// This file is generated by Values_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Values_h
#define node_inspector_protocol_Values_h

//#include "Allocator.h"
//#include "Forward.h"

#include <memory>
#include <unordered_map>
#include <utility>
#include <vector>

#include "src/node/inspector/protocol/Forward.h"

namespace node {
namespace inspector {
namespace protocol {

class ListValue;
class DictionaryValue;
class Value;

#define PROTOCOL_DISALLOW_COPY(ClassName) \
 private:                                 \
  ClassName(const ClassName&) = delete;   \
  ClassName& operator=(const ClassName&) = delete

class  Value : public Serializable {
    PROTOCOL_DISALLOW_COPY(Value);
public:
    virtual ~Value() override { }

    static std::unique_ptr<Value> null()
    {
        return std::unique_ptr<Value>(new Value());
    }

    static std::unique_ptr<Value> parseBinary(const uint8_t* data, size_t size);

    enum ValueType {
        TypeNull = 0,
        TypeBoolean,
        TypeInteger,
        TypeDouble,
        TypeString,
        TypeBinary,
        TypeObject,
        TypeArray,
        TypeImported
    };

    ValueType type() const { return m_type; }

    bool isNull() const { return m_type == TypeNull; }

    virtual bool asBoolean(bool* output) const;
    virtual bool asDouble(double* output) const;
    virtual bool asInteger(int* output) const;
    virtual bool asString(String* output) const;
    virtual bool asBinary(Binary* output) const;

    virtual void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    virtual std::unique_ptr<Value> clone() const;

protected:
    Value() : m_type(TypeNull) { }
    explicit Value(ValueType type) : m_type(type) { }

private:
    friend class DictionaryValue;
    friend class ListValue;

    ValueType m_type;
};

class  FundamentalValue : public Value {
public:
    static std::unique_ptr<FundamentalValue> create(bool value)
    {
        return std::unique_ptr<FundamentalValue>(new FundamentalValue(value));
    }

    static std::unique_ptr<FundamentalValue> create(int value)
    {
        return std::unique_ptr<FundamentalValue>(new FundamentalValue(value));
    }

    static std::unique_ptr<FundamentalValue> create(double value)
    {
        return std::unique_ptr<FundamentalValue>(new FundamentalValue(value));
    }

    bool asBoolean(bool* output) const override;
    bool asDouble(double* output) const override;
    bool asInteger(int* output) const override;
    void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    std::unique_ptr<Value> clone() const override;

private:
    explicit FundamentalValue(bool value) : Value(TypeBoolean), m_boolValue(value) { }
    explicit FundamentalValue(int value) : Value(TypeInteger), m_integerValue(value) { }
    explicit FundamentalValue(double value) : Value(TypeDouble), m_doubleValue(value) { }

    union {
        bool m_boolValue;
        double m_doubleValue;
        int m_integerValue;
    };
};

class  StringValue : public Value {
public:
    static std::unique_ptr<StringValue> create(const String& value)
    {
        return std::unique_ptr<StringValue>(new StringValue(value));
    }

    static std::unique_ptr<StringValue> create(const char* value)
    {
        return std::unique_ptr<StringValue>(new StringValue(value));
    }

    bool asString(String* output) const override;
    void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    std::unique_ptr<Value> clone() const override;

private:
    explicit StringValue(const String& value) : Value(TypeString), m_stringValue(value) { }
    explicit StringValue(const char* value) : Value(TypeString), m_stringValue(value) { }

    String m_stringValue;
};

class  BinaryValue : public Value {
public:
    static std::unique_ptr<BinaryValue> create(const Binary& value)
    {
        return std::unique_ptr<BinaryValue>(new BinaryValue(value));
    }

    bool asBinary(Binary* output) const override;
    void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    std::unique_ptr<Value> clone() const override;

private:
    explicit BinaryValue(const Binary& value) : Value(TypeBinary), m_binaryValue(value) { }

    Binary m_binaryValue;
};

class  DictionaryValue : public Value {
public:
    using Entry = std::pair<String, Value*>;
    static std::unique_ptr<DictionaryValue> create()
    {
        return std::unique_ptr<DictionaryValue>(new DictionaryValue());
    }

    static DictionaryValue* cast(Value* value)
    {
        if (!value || value->type() != TypeObject)
            return nullptr;
        return static_cast<DictionaryValue*>(value);
    }

    static std::unique_ptr<DictionaryValue> cast(std::unique_ptr<Value> value)
    {
        DictionaryValue* dictionaryValue = cast(value.get());
        if (dictionaryValue) value.release();
        return std::unique_ptr<DictionaryValue>(dictionaryValue);
    }

    void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    std::unique_ptr<Value> clone() const override;

    size_t size() const { return m_data.size(); }

    void setBoolean(const String& name, bool);
    void setInteger(const String& name, int);
    void setDouble(const String& name, double);
    void setString(const String& name, const String&);
    void setValue(const String& name, std::unique_ptr<Value>);
    void setObject(const String& name, std::unique_ptr<DictionaryValue>);
    void setArray(const String& name, std::unique_ptr<ListValue>);

    bool getBoolean(const String& name, bool* output) const;
    bool getInteger(const String& name, int* output) const;
    bool getDouble(const String& name, double* output) const;
    bool getString(const String& name, String* output) const;

    DictionaryValue* getObject(const String& name) const;
    ListValue* getArray(const String& name) const;
    Value* get(const String& name) const;
    Entry at(size_t index) const;

    bool booleanProperty(const String& name, bool defaultValue) const;
    int integerProperty(const String& name, int defaultValue) const;
    double doubleProperty(const String& name, double defaultValue) const;
    void remove(const String& name);

    ~DictionaryValue() override;

private:
    DictionaryValue();
    template<typename T>
    void set(const String& key, std::unique_ptr<T>& value)
    {
        DCHECK(value);
        bool isNew = m_data.find(key) == m_data.end();
        m_data[key] = std::move(value);
        if (isNew)
            m_order.push_back(key);
    }

    using Dictionary = std::unordered_map<String, std::unique_ptr<Value>>;
    Dictionary m_data;
    std::vector<String> m_order;
};

class  ListValue : public Value {
public:
    static std::unique_ptr<ListValue> create()
    {
        return std::unique_ptr<ListValue>(new ListValue());
    }

    static ListValue* cast(Value* value)
    {
        if (!value || value->type() != TypeArray)
            return nullptr;
        return static_cast<ListValue*>(value);
    }

    static std::unique_ptr<ListValue> cast(std::unique_ptr<Value> value)
    {
        ListValue* listValue = cast(value.get());
        if (listValue) value.release();
        return std::unique_ptr<ListValue>(listValue);
    }

    ~ListValue() override;

    void AppendSerialized(std::vector<uint8_t>* bytes) const override;
    std::unique_ptr<Value> clone() const override;

    void pushValue(std::unique_ptr<Value>);

    Value* at(size_t index);
    size_t size() const { return m_data.size(); }
    void reserve(size_t capacity) { m_data.reserve(capacity); }

private:
    ListValue();
    std::vector<std::unique_ptr<Value>> m_data;
};

} // namespace node
} // namespace inspector
} // namespace protocol

#endif // node_inspector_protocol_Values_h


// This file is generated by Object_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Object_h
#define node_inspector_protocol_Object_h

//#include "ErrorSupport.h"
//#include "Forward.h"
//#include "Values.h"

#include "crdtp/serializable.h"

namespace node {
namespace inspector {
namespace protocol {

class  Object : public crdtp::Serializable {
public:
    static std::unique_ptr<Object> fromValue(protocol::Value*, ErrorSupport*);
    explicit Object(std::unique_ptr<protocol::DictionaryValue>);
    ~Object();

    // Implements Serializable.
    void AppendSerialized(std::vector<uint8_t>* out) const override;

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    std::unique_ptr<Object> clone() const;

private:
    Object() = default;
    friend struct crdtp::ProtocolTypeTraits<std::unique_ptr<Object>, void>;

    std::unique_ptr<protocol::DictionaryValue> m_object;
};

} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Object_h)


// This file is generated by ValueConversions_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_ValueConversions_h
#define node_inspector_protocol_ValueConversions_h

//#include "ErrorSupport.h"
//#include "Forward.h"
//#include "Values.h"

namespace node {
namespace inspector {
namespace protocol {

template<typename T>
struct ValueConversions {
    static std::unique_ptr<T> fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        return T::fromValue(value, errors);
    }

    static std::unique_ptr<protocol::Value> toValue(T* value)
    {
        return value->toValue();
    }

    static std::unique_ptr<protocol::Value> toValue(const std::unique_ptr<T>& value)
    {
        return value->toValue();
    }
};

template<>
struct ValueConversions<bool> {
    static bool fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        bool result = false;
        bool success = value ? value->asBoolean(&result) : false;
        if (!success)
            errors->AddError("boolean value expected");
        return result;
    }

    static std::unique_ptr<protocol::Value> toValue(bool value)
    {
        return FundamentalValue::create(value);
    }
};

template<>
struct ValueConversions<int> {
    static int fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        int result = 0;
        bool success = value ? value->asInteger(&result) : false;
        if (!success)
            errors->AddError("integer value expected");
        return result;
    }

    static std::unique_ptr<protocol::Value> toValue(int value)
    {
        return FundamentalValue::create(value);
    }
};

template<>
struct ValueConversions<double> {
    static double fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        double result = 0;
        bool success = value ? value->asDouble(&result) : false;
        if (!success)
            errors->AddError("double value expected");
        return result;
    }

    static std::unique_ptr<protocol::Value> toValue(double value)
    {
        return FundamentalValue::create(value);
    }
};

template<>
struct ValueConversions<String> {
    static String fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        String result;
        bool success = value ? value->asString(&result) : false;
        if (!success)
            errors->AddError("string value expected");
        return result;
    }

    static std::unique_ptr<protocol::Value> toValue(const String& value)
    {
        return StringValue::create(value);
    }
};

template<>
struct ValueConversions<Binary> {
    static Binary fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        if (!value ||
            (value->type() != Value::TypeBinary && value->type() != Value::TypeString)) {
            errors->AddError("Either string base64 or binary value expected");
            return Binary();
        }
        Binary binary;
        if (value->asBinary(&binary))
            return binary;
        String result;
        value->asString(&result);
        bool success;
        Binary out = Binary::fromBase64(result, &success);
        if (!success)
          errors->AddError("base64 decoding error");
        return out;
    }

    static std::unique_ptr<protocol::Value> toValue(const Binary& value)
    {
        return BinaryValue::create(value);
    }
};

template<typename T>
struct ValueConversions<std::vector<std::unique_ptr<T>>> {
    static std::unique_ptr<std::vector<std::unique_ptr<T>>> fromValue(protocol::Value* value, ErrorSupport* errors) {
        protocol::ListValue* array = ListValue::cast(value);
        if (!array) {
            errors->AddError("array expected");
            return nullptr;
        }
        errors->Push();
        std::unique_ptr<std::vector<std::unique_ptr<T>>> result(
            new std::vector<std::unique_ptr<T>>());
        result->reserve(array->size());
        for (size_t i = 0; i < array->size(); ++i) {
            errors->SetIndex(i);
            auto item = ValueConversions<T>::fromValue(array->at(i), errors);
            result->emplace_back(std::move(item));
        }
        errors->Pop();
        if (!errors->Errors().empty())
            return nullptr;
        return result;
    }

    static std::unique_ptr<protocol::ListValue> toValue(std::vector<std::unique_ptr<T>>* v)
    {
        std::unique_ptr<protocol::ListValue> result = ListValue::create();
        result->reserve(v->size());
        for (auto& item : *v)
            result->pushValue(ValueConversions<T>::toValue(item.get()));
        return result;
    }

};

template<typename T>
struct ValueConversions<std::vector<T>> {
    static std::unique_ptr<std::vector<T>> fromValue(protocol::Value* value, ErrorSupport* errors) {
        protocol::ListValue* array = ListValue::cast(value);
        if (!array) {
            errors->AddError("array expected");
            return nullptr;
        }
        errors->Push();
        std::unique_ptr<std::vector<T>> result(new std::vector<T>());
        result->reserve(array->size());
        for (size_t i = 0; i < array->size(); ++i) {
            errors->SetIndex(i);
            auto item = ValueConversions<T>::fromValue(array->at(i), errors);
            result->emplace_back(std::move(item));
        }
        errors->Pop();
        if (!errors->Errors().empty())
            return nullptr;
        return result;
    }

    static std::unique_ptr<protocol::ListValue> toValue(std::vector<T>* v)
    {
        std::unique_ptr<protocol::ListValue> result = ListValue::create();
        result->reserve(v->size());
        for (auto& item : *v)
            result->pushValue(ValueConversions<T>::toValue(item));
        return result;
    }
};

template<>
struct ValueConversions<Value> {
    static std::unique_ptr<Value> fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        bool success = !!value;
        if (!success) {
            errors->AddError("value expected");
            return nullptr;
        }
        return value->clone();
    }

    static std::unique_ptr<protocol::Value> toValue(Value* value)
    {
        return value->clone();
    }

    static std::unique_ptr<protocol::Value> toValue(const std::unique_ptr<Value>& value)
    {
        return value->clone();
    }
};

template<>
struct ValueConversions<DictionaryValue> {
    static std::unique_ptr<DictionaryValue> fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        bool success = value && value->type() == protocol::Value::TypeObject;
        if (!success)
            errors->AddError("object expected");
        return DictionaryValue::cast(value->clone());
    }

    static std::unique_ptr<protocol::Value> toValue(DictionaryValue* value)
    {
        return value->clone();
    }

    static std::unique_ptr<protocol::Value> toValue(const std::unique_ptr<DictionaryValue>& value)
    {
        return value->clone();
    }
};

template<>
struct ValueConversions<ListValue> {
    static std::unique_ptr<ListValue> fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        bool success = value && value->type() == protocol::Value::TypeArray;
        if (!success)
            errors->AddError("list expected");
        return ListValue::cast(value->clone());
    }

    static std::unique_ptr<protocol::Value> toValue(ListValue* value)
    {
        return value->clone();
    }

    static std::unique_ptr<protocol::Value> toValue(const std::unique_ptr<ListValue>& value)
    {
        return value->clone();
    }
};

template<typename T> struct ValueTypeConverter {
  static std::unique_ptr<T> FromValue(const protocol::Value& value) {
    std::vector<uint8_t> bytes;
    value.AppendSerialized(&bytes);
    return T::FromBinary(bytes.data(), bytes.size());
  }

  static std::unique_ptr<protocol::DictionaryValue> ToValue(const T& obj) {
    std::vector<uint8_t> bytes;
    obj.AppendSerialized(&bytes);
    auto result = Value::parseBinary(bytes.data(), bytes.size());
    return DictionaryValue::cast(std::move(result));
  }
};

} // namespace node
} // namespace inspector
} // namespace protocol

namespace crdtp {

template<typename T>
struct ProtocolTypeTraits<T,
     typename std::enable_if<std::is_base_of<node::inspector::protocol::Value, T>::value>::type> {
  static void Serialize(const node::inspector::protocol::Value& value, std::vector<uint8_t>* bytes) {
    value.AppendSerialized(bytes);
  }
};

template <>
struct ProtocolTypeTraits<std::unique_ptr<node::inspector::protocol::Value>> {
  static bool Deserialize(DeserializerState* state, std::unique_ptr<node::inspector::protocol::Value>* value);
  static void Serialize(const std::unique_ptr<node::inspector::protocol::Value>& value, std::vector<uint8_t>* bytes);
};

template <>
struct ProtocolTypeTraits<std::unique_ptr<node::inspector::protocol::DictionaryValue>> {
  static bool Deserialize(DeserializerState* state, std::unique_ptr<node::inspector::protocol::DictionaryValue>* value);
  static void Serialize(const std::unique_ptr<node::inspector::protocol::DictionaryValue>& value, std::vector<uint8_t>* bytes);
};

// TODO(caseq): get rid of it, it's just a DictionaryValue really.
template <>
struct ProtocolTypeTraits<std::unique_ptr<node::inspector::protocol::Object>> {
  static bool Deserialize(DeserializerState* state, std::unique_ptr<node::inspector::protocol::Object>* value);
  static void Serialize(const std::unique_ptr<node::inspector::protocol::Object>& value, std::vector<uint8_t>* bytes);
};

template<>
struct ProtocolTypeTraits<node::inspector::protocol::Object> {
  static void Serialize(const node::inspector::protocol::Object& value, std::vector<uint8_t>* bytes) {
    value.AppendSerialized(bytes);
  }
};

}  // namespace crdtp

#endif // !defined(node_inspector_protocol_ValueConversions_h)
