use glib::Boxed;

#[derive(Clone, Copy, Debug, Boxed)]
#[boxed_type(name = "DragBuffer")]
pub struct DragBuffer([f64; 10]);

impl Default for DragBuffer {
    fn default() -> Self {
        Self([0.0; 10])
    }
}

impl AsRef<[f64; 10]> for DragBuffer {
    fn as_ref(&self) -> &[f64; 10] {
        &self.0
    }
}

impl AsMut<[f64; 10]> for DragBuffer {
    fn as_mut(&mut self) -> &mut [f64; 10] {
        &mut self.0
    }
}

impl DragBuffer {
    pub fn get(&self, index: usize) -> f64 {
        self.0[index]
    }

    pub fn set(&mut self, index: usize, value: f64) {
        self.0[index] = value;
    }
}
