/* MarkdownParser.c generated by valac 0.56.18, the Vala compiler
 * generated from MarkdownParser.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;
typedef struct _TextParserPrivate TextParserPrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_MARKDOWN_PARSER (markdown_parser_get_type ())
#define MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKDOWN_PARSER, MarkdownParser))
#define MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKDOWN_PARSER, MarkdownParserClass))
#define IS_MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKDOWN_PARSER))
#define IS_MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKDOWN_PARSER))
#define MARKDOWN_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKDOWN_PARSER, MarkdownParserClass))

typedef struct _MarkdownParser MarkdownParser;
typedef struct _MarkdownParserClass MarkdownParserClass;
typedef struct _MarkdownParserPrivate MarkdownParserPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef void (*TextParserTextMatchCallback) (FormattedText* text, GMatchInfo* match_info, gpointer user_data);

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_INSERT_TEXT (insert_text_get_type ())
typedef struct _InsertText InsertText;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _TextParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextParserPrivate * priv;
};

struct _TextParserClass {
	GTypeClass parent_class;
	void (*finalize) (TextParser *self);
	gboolean (*tag_handled) (TextParser* self, FormatTag tag);
	void (*insert_tag) (TextParser* self, CanvasText* ct, FormatTag tag, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer, const gchar* extra);
	void (*remove_all_tags) (TextParser* self, CanvasText* ct, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer);
};

struct _MarkdownParser {
	TextParser parent_instance;
	MarkdownParserPrivate * priv;
};

struct _MarkdownParserClass {
	TextParserClass parent_class;
};

struct _MarkdownParserPrivate {
	DrawArea* _da;
};

struct _InsertText {
	gint start;
	gchar* text;
};

static gint MarkdownParser_private_offset;
static gpointer markdown_parser_parent_class = NULL;

VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN GType markdown_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MarkdownParser, text_parser_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gboolean text_parser_tag_handled (TextParser* self,
                                  FormatTag tag);
VALA_EXTERN void text_parser_insert_tag (TextParser* self,
                             CanvasText* ct,
                             FormatTag tag,
                             gint start_pos,
                             gint end_pos,
                             UndoTextBuffer* undo_buffer,
                             const gchar* extra);
VALA_EXTERN MarkdownParser* markdown_parser_new (DrawArea* da);
VALA_EXTERN MarkdownParser* markdown_parser_construct (GType object_type,
                                           DrawArea* da);
VALA_EXTERN TextParser* text_parser_new (const gchar* name);
VALA_EXTERN TextParser* text_parser_construct (GType object_type,
                                   const gchar* name);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN void text_parser_add_regex (TextParser* self,
                            const gchar* re,
                            TextParserTextMatchCallback func,
                            gpointer func_target);
static void markdown_parser_highlight_header (MarkdownParser* self,
                                       FormattedText* text,
                                       GMatchInfo* match);
static void _markdown_parser_highlight_header_text_parser_text_match_callback (FormattedText* text,
                                                                        GMatchInfo* match_info,
                                                                        gpointer self);
static void __lambda35_ (MarkdownParser* self,
                  FormattedText* text,
                  GMatchInfo* match);
VALA_EXTERN void text_parser_add_tag (TextParser* self,
                          FormattedText* text,
                          GMatchInfo* matches,
                          gint paren,
                          FormatTag tag,
                          const gchar* extra);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
static void ___lambda35__text_parser_text_match_callback (FormattedText* text,
                                                   GMatchInfo* match_info,
                                                   gpointer self);
static void __lambda36_ (MarkdownParser* self,
                  FormattedText* text,
                  GMatchInfo* match);
static void markdown_parser_make_grey (MarkdownParser* self,
                                FormattedText* text,
                                GMatchInfo* match,
                                gint paren);
static void ___lambda36__text_parser_text_match_callback (FormattedText* text,
                                                   GMatchInfo* match_info,
                                                   gpointer self);
static void markdown_parser_highlight_bold (MarkdownParser* self,
                                     FormattedText* text,
                                     GMatchInfo* match);
static void _markdown_parser_highlight_bold_text_parser_text_match_callback (FormattedText* text,
                                                                      GMatchInfo* match_info,
                                                                      gpointer self);
static void markdown_parser_highlight_italics (MarkdownParser* self,
                                        FormattedText* text,
                                        GMatchInfo* match);
static void _markdown_parser_highlight_italics_text_parser_text_match_callback (FormattedText* text,
                                                                         GMatchInfo* match_info,
                                                                         gpointer self);
static void markdown_parser_highlight_strikethrough (MarkdownParser* self,
                                              FormattedText* text,
                                              GMatchInfo* match);
static void _markdown_parser_highlight_strikethrough_text_parser_text_match_callback (FormattedText* text,
                                                                               GMatchInfo* match_info,
                                                                               gpointer self);
static void markdown_parser_highlight_url1 (MarkdownParser* self,
                                     FormattedText* text,
                                     GMatchInfo* match);
static void _markdown_parser_highlight_url1_text_parser_text_match_callback (FormattedText* text,
                                                                      GMatchInfo* match_info,
                                                                      gpointer self);
static void markdown_parser_highlight_url2 (MarkdownParser* self,
                                     FormattedText* text,
                                     GMatchInfo* match);
static void _markdown_parser_highlight_url2_text_parser_text_match_callback (FormattedText* text,
                                                                      GMatchInfo* match_info,
                                                                      gpointer self);
static void markdown_parser_highlight_url3 (MarkdownParser* self,
                                     FormattedText* text,
                                     GMatchInfo* match);
static void _markdown_parser_highlight_url3_text_parser_text_match_callback (FormattedText* text,
                                                                      GMatchInfo* match_info,
                                                                      gpointer self);
static void markdown_parser_highlight_subscript (MarkdownParser* self,
                                          FormattedText* text,
                                          GMatchInfo* match);
static void _markdown_parser_highlight_subscript_text_parser_text_match_callback (FormattedText* text,
                                                                           GMatchInfo* match_info,
                                                                           gpointer self);
static void markdown_parser_highlight_superscript (MarkdownParser* self,
                                            FormattedText* text,
                                            GMatchInfo* match);
static void _markdown_parser_highlight_superscript_text_parser_text_match_callback (FormattedText* text,
                                                                             GMatchInfo* match_info,
                                                                             gpointer self);
VALA_EXTERN gchar* text_parser_get_text (TextParser* self,
                             GMatchInfo* matches,
                             gint paren);
static gboolean markdown_parser_real_tag_handled (TextParser* base,
                                           FormatTag tag);
static void markdown_parser_real_insert_tag (TextParser* base,
                                      CanvasText* ct,
                                      FormatTag tag,
                                      gint start_pos,
                                      gint end_pos,
                                      UndoTextBuffer* undo_buffer,
                                      const gchar* extra);
static void markdown_parser_insert_header (MarkdownParser* self,
                                    CanvasText* ct,
                                    gint start_pos,
                                    const gchar* extra,
                                    UndoTextBuffer* undo_buffer);
static void markdown_parser_insert_surround (MarkdownParser* self,
                                      CanvasText* ct,
                                      const gchar* surround,
                                      gint start_pos,
                                      gint end_pos,
                                      UndoTextBuffer* undo_buffer);
static void markdown_parser_insert_link (MarkdownParser* self,
                                  CanvasText* ct,
                                  gint start_pos,
                                  gint end_pos,
                                  const gchar* url,
                                  UndoTextBuffer* undo_buffer);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN GType insert_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InsertText* insert_text_dup (const InsertText* self);
VALA_EXTERN void insert_text_free (InsertText* self);
VALA_EXTERN void insert_text_copy (const InsertText* self,
                       InsertText* dest);
VALA_EXTERN void insert_text_destroy (InsertText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (InsertText, insert_text_destroy)
static void _insert_text_free0_ (gpointer var);
static void _vala_InsertText_free_function_content_of (gpointer data);
VALA_EXTERN void canvas_text_insert_ranges (CanvasText* self,
                                GArray* its,
                                UndoTextBuffer* undo_buffer);
VALA_EXTERN void canvas_text_replace (CanvasText* self,
                          gint start,
                          gint end,
                          const gchar* s,
                          UndoTextBuffer* undo_buffer);
static void markdown_parser_finalize (TextParser * obj);
static GType markdown_parser_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
markdown_parser_get_instance_private (MarkdownParser* self)
{
	return G_STRUCT_MEMBER_P (self, MarkdownParser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_markdown_parser_highlight_header_text_parser_text_match_callback (FormattedText* text,
                                                                   GMatchInfo* match_info,
                                                                   gpointer self)
{
	markdown_parser_highlight_header ((MarkdownParser*) self, text, match_info);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
__lambda35_ (MarkdownParser* self,
             FormattedText* text,
             GMatchInfo* match)
{
	DrawArea* _tmp0_;
	Theme* _tmp1_;
	Theme* _tmp2_;
	GdkRGBA* _tmp3_;
	GdkRGBA* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_theme (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = theme_get_color (_tmp2_, "markdown_listitem");
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_rgba_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	text_parser_add_tag ((TextParser*) self, text, match, 1, FORMAT_TAG_COLOR, _tmp6_);
	_g_free0 (_tmp6_);
	__vala_GdkRGBA_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}

static void
___lambda35__text_parser_text_match_callback (FormattedText* text,
                                              GMatchInfo* match_info,
                                              gpointer self)
{
	__lambda35_ ((MarkdownParser*) self, text, match_info);
}

static void
__lambda36_ (MarkdownParser* self,
             FormattedText* text,
             GMatchInfo* match)
{
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_CODE, NULL);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
___lambda36__text_parser_text_match_callback (FormattedText* text,
                                              GMatchInfo* match_info,
                                              gpointer self)
{
	__lambda36_ ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_bold_text_parser_text_match_callback (FormattedText* text,
                                                                 GMatchInfo* match_info,
                                                                 gpointer self)
{
	markdown_parser_highlight_bold ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_italics_text_parser_text_match_callback (FormattedText* text,
                                                                    GMatchInfo* match_info,
                                                                    gpointer self)
{
	markdown_parser_highlight_italics ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_strikethrough_text_parser_text_match_callback (FormattedText* text,
                                                                          GMatchInfo* match_info,
                                                                          gpointer self)
{
	markdown_parser_highlight_strikethrough ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_url1_text_parser_text_match_callback (FormattedText* text,
                                                                 GMatchInfo* match_info,
                                                                 gpointer self)
{
	markdown_parser_highlight_url1 ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_url2_text_parser_text_match_callback (FormattedText* text,
                                                                 GMatchInfo* match_info,
                                                                 gpointer self)
{
	markdown_parser_highlight_url2 ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_url3_text_parser_text_match_callback (FormattedText* text,
                                                                 GMatchInfo* match_info,
                                                                 gpointer self)
{
	markdown_parser_highlight_url3 ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_subscript_text_parser_text_match_callback (FormattedText* text,
                                                                      GMatchInfo* match_info,
                                                                      gpointer self)
{
	markdown_parser_highlight_subscript ((MarkdownParser*) self, text, match_info);
}

static void
_markdown_parser_highlight_superscript_text_parser_text_match_callback (FormattedText* text,
                                                                        GMatchInfo* match_info,
                                                                        gpointer self)
{
	markdown_parser_highlight_superscript ((MarkdownParser*) self, text, match_info);
}

MarkdownParser*
markdown_parser_construct (GType object_type,
                           DrawArea* da)
{
	MarkdownParser* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (MarkdownParser*) text_parser_construct (object_type, "Markdown");
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	text_parser_add_regex ((TextParser*) self, "^(#{1,6})[^#].*$", _markdown_parser_highlight_header_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "^\\s*(\\*|\\+|\\-|[0-9]+\\.)\\s", ___lambda35__text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(`)([^`]+)(`)", ___lambda36__text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(\\*\\*)([^* \\t].*?)(?<!\\\\|\\*| |\\t)(\\*\\*)", _markdown_parser_highlight_bold_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(__)([^_ \\t].*?(?<!\\\\|_| |\\t))(__)", _markdown_parser_highlight_bold_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(?<!_)(_)([^_ \t].*?(?<!\\\\|_| |\\t))(_)(?!_)", _markdown_parser_highlight_italics_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(?<!\\*)(\\*)([^* \t].*?(?<!\\\\|\\*| |\\t))(\\*)(?!\\*)", _markdown_parser_highlight_italics_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(~~)([^~ \t].*?(?<!\\\\|~| |\\t))(~~)", _markdown_parser_highlight_strikethrough_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(\\[)(.+?)(\\]\\s*\\((\\S+).*\\))", _markdown_parser_highlight_url1_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(<)((mailto:)?[a-z0-9.-]+@[-a-z0-9]+(\\.[-a-z0-9]+)*\\.[a-z]+)(>)", _markdown_parser_highlight_url2_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(<)((https?|ftp):[^'\">\\s]+)(>)", _markdown_parser_highlight_url3_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(<sub>)(.*?)(</sub>)", _markdown_parser_highlight_subscript_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "(<sup>)(.*?)(</sup>)", _markdown_parser_highlight_superscript_text_parser_text_match_callback, self);
	return self;
}

MarkdownParser*
markdown_parser_new (DrawArea* da)
{
	return markdown_parser_construct (TYPE_MARKDOWN_PARSER, da);
}

static void
markdown_parser_make_grey (MarkdownParser* self,
                           FormattedText* text,
                           GMatchInfo* match,
                           gint paren)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	text_parser_add_tag ((TextParser*) self, text, match, paren, FORMAT_TAG_SYNTAX, NULL);
}

static void
markdown_parser_highlight_header (MarkdownParser* self,
                                  FormattedText* text,
                                  GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 1);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	text_parser_add_tag ((TextParser*) self, text, match, 0, FORMAT_TAG_HEADER, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp1_);
}

static void
markdown_parser_highlight_bold (MarkdownParser* self,
                                FormattedText* text,
                                GMatchInfo* match)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_BOLD, NULL);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
markdown_parser_highlight_italics (MarkdownParser* self,
                                   FormattedText* text,
                                   GMatchInfo* match)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_ITALICS, NULL);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
markdown_parser_highlight_strikethrough (MarkdownParser* self,
                                         FormattedText* text,
                                         GMatchInfo* match)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_STRIKETHRU, NULL);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
markdown_parser_highlight_url1 (MarkdownParser* self,
                                FormattedText* text,
                                GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 4);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_URL, _tmp1_);
	_g_free0 (_tmp1_);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
markdown_parser_highlight_url2 (MarkdownParser* self,
                                FormattedText* text,
                                GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 2);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_URL, _tmp1_);
	_g_free0 (_tmp1_);
	markdown_parser_make_grey (self, text, match, 5);
}

static void
markdown_parser_highlight_url3 (MarkdownParser* self,
                                FormattedText* text,
                                GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 2);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_URL, _tmp1_);
	_g_free0 (_tmp1_);
	markdown_parser_make_grey (self, text, match, 4);
}

static void
markdown_parser_highlight_subscript (MarkdownParser* self,
                                     FormattedText* text,
                                     GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 2);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_SUB, _tmp1_);
	_g_free0 (_tmp1_);
	markdown_parser_make_grey (self, text, match, 3);
}

static void
markdown_parser_highlight_superscript (MarkdownParser* self,
                                       FormattedText* text,
                                       GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	markdown_parser_make_grey (self, text, match, 1);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 2);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 2, FORMAT_TAG_SUPER, _tmp1_);
	_g_free0 (_tmp1_);
	markdown_parser_make_grey (self, text, match, 3);
}

static gboolean
markdown_parser_real_tag_handled (TextParser* base,
                                  FormatTag tag)
{
	MarkdownParser * self;
	gboolean result;
	self = (MarkdownParser*) base;
	switch (tag) {
		case FORMAT_TAG_HEADER:
		case FORMAT_TAG_CODE:
		case FORMAT_TAG_BOLD:
		case FORMAT_TAG_ITALICS:
		case FORMAT_TAG_URL:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static void
markdown_parser_real_insert_tag (TextParser* base,
                                 CanvasText* ct,
                                 FormatTag tag,
                                 gint start_pos,
                                 gint end_pos,
                                 UndoTextBuffer* undo_buffer,
                                 const gchar* extra)
{
	MarkdownParser * self;
	self = (MarkdownParser*) base;
	g_return_if_fail (ct != NULL);
	g_return_if_fail (undo_buffer != NULL);
	switch (tag) {
		case FORMAT_TAG_HEADER:
		{
			markdown_parser_insert_header (self, ct, start_pos, extra, undo_buffer);
			break;
		}
		case FORMAT_TAG_CODE:
		{
			markdown_parser_insert_surround (self, ct, "`", start_pos, end_pos, undo_buffer);
			break;
		}
		case FORMAT_TAG_BOLD:
		{
			markdown_parser_insert_surround (self, ct, "**", start_pos, end_pos, undo_buffer);
			break;
		}
		case FORMAT_TAG_ITALICS:
		{
			markdown_parser_insert_surround (self, ct, "_", start_pos, end_pos, undo_buffer);
			break;
		}
		case FORMAT_TAG_URL:
		{
			markdown_parser_insert_link (self, ct, start_pos, end_pos, extra, undo_buffer);
			break;
		}
		default:
		break;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_insert_text_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (insert_text_free (var), NULL));
}

static void
_vala_InsertText_free_function_content_of (gpointer data)
{
	InsertText* self;
	self = *((InsertText**) data);
	_insert_text_free0_ (self);
}

static gpointer
_insert_text_dup0 (gpointer self)
{
	return self ? insert_text_dup (self) : NULL;
}

static void
markdown_parser_insert_header (MarkdownParser* self,
                               CanvasText* ct,
                               gint start_pos,
                               const gchar* extra,
                               UndoTextBuffer* undo_buffer)
{
	gint nl = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint num = 0;
	gchar* hashes = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	g_return_if_fail (extra != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp3_, (glong) 0, (glong) start_pos);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_last_index_of (_tmp5_, "\n", 0);
	_g_free0 (_tmp5_);
	nl = _tmp6_;
	num = atoi (extra);
	_tmp7_ = g_strdup ("");
	hashes = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < num)) {
					break;
				}
				_tmp10_ = hashes;
				_tmp11_ = g_strconcat (_tmp10_, "#", NULL);
				_g_free0 (hashes);
				hashes = _tmp11_;
			}
		}
	}
	if (nl == -1) {
		GArray* inserts = NULL;
		GArray* _tmp12_;
		GArray* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		InsertText _tmp16_ = {0};
		InsertText _tmp17_;
		InsertText* _tmp18_;
		GArray* _tmp19_;
		_tmp12_ = g_array_new (TRUE, TRUE, sizeof (InsertText*));
		g_array_set_clear_func (_tmp12_, (GDestroyNotify) _vala_InsertText_free_function_content_of);
		inserts = _tmp12_;
		_tmp13_ = inserts;
		_tmp14_ = hashes;
		_tmp15_ = g_strdup_printf ("%s ", _tmp14_);
		_tmp16_.start = 0;
		_g_free0 (_tmp16_.text);
		_tmp16_.text = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = _insert_text_dup0 (&_tmp17_);
		g_array_append_val (_tmp13_, _tmp18_);
		insert_text_destroy (&_tmp17_);
		_tmp19_ = inserts;
		canvas_text_insert_ranges (ct, _tmp19_, undo_buffer);
		_g_array_unref0 (inserts);
	} else {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = hashes;
		_tmp21_ = g_strdup_printf ("\n%s ", _tmp20_);
		_tmp22_ = _tmp21_;
		canvas_text_replace (ct, nl, nl + g_utf8_strlen ("\n", (gssize) -1), _tmp22_, undo_buffer);
		_g_free0 (_tmp22_);
	}
	_g_free0 (hashes);
}

static void
markdown_parser_insert_surround (MarkdownParser* self,
                                 CanvasText* ct,
                                 const gchar* surround,
                                 gint start_pos,
                                 gint end_pos,
                                 UndoTextBuffer* undo_buffer)
{
	GArray* inserts = NULL;
	GArray* _tmp0_;
	gchar* _tmp1_;
	InsertText _tmp2_ = {0};
	InsertText _tmp3_;
	InsertText* _tmp4_;
	gchar* _tmp5_;
	InsertText _tmp6_ = {0};
	InsertText _tmp7_;
	InsertText* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	g_return_if_fail (surround != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (InsertText*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_InsertText_free_function_content_of);
	inserts = _tmp0_;
	_tmp1_ = g_strdup (surround);
	_tmp2_.start = start_pos;
	_g_free0 (_tmp2_.text);
	_tmp2_.text = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _insert_text_dup0 (&_tmp3_);
	g_array_append_val (inserts, _tmp4_);
	insert_text_destroy (&_tmp3_);
	_tmp5_ = g_strdup (surround);
	_tmp6_.start = end_pos;
	_g_free0 (_tmp6_.text);
	_tmp6_.text = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = _insert_text_dup0 (&_tmp7_);
	g_array_append_val (inserts, _tmp8_);
	insert_text_destroy (&_tmp7_);
	canvas_text_insert_ranges (ct, inserts, undo_buffer);
	_g_array_unref0 (inserts);
}

static void
markdown_parser_insert_link (MarkdownParser* self,
                             CanvasText* ct,
                             gint start_pos,
                             gint end_pos,
                             const gchar* url,
                             UndoTextBuffer* undo_buffer)
{
	gchar* seltext = NULL;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GArray* inserts = NULL;
	GArray* _tmp5_;
	const gchar* _tmp6_;
	GArray* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp3_, (glong) start_pos, (glong) end_pos);
	seltext = _tmp4_;
	_tmp5_ = g_array_new (TRUE, TRUE, sizeof (InsertText*));
	g_array_set_clear_func (_tmp5_, (GDestroyNotify) _vala_InsertText_free_function_content_of);
	inserts = _tmp5_;
	_tmp6_ = seltext;
	if (g_strcmp0 (_tmp6_, url) == 0) {
		GArray* _tmp7_;
		gchar* _tmp8_;
		InsertText _tmp9_ = {0};
		InsertText _tmp10_;
		InsertText* _tmp11_;
		GArray* _tmp12_;
		gchar* _tmp13_;
		InsertText _tmp14_ = {0};
		InsertText _tmp15_;
		InsertText* _tmp16_;
		_tmp7_ = inserts;
		_tmp8_ = g_strdup ("<");
		_tmp9_.start = start_pos;
		_g_free0 (_tmp9_.text);
		_tmp9_.text = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = _insert_text_dup0 (&_tmp10_);
		g_array_append_val (_tmp7_, _tmp11_);
		insert_text_destroy (&_tmp10_);
		_tmp12_ = inserts;
		_tmp13_ = g_strdup (">");
		_tmp14_.start = end_pos;
		_g_free0 (_tmp14_.text);
		_tmp14_.text = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = _insert_text_dup0 (&_tmp15_);
		g_array_append_val (_tmp12_, _tmp16_);
		insert_text_destroy (&_tmp15_);
	} else {
		GArray* _tmp17_;
		gchar* _tmp18_;
		InsertText _tmp19_ = {0};
		InsertText _tmp20_;
		InsertText* _tmp21_;
		GArray* _tmp22_;
		gchar* _tmp23_;
		InsertText _tmp24_ = {0};
		InsertText _tmp25_;
		InsertText* _tmp26_;
		_tmp17_ = inserts;
		_tmp18_ = g_strdup ("[");
		_tmp19_.start = start_pos;
		_g_free0 (_tmp19_.text);
		_tmp19_.text = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = _insert_text_dup0 (&_tmp20_);
		g_array_append_val (_tmp17_, _tmp21_);
		insert_text_destroy (&_tmp20_);
		_tmp22_ = inserts;
		_tmp23_ = g_strdup_printf ("](%s)", url);
		_tmp24_.start = end_pos;
		_g_free0 (_tmp24_.text);
		_tmp24_.text = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = _insert_text_dup0 (&_tmp25_);
		g_array_append_val (_tmp22_, _tmp26_);
		insert_text_destroy (&_tmp25_);
	}
	_tmp27_ = inserts;
	canvas_text_insert_ranges (ct, _tmp27_, undo_buffer);
	_g_array_unref0 (inserts);
	_g_free0 (seltext);
}

static void
markdown_parser_class_init (MarkdownParserClass * klass,
                            gpointer klass_data)
{
	markdown_parser_parent_class = g_type_class_peek_parent (klass);
	((TextParserClass *) klass)->finalize = markdown_parser_finalize;
	g_type_class_adjust_private_offset (klass, &MarkdownParser_private_offset);
	((TextParserClass *) klass)->tag_handled = (gboolean (*) (TextParser*, FormatTag)) markdown_parser_real_tag_handled;
	((TextParserClass *) klass)->insert_tag = (void (*) (TextParser*, CanvasText*, FormatTag, gint, gint, UndoTextBuffer*, const gchar*)) markdown_parser_real_insert_tag;
}

static void
markdown_parser_instance_init (MarkdownParser * self,
                               gpointer klass)
{
	self->priv = markdown_parser_get_instance_private (self);
}

static void
markdown_parser_finalize (TextParser * obj)
{
	MarkdownParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MARKDOWN_PARSER, MarkdownParser);
	_g_object_unref0 (self->priv->_da);
	TEXT_PARSER_CLASS (markdown_parser_parent_class)->finalize (obj);
}

static GType
markdown_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MarkdownParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) markdown_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MarkdownParser), 0, (GInstanceInitFunc) markdown_parser_instance_init, NULL };
	GType markdown_parser_type_id;
	markdown_parser_type_id = g_type_register_static (TYPE_TEXT_PARSER, "MarkdownParser", &g_define_type_info, 0);
	MarkdownParser_private_offset = g_type_add_instance_private (markdown_parser_type_id, sizeof (MarkdownParserPrivate));
	return markdown_parser_type_id;
}

GType
markdown_parser_get_type (void)
{
	static volatile gsize markdown_parser_type_id__once = 0;
	if (g_once_init_enter (&markdown_parser_type_id__once)) {
		GType markdown_parser_type_id;
		markdown_parser_type_id = markdown_parser_get_type_once ();
		g_once_init_leave (&markdown_parser_type_id__once, markdown_parser_type_id);
	}
	return markdown_parser_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

