/* SummaryNode.c generated by valac 0.56.18, the Vala compiler
 * generated from SummaryNode.vala, do not modify */

/*
* Copyright (c) 2018-2021 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
typedef struct _NodePrivate NodePrivate;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;

#define TYPE_SUMMARY_NODE (summary_node_get_type ())
#define SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUMMARY_NODE, SummaryNode))
#define SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUMMARY_NODE, SummaryNodeClass))
#define IS_SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUMMARY_NODE))
#define IS_SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUMMARY_NODE))
#define SUMMARY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUMMARY_NODE, SummaryNodeClass))

typedef struct _SummaryNode SummaryNode;
typedef struct _SummaryNodeClass SummaryNodeClass;
typedef struct _SummaryNodePrivate SummaryNodePrivate;
enum  {
	SUMMARY_NODE_0_PROPERTY,
	SUMMARY_NODE_ATTACHABLE_PROPERTY,
	SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY,
	SUMMARY_NODE_NUM_PROPERTIES
};
static GParamSpec* summary_node_properties[SUMMARY_NODE_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_NODE_BOUNDS (node_bounds_get_type ())
#define NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BOUNDS, NodeBounds))
#define NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_BOUNDS, NodeBoundsClass))
#define IS_NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BOUNDS))
#define IS_NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_BOUNDS))
#define NODE_BOUNDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_BOUNDS, NodeBoundsClass))

typedef struct _NodeBounds NodeBounds;
typedef struct _NodeBoundsClass NodeBoundsClass;
#define _node_bounds_unref0(var) ((var == NULL) ? NULL : (var = (node_bounds_unref (var), NULL)))

#define TYPE_NODE_BORDER (node_border_get_type ())
#define NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BORDER, NodeBorder))
#define IS_NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BORDER))
#define NODE_BORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NODE_BORDER, NodeBorderIface))

typedef struct _NodeBorder NodeBorder;
typedef struct _NodeBorderIface NodeBorderIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Node {
	GObject parent_instance;
	NodePrivate * priv;
	gint _id;
	gdouble _width;
	gdouble _height;
	gdouble _total_width;
	gdouble _total_height;
	gdouble _ipadx;
	gdouble _ipady;
	gdouble _task_radius;
	gdouble _alpha;
	GArray* _children;
};

struct _NodeClass {
	GObjectClass parent_class;
	void (*clear_summary_extents) (Node* self);
	void (*set_summary_extents) (Node* self);
	gboolean (*is_summary) (Node* self);
	gboolean (*is_summarized) (Node* self);
	gboolean (*first_summarized) (Node* self);
	gboolean (*last_summarized) (Node* self);
	gboolean (*is_within) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_node) (Node* self, gdouble x, gdouble y);
	void (*task_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*sticker_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*sequence_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*linked_node_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*note_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*image_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*resizer_bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	gboolean (*is_within_task) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_note) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_linked_node) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_fold) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_fold_area) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_image) (Node* self, gdouble x, gdouble y);
	gboolean (*is_within_resizer) (Node* self, gdouble x, gdouble y);
	Node* (*contains) (Node* self, gdouble x, gdouble y, Node* n);
	Callout* (*contains_callout) (Node* self, gdouble x, gdouble y);
	gboolean (*contains_node) (Node* self, Node* node);
	gint (*index) (Node* self);
	gint (*side_count) (Node* self, NodeSide side);
	Node* (*get_node) (Node* self, gint id);
	void (*load) (Node* self, DrawArea* da, xmlNode* n, gboolean isroot, Node* sibling_parent, GArray** siblings);
	void (*save) (Node* self, xmlNode* parent);
	void (*resize) (Node* self, gdouble diff);
	void (*bbox) (Node* self, gdouble* x, gdouble* y, gdouble* w, gdouble* h);
	void (*detach) (Node* self, NodeSide side);
	void (*delete) (Node* self);
	void (*delete_only) (Node* self);
	void (*attach_only) (Node* self, Node* prev_parent, gint prev_index);
	void (*attach) (Node* self, Node* parent, gint index, Theme* theme, gboolean set_side);
	void (*attach_init) (Node* self, Node* parent, gint index);
	void (*attach_common) (Node* self, gint index, Theme* theme);
	Node* (*first_child) (Node* self, NodeSide* side);
	Node* (*last_child) (Node* self, NodeSide* side);
	Node* (*next_child) (Node* self, Node* n);
	Node* (*prev_child) (Node* self, Node* n);
	void (*link_point) (Node* self, gdouble* x, gdouble* y, gboolean seq);
	void (*draw_image) (Node* self, cairo_t* ctx, Theme* theme);
	void (*draw_name) (Node* self, cairo_t* ctx, Theme* theme, gboolean exporting);
	void (*draw_leaf_task) (Node* self, cairo_t* ctx, GdkRGBA* color, GdkRGBA* background);
	void (*draw_acc_task) (Node* self, cairo_t* ctx, GdkRGBA* color, GdkRGBA* background);
	void (*draw_sticker) (Node* self, cairo_t* ctx, GdkRGBA* sel_color, GdkRGBA* bg_color);
	void (*draw_sequence_num) (Node* self, cairo_t* ctx, GdkRGBA* sel_color, GdkRGBA* bg_color, GdkRGBA* fg_color);
	void (*draw_common_note) (Node* self, cairo_t* ctx, GdkRGBA* reg_color, GdkRGBA* sel_color, GdkRGBA* bg_color);
	void (*draw_link_node) (Node* self, cairo_t* ctx, GdkRGBA* reg_color, GdkRGBA* sel_color, GdkRGBA* bg_color);
	void (*draw_common_fold) (Node* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* fg_color);
	void (*draw_attachable) (Node* self, cairo_t* ctx, Theme* theme, GdkRGBA* frost_background);
	void (*draw_link) (Node* self, cairo_t* ctx, Theme* theme);
	void (*draw_link_arrow) (Node* self, cairo_t* ctx, Theme* theme, gdouble tailx, gdouble taily, gdouble tipx, gdouble tipy);
	void (*draw_resizer) (Node* self, cairo_t* ctx, Theme* theme, gboolean exporting);
	void (*draw_callout) (Node* self, cairo_t* ctx, Theme* theme, gboolean exporting);
	void (*draw) (Node* self, cairo_t* ctx, Theme* theme, gboolean motion, gboolean exporting);
};

struct _SummaryNode {
	Node parent_instance;
	SummaryNodePrivate * priv;
};

struct _SummaryNodeClass {
	NodeClass parent_class;
};

struct _SummaryNodePrivate {
	GList* _nodes;
	gdouble* _first_xy;
	gdouble* _last_xy;
	gboolean _attachable;
	Node* _last_selected_node;
};

struct _NodeBorderIface {
	GTypeInterface parent_iface;
	gchar* (*name) (NodeBorder* self);
	gchar* (*display_name) (NodeBorder* self);
	gchar* (*icon_name) (NodeBorder* self);
	gboolean (*is_fillable) (NodeBorder* self);
	void (*draw_border) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
	void (*draw_fill) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
};

static gint SummaryNode_private_offset;
static gpointer summary_node_parent_class = NULL;

VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType summary_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SummaryNode, g_object_unref)
VALA_EXTERN gboolean node_is_summary (Node* self);
VALA_EXTERN void node_detach (Node* self,
                  NodeSide side);
VALA_EXTERN void node_delete (Node* self);
VALA_EXTERN void node_draw_link (Node* self,
                     cairo_t* ctx,
                     Theme* theme);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN SummaryNode* summary_node_new (DrawArea* da,
                               Layout* layout);
VALA_EXTERN SummaryNode* summary_node_construct (GType object_type,
                                     DrawArea* da,
                                     Layout* layout);
VALA_EXTERN Node* node_new (DrawArea* da,
                Layout* layout);
VALA_EXTERN Node* node_construct (GType object_type,
                      DrawArea* da,
                      Layout* layout);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN SummaryNode* summary_node_new_from_node (DrawArea* da,
                                         Node* node,
                                         ImageManager* im);
VALA_EXTERN SummaryNode* summary_node_construct_from_node (GType object_type,
                                               DrawArea* da,
                                               Node* node,
                                               ImageManager* im);
VALA_EXTERN Node* node_new_copy (DrawArea* da,
                     Node* n,
                     ImageManager* im);
VALA_EXTERN Node* node_construct_copy (GType object_type,
                           DrawArea* da,
                           Node* n,
                           ImageManager* im);
VALA_EXTERN SummaryNode* summary_node_new_from_xml (DrawArea* da,
                                        Layout* layout,
                                        xmlNode* node,
                                        GArray** siblings);
VALA_EXTERN SummaryNode* summary_node_construct_from_xml (GType object_type,
                                              DrawArea* da,
                                              Layout* layout,
                                              xmlNode* node,
                                              GArray** siblings);
VALA_EXTERN void node_load (Node* self,
                DrawArea* da,
                xmlNode* n,
                gboolean isroot,
                Node* sibling_parent,
                GArray** siblings);
static void summary_node_connect_node (SummaryNode* self,
                                Node* node);
static void summary_node_nodes_changed_moved (SummaryNode* self,
                                       gdouble fx,
                                       gdouble fy);
static void _summary_node_nodes_changed_moved_node_moved (Node* _sender,
                                                   gdouble diffx,
                                                   gdouble diffy,
                                                   gpointer self);
static void summary_node_nodes_changed_resized (SummaryNode* self,
                                         gdouble fx,
                                         gdouble fy);
static void _summary_node_nodes_changed_resized_node_resized (Node* _sender,
                                                       gdouble diffw,
                                                       gdouble diffh,
                                                       gpointer self);
static void summary_node_disconnect_node (SummaryNode* self,
                                   Node* node);
VALA_EXTERN gint summary_node_summarized_count (SummaryNode* self);
VALA_EXTERN Node* summary_node_first_node (SummaryNode* self);
VALA_EXTERN Node* summary_node_last_node (SummaryNode* self);
VALA_EXTERN gint summary_node_node_index (SummaryNode* self,
                              Node* node);
static gboolean summary_node_real_is_summary (Node* base);
VALA_EXTERN gboolean summary_node_is_within_summarized (SummaryNode* self,
                                            gdouble x,
                                            gdouble y);
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gboolean node_side_horizontal (NodeSide self);
VALA_EXTERN DrawArea* node_get_da (Node* self);
VALA_EXTERN gdouble draw_area_get_origin_y (DrawArea* self);
VALA_EXTERN gdouble draw_area_get_origin_x (DrawArea* self);
VALA_EXTERN void summary_node_clear_extents (SummaryNode* self);
VALA_EXTERN void summary_node_get_extents (SummaryNode* self,
                               gdouble* xy1,
                               gdouble* xy2);
VALA_EXTERN void node_bbox (Node* self,
                gdouble* x,
                gdouble* y,
                gdouble* w,
                gdouble* h);
VALA_EXTERN void summary_node_set_extents (SummaryNode* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_node_margin (Style* self);
static gint* _int_dup (gint* self);
static gdouble* _double_dup (gdouble* self);
static gint summary_node_compare_pos (gdouble pos1,
                               gdouble pos2);
VALA_EXTERN void summary_node_nodes_changed (SummaryNode* self,
                                 gdouble fx,
                                 gdouble fy,
                                 const gchar* msg);
VALA_EXTERN gint* style_get_branch_margin (Style* self);
VALA_EXTERN gdouble node_get_posx (Node* self);
VALA_EXTERN gdouble node_get_posy (Node* self);
VALA_EXTERN gdouble node_get_width (Node* self);
VALA_EXTERN gdouble node_get_height (Node* self);
VALA_EXTERN gchar* node_side_to_string (NodeSide self);
VALA_EXTERN void node_set_posx (Node* self,
                    gdouble value);
VALA_EXTERN void node_set_posy (Node* self,
                    gdouble value);
VALA_EXTERN void summary_node_attach_nodes (SummaryNode* self,
                                Node* p,
                                GArray* nodes,
                                gboolean sort,
                                Theme* theme);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN void node_parent_moved (Node* self,
                        Node* parent,
                        gdouble diffx,
                        gdouble diffy);
static void _node_parent_moved_node_moved (Node* _sender,
                                    gdouble diffx,
                                    gdouble diffy,
                                    gpointer self);
static void summary_node_sort_nodes (SummaryNode* self);
VALA_EXTERN void node_set_parent (Node* self,
                      Node* value);
static void summary_node_update_tree_bboxes (SummaryNode* self);
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN void layout_handle_update_by_insert (Layout* self,
                                     Node* parent,
                                     Node* child,
                                     gint pos);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN gboolean node_main_branch (Node* self);
VALA_EXTERN GdkRGBA* theme_next_color (Theme* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN void node_set_link_color_child (Node* self,
                                GdkRGBA * value);
VALA_EXTERN void summary_node_attach_siblings (SummaryNode* self,
                                   Node* node,
                                   Theme* theme);
static void _vala_Node_free_function_content_of (gpointer data);
VALA_EXTERN gboolean node_is_leaf (Node* self);
VALA_EXTERN gboolean node_is_summarized (Node* self);
VALA_EXTERN Node* node_previous_sibling (Node* self);
VALA_EXTERN void summary_node_attach_all (SummaryNode* self);
VALA_EXTERN void summary_node_detach_all (SummaryNode* self);
static void summary_node_real_detach (Node* base,
                               NodeSide side);
VALA_EXTERN gpointer node_bounds_ref (gpointer instance);
VALA_EXTERN void node_bounds_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_bounds (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_node_bounds (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_node_bounds (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_node_bounds (const GValue* value);
VALA_EXTERN GType node_bounds_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBounds, node_bounds_unref)
VALA_EXTERN NodeBounds* layout_bbox (Layout* self,
                         Node* parent,
                         gint side_mask,
                         const gchar* msg);
VALA_EXTERN void node_set_tree_bbox (Node* self,
                         NodeBounds* value);
VALA_EXTERN NodeBounds* node_get_tree_bbox (Node* self);
VALA_EXTERN gdouble node_bounds_get_height (NodeBounds* self);
VALA_EXTERN gdouble node_bounds_get_width (NodeBounds* self);
VALA_EXTERN void node_set_tree_size (Node* self,
                         gdouble value);
static gint __lambda48_ (Node* a,
                  Node* b);
VALA_EXTERN gint node_index (Node* self);
static gint ___lambda48__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN void summary_node_add_node (SummaryNode* self,
                            Node* node);
VALA_EXTERN void summary_node_node_moved (SummaryNode* self,
                              Node* node);
VALA_EXTERN void summary_node_remove_node (SummaryNode* self,
                               Node* node);
static void summary_node_real_delete (Node* base);
static void summary_node_draw_link_left (SummaryNode* self,
                                  cairo_t* ctx);
VALA_EXTERN void node_node_bbox (Node* self,
                     gdouble* x,
                     gdouble* y,
                     gdouble* w,
                     gdouble* h);
VALA_EXTERN GType node_border_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBorder, g_object_unref)
VALA_EXTERN NodeBorder* style_get_node_border (Style* self);
VALA_EXTERN gchar* node_border_name (NodeBorder* self);
VALA_EXTERN gdouble node_get_alpha (Node* self);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
static void summary_node_draw_link_right (SummaryNode* self,
                                   cairo_t* ctx);
VALA_EXTERN gdouble node_get_total_width (Node* self);
static void summary_node_draw_link_above (SummaryNode* self,
                                   cairo_t* ctx);
static void summary_node_draw_link_below (SummaryNode* self,
                                   cairo_t* ctx);
VALA_EXTERN gdouble node_get_total_height (Node* self);
static void summary_node_real_draw_link (Node* base,
                                  cairo_t* ctx,
                                  Theme* theme);
VALA_EXTERN gboolean summary_node_get_attachable (SummaryNode* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
VALA_EXTERN gint* style_get_link_width (Style* self);
VALA_EXTERN void summary_node_set_attachable (SummaryNode* self,
                                  gboolean value);
VALA_EXTERN Node* summary_node_get_last_selected_node (SummaryNode* self);
VALA_EXTERN void summary_node_set_last_selected_node (SummaryNode* self,
                                          Node* value);
static void summary_node_finalize (GObject * obj);
static GType summary_node_get_type_once (void);
static void _vala_summary_node_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_summary_node_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
summary_node_get_instance_private (SummaryNode* self)
{
	return G_STRUCT_MEMBER_P (self, SummaryNode_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

SummaryNode*
summary_node_construct (GType object_type,
                        DrawArea* da,
                        Layout* layout)
{
	SummaryNode * self = NULL;
	g_return_val_if_fail (da != NULL, NULL);
	self = (SummaryNode*) node_construct (object_type, da, layout);
	(self->priv->_nodes == NULL) ? NULL : (self->priv->_nodes = (_g_list_free__g_object_unref0_ (self->priv->_nodes), NULL));
	self->priv->_nodes = NULL;
	return self;
}

SummaryNode*
summary_node_new (DrawArea* da,
                  Layout* layout)
{
	return summary_node_construct (TYPE_SUMMARY_NODE, da, layout);
}

SummaryNode*
summary_node_construct_from_node (GType object_type,
                                  DrawArea* da,
                                  Node* node,
                                  ImageManager* im)
{
	SummaryNode * self = NULL;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (im != NULL, NULL);
	self = (SummaryNode*) node_construct_copy (object_type, da, node, im);
	(self->priv->_nodes == NULL) ? NULL : (self->priv->_nodes = (_g_list_free__g_object_unref0_ (self->priv->_nodes), NULL));
	self->priv->_nodes = NULL;
	return self;
}

SummaryNode*
summary_node_new_from_node (DrawArea* da,
                            Node* node,
                            ImageManager* im)
{
	return summary_node_construct_from_node (TYPE_SUMMARY_NODE, da, node, im);
}

SummaryNode*
summary_node_construct_from_xml (GType object_type,
                                 DrawArea* da,
                                 Layout* layout,
                                 xmlNode* node,
                                 GArray** siblings)
{
	SummaryNode * self = NULL;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (*siblings != NULL, NULL);
	self = (SummaryNode*) node_construct (object_type, da, layout);
	(self->priv->_nodes == NULL) ? NULL : (self->priv->_nodes = (_g_list_free__g_object_unref0_ (self->priv->_nodes), NULL));
	self->priv->_nodes = NULL;
	node_load ((Node*) self, da, node, FALSE, NULL, siblings);
	return self;
}

SummaryNode*
summary_node_new_from_xml (DrawArea* da,
                           Layout* layout,
                           xmlNode* node,
                           GArray** siblings)
{
	return summary_node_construct_from_xml (TYPE_SUMMARY_NODE, da, layout, node, siblings);
}

static void
_summary_node_nodes_changed_moved_node_moved (Node* _sender,
                                              gdouble diffx,
                                              gdouble diffy,
                                              gpointer self)
{
	summary_node_nodes_changed_moved ((SummaryNode*) self, diffx, diffy);
}

static void
_summary_node_nodes_changed_resized_node_resized (Node* _sender,
                                                  gdouble diffw,
                                                  gdouble diffh,
                                                  gpointer self)
{
	summary_node_nodes_changed_resized ((SummaryNode*) self, diffw, diffh);
}

static void
summary_node_connect_node (SummaryNode* self,
                           Node* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_signal_connect_object (node, "moved", (GCallback) _summary_node_nodes_changed_moved_node_moved, self, 0);
	g_signal_connect_object (node, "resized", (GCallback) _summary_node_nodes_changed_resized_node_resized, self, 0);
}

static void
summary_node_disconnect_node (SummaryNode* self,
                              Node* node)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_signal_parse_name ("moved", TYPE_NODE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (node, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _summary_node_nodes_changed_moved_node_moved, self);
	g_signal_parse_name ("resized", TYPE_NODE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (node, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _summary_node_nodes_changed_resized_node_resized, self);
}

gint
summary_node_summarized_count (SummaryNode* self)
{
	GList* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_nodes;
	result = (gint) g_list_length (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Node*
summary_node_first_node (SummaryNode* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	Node* _tmp3_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nodes;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((Node*) _tmp2_);
	result = _tmp3_;
	return result;
}

Node*
summary_node_last_node (SummaryNode* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	Node* _tmp3_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nodes;
	_tmp1_ = g_list_last (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((Node*) _tmp2_);
	result = _tmp3_;
	return result;
}

gint
summary_node_node_index (SummaryNode* self,
                         Node* node)
{
	GList* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node != NULL, 0);
	_tmp0_ = self->priv->_nodes;
	result = g_list_index (_tmp0_, node);
	return result;
}

static gboolean
summary_node_real_is_summary (Node* base)
{
	SummaryNode * self;
	gboolean result;
	self = (SummaryNode*) base;
	result = TRUE;
	return result;
}

gboolean
summary_node_is_within_summarized (SummaryNode* self,
                                   gdouble x,
                                   gdouble y)
{
	gdouble* _tmp0_;
	NodeSide _tmp1_;
	NodeSide _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_first_xy;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = node_get_side ((Node*) self);
	_tmp2_ = _tmp1_;
	if (node_side_horizontal (_tmp2_)) {
		gboolean _tmp3_ = FALSE;
		gdouble* _tmp4_;
		DrawArea* _tmp5_;
		DrawArea* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp4_ = self->priv->_first_xy;
		_tmp5_ = node_get_da ((Node*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = draw_area_get_origin_y (_tmp6_);
		_tmp8_ = _tmp7_;
		if (((*_tmp4_) + _tmp8_) <= y) {
			gdouble* _tmp9_;
			DrawArea* _tmp10_;
			DrawArea* _tmp11_;
			gdouble _tmp12_;
			gdouble _tmp13_;
			_tmp9_ = self->priv->_last_xy;
			_tmp10_ = node_get_da ((Node*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = draw_area_get_origin_y (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp3_ = y <= ((*_tmp9_) + _tmp13_);
		} else {
			_tmp3_ = FALSE;
		}
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp14_ = FALSE;
		gdouble* _tmp15_;
		DrawArea* _tmp16_;
		DrawArea* _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_;
		_tmp15_ = self->priv->_first_xy;
		_tmp16_ = node_get_da ((Node*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = draw_area_get_origin_x (_tmp17_);
		_tmp19_ = _tmp18_;
		if (((*_tmp15_) + _tmp19_) <= x) {
			gdouble* _tmp20_;
			DrawArea* _tmp21_;
			DrawArea* _tmp22_;
			gdouble _tmp23_;
			gdouble _tmp24_;
			_tmp20_ = self->priv->_last_xy;
			_tmp21_ = node_get_da ((Node*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = draw_area_get_origin_x (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp14_ = x <= ((*_tmp20_) + _tmp24_);
		} else {
			_tmp14_ = FALSE;
		}
		result = _tmp14_;
		return result;
	}
}

void
summary_node_clear_extents (SummaryNode* self)
{
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->_first_xy);
	self->priv->_first_xy = NULL;
	_g_free0 (self->priv->_last_xy);
	self->priv->_last_xy = NULL;
}

void
summary_node_get_extents (SummaryNode* self,
                          gdouble* xy1,
                          gdouble* xy2)
{
	gdouble _vala_xy1 = 0.0;
	gdouble _vala_xy2 = 0.0;
	GList* _tmp0_;
	gdouble fx = 0.0;
	gdouble fy = 0.0;
	gdouble fw = 0.0;
	gdouble fh = 0.0;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	gdouble lw = 0.0;
	gdouble lh = 0.0;
	Node* _tmp1_;
	Node* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	Node* _tmp7_;
	Node* _tmp8_;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	NodeSide _tmp14_;
	NodeSide _tmp15_;
	gdouble _tmp16_ = 0.0;
	NodeSide _tmp17_;
	NodeSide _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nodes;
	if (g_list_length (_tmp0_) == ((guint) 0)) {
		_vala_xy1 = (gdouble) 0;
		_vala_xy2 = (gdouble) 0;
		if (xy1) {
			*xy1 = _vala_xy1;
		}
		if (xy2) {
			*xy2 = _vala_xy2;
		}
		return;
	}
	_tmp1_ = summary_node_first_node (self);
	_tmp2_ = _tmp1_;
	node_bbox (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	fx = _tmp3_;
	fy = _tmp4_;
	fw = _tmp5_;
	fh = _tmp6_;
	_g_object_unref0 (_tmp2_);
	_tmp7_ = summary_node_last_node (self);
	_tmp8_ = _tmp7_;
	node_bbox (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	lx = _tmp9_;
	ly = _tmp10_;
	lw = _tmp11_;
	lh = _tmp12_;
	_g_object_unref0 (_tmp8_);
	_tmp14_ = node_get_side ((Node*) self);
	_tmp15_ = _tmp14_;
	if (node_side_horizontal (_tmp15_)) {
		_tmp13_ = fy;
	} else {
		_tmp13_ = fx;
	}
	_vala_xy1 = _tmp13_;
	_tmp17_ = node_get_side ((Node*) self);
	_tmp18_ = _tmp17_;
	if (node_side_horizontal (_tmp18_)) {
		_tmp16_ = ly + lh;
	} else {
		_tmp16_ = lx + lw;
	}
	_vala_xy2 = _tmp16_;
	if (xy1) {
		*xy1 = _vala_xy1;
	}
	if (xy2) {
		*xy2 = _vala_xy2;
	}
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

void
summary_node_set_extents (SummaryNode* self)
{
	GList* _tmp0_;
	gdouble xy1 = 0.0;
	gdouble xy2 = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gint* first_margin = NULL;
	Node* _tmp3_;
	Node* _tmp4_;
	Style* _tmp5_;
	Style* _tmp6_;
	gint* _tmp7_;
	gint* _tmp8_;
	gint* _tmp9_;
	gint* _tmp10_;
	gint* last_margin = NULL;
	Node* _tmp11_;
	Node* _tmp12_;
	Style* _tmp13_;
	Style* _tmp14_;
	gint* _tmp15_;
	gint* _tmp16_;
	gint* _tmp17_;
	gint* _tmp18_;
	gdouble _tmp19_ = 0.0;
	NodeSide _tmp20_;
	NodeSide _tmp21_;
	gdouble origin = 0.0;
	gint* _tmp30_;
	gdouble _tmp31_;
	gdouble* _tmp32_;
	gint* _tmp33_;
	gdouble _tmp34_;
	gdouble* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nodes;
	_vala_assert (g_list_length (_tmp0_) > ((guint) 0), "_nodes.length() > 0");
	summary_node_get_extents (self, &_tmp1_, &_tmp2_);
	xy1 = _tmp1_;
	xy2 = _tmp2_;
	_tmp3_ = summary_node_first_node (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = node_get_style (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = style_get_node_margin (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = __int_dup0 (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp4_);
	first_margin = _tmp10_;
	_tmp11_ = summary_node_last_node (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = node_get_style (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = style_get_node_margin (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = __int_dup0 (_tmp16_);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp12_);
	last_margin = _tmp18_;
	_tmp20_ = node_get_side ((Node*) self);
	_tmp21_ = _tmp20_;
	if (node_side_horizontal (_tmp21_)) {
		DrawArea* _tmp22_;
		DrawArea* _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		_tmp22_ = node_get_da ((Node*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = draw_area_get_origin_y (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = _tmp25_;
	} else {
		DrawArea* _tmp26_;
		DrawArea* _tmp27_;
		gdouble _tmp28_;
		gdouble _tmp29_;
		_tmp26_ = node_get_da ((Node*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = draw_area_get_origin_x (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp19_ = _tmp29_;
	}
	origin = _tmp19_;
	_tmp30_ = first_margin;
	_tmp31_ = (xy1 + (*_tmp30_)) - origin;
	_tmp32_ = __double_dup0 (&_tmp31_);
	_g_free0 (self->priv->_first_xy);
	self->priv->_first_xy = _tmp32_;
	_tmp33_ = last_margin;
	_tmp34_ = (xy2 - (*_tmp33_)) - origin;
	_tmp35_ = __double_dup0 (&_tmp34_);
	_g_free0 (self->priv->_last_xy);
	self->priv->_last_xy = _tmp35_;
	_g_free0 (last_margin);
	_g_free0 (first_margin);
}

static gint
summary_node_compare_pos (gdouble pos1,
                          gdouble pos2)
{
	gint _tmp0_ = 0;
	gint result;
	if (pos1 == pos2) {
		_tmp0_ = 0;
	} else {
		gint _tmp1_ = 0;
		if (pos1 < pos2) {
			_tmp1_ = -1;
		} else {
			_tmp1_ = 1;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static void
summary_node_nodes_changed_moved (SummaryNode* self,
                                  gdouble fx,
                                  gdouble fy)
{
	g_return_if_fail (self != NULL);
}

static void
summary_node_nodes_changed_resized (SummaryNode* self,
                                    gdouble fx,
                                    gdouble fy)
{
	g_return_if_fail (self != NULL);
	summary_node_nodes_changed (self, fx, fy, "resized");
}

void
summary_node_nodes_changed (SummaryNode* self,
                            gdouble fx,
                            gdouble fy,
                            const gchar* msg)
{
	gint* _tmp0_ = NULL;
	Style* _tmp1_;
	Style* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
	gint* _tmp5_;
	gint* margin = NULL;
	gint* _tmp8_;
	gdouble x1 = 0.0;
	Node* _tmp9_;
	Node* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble y1 = 0.0;
	Node* _tmp14_;
	Node* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble x2 = 0.0;
	Node* _tmp19_;
	Node* _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	Node* _tmp23_;
	Node* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble y2 = 0.0;
	Node* _tmp28_;
	Node* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	Node* _tmp32_;
	Node* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	GList* _tmp37_;
	FILE* _tmp75_;
	NodeSide _tmp76_;
	NodeSide _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	NodeSide _tmp80_;
	NodeSide _tmp81_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp1_ = node_get_style ((Node*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = style_get_branch_margin (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = __int_dup0 (_tmp4_);
	_tmp0_ = _tmp5_;
	if (_tmp0_ == NULL) {
		gint _tmp6_;
		gint* _tmp7_;
		_tmp6_ = 0;
		_tmp7_ = __int_dup0 (&_tmp6_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	_tmp0_ = NULL;
	margin = _tmp8_;
	_tmp9_ = summary_node_first_node (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = node_get_posx (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	x1 = _tmp13_;
	_tmp14_ = summary_node_first_node (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = node_get_posy (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp15_);
	y1 = _tmp18_;
	_tmp19_ = summary_node_first_node (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = node_get_posx (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = summary_node_first_node (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = node_get_width (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp22_ + _tmp26_;
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (_tmp20_);
	x2 = _tmp27_;
	_tmp28_ = summary_node_first_node (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = node_get_posy (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = summary_node_first_node (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = node_get_height (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp31_ + _tmp35_;
	_g_object_unref0 (_tmp33_);
	_g_object_unref0 (_tmp29_);
	y2 = _tmp36_;
	_tmp37_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp37_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp38_;
			Node* node = NULL;
			_tmp38_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp38_;
			{
				Node* _tmp39_;
				gdouble _tmp40_;
				gdouble _tmp41_;
				Node* _tmp45_;
				gdouble _tmp46_;
				gdouble _tmp47_;
				Node* _tmp51_;
				gdouble _tmp52_;
				gdouble _tmp53_;
				Node* _tmp54_;
				gdouble _tmp55_;
				gdouble _tmp56_;
				Node* _tmp63_;
				gdouble _tmp64_;
				gdouble _tmp65_;
				Node* _tmp66_;
				gdouble _tmp67_;
				gdouble _tmp68_;
				_tmp39_ = node;
				_tmp40_ = node_get_posx (_tmp39_);
				_tmp41_ = _tmp40_;
				if (x1 > _tmp41_) {
					Node* _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					_tmp42_ = node;
					_tmp43_ = node_get_posx (_tmp42_);
					_tmp44_ = _tmp43_;
					x1 = _tmp44_;
				}
				_tmp45_ = node;
				_tmp46_ = node_get_posy (_tmp45_);
				_tmp47_ = _tmp46_;
				if (y1 > _tmp47_) {
					Node* _tmp48_;
					gdouble _tmp49_;
					gdouble _tmp50_;
					_tmp48_ = node;
					_tmp49_ = node_get_posy (_tmp48_);
					_tmp50_ = _tmp49_;
					y1 = _tmp50_;
				}
				_tmp51_ = node;
				_tmp52_ = node_get_posx (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = node;
				_tmp55_ = node_get_width (_tmp54_);
				_tmp56_ = _tmp55_;
				if (x2 < (_tmp53_ + _tmp56_)) {
					Node* _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_;
					Node* _tmp60_;
					gdouble _tmp61_;
					gdouble _tmp62_;
					_tmp57_ = node;
					_tmp58_ = node_get_posx (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = node;
					_tmp61_ = node_get_width (_tmp60_);
					_tmp62_ = _tmp61_;
					x2 = _tmp59_ + _tmp62_;
				}
				_tmp63_ = node;
				_tmp64_ = node_get_posy (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = node;
				_tmp67_ = node_get_height (_tmp66_);
				_tmp68_ = _tmp67_;
				if (y2 < (_tmp65_ + _tmp68_)) {
					Node* _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					Node* _tmp72_;
					gdouble _tmp73_;
					gdouble _tmp74_;
					_tmp69_ = node;
					_tmp70_ = node_get_posy (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = node;
					_tmp73_ = node_get_height (_tmp72_);
					_tmp74_ = _tmp73_;
					y2 = _tmp71_ + _tmp74_;
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp75_ = stdout;
	_tmp76_ = node_get_side ((Node*) self);
	_tmp77_ = _tmp76_;
	_tmp78_ = node_side_to_string (_tmp77_);
	_tmp79_ = _tmp78_;
	fprintf (_tmp75_, "In nodes_changed, side: %s, fx: %g, fy: %g, x1: %g, y1: %g, x2: %g, y2" \
": %g, msg: %s\n", _tmp79_, fx, fy, x1, y1, x2, y2, msg);
	_g_free0 (_tmp79_);
	_tmp80_ = node_get_side ((Node*) self);
	_tmp81_ = _tmp80_;
	switch (_tmp81_) {
		case NODE_SIDE_LEFT:
		{
			gdouble _tmp82_ = 0.0;
			gdouble _tmp88_ = 0.0;
			if (fx == ((gdouble) 0)) {
				gdouble _tmp83_;
				gdouble _tmp84_;
				_tmp83_ = node_get_posx ((Node*) self);
				_tmp84_ = _tmp83_;
				_tmp82_ = _tmp84_;
			} else {
				gdouble _tmp85_;
				gdouble _tmp86_;
				gint* _tmp87_;
				_tmp85_ = node_get_width ((Node*) self);
				_tmp86_ = _tmp85_;
				_tmp87_ = margin;
				_tmp82_ = (x1 - _tmp86_) - (*_tmp87_);
			}
			node_set_posx ((Node*) self, _tmp82_);
			if (fy == ((gdouble) 0)) {
				gdouble _tmp89_;
				gdouble _tmp90_;
				_tmp89_ = node_get_posy ((Node*) self);
				_tmp90_ = _tmp89_;
				_tmp88_ = _tmp90_;
			} else {
				gdouble _tmp91_;
				gdouble _tmp92_;
				_tmp91_ = node_get_height ((Node*) self);
				_tmp92_ = _tmp91_;
				_tmp88_ = (((y2 - y1) / 2) - (_tmp92_ / 2)) + y1;
			}
			node_set_posy ((Node*) self, _tmp88_);
			break;
		}
		case NODE_SIDE_RIGHT:
		{
			gdouble _tmp93_ = 0.0;
			gdouble _tmp97_ = 0.0;
			if (fx == ((gdouble) 0)) {
				gdouble _tmp94_;
				gdouble _tmp95_;
				_tmp94_ = node_get_posx ((Node*) self);
				_tmp95_ = _tmp94_;
				_tmp93_ = _tmp95_;
			} else {
				gint* _tmp96_;
				_tmp96_ = margin;
				_tmp93_ = x2 + (*_tmp96_);
			}
			node_set_posx ((Node*) self, _tmp93_);
			if (fy == ((gdouble) 0)) {
				gdouble _tmp98_;
				gdouble _tmp99_;
				_tmp98_ = node_get_posy ((Node*) self);
				_tmp99_ = _tmp98_;
				_tmp97_ = _tmp99_;
			} else {
				gdouble _tmp100_;
				gdouble _tmp101_;
				_tmp100_ = node_get_height ((Node*) self);
				_tmp101_ = _tmp100_;
				_tmp97_ = (((y2 - y1) / 2) - (_tmp101_ / 2)) + y1;
			}
			node_set_posy ((Node*) self, _tmp97_);
			break;
		}
		case NODE_SIDE_TOP:
		{
			gdouble _tmp102_ = 0.0;
			gdouble _tmp107_ = 0.0;
			if (fx == ((gdouble) 0)) {
				gdouble _tmp103_;
				gdouble _tmp104_;
				_tmp103_ = node_get_posx ((Node*) self);
				_tmp104_ = _tmp103_;
				_tmp102_ = _tmp104_;
			} else {
				gdouble _tmp105_;
				gdouble _tmp106_;
				_tmp105_ = node_get_width ((Node*) self);
				_tmp106_ = _tmp105_;
				_tmp102_ = (((x2 - x1) / 2) - (_tmp106_ / 2)) + x1;
			}
			node_set_posx ((Node*) self, _tmp102_);
			if (fy == ((gdouble) 0)) {
				gdouble _tmp108_;
				gdouble _tmp109_;
				_tmp108_ = node_get_posy ((Node*) self);
				_tmp109_ = _tmp108_;
				_tmp107_ = _tmp109_;
			} else {
				gdouble _tmp110_;
				gdouble _tmp111_;
				gint* _tmp112_;
				_tmp110_ = node_get_height ((Node*) self);
				_tmp111_ = _tmp110_;
				_tmp112_ = margin;
				_tmp107_ = (y1 - _tmp111_) - (*_tmp112_);
			}
			node_set_posy ((Node*) self, _tmp107_);
			break;
		}
		case NODE_SIDE_BOTTOM:
		{
			gdouble _tmp113_ = 0.0;
			gdouble _tmp118_ = 0.0;
			if (fx == ((gdouble) 0)) {
				gdouble _tmp114_;
				gdouble _tmp115_;
				_tmp114_ = node_get_posx ((Node*) self);
				_tmp115_ = _tmp114_;
				_tmp113_ = _tmp115_;
			} else {
				gdouble _tmp116_;
				gdouble _tmp117_;
				_tmp116_ = node_get_width ((Node*) self);
				_tmp117_ = _tmp116_;
				_tmp113_ = (((x2 - x1) / 2) - (_tmp117_ / 2)) + x1;
			}
			node_set_posx ((Node*) self, _tmp113_);
			if (fy == ((gdouble) 0)) {
				gdouble _tmp119_;
				gdouble _tmp120_;
				_tmp119_ = node_get_posy ((Node*) self);
				_tmp120_ = _tmp119_;
				_tmp118_ = _tmp120_;
			} else {
				gint* _tmp121_;
				_tmp121_ = margin;
				_tmp118_ = y2 + (*_tmp121_);
			}
			node_set_posy ((Node*) self, _tmp118_);
			break;
		}
		default:
		break;
	}
	_g_free0 (margin);
	_g_free0 (_tmp0_);
}

static void
_node_parent_moved_node_moved (Node* _sender,
                               gdouble diffx,
                               gdouble diffy,
                               gpointer self)
{
	node_parent_moved ((Node*) self, _sender, diffx, diffy);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

void
summary_node_attach_nodes (SummaryNode* self,
                           Node* p,
                           GArray* nodes,
                           gboolean sort,
                           Theme* theme)
{
	Layout* _tmp13_;
	Layout* _tmp14_;
	Node* _tmp15_;
	Node* _tmp16_;
	Node* _tmp17_;
	Node* _tmp18_;
	Style* _tmp19_;
	Style* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (nodes != NULL);
	_vala_assert (nodes->len > ((guint) 0), "nodes.length > 0");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Node* node = NULL;
				Node* _tmp2_;
				Node* _tmp3_;
				Node* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				GArray* _tmp7_;
				GArray* _tmp8_;
				Node* _tmp9_;
				Node* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < nodes->len)) {
					break;
				}
				_tmp2_ = g_array_index (nodes, Node*, (guint) i);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				node = _tmp3_;
				_tmp4_ = node;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				self->priv->_nodes = g_list_append (self->priv->_nodes, _tmp5_);
				_tmp6_ = node;
				_tmp7_ = node_children (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _g_object_ref0 ((Node*) self);
				g_array_append_val (_tmp8_, _tmp9_);
				_g_array_unref0 (_tmp8_);
				_tmp10_ = node;
				summary_node_connect_node (self, _tmp10_);
				_g_object_unref0 (node);
			}
		}
	}
	g_signal_connect_object (p, "moved", (GCallback) _node_parent_moved_node_moved, (Node*) self, 0);
	if (sort) {
		summary_node_sort_nodes (self);
	} else {
		Node* _tmp11_;
		Node* _tmp12_;
		_tmp11_ = summary_node_last_node (self);
		_tmp12_ = _tmp11_;
		node_set_parent ((Node*) self, _tmp12_);
		_g_object_unref0 (_tmp12_);
		summary_node_update_tree_bboxes (self);
	}
	_tmp13_ = node_get_layout ((Node*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = node_get_parent ((Node*) self);
	_tmp16_ = _tmp15_;
	layout_handle_update_by_insert (_tmp14_, _tmp16_, (Node*) self, -1);
	_tmp17_ = summary_node_last_node (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = node_get_style (_tmp18_);
	_tmp20_ = _tmp19_;
	node_set_style ((Node*) self, _tmp20_);
	_g_object_unref0 (_tmp18_);
	if (theme != NULL) {
		GdkRGBA* _tmp21_ = NULL;
		GdkRGBA _tmp28_;
		if (node_main_branch ((Node*) self)) {
			GdkRGBA* _tmp22_;
			_tmp22_ = theme_next_color (theme);
			__vala_GdkRGBA_free0 (_tmp21_);
			_tmp21_ = _tmp22_;
		} else {
			Node* _tmp23_;
			Node* _tmp24_;
			GdkRGBA* _tmp25_;
			GdkRGBA* _tmp26_;
			GdkRGBA* _tmp27_;
			_tmp23_ = node_get_parent ((Node*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = node_get_link_color (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = __vala_GdkRGBA_copy0 (_tmp26_);
			__vala_GdkRGBA_free0 (_tmp21_);
			_tmp21_ = _tmp27_;
		}
		_tmp28_ = *_tmp21_;
		node_set_link_color_child ((Node*) self, &_tmp28_);
		__vala_GdkRGBA_free0 (_tmp21_);
	}
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

void
summary_node_attach_siblings (SummaryNode* self,
                              Node* node,
                              Theme* theme)
{
	Node* sibling = NULL;
	Node* _tmp0_;
	GArray* nodes = NULL;
	GArray* _tmp1_;
	Node* _tmp18_;
	Node* _tmp19_;
	GArray* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _g_object_ref0 (node);
	sibling = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_Node_free_function_content_of);
	nodes = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		Node* _tmp5_;
		GArray* _tmp13_;
		Node* _tmp14_;
		Node* _tmp15_;
		Node* _tmp16_;
		Node* _tmp17_;
		_tmp5_ = sibling;
		if (_tmp5_ != NULL) {
			Node* _tmp6_;
			_tmp6_ = sibling;
			_tmp4_ = node_is_leaf (_tmp6_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			Node* _tmp7_;
			_tmp7_ = sibling;
			_tmp3_ = !node_is_summarized (_tmp7_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			Node* _tmp8_;
			NodeSide _tmp9_;
			NodeSide _tmp10_;
			NodeSide _tmp11_;
			NodeSide _tmp12_;
			_tmp8_ = sibling;
			_tmp9_ = node_get_side (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = node_get_side ((Node*) self);
			_tmp12_ = _tmp11_;
			_tmp2_ = _tmp10_ == _tmp12_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp13_ = nodes;
		_tmp14_ = sibling;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_array_prepend_val (_tmp13_, _tmp15_);
		_tmp16_ = sibling;
		_tmp17_ = node_previous_sibling (_tmp16_);
		_g_object_unref0 (sibling);
		sibling = _tmp17_;
	}
	_tmp18_ = node_get_parent (node);
	_tmp19_ = _tmp18_;
	_tmp20_ = nodes;
	summary_node_attach_nodes (self, _tmp19_, _tmp20_, FALSE, theme);
	_g_array_unref0 (nodes);
	_g_object_unref0 (sibling);
}

void
summary_node_attach_all (SummaryNode* self)
{
	GList* _tmp0_;
	Node* _tmp7_;
	Node* _tmp8_;
	Node* _tmp9_;
	Node* _tmp10_;
	Node* _tmp11_;
	Node* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp0_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp1_;
			Node* node = NULL;
			_tmp1_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp1_;
			{
				Node* _tmp2_;
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				_tmp2_ = node;
				_tmp3_ = node_children (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 ((Node*) self);
				g_array_append_val (_tmp4_, _tmp5_);
				_g_array_unref0 (_tmp4_);
				_tmp6_ = node;
				summary_node_connect_node (self, _tmp6_);
				_g_object_unref0 (node);
			}
		}
	}
	_tmp7_ = summary_node_first_node (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = node_get_parent (_tmp8_);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "moved", (GCallback) _node_parent_moved_node_moved, (Node*) self, 0);
	_g_object_unref0 (_tmp8_);
	_tmp11_ = summary_node_last_node (self);
	_tmp12_ = _tmp11_;
	node_set_parent ((Node*) self, _tmp12_);
	_g_object_unref0 (_tmp12_);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
summary_node_detach_all (SummaryNode* self)
{
	Node* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	guint _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = summary_node_first_node (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = node_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_parse_name ("moved", TYPE_NODE, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _node_parent_moved_node_moved, (Node*) self);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp5_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp6_;
			Node* node = NULL;
			_tmp6_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp6_;
			{
				Node* _tmp7_;
				GArray* _tmp8_;
				GArray* _tmp9_;
				Node* _tmp10_;
				Node* _tmp11_;
				Node* _tmp12_;
				_tmp7_ = node;
				_tmp8_ = node_children (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_g_array_remove_index (_tmp9_, (guint) 0);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp11_);
				_g_array_unref0 (_tmp9_);
				_tmp12_ = node;
				summary_node_disconnect_node (self, _tmp12_);
				_g_object_unref0 (node);
			}
		}
	}
	node_set_parent ((Node*) self, NULL);
}

static void
summary_node_real_detach (Node* base,
                          NodeSide side)
{
	SummaryNode * self;
	self = (SummaryNode*) base;
	summary_node_detach_all (self);
}

static void
summary_node_update_tree_bboxes (SummaryNode* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp0_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp1_;
			Node* node = NULL;
			_tmp1_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp1_;
			{
				Node* _tmp2_;
				Layout* _tmp3_;
				Layout* _tmp4_;
				Node* _tmp5_;
				NodeBounds* _tmp6_;
				NodeBounds* _tmp7_;
				gdouble _tmp8_ = 0.0;
				NodeSide _tmp9_;
				NodeSide _tmp10_;
				Node* _tmp21_;
				_tmp2_ = node;
				_tmp3_ = node_get_layout ((Node*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = node;
				_tmp6_ = layout_bbox (_tmp4_, _tmp5_, -1, "update_tree_bboxes");
				_tmp7_ = _tmp6_;
				node_set_tree_bbox (_tmp2_, _tmp7_);
				_node_bounds_unref0 (_tmp7_);
				_tmp9_ = node_get_side ((Node*) self);
				_tmp10_ = _tmp9_;
				if (node_side_horizontal (_tmp10_)) {
					Node* _tmp11_;
					NodeBounds* _tmp12_;
					NodeBounds* _tmp13_;
					gdouble _tmp14_;
					gdouble _tmp15_;
					_tmp11_ = node;
					_tmp12_ = node_get_tree_bbox (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = node_bounds_get_height (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp8_ = _tmp15_;
				} else {
					Node* _tmp16_;
					NodeBounds* _tmp17_;
					NodeBounds* _tmp18_;
					gdouble _tmp19_;
					gdouble _tmp20_;
					_tmp16_ = node;
					_tmp17_ = node_get_tree_bbox (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = node_bounds_get_width (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp8_ = _tmp20_;
				}
				_tmp21_ = node;
				node_set_tree_size (_tmp21_, _tmp8_);
				_g_object_unref0 (node);
			}
		}
	}
}

static gint
__lambda48_ (Node* a,
             Node* b)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (node_index (a) == node_index (b)) {
		_tmp0_ = 0;
	} else {
		gint _tmp1_ = 0;
		if (node_index (a) < node_index (b)) {
			_tmp1_ = -1;
		} else {
			_tmp1_ = 1;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gint
___lambda48__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda48_ ((Node*) a, (Node*) b);
	return result;
}

static void
summary_node_sort_nodes (SummaryNode* self)
{
	Node* _tmp0_;
	Node* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_nodes = g_list_sort (self->priv->_nodes, ___lambda48__gcompare_func);
	_tmp0_ = summary_node_last_node (self);
	_tmp1_ = _tmp0_;
	node_set_parent ((Node*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	summary_node_update_tree_bboxes (self);
}

void
summary_node_add_node (SummaryNode* self,
                       Node* node)
{
	Node* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	Node* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _g_object_ref0 (node);
	self->priv->_nodes = g_list_append (self->priv->_nodes, _tmp0_);
	_tmp1_ = node_children (node);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 ((Node*) self);
	g_array_append_val (_tmp2_, _tmp3_);
	_g_array_unref0 (_tmp2_);
	summary_node_connect_node (self, node);
	summary_node_sort_nodes (self);
}

void
summary_node_node_moved (SummaryNode* self,
                         Node* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	summary_node_sort_nodes (self);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
summary_node_remove_node (SummaryNode* self,
                          Node* node)
{
	gboolean update_color = FALSE;
	Node* _tmp0_;
	Node* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	Node** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node_get_parent ((Node*) self);
	_tmp1_ = _tmp0_;
	update_color = node == _tmp1_;
	self->priv->_nodes = vala_g_list_remove_full (self->priv->_nodes, node, _g_object_unref0_);
	_tmp2_ = node_children (node);
	_tmp3_ = _tmp2_;
	_tmp5_ = vala_g_array_remove_range (_tmp3_, (guint) 0, (guint) 1, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_array_unref0 (_tmp3_);
	summary_node_disconnect_node (self, node);
	summary_node_sort_nodes (self);
	if (update_color) {
		Node* _tmp7_;
		Node* _tmp8_;
		GdkRGBA* _tmp9_;
		GdkRGBA* _tmp10_;
		GdkRGBA _tmp11_;
		_tmp7_ = node_get_parent ((Node*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = node_get_link_color (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = *_tmp10_;
		node_set_link_color_child ((Node*) self, &_tmp11_);
	}
}

static void
summary_node_real_delete (Node* base)
{
	SummaryNode * self;
	self = (SummaryNode*) base;
	summary_node_detach_all (self);
}

static void
summary_node_draw_link_left (SummaryNode* self,
                             cairo_t* ctx)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble sx = 0.0;
	Node* _tmp4_;
	Node* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GList* _tmp9_;
	gdouble x1 = 0.0;
	gdouble _tmp17_ = 0.0;
	gdouble* _tmp18_;
	gdouble y1 = 0.0;
	Node* _tmp28_;
	Node* _tmp29_;
	Style* _tmp30_;
	Style* _tmp31_;
	gint* _tmp32_;
	gint* _tmp33_;
	gdouble _tmp34_;
	gdouble x2 = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble* _tmp36_;
	gdouble y2 = 0.0;
	Node* _tmp50_;
	Node* _tmp51_;
	Style* _tmp52_;
	Style* _tmp53_;
	gint* _tmp54_;
	gint* _tmp55_;
	gdouble _tmp56_;
	gint* margin = NULL;
	Style* _tmp57_;
	Style* _tmp58_;
	gint* _tmp59_;
	gint* _tmp60_;
	gint* _tmp61_;
	gdouble _tmp62_ = 0.0;
	Style* _tmp63_;
	Style* _tmp64_;
	NodeBorder* _tmp65_;
	NodeBorder* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_;
	gdouble _tmp71_ = 0.0;
	GList* _tmp72_;
	GdkRGBA* _tmp79_;
	GdkRGBA* _tmp80_;
	GdkRGBA _tmp81_;
	gint* _tmp82_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	node_node_bbox ((Node*) self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = summary_node_first_node (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_get_posx (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	sx = _tmp8_;
	_tmp9_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp9_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp10_;
			Node* node = NULL;
			_tmp10_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp10_;
			{
				Node* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				_tmp11_ = node;
				_tmp12_ = node_get_posx (_tmp11_);
				_tmp13_ = _tmp12_;
				if (sx > _tmp13_) {
					Node* _tmp14_;
					gdouble _tmp15_;
					gdouble _tmp16_;
					_tmp14_ = node;
					_tmp15_ = node_get_posx (_tmp14_);
					_tmp16_ = _tmp15_;
					sx = _tmp16_;
				}
				_g_object_unref0 (node);
			}
		}
	}
	x1 = sx - 10;
	_tmp18_ = self->priv->_first_xy;
	if (_tmp18_ == NULL) {
		Node* _tmp19_;
		Node* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp19_ = summary_node_first_node (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = node_get_posy (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = _tmp22_;
		_g_object_unref0 (_tmp20_);
	} else {
		gdouble* _tmp23_;
		DrawArea* _tmp24_;
		DrawArea* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		_tmp23_ = self->priv->_first_xy;
		_tmp24_ = node_get_da ((Node*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = draw_area_get_origin_x (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp17_ = (*_tmp23_) + _tmp27_;
	}
	_tmp28_ = summary_node_first_node (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = node_get_style (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = style_get_node_margin (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp17_ + (*_tmp33_);
	_g_object_unref0 (_tmp29_);
	y1 = _tmp34_;
	x2 = sx - 20;
	_tmp36_ = self->priv->_last_xy;
	if (_tmp36_ == NULL) {
		Node* _tmp37_;
		Node* _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		Node* _tmp41_;
		Node* _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_;
		_tmp37_ = summary_node_last_node (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = node_get_posy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = summary_node_last_node (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = node_get_height (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp35_ = _tmp40_ + _tmp44_;
		_g_object_unref0 (_tmp42_);
		_g_object_unref0 (_tmp38_);
	} else {
		gdouble* _tmp45_;
		DrawArea* _tmp46_;
		DrawArea* _tmp47_;
		gdouble _tmp48_;
		gdouble _tmp49_;
		_tmp45_ = self->priv->_last_xy;
		_tmp46_ = node_get_da ((Node*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = draw_area_get_origin_y (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp35_ = (*_tmp45_) + _tmp49_;
	}
	_tmp50_ = summary_node_last_node (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = node_get_style (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = style_get_node_margin (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp35_ - (*_tmp55_);
	_g_object_unref0 (_tmp51_);
	y2 = _tmp56_;
	cairo_move_to (ctx, x1, y1);
	cairo_line_to (ctx, x2, y1);
	cairo_line_to (ctx, x2, y2);
	cairo_line_to (ctx, x1, y2);
	cairo_stroke (ctx);
	_tmp57_ = node_get_style ((Node*) self);
	_tmp58_ = _tmp57_;
	_tmp59_ = style_get_node_margin (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = __int_dup0 (_tmp60_);
	margin = _tmp61_;
	_tmp63_ = node_get_style ((Node*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = style_get_node_border (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = node_border_name (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strcmp0 (_tmp68_, "underlined") == 0;
	_g_free0 (_tmp68_);
	if (_tmp69_) {
		gint* _tmp70_;
		_tmp70_ = margin;
		_tmp62_ = h - (*_tmp70_);
	} else {
		_tmp62_ = h / 2;
	}
	h = _tmp62_;
	_tmp72_ = self->priv->_nodes;
	if (g_list_length (_tmp72_) == ((guint) 1)) {
		Node* _tmp73_;
		Node* _tmp74_;
		gdouble _tmp75_;
		gdouble _tmp76_;
		_tmp73_ = node_get_parent ((Node*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = node_get_alpha (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp71_ = _tmp76_;
	} else {
		gdouble _tmp77_;
		gdouble _tmp78_;
		_tmp77_ = node_get_alpha ((Node*) self);
		_tmp78_ = _tmp77_;
		_tmp71_ = _tmp78_;
	}
	_tmp79_ = node_get_link_color ((Node*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = *_tmp80_;
	utils_set_context_color_with_alpha (ctx, &_tmp81_, _tmp71_);
	cairo_move_to (ctx, x2, ((y2 - y1) / 2) + y1);
	_tmp82_ = margin;
	cairo_line_to (ctx, (x + w) - (*_tmp82_), y + h);
	cairo_stroke (ctx);
	_g_free0 (margin);
}

static void
summary_node_draw_link_right (SummaryNode* self,
                              cairo_t* ctx)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble sx = 0.0;
	Node* _tmp4_;
	Node* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GList* _tmp9_;
	gdouble x1 = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble* _tmp24_;
	gdouble y1 = 0.0;
	Node* _tmp34_;
	Node* _tmp35_;
	Style* _tmp36_;
	Style* _tmp37_;
	gint* _tmp38_;
	gint* _tmp39_;
	gdouble _tmp40_;
	gdouble x2 = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble* _tmp42_;
	gdouble y2 = 0.0;
	Node* _tmp56_;
	Node* _tmp57_;
	Style* _tmp58_;
	Style* _tmp59_;
	gint* _tmp60_;
	gint* _tmp61_;
	gdouble _tmp62_;
	gint* margin = NULL;
	Style* _tmp63_;
	Style* _tmp64_;
	gint* _tmp65_;
	gint* _tmp66_;
	gint* _tmp67_;
	gdouble _tmp68_ = 0.0;
	Style* _tmp69_;
	Style* _tmp70_;
	NodeBorder* _tmp71_;
	NodeBorder* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gboolean _tmp75_;
	gdouble _tmp77_ = 0.0;
	GList* _tmp78_;
	GdkRGBA* _tmp85_;
	GdkRGBA* _tmp86_;
	GdkRGBA _tmp87_;
	gint* _tmp88_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	node_node_bbox ((Node*) self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = summary_node_first_node (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_get_posx (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	sx = _tmp8_;
	_tmp9_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp9_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp10_;
			Node* node = NULL;
			_tmp10_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp10_;
			{
				Node* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				Node* _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				_tmp11_ = node;
				_tmp12_ = node_get_posx (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = node;
				_tmp15_ = node_get_total_width (_tmp14_);
				_tmp16_ = _tmp15_;
				if (sx < (_tmp13_ + _tmp16_)) {
					Node* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					Node* _tmp20_;
					gdouble _tmp21_;
					gdouble _tmp22_;
					_tmp17_ = node;
					_tmp18_ = node_get_posx (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = node;
					_tmp21_ = node_get_total_width (_tmp20_);
					_tmp22_ = _tmp21_;
					sx = _tmp19_ + _tmp22_;
				}
				_g_object_unref0 (node);
			}
		}
	}
	x1 = sx + 10;
	_tmp24_ = self->priv->_first_xy;
	if (_tmp24_ == NULL) {
		Node* _tmp25_;
		Node* _tmp26_;
		gdouble _tmp27_;
		gdouble _tmp28_;
		_tmp25_ = summary_node_first_node (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = node_get_posy (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_;
		_g_object_unref0 (_tmp26_);
	} else {
		gdouble* _tmp29_;
		DrawArea* _tmp30_;
		DrawArea* _tmp31_;
		gdouble _tmp32_;
		gdouble _tmp33_;
		_tmp29_ = self->priv->_first_xy;
		_tmp30_ = node_get_da ((Node*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = draw_area_get_origin_y (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = (*_tmp29_) + _tmp33_;
	}
	_tmp34_ = summary_node_first_node (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = node_get_style (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = style_get_node_margin (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp23_ + (*_tmp39_);
	_g_object_unref0 (_tmp35_);
	y1 = _tmp40_;
	x2 = sx + 20;
	_tmp42_ = self->priv->_last_xy;
	if (_tmp42_ == NULL) {
		Node* _tmp43_;
		Node* _tmp44_;
		gdouble _tmp45_;
		gdouble _tmp46_;
		Node* _tmp47_;
		Node* _tmp48_;
		gdouble _tmp49_;
		gdouble _tmp50_;
		_tmp43_ = summary_node_last_node (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = node_get_posy (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = summary_node_last_node (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = node_get_height (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp41_ = _tmp46_ + _tmp50_;
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (_tmp44_);
	} else {
		gdouble* _tmp51_;
		DrawArea* _tmp52_;
		DrawArea* _tmp53_;
		gdouble _tmp54_;
		gdouble _tmp55_;
		_tmp51_ = self->priv->_last_xy;
		_tmp52_ = node_get_da ((Node*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = draw_area_get_origin_y (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp41_ = (*_tmp51_) + _tmp55_;
	}
	_tmp56_ = summary_node_last_node (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = node_get_style (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = style_get_node_margin (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp41_ - (*_tmp61_);
	_g_object_unref0 (_tmp57_);
	y2 = _tmp62_;
	cairo_move_to (ctx, x1, y1);
	cairo_line_to (ctx, x2, y1);
	cairo_line_to (ctx, x2, y2);
	cairo_line_to (ctx, x1, y2);
	cairo_stroke (ctx);
	_tmp63_ = node_get_style ((Node*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = style_get_node_margin (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = __int_dup0 (_tmp66_);
	margin = _tmp67_;
	_tmp69_ = node_get_style ((Node*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = style_get_node_border (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = node_border_name (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strcmp0 (_tmp74_, "underlined") == 0;
	_g_free0 (_tmp74_);
	if (_tmp75_) {
		gint* _tmp76_;
		_tmp76_ = margin;
		_tmp68_ = h - (*_tmp76_);
	} else {
		_tmp68_ = h / 2;
	}
	h = _tmp68_;
	_tmp78_ = self->priv->_nodes;
	if (g_list_length (_tmp78_) == ((guint) 1)) {
		Node* _tmp79_;
		Node* _tmp80_;
		gdouble _tmp81_;
		gdouble _tmp82_;
		_tmp79_ = node_get_parent ((Node*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = node_get_alpha (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp77_ = _tmp82_;
	} else {
		gdouble _tmp83_;
		gdouble _tmp84_;
		_tmp83_ = node_get_alpha ((Node*) self);
		_tmp84_ = _tmp83_;
		_tmp77_ = _tmp84_;
	}
	_tmp85_ = node_get_link_color ((Node*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = *_tmp86_;
	utils_set_context_color_with_alpha (ctx, &_tmp87_, _tmp77_);
	cairo_move_to (ctx, x2, ((y2 - y1) / 2) + y1);
	_tmp88_ = margin;
	cairo_line_to (ctx, x + (*_tmp88_), y + h);
	cairo_stroke (ctx);
	_g_free0 (margin);
}

static void
summary_node_draw_link_above (SummaryNode* self,
                              cairo_t* ctx)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble sy = 0.0;
	Node* _tmp4_;
	Node* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GList* _tmp9_;
	gdouble _tmp17_ = 0.0;
	gdouble* _tmp18_;
	gdouble x1 = 0.0;
	Node* _tmp28_;
	Node* _tmp29_;
	Style* _tmp30_;
	Style* _tmp31_;
	gint* _tmp32_;
	gint* _tmp33_;
	gdouble _tmp34_;
	gdouble y1 = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble* _tmp36_;
	gdouble x2 = 0.0;
	Node* _tmp50_;
	Node* _tmp51_;
	Style* _tmp52_;
	Style* _tmp53_;
	gint* _tmp54_;
	gint* _tmp55_;
	gdouble _tmp56_;
	gdouble y2 = 0.0;
	gint* margin = NULL;
	Style* _tmp57_;
	Style* _tmp58_;
	gint* _tmp59_;
	gint* _tmp60_;
	gint* _tmp61_;
	gdouble _tmp62_ = 0.0;
	GList* _tmp63_;
	GdkRGBA* _tmp70_;
	GdkRGBA* _tmp71_;
	GdkRGBA _tmp72_;
	gint* _tmp73_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	node_node_bbox ((Node*) self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = summary_node_first_node (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_get_posy (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	sy = _tmp8_;
	_tmp9_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp9_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp10_;
			Node* node = NULL;
			_tmp10_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp10_;
			{
				Node* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				_tmp11_ = node;
				_tmp12_ = node_get_posy (_tmp11_);
				_tmp13_ = _tmp12_;
				if (sy > _tmp13_) {
					Node* _tmp14_;
					gdouble _tmp15_;
					gdouble _tmp16_;
					_tmp14_ = node;
					_tmp15_ = node_get_posy (_tmp14_);
					_tmp16_ = _tmp15_;
					sy = _tmp16_;
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp18_ = self->priv->_first_xy;
	if (_tmp18_ == NULL) {
		Node* _tmp19_;
		Node* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp19_ = summary_node_first_node (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = node_get_posx (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = _tmp22_;
		_g_object_unref0 (_tmp20_);
	} else {
		gdouble* _tmp23_;
		DrawArea* _tmp24_;
		DrawArea* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		_tmp23_ = self->priv->_first_xy;
		_tmp24_ = node_get_da ((Node*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = draw_area_get_origin_x (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp17_ = (*_tmp23_) + _tmp27_;
	}
	_tmp28_ = summary_node_first_node (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = node_get_style (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = style_get_node_margin (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp17_ + (*_tmp33_);
	_g_object_unref0 (_tmp29_);
	x1 = _tmp34_;
	y1 = sy - 10;
	_tmp36_ = self->priv->_last_xy;
	if (_tmp36_ == NULL) {
		Node* _tmp37_;
		Node* _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		Node* _tmp41_;
		Node* _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_;
		_tmp37_ = summary_node_last_node (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = node_get_posx (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = summary_node_last_node (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = node_get_width (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp35_ = _tmp40_ + _tmp44_;
		_g_object_unref0 (_tmp42_);
		_g_object_unref0 (_tmp38_);
	} else {
		gdouble* _tmp45_;
		DrawArea* _tmp46_;
		DrawArea* _tmp47_;
		gdouble _tmp48_;
		gdouble _tmp49_;
		_tmp45_ = self->priv->_last_xy;
		_tmp46_ = node_get_da ((Node*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = draw_area_get_origin_x (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp35_ = (*_tmp45_) + _tmp49_;
	}
	_tmp50_ = summary_node_last_node (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = node_get_style (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = style_get_node_margin (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp35_ - (*_tmp55_);
	_g_object_unref0 (_tmp51_);
	x2 = _tmp56_;
	y2 = sy - 20;
	cairo_move_to (ctx, x1, y1);
	cairo_line_to (ctx, x1, y2);
	cairo_line_to (ctx, x2, y2);
	cairo_line_to (ctx, x2, y1);
	cairo_stroke (ctx);
	_tmp57_ = node_get_style ((Node*) self);
	_tmp58_ = _tmp57_;
	_tmp59_ = style_get_node_margin (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = __int_dup0 (_tmp60_);
	margin = _tmp61_;
	_tmp63_ = self->priv->_nodes;
	if (g_list_length (_tmp63_) == ((guint) 1)) {
		Node* _tmp64_;
		Node* _tmp65_;
		gdouble _tmp66_;
		gdouble _tmp67_;
		_tmp64_ = node_get_parent ((Node*) self);
		_tmp65_ = _tmp64_;
		_tmp66_ = node_get_alpha (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp62_ = _tmp67_;
	} else {
		gdouble _tmp68_;
		gdouble _tmp69_;
		_tmp68_ = node_get_alpha ((Node*) self);
		_tmp69_ = _tmp68_;
		_tmp62_ = _tmp69_;
	}
	_tmp70_ = node_get_link_color ((Node*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = *_tmp71_;
	utils_set_context_color_with_alpha (ctx, &_tmp72_, _tmp62_);
	cairo_move_to (ctx, ((x2 - x1) / 2) + x1, y2);
	_tmp73_ = margin;
	cairo_line_to (ctx, (w / 2) + x, (y + h) - (*_tmp73_));
	cairo_stroke (ctx);
	_g_free0 (margin);
}

static void
summary_node_draw_link_below (SummaryNode* self,
                              cairo_t* ctx)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble sy = 0.0;
	Node* _tmp4_;
	Node* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GList* _tmp9_;
	gdouble _tmp23_ = 0.0;
	gdouble* _tmp24_;
	gdouble x1 = 0.0;
	Node* _tmp34_;
	Node* _tmp35_;
	Style* _tmp36_;
	Style* _tmp37_;
	gint* _tmp38_;
	gint* _tmp39_;
	gdouble _tmp40_;
	gdouble y1 = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble* _tmp42_;
	gdouble x2 = 0.0;
	Node* _tmp56_;
	Node* _tmp57_;
	Style* _tmp58_;
	Style* _tmp59_;
	gint* _tmp60_;
	gint* _tmp61_;
	gdouble _tmp62_;
	gdouble y2 = 0.0;
	gint* margin = NULL;
	Style* _tmp63_;
	Style* _tmp64_;
	gint* _tmp65_;
	gint* _tmp66_;
	gint* _tmp67_;
	gdouble _tmp68_ = 0.0;
	GList* _tmp69_;
	GdkRGBA* _tmp76_;
	GdkRGBA* _tmp77_;
	GdkRGBA _tmp78_;
	gint* _tmp79_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	node_node_bbox ((Node*) self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp0_;
	y = _tmp1_;
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = summary_node_first_node (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_get_posy (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	sy = _tmp8_;
	_tmp9_ = self->priv->_nodes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp9_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			Node* _tmp10_;
			Node* node = NULL;
			_tmp10_ = _g_object_ref0 ((Node*) node_it->data);
			node = _tmp10_;
			{
				Node* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				Node* _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				_tmp11_ = node;
				_tmp12_ = node_get_posy (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = node;
				_tmp15_ = node_get_total_height (_tmp14_);
				_tmp16_ = _tmp15_;
				if (sy < (_tmp13_ + _tmp16_)) {
					Node* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					Node* _tmp20_;
					gdouble _tmp21_;
					gdouble _tmp22_;
					_tmp17_ = node;
					_tmp18_ = node_get_posy (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = node;
					_tmp21_ = node_get_total_height (_tmp20_);
					_tmp22_ = _tmp21_;
					sy = _tmp19_ + _tmp22_;
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp24_ = self->priv->_first_xy;
	if (_tmp24_ == NULL) {
		Node* _tmp25_;
		Node* _tmp26_;
		gdouble _tmp27_;
		gdouble _tmp28_;
		_tmp25_ = summary_node_first_node (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = node_get_posx (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_;
		_g_object_unref0 (_tmp26_);
	} else {
		gdouble* _tmp29_;
		DrawArea* _tmp30_;
		DrawArea* _tmp31_;
		gdouble _tmp32_;
		gdouble _tmp33_;
		_tmp29_ = self->priv->_first_xy;
		_tmp30_ = node_get_da ((Node*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = draw_area_get_origin_x (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = (*_tmp29_) + _tmp33_;
	}
	_tmp34_ = summary_node_first_node (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = node_get_style (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = style_get_node_margin (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp23_ + (*_tmp39_);
	_g_object_unref0 (_tmp35_);
	x1 = _tmp40_;
	y1 = sy + 10;
	_tmp42_ = self->priv->_last_xy;
	if (_tmp42_ == NULL) {
		Node* _tmp43_;
		Node* _tmp44_;
		gdouble _tmp45_;
		gdouble _tmp46_;
		Node* _tmp47_;
		Node* _tmp48_;
		gdouble _tmp49_;
		gdouble _tmp50_;
		_tmp43_ = summary_node_last_node (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = node_get_posx (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = summary_node_last_node (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = node_get_width (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp41_ = _tmp46_ + _tmp50_;
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (_tmp44_);
	} else {
		gdouble* _tmp51_;
		DrawArea* _tmp52_;
		DrawArea* _tmp53_;
		gdouble _tmp54_;
		gdouble _tmp55_;
		_tmp51_ = self->priv->_last_xy;
		_tmp52_ = node_get_da ((Node*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = draw_area_get_origin_x (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp41_ = (*_tmp51_) + _tmp55_;
	}
	_tmp56_ = summary_node_last_node (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = node_get_style (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = style_get_node_margin (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp41_ - (*_tmp61_);
	_g_object_unref0 (_tmp57_);
	x2 = _tmp62_;
	y2 = sy + 20;
	cairo_move_to (ctx, x1, y1);
	cairo_line_to (ctx, x1, y2);
	cairo_line_to (ctx, x2, y2);
	cairo_line_to (ctx, x2, y1);
	cairo_stroke (ctx);
	_tmp63_ = node_get_style ((Node*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = style_get_node_margin (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = __int_dup0 (_tmp66_);
	margin = _tmp67_;
	_tmp69_ = self->priv->_nodes;
	if (g_list_length (_tmp69_) == ((guint) 1)) {
		Node* _tmp70_;
		Node* _tmp71_;
		gdouble _tmp72_;
		gdouble _tmp73_;
		_tmp70_ = node_get_parent ((Node*) self);
		_tmp71_ = _tmp70_;
		_tmp72_ = node_get_alpha (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp68_ = _tmp73_;
	} else {
		gdouble _tmp74_;
		gdouble _tmp75_;
		_tmp74_ = node_get_alpha ((Node*) self);
		_tmp75_ = _tmp74_;
		_tmp68_ = _tmp75_;
	}
	_tmp76_ = node_get_link_color ((Node*) self);
	_tmp77_ = _tmp76_;
	_tmp78_ = *_tmp77_;
	utils_set_context_color_with_alpha (ctx, &_tmp78_, _tmp68_);
	cairo_move_to (ctx, ((x2 - x1) / 2) + x1, y2);
	_tmp79_ = margin;
	cairo_line_to (ctx, (w / 2) + x, y + (*_tmp79_));
	cairo_stroke (ctx);
	_g_free0 (margin);
}

static void
summary_node_real_draw_link (Node* base,
                             cairo_t* ctx,
                             Theme* theme)
{
	SummaryNode * self;
	GdkRGBA* color = NULL;
	GdkRGBA* _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	gboolean _tmp3_;
	gdouble _tmp5_ = 0.0;
	GList* _tmp6_;
	GdkRGBA* _tmp13_;
	GdkRGBA _tmp14_;
	Node* _tmp15_;
	Node* _tmp16_;
	Style* _tmp17_;
	Style* _tmp18_;
	gint* _tmp19_;
	gint* _tmp20_;
	NodeSide _tmp21_;
	NodeSide _tmp22_;
	self = (SummaryNode*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = node_get_link_color ((Node*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = __vala_GdkRGBA_copy0 (_tmp1_);
	color = _tmp2_;
	_tmp3_ = self->priv->_attachable;
	if (_tmp3_) {
		GdkRGBA* _tmp4_;
		_tmp4_ = theme_get_color (theme, "attachable");
		__vala_GdkRGBA_free0 (color);
		color = _tmp4_;
	}
	_tmp6_ = self->priv->_nodes;
	if (g_list_length (_tmp6_) == ((guint) 1)) {
		Node* _tmp7_;
		Node* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp7_ = node_get_parent ((Node*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = node_get_alpha (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp5_ = _tmp10_;
	} else {
		gdouble _tmp11_;
		gdouble _tmp12_;
		_tmp11_ = node_get_alpha ((Node*) self);
		_tmp12_ = _tmp11_;
		_tmp5_ = _tmp12_;
	}
	_tmp13_ = color;
	_tmp14_ = *_tmp13_;
	utils_set_context_color_with_alpha (ctx, &_tmp14_, _tmp5_);
	cairo_set_line_cap (ctx, CAIRO_LINE_CAP_ROUND);
	_tmp15_ = node_get_parent ((Node*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = node_get_style (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = style_get_link_width (_tmp18_);
	_tmp20_ = _tmp19_;
	cairo_set_line_width (ctx, *_tmp20_);
	_tmp21_ = node_get_side ((Node*) self);
	_tmp22_ = _tmp21_;
	switch (_tmp22_) {
		case NODE_SIDE_LEFT:
		{
			summary_node_draw_link_left (self, ctx);
			break;
		}
		case NODE_SIDE_RIGHT:
		{
			summary_node_draw_link_right (self, ctx);
			break;
		}
		case NODE_SIDE_TOP:
		{
			summary_node_draw_link_above (self, ctx);
			break;
		}
		case NODE_SIDE_BOTTOM:
		{
			summary_node_draw_link_below (self, ctx);
			break;
		}
		default:
		break;
	}
	__vala_GdkRGBA_free0 (color);
}

gboolean
summary_node_get_attachable (SummaryNode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_attachable;
	return result;
}

void
summary_node_set_attachable (SummaryNode* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = summary_node_get_attachable (self);
	if (old_value != value) {
		self->priv->_attachable = value;
		g_object_notify_by_pspec ((GObject *) self, summary_node_properties[SUMMARY_NODE_ATTACHABLE_PROPERTY]);
	}
}

Node*
summary_node_get_last_selected_node (SummaryNode* self)
{
	Node* result;
	Node* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_selected_node;
	result = _tmp0_;
	return result;
}

void
summary_node_set_last_selected_node (SummaryNode* self,
                                     Node* value)
{
	Node* old_value;
	g_return_if_fail (self != NULL);
	old_value = summary_node_get_last_selected_node (self);
	if (old_value != value) {
		Node* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_last_selected_node);
		self->priv->_last_selected_node = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, summary_node_properties[SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY]);
	}
}

static void
summary_node_class_init (SummaryNodeClass * klass,
                         gpointer klass_data)
{
	summary_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SummaryNode_private_offset);
	((NodeClass *) klass)->is_summary = (gboolean (*) (Node*)) summary_node_real_is_summary;
	((NodeClass *) klass)->detach = (void (*) (Node*, NodeSide)) summary_node_real_detach;
	((NodeClass *) klass)->delete = (void (*) (Node*)) summary_node_real_delete;
	((NodeClass *) klass)->draw_link = (void (*) (Node*, cairo_t*, Theme*)) summary_node_real_draw_link;
	G_OBJECT_CLASS (klass)->get_property = _vala_summary_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_summary_node_set_property;
	G_OBJECT_CLASS (klass)->finalize = summary_node_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUMMARY_NODE_ATTACHABLE_PROPERTY, summary_node_properties[SUMMARY_NODE_ATTACHABLE_PROPERTY] = g_param_spec_boolean ("attachable", "attachable", "attachable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY, summary_node_properties[SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY] = g_param_spec_object ("last-selected-node", "last-selected-node", "last-selected-node", TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
summary_node_instance_init (SummaryNode * self,
                            gpointer klass)
{
	self->priv = summary_node_get_instance_private (self);
	self->priv->_first_xy = NULL;
	self->priv->_last_xy = NULL;
	self->priv->_attachable = FALSE;
	self->priv->_last_selected_node = NULL;
}

static void
summary_node_finalize (GObject * obj)
{
	SummaryNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUMMARY_NODE, SummaryNode);
	(self->priv->_nodes == NULL) ? NULL : (self->priv->_nodes = (_g_list_free__g_object_unref0_ (self->priv->_nodes), NULL));
	_g_free0 (self->priv->_first_xy);
	_g_free0 (self->priv->_last_xy);
	_g_object_unref0 (self->priv->_last_selected_node);
	G_OBJECT_CLASS (summary_node_parent_class)->finalize (obj);
}

static GType
summary_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SummaryNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) summary_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SummaryNode), 0, (GInstanceInitFunc) summary_node_instance_init, NULL };
	GType summary_node_type_id;
	summary_node_type_id = g_type_register_static (TYPE_NODE, "SummaryNode", &g_define_type_info, 0);
	SummaryNode_private_offset = g_type_add_instance_private (summary_node_type_id, sizeof (SummaryNodePrivate));
	return summary_node_type_id;
}

GType
summary_node_get_type (void)
{
	static volatile gsize summary_node_type_id__once = 0;
	if (g_once_init_enter (&summary_node_type_id__once)) {
		GType summary_node_type_id;
		summary_node_type_id = summary_node_get_type_once ();
		g_once_init_leave (&summary_node_type_id__once, summary_node_type_id);
	}
	return summary_node_type_id__once;
}

static void
_vala_summary_node_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SummaryNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUMMARY_NODE, SummaryNode);
	switch (property_id) {
		case SUMMARY_NODE_ATTACHABLE_PROPERTY:
		g_value_set_boolean (value, summary_node_get_attachable (self));
		break;
		case SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY:
		g_value_set_object (value, summary_node_get_last_selected_node (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_summary_node_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SummaryNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUMMARY_NODE, SummaryNode);
	switch (property_id) {
		case SUMMARY_NODE_ATTACHABLE_PROPERTY:
		summary_node_set_attachable (self, g_value_get_boolean (value));
		break;
		case SUMMARY_NODE_LAST_SELECTED_NODE_PROPERTY:
		summary_node_set_last_selected_node (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

