/* DBusAccelerator.c generated by valac 0.56.18, the Vala compiler
 * generated from DBusAccelerator.vala, do not modify */

/*
 * Copyright 2015 Nicolas Bruguier, Corentin Noël
 * Copyright 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/prefs.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GREETER_COMPOSITOR_ACTION_MODE_NONE = 0,
	GREETER_COMPOSITOR_ACTION_MODE_NORMAL = 1 << 0,
	GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW = 1 << 1,
	GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN = 1 << 2,
	GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN = 1 << 3,
	GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN = 1 << 4,
	GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL = 1 << 5,
	GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS = 1 << 6,
	GREETER_COMPOSITOR_ACTION_MODE_POPUP = 1 << 7
} GreeterCompositorActionMode;

#define GREETER_COMPOSITOR_TYPE_ACTION_MODE (greeter_compositor_action_mode_get_type ())

#define GREETER_COMPOSITOR_TYPE_ACCELERATOR (greeter_compositor_accelerator_get_type ())
typedef struct _GreeterCompositorAccelerator GreeterCompositorAccelerator;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GreeterCompositorGrabbedAccelerator GreeterCompositorGrabbedAccelerator;

#define GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR (greeter_compositor_dbus_accelerator_get_type ())
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAccelerator))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))

typedef struct _GreeterCompositorDBusAccelerator GreeterCompositorDBusAccelerator;
typedef struct _GreeterCompositorDBusAcceleratorClass GreeterCompositorDBusAcceleratorClass;
typedef struct _GreeterCompositorDBusAcceleratorPrivate GreeterCompositorDBusAcceleratorPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _greeter_compositor_dbus_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_dbus_accelerator_unref (var), NULL)))
#define _greeter_compositor_grabbed_accelerator_free0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_grabbed_accelerator_free (var), NULL)))
typedef struct _GreeterCompositorParamSpecDBusAccelerator GreeterCompositorParamSpecDBusAccelerator;
enum  {
	GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL,
	GREETER_COMPOSITOR_DBUS_ACCELERATOR_NUM_SIGNALS
};
static guint greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_NUM_SIGNALS] = {0};

struct _GreeterCompositorAccelerator {
	gchar* name;
	GreeterCompositorActionMode flags;
	MetaKeyBindingFlags grab_flags;
};

struct _GreeterCompositorGrabbedAccelerator {
	gchar* name;
	GreeterCompositorActionMode flags;
	MetaKeyBindingFlags grab_flags;
	guint action;
};

struct _GreeterCompositorDBusAccelerator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GreeterCompositorDBusAcceleratorPrivate * priv;
};

struct _GreeterCompositorDBusAcceleratorClass {
	GTypeClass parent_class;
	void (*finalize) (GreeterCompositorDBusAccelerator *self);
};

struct _GreeterCompositorDBusAcceleratorPrivate {
	GreeterCompositorWindowManager* wm;
	GHashTable* grabbed_accelerators;
};

struct _GreeterCompositorParamSpecDBusAccelerator {
	GParamSpec parent_instance;
};

static gint GreeterCompositorDBusAccelerator_private_offset;
static gpointer greeter_compositor_dbus_accelerator_parent_class = NULL;
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_instance;
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_instance = NULL;

VALA_EXTERN GType greeter_compositor_action_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType greeter_compositor_accelerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorAccelerator* greeter_compositor_accelerator_dup (const GreeterCompositorAccelerator* self);
VALA_EXTERN void greeter_compositor_accelerator_free (GreeterCompositorAccelerator* self);
VALA_EXTERN void greeter_compositor_accelerator_copy (const GreeterCompositorAccelerator* self,
                                          GreeterCompositorAccelerator* dest);
VALA_EXTERN void greeter_compositor_accelerator_destroy (GreeterCompositorAccelerator* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GreeterCompositorAccelerator, greeter_compositor_accelerator_destroy)
VALA_EXTERN void greeter_compositor_grabbed_accelerator_free (GreeterCompositorGrabbedAccelerator * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorGrabbedAccelerator, greeter_compositor_grabbed_accelerator_free)
static void greeter_compositor_grabbed_accelerator_instance_init (GreeterCompositorGrabbedAccelerator * self);
VALA_EXTERN GreeterCompositorGrabbedAccelerator* greeter_compositor_grabbed_accelerator_new (void);
VALA_EXTERN gpointer greeter_compositor_dbus_accelerator_ref (gpointer instance);
VALA_EXTERN void greeter_compositor_dbus_accelerator_unref (gpointer instance);
VALA_EXTERN GParamSpec* greeter_compositor_param_spec_dbus_accelerator (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags);
VALA_EXTERN void greeter_compositor_value_set_dbus_accelerator (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN void greeter_compositor_value_take_dbus_accelerator (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN gpointer greeter_compositor_value_get_dbus_accelerator (const GValue* value);
VALA_EXTERN GType greeter_compositor_dbus_accelerator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorDBusAccelerator, greeter_compositor_dbus_accelerator_unref)
VALA_EXTERN guint greeter_compositor_dbus_accelerator_register_object (void* object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_init (GreeterCompositorWindowManager* wm);
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_new (GreeterCompositorWindowManager* _wm);
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_construct (GType object_type,
                                                                                 GreeterCompositorWindowManager* _wm);
static void _greeter_compositor_grabbed_accelerator_free0_ (gpointer var);
static void greeter_compositor_dbus_accelerator_on_accelerator_activated (GreeterCompositorDBusAccelerator* self,
                                                                   guint action,
                                                                   ClutterInputDevice* device,
                                                                   guint timestamp);
static void _greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                                       guint object,
                                                                                                       ClutterInputDevice* p0,
                                                                                                       guint p1,
                                                                                                       gpointer self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN guint greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                            const gchar* accelerator,
                                                            GreeterCompositorActionMode flags,
                                                            MetaKeyBindingFlags grab_flags,
                                                            GError** error);
VALA_EXTERN guint* greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                              GreeterCompositorAccelerator* accelerators,
                                                              gint accelerators_length1,
                                                              gint* result_length1,
                                                              GError** error);
static void _vala_array_add4 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
VALA_EXTERN gboolean greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                                 guint action,
                                                                 GError** error);
VALA_EXTERN gboolean greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                  guint* actions,
                                                                  gint actions_length1,
                                                                  GError** error);
VALA_EXTERN void greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                   GHashTable* parameters,
                                                   GError** error);
VALA_EXTERN void greeter_compositor_media_feedback_send (const gchar* icon,
                                             gint val);
static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void greeter_compositor_dbus_accelerator_finalize (GreeterCompositorDBusAccelerator * obj);
static GType greeter_compositor_dbus_accelerator_get_type_once (void);
static void _dbus_greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                                 GVariant* _parameters_,
                                                                 GDBusMethodInvocation* invocation);
static void _vala_GreeterCompositorAccelerator_array_free (GreeterCompositorAccelerator * array,
                                                    gssize array_length);
static void _dbus_greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                    GVariant* _parameters_,
                                                                    GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void greeter_compositor_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* method_name,
                                                                     GVariant* parameters,
                                                                     GDBusMethodInvocation* invocation,
                                                                     gpointer user_data);
static GVariant* greeter_compositor_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GError** error,
                                                                           gpointer user_data);
static gboolean greeter_compositor_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GVariant* value,
                                                                          GError** error,
                                                                          gpointer user_data);
static void _dbus_greeter_compositor_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                                      guint action,
                                                                      GHashTable* parameters,
                                                                      gpointer* _data);
static void _greeter_compositor_dbus_accelerator_unregister_object (gpointer user_data);

static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_accelerator = {-1, "accelerator", "s", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_grab_flags = {-1, "grab_flags", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_accelerator, &_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_flags, &_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_grab_flags, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerator = {-1, "GrabAccelerator", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerator_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators = {-1, "accelerators", "a(suu)", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_result = {-1, "result", "au", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerators = {-1, "GrabAccelerators", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerator = {-1, "UngrabAccelerator", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions = {-1, "actions", "au", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerators = {-1, "UngrabAccelerators", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_parameters, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_out[] = {NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_show_osd = {-1, "ShowOSD", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_out), NULL};
static const GDBusMethodInfo * const _greeter_compositor_dbus_accelerator_dbus_method_info[] = {&_greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerator, &_greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerators, &_greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerator, &_greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerators, &_greeter_compositor_dbus_accelerator_dbus_method_info_show_osd, NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_action, &_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters, NULL};
static const GDBusSignalInfo _greeter_compositor_dbus_accelerator_dbus_signal_info_accelerator_activated = {-1, "AcceleratorActivated", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated), NULL};
static const GDBusSignalInfo * const _greeter_compositor_dbus_accelerator_dbus_signal_info[] = {&_greeter_compositor_dbus_accelerator_dbus_signal_info_accelerator_activated, NULL};
static const GDBusPropertyInfo * const _greeter_compositor_dbus_accelerator_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _greeter_compositor_dbus_accelerator_dbus_interface_info = {-1, "org.gnome.Shell", (GDBusMethodInfo **) (&_greeter_compositor_dbus_accelerator_dbus_method_info), (GDBusSignalInfo **) (&_greeter_compositor_dbus_accelerator_dbus_signal_info), (GDBusPropertyInfo **) (&_greeter_compositor_dbus_accelerator_dbus_property_info), NULL};
static const GDBusInterfaceVTable _greeter_compositor_dbus_accelerator_dbus_interface_vtable = {greeter_compositor_dbus_accelerator_dbus_interface_method_call, greeter_compositor_dbus_accelerator_dbus_interface_get_property, greeter_compositor_dbus_accelerator_dbus_interface_set_property};

/**
     * ActionMode:
     * @NONE: block action
     * @NORMAL: allow action when in window mode, e.g. when the focus is in an application window
     * @OVERVIEW: allow action while the overview is active
     * @LOCK_SCREEN: allow action when the screen is locked, e.g. when the screen shield is shown
     * @UNLOCK_SCREEN: allow action in the unlock dialog
     * @LOGIN_SCREEN: allow action in the login screen
     * @SYSTEM_MODAL: allow action when a system modal dialog (e.g. authentification or session dialogs) is open
     * @LOOKING_GLASS: allow action in looking glass
     * @POPUP: allow action while a shell menu is open
     */
static GType
greeter_compositor_action_mode_get_type_once (void)
{
	static const GFlagsValue values[] = {{GREETER_COMPOSITOR_ACTION_MODE_NONE, "GREETER_COMPOSITOR_ACTION_MODE_NONE", "none"}, {GREETER_COMPOSITOR_ACTION_MODE_NORMAL, "GREETER_COMPOSITOR_ACTION_MODE_NORMAL", "normal"}, {GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW, "GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW", "overview"}, {GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN", "lock-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN", "unlock-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN", "login-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL, "GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL", "system-modal"}, {GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS, "GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS", "looking-glass"}, {GREETER_COMPOSITOR_ACTION_MODE_POPUP, "GREETER_COMPOSITOR_ACTION_MODE_POPUP", "popup"}, {0, NULL, NULL}};
	GType greeter_compositor_action_mode_type_id;
	greeter_compositor_action_mode_type_id = g_flags_register_static ("GreeterCompositorActionMode", values);
	return greeter_compositor_action_mode_type_id;
}

GType
greeter_compositor_action_mode_get_type (void)
{
	static volatile gsize greeter_compositor_action_mode_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_action_mode_type_id__once)) {
		GType greeter_compositor_action_mode_type_id;
		greeter_compositor_action_mode_type_id = greeter_compositor_action_mode_get_type_once ();
		g_once_init_leave (&greeter_compositor_action_mode_type_id__once, greeter_compositor_action_mode_type_id);
	}
	return greeter_compositor_action_mode_type_id__once;
}

void
greeter_compositor_accelerator_copy (const GreeterCompositorAccelerator* self,
                                     GreeterCompositorAccelerator* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).flags = (*self).flags;
	(*dest).grab_flags = (*self).grab_flags;
}

void
greeter_compositor_accelerator_destroy (GreeterCompositorAccelerator* self)
{
	_g_free0 ((*self).name);
}

GreeterCompositorAccelerator*
greeter_compositor_accelerator_dup (const GreeterCompositorAccelerator* self)
{
	GreeterCompositorAccelerator* dup;
	dup = g_new0 (GreeterCompositorAccelerator, 1);
	greeter_compositor_accelerator_copy (self, dup);
	return dup;
}

void
greeter_compositor_accelerator_free (GreeterCompositorAccelerator* self)
{
	greeter_compositor_accelerator_destroy (self);
	g_free (self);
}

static GType
greeter_compositor_accelerator_get_type_once (void)
{
	GType greeter_compositor_accelerator_type_id;
	greeter_compositor_accelerator_type_id = g_boxed_type_register_static ("GreeterCompositorAccelerator", (GBoxedCopyFunc) greeter_compositor_accelerator_dup, (GBoxedFreeFunc) greeter_compositor_accelerator_free);
	return greeter_compositor_accelerator_type_id;
}

GType
greeter_compositor_accelerator_get_type (void)
{
	static volatile gsize greeter_compositor_accelerator_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_accelerator_type_id__once)) {
		GType greeter_compositor_accelerator_type_id;
		greeter_compositor_accelerator_type_id = greeter_compositor_accelerator_get_type_once ();
		g_once_init_leave (&greeter_compositor_accelerator_type_id__once, greeter_compositor_accelerator_type_id);
	}
	return greeter_compositor_accelerator_type_id__once;
}

GreeterCompositorGrabbedAccelerator*
greeter_compositor_grabbed_accelerator_new (void)
{
	GreeterCompositorGrabbedAccelerator* self;
	self = g_slice_new0 (GreeterCompositorGrabbedAccelerator);
	greeter_compositor_grabbed_accelerator_instance_init (self);
	return self;
}

static void
greeter_compositor_grabbed_accelerator_instance_init (GreeterCompositorGrabbedAccelerator * self)
{
}

void
greeter_compositor_grabbed_accelerator_free (GreeterCompositorGrabbedAccelerator * self)
{
	_g_free0 (self->name);
	g_slice_free (GreeterCompositorGrabbedAccelerator, self);
}

static inline gpointer
greeter_compositor_dbus_accelerator_get_instance_private (GreeterCompositorDBusAccelerator* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorDBusAccelerator_private_offset);
}

GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_init (GreeterCompositorWindowManager* wm)
{
	GreeterCompositorDBusAccelerator* _tmp0_;
	GreeterCompositorDBusAccelerator* _tmp2_;
	GreeterCompositorDBusAccelerator* result;
	g_return_val_if_fail (wm != NULL, NULL);
	_tmp0_ = greeter_compositor_dbus_accelerator_instance;
	if (_tmp0_ == NULL) {
		GreeterCompositorDBusAccelerator* _tmp1_;
		_tmp1_ = greeter_compositor_dbus_accelerator_new (wm);
		_greeter_compositor_dbus_accelerator_unref0 (greeter_compositor_dbus_accelerator_instance);
		greeter_compositor_dbus_accelerator_instance = _tmp1_;
	}
	_tmp2_ = greeter_compositor_dbus_accelerator_instance;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_greeter_compositor_grabbed_accelerator_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (greeter_compositor_grabbed_accelerator_free (var), NULL));
}

static void
_greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                                  guint object,
                                                                                                  ClutterInputDevice* p0,
                                                                                                  guint p1,
                                                                                                  gpointer self)
{
	greeter_compositor_dbus_accelerator_on_accelerator_activated ((GreeterCompositorDBusAccelerator*) self, object, p0, p1);
}

static GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_construct (GType object_type,
                                               GreeterCompositorWindowManager* _wm)
{
	GreeterCompositorDBusAccelerator* self = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GreeterCompositorWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	g_return_val_if_fail (_wm != NULL, NULL);
	self = (GreeterCompositorDBusAccelerator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (self->priv->wm);
	self->priv->wm = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _greeter_compositor_grabbed_accelerator_free0_);
	_g_hash_table_unref0 (self->priv->grabbed_accelerators);
	self->priv->grabbed_accelerators = _tmp3_;
	_tmp4_ = self->priv->wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	g_signal_connect (_tmp5_, "accelerator-activated", (GCallback) _greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated, self);
	return self;
}

static GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_new (GreeterCompositorWindowManager* _wm)
{
	return greeter_compositor_dbus_accelerator_construct (GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, _wm);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
greeter_compositor_dbus_accelerator_on_accelerator_activated (GreeterCompositorDBusAccelerator* self,
                                                              guint action,
                                                              ClutterInputDevice* device,
                                                              guint timestamp)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* accel_collection = NULL;
		GList* accel_it = NULL;
		accel_collection = _tmp1_;
		for (accel_it = accel_collection; accel_it != NULL; accel_it = accel_it->next) {
			GreeterCompositorGrabbedAccelerator* accel = NULL;
			accel = (GreeterCompositorGrabbedAccelerator*) accel_it->data;
			{
				GreeterCompositorGrabbedAccelerator* _tmp2_;
				_tmp2_ = accel;
				if (_tmp2_->action == action) {
					GreeterCompositorGrabbedAccelerator* _tmp3_;
					_tmp3_ = accel;
					if ((_tmp3_->flags & GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN) == GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN) {
						GHashTable* parameters = NULL;
						GHashTable* _tmp4_;
						GHashTable* _tmp5_;
						gchar* _tmp6_;
						GVariant* _tmp7_;
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						GHashTable* _tmp15_;
						_tmp4_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
						parameters = _tmp4_;
						_tmp5_ = parameters;
						_tmp6_ = g_strdup ("timestamp");
						_tmp7_ = g_variant_new_uint32 ((guint32) timestamp);
						g_variant_ref_sink (_tmp7_);
						g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
						_tmp8_ = clutter_input_device_get_device_node (device);
						_tmp9_ = _tmp8_;
						if (_tmp9_ != NULL) {
							GHashTable* _tmp10_;
							gchar* _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							GVariant* _tmp14_;
							_tmp10_ = parameters;
							_tmp11_ = g_strdup ("device-node");
							_tmp12_ = clutter_input_device_get_device_node (device);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_variant_new_string (_tmp13_);
							g_variant_ref_sink (_tmp14_);
							g_hash_table_insert (_tmp10_, _tmp11_, _tmp14_);
						}
						_tmp15_ = parameters;
						g_signal_emit (self, greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL], 0, action, _tmp15_);
						_g_hash_table_unref0 (parameters);
					}
					(accel_collection == NULL) ? NULL : (accel_collection = (g_list_free (accel_collection), NULL));
					return;
				}
			}
		}
		(accel_collection == NULL) ? NULL : (accel_collection = (g_list_free (accel_collection), NULL));
	}
}

guint
greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                      const gchar* accelerator,
                                                      GreeterCompositorActionMode flags,
                                                      MetaKeyBindingFlags grab_flags,
                                                      GError** error)
{
	GreeterCompositorGrabbedAccelerator* found_accel = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GreeterCompositorGrabbedAccelerator* _tmp2_;
	guint action = 0U;
	GreeterCompositorWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (accelerator != NULL, 0U);
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_lookup (_tmp0_, accelerator);
	found_accel = (GreeterCompositorGrabbedAccelerator*) _tmp1_;
	_tmp2_ = found_accel;
	if (_tmp2_ != NULL) {
		GreeterCompositorGrabbedAccelerator* _tmp3_;
		_tmp3_ = found_accel;
		result = _tmp3_->action;
		return result;
	}
	_tmp4_ = self->priv->wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	action = meta_display_grab_accelerator (_tmp5_, accelerator, grab_flags);
	if (action != ((guint) META_KEY_BINDING_NONE)) {
		GreeterCompositorGrabbedAccelerator* accel = NULL;
		GreeterCompositorGrabbedAccelerator* _tmp6_;
		GreeterCompositorGrabbedAccelerator* _tmp7_;
		GreeterCompositorGrabbedAccelerator* _tmp8_;
		gchar* _tmp9_;
		GreeterCompositorGrabbedAccelerator* _tmp10_;
		GreeterCompositorGrabbedAccelerator* _tmp11_;
		GHashTable* _tmp12_;
		GreeterCompositorGrabbedAccelerator* _tmp13_;
		const gchar* _tmp14_;
		GreeterCompositorGrabbedAccelerator* _tmp15_;
		_tmp6_ = greeter_compositor_grabbed_accelerator_new ();
		accel = _tmp6_;
		_tmp7_ = accel;
		_tmp7_->action = action;
		_tmp8_ = accel;
		_tmp9_ = g_strdup (accelerator);
		_g_free0 (_tmp8_->name);
		_tmp8_->name = _tmp9_;
		_tmp10_ = accel;
		_tmp10_->flags = flags;
		_tmp11_ = accel;
		_tmp11_->grab_flags = grab_flags;
		_tmp12_ = self->priv->grabbed_accelerators;
		_tmp13_ = accel;
		_tmp14_ = _tmp13_->name;
		_tmp15_ = accel;
		accel = NULL;
		g_hash_table_insert (_tmp12_, _tmp14_, _tmp15_);
		_greeter_compositor_grabbed_accelerator_free0 (accel);
	}
	result = action;
	return result;
}

static void
_vala_array_add4 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

guint*
greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                       GreeterCompositorAccelerator* accelerators,
                                                       gint accelerators_length1,
                                                       gint* result_length1,
                                                       GError** error)
{
	guint* actions = NULL;
	guint* _tmp0_;
	gint actions_length1;
	gint _actions_size_;
	guint* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	guint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint, 0);
	actions = _tmp0_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	{
		GreeterCompositorAccelerator* accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = accelerators;
		accelerator_collection_length1 = accelerators_length1;
		for (accelerator_it = 0; accelerator_it < accelerator_collection_length1; accelerator_it = accelerator_it + 1) {
			GreeterCompositorAccelerator accelerator = {0};
			accelerator = accelerator_collection[accelerator_it];
			{
				guint _tmp1_ = 0U;
				GreeterCompositorAccelerator _tmp2_;
				const gchar* _tmp3_;
				GreeterCompositorAccelerator _tmp4_;
				GreeterCompositorAccelerator _tmp5_;
				_tmp2_ = accelerator;
				_tmp3_ = _tmp2_.name;
				_tmp4_ = accelerator;
				_tmp5_ = accelerator;
				_tmp1_ = greeter_compositor_dbus_accelerator_grab_accelerator (self, _tmp3_, _tmp4_.flags, _tmp5_.grab_flags, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
						g_propagate_error (error, _inner_error0_);
						actions = (g_free (actions), NULL);
						return NULL;
					} else {
						actions = (g_free (actions), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_vala_array_add4 (&actions, &actions_length1, &_actions_size_, _tmp1_);
			}
		}
	}
	_tmp6_ = actions;
	_tmp6__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gboolean
greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                        guint action,
                                                        GError** error)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* accel_collection = NULL;
		GList* accel_it = NULL;
		accel_collection = _tmp1_;
		for (accel_it = accel_collection; accel_it != NULL; accel_it = accel_it->next) {
			GreeterCompositorGrabbedAccelerator* accel = NULL;
			accel = (GreeterCompositorGrabbedAccelerator*) accel_it->data;
			{
				GreeterCompositorGrabbedAccelerator* _tmp2_;
				_tmp2_ = accel;
				if (_tmp2_->action == action) {
					gboolean ret = FALSE;
					GreeterCompositorWindowManager* _tmp3_;
					MetaDisplay* _tmp4_;
					GHashTable* _tmp5_;
					GreeterCompositorGrabbedAccelerator* _tmp6_;
					const gchar* _tmp7_;
					_tmp3_ = self->priv->wm;
					_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
					ret = meta_display_ungrab_accelerator (_tmp4_, action);
					_tmp5_ = self->priv->grabbed_accelerators;
					_tmp6_ = accel;
					_tmp7_ = _tmp6_->name;
					g_hash_table_remove (_tmp5_, _tmp7_);
					result = ret;
					(accel_collection == NULL) ? NULL : (accel_collection = (g_list_free (accel_collection), NULL));
					return result;
				}
			}
		}
		(accel_collection == NULL) ? NULL : (accel_collection = (g_list_free (accel_collection), NULL));
	}
	result = FALSE;
	return result;
}

gboolean
greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                         guint* actions,
                                                         gint actions_length1,
                                                         GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint* action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = actions;
		action_collection_length1 = actions_length1;
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			guint action = 0U;
			action = action_collection[action_it];
			{
				greeter_compositor_dbus_accelerator_ungrab_accelerator (self, action, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
						gboolean _tmp0_ = FALSE;
						g_propagate_error (error, _inner_error0_);
						return _tmp0_;
					} else {
						gboolean _tmp1_ = FALSE;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp1_;
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

void
greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                              GHashTable* parameters,
                                              GError** error)
{
	gint32 monitor_index = 0;
	gchar* icon = NULL;
	gchar* _tmp1_;
	gchar* label = NULL;
	gchar* _tmp5_;
	gint32 level = 0;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameters != NULL);
	monitor_index = (gint32) -1;
	if (g_hash_table_contains (parameters, "monitor")) {
		gconstpointer _tmp0_;
		_tmp0_ = g_hash_table_lookup (parameters, "monitor");
		monitor_index = g_variant_get_int32 ((GVariant*) _tmp0_);
	}
	_tmp1_ = g_strdup ("");
	icon = _tmp1_;
	if (g_hash_table_contains (parameters, "icon")) {
		gconstpointer _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_hash_table_lookup (parameters, "icon");
		_tmp3_ = g_variant_get_string ((GVariant*) _tmp2_, NULL);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (icon);
		icon = _tmp4_;
	}
	_tmp5_ = g_strdup ("");
	label = _tmp5_;
	if (g_hash_table_contains (parameters, "label")) {
		gconstpointer _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_hash_table_lookup (parameters, "label");
		_tmp7_ = g_variant_get_string ((GVariant*) _tmp6_, NULL);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (label);
		label = _tmp8_;
	}
	level = (gint32) 0;
	if (g_hash_table_contains (parameters, "level")) {
		gdouble double_level = 0.0;
		gconstpointer _tmp9_;
		_tmp9_ = g_hash_table_lookup (parameters, "level");
		double_level = g_variant_get_double ((GVariant*) _tmp9_);
		level = (gint32) ((gint) (double_level * 100));
	}
	_tmp10_ = icon;
	greeter_compositor_media_feedback_send (_tmp10_, (gint) level);
	_g_free0 (label);
	_g_free0 (icon);
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
greeter_compositor_value_dbus_accelerator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
greeter_compositor_value_dbus_accelerator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		greeter_compositor_dbus_accelerator_unref (value->data[0].v_pointer);
	}
}

static void
greeter_compositor_value_dbus_accelerator_copy_value (const GValue* src_value,
                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = greeter_compositor_dbus_accelerator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
greeter_compositor_value_dbus_accelerator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
greeter_compositor_value_dbus_accelerator_collect_value (GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GreeterCompositorDBusAccelerator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = greeter_compositor_dbus_accelerator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
greeter_compositor_value_dbus_accelerator_lcopy_value (const GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	GreeterCompositorDBusAccelerator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = greeter_compositor_dbus_accelerator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
greeter_compositor_param_spec_dbus_accelerator (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags)
{
	GreeterCompositorParamSpecDBusAccelerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
greeter_compositor_value_get_dbus_accelerator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR), NULL);
	return value->data[0].v_pointer;
}

void
greeter_compositor_value_set_dbus_accelerator (GValue* value,
                                               gpointer v_object)
{
	GreeterCompositorDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		greeter_compositor_dbus_accelerator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_dbus_accelerator_unref (old);
	}
}

void
greeter_compositor_value_take_dbus_accelerator (GValue* value,
                                                gpointer v_object)
{
	GreeterCompositorDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_dbus_accelerator_unref (old);
	}
}

static void
greeter_compositor_dbus_accelerator_class_init (GreeterCompositorDBusAcceleratorClass * klass,
                                                gpointer klass_data)
{
	greeter_compositor_dbus_accelerator_parent_class = g_type_class_peek_parent (klass);
	((GreeterCompositorDBusAcceleratorClass *) klass)->finalize = greeter_compositor_dbus_accelerator_finalize;
	g_type_class_adjust_private_offset (klass, &GreeterCompositorDBusAccelerator_private_offset);
	greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL] = g_signal_new ("accelerator-activated", GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_HASH_TABLE);
}

static void
greeter_compositor_dbus_accelerator_instance_init (GreeterCompositorDBusAccelerator * self,
                                                   gpointer klass)
{
	self->priv = greeter_compositor_dbus_accelerator_get_instance_private (self);
	self->ref_count = 1;
}

static void
greeter_compositor_dbus_accelerator_finalize (GreeterCompositorDBusAccelerator * obj)
{
	GreeterCompositorDBusAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAccelerator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->wm);
	_g_hash_table_unref0 (self->priv->grabbed_accelerators);
}

static GType
greeter_compositor_dbus_accelerator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { greeter_compositor_value_dbus_accelerator_init, greeter_compositor_value_dbus_accelerator_free_value, greeter_compositor_value_dbus_accelerator_copy_value, greeter_compositor_value_dbus_accelerator_peek_pointer, "p", greeter_compositor_value_dbus_accelerator_collect_value, "p", greeter_compositor_value_dbus_accelerator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorDBusAcceleratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_dbus_accelerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorDBusAccelerator), 0, (GInstanceInitFunc) greeter_compositor_dbus_accelerator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType greeter_compositor_dbus_accelerator_type_id;
	greeter_compositor_dbus_accelerator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GreeterCompositorDBusAccelerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (greeter_compositor_dbus_accelerator_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) greeter_compositor_dbus_accelerator_register_object);
	GreeterCompositorDBusAccelerator_private_offset = g_type_add_instance_private (greeter_compositor_dbus_accelerator_type_id, sizeof (GreeterCompositorDBusAcceleratorPrivate));
	return greeter_compositor_dbus_accelerator_type_id;
}

GType
greeter_compositor_dbus_accelerator_get_type (void)
{
	static volatile gsize greeter_compositor_dbus_accelerator_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_dbus_accelerator_type_id__once)) {
		GType greeter_compositor_dbus_accelerator_type_id;
		greeter_compositor_dbus_accelerator_type_id = greeter_compositor_dbus_accelerator_get_type_once ();
		g_once_init_leave (&greeter_compositor_dbus_accelerator_type_id__once, greeter_compositor_dbus_accelerator_type_id);
	}
	return greeter_compositor_dbus_accelerator_type_id__once;
}

gpointer
greeter_compositor_dbus_accelerator_ref (gpointer instance)
{
	GreeterCompositorDBusAccelerator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
greeter_compositor_dbus_accelerator_unref (gpointer instance)
{
	GreeterCompositorDBusAccelerator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GREETER_COMPOSITOR_DBUS_ACCELERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* accelerator = NULL;
	GVariant* _tmp8_;
	GreeterCompositorActionMode flags = 0U;
	GVariant* _tmp9_;
	MetaKeyBindingFlags grab_flags = 0U;
	GVariant* _tmp10_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	accelerator = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp9_);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	grab_flags = g_variant_get_uint32 (_tmp10_);
	g_variant_unref (_tmp10_);
	result = greeter_compositor_dbus_accelerator_grab_accelerator (self, accelerator, flags, grab_flags, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (accelerator);
	;
}

static void
_vala_GreeterCompositorAccelerator_array_free (GreeterCompositorAccelerator * array,
                                               gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			greeter_compositor_accelerator_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GreeterCompositorAccelerator* accelerators = NULL;
	gint accelerators_length1 = 0;
	GVariant* _tmp11_;
	GreeterCompositorAccelerator* _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	gint result_length1 = 0;
	guint* _tmp20_;
	GVariantBuilder _tmp21_;
	gint _tmp22_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (GreeterCompositorAccelerator, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		GreeterCompositorAccelerator _tmp15_;
		GVariantIter _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		GVariant* _tmp19_;
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (GreeterCompositorAccelerator, _tmp12_, _tmp12__size + 1);
		}
		g_variant_iter_init (&_tmp16_, _tmp14_);
		_tmp17_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.name = g_variant_dup_string (_tmp17_, NULL);
		g_variant_unref (_tmp17_);
		_tmp18_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.flags = g_variant_get_uint32 (_tmp18_);
		g_variant_unref (_tmp18_);
		_tmp19_ = g_variant_iter_next_value (&_tmp16_);
		_tmp15_.grab_flags = g_variant_get_uint32 (_tmp19_);
		g_variant_unref (_tmp19_);
		_tmp12_[_tmp12__length++] = _tmp15_;
		g_variant_unref (_tmp14_);
	}
	accelerators_length1 = _tmp12__length1;
	accelerators = _tmp12_;
	g_variant_unref (_tmp11_);
	result = greeter_compositor_dbus_accelerator_grab_accelerators (self, accelerators, accelerators_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp20_ = result;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("au"));
	for (_tmp22_ = 0; _tmp22_ < result_length1; _tmp22_++) {
		g_variant_builder_add_value (&_tmp21_, g_variant_new_uint32 (*_tmp20_));
		_tmp20_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp21_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	accelerators = (_vala_GreeterCompositorAccelerator_array_free (accelerators, accelerators_length1), NULL);
	;
}

static void
_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint action = 0U;
	GVariant* _tmp23_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_uint32 (_tmp23_);
	g_variant_unref (_tmp23_);
	result = greeter_compositor_dbus_accelerator_ungrab_accelerator (self, action, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint* actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp24_;
	guint* _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp25_ = g_new (guint, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (guint, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_get_uint32 (_tmp27_);
		g_variant_unref (_tmp27_);
	}
	actions_length1 = _tmp25__length1;
	actions = _tmp25_;
	g_variant_unref (_tmp24_);
	result = greeter_compositor_dbus_accelerator_ungrab_accelerators (self, actions, actions_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	actions = (g_free (actions), NULL);
	;
}

static void
_dbus_greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* parameters = NULL;
	GVariant* _tmp28_;
	GHashTable* _tmp29_;
	GVariantIter _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp29_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp30_, _tmp28_);
	while (g_variant_iter_loop (&_tmp30_, "{?*}", &_tmp31_, &_tmp32_)) {
		g_hash_table_insert (_tmp29_, g_variant_dup_string (_tmp31_, NULL), g_variant_get_variant (_tmp32_));
	}
	parameters = _tmp29_;
	g_variant_unref (_tmp28_);
	greeter_compositor_dbus_accelerator_show_osd (self, parameters, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (parameters);
	;
}

static void
greeter_compositor_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GrabAccelerator") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_grab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "GrabAccelerators") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_grab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerator") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerators") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_show_osd (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
greeter_compositor_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
greeter_compositor_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_greeter_compositor_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                                 guint action,
                                                                 GHashTable* parameters,
                                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp33_;
	GHashTableIter _tmp34_;
	gpointer _tmp35_;
	gpointer _tmp36_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action));
	g_hash_table_iter_init (&_tmp34_, parameters);
	g_variant_builder_init (&_tmp33_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp34_, &_tmp35_, &_tmp36_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp35_;
		_value = (GVariant*) _tmp36_;
		g_variant_builder_add (&_tmp33_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp33_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Shell", "AcceleratorActivated", _arguments, NULL);
}

guint
greeter_compositor_dbus_accelerator_register_object (gpointer object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = greeter_compositor_dbus_accelerator_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_greeter_compositor_dbus_accelerator_dbus_interface_info), &_greeter_compositor_dbus_accelerator_dbus_interface_vtable, data, _greeter_compositor_dbus_accelerator_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "accelerator-activated", (GCallback) _dbus_greeter_compositor_dbus_accelerator_accelerator_activated, data);
	return result;
}

static void
_greeter_compositor_dbus_accelerator_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_greeter_compositor_dbus_accelerator_accelerator_activated, data);
	greeter_compositor_dbus_accelerator_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

