/* !! This file is auto-generated, do not edit !! */


#define N_SVGSCRIPT_FRAGMENTS 111

static const char aSVGScript0[] =
"<![CDATA[\n\
\n\
\n\
(function(window, document, exportName, undefined) {\n\
'use strict';\n\
\n\
var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];\n\
var TEST_ELEMENT = document.createElement('div');\n\
\n\
var TYPE_FUNCTION = 'function';\n\
\n\
var round = Math.round;\n\
var abs = Math.abs;\n\
var now = Date.now;\n\
\n\
if (!Math.trunc) {\n\
Math.trunc = function (v) {\n\
return v < 0 ? Math.ceil(v) : Math.floor(v);\n\
};\n\
}\n\
\n\
function setTimeoutContext(fn, timeout, context) {\n\
return setTimeout(bindFn(fn, context), timeout);\n\
}\n\
\n\
function invokeArrayArg(arg, fn, context) {\n\
if (Array.isArray(arg)) {\n\
each(arg, context[fn], context);\n\
return true;\n\
}\n\
return false;\n\
}\n\
\n\
function each(obj, iterator, context) {\n\
var i;\n\
\n\
if (!obj) {\n\
return;\n\
}\n\
\n\
if (obj.forEach) {\n\
obj.forEach(iterator, context);\n\
} else if (obj.length !== undefined) {\n\
i = 0;\n\
while (i < obj.length) {\n\
iterator.call(context, obj[i], i, obj);\n\
i++;\n\
}\n\
} else {\n\
for (i in obj) {\n\
obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);\n\
}\n\
}\n\
}\n\
\n\
function deprecate(method, name, message) {\n\
var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\\n' + message + ' AT \\n';\n\
return function() {\n\
var e = new Error('get-stack-trace');\n\
var stack = e && e.stack ? e.stack.replace(/^[^\\(]+?[\\n$]/gm, '')\n\
.replace(/^\\s+at\\s+/gm, '')\n\
.replace(/^Object.<anonymous>\\s*\\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';\n\
\n\
var log = window.console && (window.console.warn || window.console.log);\n\
if (log) {\n\
log.call(window.console, deprecationMessage, stack);\n\
}\n\
return method.apply(this, arguments);\n\
};\n\
}\n\
\n\
var assign;\n\
if (typeof Object.assign !== 'function') {\n\
assign = function assign(target) {\n\
if (target === undefined || target === null) {\n\
throw new TypeError('Cannot convert undefined or null to object');\n\
}\n\
\n\
var output = Object(target);\n\
for (var index = 1; index < arguments.length; index++) {\n\
var source = arguments[index];\n\
if (source !== undefined && source !== null) {\n\
for (var nextKey in source) {\n\
if (source.hasOwnProperty(nextKey)) {\n\
output[nextKey] = source[nextKey];\n\
}\n\
}\n\
}\n\
}\n\
return output;\n\
};\n\
} else {\n\
assign = Object.assign;\n\
}\n\
\n\
var extend = deprecate(function extend(dest, src, merge) {\n\
var keys = Object.keys(src);\n\
var i = 0;\n\
while (i < keys.length) {\n\
if (!merge || (merge && dest[keys[i]] === undefined)) {\n\
dest[keys[i]] = src[keys[i]];\n\
}\n\
i++;\n\
}\n\
return dest;\n\
}, 'extend', 'Use `assign`.');\n\
\n\
var merge = deprecate(function merge(dest, src) {\n\
return extend(dest, src, true);\n\
}, 'merge', 'Use `assign`.');\n\
\n\
function inherit(child, base, properties) {\n\
var baseP = base.prototype,\n\
childP;\n\
\n\
childP = child.prototype = Object.create(baseP);\n\
childP.constructor = child;\n\
childP._super = baseP;\n\
\n\
if (properties) {\n\
assign(childP, properties);\n\
}\n\
}\n\
\n\
function bindFn(fn, context) {\n\
return function boundFn() {\n\
return fn.apply(context, arguments);\n\
};\n\
}\n\
\n\
function boolOrFn(val, args) {\n\
if (typeof val == TYPE_FUNCTION) {\n\
return val.apply(args ? args[0] || undefined : undefined, args);\n\
}\n\
return val;\n\
}\n\
\n\
function ifUndefined(val1, val2) {\n\
return (val1 === undefined) ? val2 : val1;\n\
}\n\
\n\
function addEventListeners(target, types, handler) {\n\
each(splitStr(types), function(type) {\n\
target.addEventListener(type, handler, false);\n\
});\n\
}\n\
\n\
function removeEventListeners(target, types, handler) {\n\
each(splitStr(types), function(type) {\n\
target.removeEventListener(type, handler, false);\n\
";

static const char aSVGScript1[] =
"\
});\n\
}\n\
\n\
function hasParent(node, parent) {\n\
while (node) {\n\
if (node == parent) {\n\
return true;\n\
}\n\
node = node.parentNode;\n\
}\n\
return false;\n\
}\n\
\n\
function inStr(str, find) {\n\
return str.indexOf(find) > -1;\n\
}\n\
\n\
function splitStr(str) {\n\
return str.trim().split(/\\s+/g);\n\
}\n\
\n\
function inArray(src, find, findByKey) {\n\
if (src.indexOf && !findByKey) {\n\
return src.indexOf(find);\n\
} else {\n\
var i = 0;\n\
while (i < src.length) {\n\
if ((findByKey && src[i][findByKey] == find) || (!findByKey && src[i] === find)) {\n\
return i;\n\
}\n\
i++;\n\
}\n\
return -1;\n\
}\n\
}\n\
\n\
function toArray(obj) {\n\
return Array.prototype.slice.call(obj, 0);\n\
}\n\
\n\
function uniqueArray(src, key, sort) {\n\
var results = [];\n\
var values = [];\n\
var i = 0;\n\
\n\
while (i < src.length) {\n\
var val = key ? src[i][key] : src[i];\n\
if (inArray(values, val) < 0) {\n\
results.push(src[i]);\n\
}\n\
values[i] = val;\n\
i++;\n\
}\n\
\n\
if (sort) {\n\
if (!key) {\n\
results = results.sort();\n\
} else {\n\
results = results.sort(function sortUniqueArray(a, b) {\n\
return a[key] > b[key];\n\
});\n\
}\n\
}\n\
\n\
return results;\n\
}\n\
\n\
function prefixed(obj, property) {\n\
if (obj === undefined) {\n\
return undefined;\n\
}\n\
\n\
var prefix, prop;\n\
var camelProp = property[0].toUpperCase() + property.slice(1);\n\
\n\
var i = 0;\n\
while (i < VENDOR_PREFIXES.length) {\n\
prefix = VENDOR_PREFIXES[i];\n\
prop = (prefix) ? prefix + camelProp : property;\n\
\n\
if (prop in obj) {\n\
return prop;\n\
}\n\
i++;\n\
}\n\
return undefined;\n\
}\n\
\n\
var _uniqueId = 1;\n\
function uniqueId() {\n\
return _uniqueId++;\n\
}\n\
\n\
function getWindowForElement(element) {\n\
var doc = element.ownerDocument || element;\n\
return (doc.defaultView || doc.parentWindow || window);\n\
}\n\
\n\
var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;\n\
\n\
var SUPPORT_TOUCH = ('ontouchstart' in window);\n\
var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined;\n\
var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);\n\
\n\
var INPUT_TYPE_TOUCH = 'touch';\n\
var INPUT_TYPE_PEN = 'pen';\n\
var INPUT_TYPE_MOUSE = 'mouse';\n\
var INPUT_TYPE_KINECT = 'kinect';\n\
\n\
var COMPUTE_INTERVAL = 25;\n\
\n\
var INPUT_START = 1;\n\
var INPUT_MOVE = 2;\n\
var INPUT_END = 4;\n\
var INPUT_CANCEL = 8;\n\
\n\
var DIRECTION_NONE = 1;\n\
var DIRECTION_LEFT = 2;\n\
var DIRECTION_RIGHT = 4;\n\
var DIRECTION_UP = 8;\n\
var DIRECTION_DOWN = 16;\n\
\n\
var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;\n\
var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;\n\
var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;\n\
\n\
var PROPS_XY = ['x', 'y'];\n\
var PROPS_CLIENT_XY = ['clientX', 'clientY'];\n\
\n\
function Input(manager, callback) {\n\
var self = this;\n\
this.manager = manager;\n\
this.callback = callback;\n\
this.element = manager.element;\n\
this.target = manager.options.inputTarget;\n\
\n\
this.domHandler = function(ev) {\n\
if (boolOrFn(manager.options.enable, [manager])) {\n\
self.handler(ev);\n\
}\n\
};\n\
\n\
this.init();\n\
\n\
}\n\
\n\
Input.prototype = {\n\
handler: function() { },\n\
\n\
init: function() {\n\
";

static const char aSVGScript2[] =
"\
this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);\n\
this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);\n\
this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);\n\
},\n\
\n\
destroy: function() {\n\
this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);\n\
this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);\n\
this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);\n\
}\n\
};\n\
\n\
function createInputInstance(manager) {\n\
var Type;\n\
var inputClass = manager.options.inputClass;\n\
\n\
if (inputClass) {\n\
Type = inputClass;\n\
} else if (!SUPPORT_TOUCH && SUPPORT_POINTER_EVENTS) {\n\
Type = PointerEventInput;\n\
} else if (SUPPORT_ONLY_TOUCH) {\n\
Type = TouchInput;\n\
} else if (!SUPPORT_TOUCH) {\n\
Type = MouseInput;\n\
} else {\n\
Type = TouchMouseInput;\n\
}\n\
return new (Type)(manager, inputHandler);\n\
}\n\
\n\
function inputHandler(manager, eventType, input) {\n\
var pointersLen = input.pointers.length;\n\
var changedPointersLen = input.changedPointers.length;\n\
var isFirst = (eventType & INPUT_START && (pointersLen - changedPointersLen === 0));\n\
var isFinal = (eventType & (INPUT_END | INPUT_CANCEL) && (pointersLen - changedPointersLen === 0));\n\
\n\
input.isFirst = !!isFirst;\n\
input.isFinal = !!isFinal;\n\
\n\
if (isFirst) {\n\
manager.session = {};\n\
}\n\
\n\
input.eventType = eventType;\n\
\n\
computeInputData(manager, input);\n\
\n\
manager.emit('hammer.input', input);\n\
\n\
manager.recognize(input);\n\
manager.session.prevInput = input;\n\
}\n\
\n\
function computeInputData(manager, input) {\n\
var session = manager.session;\n\
var pointers = input.pointers;\n\
var pointersLength = pointers.length;\n\
\n\
if (!session.firstInput) {\n\
session.firstInput = simpleCloneInputData(input);\n\
}\n\
\n\
if (pointersLength > 1 && !session.firstMultiple) {\n\
session.firstMultiple = simpleCloneInputData(input);\n\
} else if (pointersLength === 1) {\n\
session.firstMultiple = false;\n\
}\n\
\n\
var firstInput = session.firstInput;\n\
var firstMultiple = session.firstMultiple;\n\
var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;\n\
\n\
var center = input.center = getCenter(pointers);\n\
input.timeStamp = now();\n\
input.deltaTime = input.timeStamp - firstInput.timeStamp;\n\
\n\
input.angle = getAngle(offsetCenter, center);\n\
input.distance = getDistance(offsetCenter, center);\n\
\n\
computeDeltaXY(session, input);\n\
input.offsetDirection = getDirection(input.deltaX, input.deltaY);\n\
\n\
var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);\n\
input.overallVelocityX = overallVelocity.x;\n\
input.overallVelocityY = overallVelocity.y;\n\
input.overallVelocity = (abs(overallVelocity.x) > abs(overallVelocity.y)) ? overallVelocity.x : overallVelocity.y;\n\
\n\
input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;\n\
input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;\n\
\n\
input.maxPointers = !session.prevInput ? input.pointers.length : ((input.pointers.length >\n\
session.prevInput.maxPointers) ? input.pointers.length : session.prevInput.maxPointers);\n\
\n\
computeIntervalInputData(session, input);\n\
\n\
var target = manager.element;\n\
if (hasParent(input.srcEvent.target, target)) {\n\
target = input.srcEvent.target;\n\
}\n\
input.target = target;\n\
}\n\
\n\
function computeDeltaXY(session, input) {\n\
var center = input.center;\n\
var offset = session.offsetDelta || {};\n\
var prevDelta = session.prevDelta || {};\n\
var prevInput = session.prevInput || {};\n\
\n\
if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {\n\
prevDelta = session.prevDelta = {\n\
x: prevInput.deltaX || 0,\n\
y: prevInput.deltaY || 0\n\
};\n\
\n\
offset = session.offsetDelta = {\n\
x: center.x,\n\
y: center.y\n\
};\n\
}\n\
\n\
input.deltaX = prevDelta.x + (center.x - offset.x);\n\
input.deltaY = prevDelta.y + (center.y - offset.y);\n\
}\n\
\n\
function computeIntervalInputData(session, input) {\n\
var last = session.lastInterval || input,\n\
deltaTime = input.timeStamp - last.timeStamp,\n\
velocity, velocityX, velocityY, direction;\n\
\n\
if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {\n\
var deltaX = input.deltaX - last.deltaX;\n\
var deltaY = input.deltaY - last.deltaY;\n\
\n\
var v = getVelocity(deltaTime, deltaX, deltaY);\n\
velocityX = v.x;\n\
velocityY = v.y;\n\
velocity = (abs(v.x) > abs(v.y)) ? v.x : v.y;\n\
direction = getDirection(deltaX, deltaY);\n\
\n\
session.lastInterval = input;\n\
} else {\n\
velocity = last.velocity;\n\
velocityX = last.velocityX;\n\
velocityY = last.velocityY;\n\
direction = last.direction;\n\
}\n\
\n\
input.velocity = velocity;\n\
input.velocityX = velocityX;\n\
input.velocityY = velocityY;\n\
";

static const char aSVGScript3[] =
"\
input.direction = direction;\n\
}\n\
\n\
function simpleCloneInputData(input) {\n\
var pointers = [];\n\
var i = 0;\n\
while (i < input.pointers.length) {\n\
pointers[i] = {\n\
clientX: round(input.pointers[i].clientX),\n\
clientY: round(input.pointers[i].clientY)\n\
};\n\
i++;\n\
}\n\
\n\
return {\n\
timeStamp: now(),\n\
pointers: pointers,\n\
center: getCenter(pointers),\n\
deltaX: input.deltaX,\n\
deltaY: input.deltaY\n\
};\n\
}\n\
\n\
function getCenter(pointers) {\n\
var pointersLength = pointers.length;\n\
\n\
if (pointersLength === 1) {\n\
return {\n\
x: round(pointers[0].clientX),\n\
y: round(pointers[0].clientY)\n\
};\n\
}\n\
\n\
var x = 0, y = 0, i = 0;\n\
while (i < pointersLength) {\n\
x += pointers[i].clientX;\n\
y += pointers[i].clientY;\n\
i++;\n\
}\n\
\n\
return {\n\
x: round(x / pointersLength),\n\
y: round(y / pointersLength)\n\
};\n\
}\n\
\n\
function getVelocity(deltaTime, x, y) {\n\
return {\n\
x: x / deltaTime || 0,\n\
y: y / deltaTime || 0\n\
};\n\
}\n\
\n\
function getDirection(x, y) {\n\
if (x === y) {\n\
return DIRECTION_NONE;\n\
}\n\
\n\
if (abs(x) >= abs(y)) {\n\
return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;\n\
}\n\
return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;\n\
}\n\
\n\
function getDistance(p1, p2, props) {\n\
if (!props) {\n\
props = PROPS_XY;\n\
}\n\
var x = p2[props[0]] - p1[props[0]],\n\
y = p2[props[1]] - p1[props[1]];\n\
\n\
return Math.hypot(x, y);\n\
}\n\
\n\
function getAngle(p1, p2, props) {\n\
if (!props) {\n\
props = PROPS_XY;\n\
}\n\
var x = p2[props[0]] - p1[props[0]],\n\
y = p2[props[1]] - p1[props[1]];\n\
return Math.atan2(y, x) * 180 / Math.PI;\n\
}\n\
\n\
function getRotation(start, end) {\n\
return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);\n\
}\n\
\n\
function getScale(start, end) {\n\
return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);\n\
}\n\
\n\
var MOUSE_INPUT_MAP = {\n\
mousedown: INPUT_START,\n\
mousemove: INPUT_MOVE,\n\
mouseup: INPUT_END\n\
};\n\
\n\
var MOUSE_ELEMENT_EVENTS = 'mousedown';\n\
var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';\n\
\n\
function MouseInput() {\n\
this.evEl = MOUSE_ELEMENT_EVENTS;\n\
this.evWin = MOUSE_WINDOW_EVENTS;\n\
\n\
this.pressed = false; // mousedown state\n\
\n\
Input.apply(this, arguments);\n\
}\n\
\n\
inherit(MouseInput, Input, {\n\
handler: function MEhandler(ev) {\n\
var eventType = MOUSE_INPUT_MAP[ev.type];\n\
\n\
if (eventType & INPUT_START && ev.button === 0) {\n\
this.pressed = true;\n\
}\n\
\n\
if (eventType & INPUT_MOVE && ev.which !== 1) {\n\
eventType = INPUT_END;\n\
}\n\
\n\
if (!this.pressed) {\n\
return;\n\
}\n\
\n\
if (eventType & INPUT_END) {\n\
this.pressed = false;\n\
}\n\
\n\
this.callback(this.manager, eventType, {\n\
pointers: [ev],\n\
changedPointers: [ev],\n\
pointerType: INPUT_TYPE_MOUSE,\n\
srcEvent: ev\n\
});\n\
}\n\
});\n\
\n\
var POINTER_INPUT_MAP = {\n\
pointerdown: INPUT_START,\n\
pointermove: INPUT_MOVE,\n\
pointerup: INPUT_END,\n\
pointercancel: INPUT_CANCEL,\n\
pointerout: INPUT_CANCEL\n\
};\n\
\n\
var IE10_POINTER_TYPE_ENUM = {\n\
2: INPUT_TYPE_TOUCH,\n\
3: INPUT_TYPE_PEN,\n\
4: INPUT_TYPE_MOUSE,\n\
";

static const char aSVGScript4[] =
"\
5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816\n\
};\n\
\n\
var POINTER_ELEMENT_EVENTS = 'pointerdown';\n\
var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel';\n\
\n\
if (window.MSPointerEvent && !window.PointerEvent) {\n\
POINTER_ELEMENT_EVENTS = 'MSPointerDown';\n\
POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';\n\
}\n\
\n\
function PointerEventInput() {\n\
this.evEl = POINTER_ELEMENT_EVENTS;\n\
this.evWin = POINTER_WINDOW_EVENTS;\n\
\n\
Input.apply(this, arguments);\n\
\n\
this.store = (this.manager.session.pointerEvents = []);\n\
}\n\
\n\
inherit(PointerEventInput, Input, {\n\
handler: function PEhandler(ev) {\n\
var store = this.store;\n\
var removePointer = false;\n\
\n\
var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');\n\
var eventType = POINTER_INPUT_MAP[eventTypeNormalized];\n\
var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;\n\
\n\
var isTouch = (pointerType == INPUT_TYPE_TOUCH);\n\
\n\
var storeIndex = inArray(store, ev.pointerId, 'pointerId');\n\
\n\
if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {\n\
if (storeIndex < 0) {\n\
store.push(ev);\n\
storeIndex = store.length - 1;\n\
}\n\
} else if (eventType & (INPUT_END | INPUT_CANCEL)) {\n\
removePointer = true;\n\
}\n\
\n\
if (storeIndex < 0) {\n\
return;\n\
}\n\
\n\
store[storeIndex] = ev;\n\
\n\
this.callback(this.manager, eventType, {\n\
pointers: store,\n\
changedPointers: [ev],\n\
pointerType: pointerType,\n\
srcEvent: ev\n\
});\n\
\n\
if (removePointer) {\n\
store.splice(storeIndex, 1);\n\
}\n\
}\n\
});\n\
\n\
var SINGLE_TOUCH_INPUT_MAP = {\n\
touchstart: INPUT_START,\n\
touchmove: INPUT_MOVE,\n\
touchend: INPUT_END,\n\
touchcancel: INPUT_CANCEL\n\
};\n\
\n\
var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';\n\
var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';\n\
\n\
function SingleTouchInput() {\n\
this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;\n\
this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;\n\
this.started = false;\n\
\n\
Input.apply(this, arguments);\n\
}\n\
\n\
inherit(SingleTouchInput, Input, {\n\
handler: function TEhandler(ev) {\n\
var type = SINGLE_TOUCH_INPUT_MAP[ev.type];\n\
\n\
if (type === INPUT_START) {\n\
this.started = true;\n\
}\n\
\n\
if (!this.started) {\n\
return;\n\
}\n\
\n\
var touches = normalizeSingleTouches.call(this, ev, type);\n\
\n\
if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {\n\
this.started = false;\n\
}\n\
\n\
this.callback(this.manager, type, {\n\
pointers: touches[0],\n\
changedPointers: touches[1],\n\
pointerType: INPUT_TYPE_TOUCH,\n\
srcEvent: ev\n\
});\n\
}\n\
});\n\
\n\
function normalizeSingleTouches(ev, type) {\n\
var all = toArray(ev.touches);\n\
var changed = toArray(ev.changedTouches);\n\
\n\
if (type & (INPUT_END | INPUT_CANCEL)) {\n\
all = uniqueArray(all.concat(changed), 'identifier', true);\n\
}\n\
\n\
return [all, changed];\n\
}\n\
\n\
var TOUCH_INPUT_MAP = {\n\
touchstart: INPUT_START,\n\
touchmove: INPUT_MOVE,\n\
touchend: INPUT_END,\n\
touchcancel: INPUT_CANCEL\n\
};\n\
\n\
var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';\n\
\n\
function TouchInput() {\n\
this.evTarget = TOUCH_TARGET_EVENTS;\n\
this.targetIds = {};\n\
\n\
Input.apply(this, arguments);\n\
}\n\
\n\
inherit(TouchInput, Input, {\n\
handler: function MTEhandler(ev) {\n\
var type = TOUCH_INPUT_MAP[ev.type];\n\
var touches = getTouches.call(this, ev, type);\n\
if (!touches) {\n\
return;\n\
}\n\
\n\
this.callback(this.manager, type, {\n\
pointers: touches[0],\n\
changedPointers: touches[1],\n\
pointerType: INPUT_TYPE_TOUCH,\n\
srcEvent: ev\n\
});\n\
}\n\
});\n\
\n\
";

static const char aSVGScript5[] =
"\
function getTouches(ev, type) {\n\
var allTouches = toArray(ev.touches);\n\
var targetIds = this.targetIds;\n\
\n\
if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {\n\
targetIds[allTouches[0].identifier] = true;\n\
return [allTouches, allTouches];\n\
}\n\
\n\
var i,\n\
targetTouches,\n\
changedTouches = toArray(ev.changedTouches),\n\
changedTargetTouches = [],\n\
target = this.target;\n\
\n\
targetTouches = allTouches.filter(function(touch) {\n\
return hasParent(touch.target, target);\n\
});\n\
\n\
if (type === INPUT_START) {\n\
i = 0;\n\
while (i < targetTouches.length) {\n\
targetIds[targetTouches[i].identifier] = true;\n\
i++;\n\
}\n\
}\n\
\n\
i = 0;\n\
while (i < changedTouches.length) {\n\
if (targetIds[changedTouches[i].identifier]) {\n\
changedTargetTouches.push(changedTouches[i]);\n\
}\n\
\n\
if (type & (INPUT_END | INPUT_CANCEL)) {\n\
delete targetIds[changedTouches[i].identifier];\n\
}\n\
i++;\n\
}\n\
\n\
if (!changedTargetTouches.length) {\n\
return;\n\
}\n\
\n\
return [\n\
uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true),\n\
changedTargetTouches\n\
];\n\
}\n\
\n\
\n\
var DEDUP_TIMEOUT = 2500;\n\
var DEDUP_DISTANCE = 25;\n\
\n\
function TouchMouseInput() {\n\
Input.apply(this, arguments);\n\
\n\
var handler = bindFn(this.handler, this);\n\
this.touch = new TouchInput(this.manager, handler);\n\
this.mouse = new MouseInput(this.manager, handler);\n\
\n\
this.primaryTouch = null;\n\
this.lastTouches = [];\n\
}\n\
\n\
inherit(TouchMouseInput, Input, {\n\
handler: function TMEhandler(manager, inputEvent, inputData) {\n\
var isTouch = (inputData.pointerType == INPUT_TYPE_TOUCH),\n\
isMouse = (inputData.pointerType == INPUT_TYPE_MOUSE);\n\
\n\
if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {\n\
return;\n\
}\n\
\n\
if (isTouch) {\n\
recordTouches.call(this, inputEvent, inputData);\n\
} else if (isMouse && isSyntheticEvent.call(this, inputData)) {\n\
return;\n\
}\n\
\n\
this.callback(manager, inputEvent, inputData);\n\
},\n\
\n\
destroy: function destroy() {\n\
this.touch.destroy();\n\
this.mouse.destroy();\n\
}\n\
});\n\
\n\
function recordTouches(eventType, eventData) {\n\
if (eventType & INPUT_START) {\n\
this.primaryTouch = eventData.changedPointers[0].identifier;\n\
setLastTouch.call(this, eventData);\n\
} else if (eventType & (INPUT_END | INPUT_CANCEL)) {\n\
setLastTouch.call(this, eventData);\n\
}\n\
}\n\
\n\
function setLastTouch(eventData) {\n\
var touch = eventData.changedPointers[0];\n\
\n\
if (touch.identifier === this.primaryTouch) {\n\
var lastTouch = {x: touch.clientX, y: touch.clientY};\n\
this.lastTouches.push(lastTouch);\n\
var lts = this.lastTouches;\n\
var removeLastTouch = function() {\n\
var i = lts.indexOf(lastTouch);\n\
if (i > -1) {\n\
lts.splice(i, 1);\n\
}\n\
};\n\
setTimeout(removeLastTouch, DEDUP_TIMEOUT);\n\
}\n\
}\n\
\n\
function isSyntheticEvent(eventData) {\n\
var x = eventData.srcEvent.clientX, y = eventData.srcEvent.clientY;\n\
for (var i = 0; i < this.lastTouches.length; i++) {\n\
var t = this.lastTouches[i];\n\
var dx = Math.abs(x - t.x), dy = Math.abs(y - t.y);\n\
if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {\n\
return true;\n\
}\n\
}\n\
return false;\n\
}\n\
\n\
var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');\n\
var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;\n\
\n\
var TOUCH_ACTION_COMPUTE = 'compute';\n\
var TOUCH_ACTION_AUTO = 'auto';\n\
var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented\n\
var TOUCH_ACTION_NONE = 'none';\n\
var TOUCH_ACTION_PAN_X = 'pan-x';\n\
var TOUCH_ACTION_PAN_Y = 'pan-y';\n\
var TOUCH_ACTION_MAP = getTouchActionProps();\n\
\n\
function TouchAction(manager, value) {\n\
this.manager = manager;\n\
this.set(value);\n\
}\n\
\n\
TouchAction.prototype = {\n\
set: function(value) {\n\
if (value == TOUCH_ACTION_COMPUTE) {\n\
value = this.compute();\n\
}\n\
\n\
if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {\n\
this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;\n\
";

static const char aSVGScript6[] =
"\
}\n\
this.actions = value.toLowerCase().trim();\n\
},\n\
\n\
update: function() {\n\
this.set(this.manager.options.touchAction);\n\
},\n\
\n\
compute: function() {\n\
var actions = [];\n\
each(this.manager.recognizers, function(recognizer) {\n\
if (boolOrFn(recognizer.options.enable, [recognizer])) {\n\
actions = actions.concat(recognizer.getTouchAction());\n\
}\n\
});\n\
return cleanTouchActions(actions.join(' '));\n\
},\n\
\n\
preventDefaults: function(input) {\n\
var srcEvent = input.srcEvent;\n\
var direction = input.offsetDirection;\n\
\n\
if (this.manager.session.prevented) {\n\
srcEvent.preventDefault();\n\
return;\n\
}\n\
\n\
var actions = this.actions;\n\
var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];\n\
var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];\n\
var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];\n\
\n\
if (hasNone) {\n\
\n\
var isTapPointer = input.pointers.length === 1;\n\
var isTapMovement = input.distance < 2;\n\
var isTapTouchTime = input.deltaTime < 250;\n\
\n\
if (isTapPointer && isTapMovement && isTapTouchTime) {\n\
return;\n\
}\n\
}\n\
\n\
if (hasPanX && hasPanY) {\n\
return;\n\
}\n\
\n\
if (hasNone ||\n\
(hasPanY && direction & DIRECTION_HORIZONTAL) ||\n\
(hasPanX && direction & DIRECTION_VERTICAL)) {\n\
return this.preventSrc(srcEvent);\n\
}\n\
},\n\
\n\
preventSrc: function(srcEvent) {\n\
this.manager.session.prevented = true;\n\
srcEvent.preventDefault();\n\
}\n\
};\n\
\n\
function cleanTouchActions(actions) {\n\
if (inStr(actions, TOUCH_ACTION_NONE)) {\n\
return TOUCH_ACTION_NONE;\n\
}\n\
\n\
var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);\n\
var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y);\n\
\n\
if (hasPanX && hasPanY) {\n\
return TOUCH_ACTION_NONE;\n\
}\n\
\n\
if (hasPanX || hasPanY) {\n\
return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;\n\
}\n\
\n\
if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {\n\
return TOUCH_ACTION_MANIPULATION;\n\
}\n\
\n\
return TOUCH_ACTION_AUTO;\n\
}\n\
\n\
function getTouchActionProps() {\n\
if (!NATIVE_TOUCH_ACTION) {\n\
return false;\n\
}\n\
var touchMap = {};\n\
var cssSupports = window.CSS && window.CSS.supports;\n\
['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function(val) {\n\
\n\
touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;\n\
});\n\
return touchMap;\n\
}\n\
\n\
var STATE_POSSIBLE = 1;\n\
var STATE_BEGAN = 2;\n\
var STATE_CHANGED = 4;\n\
var STATE_ENDED = 8;\n\
var STATE_RECOGNIZED = STATE_ENDED;\n\
var STATE_CANCELLED = 16;\n\
var STATE_FAILED = 32;\n\
\n\
function Recognizer(options) {\n\
this.options = assign({}, this.defaults, options || {});\n\
\n\
this.id = uniqueId();\n\
\n\
this.manager = null;\n\
\n\
this.options.enable = ifUndefined(this.options.enable, true);\n\
\n\
this.state = STATE_POSSIBLE;\n\
\n\
this.simultaneous = {};\n\
this.requireFail = [];\n\
}\n\
\n\
Recognizer.prototype = {\n\
defaults: {},\n\
\n\
set: function(options) {\n\
assign(this.options, options);\n\
\n\
this.manager && this.manager.touchAction.update();\n\
return this;\n\
},\n\
\n\
recognizeWith: function(otherRecognizer) {\n\
if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {\n\
return this;\n\
}\n\
\n\
var simultaneous = this.simultaneous;\n\
otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);\n\
if (!simultaneous[otherRecognizer.id]) {\n\
simultaneous[otherRecognizer.id] = otherRecognizer;\n\
otherRecognizer.recognizeWith(this);\n\
}\n\
return this;\n\
},\n\
\n\
dropRecognizeWith: function(otherRecognizer) {\n\
if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {\n\
return this;\n\
}\n\
\n\
otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);\n\
delete this.simultaneous[otherRecognizer.id];\n\
";

static const char aSVGScript7[] =
"\
return this;\n\
},\n\
\n\
requireFailure: function(otherRecognizer) {\n\
if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {\n\
return this;\n\
}\n\
\n\
var requireFail = this.requireFail;\n\
otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);\n\
if (inArray(requireFail, otherRecognizer) === -1) {\n\
requireFail.push(otherRecognizer);\n\
otherRecognizer.requireFailure(this);\n\
}\n\
return this;\n\
},\n\
\n\
dropRequireFailure: function(otherRecognizer) {\n\
if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {\n\
return this;\n\
}\n\
\n\
otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);\n\
var index = inArray(this.requireFail, otherRecognizer);\n\
if (index > -1) {\n\
this.requireFail.splice(index, 1);\n\
}\n\
return this;\n\
},\n\
\n\
hasRequireFailures: function() {\n\
return this.requireFail.length > 0;\n\
},\n\
\n\
canRecognizeWith: function(otherRecognizer) {\n\
return !!this.simultaneous[otherRecognizer.id];\n\
},\n\
\n\
emit: function(input) {\n\
var self = this;\n\
var state = this.state;\n\
\n\
function emit(event) {\n\
self.manager.emit(event, input);\n\
}\n\
\n\
if (state < STATE_ENDED) {\n\
emit(self.options.event + stateStr(state));\n\
}\n\
\n\
emit(self.options.event); // simple 'eventName' events\n\
\n\
if (input.additionalEvent) { // additional event(panleft, panright, pinchin, pinchout...)\n\
emit(input.additionalEvent);\n\
}\n\
\n\
if (state >= STATE_ENDED) {\n\
emit(self.options.event + stateStr(state));\n\
}\n\
},\n\
\n\
tryEmit: function(input) {\n\
if (this.canEmit()) {\n\
return this.emit(input);\n\
}\n\
this.state = STATE_FAILED;\n\
},\n\
\n\
canEmit: function() {\n\
var i = 0;\n\
while (i < this.requireFail.length) {\n\
if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {\n\
return false;\n\
}\n\
i++;\n\
}\n\
return true;\n\
},\n\
\n\
recognize: function(inputData) {\n\
var inputDataClone = assign({}, inputData);\n\
\n\
if (!boolOrFn(this.options.enable, [this, inputDataClone])) {\n\
this.reset();\n\
this.state = STATE_FAILED;\n\
return;\n\
}\n\
\n\
if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {\n\
this.state = STATE_POSSIBLE;\n\
}\n\
\n\
this.state = this.process(inputDataClone);\n\
\n\
if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {\n\
this.tryEmit(inputDataClone);\n\
}\n\
},\n\
\n\
process: function(inputData) { }, // jshint ignore:line\n\
\n\
getTouchAction: function() { },\n\
\n\
reset: function() { }\n\
};\n\
\n\
function stateStr(state) {\n\
if (state & STATE_CANCELLED) {\n\
return 'cancel';\n\
} else if (state & STATE_ENDED) {\n\
return 'end';\n\
} else if (state & STATE_CHANGED) {\n\
return 'move';\n\
} else if (state & STATE_BEGAN) {\n\
return 'start';\n\
}\n\
return '';\n\
}\n\
\n\
function directionStr(direction) {\n\
if (direction == DIRECTION_DOWN) {\n\
return 'down';\n\
} else if (direction == DIRECTION_UP) {\n\
return 'up';\n\
} else if (direction == DIRECTION_LEFT) {\n\
return 'left';\n\
} else if (direction == DIRECTION_RIGHT) {\n\
return 'right';\n\
}\n\
return '';\n\
}\n\
\n\
function getRecognizerByNameIfManager(otherRecognizer, recognizer) {\n\
var manager = recognizer.manager;\n\
if (manager) {\n\
return manager.get(otherRecognizer);\n\
}\n\
return otherRecognizer;\n\
}\n\
\n\
function AttrRecognizer() {\n\
Recognizer.apply(this, arguments);\n\
}\n\
\n\
inherit(AttrRecognizer, Recognizer, {\n\
defaults: {\n\
pointers: 1\n\
},\n\
\n\
attrTest: function(input) {\n\
";

static const char aSVGScript8[] =
"\
var optionPointers = this.options.pointers;\n\
return optionPointers === 0 || input.pointers.length === optionPointers;\n\
},\n\
\n\
process: function(input) {\n\
var state = this.state;\n\
var eventType = input.eventType;\n\
\n\
var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);\n\
var isValid = this.attrTest(input);\n\
\n\
if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {\n\
return state | STATE_CANCELLED;\n\
} else if (isRecognized || isValid) {\n\
if (eventType & INPUT_END) {\n\
return state | STATE_ENDED;\n\
} else if (!(state & STATE_BEGAN)) {\n\
return STATE_BEGAN;\n\
}\n\
return state | STATE_CHANGED;\n\
}\n\
return STATE_FAILED;\n\
}\n\
});\n\
\n\
function PanRecognizer() {\n\
AttrRecognizer.apply(this, arguments);\n\
\n\
this.pX = null;\n\
this.pY = null;\n\
}\n\
\n\
inherit(PanRecognizer, AttrRecognizer, {\n\
defaults: {\n\
event: 'pan',\n\
threshold: 10,\n\
pointers: 1,\n\
direction: DIRECTION_ALL\n\
},\n\
\n\
getTouchAction: function() {\n\
var direction = this.options.direction;\n\
var actions = [];\n\
if (direction & DIRECTION_HORIZONTAL) {\n\
actions.push(TOUCH_ACTION_PAN_Y);\n\
}\n\
if (direction & DIRECTION_VERTICAL) {\n\
actions.push(TOUCH_ACTION_PAN_X);\n\
}\n\
return actions;\n\
},\n\
\n\
directionTest: function(input) {\n\
var options = this.options;\n\
var hasMoved = true;\n\
var distance = input.distance;\n\
var direction = input.direction;\n\
var x = input.deltaX;\n\
var y = input.deltaY;\n\
\n\
if (!(direction & options.direction)) {\n\
if (options.direction & DIRECTION_HORIZONTAL) {\n\
direction = (x === 0) ? DIRECTION_NONE : (x < 0) ? DIRECTION_LEFT : DIRECTION_RIGHT;\n\
hasMoved = x != this.pX;\n\
distance = Math.abs(input.deltaX);\n\
} else {\n\
direction = (y === 0) ? DIRECTION_NONE : (y < 0) ? DIRECTION_UP : DIRECTION_DOWN;\n\
hasMoved = y != this.pY;\n\
distance = Math.abs(input.deltaY);\n\
}\n\
}\n\
input.direction = direction;\n\
return hasMoved && distance > options.threshold && direction & options.direction;\n\
},\n\
\n\
attrTest: function(input) {\n\
return AttrRecognizer.prototype.attrTest.call(this, input) &&\n\
(this.state & STATE_BEGAN || (!(this.state & STATE_BEGAN) && this.directionTest(input)));\n\
},\n\
\n\
emit: function(input) {\n\
\n\
this.pX = input.deltaX;\n\
this.pY = input.deltaY;\n\
\n\
var direction = directionStr(input.direction);\n\
\n\
if (direction) {\n\
input.additionalEvent = this.options.event + direction;\n\
}\n\
this._super.emit.call(this, input);\n\
}\n\
});\n\
\n\
function PinchRecognizer() {\n\
AttrRecognizer.apply(this, arguments);\n\
}\n\
\n\
inherit(PinchRecognizer, AttrRecognizer, {\n\
defaults: {\n\
event: 'pinch',\n\
threshold: 0,\n\
pointers: 2\n\
},\n\
\n\
getTouchAction: function() {\n\
return [TOUCH_ACTION_NONE];\n\
},\n\
\n\
attrTest: function(input) {\n\
return this._super.attrTest.call(this, input) &&\n\
(Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);\n\
},\n\
\n\
emit: function(input) {\n\
if (input.scale !== 1) {\n\
var inOut = input.scale < 1 ? 'in' : 'out';\n\
input.additionalEvent = this.options.event + inOut;\n\
}\n\
this._super.emit.call(this, input);\n\
}\n\
});\n\
\n\
function PressRecognizer() {\n\
Recognizer.apply(this, arguments);\n\
\n\
this._timer = null;\n\
this._input = null;\n\
}\n\
\n\
inherit(PressRecognizer, Recognizer, {\n\
defaults: {\n\
event: 'press',\n\
pointers: 1,\n\
time: 251, // minimal time of the pointer to be pressed\n\
threshold: 9 // a minimal movement is ok, but keep it low\n\
},\n\
\n\
getTouchAction: function() {\n\
return [TOUCH_ACTION_AUTO];\n\
},\n\
\n\
process: function(input) {\n\
var options = this.options;\n\
var validPointers = input.pointers.length === options.pointers;\n\
var validMovement = input.distance < options.threshold;\n\
var validTime = input.deltaTime > options.time;\n\
\n\
this._input = input;\n\
\n\
";

static const char aSVGScript9[] =
"\
if (!validMovement || !validPointers || (input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime)) {\n\
this.reset();\n\
} else if (input.eventType & INPUT_START) {\n\
this.reset();\n\
this._timer = setTimeoutContext(function() {\n\
this.state = STATE_RECOGNIZED;\n\
this.tryEmit();\n\
}, options.time, this);\n\
} else if (input.eventType & INPUT_END) {\n\
return STATE_RECOGNIZED;\n\
}\n\
return STATE_FAILED;\n\
},\n\
\n\
reset: function() {\n\
clearTimeout(this._timer);\n\
},\n\
\n\
emit: function(input) {\n\
if (this.state !== STATE_RECOGNIZED) {\n\
return;\n\
}\n\
\n\
if (input && (input.eventType & INPUT_END)) {\n\
this.manager.emit(this.options.event + 'up', input);\n\
} else {\n\
this._input.timeStamp = now();\n\
this.manager.emit(this.options.event, this._input);\n\
}\n\
}\n\
});\n\
\n\
function RotateRecognizer() {\n\
AttrRecognizer.apply(this, arguments);\n\
}\n\
\n\
inherit(RotateRecognizer, AttrRecognizer, {\n\
defaults: {\n\
event: 'rotate',\n\
threshold: 0,\n\
pointers: 2\n\
},\n\
\n\
getTouchAction: function() {\n\
return [TOUCH_ACTION_NONE];\n\
},\n\
\n\
attrTest: function(input) {\n\
return this._super.attrTest.call(this, input) &&\n\
(Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);\n\
}\n\
});\n\
\n\
function SwipeRecognizer() {\n\
AttrRecognizer.apply(this, arguments);\n\
}\n\
\n\
inherit(SwipeRecognizer, AttrRecognizer, {\n\
defaults: {\n\
event: 'swipe',\n\
threshold: 10,\n\
velocity: 0.3,\n\
direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,\n\
pointers: 1\n\
},\n\
\n\
getTouchAction: function() {\n\
return PanRecognizer.prototype.getTouchAction.call(this);\n\
},\n\
\n\
attrTest: function(input) {\n\
var direction = this.options.direction;\n\
var velocity;\n\
\n\
if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {\n\
velocity = input.overallVelocity;\n\
} else if (direction & DIRECTION_HORIZONTAL) {\n\
velocity = input.overallVelocityX;\n\
} else if (direction & DIRECTION_VERTICAL) {\n\
velocity = input.overallVelocityY;\n\
}\n\
\n\
return this._super.attrTest.call(this, input) &&\n\
direction & input.offsetDirection &&\n\
input.distance > this.options.threshold &&\n\
input.maxPointers == this.options.pointers &&\n\
abs(velocity) > this.options.velocity && input.eventType & INPUT_END;\n\
},\n\
\n\
emit: function(input) {\n\
var direction = directionStr(input.offsetDirection);\n\
if (direction) {\n\
this.manager.emit(this.options.event + direction, input);\n\
}\n\
\n\
this.manager.emit(this.options.event, input);\n\
}\n\
});\n\
\n\
function TapRecognizer() {\n\
Recognizer.apply(this, arguments);\n\
\n\
this.pTime = false;\n\
this.pCenter = false;\n\
\n\
this._timer = null;\n\
this._input = null;\n\
this.count = 0;\n\
}\n\
\n\
inherit(TapRecognizer, Recognizer, {\n\
defaults: {\n\
event: 'tap',\n\
pointers: 1,\n\
taps: 1,\n\
interval: 300, // max time between the multi-tap taps\n\
time: 250, // max time of the pointer to be down (like finger on the screen)\n\
threshold: 9, // a minimal movement is ok, but keep it low\n\
posThreshold: 10 // a multi-tap can be a bit off the initial position\n\
},\n\
\n\
getTouchAction: function() {\n\
return [TOUCH_ACTION_MANIPULATION];\n\
},\n\
\n\
process: function(input) {\n\
var options = this.options;\n\
\n\
var validPointers = input.pointers.length === options.pointers;\n\
var validMovement = input.distance < options.threshold;\n\
var validTouchTime = input.deltaTime < options.time;\n\
\n\
this.reset();\n\
\n\
if ((input.eventType & INPUT_START) && (this.count === 0)) {\n\
return this.failTimeout();\n\
}\n\
\n\
if (validMovement && validTouchTime && validPointers) {\n\
if (input.eventType != INPUT_END) {\n\
return this.failTimeout();\n\
}\n\
\n\
var validInterval = this.pTime ? (input.timeStamp - this.pTime < options.interval) : true;\n\
var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;\n\
\n\
this.pTime = input.timeStamp;\n\
this.pCenter = input.center;\n\
\n\
if (!validMultiTap || !validInterval) {\n\
";

static const char aSVGScript10[] =
"\
this.count = 1;\n\
} else {\n\
this.count += 1;\n\
}\n\
\n\
this._input = input;\n\
\n\
var tapCount = this.count % options.taps;\n\
if (tapCount === 0) {\n\
if (!this.hasRequireFailures()) {\n\
return STATE_RECOGNIZED;\n\
} else {\n\
this._timer = setTimeoutContext(function() {\n\
this.state = STATE_RECOGNIZED;\n\
this.tryEmit();\n\
}, options.interval, this);\n\
return STATE_BEGAN;\n\
}\n\
}\n\
}\n\
return STATE_FAILED;\n\
},\n\
\n\
failTimeout: function() {\n\
this._timer = setTimeoutContext(function() {\n\
this.state = STATE_FAILED;\n\
}, this.options.interval, this);\n\
return STATE_FAILED;\n\
},\n\
\n\
reset: function() {\n\
clearTimeout(this._timer);\n\
},\n\
\n\
emit: function() {\n\
if (this.state == STATE_RECOGNIZED) {\n\
this._input.tapCount = this.count;\n\
this.manager.emit(this.options.event, this._input);\n\
}\n\
}\n\
});\n\
\n\
function Hammer(element, options) {\n\
options = options || {};\n\
options.recognizers = ifUndefined(options.recognizers, Hammer.defaults.preset);\n\
return new Manager(element, options);\n\
}\n\
\n\
Hammer.VERSION = '2.0.7';\n\
\n\
Hammer.defaults = {\n\
domEvents: false,\n\
\n\
touchAction: TOUCH_ACTION_COMPUTE,\n\
\n\
enable: true,\n\
\n\
inputTarget: null,\n\
\n\
inputClass: null,\n\
\n\
preset: [\n\
[RotateRecognizer, {enable: false}],\n\
[PinchRecognizer, {enable: false}, ['rotate']],\n\
[SwipeRecognizer, {direction: DIRECTION_HORIZONTAL}],\n\
[PanRecognizer, {direction: DIRECTION_HORIZONTAL}, ['swipe']],\n\
[TapRecognizer],\n\
[TapRecognizer, {event: 'doubletap', taps: 2}, ['tap']],\n\
[PressRecognizer]\n\
],\n\
\n\
cssProps: {\n\
userSelect: 'none',\n\
\n\
touchSelect: 'none',\n\
\n\
touchCallout: 'none',\n\
\n\
contentZooming: 'none',\n\
\n\
userDrag: 'none',\n\
\n\
tapHighlightColor: 'rgba(0,0,0,0)'\n\
}\n\
};\n\
\n\
var STOP = 1;\n\
var FORCED_STOP = 2;\n\
\n\
function Manager(element, options) {\n\
this.options = assign({}, Hammer.defaults, options || {});\n\
\n\
this.options.inputTarget = this.options.inputTarget || element;\n\
\n\
this.handlers = {};\n\
this.session = {};\n\
this.recognizers = [];\n\
this.oldCssProps = {};\n\
\n\
this.element = element;\n\
this.input = createInputInstance(this);\n\
this.touchAction = new TouchAction(this, this.options.touchAction);\n\
\n\
toggleCssProps(this, true);\n\
\n\
each(this.options.recognizers, function(item) {\n\
var recognizer = this.add(new (item[0])(item[1]));\n\
item[2] && recognizer.recognizeWith(item[2]);\n\
item[3] && recognizer.requireFailure(item[3]);\n\
}, this);\n\
}\n\
\n\
Manager.prototype = {\n\
set: function(options) {\n\
assign(this.options, options);\n\
\n\
if (options.touchAction) {\n\
this.touchAction.update();\n\
}\n\
if (options.inputTarget) {\n\
this.input.destroy();\n\
this.input.target = options.inputTarget;\n\
this.input.init();\n\
}\n\
return this;\n\
},\n\
\n\
stop: function(force) {\n\
this.session.stopped = force ? FORCED_STOP : STOP;\n\
},\n\
\n\
recognize: function(inputData) {\n\
var session = this.session;\n\
if (session.stopped) {\n\
return;\n\
}\n\
\n\
this.touchAction.preventDefaults(inputData);\n\
\n\
var recognizer;\n\
var recognizers = this.recognizers;\n\
\n\
var curRecognizer = session.curRecognizer;\n\
\n\
if (!curRecognizer || (curRecognizer && curRecognizer.state & STATE_RECOGNIZED)) {\n\
curRecognizer = session.curRecognizer = null;\n\
}\n\
\n\
var i = 0;\n\
while (i < recognizers.length) {\n\
";

static const char aSVGScript11[] =
"\
recognizer = recognizers[i];\n\
\n\
if (session.stopped !== FORCED_STOP && ( // 1\n\
!curRecognizer || recognizer == curRecognizer || // 2\n\
recognizer.canRecognizeWith(curRecognizer))) { // 3\n\
recognizer.recognize(inputData);\n\
} else {\n\
recognizer.reset();\n\
}\n\
\n\
if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {\n\
curRecognizer = session.curRecognizer = recognizer;\n\
}\n\
i++;\n\
}\n\
},\n\
\n\
get: function(recognizer) {\n\
if (recognizer instanceof Recognizer) {\n\
return recognizer;\n\
}\n\
\n\
var recognizers = this.recognizers;\n\
for (var i = 0; i < recognizers.length; i++) {\n\
if (recognizers[i].options.event == recognizer) {\n\
return recognizers[i];\n\
}\n\
}\n\
return null;\n\
},\n\
\n\
add: function(recognizer) {\n\
if (invokeArrayArg(recognizer, 'add', this)) {\n\
return this;\n\
}\n\
\n\
var existing = this.get(recognizer.options.event);\n\
if (existing) {\n\
this.remove(existing);\n\
}\n\
\n\
this.recognizers.push(recognizer);\n\
recognizer.manager = this;\n\
\n\
this.touchAction.update();\n\
return recognizer;\n\
},\n\
\n\
remove: function(recognizer) {\n\
if (invokeArrayArg(recognizer, 'remove', this)) {\n\
return this;\n\
}\n\
\n\
recognizer = this.get(recognizer);\n\
\n\
if (recognizer) {\n\
var recognizers = this.recognizers;\n\
var index = inArray(recognizers, recognizer);\n\
\n\
if (index !== -1) {\n\
recognizers.splice(index, 1);\n\
this.touchAction.update();\n\
}\n\
}\n\
\n\
return this;\n\
},\n\
\n\
on: function(events, handler) {\n\
if (events === undefined) {\n\
return;\n\
}\n\
if (handler === undefined) {\n\
return;\n\
}\n\
\n\
var handlers = this.handlers;\n\
each(splitStr(events), function(event) {\n\
handlers[event] = handlers[event] || [];\n\
handlers[event].push(handler);\n\
});\n\
return this;\n\
},\n\
\n\
off: function(events, handler) {\n\
if (events === undefined) {\n\
return;\n\
}\n\
\n\
var handlers = this.handlers;\n\
each(splitStr(events), function(event) {\n\
if (!handler) {\n\
delete handlers[event];\n\
} else {\n\
handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);\n\
}\n\
});\n\
return this;\n\
},\n\
\n\
emit: function(event, data) {\n\
if (this.options.domEvents) {\n\
triggerDomEvent(event, data);\n\
}\n\
\n\
var handlers = this.handlers[event] && this.handlers[event].slice();\n\
if (!handlers || !handlers.length) {\n\
return;\n\
}\n\
\n\
data.type = event;\n\
data.preventDefault = function() {\n\
data.srcEvent.preventDefault();\n\
};\n\
\n\
var i = 0;\n\
while (i < handlers.length) {\n\
handlers[i](data);\n\
i++;\n\
}\n\
},\n\
\n\
destroy: function() {\n\
this.element && toggleCssProps(this, false);\n\
\n\
this.handlers = {};\n\
this.session = {};\n\
this.input.destroy();\n\
this.element = null;\n\
}\n\
};\n\
\n\
function toggleCssProps(manager, add) {\n\
var element = manager.element;\n\
if (!element.style) {\n\
return;\n\
}\n\
var prop;\n\
each(manager.options.cssProps, function(value, name) {\n\
prop = prefixed(element.style, name);\n\
if (add) {\n\
manager.oldCssProps[prop] = element.style[prop];\n\
element.style[prop] = value;\n\
} else {\n\
element.style[prop] = manager.oldCssProps[prop] || '';\n\
}\n\
});\n\
if (!add) {\n\
manager.oldCssProps = {};\n\
}\n\
";

static const char aSVGScript12[] =
"\
}\n\
\n\
function triggerDomEvent(event, data) {\n\
var gestureEvent = document.createEvent('Event');\n\
gestureEvent.initEvent(event, true, true);\n\
gestureEvent.gesture = data;\n\
data.target.dispatchEvent(gestureEvent);\n\
}\n\
\n\
assign(Hammer, {\n\
INPUT_START: INPUT_START,\n\
INPUT_MOVE: INPUT_MOVE,\n\
INPUT_END: INPUT_END,\n\
INPUT_CANCEL: INPUT_CANCEL,\n\
\n\
STATE_POSSIBLE: STATE_POSSIBLE,\n\
STATE_BEGAN: STATE_BEGAN,\n\
STATE_CHANGED: STATE_CHANGED,\n\
STATE_ENDED: STATE_ENDED,\n\
STATE_RECOGNIZED: STATE_RECOGNIZED,\n\
STATE_CANCELLED: STATE_CANCELLED,\n\
STATE_FAILED: STATE_FAILED,\n\
\n\
DIRECTION_NONE: DIRECTION_NONE,\n\
DIRECTION_LEFT: DIRECTION_LEFT,\n\
DIRECTION_RIGHT: DIRECTION_RIGHT,\n\
DIRECTION_UP: DIRECTION_UP,\n\
DIRECTION_DOWN: DIRECTION_DOWN,\n\
DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,\n\
DIRECTION_VERTICAL: DIRECTION_VERTICAL,\n\
DIRECTION_ALL: DIRECTION_ALL,\n\
\n\
Manager: Manager,\n\
Input: Input,\n\
TouchAction: TouchAction,\n\
\n\
TouchInput: TouchInput,\n\
MouseInput: MouseInput,\n\
PointerEventInput: PointerEventInput,\n\
TouchMouseInput: TouchMouseInput,\n\
SingleTouchInput: SingleTouchInput,\n\
\n\
Recognizer: Recognizer,\n\
AttrRecognizer: AttrRecognizer,\n\
Tap: TapRecognizer,\n\
Pan: PanRecognizer,\n\
Swipe: SwipeRecognizer,\n\
Pinch: PinchRecognizer,\n\
Rotate: RotateRecognizer,\n\
Press: PressRecognizer,\n\
\n\
on: addEventListeners,\n\
off: removeEventListeners,\n\
each: each,\n\
merge: merge,\n\
extend: extend,\n\
assign: assign,\n\
inherit: inherit,\n\
bindFn: bindFn,\n\
prefixed: prefixed\n\
});\n\
\n\
var freeGlobal = (typeof window !== 'undefined' ? window : (typeof self !== 'undefined' ? self : {})); // jshint ignore:line\n\
freeGlobal.Hammer = Hammer;\n\
\n\
if (typeof define === 'function' && define.amd) {\n\
define(function() {\n\
return Hammer;\n\
});\n\
} else if (typeof module != 'undefined' && module.exports) {\n\
module.exports = Hammer;\n\
} else {\n\
window[exportName] = Hammer;\n\
}\n\
\n\
})(window, document, 'Hammer');\n\
\n\
/*****\n\
* @licstart\n\
*\n\
* The following is the license notice for the part of JavaScript code of this\n\
* page included between the '@jessyinkstart' and the '@jessyinkend' notes.\n\
*/\n\
\n\
/*****  ******************************************************************\n\
*\n\
* Copyright 2008-2013 Hannes Hochreiner\n\
*\n\
* The JavaScript code included between the start note '@jessyinkstart'\n\
* and the end note '@jessyinkend' is subject to the terms of the Mozilla\n\
* Public License, v. 2.0. If a copy of the MPL was not distributed with\n\
* this file, You can obtain one at http://mozilla.org/MPL/2.0/.\n\
*\n\
* Alternatively, you can redistribute and/or that part of this file\n\
* under the terms of the GNU General Public License as published by\n\
* the Free Software Foundation, either version 3 of the License, or\n\
* (at your option) any later version.\n\
*\n\
* This program is distributed in the hope that it will be useful,\n\
* but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
* GNU General Public License for more details.\n\
*\n\
* You should have received a copy of the GNU General Public License\n\
* along with this program.  If not, see http://www.gnu.org/licenses/.\n\
*/\n\
\n\
/*****\n\
*  You can find the complete source code of the JessyInk project at:\n\
*  @source http://code.google.com/p/jessyink/\n\
*/\n\
\n\
/*****\n\
* @licend\n\
*\n\
* The above is the license notice for the part of JavaScript code of this\n\
* page included between the '@jessyinkstart' and the '@jessyinkend' notes.\n\
*/\n\
\n\
\n\
/*****\n\
* @jessyinkstart\n\
*\n\
*  The following code is a derivative work of some parts of the JessyInk\n\
*  project.\n\
*  @source http://code.google.com/p/jessyink/\n\
*/\n\
\n\
function getElementsByProperty( node, name )\n\
{\n\
var elements = [];\n\
\n\
if( node.getAttribute( name ) )\n\
elements.push( node );\n\
\n\
for( var counter = 0; counter < node.childNodes.length; ++counter )\n\
{\n\
if( node.childNodes[counter].nodeType == 1 )\n\
{\n\
var subElements = getElementsByProperty( node.childNodes[counter], name );\n\
elements = elements.concat( subElements );\n\
}\n\
}\n\
return elements;\n\
}\n\
\n\
var rootNodeInitialBackgroundColor = undefined;\n\
\n\
function changeRootNodeBackgroundTo(color) {\n\
if (rootNodeInitialBackgroundColor === undefined)\n\
";

static const char aSVGScript13[] =
"\
rootNodeInitialBackgroundColor = ROOT_NODE.style.backgroundColor;\n\
\n\
if (color === 'initial')\n\
ROOT_NODE.style.backgroundColor = rootNodeInitialBackgroundColor;\n\
else\n\
ROOT_NODE.style.backgroundColor = color;\n\
}\n\
\n\
var isContentHidden = false;\n\
var contentInitialVisibilityValues = null;\n\
\n\
function getInitialVisibilityValues() {\n\
var list = ROOT_NODE.querySelectorAll('g');\n\
contentInitialVisibilityValues = [];\n\
for (var i = 0; i < list.length; i++) {\n\
var temp = {};\n\
temp.object = list[i];\n\
temp.visibility = list[i].style.visibility;\n\
contentInitialVisibilityValues.push(temp);\n\
}\n\
}\n\
\n\
function hideShowContent(color) {\n\
if (contentInitialVisibilityValues === null)\n\
getInitialVisibilityValues();\n\
\n\
if (isContentHidden) {\n\
for (var i = 0; i < contentInitialVisibilityValues.length; i++)\n\
contentInitialVisibilityValues[i].object.style.visibility = contentInitialVisibilityValues[i].visibility;\n\
\n\
changeRootNodeBackgroundTo('initial');\n\
isContentHidden = false;\n\
}\n\
else {\n\
for (var i = 0; i < contentInitialVisibilityValues.length; i++)\n\
contentInitialVisibilityValues[i].object.style.visibility = 'hidden';\n\
\n\
changeRootNodeBackgroundTo(color);\n\
isContentHidden = true;\n\
}\n\
}\n\
\n\
function onKeyDown( aEvt )\n\
{\n\
if ( !aEvt )\n\
aEvt = window.event;\n\
\n\
var code = aEvt.keyCode || aEvt.charCode || aEvt.code;\n\
\n\
\n\
if (code == 0 && aEvt.key != undefined) {\n\
switch (aEvt.key) {\n\
case 'UIKeyInputLeftArrow':\n\
code = LEFT_KEY;\n\
break;\n\
case 'UIKeyInputUpArrow':\n\
code = UP_KEY;\n\
break;\n\
case 'UIKeyInputRightArrow':\n\
code = RIGHT_KEY;\n\
break;\n\
case 'UIKeyInputDownArrow':\n\
code = DOWN_KEY;\n\
break;\n\
}\n\
\n\
}\n\
else if (code === P_KEY) {\n\
aEvt.preventDefault();\n\
if (ROOT_NODE.style.cursor === 'pointer')\n\
ROOT_NODE.style.cursor = 'default';\n\
else\n\
ROOT_NODE.style.cursor = 'pointer';\n\
}\n\
else if (code === W_KEY) {\n\
hideShowContent('white');\n\
}\n\
else if (code === B_KEY) {\n\
hideShowContent('black');\n\
}\n\
\n\
\n\
if( !processingEffect && keyCodeDictionary[currentMode] && keyCodeDictionary[currentMode][code] )\n\
{\n\
return keyCodeDictionary[currentMode][code]();\n\
}\n\
else\n\
{\n\
document.onkeypress = onKeyPress;\n\
return null;\n\
}\n\
}\n\
document.onkeydown = onKeyDown;\n\
\n\
function onKeyPress( aEvt )\n\
{\n\
document.onkeypress = null;\n\
\n\
if ( !aEvt )\n\
aEvt = window.event;\n\
\n\
var str = String.fromCharCode( aEvt.keyCode || aEvt.charCode );\n\
\n\
if ( !processingEffect && charCodeDictionary[currentMode] && charCodeDictionary[currentMode][str] )\n\
return charCodeDictionary[currentMode][str]();\n\
\n\
return null;\n\
}\n\
\n\
function getDefaultKeyCodeDictionary()\n\
{\n\
var keyCodeDict = {};\n\
\n\
keyCodeDict[SLIDE_MODE] = {};\n\
keyCodeDict[INDEX_MODE] = {};\n\
\n\
keyCodeDict[SLIDE_MODE][LEFT_KEY]\n\
= function() { return aSlideShow.rewindEffect(); };\n\
keyCodeDict[SLIDE_MODE][RIGHT_KEY]\n\
= function() { return dispatchEffects(1); };\n\
keyCodeDict[SLIDE_MODE][UP_KEY]\n\
= function() { return aSlideShow.rewindEffect(); };\n\
keyCodeDict[SLIDE_MODE][DOWN_KEY]\n\
= function() { return skipEffects(1); };\n\
keyCodeDict[SLIDE_MODE][PAGE_UP_KEY]\n\
= function() { return aSlideShow.rewindAllEffects(); };\n\
keyCodeDict[SLIDE_MODE][PAGE_DOWN_KEY]\n\
= function() { return skipAllEffects(); };\n\
keyCodeDict[SLIDE_MODE][HOME_KEY]\n\
= function() { return aSlideShow.displaySlide( 0, true ); };\n\
keyCodeDict[SLIDE_MODE][END_KEY]\n\
= function() { return aSlideShow.displaySlide( theMetaDoc.nNumberOfSlides - 1, true ); };\n\
keyCodeDict[SLIDE_MODE][SPACE_KEY]\n\
= function() { return dispatchEffects(1); };\n\
keyCodeDict[SLIDE_MODE][ESCAPE_KEY]\n\
= function() { return aSlideShow.exitSlideShowInApp(); };\n\
keyCodeDict[SLIDE_MODE][Q_KEY]\n\
= function() { return aSlideShow.exitSlideShowInApp(); };\n\
\n\
keyCodeDict[INDEX_MODE][LEFT_KEY]\n\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex - 1 ); };\n\
keyCodeDict[INDEX_MODE][RIGHT_KEY]\n\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex + 1 ); };\n\
keyCodeDict[INDEX_MODE][UP_KEY]\n\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex - theSlideIndexPage.indexColumns ); };\n\
keyCodeDict[INDEX_MODE][DOWN_KEY]\n\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex + theSlideIndexPage.indexColumns ); };\n\
keyCodeDict[INDEX_MODE][PAGE_UP_KEY]\n\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex - theSlideIndexPage.getTotalThumbnails() ); };\n\
keyCodeDict[INDEX_MODE][PAGE_DOWN_KEY]\n\
";

static const char aSVGScript14[] =
"\
= function() { return indexSetPageSlide( theSlideIndexPage.selectedSlideIndex + theSlideIndexPage.getTotalThumbnails() ); };\n\
keyCodeDict[INDEX_MODE][HOME_KEY]\n\
= function() { return indexSetPageSlide( 0 ); };\n\
keyCodeDict[INDEX_MODE][END_KEY]\n\
= function() { return indexSetPageSlide( theMetaDoc.nNumberOfSlides - 1 ); };\n\
keyCodeDict[INDEX_MODE][ENTER_KEY]\n\
= function() { return toggleSlideIndex(); };\n\
keyCodeDict[INDEX_MODE][SPACE_KEY]\n\
= function() { return toggleSlideIndex(); };\n\
keyCodeDict[INDEX_MODE][ESCAPE_KEY]\n\
= function() { return abandonIndexMode(); };\n\
\n\
return keyCodeDict;\n\
}\n\
\n\
function getDefaultCharCodeDictionary()\n\
{\n\
var charCodeDict = {};\n\
\n\
charCodeDict[SLIDE_MODE] = {};\n\
charCodeDict[INDEX_MODE] = {};\n\
\n\
charCodeDict[SLIDE_MODE]['i']\n\
= function () { return toggleSlideIndex(); };\n\
\n\
charCodeDict[INDEX_MODE]['i']\n\
= function () { return toggleSlideIndex(); };\n\
charCodeDict[INDEX_MODE]['-']\n\
= function () { return theSlideIndexPage.decreaseNumberOfColumns(); };\n\
charCodeDict[INDEX_MODE]['=']\n\
= function () { return theSlideIndexPage.increaseNumberOfColumns(); };\n\
charCodeDict[INDEX_MODE]['+']\n\
= function () { return theSlideIndexPage.increaseNumberOfColumns(); };\n\
charCodeDict[INDEX_MODE]['0']\n\
= function () { return theSlideIndexPage.resetNumberOfColumns(); };\n\
\n\
return charCodeDict;\n\
}\n\
\n\
\n\
function slideOnMouseUp( aEvt )\n\
{\n\
if (!aEvt)\n\
aEvt = window.event;\n\
\n\
var nOffset = 0;\n\
\n\
if( aEvt.button == 0 )\n\
nOffset = 1;\n\
else if( aEvt.button == 2 )\n\
nOffset = -1;\n\
\n\
if( 0 != nOffset )\n\
dispatchEffects( nOffset );\n\
return true; // the click has been handled\n\
}\n\
\n\
document.handleClick = slideOnMouseUp;\n\
\n\
\n\
function slideOnMouseWheel(aEvt)\n\
{\n\
var delta = 0;\n\
\n\
if (!aEvt)\n\
aEvt = window.event;\n\
\n\
if (aEvt.wheelDelta)\n\
{ // IE Opera\n\
delta = aEvt.wheelDelta/120;\n\
}\n\
else if (aEvt.detail)\n\
{ // MOZ\n\
delta = -aEvt.detail/3;\n\
}\n\
\n\
if (delta > 0)\n\
skipEffects(-1);\n\
else if (delta < 0)\n\
skipEffects(1);\n\
\n\
if (aEvt.preventDefault)\n\
aEvt.preventDefault();\n\
\n\
aEvt.returnValue = false;\n\
}\n\
\n\
if( window.addEventListener )\n\
{\n\
window.addEventListener( 'DOMMouseScroll', function( aEvt ) { return mouseHandlerDispatch( aEvt, MOUSE_WHEEL ); }, false );\n\
}\n\
\n\
window.onmousewheel\n\
= function( aEvt ) { return mouseHandlerDispatch( aEvt, MOUSE_WHEEL ); };\n\
\n\
function mouseHandlerDispatch( aEvt, anAction )\n\
{\n\
if( !aEvt )\n\
aEvt = window.event;\n\
\n\
var retVal = true;\n\
\n\
if ( mouseHandlerDictionary[currentMode] && mouseHandlerDictionary[currentMode][anAction] )\n\
{\n\
var subRetVal = mouseHandlerDictionary[currentMode][anAction]( aEvt );\n\
\n\
if( subRetVal != null && subRetVal != undefined )\n\
retVal = subRetVal;\n\
}\n\
\n\
if( aEvt.preventDefault && !retVal )\n\
aEvt.preventDefault();\n\
\n\
aEvt.returnValue = retVal;\n\
\n\
return retVal;\n\
}\n\
\n\
document.onmouseup = function( aEvt ) { return mouseHandlerDispatch( aEvt, MOUSE_UP ); };\n\
\n\
\n\
function mouseClickHelper( aEvt )\n\
{\n\
if( !Detect.isMozilla )\n\
{\n\
var aWindowObject = document.defaultView;\n\
if( aWindowObject )\n\
{\n\
var aTextSelection = aWindowObject.getSelection();\n\
var sSelectedText =  aTextSelection.toString();\n\
if( sSelectedText )\n\
{\n\
DBGLOG( 'text selection: ' + sSelectedText );\n\
if( sLastSelectedText !== sSelectedText )\n\
{\n\
bTextHasBeenSelected = true;\n\
sLastSelectedText = sSelectedText;\n\
}\n\
else\n\
{\n\
bTextHasBeenSelected = false;\n\
}\n\
return null;\n\
}\n\
else if( bTextHasBeenSelected )\n\
{\n\
bTextHasBeenSelected = false;\n\
sLastSelectedText = '';\n\
return null;\n\
}\n\
";

static const char aSVGScript15[] =
"\
}\n\
else\n\
{\n\
log( 'error: HyperlinkElement.handleClick: invalid window object.' );\n\
}\n\
}\n\
\n\
var aSlideAnimationsHandler = theMetaDoc.aMetaSlideSet[nCurSlide].aSlideAnimationsHandler;\n\
if( aSlideAnimationsHandler )\n\
{\n\
var aCurrentEventMultiplexer = aSlideAnimationsHandler.aEventMultiplexer;\n\
if( aCurrentEventMultiplexer )\n\
{\n\
if( aCurrentEventMultiplexer.hasRegisteredMouseClickHandlers() )\n\
{\n\
return aCurrentEventMultiplexer.notifyMouseClick( aEvt );\n\
}\n\
}\n\
}\n\
return slideOnMouseUp( aEvt );\n\
}\n\
\n\
\n\
function getDefaultMouseHandlerDictionary()\n\
{\n\
var mouseHandlerDict = {};\n\
\n\
mouseHandlerDict[SLIDE_MODE] = {};\n\
mouseHandlerDict[INDEX_MODE] = {};\n\
\n\
mouseHandlerDict[SLIDE_MODE][MOUSE_UP]\n\
= mouseClickHelper;\n\
\n\
mouseHandlerDict[SLIDE_MODE][MOUSE_WHEEL]\n\
= function( aEvt ) { return slideOnMouseWheel( aEvt ); };\n\
\n\
mouseHandlerDict[INDEX_MODE][MOUSE_UP]\n\
= function( ) { return toggleSlideIndex(); };\n\
\n\
return mouseHandlerDict;\n\
}\n\
\n\
function indexSetPageSlide( nIndex )\n\
{\n\
var aMetaSlideSet = theMetaDoc.aMetaSlideSet;\n\
nIndex = getSafeIndex( nIndex, 0, aMetaSlideSet.length - 1 );\n\
\n\
var nSelectedThumbnailIndex = nIndex % theSlideIndexPage.getTotalThumbnails();\n\
var offset = nIndex - nSelectedThumbnailIndex;\n\
\n\
if( offset < 0 )\n\
offset = 0;\n\
\n\
if( offset != INDEX_OFFSET )\n\
{\n\
INDEX_OFFSET = offset;\n\
displayIndex( INDEX_OFFSET );\n\
}\n\
\n\
theSlideIndexPage.setSelection( nSelectedThumbnailIndex );\n\
}\n\
\n\
\n\
/*****\n\
* @jessyinkend\n\
*\n\
*  The above code is a derivative work of some parts of the JessyInk project.\n\
*  @source http://code.google.com/p/jessyink/\n\
*/\n\
\n\
\n\
/*****\n\
* @licstart\n\
*\n\
* The following is the license notice for the part of JavaScript code of this\n\
* page included between the '@dojostart' and the '@dojoend' notes.\n\
*/\n\
\n\
/*****  **********************************************************************\n\
*\n\
*  The 'New' BSD License:\n\
*  **********************\n\
*  Copyright (c) 2005-2012, The Dojo Foundation\n\
*  All rights reserved.\n\
*\n\
*  Redistribution and use in source and binary forms, with or without\n\
*  modification, are permitted provided that the following conditions are met:\n\
*\n\
*    * Redistributions of source code must retain the above copyright notice,\n\
*      this list of conditions and the following disclaimer.\n\
*    * Redistributions in binary form must reproduce the above copyright notice,\n\
*      this list of conditions and the following disclaimer in the documentation\n\
*      and/or other materials provided with the distribution.\n\
*    * Neither the name of the Dojo Foundation nor the names of its contributors\n\
*      may be used to endorse or promote products derived from this software\n\
*      without specific prior written permission.\n\
*\n\
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 'AS IS' AND\n\
*  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n\
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n\
*  DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE\n\
*  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n\
*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\n\
*  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\n\
*  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\n\
*  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n\
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\
*\n\
****************************************************************************/\n\
\n\
\n\
/*****\n\
* @licend\n\
*\n\
* The above is the license notice for the part of JavaScript code of this\n\
* page included between the '@dojostart' and the '@dojoend' notes.\n\
*/\n\
\n\
\n\
/*****\n\
* @dojostart\n\
*\n\
*  The following code is a derivative work of some part of the dojox.gfx library.\n\
*  @source http://svn.dojotoolkit.org/src/dojox/trunk/_base/sniff.js\n\
*/\n\
\n\
function has( name )\n\
{\n\
return has.cache[name];\n\
}\n\
\n\
has.cache = {};\n\
\n\
has.add = function( name, test )\n\
{\n\
has.cache[name] = test;\n\
};\n\
\n\
function configureDetectionTools()\n\
{\n\
if( !navigator )\n\
{\n\
log( 'error: configureDetectionTools: configuration failed' );\n\
return null;\n\
}\n\
\n\
var n = navigator,\n\
dua = n.userAgent,\n\
dav = n.appVersion,\n\
tv = parseFloat(dav);\n\
";

static const char aSVGScript16[] =
"\
\n\
has.add('air', dua.indexOf('AdobeAIR') >= 0);\n\
has.add('khtml', dav.indexOf('Konqueror') >= 0 ? tv : undefined);\n\
has.add('webkit', parseFloat(dua.split('WebKit/')[1]) || undefined);\n\
has.add('chrome', parseFloat(dua.split('Chrome/')[1]) || undefined);\n\
has.add('safari', dav.indexOf('Safari')>=0 && !has('chrome') ? parseFloat(dav.split('Version/')[1]) : undefined);\n\
has.add('mac', dav.indexOf('Macintosh') >= 0);\n\
has.add('quirks', document.compatMode == 'BackCompat');\n\
has.add('ios', /iPhone|iPod|iPad/.test(dua));\n\
has.add('android', parseFloat(dua.split('Android ')[1]) || undefined);\n\
\n\
if(!has('webkit')){\n\
if(dua.indexOf('Opera') >= 0){\n\
has.add('opera', tv >= 9.8 ? parseFloat(dua.split('Version/')[1]) || tv : tv);\n\
}\n\
\n\
if(dua.indexOf('Gecko') >= 0 && !has('khtml') && !has('webkit')){\n\
has.add('mozilla', tv);\n\
}\n\
if(has('mozilla')){\n\
has.add('ff', parseFloat(dua.split('Firefox/')[1] || dua.split('Minefield/')[1]) || undefined);\n\
}\n\
\n\
if(document.all && !has('opera')){\n\
var isIE = parseFloat(dav.split('MSIE ')[1]) || undefined;\n\
\n\
var mode = document.documentMode;\n\
if(mode && mode != 5 && Math.floor(isIE) != mode){\n\
isIE = mode;\n\
}\n\
\n\
has.add('ie', isIE);\n\
}\n\
\n\
has.add('wii', typeof opera != 'undefined' && opera.wiiremote);\n\
}\n\
\n\
var detect =\n\
{\n\
isFF: has('ff'),\n\
\n\
isIE: has('ie'),\n\
\n\
isKhtml: has('khtml'),\n\
\n\
isWebKit: has('webkit'),\n\
\n\
isMozilla: has('mozilla'),\n\
isMoz: has('mozilla'),\n\
\n\
isOpera: has('opera'),\n\
\n\
isSafari: has('safari'),\n\
\n\
isChrome: has('chrome'),\n\
\n\
isMac: has('mac'),\n\
\n\
isIos: has('ios'),\n\
\n\
isAndroid: has('android'),\n\
\n\
isWii: has('wii'),\n\
\n\
isQuirks: has('quirks'),\n\
\n\
isAir: has('air')\n\
};\n\
return detect;\n\
}\n\
\n\
/*****\n\
* @dojoend\n\
*\n\
*  The above code is a derivative work of some part of the dojox.gfx library.\n\
*  @source http://svn.dojotoolkit.org/src/dojox/trunk/_base/sniff.js\n\
*/\n\
\n\
/*****\n\
* @licstart\n\
*\n\
* The following is the license notice for the part of JavaScript code of this\n\
* file included between the '@svgpathstart' and the '@svgpathend' notes.\n\
*/\n\
\n\
/*****  **********************************************************************\n\
*\n\
*   Copyright 2015 The Chromium Authors. All rights reserved.\n\
*\n\
*   The Chromium Authors can be found at\n\
*   http://src.chromium.org/svn/trunk/src/AUTHORS\n\
*\n\
*   Redistribution and use in source and binary forms, with or without\n\
*   modification, are permitted provided that the following conditions are\n\
*   met:\n\
*\n\
*   * Redistributions of source code must retain the above copyright\n\
*   notice, this list of conditions and the following disclaimer.\n\
*   * Redistributions in binary form must reproduce the above\n\
*   copyright notice, this list of conditions and the following disclaimer\n\
*   in the documentation and/or other materials provided with the\n\
*   distribution.\n\
*   * Neither the name of Google Inc. nor the names of its\n\
*   contributors may be used to endorse or promote products derived from\n\
*   this software without specific prior written permission.\n\
*\n\
*   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n\
*   'AS IS' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n\
*   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n\
*   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n\
*   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n\
*   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n\
*   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n\
*   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n\
*   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n\
*   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n\
*   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\
*\n\
****************************************************************************/\n\
\n\
/*****\n\
* @licend\n\
*\n\
* The above is the license notice for the part of JavaScript code of this\n\
* file included between the '@svgpathstart' and the '@svgpathend' notes.\n\
*/\n\
\n\
\n\
/*****\n\
* @svgpathstart\n\
*\n\
*  The following code is a derivative work of some part of the SVGPathSeg API.\n\
*\n\
*  This API is a drop-in replacement for the SVGPathSeg and SVGPathSegList APIs that were removed from\n\
*  SVG2 (https://lists.w3.org/Archives/Public/www-svg/2015Jun/0044.html), including the latest spec\n\
*  changes which were implemented in Firefox 43 and Chrome 46.\n\
*\n\
*  @source https://github.com/progers/pathseg\n\
*/\n\
\n\
(function() { 'use strict';\n\
if (!('SVGPathSeg' in window)) {\n\
window.SVGPathSeg = function(type, typeAsLetter, owningPathSegList) {\n\
this.pathSegType = type;\n\
this.pathSegTypeAsLetter = typeAsLetter;\n\
this._owningPathSegList = owningPathSegList;\n\
}\n\
\n\
window.SVGPathSeg.prototype.classname = 'SVGPathSeg';\n\
\n\
";

static const char aSVGScript17[] =
"\
window.SVGPathSeg.PATHSEG_UNKNOWN = 0;\n\
window.SVGPathSeg.PATHSEG_CLOSEPATH = 1;\n\
window.SVGPathSeg.PATHSEG_MOVETO_ABS = 2;\n\
window.SVGPathSeg.PATHSEG_MOVETO_REL = 3;\n\
window.SVGPathSeg.PATHSEG_LINETO_ABS = 4;\n\
window.SVGPathSeg.PATHSEG_LINETO_REL = 5;\n\
window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS = 6;\n\
window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL = 7;\n\
window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS = 8;\n\
window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL = 9;\n\
window.SVGPathSeg.PATHSEG_ARC_ABS = 10;\n\
window.SVGPathSeg.PATHSEG_ARC_REL = 11;\n\
window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS = 12;\n\
window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL = 13;\n\
window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS = 14;\n\
window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL = 15;\n\
window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS = 16;\n\
window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL = 17;\n\
window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS = 18;\n\
window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL = 19;\n\
\n\
window.SVGPathSeg.prototype._segmentChanged = function() {\n\
if (this._owningPathSegList)\n\
this._owningPathSegList.segmentChanged(this);\n\
}\n\
\n\
window.SVGPathSegClosePath = function(owningPathSegList) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CLOSEPATH, 'z', owningPathSegList);\n\
}\n\
window.SVGPathSegClosePath.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegClosePath.prototype.toString = function() { return '[object SVGPathSegClosePath]'; }\n\
window.SVGPathSegClosePath.prototype._asPathString = function() { return this.pathSegTypeAsLetter; }\n\
window.SVGPathSegClosePath.prototype.clone = function() { return new window.SVGPathSegClosePath(undefined); }\n\
\n\
window.SVGPathSegMovetoAbs = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_MOVETO_ABS, 'M', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegMovetoAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegMovetoAbs.prototype.toString = function() { return '[object SVGPathSegMovetoAbs]'; }\n\
window.SVGPathSegMovetoAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegMovetoAbs.prototype.clone = function() { return new window.SVGPathSegMovetoAbs(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegMovetoAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegMovetoAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegMovetoRel = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_MOVETO_REL, 'm', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegMovetoRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegMovetoRel.prototype.toString = function() { return '[object SVGPathSegMovetoRel]'; }\n\
window.SVGPathSegMovetoRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegMovetoRel.prototype.clone = function() { return new window.SVGPathSegMovetoRel(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegMovetoRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegMovetoRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoAbs = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_ABS, 'L', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegLinetoAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoAbs.prototype.toString = function() { return '[object SVGPathSegLinetoAbs]'; }\n\
window.SVGPathSegLinetoAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegLinetoAbs.prototype.clone = function() { return new window.SVGPathSegLinetoAbs(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegLinetoAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegLinetoAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoRel = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_REL, 'l', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegLinetoRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoRel.prototype.toString = function() { return '[object SVGPathSegLinetoRel]'; }\n\
window.SVGPathSegLinetoRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegLinetoRel.prototype.clone = function() { return new window.SVGPathSegLinetoRel(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegLinetoRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegLinetoRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoCubicAbs = function(owningPathSegList, x, y, x1, y1, x2, y2) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS, 'C', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x1 = x1;\n\
this._y1 = y1;\n\
this._x2 = x2;\n\
this._y2 = y2;\n\
}\n\
window.SVGPathSegCurvetoCubicAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoCubicAbs.prototype.toString = function() { return '[object SVGPathSegCurvetoCubicAbs]'; }\n\
window.SVGPathSegCurvetoCubicAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x1 + ' ' + this._y1 + ' ' + this._x2 + ' ' + this._y2 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoCubicAbs.prototype.clone = function() { return new window.SVGPathSegCurvetoCubicAbs(undefined, this._x, this._y, this._x1, this._y1, this._x2, this._y2); }\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'x1', { get: function() { return this._x1; }, set: function(x1) { this._x1 = x1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'y1', { get: function() { return this._y1; }, set: function(y1) { this._y1 = y1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'x2', { get: function() { return this._x2; }, set: function(x2) { this._x2 = x2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype, 'y2', { get: function() { return this._y2; }, set: function(y2) { this._y2 = y2; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoCubicRel = function(owningPathSegList, x, y, x1, y1, x2, y2) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL, 'c', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x1 = x1;\n\
this._y1 = y1;\n\
this._x2 = x2;\n\
this._y2 = y2;\n\
}\n\
window.SVGPathSegCurvetoCubicRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoCubicRel.prototype.toString = function() { return '[object SVGPathSegCurvetoCubicRel]'; }\n\
window.SVGPathSegCurvetoCubicRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x1 + ' ' + this._y1 + ' ' + this._x2 + ' ' + this._y2 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoCubicRel.prototype.clone = function() { return new window.SVGPathSegCurvetoCubicRel(undefined, this._x, this._y, this._x1, this._y1, this._x2, this._y2); }\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'x1', { get: function() { return this._x1; }, set: function(x1) { this._x1 = x1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'y1', { get: function() { return this._y1; }, set: function(y1) { this._y1 = y1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'x2', { get: function() { return this._x2; }, set: function(x2) { this._x2 = x2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype, 'y2', { get: function() { return this._y2; }, set: function(y2) { this._y2 = y2; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoQuadraticAbs = function(owningPathSegList, x, y, x1, y1) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS, 'Q', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x1 = x1;\n\
this._y1 = y1;\n\
}\n\
window.SVGPathSegCurvetoQuadraticAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoQuadraticAbs.prototype.toString = function() { return '[object SVGPathSegCurvetoQuadraticAbs]'; }\n\
window.SVGPathSegCurvetoQuadraticAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x1 + ' ' + this._y1 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoQuadraticAbs.prototype.clone = function() { return new window.SVGPathSegCurvetoQuadraticAbs(undefined, this._x, this._y, this._x1, this._y1); }\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype, 'x1', { get: function() { return this._x1; }, set: function(x1) { this._x1 = x1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype, 'y1', { get: function() { return this._y1; }, set: function(y1) { this._y1 = y1; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoQuadraticRel = function(owningPathSegList, x, y, x1, y1) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL, 'q', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x1 = x1;\n\
this._y1 = y1;\n\
}\n\
window.SVGPathSegCurvetoQuadraticRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoQuadraticRel.prototype.toString = function() { return '[object SVGPathSegCurvetoQuadraticRel]'; }\n\
window.SVGPathSegCurvetoQuadraticRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x1 + ' ' + this._y1 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoQuadraticRel.prototype.clone = function() { return new window.SVGPathSegCurvetoQuadraticRel(undefined, this._x, this._y, this._x1, this._y1); }\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
";

static const char aSVGScript18[] =
"\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype, 'x1', { get: function() { return this._x1; }, set: function(x1) { this._x1 = x1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype, 'y1', { get: function() { return this._y1; }, set: function(y1) { this._y1 = y1; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegArcAbs = function(owningPathSegList, x, y, r1, r2, angle, largeArcFlag, sweepFlag) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_ARC_ABS, 'A', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._r1 = r1;\n\
this._r2 = r2;\n\
this._angle = angle;\n\
this._largeArcFlag = largeArcFlag;\n\
this._sweepFlag = sweepFlag;\n\
}\n\
window.SVGPathSegArcAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegArcAbs.prototype.toString = function() { return '[object SVGPathSegArcAbs]'; }\n\
window.SVGPathSegArcAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._r1 + ' ' + this._r2 + ' ' + this._angle + ' ' + (this._largeArcFlag ? '1' : '0') + ' ' + (this._sweepFlag ? '1' : '0') + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegArcAbs.prototype.clone = function() { return new window.SVGPathSegArcAbs(undefined, this._x, this._y, this._r1, this._r2, this._angle, this._largeArcFlag, this._sweepFlag); }\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'r1', { get: function() { return this._r1; }, set: function(r1) { this._r1 = r1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'r2', { get: function() { return this._r2; }, set: function(r2) { this._r2 = r2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'angle', { get: function() { return this._angle; }, set: function(angle) { this._angle = angle; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'largeArcFlag', { get: function() { return this._largeArcFlag; }, set: function(largeArcFlag) { this._largeArcFlag = largeArcFlag; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcAbs.prototype, 'sweepFlag', { get: function() { return this._sweepFlag; }, set: function(sweepFlag) { this._sweepFlag = sweepFlag; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegArcRel = function(owningPathSegList, x, y, r1, r2, angle, largeArcFlag, sweepFlag) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_ARC_REL, 'a', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._r1 = r1;\n\
this._r2 = r2;\n\
this._angle = angle;\n\
this._largeArcFlag = largeArcFlag;\n\
this._sweepFlag = sweepFlag;\n\
}\n\
window.SVGPathSegArcRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegArcRel.prototype.toString = function() { return '[object SVGPathSegArcRel]'; }\n\
window.SVGPathSegArcRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._r1 + ' ' + this._r2 + ' ' + this._angle + ' ' + (this._largeArcFlag ? '1' : '0') + ' ' + (this._sweepFlag ? '1' : '0') + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegArcRel.prototype.clone = function() { return new window.SVGPathSegArcRel(undefined, this._x, this._y, this._r1, this._r2, this._angle, this._largeArcFlag, this._sweepFlag); }\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'r1', { get: function() { return this._r1; }, set: function(r1) { this._r1 = r1; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'r2', { get: function() { return this._r2; }, set: function(r2) { this._r2 = r2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'angle', { get: function() { return this._angle; }, set: function(angle) { this._angle = angle; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'largeArcFlag', { get: function() { return this._largeArcFlag; }, set: function(largeArcFlag) { this._largeArcFlag = largeArcFlag; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegArcRel.prototype, 'sweepFlag', { get: function() { return this._sweepFlag; }, set: function(sweepFlag) { this._sweepFlag = sweepFlag; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoHorizontalAbs = function(owningPathSegList, x) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS, 'H', owningPathSegList);\n\
this._x = x;\n\
}\n\
window.SVGPathSegLinetoHorizontalAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoHorizontalAbs.prototype.toString = function() { return '[object SVGPathSegLinetoHorizontalAbs]'; }\n\
window.SVGPathSegLinetoHorizontalAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x; }\n\
window.SVGPathSegLinetoHorizontalAbs.prototype.clone = function() { return new window.SVGPathSegLinetoHorizontalAbs(undefined, this._x); }\n\
Object.defineProperty(window.SVGPathSegLinetoHorizontalAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoHorizontalRel = function(owningPathSegList, x) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL, 'h', owningPathSegList);\n\
this._x = x;\n\
}\n\
window.SVGPathSegLinetoHorizontalRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoHorizontalRel.prototype.toString = function() { return '[object SVGPathSegLinetoHorizontalRel]'; }\n\
window.SVGPathSegLinetoHorizontalRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x; }\n\
window.SVGPathSegLinetoHorizontalRel.prototype.clone = function() { return new window.SVGPathSegLinetoHorizontalRel(undefined, this._x); }\n\
Object.defineProperty(window.SVGPathSegLinetoHorizontalRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoVerticalAbs = function(owningPathSegList, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS, 'V', owningPathSegList);\n\
this._y = y;\n\
}\n\
window.SVGPathSegLinetoVerticalAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoVerticalAbs.prototype.toString = function() { return '[object SVGPathSegLinetoVerticalAbs]'; }\n\
window.SVGPathSegLinetoVerticalAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._y; }\n\
window.SVGPathSegLinetoVerticalAbs.prototype.clone = function() { return new window.SVGPathSegLinetoVerticalAbs(undefined, this._y); }\n\
Object.defineProperty(window.SVGPathSegLinetoVerticalAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegLinetoVerticalRel = function(owningPathSegList, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL, 'v', owningPathSegList);\n\
this._y = y;\n\
}\n\
window.SVGPathSegLinetoVerticalRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegLinetoVerticalRel.prototype.toString = function() { return '[object SVGPathSegLinetoVerticalRel]'; }\n\
window.SVGPathSegLinetoVerticalRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._y; }\n\
window.SVGPathSegLinetoVerticalRel.prototype.clone = function() { return new window.SVGPathSegLinetoVerticalRel(undefined, this._y); }\n\
Object.defineProperty(window.SVGPathSegLinetoVerticalRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoCubicSmoothAbs = function(owningPathSegList, x, y, x2, y2) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS, 'S', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x2 = x2;\n\
this._y2 = y2;\n\
}\n\
window.SVGPathSegCurvetoCubicSmoothAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoCubicSmoothAbs.prototype.toString = function() { return '[object SVGPathSegCurvetoCubicSmoothAbs]'; }\n\
window.SVGPathSegCurvetoCubicSmoothAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x2 + ' ' + this._y2 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoCubicSmoothAbs.prototype.clone = function() { return new window.SVGPathSegCurvetoCubicSmoothAbs(undefined, this._x, this._y, this._x2, this._y2); }\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype, 'x2', { get: function() { return this._x2; }, set: function(x2) { this._x2 = x2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype, 'y2', { get: function() { return this._y2; }, set: function(y2) { this._y2 = y2; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoCubicSmoothRel = function(owningPathSegList, x, y, x2, y2) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL, 's', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
this._x2 = x2;\n\
this._y2 = y2;\n\
}\n\
window.SVGPathSegCurvetoCubicSmoothRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoCubicSmoothRel.prototype.toString = function() { return '[object SVGPathSegCurvetoCubicSmoothRel]'; }\n\
window.SVGPathSegCurvetoCubicSmoothRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x2 + ' ' + this._y2 + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoCubicSmoothRel.prototype.clone = function() { return new window.SVGPathSegCurvetoCubicSmoothRel(undefined, this._x, this._y, this._x2, this._y2); }\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype, 'x2', { get: function() { return this._x2; }, set: function(x2) { this._x2 = x2; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype, 'y2', { get: function() { return this._y2; }, set: function(y2) { this._y2 = y2; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoQuadraticSmoothAbs = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS, 'T', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype.toString = function() { return '[object SVGPathSegCurvetoQuadraticSmoothAbs]'; }\n\
window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype.clone = function() { return new window.SVGPathSegCurvetoQuadraticSmoothAbs(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathSegCurvetoQuadraticSmoothRel = function(owningPathSegList, x, y) {\n\
window.SVGPathSeg.call(this, window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL, 't', owningPathSegList);\n\
this._x = x;\n\
this._y = y;\n\
}\n\
window.SVGPathSegCurvetoQuadraticSmoothRel.prototype = Object.create(window.SVGPathSeg.prototype);\n\
window.SVGPathSegCurvetoQuadraticSmoothRel.prototype.toString = function() { return '[object SVGPathSegCurvetoQuadraticSmoothRel]'; }\n\
window.SVGPathSegCurvetoQuadraticSmoothRel.prototype._asPathString = function() { return this.pathSegTypeAsLetter + ' ' + this._x + ' ' + this._y; }\n\
window.SVGPathSegCurvetoQuadraticSmoothRel.prototype.clone = function() { return new window.SVGPathSegCurvetoQuadraticSmoothRel(undefined, this._x, this._y); }\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothRel.prototype, 'x', { get: function() { return this._x; }, set: function(x) { this._x = x; this._segmentChanged(); }, enumerable: true });\n\
Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothRel.prototype, 'y', { get: function() { return this._y; }, set: function(y) { this._y = y; this._segmentChanged(); }, enumerable: true });\n\
\n\
window.SVGPathElement.prototype.createSVGPathSegClosePath = function() { return new window.SVGPathSegClosePath(undefined); }\n\
window.SVGPathElement.prototype.createSVGPathSegMovetoAbs = function(x, y) { return new window.SVGPathSegMovetoAbs(undefined, x, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegMovetoRel = function(x, y) { return new window.SVGPathSegMovetoRel(undefined, x, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoAbs = function(x, y) { return new window.SVGPathSegLinetoAbs(undefined, x, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoRel = function(x, y) { return new window.SVGPathSegLinetoRel(undefined, x, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicAbs = function(x, y, x1, y1, x2, y2) { return new window.SVGPathSegCurvetoCubicAbs(undefined, x, y, x1, y1, x2, y2); }\n\
";

static const char aSVGScript19[] =
"\
window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicRel = function(x, y, x1, y1, x2, y2) { return new window.SVGPathSegCurvetoCubicRel(undefined, x, y, x1, y1, x2, y2); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticAbs = function(x, y, x1, y1) { return new window.SVGPathSegCurvetoQuadraticAbs(undefined, x, y, x1, y1); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticRel = function(x, y, x1, y1) { return new window.SVGPathSegCurvetoQuadraticRel(undefined, x, y, x1, y1); }\n\
window.SVGPathElement.prototype.createSVGPathSegArcAbs = function(x, y, r1, r2, angle, largeArcFlag, sweepFlag) { return new window.SVGPathSegArcAbs(undefined, x, y, r1, r2, angle, largeArcFlag, sweepFlag); }\n\
window.SVGPathElement.prototype.createSVGPathSegArcRel = function(x, y, r1, r2, angle, largeArcFlag, sweepFlag) { return new window.SVGPathSegArcRel(undefined, x, y, r1, r2, angle, largeArcFlag, sweepFlag); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoHorizontalAbs = function(x) { return new window.SVGPathSegLinetoHorizontalAbs(undefined, x); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoHorizontalRel = function(x) { return new window.SVGPathSegLinetoHorizontalRel(undefined, x); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoVerticalAbs = function(y) { return new window.SVGPathSegLinetoVerticalAbs(undefined, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegLinetoVerticalRel = function(y) { return new window.SVGPathSegLinetoVerticalRel(undefined, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothAbs = function(x, y, x2, y2) { return new window.SVGPathSegCurvetoCubicSmoothAbs(undefined, x, y, x2, y2); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothRel = function(x, y, x2, y2) { return new window.SVGPathSegCurvetoCubicSmoothRel(undefined, x, y, x2, y2); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs = function(x, y) { return new window.SVGPathSegCurvetoQuadraticSmoothAbs(undefined, x, y); }\n\
window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothRel = function(x, y) { return new window.SVGPathSegCurvetoQuadraticSmoothRel(undefined, x, y); }\n\
\n\
if (!('getPathSegAtLength' in window.SVGPathElement.prototype)) {\n\
window.SVGPathElement.prototype.getPathSegAtLength = function(distance) {\n\
if (distance === undefined || !isFinite(distance))\n\
throw 'Invalid arguments.';\n\
\n\
var measurementElement = document.createElementNS('http://www.w3.org/2000/svg', 'path');\n\
measurementElement.setAttribute('d', this.getAttribute('d'));\n\
var lastPathSegment = measurementElement.pathSegList.numberOfItems - 1;\n\
\n\
if (lastPathSegment <= 0)\n\
return 0;\n\
\n\
do {\n\
measurementElement.pathSegList.removeItem(lastPathSegment);\n\
if (distance > measurementElement.getTotalLength())\n\
break;\n\
lastPathSegment--;\n\
} while (lastPathSegment > 0);\n\
return lastPathSegment;\n\
}\n\
}\n\
}\n\
\n\
if (!('SVGPathSegList' in window) || !('appendItem' in window.SVGPathSegList.prototype)) {\n\
window.SVGPathSegList = function(pathElement) {\n\
this._pathElement = pathElement;\n\
this._list = this._parsePath(this._pathElement.getAttribute('d'));\n\
\n\
this._mutationObserverConfig = { 'attributes': true, 'attributeFilter': ['d'] };\n\
this._pathElementMutationObserver = new MutationObserver(this._updateListFromPathMutations.bind(this));\n\
this._pathElementMutationObserver.observe(this._pathElement, this._mutationObserverConfig);\n\
}\n\
\n\
window.SVGPathSegList.prototype.classname = 'SVGPathSegList';\n\
\n\
Object.defineProperty(window.SVGPathSegList.prototype, 'numberOfItems', {\n\
get: function() {\n\
this._checkPathSynchronizedToList();\n\
return this._list.length;\n\
},\n\
enumerable: true\n\
});\n\
\n\
Object.defineProperty(window.SVGPathSegList.prototype, 'length', {\n\
get: function() {\n\
this._checkPathSynchronizedToList();\n\
return this._list.length;\n\
},\n\
enumerable: true\n\
});\n\
\n\
Object.defineProperty(window.SVGPathElement.prototype, 'pathSegList', {\n\
get: function() {\n\
if (!this._pathSegList)\n\
this._pathSegList = new window.SVGPathSegList(this);\n\
return this._pathSegList;\n\
},\n\
enumerable: true\n\
});\n\
Object.defineProperty(window.SVGPathElement.prototype, 'normalizedPathSegList', { get: function() { return this.pathSegList; }, enumerable: true });\n\
Object.defineProperty(window.SVGPathElement.prototype, 'animatedPathSegList', { get: function() { return this.pathSegList; }, enumerable: true });\n\
Object.defineProperty(window.SVGPathElement.prototype, 'animatedNormalizedPathSegList', { get: function() { return this.pathSegList; }, enumerable: true });\n\
\n\
window.SVGPathSegList.prototype._checkPathSynchronizedToList = function() {\n\
this._updateListFromPathMutations(this._pathElementMutationObserver.takeRecords());\n\
}\n\
\n\
window.SVGPathSegList.prototype._updateListFromPathMutations = function(mutationRecords) {\n\
if (!this._pathElement)\n\
return;\n\
var hasPathMutations = false;\n\
mutationRecords.forEach(function(record) {\n\
if (record.attributeName == 'd')\n\
hasPathMutations = true;\n\
});\n\
if (hasPathMutations)\n\
this._list = this._parsePath(this._pathElement.getAttribute('d'));\n\
}\n\
\n\
window.SVGPathSegList.prototype._writeListToPath = function() {\n\
this._pathElementMutationObserver.disconnect();\n\
this._pathElement.setAttribute('d', window.SVGPathSegList._pathSegArrayAsString(this._list));\n\
this._pathElementMutationObserver.observe(this._pathElement, this._mutationObserverConfig);\n\
}\n\
\n\
window.SVGPathSegList.prototype.segmentChanged = function(pathSeg) {\n\
this._writeListToPath();\n\
}\n\
\n\
window.SVGPathSegList.prototype.clear = function() {\n\
this._checkPathSynchronizedToList();\n\
\n\
this._list.forEach(function(pathSeg) {\n\
pathSeg._owningPathSegList = null;\n\
});\n\
this._list = [];\n\
this._writeListToPath();\n\
}\n\
\n\
window.SVGPathSegList.prototype.initialize = function(newItem) {\n\
this._checkPathSynchronizedToList();\n\
\n\
this._list = [newItem];\n\
newItem._owningPathSegList = this;\n\
this._writeListToPath();\n\
return newItem;\n\
}\n\
\n\
window.SVGPathSegList.prototype._checkValidIndex = function(index) {\n\
if (isNaN(index) || index < 0 || index >= this.numberOfItems)\n\
throw 'INDEX_SIZE_ERR';\n\
}\n\
\n\
window.SVGPathSegList.prototype.getItem = function(index) {\n\
this._checkPathSynchronizedToList();\n\
\n\
this._checkValidIndex(index);\n\
return this._list[index];\n\
}\n\
\n\
window.SVGPathSegList.prototype.insertItemBefore = function(newItem, index) {\n\
this._checkPathSynchronizedToList();\n\
\n\
if (index > this.numberOfItems)\n\
index = this.numberOfItems;\n\
if (newItem._owningPathSegList) {\n\
newItem = newItem.clone();\n\
}\n\
this._list.splice(index, 0, newItem);\n\
newItem._owningPathSegList = this;\n\
this._writeListToPath();\n\
return newItem;\n\
}\n\
\n\
window.SVGPathSegList.prototype.replaceItem = function(newItem, index) {\n\
this._checkPathSynchronizedToList();\n\
";

static const char aSVGScript20[] =
"\
\n\
if (newItem._owningPathSegList) {\n\
newItem = newItem.clone();\n\
}\n\
this._checkValidIndex(index);\n\
this._list[index] = newItem;\n\
newItem._owningPathSegList = this;\n\
this._writeListToPath();\n\
return newItem;\n\
}\n\
\n\
window.SVGPathSegList.prototype.removeItem = function(index) {\n\
this._checkPathSynchronizedToList();\n\
\n\
this._checkValidIndex(index);\n\
var item = this._list[index];\n\
this._list.splice(index, 1);\n\
this._writeListToPath();\n\
return item;\n\
}\n\
\n\
window.SVGPathSegList.prototype.appendItem = function(newItem) {\n\
this._checkPathSynchronizedToList();\n\
\n\
if (newItem._owningPathSegList) {\n\
newItem = newItem.clone();\n\
}\n\
this._list.push(newItem);\n\
newItem._owningPathSegList = this;\n\
this._writeListToPath();\n\
return newItem;\n\
};\n\
\n\
window.SVGPathSegList.prototype.matrixTransform = function(aSVGMatrix) {\n\
this._checkPathSynchronizedToList();\n\
\n\
var nLength = this._list.length;\n\
for( var i = 0; i < nLength; ++i )\n\
{\n\
var nX;\n\
var aPathSeg = this._list[i];\n\
switch( aPathSeg.pathSegTypeAsLetter )\n\
{\n\
case 'C':\n\
nX = aPathSeg._x2;\n\
aPathSeg._x2 = aSVGMatrix.a * nX + aSVGMatrix.c * aPathSeg._y2 + aSVGMatrix.e;\n\
aPathSeg._y2 = aSVGMatrix.b * nX + aSVGMatrix.d * aPathSeg._y2 + aSVGMatrix.f;\n\
case 'Q':\n\
nX = aPathSeg._x1;\n\
aPathSeg._x1 = aSVGMatrix.a * nX + aSVGMatrix.c * aPathSeg._y1 + aSVGMatrix.e;\n\
aPathSeg._y1 = aSVGMatrix.b * nX + aSVGMatrix.d * aPathSeg._y1 + aSVGMatrix.f;\n\
case 'M':\n\
case 'L':\n\
nX = aPathSeg._x;\n\
aPathSeg._x = aSVGMatrix.a * nX + aSVGMatrix.c * aPathSeg._y + aSVGMatrix.e;\n\
aPathSeg._y = aSVGMatrix.b * nX + aSVGMatrix.d * aPathSeg._y + aSVGMatrix.f;\n\
break;\n\
default:\n\
log( 'SVGPathSeg.matrixTransform: unexpected path segment type: '\n\
+ aPathSeg.pathSegTypeAsLetter );\n\
}\n\
}\n\
\n\
this._writeListToPath();\n\
};\n\
\n\
window.SVGPathSegList.prototype.changeOrientation = function() {\n\
this._checkPathSynchronizedToList();\n\
\n\
var aPathSegList = this._list;\n\
var nLength = aPathSegList.length;\n\
if( nLength == 0 ) return;\n\
\n\
var nCurrentX = 0;\n\
var nCurrentY = 0;\n\
\n\
var aPathSeg = aPathSegList[0];\n\
if( aPathSeg.pathSegTypeAsLetter == 'M' )\n\
{\n\
nCurrentX = aPathSeg.x;\n\
nCurrentY = aPathSeg.y;\n\
aPathSegList.shift();\n\
--nLength;\n\
}\n\
\n\
var i;\n\
for( i = 0; i < nLength; ++i )\n\
{\n\
aPathSeg = aPathSegList[i];\n\
switch( aPathSeg.pathSegTypeAsLetter )\n\
{\n\
case 'C':\n\
var nX = aPathSeg._x1;\n\
aPathSeg._x1 = aPathSeg._x2;\n\
aPathSeg._x2 = nX;\n\
var nY = aPathSeg._y1;\n\
aPathSeg._y1 = aPathSeg._y2;\n\
aPathSeg._y2 = nY;\n\
case 'M':\n\
case 'L':\n\
case 'Q':\n\
var aPoint = { x: aPathSeg._x, y: aPathSeg._y };\n\
aPathSeg._x = nCurrentX;\n\
aPathSeg._y = nCurrentY;\n\
nCurrentX = aPoint.x;\n\
nCurrentY = aPoint.y;\n\
break;\n\
default:\n\
log( 'SVGPathSegList.changeOrientation: unexpected path segment type: '\n\
+ aPathSeg.pathSegTypeAsLetter );\n\
}\n\
\n\
}\n\
\n\
aPathSegList.reverse();\n\
\n\
var aMovePathSeg = new window.SVGPathSegMovetoAbs( this, nCurrentX, nCurrentY );\n\
aPathSegList.unshift( aMovePathSeg );\n\
\n\
this._writeListToPath();\n\
};\n\
\n\
window.SVGPathSegList._pathSegArrayAsString = function(pathSegArray) {\n\
var string = '';\n\
var first = true;\n\
pathSegArray.forEach(function(pathSeg) {\n\
if (first) {\n\
first = false;\n\
string += pathSeg._asPathString();\n\
} else {\n\
string += ' ' + pathSeg._asPathString();\n\
}\n\
});\n\
return string;\n\
}\n\
\n\
window.SVGPathSegList.prototype._parsePath = function(string) {\n\
if (!string || string.length == 0)\n\
return [];\n\
\n\
var owningPathSegList = this;\n\
\n\
var Builder = function() {\n\
this.pathSegList = [];\n\
}\n\
\n\
Builder.prototype.appendSegment = function(pathSeg) {\n\
this.pathSegList.push(pathSeg);\n\
}\n\
\n\
";

static const char aSVGScript21[] =
"\
var Source = function(string) {\n\
this._string = string;\n\
this._currentIndex = 0;\n\
this._endIndex = this._string.length;\n\
this._previousCommand = window.SVGPathSeg.PATHSEG_UNKNOWN;\n\
\n\
this._skipOptionalSpaces();\n\
}\n\
\n\
Source.prototype._isCurrentSpace = function() {\n\
var character = this._string[this._currentIndex];\n\
return character <= ' ' && (character == ' ' || character == '\\n' || character == '\\t' || character == '\\r' || character == '\\f');\n\
}\n\
\n\
Source.prototype._skipOptionalSpaces = function() {\n\
while (this._currentIndex < this._endIndex && this._isCurrentSpace())\n\
this._currentIndex++;\n\
return this._currentIndex < this._endIndex;\n\
}\n\
\n\
Source.prototype._skipOptionalSpacesOrDelimiter = function() {\n\
if (this._currentIndex < this._endIndex && !this._isCurrentSpace() && this._string.charAt(this._currentIndex) != ',')\n\
return false;\n\
if (this._skipOptionalSpaces()) {\n\
if (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) == ',') {\n\
this._currentIndex++;\n\
this._skipOptionalSpaces();\n\
}\n\
}\n\
return this._currentIndex < this._endIndex;\n\
}\n\
\n\
Source.prototype.hasMoreData = function() {\n\
return this._currentIndex < this._endIndex;\n\
}\n\
\n\
Source.prototype.peekSegmentType = function() {\n\
var lookahead = this._string[this._currentIndex];\n\
return this._pathSegTypeFromChar(lookahead);\n\
}\n\
\n\
Source.prototype._pathSegTypeFromChar = function(lookahead) {\n\
switch (lookahead) {\n\
case 'Z':\n\
case 'z':\n\
return window.SVGPathSeg.PATHSEG_CLOSEPATH;\n\
case 'M':\n\
return window.SVGPathSeg.PATHSEG_MOVETO_ABS;\n\
case 'm':\n\
return window.SVGPathSeg.PATHSEG_MOVETO_REL;\n\
case 'L':\n\
return window.SVGPathSeg.PATHSEG_LINETO_ABS;\n\
case 'l':\n\
return window.SVGPathSeg.PATHSEG_LINETO_REL;\n\
case 'C':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS;\n\
case 'c':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL;\n\
case 'Q':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;\n\
case 'q':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;\n\
case 'A':\n\
return window.SVGPathSeg.PATHSEG_ARC_ABS;\n\
case 'a':\n\
return window.SVGPathSeg.PATHSEG_ARC_REL;\n\
case 'H':\n\
return window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;\n\
case 'h':\n\
return window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;\n\
case 'V':\n\
return window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;\n\
case 'v':\n\
return window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;\n\
case 'S':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;\n\
case 's':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;\n\
case 'T':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;\n\
case 't':\n\
return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;\n\
default:\n\
return window.SVGPathSeg.PATHSEG_UNKNOWN;\n\
}\n\
}\n\
\n\
Source.prototype._nextCommandHelper = function(lookahead, previousCommand) {\n\
if ((lookahead == '+' || lookahead == '-' || lookahead == '.' || (lookahead >= '0' && lookahead <= '9')) && previousCommand != window.SVGPathSeg.PATHSEG_CLOSEPATH) {\n\
if (previousCommand == window.SVGPathSeg.PATHSEG_MOVETO_ABS)\n\
return window.SVGPathSeg.PATHSEG_LINETO_ABS;\n\
if (previousCommand == window.SVGPathSeg.PATHSEG_MOVETO_REL)\n\
return window.SVGPathSeg.PATHSEG_LINETO_REL;\n\
return previousCommand;\n\
}\n\
return window.SVGPathSeg.PATHSEG_UNKNOWN;\n\
}\n\
\n\
Source.prototype.initialCommandIsMoveTo = function() {\n\
if (!this.hasMoreData())\n\
return true;\n\
var command = this.peekSegmentType();\n\
return command == window.SVGPathSeg.PATHSEG_MOVETO_ABS || command == window.SVGPathSeg.PATHSEG_MOVETO_REL;\n\
}\n\
\n\
Source.prototype._parseNumber = function() {\n\
var exponent = 0;\n\
var integer = 0;\n\
var frac = 1;\n\
var decimal = 0;\n\
var sign = 1;\n\
var expsign = 1;\n\
\n\
var startIndex = this._currentIndex;\n\
\n\
this._skipOptionalSpaces();\n\
\n\
if (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) == '+')\n\
this._currentIndex++;\n\
else if (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) == '-') {\n\
this._currentIndex++;\n\
sign = -1;\n\
}\n\
\n\
if (this._currentIndex == this._endIndex || ((this._string.charAt(this._currentIndex) < '0' || this._string.charAt(this._currentIndex) > '9') && this._string.charAt(this._currentIndex) != '.'))\n\
return undefined;\n\
\n\
var startIntPartIndex = this._currentIndex;\n\
while (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) >= '0' && this._string.charAt(this._currentIndex) <= '9')\n\
this._currentIndex++; // Advance to first non-digit.\n\
\n\
if (this._currentIndex != startIntPartIndex) {\n\
var scanIntPartIndex = this._currentIndex - 1;\n\
var multiplier = 1;\n\
while (scanIntPartIndex >= startIntPartIndex) {\n\
integer += multiplier * (this._string.charAt(scanIntPartIndex--) - '0');\n\
multiplier *= 10;\n\
}\n\
}\n\
\n\
if (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) == '.') {\n\
this._currentIndex++;\n\
\n\
if (this._currentIndex >= this._endIndex || this._string.charAt(this._currentIndex) < '0' || this._string.charAt(this._currentIndex) > '9')\n\
return undefined;\n\
while (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) >= '0' && this._string.charAt(this._currentIndex) <= '9') {\n\
frac *= 10;\n\
decimal += (this._string.charAt(this._currentIndex) - '0') / frac;\n\
this._currentIndex += 1;\n\
}\n\
";

static const char aSVGScript22[] =
"\
}\n\
\n\
if (this._currentIndex != startIndex && this._currentIndex + 1 < this._endIndex && (this._string.charAt(this._currentIndex) == 'e' || this._string.charAt(this._currentIndex) == 'E') && (this._string.charAt(this._currentIndex + 1) != 'x' && this._string.charAt(this._currentIndex + 1) != 'm')) {\n\
this._currentIndex++;\n\
\n\
if (this._string.charAt(this._currentIndex) == '+') {\n\
this._currentIndex++;\n\
} else if (this._string.charAt(this._currentIndex) == '-') {\n\
this._currentIndex++;\n\
expsign = -1;\n\
}\n\
\n\
if (this._currentIndex >= this._endIndex || this._string.charAt(this._currentIndex) < '0' || this._string.charAt(this._currentIndex) > '9')\n\
return undefined;\n\
\n\
while (this._currentIndex < this._endIndex && this._string.charAt(this._currentIndex) >= '0' && this._string.charAt(this._currentIndex) <= '9') {\n\
exponent *= 10;\n\
exponent += (this._string.charAt(this._currentIndex) - '0');\n\
this._currentIndex++;\n\
}\n\
}\n\
\n\
var number = integer + decimal;\n\
number *= sign;\n\
\n\
if (exponent)\n\
number *= Math.pow(10, expsign * exponent);\n\
\n\
if (startIndex == this._currentIndex)\n\
return undefined;\n\
\n\
this._skipOptionalSpacesOrDelimiter();\n\
\n\
return number;\n\
}\n\
\n\
Source.prototype._parseArcFlag = function() {\n\
if (this._currentIndex >= this._endIndex)\n\
return undefined;\n\
var flag = false;\n\
var flagChar = this._string.charAt(this._currentIndex++);\n\
if (flagChar == '0')\n\
flag = false;\n\
else if (flagChar == '1')\n\
flag = true;\n\
else\n\
return undefined;\n\
\n\
this._skipOptionalSpacesOrDelimiter();\n\
return flag;\n\
}\n\
\n\
Source.prototype.parseSegment = function() {\n\
var lookahead = this._string[this._currentIndex];\n\
var command = this._pathSegTypeFromChar(lookahead);\n\
if (command == window.SVGPathSeg.PATHSEG_UNKNOWN) {\n\
if (this._previousCommand == window.SVGPathSeg.PATHSEG_UNKNOWN)\n\
return null;\n\
command = this._nextCommandHelper(lookahead, this._previousCommand);\n\
if (command == window.SVGPathSeg.PATHSEG_UNKNOWN)\n\
return null;\n\
} else {\n\
this._currentIndex++;\n\
}\n\
\n\
this._previousCommand = command;\n\
\n\
switch (command) {\n\
case window.SVGPathSeg.PATHSEG_MOVETO_REL:\n\
return new window.SVGPathSegMovetoRel(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_MOVETO_ABS:\n\
return new window.SVGPathSegMovetoAbs(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_REL:\n\
return new window.SVGPathSegLinetoRel(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_ABS:\n\
return new window.SVGPathSegLinetoAbs(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL:\n\
return new window.SVGPathSegLinetoHorizontalRel(owningPathSegList, this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS:\n\
return new window.SVGPathSegLinetoHorizontalAbs(owningPathSegList, this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL:\n\
return new window.SVGPathSegLinetoVerticalRel(owningPathSegList, this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS:\n\
return new window.SVGPathSegLinetoVerticalAbs(owningPathSegList, this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_CLOSEPATH:\n\
this._skipOptionalSpaces();\n\
return new window.SVGPathSegClosePath(owningPathSegList);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), x2: this._parseNumber(), y2: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoCubicRel(owningPathSegList, points.x, points.y, points.x1, points.y1, points.x2, points.y2);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), x2: this._parseNumber(), y2: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoCubicAbs(owningPathSegList, points.x, points.y, points.x1, points.y1, points.x2, points.y2);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL:\n\
var points = {x2: this._parseNumber(), y2: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoCubicSmoothRel(owningPathSegList, points.x, points.y, points.x2, points.y2);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS:\n\
var points = {x2: this._parseNumber(), y2: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoCubicSmoothAbs(owningPathSegList, points.x, points.y, points.x2, points.y2);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoQuadraticRel(owningPathSegList, points.x, points.y, points.x1, points.y1);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegCurvetoQuadraticAbs(owningPathSegList, points.x, points.y, points.x1, points.y1);\n\
case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL:\n\
return new window.SVGPathSegCurvetoQuadraticSmoothRel(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS:\n\
return new window.SVGPathSegCurvetoQuadraticSmoothAbs(owningPathSegList, this._parseNumber(), this._parseNumber());\n\
case window.SVGPathSeg.PATHSEG_ARC_REL:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), arcAngle: this._parseNumber(), arcLarge: this._parseArcFlag(), arcSweep: this._parseArcFlag(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegArcRel(owningPathSegList, points.x, points.y, points.x1, points.y1, points.arcAngle, points.arcLarge, points.arcSweep);\n\
case window.SVGPathSeg.PATHSEG_ARC_ABS:\n\
var points = {x1: this._parseNumber(), y1: this._parseNumber(), arcAngle: this._parseNumber(), arcLarge: this._parseArcFlag(), arcSweep: this._parseArcFlag(), x: this._parseNumber(), y: this._parseNumber()};\n\
return new window.SVGPathSegArcAbs(owningPathSegList, points.x, points.y, points.x1, points.y1, points.arcAngle, points.arcLarge, points.arcSweep);\n\
default:\n\
throw 'Unknown path seg type.'\n\
}\n\
}\n\
\n\
var builder = new Builder();\n\
var source = new Source(string);\n\
\n\
if (!source.initialCommandIsMoveTo())\n\
return [];\n\
while (source.hasMoreData()) {\n\
var pathSeg = source.parseSegment();\n\
if (!pathSeg)\n\
return [];\n\
builder.appendSegment(pathSeg);\n\
}\n\
\n\
return builder.pathSegList;\n\
}\n\
}\n\
}());\n\
\n\
/*****\n\
* @svgpathend\n\
*\n\
*  The above code is a derivative work of some part of the SVGPathSeg API.\n\
*\n\
*  This API is a drop-in replacement for the SVGPathSeg and SVGPathSegList APIs that were removed from\n\
*  SVG2 (https://lists.w3.org/Archives/Public/www-svg/2015Jun/0044.html), including the latest spec\n\
*  changes which were implemented in Firefox 43 and Chrome 46.\n\
*\n\
*  @source https://github.com/progers/pathseg\n\
*/\n\
\n\
\n\
";

static const char aSVGScript23[] =
"\
/*****\n\
* @licstart\n\
*\n\
* The following is the license notice for the part of JavaScript code  of\n\
* this page included between the '@libreofficestart' and the '@libreofficeend'\n\
* notes.\n\
*/\n\
\n\
/*****  ******************************************************************\n\
*\n\
* This file is part of the LibreOffice project.\n\
*\n\
* This Source Code Form is subject to the terms of the Mozilla Public\n\
* License, v. 2.0. If a copy of the MPL was not distributed with this\n\
* file, You can obtain one at http://mozilla.org/MPL/2.0/.\n\
*\n\
* This file incorporates work covered by the following license notice:\n\
*\n\
*   Licensed to the Apache Software Foundation (ASF) under one or more\n\
*   contributor license agreements. See the NOTICE file distributed\n\
*   with this work for additional information regarding copyright\n\
*   ownership. The ASF licenses this file to you under the Apache\n\
*   License, Version 2.0 (the 'License'); you may not use this file\n\
*   except in compliance with the License. You may obtain a copy of\n\
*   the License at http://www.apache.org/licenses/LICENSE-2.0 .\n\
*\n\
************************************************************************/\n\
\n\
/*****\n\
* @licend\n\
*\n\
* The above is the license notice for the part of JavaScript code  of\n\
* this page included between the '@libreofficestart' and the '@libreofficeend'\n\
* notes.\n\
*/\n\
\n\
\n\
/*****\n\
* @libreofficestart\n\
*\n\
* Several parts of the following code are the result of the porting,\n\
* started on August 2011, of the C++ code included in the source\n\
* files placed under the folder '/slideshow/source' and\n\
* sub-folders. This got later rebased onto the AL2-licensed versions\n\
* of those files in early 2013.\n\
* @source https://cgit.freedesktop.org/libreoffice/core/tree/slideshow/source\n\
*\n\
*/\n\
\n\
\n\
window.onload = init;\n\
\n\
\n\
var aOOOElemMetaSlides = 'ooo:meta_slides';\n\
var aOOOElemMetaSlide = 'ooo:meta_slide';\n\
var aOOOElemTextField = 'ooo:text_field';\n\
var aPresentationClipPathId = 'presentation_clip_path';\n\
var aPresentationClipPathShrinkId = 'presentation_clip_path_shrink';\n\
\n\
var aOOOAttrNumberOfSlides = 'number-of-slides';\n\
var aOOOAttrStartSlideNumber= 'start-slide-number';\n\
var aOOOAttrNumberingType = 'page-numbering-type';\n\
var aOOOAttrListItemNumberingType= 'numbering-type';\n\
var aOOOAttrUsePositionedChars = 'use-positioned-chars';\n\
\n\
var aOOOAttrSlide = 'slide';\n\
var aOOOAttrMaster = 'master';\n\
var aOOOAttrDisplayName = 'display-name';\n\
var aOOOAttrSlideDuration = 'slide-duration';\n\
var aOOOAttrHasTransition = 'has-transition';\n\
var aOOOAttrHasCustomBackground = 'has-custom-background';\n\
var aOOOAttrBackgroundVisibility = 'background-visibility';\n\
var aOOOAttrMasterObjectsVisibility = 'master-objects-visibility';\n\
var aOOOAttrPageNumberVisibility = 'page-number-visibility';\n\
var aOOOAttrDateTimeVisibility = 'date-time-visibility';\n\
var aOOOAttrFooterVisibility = 'footer-visibility';\n\
var aOOOAttrHeaderVisibility = 'header-visibility';\n\
var aOOOAttrDateTimeField = 'date-time-field';\n\
var aOOOAttrFooterField = 'footer-field';\n\
var aOOOAttrHeaderField = 'header-field';\n\
\n\
var aOOOAttrDateTimeFormat = 'date-time-format';\n\
\n\
var aOOOAttrTextAdjust = 'text-adjust';\n\
\n\
var aClipPathGroupClassName = 'ClipPathGroup';\n\
var aPageClassName = 'Page';\n\
var aSlideNumberClassName = 'PageNumber';\n\
var aDateTimeClassName = 'DateTime';\n\
var aFooterClassName = 'Footer';\n\
var aHeaderClassName = 'Header';\n\
var aDateClassName = 'Date';\n\
var aTimeClassName = 'Time';\n\
var aSlideNameClassName='PageName';\n\
\n\
var NSS = {};\n\
NSS['svg']='http://www.w3.org/2000/svg';\n\
NSS['rdf']='http://www.w3.org/1999/02/22-rdf-syntax-ns#';\n\
NSS['xlink']='http://www.w3.org/1999/xlink';\n\
NSS['xml']='http://www.w3.org/XML/1998/namespace';\n\
NSS['ooo'] = 'http://xml.openoffice.org/svg/export';\n\
NSS['presentation'] = 'http://sun.com/xmlns/staroffice/presentation';\n\
NSS['smil'] = 'http://www.w3.org/2001/SMIL20/';\n\
NSS['anim'] = 'urn:oasis:names:tc:opendocument:xmlns:animation:1.0';\n\
\n\
var SLIDE_MODE = 1;\n\
var INDEX_MODE = 2;\n\
\n\
var MOUSE_UP = 1;\n\
var MOUSE_DOWN = 2; // eslint-disable-line no-unused-vars\n\
var MOUSE_MOVE = 3; // eslint-disable-line no-unused-vars\n\
var MOUSE_WHEEL = 4;\n\
\n\
var LEFT_KEY = 37;          // cursor left keycode\n\
var UP_KEY = 38;            // cursor up keycode\n\
var RIGHT_KEY = 39;         // cursor right keycode\n\
var DOWN_KEY = 40;          // cursor down keycode\n\
var PAGE_UP_KEY = 33;       // page up keycode\n\
var PAGE_DOWN_KEY = 34;     // page down keycode\n\
var HOME_KEY = 36;          // home keycode\n\
var END_KEY = 35;           // end keycode\n\
var ENTER_KEY = 13;\n\
var SPACE_KEY = 32;\n\
var ESCAPE_KEY = 27;\n\
var B_KEY = 66;\n\
var P_KEY = 80;\n\
var Q_KEY = 81;\n\
var W_KEY = 87;\n\
\n\
var HIDDEN = 0;\n\
var VISIBLE = 1;\n\
var INHERIT = 2;\n\
var aVisibilityAttributeValue = [ 'hidden', 'visible', 'inherit' ];  // eslint-disable-line no-unused-vars\n\
var aVisibilityValue = { 'hidden' : HIDDEN, 'visible' : VISIBLE, 'inherit' : INHERIT };\n\
\n\
var ROOT_NODE = document.getElementsByTagNameNS( NSS['svg'], 'svg' )[0];\n\
var WIDTH = 0;\n\
var HEIGHT = 0;\n\
var INDEX_COLUMNS_DEFAULT = 3;\n\
var INDEX_OFFSET = 0;\n\
\n\
var Detect = configureDetectionTools();\n\
var theMetaDoc;\n\
var theSlideIndexPage;\n\
var currentMode = SLIDE_MODE;\n\
var processingEffect = false;\n\
var nCurSlide = undefined;\n\
var bTextHasBeenSelected = false;\n\
var sLastSelectedText = '';\n\
\n\
";

static const char aSVGScript24[] =
"\
\n\
var charCodeDictionary = getDefaultCharCodeDictionary();\n\
var keyCodeDictionary = getDefaultKeyCodeDictionary();\n\
\n\
var mouseHandlerDictionary = getDefaultMouseHandlerDictionary();\n\
\n\
\n\
function object( aObject )\n\
{\n\
var F = function() {};\n\
F.prototype = aObject;\n\
return new F();\n\
}\n\
\n\
\n\
function extend( aSubType, aSuperType )\n\
{\n\
if (!aSuperType || !aSubType)\n\
{\n\
alert('extend failed, verify dependencies');\n\
}\n\
var OP = Object.prototype;\n\
var sp = aSuperType.prototype;\n\
var rp = object( sp );\n\
aSubType.prototype = rp;\n\
\n\
rp.constructor = aSubType;\n\
aSubType.superclass = sp;\n\
\n\
if (aSuperType != Object && sp.constructor == OP.constructor)\n\
{\n\
sp.constructor = aSuperType;\n\
}\n\
\n\
return aSubType;\n\
}\n\
\n\
\n\
function instantiate( TemplateClass, BaseType )\n\
{\n\
if( !TemplateClass.instanceSet )\n\
TemplateClass.instanceSet = [];\n\
\n\
var nSize = TemplateClass.instanceSet.length;\n\
\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
if( TemplateClass.instanceSet[i].base === BaseType )\n\
return TemplateClass.instanceSet[i].instance;\n\
}\n\
\n\
TemplateClass.instanceSet[ nSize ] = {};\n\
TemplateClass.instanceSet[ nSize ].base = BaseType;\n\
TemplateClass.instanceSet[ nSize ].instance = TemplateClass( BaseType );\n\
\n\
return TemplateClass.instanceSet[ nSize ].instance;\n\
}\n\
\n\
\n\
function Rectangle( aSVGRectElem )\n\
{\n\
var x = parseInt( aSVGRectElem.getAttribute( 'x' ) );\n\
var y = parseInt( aSVGRectElem.getAttribute( 'y' ) );\n\
var width = parseInt( aSVGRectElem.getAttribute( 'width' ) );\n\
var height = parseInt( aSVGRectElem.getAttribute( 'height' ) );\n\
\n\
this.left = x;\n\
this.right = x + width;\n\
this.top = y;\n\
this.bottom = y + height;\n\
}\n\
\n\
function getKeyByValue(aObj, value) {\n\
for(var key in aObj) {\n\
if(aObj[key] == value)\n\
return key;\n\
}\n\
return null;\n\
}\n\
\n\
function log( message )\n\
{\n\
if( typeof console == 'object' )\n\
{\n\
console.log( message );\n\
}\n\
else if( typeof opera == 'object' )\n\
{\n\
opera.postError( message );\n\
}\n\
else if( typeof java == 'object' && typeof java.lang == 'object' )\n\
{\n\
java.lang.System.out.println( message );\n\
}\n\
}\n\
\n\
function getNSAttribute( sNSPrefix, aElem, sAttrName )\n\
{\n\
if( !aElem ) return null;\n\
if( 'getAttributeNS' in aElem )\n\
{\n\
return aElem.getAttributeNS( NSS[sNSPrefix], sAttrName );\n\
}\n\
else\n\
{\n\
return aElem.getAttribute( sNSPrefix + ':' + sAttrName );\n\
}\n\
}\n\
\n\
function getOOOAttribute( aElem, sAttrName )\n\
{\n\
return getNSAttribute( 'ooo', aElem, sAttrName );\n\
}\n\
\n\
function setNSAttribute( sNSPrefix, aElem, sAttrName, aValue )\n\
{\n\
if( !aElem ) return false;\n\
if( 'setAttributeNS' in aElem )\n\
{\n\
aElem.setAttributeNS( NSS[sNSPrefix], sAttrName, aValue );\n\
return true;\n\
}\n\
else\n\
{\n\
aElem.setAttribute(sNSPrefix + ':' + sAttrName, aValue );\n\
return true;\n\
}\n\
}\n\
\n\
function getElementsByClassName( aElem, sClassName )\n\
{\n\
\n\
var aElementSet = [];\n\
if( 'getElementsByClassName' in aElem )\n\
{\n\
aElementSet = aElem.getElementsByClassName( sClassName );\n\
}\n\
else\n\
{\n\
var aElementSetByClassProperty = getElementsByProperty( aElem, 'class' );\n\
for( var i = 0; i < aElementSetByClassProperty.length; ++i )\n\
{\n\
var sAttrClassName = aElementSetByClassProperty[i].getAttribute( 'class' );\n\
if( sAttrClassName == sClassName )\n\
{\n\
aElementSet.push( aElementSetByClassProperty[i] );\n\
}\n\
}\n\
}\n\
return aElementSet;\n\
";

static const char aSVGScript25[] =
"\
}\n\
\n\
function getElementByClassName( aElem, sClassName /*, sTagName */)\n\
{\n\
var aElementSet = getElementsByClassName( aElem, sClassName );\n\
if ( aElementSet.length == 1 )\n\
return aElementSet[0];\n\
else\n\
return null;\n\
}\n\
\n\
function getClassAttribute(  aElem )\n\
{\n\
if( aElem )\n\
return aElem.getAttribute( 'class' );\n\
return '';\n\
}\n\
\n\
function createElementGroup( aParentElement, aElementList, nFrom, nCount, sGroupClass, sGroupId )\n\
{\n\
var nTo = nFrom + nCount;\n\
if( nCount < 1 || aElementList.length < nTo )\n\
{\n\
log( 'createElementGroup: not enough elements available.' );\n\
return;\n\
}\n\
var firstElement = aElementList[nFrom];\n\
if( !firstElement )\n\
{\n\
log( 'createElementGroup: element not found.' );\n\
return;\n\
}\n\
var aGroupElement = document.createElementNS( NSS['svg'], 'g' );\n\
if( sGroupId )\n\
aGroupElement.setAttribute( 'id', sGroupId );\n\
if( sGroupClass )\n\
aGroupElement.setAttribute( 'class', sGroupClass );\n\
aParentElement.insertBefore( aGroupElement, firstElement );\n\
var i = nFrom;\n\
for( ; i < nTo; ++i )\n\
{\n\
aParentElement.removeChild( aElementList[i] );\n\
aGroupElement.appendChild( aElementList[i] );\n\
}\n\
}\n\
\n\
function initVisibilityProperty( aElement )\n\
{\n\
var nVisibility = VISIBLE;\n\
var sVisibility = aElement.getAttribute( 'visibility' );\n\
if( sVisibility ) nVisibility = aVisibilityValue[ sVisibility ];\n\
return nVisibility;\n\
}\n\
\n\
function getSafeIndex( nIndex, nMin, nMax )\n\
{\n\
if( nIndex < nMin )\n\
return nMin;\n\
else if( nIndex > nMax )\n\
return nMax;\n\
else\n\
return nIndex;\n\
}\n\
\n\
function getUrlParameter(name)\n\
{\n\
name = name.replace(/[\\[]/, '\\\\[').replace(/[\\]]/, '\\\\]');\n\
var regex = new RegExp('[\\\\?&]' + name + '=([^&#]*)');\n\
var results = regex.exec(window.location.search);\n\
return results === null ? '' : decodeURIComponent(results[1].replace(/\\+/g, ' '));\n\
}\n\
\n\
function getRandomInt( nMax )\n\
{\n\
return Math.floor( Math.random() * nMax );\n\
}\n\
\n\
\n\
function DebugPrinter()\n\
{\n\
this.bEnabled = false;\n\
}\n\
\n\
\n\
DebugPrinter.prototype.on = function()\n\
{\n\
this.bEnabled = true;\n\
};\n\
\n\
DebugPrinter.prototype.off = function()\n\
{\n\
this.bEnabled = false;\n\
};\n\
\n\
DebugPrinter.prototype.isEnabled = function()\n\
{\n\
return this.bEnabled;\n\
};\n\
\n\
DebugPrinter.prototype.print = function( sMessage, nTime )\n\
{\n\
if( this.isEnabled() )\n\
{\n\
var sInfo = 'DBG: ' + sMessage;\n\
if( nTime )\n\
sInfo += ' (at: ' + String( nTime / 1000 ) + 's)';\n\
log( sInfo );\n\
}\n\
};\n\
\n\
\n\
var aGenericDebugPrinter = new DebugPrinter();\n\
aGenericDebugPrinter.off();\n\
var DBGLOG = bind2( DebugPrinter.prototype.print, aGenericDebugPrinter );\n\
\n\
var NAVDBG = new DebugPrinter();\n\
NAVDBG.off();\n\
\n\
var ANIMDBG = new DebugPrinter();\n\
ANIMDBG.off();\n\
\n\
var aRegisterEventDebugPrinter = new DebugPrinter();\n\
aRegisterEventDebugPrinter.off();\n\
\n\
var aTimerEventQueueDebugPrinter = new DebugPrinter();\n\
aTimerEventQueueDebugPrinter.off();\n\
\n\
var aEventMultiplexerDebugPrinter = new DebugPrinter();\n\
aEventMultiplexerDebugPrinter.off();\n\
\n\
var aNextEffectEventArrayDebugPrinter = new DebugPrinter();\n\
aNextEffectEventArrayDebugPrinter.off();\n\
\n\
var aActivityQueueDebugPrinter = new DebugPrinter();\n\
aActivityQueueDebugPrinter.off();\n\
\n\
var aAnimatedElementDebugPrinter = new DebugPrinter();\n\
aAnimatedElementDebugPrinter.off();\n\
\n\
\n\
function MetaDocument()\n\
{\n\
var aMetaDocElem = document.getElementById( aOOOElemMetaSlides );\n\
assert( aMetaDocElem, 'MetaDocument: the svg element with id:' + aOOOElemMetaSlides + 'is not valid.');\n\
\n\
this.nNumberOfSlides = parseInt( aMetaDocElem.getAttributeNS( NSS['ooo'], aOOOAttrNumberOfSlides ) );\n\
assert( typeof this.nNumberOfSlides == 'number' && this.nNumberOfSlides > 0,\n\
'MetaDocument: number of slides is zero or undefined.' );\n\
this.nStartSlideNumber = parseInt( aMetaDocElem.getAttributeNS( NSS['ooo'], aOOOAttrStartSlideNumber ) ) || 0;\n\
var aParmStartSlideNumber = getUrlParameter('StartSlideNumber');\n\
";

static const char aSVGScript26[] =
"\
if (aParmStartSlideNumber !== '')\n\
{\n\
this.nStartSlideNumber = parseInt(aParmStartSlideNumber);\n\
}\n\
this.sPageNumberingType = aMetaDocElem.getAttributeNS( NSS['ooo'], aOOOAttrNumberingType ) || 'arabic';\n\
this.bIsUsePositionedChars = ( aMetaDocElem.getAttributeNS( NSS['ooo'], aOOOAttrUsePositionedChars ) === 'true' );\n\
\n\
this.aClipPathGroup = getElementByClassName( ROOT_NODE, aClipPathGroupClassName );\n\
assert( this.aClipPathGroup, 'MetaDocument: the clip path group element is not valid.');\n\
\n\
this.aPresentationClipPath = document.getElementById( aPresentationClipPathId );\n\
assert( this.aPresentationClipPath,\n\
'MetaDocument: the presentation clip path element element is not valid.');\n\
\n\
this.aMetaSlideSet = [];\n\
this.aMasterPageSet = {};\n\
this.aTextFieldHandlerSet = {};\n\
this.aTextFieldContentProviderSet = [];\n\
this.aSlideNumberProvider = new SlideNumberProvider( this.nStartSlideNumber + 1, this.sPageNumberingType );\n\
this.aCurrentDateProvider = new CurrentDateTimeProvider( null, '<date>' );\n\
this.aCurrentTimeProvider = new CurrentDateTimeProvider( null, '<time>' );\n\
\n\
this.bIsAnimated = false;\n\
this.aSlideAnimationsMap = {};\n\
this.initSlideAnimationsMap();\n\
\n\
this.theMetaDummySlide = new MetaSlide( 'ooo:meta_dummy_slide', this );\n\
\n\
for( var i = 0; i < this.nNumberOfSlides; ++i )\n\
{\n\
var sMetaSlideId = aOOOElemMetaSlide + '_' + i;\n\
this.aMetaSlideSet.push( new MetaSlide( sMetaSlideId, this ) );\n\
}\n\
assert( this.aMetaSlideSet.length == this.nNumberOfSlides,\n\
'MetaDocument: aMetaSlideSet.length != nNumberOfSlides.' );\n\
}\n\
\n\
MetaDocument.prototype =\n\
{\n\
\n\
getCurrentSlide : function()\n\
{\n\
return this.aMetaSlideSet[nCurSlide];\n\
},\n\
\n\
setCurrentSlide : function( nSlideIndex )\n\
{\n\
if( nSlideIndex >= 0 &&  nSlideIndex < this.nNumberOfSlides )\n\
{\n\
if( nCurSlide !== undefined )\n\
this.aMetaSlideSet[nCurSlide].hide();\n\
this.aMetaSlideSet[nSlideIndex].show();\n\
nCurSlide = nSlideIndex;\n\
}\n\
else\n\
{\n\
log('MetaDocument.setCurrentSlide: slide index out of range: ' + nSlideIndex );\n\
}\n\
},\n\
\n\
\n\
initSlideAnimationsMap : function()\n\
{\n\
var aAnimationsSection = document.getElementById( 'presentation-animations' );\n\
if( aAnimationsSection )\n\
{\n\
var aAnimationsDefSet = aAnimationsSection.getElementsByTagName( 'defs' );\n\
\n\
this.bIsAnimated = ( typeof aAnimationsDefSet.length =='number' &&\n\
aAnimationsDefSet.length > 0 );\n\
\n\
for( var i = 0; i < aAnimationsDefSet.length; ++i )\n\
{\n\
var sSlideId = aAnimationsDefSet[i].getAttributeNS( NSS['ooo'], aOOOAttrSlide );\n\
var aChildSet = getElementChildren( aAnimationsDefSet[i] );\n\
if( sSlideId && ( aChildSet.length === 1 ) )\n\
{\n\
this.aSlideAnimationsMap[ sSlideId ] = aChildSet[0];\n\
}\n\
}\n\
}\n\
}\n\
\n\
}; // end MetaDocument prototype\n\
\n\
function MetaSlide( sMetaSlideId, aMetaDoc )\n\
{\n\
this.theDocument = document;\n\
this.id = sMetaSlideId;\n\
this.theMetaDoc = aMetaDoc;\n\
\n\
this.element = this.theDocument.getElementById( this.id );\n\
assert( this.element,\n\
'MetaSlide: meta_slide element <' + this.id + '> not found.' );\n\
\n\
this.slideId = this.element.getAttributeNS( NSS['ooo'], aOOOAttrSlide );\n\
this.slideElement = this.theDocument.getElementById( this.slideId );\n\
assert( this.slideElement,\n\
'MetaSlide: slide element <' + this.slideId + '> not found.' );\n\
\n\
if( this.slideId !== 'dummy_slide' )\n\
this.nSlideNumber = parseInt( this.slideId.substr(2) );\n\
else\n\
this.nSlideNumber= -1;\n\
\n\
this.slideName = this.element.getAttributeNS( NSS['ooo'], aOOOAttrDisplayName );\n\
\n\
this.aContainerElement = this.slideElement.parentNode;\n\
this.slideContainerId = this.aContainerElement.getAttribute( 'id' );\n\
this.aVisibilityStatusElement = this.aContainerElement.parentNode;\n\
\n\
this.pageElement = getElementByClassName( this.slideElement, aPageClassName );\n\
assert( this.pageElement,\n\
'MetaSlide: page element <' + this.slideId + '> not found.' );\n\
\n\
this.backgroundElement = getElementByClassName( this.pageElement, 'Background' );\n\
if( this.backgroundElement )\n\
{\n\
this.backgroundId = this.backgroundElement.getAttribute( 'id' );\n\
}\n\
\n\
this.initPlaceholderElements();\n\
\n\
this.masterPage = this.initMasterPage();\n\
\n\
this.bHasCustomBackground = this.initHasCustomBackground();\n\
\n\
this.nAreMasterObjectsVisible     = this.initVisibilityProperty( aOOOAttrMasterObjectsVisibility,  VISIBLE );\n\
this.nIsBackgroundVisible         = this.initVisibilityProperty( aOOOAttrBackgroundVisibility,     VISIBLE );\n\
this.nIsPageNumberVisible         = this.initVisibilityProperty( aOOOAttrPageNumberVisibility,     HIDDEN );\n\
this.nIsDateTimeVisible           = this.initVisibilityProperty( aOOOAttrDateTimeVisibility,       VISIBLE );\n\
this.nIsFooterVisible             = this.initVisibilityProperty( aOOOAttrFooterVisibility,         VISIBLE );\n\
this.nIsHeaderVisible             = this.initVisibilityProperty( aOOOAttrHeaderVisibility,         VISIBLE );\n\
\n\
this.bIsDateTimeVariable = undefined;\n\
\n\
this.aTextFieldContentProviderSet = {};\n\
this.aTextFieldContentProviderSet[aSlideNumberClassName]   = this.initSlideNumberFieldContentProvider();\n\
this.aTextFieldContentProviderSet[aDateTimeClassName]      = this.initDateTimeFieldContentProvider( aOOOAttrDateTimeField );\n\
this.aTextFieldContentProviderSet[aFooterClassName]        = this.initFixedTextFieldContentProvider( aOOOAttrFooterField );\n\
this.aTextFieldContentProviderSet[aHeaderClassName]        = this.initFixedTextFieldContentProvider( aOOOAttrHeaderField );\n\
this.aTextFieldContentProviderSet[aDateClassName]          = this.theMetaDoc.aCurrentDateProvider;\n\
this.aTextFieldContentProviderSet[aTimeClassName]          = this.theMetaDoc.aCurrentTimeProvider;\n\
this.aTextFieldContentProviderSet[aSlideNameClassName]     = new FixedTextProvider( this.slideName );\n\
\n\
this.fDuration = this.initSlideDuration();\n\
\n\
this.aTransitionHandler = null;\n\
this.bHasTransition = this.initHasTransition() || true;\n\
if( this.bHasTransition )\n\
";

static const char aSVGScript27[] =
"\
{\n\
this.aTransitionHandler = new SlideTransition( this.getSlideAnimationsRoot(), this.slideId );\n\
}\n\
\n\
this.aSlideAnimationsHandler = new SlideAnimations( aSlideShow.getContext() );\n\
this.aSlideAnimationsHandler.importAnimations( this.getSlideAnimationsRoot() );\n\
this.aSlideAnimationsHandler.parseElements();\n\
\n\
if( false && this.aSlideAnimationsHandler.aRootNode )\n\
log( this.aSlideAnimationsHandler.aRootNode.info( true ) );\n\
\n\
this.aTextShapeSet = this.collectTextShapes();\n\
\n\
this.aHyperlinkSet = this.initHyperlinks();\n\
\n\
}\n\
\n\
MetaSlide.prototype =\n\
{\n\
\n\
show : function()\n\
{\n\
this.updateMasterPageView();\n\
this.aVisibilityStatusElement.setAttribute( 'visibility', 'inherit' );\n\
},\n\
\n\
hide : function()\n\
{\n\
this.aVisibilityStatusElement.setAttribute( 'visibility', 'hidden' );\n\
},\n\
\n\
updateMasterPageView : function()\n\
{\n\
if( !this.aMasterPageView )\n\
{\n\
this.aMasterPageView = new MasterPageView( this );\n\
this.aMasterPageView.attachToSlide();\n\
}\n\
this.aMasterPageView.update();\n\
},\n\
\n\
\n\
initPlaceholderElements : function()\n\
{\n\
var aPlaceholderList = getElementsByClassName(this.pageElement , 'PlaceholderText' );\n\
var i = 0;\n\
for( ; i < aPlaceholderList.length; ++i )\n\
{\n\
var aPlaceholderElem = aPlaceholderList[i];\n\
var sClass = aPlaceholderElem.getAttribute('class');\n\
var sFieldType = sClass.split(' ')[1];\n\
if( sFieldType ===  aDateClassName)\n\
aPlaceholderElem.textContent = new Date().toLocaleDateString();\n\
else if( sFieldType === aTimeClassName )\n\
aPlaceholderElem.textContent = new Date().toLocaleTimeString();\n\
}\n\
},\n\
\n\
initMasterPage : function()\n\
{\n\
var sMasterPageId = this.element.getAttributeNS( NSS['ooo'], aOOOAttrMaster );\n\
\n\
if( !this.theMetaDoc.aMasterPageSet.hasOwnProperty( sMasterPageId ) )\n\
{\n\
this.theMetaDoc.aMasterPageSet[ sMasterPageId ] = new MasterPage( sMasterPageId, this );\n\
\n\
this.theMetaDoc.aTextFieldHandlerSet[ sMasterPageId ] = {};\n\
}\n\
return this.theMetaDoc.aMasterPageSet[ sMasterPageId ];\n\
},\n\
\n\
initSlideDuration : function()\n\
{\n\
var sSlideDuration = this.element.getAttributeNS( NSS['ooo'], aOOOAttrSlideDuration );\n\
if( sSlideDuration && sSlideDuration.length > 0 )\n\
return parseFloat( sSlideDuration );\n\
else\n\
return -1;\n\
},\n\
\n\
initHasTransition : function()\n\
{\n\
var sHasTransition = this.element.getAttributeNS( NSS['ooo'], aOOOAttrHasTransition );\n\
return ( sHasTransition === 'true' );\n\
},\n\
\n\
initHasCustomBackground : function()\n\
{\n\
var sHasCustomBackground = this.element.getAttributeNS( NSS['ooo'], aOOOAttrHasCustomBackground );\n\
return ( sHasCustomBackground === 'true' );\n\
},\n\
\n\
initVisibilityProperty : function( aVisibilityAttribute, nDefaultValue )\n\
{\n\
var nVisibility = nDefaultValue;\n\
var sVisibility = getOOOAttribute( this.element, aVisibilityAttribute );\n\
if( sVisibility )\n\
nVisibility = aVisibilityValue[ sVisibility ];\n\
return nVisibility;\n\
},\n\
\n\
initSlideNumberFieldContentProvider : function()\n\
{\n\
return this.theMetaDoc.aSlideNumberProvider;\n\
},\n\
\n\
initDateTimeFieldContentProvider : function( aOOOAttrDateTimeField )\n\
{\n\
var sTextFieldId = getOOOAttribute( this.element, aOOOAttrDateTimeField );\n\
if( !sTextFieldId )  return null;\n\
\n\
var nLength = aOOOElemTextField.length + 1;\n\
var nIndex = parseInt(sTextFieldId.substring( nLength ) );\n\
if( typeof nIndex != 'number') return null;\n\
\n\
if( !this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ] )\n\
{\n\
var aTextField;\n\
var aTextFieldElem = document.getElementById( sTextFieldId );\n\
var sClassName = getClassAttribute( aTextFieldElem );\n\
if( sClassName == 'FixedDateTimeField' )\n\
{\n\
aTextField = new FixedTextByElementProvider( aTextFieldElem );\n\
this.bIsDateTimeVariable = false;\n\
}\n\
else if( sClassName == 'VariableDateTimeField' )\n\
{\n\
aTextField = new CurrentDateTimeProvider( aTextFieldElem );\n\
this.bIsDateTimeVariable = true;\n\
}\n\
else\n\
{\n\
aTextField = null;\n\
}\n\
this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ] = aTextField;\n\
}\n\
return this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ];\n\
},\n\
\n\
initFixedTextFieldContentProvider : function( aOOOAttribute )\n\
{\n\
var sTextFieldId = getOOOAttribute( this.element, aOOOAttribute );\n\
if( !sTextFieldId ) return null;\n\
\n\
var nLength = aOOOElemTextField.length + 1;\n\
var nIndex = parseInt( sTextFieldId.substring( nLength ) );\n\
if( typeof nIndex != 'number') return null;\n\
\n\
if( !this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ] )\n\
{\n\
";

static const char aSVGScript28[] =
"\
var aTextFieldElem = document.getElementById( sTextFieldId );\n\
this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ]\n\
= new FixedTextByElementProvider( aTextFieldElem );\n\
}\n\
return this.theMetaDoc.aTextFieldContentProviderSet[ nIndex ];\n\
},\n\
\n\
collectTextShapes : function()\n\
{\n\
var aTextShapeSet = [];\n\
var aTextShapeIndexElem = getElementByClassName( document, 'TextShapeIndex' );\n\
if( aTextShapeIndexElem )\n\
{\n\
var aIndexEntryList = getElementChildren( aTextShapeIndexElem );\n\
var i;\n\
for( i = 0; i < aIndexEntryList.length; ++i )\n\
{\n\
var sSlideId = getOOOAttribute( aIndexEntryList[i], 'slide' );\n\
if( sSlideId === this.slideId )\n\
{\n\
var sTextShapeIds = getOOOAttribute( aIndexEntryList[i], 'id-list' );\n\
if( sTextShapeIds )\n\
{\n\
var aTextShapeIdSet =  sTextShapeIds.split( ' ' );\n\
var j;\n\
for( j = 0; j < aTextShapeIdSet.length; ++j )\n\
{\n\
var aTextShapeElem = document.getElementById( aTextShapeIdSet[j] );\n\
if( aTextShapeElem )\n\
{\n\
aTextShapeSet.push( aTextShapeElem );\n\
}\n\
else\n\
{\n\
log( 'warning: MetaSlide.collectTextShapes: text shape with id <' + aTextShapeIdSet[j] + '> is not valid.'  );\n\
}\n\
}\n\
}\n\
break;\n\
}\n\
}\n\
}\n\
return aTextShapeSet;\n\
},\n\
\n\
initHyperlinks : function()\n\
{\n\
var aHyperlinkSet = {};\n\
var i;\n\
for( i = 0; i < this.aTextShapeSet.length; ++i )\n\
{\n\
if( this.aTextShapeSet[i] )\n\
{\n\
var aHyperlinkIdList = getElementByClassName( this.aTextShapeSet[i], 'HyperlinkIdList' );\n\
if( aHyperlinkIdList )\n\
{\n\
var sHyperlinkIds = aHyperlinkIdList.textContent;\n\
if( sHyperlinkIds )\n\
{\n\
var aHyperlinkIdSet = sHyperlinkIds.trim().split( ' ' );\n\
var j;\n\
for( j = 0; j < aHyperlinkIdSet.length; ++j )\n\
{\n\
var sId = aHyperlinkIdSet[j];\n\
aHyperlinkSet[ sId ] = new HyperlinkElement( sId, this.aSlideAnimationsHandler.aEventMultiplexer );\n\
}\n\
}\n\
}\n\
}\n\
}\n\
return aHyperlinkSet;\n\
},\n\
\n\
getSlideAnimationsRoot : function()\n\
{\n\
return this.theMetaDoc.aSlideAnimationsMap[ this.slideId ];\n\
}\n\
\n\
}; // end MetaSlide prototype\n\
\n\
function removeRedundantParagraphFromTextFieldShape( aObject )\n\
{\n\
var aTextElem = getElementByClassName( aObject, 'SVGTextShape' );\n\
if( aTextElem )\n\
{\n\
var aPlaceholderElement = getElementsByClassName(aTextElem, 'PlaceholderText');\n\
if( aPlaceholderElement )\n\
{\n\
var aTextParagraphSet = getElementsByClassName(aTextElem, 'TextParagraph');\n\
if( aTextParagraphSet.length > 1 )\n\
{\n\
var i = aTextParagraphSet.length;\n\
while( i > 1 )\n\
{\n\
aTextElem.removeChild(aTextParagraphSet[i - 1]);\n\
--i;\n\
}\n\
}\n\
}\n\
}\n\
}\n\
\n\
function getTextFieldType ( elem ) {\n\
var sFieldType = null;\n\
var sClass = elem.getAttribute('class');\n\
if( sClass === 'TextShape' )\n\
{\n\
var aPlaceholderElement = getElementByClassName(elem, 'PlaceholderText');\n\
if( aPlaceholderElement )\n\
{\n\
var sClassAttr = aPlaceholderElement.getAttribute('class');\n\
var classes = sClassAttr.split(' ');\n\
sFieldType = classes[1];\n\
}\n\
}\n\
return sFieldType;\n\
}\n\
\n\
function isTextFieldByClassName ( sClassName )\n\
{\n\
return sClassName.indexOf( aDateTimeClassName ) == 0 || sClassName.indexOf( aFooterClassName ) == 0\n\
|| sClassName.indexOf( aHeaderClassName ) == 0 || sClassName.indexOf( aSlideNumberClassName ) == 0\n\
|| sClassName.indexOf( aDateClassName ) == 0 || sClassName.indexOf( aTimeClassName ) == 0\n\
|| sClassName.indexOf( aSlideNameClassName ) == 0;\n\
}\n\
\n\
function MasterPage( sMasterPageId, aMetaSlide )\n\
{\n\
this.id = sMasterPageId;\n\
this.metaSlide = aMetaSlide;\n\
\n\
this.element = document.getElementById( this.id );\n\
assert( this.element,\n\
'MasterPage: master page element <' + this.id + '> not found.' );\n\
\n\
this.background = getElementByClassName( this.element, 'Background' );\n\
if( this.background )\n\
{\n\
this.backgroundId = this.background.getAttribute( 'id' );\n\
this.backgroundVisibility = initVisibilityProperty( this.background );\n\
}\n\
else\n\
{\n\
this.backgroundId = '';\n\
log( 'MasterPage: the background element is not valid.' );\n\
}\n\
\n\
this.backgroundObjects = getElementByClassName( this.element, 'BackgroundObjects' );\n\
this.aBackgroundObjectSubGroupIdList = [];\n\
if( this.backgroundObjects )\n\
";

static const char aSVGScript29[] =
"\
{\n\
this.backgroundObjectsId = this.backgroundObjects.getAttribute( 'id' );\n\
this.backgroundObjectsVisibility = initVisibilityProperty( this.backgroundObjects );\n\
\n\
if( this.backgroundObjectsVisibility != HIDDEN )\n\
{\n\
var aBackgroundObjectList = getElementChildren( this.backgroundObjects );\n\
var nFrom = 0;\n\
var nCount = 0;\n\
var nSubGroupId = 1;\n\
var sClass;\n\
var sId = '';\n\
var i = 0;\n\
for( ; i < aBackgroundObjectList.length; ++i )\n\
{\n\
var aObject = aBackgroundObjectList[i];\n\
removeRedundantParagraphFromTextFieldShape( aObject );\n\
sClass = null;\n\
var sFieldType = getTextFieldType( aObject );\n\
if( sFieldType && aObject.firstElementChild )\n\
{\n\
var sObjId = aObject.firstElementChild.getAttribute( 'id' );\n\
if( sObjId )\n\
{\n\
sClass = sFieldType + '.' + sObjId;\n\
aObject.setAttribute('class', sClass);\n\
}\n\
}\n\
if( !sClass )\n\
{\n\
sClass = aBackgroundObjectList[i].getAttribute('class');\n\
if( sClass === aDateTimeClassName || sClass === aFooterClassName\n\
|| sClass === aHeaderClassName || sClass === aSlideNumberClassName)\n\
{\n\
sClass += '.Default';\n\
aObject.setAttribute('class', sClass);\n\
}\n\
}\n\
if( !sClass || !isTextFieldByClassName( sClass ) )\n\
{\n\
if( nCount === 0 )\n\
{\n\
nFrom = i;\n\
sId = this.backgroundObjectsId + '.' + nSubGroupId;\n\
++nSubGroupId;\n\
this.aBackgroundObjectSubGroupIdList.push( sId );\n\
}\n\
++nCount;\n\
}\n\
else\n\
{\n\
this.aBackgroundObjectSubGroupIdList.push( sClass );\n\
if( nCount !== 0 )\n\
{\n\
createElementGroup( this.backgroundObjects, aBackgroundObjectList, nFrom, nCount, 'BackgroundObjectSubgroup', sId );\n\
nCount = 0;\n\
}\n\
}\n\
}\n\
if( nCount !== 0 )\n\
{\n\
createElementGroup( this.backgroundObjects, aBackgroundObjectList, nFrom, nCount, 'BackgroundObjectSubgroup', sId );\n\
}\n\
}\n\
}\n\
else\n\
{\n\
this.backgroundObjectsId = '';\n\
log( 'MasterPage: the background objects element is not valid.' );\n\
}\n\
\n\
this.aPlaceholderShapeSet = {};\n\
this.initPlaceholderShapes();\n\
}\n\
\n\
MasterPage.prototype =\n\
{\n\
\n\
initPlaceholderShapes : function()\n\
{\n\
var sClassName;\n\
var i = 0;\n\
for( ; i < this.aBackgroundObjectSubGroupIdList.length; ++i )\n\
{\n\
sClassName = this.aBackgroundObjectSubGroupIdList[i];\n\
if( isTextFieldByClassName( sClassName ) )\n\
this.aPlaceholderShapeSet[ sClassName ] = new PlaceholderShape( this, sClassName );\n\
}\n\
}\n\
\n\
}; // end MasterPage prototype\n\
\n\
function PlaceholderShape( aMasterPage, sClassName )\n\
{\n\
this.masterPage = aMasterPage;\n\
this.className = sClassName;\n\
\n\
this.element = null;\n\
this.textElement = null;\n\
this.init();\n\
}\n\
\n\
PlaceholderShape.prototype.isValid = function()\n\
{\n\
return ( this.element && this.textElement );\n\
};\n\
\n\
\n\
PlaceholderShape.prototype.init = function()\n\
{\n\
var aTextFieldElement = getElementByClassName( this.masterPage.backgroundObjects, this.className );\n\
if( aTextFieldElement )\n\
{\n\
var aTextElem = getElementByClassName( aTextFieldElement, 'SVGTextShape' );\n\
if( aTextElem )\n\
{\n\
var aPlaceholderElement = getElementByClassName(aTextElem, 'PlaceholderText');\n\
if( aPlaceholderElement )\n\
{\n\
var aSVGRectElem = getElementByClassName( aTextFieldElement, 'BoundingBox' );\n\
if( aSVGRectElem )\n\
{\n\
var aRect = new Rectangle( aSVGRectElem );\n\
var sTextAdjust = getOOOAttribute( aTextFieldElement, aOOOAttrTextAdjust );\n\
var nMargin = 250; // 1000th mm\n\
var sTextAnchor, sX;\n\
if( sTextAdjust == 'left' )\n\
{\n\
sTextAnchor = 'start';\n\
sX = String( Math.trunc( aRect.left + nMargin ) );\n\
}\n\
else if( sTextAdjust == 'right' )\n\
{\n\
sTextAnchor = 'end';\n\
sX = String( Math.trunc( aRect.right - nMargin ) );\n\
}\n\
else if( sTextAdjust == 'center' )\n\
{\n\
sTextAnchor = 'middle';\n\
var nMiddle = ( aRect.left + aRect.right ) / 2;\n\
sX = String( parseInt( String( nMiddle ) ) );\n\
}\n\
if( sTextAnchor )\n\
{\n\
aTextElem.setAttribute( 'text-anchor', sTextAnchor );\n\
if( sX )\n\
aTextElem.setAttribute( 'x', sX );\n\
\n\
var aTSpanElements = getElementsByClassName( aTextElem, 'TextPosition' );\n\
if( aTSpanElements )\n\
";

static const char aSVGScript30[] =
"\
{\n\
var i = 0;\n\
for( ; i < aTSpanElements.length; ++i )\n\
{\n\
var aTSpanElem = aTSpanElements[i];\n\
aTSpanElem.removeAttribute( 'x' );\n\
if( i !== 0 )\n\
aTSpanElem.removeAttribute( 'y' );\n\
}\n\
}\n\
}\n\
}\n\
\n\
if( this.masterPage.metaSlide.theMetaDoc.bIsUsePositionedChars )\n\
{\n\
var aTextLineGroupElem = aPlaceholderElement.parentNode.parentNode;\n\
if( aTextLineGroupElem )\n\
{\n\
var sFontFamilyAttr = aTextLineGroupElem.getAttribute( 'font-family' );\n\
if( sFontFamilyAttr )\n\
{\n\
var aChildSet = getElementChildren( aTextLineGroupElem );\n\
if( aChildSet.length > 1 )\n\
var i = 1;\n\
for( ; i < aChildSet.length; ++i )\n\
{\n\
aTextLineGroupElem.removeChild( aChildSet[i] );\n\
}\n\
}\n\
}\n\
}\n\
this.textElement = aPlaceholderElement;\n\
}\n\
}\n\
this.element = aTextFieldElement;\n\
}\n\
};\n\
\n\
function MasterPageView( aMetaSlide )\n\
{\n\
this.aMetaSlide = aMetaSlide;\n\
this.aSlideElement = aMetaSlide.slideElement;\n\
this.aPageElement = aMetaSlide.pageElement;\n\
this.aMasterPage = aMetaSlide.masterPage;\n\
this.aMPVElement = this.createElement();\n\
this.bIsAttached = false;\n\
}\n\
\n\
\n\
MasterPageView.prototype.attachToSlide = function()\n\
{\n\
if( !this.bIsAttached )\n\
{\n\
var aInsertedElement = this.aSlideElement.insertBefore( this.aMPVElement, this.aPageElement );\n\
assert( aInsertedElement === this.aMPVElement,\n\
'MasterPageView.attachToSlide: aInsertedElement != this.aMPVElement' );\n\
\n\
this.bIsAttached = true;\n\
}\n\
};\n\
\n\
MasterPageView.prototype.detachFromSlide = function()\n\
{\n\
if( this.bIsAttached )\n\
{\n\
this.aSlideElement.removeChild( this.aMPVElement );\n\
this.bIsAttached = false;\n\
}\n\
};\n\
\n\
MasterPageView.prototype.update = function()\n\
{\n\
if( this.aDateTimeFieldHandler && this.aMetaSlide.bIsDateTimeVariable )\n\
this.aDateTimeFieldHandler.update();\n\
};\n\
\n\
\n\
MasterPageView.prototype.createElement = function()\n\
{\n\
var theDocument = document;\n\
var aMasterPageViewElement = theDocument.createElementNS( NSS['svg'], 'g' );\n\
assert( aMasterPageViewElement,\n\
'MasterPageView.createElement: failed to create a master page view element.' );\n\
aMasterPageViewElement.setAttribute( 'class', 'MasterPageView' );\n\
\n\
var aWhiteRect = theDocument.createElementNS( NSS['svg'], 'rect' );\n\
var nWidthExt = WIDTH / 1000;\n\
var nHeightExt = HEIGHT / 1000;\n\
aWhiteRect.setAttribute( 'x', String( -nWidthExt / 2 ) );\n\
aWhiteRect.setAttribute( 'y', String( -nHeightExt / 2 ) );\n\
aWhiteRect.setAttribute( 'width', String( WIDTH + nWidthExt ) );\n\
aWhiteRect.setAttribute( 'height', String( HEIGHT + nHeightExt ) );\n\
aWhiteRect.setAttribute( 'fill', '#FFFFFF' );\n\
aMasterPageViewElement.appendChild( aWhiteRect );\n\
\n\
if( this.aMetaSlide.nIsBackgroundVisible )\n\
{\n\
var nBackgroundId = this.aMetaSlide.bHasCustomBackground ? this.aMetaSlide.backgroundId : this.aMasterPage.backgroundId;\n\
this.aBackgroundElement = theDocument.createElementNS( NSS['svg'], 'use' );\n\
this.aBackgroundElement.setAttribute( 'class', 'Background' );\n\
setNSAttribute( 'xlink', this.aBackgroundElement,\n\
'href', '#' + nBackgroundId );\n\
\n\
aMasterPageViewElement.appendChild( this.aBackgroundElement );\n\
}\n\
\n\
if( this.aMetaSlide.nAreMasterObjectsVisible )\n\
{\n\
this.aBackgroundObjectsElement = theDocument.createElementNS( NSS['svg'], 'g' );\n\
this.aBackgroundObjectsElement.setAttribute( 'class', 'BackgroundObjects' );\n\
\n\
var aBackgroundObjectSubGroupIdList = this.aMasterPage.aBackgroundObjectSubGroupIdList;\n\
this.aBackgroundSubGroupElementSet = [];\n\
var aPlaceholderShapeSet = this.aMasterPage.aPlaceholderShapeSet;\n\
var aTextFieldContentProviderSet = this.aMetaSlide.aTextFieldContentProviderSet;\n\
var aDefsElement = this.aMetaSlide.element.parentNode;\n\
var aTextFieldHandlerSet = this.aMetaSlide.theMetaDoc.aTextFieldHandlerSet;\n\
var sMasterSlideId = this.aMasterPage.id;\n\
\n\
var i = 0;\n\
var sId;\n\
for( ; i < aBackgroundObjectSubGroupIdList.length; ++i )\n\
{\n\
sId = aBackgroundObjectSubGroupIdList[i];\n\
if( sId.indexOf( aSlideNumberClassName ) == 0 )\n\
{\n\
var nIsPageNumberVisible = sId === (aSlideNumberClassName + '.Default') ? this.aMetaSlide.nIsPageNumberVisible : true;\n\
if( aPlaceholderShapeSet[sId] &&\n\
aPlaceholderShapeSet[sId].isValid() &&\n\
nIsPageNumberVisible &&\n\
aTextFieldContentProviderSet[aSlideNumberClassName] )\n\
{\n\
var aSlideNumberFieldHandler =\n\
new SlideNumberFieldHandler( aPlaceholderShapeSet[sId],\n\
aTextFieldContentProviderSet[aSlideNumberClassName] );\n\
aSlideNumberFieldHandler.update( this.aMetaSlide.nSlideNumber );\n\
aSlideNumberFieldHandler.appendTo( this.aBackgroundObjectsElement );\n\
if ( sId === aSlideNumberClassName + '.Default' )\n\
this.aSlideNumberFieldHandler = aSlideNumberFieldHandler;\n\
}\n\
}\n\
else if( sId === aDateTimeClassName + '.Default' )\n\
{\n\
if( this.aMetaSlide.nIsDateTimeVisible )\n\
{\n\
this.aDateTimeFieldHandler =\n\
this.initTextFieldHandler( sId, aPlaceholderShapeSet,\n\
aTextFieldContentProviderSet, aDefsElement,\n\
aTextFieldHandlerSet, sMasterSlideId );\n\
}\n\
";

static const char aSVGScript31[] =
"\
}\n\
else if( sId === aFooterClassName + '.Default' )\n\
{\n\
if( this.aMetaSlide.nIsFooterVisible )\n\
{\n\
this.aFooterFieldHandler =\n\
this.initTextFieldHandler( sId, aPlaceholderShapeSet,\n\
aTextFieldContentProviderSet, aDefsElement,\n\
aTextFieldHandlerSet, sMasterSlideId );\n\
}\n\
}\n\
else if( sId === aHeaderClassName + '.Default' )\n\
{\n\
if( this.aMetaSlide.nIsHeaderVisible )\n\
{\n\
this.aHeaderFieldHandler =\n\
this.initTextFieldHandler( sId, aPlaceholderShapeSet,\n\
aTextFieldContentProviderSet, aDefsElement,\n\
aTextFieldHandlerSet, sMasterSlideId );\n\
}\n\
}\n\
else if( sId.indexOf( aDateTimeClassName ) == 0\n\
|| sId.indexOf( aFooterClassName ) == 0\n\
|| sId.indexOf( aHeaderClassName ) == 0\n\
|| sId.indexOf( aDateClassName ) == 0\n\
|| sId.indexOf( aTimeClassName ) == 0\n\
|| sId.indexOf( aSlideNameClassName ) == 0 )\n\
{\n\
this.initTextFieldHandler( sId, aPlaceholderShapeSet,\n\
aTextFieldContentProviderSet, aDefsElement,\n\
aTextFieldHandlerSet, sMasterSlideId );\n\
}\n\
else\n\
{\n\
var aBackgroundSubGroupElement = theDocument.createElementNS( NSS['svg'], 'use' );\n\
aBackgroundSubGroupElement.setAttribute( 'class', 'BackgroundObjectSubGroup' );\n\
setNSAttribute( 'xlink', aBackgroundSubGroupElement,\n\
'href', '#' + sId );\n\
this.aBackgroundSubGroupElementSet.push( aBackgroundSubGroupElement );\n\
this.aBackgroundObjectsElement.appendChild( aBackgroundSubGroupElement );\n\
}\n\
\n\
}\n\
aMasterPageViewElement.appendChild( this.aBackgroundObjectsElement );\n\
}\n\
\n\
return aMasterPageViewElement;\n\
};\n\
\n\
MasterPageView.prototype.initTextFieldHandler =\n\
function( sId, aPlaceholderShapeSet, aTextFieldContentProviderSet,\n\
aDefsElement, aTextFieldHandlerSet, sMasterSlideId )\n\
{\n\
var sRefId = null;\n\
var aTextFieldHandler = null;\n\
var sClassName = sId.split('.')[0];\n\
var aPlaceholderShape = aPlaceholderShapeSet[sId];\n\
var aTextFieldContentProvider = aTextFieldContentProviderSet[sClassName];\n\
if( aPlaceholderShape  && aPlaceholderShape.isValid()\n\
&& aTextFieldContentProvider )\n\
{\n\
var sTextFiedHandlerKey = aTextFieldContentProvider.sId + '.' + sId;\n\
if ( !aTextFieldHandlerSet[ sMasterSlideId ][ sTextFiedHandlerKey ] )\n\
{\n\
aTextFieldHandlerSet[ sMasterSlideId ][ sTextFiedHandlerKey ] =\n\
new TextFieldHandler( aPlaceholderShape,\n\
aTextFieldContentProvider );\n\
aTextFieldHandler = aTextFieldHandlerSet[ sMasterSlideId ][ sTextFiedHandlerKey ];\n\
aTextFieldHandler.update();\n\
aTextFieldHandler.appendTo( aDefsElement );\n\
}\n\
else\n\
{\n\
aTextFieldHandler = aTextFieldHandlerSet[ sMasterSlideId ][ sTextFiedHandlerKey ];\n\
}\n\
sRefId = aTextFieldHandler.sId;\n\
}\n\
else if( aPlaceholderShape && aPlaceholderShape.element && aPlaceholderShape.element.firstElementChild\n\
&& !aPlaceholderShape.textElement && !aTextFieldContentProvider )\n\
{\n\
sRefId = aPlaceholderShape.element.firstElementChild.getAttribute('id');\n\
}\n\
\n\
if( sRefId )\n\
{\n\
var aTextFieldElement = document.createElementNS(NSS['svg'], 'use');\n\
aTextFieldElement.setAttribute('class', sClassName);\n\
setNSAttribute('xlink', aTextFieldElement,\n\
'href', '#' + sRefId);\n\
this.aBackgroundObjectsElement.appendChild( aTextFieldElement );\n\
}\n\
return aTextFieldHandler;\n\
};\n\
\n\
function TextFieldHandler( aPlaceholderShape, aTextContentProvider )\n\
{\n\
this.aPlaceHolderShape = aPlaceholderShape;\n\
this.aTextContentProvider = aTextContentProvider;\n\
assert( this.aTextContentProvider,\n\
'TextFieldHandler: text content provider not defined.' );\n\
this.sId = 'tf' + String( TextFieldHandler.getUniqueId() );\n\
this.aTextFieldElement = null;\n\
this.aTextPlaceholderElement = null;\n\
this.cloneElement();\n\
}\n\
\n\
\n\
TextFieldHandler.CURR_UNIQUE_ID = 0;\n\
\n\
TextFieldHandler.getUniqueId = function()\n\
{\n\
++TextFieldHandler.CURR_UNIQUE_ID;\n\
return TextFieldHandler.CURR_UNIQUE_ID;\n\
};\n\
\n\
TextFieldHandler.prototype.cloneElement = function()\n\
{\n\
assert( this.aPlaceHolderShape && this.aPlaceHolderShape.isValid(),\n\
'TextFieldHandler.cloneElement: placeholder shape is not valid.' );\n\
this.aTextFieldElement = this.aPlaceHolderShape.element.cloneNode( true /* deep clone */ );\n\
assert( this.aTextFieldElement,\n\
'TextFieldHandler.cloneElement: aTextFieldElement is not defined' );\n\
this.aTextFieldElement.setAttribute( 'id', this.sId );\n\
this.aTextFieldElement.removeAttribute( 'visibility' );\n\
this.aTextPlaceholderElement = getElementByClassName( this.aTextFieldElement, 'PlaceholderText' );\n\
assert( this.aTextPlaceholderElement,\n\
'TextFieldHandler.cloneElement: aTextPlaceholderElement is not defined' );\n\
};\n\
\n\
\n\
TextFieldHandler.prototype.appendTo = function( aParentNode )\n\
{\n\
if( !this.aTextFieldElement )\n\
{\n\
log( 'TextFieldHandler.appendTo: aTextFieldElement is not defined' );\n\
return;\n\
}\n\
if( !aParentNode )\n\
{\n\
log( 'TextFieldHandler.appendTo: parent node is not defined' );\n\
return;\n\
}\n\
\n\
aParentNode.appendChild( this.aTextFieldElement );\n\
};\n\
\n\
TextFieldHandler.prototype.setTextContent = function( sText )\n\
{\n\
if( !this.aTextPlaceholderElement )\n\
{\n\
";

static const char aSVGScript32[] =
"\
log( 'PlaceholderShape.setTextContent: text element is not valid in placeholder of type '\n\
+ this.className + ' that belongs to master slide ' + this.masterPage.id );\n\
return;\n\
}\n\
this.aTextPlaceholderElement.textContent = sText;\n\
};\n\
\n\
TextFieldHandler.prototype.update = function()\n\
{\n\
if( !this.aTextContentProvider )\n\
log('TextFieldHandler.update: text content provider not defined.');\n\
else\n\
this.aTextContentProvider.update( this );\n\
};\n\
\n\
function SlideNumberFieldHandler( aPlaceholderShape, aTextContentProvider )\n\
{\n\
SlideNumberFieldHandler.superclass.constructor.call( this, aPlaceholderShape, aTextContentProvider );\n\
}\n\
extend( SlideNumberFieldHandler, TextFieldHandler );\n\
\n\
\n\
SlideNumberFieldHandler.prototype.update = function( nPageNumber )\n\
{\n\
if( !this.aTextContentProvider )\n\
log('TextFieldHandler.update: text content provider not defined.');\n\
else\n\
this.aTextContentProvider.update( this, nPageNumber );\n\
};\n\
\n\
\n\
function TextFieldContentProvider()\n\
{\n\
this.sId = TextFieldContentProvider.getUniqueId();\n\
}\n\
\n\
\n\
TextFieldContentProvider.CURR_UNIQUE_ID = 0;\n\
\n\
TextFieldContentProvider.getUniqueId = function()\n\
{\n\
++TextFieldContentProvider.CURR_UNIQUE_ID;\n\
return TextFieldContentProvider.CURR_UNIQUE_ID;\n\
};\n\
\n\
function FixedTextProvider( aText )\n\
{\n\
FixedTextProvider.superclass.constructor.call( this );\n\
this.text = aText;\n\
}\n\
extend( FixedTextProvider, TextFieldContentProvider );\n\
\n\
\n\
FixedTextProvider.prototype.update = function( aFixedTextField )\n\
{\n\
aFixedTextField.setTextContent( this.text );\n\
};\n\
\n\
function FixedTextByElementProvider( aTextFieldContentElement )\n\
{\n\
FixedTextByElementProvider.superclass.constructor.call( this, aTextFieldContentElement.textContent );\n\
}\n\
extend( FixedTextByElementProvider, FixedTextProvider );\n\
\n\
function CurrentDateTimeProvider( aTextFieldContentElement, sDateTimeFormat )\n\
{\n\
CurrentDateTimeProvider.superclass.constructor.call( this, aTextFieldContentElement );\n\
if( aTextFieldContentElement )\n\
this.dateTimeFormat = getOOOAttribute( aTextFieldContentElement, aOOOAttrDateTimeFormat );\n\
else\n\
{\n\
this.dateTimeFormat = sDateTimeFormat;\n\
}\n\
}\n\
extend( CurrentDateTimeProvider, TextFieldContentProvider );\n\
\n\
\n\
CurrentDateTimeProvider.prototype.update = function( aDateTimeField )\n\
{\n\
var sText = this.createDateTimeText();\n\
aDateTimeField.setTextContent( sText );\n\
};\n\
\n\
\n\
CurrentDateTimeProvider.prototype.createDateTimeText = function()\n\
{\n\
var sDate;\n\
if( this.dateTimeFormat === '<date>' )\n\
sDate = new Date().toLocaleDateString();\n\
else if( this.dateTimeFormat === '<time>' )\n\
sDate = new Date().toLocaleTimeString();\n\
else\n\
sDate = new Date().toLocaleDateString();\n\
return sDate;\n\
};\n\
\n\
function SlideNumberProvider( nInitialSlideNumber, sPageNumberingType )\n\
{\n\
SlideNumberProvider.superclass.constructor.call( this );\n\
this.nInitialSlideNumber = nInitialSlideNumber;\n\
this.pageNumberingType = sPageNumberingType;\n\
\n\
}\n\
extend( SlideNumberProvider, TextFieldContentProvider );\n\
\n\
\n\
SlideNumberProvider.prototype.getNumberingType = function()\n\
{\n\
return this.pageNumberingType;\n\
};\n\
\n\
\n\
SlideNumberProvider.prototype.update = function( aSlideNumberField, nSlideNumber )\n\
{\n\
if( nSlideNumber === undefined )\n\
{\n\
if( nCurSlide === undefined )\n\
nSlideNumber = this.nInitialSlideNumber;\n\
else\n\
nSlideNumber = nCurSlide + 1;\n\
}\n\
var sText = this.createSlideNumberText( nSlideNumber, this.getNumberingType() );\n\
aSlideNumberField.setTextContent( sText );\n\
};\n\
\n\
\n\
SlideNumberProvider.prototype.createSlideNumberText = function( nSlideNumber /*, sNumberingType*/ )\n\
{\n\
return String( nSlideNumber );\n\
};\n\
\n\
\n\
function SlideIndexPage()\n\
{\n\
this.pageElementId = 'slide_index';\n\
this.pageBgColor = 'rgb(252,252,252)';\n\
this.pageElement = this.createPageElement();\n\
assert( this.pageElement, 'SlideIndexPage: pageElement is not valid' );\n\
this.indexColumns = INDEX_COLUMNS_DEFAULT;\n\
this.totalThumbnails = this.indexColumns * this.indexColumns;\n\
this.selectedSlideIndex = undefined;\n\
\n\
this.xSpacingFactor = 600/28000;\n\
this.ySpacingFactor = 450/21000;\n\
this.xSpacing = WIDTH * this.xSpacingFactor;\n\
this.ySpacing = HEIGHT * this.ySpacingFactor;\n\
this.halfBorderWidthFactor = ( 300/28000 ) * ( this.indexColumns / 3 );\n\
this.halfBorderWidth = WIDTH * this.halfBorderWidthFactor;\n\
this.borderWidth = 2 * this.halfBorderWidth;\n\
this.scaleFactor = ( 1 - ( this.indexColumns + 1 ) * this.xSpacingFactor ) /\n\
";

static const char aSVGScript33[] =
"\
( this.indexColumns * ( 1 + 2 * this.halfBorderWidthFactor ) );\n\
\n\
this.thumbnailMouseAreaTemplateId = 'thumbnail_mouse_area';\n\
this.thumbnailMouseAreaTemplateElement = null;\n\
this.thumbnailBorderTemplateId = 'thumbnail_border';\n\
this.thumbnailBorderTemplateElement = null;\n\
this.createTemplateElements();\n\
\n\
this.aThumbnailSet = new Array( this.totalThumbnails );\n\
for( var i = 0; i < this.totalThumbnails; ++i )\n\
{\n\
this.aThumbnailSet[i] = new Thumbnail( this, i );\n\
this.aThumbnailSet[i].updateView();\n\
}\n\
\n\
this.curThumbnailIndex = 0;\n\
}\n\
\n\
\n\
SlideIndexPage.prototype.getTotalThumbnails = function()\n\
{\n\
return this.totalThumbnails;\n\
};\n\
\n\
SlideIndexPage.prototype.show = function()\n\
{\n\
this.pageElement.setAttribute( 'display', 'inherit' );\n\
};\n\
\n\
SlideIndexPage.prototype.hide = function()\n\
{\n\
this.pageElement.setAttribute( 'display', 'none' );\n\
};\n\
\n\
SlideIndexPage.prototype.setSelection = function( nIndex )\n\
{\n\
nIndex = getSafeIndex( nIndex, 0, this.getTotalThumbnails() - 1 );\n\
if( this.curThumbnailIndex != nIndex )\n\
{\n\
this.aThumbnailSet[ this.curThumbnailIndex ].unselect();\n\
this.aThumbnailSet[ nIndex ].select();\n\
this.curThumbnailIndex = nIndex;\n\
}\n\
this.selectedSlideIndex = this.aThumbnailSet[ nIndex ].slideIndex;\n\
};\n\
\n\
SlideIndexPage.prototype.createPageElement = function()\n\
{\n\
var aPageElement = document.createElementNS( NSS['svg'], 'g' );\n\
aPageElement.setAttribute( 'id', this.pageElementId );\n\
aPageElement.setAttribute( 'display', 'none' );\n\
aPageElement.setAttribute( 'visibility', 'visible' );\n\
\n\
var sPageBgColor = this.pageBgColor + ';';\n\
var aRectElement = document.createElementNS( NSS['svg'], 'rect' );\n\
aRectElement.setAttribute( 'x', 0 );\n\
aRectElement.setAttribute( 'y', 0 );\n\
aRectElement.setAttribute( 'width', WIDTH );\n\
aRectElement.setAttribute( 'height', HEIGHT );\n\
aRectElement.setAttribute( 'style', 'stroke:none;fill:' + sPageBgColor );\n\
\n\
aPageElement.appendChild( aRectElement );\n\
ROOT_NODE.appendChild( aPageElement );\n\
return( document.getElementById( this.pageElementId ) );\n\
};\n\
\n\
SlideIndexPage.prototype.createTemplateElements = function()\n\
{\n\
var aDefsElement = document.createElementNS( NSS['svg'], 'defs' );\n\
var aRectElement = document.createElementNS( NSS['svg'], 'rect' );\n\
aRectElement.setAttribute( 'id', this.thumbnailBorderTemplateId );\n\
aRectElement.setAttribute( 'x', -this.halfBorderWidth );\n\
aRectElement.setAttribute( 'y', -this.halfBorderWidth );\n\
aRectElement.setAttribute( 'rx', this.halfBorderWidth );\n\
aRectElement.setAttribute( 'ry', this.halfBorderWidth );\n\
aRectElement.setAttribute( 'width', WIDTH + this.halfBorderWidth );\n\
aRectElement.setAttribute( 'height', HEIGHT + this.halfBorderWidth );\n\
aRectElement.setAttribute( 'stroke-width', this.borderWidth );\n\
aRectElement.setAttribute( 'fill', 'none' );\n\
aDefsElement.appendChild( aRectElement );\n\
\n\
aRectElement = document.createElementNS( NSS['svg'], 'rect' );\n\
aRectElement.setAttribute( 'id', this.thumbnailMouseAreaTemplateId );\n\
aRectElement.setAttribute( 'x', 0 );\n\
aRectElement.setAttribute( 'y', 0 );\n\
aRectElement.setAttribute( 'width', WIDTH );\n\
aRectElement.setAttribute( 'height', HEIGHT );\n\
aRectElement.setAttribute( 'fill', this.pageBgColor );\n\
aDefsElement.appendChild( aRectElement );\n\
\n\
this.pageElement.appendChild( aDefsElement );\n\
\n\
this.thumbnailMouseAreaTemplateElement = document.getElementById( this.thumbnailMouseAreaTemplateId );\n\
this.thumbnailBorderTemplateElement = document.getElementById( this.thumbnailBorderTemplateId );\n\
};\n\
\n\
SlideIndexPage.prototype.decreaseNumberOfColumns  = function()\n\
{\n\
this.setNumberOfColumns( this.indexColumns - 1 );\n\
};\n\
\n\
SlideIndexPage.prototype.increaseNumberOfColumns  = function()\n\
{\n\
this.setNumberOfColumns( this.indexColumns + 1 );\n\
};\n\
\n\
SlideIndexPage.prototype.resetNumberOfColumns  = function()\n\
{\n\
this.setNumberOfColumns( INDEX_COLUMNS_DEFAULT );\n\
};\n\
\n\
SlideIndexPage.prototype.setNumberOfColumns  = function( nNumberOfColumns )\n\
{\n\
if( this.indexColumns == nNumberOfColumns )  return;\n\
if( nNumberOfColumns < 2 || nNumberOfColumns > 6 ) return;\n\
\n\
var suspendHandle = ROOT_NODE.suspendRedraw(500);\n\
\n\
var nOldTotalThumbnails = this.totalThumbnails;\n\
this.indexColumns = nNumberOfColumns;\n\
this.totalThumbnails = nNumberOfColumns * nNumberOfColumns;\n\
\n\
this.aThumbnailSet[this.curThumbnailIndex].unselect();\n\
\n\
var i;\n\
for( i = this.totalThumbnails; i < nOldTotalThumbnails; ++i )\n\
{\n\
this.aThumbnailSet[i].removeElement();\n\
}\n\
\n\
for( i = nOldTotalThumbnails; i < this.totalThumbnails; ++i )\n\
{\n\
this.aThumbnailSet[i] = new Thumbnail( this, i );\n\
}\n\
\n\
this.halfBorderWidthFactor = ( 300/28000 ) * ( this.indexColumns / 3 );\n\
this.halfBorderWidth = WIDTH * this.halfBorderWidthFactor;\n\
this.borderWidth = 2 * this.halfBorderWidth;\n\
this.scaleFactor = ( 1 - ( this.indexColumns + 1 ) * this.xSpacingFactor ) /\n\
( this.indexColumns * ( 1 + 2 * this.halfBorderWidthFactor ) );\n\
\n\
var aRectElement = this.thumbnailBorderTemplateElement;\n\
aRectElement.setAttribute( 'x', -this.halfBorderWidth );\n\
aRectElement.setAttribute( 'y', -this.halfBorderWidth );\n\
aRectElement.setAttribute( 'rx', this.halfBorderWidth );\n\
aRectElement.setAttribute( 'ry', this.halfBorderWidth );\n\
aRectElement.setAttribute( 'width', WIDTH + this.halfBorderWidth );\n\
aRectElement.setAttribute( 'height', HEIGHT + this.halfBorderWidth );\n\
aRectElement.setAttribute( 'stroke-width', this.borderWidth );\n\
\n\
";

static const char aSVGScript34[] =
"\
for( i = 0; i < this.totalThumbnails; ++i )\n\
{\n\
this.aThumbnailSet[i].updateView();\n\
}\n\
\n\
this.curThumbnailIndex = this.selectedSlideIndex % this.totalThumbnails;\n\
this.aThumbnailSet[this.curThumbnailIndex].select();\n\
\n\
INDEX_OFFSET = -1;\n\
indexSetPageSlide( this.selectedSlideIndex );\n\
\n\
ROOT_NODE.unsuspendRedraw( suspendHandle );\n\
ROOT_NODE.forceRedraw();\n\
};\n\
\n\
\n\
function Thumbnail( aSlideIndexPage, nIndex )\n\
{\n\
this.container = aSlideIndexPage;\n\
this.index = nIndex;//= getSafeIndex( nIndex, 0, this.container.getTotalThumbnails() );\n\
this.pageElement = this.container.pageElement;\n\
this.thumbnailId = 'thumbnail' + this.index;\n\
this.thumbnailElement = this.createThumbnailElement();\n\
this.slideElement = getElementByClassName( this.thumbnailElement, 'Slide' );\n\
this.borderElement = getElementByClassName( this.thumbnailElement, 'Border' );\n\
this.mouseAreaElement = getElementByClassName( this.thumbnailElement, 'MouseArea' );\n\
this.aTransformSet = new Array( 3 );\n\
this.visibility = VISIBLE;\n\
this.isSelected = false;\n\
}\n\
\n\
Thumbnail.prototype.sNormalBorderColor = 'rgb(216,216,216)';\n\
Thumbnail.prototype.sSelectionBorderColor = 'rgb(92,92,255)';\n\
\n\
Thumbnail.prototype.removeElement = function()\n\
{\n\
if( this.thumbnailElement )\n\
this.container.pageElement.removeChild( this.thumbnailElement );\n\
};\n\
\n\
Thumbnail.prototype.show = function()\n\
{\n\
if( this.visibility == HIDDEN )\n\
{\n\
this.thumbnailElement.setAttribute( 'display', 'inherit' );\n\
this.visibility = VISIBLE;\n\
}\n\
};\n\
\n\
Thumbnail.prototype.hide = function()\n\
{\n\
if( this.visibility == VISIBLE )\n\
{\n\
this.thumbnailElement.setAttribute( 'display', 'none' );\n\
this.visibility = HIDDEN;\n\
}\n\
};\n\
\n\
Thumbnail.prototype.select = function()\n\
{\n\
if( !this.isSelected )\n\
{\n\
this.borderElement.setAttribute( 'stroke', this.sSelectionBorderColor );\n\
this.isSelected = true;\n\
}\n\
};\n\
\n\
Thumbnail.prototype.unselect = function()\n\
{\n\
if( this.isSelected )\n\
{\n\
this.borderElement.setAttribute( 'stroke', this.sNormalBorderColor );\n\
this.isSelected = false;\n\
}\n\
};\n\
\n\
Thumbnail.prototype.updateView = function()\n\
{\n\
this.column = this.index % this.container.indexColumns;\n\
this.row = ( this.index - this.column ) / this.container.indexColumns;\n\
this.halfBorderWidth = this.container.halfBorderWidth;\n\
this.borderWidth = this.container.borderWidth;\n\
this.width = ( WIDTH + this.borderWidth ) * this.container.scaleFactor;\n\
this.height = ( HEIGHT + this.borderWidth ) * this.container.scaleFactor;\n\
this.aTransformSet[2] = 'translate(' + this.halfBorderWidth + ' ' + this.halfBorderWidth + ')';\n\
this.aTransformSet[1] = 'scale(' + this.container.scaleFactor + ')';\n\
var sTransformAttrValue = this.computeTransform();\n\
this.thumbnailElement.setAttribute( 'transform', sTransformAttrValue );\n\
this.mouseAreaElement.setAttribute( 'onmouseover', 'theSlideIndexPage.aThumbnailSet[' + this.index  + '].onMouseOver()' );\n\
};\n\
\n\
Thumbnail.prototype.update = function( nIndex )\n\
{\n\
if( this.slideIndex == nIndex )  return;\n\
\n\
var aMetaSlide = theMetaDoc.aMetaSlideSet[nIndex];\n\
aMetaSlide.updateMasterPageView();\n\
setNSAttribute( 'xlink', this.slideElement, 'href', '#' + aMetaSlide.slideId );\n\
this.slideIndex = nIndex;\n\
};\n\
\n\
Thumbnail.prototype.clear = function( )\n\
{\n\
setNSAttribute( 'xlink', this.slideElement, 'href', '' );\n\
};\n\
\n\
Thumbnail.prototype.createThumbnailElement = function()\n\
{\n\
var aThumbnailElement = document.createElementNS( NSS['svg'], 'g' );\n\
aThumbnailElement.setAttribute( 'id', this.thumbnailId );\n\
aThumbnailElement.setAttribute( 'display', 'inherit' );\n\
\n\
var aSlideElement = document.createElementNS( NSS['svg'], 'use' );\n\
setNSAttribute( 'xlink', aSlideElement, 'href', '' );\n\
aSlideElement.setAttribute( 'class', 'Slide' );\n\
aThumbnailElement.appendChild( aSlideElement );\n\
\n\
var aMouseAreaElement = document.createElementNS( NSS['svg'], 'use' );\n\
setNSAttribute( 'xlink', aMouseAreaElement, 'href', '#' + this.container.thumbnailMouseAreaTemplateId );\n\
aMouseAreaElement.setAttribute( 'class', 'MouseArea' );\n\
aMouseAreaElement.setAttribute( 'opacity', 0.0 );\n\
aThumbnailElement.appendChild( aMouseAreaElement );\n\
\n\
var aBorderElement = document.createElementNS( NSS['svg'], 'use' );\n\
setNSAttribute( 'xlink', aBorderElement, 'href', '#' + this.container.thumbnailBorderTemplateId );\n\
aBorderElement.setAttribute( 'stroke', this.sNormalBorderColor );\n\
aBorderElement.setAttribute( 'class', 'Border' );\n\
aThumbnailElement.appendChild( aBorderElement );\n\
\n\
this.container.pageElement.appendChild( aThumbnailElement );\n\
return( document.getElementById( this.thumbnailId ) );\n\
};\n\
\n\
Thumbnail.prototype.computeTransform = function()\n\
{\n\
var nXSpacing = this.container.xSpacing;\n\
var nYSpacing = this.container.ySpacing;\n\
\n\
var nXOffset = nXSpacing + ( this.width + nXSpacing ) * this.column;\n\
var nYOffset = nYSpacing + ( this.height + nYSpacing ) * this.row;\n\
\n\
this.aTransformSet[0] = 'translate(' + nXOffset + ' ' + nYOffset + ')';\n\
\n\
var sTransform = this.aTransformSet.join( ' ' );\n\
\n\
return sTransform;\n\
};\n\
\n\
Thumbnail.prototype.onMouseOver = function()\n\
{\n\
";

static const char aSVGScript35[] =
"\
if( ( currentMode == INDEX_MODE ) && ( this.container.curThumbnailIndex !=  this.index ) )\n\
{\n\
this.container.setSelection( this.index );\n\
}\n\
};\n\
\n\
\n\
function init()\n\
{\n\
var VIEWBOX = ROOT_NODE.getAttribute('viewBox');\n\
\n\
if( VIEWBOX )\n\
{\n\
WIDTH = ROOT_NODE.viewBox.animVal.width;\n\
HEIGHT = ROOT_NODE.viewBox.animVal.height;\n\
}\n\
\n\
aSlideShow = new SlideShow();\n\
theMetaDoc =  new MetaDocument();\n\
aSlideShow.bIsEnabled = theMetaDoc.bIsAnimated;\n\
theSlideIndexPage = new SlideIndexPage();\n\
aSlideShow.displaySlide( theMetaDoc.nStartSlideNumber, false );\n\
\n\
var hammer = new Hammer(ROOT_NODE);\n\
hammer.on('swipeleft', function() {\n\
switchSlide(1, false);\n\
});\n\
hammer.on('swiperight', function() {\n\
switchSlide(-1, false);\n\
});\n\
hammer.get('swipe').set({ direction: Hammer.DIRECTION_ALL });\n\
hammer.on('swipeup', function() {\n\
aSlideShow.exitSlideShowInApp();\n\
});\n\
hammer.on('swipedown', function() {\n\
aSlideShow.exitSlideShowInApp();\n\
});\n\
}\n\
\n\
function presentationEngineStop(message)\n\
{\n\
alert( message + '\\nThe presentation engine will be stopped' );\n\
document.onkeydown = null;\n\
document.onkeypress = null;\n\
document.onclick = null;\n\
window.onmousewheel = null;\n\
}\n\
\n\
function assert( condition, message )\n\
{\n\
if (!condition)\n\
{\n\
presentationEngineStop( message );\n\
if (typeof console == 'object')\n\
console.trace();\n\
throw new Error( message );\n\
}\n\
}\n\
\n\
function dispatchEffects(dir)\n\
{\n\
\n\
if( dir == 1 )\n\
{\n\
var bRet = aSlideShow.nextEffect();\n\
\n\
if( !bRet )\n\
{\n\
switchSlide( 1, false );\n\
}\n\
}\n\
else\n\
{\n\
switchSlide( dir, false );\n\
}\n\
}\n\
\n\
function skipAllEffects()\n\
{\n\
var bRet = aSlideShow.skipAllEffects();\n\
if( !bRet )\n\
{\n\
switchSlide( 1, true );\n\
}\n\
}\n\
\n\
function skipEffects(dir)\n\
{\n\
if( dir == 1 )\n\
{\n\
var bRet = aSlideShow.skipPlayingOrNextEffect();\n\
\n\
if( !bRet )\n\
{\n\
switchSlide( 1, true );\n\
}\n\
}\n\
else\n\
{\n\
switchSlide( dir, true );\n\
}\n\
}\n\
\n\
function switchSlide( nOffset, bSkipTransition )\n\
{\n\
var nNextSlide = nCurSlide + nOffset;\n\
aSlideShow.displaySlide( nNextSlide, bSkipTransition );\n\
}\n\
\n\
function displayIndex( offsetNumber )\n\
{\n\
var aMetaSlideSet = theMetaDoc.aMetaSlideSet;\n\
offsetNumber = getSafeIndex( offsetNumber, 0, aMetaSlideSet.length - 1 );\n\
\n\
var nTotalThumbnails = theSlideIndexPage.getTotalThumbnails();\n\
var nEnd = Math.min( offsetNumber + nTotalThumbnails, aMetaSlideSet.length);\n\
\n\
var aThumbnailSet = theSlideIndexPage.aThumbnailSet;\n\
var j = 0;\n\
for( var i = offsetNumber; i < nEnd; ++i, ++j )\n\
{\n\
aThumbnailSet[j].update( i );\n\
aThumbnailSet[j].show();\n\
}\n\
for( ; j < nTotalThumbnails; ++j )\n\
{\n\
aThumbnailSet[j].hide();\n\
}\n\
\n\
if (INDEX_OFFSET != offsetNumber)\n\
INDEX_OFFSET = offsetNumber;\n\
}\n\
\n\
function toggleSlideIndex()\n\
{\n\
if( currentMode == SLIDE_MODE )\n\
{\n\
\n\
theMetaDoc.getCurrentSlide().hide();\n\
INDEX_OFFSET = -1;\n\
indexSetPageSlide( nCurSlide );\n\
theSlideIndexPage.show();\n\
currentMode = INDEX_MODE;\n\
}\n\
else if( currentMode == INDEX_MODE )\n\
{\n\
theSlideIndexPage.hide();\n\
var nNewSlide = theSlideIndexPage.selectedSlideIndex;\n\
\n\
aSlideShow.displaySlide( nNewSlide, true );\n\
";

static const char aSVGScript36[] =
"\
currentMode = SLIDE_MODE;\n\
}\n\
}\n\
\n\
function abandonIndexMode()\n\
{\n\
theSlideIndexPage.selectedSlideIndex = nCurSlide;\n\
toggleSlideIndex();\n\
}\n\
\n\
\n\
var CURR_UNIQUE_ID = 0;\n\
\n\
function getUniqueId()\n\
{\n\
++CURR_UNIQUE_ID;\n\
return CURR_UNIQUE_ID;\n\
}\n\
\n\
function mem_fn( sMethodName )\n\
{\n\
return  function( aObject )\n\
{\n\
var aMethod = aObject[ sMethodName ];\n\
if( aMethod )\n\
aMethod.call( aObject );\n\
else\n\
log( 'method sMethodName not found' );\n\
};\n\
}\n\
\n\
function bind( aObject, aMethod )\n\
{\n\
return  function()\n\
{\n\
return aMethod.call( aObject, arguments[0] );\n\
};\n\
}\n\
\n\
function bind2( aFunction )\n\
{\n\
if( !aFunction  )\n\
log( 'bind2: passed function is not valid.' );\n\
\n\
var aBoundArgList = arguments;\n\
\n\
var aResultFunction = null;\n\
\n\
switch( aBoundArgList.length )\n\
{\n\
case 1: aResultFunction = function()\n\
{\n\
return aFunction.call( arguments[0], arguments[1],\n\
arguments[2], arguments[3],\n\
arguments[4] );\n\
};\n\
break;\n\
case 2: aResultFunction = function()\n\
{\n\
return aFunction.call( aBoundArgList[1], arguments[0],\n\
arguments[1], arguments[2],\n\
arguments[3] );\n\
};\n\
break;\n\
case 3: aResultFunction = function()\n\
{\n\
return aFunction.call( aBoundArgList[1], aBoundArgList[2],\n\
arguments[0], arguments[1],\n\
arguments[2] );\n\
};\n\
break;\n\
case 4: aResultFunction = function()\n\
{\n\
return aFunction.call( aBoundArgList[1], aBoundArgList[2],\n\
aBoundArgList[3], arguments[0],\n\
arguments[1] );\n\
};\n\
break;\n\
case 5: aResultFunction = function()\n\
{\n\
return aFunction.call( aBoundArgList[1], aBoundArgList[2],\n\
aBoundArgList[3], aBoundArgList[4],\n\
arguments[0] );\n\
};\n\
break;\n\
default:\n\
log( 'bind2: arity not handled.' );\n\
}\n\
\n\
return aResultFunction;\n\
}\n\
\n\
function getCurrentSystemTime()\n\
{\n\
return ( new Date() ).getTime();\n\
}\n\
\n\
function getSlideAnimationsRoot( sSlideId )\n\
{\n\
return theMetaDoc.aSlideAnimationsMap[ sSlideId ];\n\
}\n\
\n\
function getElementChildren( aElement )\n\
{\n\
var aChildrenArray = [];\n\
\n\
var nSize = aElement.childNodes.length;\n\
\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
if( aElement.childNodes[i].nodeType == 1 )\n\
aChildrenArray.push( aElement.childNodes[i] );\n\
}\n\
\n\
return aChildrenArray;\n\
}\n\
\n\
function removeWhiteSpaces( str )\n\
{\n\
if( !str )\n\
return '';\n\
\n\
var re = / */;\n\
var aSplitString = str.split( re );\n\
return aSplitString.join('');\n\
}\n\
\n\
function clamp( nValue, nMinimum, nMaximum )\n\
{\n\
if( nValue < nMinimum )\n\
{\n\
return nMinimum;\n\
}\n\
else if( nValue > nMaximum )\n\
{\n\
return nMaximum;\n\
}\n\
else\n\
{\n\
return nValue;\n\
}\n\
}\n\
\n\
function makeMatrixString( a, b, c, d, e, f )\n\
{\n\
var s = 'matrix(';\n\
s += a + ', ';\n\
s += b + ', ';\n\
s += c + ', ';\n\
s += d + ', ';\n\
";

static const char aSVGScript37[] =
"\
s += e + ', ';\n\
s += f + ')';\n\
\n\
return s;\n\
}\n\
\n\
function matrixToString( aSVGMatrix )\n\
{\n\
return makeMatrixString( aSVGMatrix.a, aSVGMatrix.b, aSVGMatrix.c,\n\
aSVGMatrix.d, aSVGMatrix.e, aSVGMatrix.f );\n\
}\n\
\n\
\n\
function numberParser( sValue )\n\
{\n\
if( typeof sValue !== 'string' )\n\
return undefined;\n\
if( sValue === '.' )\n\
return undefined;\n\
var reFloatNumber = /^[+-]?[0-9]*[.]?[0-9]*$/;\n\
\n\
if( reFloatNumber.test( sValue ) )\n\
return parseFloat( sValue );\n\
else\n\
return undefined;\n\
}\n\
\n\
function booleanParser( sValue )\n\
{\n\
if( typeof sValue !== 'string' )\n\
return undefined;\n\
\n\
sValue = sValue.toLowerCase();\n\
if( sValue === 'true' )\n\
return true;\n\
else if( sValue === 'false' )\n\
return false;\n\
else\n\
return undefined;\n\
}\n\
\n\
function colorParser( sValue )\n\
{\n\
if( typeof sValue !== 'string' )\n\
return undefined;\n\
\n\
\n\
function hsl( nHue, nSaturation, nLuminance )\n\
{\n\
return new HSLColor( nHue, nSaturation / 100, nLuminance / 100 );\n\
}\n\
\n\
function rgb( nRed, nGreen, nBlue )\n\
{\n\
return new RGBColor( nRed / 255, nGreen / 255, nBlue / 255 );\n\
}\n\
\n\
function prgb( nRed, nGreen, nBlue )\n\
{\n\
return new RGBColor( nRed / 100, nGreen / 100, nBlue / 100 );\n\
}\n\
\n\
var sCommaPattern = ' *[,] *';\n\
var sIntegerPattern = '[+-]?[0-9]+';\n\
var sHexDigitPattern = '[0-9A-Fa-f]';\n\
\n\
var sHexColorPattern = '#(' + sHexDigitPattern + '{2})('\n\
+ sHexDigitPattern + '{2})('\n\
+ sHexDigitPattern + '{2})';\n\
\n\
var sRGBIntegerPattern = 'rgb[(] *' + sIntegerPattern + sCommaPattern\n\
+ sIntegerPattern + sCommaPattern\n\
+ sIntegerPattern + ' *[)]';\n\
\n\
var sRGBPercentPattern = 'rgb[(] *' + sIntegerPattern + '%' + sCommaPattern\n\
+ sIntegerPattern + '%' + sCommaPattern\n\
+ sIntegerPattern + '%' + ' *[)]';\n\
\n\
var sHSLPercentPattern = 'hsl[(] *' + sIntegerPattern + sCommaPattern\n\
+ sIntegerPattern + '%' + sCommaPattern\n\
+ sIntegerPattern + '%' + ' *[)]';\n\
\n\
var reHexColor = new RegExp( sHexColorPattern );\n\
var reRGBInteger = new RegExp( sRGBIntegerPattern );\n\
var reRGBPercent = new RegExp( sRGBPercentPattern );\n\
var reHSLPercent = new RegExp( sHSLPercentPattern );\n\
\n\
if( reHexColor.test( sValue ) )\n\
{\n\
var aRGBTriple = reHexColor.exec( sValue );\n\
\n\
var nRed    = parseInt( aRGBTriple[1], 16 ) / 255;\n\
var nGreen  = parseInt( aRGBTriple[2], 16 ) / 255;\n\
var nBlue   = parseInt( aRGBTriple[3], 16 ) / 255;\n\
\n\
return new RGBColor( nRed, nGreen, nBlue );\n\
}\n\
else if( reHSLPercent.test( sValue ) )\n\
{\n\
sValue = sValue.replace( '%', '' ).replace( '%', '' );\n\
return eval( sValue );\n\
}\n\
else if( reRGBInteger.test( sValue ) )\n\
{\n\
return eval( sValue );\n\
}\n\
else if( reRGBPercent.test( sValue ) )\n\
{\n\
sValue = 'p' + sValue.replace( '%', '' ).replace( '%', '' ).replace( '%', '' );\n\
return eval( sValue );\n\
}\n\
else\n\
{\n\
return null;\n\
}\n\
}\n\
\n\
\n\
function RGBColor( nRed, nGreen, nBlue )\n\
{\n\
this.eColorSpace = COLOR_SPACE_RGB;\n\
this.nRed = nRed;\n\
this.nGreen = nGreen;\n\
this.nBlue = nBlue;\n\
}\n\
\n\
\n\
RGBColor.prototype.clone = function()\n\
{\n\
return new RGBColor( this.nRed, this.nGreen, this.nBlue );\n\
};\n\
\n\
RGBColor.prototype.equal = function( aRGBColor )\n\
{\n\
return ( this.nRed == aRGBColor.nRed ) &&\n\
( this.nGreen == aRGBColor.nGreen ) &&\n\
( this.nBlue == aRGBColor.nBlue );\n\
};\n\
\n\
RGBColor.prototype.add = function( aRGBColor )\n\
{\n\
this.nRed += aRGBColor.nRed;\n\
this.nGreen += aRGBColor.nGreen;\n\
this.nBlue += aRGBColor.nBlue;\n\
return this;\n\
};\n\
\n\
RGBColor.prototype.scale = function( aT )\n\
{\n\
this.nRed *= aT;\n\
";

static const char aSVGScript38[] =
"\
this.nGreen *= aT;\n\
this.nBlue *= aT;\n\
return this;\n\
};\n\
\n\
RGBColor.clamp = function( aRGBColor )\n\
{\n\
var aClampedRGBColor = new RGBColor( 0, 0, 0 );\n\
\n\
aClampedRGBColor.nRed   = clamp( aRGBColor.nRed, 0.0, 1.0 );\n\
aClampedRGBColor.nGreen = clamp( aRGBColor.nGreen, 0.0, 1.0 );\n\
aClampedRGBColor.nBlue  = clamp( aRGBColor.nBlue, 0.0, 1.0 );\n\
\n\
return aClampedRGBColor;\n\
};\n\
\n\
RGBColor.prototype.convertToHSL = function()\n\
{\n\
var nRed   = clamp( this.nRed, 0.0, 1.0 );\n\
var nGreen = clamp( this.nGreen, 0.0, 1.0 );\n\
var nBlue  = clamp( this.nBlue, 0.0, 1.0 );\n\
\n\
var nMax = Math.max( nRed, nGreen, nBlue );\n\
var nMin = Math.min( nRed, nGreen, nBlue );\n\
var nDelta = nMax - nMin;\n\
\n\
var nLuminance  = ( nMax + nMin ) / 2.0;\n\
var nSaturation = 0.0;\n\
var nHue = 0.0;\n\
if( nDelta !== 0 )\n\
{\n\
nSaturation = ( nLuminance > 0.5 ) ?\n\
( nDelta / ( 2.0 - nMax - nMin) ) :\n\
( nDelta / ( nMax + nMin ) );\n\
\n\
if( nRed == nMax )\n\
nHue = ( nGreen - nBlue ) / nDelta;\n\
else if( nGreen == nMax )\n\
nHue = 2.0 + ( nBlue - nRed ) / nDelta;\n\
else if( nBlue == nMax )\n\
nHue = 4.0 + ( nRed - nGreen ) / nDelta;\n\
\n\
nHue *= 60.0;\n\
\n\
if( nHue < 0.0 )\n\
nHue += 360.0;\n\
}\n\
\n\
return new HSLColor( nHue, nSaturation, nLuminance );\n\
\n\
};\n\
\n\
RGBColor.prototype.toString = function( bClamped )\n\
{\n\
var aRGBColor;\n\
if( bClamped )\n\
{\n\
aRGBColor = RGBColor.clamp( this );\n\
}\n\
else\n\
{\n\
aRGBColor = this;\n\
}\n\
\n\
var nRed = Math.round( aRGBColor.nRed * 255 );\n\
var nGreen = Math.round( aRGBColor.nGreen * 255 );\n\
var nBlue = Math.round( aRGBColor.nBlue * 255 );\n\
\n\
return ( 'rgb(' + nRed + ',' + nGreen + ',' + nBlue + ')' );\n\
};\n\
\n\
RGBColor.interpolate = function( aStartRGB , aEndRGB, nT )\n\
{\n\
var aResult = aStartRGB.clone();\n\
var aTEndRGB = aEndRGB.clone();\n\
aResult.scale( 1.0 - nT );\n\
aTEndRGB.scale( nT );\n\
aResult.add( aTEndRGB );\n\
\n\
return aResult;\n\
};\n\
\n\
\n\
function HSLColor( nHue, nSaturation, nLuminance )\n\
{\n\
this.eColorSpace = COLOR_SPACE_HSL;\n\
this.nHue = nHue;\n\
this.nSaturation = nSaturation;\n\
this.nLuminance = nLuminance;\n\
\n\
this.normalizeHue();\n\
}\n\
\n\
\n\
HSLColor.prototype.clone = function()\n\
{\n\
return new HSLColor( this.nHue, this.nSaturation, this.nLuminance );\n\
};\n\
\n\
HSLColor.prototype.equal = function( aHSLColor )\n\
{\n\
return ( this.nHue == aHSLColor.nHue ) &&\n\
( this.nSaturation += aHSLColor.nSaturation ) &&\n\
( this.nLuminance += aHSLColor.nLuminance );\n\
};\n\
\n\
HSLColor.prototype.add = function( aHSLColor )\n\
{\n\
this.nHue += aHSLColor.nHue;\n\
this.nSaturation += aHSLColor.nSaturation;\n\
this.nLuminance += aHSLColor.nLuminance;\n\
this.normalizeHue();\n\
return this;\n\
};\n\
\n\
HSLColor.prototype.scale = function( aT )\n\
{\n\
this.nHue *= aT;\n\
this.nSaturation *= aT;\n\
this.nLuminance *= aT;\n\
this.normalizeHue();\n\
return this;\n\
};\n\
\n\
HSLColor.clamp = function( aHSLColor )\n\
{\n\
var aClampedHSLColor = new HSLColor( 0, 0, 0 );\n\
\n\
aClampedHSLColor.nHue = aHSLColor.nHue % 360;\n\
if( aClampedHSLColor.nHue < 0 )\n\
aClampedHSLColor.nHue += 360;\n\
aClampedHSLColor.nSaturation = clamp( aHSLColor.nSaturation, 0.0, 1.0 );\n\
aClampedHSLColor.nLuminance = clamp( aHSLColor.nLuminance, 0.0, 1.0 );\n\
};\n\
\n\
HSLColor.prototype.normalizeHue = function()\n\
{\n\
this.nHue = this.nHue % 360;\n\
if( this.nHue < 0 ) this.nHue += 360;\n\
};\n\
\n\
HSLColor.prototype.toString = function()\n\
{\n\
return 'hsl(' + this.nHue.toFixed( 3 ) + ','\n\
+ this.nSaturation.toFixed( 3 ) + ','\n\
+ this.nLuminance.toFixed( 3 ) + ')';\n\
};\n\
\n\
HSLColor.prototype.convertToRGB = function()\n\
{\n\
";

static const char aSVGScript39[] =
"\
\n\
var nHue = this.nHue % 360;\n\
if( nHue < 0 ) nHue += 360;\n\
var nSaturation =  clamp( this.nSaturation, 0.0, 1.0 );\n\
var nLuminance = clamp( this.nLuminance, 0.0, 1.0 );\n\
\n\
\n\
if( nSaturation === 0 )\n\
{\n\
return new RGBColor( nLuminance, nLuminance, nLuminance );\n\
}\n\
\n\
var nVal1 = ( nLuminance <= 0.5 ) ?\n\
( nLuminance * (1.0 + nSaturation) ) :\n\
( nLuminance + nSaturation - nLuminance * nSaturation );\n\
\n\
var nVal2 = 2.0 * nLuminance - nVal1;\n\
\n\
var nRed    = HSLColor.hsl2rgbHelper( nVal2, nVal1, nHue + 120 );\n\
var nGreen  = HSLColor.hsl2rgbHelper( nVal2, nVal1, nHue );\n\
var nBlue   = HSLColor.hsl2rgbHelper( nVal2, nVal1, nHue - 120 );\n\
\n\
return new RGBColor( nRed, nGreen, nBlue );\n\
};\n\
\n\
HSLColor.hsl2rgbHelper = function( nValue1, nValue2, nHue )\n\
{\n\
nHue = nHue % 360;\n\
if( nHue < 0 )\n\
nHue += 360;\n\
\n\
if( nHue < 60.0 )\n\
return nValue1 + ( nValue2 - nValue1 ) * nHue / 60.0;\n\
else if( nHue < 180.0 )\n\
return nValue2;\n\
else if( nHue < 240.0 )\n\
return ( nValue1 + ( nValue2 - nValue1 ) * ( 240.0 - nHue ) / 60.0 );\n\
else\n\
return nValue1;\n\
};\n\
\n\
HSLColor.interpolate = function( aFrom, aTo, nT, bCCW )\n\
{\n\
var nS = 1.0 - nT;\n\
\n\
var nHue = 0.0;\n\
if( aFrom.nHue <= aTo.nHue && !bCCW )\n\
{\n\
nHue = nS * (aFrom.nHue + 360.0) + nT * aTo.nHue;\n\
}\n\
else if( aFrom.nHue > aTo.nHue && bCCW )\n\
{\n\
nHue = nS * aFrom.nHue + nT * (aTo.nHue + 360.0);\n\
}\n\
else\n\
{\n\
nHue = nS * aFrom.nHue + nT * aTo.nHue;\n\
}\n\
\n\
var nSaturation = nS * aFrom.nSaturation + nT * aTo.nSaturation;\n\
var nLuminance = nS * aFrom.nLuminance + nT * aTo.nLuminance;\n\
\n\
return new HSLColor( nHue, nSaturation, nLuminance );\n\
};\n\
\n\
\n\
var SVGIdentityMatrix = document.documentElement.createSVGMatrix();\n\
\n\
SVGMatrix.prototype.setToIdentity = function()\n\
{\n\
this.a = this.d = 1;\n\
this.b = this.c = this.d = this.e = 0;\n\
};\n\
\n\
SVGMatrix.prototype.setToRotationAroundPoint = function( nX, nY, nAngle )\n\
{\n\
nAngle = Math.PI * nAngle / 180;\n\
var nSin = Math.sin( nAngle );\n\
var nCos = Math.cos( nAngle );\n\
\n\
this.a = nCos; this.c = -nSin; this.e = nX * (1 - nCos) + nY * nSin;\n\
this.b = nSin; this.d =  nCos; this.f = nY * (1 - nCos) - nX * nSin;\n\
};\n\
\n\
\n\
SVGPathElement.prototype.prependPath = function( aPath )\n\
{\n\
var sPathData = aPath.getAttribute( 'd' );\n\
sPathData += ( ' ' + this.getAttribute( 'd' ) );\n\
this.setAttribute( 'd', sPathData );\n\
};\n\
\n\
SVGPathElement.prototype.appendPath = function( aPath )\n\
{\n\
var sPathData = this.getAttribute( 'd' );\n\
sPathData += ( ' ' + aPath.getAttribute( 'd' ) );\n\
this.setAttribute( 'd', sPathData );\n\
};\n\
\n\
function flipOnYAxis( aPath )\n\
{\n\
var aPolyPath = aPath.cloneNode(true);\n\
var aTransform = document.documentElement.createSVGMatrix();\n\
aTransform.a = -1;\n\
aTransform.e = 1;\n\
aPolyPath.matrixTransform(aTransform);\n\
return aPolyPath;\n\
}\n\
\n\
function flipOnXAxis( aPath )\n\
{\n\
var aPolyPath = aPath.cloneNode(true);\n\
var aTransform = document.documentElement.createSVGMatrix();\n\
aTransform.d = -1;\n\
aTransform.f = 1;\n\
aPolyPath.matrixTransform(aTransform);\n\
return aPolyPath;\n\
}\n\
\n\
SVGPathElement.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
if( SVGPathSegList.prototype.matrixTransform )\n\
{\n\
this.pathSegList.matrixTransform( aSVGMatrix );\n\
return;\n\
}\n\
\n\
var aPathSegList = this.pathSegList;\n\
var nLength = aPathSegList.numberOfItems;\n\
var i;\n\
for( i = 0; i < nLength; ++i )\n\
{\n\
aPathSegList.getItem( i ).matrixTransform( aSVGMatrix );\n\
}\n\
};\n\
\n\
SVGPathElement.prototype.changeOrientation = function()\n\
{\n\
var aPathSegList = this.pathSegList;\n\
var nLength = aPathSegList.numberOfItems;\n\
if( nLength == 0 ) return;\n\
\n\
if( SVGPathSegList.prototype.changeOrientation )\n\
{\n\
aPathSegList.changeOrientation();\n\
return;\n\
}\n\
\n\
var nCurrentX = 0;\n\
var nCurrentY = 0;\n\
";

static const char aSVGScript40[] =
"\
\n\
var aPathSeg = aPathSegList.getItem( 0 );\n\
if( aPathSeg.pathSegTypeAsLetter == 'M' )\n\
{\n\
nCurrentX = aPathSeg.x;\n\
nCurrentY = aPathSeg.y;\n\
aPathSegList.removeItem( 0 );\n\
--nLength;\n\
}\n\
\n\
var i;\n\
for( i = 0; i < nLength; ++i )\n\
{\n\
aPathSeg = aPathSegList.getItem( i );\n\
var aPoint = aPathSeg.changeOrientation( nCurrentX, nCurrentY );\n\
nCurrentX = aPoint.x;\n\
nCurrentY = aPoint.y;\n\
}\n\
\n\
\n\
for( i = nLength - 2; i >= 0; --i )\n\
{\n\
aPathSeg = aPathSegList.removeItem( i );\n\
aPathSegList.appendItem( aPathSeg );\n\
}\n\
\n\
var aMovePathSeg = this.createSVGPathSegMovetoAbs( nCurrentX, nCurrentY );\n\
aPathSegList.insertItemBefore( aMovePathSeg, 0 );\n\
\n\
};\n\
\n\
\n\
try\n\
{   // Firefox, Google Chrome, Internet Explorer, Safari.\n\
\n\
SVGPathSegMovetoAbs.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
SVGPathMatrixTransform( this, aSVGMatrix );\n\
};\n\
\n\
SVGPathSegLinetoAbs.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
SVGPathMatrixTransform( this, aSVGMatrix );\n\
};\n\
\n\
SVGPathSegCurvetoQuadraticAbs.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
SVGPathMatrixTransform( this, aSVGMatrix );\n\
var nX = this.x1;\n\
this.x1 = aSVGMatrix.a * nX + aSVGMatrix.c * this.y1 + aSVGMatrix.e;\n\
this.y1 = aSVGMatrix.b * nX + aSVGMatrix.d * this.y1 + aSVGMatrix.f;\n\
};\n\
\n\
SVGPathSegCurvetoCubicAbs.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
SVGPathMatrixTransform( this, aSVGMatrix );\n\
var nX = this.x1;\n\
this.x1 = aSVGMatrix.a * nX + aSVGMatrix.c * this.y1 + aSVGMatrix.e;\n\
this.y1 = aSVGMatrix.b * nX + aSVGMatrix.d * this.y1 + aSVGMatrix.f;\n\
nX = this.x2;\n\
this.x2 = aSVGMatrix.a * nX + aSVGMatrix.c * this.y2 + aSVGMatrix.e;\n\
this.y2 = aSVGMatrix.b * nX + aSVGMatrix.d * this.y2 + aSVGMatrix.f;\n\
};\n\
\n\
\n\
SVGPathSegMovetoAbs.prototype.changeOrientation = function( nCurrentX, nCurrentY )\n\
{\n\
var aPoint = { x: this.x, y: this.y };\n\
this.x = nCurrentX;\n\
this.y = nCurrentY;\n\
return aPoint;\n\
};\n\
\n\
SVGPathSegLinetoAbs.prototype.changeOrientation = function( nCurrentX, nCurrentY )\n\
{\n\
var aPoint = { x: this.x, y: this.y };\n\
this.x = nCurrentX;\n\
this.y = nCurrentY;\n\
return aPoint;\n\
};\n\
\n\
SVGPathSegCurvetoQuadraticAbs.prototype.changeOrientation = function( nCurrentX, nCurrentY )\n\
{\n\
var aPoint = { x: this.x, y: this.y };\n\
this.x = nCurrentX;\n\
this.y = nCurrentY;\n\
return aPoint;\n\
};\n\
\n\
SVGPathSegCurvetoCubicAbs.prototype.changeOrientation = function( nCurrentX, nCurrentY )\n\
{\n\
var aPoint = { x: this.x, y: this.y };\n\
this.x = nCurrentX;\n\
this.y = nCurrentY;\n\
var nX = this.x1;\n\
this.x1 = this.x2;\n\
this.x2 = nX;\n\
var nY = this.y1;\n\
this.y1 = this.y2;\n\
this.y2 = nY;\n\
return aPoint;\n\
};\n\
\n\
}\n\
catch( e )\n\
{   // Opera\n\
\n\
if( e.name == 'ReferenceError' )\n\
{\n\
SVGPathSeg.prototype.matrixTransform = function( aSVGMatrix )\n\
{\n\
var nX;\n\
switch( this.pathSegTypeAsLetter )\n\
{\n\
case 'C':\n\
nX = this.x2;\n\
this.x2 = aSVGMatrix.a * nX + aSVGMatrix.c * this.y2 + aSVGMatrix.e;\n\
this.y2 = aSVGMatrix.b * nX + aSVGMatrix.d * this.y2 + aSVGMatrix.f;\n\
case 'Q':\n\
nX = this.x1;\n\
this.x1 = aSVGMatrix.a * nX + aSVGMatrix.c * this.y1 + aSVGMatrix.e;\n\
this.y1 = aSVGMatrix.b * nX + aSVGMatrix.d * this.y1 + aSVGMatrix.f;\n\
case 'M':\n\
case 'L':\n\
SVGPathMatrixTransform( this, aSVGMatrix );\n\
break;\n\
default:\n\
log( 'SVGPathSeg.matrixTransform: unexpected path segment type: '\n\
+ this.pathSegTypeAsLetter );\n\
}\n\
};\n\
\n\
SVGPathSeg.prototype.changeOrientation = function( nCurrentX, nCurrentY )\n\
{\n\
switch( this.pathSegTypeAsLetter )\n\
{\n\
case 'C':\n\
var nX = this.x1;\n\
this.x1 = this.x2;\n\
this.x2 = nX;\n\
var nY = this.y1;\n\
this.y1 = this.y2;\n\
this.y2 = nY;\n\
case 'M':\n\
case 'L':\n\
case 'Q':\n\
var aPoint = { x: this.x, y: this.y };\n\
this.x = nCurrentX;\n\
this.y = nCurrentY;\n\
return aPoint;\n\
";

static const char aSVGScript41[] =
"\
default:\n\
log( 'SVGPathSeg.changeOrientation: unexpected path segment type: '\n\
+ this.pathSegTypeAsLetter );\n\
return null;\n\
}\n\
}\n\
}\n\
else throw e;\n\
}\n\
\n\
function SVGPathMatrixTransform( aPath, aSVGMatrix )\n\
{\n\
var nX = aPath.x;\n\
aPath.x = aSVGMatrix.a * nX + aSVGMatrix.c * aPath.y + aSVGMatrix.e;\n\
aPath.y = aSVGMatrix.b * nX + aSVGMatrix.d * aPath.y + aSVGMatrix.f;\n\
}\n\
\n\
\n\
function PriorityQueue( aCompareFunc )\n\
{\n\
this.aSequence = [];\n\
this.aCompareFunc = aCompareFunc;\n\
}\n\
\n\
PriorityQueue.prototype.clone = function()\n\
{\n\
var aCopy = new PriorityQueue( this.aCompareFunc );\n\
var src = this.aSequence;\n\
var dest = [];\n\
var i, l;\n\
for( i = 0, l = src.length; i < l; ++i )\n\
{\n\
if( i in src )\n\
{\n\
dest.push( src[i] );\n\
}\n\
}\n\
aCopy.aSequence = dest;\n\
return aCopy;\n\
};\n\
\n\
PriorityQueue.prototype.top = function()\n\
{\n\
return this.aSequence[this.aSequence.length - 1];\n\
};\n\
\n\
PriorityQueue.prototype.isEmpty = function()\n\
{\n\
return ( this.aSequence.length === 0 );\n\
};\n\
\n\
PriorityQueue.prototype.push = function( aValue )\n\
{\n\
this.aSequence.unshift( aValue );\n\
this.aSequence.sort(this.aCompareFunc);\n\
};\n\
\n\
PriorityQueue.prototype.clear = function()\n\
{\n\
this.aSequence = [];\n\
};\n\
\n\
PriorityQueue.prototype.pop = function()\n\
{\n\
return this.aSequence.pop();\n\
};\n\
\n\
\n\
var ANIMATION_NODE_CUSTOM               = 0;\n\
var ANIMATION_NODE_PAR                  = 1;\n\
var ANIMATION_NODE_SEQ                  = 2;\n\
var ANIMATION_NODE_ITERATE              = 3;\n\
var ANIMATION_NODE_ANIMATE              = 4;\n\
var ANIMATION_NODE_SET                  = 5;\n\
var ANIMATION_NODE_ANIMATEMOTION        = 6;\n\
var ANIMATION_NODE_ANIMATECOLOR         = 7;\n\
var ANIMATION_NODE_ANIMATETRANSFORM     = 8;\n\
var ANIMATION_NODE_TRANSITIONFILTER     = 9;\n\
var ANIMATION_NODE_AUDIO                = 10;\n\
var ANIMATION_NODE_COMMAND              = 11;\n\
\n\
var aAnimationNodeTypeInMap = {\n\
'par'               : ANIMATION_NODE_PAR,\n\
'seq'               : ANIMATION_NODE_SEQ,\n\
'iterate'           : ANIMATION_NODE_ITERATE,\n\
'animate'           : ANIMATION_NODE_ANIMATE,\n\
'set'               : ANIMATION_NODE_SET,\n\
'animatemotion'     : ANIMATION_NODE_ANIMATEMOTION,\n\
'animatecolor'      : ANIMATION_NODE_ANIMATECOLOR,\n\
'animatetransform'  : ANIMATION_NODE_ANIMATETRANSFORM,\n\
'transitionfilter'  : ANIMATION_NODE_TRANSITIONFILTER,\n\
'audio'             : ANIMATION_NODE_AUDIO,\n\
'command'           : ANIMATION_NODE_COMMAND\n\
};\n\
\n\
\n\
function getAnimationElementType( aElement )\n\
{\n\
var sName = aElement.localName.toLowerCase();\n\
\n\
if( sName && aAnimationNodeTypeInMap[ sName ] )\n\
return aAnimationNodeTypeInMap[ sName ];\n\
else\n\
return ANIMATION_NODE_CUSTOM;\n\
}\n\
\n\
\n\
var INVALID_NODE                = 0;\n\
var UNRESOLVED_NODE             = 1;\n\
var RESOLVED_NODE               = 2;\n\
var ACTIVE_NODE                 = 4;\n\
var FROZEN_NODE                 = 8;\n\
var ENDED_NODE                  = 16;\n\
\n\
function getNodeStateName( eNodeState )\n\
{\n\
switch( eNodeState )\n\
{\n\
case INVALID_NODE:\n\
return 'INVALID';\n\
case UNRESOLVED_NODE:\n\
return 'UNRESOLVED';\n\
case RESOLVED_NODE:\n\
return 'RESOLVED';\n\
case ACTIVE_NODE:\n\
return 'ACTIVE';\n\
case FROZEN_NODE:\n\
return 'FROZEN';\n\
case ENDED_NODE:\n\
return 'ENDED';\n\
default:\n\
return 'UNKNOWN';\n\
}\n\
}\n\
\n\
\n\
var IMPRESS_DEFAULT_NODE                    = 0;\n\
var IMPRESS_ON_CLICK_NODE                   = 1;\n\
var IMPRESS_WITH_PREVIOUS_NODE              = 2;\n\
var IMPRESS_AFTER_PREVIOUS_NODE             = 3;\n\
var IMPRESS_MAIN_SEQUENCE_NODE              = 4;\n\
var IMPRESS_TIMING_ROOT_NODE                = 5;\n\
var IMPRESS_INTERACTIVE_SEQUENCE_NODE       = 6;\n\
\n\
var aImpressNodeTypeInMap = {\n\
'on-click'                  : IMPRESS_ON_CLICK_NODE,\n\
'with-previous'             : IMPRESS_WITH_PREVIOUS_NODE,\n\
'after-previous'            : IMPRESS_AFTER_PREVIOUS_NODE,\n\
'main-sequence'             : IMPRESS_MAIN_SEQUENCE_NODE,\n\
'timing-root'               : IMPRESS_TIMING_ROOT_NODE,\n\
";

static const char aSVGScript42[] =
"\
'interactive-sequence'      : IMPRESS_INTERACTIVE_SEQUENCE_NODE\n\
};\n\
\n\
var aImpressNodeTypeOutMap = [ 'default', 'on-click', 'with-previous', 'after-previous',\n\
'main-sequence', 'timing-root', 'interactive-sequence' ];\n\
\n\
\n\
var aPresetClassInMap = {};\n\
\n\
\n\
var aPresetIdInMap = {};\n\
\n\
\n\
var RESTART_MODE_DEFAULT            = 0;\n\
var RESTART_MODE_INHERIT            = 0; // eslint-disable-line no-unused-vars\n\
var RESTART_MODE_ALWAYS             = 1;\n\
var RESTART_MODE_WHEN_NOT_ACTIVE    = 2;\n\
var RESTART_MODE_NEVER              = 3;\n\
\n\
var aRestartModeInMap = {\n\
'inherit'       : RESTART_MODE_DEFAULT,\n\
'always'        : RESTART_MODE_ALWAYS,\n\
'whenNotActive' : RESTART_MODE_WHEN_NOT_ACTIVE,\n\
'never'         : RESTART_MODE_NEVER\n\
};\n\
\n\
var aRestartModeOutMap = [ 'inherit','always', 'whenNotActive', 'never' ];\n\
\n\
\n\
var FILL_MODE_DEFAULT           = 0;\n\
var FILL_MODE_INHERIT           = 0; // eslint-disable-line no-unused-vars\n\
var FILL_MODE_REMOVE            = 1;\n\
var FILL_MODE_FREEZE            = 2;\n\
var FILL_MODE_HOLD              = 3;\n\
var FILL_MODE_TRANSITION        = 4;\n\
var FILL_MODE_AUTO              = 5;\n\
\n\
var aFillModeInMap = {\n\
'inherit'       : FILL_MODE_DEFAULT,\n\
'remove'        : FILL_MODE_REMOVE,\n\
'freeze'        : FILL_MODE_FREEZE,\n\
'hold'          : FILL_MODE_HOLD,\n\
'transition'    : FILL_MODE_TRANSITION,\n\
'auto'          : FILL_MODE_AUTO\n\
};\n\
\n\
var aFillModeOutMap = [ 'inherit', 'remove', 'freeze', 'hold', 'transition', 'auto' ];\n\
\n\
\n\
var ADDITIVE_MODE_UNKNOWN       = 0; // eslint-disable-line no-unused-vars\n\
var ADDITIVE_MODE_BASE          = 1;\n\
var ADDITIVE_MODE_SUM           = 2;\n\
var ADDITIVE_MODE_REPLACE       = 3;\n\
var ADDITIVE_MODE_MULTIPLY      = 4;\n\
var ADDITIVE_MODE_NONE          = 5;\n\
\n\
var aAddittiveModeInMap = {\n\
'base'          : ADDITIVE_MODE_BASE,\n\
'sum'           : ADDITIVE_MODE_SUM,\n\
'replace'       : ADDITIVE_MODE_REPLACE,\n\
'multiply'      : ADDITIVE_MODE_MULTIPLY,\n\
'none'          : ADDITIVE_MODE_NONE\n\
};\n\
\n\
var aAddittiveModeOutMap = [ 'unknown', 'base', 'sum', 'replace', 'multiply', 'none' ];\n\
\n\
\n\
var ACCUMULATE_MODE_NONE        = 0;\n\
var ACCUMULATE_MODE_SUM         = 1;\n\
\n\
var aAccumulateModeOutMap = [ 'none', 'sum' ];\n\
\n\
var CALC_MODE_DISCRETE          = 1;\n\
var CALC_MODE_LINEAR            = 2;\n\
var CALC_MODE_PACED             = 3;\n\
var CALC_MODE_SPLINE            = 4;\n\
\n\
var aCalcModeInMap = {\n\
'discrete'      : CALC_MODE_DISCRETE,\n\
'linear'        : CALC_MODE_LINEAR,\n\
'paced'         : CALC_MODE_PACED,\n\
'spline'        : CALC_MODE_SPLINE\n\
};\n\
\n\
var aCalcModeOutMap = [ 'unknown', 'discrete', 'linear', 'paced', 'spline' ];\n\
\n\
\n\
var COLOR_SPACE_RGB = 0;\n\
var COLOR_SPACE_HSL = 1;\n\
\n\
var aColorSpaceInMap = { 'rgb': COLOR_SPACE_RGB, 'hsl': COLOR_SPACE_HSL };\n\
\n\
var aColorSpaceOutMap = [ 'rgb', 'hsl' ];\n\
\n\
\n\
var CLOCKWISE               = 0;\n\
var COUNTERCLOCKWISE        = 1;\n\
\n\
var aClockDirectionInMap = { 'clockwise': CLOCKWISE, 'counter-clockwise': COUNTERCLOCKWISE };\n\
\n\
var aClockDirectionOutMap = [ 'clockwise', 'counter-clockwise' ];\n\
\n\
\n\
var UNKNOWN_PROPERTY        = 0; // eslint-disable-line no-unused-vars\n\
var NUMBER_PROPERTY         = 1;\n\
var ENUM_PROPERTY           = 2;\n\
var COLOR_PROPERTY          = 3;\n\
var STRING_PROPERTY         = 4;\n\
var BOOL_PROPERTY           = 5;\n\
var TUPLE_NUMBER_PROPERTY   = 6;\n\
\n\
var aValueTypeOutMap = [ 'unknown', 'number', 'enum', 'color', 'string', 'boolean' ];\n\
\n\
\n\
var aAttributeMap =\n\
{\n\
'height':           {   'type':         NUMBER_PROPERTY,\n\
'get':          'getHeight',\n\
'set':          'setHeight',\n\
'getmod':       'makeScaler( 1/nHeight )',\n\
'setmod':       'makeScaler( nHeight)'          },\n\
\n\
'opacity':          {   'type':         NUMBER_PROPERTY,\n\
'get':          'getOpacity',\n\
'set':          'setOpacity'                    },\n\
\n\
'scale':           {   'type':          TUPLE_NUMBER_PROPERTY,\n\
'get':          'getSize',\n\
'set':          'setSize'                       },\n\
\n\
'translate':       {   'type':          TUPLE_NUMBER_PROPERTY,\n\
'get':          'getPos',\n\
'set':          'setPos'                        },\n\
\n\
'rotate':           {   'type':         NUMBER_PROPERTY,\n\
'get':          'getRotationAngle',\n\
'set':          'setRotationAngle'              },\n\
\n\
'width':            {   'type':         NUMBER_PROPERTY,\n\
'get':          'getWidth',\n\
'set':          'setWidth',\n\
'getmod':       'makeScaler( 1/nWidth )',\n\
'setmod':       'makeScaler( nWidth)'           },\n\
\n\
'x':                {   'type':         NUMBER_PROPERTY,\n\
'get':          'getX',\n\
'set':          'setX',\n\
'getmod':       'makeScaler( 1/nWidth )',\n\
'setmod':       'makeScaler( nWidth)'           },\n\
\n\
";

static const char aSVGScript43[] =
"\
'y':                {   'type':         NUMBER_PROPERTY,\n\
'get':          'getY',\n\
'set':          'setY',\n\
'getmod':       'makeScaler( 1/nHeight )',\n\
'setmod':       'makeScaler( nHeight)'          },\n\
\n\
'fill':             {   'type':         ENUM_PROPERTY,\n\
'get':          'getFillStyle',\n\
'set':          'setFillStyle'                  },\n\
\n\
'stroke':           {   'type':         ENUM_PROPERTY,\n\
'get':          'getStrokeStyle',\n\
'set':          'setStrokeStyle'                },\n\
\n\
'visibility':       {   'type':         ENUM_PROPERTY,\n\
'get':          'getVisibility',\n\
'set':          'setVisibility'                 },\n\
\n\
'fill-color':       {   'type':         COLOR_PROPERTY,\n\
'get':          'getFillColor',\n\
'set':          'setFillColor'                  },\n\
\n\
'stroke-color':     {   'type':         COLOR_PROPERTY,\n\
'get':          'getStrokeColor',\n\
'set':          'setStrokeColor'                },\n\
\n\
'color':            {   'type':         COLOR_PROPERTY,\n\
'get':          'getFontColor',\n\
'set':          'setFontColor'                  }\n\
\n\
};\n\
\n\
\n\
var TRANSITION_INVALID              = 0;    // Invalid type\n\
var TRANSITION_CLIP_POLYPOLYGON     = 1;    // Transition expressed by parametric clip polygon\n\
var TRANSITION_SPECIAL              = 2;    // Transition expressed by hand-crafted function\n\
\n\
\n\
var BARWIPE_TRANSITION              = 1;\n\
var BOXWIPE_TRANSITION              = 2;\n\
var FOURBOXWIPE_TRANSITION          = 3;\n\
var ELLIPSEWIPE_TRANSITION          = 4; // 17\n\
var CLOCKWIPE_TRANSITION            = 5; // 22\n\
var PINWHEELWIPE_TRANSITION         = 6; // 23\n\
var PUSHWIPE_TRANSITION             = 7; // 35\n\
var SLIDEWIPE_TRANSITION            = 8; // 36\n\
var FADE_TRANSITION                 = 9; // 37\n\
var RANDOMBARWIPE_TRANSITION        = 10; // 38\n\
var CHECKERBOARDWIPE_TRANSITION     = 11; // 39\n\
var DISSOLVE_TRANSITION             = 12; // 40\n\
var SNAKEWIPE_TRANSITION            = 13; // 30\n\
var PARALLELSNAKESWIPE_TRANSITION   = 14; // 32\n\
var IRISWIPE_TRANSITION             = 15; // 12\n\
var BARNDOORWIPE_TRANSITION         = 16; // 4\n\
var VEEWIPE_TRANSITION              = 17; // 8\n\
var ZIGZAGWIPE_TRANSITION           = 18; // 10\n\
var BARNZIGZAGWIPE_TRANSITION       = 19; // 11\n\
var FANWIPE_TRANSITION              = 20; // 25\n\
var SINGLESWEEPWIPE_TRANSITION      = 21; // 24\n\
var WATERFALLWIPE_TRANSITION        = 22; // 34\n\
var SPIRALWIPE_TRANSITION           = 23; // 31\n\
var MISCDIAGONALWIPE_TRANSITION     = 24; // 7\n\
var BOXSNAKESWIPE_TRANSITION        = 25; // 33\n\
\n\
var aTransitionTypeInMap = {\n\
'barWipe'           : BARWIPE_TRANSITION,\n\
'boxWipe'           : BOXWIPE_TRANSITION,\n\
'barnDoorWipe'      : BARNDOORWIPE_TRANSITION,\n\
'fourBoxWipe'       : FOURBOXWIPE_TRANSITION,\n\
'ellipseWipe'       : ELLIPSEWIPE_TRANSITION,\n\
'clockWipe'         : CLOCKWIPE_TRANSITION,\n\
'pinWheelWipe'      : PINWHEELWIPE_TRANSITION,\n\
'miscDiagonalWipe'  : MISCDIAGONALWIPE_TRANSITION,\n\
'pushWipe'          : PUSHWIPE_TRANSITION,\n\
'slideWipe'         : SLIDEWIPE_TRANSITION,\n\
'fade'              : FADE_TRANSITION,\n\
'fanWipe'           : FANWIPE_TRANSITION,\n\
'randomBarWipe'     : RANDOMBARWIPE_TRANSITION,\n\
'checkerBoardWipe'  : CHECKERBOARDWIPE_TRANSITION,\n\
'dissolve'          : DISSOLVE_TRANSITION,\n\
'singleSweepWipe'   : SINGLESWEEPWIPE_TRANSITION,\n\
'snakeWipe'         : SNAKEWIPE_TRANSITION,\n\
'parallelSnakesWipe': PARALLELSNAKESWIPE_TRANSITION,\n\
'spiralWipe'        : SPIRALWIPE_TRANSITION,\n\
'boxSnakesWipe'     : BOXSNAKESWIPE_TRANSITION,\n\
'irisWipe'          : IRISWIPE_TRANSITION,\n\
'veeWipe'           : VEEWIPE_TRANSITION,\n\
'zigZagWipe'        : ZIGZAGWIPE_TRANSITION,\n\
'barnZigZagWipe'    : BARNZIGZAGWIPE_TRANSITION,\n\
'waterfallWipe'     : WATERFALLWIPE_TRANSITION\n\
};\n\
\n\
var DEFAULT_TRANS_SUBTYPE                       = 0;\n\
var LEFTTORIGHT_TRANS_SUBTYPE                   = 1;\n\
var TOPTOBOTTOM_TRANS_SUBTYPE                   = 2;\n\
var CORNERSIN_TRANS_SUBTYPE                     = 3; // 11\n\
var CORNERSOUT_TRANS_SUBTYPE                    = 4;\n\
var VERTICAL_TRANS_SUBTYPE                      = 5;\n\
var HORIZONTAL_TRANS_SUBTYPE                    = 6; // 14\n\
var DOWN_TRANS_SUBTYPE                          = 7; // 19\n\
var CIRCLE_TRANS_SUBTYPE                        = 8; // 27\n\
var CLOCKWISETWELVE_TRANS_SUBTYPE               = 9; // 33\n\
var CLOCKWISETHREE_TRANS_SUBTYPE                = 10;\n\
var CLOCKWISESIX_TRANS_SUBTYPE                  = 11;\n\
var CLOCKWISENINE_TRANS_SUBTYPE                 = 12;\n\
var TWOBLADEVERTICAL_TRANS_SUBTYPE              = 13;\n\
var TWOBLADEHORIZONTAL_TRANS_SUBTYPE            = 14;\n\
var FOURBLADE_TRANS_SUBTYPE                     = 15; // 39\n\
var FROMLEFT_TRANS_SUBTYPE                      = 16; // 97\n\
var FROMTOP_TRANS_SUBTYPE                       = 17;\n\
var FROMRIGHT_TRANS_SUBTYPE                     = 18;\n\
var FROMBOTTOM_TRANS_SUBTYPE                    = 19;\n\
var CROSSFADE_TRANS_SUBTYPE                     = 20;\n\
var FADETOCOLOR_TRANS_SUBTYPE                   = 21;\n\
var FADEFROMCOLOR_TRANS_SUBTYPE                 = 22;\n\
var FADEOVERCOLOR_TRANS_SUBTYPE                 = 23;\n\
var THREEBLADE_TRANS_SUBTYPE                    = 24;\n\
var EIGHTBLADE_TRANS_SUBTYPE                    = 25;\n\
var ONEBLADE_TRANS_SUBTYPE                      = 26; // 107\n\
var ACROSS_TRANS_SUBTYPE                        = 27;\n\
var TOPLEFTVERTICAL_TRANS_SUBTYPE               = 28; // 109\n\
var TOPLEFTHORIZONTAL_TRANS_SUBTYPE             = 29; // 64\n\
var TOPLEFTDIAGONAL_TRANS_SUBTYPE               = 30; // 65\n\
var TOPRIGHTDIAGONAL_TRANS_SUBTYPE              = 31; // 66\n\
var BOTTOMRIGHTDIAGONAL_TRANS_SUBTYPE           = 32; // 67\n\
var BOTTOMLEFTDIAGONAL_TRANS_SUBTYPE            = 33; // 68\n\
var RECTANGLE_TRANS_SUBTYPE                     = 34; // 101\n\
var DIAMOND_TRANS_SUBTYPE                       = 35; // 102\n\
var TOPLEFT_TRANS_SUBTYPE                       = 36; // 3\n\
var TOPRIGHT_TRANS_SUBTYPE                      = 37; // 4\n\
var BOTTOMRIGHT_TRANS_SUBTYPE                   = 38; // 5\n\
var BOTTOMLEFT_TRANS_SUBTYPE                    = 39; // 6\n\
var TOPCENTER_TRANS_SUBTYPE                     = 40; // 7\n\
var RIGHTCENTER_TRANS_SUBTYPE                   = 41; // 8\n\
var BOTTOMCENTER_TRANS_SUBTYPE                  = 42; // 9\n\
var LEFTCENTER_TRANS_SUBTYPE                    = 43; // 10\n\
var LEFT_TRANS_SUBTYPE                          = 44; // 20\n\
var UP_TRANS_SUBTYPE                            = 45; // 21\n\
var RIGHT_TRANS_SUBTYPE                         = 46; // 22\n\
var DIAGONALBOTTOMLEFT_TRANS_SUBTYPE            = 47; // 15\n\
var DIAGONALTOPLEFT_TRANS_SUBTYPE               = 48; // 16\n\
var CENTERTOP_TRANS_SUBTYPE                     = 49; // 48\n\
var CENTERRIGHT_TRANS_SUBTYPE                   = 50; // 49\n\
var TOP_TRANS_SUBTYPE                           = 51; // 50\n\
var BOTTOM_TRANS_SUBTYPE                        = 52; // 52\n\
var CLOCKWISETOP_TRANS_SUBTYPE                  = 53; // 40\n\
var CLOCKWISERIGHT_TRANS_SUBTYPE                = 54; // 41\n\
var CLOCKWISEBOTTOM_TRANS_SUBTYPE               = 55; // 42\n\
var CLOCKWISELEFT_TRANS_SUBTYPE                 = 56; // 43\n\
var CLOCKWISETOPLEFT_TRANS_SUBTYPE              = 57; // 44\n\
";

static const char aSVGScript44[] =
"\
var COUNTERCLOCKWISEBOTTOMLEFT_TRANS_SUBTYPE    = 58; // 45\n\
var CLOCKWISEBOTTOMRIGHT_TRANS_SUBTYPE          = 59; // 46\n\
var COUNTERCLOCKWISETOPRIGHT_TRANS_SUBTYPE      = 60; // 47\n\
var VERTICALLEFT_TRANS_SUBTYPE                  = 61; // 93\n\
var VERTICALRIGHT_TRANS_SUBTYPE                 = 62; // 94\n\
var HORIZONTALLEFT_TRANS_SUBTYPE                = 63; // 95\n\
var HORIZONTALRIGHT_TRANS_SUBTYPE               = 64; // 96\n\
var TOPLEFTCLOCKWISE_TRANS_SUBTYPE              = 65; // 69\n\
var TOPRIGHTCLOCKWISE_TRANS_SUBTYPE             = 66; // 70\n\
var BOTTOMRIGHTCLOCKWISE_TRANS_SUBTYPE          = 67; // 71\n\
var BOTTOMLEFTCLOCKWISE_TRANS_SUBTYPE           = 68; // 72\n\
var TOPLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE       = 69; // 73\n\
var TOPRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE      = 70; // 74\n\
var BOTTOMRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE   = 71; // 75\n\
var BOTTOMLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE    = 72; // 76\n\
var DOUBLEBARNDOOR_TRANS_SUBTYPE                = 73; // 17\n\
var DOUBLEDIAMOND_TRANS_SUBTYPE                 = 74; // 18\n\
var VERTICALTOPSAME_TRANS_SUBTYPE               = 75; // 77\n\
var VERTICALBOTTOMSAME_TRANS_SUBTYPE            = 76; // 78\n\
var VERTICALTOPLEFTOPPOSITE_TRANS_SUBTYPE       = 77; // 79\n\
var VERTICALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE    = 78; // 80\n\
var HORIZONTALLEFTSAME_TRANS_SUBTYPE            = 79; // 81\n\
var HORIZONTALRIGHTSAME_TRANS_SUBTYPE           = 80; // 82\n\
var HORIZONTALTOPLEFTOPPOSITE_TRANS_SUBTYPE     = 81; // 83\n\
var HORIZONTALTOPRIGHTOPPOSITE_TRANS_SUBTYPE    = 82; // 84\n\
var DIAGONALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE    = 83; // 85\n\
var DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE       = 84; // 86\n\
var TWOBOXTOP_TRANS_SUBTYPE                     = 85; // 87\n\
var TWOBOXBOTTOM_TRANS_SUBTYPE                  = 86; // 88\n\
var TWOBOXLEFT_TRANS_SUBTYPE                    = 87; // 89\n\
var TWOBOXRIGHT_TRANS_SUBTYPE                   = 88; // 90\n\
var FOURBOXVERTICAL_TRANS_SUBTYPE               = 89; // 91\n\
var FOURBOXHORIZONTAL_TRANS_SUBTYPE             = 90; // 92\n\
\n\
var aTransitionSubtypeInMap = {\n\
'default'                       : DEFAULT_TRANS_SUBTYPE,\n\
'leftToRight'                   : LEFTTORIGHT_TRANS_SUBTYPE,\n\
'topToBottom'                   : TOPTOBOTTOM_TRANS_SUBTYPE,\n\
'cornersIn'                     : CORNERSIN_TRANS_SUBTYPE,\n\
'cornersOut'                    : CORNERSOUT_TRANS_SUBTYPE,\n\
'vertical'                      : VERTICAL_TRANS_SUBTYPE,\n\
'centerTop'                     : CENTERTOP_TRANS_SUBTYPE,\n\
'centerRight'                   : CENTERRIGHT_TRANS_SUBTYPE,\n\
'top'                           : TOP_TRANS_SUBTYPE,\n\
'right'                         : RIGHT_TRANS_SUBTYPE,\n\
'bottom'                        : BOTTOM_TRANS_SUBTYPE,\n\
'left'                          : LEFT_TRANS_SUBTYPE,\n\
'horizontal'                    : HORIZONTAL_TRANS_SUBTYPE,\n\
'down'                          : DOWN_TRANS_SUBTYPE,\n\
'circle'                        : CIRCLE_TRANS_SUBTYPE,\n\
'clockwiseTwelve'               : CLOCKWISETWELVE_TRANS_SUBTYPE,\n\
'clockwiseThree'                : CLOCKWISETHREE_TRANS_SUBTYPE,\n\
'clockwiseSix'                  : CLOCKWISESIX_TRANS_SUBTYPE,\n\
'clockwiseNine'                 : CLOCKWISENINE_TRANS_SUBTYPE,\n\
'clockwiseRight'                : CLOCKWISERIGHT_TRANS_SUBTYPE,\n\
'clockwiseTop'                  : CLOCKWISETOP_TRANS_SUBTYPE,\n\
'clockwiseBottom'               : CLOCKWISEBOTTOM_TRANS_SUBTYPE,\n\
'clockwiseLeft'                 : CLOCKWISELEFT_TRANS_SUBTYPE,\n\
'clockwiseTopLeft'              : CLOCKWISETOPLEFT_TRANS_SUBTYPE,\n\
'counterClockwiseBottomLeft'    : COUNTERCLOCKWISEBOTTOMLEFT_TRANS_SUBTYPE,\n\
'clockwiseBottomRight'          : CLOCKWISEBOTTOMRIGHT_TRANS_SUBTYPE,\n\
'counterClockwiseTopRight'      : COUNTERCLOCKWISETOPRIGHT_TRANS_SUBTYPE,\n\
'twoBladeVertical'              : TWOBLADEVERTICAL_TRANS_SUBTYPE,\n\
'twoBladeHorizontal'            : TWOBLADEHORIZONTAL_TRANS_SUBTYPE,\n\
'fourBlade'                     : FOURBLADE_TRANS_SUBTYPE,\n\
'fromLeft'                      : FROMLEFT_TRANS_SUBTYPE,\n\
'fromTop'                       : FROMTOP_TRANS_SUBTYPE,\n\
'fromRight'                     : FROMRIGHT_TRANS_SUBTYPE,\n\
'fromBottom'                    : FROMBOTTOM_TRANS_SUBTYPE,\n\
'crossfade'                     : CROSSFADE_TRANS_SUBTYPE,\n\
'fadeToColor'                   : FADETOCOLOR_TRANS_SUBTYPE,\n\
'fadeFromColor'                 : FADEFROMCOLOR_TRANS_SUBTYPE,\n\
'fadeOverColor'                 : FADEOVERCOLOR_TRANS_SUBTYPE,\n\
'threeBlade'                    : THREEBLADE_TRANS_SUBTYPE,\n\
'eightBlade'                    : EIGHTBLADE_TRANS_SUBTYPE,\n\
'oneBlade'                      : ONEBLADE_TRANS_SUBTYPE,\n\
'across'                        : ACROSS_TRANS_SUBTYPE,\n\
'topLeftVertical'               : TOPLEFTVERTICAL_TRANS_SUBTYPE,\n\
'topLeftHorizontal'             : TOPLEFTHORIZONTAL_TRANS_SUBTYPE,\n\
'topLeftDiagonal'               : TOPLEFTDIAGONAL_TRANS_SUBTYPE,\n\
'topRightDiagonal'              : TOPRIGHTDIAGONAL_TRANS_SUBTYPE,\n\
'bottomRightDiagonal'           : BOTTOMRIGHTDIAGONAL_TRANS_SUBTYPE,\n\
'topLeftClockwise'              : TOPLEFTCLOCKWISE_TRANS_SUBTYPE,\n\
'topRightClockwise'             : TOPRIGHTCLOCKWISE_TRANS_SUBTYPE,\n\
'bottomRightClockwise'          : BOTTOMRIGHTCLOCKWISE_TRANS_SUBTYPE,\n\
'bottomLeftClockwise'           : BOTTOMLEFTCLOCKWISE_TRANS_SUBTYPE,\n\
'topLeftCounterClockwise'       : TOPLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE,\n\
'topRightCounterClockwise'      : TOPRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE,\n\
'bottomRightCounterClockwise'   : BOTTOMRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE,\n\
'bottomLeftCounterClockwise'    : BOTTOMLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE,\n\
'bottomLeftDiagonal'            : BOTTOMLEFTDIAGONAL_TRANS_SUBTYPE,\n\
'rectangle'                     : RECTANGLE_TRANS_SUBTYPE,\n\
'diamond'                       : DIAMOND_TRANS_SUBTYPE,\n\
'topLeft'                       : TOPLEFT_TRANS_SUBTYPE,\n\
'topRight'                      : TOPRIGHT_TRANS_SUBTYPE,\n\
'bottomRight'                   : BOTTOMRIGHT_TRANS_SUBTYPE,\n\
'bottomLeft'                    : BOTTOMLEFT_TRANS_SUBTYPE,\n\
'topCenter'                     : TOPCENTER_TRANS_SUBTYPE,\n\
'rightCenter'                   : RIGHTCENTER_TRANS_SUBTYPE,\n\
'bottomCenter'                  : BOTTOMCENTER_TRANS_SUBTYPE,\n\
'leftCenter'                    : LEFTCENTER_TRANS_SUBTYPE,\n\
'up'                            : UP_TRANS_SUBTYPE,\n\
'diagonalBottomLeft'            : DIAGONALBOTTOMLEFT_TRANS_SUBTYPE,\n\
'diagonalTopLeft'               : DIAGONALTOPLEFT_TRANS_SUBTYPE,\n\
'verticalLeft'                  : VERTICALLEFT_TRANS_SUBTYPE,\n\
'verticalRight'                 : VERTICALRIGHT_TRANS_SUBTYPE,\n\
'horizontalLeft'                : HORIZONTALLEFT_TRANS_SUBTYPE,\n\
'horizontalRight'               : HORIZONTALRIGHT_TRANS_SUBTYPE,\n\
'doubleBarnDoor'                : DOUBLEBARNDOOR_TRANS_SUBTYPE,\n\
'doubleDiamond'                 : DOUBLEDIAMOND_TRANS_SUBTYPE,\n\
'verticalTopSame'               : VERTICALTOPSAME_TRANS_SUBTYPE,\n\
'verticalBottomSame'            : VERTICALBOTTOMSAME_TRANS_SUBTYPE,\n\
'verticalTopLeftOpposite'       : VERTICALTOPLEFTOPPOSITE_TRANS_SUBTYPE,\n\
'verticalBottomLeftOpposite'    : VERTICALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE,\n\
'horizontalLeftSame'            : HORIZONTALLEFTSAME_TRANS_SUBTYPE,\n\
'horizontalRightSame'           : HORIZONTALRIGHTSAME_TRANS_SUBTYPE,\n\
'horizontalTopLeftOpposite'     : HORIZONTALTOPLEFTOPPOSITE_TRANS_SUBTYPE,\n\
'horizontalTopRightOpposite'    : HORIZONTALTOPRIGHTOPPOSITE_TRANS_SUBTYPE,\n\
'diagonalBottomLeftOpposite'    : DIAGONALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE,\n\
'diagonalTopLeftOpposite'       : DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE,\n\
'twoBoxTop'                     : TWOBOXTOP_TRANS_SUBTYPE,\n\
'twoBoxBottom'                  : TWOBOXBOTTOM_TRANS_SUBTYPE,\n\
'twoBoxLeft'                    : TWOBOXLEFT_TRANS_SUBTYPE,\n\
'twoBoxRight'                   : TWOBOXRIGHT_TRANS_SUBTYPE,\n\
'fourBoxVertical'               : FOURBOXVERTICAL_TRANS_SUBTYPE,\n\
'fourBoxHorizontal'             : FOURBOXHORIZONTAL_TRANS_SUBTYPE\n\
};\n\
\n\
var TRANSITION_MODE_IN  = 1;\n\
var TRANSITION_MODE_OUT = 0;\n\
\n\
var aTransitionModeOutMap = [ 'out', 'in' ];\n\
\n\
\n\
var REVERSEMETHOD_IGNORE                    = 0;\n\
var REVERSEMETHOD_INVERT_SWEEP              = 1;\n\
var REVERSEMETHOD_SUBTRACT_POLYGON          = 2;\n\
var REVERSEMETHOD_SUBTRACT_AND_INVERT       = 3;\n\
var REVERSEMETHOD_ROTATE_180                = 4;\n\
var REVERSEMETHOD_FLIP_X                    = 5;\n\
var REVERSEMETHOD_FLIP_Y                    = 6;\n\
\n\
var aReverseMethodOutMap = ['ignore', 'invert sweep', 'subtract polygon',\n\
'subtract and invert', 'rotate 180', 'flip x', 'flip y'];\n\
\n\
\n\
var aTransitionInfoTable = {};\n\
\n\
aTransitionInfoTable[0] = {};\n\
aTransitionInfoTable[0][0] =\n\
";

static const char aSVGScript45[] =
"\
{\n\
'class' : TRANSITION_INVALID,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 0.0,\n\
'scaleY' : 0.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : false,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][TOPLEFTVERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][TOPLEFTHORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][TOPLEFTDIAGONAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][TOPRIGHTDIAGONAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][BOTTOMRIGHTDIAGONAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SNAKEWIPE_TRANSITION][BOTTOMLEFTDIAGONAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
}\n\
\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][VERTICALTOPSAME_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][VERTICALBOTTOMSAME_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][VERTICALTOPLEFTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][VERTICALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][HORIZONTALLEFTSAME_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][HORIZONTALRIGHTSAME_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][HORIZONTALTOPLEFTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][HORIZONTALTOPRIGHTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
";

static const char aSVGScript46[] =
"\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[PARALLELSNAKESWIPE_TRANSITION][DIAGONALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][TOPLEFTCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][TOPRIGHTCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][BOTTOMRIGHTCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][BOTTOMLEFTCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 270.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][TOPLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][TOPRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][BOTTOMRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 270.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SPIRALWIPE_TRANSITION][BOTTOMLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][TWOBOXTOP_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][TWOBOXBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][TWOBOXLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][TWOBOXRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][FOURBOXVERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
";

static const char aSVGScript47[] =
"\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXSNAKESWIPE_TRANSITION][FOURBOXHORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[BARNDOORWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[BARNDOORWIPE_TRANSITION][VERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 0.0,\n\
'scaleX': 1.0,\n\
'scaleY': 1.0,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
aTransitionInfoTable[BARNDOORWIPE_TRANSITION][HORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 90.0,\n\
'scaleX': 1.0,\n\
'scaleY': 1.0,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
aTransitionInfoTable[BARNDOORWIPE_TRANSITION][DIAGONALBOTTOMLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 45.0,\n\
'scaleX': Math.SQRT2,\n\
'scaleY': Math.SQRT2,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
aTransitionInfoTable[BARNDOORWIPE_TRANSITION][DIAGONALTOPLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': -45.0,\n\
'scaleX': Math.SQRT2,\n\
'scaleY': Math.SQRT2,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
\n\
aTransitionInfoTable[MISCDIAGONALWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[MISCDIAGONALWIPE_TRANSITION][DOUBLEBARNDOOR_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 45.0,\n\
'scaleX': Math.SQRT2,\n\
'scaleY': Math.SQRT2,\n\
'reverseMethod': REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
aTransitionInfoTable[MISCDIAGONALWIPE_TRANSITION][DOUBLEDIAMOND_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 0.0,\n\
'scaleX': 1,\n\
'scaleY': 1,\n\
'reverseMethod': REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
\n\
aTransitionInfoTable[IRISWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[IRISWIPE_TRANSITION][RECTANGLE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 0.0,\n\
'scaleX': 1.0,\n\
'scaleY': 1.0,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
\n\
aTransitionInfoTable[IRISWIPE_TRANSITION][DIAMOND_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle': 45.0,\n\
'scaleX': Math.SQRT2,\n\
'scaleY': Math.SQRT2,\n\
'reverseMethod': REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep': true,\n\
'scaleIsotropically': false\n\
};\n\
\n\
aTransitionInfoTable[ZIGZAGWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[ZIGZAGWIPE_TRANSITION][LEFTTORIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[ZIGZAGWIPE_TRANSITION][TOPTOBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[BARNZIGZAGWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[BARNZIGZAGWIPE_TRANSITION][VERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BARNZIGZAGWIPE_TRANSITION][HORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[BARWIPE_TRANSITION] = {};\n\
";

static const char aSVGScript48[] =
"\
aTransitionInfoTable[BARWIPE_TRANSITION][LEFTTORIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : false,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BARWIPE_TRANSITION][TOPTOBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : false,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[WATERFALLWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[WATERFALLWIPE_TRANSITION][VERTICALLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[WATERFALLWIPE_TRANSITION][VERTICALRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[WATERFALLWIPE_TRANSITION][HORIZONTALLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[WATERFALLWIPE_TRANSITION][HORIZONTALRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_ROTATE_180,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[BOXWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][TOPLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][TOPRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][BOTTOMRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][BOTTOMLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][TOPCENTER_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][RIGHTCENTER_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][BOTTOMCENTER_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[BOXWIPE_TRANSITION][LEFTCENTER_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[FOURBOXWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[FOURBOXWIPE_TRANSITION][CORNERSIN_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[FOURBOXWIPE_TRANSITION][CORNERSOUT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
";

static const char aSVGScript49[] =
"\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[ELLIPSEWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[ELLIPSEWIPE_TRANSITION][CIRCLE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : true\n\
};\n\
aTransitionInfoTable[ELLIPSEWIPE_TRANSITION][HORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[ELLIPSEWIPE_TRANSITION][VERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[CLOCKWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[CLOCKWIPE_TRANSITION][CLOCKWISETWELVE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[CLOCKWIPE_TRANSITION][CLOCKWISETHREE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[CLOCKWIPE_TRANSITION][CLOCKWISESIX_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[CLOCKWIPE_TRANSITION][CLOCKWISENINE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 270.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[VEEWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[VEEWIPE_TRANSITION][DOWN_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[VEEWIPE_TRANSITION][LEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[VEEWIPE_TRANSITION][UP_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[VEEWIPE_TRANSITION][RIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[FANWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][CENTERTOP_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][CENTERRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][TOP_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
";

static const char aSVGScript50[] =
"\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][RIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][BOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[FANWIPE_TRANSITION][LEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][ONEBLADE_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][TWOBLADEVERTICAL_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][THREEBLADE_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][FOURBLADE_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][EIGHTBLADE_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : true\n\
};\n\
aTransitionInfoTable[PINWHEELWIPE_TRANSITION][TWOBLADEHORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : -90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : true\n\
};\n\
\n\
aTransitionInfoTable[PUSHWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[PUSHWIPE_TRANSITION][FROMLEFT_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PUSHWIPE_TRANSITION][FROMTOP_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PUSHWIPE_TRANSITION][FROMRIGHT_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[PUSHWIPE_TRANSITION][FROMBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_SPECIAL,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISETOP_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISERIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISEBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISELEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 270.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISETOPLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][COUNTERCLOCKWISEBOTTOMLEFT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][CLOCKWISEBOTTOMRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 180.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
";

static const char aSVGScript51[] =
"\
aTransitionInfoTable[SINGLESWEEPWIPE_TRANSITION][COUNTERCLOCKWISETOPRIGHT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_SUBTRACT_AND_INVERT,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[SLIDEWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[SLIDEWIPE_TRANSITION][FROMLEFT_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[SLIDEWIPE_TRANSITION][FROMTOP_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[SLIDEWIPE_TRANSITION][FROMRIGHT_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[SLIDEWIPE_TRANSITION][FROMBOTTOM_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_SPECIAL,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[FADE_TRANSITION] = {};\n\
aTransitionInfoTable[FADE_TRANSITION][CROSSFADE_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[FADE_TRANSITION][FADETOCOLOR_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[FADE_TRANSITION][FADEFROMCOLOR_TRANS_SUBTYPE] =\n\
aTransitionInfoTable[FADE_TRANSITION][FADEOVERCOLOR_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_SPECIAL,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
\n\
aTransitionInfoTable[RANDOMBARWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[RANDOMBARWIPE_TRANSITION][VERTICAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[RANDOMBARWIPE_TRANSITION][HORIZONTAL_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[CHECKERBOARDWIPE_TRANSITION] = {};\n\
aTransitionInfoTable[CHECKERBOARDWIPE_TRANSITION][DOWN_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 90.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_Y,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
aTransitionInfoTable[CHECKERBOARDWIPE_TRANSITION][ACROSS_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_FLIP_X,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : false\n\
};\n\
\n\
aTransitionInfoTable[DISSOLVE_TRANSITION] = {};\n\
aTransitionInfoTable[DISSOLVE_TRANSITION][DEFAULT_TRANS_SUBTYPE] =\n\
{\n\
'class' : TRANSITION_CLIP_POLYPOLYGON,\n\
'rotationAngle' : 0.0,\n\
'scaleX' : 1.0,\n\
'scaleY' : 1.0,\n\
'reverseMethod' : REVERSEMETHOD_IGNORE,\n\
'outInvertsSweep' : true,\n\
'scaleIsotropically' : true\n\
};\n\
\n\
\n\
function createStateTransitionTable()\n\
{\n\
var aSTT = {};\n\
\n\
aSTT[RESTART_MODE_NEVER] = {};\n\
aSTT[RESTART_MODE_WHEN_NOT_ACTIVE] = {};\n\
aSTT[RESTART_MODE_ALWAYS] = {};\n\
\n\
var aTable =\n\
aSTT[RESTART_MODE_NEVER][FILL_MODE_REMOVE] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = ENDED_NODE;\n\
aTable[FROZEN_NODE]         = INVALID_NODE;  // this state is unreachable here\n\
aTable[ENDED_NODE]          = ENDED_NODE;    // this state is a sink here (cannot restart)\n\
\n\
aTable =\n\
aSTT[RESTART_MODE_NEVER][FILL_MODE_FREEZE] =\n\
aSTT[RESTART_MODE_NEVER][FILL_MODE_HOLD] =\n\
aSTT[RESTART_MODE_NEVER][FILL_MODE_TRANSITION] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = FROZEN_NODE | ENDED_NODE;\n\
aTable[FROZEN_NODE]         = ENDED_NODE;\n\
aTable[ENDED_NODE]          = ENDED_NODE;   // this state is a sink here (cannot restart)\n\
\n\
aTable =\n\
aSTT[RESTART_MODE_WHEN_NOT_ACTIVE][FILL_MODE_REMOVE] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = ENDED_NODE;\n\
aTable[FROZEN_NODE]         = INVALID_NODE;  // this state is unreachable here\n\
aTable[ENDED_NODE]          = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
\n\
aTable =\n\
aSTT[RESTART_MODE_WHEN_NOT_ACTIVE][FILL_MODE_FREEZE] =\n\
aSTT[RESTART_MODE_WHEN_NOT_ACTIVE][FILL_MODE_HOLD] =\n\
aSTT[RESTART_MODE_WHEN_NOT_ACTIVE][FILL_MODE_TRANSITION] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = FROZEN_NODE | ENDED_NODE;\n\
aTable[FROZEN_NODE]         = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
aTable[ENDED_NODE]          = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
\n\
aTable =\n\
aSTT[RESTART_MODE_ALWAYS][FILL_MODE_REMOVE] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
";

static const char aSVGScript52[] =
"\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
aTable[FROZEN_NODE]         = INVALID_NODE;  // this state is unreachable here\n\
aTable[ENDED_NODE]          = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
\n\
aTable =\n\
aSTT[RESTART_MODE_ALWAYS][FILL_MODE_FREEZE] =\n\
aSTT[RESTART_MODE_ALWAYS][FILL_MODE_HOLD] =\n\
aSTT[RESTART_MODE_ALWAYS][FILL_MODE_TRANSITION] = {};\n\
aTable[INVALID_NODE]        = INVALID_NODE;\n\
aTable[UNRESOLVED_NODE]     = RESOLVED_NODE | ENDED_NODE;\n\
aTable[RESOLVED_NODE]       = ACTIVE_NODE | ENDED_NODE;\n\
aTable[ACTIVE_NODE]         = RESOLVED_NODE | ACTIVE_NODE | FROZEN_NODE | ENDED_NODE;\n\
aTable[FROZEN_NODE]         = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
aTable[ENDED_NODE]          = RESOLVED_NODE | ACTIVE_NODE | ENDED_NODE;  // restart is possible\n\
\n\
return aSTT;\n\
}\n\
\n\
var aStateTransitionTable = createStateTransitionTable();\n\
\n\
\n\
function getTransitionTable( eRestartMode, eFillMode )\n\
{\n\
if( eRestartMode == RESTART_MODE_DEFAULT )\n\
{\n\
log( 'getTransitionTable: unexpected restart mode: ' + eRestartMode\n\
+ '. Used NEVER instead.');\n\
eRestartMode = RESTART_MODE_NEVER;\n\
}\n\
\n\
if( eFillMode == FILL_MODE_DEFAULT ||\n\
eFillMode == FILL_MODE_AUTO )\n\
{\n\
eFillMode = FILL_MODE_REMOVE;\n\
}\n\
\n\
return aStateTransitionTable[eRestartMode][eFillMode];\n\
}\n\
\n\
\n\
var EVENT_TRIGGER_UNKNOWN               = 0;\n\
var EVENT_TRIGGER_ON_SLIDE_BEGIN        = 1; // eslint-disable-line no-unused-vars\n\
var EVENT_TRIGGER_ON_SLIDE_END          = 2; // eslint-disable-line no-unused-vars\n\
var EVENT_TRIGGER_BEGIN_EVENT           = 3;\n\
var EVENT_TRIGGER_END_EVENT             = 4;\n\
var EVENT_TRIGGER_ON_CLICK              = 5;\n\
var EVENT_TRIGGER_ON_DBL_CLICK          = 6; // eslint-disable-line no-unused-vars\n\
var EVENT_TRIGGER_ON_MOUSE_ENTER        = 7; // eslint-disable-line no-unused-vars\n\
var EVENT_TRIGGER_ON_MOUSE_LEAVE        = 8; // eslint-disable-line no-unused-vars\n\
var EVENT_TRIGGER_ON_NEXT_EFFECT        = 9;\n\
var EVENT_TRIGGER_ON_PREV_EFFECT        = 10;\n\
var EVENT_TRIGGER_REPEAT                = 11; // eslint-disable-line no-unused-vars\n\
\n\
var aEventTriggerOutMap = [ 'unknown', 'slideBegin', 'slideEnd', 'begin', 'end', 'click',\n\
'doubleClick', 'mouseEnter', 'mouseLeave', 'next', 'previous', 'repeat' ];\n\
\n\
\n\
function getEventTriggerType( sEventTrigger )\n\
{\n\
if( sEventTrigger == 'begin' )\n\
return EVENT_TRIGGER_BEGIN_EVENT;\n\
else if( sEventTrigger == 'end' )\n\
return EVENT_TRIGGER_END_EVENT;\n\
else if( sEventTrigger == 'next' )\n\
return EVENT_TRIGGER_ON_NEXT_EFFECT;\n\
else if( sEventTrigger == 'prev' )\n\
return EVENT_TRIGGER_ON_PREV_EFFECT;\n\
else if( sEventTrigger == 'click' )\n\
return EVENT_TRIGGER_ON_CLICK;\n\
else\n\
return EVENT_TRIGGER_UNKNOWN;\n\
}\n\
\n\
\n\
var UNKNOWN_TIMING          = 0;\n\
var OFFSET_TIMING           = 1;\n\
var WALLCLOCK_TIMING        = 2; // eslint-disable-line no-unused-vars\n\
var INDEFINITE_TIMING       = 3;\n\
var EVENT_TIMING            = 4;\n\
var SYNCBASE_TIMING         = 5;\n\
var MEDIA_TIMING            = 6; // eslint-disable-line no-unused-vars\n\
\n\
var aTimingTypeOutMap = [ 'unknown', 'offset', 'wallclock', 'indefinite', 'event', 'syncbase', 'media' ];\n\
\n\
\n\
var CHARCODE_PLUS       = '+'.charCodeAt(0);\n\
var CHARCODE_MINUS      = '-'.charCodeAt(0);\n\
var CHARCODE_0          = '0'.charCodeAt(0);\n\
var CHARCODE_9          = '9'.charCodeAt(0);\n\
\n\
\n\
function Timing( aAnimationNode, sTimingAttribute )\n\
{\n\
this.aAnimationNode = aAnimationNode;     // the node, the timing attribute belongs to\n\
this.sTimingDescription = removeWhiteSpaces( sTimingAttribute );\n\
this.eTimingType = UNKNOWN_TIMING;\n\
this.nOffset = 0.0;                       // in seconds\n\
this.sEventBaseElementId = '';            // the element id for event based timing\n\
this.eEventType = EVENT_TRIGGER_UNKNOWN;  // the event type\n\
}\n\
\n\
Timing.prototype.getAnimationNode = function()\n\
{\n\
return this.aAnimationNode;\n\
};\n\
\n\
Timing.prototype.getType = function()\n\
{\n\
return this.eTimingType;\n\
};\n\
\n\
Timing.prototype.getOffset = function()\n\
{\n\
return this.nOffset;\n\
};\n\
\n\
Timing.prototype.getEventBaseElementId = function()\n\
{\n\
return this.sEventBaseElementId;\n\
};\n\
\n\
Timing.prototype.getEventType = function()\n\
{\n\
return this.eEventType;\n\
};\n\
\n\
Timing.prototype.parse = function()\n\
{\n\
if( !this.sTimingDescription )\n\
{\n\
this.eTimingType = OFFSET_TIMING;\n\
return;\n\
}\n\
\n\
if( this.sTimingDescription == 'indefinite' )\n\
this.eTimingType = INDEFINITE_TIMING;\n\
else\n\
{\n\
var nFirstCharCode = this.sTimingDescription.charCodeAt(0);\n\
var bPositiveOffset = !( nFirstCharCode == CHARCODE_MINUS );\n\
if ( ( nFirstCharCode == CHARCODE_PLUS ) ||\n\
( nFirstCharCode == CHARCODE_MINUS ) ||\n\
( ( nFirstCharCode >= CHARCODE_0 ) && ( nFirstCharCode <= CHARCODE_9 ) ) )\n\
{\n\
var sClockValue\n\
= ( ( nFirstCharCode == CHARCODE_PLUS ) || ( nFirstCharCode == CHARCODE_MINUS ) )\n\
? this.sTimingDescription.substr( 1 )\n\
: this.sTimingDescription;\n\
";

static const char aSVGScript53[] =
"\
\n\
var TimeInSec = Timing.parseClockValue( sClockValue );\n\
if( TimeInSec != undefined )\n\
{\n\
this.eTimingType = OFFSET_TIMING;\n\
this.nOffset = bPositiveOffset ? TimeInSec : -TimeInSec;\n\
}\n\
}\n\
else\n\
{\n\
var aTimingSplit = [];\n\
bPositiveOffset = true;\n\
if( this.sTimingDescription.indexOf( '+' ) != -1 )\n\
{\n\
aTimingSplit = this.sTimingDescription.split( '+' );\n\
}\n\
else if( this.sTimingDescription.indexOf( '-' ) != -1 )\n\
{\n\
aTimingSplit = this.sTimingDescription.split( '-' );\n\
bPositiveOffset = false;\n\
}\n\
else\n\
{\n\
aTimingSplit[0] = this.sTimingDescription;\n\
aTimingSplit[1] = '';\n\
}\n\
\n\
if( aTimingSplit[0].indexOf( '.' ) != -1 )\n\
{\n\
var aEventSplit = aTimingSplit[0].split( '.' );\n\
this.sEventBaseElementId = aEventSplit[0];\n\
this.eEventType = getEventTriggerType( aEventSplit[1] );\n\
}\n\
else\n\
{\n\
this.eEventType = getEventTriggerType( aTimingSplit[0] );\n\
}\n\
\n\
if( this.eEventType == EVENT_TRIGGER_UNKNOWN )\n\
return;\n\
\n\
if( ( this.eEventType == EVENT_TRIGGER_BEGIN_EVENT ) ||\n\
( this.eEventType == EVENT_TRIGGER_END_EVENT ) )\n\
{\n\
this.eTimingType = SYNCBASE_TIMING;\n\
}\n\
else\n\
{\n\
this.eTimingType = EVENT_TIMING;\n\
}\n\
\n\
if( aTimingSplit[1] )\n\
{\n\
sClockValue = aTimingSplit[1];\n\
TimeInSec = Timing.parseClockValue( sClockValue );\n\
if( TimeInSec != undefined )\n\
{\n\
this.nOffset = ( bPositiveOffset ) ? TimeInSec : -TimeInSec;\n\
}\n\
else\n\
{\n\
this.eTimingType = UNKNOWN_TIMING;\n\
}\n\
\n\
}\n\
}\n\
}\n\
\n\
};\n\
\n\
Timing.parseClockValue = function( sClockValue )\n\
{\n\
if( !sClockValue )\n\
return 0.0;\n\
\n\
var nTimeInSec = undefined;\n\
\n\
var reFullClockValue = /^([0-9]+):([0-5][0-9]):([0-5][0-9])(.[0-9]+)?$/;\n\
var rePartialClockValue = /^([0-5][0-9]):([0-5][0-9])(.[0-9]+)?$/;\n\
var reTimeCountValue = /^([0-9]+)(.[0-9]+)?(h|min|s|ms)?$/;\n\
\n\
if( reFullClockValue.test( sClockValue ) )\n\
{\n\
var aClockTimeParts = reFullClockValue.exec( sClockValue );\n\
\n\
var nHours = parseInt( aClockTimeParts[1] );\n\
var nMinutes = parseInt( aClockTimeParts[2] );\n\
var nSeconds = parseInt( aClockTimeParts[3] );\n\
if( aClockTimeParts[4] )\n\
nSeconds += parseFloat( aClockTimeParts[4] );\n\
\n\
nTimeInSec = ( ( nHours * 60 ) +  nMinutes ) * 60 + nSeconds;\n\
\n\
}\n\
else if( rePartialClockValue.test( sClockValue ) )\n\
{\n\
aClockTimeParts = rePartialClockValue.exec( sClockValue );\n\
\n\
nMinutes = parseInt( aClockTimeParts[1] );\n\
nSeconds = parseInt( aClockTimeParts[2] );\n\
if( aClockTimeParts[3] )\n\
nSeconds += parseFloat( aClockTimeParts[3] );\n\
\n\
nTimeInSec = nMinutes * 60 + nSeconds;\n\
}\n\
else if( reTimeCountValue.test( sClockValue ) )\n\
{\n\
aClockTimeParts = reTimeCountValue.exec( sClockValue );\n\
\n\
var nTimeCount = parseInt( aClockTimeParts[1] );\n\
if( aClockTimeParts[2] )\n\
nTimeCount += parseFloat( aClockTimeParts[2] );\n\
\n\
if( aClockTimeParts[3] )\n\
{\n\
if( aClockTimeParts[3] == 'h' )\n\
{\n\
nTimeInSec = nTimeCount * 3600;\n\
}\n\
else if( aClockTimeParts[3] == 'min' )\n\
{\n\
nTimeInSec = nTimeCount * 60;\n\
}\n\
else if( aClockTimeParts[3] == 's' )\n\
{\n\
nTimeInSec = nTimeCount;\n\
}\n\
else if( aClockTimeParts[3] == 'ms' )\n\
{\n\
nTimeInSec = nTimeCount / 1000;\n\
}\n\
}\n\
else\n\
{\n\
nTimeInSec = nTimeCount;\n\
}\n\
\n\
}\n\
\n\
if( nTimeInSec )\n\
nTimeInSec = parseFloat( nTimeInSec.toFixed( 3 ) );\n\
return nTimeInSec;\n\
};\n\
\n\
Timing.prototype.info = function( bVerbose )\n\
{\n\
\n\
var sInfo = '';\n\
\n\
if( bVerbose )\n\
";

static const char aSVGScript54[] =
"\
{\n\
sInfo = 'description: ' + this.sTimingDescription + ', ';\n\
\n\
sInfo += ', type: ' +  aTimingTypeOutMap[ this.getType() ];\n\
sInfo += ', offset: ' + this.getOffset();\n\
sInfo += ', event base element id: ' + this.getEventBaseElementId();\n\
sInfo += ', timing event type: ' + aEventTriggerOutMap[ this.getEventType() ];\n\
}\n\
else\n\
{\n\
switch( this.getType() )\n\
{\n\
case INDEFINITE_TIMING:\n\
sInfo += 'indefinite';\n\
break;\n\
case OFFSET_TIMING:\n\
sInfo += this.getOffset();\n\
break;\n\
case EVENT_TIMING:\n\
case SYNCBASE_TIMING:\n\
if( this.getEventBaseElementId() )\n\
sInfo += this.getEventBaseElementId() + '.';\n\
sInfo += aEventTriggerOutMap[ this.getEventType() ];\n\
if( this.getOffset() )\n\
{\n\
if( this.getOffset() > 0 )\n\
sInfo += '+';\n\
sInfo += this.getOffset();\n\
}\n\
}\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function Duration( sDurationAttribute )\n\
{\n\
this.bIndefinite = false;\n\
this.bMedia = false;\n\
this.nValue = undefined;\n\
this.bDefined = false;\n\
\n\
if( !sDurationAttribute )\n\
return;\n\
\n\
if( sDurationAttribute == 'indefinite' )\n\
this.bIndefinite = true;\n\
else if( sDurationAttribute == 'media' )\n\
this.bMedia = true;\n\
else\n\
{\n\
this.nValue = Timing.parseClockValue( sDurationAttribute );\n\
if( this.nValue <= 0.0 )\n\
this.nValue = 0.001;  // duration must be always greater than 0\n\
}\n\
this.bDefined = true;\n\
}\n\
\n\
\n\
Duration.prototype.isSet = function()\n\
{\n\
return this.bDefined;\n\
};\n\
\n\
Duration.prototype.isIndefinite = function()\n\
{\n\
return this.bIndefinite;\n\
};\n\
\n\
Duration.prototype.isMedia = function()\n\
{\n\
return this.bMedia;\n\
};\n\
\n\
Duration.prototype.isValue = function()\n\
{\n\
return this.nValue != undefined;\n\
};\n\
\n\
Duration.prototype.getValue= function()\n\
{\n\
return this.nValue;\n\
};\n\
\n\
Duration.prototype.info= function()\n\
{\n\
var sInfo;\n\
\n\
if( this.isIndefinite() )\n\
sInfo = 'indefinite';\n\
else if( this.isMedia() )\n\
sInfo = 'media';\n\
else if( this.getValue() )\n\
sInfo = this.getValue();\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function AnimationNode()\n\
{\n\
}\n\
\n\
AnimationNode.prototype.init = function() {};\n\
AnimationNode.prototype.resolve = function() {};\n\
AnimationNode.prototype.activate = function() {};\n\
AnimationNode.prototype.deactivate = function() {};\n\
AnimationNode.prototype.end = function() {};\n\
AnimationNode.prototype.getState = function() {};\n\
AnimationNode.prototype.registerDeactivatingListener = function() {};\n\
AnimationNode.prototype.notifyDeactivating = function() {};\n\
\n\
\n\
function NodeContext( aSlideShowContext )\n\
{\n\
this.aContext = aSlideShowContext;\n\
this.aAnimationNodeMap = null;\n\
this.aAnimatedElementMap = null;\n\
this.aSourceEventElementMap = null;\n\
this.nStartDelay = 0.0;\n\
this.bFirstRun = undefined;\n\
this.bIsInvalid = false;\n\
this.aSlideHeight = HEIGHT;\n\
this.aSlideWidth = WIDTH;\n\
}\n\
\n\
\n\
NodeContext.prototype.makeSourceEventElement = function( sId, aEventBaseElem )\n\
{\n\
if( !aEventBaseElem )\n\
{\n\
log( 'NodeContext.makeSourceEventElement: event base element is not valid' );\n\
return null;\n\
}\n\
\n\
if( !this.aContext.aEventMultiplexer )\n\
{\n\
log( 'NodeContext.makeSourceEventElement: event multiplexer not initialized' );\n\
return null;\n\
}\n\
\n\
if( !this.aSourceEventElementMap[ sId ] )\n\
{\n\
this.aSourceEventElementMap[ sId ] = new SourceEventElement( sId, aEventBaseElem, this.aContext.aEventMultiplexer );\n\
}\n\
return this.aSourceEventElementMap[ sId ];\n\
};\n\
\n\
\n\
";

static const char aSVGScript55[] =
"\
function StateTransition( aBaseNode )\n\
{\n\
this.aNode = aBaseNode;\n\
this.eToState = INVALID_NODE;\n\
}\n\
\n\
StateTransition.prototype.enter = function( eNodeState, bForce )\n\
{\n\
if( !bForce ) bForce = false;\n\
\n\
if( this.eToState != INVALID_NODE )\n\
{\n\
log( 'StateTransition.enter: commit() before enter()ing again!' );\n\
return false;\n\
}\n\
if( !bForce && !this.aNode.isTransition( this.aNode.getState(), eNodeState  ) )\n\
return false;\n\
\n\
if( ( this.aNode.nCurrentStateTransition & eNodeState ) != 0 )\n\
return false; // already in wanted transition\n\
\n\
this.aNode.nCurrentStateTransition |= eNodeState;\n\
this.eToState = eNodeState;\n\
return true;\n\
};\n\
\n\
StateTransition.prototype.commit = function()\n\
{\n\
if( this.eToState != INVALID_NODE )\n\
{\n\
this.aNode.eCurrentState = this.eToState;\n\
this.clear();\n\
}\n\
};\n\
\n\
StateTransition.prototype.clear = function()\n\
{\n\
if( this.eToState != INVALID_NODE )\n\
{\n\
this.aNode.nCurrentStateTransition &= ~this.eToState;\n\
this.eToState = INVALID_NODE;\n\
}\n\
};\n\
\n\
\n\
function BaseNode( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
this.nId = getUniqueId();\n\
this.sClassName = 'BaseNode';\n\
\n\
if( !aAnimElem )\n\
log( 'BaseNode(id:' + this.nId + ') constructor: aAnimElem is not valid' );\n\
\n\
if( !aNodeContext )\n\
log( 'BaseNode(id:' + this.nId + ') constructor: aNodeContext is not valid' );\n\
\n\
if( !aNodeContext.aContext )\n\
log( 'BaseNode(id:' + this.nId + ') constructor: aNodeContext.aContext is not valid' );\n\
\n\
\n\
this.bIsContainer = false;\n\
this.aElement = aAnimElem;\n\
this.aParentNode = aParentNode;\n\
this.aNodeContext = aNodeContext;\n\
this.aContext = aNodeContext.aContext;\n\
this.nStartDelay = aNodeContext.nStartDelay;\n\
this.eCurrentState = UNRESOLVED_NODE;\n\
this.nCurrentStateTransition = 0;\n\
this.aDeactivatingListenerArray = [];\n\
this.aActivationEvent = null;\n\
this.aDeactivationEvent = null;\n\
\n\
this.aBegin = null;\n\
this.aDuration = null;\n\
this.aEnd = null;\n\
this.bMainSequenceRootNode = false;\n\
this.bInteractiveSequenceRootNode = false;\n\
this.eFillMode = FILL_MODE_FREEZE;\n\
this.eRestartMode = RESTART_MODE_NEVER;\n\
this.nRepeatCount = undefined;\n\
this.nAccelerate = 0.0;\n\
this.nDecelerate = 0.0;\n\
this.bAutoReverse = false;\n\
\n\
}\n\
extend( BaseNode, AnimationNode );\n\
\n\
\n\
BaseNode.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
BaseNode.prototype.parseElement = function()\n\
{\n\
var aAnimElem = this.aElement;\n\
\n\
var sIdAttr = aAnimElem.getAttributeNS( NSS['xml'], 'id' );\n\
if( sIdAttr )\n\
this.aNodeContext.aAnimationNodeMap[ sIdAttr ] = this;\n\
\n\
this.aBegin = null;\n\
var sBeginAttr = aAnimElem.getAttributeNS( NSS['smil'], 'begin' );\n\
this.aBegin = new Timing( this, sBeginAttr );\n\
this.aBegin.parse();\n\
\n\
this.aEnd = null;\n\
var sEndAttr = aAnimElem.getAttributeNS( NSS['smil'], 'end' );\n\
if( sEndAttr )\n\
{\n\
this.aEnd = new Timing( this, sEndAttr );\n\
this.aEnd.parse();\n\
}\n\
\n\
this.aDuration = null;\n\
var sDurAttr = aAnimElem.getAttributeNS( NSS['smil'], 'dur' );\n\
this.aDuration = new Duration( sDurAttr );\n\
if( !this.aDuration.isSet() )\n\
{\n\
if( this.isContainer() )\n\
this.aDuration = null;\n\
else\n\
this.aDuration = new Duration( 'indefinite' );\n\
}\n\
\n\
var sFillAttr = aAnimElem.getAttributeNS( NSS['smil'], 'fill' );\n\
if( sFillAttr && aFillModeInMap[ sFillAttr ])\n\
this.eFillMode = aFillModeInMap[ sFillAttr ];\n\
else\n\
this.eFillMode = FILL_MODE_DEFAULT;\n\
\n\
var sRestartAttr = aAnimElem.getAttributeNS( NSS['smil'], 'restart' );\n\
if( sRestartAttr && aRestartModeInMap[ sRestartAttr ] )\n\
this.eRestartMode = aRestartModeInMap[ sRestartAttr ];\n\
else\n\
this.eRestartMode = RESTART_MODE_DEFAULT;\n\
\n\
var sRepeatCount = aAnimElem.getAttributeNS( NSS['smil'], 'repeatCount' );\n\
if( !sRepeatCount )\n\
this.nRepeatCount = 1;\n\
else\n\
this.nRepeatCount = parseFloat( sRepeatCount );\n\
if( ( isNaN(this.nRepeatCount) ) && ( sRepeatCount != 'indefinite' ) )\n\
this.nRepeatCount = 1;\n\
\n\
this.nAccelerate = 0.0;\n\
var sAccelerateAttr = aAnimElem.getAttributeNS( NSS['smil'], 'accelerate' );\n\
if( sAccelerateAttr )\n\
this.nAccelerate = parseFloat( sAccelerateAttr );\n\
if( isNaN(this.nAccelerate) )\n\
";

static const char aSVGScript56[] =
"\
this.nAccelerate = 0.0;\n\
\n\
this.nDecelerate = 0.0;\n\
var sDecelerateAttr = aAnimElem.getAttributeNS( NSS['smil'], 'decelerate' );\n\
if( sDecelerateAttr )\n\
this.nDecelerate = parseFloat( sDecelerateAttr );\n\
if( isNaN(this.nDecelerate) )\n\
this.nDecelerate = 0.0;\n\
\n\
this.bAutoreverse = false;\n\
var sAutoReverseAttr = aAnimElem.getAttributeNS( NSS['smil'], 'autoReverse' );\n\
if( sAutoReverseAttr == 'true' )\n\
this.bAutoreverse = true;\n\
\n\
\n\
if( this.eFillMode == FILL_MODE_DEFAULT )\n\
if( this.getParentNode() )\n\
this.eFillMode = this.getParentNode().getFillMode();\n\
else\n\
this.eFillMode = FILL_MODE_AUTO;\n\
\n\
if( this.eFillMode ==  FILL_MODE_AUTO ) // see SMIL recommendation document\n\
{\n\
this.eFillMode = ( this.aEnd ||\n\
( this.nRepeatCount != 1) ||\n\
( this.aDuration && !this.aDuration.isIndefinite() ) )\n\
? FILL_MODE_REMOVE\n\
: FILL_MODE_FREEZE;\n\
}\n\
\n\
if( this.eRestartMode == RESTART_MODE_DEFAULT )\n\
if( this.getParentNode() )\n\
this.eRestartMode = this.getParentNode().getRestartMode();\n\
else\n\
this.eRestartMode = RESTART_MODE_ALWAYS;\n\
\n\
if( ( this.nAccelerate + this.nDecelerate ) > 1.0 )\n\
{\n\
this.nAccelerate = 0.0;\n\
this.nDecelerate = 0.0;\n\
}\n\
\n\
this.aStateTransTable = getTransitionTable( this.getRestartMode(), this.getFillMode() );\n\
\n\
return true;\n\
};\n\
\n\
BaseNode.prototype.getParentNode = function()\n\
{\n\
return this.aParentNode;\n\
};\n\
\n\
BaseNode.prototype.init = function()\n\
{\n\
this.DBG( this.callInfo( 'init' ) );\n\
if( ! this.checkValidNode() )\n\
return false;\n\
if( this.aActivationEvent )\n\
this.aActivationEvent.dispose();\n\
if( this.aDeactivationEvent )\n\
this.aDeactivationEvent.dispose();\n\
\n\
this.eCurrentState = UNRESOLVED_NODE;\n\
\n\
return this.init_st();\n\
};\n\
\n\
BaseNode.prototype.resolve = function()\n\
{\n\
if( this.aNodeContext.bIsInvalid || ! this.checkValidNode() )\n\
return false;\n\
\n\
this.DBG( this.callInfo( 'resolve' ) );\n\
\n\
if( this.eCurrentState == RESOLVED_NODE )\n\
log( 'BaseNode.resolve: already in RESOLVED state' );\n\
\n\
var aStateTrans = new StateTransition( this );\n\
\n\
if( aStateTrans.enter( RESOLVED_NODE ) &&\n\
this.isTransition( RESOLVED_NODE, ACTIVE_NODE ) &&\n\
this.resolve_st() )\n\
{\n\
aStateTrans.commit();\n\
\n\
if( this.aActivationEvent )\n\
{\n\
this.aActivationEvent.charge();\n\
}\n\
else\n\
{\n\
this.aActivationEvent = makeDelay( bind( this, this.activate ), this.getBegin().getOffset() + this.nStartDelay );\n\
}\n\
registerEvent( this.getId(), this.getBegin(), this.aActivationEvent, this.aNodeContext );\n\
\n\
return true;\n\
}\n\
\n\
return false;\n\
};\n\
\n\
BaseNode.prototype.activate = function()\n\
{\n\
if( ! this.checkValidNode() )\n\
return false;\n\
\n\
if( this.eCurrentState == ACTIVE_NODE )\n\
log( 'BaseNode.activate: already in ACTIVE state' );\n\
\n\
this.DBG( this.callInfo( 'activate' ), getCurrentSystemTime() );\n\
\n\
var aStateTrans = new StateTransition( this );\n\
\n\
if( aStateTrans.enter( ACTIVE_NODE ) )\n\
{\n\
this.activate_st();\n\
aStateTrans.commit();\n\
if( !this.aContext.aEventMultiplexer )\n\
log( 'BaseNode.activate: this.aContext.aEventMultiplexer is not valid' );\n\
this.aContext.aEventMultiplexer.notifyEvent( EVENT_TRIGGER_BEGIN_EVENT, this.getId() );\n\
return true;\n\
}\n\
return false;\n\
};\n\
\n\
BaseNode.prototype.deactivate = function()\n\
{\n\
if( this.inStateOrTransition( ENDED_NODE | FROZEN_NODE ) || !this.checkValidNode() )\n\
return;\n\
\n\
if( this.isTransition( this.eCurrentState, FROZEN_NODE ) )\n\
{\n\
this.DBG( this.callInfo( 'deactivate' ), getCurrentSystemTime() );\n\
\n\
var aStateTrans = new StateTransition( this );\n\
if( aStateTrans.enter( FROZEN_NODE, true /* FORCE */ ) )\n\
{\n\
this.deactivate_st( FROZEN_NODE );\n\
aStateTrans.commit();\n\
\n\
this.notifyEndListeners();\n\
\n\
if( this.aActivationEvent )\n\
this.aActivationEvent.dispose();\n\
if( this.aDeactivationEvent )\n\
this.aDeactivationEvent.dispose();\n\
}\n\
}\n\
else\n\
{\n\
";

static const char aSVGScript57[] =
"\
this.end();\n\
}\n\
};\n\
\n\
BaseNode.prototype.end = function()\n\
{\n\
var bIsFrozenOrInTransitionToFrozen = this.inStateOrTransition( FROZEN_NODE );\n\
if( this.inStateOrTransition( ENDED_NODE ) || !this.checkValidNode() )\n\
return;\n\
\n\
if( !(this.isTransition( this.eCurrentState, ENDED_NODE ) ) )\n\
log( 'BaseNode.end: end state not reachable in transition table' );\n\
\n\
this.DBG( this.callInfo( 'end' ), getCurrentSystemTime() );\n\
\n\
var aStateTrans = new StateTransition( this );\n\
if( aStateTrans.enter( ENDED_NODE, true /* FORCE */ ) )\n\
{\n\
this.deactivate_st( ENDED_NODE );\n\
aStateTrans.commit();\n\
\n\
if( !bIsFrozenOrInTransitionToFrozen )\n\
this.notifyEndListeners();\n\
\n\
if( this.aActivationEvent )\n\
this.aActivationEvent.dispose();\n\
if( this.aDeactivationEvent )\n\
this.aDeactivationEvent.dispose();\n\
}\n\
};\n\
\n\
BaseNode.prototype.dispose = function()\n\
{\n\
if( this.aActivationEvent )\n\
this.aActivationEvent.dispose();\n\
if( this.aDeactivationEvent )\n\
this.aDeactivationEvent.dispose();\n\
this.aDeactivatingListenerArray = [];\n\
};\n\
\n\
BaseNode.prototype.getState = function()\n\
{\n\
return this.eCurrentState;\n\
};\n\
\n\
BaseNode.prototype.registerDeactivatingListener = function( aNotifiee )\n\
{\n\
if (! this.checkValidNode())\n\
return false;\n\
\n\
if( !aNotifiee )\n\
{\n\
log( 'BaseNode.registerDeactivatingListener(): invalid notifiee' );\n\
return false;\n\
}\n\
this.aDeactivatingListenerArray.push( aNotifiee );\n\
\n\
return true;\n\
};\n\
\n\
BaseNode.prototype.notifyDeactivating = function( aNotifier )\n\
{\n\
assert( ( aNotifier.getState() == FROZEN_NODE ) || ( aNotifier.getState() == ENDED_NODE ),\n\
'BaseNode.notifyDeactivating: Notifier node is neither in FROZEN nor in ENDED state' );\n\
};\n\
\n\
BaseNode.prototype.isMainSequenceRootNode = function()\n\
{\n\
return this.bMainSequenceRootNode;\n\
};\n\
\n\
BaseNode.prototype.isInteractiveSequenceRootNode = function()\n\
{\n\
return this.bInteractiveSequenceRootNode;\n\
};\n\
\n\
BaseNode.prototype.makeDeactivationEvent = function( nDelay )\n\
{\n\
if( this.aDeactivationEvent )\n\
{\n\
this.aDeactivationEvent.charge();\n\
}\n\
else\n\
{\n\
if( typeof( nDelay ) == typeof(0) )\n\
this.aDeactivationEvent = makeDelay( bind( this, this.deactivate ), nDelay );\n\
else\n\
this.aDeactivationEvent = null;\n\
}\n\
return this.aDeactivationEvent;\n\
};\n\
\n\
BaseNode.prototype.scheduleDeactivationEvent = function( aEvent )\n\
{\n\
this.DBG( this.callInfo( 'scheduleDeactivationEvent' ) );\n\
\n\
if( !aEvent )\n\
{\n\
if( this.getDuration() && this.getDuration().isValue() )\n\
aEvent = this.makeDeactivationEvent( this.getDuration().getValue() );\n\
}\n\
if( aEvent )\n\
{\n\
this.aContext.aTimerEventQueue.addEvent( aEvent );\n\
}\n\
};\n\
\n\
BaseNode.prototype.checkValidNode = function()\n\
{\n\
return ( this.eCurrentState != INVALID_NODE );\n\
};\n\
\n\
BaseNode.prototype.init_st = function()\n\
{\n\
return true;\n\
};\n\
\n\
BaseNode.prototype.resolve_st = function()\n\
{\n\
return true;\n\
};\n\
\n\
BaseNode.prototype.activate_st = function()\n\
{\n\
this.scheduleDeactivationEvent();\n\
};\n\
\n\
BaseNode.prototype.deactivate_st = function( /*aNodeState*/ )\n\
{\n\
};\n\
\n\
BaseNode.prototype.notifyEndListeners = function()\n\
{\n\
var nDeactivatingListenerCount = this.aDeactivatingListenerArray.length;\n\
\n\
for( var i = 0; i < nDeactivatingListenerCount; ++i )\n\
{\n\
this.aDeactivatingListenerArray[i].notifyDeactivating( this );\n\
}\n\
\n\
this.aContext.aEventMultiplexer.notifyEvent( EVENT_TRIGGER_END_EVENT, this.getId() );\n\
if( this.getParentNode() && this.getParentNode().isMainSequenceRootNode() )\n\
this.aContext.aEventMultiplexer.notifyNextEffectEndEvent();\n\
\n\
if( this.isMainSequenceRootNode() )\n\
this.aContext.aEventMultiplexer.notifyAnimationsEndEvent();\n\
};\n\
\n\
BaseNode.prototype.getContext = function()\n\
{\n\
";

static const char aSVGScript58[] =
"\
return this.aContext;\n\
};\n\
\n\
BaseNode.prototype.isTransition = function( eFromState, eToState )\n\
{\n\
return ( ( this.aStateTransTable[ eFromState ] & eToState ) != 0 );\n\
};\n\
\n\
BaseNode.prototype.inStateOrTransition = function( nMask )\n\
{\n\
return ( ( ( this.eCurrentState & nMask ) != 0 ) || ( ( this.nCurrentStateTransition & nMask ) != 0 ) );\n\
};\n\
\n\
BaseNode.prototype.isContainer = function()\n\
{\n\
return this.bIsContainer;\n\
};\n\
\n\
BaseNode.prototype.getBegin = function()\n\
{\n\
return this.aBegin;\n\
};\n\
\n\
BaseNode.prototype.getDuration = function()\n\
{\n\
return this.aDuration;\n\
};\n\
\n\
BaseNode.prototype.getEnd = function()\n\
{\n\
return this.aEnd;\n\
};\n\
\n\
BaseNode.prototype.getFillMode = function()\n\
{\n\
return this.eFillMode;\n\
};\n\
\n\
BaseNode.prototype.getRestartMode = function()\n\
{\n\
return this.eRestartMode;\n\
};\n\
\n\
BaseNode.prototype.getRepeatCount = function()\n\
{\n\
return this.nRepeatCount;\n\
};\n\
\n\
BaseNode.prototype.getAccelerateValue = function()\n\
{\n\
return this.nAccelerate;\n\
};\n\
\n\
BaseNode.prototype.getDecelerateValue = function()\n\
{\n\
return this.nDecelerate;\n\
};\n\
\n\
BaseNode.prototype.isAutoReverseEnabled = function()\n\
{\n\
return this.bAutoreverse;\n\
};\n\
\n\
BaseNode.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = 'class name: ' + this.sClassName;\n\
sInfo += ';  element name: ' + this.aElement.localName;\n\
sInfo += ';  id: ' + this.getId();\n\
sInfo += ';  state: ' + getNodeStateName( this.getState() );\n\
\n\
if( bVerbose )\n\
{\n\
sInfo += ';  is container: ' + this.isContainer();\n\
\n\
if( this.getBegin() )\n\
sInfo += ';  begin: ' + this.getBegin().info();\n\
\n\
if( this.getDuration() )\n\
sInfo += ';  dur: ' + this.getDuration().info();\n\
\n\
if( this.getEnd() )\n\
sInfo += ';  end: ' + this.getEnd().info();\n\
\n\
if( this.getFillMode() )\n\
sInfo += ';  fill: ' + aFillModeOutMap[ this.getFillMode() ];\n\
\n\
if( this.getRestartMode() )\n\
sInfo += ';  restart: ' + aRestartModeOutMap[ this.getRestartMode() ];\n\
\n\
if( this.getRepeatCount() && ( this.getRepeatCount() != 1.0 ) )\n\
sInfo += ';  repeatCount: ' + this.getRepeatCount();\n\
\n\
if( this.getAccelerateValue() )\n\
sInfo += ';  accelerate: ' + this.getAccelerateValue();\n\
\n\
if( this.getDecelerateValue() )\n\
sInfo += ';  decelerate: ' + this.getDecelerateValue();\n\
\n\
if( this.isAutoReverseEnabled() )\n\
sInfo += ';  autoReverse: true';\n\
\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
BaseNode.prototype.callInfo = function( sMethodName )\n\
{\n\
var sInfo = this.sClassName +\n\
'( ' + this.getId() +\n\
', ' + getNodeStateName( this.getState() ) +\n\
' ).' + sMethodName;\n\
return sInfo;\n\
};\n\
\n\
BaseNode.prototype.DBG = function( sMessage, nTime )\n\
{\n\
ANIMDBG.print( sMessage, nTime );\n\
};\n\
\n\
\n\
function AnimationBaseNode( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationBaseNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'AnimationBaseNode';\n\
this.bIsContainer = false;\n\
this.aTargetElement = null;\n\
this.bIsTargetTextElement = false;\n\
this.aAnimatedElement = null;\n\
this.aActivity = null;\n\
\n\
this.nMinFrameCount = undefined;\n\
this.eAdditiveMode = undefined;\n\
\n\
}\n\
extend( AnimationBaseNode, BaseNode );\n\
\n\
\n\
AnimationBaseNode.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationBaseNode.superclass.parseElement.call( this );\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.aTargetElement = null;\n\
var sTargetElementAttr = aAnimElem.getAttributeNS( NSS['smil'], 'targetElement' );\n\
if( sTargetElementAttr )\n\
this.aTargetElement = document.getElementById( sTargetElementAttr );\n\
\n\
";

static const char aSVGScript59[] =
"\
if( !this.aTargetElement )\n\
{\n\
this.eCurrentState = INVALID_NODE;\n\
log( 'AnimationBaseNode.parseElement: target element not found: ' + sTargetElementAttr );\n\
}\n\
\n\
var sSubItemAttr = aAnimElem.getAttributeNS( NSS['anim'], 'sub-item' );\n\
this.bIsTargetTextElement = ( sSubItemAttr && ( sSubItemAttr === 'text' ) );\n\
\n\
var sAdditiveAttr = aAnimElem.getAttributeNS( NSS['smil'], 'additive' );\n\
if( sAdditiveAttr && aAddittiveModeInMap[sAdditiveAttr] )\n\
this.eAdditiveMode = aAddittiveModeInMap[sAdditiveAttr];\n\
else\n\
this.eAdditiveMode = ADDITIVE_MODE_REPLACE;\n\
\n\
this.nMinFrameCount = ( this.getDuration().isValue() )\n\
? ( this.getDuration().getValue() * MINIMUM_FRAMES_PER_SECONDS )\n\
: MINIMUM_FRAMES_PER_SECONDS;\n\
if( this.nMinFrameCount < 1.0 )\n\
this.nMinFrameCount = 1;\n\
else if( this.nMinFrameCount > MINIMUM_FRAMES_PER_SECONDS )\n\
this.nMinFrameCount = MINIMUM_FRAMES_PER_SECONDS;\n\
\n\
\n\
if( this.aTargetElement )\n\
{\n\
if( aAnimElem.getAttributeNS( NSS['smil'], 'attributeName' ) === 'visibility' )\n\
{\n\
if( aAnimElem.getAttributeNS( NSS['smil'], 'to' ) === 'visible' )\n\
this.aTargetElement.setAttribute( 'visibility', 'hidden' );\n\
}\n\
\n\
if( !this.aNodeContext.aAnimatedElementMap[ sTargetElementAttr ] )\n\
{\n\
if( this.bIsTargetTextElement )\n\
{\n\
this.aNodeContext.aAnimatedElementMap[ sTargetElementAttr ]\n\
= new AnimatedTextElement( this.aTargetElement );\n\
}\n\
else\n\
{\n\
this.aNodeContext.aAnimatedElementMap[ sTargetElementAttr ]\n\
= new AnimatedElement( this.aTargetElement );\n\
}\n\
}\n\
this.aAnimatedElement = this.aNodeContext.aAnimatedElementMap[ sTargetElementAttr ];\n\
\n\
this.aAnimatedElement.setAdditiveMode( this.eAdditiveMode );\n\
}\n\
\n\
\n\
return bRet;\n\
};\n\
\n\
AnimationBaseNode.prototype.init_st = function()\n\
{\n\
if( this.aActivity )\n\
this.aActivity.activate( makeEvent( bind( this, this.deactivate ) ) );\n\
else\n\
this.aActivity = this.createActivity();\n\
return true;\n\
};\n\
\n\
AnimationBaseNode.prototype.resolve_st = function()\n\
{\n\
return true;\n\
};\n\
\n\
AnimationBaseNode.prototype.activate_st = function()\n\
{\n\
if( this.aActivity )\n\
{\n\
this.saveStateOfAnimatedElement();\n\
this.aActivity.setTargets( this.getAnimatedElement() );\n\
if( this.getContext().bIsSkipping  )\n\
{\n\
this.aActivity.end();\n\
}\n\
else\n\
{\n\
this.getContext().aActivityQueue.addActivity( this.aActivity );\n\
}\n\
}\n\
else\n\
{\n\
AnimationBaseNode.superclass.scheduleDeactivationEvent.call( this );\n\
}\n\
};\n\
\n\
AnimationBaseNode.prototype.deactivate_st = function( eDestState )\n\
{\n\
if( eDestState == FROZEN_NODE )\n\
{\n\
if( this.aActivity )\n\
this.aActivity.end();\n\
}\n\
if( eDestState == ENDED_NODE )\n\
{\n\
if( this.aActivity )\n\
this.aActivity.dispose();\n\
if( ( this.getFillMode() == FILL_MODE_REMOVE ) && this.getAnimatedElement()  )\n\
this.removeEffect();\n\
}\n\
};\n\
\n\
AnimationBaseNode.prototype.createActivity = function()\n\
{\n\
log( 'AnimationBaseNode.createActivity: abstract method called' );\n\
};\n\
\n\
AnimationBaseNode.prototype.fillActivityParams = function()\n\
{\n\
\n\
var nDuration = 0.001;\n\
if( this.getDuration().isValue() )\n\
{\n\
nDuration = this.getDuration().getValue();\n\
}\n\
else\n\
{\n\
log( 'AnimationBaseNode.fillActivityParams: duration is not a number' );\n\
}\n\
\n\
var aActivityParamSet = new ActivityParamSet();\n\
\n\
aActivityParamSet.aEndEvent             = makeEvent( bind( this, this.deactivate ) );\n\
aActivityParamSet.aTimerEventQueue      = this.aContext.aTimerEventQueue;\n\
aActivityParamSet.aActivityQueue        = this.aContext.aActivityQueue;\n\
aActivityParamSet.nMinDuration          = nDuration;\n\
aActivityParamSet.nMinNumberOfFrames    = this.getMinFrameCount();\n\
aActivityParamSet.bAutoReverse          = this.isAutoReverseEnabled();\n\
aActivityParamSet.nRepeatCount          = this.getRepeatCount();\n\
aActivityParamSet.nAccelerationFraction = this.getAccelerateValue();\n\
aActivityParamSet.nDecelerationFraction = this.getDecelerateValue();\n\
aActivityParamSet.nSlideWidth           = this.aNodeContext.aSlideWidth;\n\
aActivityParamSet.nSlideHeight          = this.aNodeContext.aSlideHeight;\n\
\n\
return aActivityParamSet;\n\
};\n\
\n\
AnimationBaseNode.prototype.hasPendingAnimation = function()\n\
{\n\
return true;\n\
};\n\
\n\
AnimationBaseNode.prototype.saveStateOfAnimatedElement = function()\n\
{\n\
this.getAnimatedElement().saveState( this.getId() );\n\
};\n\
\n\
";

static const char aSVGScript60[] =
"\
AnimationBaseNode.prototype.removeEffect = function()\n\
{\n\
this.getAnimatedElement().restoreState( this.getId() );\n\
};\n\
\n\
AnimationBaseNode.prototype.getTargetElement = function()\n\
{\n\
return this.aTargetElement;\n\
};\n\
\n\
AnimationBaseNode.prototype.getAnimatedElement = function()\n\
{\n\
return this.aAnimatedElement;\n\
};\n\
\n\
AnimationBaseNode.prototype.dispose= function()\n\
{\n\
if( this.aActivity )\n\
this.aActivity.dispose();\n\
\n\
AnimationBaseNode.superclass.dispose.call( this );\n\
};\n\
\n\
AnimationBaseNode.prototype.getMinFrameCount = function()\n\
{\n\
return this.nMinFrameCount;\n\
};\n\
\n\
AnimationBaseNode.prototype.getAdditiveMode = function()\n\
{\n\
return this.eAdditiveMode;\n\
};\n\
\n\
AnimationBaseNode.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = AnimationBaseNode.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
if( this.getMinFrameCount() )\n\
sInfo += ';  min frame count: ' + this.getMinFrameCount();\n\
\n\
sInfo += ';  additive: ' + aAddittiveModeOutMap[ this.getAdditiveMode() ];\n\
\n\
if( this.getTargetElement() )\n\
{\n\
var sElemId = this.getTargetElement().getAttribute( 'id' );\n\
sInfo += ';  targetElement: ' +  sElemId;\n\
}\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function AnimationBaseNode2( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationBaseNode2.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sAttributeName = '';\n\
this.aToValue = null;\n\
\n\
}\n\
extend( AnimationBaseNode2, AnimationBaseNode );\n\
\n\
\n\
AnimationBaseNode2.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationBaseNode2.superclass.parseElement.call( this );\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.sAttributeName = aAnimElem.getAttributeNS( NSS['smil'], 'attributeName' );\n\
if( !this.sAttributeName )\n\
{\n\
this.eCurrentState = INVALID_NODE;\n\
log( 'AnimationBaseNode2.parseElement: target attribute name not found: ' + this.sAttributeName );\n\
}\n\
\n\
this.aToValue = aAnimElem.getAttributeNS( NSS['smil'], 'to' );\n\
\n\
return bRet;\n\
};\n\
\n\
AnimationBaseNode2.prototype.getAttributeName = function()\n\
{\n\
return this.sAttributeName;\n\
};\n\
\n\
AnimationBaseNode2.prototype.getToValue = function()\n\
{\n\
return this.aToValue;\n\
};\n\
\n\
AnimationBaseNode2.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = AnimationBaseNode2.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
if( this.getAttributeName() )\n\
sInfo += ';  attributeName: ' + this.getAttributeName();\n\
\n\
if( this.getToValue() )\n\
sInfo += ';  to: ' + this.getToValue();\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function AnimationBaseNode3( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationBaseNode3.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.eAccumulate = undefined;\n\
this.eCalcMode = undefined;\n\
this.aFromValue = null;\n\
this.aByValue = null;\n\
this.aKeyTimes = null;\n\
this.aValues = null;\n\
this.aFormula= null;\n\
}\n\
extend( AnimationBaseNode3, AnimationBaseNode2 );\n\
\n\
\n\
AnimationBaseNode3.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationBaseNode3.superclass.parseElement.call( this );\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.eAccumulate = ACCUMULATE_MODE_NONE;\n\
var sAccumulateAttr = aAnimElem.getAttributeNS( NSS['smil'], 'accumulate' );\n\
if( sAccumulateAttr == 'sum' )\n\
this.eAccumulate = ACCUMULATE_MODE_SUM;\n\
\n\
this.eCalcMode = CALC_MODE_LINEAR;\n\
var sCalcModeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'calcMode' );\n\
if( sCalcModeAttr && aCalcModeInMap[ sCalcModeAttr ] )\n\
this.eCalcMode = aCalcModeInMap[ sCalcModeAttr ];\n\
\n\
this.aFromValue = aAnimElem.getAttributeNS( NSS['smil'], 'from' );\n\
\n\
this.aByValue = aAnimElem.getAttributeNS( NSS['smil'], 'by' );\n\
\n\
this.aKeyTimes = [];\n\
var sKeyTimesAttr = aAnimElem.getAttributeNS( NSS['smil'], 'keyTimes' );\n\
sKeyTimesAttr = removeWhiteSpaces( sKeyTimesAttr );\n\
if( sKeyTimesAttr )\n\
";

static const char aSVGScript61[] =
"\
{\n\
var aKeyTimes = sKeyTimesAttr.split( ';' );\n\
for( var i = 0; i < aKeyTimes.length; ++i )\n\
this.aKeyTimes.push( parseFloat( aKeyTimes[i] ) );\n\
}\n\
\n\
var sValuesAttr = aAnimElem.getAttributeNS( NSS['smil'], 'values' );\n\
if( sValuesAttr )\n\
{\n\
this.aValues = sValuesAttr.split( ';' );\n\
}\n\
else\n\
{\n\
this.aValues = [];\n\
}\n\
\n\
this.aFormula = aAnimElem.getAttributeNS( NSS['anim'], 'formula' );\n\
\n\
return bRet;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getAccumulate = function()\n\
{\n\
return this.eAccumulate;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getCalcMode = function()\n\
{\n\
return this.eCalcMode;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getFromValue = function()\n\
{\n\
return this.aFromValue;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getByValue = function()\n\
{\n\
return this.aByValue;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getKeyTimes = function()\n\
{\n\
return this.aKeyTimes;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getValues = function()\n\
{\n\
return this.aValues;\n\
};\n\
\n\
AnimationBaseNode3.prototype.getFormula = function()\n\
{\n\
return this.aFormula;\n\
};\n\
\n\
AnimationBaseNode3.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = AnimationBaseNode3.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
if( this.getAccumulate() )\n\
sInfo += ';  accumulate: ' + aAccumulateModeOutMap[ this.getAccumulate() ];\n\
\n\
sInfo += ';  calcMode: ' + aCalcModeOutMap[ this.getCalcMode() ];\n\
\n\
if( this.getFromValue() )\n\
sInfo += ';  from: ' + this.getFromValue();\n\
\n\
if( this.getByValue() )\n\
sInfo += ';  by: ' + this.getByValue();\n\
\n\
if( this.getKeyTimes().length )\n\
sInfo += ';  keyTimes: ' + this.getKeyTimes().join( ',' );\n\
\n\
if( this.getValues().length )\n\
sInfo += ';  values: ' + this.getValues().join( ',' );\n\
\n\
if( this.getFormula() )\n\
sInfo += ';  formula: ' + this.getFormula();\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function BaseContainerNode( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
BaseContainerNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'BaseContainerNode';\n\
this.bIsContainer = true;\n\
this.aChildrenArray = [];\n\
this.nFinishedChildren = 0;\n\
this.bDurationIndefinite = false;\n\
this.nLeftIterations = 1;\n\
\n\
this.eImpressNodeType = undefined;\n\
this.ePresetClass =  undefined;\n\
this.ePresetId =  undefined;\n\
}\n\
extend( BaseContainerNode, BaseNode );\n\
\n\
\n\
BaseContainerNode.prototype.parseElement= function()\n\
{\n\
var bRet = BaseContainerNode.superclass.parseElement.call( this );\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.eImpressNodeType = IMPRESS_DEFAULT_NODE;\n\
var sNodeTypeAttr = aAnimElem.getAttributeNS( NSS['presentation'], 'node-type' );\n\
if( sNodeTypeAttr && aImpressNodeTypeInMap[ sNodeTypeAttr ] )\n\
this.eImpressNodeType = aImpressNodeTypeInMap[ sNodeTypeAttr ];\n\
this.bMainSequenceRootNode = ( this.eImpressNodeType == IMPRESS_MAIN_SEQUENCE_NODE );\n\
this.bInteractiveSequenceRootNode = ( this.eImpressNodeType == IMPRESS_INTERACTIVE_SEQUENCE_NODE );\n\
\n\
this.ePresetClass =  undefined;\n\
var sPresetClassAttr = aAnimElem.getAttributeNS( NSS['presentation'], 'preset-class' );\n\
if( sPresetClassAttr && aPresetClassInMap[ sPresetClassAttr ] )\n\
this.ePresetClass = aPresetClassInMap[ sPresetClassAttr ];\n\
\n\
this.ePresetId =  undefined;\n\
var sPresetIdAttr = aAnimElem.getAttributeNS( NSS['presentation'], 'preset-id' );\n\
if( sPresetIdAttr && aPresetIdInMap[ sPresetIdAttr ] )\n\
this.ePresetId = aPresetIdInMap[ sPresetIdAttr ];\n\
\n\
\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
this.aChildrenArray[i].parseElement();\n\
}\n\
\n\
\n\
this.bDurationIndefinite\n\
= ( !this.getDuration() || this.getDuration().isIndefinite()  ) &&\n\
( !this.getEnd() || ( this.getEnd().getType() != OFFSET_TIMING ) );\n\
\n\
return bRet;\n\
};\n\
\n\
BaseContainerNode.prototype.appendChildNode = function( aAnimationNode )\n\
{\n\
if( ! this.checkValidNode() )\n\
return ;\n\
\n\
if( aAnimationNode.registerDeactivatingListener( this ) )\n\
this.aChildrenArray.push( aAnimationNode );\n\
";

static const char aSVGScript62[] =
"\
};\n\
\n\
BaseContainerNode.prototype.removeAllChildrenNodes = function()\n\
{\n\
this.aChildrenArray = [];\n\
};\n\
\n\
BaseContainerNode.prototype.init_st = function()\n\
{\n\
this.nLeftIterations = this.getRepeatCount();\n\
\n\
return this.init_children();\n\
};\n\
\n\
BaseContainerNode.prototype.init_children = function()\n\
{\n\
this.nFinishedChildren = 0;\n\
var nChildrenCount = this.aChildrenArray.length;\n\
var nInitChildren = 0;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
if( this.aChildrenArray[i].init() )\n\
{\n\
++nInitChildren;\n\
}\n\
}\n\
return ( nChildrenCount == nInitChildren );\n\
};\n\
\n\
\n\
BaseContainerNode.prototype.deactivate_st = function( eDestState )\n\
{\n\
this.nLeftIterations = 0;\n\
if( eDestState == FROZEN_NODE )\n\
{\n\
this.forEachChildNode( mem_fn( 'deactivate' ), ~( FROZEN_NODE | ENDED_NODE ) );\n\
}\n\
else\n\
{\n\
this.forEachChildNode( mem_fn( 'end' ), ~ENDED_NODE );\n\
if( this.getFillMode() == FILL_MODE_REMOVE )\n\
this.removeEffect();\n\
}\n\
};\n\
\n\
BaseContainerNode.prototype.hasPendingAnimation = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
if( this.aChildrenArray[i].hasPendingAnimation() )\n\
return true;\n\
}\n\
return false;\n\
};\n\
\n\
BaseContainerNode.prototype.activate_st = function()\n\
{\n\
log( 'BaseContainerNode.activate_st: abstract method called' );\n\
};\n\
\n\
BaseContainerNode.prototype.notifyDeactivating = function( /*aAnimationNode*/ )\n\
{\n\
log( 'BaseContainerNode.notifyDeactivating: abstract method called' );\n\
};\n\
\n\
BaseContainerNode.prototype.isDurationIndefinite = function()\n\
{\n\
return this.bDurationIndefinite;\n\
};\n\
\n\
BaseContainerNode.prototype.isChildNode = function( aAnimationNode )\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
if( this.aChildrenArray[i].getId() == aAnimationNode.getId() )\n\
return true;\n\
}\n\
return false;\n\
};\n\
\n\
BaseContainerNode.prototype.notifyDeactivatedChild = function( aChildNode )\n\
{\n\
assert( ( aChildNode.getState() == FROZEN_NODE ) || ( aChildNode.getState() == ENDED_NODE ),\n\
'BaseContainerNode.notifyDeactivatedChild: passed child node is neither in FROZEN nor in ENDED state' );\n\
\n\
assert( this.getState() != INVALID_NODE,\n\
'BaseContainerNode.notifyDeactivatedChild: this node is invalid' );\n\
\n\
if( !this.isChildNode( aChildNode ) )\n\
{\n\
log( 'BaseContainerNode.notifyDeactivatedChild: unknown child notifier!' );\n\
return false;\n\
}\n\
\n\
var nChildrenCount = this.aChildrenArray.length;\n\
\n\
assert( ( this.nFinishedChildren < nChildrenCount ),\n\
'BaseContainerNode.notifyDeactivatedChild: assert(this.nFinishedChildren < nChildrenCount) failed' );\n\
\n\
++this.nFinishedChildren;\n\
var bFinished = ( this.nFinishedChildren >= nChildrenCount );\n\
\n\
if( bFinished && this.isDurationIndefinite() )\n\
{\n\
if( this.nLeftIterations >= 1.0 )\n\
{\n\
this.nLeftIterations -= 1.0;\n\
}\n\
if( this.nLeftIterations >= 1.0 )\n\
{\n\
bFinished = false;\n\
var aRepetitionEvent = makeDelay( bind( this, this.repeat ), 0.0 );\n\
this.aContext.aTimerEventQueue.addEvent( aRepetitionEvent );\n\
}\n\
else\n\
{\n\
this.deactivate();\n\
}\n\
}\n\
\n\
return bFinished;\n\
};\n\
\n\
BaseContainerNode.prototype.repeat = function()\n\
{\n\
this.forEachChildNode( mem_fn( 'end' ), ~ENDED_NODE );\n\
this.removeEffect();\n\
var bInitialized = this.init_children();\n\
if( bInitialized )\n\
this.activate_st();\n\
return bInitialized;\n\
};\n\
\n\
BaseContainerNode.prototype.removeEffect = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
if( nChildrenCount == 0 )\n\
return;\n\
for( var i = nChildrenCount - 1; i >= 0; --i )\n\
{\n\
if( ( this.aChildrenArray[i].getState() & ( FROZEN_NODE | ENDED_NODE ) ) == 0 )\n\
{\n\
log( 'BaseContainerNode.removeEffect: child(id:'\n\
+ this.aChildrenArray[i].getId() + ') is neither frozen nor ended;'\n\
+ ' state: '\n\
+ aTransitionModeOutMap[ this.aChildrenArray[i].getState() ] );\n\
continue;\n\
}\n\
";

static const char aSVGScript63[] =
"\
this.aChildrenArray[i].removeEffect();\n\
}\n\
};\n\
\n\
BaseContainerNode.prototype.saveStateOfAnimatedElement = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
this.aChildrenArray[i].saveStateOfAnimatedElement();\n\
}\n\
};\n\
\n\
BaseContainerNode.prototype.forEachChildNode = function( aFunction, eNodeStateMask )\n\
{\n\
if( !eNodeStateMask )\n\
eNodeStateMask = -1;\n\
\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
if( ( eNodeStateMask != -1 ) && ( ( this.aChildrenArray[i].getState() & eNodeStateMask ) == 0 ) )\n\
continue;\n\
aFunction( this.aChildrenArray[i] );\n\
}\n\
};\n\
\n\
BaseContainerNode.prototype.dispose = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
this.aChildrenArray[i].dispose();\n\
}\n\
\n\
BaseContainerNode.superclass.dispose.call( this );\n\
};\n\
\n\
BaseContainerNode.prototype.getImpressNodeType = function()\n\
{\n\
return this.eImpressNodeType;\n\
};\n\
\n\
BaseContainerNode.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = BaseContainerNode.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
if( this.getImpressNodeType() )\n\
sInfo += ';  node-type: ' + aImpressNodeTypeOutMap[ this.getImpressNodeType() ];\n\
}\n\
\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
sInfo += '\\n';\n\
sInfo += this.aChildrenArray[i].info( bVerbose );\n\
}\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function ParallelTimeContainer( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
ParallelTimeContainer.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'ParallelTimeContainer';\n\
}\n\
extend( ParallelTimeContainer, BaseContainerNode );\n\
\n\
\n\
ParallelTimeContainer.prototype.activate_st = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
var nResolvedChildren = 0;\n\
for( var i = 0; i < nChildrenCount; ++i )\n\
{\n\
if( this.aChildrenArray[i].resolve() )\n\
{\n\
++nResolvedChildren;\n\
}\n\
}\n\
\n\
if( nChildrenCount != nResolvedChildren )\n\
{\n\
log( 'ParallelTimeContainer.activate_st: resolving all children failed' );\n\
return;\n\
}\n\
\n\
\n\
if( this.isDurationIndefinite() && ( nChildrenCount == 0  ) )\n\
{\n\
this.scheduleDeactivationEvent( this.makeDeactivationEvent( 0.0 ) );\n\
}\n\
else\n\
{\n\
this.scheduleDeactivationEvent();\n\
}\n\
};\n\
\n\
ParallelTimeContainer.prototype.notifyDeactivating = function( aAnimationNode )\n\
{\n\
this.notifyDeactivatedChild( aAnimationNode );\n\
};\n\
\n\
\n\
function SequentialTimeContainer( aAnimElem, aParentNode, aNodeContext )\n\
{\n\
SequentialTimeContainer.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'SequentialTimeContainer';\n\
this.bIsRewinding = false;\n\
this.aCurrentSkipEvent = null;\n\
this.aRewindCurrentEffectEvent = null;\n\
this.aRewindLastEffectEvent = null;\n\
}\n\
extend( SequentialTimeContainer, BaseContainerNode );\n\
\n\
\n\
SequentialTimeContainer.prototype.activate_st = function()\n\
{\n\
var nChildrenCount = this.aChildrenArray.length;\n\
for( ; this.nFinishedChildren < nChildrenCount; ++this.nFinishedChildren )\n\
{\n\
if( this.resolveChild( this.aChildrenArray[ this.nFinishedChildren ] ) )\n\
break;\n\
else\n\
log( 'SequentialTimeContainer.activate_st: resolving child failed!' );\n\
}\n\
\n\
if( this.isDurationIndefinite() && ( ( nChildrenCount == 0 ) || ( this.nFinishedChildren >= nChildrenCount ) ) )\n\
{\n\
this.scheduleDeactivationEvent( this.makeDeactivationEvent( 0.0 ) );\n\
}\n\
else\n\
{\n\
this.scheduleDeactivationEvent();\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.notifyDeactivating = function( aNotifier )\n\
{\n\
if( this.bIsRewinding )\n\
return;\n\
\n\
if( this.notifyDeactivatedChild( aNotifier ) )\n\
return;\n\
\n\
";

static const char aSVGScript64[] =
"\
assert( this.nFinishedChildren < this.aChildrenArray.length,\n\
'SequentialTimeContainer.notifyDeactivating: assertion (this.nFinishedChildren < this.aChildrenArray.length) failed' );\n\
\n\
var aNextChild = this.aChildrenArray[ this.nFinishedChildren ];\n\
\n\
assert( aNextChild.getState() == UNRESOLVED_NODE,\n\
'SequentialTimeContainer.notifyDeactivating: assertion (aNextChild.getState == UNRESOLVED_NODE) failed' );\n\
\n\
if( !this.resolveChild( aNextChild ) )\n\
{\n\
this.deactivate();\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.skipEffect = function( aChildNode )\n\
{\n\
if( this.isChildNode( aChildNode ) )\n\
{\n\
this.getContext().aActivityQueue.endAll();\n\
this.getContext().bIsSkipping = true;\n\
this.getContext().aTimerEventQueue.forceEmpty();\n\
this.getContext().bIsSkipping = false;\n\
var aEvent = makeEvent( bind2( aChildNode.deactivate, aChildNode ) );\n\
this.getContext().aTimerEventQueue.addEvent( aEvent );\n\
}\n\
else\n\
{\n\
log( 'SequentialTimeContainer.skipEffect: unknown child: '\n\
+ aChildNode.getId() );\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.rewindCurrentEffect = function( aChildNode )\n\
{\n\
if( this.isChildNode( aChildNode ) )\n\
{\n\
assert( !this.bIsRewinding,\n\
'SequentialTimeContainer.rewindCurrentEffect: is already rewinding.' );\n\
\n\
this.bIsRewinding = true;\n\
this.getContext().aActivityQueue.endAll();\n\
this.getContext().bIsSkipping = true;\n\
this.getContext().aTimerEventQueue.forceEmpty();\n\
this.getContext().bIsSkipping = false;\n\
this.getContext().aActivityQueue.endAll();\n\
\n\
aChildNode.end();\n\
aChildNode.removeEffect();\n\
aChildNode.init();\n\
this.resolveChild( aChildNode );\n\
this.notifyRewindedEvent( aChildNode );\n\
this.bIsRewinding = false;\n\
}\n\
else\n\
{\n\
log( 'SequentialTimeContainer.rewindCurrentEffect: unknown child: '\n\
+ aChildNode.getId() );\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.rewindLastEffect = function( aChildNode )\n\
{\n\
if( this.isChildNode( aChildNode ) )\n\
{\n\
assert( !this.bIsRewinding,\n\
'SequentialTimeContainer.rewindLastEffect: is already rewinding.' );\n\
\n\
this.bIsRewinding = true;\n\
this.getContext().aTimerEventQueue.forceEmpty();\n\
this.getContext().aActivityQueue.clear();\n\
aChildNode.end();\n\
\n\
--this.nFinishedChildren;\n\
var aPreviousChildNode = this.aChildrenArray[ this.nFinishedChildren ];\n\
\n\
aPreviousChildNode.removeEffect();\n\
aPreviousChildNode.init();\n\
aChildNode.init();\n\
this.resolveChild( aPreviousChildNode );\n\
this.notifyRewindedEvent( aChildNode );\n\
this.bIsRewinding = false;\n\
}\n\
else\n\
{\n\
log( 'SequentialTimeContainer.rewindLastEffect: unknown child: '\n\
+ aChildNode.getId() );\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.resolveChild = function( aChildNode )\n\
{\n\
var bResolved = aChildNode.resolve();\n\
\n\
if( bResolved && ( this.isMainSequenceRootNode() || this.isInteractiveSequenceRootNode() ) )\n\
{\n\
if( this.aCurrentSkipEvent )\n\
this.aCurrentSkipEvent.dispose();\n\
this.aCurrentSkipEvent = makeEvent( bind2( SequentialTimeContainer.prototype.skipEffect, this, aChildNode ) );\n\
\n\
if( this.aRewindCurrentEffectEvent )\n\
this.aRewindCurrentEffectEvent.dispose();\n\
this.aRewindCurrentEffectEvent = makeEvent( bind2( SequentialTimeContainer.prototype.rewindCurrentEffect, this, aChildNode ) );\n\
\n\
if( this.aRewindLastEffectEvent )\n\
this.aRewindLastEffectEvent.dispose();\n\
this.aRewindLastEffectEvent = makeEvent( bind2( SequentialTimeContainer.prototype.rewindLastEffect, this, aChildNode ) );\n\
\n\
if( this.isMainSequenceRootNode() )\n\
{\n\
this.aContext.aEventMultiplexer.registerSkipEffectEvent( this.aCurrentSkipEvent );\n\
this.aContext.aEventMultiplexer.registerRewindCurrentEffectEvent( this.aRewindCurrentEffectEvent );\n\
this.aContext.aEventMultiplexer.registerRewindLastEffectEvent( this.aRewindLastEffectEvent );\n\
}\n\
else if( this.isInteractiveSequenceRootNode() )\n\
{\n\
this.aContext.aEventMultiplexer.registerSkipInteractiveEffectEvent( aChildNode.getId(), this.aCurrentSkipEvent );\n\
this.aContext.aEventMultiplexer.registerRewindRunningInteractiveEffectEvent( aChildNode.getId(), this.aRewindCurrentEffectEvent );\n\
this.aContext.aEventMultiplexer.registerRewindEndedInteractiveEffectEvent( aChildNode.getId(), this.aRewindLastEffectEvent );\n\
}\n\
}\n\
return bResolved;\n\
};\n\
\n\
SequentialTimeContainer.prototype.notifyRewindedEvent = function( aChildNode )\n\
{\n\
if( this.isInteractiveSequenceRootNode() )\n\
{\n\
this.aContext.aEventMultiplexer.notifyRewindedEffectEvent( aChildNode.getId() );\n\
\n\
var sId = aChildNode.getBegin().getEventBaseElementId();\n\
if( sId )\n\
{\n\
this.aContext.aEventMultiplexer.notifyRewindedEffectEvent( sId );\n\
}\n\
}\n\
};\n\
\n\
SequentialTimeContainer.prototype.dispose = function()\n\
{\n\
if( this.aCurrentSkipEvent )\n\
this.aCurrentSkipEvent.dispose();\n\
\n\
SequentialTimeContainer.superclass.dispose.call( this );\n\
};\n\
\n\
\n\
function PropertyAnimationNode(  aAnimElem, aParentNode, aNodeContext )\n\
{\n\
PropertyAnimationNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
";

static const char aSVGScript65[] =
"\
this.sClassName = 'PropertyAnimationNode';\n\
}\n\
extend( PropertyAnimationNode, AnimationBaseNode3 );\n\
\n\
\n\
PropertyAnimationNode.prototype.createActivity = function()\n\
{\n\
var aActivityParamSet = this.fillActivityParams();\n\
\n\
var aAnimation = createPropertyAnimation( this.getAttributeName(),\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight );\n\
\n\
var aInterpolator = null;  // createActivity will compute it;\n\
return createActivity( aActivityParamSet, this, aAnimation, aInterpolator );\n\
};\n\
\n\
\n\
function isValidTransformation( sType )\n\
{\n\
return ( sType === 'translate' || sType === 'scale' || sType === 'rotate'\n\
|| sType === 'skewX' || sType === 'skewY' );\n\
}\n\
\n\
function AnimationTransformNode(  aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationTransformNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'AnimationTransformNode';\n\
}\n\
extend( AnimationTransformNode, AnimationBaseNode3 );\n\
\n\
\n\
AnimationTransformNode.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationTransformNode.superclass.parseElement.call(this);\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
var sTransformType = aAnimElem.getAttribute( 'svg:type' );\n\
if( !isValidTransformation( sTransformType ) )\n\
{\n\
this.eCurrentState = INVALID_NODE;\n\
log( 'AnimationTransformNode.parseElement: transformation type not found: ' + sTransformType );\n\
}\n\
else\n\
{\n\
this.sAttributeName = sTransformType;\n\
}\n\
\n\
return bRet;\n\
}\n\
\n\
AnimationTransformNode.prototype.createActivity = function()\n\
{\n\
var aActivityParamSet = this.fillActivityParams();\n\
var aAnimation;\n\
\n\
if( this.getAttributeName() === 'scale' || this.getAttributeName() === 'translate' )\n\
{\n\
aAnimation = createPairPropertyAnimation( this.getAttributeName(),\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight );\n\
\n\
}\n\
else\n\
{\n\
aAnimation = createPropertyAnimation( this.getAttributeName(),\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight );\n\
}\n\
\n\
var aInterpolator = null;  // createActivity will compute it;\n\
return createActivity( aActivityParamSet, this, aAnimation, aInterpolator );\n\
};\n\
\n\
\n\
function AnimationSetNode(  aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationSetNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'AnimationSetNode';\n\
}\n\
extend( AnimationSetNode, AnimationBaseNode2 );\n\
\n\
\n\
AnimationSetNode.prototype.createActivity = function()\n\
{\n\
var aAnimation = createPropertyAnimation( this.getAttributeName(),\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight );\n\
\n\
var aActivityParamSet = this.fillActivityParams();\n\
\n\
return new SetActivity( aActivityParamSet, aAnimation, this.getToValue() );\n\
};\n\
\n\
\n\
function AnimationColorNode(  aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationColorNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'AnimationColorNode';\n\
\n\
this.eColorInterpolation = undefined;\n\
this.eColorInterpolationDirection = undefined;\n\
}\n\
extend( AnimationColorNode, AnimationBaseNode3 );\n\
\n\
\n\
AnimationColorNode.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationColorNode.superclass.parseElement.call( this );\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.eColorInterpolation = COLOR_SPACE_RGB;\n\
var sColorInterpolationAttr = aAnimElem.getAttributeNS( NSS['anim'], 'color-interpolation' );\n\
if( sColorInterpolationAttr && aColorSpaceInMap[ sColorInterpolationAttr ] )\n\
this.eColorInterpolation = aColorSpaceInMap[ sColorInterpolationAttr ];\n\
\n\
this.eColorInterpolationDirection = CLOCKWISE;\n\
var sColorInterpolationDirectionAttr = aAnimElem.getAttributeNS( NSS['anim'], 'color-interpolation-direction' );\n\
if( sColorInterpolationDirectionAttr && aClockDirectionInMap[ sColorInterpolationDirectionAttr ] )\n\
this.eColorInterpolationDirection = aClockDirectionInMap[ sColorInterpolationDirectionAttr ];\n\
\n\
return bRet;\n\
};\n\
\n\
AnimationColorNode.prototype.createActivity = function()\n\
{\n\
var aActivityParamSet = this.fillActivityParams();\n\
\n\
var aAnimation = createPropertyAnimation( this.getAttributeName(),\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight );\n\
\n\
var aColorAnimation;\n\
var aInterpolator;\n\
if( this.getColorInterpolation() === COLOR_SPACE_HSL )\n\
{\n\
ANIMDBG.print( 'AnimationColorNode.createActivity: color space hsl'  );\n\
aColorAnimation = new HSLAnimationWrapper( aAnimation );\n\
var aInterpolatorMaker = aInterpolatorHandler.getInterpolator( this.getCalcMode(),\n\
COLOR_PROPERTY,\n\
";

static const char aSVGScript66[] =
"\
COLOR_SPACE_HSL );\n\
aInterpolator = aInterpolatorMaker( this.getColorInterpolationDirection() );\n\
}\n\
else\n\
{\n\
ANIMDBG.print( 'AnimationColorNode.createActivity: color space rgb'  );\n\
aColorAnimation = aAnimation;\n\
aInterpolator = aInterpolatorHandler.getInterpolator( this.getCalcMode(),\n\
COLOR_PROPERTY,\n\
COLOR_SPACE_RGB );\n\
}\n\
\n\
return createActivity( aActivityParamSet, this, aColorAnimation, aInterpolator );\n\
};\n\
\n\
AnimationColorNode.prototype.getColorInterpolation = function()\n\
{\n\
return this.eColorInterpolation;\n\
};\n\
\n\
AnimationColorNode.prototype.getColorInterpolationDirection = function()\n\
{\n\
return this.eColorInterpolationDirection;\n\
};\n\
\n\
AnimationColorNode.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = AnimationColorNode.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
sInfo += ';  color-interpolation: ' + aColorSpaceOutMap[ this.getColorInterpolation() ];\n\
\n\
sInfo += ';  color-interpolation-direction: ' + aClockDirectionOutMap[ this.getColorInterpolationDirection() ];\n\
}\n\
return sInfo;\n\
};\n\
\n\
\n\
function AnimationTransitionFilterNode(  aAnimElem, aParentNode, aNodeContext )\n\
{\n\
AnimationTransitionFilterNode.superclass.constructor.call( this, aAnimElem, aParentNode, aNodeContext );\n\
\n\
this.sClassName = 'AnimationTransitionFilterNode';\n\
\n\
this.eTransitionType = undefined;\n\
this.eTransitionSubType = undefined;\n\
this.bReverseDirection = undefined;\n\
this.eTransitionMode = undefined;\n\
}\n\
extend( AnimationTransitionFilterNode, AnimationBaseNode );\n\
\n\
\n\
AnimationTransitionFilterNode.prototype.createActivity = function()\n\
{\n\
var aActivityParamSet = this.fillActivityParams();\n\
\n\
return createShapeTransition( aActivityParamSet,\n\
this.getAnimatedElement(),\n\
this.aNodeContext.aSlideWidth,\n\
this.aNodeContext.aSlideHeight,\n\
this );\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.parseElement = function()\n\
{\n\
var bRet = AnimationTransitionFilterNode.superclass.parseElement.call( this );\n\
var bIsValidTransition = true;\n\
\n\
var aAnimElem = this.aElement;\n\
\n\
this.eTransitionType = undefined;\n\
var sTypeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'type' );\n\
if( sTypeAttr && aTransitionTypeInMap[ sTypeAttr ] )\n\
{\n\
this.eTransitionType = aTransitionTypeInMap[ sTypeAttr ];\n\
}\n\
else\n\
{\n\
bIsValidTransition = false;\n\
log( 'AnimationTransitionFilterNode.parseElement: transition type not valid: ' + sTypeAttr );\n\
}\n\
\n\
this.eTransitionSubType = undefined;\n\
var sSubTypeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'subtype' );\n\
if( sSubTypeAttr === null )\n\
sSubTypeAttr = 'default';\n\
if( sSubTypeAttr && ( aTransitionSubtypeInMap[ sSubTypeAttr ] !== undefined  ) )\n\
{\n\
this.eTransitionSubType = aTransitionSubtypeInMap[ sSubTypeAttr ];\n\
}\n\
else\n\
{\n\
bIsValidTransition = false;\n\
log( 'AnimationTransitionFilterNode.parseElement: transition subtype not valid: ' + sSubTypeAttr );\n\
}\n\
\n\
if( !bIsValidTransition )\n\
{\n\
this.eTransitionType = FADE_TRANSITION;\n\
this.eTransitionSubType = CROSSFADE_TRANS_SUBTYPE;\n\
log( 'AnimationTransitionFilterNode.parseElement: in place of the invalid transition a crossfade transition is used' );\n\
}\n\
\n\
this.bReverseDirection = false;\n\
var sDirectionAttr = aAnimElem.getAttributeNS( NSS['smil'], 'direction' );\n\
if( sDirectionAttr == 'reverse' )\n\
this.bReverseDirection = true;\n\
\n\
this.eTransitionMode = TRANSITION_MODE_IN;\n\
var sModeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'mode' );\n\
if( sModeAttr === 'out' )\n\
this.eTransitionMode = TRANSITION_MODE_OUT;\n\
\n\
return bRet;\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.getTransitionType = function()\n\
{\n\
return this.eTransitionType;\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.getTransitionSubType = function()\n\
{\n\
return this.eTransitionSubType;\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.getTransitionMode = function()\n\
{\n\
return this.eTransitionMode;\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.getReverseDirection = function()\n\
{\n\
return this.bReverseDirection;\n\
};\n\
\n\
AnimationTransitionFilterNode.prototype.info = function( bVerbose )\n\
{\n\
var sInfo = AnimationTransitionFilterNode.superclass.info.call( this, bVerbose );\n\
\n\
if( bVerbose )\n\
{\n\
sInfo += ';  type: ' + getKeyByValue(aTransitionTypeInMap, this.getTransitionType());\n\
\n\
sInfo += ';  subtype: ' + getKeyByValue(aTransitionSubtypeInMap, this.getTransitionSubType());\n\
\n\
if( this.getReverseDirection() )\n\
sInfo += ';  direction: reverse';\n\
}\n\
";

static const char aSVGScript67[] =
"\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function createAnimationTree( aRootElement, aNodeContext )\n\
{\n\
return createAnimationNode( aRootElement, null, aNodeContext );\n\
}\n\
\n\
\n\
function createAnimationNode( aElement, aParentNode, aNodeContext )\n\
{\n\
assert( aElement, 'createAnimationNode: invalid animation element' );\n\
\n\
var eAnimationNodeType = getAnimationElementType( aElement );\n\
\n\
var aCreatedNode = null;\n\
var aCreatedContainer = null;\n\
\n\
switch( eAnimationNodeType )\n\
{\n\
case ANIMATION_NODE_PAR:\n\
aCreatedNode = aCreatedContainer =\n\
new ParallelTimeContainer( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_ITERATE:\n\
aCreatedNode = aCreatedContainer =\n\
new ParallelTimeContainer( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_SEQ:\n\
aCreatedNode = aCreatedContainer =\n\
new SequentialTimeContainer( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_ANIMATE:\n\
aCreatedNode = new PropertyAnimationNode( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_SET:\n\
aCreatedNode = new AnimationSetNode( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_ANIMATEMOTION:\n\
log( 'createAnimationNode: ANIMATEMOTION not implemented' );\n\
return null;\n\
case ANIMATION_NODE_ANIMATECOLOR:\n\
aCreatedNode = new AnimationColorNode( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_ANIMATETRANSFORM:\n\
aCreatedNode = new AnimationTransformNode( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_TRANSITIONFILTER:\n\
aCreatedNode = new AnimationTransitionFilterNode( aElement, aParentNode, aNodeContext );\n\
break;\n\
case ANIMATION_NODE_AUDIO:\n\
log( 'createAnimationNode: AUDIO not implemented' );\n\
return null;\n\
case ANIMATION_NODE_COMMAND:\n\
log( 'createAnimationNode: COMMAND not implemented' );\n\
return null;\n\
default:\n\
log( 'createAnimationNode: invalid Animation Node Type: ' + eAnimationNodeType );\n\
return null;\n\
}\n\
\n\
if( aCreatedContainer )\n\
{\n\
if( eAnimationNodeType == ANIMATION_NODE_ITERATE )\n\
{\n\
createIteratedNodes( aElement, aCreatedContainer, aNodeContext );\n\
}\n\
else\n\
{\n\
var aChildrenArray = getElementChildren( aElement );\n\
for( var i = 0; i < aChildrenArray.length; ++i )\n\
{\n\
if( !createChildNode( aChildrenArray[i], aCreatedContainer, aNodeContext ) )\n\
{\n\
aCreatedContainer.removeAllChildrenNodes();\n\
break;\n\
}\n\
}\n\
}\n\
}\n\
\n\
return aCreatedNode;\n\
}\n\
\n\
\n\
function createChildNode( aElement, aParentNode, aNodeContext )\n\
{\n\
var aChildNode = createAnimationNode( aElement, aParentNode, aNodeContext );\n\
\n\
if( !aChildNode )\n\
{\n\
log( 'createChildNode: child node creation failed' );\n\
return false;\n\
}\n\
else\n\
{\n\
aParentNode.appendChildNode( aChildNode );\n\
return true;\n\
}\n\
}\n\
\n\
\n\
function createIteratedNodes( /*aElement, aContainerNode, aNodeContext*/ )\n\
{\n\
}\n\
\n\
\n\
function makeScaler( nScale )\n\
{\n\
if( ( typeof( nScale ) !== typeof( 0 ) ) || !isFinite( nScale ) )\n\
{\n\
log( 'makeScaler: not valid param passed: ' + nScale );\n\
return null;\n\
}\n\
\n\
return  function( nValue )\n\
{\n\
return ( nScale * nValue );\n\
};\n\
}\n\
\n\
\n\
function createPropertyAnimation( sAttrName, aAnimatedElement, nWidth, nHeight )\n\
{\n\
if( !aAttributeMap[ sAttrName ] )\n\
{\n\
log( 'createPropertyAnimation: attribute is unknown' );\n\
return null;\n\
}\n\
\n\
\n\
var aFunctorSet = aAttributeMap[ sAttrName ];\n\
\n\
var sGetValueMethod =   aFunctorSet.get;\n\
var sSetValueMethod =   aFunctorSet.set;\n\
\n\
if( !sGetValueMethod || !sSetValueMethod  )\n\
{\n\
log( 'createPropertyAnimation: attribute is not handled' );\n\
return null;\n\
}\n\
\n\
var aGetModifier =  eval( aFunctorSet.getmod );\n\
var aSetModifier =  eval( aFunctorSet.setmod );\n\
\n\
\n\
return new GenericAnimation( bind( aAnimatedElement, aAnimatedElement[ sGetValueMethod ] ),\n\
bind( aAnimatedElement, aAnimatedElement[ sSetValueMethod ] ),\n\
";

static const char aSVGScript68[] =
"\
aGetModifier,\n\
aSetModifier);\n\
}\n\
\n\
\n\
function createPairPropertyAnimation( sTransformType, aAnimatedElement, nWidth, nHeight )\n\
{\n\
var aFunctorSet = aAttributeMap[ sTransformType ];\n\
var sGetValueMethod = aFunctorSet.get;\n\
var sSetValueMethod = aFunctorSet.set;\n\
\n\
var aDefaultValue = [];\n\
var aSizeReference = [];\n\
if( sTransformType === 'scale' )\n\
{\n\
aDefaultValue[0] = aSizeReference[0] = aAnimatedElement.getBaseBBox().width;\n\
aDefaultValue[1] = aSizeReference[1] = aAnimatedElement.getBaseBBox().height;\n\
}\n\
else if( sTransformType === 'translate' )\n\
{\n\
aDefaultValue[0] = aAnimatedElement.getBaseCenterX();\n\
aDefaultValue[1] = aAnimatedElement.getBaseCenterY();\n\
aSizeReference[0] = nWidth;\n\
aSizeReference[1] = nHeight;\n\
}\n\
else\n\
{\n\
log( 'createPairPropertyAnimation: transform type is not handled' );\n\
return null;\n\
}\n\
\n\
return new TupleAnimation( bind( aAnimatedElement, aAnimatedElement[ sGetValueMethod ] ),\n\
bind( aAnimatedElement, aAnimatedElement[ sSetValueMethod ] ),\n\
aDefaultValue,\n\
aSizeReference );\n\
}\n\
\n\
\n\
function createShapeTransition( aActivityParamSet, aAnimatedElement,\n\
nSlideWidth, nSlideHeight,\n\
aAnimatedTransitionFilterNode )\n\
{\n\
if( !aAnimatedTransitionFilterNode )\n\
{\n\
log( 'createShapeTransition: the animated transition filter node is not valid.' );\n\
return null;\n\
}\n\
var eTransitionType = aAnimatedTransitionFilterNode.getTransitionType();\n\
var eTransitionSubType = aAnimatedTransitionFilterNode.getTransitionSubType();\n\
var bDirectionForward = ! aAnimatedTransitionFilterNode.getReverseDirection();\n\
var bModeIn = ( aAnimatedTransitionFilterNode.getTransitionMode() == FORWARD );\n\
\n\
var aTransitionInfo = aTransitionInfoTable[eTransitionType][eTransitionSubType];\n\
var eTransitionClass = aTransitionInfo['class'];\n\
\n\
switch( eTransitionClass )\n\
{\n\
default:\n\
case TRANSITION_INVALID:\n\
log( 'createShapeTransition: transition class: TRANSITION_INVALID' );\n\
return null;\n\
\n\
case TRANSITION_CLIP_POLYPOLYGON:\n\
var aParametricPolyPolygon\n\
= createClipPolyPolygon( eTransitionType, eTransitionSubType );\n\
var aClippingAnimation\n\
= new ClippingAnimation( aParametricPolyPolygon, aTransitionInfo,\n\
bDirectionForward, bModeIn );\n\
return new SimpleActivity( aActivityParamSet, aClippingAnimation, true );\n\
\n\
case TRANSITION_SPECIAL:\n\
switch( eTransitionType )\n\
{\n\
default:\n\
var aAnimation\n\
= createPropertyAnimation( 'opacity',\n\
aAnimatedElement,\n\
nSlideWidth,\n\
nSlideHeight );\n\
return new SimpleActivity( aActivityParamSet, aAnimation, bModeIn );\n\
}\n\
}\n\
\n\
}\n\
\n\
\n\
function ClippingAnimation( aParametricPolyPolygon, aTransitionInfo,\n\
bDirectionForward, bModeIn )\n\
{\n\
this.aClippingFunctor = new ClippingFunctor( aParametricPolyPolygon,\n\
aTransitionInfo,\n\
bDirectionForward, bModeIn );\n\
this.bAnimationStarted = false;\n\
}\n\
\n\
ClippingAnimation.prototype.start = function( aAnimatableElement )\n\
{\n\
assert( aAnimatableElement,\n\
'ClippingAnimation.start: animatable element is not valid' );\n\
this.aAnimatableElement = aAnimatableElement;\n\
this.aAnimatableElement.initClipPath();\n\
this.aAnimatableElement.notifyAnimationStart();\n\
\n\
if( !this.bAnimationStarted )\n\
this.bAnimationStarted = true;\n\
\n\
};\n\
\n\
ClippingAnimation.prototype.end = function()\n\
{\n\
if( this.bAnimationStarted )\n\
{\n\
this.aAnimatableElement.cleanClipPath();\n\
this.bAnimationStarted = false;\n\
this.aAnimatableElement.notifyAnimationEnd();\n\
}\n\
};\n\
\n\
ClippingAnimation.prototype.perform = function( nValue )\n\
{\n\
var nWidth = this.aAnimatableElement.aClippingBBox.width;\n\
var nHeight = this.aAnimatableElement.aClippingBBox.height;\n\
var aPolyPolygonElement = this.aClippingFunctor.perform( nValue, nWidth, nHeight );\n\
this.aAnimatableElement.setClipPath( aPolyPolygonElement );\n\
};\n\
\n\
ClippingAnimation.prototype.getUnderlyingValue = function()\n\
{\n\
return 0.0;\n\
};\n\
\n\
\n\
function GenericAnimation( aGetValueFunc, aSetValueFunc, aGetModifier, aSetModifier )\n\
{\n\
assert( aGetValueFunc && aSetValueFunc,\n\
'GenericAnimation constructor: get value functor and/or set value functor are not valid' );\n\
\n\
this.aGetValueFunc = aGetValueFunc;\n\
this.aSetValueFunc = aSetValueFunc;\n\
this.aGetModifier = aGetModifier;\n\
this.aSetModifier = aSetModifier;\n\
this.aAnimatableElement = null;\n\
this.bAnimationStarted = false;\n\
}\n\
\n\
\n\
GenericAnimation.prototype.start = function( aAnimatableElement )\n\
{\n\
assert( aAnimatableElement, 'GenericAnimation.start: animatable element is not valid' );\n\
\n\
";

static const char aSVGScript69[] =
"\
this.aAnimatableElement = aAnimatableElement;\n\
this.aAnimatableElement.notifyAnimationStart();\n\
\n\
if( !this.bAnimationStarted )\n\
this.bAnimationStarted = true;\n\
};\n\
\n\
GenericAnimation.prototype.end = function()\n\
{\n\
if( this.bAnimationStarted )\n\
{\n\
this.bAnimationStarted = false;\n\
this.aAnimatableElement.notifyAnimationEnd();\n\
}\n\
};\n\
\n\
GenericAnimation.prototype.perform = function( aValue )\n\
{\n\
if( this.aSetModifier )\n\
aValue = this.aSetModifier( aValue );\n\
\n\
this.aSetValueFunc( aValue );\n\
};\n\
\n\
GenericAnimation.prototype.getUnderlyingValue = function()\n\
{\n\
var aValue = this.aGetValueFunc();\n\
if( this.aGetModifier )\n\
aValue = this.aGetModifier( aValue );\n\
return aValue;\n\
};\n\
\n\
\n\
function TupleAnimation( aGetValueFunc, aSetValueFunc, aDefaultValue, aReferenceSize )\n\
{\n\
TupleAnimation.superclass.constructor.call( this, aGetValueFunc, aSetValueFunc );\n\
assert( aDefaultValue && aReferenceSize,\n\
'TupleAnimation constructor: default value functor and/or reference size are not valid' );\n\
\n\
this.aDefaultValue = aDefaultValue;\n\
this.aReferenceSize = aReferenceSize;\n\
}\n\
extend( TupleAnimation, GenericAnimation );\n\
\n\
TupleAnimation.prototype.perform = function( aNormValue )\n\
{\n\
assert(aNormValue.length === this.aReferenceSize.length);\n\
\n\
var aValue = [];\n\
for( var i = 0; i < aNormValue.length; ++i )\n\
{\n\
aValue.push( aNormValue[i] * this.aReferenceSize[i] );\n\
}\n\
\n\
this.aSetValueFunc( aValue );\n\
};\n\
\n\
TupleAnimation.prototype.getUnderlyingValue = function()\n\
{\n\
var aValue = this.aGetValueFunc();\n\
assert(aValue.length === this.aReferenceSize.length);\n\
\n\
var aNormValue = [];\n\
for( var i = 0; i < aValue.length; ++i )\n\
{\n\
aNormValue.push( aValue[i] / this.aReferenceSize[i] );\n\
}\n\
\n\
return aNormValue;\n\
};\n\
\n\
\n\
function HSLAnimationWrapper( aColorAnimation )\n\
{\n\
assert( aColorAnimation,\n\
'HSLAnimationWrapper constructor: invalid color animation delegate' );\n\
\n\
this.aAnimation = aColorAnimation;\n\
}\n\
\n\
\n\
HSLAnimationWrapper.prototype.start = function( aAnimatableElement )\n\
{\n\
this.aAnimation.start( aAnimatableElement );\n\
};\n\
\n\
HSLAnimationWrapper.prototype.end = function()\n\
{\n\
this.aAnimation.end();\n\
};\n\
HSLAnimationWrapper.prototype.perform = function( aHSLValue )\n\
{\n\
this.aAnimation.perform( aHSLValue.convertToRGB() );\n\
};\n\
\n\
HSLAnimationWrapper.prototype.getUnderlyingValue = function()\n\
{\n\
return this.aAnimation.getUnderlyingValue().convertToHSL();\n\
};\n\
\n\
\n\
function SlideChangeBase(aLeavingSlide, aEnteringSlide)\n\
{\n\
this.aLeavingSlide = aLeavingSlide;\n\
this.aEnteringSlide = aEnteringSlide;\n\
this.bIsFinished = false;\n\
}\n\
\n\
SlideChangeBase.prototype.start = function()\n\
{\n\
};\n\
\n\
SlideChangeBase.prototype.end = function()\n\
{\n\
if( this.bIsFinished )\n\
return;\n\
\n\
this.aLeavingSlide.hide();\n\
this.aEnteringSlide.reset();\n\
this.aLeavingSlide.reset();\n\
\n\
this.bIsFinished = true;\n\
};\n\
\n\
SlideChangeBase.prototype.perform = function( nValue )\n\
{\n\
if( this.bIsFinished ) return false;\n\
\n\
if( this.aLeavingSlide )\n\
this.performOut( nValue );\n\
\n\
if( this.aEnteringSlide )\n\
this.performIn( nValue );\n\
\n\
return true;\n\
};\n\
\n\
SlideChangeBase.prototype.getUnderlyingValue = function()\n\
{\n\
return 0.0;\n\
};\n\
\n\
SlideChangeBase.prototype.performIn = function( )\n\
{\n\
log( 'SlideChangeBase.performIn: abstract method called' );\n\
};\n\
\n\
SlideChangeBase.prototype.performOut = function( )\n\
{\n\
log( 'SlideChangeBase.performOut: abstract method called' );\n\
";

static const char aSVGScript70[] =
"\
};\n\
\n\
\n\
function FadingSlideChange( aLeavingSlide, aEnteringSlide )\n\
{\n\
FadingSlideChange.superclass.constructor.call( this, aLeavingSlide, aEnteringSlide );\n\
this.bFirstRun = true;\n\
}\n\
extend( FadingSlideChange, SlideChangeBase );\n\
\n\
FadingSlideChange.prototype.start = function()\n\
{\n\
FadingSlideChange.superclass.start.call( this );\n\
this.aEnteringSlide.notifyUsedAttribute( 'opacity' );\n\
this.aLeavingSlide.notifyUsedAttribute( 'opacity' );\n\
this.aEnteringSlide.setOpacity( 0.0 );\n\
this.aEnteringSlide.show();\n\
};\n\
\n\
FadingSlideChange.prototype.performIn = function( nT )\n\
{\n\
this.aEnteringSlide.setOpacity( nT );\n\
};\n\
\n\
FadingSlideChange.prototype.performOut = function( nT )\n\
{\n\
\n\
this.aLeavingSlide.setOpacity( 1 - nT );\n\
};\n\
\n\
\n\
function FadingOverColorSlideChange( aLeavingSlide, aEnteringSlide, sFadeColor )\n\
{\n\
FadingSlideChange.superclass.constructor.call( this, aLeavingSlide, aEnteringSlide );\n\
this.sFadeColor = sFadeColor;\n\
if( !this.sFadeColor )\n\
{\n\
log( 'FadingOverColorSlideChange: sFadeColor not valid.' );\n\
this.sFadeColor = '#000000';\n\
}\n\
this.aColorPlaneElement = this.createColorPlaneElement();\n\
}\n\
extend( FadingOverColorSlideChange, SlideChangeBase );\n\
\n\
FadingOverColorSlideChange.prototype.start = function()\n\
{\n\
FadingOverColorSlideChange.superclass.start.call( this );\n\
this.aEnteringSlide.notifyUsedAttribute( 'opacity' );\n\
this.aLeavingSlide.notifyUsedAttribute( 'opacity' );\n\
this.aLeavingSlide.insertBefore( this.aColorPlaneElement );\n\
this.aEnteringSlide.setOpacity( 0.0 );\n\
this.aEnteringSlide.show();\n\
};\n\
\n\
FadingOverColorSlideChange.prototype.end = function()\n\
{\n\
FadingOverColorSlideChange.superclass.end.call( this );\n\
this.aLeavingSlide.removeElement( this.aColorPlaneElement );\n\
};\n\
\n\
FadingOverColorSlideChange.prototype.performIn = function( nT )\n\
{\n\
this.aEnteringSlide.setOpacity( (nT > 0.55) ? 2.0*(nT-0.55) : 0.0 );\n\
};\n\
\n\
FadingOverColorSlideChange.prototype.performOut = function( nT )\n\
{\n\
this.aLeavingSlide.setOpacity( (nT > 0.45) ? 0.0 : 2.0*(0.45-nT) );\n\
};\n\
\n\
FadingOverColorSlideChange.prototype.createColorPlaneElement = function()\n\
{\n\
var aColorPlaneElement = document.createElementNS( NSS['svg'], 'rect' );\n\
aColorPlaneElement.setAttribute( 'width', String( this.aLeavingSlide.getWidth() ) );\n\
aColorPlaneElement.setAttribute( 'height', String( this.aLeavingSlide.getHeight() ) );\n\
aColorPlaneElement.setAttribute( 'fill', this.sFadeColor );\n\
return aColorPlaneElement;\n\
};\n\
\n\
\n\
function MovingSlideChange( aLeavingSlide, aEnteringSlide,\n\
aLeavingDirection, aEnteringDirection )\n\
{\n\
MovingSlideChange.superclass.constructor.call( this, aLeavingSlide, aEnteringSlide );\n\
this.aLeavingDirection = aLeavingDirection;\n\
this.aEnteringDirection = aEnteringDirection;\n\
}\n\
extend( MovingSlideChange, SlideChangeBase );\n\
\n\
MovingSlideChange.prototype.start = function()\n\
{\n\
MovingSlideChange.superclass.start.call( this );\n\
this.aEnteringSlide.notifyUsedAttribute( 'transform' );\n\
this.aLeavingSlide.notifyUsedAttribute( 'transform' );\n\
this.performIn( 0 );\n\
this.aEnteringSlide.show();\n\
};\n\
\n\
MovingSlideChange.prototype.performIn = function( nT )\n\
{\n\
var nS = nT - 1;\n\
var dx = nS * this.aEnteringDirection.x * this.aEnteringSlide.getWidth();\n\
var dy = nS * this.aEnteringDirection.y * this.aEnteringSlide.getHeight();\n\
this.aEnteringSlide.translate( dx, dy );\n\
};\n\
\n\
MovingSlideChange.prototype.performOut = function( nT )\n\
{\n\
var dx = nT * this.aLeavingDirection.x * this.aLeavingSlide.getWidth();\n\
var dy = nT * this.aLeavingDirection.y * this.aLeavingSlide.getHeight();\n\
this.aLeavingSlide.translate( dx, dy );\n\
};\n\
\n\
\n\
function ClippedSlideChange( aLeavingSlide, aEnteringSlide, aParametricPolyPolygon,\n\
aTransitionInfo, bIsDirectionForward )\n\
{\n\
ClippedSlideChange.superclass.constructor.call( this, aLeavingSlide, aEnteringSlide );\n\
\n\
var bIsModeIn = true;\n\
this.aClippingFunctor= new ClippingFunctor( aParametricPolyPolygon, aTransitionInfo,\n\
bIsDirectionForward, bIsModeIn );\n\
}\n\
extend( ClippedSlideChange, SlideChangeBase );\n\
\n\
ClippedSlideChange.prototype.start = function()\n\
{\n\
ClippedSlideChange.superclass.start.call( this );\n\
this.aEnteringSlide.notifyUsedAttribute( 'clip-path' );\n\
this.performIn( 0 );\n\
this.aEnteringSlide.show();\n\
};\n\
\n\
ClippedSlideChange.prototype.performIn = function( nT )\n\
{\n\
var nWidth = this.aEnteringSlide.getWidth();\n\
var nHeight = this.aEnteringSlide.getHeight();\n\
var aPolyPolygonElement = this.aClippingFunctor.perform( nT, nWidth, nHeight );\n\
this.aEnteringSlide.setClipPath( aPolyPolygonElement );\n\
};\n\
\n\
ClippedSlideChange.prototype.performOut = function( )\n\
{\n\
};\n\
\n\
\n\
function ClippingFunctor( aParametricPolyPolygon, aTransitionInfo,\n\
bIsDirectionForward, bIsModeIn)\n\
{\n\
this.aParametricPolyPolygon = aParametricPolyPolygon;\n\
";

static const char aSVGScript71[] =
"\
this.aStaticTransformation = null;\n\
this.bForwardParameterSweep = true;\n\
this.bSubtractPolygon = false;\n\
this.bScaleIsotropically = aTransitionInfo.scaleIsotropically;\n\
this.bFlip = false;\n\
\n\
assert( this.aParametricPolyPolygon,\n\
'ClippingFunctor: parametric polygon is not valid' );\n\
\n\
if( aTransitionInfo.rotationAngle != 0.0 ||\n\
aTransitionInfo.scaleX != 1.0 ||  aTransitionInfo.scaleY != 1.0 )\n\
{\n\
this.aStaticTransformation = SVGIdentityMatrix.translate( 0.5, 0.5 );\n\
if( aTransitionInfo.scaleX != 1.0 ||  aTransitionInfo.scaleY != 1.0 )\n\
this.aStaticTransformation\n\
= this.aStaticTransformation.scaleNonUniform( aTransitionInfo.scaleX,\n\
aTransitionInfo.scaleY );\n\
if( aTransitionInfo.rotationAngle != 0.0 )\n\
this.aStaticTransformation\n\
= this.aStaticTransformation.rotate( aTransitionInfo.rotationAngle );\n\
this.aStaticTransformation = this.aStaticTransformation.translate( -0.5, -0.5 );\n\
}\n\
else\n\
{\n\
this.aStaticTransformation = document.documentElement.createSVGMatrix();\n\
}\n\
\n\
if( !bIsDirectionForward )\n\
{\n\
var aMatrix = null;\n\
switch( aTransitionInfo.reverseMethod )\n\
{\n\
default:\n\
log( 'ClippingFunctor: unexpected reverse method.' );\n\
break;\n\
case REVERSEMETHOD_IGNORE:\n\
break;\n\
case REVERSEMETHOD_INVERT_SWEEP:\n\
this.bForwardParameterSweep = !this.bForwardParameterSweep;\n\
break;\n\
case REVERSEMETHOD_SUBTRACT_POLYGON:\n\
this.bSubtractPolygon = !this.bSubtractPolygon;\n\
break;\n\
case REVERSEMETHOD_SUBTRACT_AND_INVERT:\n\
this.bForwardParameterSweep = !this.bForwardParameterSweep;\n\
this.bSubtractPolygon = !this.bSubtractPolygon;\n\
break;\n\
case REVERSEMETHOD_ROTATE_180:\n\
aMatrix = document.documentElement.createSVGMatrix();\n\
aMatrix.setToRotationAroundPoint( 0.5, 0.5, 180 );\n\
this.aStaticTransformation = aMatrix.multiply( this.aStaticTransformation );\n\
break;\n\
case REVERSEMETHOD_FLIP_X:\n\
aMatrix = document.documentElement.createSVGMatrix();\n\
aMatrix.a = -1; aMatrix.e = 1.0;\n\
this.aStaticTransformation = aMatrix.multiply( this.aStaticTransformation );\n\
this.bFlip = true;\n\
break;\n\
case REVERSEMETHOD_FLIP_Y:\n\
aMatrix = document.documentElement.createSVGMatrix();\n\
aMatrix.d = -1; aMatrix.f = 1.0;\n\
this.aStaticTransformation = aMatrix.multiply( this.aStaticTransformation );\n\
this.bFlip = true;\n\
break;\n\
}\n\
}\n\
\n\
if( !bIsModeIn )\n\
{\n\
if( aTransitionInfo.outInvertsSweep )\n\
{\n\
this.bForwardParameterSweep = !this.bForwardParameterSweep;\n\
}\n\
else\n\
{\n\
this.bSubtractPolygon = !this.bSubtractPolygon;\n\
}\n\
}\n\
}\n\
\n\
ClippingFunctor.aBoundingPath = document.createElementNS( NSS['svg'], 'path' );\n\
ClippingFunctor.aBoundingPath.setAttribute( 'd', 'M -1 -1 L 2 -1 L 2 2 L -1 2 L -1 -1' );\n\
\n\
ClippingFunctor.prototype.perform = function( nT, nWidth, nHeight )\n\
{\n\
var aClipPoly = this.aParametricPolyPolygon.perform( this.bForwardParameterSweep ? nT : (1 - nT) );\n\
\n\
\n\
if( this.bSubtractPolygon )\n\
{\n\
aClipPoly.changeOrientation();\n\
aClipPoly.prependPath( ClippingFunctor.aBoundingPath );\n\
}\n\
\n\
var aMatrix;\n\
if( this.bScaleIsotropically )\n\
{\n\
var nScaleFactor = Math.max( nWidth, nHeight );\n\
aMatrix = SVGIdentityMatrix.translate( -( nScaleFactor - nWidth ) / 2.0,\n\
-( nScaleFactor - nHeight ) / 2.0 );\n\
aMatrix = aMatrix.scale( nScaleFactor );\n\
aMatrix = aMatrix.multiply( this.aStaticTransformation );\n\
}\n\
else\n\
{\n\
aMatrix = SVGIdentityMatrix.scaleNonUniform( nWidth, nHeight );\n\
aMatrix = aMatrix.multiply( this.aStaticTransformation );\n\
}\n\
\n\
aClipPoly.matrixTransform( aMatrix );\n\
\n\
return aClipPoly;\n\
};\n\
\n\
\n\
function createClipPolyPolygon( nType, nSubtype )\n\
{\n\
switch( nType )\n\
{\n\
default:\n\
log( 'createClipPolyPolygon: unknown transition type: ' + nType );\n\
return null;\n\
case BARWIPE_TRANSITION:\n\
return new BarWipePath( 1 );\n\
case FOURBOXWIPE_TRANSITION:\n\
return new FourBoxWipePath( nSubtype === CORNERSOUT_TRANS_SUBTYPE );\n\
case BOXWIPE_TRANSITION:\n\
return new BoxWipePath( nSubtype == LEFTCENTER_TRANS_SUBTYPE ||\n\
nSubtype == TOPCENTER_TRANS_SUBTYPE ||\n\
nSubtype == RIGHTCENTER_TRANS_SUBTYPE ||\n\
nSubtype == BOTTOMCENTER_TRANS_SUBTYPE );\n\
case ELLIPSEWIPE_TRANSITION:\n\
return new EllipseWipePath( nSubtype );\n\
case FANWIPE_TRANSITION:\n\
return new FanWipePath(nSubtype == CENTERTOP_TRANS_SUBTYPE ||\n\
nSubtype == CENTERRIGHT_TRANS_SUBTYPE, true, false);\n\
case PINWHEELWIPE_TRANSITION:\n\
var nBlades;\n\
switch( nSubtype )\n\
{\n\
case ONEBLADE_TRANS_SUBTYPE:\n\
nBlades = 1;\n\
break;\n\
case DEFAULT_TRANS_SUBTYPE:\n\
case TWOBLADEVERTICAL_TRANS_SUBTYPE:\n\
nBlades = 2;\n\
break;\n\
case TWOBLADEHORIZONTAL_TRANS_SUBTYPE:\n\
nBlades = 2;\n\
break;\n\
";

static const char aSVGScript72[] =
"\
case THREEBLADE_TRANS_SUBTYPE:\n\
nBlades = 3;\n\
break;\n\
case FOURBLADE_TRANS_SUBTYPE:\n\
nBlades = 4;\n\
break;\n\
case EIGHTBLADE_TRANS_SUBTYPE:\n\
nBlades = 8;\n\
break;\n\
default:\n\
log( 'createClipPolyPolygon: unknown subtype: ' + nSubtype );\n\
return null;\n\
}\n\
return new PinWheelWipePath( nBlades );\n\
case CLOCKWIPE_TRANSITION:\n\
return new ClockWipePath();\n\
case RANDOMBARWIPE_TRANSITION:\n\
return new RandomWipePath( 128, true /* bars */ );\n\
case CHECKERBOARDWIPE_TRANSITION:\n\
return new CheckerBoardWipePath( 10 );\n\
case ZIGZAGWIPE_TRANSITION:\n\
return new ZigZagWipePath( 5 );\n\
case BARNZIGZAGWIPE_TRANSITION:\n\
return new BarnZigZagWipePath( 5 );\n\
case IRISWIPE_TRANSITION:\n\
switch(nSubtype)\n\
{\n\
case RECTANGLE_TRANS_SUBTYPE:\n\
return new IrisWipePath(0);\n\
case DIAMOND_TRANS_SUBTYPE:\n\
return new IrisWipePath(1);\n\
default:\n\
log( 'createClipPolyPolygon: unknown subtype: ' + nSubtype );\n\
return null;\n\
}\n\
case BARNDOORWIPE_TRANSITION:\n\
return new BarnDoorWipePath(false);\n\
case SINGLESWEEPWIPE_TRANSITION:\n\
return new SweepWipePath(\n\
nSubtype == CLOCKWISETOP_TRANS_SUBTYPE ||\n\
nSubtype == CLOCKWISERIGHT_TRANS_SUBTYPE ||\n\
nSubtype == CLOCKWISEBOTTOM_TRANS_SUBTYPE ||\n\
nSubtype == CLOCKWISELEFT_TRANS_SUBTYPE,\n\
true,\n\
false,\n\
nSubtype == COUNTERCLOCKWISEBOTTOMLEFT_TRANS_SUBTYPE ||\n\
nSubtype == COUNTERCLOCKWISETOPRIGHT_TRANS_SUBTYPE );\n\
case WATERFALLWIPE_TRANSITION:\n\
return new WaterfallWipePath(128, // flipOnYAxis\n\
nSubtype == VERTICALRIGHT_TRANS_SUBTYPE ||\n\
nSubtype == HORIZONTALLEFT_TRANS_SUBTYPE);\n\
case MISCDIAGONALWIPE_TRANSITION:\n\
switch(nSubtype) {\n\
case DOUBLEBARNDOOR_TRANS_SUBTYPE:\n\
return new BarnDoorWipePath(true /* Doubled */);\n\
case DOUBLEDIAMOND_TRANS_SUBTYPE:\n\
return new DoubleDiamondWipePath();\n\
default:\n\
log( 'createClipPolyPolygon: unhandled subtype: ' + nSubtype );\n\
return null;\n\
}\n\
case DISSOLVE_TRANSITION:\n\
return new RandomWipePath( 16 * 16, false /* dissolve */ );\n\
case VEEWIPE_TRANSITION:\n\
return new VeeWipePath();\n\
case SNAKEWIPE_TRANSITION:\n\
return new SnakeWipePath( 8 * 8, // diagonal\n\
nSubtype == TOPLEFTDIAGONAL_TRANS_SUBTYPE     ||\n\
nSubtype == TOPRIGHTDIAGONAL_TRANS_SUBTYPE    ||\n\
nSubtype == BOTTOMRIGHTDIAGONAL_TRANS_SUBTYPE ||\n\
nSubtype == BOTTOMLEFTDIAGONAL_TRANS_SUBTYPE   ,\n\
nSubtype == TOPLEFTVERTICAL_TRANS_SUBTYPE     ||\n\
nSubtype == TOPRIGHTDIAGONAL_TRANS_SUBTYPE    ||\n\
nSubtype == BOTTOMLEFTDIAGONAL_TRANS_SUBTYPE\n\
);\n\
case PARALLELSNAKESWIPE_TRANSITION:\n\
return new ParallelSnakesWipePath(\n\
8 * 8, // elements\n\
nSubtype == DIAGONALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE ||\n\
nSubtype == DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE,\n\
nSubtype == VERTICALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE ||\n\
nSubtype == HORIZONTALTOPLEFTOPPOSITE_TRANS_SUBTYPE  ||\n\
nSubtype == DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE,\n\
nSubtype == VERTICALTOPLEFTOPPOSITE_TRANS_SUBTYPE    ||\n\
nSubtype == VERTICALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE ||\n\
nSubtype == HORIZONTALTOPLEFTOPPOSITE_TRANS_SUBTYPE  ||\n\
nSubtype == HORIZONTALTOPRIGHTOPPOSITE_TRANS_SUBTYPE ||\n\
nSubtype == DIAGONALBOTTOMLEFTOPPOSITE_TRANS_SUBTYPE ||\n\
nSubtype == DIAGONALTOPLEFTOPPOSITE_TRANS_SUBTYPE\n\
);\n\
\n\
case SPIRALWIPE_TRANSITION:\n\
return new SpiralWipePath(\n\
8 * 8, // elements\n\
nSubtype == TOPLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE     ||\n\
nSubtype == TOPRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE    ||\n\
nSubtype == BOTTOMRIGHTCOUNTERCLOCKWISE_TRANS_SUBTYPE ||\n\
nSubtype == BOTTOMLEFTCOUNTERCLOCKWISE_TRANS_SUBTYPE );\n\
\n\
case BOXSNAKESWIPE_TRANSITION:\n\
return new BoxSnakesWipePath(\n\
8 * 8,\n\
nSubtype == FOURBOXVERTICAL_TRANS_SUBTYPE ||\n\
nSubtype == FOURBOXHORIZONTAL_TRANS_SUBTYPE );\n\
}\n\
}\n\
\n\
\n\
function createUnitSquarePath()\n\
{\n\
var aPath = document.createElementNS( NSS['svg'], 'path' );\n\
var sD = 'M 0 0 L 1 0 L 1 1 L 0 1 L 0 0';\n\
aPath.setAttribute( 'd', sD );\n\
return aPath;\n\
}\n\
\n\
function createEmptyPath()\n\
{\n\
var aPath = document.createElementNS( NSS['svg'], 'path' );\n\
var sD = 'M 0 0 L 0 0';\n\
aPath.setAttribute( 'd', sD );\n\
return aPath;\n\
}\n\
\n\
function pruneScaleValue( nVal )\n\
{\n\
if( nVal < 0.0 )\n\
return (nVal < -0.00001 ? nVal : -0.00001);\n\
else\n\
return (nVal > 0.00001 ? nVal : 0.00001);\n\
}\n\
\n\
\n\
function BarWipePath( nBars /* nBars > 1: blinds effect */ )\n\
{\n\
this.nBars = nBars;\n\
if( this.nBars === undefined || this.nBars < 1 )\n\
this.nBars = 1;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
BarWipePath.prototype.perform = function( nT )\n\
{\n\
\n\
var aMatrix = SVGIdentityMatrix.scaleNonUniform( pruneScaleValue( nT / this.nBars ), 1.0 );\n\
\n\
var aPolyPath = this.aBasePath.cloneNode( true );\n\
aPolyPath.matrixTransform( aMatrix );\n\
\n\
if( this.nBars > 1 )\n\
";

static const char aSVGScript73[] =
"\
{\n\
var i;\n\
var aTransform;\n\
var aPath;\n\
for( i = this.nBars - 1; i > 0; --i )\n\
{\n\
aTransform = SVGIdentityMatrix.translate( i / this.nBars, 0.0 );\n\
aTransform = aTransform.multiply( aMatrix );\n\
aPath = this.aBasePath.cloneNode( true );\n\
aPath.matrixTransform( aTransform );\n\
aPolyPath.appendPath( aPath );\n\
}\n\
}\n\
return aPolyPath;\n\
};\n\
\n\
\n\
function BoxWipePath(bIsTopCentered) {\n\
this.bIsTopCentered = bIsTopCentered;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
BoxWipePath.prototype.perform = function( nT ) {\n\
var d = pruneScaleValue(nT);\n\
var aTransform = SVGIdentityMatrix;\n\
if(this.bIsTopCentered) {\n\
aTransform = aTransform.translate(-0.5, 0.0).scale(d, d).translate(0.5, 0.0);\n\
}\n\
else {\n\
aTransform = aTransform.scale(d, d);\n\
}\n\
var aPath = this.aBasePath.cloneNode(true);\n\
aPath.matrixTransform(aTransform);\n\
return aPath;\n\
}\n\
\n\
function SweepWipePath(bCenter, bSingle, bOppositeVertical, bFlipOnYAxis) {\n\
this.bCenter = bCenter;\n\
this.bSingle = bSingle;\n\
this.bOppositeVertical = bOppositeVertical;\n\
this.bFlipOnYAxis = bFlipOnYAxis;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
SweepWipePath.prototype.perform = function( nT ) {\n\
nT /= 2.0;\n\
if(!this.bCenter)\n\
nT /= 2.0;\n\
if(!this.bSingle && !this.bOppositeVertical)\n\
nT /= 2.0;\n\
\n\
var poly = PinWheelWipePath.calcCenteredClock( nT + 0.25, 1.0 );\n\
var aTransform;\n\
\n\
if(this.bCenter) {\n\
aTransform = SVGIdentityMatrix.translate(0.5, 0.0);\n\
poly.matrixTransform(aTransform);\n\
}\n\
var res = poly;\n\
\n\
if(!this.bSingle) {\n\
if(this.bOppositeVertical) {\n\
aTransform = SVGIdentityMatrix.scale(1.0, -1.0);\n\
aTransform.translate(0.0, 1.0);\n\
poly.matrixTransform(aTransform);\n\
poly.changeOrientation();\n\
}\n\
else {\n\
aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform.rotate(Math.PI);\n\
aTransform.translate(0.5, 0.5);\n\
poly.matrixTransform(aTransform);\n\
}\n\
res.appendPath(poly);\n\
}\n\
return this.bFlipOnYAxis ? flipOnYAxis(res) : res;\n\
}\n\
\n\
function FourBoxWipePath( bCornersOut )\n\
{\n\
this.bCornersOut = bCornersOut;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
FourBoxWipePath.prototype.perform = function( nT )\n\
{\n\
var aMatrix;\n\
var d = pruneScaleValue( nT / 2.0 );\n\
\n\
if( this.bCornersOut )\n\
{\n\
aMatrix = SVGIdentityMatrix.translate( -0.25, -0.25 ).scale( d ).translate( -0.5, -0.5 );\n\
}\n\
else\n\
{\n\
aMatrix = SVGIdentityMatrix.translate( -0.5, -0.5 ).scale( d );\n\
}\n\
\n\
\n\
var aTransform = aMatrix;\n\
var aSquare = this.aBasePath.cloneNode( true );\n\
aSquare.matrixTransform( aTransform );\n\
var aPolyPath = aSquare;\n\
aMatrix = SVGIdentityMatrix.flipY();\n\
aTransform = aMatrix.multiply( aTransform );\n\
aSquare = this.aBasePath.cloneNode( true );\n\
aSquare.matrixTransform( aTransform );\n\
aSquare.changeOrientation();\n\
aPolyPath.appendPath( aSquare );\n\
aMatrix = SVGIdentityMatrix.flipX();\n\
aTransform = aMatrix.multiply( aTransform );\n\
aSquare = this.aBasePath.cloneNode( true );\n\
aSquare.matrixTransform( aTransform );\n\
aPolyPath.appendPath( aSquare );\n\
aMatrix = SVGIdentityMatrix.flipY();\n\
aTransform = aMatrix.multiply( aTransform );\n\
aSquare = this.aBasePath.cloneNode( true );\n\
aSquare.matrixTransform( aTransform );\n\
aSquare.changeOrientation();\n\
aPolyPath.appendPath( aSquare );\n\
\n\
aMatrix = SVGIdentityMatrix.translate( 0.5, 0.5 );\n\
aMatrix = aMatrix.scale( 1.1 );\n\
aPolyPath.matrixTransform( aMatrix );\n\
\n\
return aPolyPath;\n\
};\n\
\n\
\n\
function EllipseWipePath( eSubtype )\n\
{\n\
this.eSubtype = eSubtype;\n\
\n\
var sPathData = 'M 0.5 -0.207107 ' +\n\
'C 0.687536 -0.207107 0.867392 -0.132608 1 0 ' +\n\
'C 1.13261 0.132608 1.20711 0.312464 1.20711 0.5 ' +\n\
'C 1.20711 0.687536 1.13261 0.867392 1 1 ' +\n\
'C 0.867392 1.13261 0.687536 1.20711 0.5 1.20711 ' +\n\
'C 0.312464 1.20711 0.132608 1.13261 0 1 ' +\n\
'C -0.132608 0.867392 -0.207107 0.687536 -0.207107 0.5 ' +\n\
'C -0.207107 0.312464 -0.132608 0.132608 0 0 ' +\n\
'C 0.132608 -0.132608 0.312464 -0.207107 0.5 -0.207107';\n\
\n\
this.aBasePath = document.createElementNS( NSS['svg'], 'path' );\n\
this.aBasePath.setAttribute( 'd', sPathData );\n\
}\n\
\n\
EllipseWipePath.prototype.perform = function( nT )\n\
{\n\
\n\
";

static const char aSVGScript74[] =
"\
var aTransform = SVGIdentityMatrix.translate( 0.5, 0.5 ).scale( nT ).translate( -0.5, -0.5 );\n\
var aEllipse = this.aBasePath.cloneNode( true );\n\
aEllipse.matrixTransform( aTransform );\n\
\n\
return aEllipse;\n\
};\n\
\n\
function FanWipePath(bIsCenter, bIsSingle, bIsFanIn) {\n\
this.bCenter = bIsCenter;\n\
this.bSingle = bIsSingle;\n\
this.bFanIn  = bIsFanIn;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
FanWipePath.prototype.perform = function( nT ) {\n\
var res = this.aBasePath.cloneNode(true);\n\
var poly = PinWheelWipePath.calcCenteredClock(\n\
nT / ((this.bCenter && this.bSingle) ? 2.0 : 4.0), 1.0);\n\
res.appendPath(poly);\n\
var aTransform = SVGIdentityMatrix.flipY();\n\
aTransform = aTransform.scaleNonUniform(-1.0, 1.0);\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
\n\
if(this.bCenter) {\n\
aTransform = SVGIdentityMatrix.scaleNonUniform(0.5, 0.5).translate(0.5, 0.5);\n\
res.matrixTransform(aTransform);\n\
\n\
if(!this.bSingle)\n\
res.appendPath(flipOnXAxis(res));\n\
}\n\
else {\n\
aTransform = SVGIdentityMatrix.scaleNonUniform(0.5, 1.0).translate(0.5, 1.0);\n\
res.matrixTransform(aTransform);\n\
}\n\
return res;\n\
}\n\
\n\
function ClockWipePath() { }\n\
\n\
ClockWipePath.prototype.perform = function( nT ) {\n\
const aTransform = SVGIdentityMatrix.scaleNonUniform(0.5, 0.5).translate(0.5, 0.5);\n\
var aPolyPath = PinWheelWipePath.calcCenteredClock(nT, 1.0);\n\
aPolyPath.matrixTransform( aTransform );\n\
\n\
return aPolyPath;\n\
}\n\
\n\
function PinWheelWipePath( nBlades )\n\
{\n\
this.nBlades = nBlades;\n\
if( !this.nBlades || this.nBlades < 1 )\n\
this.nBlades = 1;\n\
}\n\
\n\
PinWheelWipePath.calcCenteredClock = function( nT, nE )\n\
{\n\
var nMAX_EDGE = 2;\n\
\n\
var aTransform = SVGIdentityMatrix.rotate( nT * 360 );\n\
\n\
var aPoint = document.documentElement.createSVGPoint();\n\
aPoint.y = -nMAX_EDGE;\n\
aPoint = aPoint.matrixTransform( aTransform );\n\
\n\
var sPathData = 'M ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
if( nT >= 0.875 )\n\
sPathData += 'L ' + '-' + nE + ' -' + nE + ' ';\n\
if( nT >= 0.625 )\n\
sPathData += 'L ' + '-' + nE + ' ' + nE + ' ';\n\
if( nT >= 0.375 )\n\
sPathData += 'L ' + nE + ' ' + nE + ' ';\n\
if( nT >= 0.125 )\n\
sPathData += 'L ' + nE + ' -' + nE + ' ';\n\
\n\
sPathData += 'L 0 -' + nE + ' ';\n\
sPathData += 'L 0 0 ';\n\
sPathData += 'L '  + aPoint.x + ' ' + aPoint.y;\n\
\n\
var aPath = document.createElementNS( NSS['svg'], 'path' );\n\
aPath.setAttribute( 'd', sPathData );\n\
return aPath;\n\
};\n\
\n\
PinWheelWipePath.prototype.perform = function( nT )\n\
{\n\
var aBasePath = PinWheelWipePath.calcCenteredClock( nT / this.nBlades,\n\
2.0 /* max edge when rotating */  );\n\
\n\
var aPolyPath = aBasePath.cloneNode( true );\n\
var aPath;\n\
var aRotation;\n\
var i;\n\
for( i = this.nBlades - 1; i > 0; --i )\n\
{\n\
aRotation = SVGIdentityMatrix.rotate( (i * 360) / this.nBlades );\n\
aPath = aBasePath.cloneNode( true );\n\
aPath.matrixTransform( aRotation );\n\
aPolyPath.appendPath( aPath );\n\
}\n\
\n\
var aTransform = SVGIdentityMatrix.translate( 0.5, 0.5 ).scale( 0.5 );\n\
aPolyPath.matrixTransform( aTransform );\n\
\n\
return aPolyPath;\n\
};\n\
\n\
function BarnDoorWipePath(doubled) {\n\
this.aBasePath = createUnitSquarePath();\n\
this.doubled   = doubled;\n\
}\n\
\n\
BarnDoorWipePath.prototype.perform = function( nT ) {\n\
if(this.doubled)\n\
nT /= 2.0;\n\
var aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform = aTransform.scaleNonUniform(pruneScaleValue(nT), 1.0).translate(0.5, 0.5);\n\
var aPath = this.aBasePath.cloneNode(true);\n\
aPath.matrixTransform(aTransform);\n\
var res = aPath;\n\
\n\
if(this.doubled) {\n\
aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform = aTransform.rotate(Math.PI / 2).translate(0.5, 0.5);\n\
aPath.matrixTransform(aTransform);\n\
res.appendPath(aPath);\n\
}\n\
return res;\n\
}\n\
\n\
function WaterfallWipePath(nElements, bFlipOnYAxis) {\n\
this.bFlipOnYAxis = bFlipOnYAxis;\n\
\n\
var sqrtElements = Math.floor(Math.sqrt(nElements));\n\
var elementEdge = 1.0/sqrtElements;\n\
\n\
var aPath = 'M '+ 0.0 + ' ' + -1.0 + ' ';\n\
for(var pos = sqrtElements; pos--; ) {\n\
var xPos = sqrtElements - pos - 1;\n\
var yPos = pruneScaleValue( ((pos+1) * elementEdge) - 1.0);\n\
\n\
aPath += 'L ' + pruneScaleValue(xPos * elementEdge) + ' ' + yPos + ' ';\n\
aPath += 'L ' + pruneScaleValue((xPos+1)*elementEdge) + ' ' + yPos + ' ';\n\
}\n\
aPath += 'L ' + 1.0 + ' ' + -1.0 + ' ';\n\
aPath += 'L ' + 0.0 + ' ' + -1.0 + ' ';\n\
this.aBasePath = document.createElementNS( NSS['svg'], 'path');\n\
this.aBasePath.setAttribute('d', aPath);\n\
}\n\
\n\
";

static const char aSVGScript75[] =
"\
WaterfallWipePath.prototype.perform = function( nT ) {\n\
var poly = this.aBasePath.cloneNode(true);\n\
var aTransform = SVGIdentityMatrix.translate(0.0, pruneScaleValue(2.0 * nT));\n\
poly.matrixTransform(aTransform);\n\
var aHead = 'M ' + 0.0 + ' ' + -1.0 + ' ';\n\
var aHeadPath= document.createElementNS( NSS['svg'], 'path');\n\
aHeadPath.setAttribute('d', aHead);\n\
\n\
var aTail = 'M ' + 1.0 + ' ' + -1.0 + ' ';\n\
var aTailPath = document.createElementNS( NSS['svg'], 'path');\n\
aTailPath.setAttribute('d', aTail);\n\
\n\
poly.prependPath(aHeadPath);\n\
poly.appendPath(aTailPath);\n\
\n\
return this.bFlipOnYAxis ? flipOnYAxis(poly) : poly;\n\
}\n\
\n\
function DoubleDiamondWipePath() { }\n\
\n\
DoubleDiamondWipePath.prototype.perform = function( nT ) {\n\
var a = pruneScaleValue(0.25 + (nT * 0.75));\n\
var aPath = 'M ' + (0.5 + a) + ' ' + 0.5 + ' ';\n\
aPath += 'L ' + 0.5 + ' ' + (0.5 - a) + ' ';\n\
aPath += 'L ' + (0.5 - a) + ' ' + 0.5 + ' ';\n\
aPath += 'L ' + 0.5 + ' ' + (0.5 + a) + ' ';\n\
aPath += 'L ' + (0.5 + a) + ' ' + 0.5 + ' ';\n\
var poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
var res = poly.cloneNode(true);\n\
\n\
var b = pruneScaleValue( (1.0 - nT) * 0.25);\n\
aPath = 'M ' + (0.5 + b) + ' ' + 0.5 + ' ';\n\
aPath += 'L ' + 0.5 + ' ' + (0.5 + b) + ' ';\n\
aPath += 'L ' + (0.5 - b) + ' ' + 0.5 + ' ';\n\
aPath += 'L ' + 0.5 + ' ' + (0.5 - b) + ' ';\n\
aPath += 'L ' + (0.5 + b) + ' ' + 0.5 + ' ';\n\
poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
res.appendPath(poly);\n\
\n\
return res;\n\
}\n\
\n\
function IrisWipePath(unitRect) {\n\
this.unitRect = unitRect;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
\n\
IrisWipePath.prototype.perform = function( nT ) {\n\
var d = pruneScaleValue(nT);\n\
var aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform = aTransform.multiply(SVGIdentityMatrix.scaleNonUniform(d, d).translate(0.5, 0.5));\n\
var aPath = this.aBasePath.cloneNode(true);\n\
aPath.matrixTransform(aTransform);\n\
return aPath;\n\
}\n\
\n\
function ZigZagWipePath(nZigs) {\n\
this.zigEdge = 1.0/nZigs;\n\
const d = this.zigEdge;\n\
const d2 = (d / 2.0);\n\
this.aBasePath = 'M ' + (-1.0 - d) + ' ' + -d + ' ';\n\
this.aBasePath += 'L ' + (-1.0 - d) + ' ' + (1.0 + d) + ' ';\n\
this.aBasePath += 'L ' + -d + ' ' + (1.0 + d) + ' ';\n\
\n\
for(var pos = (nZigs + 2); pos--; ) {\n\
this.aBasePath += 'L ' + 0.0 + ' ' + ((pos - 1) * d + d2) + ' ';\n\
this.aBasePath += 'L ' + -d + ' ' + (pos - 1) * d + ' ';\n\
}\n\
this.aBasePath += 'L ' + (-1.0 - d) + ' ' + -d + ' ';\n\
}\n\
\n\
ZigZagWipePath.prototype.perform = function( nT ) {\n\
var res = document.createElementNS( NSS['svg'], 'path');\n\
res.setAttribute('d', this.aBasePath);\n\
res.matrixTransform(SVGIdentityMatrix.translate((1.0 + this.zigEdge) * nT, 0.0));\n\
return res;\n\
}\n\
\n\
function BarnZigZagWipePath( nZigs ) { ZigZagWipePath.call(this, nZigs); }\n\
\n\
BarnZigZagWipePath.prototype = Object.create(ZigZagWipePath);\n\
\n\
BarnZigZagWipePath.prototype.perform = function( nT ) {\n\
var res = createEmptyPath();\n\
var poly = document.createElementNS( NSS['svg'], 'path');\n\
var aTransform = SVGIdentityMatrix.translate(\n\
((1.0 + this.zigEdge) * (1.0 - nT)) / 2.0, 0.0);\n\
poly.setAttribute('d', this.aBasePath);\n\
poly.changeOrientation();\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
\n\
aTransform = SVGIdentityMatrix.scale(-1.0, 1.0);\n\
aTransform.translate(1.0, this.zigEdge / 2.0);\n\
poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', this.aBasePath);\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
\n\
return res;\n\
}\n\
\n\
function CheckerBoardWipePath( unitsPerEdge )\n\
{\n\
this.unitsPerEdge = unitsPerEdge;\n\
if( this.unitsPerEdge === undefined || this.unitsPerEdge < 1 )\n\
this.unitsPerEdge = 10;\n\
this.aBasePath = createUnitSquarePath();\n\
}\n\
\n\
CheckerBoardWipePath.prototype.perform = function( nT )\n\
{\n\
var d = pruneScaleValue(1.0 / this.unitsPerEdge);\n\
var aMatrix = SVGIdentityMatrix.scaleNonUniform(pruneScaleValue( d*2.0*nT ),\n\
pruneScaleValue( d ) );\n\
\n\
var aPolyPath = null;\n\
var i, j;\n\
var aTransform;\n\
var aPath;\n\
for ( i = this.unitsPerEdge; i--; )\n\
{\n\
aTransform = SVGIdentityMatrix;\n\
\n\
if ((i % 2) == 1) // odd line\n\
aTransform = aTransform.translate( -d, 0.0 );\n\
\n\
aTransform = aTransform.multiply( aMatrix );\n\
\n\
for ( j = (this.unitsPerEdge / 2) + 1; j--;)\n\
{\n\
aPath = this.aBasePath.cloneNode( true );\n\
aPath.matrixTransform( aTransform );\n\
if (aPolyPath == null) aPolyPath = aPath;\n\
else aPolyPath.appendPath( aPath );\n\
aTransform = SVGIdentityMatrix.translate( d*2.0, 0.0 ).multiply( aTransform );\n\
}\n\
\n\
aMatrix = SVGIdentityMatrix.translate( 0.0, d ).multiply( aMatrix ); // next line\n\
}\n\
\n\
return aPolyPath;\n\
};\n\
\n\
\n\
function RandomWipePath( nElements, bRandomBars )\n\
{\n\
";

static const char aSVGScript76[] =
"\
this.nElements = nElements;\n\
this.aBasePath = createUnitSquarePath();\n\
this.aPositionArray = new Array( nElements );\n\
this.aClipPath = createEmptyPath();\n\
this.nAlreadyAppendedElements = 0;\n\
\n\
var fEdgeLength, nPos, aTransform;\n\
\n\
if( bRandomBars ) // random bar wipe\n\
{\n\
fEdgeLength = 1.0 / nElements;\n\
for( nPos = 0; nPos < nElements; ++nPos )\n\
{\n\
this.aPositionArray[nPos] = { x: 0.0, y: pruneScaleValue( nPos * fEdgeLength ) }\n\
}\n\
aTransform = SVGIdentityMatrix.scaleNonUniform( 1.0, pruneScaleValue( fEdgeLength ) );\n\
}\n\
else // dissolve wipe\n\
{\n\
var nSqrtElements = Math.round( Math.sqrt( nElements ) );\n\
fEdgeLength = 1.0 / nSqrtElements;\n\
for( nPos = 0; nPos < nElements; ++nPos )\n\
{\n\
this.aPositionArray[nPos] = {\n\
x: pruneScaleValue( ( nPos % nSqrtElements ) * fEdgeLength ),\n\
y: pruneScaleValue( ( nPos / nSqrtElements ) * fEdgeLength ) }\n\
}\n\
aTransform = SVGIdentityMatrix.scale( pruneScaleValue( fEdgeLength ) );\n\
}\n\
this.aBasePath.matrixTransform( aTransform );\n\
\n\
var nPos1, nPos2;\n\
var tmp;\n\
for( nPos1 = nElements - 1; nPos1 > 0; --nPos1 )\n\
{\n\
nPos2 = getRandomInt( nPos1 + 1 );\n\
tmp = this.aPositionArray[nPos1];\n\
this.aPositionArray[nPos1] = this.aPositionArray[nPos2];\n\
this.aPositionArray[nPos2] = tmp;\n\
}\n\
}\n\
\n\
RandomWipePath.prototype.perform = function( nT )\n\
{\n\
var aPolyPath = createEmptyPath();\n\
var aPoint;\n\
var aPath;\n\
var aTransform;\n\
var nElements = Math.round( nT * this.nElements );\n\
if( nElements === 0 )\n\
{\n\
return aPolyPath;\n\
}\n\
if( this.nAlreadyAppendedElements >= nElements )\n\
{\n\
this.nAlreadyAppendedElements = 0;\n\
this.aClipPath = createEmptyPath();\n\
}\n\
var nPos;\n\
for( nPos = this.nAlreadyAppendedElements; nPos < nElements; ++nPos )\n\
{\n\
aPoint = this.aPositionArray[nPos];\n\
aPath = this.aBasePath.cloneNode( true );\n\
aTransform = SVGIdentityMatrix.translate( aPoint.x, aPoint.y );\n\
aPath.matrixTransform( aTransform );\n\
aPolyPath.appendPath( aPath );\n\
}\n\
\n\
this.nAlreadyAppendedElements = nElements;\n\
this.aClipPath.appendPath( aPolyPath );\n\
\n\
return this.aClipPath.cloneNode( true );\n\
};\n\
\n\
function SnakeWipePath(nElements, bDiagonal, bflipOnYAxis)\n\
{\n\
this.sqrtElements = Math.floor(Math.sqrt(nElements));\n\
this.elementEdge  = (1.0 / this.sqrtElements);\n\
this.diagonal     = bDiagonal;\n\
this.flipOnYAxis  = bflipOnYAxis;\n\
this.aBasePath    = createUnitSquarePath();\n\
}\n\
\n\
SnakeWipePath.prototype.calcSnake = function(t)\n\
{\n\
var aPolyPath = createEmptyPath();\n\
const area   = (t * this.sqrtElements * this.sqrtElements);\n\
const line_  = Math.floor(area) / this.sqrtElements;\n\
const line   = pruneScaleValue(line_ / this.sqrtElements);\n\
const col    = pruneScaleValue((area - (line_ * this.sqrtElements)) / this.sqrtElements);\n\
\n\
if(line != 0) {\n\
let aPath = 'M '+ 0.0 + ' ' + 0.0 + ' ';\n\
aPath += 'L ' + 0.0 + ' ' + line + ' ';\n\
aPath += 'L ' + 1.0 + ' ' + line + ' ';\n\
aPath += 'L ' + 1.0 + ' ' + 0.0 + ' ';\n\
aPath += 'L 0 0 ';\n\
let poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
aPolyPath.appendPath(poly);\n\
}\n\
if(col != 0) {\n\
var offset = 0.0;\n\
if((line_ & 1) == 1) {\n\
offset = (1.0 - col);\n\
}\n\
let aPath = 'M ' + offset + ' ' + line + ' ';\n\
aPath += 'L '+ offset + ' ' + (line + this.elementEdge) + ' ';\n\
aPath += 'L ' + (offset+col) + ' ' + (line + this.elementEdge) + ' ';\n\
aPath += 'L ' + (offset+col) + ' ' + line + ' ';\n\
aPath += 'L ' + offset + ' ' + line + ' ';\n\
let poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
aPolyPath.appendPath(poly);\n\
}\n\
\n\
return aPolyPath;\n\
}\n\
\n\
SnakeWipePath.prototype.calcHalfDiagonalSnake = function(nT, bIn) {\n\
var res = createEmptyPath();\n\
\n\
if(bIn) {\n\
const sqrtArea2 = Math.sqrt(nT * this.sqrtElements * this.sqrtElements);\n\
const edge = pruneScaleValue(sqrtArea2 / this.sqrtElements);\n\
\n\
var aPath, aPoint = document.documentElement.createSVGPoint();\n\
if(edge) {\n\
aPath = 'M ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = edge;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = edge;\n\
aPoint.y = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
const poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
res.appendPath(poly);\n\
}\n\
const a = (Math.SQRT1_2 / this.sqrtElements);\n\
const d = (sqrtArea2 - Math.floor(sqrtArea2));\n\
const len = (nT * Math.SQRT1_2 * d);\n\
const height = pruneScaleValue(Math.SQRT1_2 / this.sqrtElements);\n\
aPath = 'M ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = height;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = len + a;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = 0.0;\n\
";

static const char aSVGScript77[] =
"\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
const poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
let aTransform;\n\
\n\
if((Math.floor(sqrtArea2) & 1) == 1) {\n\
aTransform = SVGIdentityMatrix.rotate((Math.PI)/2 + (Math.PI)/4);\n\
aTransform.translate(edge + this.elementEdge, 0.0);\n\
}\n\
else {\n\
aTransform = SVGIdentityMatrix.translate(-a, 0.0);\n\
aTransform.rotate(-(Math.PI/4));\n\
aTransform.translate(0.0, edge);\n\
}\n\
\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
}\n\
else { //out\n\
const sqrtArea2 = Math.sqrt(nT * this.sqrtElements * this.sqrtElements);\n\
const edge = pruneScaleValue(Math.floor(sqrtArea2)/this.sqrtElements);\n\
\n\
let aPath, aPoint = document.documentElement.createSVGPoint();\n\
if(edge != 0) {\n\
aPoint.y = 1.0;\n\
aPath = 'M ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = edge;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = 1.0;\n\
aPoint.y = edge;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
const poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
res.appendPath(poly);\n\
}\n\
const a = (Math.SQRT1_2 / this.sqrtElements);\n\
const d = (sqrtArea2 - Math.floor(sqrtArea2));\n\
const len = ((1.0 - nT) * Math.SQRT2 * d);\n\
const height = pruneScaleValue(Math.SQRT1_2 / this.sqrtElements);\n\
aPath = 'M ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = height;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = len + a;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.y = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
aPoint.x = 0.0;\n\
aPath += 'L ' + aPoint.x + ' ' + aPoint.y + ' ';\n\
const poly = document.createElementNS( NSS['svg'], 'path');\n\
poly.setAttribute('d', aPath);\n\
let aTransform;\n\
\n\
if((Math.floor(sqrtArea2) & 1) == 1) {\n\
aTransform = SVGIdentityMatrix.translate(0.0, -height);\n\
aTransform.rotate(Math.PI/2 + Math.PI/4);\n\
aTransform.translate(1.0, edge);\n\
}\n\
else {\n\
aTransform = SVGIdentityMatrix.rotate(-(Math.PI/4));\n\
aTransform = aTransform.translate(edge, 1.0);\n\
}\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
}\n\
return res;\n\
}\n\
\n\
SnakeWipePath.prototype.perform = function(nT) {\n\
var res = createEmptyPath();\n\
if(this.diagonal) {\n\
if(nT >= 0.5) {\n\
res.appendPath(this.calcHalfDiagonalSnake(1.0, true));\n\
res.appendPath(this.calcHalfDiagonalSnake(2.0*(nT-0.5), false));\n\
}\n\
else\n\
res.appendPath(this.calcHalfDiagonalSnake(2.0*nT, true));\n\
}\n\
else\n\
res = this.calcSnake(nT);\n\
\n\
return this.flipOnYAxis ? flipOnYAxis(res) : res;\n\
}\n\
\n\
function ParallelSnakesWipePath(nElements, bDiagonal, bFlipOnYAxis, bOpposite) {\n\
SnakeWipePath.call(this, nElements, bDiagonal, bFlipOnYAxis);\n\
this.bOpposite = bOpposite;\n\
}\n\
\n\
ParallelSnakesWipePath.prototype = Object.create(SnakeWipePath);\n\
\n\
ParallelSnakesWipePath.prototype.perform = function( nT ) {\n\
var res = createEmptyPath(), half, aTransform;\n\
if(this.diagonal) {\n\
assert(this.bOpposite);\n\
half = SnakeWipePath.prototype.calcHalfDiagonalSnake.call(this, nT, false);\n\
aTransform = SVGIdentityMatrix.scale(1, -1);\n\
aTransform.translate(-0.5, 0.5);\n\
aTransform.rotate(Math.PI/2);\n\
aTransform.translate(0.5, 0.5);\n\
half.matrixTransform(aTransform);\n\
half.changeOrientation();\n\
res.appendPath(half);\n\
\n\
aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform.rotate(Math.PI);\n\
aTransform.translate(0.5, 0.5);\n\
half.matrixTransform(aTransform);\n\
res.appendPath(half);\n\
}\n\
else {\n\
half = SnakeWipePath.prototype.calcSnake.call(this, nT / 2.0 );\n\
aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
aTransform = aTransform.rotate(Math.PI/2);\n\
aTransform = aTransform.translate(0.5, 0.5);\n\
half.matrixTransform(aTransform);\n\
res.appendPath(flipOnYAxis(half));\n\
res.appendPath(this.bOpposite ? flipOnXAxis(half) : half);\n\
}\n\
\n\
return this.flipOnYAxis ? flipOnYAxis(res) : res;\n\
}\n\
\n\
function SpiralWipePath(nElements, bFlipOnYAxis) {\n\
this.nElements    = nElements;\n\
this.sqrtElements = Math.floor(Math.sqrt(nElements));\n\
this.bFlipOnYAxis = bFlipOnYAxis;\n\
}\n\
\n\
SpiralWipePath.prototype.calcNegSpiral = function( nT ) {\n\
var area  = nT * this.nElements;\n\
var e     = (Math.sqrt(area) / 2.0);\n\
var edge  = Math.floor(e) * 2;\n\
\n\
var aTransform = SVGIdentityMatrix.translate(-0.5, -0.5);\n\
var edge_ = pruneScaleValue(edge / this.sqrtElements);\n\
\n\
aTransform = aTransform.scale(edge_, edge_);\n\
aTransform = aTransform.translate(0.5, 0.5);\n\
var poly = createUnitSquarePath();\n\
poly.matrixTransform(aTransform);\n\
var res = poly.cloneNode(true);\n\
\n\
if(1.0 - nT != 0) {\n\
var edge1 = edge + 1;\n\
";

static const char aSVGScript78[] =
"\
var len   = Math.floor( (e - edge/2) * edge1 * 4);\n\
var w     = Math.PI / 2;\n\
\n\
while(len > 0) {\n\
var alen = Math.min(len, edge1);\n\
len -= alen;\n\
poly = createUnitSquarePath();\n\
aTransform = SVGIdentityMatrix.scale(\n\
pruneScaleValue( alen / this.sqrtElements ),\n\
pruneScaleValue( 1.0 / this.sqrtElements ));\n\
aTransform = aTransform.translate(\n\
- pruneScaleValue( (edge / 2) / this.sqrtElements ),\n\
pruneScaleValue( (edge / 2) / this.sqrtElements ));\n\
aTransform = aTransform.rotate( w );\n\
w -= Math.PI / 2;\n\
aTransform = aTransform.translate(0.5, 0.5);\n\
poly.matrixTransform(aTransform);\n\
res.appendPath(poly);\n\
}\n\
}\n\
\n\
return res;\n\
}\n\
\n\
SpiralWipePath.prototype.perform = function( nT ) {\n\
var res         = createUnitSquarePath();\n\
var innerSpiral = this.calcNegSpiral( 1.0 - nT );\n\
innerSpiral.changeOrientation();\n\
res.appendPath(innerSpiral);\n\
\n\
return this.bFlipOnYAxis ? flipOnYAxis(res) : res;\n\
}\n\
\n\
function BoxSnakesWipePath(nElements, bFourBox) {\n\
SpiralWipePath.call(this, nElements);\n\
this.bFourBox = bFourBox;\n\
}\n\
\n\
BoxSnakesWipePath.prototype = Object.create(SpiralWipePath);\n\
\n\
BoxSnakesWipePath.prototype.perform = function( nT ) {\n\
var res = createUnitSquarePath(), aTransform;\n\
var innerSpiral = SpiralWipePath.prototype.calcNegSpiral.call(this, 1.0 - nT);\n\
innerSpiral.changeOrientation();\n\
\n\
if(this.bFourBox) {\n\
aTransform = SVGIdentityMatrix.scale(0.5, 0.5);\n\
innerSpiral.matrixTransform(aTransform);\n\
res.appendPath(innerSpiral);\n\
res.appendPath(flipOnXAxis(innerSpiral));\n\
innerSpiral = flipOnYAxis(innerSpiral);\n\
res.appendPath(innerSpiral);\n\
res.appendPath(flipOnXAxis(innerSpiral));\n\
}\n\
else {\n\
aTransform = SVGIdentityMatrix.scale(1.0, 0.5);\n\
innerSpiral.matrixTransform(aTransform);\n\
res.appendPath(innerSpiral);\n\
res.appendPath(flipOnXAxis(innerSpiral));\n\
}\n\
return this.bFlipOnYAxis ? flipOnYAxis(res) : res;\n\
}\n\
\n\
function VeeWipePath() { }\n\
\n\
VeeWipePath.prototype.perform = function( nT ) {\n\
const d = pruneScaleValue(2.0 * nT);\n\
var polyPath = 'M ' + 0.0 + ' ' + -1.0 + ' ';\n\
polyPath += 'L ' + 0.0 + ' ' + (d - 1.0) + ' ';\n\
polyPath += 'L ' + 0.5 + ' ' + d + ' ';\n\
polyPath += 'L ' + 1.0 + ' ' + (d - 1.0) + ' ';\n\
polyPath += 'L ' + 1.0 + ' ' + -1.0 + ' ';\n\
polyPath += 'L ' + 0.0 + ' ' + -1.0 + ' ';\n\
\n\
var aPolyPolyPath = document.createElementNS( NSS['svg'], 'path');\n\
aPolyPolyPath.setAttribute('d', polyPath);\n\
return aPolyPolyPath;\n\
}\n\
\n\
\n\
function AnimatedSlide( aMetaSlide )\n\
{\n\
if( !aMetaSlide )\n\
{\n\
log( 'AnimatedSlide constructor: meta slide is not valid' );\n\
}\n\
\n\
this.aMetaSlide = aMetaSlide;\n\
this.aSlideElement = this.aMetaSlide.slideElement;\n\
this.sSlideId = this.aMetaSlide.slideId;\n\
\n\
this.aUsedAttributeSet = [];\n\
\n\
this.aClipPathElement = null;\n\
this.aClipPathContent = null;\n\
this.bIsClipped = false;\n\
}\n\
\n\
AnimatedSlide.prototype.show = function()\n\
{\n\
this.aMetaSlide.show();\n\
};\n\
\n\
AnimatedSlide.prototype.hide = function()\n\
{\n\
this.aMetaSlide.hide();\n\
};\n\
\n\
AnimatedSlide.prototype.notifyUsedAttribute = function( sName )\n\
{\n\
if( sName == 'clip-path' )\n\
{\n\
this.initClipPath();\n\
this.bIsClipped = true;\n\
}\n\
else\n\
{\n\
this.aUsedAttributeSet.push( sName );\n\
}\n\
};\n\
\n\
AnimatedSlide.prototype.reset = function()\n\
{\n\
if( this.bIsClipped )\n\
{\n\
this.cleanClipPath();\n\
this.bIsClipped = false;\n\
}\n\
\n\
var i;\n\
for( i = 0; i < this.aUsedAttributeSet.length; ++i )\n\
{\n\
var sAttrName = this.aUsedAttributeSet[i];\n\
this.aSlideElement.removeAttribute( sAttrName );\n\
}\n\
this.aUsedAttributeSet = [];\n\
};\n\
\n\
AnimatedSlide.prototype.initClipPath = function()\n\
{\n\
this.aClipPathElement = document.createElementNS( NSS['svg'], 'clipPath' );\n\
\n\
var sId = 'clip-path-' + this.sSlideId;\n\
this.aClipPathElement.setAttribute( 'id', sId );\n\
this.aClipPathElement.setAttribute( 'clipPathUnits', 'userSpaceOnUse' );\n\
\n\
this.aClipPathContent = document.createElementNS( NSS['svg'], 'path' );\n\
var sPathData = 'M 0 0 h ' + WIDTH + ' v ' + HEIGHT + ' h -' + WIDTH + ' z';\n\
this.aClipPathContent.setAttribute( 'd', sPathData );\n\
this.aClipPathElement.appendChild( this.aClipPathContent );\n\
";

static const char aSVGScript79[] =
"\
\n\
var aClipPathGroup = theMetaDoc.aClipPathGroup;\n\
aClipPathGroup.appendChild( this.aClipPathElement );\n\
\n\
var sRef = 'url(#' + sId + ')';\n\
this.aSlideElement.parentNode.setAttribute( 'clip-path', sRef );\n\
};\n\
\n\
AnimatedSlide.prototype.cleanClipPath = function()\n\
{\n\
this.aSlideElement.parentNode.removeAttribute( 'clip-path' );\n\
\n\
if( this.aClipPathElement )\n\
{\n\
var aClipPathGroup = theMetaDoc.aClipPathGroup;\n\
aClipPathGroup.removeChild( this.aClipPathElement );\n\
this.aClipPathElement = null;\n\
this.aClipPathContent = null;\n\
}\n\
};\n\
\n\
AnimatedSlide.prototype.insertBefore = function( aElement )\n\
{\n\
if( aElement )\n\
{\n\
this.aSlideElement.parentNode.insertBefore( aElement, this.aSlideElement );\n\
}\n\
};\n\
\n\
AnimatedSlide.prototype.appendElement = function( aElement )\n\
{\n\
if( aElement )\n\
{\n\
this.aSlideElement.parentNode.appendChild( aElement );\n\
}\n\
};\n\
\n\
AnimatedSlide.prototype.removeElement = function( aElement )\n\
{\n\
if( aElement )\n\
{\n\
this.aSlideElement.parentNode.removeChild( aElement );\n\
}\n\
};\n\
\n\
AnimatedSlide.prototype.getWidth = function()\n\
{\n\
return WIDTH;\n\
};\n\
\n\
AnimatedSlide.prototype.getHeight = function()\n\
{\n\
return HEIGHT;\n\
};\n\
\n\
AnimatedSlide.prototype.setOpacity = function( nValue )\n\
{\n\
this.aSlideElement.setAttribute( 'opacity', nValue );\n\
};\n\
\n\
AnimatedSlide.prototype.translate = function( nDx, nDy )\n\
{\n\
var sTransformAttr = 'translate(' + nDx + ',' + nDy + ')';\n\
this.aSlideElement.setAttribute( 'transform', sTransformAttr );\n\
};\n\
\n\
AnimatedSlide.prototype.setClipPath = function( aClipPathContent )\n\
{\n\
if( this.aClipPathContent )\n\
{\n\
var sPathData = aClipPathContent.getAttribute( 'd' );\n\
this.aClipPathContent.setAttribute( 'd', sPathData );\n\
}\n\
};\n\
\n\
\n\
function AnimatedElement( aElement )\n\
{\n\
if( !aElement )\n\
{\n\
log( 'AnimatedElement constructor: element is not valid' );\n\
}\n\
\n\
this.aSlideShowContext = null;\n\
\n\
this.aBaseElement = aElement.cloneNode( true );\n\
this.aActiveElement = aElement;\n\
this.sElementId = this.aActiveElement.getAttribute( 'id' );\n\
\n\
this.aBaseBBox = this.aActiveElement.getBBox();\n\
this.nBaseCenterX = this.aBaseBBox.x + this.aBaseBBox.width / 2;\n\
this.nBaseCenterY = this.aBaseBBox.y + this.aBaseBBox.height / 2;\n\
\n\
\n\
this.aClipPathElement = null;\n\
this.aClipPathContent = null;\n\
\n\
this.aPreviousElement = null;\n\
this.aStateSet = {};\n\
\n\
this.eAdditiveMode = ADDITIVE_MODE_REPLACE;\n\
this.bIsUpdated = true;\n\
\n\
this.aTMatrix = document.documentElement.createSVGMatrix();\n\
this.aCTM = document.documentElement.createSVGMatrix();\n\
this.aICTM = document.documentElement.createSVGMatrix();\n\
\n\
this.initElement();\n\
}\n\
\n\
AnimatedElement.prototype.initElement = function()\n\
{\n\
this.nCenterX = this.nBaseCenterX;\n\
this.nCenterY = this.nBaseCenterY;\n\
this.nScaleFactorX = 1.0;\n\
this.nScaleFactorY = 1.0;\n\
this.nRotationAngle = 0.0;\n\
\n\
this.aActiveElement.setAttribute( 'transform', makeMatrixString( 1, 0, 0, 1, 0, 0 ) );\n\
};\n\
\n\
AnimatedElement.prototype.initClipPath = function()\n\
{\n\
this.aClipPathElement = document.createElementNS( NSS['svg'], 'clipPath' );\n\
\n\
var sId = 'clip-path-' + this.sElementId;\n\
this.aClipPathElement.setAttribute( 'id', sId );\n\
this.aClipPathElement.setAttribute( 'clipPathUnits', 'userSpaceOnUse' );\n\
\n\
this.aClipPathContent = document.createElementNS( NSS['svg'], 'path' );\n\
this.aClippingBBox = this.getBBoxWithStroke();\n\
var nWidth = this.aClippingBBox.width;\n\
var nHeight = this.aClippingBBox.height;\n\
var sPathData = 'M ' + this.aClippingBBox.x + ' ' + this.aClippingBBox.y +\n\
' h ' + nWidth + ' v ' + nHeight + ' h -' + nWidth + ' z';\n\
this.aClipPathContent.setAttribute( 'd', sPathData );\n\
this.aClipPathElement.appendChild( this.aClipPathContent );\n\
\n\
var aClipPathGroup = theMetaDoc.aClipPathGroup;\n\
aClipPathGroup.appendChild( this.aClipPathElement );\n\
\n\
var sRef = 'url(#' + sId + ')';\n\
this.aActiveElement.setAttribute( 'clip-path', sRef );\n\
};\n\
\n\
AnimatedElement.prototype.cleanClipPath = function()\n\
{\n\
this.aActiveElement.removeAttribute( 'clip-path' );\n\
\n\
if( this.aClipPathElement )\n\
";

static const char aSVGScript80[] =
"\
{\n\
var aClipPathGroup = theMetaDoc.aClipPathGroup;\n\
aClipPathGroup.removeChild( this.aClipPathElement );\n\
this.aClipPathElement = null;\n\
this.aClipPathContent = null;\n\
}\n\
};\n\
\n\
AnimatedElement.prototype.getId = function()\n\
{\n\
return this.aActiveElement.getAttribute( 'id' );\n\
};\n\
\n\
AnimatedElement.prototype.getAdditiveMode = function()\n\
{\n\
return this.eAdditiveMode;\n\
};\n\
\n\
AnimatedElement.prototype.setAdditiveMode = function( eAdditiveMode )\n\
{\n\
this.eAdditiveMode = eAdditiveMode;\n\
};\n\
\n\
AnimatedElement.prototype.setToElement = function( aElement )\n\
{\n\
if( !aElement )\n\
{\n\
log( 'AnimatedElement(' + this.getId() + ').setToElement: element is not valid' );\n\
return false;\n\
}\n\
\n\
var aClone = aElement.cloneNode( true );\n\
this.aPreviousElement = this.aActiveElement.parentNode.replaceChild( aClone, this.aActiveElement );\n\
this.aActiveElement = aClone;\n\
\n\
return true;\n\
};\n\
\n\
AnimatedElement.prototype.notifySlideStart = function( aSlideShowContext )\n\
{\n\
if( !aSlideShowContext )\n\
{\n\
log( 'AnimatedElement.notifySlideStart: slideshow context is not valid' );\n\
}\n\
this.aSlideShowContext = aSlideShowContext;\n\
\n\
var aClone = this.aBaseElement.cloneNode( true );\n\
this.aActiveElement.parentNode.replaceChild( aClone, this.aActiveElement );\n\
this.aActiveElement = aClone;\n\
\n\
this.initElement();\n\
this.DBG( '.notifySlideStart invoked' );\n\
};\n\
\n\
AnimatedElement.prototype.notifySlideEnd = function()\n\
{\n\
};\n\
\n\
AnimatedElement.prototype.notifyAnimationStart = function()\n\
{\n\
};\n\
\n\
AnimatedElement.prototype.notifyAnimationEnd = function()\n\
{\n\
};\n\
\n\
AnimatedElement.prototype.notifyNextEffectStart = function( /*nEffectIndex*/ )\n\
{\n\
};\n\
\n\
AnimatedElement.prototype.saveState = function( nAnimationNodeId )\n\
{\n\
ANIMDBG.print( 'AnimatedElement(' + this.getId() + ').saveState(' + nAnimationNodeId +')' );\n\
if( !this.aStateSet[ nAnimationNodeId ] )\n\
{\n\
this.aStateSet[ nAnimationNodeId ] = {};\n\
}\n\
var aState = this.aStateSet[ nAnimationNodeId ];\n\
aState.aElement = this.aActiveElement.cloneNode( true );\n\
aState.nCenterX = this.nCenterX;\n\
aState.nCenterY = this.nCenterY;\n\
aState.nScaleFactorX = this.nScaleFactorX;\n\
aState.nScaleFactorY = this.nScaleFactorY;\n\
aState.nRotationAngle = this.nRotationAngle;\n\
\n\
};\n\
\n\
AnimatedElement.prototype.restoreState = function( nAnimationNodeId )\n\
{\n\
if( !this.aStateSet[ nAnimationNodeId ] )\n\
{\n\
log( 'AnimatedElement(' + this.getId() + ').restoreState: state '\n\
+nAnimationNodeId  + ' is not valid' );\n\
return false;\n\
}\n\
\n\
ANIMDBG.print( 'AnimatedElement(' + this.getId() + ').restoreState(' + nAnimationNodeId +')' );\n\
var aState = this.aStateSet[ nAnimationNodeId ];\n\
var bRet = this.setToElement( aState.aElement );\n\
if( bRet )\n\
{\n\
this.nCenterX = aState.nCenterX;\n\
this.nCenterY = aState.nCenterY;\n\
this.nScaleFactorX = aState.nScaleFactorX;\n\
this.nScaleFactorY = aState.nScaleFactorY;\n\
this.nRotationAngle = aState.nRotationAngle;\n\
}\n\
return bRet;\n\
};\n\
\n\
AnimatedElement.prototype.getBaseBBox = function()\n\
{\n\
return this.aBaseBBox;\n\
};\n\
\n\
AnimatedElement.prototype.getBaseCenterX = function()\n\
{\n\
return this.nBaseCenterX;\n\
};\n\
\n\
AnimatedElement.prototype.getBaseCenterY = function()\n\
{\n\
return this.nBaseCenterY;\n\
};\n\
\n\
AnimatedElement.prototype.getBBox = function()\n\
{\n\
return this.aActiveElement.parentNode.getBBox();\n\
};\n\
\n\
AnimatedElement.prototype.getBBoxWithStroke = function()\n\
{\n\
var aBBox = this.aActiveElement.parentNode.getBBox();\n\
\n\
var aChildrenSet = this.aActiveElement.childNodes;\n\
\n\
var sStroke, sStrokeWidth;\n\
var nStrokeWidth = 0;\n\
var i;\n\
for( i = 0; i < aChildrenSet.length; ++i )\n\
{\n\
if( ! aChildrenSet[i].getAttribute  )\n\
continue;\n\
\n\
sStroke = aChildrenSet[i].getAttribute( 'stroke' );\n\
if( sStroke && sStroke != 'none' )\n\
{\n\
sStrokeWidth = aChildrenSet[i].getAttribute( 'stroke-width' );\n\
var nSW = parseFloat( sStrokeWidth );\n\
if( nSW > nStrokeWidth )\n\
";

static const char aSVGScript81[] =
"\
nStrokeWidth = nSW;\n\
}\n\
}\n\
\n\
if( nStrokeWidth == 0 )\n\
{\n\
sStrokeWidth = ROOT_NODE.getAttribute( 'stroke-width' );\n\
nStrokeWidth = parseFloat( sStrokeWidth );\n\
}\n\
if( nStrokeWidth != 0 )\n\
{\n\
nStrokeWidth *= 1.1;\n\
var nHalfStrokeWidth = nStrokeWidth / 2;\n\
var nDoubleStrokeWidth = nStrokeWidth * 2;\n\
\n\
var aEBBox = document.documentElement.createSVGRect();\n\
aEBBox.x = aBBox.x - nHalfStrokeWidth;\n\
aEBBox.y = aBBox.y - nHalfStrokeWidth;\n\
aEBBox.width = aBBox.width + nDoubleStrokeWidth;\n\
aEBBox.height = aBBox.height + nDoubleStrokeWidth;\n\
aBBox = aEBBox;\n\
}\n\
return aBBox;\n\
};\n\
\n\
AnimatedElement.prototype.setClipPath = function( aClipPathContent )\n\
{\n\
if( this.aClipPathContent )\n\
{\n\
var aTranslation = SVGIdentityMatrix.translate( this.aClippingBBox.x,\n\
this.aClippingBBox.y);\n\
aClipPathContent.matrixTransform( aTranslation );\n\
var sPathData = aClipPathContent.getAttribute( 'd' );\n\
this.aClipPathContent.setAttribute( 'd', sPathData );\n\
}\n\
};\n\
\n\
\n\
AnimatedElement.prototype.getX = function()\n\
{\n\
return this.nCenterX;\n\
};\n\
\n\
AnimatedElement.prototype.getY = function()\n\
{\n\
return this.nCenterY;\n\
};\n\
\n\
AnimatedElement.prototype.getPos = function()\n\
{\n\
return [this.getX(), this.getY()];\n\
};\n\
\n\
AnimatedElement.prototype.getWidth = function()\n\
{\n\
return this.nScaleFactorX * this.getBaseBBox().width;\n\
};\n\
\n\
AnimatedElement.prototype.getHeight = function()\n\
{\n\
return this.nScaleFactorY * this.getBaseBBox().height;\n\
};\n\
\n\
AnimatedElement.prototype.getSize = function()\n\
{\n\
return [this.getWidth(), this.getHeight()];\n\
};\n\
\n\
AnimatedElement.prototype.updateTransformAttribute = function()\n\
{\n\
this.aTransformAttrList = this.aActiveElement.transform.baseVal;\n\
this.aTransformAttr = this.aTransformAttrList.getItem( 0 );\n\
this.aTransformAttr.setMatrix( this.aTMatrix );\n\
};\n\
\n\
AnimatedElement.prototype.setX = function( nNewCenterX )\n\
{\n\
if( nNewCenterX === this.nCenterX ) return;\n\
\n\
this.aTransformAttrList = this.aActiveElement.transform.baseVal;\n\
this.aTransformAttr = this.aTransformAttrList.getItem( 0 );\n\
this.aTMatrix = this.aTransformAttr.matrix.translate( nNewCenterX - this.nCenterX, 0 );\n\
this.aTransformAttr.setMatrix( this.aTMatrix );\n\
this.nCenterX = nNewCenterX;\n\
};\n\
\n\
AnimatedElement.prototype.setY = function( nNewCenterY )\n\
{\n\
if( nNewCenterY === this.nCenterY ) return;\n\
\n\
this.aTransformAttrList = this.aActiveElement.transform.baseVal;\n\
this.aTransformAttr = this.aTransformAttrList.getItem( 0 );\n\
this.aTMatrix = this.aTransformAttr.matrix.translate( 0, nNewCenterY - this.nCenterY );\n\
this.aTransformAttr.setMatrix( this.aTMatrix );\n\
this.nCenterY = nNewCenterY;\n\
};\n\
\n\
AnimatedElement.prototype.setPos = function( aNewPos )\n\
{\n\
var nNewCenterX = aNewPos[0];\n\
var nNewCenterY = aNewPos[1];\n\
\n\
if( nNewCenterX === this.nCenterX && nNewCenterY === this.nCenterY ) return;\n\
\n\
this.aTransformAttrList = this.aActiveElement.transform.baseVal;\n\
this.aTransformAttr = this.aTransformAttrList.getItem( 0 );\n\
this.aTMatrix = this.aTransformAttr.matrix.translate( nNewCenterX - this.nCenterX, nNewCenterY - this.nCenterY );\n\
this.aTransformAttr.setMatrix( this.aTMatrix );\n\
this.nCenterX = nNewCenterX;\n\
this.nCenterY = nNewCenterY;\n\
};\n\
\n\
AnimatedElement.prototype.setWidth = function( nNewWidth )\n\
{\n\
ANIMDBG.print( 'AnimatedElement.setWidth: nNewWidth = ' + nNewWidth );\n\
if( nNewWidth < 0 )\n\
{\n\
log('AnimatedElement(' + this.getId() + ').setWidth: negative width!');\n\
nNewWidth = 0;\n\
}\n\
\n\
var nBaseWidth = this.getBaseBBox().width;\n\
var nScaleFactorX = nNewWidth / nBaseWidth;\n\
\n\
if( nScaleFactorX < 1e-5 ) nScaleFactorX = 1e-5;\n\
if( nScaleFactorX == this.nScaleFactorX ) return;\n\
\n\
this.aTMatrix = document.documentElement.createSVGMatrix()\n\
.translate( this.nCenterX, this.nCenterY )\n\
.rotate(this.nRotationAngle)\n\
.scaleNonUniform( nScaleFactorX, this.nScaleFactorY )\n\
.translate( -this.nBaseCenterX, -this.nBaseCenterY );\n\
this.updateTransformAttribute();\n\
\n\
this.nScaleFactorX = nScaleFactorX;\n\
};\n\
\n\
AnimatedElement.prototype.setHeight = function( nNewHeight )\n\
{\n\
ANIMDBG.print( 'AnimatedElement.setWidth: nNewHeight = ' + nNewHeight );\n\
if( nNewHeight < 0 )\n\
{\n\
log('AnimatedElement(' + this.getId() + ').setWidth: negative height!');\n\
nNewHeight = 0;\n\
}\n\
\n\
var nBaseHeight = this.getBaseBBox().height;\n\
var nScaleFactorY = nNewHeight / nBaseHeight;\n\
\n\
if( nScaleFactorY < 1e-5 ) nScaleFactorY = 1e-5;\n\
";

static const char aSVGScript82[] =
"\
if( nScaleFactorY == this.nScaleFactorY ) return;\n\
\n\
this.aTMatrix = document.documentElement.createSVGMatrix()\n\
.translate( this.nCenterX, this.nCenterY )\n\
.rotate(this.nRotationAngle)\n\
.scaleNonUniform( this.nScaleFactorX, nScaleFactorY )\n\
.translate( -this.nBaseCenterX, -this.nBaseCenterY );\n\
this.updateTransformAttribute();\n\
\n\
this.nScaleFactorY = nScaleFactorY;\n\
};\n\
\n\
AnimatedElement.prototype.setSize= function( aNewSize )\n\
{\n\
var nNewWidth = aNewSize[0];\n\
var nNewHeight = aNewSize[1];\n\
ANIMDBG.print( 'AnimatedElement.setSize:  = [' + nNewWidth + ',' + nNewHeight + ']');\n\
if( nNewWidth < 0 )\n\
{\n\
log('AnimatedElement(' + this.getId() + ').setSize: negative width!');\n\
nNewWidth = 0;\n\
}\n\
if( nNewHeight < 0 )\n\
{\n\
log('AnimatedElement(' + this.getId() + ').setSize: negative height!');\n\
nNewHeight = 0;\n\
}\n\
\n\
var nBaseWidth = this.getBaseBBox().width;\n\
var nScaleFactorX = nNewWidth / nBaseWidth;\n\
if( nScaleFactorX < 1e-5 ) nScaleFactorX = 1e-5;\n\
\n\
var nBaseHeight = this.getBaseBBox().height;\n\
var nScaleFactorY = nNewHeight / nBaseHeight;\n\
if( nScaleFactorY < 1e-5 ) nScaleFactorY = 1e-5;\n\
\n\
if( nScaleFactorX == this.nScaleFactorX && nScaleFactorY == this.nScaleFactorY ) return;\n\
\n\
this.aTMatrix = document.documentElement.createSVGMatrix()\n\
.translate( this.nCenterX, this.nCenterY )\n\
.rotate(this.nRotationAngle)\n\
.scaleNonUniform( nScaleFactorX, nScaleFactorY )\n\
.translate( -this.nBaseCenterX, -this.nBaseCenterY );\n\
this.updateTransformAttribute();\n\
\n\
this.nScaleFactorX = nScaleFactorX;\n\
this.nScaleFactorY = nScaleFactorY;\n\
};\n\
\n\
AnimatedElement.prototype.getOpacity = function()\n\
{\n\
return this.aActiveElement.getAttribute( 'opacity' );\n\
};\n\
\n\
AnimatedElement.prototype.setOpacity = function( nValue )\n\
{\n\
this.aActiveElement.setAttribute( 'opacity', nValue );\n\
};\n\
\n\
AnimatedElement.prototype.getRotationAngle = function()\n\
{\n\
return this.nRotationAngle;\n\
};\n\
\n\
AnimatedElement.prototype.setRotationAngle = function( nNewRotAngle )\n\
{\n\
this.aTMatrix = document.documentElement.createSVGMatrix()\n\
.translate( this.nCenterX, this.nCenterY )\n\
.rotate(nNewRotAngle)\n\
.scaleNonUniform( this.nScaleFactorX, this.nScaleFactorY )\n\
.translate( -this.nBaseCenterX, -this.nBaseCenterY );\n\
this.updateTransformAttribute();\n\
\n\
this.nRotationAngle = nNewRotAngle;\n\
};\n\
\n\
AnimatedElement.prototype.getVisibility = function()\n\
{\n\
\n\
var sVisibilityValue = this.aActiveElement.getAttribute( 'visibility' );\n\
if( !sVisibilityValue || ( sVisibilityValue === 'inherit' ) )\n\
return 'visible'; // TODO: look for parent visibility!\n\
else\n\
return sVisibilityValue;\n\
};\n\
\n\
AnimatedElement.prototype.setVisibility = function( sValue )\n\
{\n\
if( sValue == 'visible' )\n\
sValue = 'inherit';\n\
this.aActiveElement.setAttribute( 'visibility', sValue );\n\
};\n\
\n\
AnimatedElement.prototype.getStrokeStyle = function()\n\
{\n\
return 'solid';\n\
};\n\
\n\
AnimatedElement.prototype.setStrokeStyle = function( sValue )\n\
{\n\
ANIMDBG.print( 'AnimatedElement.setStrokeStyle(' + sValue + ')' );\n\
};\n\
\n\
AnimatedElement.prototype.getFillStyle = function()\n\
{\n\
return 'solid';\n\
};\n\
\n\
AnimatedElement.prototype.setFillStyle = function( sValue )\n\
{\n\
ANIMDBG.print( 'AnimatedElement.setFillStyle(' + sValue + ')' );\n\
};\n\
\n\
AnimatedElement.prototype.getFillColor = function()\n\
{\n\
var aChildSet = getElementChildren( this.aActiveElement );\n\
var sFillColorValue = '';\n\
for( var i = 0; i <  aChildSet.length; ++i )\n\
{\n\
sFillColorValue = aChildSet[i].getAttribute( 'fill' );\n\
if( sFillColorValue && ( sFillColorValue !== 'none' ) )\n\
break;\n\
}\n\
\n\
return colorParser( sFillColorValue );\n\
};\n\
\n\
AnimatedElement.prototype.setFillColor = function( aRGBValue )\n\
{\n\
assert( aRGBValue instanceof RGBColor,\n\
'AnimatedElement.setFillColor: value argument is not an instance of RGBColor' );\n\
\n\
var sValue = aRGBValue.toString( true /* clamped values */ );\n\
var aChildSet = getElementChildren( this.aActiveElement );\n\
\n\
var sFillColorValue = '';\n\
for( var i = 0; i <  aChildSet.length; ++i )\n\
{\n\
sFillColorValue = aChildSet[i].getAttribute( 'fill' );\n\
if( sFillColorValue && ( sFillColorValue !== 'none' ) )\n\
{\n\
aChildSet[i].setAttribute( 'fill', sValue );\n\
}\n\
}\n\
};\n\
\n\
AnimatedElement.prototype.getStrokeColor = function()\n\
{\n\
var aChildSet = getElementChildren( this.aActiveElement );\n\
var sStrokeColorValue = '';\n\
";

static const char aSVGScript83[] =
"\
for( var i = 0; i <  aChildSet.length; ++i )\n\
{\n\
sStrokeColorValue = aChildSet[i].getAttribute( 'stroke' );\n\
if( sStrokeColorValue && ( sStrokeColorValue !== 'none' ) )\n\
break;\n\
}\n\
\n\
return colorParser( sStrokeColorValue );\n\
};\n\
\n\
AnimatedElement.prototype.setStrokeColor = function( aRGBValue )\n\
{\n\
assert( aRGBValue instanceof RGBColor,\n\
'AnimatedElement.setFillColor: value argument is not an instance of RGBColor' );\n\
\n\
var sValue = aRGBValue.toString( true /* clamped values */ );\n\
var aChildSet = getElementChildren( this.aActiveElement );\n\
\n\
var sStrokeColorValue = '';\n\
for( var i = 0; i <  aChildSet.length; ++i )\n\
{\n\
sStrokeColorValue = aChildSet[i].getAttribute( 'stroke' );\n\
if( sStrokeColorValue && ( sStrokeColorValue !== 'none' ) )\n\
{\n\
aChildSet[i].setAttribute( 'stroke', sValue );\n\
}\n\
}\n\
};\n\
\n\
AnimatedElement.prototype.getFontColor = function()\n\
{\n\
return new RGBColor( 0, 0, 0 );\n\
};\n\
\n\
AnimatedElement.prototype.setFontColor = function( sValue )\n\
{\n\
ANIMDBG.print( 'AnimatedElement.setFontColor(' + sValue + ')' );\n\
};\n\
\n\
AnimatedElement.prototype.DBG = function( sMessage, nTime )\n\
{\n\
aAnimatedElementDebugPrinter.print( 'AnimatedElement(' + this.getId() + ')' + sMessage, nTime );\n\
};\n\
\n\
\n\
function AnimatedTextElement( aElement, aEventMultiplexer )\n\
{\n\
var theDocument = document;\n\
\n\
var sTextType = aElement.getAttribute( 'class' );\n\
var bIsListItem = ( sTextType === 'ListItem' );\n\
if( ( sTextType !== 'TextParagraph' ) && !bIsListItem )\n\
{\n\
log( 'AnimatedTextElement: passed element is not a paragraph.' );\n\
return;\n\
}\n\
var aTextShapeElement = aElement.parentNode;\n\
sTextType = aTextShapeElement.getAttribute( 'class' );\n\
if( sTextType !== 'SVGTextShape' )\n\
{\n\
log( 'AnimatedTextElement: element parent is not a text shape.' );\n\
return;\n\
}\n\
var aTextShapeGroup = aTextShapeElement.parentNode;\n\
var aAnimatedElementGroup = getElementByClassName( aTextShapeGroup, 'AnimatedElements' );\n\
if( !aAnimatedElementGroup )\n\
{\n\
aAnimatedElementGroup = theDocument.createElementNS( NSS['svg'], 'g' );\n\
aAnimatedElementGroup.setAttribute( 'class', 'AnimatedElements' );\n\
aTextShapeGroup.appendChild( aAnimatedElementGroup );\n\
}\n\
\n\
var aAnimatableElement = theDocument.createElementNS( NSS['svg'], 'g' );\n\
var aTextElement = theDocument.createElementNS( NSS['svg'], 'text' );\n\
var aParagraphElement = aElement.cloneNode( true );\n\
\n\
this.aGraphicGroupElement = theDocument.createElementNS( NSS['svg'], 'g' );\n\
this.aGraphicGroupElement.setAttribute( 'class', 'GraphicGroup' );\n\
\n\
var aBulletCharClone = null;\n\
var aBulletCharElem = null;\n\
var bIsBulletCharStyle =\n\
( aElement.getAttributeNS( NSS['ooo'], aOOOAttrListItemNumberingType ) === 'bullet-style' );\n\
if( bIsBulletCharStyle )\n\
{\n\
var aBulletCharGroupElem = getElementByClassName( aTextShapeGroup, 'BulletChars' );\n\
if( aBulletCharGroupElem )\n\
{\n\
var aBulletPlaceholderElem = getElementByClassName( aElement, 'BulletPlaceholder' );\n\
if( aBulletPlaceholderElem )\n\
{\n\
var sId = aBulletPlaceholderElem.getAttribute( 'id' );\n\
sId = 'bullet-char-' + sId;\n\
aBulletCharElem = theDocument.getElementById( sId );\n\
if( aBulletCharElem )\n\
{\n\
aBulletCharClone = aBulletCharElem.cloneNode( true );\n\
}\n\
else\n\
{\n\
log( 'AnimatedTextElement: ' + sId + ' not found.' );\n\
}\n\
}\n\
else\n\
{\n\
log( 'AnimatedTextElement: no bullet placeholder found' );\n\
}\n\
}\n\
else\n\
{\n\
log( 'AnimatedTextElement: no bullet char group found' );\n\
}\n\
}\n\
\n\
var aBitmapElemSet = [];\n\
var aBitmapCloneSet = [];\n\
var aBitmapPlaceholderSet = getElementsByClassName( aElement, 'BitmapPlaceholder' );\n\
var i;\n\
if( aBitmapPlaceholderSet )\n\
{\n\
for( i = 0; i < aBitmapPlaceholderSet.length; ++i )\n\
{\n\
sId = aBitmapPlaceholderSet[i].getAttribute( 'id' );\n\
var sBitmapChecksum = sId.substring( 'bitmap-placeholder'.length + 1, sId.length - 1 );\n\
sId = 'embedded-bitmap(' + sBitmapChecksum + ')';\n\
aBitmapElemSet[i] = theDocument.getElementById( sId );\n\
if( aBitmapElemSet[i] )\n\
{\n\
aBitmapCloneSet[i] = aBitmapElemSet[i].cloneNode( true );\n\
}\n\
else\n\
{\n\
log( 'AnimatedTextElement: ' + sId + ' not found.' );\n\
}\n\
}\n\
}\n\
\n\
\n\
this.sParagraphId = sId = aParagraphElement.getAttribute( 'id' );\n\
aParagraphElement.removeAttribute( 'id' );\n\
aAnimatableElement.setAttribute( 'id', sId +'.a' );\n\
if( aBulletCharClone )\n\
aBulletCharClone.removeAttribute( 'id' );\n\
for( i = 0; i < aBitmapCloneSet.length; ++i )\n\
{\n\
if( aBitmapCloneSet[i] )\n\
aBitmapCloneSet[i].removeAttribute( 'id' );\n\
}\n\
\n\
var sVisibilityAttr = aElement.getAttribute( 'visibility' );\n\
";

static const char aSVGScript84[] =
"\
if( !sVisibilityAttr )\n\
sVisibilityAttr = 'inherit';\n\
aAnimatableElement.setAttribute( 'visibility', sVisibilityAttr );\n\
aParagraphElement.setAttribute( 'visibility', 'inherit' );\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'inherit' );\n\
if( aBulletCharElem )\n\
aBulletCharElem.setAttribute( 'visibility', 'hidden' );\n\
for( i = 0; i < aBitmapCloneSet.length; ++i )\n\
{\n\
if( aBitmapElemSet[i] )\n\
aBitmapElemSet[i].setAttribute( 'visibility', 'hidden' );\n\
}\n\
\n\
\n\
aTextElement.appendChild( aParagraphElement );\n\
aAnimatableElement.appendChild( aTextElement );\n\
\n\
if( aBulletCharClone )\n\
this.aGraphicGroupElement.appendChild( aBulletCharClone );\n\
for( i = 0; i < aBitmapCloneSet.length; ++i )\n\
{\n\
if( aBitmapCloneSet[i] )\n\
this.aGraphicGroupElement.appendChild( aBitmapCloneSet[i] );\n\
}\n\
aAnimatableElement.appendChild( this.aGraphicGroupElement );\n\
aAnimatedElementGroup.appendChild( aAnimatableElement );\n\
\n\
this.aParentTextElement = aElement.parentNode;\n\
this.aParagraphElement = aElement;\n\
this.aAnimatedElementGroup = aAnimatedElementGroup;\n\
this.nRunningAnimations = 0;\n\
\n\
this.aHyperlinkIdSet = [];\n\
var aHyperlinkElementSet = getElementsByClassName( this.aParagraphElement, 'UrlField' );\n\
var sHyperlinkId;\n\
for( i = 0; i < aHyperlinkElementSet.length; ++i )\n\
{\n\
sHyperlinkId = aHyperlinkElementSet[i].getAttribute( 'id' );\n\
if( sHyperlinkId )\n\
this.aHyperlinkIdSet.push( sHyperlinkId );\n\
else\n\
log( 'error: AnimatedTextElement constructor: hyperlink element has no id' );\n\
}\n\
\n\
AnimatedTextElement.superclass.constructor.call( this, aAnimatableElement, aEventMultiplexer );\n\
\n\
}\n\
extend( AnimatedTextElement, AnimatedElement );\n\
\n\
\n\
AnimatedTextElement.prototype.setToElement = function( aElement )\n\
{\n\
var bRet = AnimatedTextElement.superclass.setToElement.call( this, aElement );\n\
if( bRet )\n\
{\n\
this.aGraphicGroupElement = getElementByClassName( this.aActiveElement, 'GraphicGroup' );\n\
}\n\
return ( bRet && this.aGraphicGroupElement );\n\
};\n\
\n\
AnimatedTextElement.prototype.notifySlideStart = function( aSlideShowContext )\n\
{\n\
DBGLOG( 'AnimatedTextElement.notifySlideStart' );\n\
AnimatedTextElement.superclass.notifySlideStart.call( this, aSlideShowContext );\n\
this.aGraphicGroupElement = getElementByClassName( this.aActiveElement, 'GraphicGroup' );\n\
this.restoreBaseTextParagraph();\n\
};\n\
\n\
AnimatedTextElement.prototype.notifySlideEnd = function()\n\
{\n\
DBGLOG( 'AnimatedTextElement.notifySlideEnd' );\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'inherit' );\n\
};\n\
\n\
AnimatedTextElement.prototype.restoreBaseTextParagraph = function()\n\
{\n\
var aActiveParagraphElement = this.aActiveElement.firstElementChild.firstElementChild;\n\
if( aActiveParagraphElement )\n\
{\n\
var sVisibilityAttr = this.aActiveElement.getAttribute( 'visibility' );\n\
if( !sVisibilityAttr || ( sVisibilityAttr === 'visible' ) )\n\
sVisibilityAttr = 'inherit';\n\
if( sVisibilityAttr === 'inherit' )\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'visible' );\n\
else\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'hidden' );\n\
\n\
var aParagraphClone = aActiveParagraphElement.cloneNode( true );\n\
aParagraphClone.setAttribute( 'id', this.sParagraphId );\n\
aParagraphClone.setAttribute( 'visibility', sVisibilityAttr );\n\
this.aParentTextElement.replaceChild( aParagraphClone, this.aParagraphElement );\n\
this.aParagraphElement = aParagraphClone;\n\
\n\
\n\
var aEventMultiplexer = this.aSlideShowContext.aEventMultiplexer;\n\
var aHyperlinkIdSet = this.aHyperlinkIdSet;\n\
var aHyperlinkElementSet = getElementsByClassName( this.aParagraphElement, 'UrlField' );\n\
var i = 0;\n\
for( ; i < aHyperlinkIdSet.length; ++i )\n\
{\n\
aEventMultiplexer.notifyElementChangedEvent( aHyperlinkIdSet[i], aHyperlinkElementSet[i] );\n\
}\n\
}\n\
this.aActiveElement.setAttribute( 'visibility', 'hidden' );\n\
};\n\
\n\
AnimatedTextElement.prototype.notifyAnimationStart = function()\n\
{\n\
DBGLOG( 'AnimatedTextElement.notifyAnimationStart' );\n\
if( this.nRunningAnimations === 0 )\n\
{\n\
var sVisibilityAttr = this.aParagraphElement.getAttribute( 'visibility' );\n\
if( !sVisibilityAttr )\n\
sVisibilityAttr = 'inherit';\n\
this.aActiveElement.setAttribute( 'visibility', sVisibilityAttr );\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'inherit' );\n\
this.aParagraphElement.setAttribute( 'visibility', 'hidden' );\n\
}\n\
++this.nRunningAnimations;\n\
};\n\
\n\
AnimatedTextElement.prototype.notifyAnimationEnd = function()\n\
{\n\
DBGLOG( 'AnimatedTextElement.notifyAnimationEnd' );\n\
--this.nRunningAnimations;\n\
if( this.nRunningAnimations === 0 )\n\
{\n\
this.restoreBaseTextParagraph();\n\
}\n\
};\n\
\n\
AnimatedTextElement.prototype.saveState = function( nAnimationNodeId )\n\
{\n\
if( this.nRunningAnimations === 0 )\n\
{\n\
var sVisibilityAttr = this.aParagraphElement.getAttribute( 'visibility' );\n\
this.aActiveElement.setAttribute( 'visibility', sVisibilityAttr );\n\
this.aGraphicGroupElement.setAttribute( 'visibility', 'inherit' );\n\
}\n\
AnimatedTextElement.superclass.saveState.call( this, nAnimationNodeId );\n\
};\n\
\n\
AnimatedTextElement.prototype.restoreState = function( nAnimationNodeId )\n\
{\n\
var bRet = AnimatedTextElement.superclass.restoreState.call( this, nAnimationNodeId );\n\
if( bRet )\n\
this.restoreBaseTextParagraph();\n\
return bRet;\n\
};\n\
\n\
";

static const char aSVGScript85[] =
"\
\n\
function SlideTransition( aAnimationsRootElement, aSlideId )\n\
{\n\
this.sSlideId = aSlideId;\n\
this.bIsValid = false;\n\
this.eTransitionType = undefined;\n\
this.eTransitionSubType = undefined;\n\
this.bReverseDirection = false;\n\
this.eTransitionMode = TRANSITION_MODE_IN;\n\
this.sFadeColor = null;\n\
this.aDuration = null;\n\
this.nMinFrameCount = undefined;\n\
\n\
if( aAnimationsRootElement )\n\
{\n\
if( aAnimationsRootElement.firstElementChild &&\n\
( aAnimationsRootElement.firstElementChild.getAttributeNS( NSS['smil'], 'begin' ) === (this.sSlideId + '.begin') ) )\n\
{\n\
var aTransitionFilterElement = aAnimationsRootElement.firstElementChild.firstElementChild;\n\
if( aTransitionFilterElement && ( aTransitionFilterElement.localName === 'transitionFilter' ) )\n\
{\n\
this.aElement = aTransitionFilterElement;\n\
this.parseElement();\n\
}\n\
aAnimationsRootElement.removeChild( aAnimationsRootElement.firstElementChild );\n\
}\n\
}\n\
}\n\
\n\
SlideTransition.prototype.createSlideTransition = function( aLeavingSlide, aEnteringSlide )\n\
{\n\
if( !this.isValid() )\n\
return null;\n\
if( this.eTransitionType == 0 )\n\
return null;\n\
\n\
if( !aEnteringSlide )\n\
{\n\
log( 'SlideTransition.createSlideTransition: invalid entering slide.' );\n\
return null;\n\
}\n\
\n\
var aTransitionInfo = aTransitionInfoTable[this.eTransitionType][this.eTransitionSubType];\n\
var eTransitionClass = aTransitionInfo['class'];\n\
\n\
switch( eTransitionClass )\n\
{\n\
default:\n\
case TRANSITION_INVALID:\n\
log( 'SlideTransition.createSlideTransition: transition class: TRANSITION_INVALID' );\n\
return null;\n\
\n\
case TRANSITION_CLIP_POLYPOLYGON:\n\
var aParametricPolyPolygon\n\
= createClipPolyPolygon( this.eTransitionType, this.eTransitionSubType );\n\
return new ClippedSlideChange( aLeavingSlide, aEnteringSlide, aParametricPolyPolygon,\n\
aTransitionInfo, this.isDirectionForward() );\n\
\n\
case TRANSITION_SPECIAL:\n\
switch( this.eTransitionType )\n\
{\n\
default:\n\
log( 'SlideTransition.createSlideTransition: ' +\n\
'transition class: TRANSITION_SPECIAL, ' +\n\
'unknown transition type: ' + this.eTransitionType );\n\
return null;\n\
\n\
case PUSHWIPE_TRANSITION:\n\
{\n\
var aDirection = null;\n\
switch( this.eTransitionSubType )\n\
{\n\
default:\n\
log( 'SlideTransition.createSlideTransition: ' +\n\
'transition type: PUSHWIPE_TRANSITION, ' +\n\
'unknown transition subtype: ' + this.eTransitionSubType );\n\
return null;\n\
case FROMTOP_TRANS_SUBTYPE:\n\
aDirection = { x: 0.0, y: 1.0 };\n\
break;\n\
case FROMBOTTOM_TRANS_SUBTYPE:\n\
aDirection = { x: 0.0, y: -1.0 };\n\
break;\n\
case FROMLEFT_TRANS_SUBTYPE:\n\
aDirection = { x: 1.0, y: 0.0 };\n\
break;\n\
case FROMRIGHT_TRANS_SUBTYPE:\n\
aDirection = { x: -1.0, y: 0.0 };\n\
break;\n\
}\n\
return new MovingSlideChange( aLeavingSlide, aEnteringSlide, aDirection, aDirection );\n\
}\n\
\n\
case SLIDEWIPE_TRANSITION:\n\
{\n\
var aInDirection = null;\n\
switch( this.eTransitionSubType )\n\
{\n\
default:\n\
log( 'SlideTransition.createSlideTransition: ' +\n\
'transition type: SLIDEWIPE_TRANSITION, ' +\n\
'unknown transition subtype: ' + this.eTransitionSubType );\n\
return null;\n\
case FROMTOP_TRANS_SUBTYPE:\n\
aInDirection = { x: 0.0, y: 1.0 };\n\
break;\n\
case FROMBOTTOM_TRANS_SUBTYPE:\n\
aInDirection = { x: 0.0, y: -1.0 };\n\
break;\n\
case FROMLEFT_TRANS_SUBTYPE:\n\
aInDirection = { x: 1.0, y: 0.0 };\n\
break;\n\
case FROMRIGHT_TRANS_SUBTYPE:\n\
aInDirection = { x: -1.0, y: 0.0 };\n\
break;\n\
}\n\
var aNoDirection = { x: 0.0, y: 0.0 };\n\
if( !this.bReverseDirection )\n\
{\n\
return new MovingSlideChange( aLeavingSlide, aEnteringSlide, aNoDirection, aInDirection );\n\
}\n\
else\n\
{\n\
return new MovingSlideChange( aLeavingSlide, aEnteringSlide, aInDirection, aNoDirection );\n\
}\n\
}\n\
\n\
case FADE_TRANSITION:\n\
switch( this.eTransitionSubType )\n\
{\n\
default:\n\
log( 'SlideTransition.createSlideTransition: ' +\n\
'transition type: FADE_TRANSITION, ' +\n\
'unknown transition subtype: ' + this.eTransitionSubType );\n\
return null;\n\
case CROSSFADE_TRANS_SUBTYPE:\n\
return new FadingSlideChange( aLeavingSlide, aEnteringSlide );\n\
case FADEOVERCOLOR_TRANS_SUBTYPE:\n\
return new FadingOverColorSlideChange( aLeavingSlide, aEnteringSlide, this.getFadeColor() );\n\
}\n\
}\n\
}\n\
};\n\
\n\
SlideTransition.prototype.parseElement = function()\n\
{\n\
this.bIsValid = true;\n\
var aAnimElem = this.aElement;\n\
\n\
this.eTransitionType = undefined;\n\
";

static const char aSVGScript86[] =
"\
var sTypeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'type' );\n\
if( sTypeAttr && aTransitionTypeInMap[ sTypeAttr ] )\n\
{\n\
this.eTransitionType = aTransitionTypeInMap[ sTypeAttr ];\n\
}\n\
else\n\
{\n\
this.bIsValid = false;\n\
log( 'SlideTransition.parseElement: transition type not valid: ' + sTypeAttr );\n\
}\n\
\n\
this.eTransitionSubType = undefined;\n\
var sSubTypeAttr = aAnimElem.getAttributeNS( NSS['smil'], 'subtype' );\n\
if( sSubTypeAttr === null )\n\
sSubTypeAttr = 'default';\n\
if( sSubTypeAttr && ( aTransitionSubtypeInMap[ sSubTypeAttr ] !== undefined ) )\n\
{\n\
this.eTransitionSubType = aTransitionSubtypeInMap[ sSubTypeAttr ];\n\
}\n\
else\n\
{\n\
this.bIsValid = false;\n\
log( 'SlideTransition.parseElement: transition subtype not valid: ' + sSubTypeAttr );\n\
}\n\
\n\
if( this.bIsValid && aTransitionInfoTable[this.eTransitionType][this.eTransitionSubType] === undefined )\n\
{\n\
this.bIsValid = false;\n\
log( 'SlideTransition.parseElement: transition not valid: type: ' + sTypeAttr + ' subtype: ' + sSubTypeAttr );\n\
}\n\
\n\
this.bReverseDirection = false;\n\
var sDirectionAttr = aAnimElem.getAttributeNS( NSS['smil'], 'direction' );\n\
if( sDirectionAttr == 'reverse' )\n\
this.bReverseDirection = true;\n\
\n\
this.sFadeColor = null;\n\
if( this.eTransitionType == FADE_TRANSITION &&\n\
( this.eTransitionSubType == FADEFROMCOLOR_TRANS_SUBTYPE ||\n\
this.eTransitionSubType == FADEOVERCOLOR_TRANS_SUBTYPE ||\n\
this.eTransitionSubType == FADETOCOLOR_TRANS_SUBTYPE ) )\n\
{\n\
var sColorAttr = aAnimElem.getAttributeNS( NSS['smil'], 'fadeColor' );\n\
if( sColorAttr )\n\
this.sFadeColor = sColorAttr;\n\
else\n\
this.sFadeColor='#000000';\n\
}\n\
\n\
\n\
this.aDuration = null;\n\
var sDurAttr = aAnimElem.getAttributeNS( NSS['smil'], 'dur' );\n\
this.aDuration = new Duration( sDurAttr );\n\
if( !this.aDuration.isSet() )\n\
{\n\
this.aDuration = new Duration( null ); // duration == 0.0\n\
}\n\
\n\
this.nMinFrameCount = ( this.getDuration().isValue() )\n\
? ( this.getDuration().getValue() * MINIMUM_FRAMES_PER_SECONDS )\n\
: MINIMUM_FRAMES_PER_SECONDS;\n\
if( this.nMinFrameCount < 1.0 )\n\
this.nMinFrameCount = 1;\n\
else if( this.nMinFrameCount > MINIMUM_FRAMES_PER_SECONDS )\n\
this.nMinFrameCount = MINIMUM_FRAMES_PER_SECONDS;\n\
\n\
};\n\
\n\
SlideTransition.prototype.isValid = function()\n\
{\n\
return this.bIsValid;\n\
};\n\
\n\
SlideTransition.prototype.getTransitionType = function()\n\
{\n\
return this.eTransitionType;\n\
};\n\
\n\
SlideTransition.prototype.getTransitionSubType = function()\n\
{\n\
return this.eTransitionSubType;\n\
};\n\
\n\
SlideTransition.prototype.getTransitionMode = function()\n\
{\n\
return this.eTransitionMode;\n\
};\n\
\n\
SlideTransition.prototype.getFadeColor = function()\n\
{\n\
return this.sFadeColor;\n\
};\n\
\n\
SlideTransition.prototype.isDirectionForward = function()\n\
{\n\
return !this.bReverseDirection;\n\
};\n\
\n\
SlideTransition.prototype.getDuration = function()\n\
{\n\
return this.aDuration;\n\
};\n\
\n\
SlideTransition.prototype.getMinFrameCount = function()\n\
{\n\
return this.nMinFrameCount;\n\
};\n\
\n\
SlideTransition.prototype.info = function()\n\
{\n\
\n\
var sInfo ='slide transition <' + this.sSlideId + '>: ';\n\
sInfo += ';  type: ' + getKeyByValue(aTransitionTypeInMap, this.getTransitionType());\n\
\n\
sInfo += ';  subtype: ' + getKeyByValue(aTransitionSubtypeInMap, this.getTransitionSubType());\n\
\n\
if( !this.isDirectionForward() )\n\
sInfo += ';  direction: reverse';\n\
\n\
sInfo += '; mode: ' + aTransitionModeOutMap[ this.getTransitionMode() ];\n\
\n\
if( this.getDuration() )\n\
sInfo += '; duration: ' + this.getDuration().info();\n\
\n\
return sInfo;\n\
};\n\
\n\
\n\
function SlideAnimations( aSlideShowContext )\n\
{\n\
this.aContext = new NodeContext( aSlideShowContext );\n\
this.aAnimationNodeMap = {};\n\
this.aAnimatedElementMap = {};\n\
this.aSourceEventElementMap = {};\n\
this.aNextEffectEventArray = new NextEffectEventArray();\n\
this.aInteractiveAnimationSequenceMap = {};\n\
this.aEventMultiplexer = new EventMultiplexer( aSlideShowContext.aTimerEventQueue );\n\
this.aRootNode = null;\n\
this.bElementsParsed = false;\n\
\n\
this.aContext.aAnimationNodeMap = this.aAnimationNodeMap;\n\
this.aContext.aAnimatedElementMap = this.aAnimatedElementMap;\n\
this.aContext.aSourceEventElementMap = this.aSourceEventElementMap;\n\
\n\
this.aEventMultiplexer.registerMouseClickHandler( document, 100 );\n\
}\n\
\n\
\n\
SlideAnimations.prototype.importAnimations = function( aAnimationRootElement )\n\
{\n\
";

static const char aSVGScript87[] =
"\
if( !aAnimationRootElement )\n\
return false;\n\
\n\
this.aRootNode = createAnimationTree( aAnimationRootElement, this.aContext );\n\
\n\
return ( this.aRootNode ? true : false );\n\
};\n\
\n\
SlideAnimations.prototype.parseElements = function()\n\
{\n\
if( !this.aRootNode )\n\
return false;\n\
\n\
if( !this.aRootNode.parseElement() )\n\
return false;\n\
else\n\
this.bElementsParsed = true;\n\
};\n\
\n\
SlideAnimations.prototype.elementsParsed = function()\n\
{\n\
return this.bElementsParsed;\n\
};\n\
\n\
SlideAnimations.prototype.isFirstRun = function()\n\
{\n\
return this.aContext.bFirstRun;\n\
};\n\
\n\
SlideAnimations.prototype.isAnimated = function()\n\
{\n\
if( !this.bElementsParsed )\n\
return false;\n\
\n\
return this.aRootNode.hasPendingAnimation();\n\
};\n\
\n\
SlideAnimations.prototype.start = function()\n\
{\n\
if( !this.bElementsParsed )\n\
return false;\n\
\n\
this.chargeSourceEvents();\n\
this.chargeInterAnimEvents();\n\
\n\
aSlideShow.setSlideEvents( this.aNextEffectEventArray,\n\
this.aInteractiveAnimationSequenceMap,\n\
this.aEventMultiplexer );\n\
\n\
if( this.aContext.bFirstRun == undefined )\n\
this.aContext.bFirstRun = true;\n\
else if( this.aContext.bFirstRun )\n\
this.aContext.bFirstRun = false;\n\
\n\
this.aContext.bIsInvalid = !this.aRootNode.init();\n\
if( this.aContext.bIsInvalid )\n\
return false;\n\
\n\
return this.aRootNode.resolve();\n\
};\n\
\n\
SlideAnimations.prototype.end = function( bLeftEffectsSkipped )\n\
{\n\
if( !this.bElementsParsed )\n\
return; // no animations there\n\
\n\
this.aRootNode.deactivate();\n\
this.aRootNode.end();\n\
\n\
if( bLeftEffectsSkipped && this.isFirstRun() )\n\
{\n\
this.aContext.bFirstRun = undefined;\n\
}\n\
else if( this.isFirstRun() )\n\
{\n\
this.aContext.bFirstRun = false;\n\
}\n\
\n\
this.aContext.bIsInvalid = false;\n\
};\n\
\n\
SlideAnimations.prototype.dispose = function()\n\
{\n\
if( this.aRootNode )\n\
{\n\
this.aRootNode.dispose();\n\
}\n\
};\n\
\n\
SlideAnimations.prototype.clearNextEffectEvents = function()\n\
{\n\
ANIMDBG.print( 'SlideAnimations.clearNextEffectEvents: current slide: ' + nCurSlide );\n\
this.aNextEffectEventArray.clear();\n\
this.aContext.bFirstRun = undefined;\n\
};\n\
\n\
SlideAnimations.prototype.chargeSourceEvents = function()\n\
{\n\
for( var id in this.aSourceEventElementMap )\n\
{\n\
this.aSourceEventElementMap[id].charge();\n\
}\n\
};\n\
\n\
SlideAnimations.prototype.chargeInterAnimEvents = function()\n\
{\n\
for( var id in this.aInteractiveAnimationSequenceMap )\n\
{\n\
this.aInteractiveAnimationSequenceMap[id].chargeEvents();\n\
}\n\
};\n\
\n\
\n\
function Event()\n\
{\n\
this.nId = Event.getUniqueId();\n\
}\n\
\n\
\n\
Event.CURR_UNIQUE_ID = 0;\n\
\n\
Event.getUniqueId = function()\n\
{\n\
++Event.CURR_UNIQUE_ID;\n\
return Event.CURR_UNIQUE_ID;\n\
};\n\
\n\
Event.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
\n\
function DelayEvent( aFunctor, nTimeout )\n\
{\n\
DelayEvent.superclass.constructor.call( this );\n\
\n\
this.aFunctor = aFunctor;\n\
this.nTimeout = nTimeout;\n\
this.bWasFired = false;\n\
}\n\
extend( DelayEvent, Event );\n\
\n\
\n\
DelayEvent.prototype.fire = function()\n\
{\n\
assert( this.isCharged(), 'DelayEvent.fire: assertion isCharged failed' );\n\
\n\
this.bWasFired = true;\n\
this.aFunctor();\n\
";

static const char aSVGScript88[] =
"\
return true;\n\
};\n\
\n\
DelayEvent.prototype.isCharged = function()\n\
{\n\
return !this.bWasFired;\n\
};\n\
\n\
DelayEvent.prototype.getActivationTime = function( nCurrentTime )\n\
{\n\
return ( this.nTimeout + nCurrentTime );\n\
};\n\
\n\
DelayEvent.prototype.dispose = function()\n\
{\n\
if( this.isCharged() )\n\
this.bWasFired = true;\n\
};\n\
\n\
DelayEvent.prototype.charge = function()\n\
{\n\
if( !this.isCharged() )\n\
this.bWasFired = false;\n\
};\n\
\n\
\n\
function WakeupEvent( aTimer, aActivityQueue )\n\
{\n\
WakeupEvent.superclass.constructor.call( this );\n\
\n\
this.aTimer = new ElapsedTime( aTimer );\n\
this.nNextTime = 0.0;\n\
this.aActivity = null;\n\
this.aActivityQueue = aActivityQueue;\n\
}\n\
extend( WakeupEvent, Event );\n\
\n\
\n\
WakeupEvent.prototype.clone = function()\n\
{\n\
var aWakeupEvent = new WakeupEvent( this.aTimer.getTimeBase(), this.aActivityQueue );\n\
aWakeupEvent.nNextTime = this.nNextTime;\n\
aWakeupEvent.aActivity = this.aActivity;\n\
return aWakeupEvent;\n\
};\n\
\n\
WakeupEvent.prototype.dispose = function()\n\
{\n\
this.aActivity = null;\n\
};\n\
\n\
WakeupEvent.prototype.fire = function()\n\
{\n\
if( !this.aActivity )\n\
return false;\n\
\n\
return this.aActivityQueue.addActivity( this.aActivity );\n\
};\n\
\n\
WakeupEvent.prototype.isCharged = function()\n\
{\n\
return true;\n\
};\n\
\n\
WakeupEvent.prototype.getActivationTime = function( nCurrentTime )\n\
{\n\
var nElapsedTime = this.aTimer.getElapsedTime();\n\
\n\
return Math.max( nCurrentTime, nCurrentTime - nElapsedTime + this.nNextTime );\n\
};\n\
\n\
WakeupEvent.prototype.start = function()\n\
{\n\
this.aTimer.reset();\n\
};\n\
\n\
WakeupEvent.prototype.setNextTimeout = function( nNextTime )\n\
{\n\
this.nNextTime = nNextTime;\n\
};\n\
\n\
WakeupEvent.prototype.setActivity = function( aActivity )\n\
{\n\
this.aActivity = aActivity;\n\
};\n\
\n\
\n\
function makeEvent( aFunctor )\n\
{\n\
return new DelayEvent( aFunctor, 0.0 );\n\
}\n\
\n\
\n\
function makeDelay( aFunctor, nTimeout )\n\
{\n\
return new DelayEvent( aFunctor, nTimeout );\n\
}\n\
\n\
\n\
function registerEvent( nNodeId, aTiming, aEvent, aNodeContext )\n\
{\n\
var aSlideShowContext = aNodeContext.aContext;\n\
var eTimingType = aTiming.getType();\n\
\n\
registerEvent.DBG( aTiming );\n\
\n\
if( eTimingType == OFFSET_TIMING )\n\
{\n\
aSlideShowContext.aTimerEventQueue.addEvent( aEvent );\n\
}\n\
else if ( aNodeContext.bFirstRun )\n\
{\n\
var aEventMultiplexer = aSlideShowContext.aEventMultiplexer;\n\
if( !aEventMultiplexer )\n\
{\n\
log( 'registerEvent: event multiplexer not initialized' );\n\
return;\n\
}\n\
var aNextEffectEventArray = aSlideShowContext.aNextEffectEventArray;\n\
if( !aNextEffectEventArray )\n\
{\n\
log( 'registerEvent: next effect event array not initialized' );\n\
return;\n\
}\n\
var aInteractiveAnimationSequenceMap =\n\
aSlideShowContext.aInteractiveAnimationSequenceMap;\n\
if( !aInteractiveAnimationSequenceMap )\n\
{\n\
log( 'registerEvent: interactive animation sequence map not initialized' );\n\
return;\n\
}\n\
\n\
switch( eTimingType )\n\
{\n\
case EVENT_TIMING:\n\
var eEventType = aTiming.getEventType();\n\
var sEventBaseElemId = aTiming.getEventBaseElementId();\n\
if( sEventBaseElemId )\n\
{\n\
var aEventBaseElem = document.getElementById( sEventBaseElemId );\n\
if( !aEventBaseElem )\n\
{\n\
log( 'generateEvent: EVENT_TIMING: event base element not found: ' + sEventBaseElemId );\n\
return;\n\
}\n\
var aSourceEventElement = aNodeContext.makeSourceEventElement( sEventBaseElemId, aEventBaseElem );\n\
\n\
if( !aInteractiveAnimationSequenceMap[ nNodeId ] )\n\
{\n\
aInteractiveAnimationSequenceMap[ nNodeId ] = new InteractiveAnimationSequence(nNodeId);\n\
";

static const char aSVGScript89[] =
"\
}\n\
\n\
var bEventRegistered = false;\n\
switch( eEventType )\n\
{\n\
case EVENT_TRIGGER_ON_CLICK:\n\
aEventMultiplexer.registerEvent( eEventType, aSourceEventElement.getId(), aEvent );\n\
aEventMultiplexer.registerRewindedEffectHandler( aSourceEventElement.getId(),\n\
bind2( aSourceEventElement.charge, aSourceEventElement ) );\n\
bEventRegistered = true;\n\
break;\n\
default:\n\
log( 'generateEvent: not handled event type: ' + eEventType );\n\
}\n\
if( bEventRegistered )\n\
{\n\
var aStartEvent = aInteractiveAnimationSequenceMap[ nNodeId ].getStartEvent();\n\
var aEndEvent = aInteractiveAnimationSequenceMap[ nNodeId ].getEndEvent();\n\
aEventMultiplexer.registerEvent( eEventType, aSourceEventElement.getId(), aStartEvent );\n\
aEventMultiplexer.registerEvent( EVENT_TRIGGER_END_EVENT, nNodeId, aEndEvent );\n\
aEventMultiplexer.registerRewindedEffectHandler(\n\
nNodeId,\n\
bind2( InteractiveAnimationSequence.prototype.chargeEvents,\n\
aInteractiveAnimationSequenceMap[ nNodeId ] )\n\
);\n\
}\n\
}\n\
else  // no base event element present\n\
{\n\
switch( eEventType )\n\
{\n\
case EVENT_TRIGGER_ON_NEXT_EFFECT:\n\
aNextEffectEventArray.appendEvent( aEvent );\n\
break;\n\
default:\n\
log( 'generateEvent: not handled event type: ' + eEventType );\n\
}\n\
}\n\
break;\n\
case SYNCBASE_TIMING:\n\
eEventType = aTiming.getEventType();\n\
sEventBaseElemId = aTiming.getEventBaseElementId();\n\
if( sEventBaseElemId )\n\
{\n\
var aAnimationNode = aNodeContext.aAnimationNodeMap[ sEventBaseElemId ];\n\
if( !aAnimationNode )\n\
{\n\
log( 'generateEvent: SYNCBASE_TIMING: event base element not found: ' + sEventBaseElemId );\n\
return;\n\
}\n\
aEventMultiplexer.registerEvent( eEventType, aAnimationNode.getId(), aEvent );\n\
}\n\
else\n\
{\n\
log( 'generateEvent: SYNCBASE_TIMING: event base element not specified' );\n\
}\n\
break;\n\
default:\n\
log( 'generateEvent: not handled timing type: ' + eTimingType );\n\
}\n\
}\n\
}\n\
\n\
registerEvent.DEBUG = aRegisterEventDebugPrinter.isEnabled();\n\
\n\
registerEvent.DBG = function( aTiming, nTime )\n\
{\n\
if( registerEvent.DEBUG )\n\
{\n\
aRegisterEventDebugPrinter.print( 'registerEvent( timing: ' + aTiming.info() + ' )', nTime );\n\
}\n\
};\n\
\n\
\n\
function SourceEventElement( sId, aElement, aEventMultiplexer )\n\
{\n\
this.sId = sId;\n\
this.aElement = aElement;\n\
this.aEventMultiplexer = aEventMultiplexer;\n\
\n\
this.aEventMultiplexer.registerMouseClickHandler( this, 1000 );\n\
\n\
this.bClickHandled = false;\n\
this.bIsPointerOver = false;\n\
this.aElement.addEventListener( 'mouseover', bind2( SourceEventElement.prototype.onMouseEnter, this), false );\n\
this.aElement.addEventListener( 'mouseout', bind2( SourceEventElement.prototype.onMouseLeave, this), false );\n\
}\n\
\n\
SourceEventElement.prototype.getId = function()\n\
{\n\
return this.sId;\n\
};\n\
\n\
SourceEventElement.prototype.onMouseEnter = function()\n\
{\n\
this.bIsPointerOver = true;\n\
this.setPointerCursor();\n\
};\n\
\n\
SourceEventElement.prototype.onMouseLeave = function()\n\
{\n\
this.bIsPointerOver = false;\n\
this.setDefaultCursor();\n\
};\n\
\n\
SourceEventElement.prototype.charge = function()\n\
{\n\
this.bClickHandled = false;\n\
this.setPointerCursor();\n\
};\n\
\n\
SourceEventElement.prototype.handleClick = function( /*aMouseEvent*/ )\n\
{\n\
if( !this.bIsPointerOver ) return false;\n\
\n\
if( this.bClickHandled )\n\
return false;\n\
\n\
this.aEventMultiplexer.notifyEvent( EVENT_TRIGGER_ON_CLICK, this.getId() );\n\
aSlideShow.update();\n\
this.bClickHandled = true;\n\
this.setDefaultCursor();\n\
return true;\n\
};\n\
\n\
SourceEventElement.prototype.setPointerCursor = function()\n\
{\n\
if( this.bClickHandled )\n\
return;\n\
\n\
this.aElement.setAttribute( 'style', 'cursor: pointer' );\n\
};\n\
\n\
SourceEventElement.prototype.setDefaultCursor = function()\n\
{\n\
this.aElement.setAttribute( 'style', 'cursor: default' );\n\
};\n\
\n\
\n\
function HyperlinkElement( sId, aEventMultiplexer )\n\
{\n\
var aElement = document.getElementById( sId );\n\
if( !aElement )\n\
{\n\
log( 'error: HyperlinkElement: no element with id: <' + sId + '> found' );\n\
return;\n\
}\n\
if( !aEventMultiplexer )\n\
{\n\
log( 'AnimatedElement constructor: event multiplexer is not valid' );\n\
";

static const char aSVGScript90[] =
"\
}\n\
\n\
this.sId = sId;\n\
this.aElement = aElement;\n\
this.aEventMultiplexer = aEventMultiplexer;\n\
this.nTargetSlideIndex = undefined;\n\
\n\
this.sURL = getNSAttribute( 'xlink', this.aElement, 'href' );\n\
if( this.sURL )\n\
{\n\
if( this.sURL[0] === '#' )\n\
{\n\
if( this.sURL.substr(1, 5) === 'Slide' )\n\
{\n\
var sSlideIndex = this.sURL.split( ' ' )[1];\n\
this.nTargetSlideIndex = parseInt( sSlideIndex ) - 1;\n\
}\n\
}\n\
\n\
this.aEventMultiplexer.registerElementChangedHandler( this.sId, bind2( HyperlinkElement.prototype.onElementChanged, this) );\n\
this.aEventMultiplexer.registerMouseClickHandler( this, 1100 );\n\
\n\
this.bIsPointerOver = false;\n\
this.mouseEnterHandler = bind2( HyperlinkElement.prototype.onMouseEnter, this);\n\
this.mouseLeaveHandler = bind2( HyperlinkElement.prototype.onMouseLeave, this);\n\
this.aElement.addEventListener( 'mouseover', this.mouseEnterHandler, false );\n\
this.aElement.addEventListener( 'mouseout', this.mouseLeaveHandler, false );\n\
}\n\
else\n\
{\n\
log( 'warning: HyperlinkElement(' + this.sId + '): url is empty' );\n\
}\n\
}\n\
\n\
HyperlinkElement.prototype.onElementChanged = function( aElement )\n\
{\n\
if( !aElement )\n\
{\n\
log( 'error: HyperlinkElement: passed element is not valid' );\n\
return;\n\
}\n\
\n\
if( this.sURL )\n\
{\n\
this.aElement.removeEventListener( 'mouseover', this.mouseEnterHandler, false );\n\
this.aElement.removeEventListener( 'mouseout', this.mouseLeaveHandler, false );\n\
this.aElement = aElement;\n\
this.aElement.addEventListener( 'mouseover', this.mouseEnterHandler, false );\n\
this.aElement.addEventListener( 'mouseout', this.mouseLeaveHandler, false );\n\
}\n\
};\n\
\n\
HyperlinkElement.prototype.onMouseEnter = function()\n\
{\n\
this.bIsPointerOver = true;\n\
this.setPointerCursor();\n\
};\n\
\n\
HyperlinkElement.prototype.onMouseLeave = function()\n\
{\n\
this.bIsPointerOver = false;\n\
this.setDefaultCursor();\n\
};\n\
\n\
HyperlinkElement.prototype.handleClick = function( )\n\
{\n\
if( !this.bIsPointerOver ) return false;\n\
\n\
if( this.nTargetSlideIndex !== undefined )\n\
{\n\
aSlideShow.displaySlide( this.nTargetSlideIndex, true );\n\
}\n\
else\n\
{\n\
var aWindowObject = document.defaultView;\n\
if( aWindowObject )\n\
{\n\
aWindowObject.open( this.sURL, this.sId );\n\
}\n\
else\n\
{\n\
log( 'error: HyperlinkElement.handleClick: invalid window object.' );\n\
}\n\
}\n\
\n\
return true;\n\
};\n\
\n\
HyperlinkElement.prototype.setPointerCursor = function()\n\
{\n\
if( this.bClickHandled )\n\
return;\n\
\n\
this.aElement.setAttribute( 'style', 'cursor: pointer' );\n\
};\n\
\n\
HyperlinkElement.prototype.setDefaultCursor = function()\n\
{\n\
this.aElement.setAttribute( 'style', 'cursor: default' );\n\
};\n\
\n\
\n\
function InteractiveAnimationSequence( nId )\n\
{\n\
this.nId = nId;\n\
this.bIsRunning = false;\n\
this.aStartEvent = null;\n\
this.aEndEvent = null;\n\
}\n\
\n\
InteractiveAnimationSequence.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
InteractiveAnimationSequence.prototype.getStartEvent = function()\n\
{\n\
if( !this.aStartEvent )\n\
{\n\
this.aStartEvent =\n\
makeEvent( bind2( InteractiveAnimationSequence.prototype.start, this ) );\n\
}\n\
return this.aStartEvent;\n\
};\n\
\n\
InteractiveAnimationSequence.prototype.getEndEvent = function()\n\
{\n\
if( !this.aEndEvent )\n\
{\n\
this.aEndEvent =\n\
makeEvent( bind2( InteractiveAnimationSequence.prototype.end, this ) );\n\
}\n\
return this.aEndEvent;\n\
};\n\
\n\
InteractiveAnimationSequence.prototype.chargeEvents = function()\n\
{\n\
if( this.aStartEvent )      this.aStartEvent.charge();\n\
if( this.aEndEvent )        this.aEndEvent.charge();\n\
};\n\
\n\
InteractiveAnimationSequence.prototype.isRunning = function()\n\
{\n\
return this.bIsRunning;\n\
};\n\
\n\
InteractiveAnimationSequence.prototype.start = function()\n\
{\n\
aSlideShow.notifyInteractiveAnimationSequenceStart( this.getId() );\n\
this.bIsRunning = true;\n\
";

static const char aSVGScript91[] =
"\
};\n\
\n\
InteractiveAnimationSequence.prototype.end = function()\n\
{\n\
aSlideShow.notifyInteractiveAnimationSequenceEnd( this.getId() );\n\
this.bIsRunning = false;\n\
};\n\
\n\
\n\
function PriorityEntry( aValue, nPriority )\n\
{\n\
this.aValue = aValue;\n\
this.nPriority = nPriority;\n\
}\n\
\n\
PriorityEntry.compare = function( aLhsEntry, aRhsEntry )\n\
{\n\
if ( aLhsEntry.nPriority < aRhsEntry.nPriority )\n\
{\n\
return -1;\n\
}\n\
else if (aLhsEntry.nPriority > aRhsEntry.nPriority)\n\
{\n\
return 1;\n\
}\n\
else\n\
{\n\
return 0;\n\
}\n\
};\n\
\n\
\n\
function EventMultiplexer( aTimerEventQueue )\n\
{\n\
this.nId = EventMultiplexer.getUniqueId();\n\
this.aTimerEventQueue = aTimerEventQueue;\n\
this.aEventMap = {};\n\
this.aAnimationsEndHandler = null;\n\
this.aSkipEffectEndHandlerSet = [];\n\
this.aMouseClickHandlerSet = new PriorityQueue( PriorityEntry.compare );\n\
this.aSkipEffectEvent = null;\n\
this.aRewindCurrentEffectEvent = null;\n\
this.aRewindLastEffectEvent = null;\n\
this.aSkipInteractiveEffectEventSet = {};\n\
this.aRewindRunningInteractiveEffectEventSet = {};\n\
this.aRewindEndedInteractiveEffectEventSet = {};\n\
this.aRewindedEffectHandlerSet = {};\n\
this.aElementChangedHandlerSet = {};\n\
}\n\
\n\
EventMultiplexer.CURR_UNIQUE_ID = 0;\n\
\n\
EventMultiplexer.getUniqueId = function()\n\
{\n\
++EventMultiplexer.CURR_UNIQUE_ID;\n\
return EventMultiplexer.CURR_UNIQUE_ID;\n\
};\n\
\n\
EventMultiplexer.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
EventMultiplexer.prototype.hasRegisteredMouseClickHandlers = function()\n\
{\n\
return !this.aMouseClickHandlerSet.isEmpty();\n\
};\n\
\n\
EventMultiplexer.prototype.registerMouseClickHandler = function( aHandler, nPriority )\n\
{\n\
var aHandlerEntry = new PriorityEntry( aHandler, nPriority );\n\
this.aMouseClickHandlerSet.push( aHandlerEntry );\n\
};\n\
\n\
EventMultiplexer.prototype.notifyMouseClick = function( aMouseEvent )\n\
{\n\
var aMouseClickHandlerSet = this.aMouseClickHandlerSet.clone();\n\
while( !aMouseClickHandlerSet.isEmpty() )\n\
{\n\
var aHandlerEntry = aMouseClickHandlerSet.top();\n\
aMouseClickHandlerSet.pop();\n\
if( aHandlerEntry.aValue.handleClick( aMouseEvent ) )\n\
break;\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerEvent = function( eEventType, aNotifierId, aEvent )\n\
{\n\
this.DBG( 'registerEvent', eEventType, aNotifierId );\n\
if( !this.aEventMap[ eEventType ] )\n\
{\n\
this.aEventMap[ eEventType ] = {};\n\
}\n\
if( !this.aEventMap[ eEventType ][ aNotifierId ] )\n\
{\n\
this.aEventMap[ eEventType ][ aNotifierId ] = [];\n\
}\n\
this.aEventMap[ eEventType ][ aNotifierId ].push( aEvent );\n\
};\n\
\n\
\n\
EventMultiplexer.prototype.notifyEvent = function( eEventType, aNotifierId )\n\
{\n\
this.DBG( 'notifyEvent', eEventType, aNotifierId );\n\
if( this.aEventMap[ eEventType ] )\n\
{\n\
if( this.aEventMap[ eEventType ][ aNotifierId ] )\n\
{\n\
var aEventArray = this.aEventMap[ eEventType ][ aNotifierId ];\n\
var nSize = aEventArray.length;\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
this.aTimerEventQueue.addEvent( aEventArray[i] );\n\
}\n\
}\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerAnimationsEndHandler = function( aHandler )\n\
{\n\
this.aAnimationsEndHandler = aHandler;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyAnimationsEndEvent = function()\n\
{\n\
if( this.aAnimationsEndHandler )\n\
this.aAnimationsEndHandler();\n\
};\n\
\n\
EventMultiplexer.prototype.registerNextEffectEndHandler = function( aHandler )\n\
{\n\
this.aSkipEffectEndHandlerSet.push( aHandler );\n\
};\n\
\n\
EventMultiplexer.prototype.notifyNextEffectEndEvent = function()\n\
{\n\
var nSize = this.aSkipEffectEndHandlerSet.length;\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
(this.aSkipEffectEndHandlerSet[i])();\n\
}\n\
this.aSkipEffectEndHandlerSet = [];\n\
};\n\
\n\
EventMultiplexer.prototype.registerSkipEffectEvent = function( aEvent )\n\
{\n\
this.aSkipEffectEvent = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifySkipEffectEvent = function()\n\
";

static const char aSVGScript92[] =
"\
{\n\
if( this.aSkipEffectEvent )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aSkipEffectEvent );\n\
this.aSkipEffectEvent = null;\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerRewindCurrentEffectEvent = function( aEvent )\n\
{\n\
this.aRewindCurrentEffectEvent = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyRewindCurrentEffectEvent = function()\n\
{\n\
if( this.aRewindCurrentEffectEvent )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aRewindCurrentEffectEvent );\n\
this.aRewindCurrentEffectEvent = null;\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerRewindLastEffectEvent = function( aEvent )\n\
{\n\
this.aRewindLastEffectEvent = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyRewindLastEffectEvent = function()\n\
{\n\
if( this.aRewindLastEffectEvent )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aRewindLastEffectEvent );\n\
this.aRewindLastEffectEvent = null;\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerSkipInteractiveEffectEvent = function( nNotifierId, aEvent )\n\
{\n\
this.aSkipInteractiveEffectEventSet[ nNotifierId ] = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifySkipInteractiveEffectEvent = function( nNotifierId )\n\
{\n\
if( this.aSkipInteractiveEffectEventSet[ nNotifierId ] )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aSkipInteractiveEffectEventSet[ nNotifierId ] );\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerRewindRunningInteractiveEffectEvent = function( nNotifierId, aEvent )\n\
{\n\
this.aRewindRunningInteractiveEffectEventSet[ nNotifierId ] = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyRewindRunningInteractiveEffectEvent = function( nNotifierId )\n\
{\n\
if( this.aRewindRunningInteractiveEffectEventSet[ nNotifierId ] )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aRewindRunningInteractiveEffectEventSet[ nNotifierId ] );\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerRewindEndedInteractiveEffectEvent = function( nNotifierId, aEvent )\n\
{\n\
this.aRewindEndedInteractiveEffectEventSet[ nNotifierId ] = aEvent;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyRewindEndedInteractiveEffectEvent = function( nNotifierId )\n\
{\n\
if( this.aRewindEndedInteractiveEffectEventSet[ nNotifierId ] )\n\
{\n\
this.aTimerEventQueue.addEvent( this.aRewindEndedInteractiveEffectEventSet[ nNotifierId ] );\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerRewindedEffectHandler = function( aNotifierId, aHandler )\n\
{\n\
this.aRewindedEffectHandlerSet[ aNotifierId ] = aHandler;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyRewindedEffectEvent = function( aNotifierId )\n\
{\n\
if( this.aRewindedEffectHandlerSet[ aNotifierId ] )\n\
{\n\
(this.aRewindedEffectHandlerSet[ aNotifierId ])();\n\
}\n\
};\n\
\n\
EventMultiplexer.prototype.registerElementChangedHandler = function( aNotifierId, aHandler )\n\
{\n\
this.aElementChangedHandlerSet[ aNotifierId ] = aHandler;\n\
};\n\
\n\
EventMultiplexer.prototype.notifyElementChangedEvent = function( aNotifierId, aElement )\n\
{\n\
if( this.aElementChangedHandlerSet[ aNotifierId ] )\n\
{\n\
(this.aElementChangedHandlerSet[ aNotifierId ])( aElement );\n\
}\n\
};\n\
\n\
EventMultiplexer.DEBUG = aEventMultiplexerDebugPrinter.isEnabled();\n\
\n\
EventMultiplexer.prototype.DBG = function( sMethodName, eEventType, aNotifierId, nTime )\n\
{\n\
if( EventMultiplexer.DEBUG )\n\
{\n\
var sInfo = 'EventMultiplexer.' + sMethodName;\n\
sInfo += '( type: ' + aEventTriggerOutMap[ eEventType ];\n\
sInfo += ', notifier: ' + aNotifierId + ' )';\n\
aEventMultiplexerDebugPrinter.print( sInfo, nTime );\n\
}\n\
};\n\
\n\
\n\
var aInterpolatorHandler = {};\n\
\n\
aInterpolatorHandler.getInterpolator = function( eCalcMode, eValueType, eValueSubtype )\n\
{\n\
var bHasSubtype = ( typeof( eValueSubtype ) === typeof( 0 ) );\n\
\n\
if( !bHasSubtype && aInterpolatorHandler.aLerpFunctorMap[ eCalcMode ][ eValueType ] )\n\
{\n\
return aInterpolatorHandler.aLerpFunctorMap[ eCalcMode ][ eValueType ];\n\
}\n\
else if( bHasSubtype && aInterpolatorHandler.aLerpFunctorMap[ eCalcMode ][ eValueType ][ eValueSubtype ] )\n\
{\n\
return aInterpolatorHandler.aLerpFunctorMap[ eCalcMode ][ eValueType ][ eValueSubtype ];\n\
}\n\
else\n\
{\n\
log( 'aInterpolatorHandler.getInterpolator: not found any valid interpolator for calc mode '\n\
+ aCalcModeOutMap[eCalcMode]  + ' and value type ' + aValueTypeOutMap[eValueType]  );\n\
return null;\n\
}\n\
};\n\
\n\
aInterpolatorHandler.aLerpFunctorMap = [];\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_DISCRETE ] = [];\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ] = [];\n\
\n\
\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ][ NUMBER_PROPERTY ] =\n\
function ( nFrom, nTo, nT )\n\
{\n\
return ( ( 1.0 - nT )* nFrom + nT * nTo );\n\
};\n\
\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ][ COLOR_PROPERTY ] = [];\n\
\n\
";

static const char aSVGScript93[] =
"\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ][ COLOR_PROPERTY ][ COLOR_SPACE_RGB ] =\n\
function ( nFrom, nTo, nT )\n\
{\n\
return RGBColor.interpolate( nFrom, nTo, nT );\n\
};\n\
\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ][ COLOR_PROPERTY ][ COLOR_SPACE_HSL ] =\n\
function ( bCCW  )\n\
{\n\
return  function ( nFrom, nTo, nT )\n\
{\n\
return HSLColor.interpolate( nFrom, nTo, nT, bCCW );\n\
};\n\
};\n\
\n\
aInterpolatorHandler.aLerpFunctorMap[ CALC_MODE_LINEAR ][ TUPLE_NUMBER_PROPERTY ] =\n\
function ( aFrom, aTo, nT )\n\
{\n\
var aRes = [];\n\
for( var i = 0; i < aFrom.length; ++i )\n\
{\n\
aRes.push( ( 1.0 - nT )* aFrom[i] + nT * aTo[i] );\n\
}\n\
return aRes;\n\
};\n\
\n\
\n\
function KeyStopLerp( aValueList )\n\
{\n\
KeyStopLerp.validateInput( aValueList );\n\
\n\
this.aKeyStopList = [];\n\
this.nLastIndex = 0;\n\
this.nKeyStopDistance = aValueList[1] - aValueList[0];\n\
if( this.nKeyStopDistance <= 0 )\n\
this.nKeyStopDistance = 0.001;\n\
\n\
for( var i = 0; i < aValueList.length; ++i )\n\
this.aKeyStopList.push( aValueList[i] );\n\
\n\
this.nUpperBoundIndex = this.aKeyStopList.length - 2;\n\
}\n\
\n\
\n\
KeyStopLerp.validateInput = function( aValueList )\n\
{\n\
var nSize = aValueList.length;\n\
assert( nSize > 1, 'KeyStopLerp.validateInput: key stop vector must have two entries or more' );\n\
\n\
for( var i = 1; i < nSize; ++i )\n\
{\n\
if( aValueList[i-1] > aValueList[i] )\n\
log( 'KeyStopLerp.validateInput: time vector is not sorted in ascending order!' );\n\
}\n\
};\n\
\n\
KeyStopLerp.prototype.reset = function()\n\
{\n\
KeyStopLerp.validateInput( this.aKeyStopList );\n\
this.nLastIndex = 0;\n\
this.nKeyStopDistance = this.aKeyStopList[1] - this.aKeyStopList[0];\n\
if( this.nKeyStopDistance <= 0 )\n\
this.nKeyStopDistance = 0.001;\n\
\n\
};\n\
\n\
KeyStopLerp.prototype.lerp = function( nAlpha )\n\
{\n\
if( nAlpha > this.aKeyStopList[ this.nLastIndex + 1 ] )\n\
{\n\
do\n\
{\n\
var nIndex = this.nLastIndex + 1;\n\
this.nLastIndex = clamp( nIndex, 0, this.nUpperBoundIndex );\n\
this.nKeyStopDistance = this.aKeyStopList[ this.nLastIndex + 1 ] - this.aKeyStopList[ this.nLastIndex ];\n\
}\n\
while( ( this.nKeyStopDistance <= 0 ) && ( this.nLastIndex < this.nUpperBoundIndex ) );\n\
}\n\
\n\
var nRawLerp = ( nAlpha - this.aKeyStopList[ this.nLastIndex ] ) / this.nKeyStopDistance;\n\
\n\
nRawLerp = clamp( nRawLerp, 0.0, 1.0 );\n\
\n\
var aResult = {};\n\
aResult.nIndex = this.nLastIndex;\n\
aResult.nLerp = nRawLerp;\n\
\n\
return aResult;\n\
};\n\
\n\
KeyStopLerp.prototype.lerp_ported = function( nAlpha )\n\
{\n\
if( ( this.aKeyStopList[ this.nLastIndex ] < nAlpha ) ||\n\
( this.aKeyStopList[ this.nLastIndex + 1 ] >= nAlpha ) )\n\
{\n\
var i = 0;\n\
for( ; i < this.aKeyStopList.length; ++i )\n\
{\n\
if( this.aKeyStopList[i] >= nAlpha )\n\
break;\n\
}\n\
if( this.aKeyStopList[i] > nAlpha )\n\
--i;\n\
var nIndex = i - 1;\n\
this.nLastIndex = clamp( nIndex, 0, this.aKeyStopList.length - 2 );\n\
}\n\
\n\
var nRawLerp = ( nAlpha - this.aKeyStopList[ this.nLastIndex ] ) /\n\
( this.aKeyStopList[ this.nLastIndex+1 ] - this.aKeyStopList[ this.nLastIndex ] );\n\
\n\
nRawLerp = clamp( nRawLerp, 0.0, 1.0 );\n\
\n\
var aResult = {};\n\
aResult.nIndex = this.nLastIndex;\n\
aResult.nLerp = nRawLerp;\n\
\n\
return aResult;\n\
};\n\
\n\
\n\
var aOperatorSetMap = [];\n\
\n\
aOperatorSetMap[ NUMBER_PROPERTY ] = {};\n\
\n\
aOperatorSetMap[ NUMBER_PROPERTY ].equal = function( a, b )\n\
{\n\
return ( a === b );\n\
};\n\
\n\
aOperatorSetMap[ NUMBER_PROPERTY ].add = function( a, b )\n\
{\n\
return ( a + b );\n\
};\n\
\n\
aOperatorSetMap[ NUMBER_PROPERTY ].scale = function( k, v )\n\
{\n\
return ( k * v );\n\
};\n\
\n\
aOperatorSetMap[ COLOR_PROPERTY ] = {};\n\
\n\
aOperatorSetMap[ COLOR_PROPERTY ].equal = function( a, b )\n\
{\n\
return a.equal( b );\n\
};\n\
\n\
aOperatorSetMap[ COLOR_PROPERTY ].add = function( a, b )\n\
{\n\
var c = a.clone();\n\
c.add( b );\n\
";

static const char aSVGScript94[] =
"\
return c;\n\
};\n\
\n\
aOperatorSetMap[ COLOR_PROPERTY ].scale = function( k, v )\n\
{\n\
var r = v.clone();\n\
r.scale( k );\n\
return r;\n\
};\n\
\n\
aOperatorSetMap[ ENUM_PROPERTY ] = {};\n\
\n\
aOperatorSetMap[ ENUM_PROPERTY ].equal = function( a, b )\n\
{\n\
return ( a === b );\n\
};\n\
\n\
aOperatorSetMap[ ENUM_PROPERTY ].add = function( a )\n\
{\n\
return a;\n\
};\n\
\n\
aOperatorSetMap[ ENUM_PROPERTY ].scale = function( k, v )\n\
{\n\
return v;\n\
};\n\
\n\
aOperatorSetMap[ STRING_PROPERTY ] = aOperatorSetMap[ ENUM_PROPERTY ];\n\
\n\
aOperatorSetMap[ BOOL_PROPERTY ] = aOperatorSetMap[ ENUM_PROPERTY ];\n\
\n\
aOperatorSetMap[ TUPLE_NUMBER_PROPERTY ] = {};\n\
\n\
aOperatorSetMap[ TUPLE_NUMBER_PROPERTY ].equal = function( a, b )\n\
{\n\
assert( a.length === b.length, 'Tuples length mismatch.' );\n\
return ( a.toString() === b.toString() );\n\
};\n\
\n\
aOperatorSetMap[ TUPLE_NUMBER_PROPERTY ].add = function( a, b )\n\
{\n\
assert( a.length === b.length, 'Tuples length mismatch.' );\n\
var r = [];\n\
for( var i = 0; i < a.length; ++i )\n\
{\n\
r.push(a[i] + b[i]);\n\
}\n\
return r;\n\
};\n\
\n\
aOperatorSetMap[ TUPLE_NUMBER_PROPERTY ].scale = function( k, v )\n\
{\n\
var r = [];\n\
for( var i = 0; i < v.length; ++i )\n\
{\n\
r.push(k * v[i]);\n\
}\n\
return r;\n\
};\n\
\n\
\n\
function ActivityParamSet()\n\
{\n\
this.aEndEvent = null;\n\
this.aWakeupEvent = null;\n\
this.aTimerEventQueue = null;\n\
this.aActivityQueue = null;\n\
this.nMinDuration = undefined;\n\
this.nMinNumberOfFrames = MINIMUM_FRAMES_PER_SECONDS;\n\
this.bAutoReverse = false;\n\
this.nRepeatCount = 1.0;\n\
this.nAccelerationFraction = 0.0;\n\
this.nDecelerationFraction = 0.0;\n\
this.nSlideWidth = undefined;\n\
this.nSlideHeight = undefined;\n\
this.aFormula = null;\n\
this.aDiscreteTimes = [];\n\
}\n\
\n\
\n\
function AnimationActivity()\n\
{\n\
this.nId = AnimationActivity.getUniqueId();\n\
}\n\
\n\
\n\
AnimationActivity.CURR_UNIQUE_ID = 0;\n\
\n\
AnimationActivity.getUniqueId = function()\n\
{\n\
++AnimationActivity.CURR_UNIQUE_ID;\n\
return AnimationActivity.CURR_UNIQUE_ID;\n\
};\n\
\n\
AnimationActivity.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
\n\
function SetActivity( aCommonParamSet, aAnimation, aToAttr  )\n\
{\n\
SetActivity.superclass.constructor.call( this );\n\
\n\
this.aAnimation = aAnimation;\n\
this.aTargetElement = null;\n\
this.aEndEvent = aCommonParamSet.aEndEvent;\n\
this.aTimerEventQueue = aCommonParamSet.aTimerEventQueue;\n\
this.aToAttr = aToAttr;\n\
this.bIsActive = true;\n\
}\n\
extend( SetActivity, AnimationActivity );\n\
\n\
\n\
SetActivity.prototype.activate = function( aEndEvent )\n\
{\n\
this.aEndEvent = aEndEvent;\n\
this.bIsActive = true;\n\
};\n\
\n\
SetActivity.prototype.dispose = function()\n\
{\n\
this.bIsActive = false;\n\
if( this.aEndEvent && this.aEndEvent.isCharged() )\n\
this.aEndEvent.dispose();\n\
};\n\
\n\
SetActivity.prototype.calcTimeLag = function()\n\
{\n\
return 0.0;\n\
};\n\
\n\
SetActivity.prototype.perform = function()\n\
{\n\
if( !this.isActive() )\n\
return false;\n\
\n\
this.bIsActive = false;\n\
\n\
if( this.aAnimation && this.aTargetElement )\n\
{\n\
this.aAnimation.start( this.aTargetElement );\n\
this.aAnimation.perform( this.aToAttr );\n\
this.aAnimation.end();\n\
}\n\
\n\
if( this.aEndEvent )\n\
this.aTimerEventQueue.addEvent( this.aEndEvent );\n\
\n\
};\n\
";

static const char aSVGScript95[] =
"\
\n\
SetActivity.prototype.isActive = function()\n\
{\n\
return this.bIsActive;\n\
};\n\
\n\
SetActivity.prototype.dequeued = function()\n\
{\n\
};\n\
\n\
SetActivity.prototype.end = function()\n\
{\n\
this.perform();\n\
};\n\
\n\
SetActivity.prototype.setTargets = function( aTargetElement )\n\
{\n\
assert( aTargetElement, 'SetActivity.setTargets: target element is not valid' );\n\
this.aTargetElement = aTargetElement;\n\
};\n\
\n\
\n\
function ActivityBase( aCommonParamSet )\n\
{\n\
ActivityBase.superclass.constructor.call( this );\n\
\n\
this.aTargetElement = null;\n\
this.aEndEvent = aCommonParamSet.aEndEvent;\n\
this.aTimerEventQueue = aCommonParamSet.aTimerEventQueue;\n\
this.nRepeats = aCommonParamSet.nRepeatCount;\n\
this.nAccelerationFraction = aCommonParamSet.nAccelerationFraction;\n\
this.nDecelerationFraction = aCommonParamSet.nDecelerationFraction;\n\
this.bAutoReverse = aCommonParamSet.bAutoReverse;\n\
\n\
this.bFirstPerformCall = true;\n\
this.bIsActive = true;\n\
\n\
}\n\
extend( ActivityBase, AnimationActivity );\n\
\n\
\n\
ActivityBase.prototype.activate = function( aEndEvent )\n\
{\n\
this.aEndEvent = aEndEvent;\n\
this.bFirstPerformCall = true;\n\
this.bIsActive = true;\n\
};\n\
\n\
ActivityBase.prototype.dispose = function()\n\
{\n\
this.bIsActive = false;\n\
\n\
if( this.aEndEvent )\n\
this.aEndEvent.dispose();\n\
\n\
this.aEndEvent = null;\n\
};\n\
\n\
ActivityBase.prototype.perform = function()\n\
{\n\
if( !this.isActive() )\n\
return false; // no, early exit.\n\
\n\
assert( !this.bFirstPerformCall, 'ActivityBase.perform: assertion (!this.FirstPerformCall) failed' );\n\
\n\
return true;\n\
};\n\
\n\
ActivityBase.prototype.calcTimeLag = function()\n\
{\n\
if( this.isActive() && this.bFirstPerformCall )\n\
{\n\
this.bFirstPerformCall = false;\n\
\n\
this.startAnimation();\n\
}\n\
return 0.0;\n\
};\n\
\n\
ActivityBase.prototype.isActive = function()\n\
{\n\
return this.bIsActive;\n\
};\n\
\n\
ActivityBase.prototype.isDisposed = function()\n\
{\n\
return ( !this.bIsActive && !this.aEndEvent );\n\
};\n\
\n\
ActivityBase.prototype.dequeued = function()\n\
{\n\
if( !this.isActive() )\n\
this.endAnimation();\n\
};\n\
\n\
ActivityBase.prototype.setTargets = function( aTargetElement )\n\
{\n\
assert( aTargetElement, 'ActivityBase.setTargets: target element is not valid' );\n\
\n\
this.aTargetElement = aTargetElement;\n\
};\n\
\n\
ActivityBase.prototype.startAnimation = function()\n\
{\n\
throw ( 'ActivityBase.startAnimation: abstract method invoked' );\n\
};\n\
\n\
ActivityBase.prototype.endAnimation = function()\n\
{\n\
throw ( 'ActivityBase.endAnimation: abstract method invoked' );\n\
};\n\
\n\
ActivityBase.prototype.endActivity = function()\n\
{\n\
this.bIsActive = false;\n\
\n\
if( this.aEndEvent )\n\
this.aTimerEventQueue.addEvent( this.aEndEvent );\n\
\n\
this.aEndEvent = null;\n\
\n\
};\n\
\n\
ActivityBase.prototype.calcAcceleratedTime = function( nT )\n\
{\n\
\n\
\n\
nT = clamp( nT, 0.0, 1.0 );\n\
\n\
if( ( this.nAccelerationFraction > 0.0 || this.nDecelerationFraction > 0.0 ) &&\n\
( this.nAccelerationFraction + this.nDecelerationFraction <= 1.0 ) )\n\
{\n\
var nC = 1.0 - 0.5*this.nAccelerationFraction - 0.5*this.nDecelerationFraction;\n\
\n\
var nTPrime = 0.0;\n\
\n\
if( nT < this.nAccelerationFraction )\n\
{\n\
nTPrime += 0.5 * nT * nT / this.nAccelerationFraction; // partial first interval\n\
}\n\
else\n\
{\n\
nTPrime += 0.5 * this.nAccelerationFraction; // full first interval\n\
\n\
if( nT <= ( 1.0 - this.nDecelerationFraction ) )\n\
{\n\
nTPrime += nT - this.nAccelerationFraction; // partial second interval\n\
}\n\
else\n\
{\n\
";

static const char aSVGScript96[] =
"\
nTPrime += 1.0 - this.nAccelerationFraction - this.nDecelerationFraction; // full second interval\n\
\n\
var nTRelative = nT - 1.0 + this.nDecelerationFraction;\n\
\n\
nTPrime += nTRelative - 0.5*nTRelative*nTRelative / this.nDecelerationFraction;\n\
}\n\
}\n\
\n\
nT = nTPrime / nC;\n\
\n\
}\n\
return nT;\n\
};\n\
\n\
ActivityBase.prototype.getEventQueue = function()\n\
{\n\
return this.aTimerEventQueue;\n\
};\n\
\n\
ActivityBase.prototype.getTargetElement = function()\n\
{\n\
return this.aTargetElement;\n\
};\n\
\n\
ActivityBase.prototype.isRepeatCountValid = function()\n\
{\n\
return !!this.nRepeats; // first ! convert to bool\n\
};\n\
\n\
ActivityBase.prototype.getRepeatCount = function()\n\
{\n\
return this.nRepeats;\n\
};\n\
\n\
ActivityBase.prototype.isAutoReverse = function()\n\
{\n\
return this.bAutoReverse;\n\
};\n\
\n\
ActivityBase.prototype.end = function()\n\
{\n\
if( !this.isActive() || this.isDisposed() )\n\
return;\n\
\n\
if( this.bFirstPerformCall )\n\
{\n\
this.bFirstPerformCall = false;\n\
this.startAnimation();\n\
}\n\
\n\
this.performEnd();\n\
this.endAnimation();\n\
this.endActivity();\n\
};\n\
\n\
ActivityBase.prototype.performEnd = function()\n\
{\n\
throw ( 'ActivityBase.performEnd: abstract method invoked' );\n\
};\n\
\n\
\n\
function DiscreteActivityBase( aCommonParamSet )\n\
{\n\
DiscreteActivityBase.superclass.constructor.call( this, aCommonParamSet );\n\
\n\
this.aOriginalWakeupEvent = aCommonParamSet.aWakeupEvent;\n\
this.aOriginalWakeupEvent.setActivity( this );\n\
this.aWakeupEvent = this.aOriginalWakeupEvent;\n\
this.aWakeupEvent = aCommonParamSet.aWakeupEvent;\n\
this.aDiscreteTimes = aCommonParamSet.aDiscreteTimes;\n\
this.nMinSimpleDuration = aCommonParamSet.nMinDuration;\n\
this.nCurrPerformCalls = 0;\n\
}\n\
extend( DiscreteActivityBase, ActivityBase );\n\
\n\
\n\
DiscreteActivityBase.prototype.activate = function( aEndElement )\n\
{\n\
DiscreteActivityBase.superclass.activate.call( this, aEndElement );\n\
\n\
this.aWakeupEvent = this.aOriginalWakeupEvent;\n\
this.aWakeupEvent.setNextTimeout( 0 );\n\
this.nCurrPerformCalls = 0;\n\
};\n\
\n\
DiscreteActivityBase.prototype.startAnimation = function()\n\
{\n\
this.aWakeupEvent.start();\n\
};\n\
\n\
DiscreteActivityBase.prototype.calcFrameIndex = function( nCurrCalls, nVectorSize )\n\
{\n\
if( this.isAutoReverse() )\n\
{\n\
var nFrameIndex = nCurrCalls % (2 * nVectorSize);\n\
\n\
if( nFrameIndex >= nVectorSize )\n\
nFrameIndex = 2*nVectorSize - nFrameIndex; // invert sweep\n\
\n\
return nFrameIndex;\n\
}\n\
else\n\
{\n\
return nCurrCalls % nVectorSize;\n\
}\n\
};\n\
\n\
DiscreteActivityBase.prototype.calcRepeatCount = function( nCurrCalls, nVectorSize )\n\
{\n\
if( this.isAutoReverse() )\n\
{\n\
return Math.floor( nCurrCalls / (2*nVectorSize) ); // we've got 2 cycles per repeat\n\
}\n\
else\n\
{\n\
return Math.floor( nCurrCalls / nVectorSize );\n\
}\n\
};\n\
\n\
DiscreteActivityBase.prototype.performDiscreteHook = function( /*nFrame, nRepeatCount*/ )\n\
{\n\
throw ( 'DiscreteActivityBase.performDiscreteHook: abstract method invoked' );\n\
};\n\
\n\
DiscreteActivityBase.prototype.perform = function()\n\
{\n\
if( !SimpleContinuousActivityBase.superclass.perform.call( this ) )\n\
return false; // done, we're ended\n\
\n\
var nVectorSize = this.aDiscreteTimes.length;\n\
\n\
var nFrameIndex = this.calcFrameIndex(this.nCurrPerformCalls, nVectorSize);\n\
var nRepeatCount = this.calcRepeatCount( this.nCurrPerformCalls, nVectorSize );\n\
this.performDiscreteHook( nFrameIndex, nRepeatCount );\n\
\n\
++this.nCurrPerformCalls;\n\
\n\
var nCurrRepeat = this.nCurrPerformCalls / nVectorSize;\n\
\n\
if( this.isAutoReverse() )\n\
nCurrRepeat /= 2;\n\
\n\
if( !this.isRepeatCountValid() || nCurrRepeat < this.getRepeatCount() )\n\
{\n\
\n\
\n\
nFrameIndex = this.calcFrameIndex(this.nCurrPerformCalls, nVectorSize);\n\
var nCurrentRepeatTime = this.aDiscreteTimes[nFrameIndex];\n\
nRepeatCount = this.calcRepeatCount( this.nCurrPerformCalls, nVectorSize );\n\
var nNextTimeout = this.nMinSimpleDuration * ( nRepeatCount + this.calcAcceleratedTime( nCurrentRepeatTime ) );\n\
";

static const char aSVGScript97[] =
"\
this.aWakeupEvent.setNextTimeout( nNextTimeout );\n\
\n\
this.getEventQueue().addEvent( this.aWakeupEvent );\n\
}\n\
else\n\
{\n\
this.aWakeupEvent = null;\n\
\n\
this.endActivity();\n\
}\n\
\n\
return false; // remove from queue, will be added back by the wakeup event.\n\
};\n\
\n\
DiscreteActivityBase.prototype.dispose = function()\n\
{\n\
if( this.aWakeupEvent )\n\
this.aWakeupEvent.dispose();\n\
\n\
this.aWakeupEvent = null;\n\
\n\
DiscreteActivityBase.superclass.dispose.call(this);\n\
};\n\
\n\
\n\
function SimpleContinuousActivityBase( aCommonParamSet )\n\
{\n\
SimpleContinuousActivityBase.superclass.constructor.call( this, aCommonParamSet );\n\
\n\
this.aTimer = new ElapsedTime( aCommonParamSet.aActivityQueue.getTimer() );\n\
this.nMinSimpleDuration = aCommonParamSet.nMinDuration;\n\
this.nMinNumberOfFrames = aCommonParamSet.nMinNumberOfFrames;\n\
this.nCurrPerformCalls = 0;\n\
\n\
}\n\
extend( SimpleContinuousActivityBase, ActivityBase );\n\
\n\
\n\
SimpleContinuousActivityBase.prototype.startAnimation = function()\n\
{\n\
this.aTimer.reset();\n\
};\n\
\n\
SimpleContinuousActivityBase.prototype.calcTimeLag = function()\n\
{\n\
SimpleContinuousActivityBase.superclass.calcTimeLag.call( this );\n\
\n\
if( !this.isActive() )\n\
return 0.0;\n\
\n\
var nCurrElapsedTime = this.aTimer.getElapsedTime();\n\
\n\
\n\
var nFractionElapsedTime = nCurrElapsedTime / this.nMinSimpleDuration;\n\
\n\
var nFractionRequiredCalls = this.nCurrPerformCalls / this.nMinNumberOfFrames;\n\
\n\
\n\
if( nFractionElapsedTime < nFractionRequiredCalls )\n\
{\n\
return 0.0;\n\
}\n\
else\n\
{\n\
return ( ( nFractionElapsedTime - nFractionRequiredCalls ) * this.nMinSimpleDuration );\n\
}\n\
};\n\
\n\
SimpleContinuousActivityBase.prototype.perform = function()\n\
{\n\
if( !SimpleContinuousActivityBase.superclass.perform.call( this ) )\n\
return false; // done, we're ended\n\
\n\
var nCurrElapsedTime = this.aTimer.getElapsedTime();\n\
var nT = nCurrElapsedTime / this.nMinSimpleDuration;\n\
\n\
\n\
var bActivityEnding = false;\n\
\n\
if( this.isRepeatCountValid() )\n\
{\n\
\n\
var nRepeatCount = this.getRepeatCount();\n\
var nEffectiveRepeat = this.isAutoReverse() ? 2.0 * nRepeatCount : nRepeatCount;\n\
\n\
if( nEffectiveRepeat <= nT )\n\
{\n\
bActivityEnding = true;\n\
\n\
nT = nEffectiveRepeat;\n\
}\n\
}\n\
\n\
\n\
var nRepeats;\n\
var nRelativeSimpleTime;\n\
if( this.isAutoReverse() )\n\
{\n\
nRepeats = Math.floor( nT );\n\
var nFractionalActiveDuration =  nT - nRepeats;\n\
\n\
if( nRepeats % 2 )\n\
{\n\
nRelativeSimpleTime = 1.0 - nFractionalActiveDuration;\n\
}\n\
else\n\
{\n\
nRelativeSimpleTime = nFractionalActiveDuration;\n\
}\n\
\n\
nRepeats /= 2;\n\
}\n\
else\n\
{\n\
\n\
nRepeats = Math.floor( nT );\n\
nRelativeSimpleTime = nT - nRepeats;\n\
\n\
if( this.isRepeatCountValid() && ( nRepeats >= this.getRepeatCount() ) )\n\
{\n\
\n\
nRelativeSimpleTime = 1.0;\n\
nRepeats -= 1.0;\n\
}\n\
}\n\
\n\
\n\
this.simplePerform( nRelativeSimpleTime, nRepeats );\n\
\n\
if( bActivityEnding )\n\
this.endActivity();\n\
\n\
++this.nCurrPerformCalls;\n\
\n\
return this.isActive();\n\
};\n\
\n\
SimpleContinuousActivityBase.prototype.simplePerform = function( /*nSimpleTime, nRepeatCount*/ )\n\
{\n\
throw ( 'SimpleContinuousActivityBase.simplePerform: abstract method invoked' );\n\
};\n\
\n\
\n\
function ContinuousKeyTimeActivityBase( aCommonParamSet )\n\
{\n\
var nSize = aCommonParamSet.aDiscreteTimes.length;\n\
assert( nSize > 1,\n\
'ContinuousKeyTimeActivityBase constructor: assertion (aDiscreteTimes.length > 1) failed' );\n\
\n\
assert( aCommonParamSet.aDiscreteTimes[0] == 0.0,\n\
";

static const char aSVGScript98[] =
"\
'ContinuousKeyTimeActivityBase constructor: assertion (aDiscreteTimes.front() == 0.0) failed' );\n\
\n\
assert( aCommonParamSet.aDiscreteTimes[ nSize - 1 ] <= 1.0,\n\
'ContinuousKeyTimeActivityBase constructor: assertion (aDiscreteTimes.back() <= 1.0) failed' );\n\
\n\
ContinuousKeyTimeActivityBase.superclass.constructor.call( this, aCommonParamSet );\n\
\n\
this.aLerper = new KeyStopLerp( aCommonParamSet.aDiscreteTimes );\n\
}\n\
extend( ContinuousKeyTimeActivityBase, SimpleContinuousActivityBase );\n\
\n\
\n\
ContinuousKeyTimeActivityBase.prototype.activate = function( aEndElement )\n\
{\n\
ContinuousKeyTimeActivityBase.superclass.activate.call( this, aEndElement );\n\
\n\
this.aLerper.reset();\n\
};\n\
\n\
ContinuousKeyTimeActivityBase.prototype.performContinuousHook = function( /*nIndex, nFractionalIndex, nRepeatCount*/ )\n\
{\n\
throw ( 'ContinuousKeyTimeActivityBase.performContinuousHook: abstract method invoked' );\n\
};\n\
\n\
ContinuousKeyTimeActivityBase.prototype.simplePerform = function( nSimpleTime, nRepeatCount )\n\
{\n\
var nAlpha = this.calcAcceleratedTime( nSimpleTime );\n\
\n\
var aLerpResult = this.aLerper.lerp( nAlpha );\n\
\n\
this.performContinuousHook( aLerpResult.nIndex, aLerpResult.nLerp, nRepeatCount );\n\
};\n\
\n\
\n\
function ContinuousActivityBase( aCommonParamSet )\n\
{\n\
ContinuousActivityBase.superclass.constructor.call( this, aCommonParamSet );\n\
\n\
}\n\
extend( ContinuousActivityBase, SimpleContinuousActivityBase );\n\
\n\
\n\
ContinuousActivityBase.prototype.performContinuousHook = function( /*nModifiedTime, nRepeatCount*/ )\n\
{\n\
throw ( 'ContinuousActivityBase.performContinuousHook: abstract method invoked' );\n\
};\n\
\n\
ContinuousActivityBase.prototype.simplePerform = function( nSimpleTime, nRepeatCount )\n\
{\n\
this.performContinuousHook( this.calcAcceleratedTime( nSimpleTime ), nRepeatCount );\n\
};\n\
\n\
\n\
function SimpleActivity( aCommonParamSet, aNumberAnimation, eDirection )\n\
{\n\
assert( ( eDirection == BACKWARD ) || ( eDirection == FORWARD ),\n\
'SimpleActivity constructor: animation direction is not valid' );\n\
\n\
assert( aNumberAnimation, 'SimpleActivity constructor: animation object is not valid' );\n\
\n\
SimpleActivity.superclass.constructor.call( this, aCommonParamSet );\n\
\n\
this.aAnimation = aNumberAnimation;\n\
this.nDirection = ( eDirection == FORWARD ) ? 1.0 : 0.0;\n\
}\n\
extend( SimpleActivity, ContinuousActivityBase );\n\
\n\
\n\
SimpleActivity.prototype.startAnimation = function()\n\
{\n\
if( this.isDisposed() || !this.aAnimation )\n\
return;\n\
\n\
ANIMDBG.print( 'SimpleActivity.startAnimation invoked' );\n\
SimpleActivity.superclass.startAnimation.call( this );\n\
\n\
this.aAnimation.start( this.getTargetElement() );\n\
};\n\
\n\
SimpleActivity.prototype.endAnimation = function()\n\
{\n\
if( this.aAnimation )\n\
this.aAnimation.end();\n\
\n\
};\n\
\n\
SimpleActivity.prototype.performContinuousHook = function( nModifiedTime /*, nRepeatCount*/ )\n\
{\n\
\n\
if( this.isDisposed() || !this.aAnimation )\n\
return;\n\
\n\
var nT = 1.0 - this.nDirection + nModifiedTime * ( 2.0*this.nDirection - 1.0 );\n\
this.aAnimation.perform( nT );\n\
};\n\
\n\
SimpleActivity.prototype.performEnd = function()\n\
{\n\
if( this.aAnimation )\n\
this.aAnimation.perform( this.nDirection );\n\
};\n\
\n\
\n\
function FromToByActivityTemplate( BaseType ) // template parameter\n\
{\n\
\n\
function FromToByActivity( aFromValue, aToValue, aByValue,\n\
aActivityParamSet, aAnimation,\n\
aInterpolator, aOperatorSet, bAccumulate )\n\
{\n\
assert( aAnimation, 'FromToByActivity constructor: invalid animation object' );\n\
assert( ( aToValue != undefined ) || ( aByValue != undefined ),\n\
'FromToByActivity constructor: one of aToValue or aByValue must be valid' );\n\
\n\
FromToByActivity.superclass.constructor.call( this, aActivityParamSet );\n\
\n\
this.aFrom = aFromValue;\n\
this.aTo = aToValue;\n\
this.aBy = aByValue;\n\
this.aStartValue = null;\n\
this.aEndValue = null;\n\
this.aPreviousValue = null;\n\
this.aStartInterpolationValue = null;\n\
this.aAnimation = aAnimation;\n\
this.aInterpolator = aInterpolator;\n\
this.equal = aOperatorSet.equal;\n\
this.add = aOperatorSet.add;\n\
this.scale = aOperatorSet.scale;\n\
this.bDynamicStartValue = false;\n\
this.nIteration = 0;\n\
this.bCumulative = bAccumulate;\n\
this.aFormula = aActivityParamSet.aFormula;\n\
}\n\
extend( FromToByActivity, BaseType );\n\
\n\
FromToByActivity.prototype.initAnimatedElement = function()\n\
{\n\
if( this.aAnimation && this.aFrom )\n\
{\n\
var aValue = this.aFormula ? this.aFormula( this.aFrom ) : this.aFrom;\n\
this.aAnimation.perform(aValue);\n\
}\n\
};\n\
\n\
FromToByActivity.prototype.startAnimation = function()\n\
{\n\
if( this.isDisposed() || !this.aAnimation  )\n\
{\n\
log( 'FromToByActivity.startAnimation: activity disposed or not valid animation' );\n\
return;\n\
";

static const char aSVGScript99[] =
"\
}\n\
\n\
FromToByActivity.superclass.startAnimation.call( this );\n\
\n\
this.aAnimation.start( this.getTargetElement() );\n\
\n\
\n\
var aAnimationStartValue = this.aAnimation.getUnderlyingValue();\n\
\n\
if( this.aFrom )\n\
{\n\
if( this.aTo )\n\
{\n\
this.aStartValue = this.aFrom;\n\
this.aEndValue = this.aTo;\n\
}\n\
else if( this.aBy )\n\
{\n\
this.aStartValue = this.aFrom;\n\
\n\
this.aEndValue = this.add( this.aStartValue, this.aBy );\n\
}\n\
}\n\
else\n\
{\n\
this.aStartValue = aAnimationStartValue;\n\
this.aStartInterpolationValue = this.aStartValue;\n\
\n\
if( this.aTo )\n\
{\n\
\n\
this.bDynamicStartValue = true;\n\
this.aPreviousValue = this.aStartValue;\n\
this.aEndValue = this.aTo;\n\
}\n\
else if( this.aBy )\n\
{\n\
this.aStartValue = aAnimationStartValue;\n\
\n\
this.aEndValue = this.add( this.aStartValue, this.aBy );\n\
}\n\
}\n\
\n\
ANIMDBG.print( 'FromToByActivity.startAnimation: aStartValue = ' + this.aStartValue + ', aEndValue = ' + this.aEndValue );\n\
};\n\
\n\
FromToByActivity.prototype.endAnimation = function()\n\
{\n\
if( this.aAnimation )\n\
this.aAnimation.end();\n\
};\n\
\n\
FromToByActivity.prototype.performContinuousHook = function( nModifiedTime, nRepeatCount )\n\
{\n\
if( this.isDisposed() || !this.aAnimation  )\n\
{\n\
log( 'FromToByActivity.performContinuousHook: activity disposed or not valid animation' );\n\
return;\n\
}\n\
\n\
\n\
if( this.bDynamicStartValue )\n\
{\n\
if( this.nIteration != nRepeatCount )\n\
{\n\
this.nIteration = nRepeatCount;\n\
this.aStartInterpolationValue =  this.aStartValue;\n\
}\n\
else\n\
{\n\
var aActualValue = this.aAnimation.getUnderlyingValue();\n\
if( !this.equal( aActualValue, this.aPreviousValue ) )\n\
this.aStartInterpolationValue = aActualValue;\n\
}\n\
}\n\
\n\
var aValue = this.aInterpolator( this.aStartInterpolationValue,\n\
this.aEndValue, nModifiedTime );\n\
\n\
if( this.bCumulative && !this.bDynamicStartValue )\n\
{\n\
aValue = this.add( this.scale( nRepeatCount, this.aEndValue ), aValue );\n\
}\n\
\n\
aValue = this.aFormula ? this.aFormula( aValue ) : aValue;\n\
this.aAnimation.perform( aValue );\n\
\n\
if( this.bDynamicStartValue )\n\
{\n\
this.aPreviousValue = this.aAnimation.getUnderlyingValue();\n\
}\n\
\n\
};\n\
\n\
FromToByActivity.prototype.performDiscreteHook = function( /*nFrame, nRepeatCount*/ )\n\
{\n\
if (this.isDisposed() || !this.aAnimation) {\n\
log('FromToByActivity.performDiscreteHook: activity disposed or not valid animation');\n\
return;\n\
}\n\
};\n\
\n\
FromToByActivity.prototype.performEnd = function()\n\
{\n\
if( this.aAnimation )\n\
{\n\
var aValue = this.isAutoReverse() ? this.aStartValue : this.aEndValue;\n\
aValue = this.aFormula ? this.aFormula( aValue ) : aValue;\n\
this.aAnimation.perform( aValue );\n\
}\n\
};\n\
\n\
FromToByActivity.prototype.dispose = function()\n\
{\n\
FromToByActivity.superclass.dispose.call( this );\n\
};\n\
\n\
\n\
return FromToByActivity;\n\
}\n\
\n\
\n\
var LinearFromToByActivity = instantiate( FromToByActivityTemplate, ContinuousActivityBase );\n\
var DiscreteFromToByActivity = instantiate( FromToByActivityTemplate, DiscreteActivityBase );\n\
\n\
\n\
function  ValueListActivityTemplate( BaseType ) // template parameter\n\
{\n\
\n\
function ValueListActivity( aValueList, aActivityParamSet,\n\
aAnimation, aInterpolator,\n\
aOperatorSet, bAccumulate )\n\
{\n\
assert( aAnimation, 'ValueListActivity constructor: invalid animation object' );\n\
assert( aValueList.length != 0, 'ValueListActivity: value list is empty' );\n\
\n\
ValueListActivity.superclass.constructor.call( this, aActivityParamSet );\n\
\n\
this.aValueList = aValueList;\n\
this.aAnimation = aAnimation;\n\
this.aInterpolator = aInterpolator;\n\
this.add = aOperatorSet.add;\n\
this.scale = aOperatorSet.scale;\n\
this.bCumulative = bAccumulate;\n\
this.aLastValue = this.aValueList[ this.aValueList.length - 1 ];\n\
this.aFormula = aActivityParamSet.aFormula;\n\
}\n\
extend( ValueListActivity, BaseType );\n\
\n\
ValueListActivity.prototype.activate = function( aEndEvent )\n\
";

static const char aSVGScript100[] =
"\
{\n\
ValueListActivity.superclass.activate.call( this, aEndEvent );\n\
for( var i = 0; i < this.aValueList.length; ++i )\n\
{\n\
ANIMDBG.print( 'createValueListActivity: value[' + i + '] = ' + this.aValueList[i] );\n\
}\n\
};\n\
\n\
ValueListActivity.prototype.initAnimatedElement = function()\n\
{\n\
if( this.aAnimation )\n\
{\n\
var aValue = this.aValueList[0];\n\
aValue = this.aFormula ? this.aFormula( aValue ) : aValue;\n\
this.aAnimation.perform(aValue);\n\
}\n\
};\n\
\n\
ValueListActivity.prototype.startAnimation = function()\n\
{\n\
if( this.isDisposed() || !this.aAnimation  )\n\
{\n\
log( 'ValueListActivity.startAnimation: activity disposed or not valid animation' );\n\
return;\n\
}\n\
\n\
ValueListActivity.superclass.startAnimation.call( this );\n\
\n\
this.aAnimation.start( this.getTargetElement() );\n\
};\n\
\n\
ValueListActivity.prototype.endAnimation = function()\n\
{\n\
if( this.aAnimation )\n\
this.aAnimation.end();\n\
};\n\
\n\
ValueListActivity.prototype.performContinuousHook = function( nIndex, nFractionalIndex, nRepeatCount )\n\
{\n\
if( this.isDisposed() || !this.aAnimation  )\n\
{\n\
log( 'ValueListActivity.performContinuousHook: activity disposed or not valid animation' );\n\
return;\n\
}\n\
\n\
assert( ( nIndex + 1 ) < this.aValueList.length,\n\
'ValueListActivity.performContinuousHook: assertion (nIndex + 1 < this.aValueList.length) failed' );\n\
\n\
\n\
var aValue = this.aInterpolator( this.aValueList[ nIndex ],\n\
this.aValueList[ nIndex+1 ],\n\
nFractionalIndex );\n\
\n\
if( this.bCumulative )\n\
{\n\
aValue = this.add( aValue, this.scale( nRepeatCount, this.aLastValue ) );\n\
}\n\
\n\
aValue = this.aFormula ? this.aFormula( aValue ) : aValue;\n\
this.aAnimation.perform( aValue );\n\
};\n\
\n\
ValueListActivity.prototype.performDiscreteHook = function( nFrame, nRepeatCount )\n\
{\n\
if( this.isDisposed() || !this.aAnimation  )\n\
{\n\
log( 'ValueListActivity.performDiscreteHook: activity disposed or not valid animation' );\n\
return;\n\
}\n\
\n\
assert( nFrame < this.aValueList.length,\n\
'ValueListActivity.performDiscreteHook: assertion ( nFrame < this.aValueList.length) failed' );\n\
\n\
var aValue = this.aValueList[nFrame];\n\
\n\
if( this.bCumulative )\n\
{\n\
aValue = this.add( aValue, this.scale( nRepeatCount, this.aLastValue ) );\n\
}\n\
\n\
aValue = this.aFormula ? this.aFormula( aValue ) : aValue;\n\
this.aAnimation.perform( aValue );\n\
};\n\
\n\
ValueListActivity.prototype.performEnd = function()\n\
{\n\
if( this.aAnimation )\n\
{\n\
var aValue = this.aFormula ? this.aFormula( this.aLastValue ) : this.aLastValue;\n\
this.aAnimation.perform( aValue );\n\
}\n\
};\n\
\n\
ValueListActivity.prototype.dispose = function()\n\
{\n\
ValueListActivity.superclass.dispose.call( this );\n\
};\n\
\n\
\n\
return ValueListActivity;\n\
}\n\
\n\
\n\
var LinearValueListActivity = instantiate( ValueListActivityTemplate, ContinuousKeyTimeActivityBase );\n\
var DiscreteValueListActivity = instantiate( ValueListActivityTemplate, DiscreteActivityBase );\n\
\n\
\n\
function createActivity( aActivityParamSet, aAnimationNode, aAnimation, aInterpolator )\n\
{\n\
var eCalcMode = aAnimationNode.getCalcMode();\n\
\n\
var sAttributeName = aAnimationNode.getAttributeName();\n\
var aAttributeProp = aAttributeMap[ sAttributeName ];\n\
\n\
var eValueType = aAttributeProp[ 'type' ];\n\
var eValueSubtype = aAttributeProp[ 'subtype' ];\n\
\n\
if( ! aInterpolator )\n\
{\n\
aInterpolator = aInterpolatorHandler.getInterpolator( eCalcMode,\n\
eValueType,\n\
eValueSubtype );\n\
}\n\
\n\
var bAccumulate = ( aAnimationNode.getAccumulate() === ACCUMULATE_MODE_SUM )\n\
&& !( eValueType === BOOL_PROPERTY ||\n\
eValueType === STRING_PROPERTY ||\n\
eValueType === ENUM_PROPERTY );\n\
\n\
if( aAnimationNode.getFormula() )\n\
{\n\
var sFormula =  aAnimationNode.getFormula();\n\
var reMath = /abs|sqrt|asin|acos|atan|sin|cos|tan|exp|log|min|max/g;\n\
sFormula = sFormula.replace(reMath, 'Math.$&');\n\
sFormula = sFormula.replace(/pi(?!\\w)/g, 'Math.PI');\n\
sFormula = sFormula.replace(/e(?!\\w)/g, 'Math.E');\n\
sFormula = sFormula.replace(/\\$/g, '__PARAM0__');\n\
\n\
var aAnimatedElement = aAnimationNode.getAnimatedElement();\n\
var aBBox = aAnimatedElement.getBaseBBox();\n\
\n\
var width = aBBox.width / aActivityParamSet.nSlideWidth;\n\
var height = aBBox.height / aActivityParamSet.nSlideHeight;\n\
var x = ( aBBox.x + aBBox.width / 2 ) / aActivityParamSet.nSlideWidth;\n\
var y = ( aBBox.y + aBBox.height / 2 ) / aActivityParamSet.nSlideHeight;\n\
\n\
aActivityParamSet.aFormula = function( __PARAM0__ ) {\n\
\n\
return eval(sFormula);\n\
};\n\
";

static const char aSVGScript101[] =
"\
}\n\
\n\
aActivityParamSet.aDiscreteTimes = aAnimationNode.getKeyTimes();\n\
\n\
var aValueSet = aAnimationNode.getValues();\n\
var nValueSetSize = aValueSet.length;\n\
\n\
if( nValueSetSize != 0 )\n\
{\n\
\n\
if( aActivityParamSet.aDiscreteTimes.length == 0 )\n\
{\n\
for( var i = 0; i < nValueSetSize; ++i )\n\
aActivityParamSet.aDiscreteTimes[i].push( i / nValueSetSize );\n\
}\n\
\n\
switch( eCalcMode )\n\
{\n\
case CALC_MODE_DISCRETE:\n\
aActivityParamSet.aWakeupEvent =\n\
new WakeupEvent( aActivityParamSet.aTimerEventQueue.getTimer(),\n\
aActivityParamSet.aActivityQueue );\n\
\n\
return createValueListActivity( aActivityParamSet,\n\
aAnimationNode,\n\
aAnimation,\n\
aInterpolator,\n\
DiscreteValueListActivity,\n\
bAccumulate,\n\
eValueType );\n\
\n\
default:\n\
log( 'createActivity: unexpected calculation mode: ' + eCalcMode );\n\
case CALC_MODE_PACED :\n\
case CALC_MODE_SPLINE :\n\
case CALC_MODE_LINEAR:\n\
return createValueListActivity( aActivityParamSet,\n\
aAnimationNode,\n\
aAnimation,\n\
aInterpolator,\n\
LinearValueListActivity,\n\
bAccumulate,\n\
eValueType );\n\
}\n\
}\n\
else\n\
{\n\
switch( eCalcMode )\n\
{\n\
case CALC_MODE_DISCRETE:\n\
log( 'createActivity: discrete calculation case not yet implemented' );\n\
aActivityParamSet.aWakeupEvent =\n\
new WakeupEvent( aActivityParamSet.aTimerEventQueue.getTimer(),\n\
aActivityParamSet.aActivityQueue );\n\
return createFromToByActivity(  aActivityParamSet,\n\
aAnimationNode,\n\
aAnimation,\n\
aInterpolator,\n\
DiscreteFromToByActivity,\n\
bAccumulate,\n\
eValueType );\n\
\n\
default:\n\
log( 'createActivity: unexpected calculation mode: ' + eCalcMode );\n\
case CALC_MODE_PACED :\n\
case CALC_MODE_SPLINE :\n\
case CALC_MODE_LINEAR:\n\
return createFromToByActivity(  aActivityParamSet,\n\
aAnimationNode,\n\
aAnimation,\n\
aInterpolator,\n\
LinearFromToByActivity,\n\
bAccumulate,\n\
eValueType );\n\
}\n\
}\n\
}\n\
\n\
\n\
function createValueListActivity( aActivityParamSet, aAnimationNode, aAnimation,\n\
aInterpolator, ClassTemplateInstance, bAccumulate, eValueType )\n\
{\n\
var aAnimatedElement = aAnimationNode.getAnimatedElement();\n\
var aOperatorSet = aOperatorSetMap[ eValueType ];\n\
assert( aOperatorSet, 'createValueListActivity: no operator set found' );\n\
\n\
var aValueSet = aAnimationNode.getValues();\n\
\n\
var aValueList = [];\n\
\n\
extractAttributeValues( eValueType,\n\
aValueList,\n\
aValueSet,\n\
aAnimatedElement.getBaseBBox(),\n\
aActivityParamSet.nSlideWidth,\n\
aActivityParamSet.nSlideHeight );\n\
\n\
for( var i = 0; i < aValueList.length; ++i )\n\
{\n\
ANIMDBG.print( 'createValueListActivity: value[' + i + '] = ' + aValueList[i] );\n\
}\n\
\n\
return new ClassTemplateInstance( aValueList, aActivityParamSet, aAnimation,\n\
aInterpolator, aOperatorSet, bAccumulate );\n\
}\n\
\n\
\n\
function createFromToByActivity( aActivityParamSet, aAnimationNode, aAnimation,\n\
aInterpolator, ClassTemplateInstance, bAccumulate, eValueType )\n\
{\n\
\n\
var aAnimatedElement = aAnimationNode.getAnimatedElement();\n\
var aOperatorSet = aOperatorSetMap[ eValueType ];\n\
assert( aOperatorSet, 'createFromToByActivity: no operator set found' );\n\
\n\
var aValueSet = [];\n\
aValueSet[0] = aAnimationNode.getFromValue();\n\
aValueSet[1] = aAnimationNode.getToValue();\n\
aValueSet[2] = aAnimationNode.getByValue();\n\
\n\
ANIMDBG.print( 'createFromToByActivity: value type: ' + aValueTypeOutMap[eValueType] +\n\
', aFrom = ' + aValueSet[0] +\n\
', aTo = ' + aValueSet[1] +\n\
', aBy = ' + aValueSet[2] );\n\
\n\
var aValueList = [];\n\
\n\
extractAttributeValues( eValueType,\n\
aValueList,\n\
aValueSet,\n\
aAnimatedElement.getBaseBBox(),\n\
aActivityParamSet.nSlideWidth,\n\
aActivityParamSet.nSlideHeight );\n\
\n\
ANIMDBG.print( 'createFromToByActivity: ' +\n\
', aFrom = ' + aValueList[0] +\n\
', aTo = ' + aValueList[1] +\n\
', aBy = ' + aValueList[2] );\n\
\n\
return new ClassTemplateInstance( aValueList[0], aValueList[1], aValueList[2],\n\
aActivityParamSet, aAnimation,\n\
aInterpolator, aOperatorSet, bAccumulate );\n\
}\n\
\n\
\n\
function extractAttributeValues( eValueType, aValueList, aValueSet, aBBox, nSlideWidth, nSlideHeight )\n\
{\n\
var i;\n\
switch( eValueType )\n\
{\n\
";

static const char aSVGScript102[] =
"\
case NUMBER_PROPERTY :\n\
evalValuesAttribute( aValueList, aValueSet, aBBox, nSlideWidth, nSlideHeight );\n\
break;\n\
case BOOL_PROPERTY :\n\
for( i = 0; i < aValueSet.length; ++i )\n\
{\n\
var aValue = booleanParser( aValueSet[i] );\n\
aValueList.push( aValue );\n\
}\n\
break;\n\
case STRING_PROPERTY :\n\
for( i = 0; i < aValueSet.length; ++i )\n\
{\n\
aValueList.push( aValueSet[i] );\n\
}\n\
break;\n\
case ENUM_PROPERTY :\n\
for( i = 0; i < aValueSet.length; ++i )\n\
{\n\
aValueList.push( aValueSet[i] );\n\
}\n\
break;\n\
case COLOR_PROPERTY :\n\
for( i = 0; i < aValueSet.length; ++i )\n\
{\n\
aValue = colorParser( aValueSet[i] );\n\
aValueList.push( aValue );\n\
}\n\
break;\n\
case TUPLE_NUMBER_PROPERTY :\n\
for( i = 0; i < aValueSet.length; ++i )\n\
{\n\
if( typeof aValueSet[i] === 'string' )\n\
{\n\
var aTuple = aValueSet[i].split(',');\n\
aValue = [];\n\
evalValuesAttribute(aValue, aTuple, aBBox, nSlideWidth, nSlideHeight);\n\
aValueList.push(aValue);\n\
}\n\
else\n\
{\n\
aValueList.push( undefined );\n\
}\n\
}\n\
break;\n\
default:\n\
log( 'createValueListActivity: unexpected value type: ' + eValueType );\n\
}\n\
\n\
}\n\
\n\
\n\
function evalValuesAttribute( aValueList, aValueSet, aBBox, nSlideWidth, nSlideHeight )\n\
{\n\
var width = aBBox.width / nSlideWidth;\n\
var height = aBBox.height / nSlideHeight;\n\
var x = ( aBBox.x + aBBox.width / 2 ) / nSlideWidth;\n\
var y = ( aBBox.y + aBBox.height / 2 ) / nSlideHeight;\n\
\n\
var reMath = /abs|sqrt|asin|acos|atan|sin|cos|tan|exp|log|min|max/g;\n\
\n\
for( var i = 0; i < aValueSet.length; ++i )\n\
{\n\
var sValue = aValueSet[i];\n\
if(sValue)\n\
{\n\
sValue = sValue.replace(reMath, 'Math.$&');\n\
sValue = sValue.replace(/pi(?!\\w)/g, 'Math.PI');\n\
sValue = sValue.replace(/e(?!\\w)/g, 'Math.E');\n\
}\n\
var aValue =  eval( sValue );\n\
aValueList.push( aValue );\n\
}\n\
}\n\
\n\
\n\
var BACKWARD    = 0;\n\
var FORWARD     = 1;\n\
\n\
var MAXIMUM_FRAME_COUNT                 = 60;\n\
var MINIMUM_TIMEOUT                     = 1.0 / MAXIMUM_FRAME_COUNT;\n\
var MAXIMUM_TIMEOUT                     = 4.0;\n\
var MINIMUM_FRAMES_PER_SECONDS          = 10;\n\
var PREFERRED_FRAMES_PER_SECONDS        = 50;\n\
var PREFERRED_FRAME_RATE                = 1.0 / PREFERRED_FRAMES_PER_SECONDS;\n\
\n\
\n\
function Effect( nId )\n\
{\n\
this.nId = ( typeof( nId ) === typeof( 1 ) ) ? nId : -1;\n\
this.eState = Effect.NOT_STARTED;\n\
}\n\
Effect.NOT_STARTED = 0;\n\
Effect.PLAYING = 1;\n\
Effect.ENDED = 2;\n\
\n\
Effect.prototype.getId = function()\n\
{\n\
return this.nId;\n\
};\n\
\n\
Effect.prototype.isMainEffect = function()\n\
{\n\
return ( this.nId === -1 );\n\
};\n\
\n\
Effect.prototype.isPlaying = function()\n\
{\n\
return ( this.eState === Effect.PLAYING );\n\
};\n\
\n\
Effect.prototype.isEnded = function()\n\
{\n\
return ( this.eState === Effect.ENDED );\n\
};\n\
\n\
Effect.prototype.start = function()\n\
{\n\
assert( this.eState === Effect.NOT_STARTED, 'Effect.start: wrong state.' );\n\
this.eState = Effect.PLAYING;\n\
};\n\
\n\
Effect.prototype.end = function()\n\
{\n\
assert( this.eState === Effect.PLAYING, 'Effect.end: wrong state.' );\n\
this.eState = Effect.ENDED;\n\
};\n\
\n\
\n\
function SlideShow()\n\
{\n\
this.aTimer = new ElapsedTime();\n\
this.aFrameSynchronization = new FrameSynchronization( PREFERRED_FRAME_RATE );\n\
this.aTimerEventQueue = new TimerEventQueue( this.aTimer );\n\
this.aActivityQueue = new ActivityQueue( this.aTimer );\n\
this.aNextEffectEventArray = null;\n\
this.aInteractiveAnimationSequenceMap = null;\n\
this.aEventMultiplexer = null;\n\
\n\
this.aContext = new SlideShowContext( this.aTimerEventQueue,\n\
this.aEventMultiplexer,\n\
this.aNextEffectEventArray,\n\
this.aInteractiveAnimationSequenceMap,\n\
this.aActivityQueue );\n\
this.bIsIdle = true;\n\
this.bIsEnabled = true;\n\
this.bNoSlideTransition = false;\n\
this.bIsTransitionRunning = false;\n\
\n\
this.nCurrentEffect = 0;\n\
";

static const char aSVGScript103[] =
"\
this.bIsNextEffectRunning = false;\n\
this.bIsRewinding = false;\n\
this.bIsSkipping = false;\n\
this.bIsSkippingAll = false;\n\
this.nTotalInteractivePlayingEffects = 0;\n\
this.aStartedEffectList = [];\n\
this.aStartedEffectIndexMap = {};\n\
this.aStartedEffectIndexMap[ -1 ] = undefined;\n\
this.automaticAdvanceTimeout = null;\n\
}\n\
\n\
SlideShow.prototype.setSlideEvents = function( aNextEffectEventArray,\n\
aInteractiveAnimationSequenceMap,\n\
aEventMultiplexer )\n\
{\n\
if( !aNextEffectEventArray )\n\
log( 'SlideShow.setSlideEvents: aNextEffectEventArray is not valid' );\n\
\n\
if( !aInteractiveAnimationSequenceMap )\n\
log( 'SlideShow.setSlideEvents:aInteractiveAnimationSequenceMap  is not valid' );\n\
\n\
if( !aEventMultiplexer )\n\
log( 'SlideShow.setSlideEvents: aEventMultiplexer is not valid' );\n\
\n\
this.aContext.aNextEffectEventArray = aNextEffectEventArray;\n\
this.aNextEffectEventArray = aNextEffectEventArray;\n\
this.aContext.aInteractiveAnimationSequenceMap = aInteractiveAnimationSequenceMap;\n\
this.aInteractiveAnimationSequenceMap = aInteractiveAnimationSequenceMap;\n\
this.aContext.aEventMultiplexer = aEventMultiplexer;\n\
this.aEventMultiplexer = aEventMultiplexer;\n\
this.nCurrentEffect = 0;\n\
};\n\
\n\
SlideShow.prototype.createSlideTransition = function( aSlideTransitionHandler, aLeavingSlide, aEnteringSlide, aTransitionEndEvent )\n\
{\n\
if( !aEnteringSlide )\n\
{\n\
log( 'SlideShow.createSlideTransition: entering slide element is not valid.' );\n\
return null;\n\
}\n\
\n\
if( this.bNoSlideTransition ) return null;\n\
\n\
var aAnimatedLeavingSlide = null;\n\
if( aLeavingSlide )\n\
aAnimatedLeavingSlide = new AnimatedSlide( aLeavingSlide );\n\
var aAnimatedEnteringSlide = new AnimatedSlide( aEnteringSlide );\n\
\n\
var aSlideTransition = aSlideTransitionHandler.createSlideTransition( aAnimatedLeavingSlide, aAnimatedEnteringSlide );\n\
if( !aSlideTransition ) return null;\n\
\n\
var nDuration = 0.001;\n\
if( aSlideTransitionHandler.getDuration().isValue() )\n\
{\n\
nDuration = aSlideTransitionHandler.getDuration().getValue();\n\
}\n\
else\n\
{\n\
log( 'SlideShow.createSlideTransition: duration is not a number' );\n\
}\n\
\n\
var aCommonParameterSet = new ActivityParamSet();\n\
aCommonParameterSet.aEndEvent = aTransitionEndEvent;\n\
aCommonParameterSet.aTimerEventQueue = this.aTimerEventQueue;\n\
aCommonParameterSet.aActivityQueue = this.aActivityQueue;\n\
aCommonParameterSet.nMinDuration = nDuration;\n\
aCommonParameterSet.nMinNumberOfFrames = aSlideTransitionHandler.getMinFrameCount();\n\
aCommonParameterSet.nSlideWidth = WIDTH;\n\
aCommonParameterSet.nSlideHeight = HEIGHT;\n\
\n\
return new SimpleActivity( aCommonParameterSet, aSlideTransition, FORWARD );\n\
\n\
};\n\
\n\
SlideShow.prototype.isEnabled = function()\n\
{\n\
return this.bIsEnabled;\n\
};\n\
\n\
SlideShow.prototype.isRunning = function()\n\
{\n\
return !this.bIsIdle;\n\
};\n\
\n\
SlideShow.prototype.isTransitionPlaying = function()\n\
{\n\
return this.bIsTransitionRunning;\n\
};\n\
\n\
SlideShow.prototype.isMainEffectPlaying = function()\n\
{\n\
return this.bIsNextEffectRunning;\n\
};\n\
\n\
SlideShow.prototype.isInteractiveEffectPlaying = function()\n\
{\n\
return ( this.nTotalInteractivePlayingEffects > 0 );\n\
};\n\
\n\
SlideShow.prototype.isAnyEffectPlaying = function()\n\
{\n\
return ( this.isMainEffectPlaying() || this.isInteractiveEffectPlaying() );\n\
};\n\
\n\
SlideShow.prototype.hasAnyEffectStarted = function()\n\
{\n\
return ( this.aStartedEffectList.length > 0 );\n\
};\n\
\n\
SlideShow.prototype.notifyNextEffectStart = function()\n\
{\n\
assert( !this.bIsNextEffectRunning,\n\
'SlideShow.notifyNextEffectStart: an effect is already started.' );\n\
this.bIsNextEffectRunning = true;\n\
this.aEventMultiplexer.registerNextEffectEndHandler( bind2( SlideShow.prototype.notifyNextEffectEnd, this ) );\n\
var aEffect = new Effect();\n\
aEffect.start();\n\
this.aStartedEffectIndexMap[ -1 ] = this.aStartedEffectList.length;\n\
this.aStartedEffectList.push( aEffect );\n\
\n\
var aAnimatedElementMap = theMetaDoc.aMetaSlideSet[nCurSlide].aSlideAnimationsHandler.aAnimatedElementMap;\n\
for( var sId in aAnimatedElementMap )\n\
aAnimatedElementMap[ sId ].notifyNextEffectStart( this.nCurrentEffect );\n\
};\n\
\n\
SlideShow.prototype.notifyNextEffectEnd = function()\n\
{\n\
assert( this.bIsNextEffectRunning,\n\
'SlideShow.notifyNextEffectEnd: effect already ended.' );\n\
this.bIsNextEffectRunning = false;\n\
\n\
this.aStartedEffectList[ this.aStartedEffectIndexMap[ -1 ] ].end();\n\
if( this.automaticAdvanceTimeout !== null )\n\
{\n\
if( this.automaticAdvanceTimeout['rewindedEffect'] === this.nCurrentEffect )\n\
{\n\
this.automaticAdvanceTimeout = null;\n\
this.notifyAnimationsEnd();\n\
}\n\
}\n\
};\n\
\n\
SlideShow.prototype.notifyAnimationsEnd = function()\n\
{\n\
if( nCurSlide + 1 === theMetaDoc.nNumberOfSlides )\n\
return;\n\
\n\
assert (this.automaticAdvanceTimeout === null,\n\
'SlideShow.notifyAnimationsEnd: Timeout already set.')\n\
\n\
";

static const char aSVGScript104[] =
"\
var nTimeout = Math.ceil(theMetaDoc.aMetaSlideSet[nCurSlide].fDuration * 1000);\n\
if( nTimeout < 0 )\n\
return;\n\
\n\
this.automaticAdvanceTimeout = window.setTimeout('switchSlide(1, false)', nTimeout);\n\
};\n\
\n\
SlideShow.prototype.notifySlideStart = function( nNewSlideIndex, nOldSlideIndex )\n\
{\n\
this.nCurrentEffect = 0;\n\
this.bIsRewinding = false;\n\
this.bIsSkipping = false;\n\
this.bIsSkippingAll = false;\n\
this.nTotalInteractivePlayingEffects = 0;\n\
this.aStartedEffectList = [];\n\
this.aStartedEffectIndexMap = {};\n\
this.aStartedEffectIndexMap[ -1 ] = undefined;\n\
\n\
var aAnimatedElementMap;\n\
var sId;\n\
if( nOldSlideIndex !== undefined )\n\
{\n\
aAnimatedElementMap = theMetaDoc.aMetaSlideSet[nOldSlideIndex].aSlideAnimationsHandler.aAnimatedElementMap;\n\
for( sId in aAnimatedElementMap )\n\
aAnimatedElementMap[ sId ].notifySlideEnd();\n\
}\n\
\n\
aAnimatedElementMap = theMetaDoc.aMetaSlideSet[nNewSlideIndex].aSlideAnimationsHandler.aAnimatedElementMap;\n\
for( sId in aAnimatedElementMap )\n\
aAnimatedElementMap[ sId ].notifySlideStart( this.aContext );\n\
};\n\
\n\
SlideShow.prototype.notifyTransitionEnd = function( nSlideIndex )\n\
{\n\
if( theMetaDoc.getCurrentSlide() )\n\
{\n\
var sRef = 'url(#' + aPresentationClipPathId + ')';\n\
theMetaDoc.getCurrentSlide().slideElement.setAttribute('clip-path', sRef);\n\
}\n\
\n\
this.bIsTransitionRunning = false;\n\
if( this.bIsRewinding )\n\
{\n\
theMetaDoc.aMetaSlideSet[nSlideIndex].hide();\n\
var nIndex = nCurSlide !== undefined ? nCurSlide : -1;\n\
this.displaySlide( nIndex, true );\n\
this.skipAllEffects();\n\
this.bIsRewinding = false;\n\
return;\n\
}\n\
\n\
theMetaDoc.setCurrentSlide(nSlideIndex);\n\
\n\
if( this.aSlideViewElement )\n\
{\n\
theMetaDoc.getCurrentSlide().aVisibilityStatusElement.parentNode.removeChild( this.aSlideViewElement );\n\
this.aSlideViewElement = null;\n\
}\n\
if( this.isEnabled() )\n\
{\n\
this.dispose();\n\
\n\
var aCurrentSlide = theMetaDoc.getCurrentSlide();\n\
if( aCurrentSlide.aSlideAnimationsHandler.elementsParsed() )\n\
{\n\
aCurrentSlide.aSlideAnimationsHandler.start();\n\
this.aEventMultiplexer.registerAnimationsEndHandler( bind2( SlideShow.prototype.notifyAnimationsEnd, this ) );\n\
}\n\
else\n\
this.notifyAnimationsEnd();\n\
\n\
this.update();\n\
}\n\
else\n\
this.notifyAnimationsEnd();\n\
};\n\
\n\
SlideShow.prototype.notifyInteractiveAnimationSequenceStart = function( nNodeId )\n\
{\n\
++this.nTotalInteractivePlayingEffects;\n\
var aEffect = new Effect( nNodeId );\n\
aEffect.start();\n\
this.aStartedEffectIndexMap[ nNodeId ] = this.aStartedEffectList.length;\n\
this.aStartedEffectList.push( aEffect );\n\
};\n\
\n\
SlideShow.prototype.notifyInteractiveAnimationSequenceEnd = function( nNodeId )\n\
{\n\
assert( this.isInteractiveEffectPlaying(),\n\
'SlideShow.notifyInteractiveAnimationSequenceEnd: no interactive effect playing.' );\n\
\n\
this.aStartedEffectList[ this.aStartedEffectIndexMap[ nNodeId ] ].end();\n\
--this.nTotalInteractivePlayingEffects;\n\
};\n\
\n\
SlideShow.prototype.nextEffect = function()\n\
{\n\
if( !this.isEnabled() )\n\
return false;\n\
\n\
if( this.isTransitionPlaying() )\n\
{\n\
this.skipTransition();\n\
return true;\n\
}\n\
\n\
if( this.isAnyEffectPlaying() )\n\
{\n\
this.skipAllPlayingEffects();\n\
return true;\n\
}\n\
\n\
if( !this.aNextEffectEventArray )\n\
return false;\n\
\n\
if( this.nCurrentEffect >= this.aNextEffectEventArray.size() )\n\
return false;\n\
\n\
this.notifyNextEffectStart();\n\
\n\
this.aNextEffectEventArray.at( this.nCurrentEffect ).fire();\n\
++this.nCurrentEffect;\n\
this.update();\n\
return true;\n\
};\n\
\n\
SlideShow.prototype.skipTransition  = function()\n\
{\n\
if( this.bIsSkipping || this.bIsRewinding )\n\
return;\n\
\n\
this.bIsSkipping = true;\n\
\n\
this.aActivityQueue.endAll();\n\
this.aTimerEventQueue.forceEmpty();\n\
this.aActivityQueue.endAll();\n\
this.update();\n\
this.bIsSkipping = false;\n\
};\n\
\n\
SlideShow.prototype.skipAllPlayingEffects  = function()\n\
{\n\
if( this.bIsSkipping || this.bIsRewinding )\n\
return true;\n\
\n\
this.bIsSkipping = true;\n\
for( var i = 0; i < this.aStartedEffectList.length; ++i )\n\
{\n\
var aEffect = this.aStartedEffectList[i];\n\
if( aEffect.isPlaying() )\n\
";

static const char aSVGScript105[] =
"\
{\n\
if( aEffect.isMainEffect() )\n\
this.aEventMultiplexer.notifySkipEffectEvent();\n\
else\n\
this.aEventMultiplexer.notifySkipInteractiveEffectEvent( aEffect.getId() );\n\
}\n\
}\n\
this.update();\n\
this.bIsSkipping = false;\n\
return true;\n\
};\n\
\n\
SlideShow.prototype.skipNextEffect = function()\n\
{\n\
if( this.bIsSkipping || this.bIsRewinding )\n\
return true;\n\
\n\
assert( !this.isAnyEffectPlaying(),\n\
'SlideShow.skipNextEffect' );\n\
\n\
if( !this.aNextEffectEventArray )\n\
return false;\n\
\n\
if( this.nCurrentEffect >= this.aNextEffectEventArray.size() )\n\
return false;\n\
\n\
this.notifyNextEffectStart();\n\
\n\
this.bIsSkipping = true;\n\
this.aNextEffectEventArray.at( this.nCurrentEffect ).fire();\n\
this.aEventMultiplexer.notifySkipEffectEvent();\n\
++this.nCurrentEffect;\n\
this.update();\n\
this.bIsSkipping = false;\n\
return true;\n\
};\n\
\n\
SlideShow.prototype.skipPlayingOrNextEffect = function()\n\
{\n\
if( this.isTransitionPlaying() )\n\
{\n\
this.skipTransition();\n\
return true;\n\
}\n\
\n\
if( this.isAnyEffectPlaying() )\n\
return this.skipAllPlayingEffects();\n\
else\n\
return this.skipNextEffect();\n\
};\n\
\n\
\n\
SlideShow.prototype.skipAllEffects = function()\n\
{\n\
if( this.bIsSkippingAll )\n\
return true;\n\
\n\
this.bIsSkippingAll = true;\n\
\n\
if( this.isTransitionPlaying() )\n\
{\n\
this.skipTransition();\n\
}\n\
\n\
if( this.isAnyEffectPlaying() )\n\
{\n\
this.skipAllPlayingEffects();\n\
}\n\
else if( !this.aNextEffectEventArray\n\
|| ( this.nCurrentEffect >= this.aNextEffectEventArray.size() ) )\n\
{\n\
this.bIsSkippingAll = false;\n\
return false;\n\
}\n\
\n\
while( this.nCurrentEffect < this.aNextEffectEventArray.size() )\n\
{\n\
this.skipNextEffect();\n\
}\n\
this.bIsSkippingAll = false;\n\
return true;\n\
};\n\
\n\
SlideShow.prototype.rewindTransition = function()\n\
{\n\
if( this.bIsSkipping || this.bIsRewinding )\n\
return;\n\
\n\
this.bIsRewinding = true;\n\
this.aActivityQueue.endAll();\n\
this.update();\n\
this.bIsRewinding = false;\n\
};\n\
\n\
SlideShow.prototype.rewindEffect = function()\n\
{\n\
if( this.bIsSkipping || this.bIsRewinding )\n\
return;\n\
\n\
if( this.automaticAdvanceTimeout !== null && !this.automaticAdvanceTimeout['rewindedEffect'] )\n\
{\n\
window.clearTimeout( this.automaticAdvanceTimeout );\n\
this.automaticAdvanceTimeout = { 'rewindedEffect': this.nCurrentEffect };\n\
}\n\
\n\
if( !this.hasAnyEffectStarted() )\n\
{\n\
this.rewindToPreviousSlide();\n\
return;\n\
}\n\
\n\
this.bIsRewinding = true;\n\
\n\
var nFirstPlayingEffectIndex = undefined;\n\
\n\
var i = 0;\n\
for( ; i < this.aStartedEffectList.length; ++i )\n\
{\n\
var aEffect = this.aStartedEffectList[i];\n\
if( aEffect.isPlaying() )\n\
{\n\
nFirstPlayingEffectIndex = i;\n\
break;\n\
}\n\
}\n\
\n\
if( nFirstPlayingEffectIndex !== undefined )\n\
{\n\
i = this.aStartedEffectList.length - 1;\n\
for( ; i >= nFirstPlayingEffectIndex; --i )\n\
{\n\
aEffect = this.aStartedEffectList[i];\n\
if( aEffect.isPlaying() )\n\
{\n\
if( aEffect.isMainEffect() )\n\
{\n\
this.aEventMultiplexer.notifyRewindCurrentEffectEvent();\n\
if( this.nCurrentEffect > 0 )\n\
--this.nCurrentEffect;\n\
}\n\
else\n\
{\n\
this.aEventMultiplexer.notifyRewindRunningInteractiveEffectEvent( aEffect.getId() );\n\
}\n\
}\n\
else if( aEffect.isEnded() )\n\
{\n\
if( aEffect.isMainEffect() )\n\
{\n\
this.aEventMultiplexer.notifyRewindLastEffectEvent();\n\
";

static const char aSVGScript106[] =
"\
if( this.nCurrentEffect > 0 )\n\
--this.nCurrentEffect;\n\
}\n\
else\n\
{\n\
this.aEventMultiplexer.notifyRewindEndedInteractiveEffectEvent( aEffect.getId() );\n\
}\n\
}\n\
}\n\
this.update();\n\
\n\
i = this.aStartedEffectList.length - 1;\n\
for( ; i >= nFirstPlayingEffectIndex; --i )\n\
{\n\
aEffect = this.aStartedEffectList.pop();\n\
if( !aEffect.isMainEffect() )\n\
delete this.aStartedEffectIndexMap[ aEffect.getId() ];\n\
}\n\
}\n\
else  // there is no playing effect\n\
{\n\
aEffect = this.aStartedEffectList.pop();\n\
if( !aEffect.isMainEffect() )\n\
delete this.aStartedEffectIndexMap[ aEffect.getId() ];\n\
if( aEffect.isEnded() )  // Well that is almost an assertion.\n\
{\n\
if( aEffect.isMainEffect() )\n\
{\n\
this.aEventMultiplexer.notifyRewindLastEffectEvent();\n\
if( this.nCurrentEffect > 0 )\n\
--this.nCurrentEffect;\n\
}\n\
else\n\
{\n\
this.aEventMultiplexer.notifyRewindEndedInteractiveEffectEvent( aEffect.getId() );\n\
}\n\
}\n\
this.update();\n\
}\n\
\n\
this.bIsRewinding = false;\n\
};\n\
\n\
SlideShow.prototype.rewindToPreviousSlide = function()\n\
{\n\
if( this.isTransitionPlaying() )\n\
{\n\
this.rewindTransition();\n\
return;\n\
}\n\
if( this.isAnyEffectPlaying() )\n\
return;\n\
var nNewSlide = nCurSlide - 1;\n\
this.displaySlide( nNewSlide, true );\n\
this.skipAllEffects();\n\
};\n\
\n\
SlideShow.prototype.rewindAllEffects = function()\n\
{\n\
if( !this.hasAnyEffectStarted() )\n\
{\n\
this.rewindToPreviousSlide();\n\
return;\n\
}\n\
\n\
while( this.hasAnyEffectStarted() )\n\
{\n\
this.rewindEffect();\n\
}\n\
};\n\
\n\
SlideShow.prototype.exitSlideShowInApp = function()\n\
{\n\
if (window.webkit !== undefined &&\n\
window.webkit.messageHandlers !== undefined &&\n\
window.webkit.messageHandlers.lok !== undefined)\n\
window.webkit.messageHandlers.lok.postMessage('EXITSLIDESHOW', '*');\n\
}\n\
\n\
SlideShow.prototype.displaySlide = function( nNewSlide, bSkipSlideTransition )\n\
{\n\
var aMetaDoc = theMetaDoc;\n\
var nSlides = aMetaDoc.nNumberOfSlides;\n\
if( nNewSlide < 0 && nSlides > 0 )\n\
nNewSlide = nSlides - 1;\n\
else if( nNewSlide >= nSlides ) {\n\
nNewSlide = 0;\n\
this.exitSlideShowInApp();\n\
}\n\
\n\
if( ( currentMode === INDEX_MODE ) && ( nNewSlide === nCurSlide ) )\n\
{\n\
aMetaDoc.getCurrentSlide().show();\n\
return;\n\
}\n\
\n\
if( this.isTransitionPlaying() )\n\
{\n\
this.skipTransition();\n\
}\n\
\n\
var nOldSlide = nCurSlide;\n\
if( nOldSlide !== undefined )\n\
{\n\
var oldMetaSlide = aMetaDoc.aMetaSlideSet[nOldSlide];\n\
if( this.isEnabled() )\n\
{\n\
if( oldMetaSlide.aSlideAnimationsHandler.isAnimated() )\n\
{\n\
oldMetaSlide.aSlideAnimationsHandler.end( bSkipSlideTransition );\n\
\n\
this.dispose();\n\
}\n\
}\n\
\n\
if( this.automaticAdvanceTimeout !== null )\n\
{\n\
window.clearTimeout( this.automaticAdvanceTimeout );\n\
this.automaticAdvanceTimeout = null;\n\
}\n\
}\n\
\n\
this.notifySlideStart( nNewSlide, nOldSlide );\n\
\n\
if( this.isEnabled() && !bSkipSlideTransition  )\n\
{\n\
if ( ( ( nOldSlide !== undefined ) &&\n\
( ( nNewSlide > nOldSlide ) ||\n\
( ( nNewSlide == 0) && ( nOldSlide == (aMetaDoc.nNumberOfSlides - 1) ) ) ) ) ||\n\
(  ( nOldSlide === undefined ) &&  ( nNewSlide == 0) )  // for transition on first slide\n\
)\n\
{\n\
\n\
var aOldMetaSlide = null;\n\
if( nOldSlide === undefined ) // for transition on first slide\n\
{\n\
aOldMetaSlide = aMetaDoc.theMetaDummySlide;\n\
}\n\
else\n\
{\n\
aOldMetaSlide = aMetaDoc.aMetaSlideSet[nOldSlide];\n\
}\n\
var aNewMetaSlide = aMetaDoc.aMetaSlideSet[nNewSlide];\n\
\n\
var aSlideTransitionHandler = aNewMetaSlide.aTransitionHandler;\n\
if( aSlideTransitionHandler && aSlideTransitionHandler.isValid() )\n\
{\n\
var sRef = 'url(#' + aPresentationClipPathShrinkId + ')';\n\
aOldMetaSlide.slideElement.setAttribute( 'clip-path', sRef );\n\
\n\
";

static const char aSVGScript107[] =
"\
if( nOldSlide > nNewSlide )\n\
{\n\
this.aSlideViewElement = document.createElementNS( NSS['svg'], 'use' );\n\
setNSAttribute( 'xlink', this.aSlideViewElement, 'href', '#' + aOldMetaSlide.slideContainerId );\n\
aNewMetaSlide.aVisibilityStatusElement.parentNode.insertBefore( this.aSlideViewElement, aNewMetaSlide.aVisibilityStatusElement );\n\
aOldMetaSlide.hide();\n\
}\n\
\n\
var aLeavingSlide = aOldMetaSlide;\n\
var aEnteringSlide = aNewMetaSlide;\n\
var aTransitionEndEvent = makeEvent( bind2( this.notifyTransitionEnd, this, nNewSlide ) );\n\
\n\
var aTransitionActivity =\n\
this.createSlideTransition( aSlideTransitionHandler, aLeavingSlide,\n\
aEnteringSlide, aTransitionEndEvent );\n\
\n\
if( aTransitionActivity )\n\
{\n\
this.bIsTransitionRunning = true;\n\
this.aActivityQueue.addActivity( aTransitionActivity );\n\
this.update();\n\
}\n\
else\n\
{\n\
this.notifyTransitionEnd( nNewSlide );\n\
}\n\
}\n\
else\n\
{\n\
this.notifyTransitionEnd( nNewSlide );\n\
}\n\
}\n\
else\n\
{\n\
this.notifyTransitionEnd( nNewSlide );\n\
}\n\
}\n\
else\n\
{\n\
this.notifyTransitionEnd( nNewSlide );\n\
}\n\
\n\
};\n\
\n\
SlideShow.prototype.update = function()\n\
{\n\
this.aTimer.holdTimer();\n\
\n\
this.aTimerEventQueue.process();\n\
this.aActivityQueue.process();\n\
\n\
this.aFrameSynchronization.synchronize();\n\
\n\
this.aActivityQueue.processDequeued();\n\
\n\
this.aTimer.releaseTimer();\n\
\n\
var bActivitiesLeft = ( ! this.aActivityQueue.isEmpty() );\n\
var bTimerEventsLeft = ( ! this.aTimerEventQueue.isEmpty() );\n\
var bEventsLeft = ( bActivitiesLeft || bTimerEventsLeft );\n\
\n\
\n\
if( bEventsLeft )\n\
{\n\
var nNextTimeout;\n\
if( bActivitiesLeft )\n\
{\n\
nNextTimeout = MINIMUM_TIMEOUT;\n\
this.aFrameSynchronization.activate();\n\
}\n\
else\n\
{\n\
nNextTimeout = this.aTimerEventQueue.nextTimeout();\n\
if( nNextTimeout < MINIMUM_TIMEOUT )\n\
nNextTimeout = MINIMUM_TIMEOUT;\n\
else if( nNextTimeout > MAXIMUM_TIMEOUT )\n\
nNextTimeout = MAXIMUM_TIMEOUT;\n\
this.aFrameSynchronization.deactivate();\n\
}\n\
\n\
this.bIsIdle = false;\n\
window.setTimeout( 'aSlideShow.update()', nNextTimeout * 1000 );\n\
}\n\
else\n\
{\n\
this.bIsIdle = true;\n\
}\n\
};\n\
\n\
SlideShow.prototype.dispose = function()\n\
{\n\
this.aTimerEventQueue.clear();\n\
this.aActivityQueue.clear();\n\
this.aNextEffectEventArray = null;\n\
this.aEventMultiplexer = null;\n\
};\n\
\n\
SlideShow.prototype.getContext = function()\n\
{\n\
return this.aContext;\n\
};\n\
\n\
var aSlideShow = null;\n\
\n\
\n\
function SlideShowContext( aTimerEventQueue, aEventMultiplexer, aNextEffectEventArray, aInteractiveAnimationSequenceMap, aActivityQueue)\n\
{\n\
this.aTimerEventQueue = aTimerEventQueue;\n\
this.aEventMultiplexer = aEventMultiplexer;\n\
this.aNextEffectEventArray = aNextEffectEventArray;\n\
this.aInteractiveAnimationSequenceMap = aInteractiveAnimationSequenceMap;\n\
this.aActivityQueue = aActivityQueue;\n\
this.bIsSkipping = false;\n\
}\n\
\n\
\n\
function FrameSynchronization( nFrameDuration )\n\
{\n\
this.nFrameDuration = nFrameDuration;\n\
this.aTimer = new ElapsedTime();\n\
this.nNextFrameTargetTime = 0.0;\n\
this.bIsActive = false;\n\
\n\
this.markCurrentFrame();\n\
}\n\
\n\
\n\
FrameSynchronization.prototype.markCurrentFrame = function()\n\
{\n\
this.nNextFrameTargetTime = this.aTimer.getElapsedTime() + this.nFrameDuration;\n\
};\n\
\n\
FrameSynchronization.prototype.synchronize = function()\n\
{\n\
if( this.bIsActive )\n\
{\n\
while( this.aTimer.getElapsedTime() < this.nNextFrameTargetTime )\n\
;\n\
}\n\
\n\
this.markCurrentFrame();\n\
\n\
};\n\
\n\
FrameSynchronization.prototype.activate = function()\n\
{\n\
this.bIsActive = true;\n\
};\n\
\n\
FrameSynchronization.prototype.deactivate = function()\n\
";

static const char aSVGScript108[] =
"\
{\n\
this.bIsActive = false;\n\
};\n\
\n\
\n\
function NextEffectEventArray()\n\
{\n\
this.aEventArray = [];\n\
}\n\
\n\
\n\
NextEffectEventArray.prototype.size = function()\n\
{\n\
return this.aEventArray.length;\n\
};\n\
\n\
NextEffectEventArray.prototype.at = function( nIndex )\n\
{\n\
return this.aEventArray[ nIndex ];\n\
};\n\
\n\
NextEffectEventArray.prototype.appendEvent = function( aEvent )\n\
{\n\
var nSize = this.size();\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
if( this.aEventArray[i].getId() == aEvent.getId() )\n\
{\n\
aNextEffectEventArrayDebugPrinter.print( 'NextEffectEventArray.appendEvent: event(' + aEvent.getId() + ') already present' );\n\
return false;\n\
}\n\
}\n\
this.aEventArray.push( aEvent );\n\
aNextEffectEventArrayDebugPrinter.print( 'NextEffectEventArray.appendEvent: event(' + aEvent.getId() + ') appended' );\n\
return true;\n\
};\n\
\n\
NextEffectEventArray.prototype.clear = function( )\n\
{\n\
this.aEventArray = [];\n\
};\n\
\n\
\n\
function TimerEventQueue( aTimer )\n\
{\n\
this.aTimer = aTimer;\n\
this.aEventSet = new PriorityQueue( EventEntry.compare );\n\
}\n\
\n\
\n\
TimerEventQueue.prototype.addEvent = function( aEvent )\n\
{\n\
this.DBG( 'TimerEventQueue.addEvent event(' + aEvent.getId() + ') appended.' );\n\
if( !aEvent )\n\
{\n\
log( 'TimerEventQueue.addEvent: null event' );\n\
return false;\n\
}\n\
\n\
var nTime = aEvent.getActivationTime( this.aTimer.getElapsedTime() );\n\
var aEventEntry = new EventEntry( aEvent, nTime );\n\
this.aEventSet.push( aEventEntry );\n\
\n\
return true;\n\
};\n\
\n\
TimerEventQueue.prototype.forceEmpty = function()\n\
{\n\
this.process_(true);\n\
};\n\
\n\
\n\
TimerEventQueue.prototype.process = function()\n\
{\n\
this.process_(false);\n\
};\n\
\n\
TimerEventQueue.prototype.process_ = function( bFireAllEvents )\n\
{\n\
var nCurrentTime = this.aTimer.getElapsedTime();\n\
\n\
while( !this.isEmpty() && ( bFireAllEvents || ( this.aEventSet.top().nActivationTime <= nCurrentTime ) ) )\n\
{\n\
var aEventEntry = this.aEventSet.top();\n\
this.aEventSet.pop();\n\
\n\
var aEvent = aEventEntry.aEvent;\n\
if( aEvent.isCharged() )\n\
aEvent.fire();\n\
}\n\
};\n\
\n\
TimerEventQueue.prototype.isEmpty = function()\n\
{\n\
return this.aEventSet.isEmpty();\n\
};\n\
\n\
TimerEventQueue.prototype.nextTimeout = function()\n\
{\n\
var nTimeout = Number.MAX_VALUE;\n\
var nCurrentTime = this.aTimer.getElapsedTime();\n\
if( !this.isEmpty() )\n\
nTimeout = this.aEventSet.top().nActivationTime - nCurrentTime;\n\
return nTimeout;\n\
};\n\
\n\
TimerEventQueue.prototype.clear = function()\n\
{\n\
this.DBG( 'TimerEventQueue.clear invoked' );\n\
this.aEventSet.clear();\n\
};\n\
\n\
TimerEventQueue.prototype.getTimer = function()\n\
{\n\
return this.aTimer;\n\
};\n\
\n\
TimerEventQueue.prototype.DBG = function( sMessage, nTime )\n\
{\n\
aTimerEventQueueDebugPrinter.print( sMessage, nTime );\n\
};\n\
\n\
\n\
TimerEventQueue.prototype.insert = function( aEventEntry )\n\
{\n\
var nHoleIndex = this.aEventSet.length;\n\
var nParent = Math.floor( ( nHoleIndex - 1 ) / 2 );\n\
\n\
while( ( nHoleIndex > 0 ) && this.aEventSet[ nParent ].compare( aEventEntry ) )\n\
{\n\
this.aEventSet[ nHoleIndex ] = this.aEventSet[ nParent ];\n\
nHoleIndex = nParent;\n\
nParent = Math.floor( ( nHoleIndex - 1 ) / 2 );\n\
}\n\
this.aEventSet[ nHoleIndex ] = aEventEntry;\n\
};\n\
\n\
\n\
function EventEntry( aEvent, nTime )\n\
{\n\
this.aEvent = aEvent;\n\
this.nActivationTime = nTime;\n\
}\n\
\n\
\n\
EventEntry.compare = function( aLhsEventEntry, aRhsEventEntry )\n\
{\n\
if ( aLhsEventEntry.nActivationTime > aRhsEventEntry.nActivationTime )\n\
{\n\
return -1;\n\
";

static const char aSVGScript109[] =
"\
}\n\
else if ( aLhsEventEntry.nActivationTime < aRhsEventEntry.nActivationTime )\n\
{\n\
return 1;\n\
}\n\
else\n\
{\n\
return 0;\n\
}\n\
};\n\
\n\
\n\
function ActivityQueue( aTimer )\n\
{\n\
this.aTimer = aTimer;\n\
this.aCurrentActivityWaitingSet = [];\n\
this.aCurrentActivityReinsertSet = [];\n\
this.aDequeuedActivitySet = [];\n\
}\n\
\n\
\n\
ActivityQueue.prototype.dispose = function()\n\
{\n\
var nSize = this.aCurrentActivityWaitingSet.length;\n\
var i;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityWaitingSet[i].dispose();\n\
\n\
nSize = this.aCurrentActivityReinsertSet.length;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityReinsertSet[i].dispose();\n\
};\n\
\n\
ActivityQueue.prototype.addActivity = function( aActivity )\n\
{\n\
if( !aActivity )\n\
{\n\
log( 'ActivityQueue.addActivity: activity is not valid' );\n\
return false;\n\
}\n\
\n\
this.aCurrentActivityWaitingSet.push( aActivity );\n\
aActivityQueueDebugPrinter.print( 'ActivityQueue.addActivity: activity appended' );\n\
return true;\n\
};\n\
\n\
ActivityQueue.prototype.process = function()\n\
{\n\
var nSize = this.aCurrentActivityWaitingSet.length;\n\
var nLag = 0.0;\n\
for( var i = 0; i < nSize; ++i )\n\
{\n\
nLag = Math.max( nLag,this.aCurrentActivityWaitingSet[i].calcTimeLag()  );\n\
}\n\
\n\
if( nLag > 0.0 )\n\
this.aTimer.adjustTimer( -nLag, true );\n\
\n\
\n\
while( this.aCurrentActivityWaitingSet.length != 0 )\n\
{\n\
var aActivity = this.aCurrentActivityWaitingSet.shift();\n\
var bReinsert = false;\n\
\n\
bReinsert = aActivity.perform();\n\
\n\
if( bReinsert )\n\
{\n\
this.aCurrentActivityReinsertSet.push( aActivity );\n\
}\n\
else\n\
{\n\
this.aDequeuedActivitySet.push( aActivity );\n\
}\n\
}\n\
\n\
if( this.aCurrentActivityReinsertSet.length != 0 )\n\
{\n\
this.aCurrentActivityWaitingSet = this.aCurrentActivityReinsertSet;\n\
this.aCurrentActivityReinsertSet = [];\n\
}\n\
};\n\
\n\
ActivityQueue.prototype.processDequeued = function()\n\
{\n\
var nSize = this.aDequeuedActivitySet.length;\n\
for( var i = 0; i < nSize; ++i )\n\
this.aDequeuedActivitySet[i].dequeued();\n\
\n\
this.aDequeuedActivitySet = [];\n\
};\n\
\n\
ActivityQueue.prototype.isEmpty = function()\n\
{\n\
return ( ( this.aCurrentActivityWaitingSet.length == 0 ) &&\n\
( this.aCurrentActivityReinsertSet.length == 0 ) );\n\
};\n\
\n\
ActivityQueue.prototype.clear = function()\n\
{\n\
aActivityQueueDebugPrinter.print( 'ActivityQueue.clear invoked' );\n\
var nSize = this.aCurrentActivityWaitingSet.length;\n\
var i;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityWaitingSet[i].dequeued();\n\
this.aCurrentActivityWaitingSet = [];\n\
\n\
nSize = this.aCurrentActivityReinsertSet.length;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityReinsertSet[i].dequeued();\n\
this.aCurrentActivityReinsertSet = [];\n\
};\n\
\n\
ActivityQueue.prototype.endAll = function()\n\
{\n\
aActivityQueueDebugPrinter.print( 'ActivityQueue.endAll invoked' );\n\
var nSize = this.aCurrentActivityWaitingSet.length;\n\
var i;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityWaitingSet[i].end();\n\
this.aCurrentActivityWaitingSet = [];\n\
\n\
nSize = this.aCurrentActivityReinsertSet.length;\n\
for( i = 0; i < nSize; ++i )\n\
this.aCurrentActivityReinsertSet[i].end();\n\
this.aCurrentActivityReinsertSet = [];\n\
};\n\
\n\
ActivityQueue.prototype.getTimer = function()\n\
{\n\
return this.aTimer;\n\
};\n\
\n\
ActivityQueue.prototype.size = function()\n\
{\n\
return ( this.aCurrentActivityWaitingSet.length +\n\
this.aCurrentActivityReinsertSet.length +\n\
this.aDequeuedActivitySet.length );\n\
};\n\
\n\
\n\
function ElapsedTime( aTimeBase )\n\
{\n\
this.aTimeBase = aTimeBase;\n\
this.nLastQueriedTime = 0.0;\n\
this.nStartTime = this.getCurrentTime();\n\
this.nFrozenTime = 0.0;\n\
this.bInPauseMode = false;\n\
this.bInHoldMode = false;\n\
}\n\
";

static const char aSVGScript110[] =
"\
\n\
\n\
ElapsedTime.prototype.getTimeBase = function()\n\
{\n\
return this.aTimeBase;\n\
};\n\
\n\
ElapsedTime.prototype.reset = function()\n\
{\n\
this.nLastQueriedTime = 0.0;\n\
this.nStartTime = this.getCurrentTime();\n\
this.nFrozenTime = 0.0;\n\
this.bInPauseMode = false;\n\
this.bInHoldMode = false;\n\
};\n\
\n\
ElapsedTime.prototype.getElapsedTime = function()\n\
{\n\
this.nLastQueriedTime = this.getElapsedTimeImpl();\n\
return this.nLastQueriedTime;\n\
};\n\
\n\
ElapsedTime.prototype.pauseTimer = function()\n\
{\n\
this.nFrozenTime = this.getElapsedTimeImpl();\n\
this.bInPauseMode = true;\n\
};\n\
\n\
ElapsedTime.prototype.continueTimer = function()\n\
{\n\
this.bInPauseMode = false;\n\
\n\
var nPauseDuration = this.getElapsedTimeImpl() - this.nFrozenTime;\n\
\n\
this.nStartTime += nPauseDuration;\n\
};\n\
\n\
ElapsedTime.prototype.adjustTimer = function( nOffset, bLimitToLastQueriedTime )\n\
{\n\
if( bLimitToLastQueriedTime == undefined )\n\
bLimitToLastQueriedTime = true;\n\
\n\
this.nStartTime -= nOffset;\n\
\n\
if( this.bInHoldMode || this.bInPauseMode )\n\
this.nFrozenTime += nOffset;\n\
};\n\
\n\
ElapsedTime.prototype.holdTimer = function()\n\
{\n\
this.nFrozenTime = this.getElapsedTimeImpl();\n\
this.bInHoldMode = true;\n\
};\n\
\n\
ElapsedTime.prototype.releaseTimer = function()\n\
{\n\
this.bInHoldMode = false;\n\
};\n\
\n\
ElapsedTime.prototype.getSystemTime = function()\n\
{\n\
return ( getCurrentSystemTime() / 1000.0 );\n\
};\n\
\n\
ElapsedTime.prototype.getCurrentTime = function()\n\
{\n\
var nCurrentTime;\n\
if ( !this.aTimeBase )\n\
{\n\
nCurrentTime = this.getSystemTime();\n\
}\n\
else\n\
{\n\
nCurrentTime = this.aTimeBase.getElapsedTimeImpl();\n\
}\n\
\n\
assert( ( typeof( nCurrentTime ) === typeof( 0 ) ) && isFinite( nCurrentTime ),\n\
'ElapsedTime.getCurrentTime: assertion failed: nCurrentTime == ' + nCurrentTime );\n\
\n\
\n\
return nCurrentTime;\n\
};\n\
\n\
ElapsedTime.prototype.getElapsedTimeImpl = function()\n\
{\n\
if( this.bInHoldMode || this.bInPauseMode )\n\
{\n\
return this.nFrozenTime;\n\
}\n\
\n\
var nCurTime = this.getCurrentTime();\n\
return ( nCurTime - this.nStartTime );\n\
};\n\
\n\
\n\
/*****\n\
* @libreofficeend\n\
*\n\
* Several parts of the above code are the result of the porting,\n\
* started on August 2011, of the C++ code included in the source files\n\
* placed under the folder '/slideshow/source' and subfolders.\n\
* @source https://cgit.freedesktop.org/libreoffice/core/tree/slideshow/source\n\
*\n\
*/\n\
\n\
]]>";

static const char * const g_SVGScripts[N_SVGSCRIPT_FRAGMENTS] = {
    aSVGScript0,
    aSVGScript1,
    aSVGScript2,
    aSVGScript3,
    aSVGScript4,
    aSVGScript5,
    aSVGScript6,
    aSVGScript7,
    aSVGScript8,
    aSVGScript9,
    aSVGScript10,
    aSVGScript11,
    aSVGScript12,
    aSVGScript13,
    aSVGScript14,
    aSVGScript15,
    aSVGScript16,
    aSVGScript17,
    aSVGScript18,
    aSVGScript19,
    aSVGScript20,
    aSVGScript21,
    aSVGScript22,
    aSVGScript23,
    aSVGScript24,
    aSVGScript25,
    aSVGScript26,
    aSVGScript27,
    aSVGScript28,
    aSVGScript29,
    aSVGScript30,
    aSVGScript31,
    aSVGScript32,
    aSVGScript33,
    aSVGScript34,
    aSVGScript35,
    aSVGScript36,
    aSVGScript37,
    aSVGScript38,
    aSVGScript39,
    aSVGScript40,
    aSVGScript41,
    aSVGScript42,
    aSVGScript43,
    aSVGScript44,
    aSVGScript45,
    aSVGScript46,
    aSVGScript47,
    aSVGScript48,
    aSVGScript49,
    aSVGScript50,
    aSVGScript51,
    aSVGScript52,
    aSVGScript53,
    aSVGScript54,
    aSVGScript55,
    aSVGScript56,
    aSVGScript57,
    aSVGScript58,
    aSVGScript59,
    aSVGScript60,
    aSVGScript61,
    aSVGScript62,
    aSVGScript63,
    aSVGScript64,
    aSVGScript65,
    aSVGScript66,
    aSVGScript67,
    aSVGScript68,
    aSVGScript69,
    aSVGScript70,
    aSVGScript71,
    aSVGScript72,
    aSVGScript73,
    aSVGScript74,
    aSVGScript75,
    aSVGScript76,
    aSVGScript77,
    aSVGScript78,
    aSVGScript79,
    aSVGScript80,
    aSVGScript81,
    aSVGScript82,
    aSVGScript83,
    aSVGScript84,
    aSVGScript85,
    aSVGScript86,
    aSVGScript87,
    aSVGScript88,
    aSVGScript89,
    aSVGScript90,
    aSVGScript91,
    aSVGScript92,
    aSVGScript93,
    aSVGScript94,
    aSVGScript95,
    aSVGScript96,
    aSVGScript97,
    aSVGScript98,
    aSVGScript99,
    aSVGScript100,
    aSVGScript101,
    aSVGScript102,
    aSVGScript103,
    aSVGScript104,
    aSVGScript105,
    aSVGScript106,
    aSVGScript107,
    aSVGScript108,
    aSVGScript109,
    aSVGScript110,
};
