
#line 1 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
/**
 * \file
 * \brief parse SVG path specifications
 *
 * Copyright 2007 MenTaLguY <mental@rydia.net>
 * Copyright 2007 Aaron Spike <aaron@ekips.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it either under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * (the "LGPL") or, at your option, under the terms of the Mozilla
 * Public License Version 1.1 (the "MPL"). If you do not alter this
 * notice, a recipient may use your version of this file under either
 * the MPL or the LGPL.
 *
 * You should have received a copy of the LGPL along with this library
 * in the file COPYING-LGPL-2.1; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * You should have received a copy of the MPL along with this library
 * in the file COPYING-MPL-1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY
 * OF ANY KIND, either express or implied. See the LGPL or the MPL for
 * the specific language governing rights and limitations.
 *
 */

#include <cstdio>
#include <cmath>
#include <vector>
#include <glib.h>

#include <2geom/point.h>
#include <2geom/svg-path-parser.h>
#include <2geom/angle.h>

namespace Geom {


#line 48 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.cpp"
static const char _svg_path_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 15, 2, 
	1, 0, 2, 1, 6, 2, 1, 7, 
	2, 1, 8, 2, 1, 9, 2, 1, 
	10, 2, 1, 11, 2, 1, 12, 2, 
	1, 13, 2, 1, 14, 2, 2, 0, 
	2, 3, 0, 2, 4, 0, 2, 5, 
	0, 3, 1, 6, 0, 3, 1, 7, 
	0, 3, 1, 8, 0, 3, 1, 9, 
	0, 3, 1, 10, 0, 3, 1, 11, 
	0, 3, 1, 12, 0, 3, 1, 13, 
	0, 3, 1, 14, 0
};

static const short _svg_path_key_offsets[] = {
	0, 0, 9, 18, 21, 23, 35, 45, 
	48, 50, 53, 55, 67, 77, 80, 82, 
	91, 103, 112, 121, 130, 133, 135, 147, 
	157, 160, 162, 174, 184, 187, 189, 198, 
	205, 211, 218, 225, 231, 241, 251, 254, 
	256, 268, 278, 281, 283, 295, 304, 316, 
	325, 335, 339, 341, 348, 352, 354, 364, 
	368, 370, 380, 389, 398, 401, 403, 415, 
	425, 428, 430, 442, 452, 455, 457, 469, 
	479, 482, 484, 496, 506, 509, 511, 523, 
	533, 536, 538, 550, 559, 571, 580, 592, 
	601, 613, 622, 634, 643, 647, 649, 658, 
	667, 670, 672, 676, 678, 687, 696, 705, 
	708, 710, 722, 732, 735, 737, 749, 759, 
	762, 764, 776, 786, 789, 791, 803, 812, 
	824, 833, 845, 854, 858, 860, 869, 878, 
	881, 883, 895, 905, 908, 910, 922, 932, 
	935, 937, 949, 959, 962, 964, 976, 985, 
	997, 1006, 1018, 1027, 1031, 1033, 1042, 1051, 
	1054, 1056, 1068, 1078, 1081, 1083, 1095, 1104, 
	1108, 1110, 1119, 1128, 1131, 1133, 1137, 1139, 
	1148, 1157, 1166, 1175, 1184, 1196, 1205, 1209, 
	1211, 1220, 1229, 1238, 1247, 1251, 1253, 1263, 
	1267, 1269, 1279, 1283, 1285, 1295, 1299, 1301, 
	1311, 1315, 1317, 1327, 1331, 1333, 1343, 1347, 
	1349, 1359, 1363, 1365, 1375, 1379, 1381, 1391, 
	1395, 1397, 1407, 1411, 1413, 1423, 1427, 1429, 
	1439, 1443, 1445, 1455, 1459, 1461, 1470, 1474, 
	1476, 1486, 1498, 1507, 1517, 1524, 1528, 1530, 
	1534, 1536, 1546, 1552, 1584, 1614, 1646, 1678, 
	1710, 1740, 1772, 1802, 1834, 1864, 1896, 1926, 
	1958, 1988, 2020, 2050, 2082, 2112, 2144, 2174, 
	2206, 2236, 2268, 2298, 2330, 2360, 2392, 2422, 
	2454, 2484, 2508, 2532, 2564, 2594, 2624, 2656
};

static const char _svg_path_trans_keys[] = {
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 13, 32, 44, 46, 69, 101, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 9, 10, 43, 45, 48, 57, 
	46, 48, 57, 48, 57, 13, 32, 44, 
	69, 101, 9, 10, 48, 57, 13, 32, 
	44, 48, 49, 9, 10, 13, 32, 48, 
	49, 9, 10, 13, 32, 44, 48, 49, 
	9, 10, 13, 32, 44, 48, 49, 9, 
	10, 13, 32, 48, 49, 9, 10, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 13, 32, 44, 46, 9, 10, 43, 
	45, 48, 57, 46, 48, 57, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	9, 10, 43, 45, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	43, 45, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 44, 
	46, 69, 101, 9, 10, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	9, 10, 48, 57, 43, 45, 48, 57, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 43, 45, 48, 57, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 13, 32, 44, 46, 69, 101, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 43, 45, 48, 57, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 46, 48, 57, 48, 57, 
	43, 45, 48, 57, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 43, 45, 
	48, 57, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 43, 45, 48, 57, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 46, 48, 57, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	9, 10, 43, 45, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	43, 45, 48, 57, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	46, 48, 57, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	43, 45, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 43, 
	45, 48, 57, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 43, 45, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	48, 49, 9, 10, 43, 45, 48, 57, 
	48, 57, 43, 45, 48, 57, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 13, 32, 77, 109, 9, 10, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 13, 32, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 0
};

static const char _svg_path_single_lengths[] = {
	0, 5, 5, 1, 0, 6, 4, 1, 
	0, 1, 0, 6, 4, 1, 0, 5, 
	6, 5, 5, 5, 1, 0, 6, 4, 
	1, 0, 6, 4, 1, 0, 5, 5, 
	4, 5, 5, 4, 4, 4, 1, 0, 
	6, 4, 1, 0, 6, 5, 6, 5, 
	6, 2, 0, 3, 2, 0, 4, 2, 
	0, 4, 5, 5, 1, 0, 6, 4, 
	1, 0, 6, 4, 1, 0, 6, 4, 
	1, 0, 6, 4, 1, 0, 6, 4, 
	1, 0, 6, 5, 6, 5, 6, 5, 
	6, 5, 6, 5, 2, 0, 5, 5, 
	1, 0, 2, 0, 5, 5, 5, 1, 
	0, 6, 4, 1, 0, 6, 4, 1, 
	0, 6, 4, 1, 0, 6, 5, 6, 
	5, 6, 5, 2, 0, 5, 5, 1, 
	0, 6, 4, 1, 0, 6, 4, 1, 
	0, 6, 4, 1, 0, 6, 5, 6, 
	5, 6, 5, 2, 0, 5, 5, 1, 
	0, 6, 4, 1, 0, 6, 5, 2, 
	0, 5, 5, 1, 0, 2, 0, 5, 
	5, 5, 5, 5, 6, 5, 2, 0, 
	5, 5, 5, 5, 2, 0, 4, 2, 
	0, 4, 2, 0, 4, 2, 0, 4, 
	2, 0, 4, 2, 0, 4, 2, 0, 
	4, 2, 0, 4, 2, 0, 4, 2, 
	0, 4, 2, 0, 4, 2, 0, 4, 
	2, 0, 4, 2, 0, 5, 2, 0, 
	4, 6, 5, 4, 5, 2, 0, 2, 
	0, 4, 4, 26, 24, 26, 26, 26, 
	24, 26, 24, 26, 24, 26, 24, 26, 
	24, 26, 24, 26, 24, 26, 24, 26, 
	24, 26, 24, 26, 24, 26, 24, 26, 
	24, 22, 22, 26, 24, 24, 26, 24
};

static const char _svg_path_range_lengths[] = {
	0, 2, 2, 1, 1, 3, 3, 1, 
	1, 1, 1, 3, 3, 1, 1, 2, 
	3, 2, 2, 2, 1, 1, 3, 3, 
	1, 1, 3, 3, 1, 1, 2, 1, 
	1, 1, 1, 1, 3, 3, 1, 1, 
	3, 3, 1, 1, 3, 2, 3, 2, 
	2, 1, 1, 2, 1, 1, 3, 1, 
	1, 3, 2, 2, 1, 1, 3, 3, 
	1, 1, 3, 3, 1, 1, 3, 3, 
	1, 1, 3, 3, 1, 1, 3, 3, 
	1, 1, 3, 2, 3, 2, 3, 2, 
	3, 2, 3, 2, 1, 1, 2, 2, 
	1, 1, 1, 1, 2, 2, 2, 1, 
	1, 3, 3, 1, 1, 3, 3, 1, 
	1, 3, 3, 1, 1, 3, 2, 3, 
	2, 3, 2, 1, 1, 2, 2, 1, 
	1, 3, 3, 1, 1, 3, 3, 1, 
	1, 3, 3, 1, 1, 3, 2, 3, 
	2, 3, 2, 1, 1, 2, 2, 1, 
	1, 3, 3, 1, 1, 3, 2, 1, 
	1, 2, 2, 1, 1, 1, 1, 2, 
	2, 2, 2, 2, 3, 2, 1, 1, 
	2, 2, 2, 2, 1, 1, 3, 1, 
	1, 3, 1, 1, 3, 1, 1, 3, 
	1, 1, 3, 1, 1, 3, 1, 1, 
	3, 1, 1, 3, 1, 1, 3, 1, 
	1, 3, 1, 1, 3, 1, 1, 3, 
	1, 1, 3, 1, 1, 2, 1, 1, 
	3, 3, 2, 3, 1, 1, 1, 1, 
	1, 3, 1, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 1, 1, 3, 3, 3, 3, 3
};

static const short _svg_path_index_offsets[] = {
	0, 0, 8, 16, 19, 21, 31, 39, 
	42, 44, 47, 49, 59, 67, 70, 72, 
	80, 90, 98, 106, 114, 117, 119, 129, 
	137, 140, 142, 152, 160, 163, 165, 173, 
	180, 186, 193, 200, 206, 214, 222, 225, 
	227, 237, 245, 248, 250, 260, 268, 278, 
	286, 295, 299, 301, 307, 311, 313, 321, 
	325, 327, 335, 343, 351, 354, 356, 366, 
	374, 377, 379, 389, 397, 400, 402, 412, 
	420, 423, 425, 435, 443, 446, 448, 458, 
	466, 469, 471, 481, 489, 499, 507, 517, 
	525, 535, 543, 553, 561, 565, 567, 575, 
	583, 586, 588, 592, 594, 602, 610, 618, 
	621, 623, 633, 641, 644, 646, 656, 664, 
	667, 669, 679, 687, 690, 692, 702, 710, 
	720, 728, 738, 746, 750, 752, 760, 768, 
	771, 773, 783, 791, 794, 796, 806, 814, 
	817, 819, 829, 837, 840, 842, 852, 860, 
	870, 878, 888, 896, 900, 902, 910, 918, 
	921, 923, 933, 941, 944, 946, 956, 964, 
	968, 970, 978, 986, 989, 991, 995, 997, 
	1005, 1013, 1021, 1029, 1037, 1047, 1055, 1059, 
	1061, 1069, 1077, 1085, 1093, 1097, 1099, 1107, 
	1111, 1113, 1121, 1125, 1127, 1135, 1139, 1141, 
	1149, 1153, 1155, 1163, 1167, 1169, 1177, 1181, 
	1183, 1191, 1195, 1197, 1205, 1209, 1211, 1219, 
	1223, 1225, 1233, 1237, 1239, 1247, 1251, 1253, 
	1261, 1265, 1267, 1275, 1279, 1281, 1289, 1293, 
	1295, 1303, 1313, 1321, 1329, 1336, 1340, 1342, 
	1346, 1348, 1356, 1362, 1392, 1420, 1450, 1480, 
	1510, 1538, 1568, 1596, 1626, 1654, 1684, 1712, 
	1742, 1770, 1800, 1828, 1858, 1886, 1916, 1944, 
	1974, 2002, 2032, 2060, 2090, 2118, 2148, 2176, 
	2206, 2234, 2258, 2282, 2312, 2340, 2368, 2398
};

static const short _svg_path_indicies[] = {
	0, 0, 2, 2, 3, 0, 4, 1, 
	5, 5, 6, 6, 7, 5, 8, 1, 
	9, 10, 1, 11, 1, 12, 12, 14, 
	15, 16, 16, 12, 13, 11, 1, 17, 
	17, 19, 20, 17, 18, 21, 1, 22, 
	23, 1, 24, 1, 25, 26, 1, 27, 
	1, 28, 28, 30, 31, 32, 32, 28, 
	29, 27, 1, 33, 33, 35, 36, 33, 
	34, 37, 1, 38, 39, 1, 40, 1, 
	41, 41, 42, 42, 43, 41, 44, 1, 
	28, 28, 30, 27, 32, 32, 28, 29, 
	26, 1, 35, 35, 34, 34, 36, 35, 
	37, 1, 45, 45, 46, 46, 47, 45, 
	48, 1, 49, 49, 50, 50, 51, 49, 
	52, 1, 53, 54, 1, 55, 1, 56, 
	56, 58, 59, 60, 60, 56, 57, 55, 
	1, 61, 61, 63, 64, 61, 62, 65, 
	1, 66, 67, 1, 68, 1, 69, 69, 
	71, 72, 73, 73, 69, 70, 68, 1, 
	74, 74, 76, 77, 74, 75, 78, 1, 
	79, 80, 1, 81, 1, 82, 82, 83, 
	84, 84, 82, 81, 1, 85, 85, 86, 
	87, 88, 85, 1, 86, 86, 87, 88, 
	86, 1, 89, 89, 90, 91, 92, 89, 
	1, 93, 93, 94, 95, 96, 93, 1, 
	94, 94, 95, 96, 94, 1, 97, 97, 
	99, 100, 97, 98, 101, 1, 102, 102, 
	104, 105, 102, 103, 106, 1, 107, 108, 
	1, 109, 1, 110, 110, 112, 113, 114, 
	114, 110, 111, 109, 1, 115, 115, 117, 
	118, 115, 116, 119, 1, 120, 121, 1, 
	122, 1, 56, 56, 58, 55, 60, 60, 
	56, 57, 54, 1, 63, 63, 62, 62, 
	64, 63, 65, 1, 69, 69, 71, 68, 
	73, 73, 69, 70, 67, 1, 76, 76, 
	75, 75, 77, 76, 78, 1, 82, 82, 
	83, 81, 84, 84, 82, 80, 1, 123, 
	123, 124, 1, 124, 1, 82, 82, 83, 
	82, 124, 1, 125, 125, 126, 1, 126, 
	1, 69, 69, 71, 72, 69, 70, 126, 
	1, 127, 127, 128, 1, 128, 1, 56, 
	56, 58, 59, 56, 57, 128, 1, 129, 
	129, 130, 130, 131, 129, 132, 1, 133, 
	133, 134, 134, 135, 133, 136, 1, 137, 
	138, 1, 139, 1, 140, 140, 142, 143, 
	144, 144, 140, 141, 139, 1, 145, 145, 
	147, 148, 145, 146, 149, 1, 150, 151, 
	1, 152, 1, 153, 153, 155, 156, 157, 
	157, 153, 154, 152, 1, 158, 158, 160, 
	161, 158, 159, 162, 1, 163, 164, 1, 
	165, 1, 166, 166, 168, 169, 170, 170, 
	166, 167, 165, 1, 171, 171, 173, 174, 
	171, 172, 175, 1, 176, 177, 1, 178, 
	1, 179, 179, 181, 182, 183, 183, 179, 
	180, 178, 1, 184, 184, 186, 187, 184, 
	185, 188, 1, 189, 190, 1, 191, 1, 
	192, 192, 194, 195, 196, 196, 192, 193, 
	191, 1, 197, 197, 199, 200, 197, 198, 
	201, 1, 202, 203, 1, 204, 1, 140, 
	140, 142, 139, 144, 144, 140, 141, 138, 
	1, 147, 147, 146, 146, 148, 147, 149, 
	1, 153, 153, 155, 152, 157, 157, 153, 
	154, 151, 1, 160, 160, 159, 159, 161, 
	160, 162, 1, 166, 166, 168, 165, 170, 
	170, 166, 167, 164, 1, 173, 173, 172, 
	172, 174, 173, 175, 1, 179, 179, 181, 
	178, 183, 183, 179, 180, 177, 1, 186, 
	186, 185, 185, 187, 186, 188, 1, 192, 
	192, 194, 191, 196, 196, 192, 193, 190, 
	1, 199, 199, 198, 198, 200, 199, 201, 
	1, 205, 205, 206, 1, 206, 1, 207, 
	207, 208, 208, 209, 207, 210, 1, 211, 
	211, 212, 212, 213, 211, 214, 1, 215, 
	216, 1, 217, 1, 218, 218, 219, 1, 
	219, 1, 220, 220, 221, 221, 222, 220, 
	223, 1, 224, 224, 225, 225, 226, 224, 
	227, 1, 228, 228, 229, 229, 230, 228, 
	231, 1, 232, 233, 1, 234, 1, 235, 
	235, 237, 238, 239, 239, 235, 236, 234, 
	1, 240, 240, 242, 243, 240, 241, 244, 
	1, 245, 246, 1, 247, 1, 248, 248, 
	250, 251, 252, 252, 248, 249, 247, 1, 
	253, 253, 255, 256, 253, 254, 257, 1, 
	258, 259, 1, 260, 1, 261, 261, 263, 
	264, 265, 265, 261, 262, 260, 1, 266, 
	266, 268, 269, 266, 267, 270, 1, 271, 
	272, 1, 273, 1, 235, 235, 237, 234, 
	239, 239, 235, 236, 233, 1, 242, 242, 
	241, 241, 243, 242, 244, 1, 248, 248, 
	250, 247, 252, 252, 248, 249, 246, 1, 
	255, 255, 254, 254, 256, 255, 257, 1, 
	261, 261, 263, 260, 265, 265, 261, 262, 
	259, 1, 268, 268, 267, 267, 269, 268, 
	270, 1, 274, 274, 275, 1, 275, 1, 
	276, 276, 277, 277, 278, 276, 279, 1, 
	280, 280, 281, 281, 282, 280, 283, 1, 
	284, 285, 1, 286, 1, 287, 287, 289, 
	290, 291, 291, 287, 288, 286, 1, 292, 
	292, 294, 295, 292, 293, 296, 1, 297, 
	298, 1, 299, 1, 300, 300, 302, 303, 
	304, 304, 300, 301, 299, 1, 305, 305, 
	307, 308, 305, 306, 309, 1, 310, 311, 
	1, 312, 1, 313, 313, 315, 316, 317, 
	317, 313, 314, 312, 1, 318, 318, 320, 
	321, 318, 319, 322, 1, 323, 324, 1, 
	325, 1, 287, 287, 289, 286, 291, 291, 
	287, 288, 285, 1, 294, 294, 293, 293, 
	295, 294, 296, 1, 300, 300, 302, 299, 
	304, 304, 300, 301, 298, 1, 307, 307, 
	306, 306, 308, 307, 309, 1, 313, 313, 
	315, 312, 317, 317, 313, 314, 311, 1, 
	320, 320, 319, 319, 321, 320, 322, 1, 
	326, 326, 327, 1, 327, 1, 328, 328, 
	329, 329, 330, 328, 331, 1, 332, 332, 
	333, 333, 334, 332, 335, 1, 336, 337, 
	1, 338, 1, 339, 339, 341, 342, 343, 
	343, 339, 340, 338, 1, 344, 344, 346, 
	347, 344, 345, 348, 1, 349, 350, 1, 
	351, 1, 339, 339, 341, 338, 343, 343, 
	339, 340, 337, 1, 346, 346, 345, 345, 
	347, 346, 348, 1, 352, 352, 353, 1, 
	353, 1, 354, 354, 355, 355, 356, 354, 
	357, 1, 358, 358, 359, 359, 360, 358, 
	361, 1, 362, 363, 1, 364, 1, 365, 
	365, 366, 1, 366, 1, 367, 367, 368, 
	368, 369, 367, 370, 1, 371, 371, 372, 
	372, 373, 371, 374, 1, 375, 375, 376, 
	376, 377, 375, 378, 1, 379, 379, 380, 
	380, 381, 379, 382, 1, 383, 383, 384, 
	384, 385, 383, 386, 1, 12, 12, 14, 
	11, 16, 16, 12, 13, 10, 1, 19, 
	19, 18, 18, 20, 19, 21, 1, 387, 
	387, 388, 1, 388, 1, 389, 389, 390, 
	390, 391, 389, 392, 1, 393, 393, 394, 
	394, 395, 393, 396, 1, 397, 397, 398, 
	398, 399, 397, 400, 1, 401, 401, 402, 
	402, 403, 401, 404, 1, 405, 405, 406, 
	1, 406, 1, 12, 12, 14, 15, 12, 
	13, 406, 1, 407, 407, 408, 1, 408, 
	1, 339, 339, 341, 342, 339, 340, 408, 
	1, 409, 409, 410, 1, 410, 1, 313, 
	313, 315, 316, 313, 314, 410, 1, 411, 
	411, 412, 1, 412, 1, 300, 300, 302, 
	303, 300, 301, 412, 1, 413, 413, 414, 
	1, 414, 1, 287, 287, 289, 290, 287, 
	288, 414, 1, 415, 415, 416, 1, 416, 
	1, 261, 261, 263, 264, 261, 262, 416, 
	1, 417, 417, 418, 1, 418, 1, 248, 
	248, 250, 251, 248, 249, 418, 1, 419, 
	419, 420, 1, 420, 1, 235, 235, 237, 
	238, 235, 236, 420, 1, 421, 421, 422, 
	1, 422, 1, 192, 192, 194, 195, 192, 
	193, 422, 1, 423, 423, 424, 1, 424, 
	1, 179, 179, 181, 182, 179, 180, 424, 
	1, 425, 425, 426, 1, 426, 1, 166, 
	166, 168, 169, 166, 167, 426, 1, 427, 
	427, 428, 1, 428, 1, 153, 153, 155, 
	156, 153, 154, 428, 1, 429, 429, 430, 
	1, 430, 1, 140, 140, 142, 143, 140, 
	141, 430, 1, 431, 431, 432, 1, 432, 
	1, 117, 117, 116, 116, 118, 117, 119, 
	1, 433, 433, 434, 1, 434, 1, 110, 
	110, 112, 113, 110, 111, 434, 1, 110, 
	110, 112, 109, 114, 114, 110, 111, 108, 
	1, 104, 104, 103, 103, 105, 104, 106, 
	1, 435, 435, 437, 438, 435, 436, 439, 
	1, 440, 440, 441, 442, 443, 440, 1, 
	444, 444, 445, 1, 445, 1, 446, 446, 
	447, 1, 447, 1, 28, 28, 30, 31, 
	28, 29, 447, 1, 448, 448, 449, 450, 
	448, 1, 451, 451, 453, 454, 455, 456, 
	457, 458, 459, 460, 461, 462, 463, 464, 
	465, 466, 467, 457, 468, 469, 470, 471, 
	472, 473, 474, 465, 451, 452, 24, 1, 
	475, 475, 41, 43, 476, 477, 478, 479, 
	449, 480, 481, 482, 483, 484, 485, 486, 
	487, 488, 450, 489, 490, 491, 492, 484, 
	475, 42, 44, 1, 493, 493, 495, 496, 
	497, 498, 499, 500, 501, 502, 503, 504, 
	505, 506, 507, 508, 509, 499, 510, 511, 
	512, 513, 514, 515, 516, 507, 493, 494, 
	40, 1, 493, 493, 495, 40, 497, 498, 
	499, 500, 501, 502, 503, 504, 505, 506, 
	507, 508, 509, 499, 510, 511, 512, 513, 
	514, 515, 516, 507, 493, 494, 39, 1, 
	517, 517, 519, 520, 521, 522, 523, 524, 
	525, 526, 527, 528, 529, 530, 531, 532, 
	533, 523, 534, 535, 536, 537, 538, 539, 
	540, 531, 517, 518, 122, 1, 541, 541, 
	49, 51, 476, 477, 478, 479, 449, 480, 
	481, 482, 483, 484, 485, 486, 487, 488, 
	450, 489, 490, 491, 492, 484, 541, 50, 
	52, 1, 542, 542, 544, 545, 546, 547, 
	548, 549, 550, 551, 552, 553, 554, 555, 
	556, 557, 558, 548, 559, 560, 561, 562, 
	563, 564, 565, 556, 542, 543, 204, 1, 
	566, 566, 133, 135, 476, 477, 478, 479, 
	449, 480, 481, 482, 483, 484, 485, 486, 
	487, 488, 450, 489, 490, 491, 492, 484, 
	566, 134, 136, 1, 542, 542, 544, 204, 
	546, 547, 548, 549, 550, 551, 552, 553, 
	554, 555, 556, 557, 558, 548, 559, 560, 
	561, 562, 563, 564, 565, 556, 542, 543, 
	203, 1, 542, 542, 544, 545, 546, 547, 
	549, 550, 551, 552, 553, 554, 555, 556, 
	557, 558, 559, 560, 561, 562, 563, 564, 
	565, 556, 542, 543, 206, 1, 567, 567, 
	569, 570, 571, 572, 573, 574, 575, 576, 
	577, 578, 579, 580, 581, 582, 583, 573, 
	584, 585, 586, 587, 588, 589, 590, 581, 
	567, 568, 217, 1, 591, 591, 211, 213, 
	476, 477, 478, 479, 449, 480, 481, 482, 
	483, 484, 485, 486, 487, 488, 450, 489, 
	490, 491, 492, 484, 591, 212, 214, 1, 
	567, 567, 569, 217, 571, 572, 573, 574, 
	575, 576, 577, 578, 579, 580, 581, 582, 
	583, 573, 584, 585, 586, 587, 588, 589, 
	590, 581, 567, 568, 216, 1, 567, 567, 
	569, 570, 571, 572, 574, 575, 576, 577, 
	578, 579, 580, 581, 582, 583, 584, 585, 
	586, 587, 588, 589, 590, 581, 567, 568, 
	219, 1, 592, 592, 594, 595, 596, 597, 
	598, 599, 600, 601, 602, 603, 604, 605, 
	606, 607, 608, 598, 609, 610, 611, 612, 
	613, 614, 615, 606, 592, 593, 273, 1, 
	616, 616, 228, 230, 476, 477, 478, 479, 
	449, 480, 481, 482, 483, 484, 485, 486, 
	487, 488, 450, 489, 490, 491, 492, 484, 
	616, 229, 231, 1, 592, 592, 594, 273, 
	596, 597, 598, 599, 600, 601, 602, 603, 
	604, 605, 606, 607, 608, 598, 609, 610, 
	611, 612, 613, 614, 615, 606, 592, 593, 
	272, 1, 592, 592, 594, 595, 596, 597, 
	599, 600, 601, 602, 603, 604, 605, 606, 
	607, 608, 609, 610, 611, 612, 613, 614, 
	615, 606, 592, 593, 275, 1, 617, 617, 
	619, 620, 621, 622, 623, 624, 625, 626, 
	627, 628, 629, 630, 631, 632, 633, 623, 
	634, 635, 636, 637, 638, 639, 640, 631, 
	617, 618, 325, 1, 641, 641, 280, 282, 
	476, 477, 478, 479, 449, 480, 481, 482, 
	483, 484, 485, 486, 487, 488, 450, 489, 
	490, 491, 492, 484, 641, 281, 283, 1, 
	617, 617, 619, 325, 621, 622, 623, 624, 
	625, 626, 627, 628, 629, 630, 631, 632, 
	633, 623, 634, 635, 636, 637, 638, 639, 
	640, 631, 617, 618, 324, 1, 617, 617, 
	619, 620, 621, 622, 624, 625, 626, 627, 
	628, 629, 630, 631, 632, 633, 634, 635, 
	636, 637, 638, 639, 640, 631, 617, 618, 
	327, 1, 642, 642, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 653, 654, 655, 
	656, 657, 658, 648, 659, 660, 661, 662, 
	663, 664, 665, 656, 642, 643, 351, 1, 
	666, 666, 332, 334, 476, 477, 478, 479, 
	449, 480, 481, 482, 483, 484, 485, 486, 
	487, 488, 450, 489, 490, 491, 492, 484, 
	666, 333, 335, 1, 642, 642, 644, 351, 
	646, 647, 648, 649, 650, 651, 652, 653, 
	654, 655, 656, 657, 658, 648, 659, 660, 
	661, 662, 663, 664, 665, 656, 642, 643, 
	350, 1, 642, 642, 644, 645, 646, 647, 
	649, 650, 651, 652, 653, 654, 655, 656, 
	657, 658, 659, 660, 661, 662, 663, 664, 
	665, 656, 642, 643, 353, 1, 667, 667, 
	669, 670, 671, 672, 673, 674, 675, 676, 
	677, 678, 679, 680, 681, 682, 683, 673, 
	684, 685, 686, 687, 688, 689, 690, 681, 
	667, 668, 364, 1, 691, 691, 358, 360, 
	476, 477, 478, 479, 449, 480, 481, 482, 
	483, 484, 485, 486, 487, 488, 450, 489, 
	490, 491, 492, 484, 691, 359, 361, 1, 
	667, 667, 669, 364, 671, 672, 673, 674, 
	675, 676, 677, 678, 679, 680, 681, 682, 
	683, 673, 684, 685, 686, 687, 688, 689, 
	690, 681, 667, 668, 363, 1, 667, 667, 
	669, 670, 671, 672, 674, 675, 676, 677, 
	678, 679, 680, 681, 682, 683, 684, 685, 
	686, 687, 688, 689, 690, 681, 667, 668, 
	366, 1, 692, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 703, 704, 
	705, 706, 707, 708, 709, 710, 711, 702, 
	692, 1, 712, 712, 476, 477, 478, 479, 
	449, 480, 481, 482, 483, 484, 485, 486, 
	487, 488, 450, 489, 490, 491, 492, 484, 
	712, 1, 451, 451, 453, 24, 455, 456, 
	457, 458, 459, 460, 461, 462, 463, 464, 
	465, 466, 467, 457, 468, 469, 470, 471, 
	472, 473, 474, 465, 451, 452, 23, 1, 
	451, 451, 453, 454, 455, 456, 458, 459, 
	460, 461, 462, 463, 464, 465, 466, 467, 
	468, 469, 470, 471, 472, 473, 474, 465, 
	451, 452, 388, 1, 517, 517, 519, 520, 
	521, 522, 524, 525, 526, 527, 528, 529, 
	530, 531, 532, 533, 534, 535, 536, 537, 
	538, 539, 540, 531, 517, 518, 432, 1, 
	517, 517, 519, 122, 521, 522, 523, 524, 
	525, 526, 527, 528, 529, 530, 531, 532, 
	533, 523, 534, 535, 536, 537, 538, 539, 
	540, 531, 517, 518, 121, 1, 493, 493, 
	495, 496, 497, 498, 500, 501, 502, 503, 
	504, 505, 506, 507, 508, 509, 510, 511, 
	512, 513, 514, 515, 516, 507, 493, 494, 
	445, 1, 0
};

static const short _svg_path_trans_targs[] = {
	2, 0, 3, 4, 172, 2, 3, 4, 
	172, 4, 172, 5, 6, 7, 173, 8, 
	180, 6, 7, 173, 8, 267, 8, 267, 
	235, 10, 16, 11, 12, 13, 17, 14, 
	231, 12, 13, 17, 14, 238, 14, 238, 
	237, 15, 9, 10, 16, 19, 20, 21, 
	44, 19, 20, 21, 44, 21, 44, 22, 
	23, 24, 45, 25, 55, 23, 24, 45, 
	25, 46, 25, 46, 26, 27, 28, 47, 
	29, 52, 27, 28, 47, 29, 48, 29, 
	48, 30, 31, 32, 49, 31, 32, 33, 
	228, 34, 35, 36, 227, 34, 35, 36, 
	227, 37, 38, 226, 39, 225, 37, 38, 
	226, 39, 225, 39, 225, 40, 41, 42, 
	221, 43, 222, 41, 42, 221, 43, 270, 
	43, 270, 239, 50, 51, 53, 54, 56, 
	57, 59, 60, 61, 82, 59, 60, 61, 
	82, 61, 82, 62, 63, 64, 83, 65, 
	216, 63, 64, 83, 65, 84, 65, 84, 
	66, 67, 68, 85, 69, 213, 67, 68, 
	85, 69, 86, 69, 86, 70, 71, 72, 
	87, 73, 210, 71, 72, 87, 73, 88, 
	73, 88, 74, 75, 76, 89, 77, 207, 
	75, 76, 89, 77, 90, 77, 90, 78, 
	79, 80, 91, 81, 204, 79, 80, 91, 
	81, 243, 81, 243, 241, 93, 244, 95, 
	96, 97, 247, 95, 96, 97, 247, 97, 
	247, 245, 99, 248, 15, 9, 10, 16, 
	102, 103, 104, 117, 102, 103, 104, 117, 
	104, 117, 105, 106, 107, 118, 108, 201, 
	106, 107, 118, 108, 119, 108, 119, 109, 
	110, 111, 120, 112, 198, 110, 111, 120, 
	112, 121, 112, 121, 113, 114, 115, 122, 
	116, 195, 114, 115, 122, 116, 251, 116, 
	251, 249, 124, 252, 126, 127, 128, 141, 
	126, 127, 128, 141, 128, 141, 129, 130, 
	131, 142, 132, 192, 130, 131, 142, 132, 
	143, 132, 143, 133, 134, 135, 144, 136, 
	189, 134, 135, 144, 136, 145, 136, 145, 
	137, 138, 139, 146, 140, 186, 138, 139, 
	146, 140, 255, 140, 255, 253, 148, 256, 
	150, 151, 152, 157, 150, 151, 152, 157, 
	152, 157, 153, 154, 155, 158, 156, 183, 
	154, 155, 158, 156, 259, 156, 259, 257, 
	160, 260, 162, 163, 164, 263, 162, 163, 
	164, 263, 164, 263, 261, 166, 264, 19, 
	20, 21, 44, 59, 60, 61, 82, 95, 
	96, 97, 247, 15, 9, 10, 16, 2, 
	3, 4, 172, 175, 268, 102, 103, 104, 
	117, 126, 127, 128, 141, 150, 151, 152, 
	157, 162, 163, 164, 263, 181, 182, 184, 
	185, 187, 188, 190, 191, 193, 194, 196, 
	197, 199, 200, 202, 203, 205, 206, 208, 
	209, 211, 212, 214, 215, 217, 218, 220, 
	269, 223, 224, 37, 38, 226, 39, 225, 
	34, 35, 36, 227, 230, 271, 232, 233, 
	234, 1, 171, 236, 9, 15, 10, 18, 
	58, 174, 94, 100, 1, 101, 125, 149, 
	161, 265, 167, 168, 169, 170, 171, 176, 
	177, 178, 179, 236, 18, 58, 94, 100, 
	101, 125, 149, 161, 265, 167, 168, 169, 
	170, 176, 177, 178, 179, 236, 9, 15, 
	10, 18, 58, 229, 94, 100, 1, 101, 
	125, 149, 161, 265, 167, 168, 169, 170, 
	171, 176, 177, 178, 179, 240, 20, 19, 
	21, 18, 58, 219, 94, 100, 1, 101, 
	125, 149, 161, 265, 167, 168, 169, 170, 
	171, 176, 177, 178, 179, 240, 242, 60, 
	59, 61, 18, 58, 92, 94, 100, 1, 
	101, 125, 149, 161, 265, 167, 168, 169, 
	170, 171, 176, 177, 178, 179, 242, 246, 
	96, 95, 97, 18, 58, 98, 94, 100, 
	1, 101, 125, 149, 161, 265, 167, 168, 
	169, 170, 171, 176, 177, 178, 179, 246, 
	250, 103, 102, 104, 18, 58, 123, 94, 
	100, 1, 101, 125, 149, 161, 265, 167, 
	168, 169, 170, 171, 176, 177, 178, 179, 
	250, 254, 127, 126, 128, 18, 58, 147, 
	94, 100, 1, 101, 125, 149, 161, 265, 
	167, 168, 169, 170, 171, 176, 177, 178, 
	179, 254, 258, 151, 150, 152, 18, 58, 
	159, 94, 100, 1, 101, 125, 149, 161, 
	265, 167, 168, 169, 170, 171, 176, 177, 
	178, 179, 258, 262, 163, 162, 164, 18, 
	58, 165, 94, 100, 1, 101, 125, 149, 
	161, 265, 167, 168, 169, 170, 171, 176, 
	177, 178, 179, 262, 266, 18, 58, 94, 
	100, 1, 101, 125, 149, 161, 265, 167, 
	168, 169, 170, 171, 176, 177, 178, 179, 
	266
};

static const char _svg_path_trans_actions[] = {
	9, 0, 51, 51, 51, 0, 1, 1, 
	1, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 0, 1, 1, 1, 9, 51, 51, 
	51, 0, 1, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 3, 15, 3, 
	15, 0, 0, 1, 0, 1, 1, 0, 
	0, 0, 3, 3, 0, 0, 0, 0, 
	0, 7, 7, 7, 7, 0, 0, 0, 
	0, 7, 48, 7, 48, 48, 0, 1, 
	0, 1, 1, 0, 0, 0, 3, 15, 
	3, 15, 0, 0, 1, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 9, 51, 51, 51, 0, 1, 1, 
	1, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 3, 15, 3, 15, 0, 0, 1, 
	0, 1, 1, 0, 0, 0, 3, 15, 
	3, 15, 0, 0, 1, 0, 1, 1, 
	0, 0, 0, 3, 15, 3, 15, 0, 
	0, 1, 0, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 0, 0, 9, 
	51, 51, 51, 0, 1, 1, 1, 0, 
	0, 0, 0, 0, 9, 51, 51, 51, 
	9, 51, 51, 51, 0, 1, 1, 1, 
	0, 0, 0, 3, 15, 3, 15, 0, 
	0, 1, 0, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 3, 15, 3, 
	15, 0, 0, 1, 0, 1, 1, 0, 
	0, 0, 0, 0, 9, 51, 51, 51, 
	0, 1, 1, 1, 0, 0, 0, 3, 
	15, 3, 15, 0, 0, 1, 0, 1, 
	1, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 3, 15, 3, 15, 0, 0, 1, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	9, 51, 51, 51, 0, 1, 1, 1, 
	0, 0, 0, 3, 15, 3, 15, 0, 
	0, 1, 0, 1, 1, 0, 0, 0, 
	0, 0, 9, 51, 51, 51, 0, 1, 
	1, 1, 0, 0, 0, 0, 0, 11, 
	54, 54, 54, 11, 54, 54, 54, 11, 
	54, 54, 54, 11, 54, 54, 54, 11, 
	54, 54, 54, 0, 0, 11, 54, 54, 
	54, 11, 54, 54, 54, 11, 54, 54, 
	54, 11, 54, 54, 54, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 5, 45, 5, 45, 45, 
	5, 5, 5, 5, 0, 0, 0, 0, 
	0, 0, 0, 18, 57, 18, 57, 18, 
	18, 0, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 21, 61, 21, 
	61, 21, 21, 0, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 42, 89, 42, 
	89, 42, 42, 0, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 0, 30, 73, 
	30, 73, 30, 30, 0, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 0, 24, 
	65, 24, 65, 24, 24, 0, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 0, 
	36, 81, 36, 81, 36, 36, 0, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	0, 33, 77, 33, 77, 33, 33, 0, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 0, 39, 85, 39, 85, 39, 39, 
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 0, 27, 69, 27, 69, 27, 
	27, 0, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 0, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	0
};

static const char _svg_path_eof_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 18, 0, 21, 21, 42, 
	0, 30, 0, 30, 30, 24, 0, 24, 
	24, 36, 0, 36, 36, 33, 0, 33, 
	33, 39, 0, 39, 39, 27, 0, 27, 
	27, 13, 0, 18, 18, 42, 42, 21
};

static const int svg_path_start = 234;
static const int svg_path_first_final = 234;

static const int svg_path_en_main = 234;


#line 47 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"


SVGPathParser::SVGPathParser(PathSink &sink)
    : _absolute(false)
    , _sink(sink)
    , _z_snap_threshold(0)
    , _curve(NULL)
{
    reset();
}

SVGPathParser::~SVGPathParser()
{
    delete _curve;
}

void SVGPathParser::reset() {
    _absolute = false;
    _current = _initial = Point(0, 0);
    _quad_tangent = _cubic_tangent = Point(0, 0);
    _params.clear();
    delete _curve;
    _curve = NULL;

    
#line 1113 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.cpp"
	{
	cs = svg_path_start;
	}

#line 73 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"

}

void SVGPathParser::parse(char const *str, int len)
{
    if (len < 0) {
        len = std::strlen(str);
    }
    _parse(str, str + len, true);
}

void SVGPathParser::parse(std::string const &s)
{
    _parse(s.c_str(), s.c_str() + s.size(), true);
}

void SVGPathParser::feed(char const *str, int len)
{
    if (len < 0) {
        len = std::strlen(str);
    }
    _parse(str, str + len, false);
}

void SVGPathParser::feed(std::string const &s)
{
    _parse(s.c_str(), s.c_str() + s.size(), false);
}

void SVGPathParser::finish()
{
    char const *empty = "";
    _parse(empty, empty, true);
}

void SVGPathParser::_push(Coord value)
{
    _params.push_back(value);
}

Coord SVGPathParser::_pop()
{
    Coord value = _params.back();
    _params.pop_back();
    return value;
}

bool SVGPathParser::_pop_flag()
{
    return _pop() != 0.0;
}

Coord SVGPathParser::_pop_coord(Dim2 axis)
{
    if (_absolute) {
        return _pop();
    } else {
        return _pop() + _current[axis];
    }
}

Point SVGPathParser::_pop_point()
{
    Coord y = _pop_coord(Y);
    Coord x = _pop_coord(X);
    return Point(x, y);
}

void SVGPathParser::_moveTo(Point const &p)
{
    _pushCurve(NULL); // flush
    _sink.moveTo(p);
    _quad_tangent = _cubic_tangent = _current = _initial = p;
}

void SVGPathParser::_lineTo(Point const &p)
{
    _pushCurve(new LineSegment(_current, p));
    _quad_tangent = _cubic_tangent = _current = p;
}

void SVGPathParser::_curveTo(Point const &c0, Point const &c1, Point const &p)
{
    _pushCurve(new CubicBezier(_current, c0, c1, p));
    _quad_tangent = _current = p;
    _cubic_tangent = p + ( p - c1 );
}

void SVGPathParser::_quadTo(Point const &c, Point const &p)
{
    _pushCurve(new QuadraticBezier(_current, c, p));
    _cubic_tangent = _current = p;
    _quad_tangent = p + ( p - c );
}

void SVGPathParser::_arcTo(Coord rx, Coord ry, Coord angle,
                           bool large_arc, bool sweep, Point const &p)
{
    if (_current == p) {
        return; // ignore invalid (ambiguous) arc segments where start and end point are the same (per SVG spec)
    }

    _pushCurve(new EllipticalArc(_current, fabs(rx), fabs(ry), angle, large_arc, sweep, p));
    _quad_tangent = _cubic_tangent = _current = p;
}

void SVGPathParser::_closePath()
{
    if (_curve && (!_absolute || !_moveto_was_absolute) &&
        are_near(_initial, _current, _z_snap_threshold))
    {
        _curve->setFinal(_initial);
    }

    _pushCurve(NULL); // flush
    _sink.closePath();
    _quad_tangent = _cubic_tangent = _current = _initial;
}

void SVGPathParser::_pushCurve(Curve *c)
{
    if (_curve) {
        _sink.feed(*_curve, false);
        delete _curve;
    }
    _curve = c;
}

void SVGPathParser::_parse(char const *str, char const *strend, bool finish)
{
    char const *p = str;
    char const *pe = strend;
    char const *eof = finish ? pe : NULL;
    char const *start = NULL;

    
#line 1255 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.cpp"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _svg_path_trans_keys + _svg_path_key_offsets[cs];
	_trans = _svg_path_index_offsets[cs];

	_klen = _svg_path_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _svg_path_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _svg_path_indicies[_trans];
	cs = _svg_path_trans_targs[_trans];

	if ( _svg_path_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _svg_path_actions + _svg_path_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 209 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            start = p;
        }
	break;
	case 1:
#line 213 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            if (start) {
                std::string buf(start, p);
                _push(g_ascii_strtod(buf.c_str(), NULL));
                start = NULL;
            } else {
                std::string buf(str, p);
                _push(g_ascii_strtod((_number_part + buf).c_str(), NULL));
                _number_part.clear();
            }
        }
	break;
	case 2:
#line 225 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _push(1.0);
        }
	break;
	case 3:
#line 229 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _push(0.0);
        }
	break;
	case 4:
#line 233 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _absolute = true;
        }
	break;
	case 5:
#line 237 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _absolute = false;
        }
	break;
	case 6:
#line 241 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _moveto_was_absolute = _absolute;
            _moveTo(_pop_point());
        }
	break;
	case 7:
#line 246 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(_pop_point());
        }
	break;
	case 8:
#line 250 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_pop_coord(X), _current[Y]));
        }
	break;
	case 9:
#line 254 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_current[X], _pop_coord(Y)));
        }
	break;
	case 10:
#line 258 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            Point c0 = _pop_point();
            _curveTo(c0, c1, p);
        }
	break;
	case 11:
#line 265 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            _curveTo(_cubic_tangent, c1, p);
        }
	break;
	case 12:
#line 271 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c = _pop_point();
            _quadTo(c, p);
        }
	break;
	case 13:
#line 277 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            _quadTo(_quad_tangent, p);
        }
	break;
	case 14:
#line 282 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point point = _pop_point();
            bool sweep = _pop_flag();
            bool large_arc = _pop_flag();
            double angle = rad_from_deg(_pop());
            double ry = _pop();
            double rx = _pop();

            _arcTo(rx, ry, angle, large_arc, sweep, point);
        }
	break;
	case 15:
#line 293 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _closePath();
        }
	break;
#line 1449 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.cpp"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _svg_path_actions + _svg_path_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 1:
#line 213 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            if (start) {
                std::string buf(start, p);
                _push(g_ascii_strtod(buf.c_str(), NULL));
                start = NULL;
            } else {
                std::string buf(str, p);
                _push(g_ascii_strtod((_number_part + buf).c_str(), NULL));
                _number_part.clear();
            }
        }
	break;
	case 6:
#line 241 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _moveto_was_absolute = _absolute;
            _moveTo(_pop_point());
        }
	break;
	case 7:
#line 246 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(_pop_point());
        }
	break;
	case 8:
#line 250 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_pop_coord(X), _current[Y]));
        }
	break;
	case 9:
#line 254 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_current[X], _pop_coord(Y)));
        }
	break;
	case 10:
#line 258 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            Point c0 = _pop_point();
            _curveTo(c0, c1, p);
        }
	break;
	case 11:
#line 265 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            _curveTo(_cubic_tangent, c1, p);
        }
	break;
	case 12:
#line 271 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c = _pop_point();
            _quadTo(c, p);
        }
	break;
	case 13:
#line 277 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            _quadTo(_quad_tangent, p);
        }
	break;
	case 14:
#line 282 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            Point point = _pop_point();
            bool sweep = _pop_flag();
            bool large_arc = _pop_flag();
            double angle = rad_from_deg(_pop());
            double ry = _pop();
            double rx = _pop();

            _arcTo(rx, ry, angle, large_arc, sweep, point);
        }
	break;
	case 15:
#line 293 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"
	{
            _closePath();
        }
	break;
#line 1555 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.cpp"
		}
	}
	}

	_out: {}
	}

#line 435 "/build/lib2geom/src/lib2geom-1.4/src/2geom/svg-path-parser.rl"


    if (finish) {
        if (cs < svg_path_first_final) {
            throw SVGPathParseError();
        }
    } else if (start != NULL) {
        _number_part = std::string(start, pe);
    }

    if (finish) {
        _pushCurve(NULL);
        _sink.flush();
        reset();
    }
}

void parse_svg_path(char const *str, PathSink &sink)
{
    SVGPathParser parser(sink);
    parser.parse(str);
}

void parse_svg_path_file(FILE *fi, PathSink &sink)
{
    static const size_t BUFFER_SIZE = 4096;
    char buffer[BUFFER_SIZE];
    size_t bytes_read;
    SVGPathParser parser(sink);

    while (true) {
        bytes_read = fread(buffer, 1, BUFFER_SIZE, fi);
        if (bytes_read < BUFFER_SIZE) {
            parser.parse(buffer, bytes_read);
            break;
        } else {
            parser.feed(buffer, bytes_read);
        }
    }
}

} // namespace Geom

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=ragel:cindent:expandtab:shiftwidth=4:softtabstop=4:fileencoding=utf-8:textwidth=99 :
