/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_OUTPUT_DEVICE_V2_SERVER_PROTOCOL_H
#define KDE_OUTPUT_DEVICE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_output_device_v2 The kde_output_device_v2 protocol
 * @section page_ifaces_kde_output_device_v2 Interfaces
 * - @subpage page_iface_kde_output_device_v2 - output configuration representation
 * - @subpage page_iface_kde_output_device_mode_v2 - output mode
 * @section page_copyright_kde_output_device_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 * SPDX-FileCopyrightText: 2021 Méven Car <meven.car@enioka.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_device_mode_v2;
struct kde_output_device_v2;

#ifndef KDE_OUTPUT_DEVICE_V2_INTERFACE
#define KDE_OUTPUT_DEVICE_V2_INTERFACE
/**
 * @page page_iface_kde_output_device_v2 kde_output_device_v2
 * @section page_iface_kde_output_device_v2_desc Description
 *
 * An output device describes a display device available to the compositor.
 * output_device is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global output_device objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the output devices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_kde_output_device_v2_api API
 * See @ref iface_kde_output_device_v2.
 */
/**
 * @defgroup iface_kde_output_device_v2 The kde_output_device_v2 interface
 *
 * An output device describes a display device available to the compositor.
 * output_device is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global output_device objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the output devices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface kde_output_device_v2_interface;
#endif
#ifndef KDE_OUTPUT_DEVICE_MODE_V2_INTERFACE
#define KDE_OUTPUT_DEVICE_MODE_V2_INTERFACE
/**
 * @page page_iface_kde_output_device_mode_v2 kde_output_device_mode_v2
 * @section page_iface_kde_output_device_mode_v2_desc Description
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * kde_output_device.done event. No guarantees are made regarding the order
 * in which properties are sent.
 * @section page_iface_kde_output_device_mode_v2_api API
 * See @ref iface_kde_output_device_mode_v2.
 */
/**
 * @defgroup iface_kde_output_device_mode_v2 The kde_output_device_mode_v2 interface
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * kde_output_device.done event. No guarantees are made regarding the order
 * in which properties are sent.
 */
extern const struct wl_interface kde_output_device_mode_v2_interface;
#endif

#ifndef KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM
#define KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * subpixel geometry information
 *
 * This enumeration describes how the physical pixels on an output are
 * laid out.
 */
enum kde_output_device_v2_subpixel {
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_UNKNOWN = 0,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_NONE = 1,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_RGB = 2,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_BGR = 3,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_RGB = 4,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_BGR = 5,
};
#endif /* KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 subpixel value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_subpixel
 */
static inline bool
kde_output_device_v2_subpixel_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_UNKNOWN:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_NONE:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_RGB:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_BGR:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_RGB:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_BGR:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM
#define KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * transform from framebuffer to output
 *
 * This describes the transform, that a compositor will apply to a
 * surface to compensate for the rotation or mirroring of an
 * output device.
 *
 * The flipped values correspond to an initial flip around a
 * vertical axis followed by rotation.
 *
 * The purpose is mainly to allow clients to render accordingly and
 * tell the compositor, so that for fullscreen surfaces, the
 * compositor is still able to scan out directly client surfaces.
 */
enum kde_output_device_v2_transform {
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_NORMAL = 0,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_90 = 1,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_180 = 2,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_270 = 3,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED = 4,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_90 = 5,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_180 = 6,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_270 = 7,
};
#endif /* KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 transform value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_transform
 */
static inline bool
kde_output_device_v2_transform_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_NORMAL:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_90:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_180:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_270:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_90:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_180:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_270:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes capabilities of the outputdevice
 *
 * Describes what capabilities this device has.
 */
enum kde_output_device_v2_capability {
	/**
	 * if this output_device can use overscan
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_OVERSCAN = 0x1,
	/**
	 * if this outputdevice supports variable refresh rate
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_VRR = 0x2,
	/**
	 * if setting the rgb range is possible
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_RGB_RANGE = 0x4,
	/**
	 * if this outputdevice supports high dynamic range
	 * @since 3
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_HIGH_DYNAMIC_RANGE = 0x8,
	/**
	 * if this outputdevice supports a wide color gamut
	 * @since 3
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_WIDE_COLOR_GAMUT = 0x10,
	/**
	 * if this outputdevice supports autorotation
	 * @since 4
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_AUTO_ROTATE = 0x20,
	/**
	 * if this outputdevice supports icc profiles
	 * @since 5
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_ICC_PROFILE = 0x40,
	/**
	 * if this outputdevice supports the brightness setting
	 * @since 9
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_BRIGHTNESS = 0x80,
	/**
	 * if this outputdevice supports the built-in color profile
	 * @since 12
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_BUILT_IN_COLOR = 0x100,
	/**
	 * if this outputdevice supports DDC/CI
	 * @since 14
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_DDC_CI = 0x200,
	/**
	 * if this outputdevice supports setting max bpc
	 * @since 15
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_MAX_BITS_PER_COLOR = 0x400,
	/**
	 * if this outputdevice supports EDR
	 * @since 16
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_EDR = 0x800,
	/**
	 * if this outputdevice supports the sharpness setting
	 * @since 17
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_SHARPNESS = 0x1000,
};
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_HIGH_DYNAMIC_RANGE_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_WIDE_COLOR_GAMUT_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_AUTO_ROTATE_SINCE_VERSION 4
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_ICC_PROFILE_SINCE_VERSION 5
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_BRIGHTNESS_SINCE_VERSION 9
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_BUILT_IN_COLOR_SINCE_VERSION 12
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_DDC_CI_SINCE_VERSION 14
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_MAX_BITS_PER_COLOR_SINCE_VERSION 15
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_EDR_SINCE_VERSION 16
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_SHARPNESS_SINCE_VERSION 17
#endif /* KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 capability value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_capability
 */
static inline bool
kde_output_device_v2_capability_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_OVERSCAN;
	if (version >= 1)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_VRR;
	if (version >= 1)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_RGB_RANGE;
	if (version >= 3)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_HIGH_DYNAMIC_RANGE;
	if (version >= 3)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_WIDE_COLOR_GAMUT;
	if (version >= 4)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_AUTO_ROTATE;
	if (version >= 5)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_ICC_PROFILE;
	if (version >= 9)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_BRIGHTNESS;
	if (version >= 12)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_BUILT_IN_COLOR;
	if (version >= 14)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_DDC_CI;
	if (version >= 15)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_MAX_BITS_PER_COLOR;
	if (version >= 16)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_EDR;
	if (version >= 17)
		valid |= KDE_OUTPUT_DEVICE_V2_CAPABILITY_SHARPNESS;
	return (value & ~valid) == 0;
}
#endif /* KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum kde_output_device_v2_vrr_policy {
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_NEVER = 0,
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ALWAYS = 1,
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 vrr_policy value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_vrr_policy
 */
static inline bool
kde_output_device_v2_vrr_policy_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_VRR_POLICY_NEVER:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ALWAYS:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_VRR_POLICY_AUTOMATIC:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes RGB range policy
 *
 * Whether full or limited color range should be used
 */
enum kde_output_device_v2_rgb_range {
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_AUTOMATIC = 0,
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_FULL = 1,
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_LIMITED = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 rgb_range value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_rgb_range
 */
static inline bool
kde_output_device_v2_rgb_range_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_RGB_RANGE_AUTOMATIC:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_RGB_RANGE_FULL:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_RGB_RANGE_LIMITED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM
#define KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes when auto rotate should be used
 */
enum kde_output_device_v2_auto_rotate_policy {
	KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_NEVER = 0,
	KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_IN_TABLET_MODE = 1,
	KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ALWAYS = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 auto_rotate_policy value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_auto_rotate_policy
 */
static inline bool
kde_output_device_v2_auto_rotate_policy_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_NEVER:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_IN_TABLET_MODE:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ALWAYS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM
#define KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * which source the compositor should use for the color profile on an output
 */
enum kde_output_device_v2_color_profile_source {
	KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_SRGB = 0,
	KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ICC = 1,
	KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_EDID = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 color_profile_source value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_color_profile_source
 */
static inline bool
kde_output_device_v2_color_profile_source_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_SRGB:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ICC:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_EDID:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM
#define KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * tradeoff between power and accuracy
 *
 * The compositor can do a lot of things that trade between
 * performance, power and color accuracy. This setting describes
 * a high level preference from the user about in which direction
 * that tradeoff should be made.
 */
enum kde_output_device_v2_color_power_tradeoff {
	/**
	 * prefer efficiency and performance
	 */
	KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_EFFICIENCY = 0,
	/**
	 * prefer accuracy
	 */
	KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ACCURACY = 1,
};
#endif /* KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 color_power_tradeoff value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_color_power_tradeoff
 */
static inline bool
kde_output_device_v2_color_power_tradeoff_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_EFFICIENCY:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ACCURACY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_ENUM_IS_VALID */

#ifndef KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM
#define KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * when the compositor may make use of EDR
 */
enum kde_output_device_v2_edr_policy {
	KDE_OUTPUT_DEVICE_V2_EDR_POLICY_NEVER = 0,
	KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ALWAYS = 1,
};
#endif /* KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM_IS_VALID
#define KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM_IS_VALID
/**
 * @ingroup iface_kde_output_device_v2
 * Validate a kde_output_device_v2 edr_policy value.
 *
 * @return true on success, false on error.
 * @ref kde_output_device_v2_edr_policy
 */
static inline bool
kde_output_device_v2_edr_policy_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_DEVICE_V2_EDR_POLICY_NEVER:
		return version >= 1;
	case KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ALWAYS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_DEVICE_V2_EDR_POLICY_ENUM_IS_VALID */

#define KDE_OUTPUT_DEVICE_V2_GEOMETRY 0
#define KDE_OUTPUT_DEVICE_V2_CURRENT_MODE 1
#define KDE_OUTPUT_DEVICE_V2_MODE 2
#define KDE_OUTPUT_DEVICE_V2_DONE 3
#define KDE_OUTPUT_DEVICE_V2_SCALE 4
#define KDE_OUTPUT_DEVICE_V2_EDID 5
#define KDE_OUTPUT_DEVICE_V2_ENABLED 6
#define KDE_OUTPUT_DEVICE_V2_UUID 7
#define KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER 8
#define KDE_OUTPUT_DEVICE_V2_EISA_ID 9
#define KDE_OUTPUT_DEVICE_V2_CAPABILITIES 10
#define KDE_OUTPUT_DEVICE_V2_OVERSCAN 11
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY 12
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE 13
#define KDE_OUTPUT_DEVICE_V2_NAME 14
#define KDE_OUTPUT_DEVICE_V2_HIGH_DYNAMIC_RANGE 15
#define KDE_OUTPUT_DEVICE_V2_SDR_BRIGHTNESS 16
#define KDE_OUTPUT_DEVICE_V2_WIDE_COLOR_GAMUT 17
#define KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY 18
#define KDE_OUTPUT_DEVICE_V2_ICC_PROFILE_PATH 19
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_METADATA 20
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_OVERRIDES 21
#define KDE_OUTPUT_DEVICE_V2_SDR_GAMUT_WIDENESS 22
#define KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE 23
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS 24
#define KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF 25
#define KDE_OUTPUT_DEVICE_V2_DIMMING 26
#define KDE_OUTPUT_DEVICE_V2_REPLICATION_SOURCE 27
#define KDE_OUTPUT_DEVICE_V2_DDC_CI_ALLOWED 28
#define KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR 29
#define KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR_RANGE 30
#define KDE_OUTPUT_DEVICE_V2_AUTOMATIC_MAX_BITS_PER_COLOR_LIMIT 31
#define KDE_OUTPUT_DEVICE_V2_EDR_POLICY 32
#define KDE_OUTPUT_DEVICE_V2_SHARPNESS 33

/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CURRENT_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_ENABLED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_UUID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_EISA_ID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_OVERSCAN_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_NAME_SINCE_VERSION 2
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_HIGH_DYNAMIC_RANGE_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SDR_BRIGHTNESS_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_WIDE_COLOR_GAMUT_SINCE_VERSION 3
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY_SINCE_VERSION 4
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_ICC_PROFILE_PATH_SINCE_VERSION 5
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_METADATA_SINCE_VERSION 6
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_OVERRIDES_SINCE_VERSION 6
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SDR_GAMUT_WIDENESS_SINCE_VERSION 6
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE_SINCE_VERSION 7
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_SINCE_VERSION 8
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF_SINCE_VERSION 10
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_DIMMING_SINCE_VERSION 11
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_REPLICATION_SOURCE_SINCE_VERSION 13
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_DDC_CI_ALLOWED_SINCE_VERSION 14
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR_SINCE_VERSION 15
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR_RANGE_SINCE_VERSION 15
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_AUTOMATIC_MAX_BITS_PER_COLOR_LIMIT_SINCE_VERSION 15
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_EDR_POLICY_SINCE_VERSION 16
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SHARPNESS_SINCE_VERSION 17


/**
 * @ingroup iface_kde_output_device_v2
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x position within the global compositor space
 * @param y y position within the global compositor space
 * @param physical_width width in millimeters of the output
 * @param physical_height height in millimeters of the output
 * @param subpixel subpixel orientation of the output
 * @param make textual description of the manufacturer
 * @param model textual description of the model
 * @param transform transform that maps framebuffer to output
 */
static inline void
kde_output_device_v2_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const char *make, const char *model, int32_t transform)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_GEOMETRY, x, y, physical_width, physical_height, subpixel, make, model, transform);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an current_mode event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_current_mode(struct wl_resource *resource_, struct wl_resource *mode)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_CURRENT_MODE, mode);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an mode event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_mode(struct wl_resource *resource_, struct wl_resource *mode)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_MODE, mode);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_DONE);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an scale event to the client owning the resource.
 * @param resource_ The client's resource
 * @param factor scaling factor of output
 */
static inline void
kde_output_device_v2_send_scale(struct wl_resource *resource_, wl_fixed_t factor)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SCALE, factor);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an edid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param raw base64-encoded EDID string
 */
static inline void
kde_output_device_v2_send_edid(struct wl_resource *resource_, const char *raw)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_EDID, raw);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an enabled event to the client owning the resource.
 * @param resource_ The client's resource
 * @param enabled output enabled state
 */
static inline void
kde_output_device_v2_send_enabled(struct wl_resource *resource_, int32_t enabled)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_ENABLED, enabled);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an uuid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuid output devices ID
 */
static inline void
kde_output_device_v2_send_uuid(struct wl_resource *resource_, const char *uuid)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_UUID, uuid);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an serial_number event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serialNumber textual representation of serial number
 */
static inline void
kde_output_device_v2_send_serial_number(struct wl_resource *resource_, const char *serialNumber)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER, serialNumber);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an eisa_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param eisaId textual representation of EISA identifier
 */
static inline void
kde_output_device_v2_send_eisa_id(struct wl_resource *resource_, const char *eisaId)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_EISA_ID, eisaId);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_capabilities(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_CAPABILITIES, flags);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an overscan event to the client owning the resource.
 * @param resource_ The client's resource
 * @param overscan amount of overscan of the monitor
 */
static inline void
kde_output_device_v2_send_overscan(struct wl_resource *resource_, uint32_t overscan)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_OVERSCAN, overscan);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an vrr_policy event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_vrr_policy(struct wl_resource *resource_, uint32_t vrr_policy)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_VRR_POLICY, vrr_policy);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an rgb_range event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_rgb_range(struct wl_resource *resource_, uint32_t rgb_range)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_RGB_RANGE, rgb_range);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an name event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_name(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_NAME, name);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an high_dynamic_range event to the client owning the resource.
 * @param resource_ The client's resource
 * @param hdr_enabled 1 if enabled, 0 if disabled
 */
static inline void
kde_output_device_v2_send_high_dynamic_range(struct wl_resource *resource_, uint32_t hdr_enabled)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_HIGH_DYNAMIC_RANGE, hdr_enabled);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an sdr_brightness event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_sdr_brightness(struct wl_resource *resource_, uint32_t sdr_brightness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SDR_BRIGHTNESS, sdr_brightness);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an wide_color_gamut event to the client owning the resource.
 * @param resource_ The client's resource
 * @param wcg_enabled 1 if enabled, 0 if disabled
 */
static inline void
kde_output_device_v2_send_wide_color_gamut(struct wl_resource *resource_, uint32_t wcg_enabled)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_WIDE_COLOR_GAMUT, wcg_enabled);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an auto_rotate_policy event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_auto_rotate_policy(struct wl_resource *resource_, uint32_t policy)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_AUTO_ROTATE_POLICY, policy);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an icc_profile_path event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_icc_profile_path(struct wl_resource *resource_, const char *profile_path)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_ICC_PROFILE_PATH, profile_path);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an brightness_metadata event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_peak_brightness in nits
 * @param max_frame_average_brightness in nits
 * @param min_brightness in 0.0001 nits
 */
static inline void
kde_output_device_v2_send_brightness_metadata(struct wl_resource *resource_, uint32_t max_peak_brightness, uint32_t max_frame_average_brightness, uint32_t min_brightness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_METADATA, max_peak_brightness, max_frame_average_brightness, min_brightness);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an brightness_overrides event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_peak_brightness -1 for no override, positive values are the brightness in nits
 * @param max_average_brightness -1 for no override, positive values are the brightness in nits
 * @param min_brightness -1 for no override, positive values are the brightness in 0.0001 nits
 */
static inline void
kde_output_device_v2_send_brightness_overrides(struct wl_resource *resource_, int32_t max_peak_brightness, int32_t max_average_brightness, int32_t min_brightness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_BRIGHTNESS_OVERRIDES, max_peak_brightness, max_average_brightness, min_brightness);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an sdr_gamut_wideness event to the client owning the resource.
 * @param resource_ The client's resource
 * @param gamut_wideness 0 means rec.709 primaries, 10000 means native primaries
 */
static inline void
kde_output_device_v2_send_sdr_gamut_wideness(struct wl_resource *resource_, uint32_t gamut_wideness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SDR_GAMUT_WIDENESS, gamut_wideness);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an color_profile_source event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_color_profile_source(struct wl_resource *resource_, uint32_t source)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_COLOR_PROFILE_SOURCE, source);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an brightness event to the client owning the resource.
 * @param resource_ The client's resource
 * @param brightness brightness in 0-10000
 */
static inline void
kde_output_device_v2_send_brightness(struct wl_resource *resource_, uint32_t brightness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_BRIGHTNESS, brightness);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an color_power_tradeoff event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_color_power_tradeoff(struct wl_resource *resource_, uint32_t preference)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_COLOR_POWER_TRADEOFF, preference);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an dimming event to the client owning the resource.
 * @param resource_ The client's resource
 * @param multiplier multiplier in 0-10000
 */
static inline void
kde_output_device_v2_send_dimming(struct wl_resource *resource_, uint32_t multiplier)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_DIMMING, multiplier);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an replication_source event to the client owning the resource.
 * @param resource_ The client's resource
 * @param source uuid of the source output
 */
static inline void
kde_output_device_v2_send_replication_source(struct wl_resource *resource_, const char *source)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_REPLICATION_SOURCE, source);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an ddc_ci_allowed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param allowed 1 if allowed, 0 if disabled
 */
static inline void
kde_output_device_v2_send_ddc_ci_allowed(struct wl_resource *resource_, uint32_t allowed)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_DDC_CI_ALLOWED, allowed);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an max_bits_per_color event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_bpc 0 for the default / automatic
 */
static inline void
kde_output_device_v2_send_max_bits_per_color(struct wl_resource *resource_, uint32_t max_bpc)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR, max_bpc);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an max_bits_per_color_range event to the client owning the resource.
 * @param resource_ The client's resource
 * @param min_value the minimum supported by the driver
 * @param max_value the maximum supported by the driver
 */
static inline void
kde_output_device_v2_send_max_bits_per_color_range(struct wl_resource *resource_, uint32_t min_value, uint32_t max_value)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_MAX_BITS_PER_COLOR_RANGE, min_value, max_value);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an automatic_max_bits_per_color_limit event to the client owning the resource.
 * @param resource_ The client's resource
 * @param max_bpc_limit which value automatic bpc gets limited to. 0 if not limited
 */
static inline void
kde_output_device_v2_send_automatic_max_bits_per_color_limit(struct wl_resource *resource_, uint32_t max_bpc_limit)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_AUTOMATIC_MAX_BITS_PER_COLOR_LIMIT, max_bpc_limit);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an edr_policy event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_edr_policy(struct wl_resource *resource_, uint32_t policy)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_EDR_POLICY, policy);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an sharpness event to the client owning the resource.
 * @param resource_ The client's resource
 * @param sharpness sharpness in 0-10000
 */
static inline void
kde_output_device_v2_send_sharpness(struct wl_resource *resource_, uint32_t sharpness)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SHARPNESS, sharpness);
}

#define KDE_OUTPUT_DEVICE_MODE_V2_SIZE 0
#define KDE_OUTPUT_DEVICE_MODE_V2_REFRESH 1
#define KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED 2
#define KDE_OUTPUT_DEVICE_MODE_V2_REMOVED 3

/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_REFRESH_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_REMOVED_SINCE_VERSION 1


/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param width width of the mode in hardware units
 * @param height height of the mode in hardware units
 */
static inline void
kde_output_device_mode_v2_send_size(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_SIZE, width, height);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an refresh event to the client owning the resource.
 * @param resource_ The client's resource
 * @param refresh vertical refresh rate in mHz
 */
static inline void
kde_output_device_mode_v2_send_refresh(struct wl_resource *resource_, int32_t refresh)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_REFRESH, refresh);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an preferred event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_mode_v2_send_preferred(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_mode_v2_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_REMOVED);
}

#ifdef  __cplusplus
}
#endif

#endif
