
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpagewidgetmodel_wrapper.h"

// Wrappers providing overrides
#include "kpagemodel_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QHash>
#include <QList>
#include <QMap>
#include <QString>
#include <QStringList>
#include <kpagewidgetmodel.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPageWidgetModel_Type = nullptr;
static PyTypeObject *Sbk_KPageWidgetModel_TypeF(void)
{
    return _Sbk_KPageWidgetModel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPageWidgetModelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPageWidgetModelWrapper::KPageWidgetModelWrapper(::QObject * parent) : KPageWidgetModel(parent)
{
}

::QModelIndex KPageWidgetModelWrapper::buddy(const ::QModelIndex & index) const
{
    static const char *funcName = "buddy";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::buddy(index);
    }
    return KPageModelWrapper::sbk_o_buddy("KPageWidgetModel", funcName, gil, pyOverride, index);
}

bool KPageWidgetModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "canDropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canDropMimeData(data, action, row, column, parent);
    }
    return KPageModelWrapper::sbk_o_canDropMimeData("KPageWidgetModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool KPageWidgetModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    static const char *funcName = "canFetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canFetchMore(parent);
    }
    return KPageModelWrapper::sbk_o_canFetchMore("KPageWidgetModel", funcName, gil, pyOverride, parent);
}

void KPageWidgetModelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPageWidgetModel", funcName, gil, pyOverride, event);
}

bool KPageWidgetModelWrapper::clearItemData(const ::QModelIndex & index)
{
    static const char *funcName = "clearItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::clearItemData(index);
    }
    return KPageModelWrapper::sbk_o_canFetchMore("KPageWidgetModel", funcName, gil, pyOverride, index);
}

int KPageWidgetModelWrapper::columnCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "columnCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::columnCount(parent);
    }
    return KPageModelWrapper::sbk_o_columnCount("KPageWidgetModel", funcName, gil, pyOverride, parent);
}

void KPageWidgetModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageWidgetModel", funcName, gil, pyOverride, signal);
}

void KPageWidgetModelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPageWidgetModel", funcName, gil, pyOverride, event);
}

::QVariant KPageWidgetModelWrapper::data(const ::QModelIndex & index, int role) const
{
    static const char *funcName = "data";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::data(index, role);
    }
    return KPageModelWrapper::sbk_o_data("KPageWidgetModel", funcName, gil, pyOverride, index, role);
}

void KPageWidgetModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageWidgetModel", funcName, gil, pyOverride, signal);
}

bool KPageWidgetModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    static const char *funcName = "dropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }
    return KPageModelWrapper::sbk_o_canDropMimeData("KPageWidgetModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool KPageWidgetModelWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPageWidgetModel", funcName, gil, pyOverride, event);
}

bool KPageWidgetModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPageWidgetModel", funcName, gil, pyOverride, watched, event);
}

void KPageWidgetModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    static const char *funcName = "fetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::fetchMore(parent);
    }
    KPageModelWrapper::sbk_o_fetchMore("KPageWidgetModel", funcName, gil, pyOverride, parent);
}

::QFlags<Qt::ItemFlag> KPageWidgetModelWrapper::flags(const ::QModelIndex & index) const
{
    static const char *funcName = "flags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::flags(index);
    }
    return KPageModelWrapper::sbk_o_flags("KPageWidgetModel", funcName, gil, pyOverride, index);
}

bool KPageWidgetModelWrapper::hasChildren(const ::QModelIndex & parent) const
{
    static const char *funcName = "hasChildren";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::hasChildren(parent);
    }
    return KPageModelWrapper::sbk_o_canFetchMore("KPageWidgetModel", funcName, gil, pyOverride, parent);
}

::QVariant KPageWidgetModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    static const char *funcName = "headerData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::headerData(section, orientation, role);
    }
    return KPageModelWrapper::sbk_o_headerData("KPageWidgetModel", funcName, gil, pyOverride, section, orientation, role);
}

::QModelIndex KPageWidgetModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "index";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::index(row, column, parent);
    }
    return KPageModelWrapper::sbk_o_index("KPageWidgetModel", funcName, gil, pyOverride, row, column, parent);
}

bool KPageWidgetModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageWidgetModel", funcName, gil, pyOverride, column, count, parent);
}

bool KPageWidgetModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageWidgetModel", funcName, gil, pyOverride, row, count, parent);
}

::QMap<int,QVariant> KPageWidgetModelWrapper::itemData(const ::QModelIndex & index) const
{
    static const char *funcName = "itemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::itemData(index);
    }
    return KPageModelWrapper::sbk_o_itemData("KPageWidgetModel", funcName, gil, pyOverride, index);
}

::QList<QModelIndex> KPageWidgetModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    static const char *funcName = "match";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }
    return KPageModelWrapper::sbk_o_match("KPageWidgetModel", funcName, gil, pyOverride, start, role, value, hits, flags);
}

::QMimeData * KPageWidgetModelWrapper::mimeData(const ::QList<QModelIndex> & indexes) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeData(indexes);
    }
    return KPageModelWrapper::sbk_o_mimeData("KPageWidgetModel", funcName, gil, pyOverride, indexes);
}

::QStringList KPageWidgetModelWrapper::mimeTypes() const
{
    static const char *funcName = "mimeTypes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeTypes();
    }
    return KPageModelWrapper::sbk_o_mimeTypes("KPageWidgetModel", funcName, gil, pyOverride);
}

bool KPageWidgetModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
    return KPageModelWrapper::sbk_o_moveColumns("KPageWidgetModel", funcName, gil, pyOverride, sourceParent, sourceColumn, count, destinationParent, destinationChild);
}

bool KPageWidgetModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
    return KPageModelWrapper::sbk_o_moveColumns("KPageWidgetModel", funcName, gil, pyOverride, sourceParent, sourceRow, count, destinationParent, destinationChild);
}

void KPageWidgetModelWrapper::multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const
{
    static const char *funcName = "multiData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::multiData(index, roleDataSpan);
    }
    KPageModelWrapper::sbk_o_multiData("KPageWidgetModel", funcName, gil, pyOverride, index, roleDataSpan);
}

::QModelIndex KPageWidgetModelWrapper::parent(const ::QModelIndex & index) const
{
    static const char *funcName = "parent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::parent(index);
    }
    return KPageModelWrapper::sbk_o_buddy("KPageWidgetModel", funcName, gil, pyOverride, index);
}

bool KPageWidgetModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageWidgetModel", funcName, gil, pyOverride, column, count, parent);
}

bool KPageWidgetModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageWidgetModel", funcName, gil, pyOverride, row, count, parent);
}

void KPageWidgetModelWrapper::resetInternalData()
{
    static const char *funcName = "resetInternalData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::resetInternalData();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPageWidgetModel", funcName, gil, pyOverride);
}

void KPageWidgetModelWrapper::revert()
{
    static const char *funcName = "revert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::revert();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPageWidgetModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> KPageWidgetModelWrapper::roleNames() const
{
    static const char *funcName = "roleNames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::roleNames();
    }
    return KPageModelWrapper::sbk_o_roleNames("KPageWidgetModel", funcName, gil, pyOverride);
}

int KPageWidgetModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "rowCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::rowCount(parent);
    }
    return KPageModelWrapper::sbk_o_columnCount("KPageWidgetModel", funcName, gil, pyOverride, parent);
}

bool KPageWidgetModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    static const char *funcName = "setData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageWidgetModel::setData(index, value, role);
    }
    return KPageModelWrapper::sbk_o_setData("KPageWidgetModel", funcName, gil, pyOverride, index, value, role);
}

bool KPageWidgetModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    static const char *funcName = "setHeaderData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
    return KPageModelWrapper::sbk_o_setHeaderData("KPageWidgetModel", funcName, gil, pyOverride, section, orientation, value, role);
}

bool KPageWidgetModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    static const char *funcName = "setItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setItemData(index, roles);
    }
    return KPageModelWrapper::sbk_o_setItemData("KPageWidgetModel", funcName, gil, pyOverride, index, roles);
}

::QModelIndex KPageWidgetModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    static const char *funcName = "sibling";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sibling(row, column, idx);
    }
    return KPageModelWrapper::sbk_o_index("KPageWidgetModel", funcName, gil, pyOverride, row, column, idx);
}

void KPageWidgetModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    static const char *funcName = "sort";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sort(column, order);
    }
    KPageModelWrapper::sbk_o_sort("KPageWidgetModel", funcName, gil, pyOverride, column, order);
}

::QSize KPageWidgetModelWrapper::span(const ::QModelIndex & index) const
{
    static const char *funcName = "span";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::span(index);
    }
    return KPageModelWrapper::sbk_o_span("KPageWidgetModel", funcName, gil, pyOverride, index);
}

bool KPageWidgetModelWrapper::submit()
{
    static const char *funcName = "submit";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::submit();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPageWidgetModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> KPageWidgetModelWrapper::supportedDragActions() const
{
    static const char *funcName = "supportedDragActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDragActions();
    }
    return KPageModelWrapper::sbk_o_supportedDragActions("KPageWidgetModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> KPageWidgetModelWrapper::supportedDropActions() const
{
    static const char *funcName = "supportedDropActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDropActions();
    }
    return KPageModelWrapper::sbk_o_supportedDragActions("KPageWidgetModel", funcName, gil, pyOverride);
}

void KPageWidgetModelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageWidgetModel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPageWidgetModel", funcName, gil, pyOverride, event);
}

const QMetaObject *KPageWidgetModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPageWidgetModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPageWidgetModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPageWidgetModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPageWidgetModelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPageWidgetModelWrapper *>(this));
    }
    return KPageWidgetModel::qt_metacast(_clname);
}

KPageWidgetModelWrapper::~KPageWidgetModelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPageWidgetModel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPageWidgetModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPageWidgetModel >()))
        return -1;

    KPageWidgetModelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPageWidgetModel", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPageWidgetModel::KPageWidgetModel(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KPageWidgetModel(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPageWidgetModel(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPageWidgetModel(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPageWidgetModelWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPageWidgetModelWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPageWidgetModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPageWidgetModelFunc_addPage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addPage", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPageWidgetModel::addPage(KPageWidgetItem*)
    // 1: KPageWidgetModel::addPage(QWidget*,QString)->KPageWidgetItem*
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // addPage(QWidget*,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addPage(KPageWidgetItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addPage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addPage(KPageWidgetItem *item)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addPage(KPageWidgetItem*)
                cppSelf->addPage(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // addPage(QWidget *widget, const QString &name)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addPage(QWidget*,QString)
                KPageWidgetItem * cppResult = cppSelf->addPage(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_addSubPage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addSubPage", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPageWidgetModel::addSubPage(KPageWidgetItem*,KPageWidgetItem*)
    // 1: KPageWidgetModel::addSubPage(KPageWidgetItem*,QWidget*,QString)->KPageWidgetItem*
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            overloadId = 1; // addSubPage(KPageWidgetItem*,QWidget*,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addSubPage(KPageWidgetItem*,KPageWidgetItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addSubPage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addSubPage(KPageWidgetItem *parent, KPageWidgetItem *item)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::KPageWidgetItem *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addSubPage(KPageWidgetItem*,KPageWidgetItem*)
                cppSelf->addSubPage(cppArg0, cppArg1);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // addSubPage(KPageWidgetItem *parent, QWidget *widget, const QString &name)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addSubPage(KPageWidgetItem*,QWidget*,QString)
                KPageWidgetItem * cppResult = cppSelf->addSubPage(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_columnCount(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    if (PyArg_ParseTuple(args, "|O:columnCount", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::columnCount(const QModelIndex&=)const->int
    if (numArgs == 0) {
        overloadId = 0; // columnCount(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // columnCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // columnCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::columnCount(*cppArg0)
                : const_cast<const ::KPageWidgetModel *>(cppSelf)->columnCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_data(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    if (PyArg_ParseTuple(args, "|OO:data", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::data(QModelIndex,int=)const->QVariant
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // data(QModelIndex,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // data(QModelIndex,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"role", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "data", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = Qt::DisplayRole;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // data(QModelIndex,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::data(*cppArg0, cppArg1)
                : const_cast<const ::KPageWidgetModel *>(cppSelf)->data(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_flags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::flags(QModelIndex)const->QFlags<Qt::ItemFlag>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // flags(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "flags", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // flags(QModelIndex)const
            QFlags<Qt::ItemFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::flags(*cppArg0)
                : const_cast<const ::KPageWidgetModel *>(cppSelf)->flags(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_ItemFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_index(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:index", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::index(int,int,const QModelIndex&=)const->QModelIndex
    // 1: KPageWidgetModel::index(const KPageWidgetItem*)const->QModelIndex
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))) {
        overloadId = 1; // index(const KPageWidgetItem*)const
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // index(int,int,QModelIndex)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2])))) {
            overloadId = 0; // index(int,int,QModelIndex)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // index(int row, int column, const QModelIndex &parent) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "index", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QModelIndex cppArg2_local = QModelIndex();
            ::QModelIndex *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
                if (pythonToCpp[2].isValue())
                    pythonToCpp[2](pyArgs[2], &cppArg2_local);
                else
                    pythonToCpp[2](pyArgs[2], &cppArg2);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // index(int,int,QModelIndex)const
                QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::index(cppArg0, cppArg1, *cppArg2)
                    : const_cast<const ::KPageWidgetModel *>(cppSelf)->index(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
        case 1: // index(const KPageWidgetItem *item) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "index", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // index(const KPageWidgetItem*)const
                QModelIndex cppResult = const_cast<const ::KPageWidgetModel *>(cppSelf)->index(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_insertPage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertPage", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPageWidgetModel::insertPage(KPageWidgetItem*,KPageWidgetItem*)
    // 1: KPageWidgetModel::insertPage(KPageWidgetItem*,QWidget*,QString)->KPageWidgetItem*
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            overloadId = 1; // insertPage(KPageWidgetItem*,QWidget*,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[1])))) {
            overloadId = 0; // insertPage(KPageWidgetItem*,KPageWidgetItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertPage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // insertPage(KPageWidgetItem *before, KPageWidgetItem *item)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::KPageWidgetItem *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // insertPage(KPageWidgetItem*,KPageWidgetItem*)
                cppSelf->insertPage(cppArg0, cppArg1);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // insertPage(KPageWidgetItem *before, QWidget *widget, const QString &name)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KPageWidgetItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // insertPage(KPageWidgetItem*,QWidget*,QString)
                KPageWidgetItem * cppResult = cppSelf->insertPage(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_item(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetModel::item(QModelIndex)const->KPageWidgetItem*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // item(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "item", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // item(QModelIndex)const
            KPageWidgetItem * cppResult = const_cast<const ::KPageWidgetModel *>(cppSelf)->item(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_parent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "parent", 0, 1, &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::parent(QModelIndex)const->QModelIndex
    // 1: QObject::parent()const->QObject*
    if (numArgs == 0) {
        overloadId = 1; // parent()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // parent(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "parent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // parent(const QModelIndex &index) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // parent(QModelIndex)const
                QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::parent(*cppArg0)
                    : const_cast<const ::KPageWidgetModel *>(cppSelf)->parent(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
        case 1: // parent() const
        {

            // parent()const
            QObject * cppResult = const_cast<const ::QObject *>(reinterpret_cast<QObject *>(cppSelf))->parent();
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), cppResult);

            // Ownership transferences.
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_removePage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageWidgetModel::removePage(KPageWidgetItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArg)))) {
        overloadId = 0; // removePage(KPageWidgetItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removePage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KPageWidgetItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removePage(KPageWidgetItem*)
            cppSelf->removePage(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageWidgetModelFunc_rowCount(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    if (PyArg_ParseTuple(args, "|O:rowCount", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::rowCount(const QModelIndex&=)const->int
    if (numArgs == 0) {
        overloadId = 0; // rowCount(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // rowCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // rowCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KPageWidgetModel *>(cppSelf)->::KPageWidgetModel::rowCount(*cppArg0)
                : const_cast<const ::KPageWidgetModel *>(cppSelf)->rowCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageWidgetModelFunc_setData(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setData", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::setData(QModelIndex,QVariant,int=)->bool
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setData(QModelIndex,QVariant,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setData(QModelIndex,QVariant,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setData", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"role", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setData", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = Qt::EditRole;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setData(QModelIndex,QVariant,int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KPageWidgetModel::setData(*cppArg0, cppArg1, cppArg2)
                : cppSelf->setData(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPageWidgetModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPageWidgetModel_methods[] = {
    {"addPage", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_addPage), METH_VARARGS, nullptr},
    {"addSubPage", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_addSubPage), METH_VARARGS, nullptr},
    {"columnCount", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_columnCount), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"data", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_data), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_flags), METH_O, nullptr},
    {"index", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_index), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"insertPage", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_insertPage), METH_VARARGS, nullptr},
    {"item", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_item), METH_O, nullptr},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_parent), METH_VARARGS, nullptr},
    {"removePage", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_removePage), METH_O, nullptr},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_rowCount), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_KPageWidgetModelFunc_setData), METH_VARARGS|METH_KEYWORDS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPageWidgetModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPageWidgetModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPageWidgetModelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPageWidgetModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPageWidgetModel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPageWidgetModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPageWidgetModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPageWidgetModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPageWidgetModel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPageWidgetModel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPageWidgetModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPageWidgetModel_spec = {
    "1:KWidgetsAddons.KPageWidgetModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPageWidgetModel_slots
};

} //extern "C"

static void *Sbk_KPageWidgetModel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPageWidgetModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPageWidgetModel_PythonToCpp_KPageWidgetModel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPageWidgetModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPageWidgetModel_PythonToCpp_KPageWidgetModel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPageWidgetModel_TypeF()))
        return KPageWidgetModel_PythonToCpp_KPageWidgetModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPageWidgetModel_PTR_CppToPython_KPageWidgetModel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPageWidgetModel *>(const_cast<void *>(cppIn)), Sbk_KPageWidgetModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPageWidgetModel_SignatureStrings[] = {
    "KWidgetsAddons.KPageWidgetModel(self,parent:PySide6.QtCore.QObject=nullptr)",
    "1:KWidgetsAddons.KPageWidgetModel.addPage(self,item:KWidgetsAddons.KPageWidgetItem)",
    "0:KWidgetsAddons.KPageWidgetModel.addPage(self,widget:PySide6.QtWidgets.QWidget,name:QString)->KWidgetsAddons.KPageWidgetItem",
    "1:KWidgetsAddons.KPageWidgetModel.addSubPage(self,parent:KWidgetsAddons.KPageWidgetItem,item:KWidgetsAddons.KPageWidgetItem)",
    "0:KWidgetsAddons.KPageWidgetModel.addSubPage(self,parent:KWidgetsAddons.KPageWidgetItem,widget:PySide6.QtWidgets.QWidget,name:QString)->KWidgetsAddons.KPageWidgetItem",
    "KWidgetsAddons.KPageWidgetModel.columnCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->int",
    "KWidgetsAddons.KPageWidgetModel.data(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],role:int=Qt.DisplayRole)->QVariant",
    "KWidgetsAddons.KPageWidgetModel.flags(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.Qt.ItemFlag",
    "1:KWidgetsAddons.KPageWidgetModel.index(self,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->PySide6.QtCore.QModelIndex",
    "0:KWidgetsAddons.KPageWidgetModel.index(self,item:KWidgetsAddons.KPageWidgetItem)->PySide6.QtCore.QModelIndex",
    "1:KWidgetsAddons.KPageWidgetModel.insertPage(self,before:KWidgetsAddons.KPageWidgetItem,item:KWidgetsAddons.KPageWidgetItem)",
    "0:KWidgetsAddons.KPageWidgetModel.insertPage(self,before:KWidgetsAddons.KPageWidgetItem,widget:PySide6.QtWidgets.QWidget,name:QString)->KWidgetsAddons.KPageWidgetItem",
    "KWidgetsAddons.KPageWidgetModel.item(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->KWidgetsAddons.KPageWidgetItem",
    "1:KWidgetsAddons.KPageWidgetModel.parent(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.QModelIndex",
    "0:KWidgetsAddons.KPageWidgetModel.parent(self)->PySide6.QtCore.QObject",
    "KWidgetsAddons.KPageWidgetModel.removePage(self,item:KWidgetsAddons.KPageWidgetItem)",
    "KWidgetsAddons.KPageWidgetModel.rowCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->int",
    "KWidgetsAddons.KPageWidgetModel.setData(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],value:QVariant,role:int=Qt.EditRole)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KPageWidgetModel_SignatureByteSize = 388;
static constexpr uint8_t KPageWidgetModel_SignatureBytes[388] = {
    0x78, 0xda, 0xcd, 0x95, 0x51, 0x4b, 0xc3, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x29, 0x7c, 0x5c, 0xa1,
    0x06, 0x7d, 0xf1, 0xa1, 0x30, 0x41, 0x36, 0x85, 0x31, 0xc4, 0xd5, 0xa1, 0x3e, 0x88, 0x0f, 0xe9,
    0x72, 0x2b, 0x91, 0x34, 0x29, 0xc9, 0x75, 0x73, 0xdf, 0xde, 0xb4, 0x29, 0xac, 0x1b, 0xda, 0x76,
    0x73, 0x2d, 0xbe, 0x85, 0x24, 0xf7, 0xbf, 0xdf, 0xe5, 0xee, 0x72, 0xb3, 0x37, 0xce, 0x62, 0x40,
    0x73, 0xc7, 0x98, 0x92, 0x86, 0xcc, 0xe6, 0x34, 0x06, 0xb7, 0xf5, 0xa8, 0x18, 0x88, 0xa1, 0x01,
    0xb1, 0xf2, 0x53, 0xaa, 0x41, 0x62, 0x30, 0xdf, 0x2e, 0x38, 0x83, 0x1b, 0x12, 0xe2, 0x58, 0x69,
    0x20, 0xe1, 0x53, 0xf4, 0x09, 0x4b, 0x1c, 0xc9, 0x4c, 0x88, 0x14, 0xb5, 0x37, 0xb8, 0x0e, 0x66,
    0xf5, 0x6a, 0x84, 0x32, 0x96, 0x6f, 0x39, 0x55, 0x8e, 0x90, 0xd4, 0x58, 0x4c, 0xed, 0xb1, 0x37,
    0xb8, 0x3a, 0x4e, 0x73, 0x53, 0x1c, 0x54, 0x48, 0x4b, 0x63, 0x12, 0xba, 0x85, 0x2f, 0x69, 0x02,
    0x41, 0xb8, 0x40, 0xcd, 0x65, 0xec, 0x5d, 0xde, 0xd6, 0xbb, 0x6f, 0x17, 0xd1, 0x22, 0x8b, 0x76,
    0x00, 0xe5, 0x53, 0xd5, 0xeb, 0x9e, 0x31, 0xf4, 0x13, 0x9c, 0x9f, 0xf9, 0x8d, 0x9a, 0x20, 0x97,
    0x4a, 0x64, 0x89, 0x1c, 0xab, 0x4c, 0xe2, 0x1e, 0x25, 0x6e, 0x53, 0xab, 0x4f, 0x5e, 0x24, 0x57,
    0xf2, 0xfd, 0xb0, 0xb4, 0x0a, 0xd3, 0xa9, 0x64, 0xf0, 0xe5, 0x5f, 0x1c, 0x9e, 0xcd, 0x41, 0x1b,
    0x6e, 0xd0, 0x6a, 0xec, 0x6e, 0x7d, 0x8c, 0x2a, 0x26, 0x43, 0xcf, 0x52, 0x73, 0x89, 0x8d, 0x68,
    0x8c, 0x22, 0x2d, 0x6b, 0x31, 0xb7, 0x3b, 0x33, 0x92, 0xaf, 0x95, 0x80, 0xc0, 0x72, 0x8c, 0x42,
    0x24, 0x13, 0x6e, 0x52, 0x41, 0xb7, 0xcf, 0x76, 0xcb, 0xc2, 0x85, 0xaf, 0x54, 0x73, 0xda, 0x82,
    0x70, 0x25, 0x68, 0x6c, 0xba, 0x43, 0xb4, 0x28, 0x87, 0xf7, 0x90, 0xe4, 0x59, 0x7d, 0xb0, 0x7e,
    0x5b, 0x54, 0x7f, 0xc1, 0xe4, 0xf0, 0xb4, 0xda, 0xe4, 0xb1, 0xfa, 0x2e, 0xdd, 0xc5, 0xb2, 0x9f,
    0x44, 0xff, 0xae, 0xd8, 0xa2, 0x83, 0x2a, 0x01, 0xb4, 0xe9, 0xc9, 0x5a, 0x6f, 0x6d, 0x9e, 0xcb,
    0x80, 0xc6, 0x5d, 0xbf, 0x46, 0xb0, 0xb2, 0x22, 0x3d, 0x7d, 0x16, 0xa7, 0x39, 0xef, 0xf9, 0xb3,
    0xc8, 0x63, 0xed, 0xb4, 0xdc, 0xff, 0xfc, 0xe1, 0xbb, 0xa2, 0xee, 0xb5, 0x25, 0x8f, 0xaa, 0xe8,
    0x0a, 0xdf, 0x0f, 0x52, 0x6e, 0x64, 0x37, 0xa6, 0x41, 0x43, 0xa2, 0xd6, 0x70, 0xe4, 0xa8, 0x6e,
    0x14, 0x55, 0x9b, 0x7f, 0x39, 0x05, 0x0c, 0xe0, 0xa4, 0xdb, 0x41, 0xb0, 0xa6, 0x22, 0xb3, 0x4d,
    0x52, 0x7e, 0xfa, 0x7b, 0x73, 0xe1, 0x9e, 0x71, 0x2c, 0x87, 0x42, 0xa4, 0x94, 0x18, 0x7c, 0x03,
    0x45, 0x87, 0x7e, 0xfb
};
#endif

PyTypeObject *init_KPageWidgetModel(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX].type;

    Shiboken::AutoDecRef Sbk_KPageWidgetModel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]))));

    _Sbk_KPageWidgetModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPageWidgetModel",
        "KPageWidgetModel*",
        &Sbk_KPageWidgetModel_spec,
        &Shiboken::callCppDestructor< KPageWidgetModel >,
        Sbk_KPageWidgetModel_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KPageWidgetModel_Type; // references _Sbk_KPageWidgetModel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPageWidgetModel_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPageWidgetModel_SignatureBytes, KPageWidgetModel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPageWidgetModel_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPageWidgetModel_PythonToCpp_KPageWidgetModel_PTR,
        is_KPageWidgetModel_PythonToCpp_KPageWidgetModel_PTR_Convertible,
        KPageWidgetModel_PTR_CppToPython_KPageWidgetModel);

    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetModel");
    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetModel*");
    Shiboken::Conversions::registerConverterName(converter, "KPageWidgetModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPageWidgetModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPageWidgetModelWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPageWidgetModel_TypeF(), &Sbk_KPageWidgetModel_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KPageWidgetModel::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPageWidgetModel::staticMetaObject, sizeof(KPageWidgetModelWrapper));

    return pyType;
}
