/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* OpenCL Builtin handling                                                    *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#include "llvm/ADT/StringRef.h"
using namespace clang;

enum OpenCLTypeID {
  OCLT_atomic_double,
  OCLT_atomic_flag,
  OCLT_atomic_float,
  OCLT_atomic_half,
  OCLT_atomic_int,
  OCLT_atomic_intptr_t,
  OCLT_atomic_long,
  OCLT_atomic_ptrdiff_t,
  OCLT_atomic_size_t,
  OCLT_atomic_uint,
  OCLT_atomic_uintptr_t,
  OCLT_atomic_ulong,
  OCLT_bool,
  OCLT_char,
  OCLT_clk_event_t,
  OCLT_clk_profiling_info,
  OCLT_double,
  OCLT_event_t,
  OCLT_float,
  OCLT_half,
  OCLT___half,
  OCLT_image1d_t,
  OCLT_image1d_array_t,
  OCLT_image1d_buffer_t,
  OCLT_image2d_t,
  OCLT_image2d_array_t,
  OCLT_image2d_array_depth_t,
  OCLT_image2d_array_msaa_t,
  OCLT_image2d_array_msaa_depth_t,
  OCLT_image2d_depth_t,
  OCLT_image2d_msaa_t,
  OCLT_image2d_msaa_depth_t,
  OCLT_image3d_t,
  OCLT_int,
  OCLT_intptr_t,
  OCLT_long,
  OCLT_cl_mem_fence_flags,
  OCLT_memory_order,
  OCLT_memory_scope,
  OCLT_ndrange_t,
  OCLT_ptrdiff_t,
  OCLT_queue_t,
  OCLT_reserve_id_t,
  OCLT_sampler_t,
  OCLT_short,
  OCLT_size_t,
  OCLT_uchar,
  OCLT_uint,
  OCLT_uintptr_t,
  OCLT_ulong,
  OCLT_ushort,
  OCLT_void,
  OCLT_AGenType1,
  OCLT_AGenTypeN,
  OCLT_AGenTypeNNoScalar,
  OCLT_AI2UGenTypeN,
  OCLT_AIGenType1,
  OCLT_AIGenTypeN,
  OCLT_AIGenTypeNNoScalar,
  OCLT_CharShortGenType1,
  OCLT_FGenTypeN,
  OCLT_GenTypeCharVecAndScalar,
  OCLT_GenTypeCharVecNoScalar,
  OCLT_GenTypeDoubleVec1234,
  OCLT_GenTypeDoubleVecAndScalar,
  OCLT_GenTypeDoubleVecNoScalar,
  OCLT_GenTypeFloatVec1234,
  OCLT_GenTypeFloatVecAndScalar,
  OCLT_GenTypeFloatVecNoScalar,
  OCLT_GenTypeHalfVec1234,
  OCLT_GenTypeHalfVecAndScalar,
  OCLT_GenTypeHalfVecNoScalar,
  OCLT_GenTypeIntVecAndScalar,
  OCLT_GenTypeIntVecNoScalar,
  OCLT_GenTypeLongVecAndScalar,
  OCLT_GenTypeLongVecNoScalar,
  OCLT_GenTypeShortVecAndScalar,
  OCLT_GenTypeShortVecNoScalar,
  OCLT_GenTypeUCharVecAndScalar,
  OCLT_GenTypeUCharVecNoScalar,
  OCLT_GenTypeUIntVecAndScalar,
  OCLT_GenTypeUIntVecNoScalar,
  OCLT_GenTypeULongVecAndScalar,
  OCLT_GenTypeULongVecNoScalar,
  OCLT_GenTypeUShortVecAndScalar,
  OCLT_GenTypeUShortVecNoScalar,
  OCLT_IntLongFloatGenType1,
  OCLT_SGenTypeN,
  OCLT_UGenTypeN,
};

// Image access qualifier.
enum OpenCLAccessQual : unsigned char {
  OCLAQ_None,
  OCLAQ_ReadOnly,
  OCLAQ_WriteOnly,
  OCLAQ_ReadWrite
};

// Represents a return type or argument type.
struct OpenCLTypeStruct {
  // A type (e.g. float, int, ...).
  const OpenCLTypeID ID;
  // Vector size (if applicable; 0 for scalars and generic types).
  const unsigned VectorWidth;
  // 0 if the type is not a pointer.
  const bool IsPointer : 1;
  // 0 if the type is not const.
  const bool IsConst : 1;
  // 0 if the type is not volatile.
  const bool IsVolatile : 1;
  // Access qualifier.
  const OpenCLAccessQual AccessQualifier;
  // Address space of the pointer (if applicable).
  const LangAS AS;
};

// One overload of an OpenCL builtin function.
struct OpenCLBuiltinStruct {
  // Index of the signature in the OpenCLTypeStruct table.
  const unsigned SigTableIndex;
  // Entries between index SigTableIndex and (SigTableIndex + NumTypes - 1) in
  // the SignatureTable represent the complete signature.  The first type at
  // index SigTableIndex is the return type.
  const unsigned NumTypes;
  // Function attribute __attribute__((pure))
  const bool IsPure : 1;
  // Function attribute __attribute__((const))
  const bool IsConst : 1;
  // Function attribute __attribute__((convergent))
  const bool IsConv : 1;
  // OpenCL extension(s) required for this overload.
  const unsigned short Extension;
  // OpenCL versions in which this overload is available.
  const unsigned short Versions;
};

static const char *FunctionExtensionTable[] = {
  // 0: ArmIntegerDotProductAccumulateInt16
  "cl_arm_integer_dot_product_accumulate_int16",
  // 1: ArmIntegerDotProductAccumulateInt8
  "cl_arm_integer_dot_product_accumulate_int8",
  // 2: ArmIntegerDotProductAccumulateSaturateInt8
  "cl_arm_integer_dot_product_accumulate_saturate_int8",
  // 3: ArmIntegerDotProductInt8
  "cl_arm_integer_dot_product_int8",
  // 4: FuncExtFloatAtomicsFp16GenericASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add __opencl_c_ext_fp16_global_atomic_add",
  // 5: FuncExtFloatAtomicsFp16GenericASLoadStore
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store __opencl_c_ext_fp16_local_atomic_load_store",
  // 6: FuncExtFloatAtomicsFp16GenericASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max __opencl_c_ext_fp16_global_atomic_min_max",
  // 7: FuncExtFloatAtomicsFp16GlobalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_add",
  // 8: FuncExtFloatAtomicsFp16GlobalASLoadStore
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store",
  // 9: FuncExtFloatAtomicsFp16GlobalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_min_max",
  // 10: FuncExtFloatAtomicsFp16LocalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add",
  // 11: FuncExtFloatAtomicsFp16LocalASLoadStore
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_load_store",
  // 12: FuncExtFloatAtomicsFp16LocalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max",
  // 13: FuncExtFloatAtomicsFp32GenericASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add __opencl_c_ext_fp32_global_atomic_add",
  // 14: FuncExtFloatAtomicsFp32GenericASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max __opencl_c_ext_fp32_global_atomic_min_max",
  // 15: FuncExtFloatAtomicsFp32GlobalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_add",
  // 16: FuncExtFloatAtomicsFp32GlobalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_min_max",
  // 17: FuncExtFloatAtomicsFp32LocalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add",
  // 18: FuncExtFloatAtomicsFp32LocalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max",
  // 19: FuncExtFloatAtomicsFp64GenericASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add __opencl_c_ext_fp64_global_atomic_add",
  // 20: FuncExtFloatAtomicsFp64GenericASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max __opencl_c_ext_fp64_global_atomic_min_max",
  // 21: FuncExtFloatAtomicsFp64GlobalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_add",
  // 22: FuncExtFloatAtomicsFp64GlobalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_min_max",
  // 23: FuncExtFloatAtomicsFp64LocalASAdd
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add",
  // 24: FuncExtFloatAtomicsFp64LocalASMinMax
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max",
  // 25: FuncExtKhrExtendedBitOps
  "cl_khr_extended_bit_ops",
  // 26: FuncExtKhrGlMsaaSharing
  "cl_khr_gl_msaa_sharing",
  // 27: FuncExtKhrGlobalInt32BaseAtomics
  "cl_khr_global_int32_base_atomics",
  // 28: FuncExtKhrGlobalInt32ExtendedAtomics
  "cl_khr_global_int32_extended_atomics",
  // 29: FuncExtKhrInt64BaseAtomics
  "cl_khr_int64_base_atomics",
  // 30: FuncExtKhrInt64ExtendedAtomics
  "cl_khr_int64_extended_atomics",
  // 31: FuncExtKhrLocalInt32BaseAtomics
  "cl_khr_local_int32_base_atomics",
  // 32: FuncExtKhrLocalInt32ExtendedAtomics
  "cl_khr_local_int32_extended_atomics",
  // 33: FuncExtKhrMipmapImage
  "cl_khr_mipmap_image",
  // 34: FuncExtKhrMipmapImageWrites
  "cl_khr_mipmap_image_writes",
  // 35: FuncExtKhrSubgroupBallot
  "cl_khr_subgroup_ballot",
  // 36: FuncExtKhrSubgroupClusteredReduce
  "cl_khr_subgroup_clustered_reduce",
  // 37: FuncExtKhrSubgroupExtendedTypes
  "cl_khr_subgroup_extended_types",
  // 38: FuncExtKhrSubgroupNonUniformArithmetic
  "cl_khr_subgroup_non_uniform_arithmetic",
  // 39: FuncExtKhrSubgroupNonUniformVote
  "cl_khr_subgroup_non_uniform_vote",
  // 40: FuncExtKhrSubgroupShuffle
  "cl_khr_subgroup_shuffle",
  // 41: FuncExtKhrSubgroupShuffleRelative
  "cl_khr_subgroup_shuffle_relative",
  // 42: FuncExtKhrSubgroups
  "__opencl_subgroup_builtins",
  // 43: FuncExtNone
  "",
  // 44: FuncExtOpenCLCDeviceEnqueue
  "__opencl_c_device_enqueue",
  // 45: FuncExtOpenCLCGenericAddressSpace
  "__opencl_c_generic_address_space",
  // 46: FuncExtOpenCLCNamedAddressSpaceBuiltins
  "__opencl_c_named_address_space_builtins",
  // 47: FuncExtOpenCLCPipes
  "__opencl_c_pipes",
  // 48: FuncExtOpenCLCReadWriteImages
  "__opencl_c_read_write_images",
  // 49: FuncExtOpenCLCWGCollectiveFunctions
  "__opencl_c_work_group_collective_functions",
  // 50: FuncExtOpenCLCxx
  "__cplusplus",
  // 51: anonymous_10046
  "__opencl_c_integer_dot_product_input_4x8bit",
  // 52: anonymous_10055
  "__opencl_c_integer_dot_product_input_4x8bit_packed",
  // 53: anonymous_10064
  "cl_khr_subgroup_rotate",
  // 54: anonymous_10067
  "cl_khr_kernel_clock __opencl_c_kernel_clock_scope_device",
  // 55: anonymous_10070
  "cl_khr_kernel_clock __opencl_c_kernel_clock_scope_work_group",
  // 56: anonymous_10073
  "cl_khr_kernel_clock __opencl_c_kernel_clock_scope_sub_group",
  // 57: anonymous_8060
  "__opencl_c_generic_address_space __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 58: anonymous_8062
  "__opencl_c_generic_address_space __opencl_c_atomic_scope_device",
  // 59: anonymous_8258
  "__opencl_c_named_address_space_builtins __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 60: anonymous_8260
  "__opencl_c_named_address_space_builtins __opencl_c_atomic_scope_device",
  // 61: anonymous_8817
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 62: anonymous_8820
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store __opencl_c_atomic_scope_device",
  // 63: anonymous_8830
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 64: anonymous_8833
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_add __opencl_c_atomic_scope_device",
  // 65: anonymous_8837
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 66: anonymous_8840
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_add __opencl_c_atomic_scope_device",
  // 67: anonymous_8844
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 68: anonymous_8847
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_add __opencl_c_atomic_scope_device",
  // 69: anonymous_8860
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 70: anonymous_8863
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_min_max __opencl_c_atomic_scope_device",
  // 71: anonymous_8867
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 72: anonymous_8870
  "cl_ext_float_atomics __opencl_c_ext_fp32_global_atomic_min_max __opencl_c_atomic_scope_device",
  // 73: anonymous_8874
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 74: anonymous_8877
  "cl_ext_float_atomics __opencl_c_ext_fp64_global_atomic_min_max __opencl_c_atomic_scope_device",
  // 75: anonymous_8891
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_load_store __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 76: anonymous_8894
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_load_store __opencl_c_atomic_scope_device",
  // 77: anonymous_8904
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 78: anonymous_8907
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add __opencl_c_atomic_scope_device",
  // 79: anonymous_8911
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 80: anonymous_8914
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add __opencl_c_atomic_scope_device",
  // 81: anonymous_8918
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 82: anonymous_8921
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add __opencl_c_atomic_scope_device",
  // 83: anonymous_8934
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 84: anonymous_8937
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max __opencl_c_atomic_scope_device",
  // 85: anonymous_8941
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 86: anonymous_8944
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max __opencl_c_atomic_scope_device",
  // 87: anonymous_8948
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 88: anonymous_8951
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max __opencl_c_atomic_scope_device",
  // 89: anonymous_8965
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store __opencl_c_ext_fp16_local_atomic_load_store __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 90: anonymous_8968
  "cl_ext_float_atomics __opencl_c_ext_fp16_global_atomic_load_store __opencl_c_ext_fp16_local_atomic_load_store __opencl_c_atomic_scope_device",
  // 91: anonymous_8978
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add __opencl_c_ext_fp16_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 92: anonymous_8981
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_add __opencl_c_ext_fp16_global_atomic_add __opencl_c_atomic_scope_device",
  // 93: anonymous_8985
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add __opencl_c_ext_fp32_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 94: anonymous_8988
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_add __opencl_c_ext_fp32_global_atomic_add __opencl_c_atomic_scope_device",
  // 95: anonymous_8992
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add __opencl_c_ext_fp64_global_atomic_add __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 96: anonymous_8995
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_add __opencl_c_ext_fp64_global_atomic_add __opencl_c_atomic_scope_device",
  // 97: anonymous_9008
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max __opencl_c_ext_fp16_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 98: anonymous_9011
  "cl_ext_float_atomics __opencl_c_ext_fp16_local_atomic_min_max __opencl_c_ext_fp16_global_atomic_min_max __opencl_c_atomic_scope_device",
  // 99: anonymous_9015
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max __opencl_c_ext_fp32_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 100: anonymous_9018
  "cl_ext_float_atomics __opencl_c_ext_fp32_local_atomic_min_max __opencl_c_ext_fp32_global_atomic_min_max __opencl_c_atomic_scope_device",
  // 101: anonymous_9022
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max __opencl_c_ext_fp64_global_atomic_min_max __opencl_c_atomic_order_seq_cst __opencl_c_atomic_scope_device",
  // 102: anonymous_9025
  "cl_ext_float_atomics __opencl_c_ext_fp64_local_atomic_min_max __opencl_c_ext_fp64_global_atomic_min_max __opencl_c_atomic_scope_device",
};

static const OpenCLTypeStruct TypeTable[] = {
  // 0
  {OCLT_AGenType1, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 1
  {OCLT_AGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 2
  {OCLT_AGenTypeNNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 3
  {OCLT_AI2UGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 4
  {OCLT_AIGenType1, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 5
  {OCLT_AIGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 6
  {OCLT_AIGenTypeNNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 7
  {OCLT_atomic_double, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 8
  {OCLT_atomic_flag, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 9
  {OCLT_atomic_float, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 10
  {OCLT_atomic_half, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 11
  {OCLT_atomic_int, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 12
  {OCLT_atomic_intptr_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 13
  {OCLT_atomic_long, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 14
  {OCLT_atomic_ptrdiff_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 15
  {OCLT_atomic_size_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 16
  {OCLT_atomic_uint, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 17
  {OCLT_atomic_uintptr_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 18
  {OCLT_atomic_ulong, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 19
  {OCLT_bool, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 20
  {OCLT_char, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 21
  {OCLT_CharShortGenType1, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 22
  {OCLT_clk_event_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 23
  {OCLT_clk_profiling_info, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 24
  {OCLT_double, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 25
  {OCLT_event_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 26
  {OCLT_FGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 27
  {OCLT_float, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 28
  {OCLT_GenTypeCharVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 29
  {OCLT_GenTypeCharVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 30
  {OCLT_GenTypeDoubleVec1234, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 31
  {OCLT_GenTypeDoubleVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 32
  {OCLT_GenTypeDoubleVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 33
  {OCLT_GenTypeFloatVec1234, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 34
  {OCLT_GenTypeFloatVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 35
  {OCLT_GenTypeFloatVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 36
  {OCLT_GenTypeHalfVec1234, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 37
  {OCLT_GenTypeHalfVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 38
  {OCLT_GenTypeHalfVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 39
  {OCLT_GenTypeIntVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 40
  {OCLT_GenTypeIntVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 41
  {OCLT_GenTypeLongVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 42
  {OCLT_GenTypeLongVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 43
  {OCLT_GenTypeShortVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 44
  {OCLT_GenTypeShortVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 45
  {OCLT_GenTypeUCharVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 46
  {OCLT_GenTypeUCharVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 47
  {OCLT_GenTypeUIntVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 48
  {OCLT_GenTypeUIntVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 49
  {OCLT_GenTypeULongVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 50
  {OCLT_GenTypeULongVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 51
  {OCLT_GenTypeUShortVecAndScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 52
  {OCLT_GenTypeUShortVecNoScalar, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 53
  {OCLT_half, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 54
  {OCLT___half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 55
  {OCLT___half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 56
  {OCLT___half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 57
  {OCLT___half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 58
  {OCLT___half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 59
  {OCLT___half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 60
  {OCLT___half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 61
  {OCLT___half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 62
  {OCLT___half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 63
  {OCLT___half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 64
  {OCLT_image1d_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 65
  {OCLT_image1d_array_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 66
  {OCLT_image1d_buffer_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 67
  {OCLT_image2d_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 68
  {OCLT_image2d_array_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 69
  {OCLT_image2d_array_depth_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 70
  {OCLT_image2d_array_msaa_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 71
  {OCLT_image2d_array_msaa_depth_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 72
  {OCLT_image2d_depth_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 73
  {OCLT_image2d_msaa_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 74
  {OCLT_image2d_msaa_depth_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 75
  {OCLT_image3d_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 76
  {OCLT_int, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 77
  {OCLT_IntLongFloatGenType1, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 78
  {OCLT_intptr_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 79
  {OCLT_long, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 80
  {OCLT_cl_mem_fence_flags, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 81
  {OCLT_memory_order, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 82
  {OCLT_memory_scope, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 83
  {OCLT_ndrange_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 84
  {OCLT_ptrdiff_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 85
  {OCLT_queue_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 86
  {OCLT_reserve_id_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 87
  {OCLT_SGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 88
  {OCLT_sampler_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 89
  {OCLT_short, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 90
  {OCLT_size_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 91
  {OCLT_uchar, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 92
  {OCLT_UGenTypeN, 0, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 93
  {OCLT_uint, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 94
  {OCLT_uintptr_t, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 95
  {OCLT_ulong, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 96
  {OCLT_ushort, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 97
  {OCLT_void, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 98
  {OCLT_double, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 99
  {OCLT_double, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 100
  {OCLT_double, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 101
  {OCLT_double, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 102
  {OCLT_double, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 103
  {OCLT_half, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 104
  {OCLT_half, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 105
  {OCLT_half, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 106
  {OCLT_half, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 107
  {OCLT_half, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 108
  {OCLT___half, 1, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 109
  {OCLT_char, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 110
  {OCLT_char, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 111
  {OCLT___half, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 112
  {OCLT_char, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 113
  {OCLT_char, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 114
  {OCLT_char, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 115
  {OCLT_uchar, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 116
  {OCLT_uchar, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 117
  {OCLT_uchar, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 118
  {OCLT_uchar, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 119
  {OCLT_uchar, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 120
  {OCLT_short, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 121
  {OCLT_short, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 122
  {OCLT_short, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 123
  {OCLT_short, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 124
  {OCLT_short, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 125
  {OCLT_ushort, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 126
  {OCLT_ushort, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 127
  {OCLT_ushort, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 128
  {OCLT_ushort, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 129
  {OCLT_ushort, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 130
  {OCLT_int, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 131
  {OCLT_int, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 132
  {OCLT_int, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 133
  {OCLT_int, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 134
  {OCLT_int, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 135
  {OCLT_uint, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 136
  {OCLT_uint, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 137
  {OCLT_uint, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 138
  {OCLT_uint, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 139
  {OCLT_uint, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 140
  {OCLT_long, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 141
  {OCLT_long, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 142
  {OCLT_long, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 143
  {OCLT_long, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 144
  {OCLT_long, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 145
  {OCLT_ulong, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 146
  {OCLT_ulong, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 147
  {OCLT_ulong, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 148
  {OCLT_ulong, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 149
  {OCLT_ulong, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 150
  {OCLT_FGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 151
  {OCLT_GenTypeIntVecAndScalar, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 152
  {OCLT_FGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 153
  {OCLT_GenTypeIntVecAndScalar, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 154
  {OCLT_FGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 155
  {OCLT_GenTypeIntVecAndScalar, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 156
  {OCLT_FGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 157
  {OCLT_GenTypeIntVecAndScalar, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 158
  {OCLT_char, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 159
  {OCLT_uchar, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 160
  {OCLT_short, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 161
  {OCLT_ushort, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 162
  {OCLT_int, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 163
  {OCLT_uint, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 164
  {OCLT_long, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 165
  {OCLT_ulong, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 166
  {OCLT_float, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 167
  {OCLT_double, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 168
  {OCLT_half, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 169
  {OCLT_char, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 170
  {OCLT_uchar, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 171
  {OCLT_short, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 172
  {OCLT_ushort, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 173
  {OCLT_int, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 174
  {OCLT_uint, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 175
  {OCLT_long, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 176
  {OCLT_ulong, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 177
  {OCLT_float, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 178
  {OCLT_double, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 179
  {OCLT_half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 180
  {OCLT_char, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 181
  {OCLT_uchar, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 182
  {OCLT_short, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 183
  {OCLT_ushort, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 184
  {OCLT_int, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 185
  {OCLT_uint, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 186
  {OCLT_long, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 187
  {OCLT_ulong, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 188
  {OCLT_float, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 189
  {OCLT_double, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 190
  {OCLT_half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 191
  {OCLT_char, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 192
  {OCLT_uchar, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 193
  {OCLT_short, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 194
  {OCLT_ushort, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 195
  {OCLT_int, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 196
  {OCLT_uint, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 197
  {OCLT_long, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 198
  {OCLT_ulong, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 199
  {OCLT_float, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 200
  {OCLT_double, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 201
  {OCLT_half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 202
  {OCLT_char, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 203
  {OCLT_uchar, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 204
  {OCLT_short, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 205
  {OCLT_ushort, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 206
  {OCLT_int, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 207
  {OCLT_uint, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 208
  {OCLT_long, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 209
  {OCLT_ulong, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 210
  {OCLT_float, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 211
  {OCLT_double, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 212
  {OCLT_half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 213
  {OCLT_char, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 214
  {OCLT_uchar, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 215
  {OCLT_short, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 216
  {OCLT_ushort, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 217
  {OCLT_int, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 218
  {OCLT_uint, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 219
  {OCLT_long, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 220
  {OCLT_ulong, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 221
  {OCLT_float, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 222
  {OCLT_double, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 223
  {OCLT_half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 224
  {OCLT_char, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 225
  {OCLT_uchar, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 226
  {OCLT_short, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 227
  {OCLT_ushort, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 228
  {OCLT_int, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 229
  {OCLT_uint, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 230
  {OCLT_long, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 231
  {OCLT_ulong, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 232
  {OCLT_float, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 233
  {OCLT_double, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 234
  {OCLT_half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 235
  {OCLT_char, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 236
  {OCLT_uchar, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 237
  {OCLT_short, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 238
  {OCLT_ushort, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 239
  {OCLT_int, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 240
  {OCLT_uint, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 241
  {OCLT_long, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 242
  {OCLT_ulong, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 243
  {OCLT_float, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 244
  {OCLT_double, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 245
  {OCLT_half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 246
  {OCLT_char, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 247
  {OCLT_uchar, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 248
  {OCLT_short, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 249
  {OCLT_ushort, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 250
  {OCLT_int, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 251
  {OCLT_uint, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 252
  {OCLT_long, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 253
  {OCLT_ulong, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 254
  {OCLT_float, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 255
  {OCLT_double, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 256
  {OCLT_half, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 257
  {OCLT_float, 2, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 258
  {OCLT_char, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 259
  {OCLT_uchar, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 260
  {OCLT_short, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 261
  {OCLT_ushort, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 262
  {OCLT_int, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 263
  {OCLT_uint, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 264
  {OCLT_long, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 265
  {OCLT_ulong, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 266
  {OCLT_float, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 267
  {OCLT_double, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 268
  {OCLT_half, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_constant},
  // 269
  {OCLT_float, 3, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 270
  {OCLT_float, 4, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 271
  {OCLT_float, 8, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 272
  {OCLT_void, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 273
  {OCLT_void, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 274
  {OCLT_void, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 275
  {OCLT_AGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 276
  {OCLT_AGenTypeN, 0, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 277
  {OCLT_AGenTypeN, 0, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 278
  {OCLT_AGenTypeN, 0, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 279
  {OCLT_AGenTypeN, 0, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_local},
  // 280
  {OCLT_event_t, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 281
  {OCLT_int, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 282
  {OCLT_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 283
  {OCLT_uint, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 284
  {OCLT_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 285
  {OCLT_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 286
  {OCLT_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 287
  {OCLT_long, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 288
  {OCLT_long, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 289
  {OCLT_ulong, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 290
  {OCLT_float, 16, 0, 0, 0, OCLAQ_None, clang::LangAS::Default},
  // 291
  {OCLT_ulong, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 292
  {OCLT_long, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 293
  {OCLT_ulong, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 294
  {OCLT_float, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 295
  {OCLT_float, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 296
  {OCLT_float, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 297
  {OCLT_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 298
  {OCLT_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 299
  {OCLT_atomic_int, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 300
  {OCLT_atomic_uint, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 301
  {OCLT_atomic_long, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 302
  {OCLT_atomic_ulong, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 303
  {OCLT_atomic_float, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 304
  {OCLT_atomic_double, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 305
  {OCLT_atomic_uintptr_t, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 306
  {OCLT_atomic_flag, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 307
  {OCLT_atomic_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 308
  {OCLT_atomic_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 309
  {OCLT_atomic_long, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 310
  {OCLT_atomic_ulong, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 311
  {OCLT_atomic_float, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 312
  {OCLT_atomic_double, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 313
  {OCLT_atomic_uintptr_t, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 314
  {OCLT_atomic_flag, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 315
  {OCLT_atomic_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 316
  {OCLT_atomic_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 317
  {OCLT_atomic_long, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 318
  {OCLT_atomic_ulong, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 319
  {OCLT_atomic_float, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 320
  {OCLT_atomic_double, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 321
  {OCLT_atomic_uintptr_t, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 322
  {OCLT_atomic_flag, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 323
  {OCLT_atomic_int, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 324
  {OCLT_atomic_uint, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 325
  {OCLT_atomic_long, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 326
  {OCLT_atomic_ulong, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 327
  {OCLT_atomic_float, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 328
  {OCLT_atomic_double, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 329
  {OCLT_atomic_uintptr_t, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 330
  {OCLT_atomic_flag, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 331
  {OCLT_atomic_half, 1, 0, 0, 1, OCLAQ_None, clang::LangAS::Default},
  // 332
  {OCLT_atomic_half, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_global},
  // 333
  {OCLT_atomic_half, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_local},
  // 334
  {OCLT_atomic_half, 1, 1, 0, 1, OCLAQ_None, clang::LangAS::opencl_generic},
  // 335
  {OCLT_image1d_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 336
  {OCLT_image2d_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 337
  {OCLT_image1d_array_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 338
  {OCLT_image3d_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 339
  {OCLT_image2d_array_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 340
  {OCLT_image2d_depth_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 341
  {OCLT_image2d_array_depth_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 342
  {OCLT_image1d_buffer_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 343
  {OCLT_image2d_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 344
  {OCLT_image1d_array_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 345
  {OCLT_image3d_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 346
  {OCLT_image2d_array_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 347
  {OCLT_image1d_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 348
  {OCLT_image1d_buffer_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 349
  {OCLT_image2d_depth_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 350
  {OCLT_image2d_array_depth_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 351
  {OCLT_image2d_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 352
  {OCLT_image2d_array_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 353
  {OCLT_image1d_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 354
  {OCLT_image1d_buffer_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 355
  {OCLT_image1d_array_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 356
  {OCLT_image3d_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 357
  {OCLT_image2d_depth_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 358
  {OCLT_image2d_array_depth_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 359
  {OCLT_clk_event_t, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 360
  {OCLT_clk_event_t, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 361
  {OCLT_clk_event_t, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_generic},
  // 362
  {OCLT_void, 1, 1, 0, 0, OCLAQ_None, clang::LangAS::opencl_global},
  // 363
  {OCLT_size_t, 1, 0, 1, 0, OCLAQ_None, clang::LangAS::Default},
  // 364
  {OCLT_size_t, 1, 1, 1, 0, OCLAQ_None, clang::LangAS::opencl_private},
  // 365
  {OCLT_image2d_msaa_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 366
  {OCLT_image2d_array_msaa_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 367
  {OCLT_image2d_msaa_depth_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 368
  {OCLT_image2d_array_msaa_depth_t, 0, 0, 0, 0, OCLAQ_ReadOnly, clang::LangAS::Default},
  // 369
  {OCLT_image2d_msaa_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 370
  {OCLT_image2d_array_msaa_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 371
  {OCLT_image2d_msaa_depth_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 372
  {OCLT_image2d_array_msaa_depth_t, 0, 0, 0, 0, OCLAQ_WriteOnly, clang::LangAS::Default},
  // 373
  {OCLT_image2d_msaa_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 374
  {OCLT_image2d_array_msaa_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 375
  {OCLT_image2d_msaa_depth_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
  // 376
  {OCLT_image2d_array_msaa_depth_t, 0, 0, 0, 0, OCLAQ_ReadWrite, clang::LangAS::Default},
};

static const unsigned short SignatureTable[] = {
  // 0
  257, 257, 
  // 2
  107, 134, 
  // 4
  0, 0, 
  // 6
  4, 4, 
  // 8
  76, 76, 
  // 10
  53, 76, 
  // 12
  103, 130, 
  // 14
  0, 0, 93, 
  // 17
  104, 131, 
  // 19
  4, 4, 93, 
  // 22
  76, 76, 93, 
  // 25
  105, 132, 
  // 27
  5, 5, 5, 93, 93, 
  // 32
  87, 87, 93, 93, 
  // 36
  87, 92, 93, 93, 
  // 40
  92, 87, 93, 93, 
  // 44
  92, 92, 93, 93, 
  // 48
  5, 5, 
  // 50
  93, 117, 117, 
  // 53
  76, 112, 112, 
  // 56
  76, 117, 112, 
  // 59
  106, 133, 
  // 61
  76, 112, 117, 
  // 64
  93, 117, 117, 93, 
  // 68
  76, 112, 112, 76, 
  // 72
  76, 117, 112, 76, 
  // 76
  76, 112, 117, 76, 
  // 80
  93, 93, 93, 
  // 83
  76, 93, 93, 
  // 86
  93, 93, 93, 93, 
  // 90
  76, 93, 93, 76, 
  // 94
  0, 0, 76, 
  // 97
  0, 0, 76, 93, 
  // 101
  95, 
  // 102
  135, 
  // 103
  93, 125, 125, 93, 
  // 107
  76, 120, 120, 76, 
  // 111
  269, 269, 
  // 113
  270, 270, 
  // 115
  53, 93, 
  // 117
  103, 135, 
  // 119
  104, 136, 
  // 121
  105, 137, 
  // 123
  106, 138, 
  // 125
  271, 271, 
  // 127
  107, 139, 
  // 129
  290, 290, 
  // 131
  27, 24, 
  // 133
  53, 79, 
  // 135
  103, 140, 
  // 137
  104, 141, 
  // 139
  105, 142, 
  // 141
  106, 143, 
  // 143
  107, 144, 
  // 145
  257, 98, 
  // 147
  53, 95, 
  // 149
  103, 145, 
  // 151
  104, 146, 
  // 153
  105, 147, 
  // 155
  106, 148, 
  // 157
  269, 99, 
  // 159
  107, 149, 
  // 161
  270, 100, 
  // 163
  20, 27, 
  // 165
  109, 257, 
  // 167
  110, 269, 
  // 169
  112, 270, 
  // 171
  113, 271, 
  // 173
  114, 290, 
  // 175
  271, 101, 
  // 177
  290, 102, 
  // 179
  20, 24, 
  // 181
  109, 98, 
  // 183
  110, 99, 
  // 185
  112, 100, 
  // 187
  113, 101, 
  // 189
  114, 102, 
  // 191
  20, 53, 
  // 193
  109, 103, 
  // 195
  110, 104, 
  // 197
  112, 105, 
  // 199
  113, 106, 
  // 201
  114, 107, 
  // 203
  20, 20, 
  // 205
  109, 109, 
  // 207
  110, 110, 
  // 209
  112, 112, 
  // 211
  113, 113, 
  // 213
  114, 114, 
  // 215
  20, 91, 
  // 217
  109, 115, 
  // 219
  110, 116, 
  // 221
  112, 117, 
  // 223
  113, 118, 
  // 225
  114, 119, 
  // 227
  27, 53, 
  // 229
  20, 89, 
  // 231
  109, 120, 
  // 233
  110, 121, 
  // 235
  112, 122, 
  // 237
  113, 123, 
  // 239
  257, 103, 
  // 241
  114, 124, 
  // 243
  269, 104, 
  // 245
  270, 105, 
  // 247
  20, 96, 
  // 249
  109, 125, 
  // 251
  110, 126, 
  // 253
  112, 127, 
  // 255
  113, 128, 
  // 257
  271, 106, 
  // 259
  114, 129, 
  // 261
  290, 107, 
  // 263
  20, 76, 
  // 265
  109, 130, 
  // 267
  110, 131, 
  // 269
  112, 132, 
  // 271
  113, 133, 
  // 273
  114, 134, 
  // 275
  20, 93, 
  // 277
  109, 135, 
  // 279
  110, 136, 
  // 281
  112, 137, 
  // 283
  113, 138, 
  // 285
  114, 139, 
  // 287
  20, 79, 
  // 289
  109, 140, 
  // 291
  110, 141, 
  // 293
  112, 142, 
  // 295
  113, 143, 
  // 297
  114, 144, 
  // 299
  20, 95, 
  // 301
  109, 145, 
  // 303
  110, 146, 
  // 305
  112, 147, 
  // 307
  113, 148, 
  // 309
  114, 149, 
  // 311
  27, 20, 
  // 313
  257, 109, 
  // 315
  91, 27, 
  // 317
  115, 257, 
  // 319
  116, 269, 
  // 321
  117, 270, 
  // 323
  118, 271, 
  // 325
  119, 290, 
  // 327
  269, 110, 
  // 329
  270, 112, 
  // 331
  271, 113, 
  // 333
  91, 24, 
  // 335
  115, 98, 
  // 337
  116, 99, 
  // 339
  117, 100, 
  // 341
  118, 101, 
  // 343
  119, 102, 
  // 345
  290, 114, 
  // 347
  91, 53, 
  // 349
  115, 103, 
  // 351
  116, 104, 
  // 353
  117, 105, 
  // 355
  118, 106, 
  // 357
  119, 107, 
  // 359
  91, 20, 
  // 361
  115, 109, 
  // 363
  116, 110, 
  // 365
  117, 112, 
  // 367
  118, 113, 
  // 369
  119, 114, 
  // 371
  91, 91, 
  // 373
  115, 115, 
  // 375
  116, 116, 
  // 377
  117, 117, 
  // 379
  118, 118, 
  // 381
  119, 119, 
  // 383
  91, 89, 
  // 385
  115, 120, 
  // 387
  116, 121, 
  // 389
  117, 122, 
  // 391
  118, 123, 
  // 393
  119, 124, 
  // 395
  27, 91, 
  // 397
  257, 115, 
  // 399
  91, 96, 
  // 401
  115, 125, 
  // 403
  116, 126, 
  // 405
  117, 127, 
  // 407
  118, 128, 
  // 409
  269, 116, 
  // 411
  119, 129, 
  // 413
  270, 117, 
  // 415
  271, 118, 
  // 417
  91, 76, 
  // 419
  115, 130, 
  // 421
  116, 131, 
  // 423
  117, 132, 
  // 425
  118, 133, 
  // 427
  290, 119, 
  // 429
  119, 134, 
  // 431
  91, 93, 
  // 433
  115, 135, 
  // 435
  116, 136, 
  // 437
  117, 137, 
  // 439
  118, 138, 
  // 441
  119, 139, 
  // 443
  91, 79, 
  // 445
  115, 140, 
  // 447
  116, 141, 
  // 449
  117, 142, 
  // 451
  118, 143, 
  // 453
  119, 144, 
  // 455
  91, 95, 
  // 457
  115, 145, 
  // 459
  116, 146, 
  // 461
  117, 147, 
  // 463
  118, 148, 
  // 465
  119, 149, 
  // 467
  89, 27, 
  // 469
  120, 257, 
  // 471
  121, 269, 
  // 473
  122, 270, 
  // 475
  123, 271, 
  // 477
  124, 290, 
  // 479
  27, 89, 
  // 481
  257, 120, 
  // 483
  269, 121, 
  // 485
  89, 24, 
  // 487
  120, 98, 
  // 489
  121, 99, 
  // 491
  122, 100, 
  // 493
  123, 101, 
  // 495
  124, 102, 
  // 497
  270, 122, 
  // 499
  271, 123, 
  // 501
  290, 124, 
  // 503
  89, 53, 
  // 505
  120, 103, 
  // 507
  121, 104, 
  // 509
  122, 105, 
  // 511
  123, 106, 
  // 513
  124, 107, 
  // 515
  89, 20, 
  // 517
  120, 109, 
  // 519
  121, 110, 
  // 521
  122, 112, 
  // 523
  123, 113, 
  // 525
  124, 114, 
  // 527
  89, 91, 
  // 529
  120, 115, 
  // 531
  121, 116, 
  // 533
  122, 117, 
  // 535
  123, 118, 
  // 537
  124, 119, 
  // 539
  89, 89, 
  // 541
  120, 120, 
  // 543
  121, 121, 
  // 545
  122, 122, 
  // 547
  123, 123, 
  // 549
  124, 124, 
  // 551
  89, 96, 
  // 553
  120, 125, 
  // 555
  121, 126, 
  // 557
  122, 127, 
  // 559
  123, 128, 
  // 561
  27, 96, 
  // 563
  124, 129, 
  // 565
  257, 125, 
  // 567
  269, 126, 
  // 569
  89, 76, 
  // 571
  120, 130, 
  // 573
  121, 131, 
  // 575
  122, 132, 
  // 577
  123, 133, 
  // 579
  270, 127, 
  // 581
  124, 134, 
  // 583
  271, 128, 
  // 585
  290, 129, 
  // 587
  89, 93, 
  // 589
  120, 135, 
  // 591
  121, 136, 
  // 593
  122, 137, 
  // 595
  123, 138, 
  // 597
  124, 139, 
  // 599
  89, 79, 
  // 601
  120, 140, 
  // 603
  121, 141, 
  // 605
  122, 142, 
  // 607
  123, 143, 
  // 609
  124, 144, 
  // 611
  89, 95, 
  // 613
  120, 145, 
  // 615
  121, 146, 
  // 617
  122, 147, 
  // 619
  123, 148, 
  // 621
  124, 149, 
  // 623
  96, 27, 
  // 625
  125, 257, 
  // 627
  126, 269, 
  // 629
  127, 270, 
  // 631
  128, 271, 
  // 633
  129, 290, 
  // 635
  27, 76, 
  // 637
  96, 24, 
  // 639
  125, 98, 
  // 641
  126, 99, 
  // 643
  127, 100, 
  // 645
  128, 101, 
  // 647
  129, 102, 
  // 649
  257, 130, 
  // 651
  269, 131, 
  // 653
  270, 132, 
  // 655
  96, 53, 
  // 657
  125, 103, 
  // 659
  126, 104, 
  // 661
  127, 105, 
  // 663
  128, 106, 
  // 665
  129, 107, 
  // 667
  271, 133, 
  // 669
  290, 134, 
  // 671
  96, 20, 
  // 673
  125, 109, 
  // 675
  126, 110, 
  // 677
  127, 112, 
  // 679
  128, 113, 
  // 681
  129, 114, 
  // 683
  96, 91, 
  // 685
  125, 115, 
  // 687
  126, 116, 
  // 689
  127, 117, 
  // 691
  128, 118, 
  // 693
  129, 119, 
  // 695
  96, 89, 
  // 697
  125, 120, 
  // 699
  126, 121, 
  // 701
  127, 122, 
  // 703
  128, 123, 
  // 705
  129, 124, 
  // 707
  96, 96, 
  // 709
  125, 125, 
  // 711
  126, 126, 
  // 713
  127, 127, 
  // 715
  128, 128, 
  // 717
  129, 129, 
  // 719
  27, 93, 
  // 721
  96, 76, 
  // 723
  125, 130, 
  // 725
  126, 131, 
  // 727
  127, 132, 
  // 729
  128, 133, 
  // 731
  257, 135, 
  // 733
  129, 134, 
  // 735
  269, 136, 
  // 737
  270, 137, 
  // 739
  96, 93, 
  // 741
  125, 135, 
  // 743
  126, 136, 
  // 745
  127, 137, 
  // 747
  128, 138, 
  // 749
  271, 138, 
  // 751
  129, 139, 
  // 753
  290, 139, 
  // 755
  96, 79, 
  // 757
  125, 140, 
  // 759
  126, 141, 
  // 761
  127, 142, 
  // 763
  128, 143, 
  // 765
  129, 144, 
  // 767
  96, 95, 
  // 769
  125, 145, 
  // 771
  126, 146, 
  // 773
  127, 147, 
  // 775
  128, 148, 
  // 777
  129, 149, 
  // 779
  76, 27, 
  // 781
  130, 257, 
  // 783
  131, 269, 
  // 785
  132, 270, 
  // 787
  133, 271, 
  // 789
  134, 290, 
  // 791
  76, 24, 
  // 793
  130, 98, 
  // 795
  131, 99, 
  // 797
  132, 100, 
  // 799
  133, 101, 
  // 801
  134, 102, 
  // 803
  27, 79, 
  // 805
  257, 140, 
  // 807
  76, 53, 
  // 809
  130, 103, 
  // 811
  131, 104, 
  // 813
  132, 105, 
  // 815
  133, 106, 
  // 817
  134, 107, 
  // 819
  269, 141, 
  // 821
  270, 142, 
  // 823
  271, 143, 
  // 825
  76, 20, 
  // 827
  130, 109, 
  // 829
  131, 110, 
  // 831
  132, 112, 
  // 833
  133, 113, 
  // 835
  134, 114, 
  // 837
  290, 144, 
  // 839
  76, 91, 
  // 841
  130, 115, 
  // 843
  131, 116, 
  // 845
  132, 117, 
  // 847
  133, 118, 
  // 849
  134, 119, 
  // 851
  76, 89, 
  // 853
  130, 120, 
  // 855
  131, 121, 
  // 857
  132, 122, 
  // 859
  133, 123, 
  // 861
  134, 124, 
  // 863
  76, 96, 
  // 865
  130, 125, 
  // 867
  131, 126, 
  // 869
  132, 127, 
  // 871
  133, 128, 
  // 873
  134, 129, 
  // 875
  130, 130, 
  // 877
  131, 131, 
  // 879
  132, 132, 
  // 881
  133, 133, 
  // 883
  134, 134, 
  // 885
  27, 95, 
  // 887
  257, 145, 
  // 889
  76, 93, 
  // 891
  130, 135, 
  // 893
  131, 136, 
  // 895
  132, 137, 
  // 897
  133, 138, 
  // 899
  269, 146, 
  // 901
  134, 139, 
  // 903
  270, 147, 
  // 905
  271, 148, 
  // 907
  76, 79, 
  // 909
  130, 140, 
  // 911
  131, 141, 
  // 913
  132, 142, 
  // 915
  133, 143, 
  // 917
  290, 149, 
  // 919
  134, 144, 
  // 921
  76, 95, 
  // 923
  130, 145, 
  // 925
  131, 146, 
  // 927
  132, 147, 
  // 929
  133, 148, 
  // 931
  134, 149, 
  // 933
  93, 27, 
  // 935
  135, 257, 
  // 937
  136, 269, 
  // 939
  137, 270, 
  // 941
  138, 271, 
  // 943
  139, 290, 
  // 945
  93, 24, 
  // 947
  135, 98, 
  // 949
  136, 99, 
  // 951
  137, 100, 
  // 953
  138, 101, 
  // 955
  139, 102, 
  // 957
  93, 53, 
  // 959
  135, 103, 
  // 961
  136, 104, 
  // 963
  137, 105, 
  // 965
  138, 106, 
  // 967
  139, 107, 
  // 969
  24, 27, 
  // 971
  98, 257, 
  // 973
  99, 269, 
  // 975
  100, 270, 
  // 977
  101, 271, 
  // 979
  93, 20, 
  // 981
  135, 109, 
  // 983
  136, 110, 
  // 985
  137, 112, 
  // 987
  138, 113, 
  // 989
  102, 290, 
  // 991
  139, 114, 
  // 993
  93, 91, 
  // 995
  135, 115, 
  // 997
  136, 116, 
  // 999
  137, 117, 
  // 1001
  138, 118, 
  // 1003
  139, 119, 
  // 1005
  93, 89, 
  // 1007
  135, 120, 
  // 1009
  136, 121, 
  // 1011
  137, 122, 
  // 1013
  138, 123, 
  // 1015
  139, 124, 
  // 1017
  93, 96, 
  // 1019
  135, 125, 
  // 1021
  136, 126, 
  // 1023
  137, 127, 
  // 1025
  138, 128, 
  // 1027
  139, 129, 
  // 1029
  93, 76, 
  // 1031
  135, 130, 
  // 1033
  136, 131, 
  // 1035
  137, 132, 
  // 1037
  138, 133, 
  // 1039
  139, 134, 
  // 1041
  24, 24, 
  // 1043
  98, 98, 
  // 1045
  99, 99, 
  // 1047
  100, 100, 
  // 1049
  101, 101, 
  // 1051
  93, 93, 
  // 1053
  135, 135, 
  // 1055
  136, 136, 
  // 1057
  137, 137, 
  // 1059
  138, 138, 
  // 1061
  102, 102, 
  // 1063
  139, 139, 
  // 1065
  93, 79, 
  // 1067
  135, 140, 
  // 1069
  136, 141, 
  // 1071
  137, 142, 
  // 1073
  138, 143, 
  // 1075
  139, 144, 
  // 1077
  93, 95, 
  // 1079
  135, 145, 
  // 1081
  136, 146, 
  // 1083
  137, 147, 
  // 1085
  138, 148, 
  // 1087
  139, 149, 
  // 1089
  79, 27, 
  // 1091
  140, 257, 
  // 1093
  141, 269, 
  // 1095
  142, 270, 
  // 1097
  143, 271, 
  // 1099
  144, 290, 
  // 1101
  79, 24, 
  // 1103
  140, 98, 
  // 1105
  141, 99, 
  // 1107
  142, 100, 
  // 1109
  143, 101, 
  // 1111
  144, 102, 
  // 1113
  24, 53, 
  // 1115
  98, 103, 
  // 1117
  99, 104, 
  // 1119
  100, 105, 
  // 1121
  101, 106, 
  // 1123
  79, 53, 
  // 1125
  140, 103, 
  // 1127
  141, 104, 
  // 1129
  142, 105, 
  // 1131
  143, 106, 
  // 1133
  102, 107, 
  // 1135
  144, 107, 
  // 1137
  79, 20, 
  // 1139
  140, 109, 
  // 1141
  141, 110, 
  // 1143
  142, 112, 
  // 1145
  143, 113, 
  // 1147
  144, 114, 
  // 1149
  79, 91, 
  // 1151
  140, 115, 
  // 1153
  141, 116, 
  // 1155
  142, 117, 
  // 1157
  143, 118, 
  // 1159
  144, 119, 
  // 1161
  79, 89, 
  // 1163
  140, 120, 
  // 1165
  141, 121, 
  // 1167
  142, 122, 
  // 1169
  143, 123, 
  // 1171
  144, 124, 
  // 1173
  79, 96, 
  // 1175
  140, 125, 
  // 1177
  141, 126, 
  // 1179
  142, 127, 
  // 1181
  143, 128, 
  // 1183
  144, 129, 
  // 1185
  24, 20, 
  // 1187
  98, 109, 
  // 1189
  99, 110, 
  // 1191
  100, 112, 
  // 1193
  101, 113, 
  // 1195
  79, 76, 
  // 1197
  140, 130, 
  // 1199
  141, 131, 
  // 1201
  142, 132, 
  // 1203
  143, 133, 
  // 1205
  102, 114, 
  // 1207
  144, 134, 
  // 1209
  79, 93, 
  // 1211
  140, 135, 
  // 1213
  141, 136, 
  // 1215
  142, 137, 
  // 1217
  143, 138, 
  // 1219
  144, 139, 
  // 1221
  79, 79, 
  // 1223
  140, 140, 
  // 1225
  141, 141, 
  // 1227
  142, 142, 
  // 1229
  143, 143, 
  // 1231
  144, 144, 
  // 1233
  79, 95, 
  // 1235
  140, 145, 
  // 1237
  141, 146, 
  // 1239
  142, 147, 
  // 1241
  143, 148, 
  // 1243
  144, 149, 
  // 1245
  95, 27, 
  // 1247
  145, 257, 
  // 1249
  146, 269, 
  // 1251
  147, 270, 
  // 1253
  148, 271, 
  // 1255
  149, 290, 
  // 1257
  24, 91, 
  // 1259
  98, 115, 
  // 1261
  99, 116, 
  // 1263
  100, 117, 
  // 1265
  101, 118, 
  // 1267
  95, 24, 
  // 1269
  145, 98, 
  // 1271
  146, 99, 
  // 1273
  147, 100, 
  // 1275
  148, 101, 
  // 1277
  102, 119, 
  // 1279
  149, 102, 
  // 1281
  95, 53, 
  // 1283
  145, 103, 
  // 1285
  146, 104, 
  // 1287
  147, 105, 
  // 1289
  148, 106, 
  // 1291
  149, 107, 
  // 1293
  95, 20, 
  // 1295
  145, 109, 
  // 1297
  146, 110, 
  // 1299
  147, 112, 
  // 1301
  148, 113, 
  // 1303
  149, 114, 
  // 1305
  95, 91, 
  // 1307
  145, 115, 
  // 1309
  146, 116, 
  // 1311
  147, 117, 
  // 1313
  148, 118, 
  // 1315
  149, 119, 
  // 1317
  95, 89, 
  // 1319
  145, 120, 
  // 1321
  146, 121, 
  // 1323
  147, 122, 
  // 1325
  148, 123, 
  // 1327
  149, 124, 
  // 1329
  24, 89, 
  // 1331
  98, 120, 
  // 1333
  99, 121, 
  // 1335
  100, 122, 
  // 1337
  101, 123, 
  // 1339
  95, 96, 
  // 1341
  145, 125, 
  // 1343
  146, 126, 
  // 1345
  147, 127, 
  // 1347
  148, 128, 
  // 1349
  102, 124, 
  // 1351
  149, 129, 
  // 1353
  95, 76, 
  // 1355
  145, 130, 
  // 1357
  146, 131, 
  // 1359
  147, 132, 
  // 1361
  148, 133, 
  // 1363
  149, 134, 
  // 1365
  95, 93, 
  // 1367
  145, 135, 
  // 1369
  146, 136, 
  // 1371
  147, 137, 
  // 1373
  148, 138, 
  // 1375
  149, 139, 
  // 1377
  95, 79, 
  // 1379
  145, 140, 
  // 1381
  146, 141, 
  // 1383
  147, 142, 
  // 1385
  148, 143, 
  // 1387
  149, 144, 
  // 1389
  95, 95, 
  // 1391
  145, 145, 
  // 1393
  146, 146, 
  // 1395
  147, 147, 
  // 1397
  148, 148, 
  // 1399
  149, 149, 
  // 1401
  24, 96, 
  // 1403
  98, 125, 
  // 1405
  99, 126, 
  // 1407
  100, 127, 
  // 1409
  101, 128, 
  // 1411
  93, 
  // 1412
  90, 93, 
  // 1414
  102, 129, 
  // 1416
  90, 
  // 1417
  26, 26, 
  // 1419
  34, 47, 
  // 1421
  31, 49, 
  // 1423
  37, 51, 
  // 1425
  26, 26, 26, 
  // 1428
  35, 35, 27, 
  // 1431
  32, 32, 24, 
  // 1434
  38, 38, 53, 
  // 1437
  39, 34, 
  // 1439
  39, 31, 
  // 1441
  39, 37, 
  // 1443
  34, 34, 39, 
  // 1446
  35, 35, 76, 
  // 1449
  31, 31, 39, 
  // 1452
  32, 32, 76, 
  // 1455
  37, 37, 39, 
  // 1458
  38, 38, 76, 
  // 1461
  26, 26, 26, 26, 
  // 1465
  26, 26, 150, 
  // 1468
  34, 34, 151, 
  // 1471
  34, 34, 34, 151, 
  // 1475
  31, 31, 151, 
  // 1478
  37, 37, 151, 
  // 1481
  31, 31, 31, 151, 
  // 1485
  37, 37, 37, 151, 
  // 1489
  26, 26, 152, 
  // 1492
  34, 34, 153, 
  // 1495
  31, 31, 153, 
  // 1498
  37, 37, 153, 
  // 1501
  34, 34, 34, 153, 
  // 1505
  31, 31, 31, 153, 
  // 1509
  37, 37, 37, 153, 
  // 1513
  26, 26, 154, 
  // 1516
  34, 34, 155, 
  // 1519
  31, 31, 155, 
  // 1522
  37, 37, 155, 
  // 1525
  34, 34, 34, 155, 
  // 1529
  31, 31, 31, 155, 
  // 1533
  37, 37, 37, 155, 
  // 1537
  26, 26, 156, 
  // 1540
  34, 34, 157, 
  // 1543
  31, 31, 157, 
  // 1546
  37, 37, 157, 
  // 1549
  34, 34, 34, 157, 
  // 1553
  31, 31, 31, 157, 
  // 1557
  37, 37, 37, 157, 
  // 1561
  34, 34, 
  // 1563
  34, 34, 34, 
  // 1566
  3, 5, 
  // 1568
  3, 5, 5, 
  // 1571
  5, 5, 5, 
  // 1574
  6, 6, 4, 
  // 1577
  43, 28, 45, 
  // 1580
  51, 45, 45, 
  // 1583
  39, 43, 51, 
  // 1586
  47, 51, 51, 
  // 1589
  41, 39, 47, 
  // 1592
  49, 47, 47, 
  // 1595
  5, 5, 5, 5, 
  // 1599
  6, 6, 4, 4, 
  // 1603
  39, 39, 39, 39, 
  // 1607
  47, 47, 47, 47, 
  // 1611
  39, 39, 39, 
  // 1614
  47, 47, 47, 
  // 1617
  35, 27, 35, 
  // 1620
  32, 24, 32, 
  // 1623
  38, 53, 38, 
  // 1626
  35, 35, 27, 27, 
  // 1630
  32, 32, 24, 24, 
  // 1634
  38, 38, 53, 53, 
  // 1638
  35, 35, 35, 27, 
  // 1642
  32, 32, 32, 24, 
  // 1646
  38, 38, 38, 53, 
  // 1650
  35, 27, 27, 35, 
  // 1654
  32, 24, 24, 32, 
  // 1658
  38, 53, 53, 38, 
  // 1662
  27, 33, 
  // 1664
  24, 30, 
  // 1666
  53, 36, 
  // 1668
  33, 33, 
  // 1670
  30, 30, 
  // 1672
  36, 36, 
  // 1674
  269, 269, 269, 
  // 1677
  99, 99, 99, 
  // 1680
  104, 104, 104, 
  // 1683
  270, 270, 270, 
  // 1686
  100, 100, 100, 
  // 1689
  105, 105, 105, 
  // 1692
  27, 33, 33, 
  // 1695
  24, 30, 30, 
  // 1698
  53, 36, 36, 
  // 1701
  24, 76, 
  // 1703
  42, 32, 
  // 1705
  44, 38, 
  // 1707
  98, 130, 
  // 1709
  99, 131, 
  // 1711
  76, 87, 
  // 1713
  39, 34, 34, 
  // 1716
  76, 24, 24, 
  // 1719
  42, 32, 32, 
  // 1722
  76, 53, 53, 
  // 1725
  100, 132, 
  // 1727
  44, 38, 38, 
  // 1730
  101, 133, 
  // 1732
  102, 134, 
  // 1734
  1, 1, 1, 1, 
  // 1738
  87, 87, 87, 87, 
  // 1742
  87, 87, 87, 92, 
  // 1746
  92, 92, 92, 92, 
  // 1750
  92, 92, 92, 87, 
  // 1754
  34, 34, 34, 39, 
  // 1758
  34, 34, 34, 47, 
  // 1762
  31, 31, 31, 41, 
  // 1766
  31, 31, 31, 49, 
  // 1770
  37, 37, 37, 43, 
  // 1774
  37, 37, 37, 51, 
  // 1778
  109, 90, 169, 
  // 1781
  115, 90, 170, 
  // 1784
  120, 90, 171, 
  // 1787
  125, 90, 172, 
  // 1790
  130, 90, 173, 
  // 1793
  135, 90, 174, 
  // 1796
  140, 90, 175, 
  // 1799
  145, 90, 176, 
  // 1802
  257, 90, 177, 
  // 1805
  98, 90, 178, 
  // 1808
  103, 90, 179, 
  // 1811
  97, 109, 90, 180, 
  // 1815
  97, 115, 90, 181, 
  // 1819
  97, 120, 90, 182, 
  // 1823
  97, 125, 90, 183, 
  // 1827
  97, 130, 90, 184, 
  // 1831
  97, 135, 90, 185, 
  // 1835
  97, 140, 90, 186, 
  // 1839
  97, 145, 90, 187, 
  // 1843
  97, 257, 90, 188, 
  // 1847
  97, 98, 90, 189, 
  // 1851
  97, 103, 90, 190, 
  // 1855
  110, 90, 169, 
  // 1858
  116, 90, 170, 
  // 1861
  121, 90, 171, 
  // 1864
  126, 90, 172, 
  // 1867
  131, 90, 173, 
  // 1870
  136, 90, 174, 
  // 1873
  141, 90, 175, 
  // 1876
  146, 90, 176, 
  // 1879
  269, 90, 177, 
  // 1882
  99, 90, 178, 
  // 1885
  104, 90, 179, 
  // 1888
  97, 110, 90, 180, 
  // 1892
  97, 116, 90, 181, 
  // 1896
  97, 121, 90, 182, 
  // 1900
  97, 126, 90, 183, 
  // 1904
  97, 131, 90, 184, 
  // 1908
  97, 136, 90, 185, 
  // 1912
  97, 141, 90, 186, 
  // 1916
  97, 146, 90, 187, 
  // 1920
  97, 269, 90, 188, 
  // 1924
  97, 99, 90, 189, 
  // 1928
  97, 104, 90, 190, 
  // 1932
  112, 90, 169, 
  // 1935
  117, 90, 170, 
  // 1938
  122, 90, 171, 
  // 1941
  127, 90, 172, 
  // 1944
  132, 90, 173, 
  // 1947
  137, 90, 174, 
  // 1950
  142, 90, 175, 
  // 1953
  147, 90, 176, 
  // 1956
  270, 90, 177, 
  // 1959
  100, 90, 178, 
  // 1962
  105, 90, 179, 
  // 1965
  97, 112, 90, 180, 
  // 1969
  97, 117, 90, 181, 
  // 1973
  97, 122, 90, 182, 
  // 1977
  97, 127, 90, 183, 
  // 1981
  97, 132, 90, 184, 
  // 1985
  97, 137, 90, 185, 
  // 1989
  97, 142, 90, 186, 
  // 1993
  97, 147, 90, 187, 
  // 1997
  97, 270, 90, 188, 
  // 2001
  97, 100, 90, 189, 
  // 2005
  97, 105, 90, 190, 
  // 2009
  113, 90, 169, 
  // 2012
  118, 90, 170, 
  // 2015
  123, 90, 171, 
  // 2018
  128, 90, 172, 
  // 2021
  133, 90, 173, 
  // 2024
  138, 90, 174, 
  // 2027
  143, 90, 175, 
  // 2030
  148, 90, 176, 
  // 2033
  271, 90, 177, 
  // 2036
  101, 90, 178, 
  // 2039
  106, 90, 179, 
  // 2042
  97, 113, 90, 180, 
  // 2046
  97, 118, 90, 181, 
  // 2050
  97, 123, 90, 182, 
  // 2054
  97, 128, 90, 183, 
  // 2058
  97, 133, 90, 184, 
  // 2062
  97, 138, 90, 185, 
  // 2066
  97, 143, 90, 186, 
  // 2070
  97, 148, 90, 187, 
  // 2074
  97, 271, 90, 188, 
  // 2078
  97, 101, 90, 189, 
  // 2082
  97, 106, 90, 190, 
  // 2086
  114, 90, 169, 
  // 2089
  119, 90, 170, 
  // 2092
  124, 90, 171, 
  // 2095
  129, 90, 172, 
  // 2098
  134, 90, 173, 
  // 2101
  139, 90, 174, 
  // 2104
  144, 90, 175, 
  // 2107
  149, 90, 176, 
  // 2110
  290, 90, 177, 
  // 2113
  102, 90, 178, 
  // 2116
  107, 90, 179, 
  // 2119
  97, 114, 90, 180, 
  // 2123
  97, 119, 90, 181, 
  // 2127
  97, 124, 90, 182, 
  // 2131
  97, 129, 90, 183, 
  // 2135
  97, 134, 90, 184, 
  // 2139
  97, 139, 90, 185, 
  // 2143
  97, 144, 90, 186, 
  // 2147
  97, 149, 90, 187, 
  // 2151
  97, 290, 90, 188, 
  // 2155
  97, 102, 90, 189, 
  // 2159
  97, 107, 90, 190, 
  // 2163
  109, 90, 191, 
  // 2166
  115, 90, 192, 
  // 2169
  120, 90, 193, 
  // 2172
  125, 90, 194, 
  // 2175
  130, 90, 195, 
  // 2178
  135, 90, 196, 
  // 2181
  140, 90, 197, 
  // 2184
  145, 90, 198, 
  // 2187
  257, 90, 199, 
  // 2190
  98, 90, 200, 
  // 2193
  103, 90, 201, 
  // 2196
  97, 109, 90, 202, 
  // 2200
  97, 115, 90, 203, 
  // 2204
  97, 120, 90, 204, 
  // 2208
  97, 125, 90, 205, 
  // 2212
  97, 130, 90, 206, 
  // 2216
  97, 135, 90, 207, 
  // 2220
  97, 140, 90, 208, 
  // 2224
  97, 145, 90, 209, 
  // 2228
  97, 257, 90, 210, 
  // 2232
  97, 98, 90, 211, 
  // 2236
  97, 103, 90, 212, 
  // 2240
  110, 90, 191, 
  // 2243
  116, 90, 192, 
  // 2246
  121, 90, 193, 
  // 2249
  126, 90, 194, 
  // 2252
  131, 90, 195, 
  // 2255
  136, 90, 196, 
  // 2258
  141, 90, 197, 
  // 2261
  146, 90, 198, 
  // 2264
  24, 93, 
  // 2266
  269, 90, 199, 
  // 2269
  99, 90, 200, 
  // 2272
  104, 90, 201, 
  // 2275
  97, 110, 90, 202, 
  // 2279
  97, 116, 90, 203, 
  // 2283
  97, 121, 90, 204, 
  // 2287
  97, 126, 90, 205, 
  // 2291
  97, 131, 90, 206, 
  // 2295
  97, 136, 90, 207, 
  // 2299
  97, 141, 90, 208, 
  // 2303
  98, 135, 
  // 2305
  97, 146, 90, 209, 
  // 2309
  97, 269, 90, 210, 
  // 2313
  97, 99, 90, 211, 
  // 2317
  97, 104, 90, 212, 
  // 2321
  112, 90, 191, 
  // 2324
  117, 90, 192, 
  // 2327
  122, 90, 193, 
  // 2330
  127, 90, 194, 
  // 2333
  132, 90, 195, 
  // 2336
  137, 90, 196, 
  // 2339
  99, 136, 
  // 2341
  142, 90, 197, 
  // 2344
  147, 90, 198, 
  // 2347
  270, 90, 199, 
  // 2350
  100, 90, 200, 
  // 2353
  105, 90, 201, 
  // 2356
  97, 112, 90, 202, 
  // 2360
  97, 117, 90, 203, 
  // 2364
  97, 122, 90, 204, 
  // 2368
  97, 127, 90, 205, 
  // 2372
  97, 132, 90, 206, 
  // 2376
  100, 137, 
  // 2378
  97, 137, 90, 207, 
  // 2382
  97, 142, 90, 208, 
  // 2386
  97, 147, 90, 209, 
  // 2390
  97, 270, 90, 210, 
  // 2394
  97, 100, 90, 211, 
  // 2398
  97, 105, 90, 212, 
  // 2402
  113, 90, 191, 
  // 2405
  118, 90, 192, 
  // 2408
  123, 90, 193, 
  // 2411
  128, 90, 194, 
  // 2414
  101, 138, 
  // 2416
  133, 90, 195, 
  // 2419
  138, 90, 196, 
  // 2422
  143, 90, 197, 
  // 2425
  148, 90, 198, 
  // 2428
  271, 90, 199, 
  // 2431
  101, 90, 200, 
  // 2434
  106, 90, 201, 
  // 2437
  97, 113, 90, 202, 
  // 2441
  97, 118, 90, 203, 
  // 2445
  97, 123, 90, 204, 
  // 2449
  27, 27, 
  // 2451
  102, 139, 
  // 2453
  97, 128, 90, 205, 
  // 2457
  97, 133, 90, 206, 
  // 2461
  97, 138, 90, 207, 
  // 2465
  97, 143, 90, 208, 
  // 2469
  97, 148, 90, 209, 
  // 2473
  97, 271, 90, 210, 
  // 2477
  97, 101, 90, 211, 
  // 2481
  97, 106, 90, 212, 
  // 2485
  114, 90, 191, 
  // 2488
  119, 90, 192, 
  // 2491
  124, 90, 193, 
  // 2494
  129, 90, 194, 
  // 2497
  134, 90, 195, 
  // 2500
  139, 90, 196, 
  // 2503
  144, 90, 197, 
  // 2506
  149, 90, 198, 
  // 2509
  290, 90, 199, 
  // 2512
  102, 90, 200, 
  // 2515
  107, 90, 201, 
  // 2518
  97, 114, 90, 202, 
  // 2522
  97, 119, 90, 203, 
  // 2526
  97, 124, 90, 204, 
  // 2530
  97, 129, 90, 205, 
  // 2534
  97, 134, 90, 206, 
  // 2538
  97, 139, 90, 207, 
  // 2542
  97, 144, 90, 208, 
  // 2546
  97, 149, 90, 209, 
  // 2550
  97, 290, 90, 210, 
  // 2554
  97, 102, 90, 211, 
  // 2558
  97, 107, 90, 212, 
  // 2562
  109, 90, 213, 
  // 2565
  115, 90, 214, 
  // 2568
  120, 90, 215, 
  // 2571
  125, 90, 216, 
  // 2574
  130, 90, 217, 
  // 2577
  135, 90, 218, 
  // 2580
  140, 90, 219, 
  // 2583
  145, 90, 220, 
  // 2586
  257, 90, 221, 
  // 2589
  98, 90, 222, 
  // 2592
  103, 90, 223, 
  // 2595
  97, 109, 90, 224, 
  // 2599
  97, 115, 90, 225, 
  // 2603
  97, 120, 90, 226, 
  // 2607
  97, 125, 90, 227, 
  // 2611
  97, 130, 90, 228, 
  // 2615
  97, 135, 90, 229, 
  // 2619
  97, 140, 90, 230, 
  // 2623
  97, 145, 90, 231, 
  // 2627
  97, 257, 90, 232, 
  // 2631
  97, 98, 90, 233, 
  // 2635
  97, 103, 90, 234, 
  // 2639
  110, 90, 213, 
  // 2642
  116, 90, 214, 
  // 2645
  121, 90, 215, 
  // 2648
  126, 90, 216, 
  // 2651
  131, 90, 217, 
  // 2654
  136, 90, 218, 
  // 2657
  141, 90, 219, 
  // 2660
  146, 90, 220, 
  // 2663
  269, 90, 221, 
  // 2666
  99, 90, 222, 
  // 2669
  104, 90, 223, 
  // 2672
  97, 110, 90, 224, 
  // 2676
  97, 116, 90, 225, 
  // 2680
  97, 121, 90, 226, 
  // 2684
  97, 126, 90, 227, 
  // 2688
  97, 131, 90, 228, 
  // 2692
  97, 136, 90, 229, 
  // 2696
  97, 141, 90, 230, 
  // 2700
  97, 146, 90, 231, 
  // 2704
  97, 269, 90, 232, 
  // 2708
  97, 99, 90, 233, 
  // 2712
  97, 104, 90, 234, 
  // 2716
  112, 90, 213, 
  // 2719
  117, 90, 214, 
  // 2722
  122, 90, 215, 
  // 2725
  127, 90, 216, 
  // 2728
  132, 90, 217, 
  // 2731
  137, 90, 218, 
  // 2734
  142, 90, 219, 
  // 2737
  147, 90, 220, 
  // 2740
  270, 90, 221, 
  // 2743
  100, 90, 222, 
  // 2746
  105, 90, 223, 
  // 2749
  97, 112, 90, 224, 
  // 2753
  97, 117, 90, 225, 
  // 2757
  97, 122, 90, 226, 
  // 2761
  97, 127, 90, 227, 
  // 2765
  97, 132, 90, 228, 
  // 2769
  97, 137, 90, 229, 
  // 2773
  97, 142, 90, 230, 
  // 2777
  97, 147, 90, 231, 
  // 2781
  97, 270, 90, 232, 
  // 2785
  97, 100, 90, 233, 
  // 2789
  97, 105, 90, 234, 
  // 2793
  113, 90, 213, 
  // 2796
  118, 90, 214, 
  // 2799
  123, 90, 215, 
  // 2802
  128, 90, 216, 
  // 2805
  133, 90, 217, 
  // 2808
  138, 90, 218, 
  // 2811
  143, 90, 219, 
  // 2814
  148, 90, 220, 
  // 2817
  271, 90, 221, 
  // 2820
  101, 90, 222, 
  // 2823
  106, 90, 223, 
  // 2826
  97, 113, 90, 224, 
  // 2830
  97, 118, 90, 225, 
  // 2834
  97, 123, 90, 226, 
  // 2838
  97, 128, 90, 227, 
  // 2842
  97, 133, 90, 228, 
  // 2846
  97, 138, 90, 229, 
  // 2850
  97, 143, 90, 230, 
  // 2854
  97, 148, 90, 231, 
  // 2858
  97, 271, 90, 232, 
  // 2862
  97, 101, 90, 233, 
  // 2866
  97, 106, 90, 234, 
  // 2870
  114, 90, 213, 
  // 2873
  119, 90, 214, 
  // 2876
  124, 90, 215, 
  // 2879
  129, 90, 216, 
  // 2882
  134, 90, 217, 
  // 2885
  139, 90, 218, 
  // 2888
  144, 90, 219, 
  // 2891
  149, 90, 220, 
  // 2894
  290, 90, 221, 
  // 2897
  102, 90, 222, 
  // 2900
  107, 90, 223, 
  // 2903
  97, 114, 90, 224, 
  // 2907
  97, 119, 90, 225, 
  // 2911
  97, 124, 90, 226, 
  // 2915
  97, 129, 90, 227, 
  // 2919
  97, 134, 90, 228, 
  // 2923
  97, 139, 90, 229, 
  // 2927
  97, 144, 90, 230, 
  // 2931
  97, 149, 90, 231, 
  // 2935
  97, 290, 90, 232, 
  // 2939
  97, 102, 90, 233, 
  // 2943
  97, 107, 90, 234, 
  // 2947
  109, 90, 235, 
  // 2950
  115, 90, 236, 
  // 2953
  120, 90, 237, 
  // 2956
  125, 90, 238, 
  // 2959
  130, 90, 239, 
  // 2962
  135, 90, 240, 
  // 2965
  140, 90, 241, 
  // 2968
  145, 90, 242, 
  // 2971
  257, 90, 243, 
  // 2974
  98, 90, 244, 
  // 2977
  103, 90, 245, 
  // 2980
  97, 109, 90, 246, 
  // 2984
  97, 115, 90, 247, 
  // 2988
  97, 120, 90, 248, 
  // 2992
  97, 125, 90, 249, 
  // 2996
  97, 130, 90, 250, 
  // 3000
  97, 135, 90, 251, 
  // 3004
  97, 140, 90, 252, 
  // 3008
  97, 145, 90, 253, 
  // 3012
  97, 257, 90, 254, 
  // 3016
  97, 98, 90, 255, 
  // 3020
  97, 103, 90, 256, 
  // 3024
  110, 90, 235, 
  // 3027
  116, 90, 236, 
  // 3030
  121, 90, 237, 
  // 3033
  126, 90, 238, 
  // 3036
  131, 90, 239, 
  // 3039
  136, 90, 240, 
  // 3042
  141, 90, 241, 
  // 3045
  146, 90, 242, 
  // 3048
  269, 90, 243, 
  // 3051
  99, 90, 244, 
  // 3054
  104, 90, 245, 
  // 3057
  97, 110, 90, 246, 
  // 3061
  97, 116, 90, 247, 
  // 3065
  97, 121, 90, 248, 
  // 3069
  97, 126, 90, 249, 
  // 3073
  97, 131, 90, 250, 
  // 3077
  97, 136, 90, 251, 
  // 3081
  97, 141, 90, 252, 
  // 3085
  97, 146, 90, 253, 
  // 3089
  97, 269, 90, 254, 
  // 3093
  97, 99, 90, 255, 
  // 3097
  97, 104, 90, 256, 
  // 3101
  112, 90, 235, 
  // 3104
  117, 90, 236, 
  // 3107
  122, 90, 237, 
  // 3110
  127, 90, 238, 
  // 3113
  132, 90, 239, 
  // 3116
  137, 90, 240, 
  // 3119
  142, 90, 241, 
  // 3122
  147, 90, 242, 
  // 3125
  270, 90, 243, 
  // 3128
  100, 90, 244, 
  // 3131
  105, 90, 245, 
  // 3134
  97, 112, 90, 246, 
  // 3138
  97, 117, 90, 247, 
  // 3142
  97, 122, 90, 248, 
  // 3146
  97, 127, 90, 249, 
  // 3150
  97, 132, 90, 250, 
  // 3154
  97, 137, 90, 251, 
  // 3158
  97, 142, 90, 252, 
  // 3162
  97, 147, 90, 253, 
  // 3166
  97, 270, 90, 254, 
  // 3170
  97, 100, 90, 255, 
  // 3174
  97, 105, 90, 256, 
  // 3178
  113, 90, 235, 
  // 3181
  118, 90, 236, 
  // 3184
  123, 90, 237, 
  // 3187
  128, 90, 238, 
  // 3190
  133, 90, 239, 
  // 3193
  138, 90, 240, 
  // 3196
  143, 90, 241, 
  // 3199
  148, 90, 242, 
  // 3202
  271, 90, 243, 
  // 3205
  101, 90, 244, 
  // 3208
  106, 90, 245, 
  // 3211
  97, 113, 90, 246, 
  // 3215
  97, 118, 90, 247, 
  // 3219
  97, 123, 90, 248, 
  // 3223
  97, 128, 90, 249, 
  // 3227
  97, 133, 90, 250, 
  // 3231
  97, 138, 90, 251, 
  // 3235
  97, 143, 90, 252, 
  // 3239
  97, 148, 90, 253, 
  // 3243
  97, 271, 90, 254, 
  // 3247
  97, 101, 90, 255, 
  // 3251
  24, 79, 
  // 3253
  97, 106, 90, 256, 
  // 3257
  114, 90, 235, 
  // 3260
  119, 90, 236, 
  // 3263
  124, 90, 237, 
  // 3266
  129, 90, 238, 
  // 3269
  134, 90, 239, 
  // 3272
  139, 90, 240, 
  // 3275
  144, 90, 241, 
  // 3278
  149, 90, 242, 
  // 3281
  290, 90, 243, 
  // 3284
  98, 140, 
  // 3286
  102, 90, 244, 
  // 3289
  107, 90, 245, 
  // 3292
  97, 114, 90, 246, 
  // 3296
  97, 119, 90, 247, 
  // 3300
  97, 124, 90, 248, 
  // 3304
  97, 129, 90, 249, 
  // 3308
  97, 134, 90, 250, 
  // 3312
  97, 139, 90, 251, 
  // 3316
  97, 144, 90, 252, 
  // 3320
  97, 149, 90, 253, 
  // 3324
  99, 141, 
  // 3326
  97, 290, 90, 254, 
  // 3330
  97, 102, 90, 255, 
  // 3334
  97, 107, 90, 256, 
  // 3338
  100, 142, 
  // 3340
  109, 90, 258, 
  // 3343
  115, 90, 259, 
  // 3346
  120, 90, 260, 
  // 3349
  125, 90, 261, 
  // 3352
  130, 90, 262, 
  // 3355
  101, 143, 
  // 3357
  135, 90, 263, 
  // 3360
  140, 90, 264, 
  // 3363
  145, 90, 265, 
  // 3366
  257, 90, 266, 
  // 3369
  98, 90, 267, 
  // 3372
  103, 90, 268, 
  // 3375
  110, 90, 258, 
  // 3378
  116, 90, 259, 
  // 3381
  121, 90, 260, 
  // 3384
  126, 90, 261, 
  // 3387
  102, 144, 
  // 3389
  131, 90, 262, 
  // 3392
  136, 90, 263, 
  // 3395
  141, 90, 264, 
  // 3398
  146, 90, 265, 
  // 3401
  269, 90, 266, 
  // 3404
  99, 90, 267, 
  // 3407
  104, 90, 268, 
  // 3410
  112, 90, 258, 
  // 3413
  117, 90, 259, 
  // 3416
  122, 90, 260, 
  // 3419
  127, 90, 261, 
  // 3422
  132, 90, 262, 
  // 3425
  137, 90, 263, 
  // 3428
  142, 90, 264, 
  // 3431
  147, 90, 265, 
  // 3434
  270, 90, 266, 
  // 3437
  100, 90, 267, 
  // 3440
  105, 90, 268, 
  // 3443
  113, 90, 258, 
  // 3446
  118, 90, 259, 
  // 3449
  123, 90, 260, 
  // 3452
  128, 90, 261, 
  // 3455
  133, 90, 262, 
  // 3458
  138, 90, 263, 
  // 3461
  143, 90, 264, 
  // 3464
  148, 90, 265, 
  // 3467
  271, 90, 266, 
  // 3470
  101, 90, 267, 
  // 3473
  106, 90, 268, 
  // 3476
  114, 90, 258, 
  // 3479
  119, 90, 259, 
  // 3482
  124, 90, 260, 
  // 3485
  129, 90, 261, 
  // 3488
  134, 90, 262, 
  // 3491
  139, 90, 263, 
  // 3494
  144, 90, 264, 
  // 3497
  149, 90, 265, 
  // 3500
  290, 90, 266, 
  // 3503
  102, 90, 267, 
  // 3506
  107, 90, 268, 
  // 3509
  27, 90, 56, 
  // 3512
  257, 90, 56, 
  // 3515
  97, 27, 90, 61, 
  // 3519
  97, 24, 90, 61, 
  // 3523
  97, 257, 90, 61, 
  // 3527
  97, 98, 90, 61, 
  // 3531
  269, 90, 56, 
  // 3534
  270, 90, 56, 
  // 3537
  271, 90, 56, 
  // 3540
  290, 90, 56, 
  // 3543
  97, 269, 90, 61, 
  // 3547
  97, 99, 90, 61, 
  // 3551
  97, 270, 90, 61, 
  // 3555
  97, 100, 90, 61, 
  // 3559
  97, 271, 90, 61, 
  // 3563
  97, 101, 90, 61, 
  // 3567
  97, 290, 90, 61, 
  // 3571
  97, 102, 90, 61, 
  // 3575
  27, 90, 57, 
  // 3578
  257, 90, 57, 
  // 3581
  269, 90, 57, 
  // 3584
  270, 90, 57, 
  // 3587
  271, 90, 57, 
  // 3590
  290, 90, 57, 
  // 3593
  97, 27, 90, 62, 
  // 3597
  97, 24, 90, 62, 
  // 3601
  97, 257, 90, 62, 
  // 3605
  97, 98, 90, 62, 
  // 3609
  97, 269, 90, 62, 
  // 3613
  97, 99, 90, 62, 
  // 3617
  97, 270, 90, 62, 
  // 3621
  97, 100, 90, 62, 
  // 3625
  97, 271, 90, 62, 
  // 3629
  97, 101, 90, 62, 
  // 3633
  97, 290, 90, 62, 
  // 3637
  97, 102, 90, 62, 
  // 3641
  24, 95, 
  // 3643
  98, 145, 
  // 3645
  99, 146, 
  // 3647
  100, 147, 
  // 3649
  27, 90, 58, 
  // 3652
  257, 90, 58, 
  // 3655
  269, 90, 58, 
  // 3658
  270, 90, 58, 
  // 3661
  101, 148, 
  // 3663
  271, 90, 58, 
  // 3666
  290, 90, 58, 
  // 3669
  97, 27, 90, 63, 
  // 3673
  97, 24, 90, 63, 
  // 3677
  97, 257, 90, 63, 
  // 3681
  97, 98, 90, 63, 
  // 3685
  102, 149, 
  // 3687
  97, 269, 90, 63, 
  // 3691
  97, 99, 90, 63, 
  // 3695
  97, 270, 90, 63, 
  // 3699
  97, 100, 90, 63, 
  // 3703
  97, 271, 90, 63, 
  // 3707
  97, 101, 90, 63, 
  // 3711
  97, 290, 90, 63, 
  // 3715
  97, 102, 90, 63, 
  // 3719
  27, 90, 55, 
  // 3722
  257, 90, 55, 
  // 3725
  269, 90, 55, 
  // 3728
  270, 90, 55, 
  // 3731
  271, 90, 55, 
  // 3734
  290, 90, 55, 
  // 3737
  97, 27, 90, 60, 
  // 3741
  97, 24, 90, 60, 
  // 3745
  97, 257, 90, 60, 
  // 3749
  97, 98, 90, 60, 
  // 3753
  97, 269, 90, 60, 
  // 3757
  97, 99, 90, 60, 
  // 3761
  97, 270, 90, 60, 
  // 3765
  97, 100, 90, 60, 
  // 3769
  97, 271, 90, 60, 
  // 3773
  97, 101, 90, 60, 
  // 3777
  97, 290, 90, 60, 
  // 3781
  97, 102, 90, 60, 
  // 3785
  27, 90, 54, 
  // 3788
  257, 90, 54, 
  // 3791
  269, 90, 54, 
  // 3794
  270, 90, 54, 
  // 3797
  271, 90, 54, 
  // 3800
  290, 90, 54, 
  // 3803
  97, 80, 
  // 3805
  97, 80, 82, 
  // 3808
  80, 272, 
  // 3810
  80, 274, 
  // 3812
  25, 275, 277, 90, 25, 
  // 3817
  53, 27, 
  // 3819
  25, 278, 279, 90, 25, 
  // 3824
  25, 275, 277, 90, 90, 25, 
  // 3830
  25, 278, 279, 90, 90, 25, 
  // 3836
  97, 76, 280, 
  // 3839
  103, 257, 
  // 3841
  97, 277, 90, 
  // 3844
  76, 282, 76, 
  // 3847
  76, 282, 
  // 3849
  76, 282, 76, 76, 
  // 3853
  104, 269, 
  // 3855
  93, 284, 93, 
  // 3858
  93, 284, 
  // 3860
  93, 284, 93, 93, 
  // 3864
  76, 285, 76, 
  // 3867
  76, 285, 
  // 3869
  76, 285, 76, 76, 
  // 3873
  105, 270, 
  // 3875
  93, 286, 93, 
  // 3878
  93, 286, 
  // 3880
  106, 271, 
  // 3882
  93, 286, 93, 93, 
  // 3886
  79, 288, 79, 
  // 3889
  79, 288, 
  // 3891
  79, 288, 79, 79, 
  // 3895
  107, 290, 
  // 3897
  95, 291, 95, 
  // 3900
  95, 291, 
  // 3902
  95, 291, 95, 95, 
  // 3906
  79, 292, 79, 
  // 3909
  79, 292, 
  // 3911
  79, 292, 79, 79, 
  // 3915
  95, 293, 95, 
  // 3918
  95, 293, 
  // 3920
  95, 293, 95, 95, 
  // 3924
  27, 295, 27, 
  // 3927
  27, 296, 27, 
  // 3930
  76, 297, 76, 
  // 3933
  76, 297, 
  // 3935
  76, 297, 76, 76, 
  // 3939
  93, 298, 93, 
  // 3942
  93, 298, 
  // 3944
  93, 298, 93, 93, 
  // 3948
  97, 307, 76, 
  // 3951
  97, 307, 76, 81, 
  // 3955
  97, 307, 76, 81, 82, 
  // 3960
  19, 307, 250, 76, 
  // 3964
  19, 307, 250, 76, 81, 81, 
  // 3970
  19, 307, 250, 76, 81, 81, 82, 
  // 3977
  97, 80, 81, 82, 
  // 3981
  76, 307, 
  // 3983
  76, 307, 81, 
  // 3986
  76, 307, 81, 82, 
  // 3990
  76, 307, 76, 
  // 3993
  76, 307, 76, 81, 
  // 3997
  76, 307, 76, 81, 82, 
  // 4002
  97, 308, 93, 
  // 4005
  97, 308, 93, 81, 
  // 4009
  97, 308, 93, 81, 82, 
  // 4014
  93, 308, 
  // 4016
  93, 308, 81, 
  // 4019
  93, 308, 81, 82, 
  // 4023
  93, 308, 93, 
  // 4026
  93, 308, 93, 81, 
  // 4030
  93, 308, 93, 81, 82, 
  // 4035
  19, 308, 251, 93, 
  // 4039
  19, 308, 251, 93, 81, 81, 
  // 4045
  19, 308, 251, 93, 81, 81, 82, 
  // 4052
  97, 309, 79, 
  // 4055
  97, 309, 79, 81, 
  // 4059
  97, 309, 79, 81, 82, 
  // 4064
  79, 309, 
  // 4066
  79, 309, 81, 
  // 4069
  79, 309, 81, 82, 
  // 4073
  79, 309, 79, 
  // 4076
  79, 309, 79, 81, 
  // 4080
  79, 309, 79, 81, 82, 
  // 4085
  19, 309, 252, 79, 
  // 4089
  19, 309, 252, 79, 81, 81, 
  // 4095
  19, 309, 252, 79, 81, 81, 82, 
  // 4102
  97, 310, 95, 
  // 4105
  97, 310, 95, 81, 
  // 4109
  97, 310, 95, 81, 82, 
  // 4114
  95, 310, 
  // 4116
  95, 310, 81, 
  // 4119
  95, 310, 81, 82, 
  // 4123
  95, 310, 95, 
  // 4126
  95, 310, 95, 81, 
  // 4130
  95, 310, 95, 81, 82, 
  // 4135
  19, 310, 253, 95, 
  // 4139
  19, 310, 253, 95, 81, 81, 
  // 4145
  19, 310, 253, 95, 81, 81, 82, 
  // 4152
  97, 311, 27, 
  // 4155
  97, 311, 27, 81, 
  // 4159
  97, 311, 27, 81, 82, 
  // 4164
  27, 311, 
  // 4166
  27, 311, 81, 
  // 4169
  27, 311, 81, 82, 
  // 4173
  27, 311, 27, 
  // 4176
  27, 311, 27, 81, 
  // 4180
  27, 311, 27, 81, 82, 
  // 4185
  19, 311, 254, 27, 
  // 4189
  19, 311, 254, 27, 81, 81, 
  // 4195
  19, 311, 254, 27, 81, 81, 82, 
  // 4202
  97, 312, 24, 
  // 4205
  97, 312, 24, 81, 
  // 4209
  97, 312, 24, 81, 82, 
  // 4214
  24, 312, 
  // 4216
  24, 312, 81, 
  // 4219
  24, 312, 81, 82, 
  // 4223
  53, 24, 
  // 4225
  24, 312, 24, 
  // 4228
  24, 312, 24, 81, 
  // 4232
  24, 312, 24, 81, 82, 
  // 4237
  19, 312, 255, 24, 
  // 4241
  19, 312, 255, 24, 81, 81, 
  // 4247
  19, 312, 255, 24, 81, 81, 82, 
  // 4254
  103, 98, 
  // 4256
  104, 99, 
  // 4258
  105, 100, 
  // 4260
  94, 313, 84, 
  // 4263
  94, 313, 84, 81, 
  // 4267
  94, 313, 84, 81, 82, 
  // 4272
  106, 101, 
  // 4274
  107, 102, 
  // 4276
  97, 314, 
  // 4278
  97, 314, 81, 
  // 4281
  97, 314, 81, 82, 
  // 4285
  19, 314, 
  // 4287
  19, 314, 81, 
  // 4290
  19, 314, 81, 82, 
  // 4294
  97, 315, 76, 
  // 4297
  97, 315, 76, 81, 
  // 4301
  97, 315, 76, 81, 82, 
  // 4306
  76, 315, 
  // 4308
  76, 315, 81, 
  // 4311
  76, 315, 81, 82, 
  // 4315
  76, 315, 76, 
  // 4318
  76, 315, 76, 81, 
  // 4322
  76, 315, 76, 81, 82, 
  // 4327
  19, 315, 184, 76, 
  // 4331
  19, 315, 184, 76, 81, 81, 
  // 4337
  19, 315, 184, 76, 81, 81, 82, 
  // 4344
  19, 315, 206, 76, 
  // 4348
  19, 315, 206, 76, 81, 81, 
  // 4354
  19, 315, 206, 76, 81, 81, 82, 
  // 4361
  19, 315, 228, 76, 
  // 4365
  19, 315, 228, 76, 81, 81, 
  // 4371
  19, 315, 228, 76, 81, 81, 82, 
  // 4378
  97, 316, 93, 
  // 4381
  97, 316, 93, 81, 
  // 4385
  97, 316, 93, 81, 82, 
  // 4390
  93, 316, 
  // 4392
  93, 316, 81, 
  // 4395
  93, 316, 81, 82, 
  // 4399
  93, 316, 93, 
  // 4402
  93, 316, 93, 81, 
  // 4406
  93, 316, 93, 81, 82, 
  // 4411
  19, 316, 185, 93, 
  // 4415
  19, 316, 185, 93, 81, 81, 
  // 4421
  19, 316, 185, 93, 81, 81, 82, 
  // 4428
  19, 316, 207, 93, 
  // 4432
  19, 316, 207, 93, 81, 81, 
  // 4438
  19, 316, 207, 93, 81, 81, 82, 
  // 4445
  19, 316, 229, 93, 
  // 4449
  19, 316, 229, 93, 81, 81, 
  // 4455
  19, 316, 229, 93, 81, 81, 82, 
  // 4462
  97, 317, 79, 
  // 4465
  97, 317, 79, 81, 
  // 4469
  97, 317, 79, 81, 82, 
  // 4474
  79, 317, 
  // 4476
  79, 317, 81, 
  // 4479
  79, 317, 81, 82, 
  // 4483
  79, 317, 79, 
  // 4486
  79, 317, 79, 81, 
  // 4490
  79, 317, 79, 81, 82, 
  // 4495
  19, 317, 186, 79, 
  // 4499
  19, 317, 186, 79, 81, 81, 
  // 4505
  19, 317, 186, 79, 81, 81, 82, 
  // 4512
  19, 317, 208, 79, 
  // 4516
  19, 317, 208, 79, 81, 81, 
  // 4522
  19, 317, 208, 79, 81, 81, 82, 
  // 4529
  19, 317, 230, 79, 
  // 4533
  19, 317, 230, 79, 81, 81, 
  // 4539
  19, 317, 230, 79, 81, 81, 82, 
  // 4546
  97, 318, 95, 
  // 4549
  97, 318, 95, 81, 
  // 4553
  97, 318, 95, 81, 82, 
  // 4558
  95, 318, 
  // 4560
  95, 318, 81, 
  // 4563
  95, 318, 81, 82, 
  // 4567
  95, 318, 95, 
  // 4570
  95, 318, 95, 81, 
  // 4574
  95, 318, 95, 81, 82, 
  // 4579
  19, 318, 187, 95, 
  // 4583
  19, 318, 187, 95, 81, 81, 
  // 4589
  19, 318, 187, 95, 81, 81, 82, 
  // 4596
  19, 318, 209, 95, 
  // 4600
  19, 318, 209, 95, 81, 81, 
  // 4606
  19, 318, 209, 95, 81, 81, 82, 
  // 4613
  19, 318, 231, 95, 
  // 4617
  19, 318, 231, 95, 81, 81, 
  // 4623
  19, 318, 231, 95, 81, 81, 82, 
  // 4630
  97, 319, 27, 
  // 4633
  97, 319, 27, 81, 
  // 4637
  97, 319, 27, 81, 82, 
  // 4642
  27, 319, 
  // 4644
  27, 319, 81, 
  // 4647
  27, 319, 81, 82, 
  // 4651
  27, 319, 27, 
  // 4654
  27, 319, 27, 81, 
  // 4658
  27, 319, 27, 81, 82, 
  // 4663
  19, 319, 188, 27, 
  // 4667
  19, 319, 188, 27, 81, 81, 
  // 4673
  19, 319, 188, 27, 81, 81, 82, 
  // 4680
  19, 319, 210, 27, 
  // 4684
  19, 319, 210, 27, 81, 81, 
  // 4690
  19, 319, 210, 27, 81, 81, 82, 
  // 4697
  19, 319, 232, 27, 
  // 4701
  19, 319, 232, 27, 81, 81, 
  // 4707
  19, 319, 232, 27, 81, 81, 82, 
  // 4714
  97, 320, 24, 
  // 4717
  97, 320, 24, 81, 
  // 4721
  97, 320, 24, 81, 82, 
  // 4726
  24, 320, 
  // 4728
  24, 320, 81, 
  // 4731
  24, 320, 81, 82, 
  // 4735
  24, 320, 24, 
  // 4738
  24, 320, 24, 81, 
  // 4742
  24, 320, 24, 81, 82, 
  // 4747
  19, 320, 189, 24, 
  // 4751
  19, 320, 189, 24, 81, 81, 
  // 4757
  19, 320, 189, 24, 81, 81, 82, 
  // 4764
  19, 320, 211, 24, 
  // 4768
  19, 320, 211, 24, 81, 81, 
  // 4774
  19, 320, 211, 24, 81, 81, 82, 
  // 4781
  19, 320, 233, 24, 
  // 4785
  19, 320, 233, 24, 81, 81, 
  // 4791
  19, 320, 233, 24, 81, 81, 82, 
  // 4798
  53, 53, 
  // 4800
  103, 103, 
  // 4802
  94, 321, 84, 
  // 4805
  94, 321, 84, 81, 
  // 4809
  94, 321, 84, 81, 82, 
  // 4814
  104, 104, 
  // 4816
  105, 105, 
  // 4818
  106, 106, 
  // 4820
  107, 107, 
  // 4822
  97, 322, 
  // 4824
  97, 322, 81, 
  // 4827
  97, 322, 81, 82, 
  // 4831
  19, 322, 
  // 4833
  19, 322, 81, 
  // 4836
  19, 322, 81, 82, 
  // 4840
  97, 323, 76, 
  // 4843
  97, 323, 76, 81, 
  // 4847
  97, 323, 76, 81, 82, 
  // 4852
  76, 323, 
  // 4854
  76, 323, 81, 
  // 4857
  76, 323, 81, 82, 
  // 4861
  76, 323, 76, 
  // 4864
  76, 323, 76, 81, 
  // 4868
  76, 323, 76, 81, 82, 
  // 4873
  19, 323, 184, 76, 
  // 4877
  19, 323, 184, 76, 81, 81, 
  // 4883
  19, 323, 184, 76, 81, 81, 82, 
  // 4890
  19, 323, 206, 76, 
  // 4894
  19, 323, 206, 76, 81, 81, 
  // 4900
  19, 323, 206, 76, 81, 81, 82, 
  // 4907
  19, 323, 228, 76, 
  // 4911
  19, 323, 228, 76, 81, 81, 
  // 4917
  19, 323, 228, 76, 81, 81, 82, 
  // 4924
  97, 324, 93, 
  // 4927
  97, 324, 93, 81, 
  // 4931
  97, 324, 93, 81, 82, 
  // 4936
  93, 324, 
  // 4938
  93, 324, 81, 
  // 4941
  93, 324, 81, 82, 
  // 4945
  93, 324, 93, 
  // 4948
  93, 324, 93, 81, 
  // 4952
  93, 324, 93, 81, 82, 
  // 4957
  19, 324, 185, 93, 
  // 4961
  19, 324, 185, 93, 81, 81, 
  // 4967
  19, 324, 185, 93, 81, 81, 82, 
  // 4974
  19, 324, 207, 93, 
  // 4978
  19, 324, 207, 93, 81, 81, 
  // 4984
  19, 324, 207, 93, 81, 81, 82, 
  // 4991
  19, 324, 229, 93, 
  // 4995
  19, 324, 229, 93, 81, 81, 
  // 5001
  19, 324, 229, 93, 81, 81, 82, 
  // 5008
  97, 325, 79, 
  // 5011
  97, 325, 79, 81, 
  // 5015
  97, 325, 79, 81, 82, 
  // 5020
  79, 325, 
  // 5022
  79, 325, 81, 
  // 5025
  79, 325, 81, 82, 
  // 5029
  79, 325, 79, 
  // 5032
  79, 325, 79, 81, 
  // 5036
  79, 325, 79, 81, 82, 
  // 5041
  19, 325, 186, 79, 
  // 5045
  19, 325, 186, 79, 81, 81, 
  // 5051
  19, 325, 186, 79, 81, 81, 82, 
  // 5058
  19, 325, 208, 79, 
  // 5062
  19, 325, 208, 79, 81, 81, 
  // 5068
  19, 325, 208, 79, 81, 81, 82, 
  // 5075
  19, 325, 230, 79, 
  // 5079
  19, 325, 230, 79, 81, 81, 
  // 5085
  19, 325, 230, 79, 81, 81, 82, 
  // 5092
  97, 326, 95, 
  // 5095
  97, 326, 95, 81, 
  // 5099
  97, 326, 95, 81, 82, 
  // 5104
  95, 326, 
  // 5106
  95, 326, 81, 
  // 5109
  95, 326, 81, 82, 
  // 5113
  95, 326, 95, 
  // 5116
  95, 326, 95, 81, 
  // 5120
  95, 326, 95, 81, 82, 
  // 5125
  19, 326, 187, 95, 
  // 5129
  19, 326, 187, 95, 81, 81, 
  // 5135
  19, 326, 187, 95, 81, 81, 82, 
  // 5142
  19, 326, 209, 95, 
  // 5146
  19, 326, 209, 95, 81, 81, 
  // 5152
  19, 326, 209, 95, 81, 81, 82, 
  // 5159
  19, 326, 231, 95, 
  // 5163
  19, 326, 231, 95, 81, 81, 
  // 5169
  19, 326, 231, 95, 81, 81, 82, 
  // 5176
  97, 327, 27, 
  // 5179
  97, 327, 27, 81, 
  // 5183
  97, 327, 27, 81, 82, 
  // 5188
  27, 327, 
  // 5190
  27, 327, 81, 
  // 5193
  27, 327, 81, 82, 
  // 5197
  27, 327, 27, 
  // 5200
  27, 327, 27, 81, 
  // 5204
  27, 327, 27, 81, 82, 
  // 5209
  19, 327, 188, 27, 
  // 5213
  19, 327, 188, 27, 81, 81, 
  // 5219
  19, 327, 188, 27, 81, 81, 82, 
  // 5226
  19, 327, 210, 27, 
  // 5230
  19, 327, 210, 27, 81, 81, 
  // 5236
  19, 327, 210, 27, 81, 81, 82, 
  // 5243
  19, 327, 232, 27, 
  // 5247
  19, 327, 232, 27, 81, 81, 
  // 5253
  19, 327, 232, 27, 81, 81, 82, 
  // 5260
  97, 328, 24, 
  // 5263
  97, 328, 24, 81, 
  // 5267
  97, 328, 24, 81, 82, 
  // 5272
  24, 328, 
  // 5274
  24, 328, 81, 
  // 5277
  24, 328, 81, 82, 
  // 5281
  24, 328, 24, 
  // 5284
  24, 328, 24, 81, 
  // 5288
  24, 328, 24, 81, 82, 
  // 5293
  19, 328, 189, 24, 
  // 5297
  19, 328, 189, 24, 81, 81, 
  // 5303
  19, 328, 189, 24, 81, 81, 82, 
  // 5310
  19, 328, 211, 24, 
  // 5314
  19, 328, 211, 24, 81, 81, 
  // 5320
  19, 328, 211, 24, 81, 81, 82, 
  // 5327
  19, 328, 233, 24, 
  // 5331
  19, 328, 233, 24, 81, 81, 
  // 5337
  19, 328, 233, 24, 81, 81, 82, 
  // 5344
  94, 329, 84, 
  // 5347
  94, 329, 84, 81, 
  // 5351
  94, 329, 84, 81, 82, 
  // 5356
  53, 20, 
  // 5358
  103, 109, 
  // 5360
  104, 110, 
  // 5362
  105, 112, 
  // 5364
  106, 113, 
  // 5366
  97, 330, 
  // 5368
  107, 114, 
  // 5370
  97, 330, 81, 
  // 5373
  97, 330, 81, 82, 
  // 5377
  19, 330, 
  // 5379
  19, 330, 81, 
  // 5382
  19, 330, 81, 82, 
  // 5386
  97, 332, 10, 
  // 5389
  97, 332, 10, 81, 
  // 5393
  97, 332, 10, 81, 82, 
  // 5398
  53, 332, 
  // 5400
  53, 332, 81, 
  // 5403
  53, 332, 81, 82, 
  // 5407
  53, 332, 53, 
  // 5410
  53, 332, 53, 81, 
  // 5414
  53, 332, 53, 81, 82, 
  // 5419
  97, 333, 10, 
  // 5422
  97, 333, 10, 81, 
  // 5426
  97, 333, 10, 81, 82, 
  // 5431
  53, 333, 
  // 5433
  53, 333, 81, 
  // 5436
  53, 333, 81, 82, 
  // 5440
  53, 333, 53, 
  // 5443
  53, 333, 53, 81, 
  // 5447
  53, 333, 53, 81, 82, 
  // 5452
  97, 334, 10, 
  // 5455
  97, 334, 10, 81, 
  // 5459
  97, 334, 10, 81, 82, 
  // 5464
  53, 334, 
  // 5466
  53, 334, 81, 
  // 5469
  53, 334, 81, 82, 
  // 5473
  53, 334, 53, 
  // 5476
  53, 334, 53, 81, 
  // 5480
  53, 334, 53, 81, 82, 
  // 5485
  109, 109, 115, 
  // 5488
  115, 115, 115, 
  // 5491
  120, 120, 125, 
  // 5494
  125, 125, 125, 
  // 5497
  130, 130, 135, 
  // 5500
  135, 135, 135, 
  // 5503
  140, 140, 145, 
  // 5506
  145, 145, 145, 
  // 5509
  257, 257, 135, 
  // 5512
  98, 98, 145, 
  // 5515
  103, 103, 125, 
  // 5518
  109, 112, 115, 
  // 5521
  115, 117, 115, 
  // 5524
  53, 91, 
  // 5526
  120, 122, 125, 
  // 5529
  125, 127, 125, 
  // 5532
  130, 132, 135, 
  // 5535
  135, 137, 135, 
  // 5538
  140, 142, 145, 
  // 5541
  145, 147, 145, 
  // 5544
  257, 270, 135, 
  // 5547
  98, 100, 145, 
  // 5550
  103, 105, 125, 
  // 5553
  109, 113, 115, 
  // 5556
  103, 115, 
  // 5558
  115, 118, 115, 
  // 5561
  120, 123, 125, 
  // 5564
  125, 128, 125, 
  // 5567
  130, 133, 135, 
  // 5570
  135, 138, 135, 
  // 5573
  140, 143, 145, 
  // 5576
  145, 148, 145, 
  // 5579
  257, 271, 135, 
  // 5582
  98, 101, 145, 
  // 5585
  103, 106, 125, 
  // 5588
  104, 116, 
  // 5590
  109, 114, 115, 
  // 5593
  115, 119, 115, 
  // 5596
  120, 124, 125, 
  // 5599
  125, 129, 125, 
  // 5602
  130, 134, 135, 
  // 5605
  135, 139, 135, 
  // 5608
  140, 144, 145, 
  // 5611
  145, 149, 145, 
  // 5614
  257, 290, 135, 
  // 5617
  98, 102, 145, 
  // 5620
  105, 117, 
  // 5622
  103, 107, 125, 
  // 5625
  112, 109, 117, 
  // 5628
  117, 115, 117, 
  // 5631
  122, 120, 127, 
  // 5634
  127, 125, 127, 
  // 5637
  132, 130, 137, 
  // 5640
  137, 135, 137, 
  // 5643
  142, 140, 147, 
  // 5646
  147, 145, 147, 
  // 5649
  270, 257, 137, 
  // 5652
  106, 118, 
  // 5654
  100, 98, 147, 
  // 5657
  105, 103, 127, 
  // 5660
  112, 112, 117, 
  // 5663
  117, 117, 117, 
  // 5666
  122, 122, 127, 
  // 5669
  127, 127, 127, 
  // 5672
  132, 132, 137, 
  // 5675
  137, 137, 137, 
  // 5678
  142, 142, 147, 
  // 5681
  147, 147, 147, 
  // 5684
  107, 119, 
  // 5686
  270, 270, 137, 
  // 5689
  100, 100, 147, 
  // 5692
  105, 105, 127, 
  // 5695
  112, 113, 117, 
  // 5698
  117, 118, 117, 
  // 5701
  122, 123, 127, 
  // 5704
  127, 128, 127, 
  // 5707
  132, 133, 137, 
  // 5710
  137, 138, 137, 
  // 5713
  142, 143, 147, 
  // 5716
  147, 148, 147, 
  // 5719
  270, 271, 137, 
  // 5722
  100, 101, 147, 
  // 5725
  105, 106, 127, 
  // 5728
  112, 114, 117, 
  // 5731
  117, 119, 117, 
  // 5734
  122, 124, 127, 
  // 5737
  127, 129, 127, 
  // 5740
  132, 134, 137, 
  // 5743
  137, 139, 137, 
  // 5746
  142, 144, 147, 
  // 5749
  147, 149, 147, 
  // 5752
  270, 290, 137, 
  // 5755
  100, 102, 147, 
  // 5758
  105, 107, 127, 
  // 5761
  113, 109, 118, 
  // 5764
  118, 115, 118, 
  // 5767
  123, 120, 128, 
  // 5770
  128, 125, 128, 
  // 5773
  133, 130, 138, 
  // 5776
  138, 135, 138, 
  // 5779
  143, 140, 148, 
  // 5782
  148, 145, 148, 
  // 5785
  271, 257, 138, 
  // 5788
  101, 98, 148, 
  // 5791
  106, 103, 128, 
  // 5794
  113, 112, 118, 
  // 5797
  118, 117, 118, 
  // 5800
  123, 122, 128, 
  // 5803
  128, 127, 128, 
  // 5806
  133, 132, 138, 
  // 5809
  138, 137, 138, 
  // 5812
  143, 142, 148, 
  // 5815
  148, 147, 148, 
  // 5818
  271, 270, 138, 
  // 5821
  101, 100, 148, 
  // 5824
  106, 105, 128, 
  // 5827
  113, 113, 118, 
  // 5830
  118, 118, 118, 
  // 5833
  123, 123, 128, 
  // 5836
  128, 128, 128, 
  // 5839
  133, 133, 138, 
  // 5842
  138, 138, 138, 
  // 5845
  143, 143, 148, 
  // 5848
  148, 148, 148, 
  // 5851
  271, 271, 138, 
  // 5854
  101, 101, 148, 
  // 5857
  106, 106, 128, 
  // 5860
  113, 114, 118, 
  // 5863
  118, 119, 118, 
  // 5866
  123, 124, 128, 
  // 5869
  128, 129, 128, 
  // 5872
  133, 134, 138, 
  // 5875
  138, 139, 138, 
  // 5878
  143, 144, 148, 
  // 5881
  148, 149, 148, 
  // 5884
  271, 290, 138, 
  // 5887
  101, 102, 148, 
  // 5890
  106, 107, 128, 
  // 5893
  114, 109, 119, 
  // 5896
  119, 115, 119, 
  // 5899
  124, 120, 129, 
  // 5902
  129, 125, 129, 
  // 5905
  134, 130, 139, 
  // 5908
  139, 135, 139, 
  // 5911
  144, 140, 149, 
  // 5914
  149, 145, 149, 
  // 5917
  290, 257, 139, 
  // 5920
  102, 98, 149, 
  // 5923
  107, 103, 129, 
  // 5926
  114, 112, 119, 
  // 5929
  119, 117, 119, 
  // 5932
  124, 122, 129, 
  // 5935
  129, 127, 129, 
  // 5938
  134, 132, 139, 
  // 5941
  139, 137, 139, 
  // 5944
  144, 142, 149, 
  // 5947
  149, 147, 149, 
  // 5950
  290, 270, 139, 
  // 5953
  102, 100, 149, 
  // 5956
  107, 105, 129, 
  // 5959
  114, 113, 119, 
  // 5962
  119, 118, 119, 
  // 5965
  124, 123, 129, 
  // 5968
  129, 128, 129, 
  // 5971
  134, 133, 139, 
  // 5974
  139, 138, 139, 
  // 5977
  144, 143, 149, 
  // 5980
  149, 148, 149, 
  // 5983
  290, 271, 139, 
  // 5986
  102, 101, 149, 
  // 5989
  107, 106, 129, 
  // 5992
  114, 114, 119, 
  // 5995
  119, 119, 119, 
  // 5998
  124, 124, 129, 
  // 6001
  129, 129, 129, 
  // 6004
  134, 134, 139, 
  // 6007
  139, 139, 139, 
  // 6010
  144, 144, 149, 
  // 6013
  149, 149, 149, 
  // 6016
  290, 290, 139, 
  // 6019
  102, 102, 149, 
  // 6022
  107, 107, 129, 
  // 6025
  109, 109, 109, 115, 
  // 6029
  115, 115, 115, 115, 
  // 6033
  120, 120, 120, 125, 
  // 6037
  125, 125, 125, 125, 
  // 6041
  130, 130, 130, 135, 
  // 6045
  135, 135, 135, 135, 
  // 6049
  140, 140, 140, 145, 
  // 6053
  145, 145, 145, 145, 
  // 6057
  257, 257, 257, 135, 
  // 6061
  98, 98, 98, 145, 
  // 6065
  103, 103, 103, 125, 
  // 6069
  109, 112, 112, 115, 
  // 6073
  115, 117, 117, 115, 
  // 6077
  120, 122, 122, 125, 
  // 6081
  125, 127, 127, 125, 
  // 6085
  130, 132, 132, 135, 
  // 6089
  135, 137, 137, 135, 
  // 6093
  140, 142, 142, 145, 
  // 6097
  145, 147, 147, 145, 
  // 6101
  257, 270, 270, 135, 
  // 6105
  98, 100, 100, 145, 
  // 6109
  103, 105, 105, 125, 
  // 6113
  109, 113, 113, 115, 
  // 6117
  115, 118, 118, 115, 
  // 6121
  120, 123, 123, 125, 
  // 6125
  125, 128, 128, 125, 
  // 6129
  130, 133, 133, 135, 
  // 6133
  135, 138, 138, 135, 
  // 6137
  140, 143, 143, 145, 
  // 6141
  145, 148, 148, 145, 
  // 6145
  257, 271, 271, 135, 
  // 6149
  98, 101, 101, 145, 
  // 6153
  103, 106, 106, 125, 
  // 6157
  109, 114, 114, 115, 
  // 6161
  115, 119, 119, 115, 
  // 6165
  120, 124, 124, 125, 
  // 6169
  125, 129, 129, 125, 
  // 6173
  130, 134, 134, 135, 
  // 6177
  135, 139, 139, 135, 
  // 6181
  140, 144, 144, 145, 
  // 6185
  145, 149, 149, 145, 
  // 6189
  257, 290, 290, 135, 
  // 6193
  98, 102, 102, 145, 
  // 6197
  103, 107, 107, 125, 
  // 6201
  112, 109, 109, 117, 
  // 6205
  117, 115, 115, 117, 
  // 6209
  122, 120, 120, 127, 
  // 6213
  127, 125, 125, 127, 
  // 6217
  132, 130, 130, 137, 
  // 6221
  137, 135, 135, 137, 
  // 6225
  142, 140, 140, 147, 
  // 6229
  147, 145, 145, 147, 
  // 6233
  270, 257, 257, 137, 
  // 6237
  100, 98, 98, 147, 
  // 6241
  105, 103, 103, 127, 
  // 6245
  112, 112, 112, 117, 
  // 6249
  117, 117, 117, 117, 
  // 6253
  122, 122, 122, 127, 
  // 6257
  127, 127, 127, 127, 
  // 6261
  132, 132, 132, 137, 
  // 6265
  137, 137, 137, 137, 
  // 6269
  142, 142, 142, 147, 
  // 6273
  147, 147, 147, 147, 
  // 6277
  270, 270, 270, 137, 
  // 6281
  100, 100, 100, 147, 
  // 6285
  105, 105, 105, 127, 
  // 6289
  112, 113, 113, 117, 
  // 6293
  117, 118, 118, 117, 
  // 6297
  122, 123, 123, 127, 
  // 6301
  127, 128, 128, 127, 
  // 6305
  132, 133, 133, 137, 
  // 6309
  137, 138, 138, 137, 
  // 6313
  142, 143, 143, 147, 
  // 6317
  147, 148, 148, 147, 
  // 6321
  270, 271, 271, 137, 
  // 6325
  100, 101, 101, 147, 
  // 6329
  105, 106, 106, 127, 
  // 6333
  112, 114, 114, 117, 
  // 6337
  117, 119, 119, 117, 
  // 6341
  122, 124, 124, 127, 
  // 6345
  127, 129, 129, 127, 
  // 6349
  132, 134, 134, 137, 
  // 6353
  137, 139, 139, 137, 
  // 6357
  142, 144, 144, 147, 
  // 6361
  147, 149, 149, 147, 
  // 6365
  270, 290, 290, 137, 
  // 6369
  100, 102, 102, 147, 
  // 6373
  105, 107, 107, 127, 
  // 6377
  113, 109, 109, 118, 
  // 6381
  118, 115, 115, 118, 
  // 6385
  123, 120, 120, 128, 
  // 6389
  128, 125, 125, 128, 
  // 6393
  133, 130, 130, 138, 
  // 6397
  138, 135, 135, 138, 
  // 6401
  143, 140, 140, 148, 
  // 6405
  148, 145, 145, 148, 
  // 6409
  271, 257, 257, 138, 
  // 6413
  101, 98, 98, 148, 
  // 6417
  106, 103, 103, 128, 
  // 6421
  113, 112, 112, 118, 
  // 6425
  118, 117, 117, 118, 
  // 6429
  123, 122, 122, 128, 
  // 6433
  128, 127, 127, 128, 
  // 6437
  133, 132, 132, 138, 
  // 6441
  138, 137, 137, 138, 
  // 6445
  143, 142, 142, 148, 
  // 6449
  148, 147, 147, 148, 
  // 6453
  271, 270, 270, 138, 
  // 6457
  101, 100, 100, 148, 
  // 6461
  106, 105, 105, 128, 
  // 6465
  113, 113, 113, 118, 
  // 6469
  118, 118, 118, 118, 
  // 6473
  123, 123, 123, 128, 
  // 6477
  128, 128, 128, 128, 
  // 6481
  133, 133, 133, 138, 
  // 6485
  138, 138, 138, 138, 
  // 6489
  143, 143, 143, 148, 
  // 6493
  148, 148, 148, 148, 
  // 6497
  271, 271, 271, 138, 
  // 6501
  101, 101, 101, 148, 
  // 6505
  106, 106, 106, 128, 
  // 6509
  113, 114, 114, 118, 
  // 6513
  118, 119, 119, 118, 
  // 6517
  123, 124, 124, 128, 
  // 6521
  128, 129, 129, 128, 
  // 6525
  133, 134, 134, 138, 
  // 6529
  138, 139, 139, 138, 
  // 6533
  143, 144, 144, 148, 
  // 6537
  148, 149, 149, 148, 
  // 6541
  271, 290, 290, 138, 
  // 6545
  101, 102, 102, 148, 
  // 6549
  106, 107, 107, 128, 
  // 6553
  114, 109, 109, 119, 
  // 6557
  119, 115, 115, 119, 
  // 6561
  124, 120, 120, 129, 
  // 6565
  129, 125, 125, 129, 
  // 6569
  134, 130, 130, 139, 
  // 6573
  53, 89, 
  // 6575
  139, 135, 135, 139, 
  // 6579
  144, 140, 140, 149, 
  // 6583
  149, 145, 145, 149, 
  // 6587
  290, 257, 257, 139, 
  // 6591
  102, 98, 98, 149, 
  // 6595
  107, 103, 103, 129, 
  // 6599
  114, 112, 112, 119, 
  // 6603
  119, 117, 117, 119, 
  // 6607
  124, 122, 122, 129, 
  // 6611
  129, 127, 127, 129, 
  // 6615
  103, 120, 
  // 6617
  134, 132, 132, 139, 
  // 6621
  139, 137, 137, 139, 
  // 6625
  144, 142, 142, 149, 
  // 6629
  149, 147, 147, 149, 
  // 6633
  290, 270, 270, 139, 
  // 6637
  102, 100, 100, 149, 
  // 6641
  107, 105, 105, 129, 
  // 6645
  114, 113, 113, 119, 
  // 6649
  119, 118, 118, 119, 
  // 6653
  124, 123, 123, 129, 
  // 6657
  104, 121, 
  // 6659
  129, 128, 128, 129, 
  // 6663
  134, 133, 133, 139, 
  // 6667
  139, 138, 138, 139, 
  // 6671
  144, 143, 143, 149, 
  // 6675
  149, 148, 148, 149, 
  // 6679
  290, 271, 271, 139, 
  // 6683
  102, 101, 101, 149, 
  // 6687
  107, 106, 106, 129, 
  // 6691
  114, 114, 114, 119, 
  // 6695
  119, 119, 119, 119, 
  // 6699
  105, 122, 
  // 6701
  124, 124, 124, 129, 
  // 6705
  129, 129, 129, 129, 
  // 6709
  134, 134, 134, 139, 
  // 6713
  139, 139, 139, 139, 
  // 6717
  144, 144, 144, 149, 
  // 6721
  149, 149, 149, 149, 
  // 6725
  290, 290, 290, 139, 
  // 6729
  102, 102, 102, 149, 
  // 6733
  107, 107, 107, 129, 
  // 6737
  270, 335, 88, 76, 
  // 6741
  106, 123, 
  // 6743
  132, 335, 88, 76, 
  // 6747
  137, 335, 88, 76, 
  // 6751
  270, 335, 88, 27, 
  // 6755
  132, 335, 88, 27, 
  // 6759
  137, 335, 88, 27, 
  // 6763
  270, 336, 88, 130, 
  // 6767
  132, 336, 88, 130, 
  // 6771
  137, 336, 88, 130, 
  // 6775
  107, 124, 
  // 6777
  270, 336, 88, 257, 
  // 6781
  132, 336, 88, 257, 
  // 6785
  137, 336, 88, 257, 
  // 6789
  270, 337, 88, 130, 
  // 6793
  132, 337, 88, 130, 
  // 6797
  137, 337, 88, 130, 
  // 6801
  270, 337, 88, 257, 
  // 6805
  132, 337, 88, 257, 
  // 6809
  137, 337, 88, 257, 
  // 6813
  270, 338, 88, 132, 
  // 6817
  132, 338, 88, 132, 
  // 6821
  137, 338, 88, 132, 
  // 6825
  270, 338, 88, 270, 
  // 6829
  132, 338, 88, 270, 
  // 6833
  137, 338, 88, 270, 
  // 6837
  270, 339, 88, 132, 
  // 6841
  132, 339, 88, 132, 
  // 6845
  137, 339, 88, 132, 
  // 6849
  270, 339, 88, 270, 
  // 6853
  132, 339, 88, 270, 
  // 6857
  137, 339, 88, 270, 
  // 6861
  27, 340, 88, 130, 
  // 6865
  27, 341, 88, 132, 
  // 6869
  27, 340, 88, 257, 
  // 6873
  27, 341, 88, 270, 
  // 6877
  270, 336, 130, 
  // 6880
  132, 336, 130, 
  // 6883
  137, 336, 130, 
  // 6886
  270, 338, 132, 
  // 6889
  132, 338, 132, 
  // 6892
  137, 338, 132, 
  // 6895
  270, 335, 76, 
  // 6898
  132, 335, 76, 
  // 6901
  137, 335, 76, 
  // 6904
  27, 340, 130, 
  // 6907
  27, 341, 132, 
  // 6910
  270, 337, 130, 
  // 6913
  132, 337, 130, 
  // 6916
  137, 337, 130, 
  // 6919
  270, 339, 132, 
  // 6922
  132, 339, 132, 
  // 6925
  137, 339, 132, 
  // 6928
  270, 342, 76, 
  // 6931
  132, 342, 76, 
  // 6934
  137, 342, 76, 
  // 6937
  270, 343, 130, 
  // 6940
  132, 343, 130, 
  // 6943
  137, 343, 130, 
  // 6946
  270, 344, 130, 
  // 6949
  132, 344, 130, 
  // 6952
  137, 344, 130, 
  // 6955
  270, 345, 132, 
  // 6958
  132, 345, 132, 
  // 6961
  137, 345, 132, 
  // 6964
  270, 346, 132, 
  // 6967
  132, 346, 132, 
  // 6970
  137, 346, 132, 
  // 6973
  270, 347, 76, 
  // 6976
  132, 347, 76, 
  // 6979
  137, 347, 76, 
  // 6982
  270, 348, 76, 
  // 6985
  132, 348, 76, 
  // 6988
  137, 348, 76, 
  // 6991
  27, 349, 130, 
  // 6994
  27, 350, 132, 
  // 6997
  97, 351, 130, 270, 
  // 7001
  97, 351, 130, 132, 
  // 7005
  97, 351, 130, 137, 
  // 7009
  97, 352, 132, 270, 
  // 7013
  97, 352, 132, 132, 
  // 7017
  97, 352, 132, 137, 
  // 7021
  97, 353, 76, 270, 
  // 7025
  97, 353, 76, 132, 
  // 7029
  97, 353, 76, 137, 
  // 7033
  97, 355, 130, 270, 
  // 7037
  97, 355, 130, 132, 
  // 7041
  97, 355, 130, 137, 
  // 7045
  97, 356, 132, 270, 
  // 7049
  97, 356, 132, 132, 
  // 7053
  97, 356, 132, 137, 
  // 7057
  97, 357, 130, 27, 
  // 7061
  97, 358, 132, 27, 
  // 7065
  97, 354, 76, 270, 
  // 7069
  97, 354, 76, 132, 
  // 7073
  97, 354, 76, 137, 
  // 7077
  97, 343, 130, 270, 
  // 7081
  97, 343, 130, 132, 
  // 7085
  97, 343, 130, 137, 
  // 7089
  97, 346, 132, 270, 
  // 7093
  97, 346, 132, 132, 
  // 7097
  97, 346, 132, 137, 
  // 7101
  97, 347, 76, 270, 
  // 7105
  97, 347, 76, 132, 
  // 7109
  97, 347, 76, 137, 
  // 7113
  97, 348, 76, 270, 
  // 7117
  97, 348, 76, 132, 
  // 7121
  97, 348, 76, 137, 
  // 7125
  97, 344, 130, 270, 
  // 7129
  97, 344, 130, 132, 
  // 7133
  97, 344, 130, 137, 
  // 7137
  97, 345, 132, 270, 
  // 7141
  97, 345, 132, 132, 
  // 7145
  97, 345, 132, 137, 
  // 7149
  97, 349, 130, 27, 
  // 7153
  97, 350, 132, 27, 
  // 7157
  76, 335, 
  // 7159
  76, 336, 
  // 7161
  76, 338, 
  // 7163
  130, 336, 
  // 7165
  132, 338, 
  // 7167
  90, 337, 
  // 7169
  76, 342, 
  // 7171
  76, 337, 
  // 7173
  76, 339, 
  // 7175
  76, 340, 
  // 7177
  76, 341, 
  // 7179
  130, 339, 
  // 7181
  130, 340, 
  // 7183
  130, 341, 
  // 7185
  90, 339, 
  // 7187
  90, 341, 
  // 7189
  76, 353, 
  // 7191
  76, 354, 
  // 7193
  76, 351, 
  // 7195
  76, 356, 
  // 7197
  76, 355, 
  // 7199
  76, 352, 
  // 7201
  76, 357, 
  // 7203
  76, 358, 
  // 7205
  130, 351, 
  // 7207
  130, 352, 
  // 7209
  130, 357, 
  // 7211
  130, 358, 
  // 7213
  132, 356, 
  // 7215
  90, 355, 
  // 7217
  90, 352, 
  // 7219
  90, 358, 
  // 7221
  76, 347, 
  // 7223
  76, 348, 
  // 7225
  76, 343, 
  // 7227
  76, 345, 
  // 7229
  76, 344, 
  // 7231
  76, 346, 
  // 7233
  53, 96, 
  // 7235
  76, 349, 
  // 7237
  76, 350, 
  // 7239
  103, 125, 
  // 7241
  130, 343, 
  // 7243
  130, 346, 
  // 7245
  130, 349, 
  // 7247
  130, 350, 
  // 7249
  132, 345, 
  // 7251
  90, 344, 
  // 7253
  104, 126, 
  // 7255
  90, 346, 
  // 7257
  90, 350, 
  // 7259
  105, 336, 88, 130, 
  // 7263
  105, 338, 88, 132, 
  // 7267
  105, 335, 88, 76, 
  // 7271
  105, 337, 88, 130, 
  // 7275
  105, 339, 88, 132, 
  // 7279
  105, 336, 88, 257, 
  // 7283
  105, 337, 88, 257, 
  // 7287
  105, 338, 88, 270, 
  // 7291
  105, 127, 
  // 7293
  105, 339, 88, 270, 
  // 7297
  105, 335, 88, 27, 
  // 7301
  105, 336, 130, 
  // 7304
  105, 338, 132, 
  // 7307
  105, 335, 76, 
  // 7310
  105, 337, 130, 
  // 7313
  105, 339, 132, 
  // 7316
  105, 342, 76, 
  // 7319
  106, 128, 
  // 7321
  105, 343, 130, 
  // 7324
  105, 344, 130, 
  // 7327
  105, 345, 132, 
  // 7330
  105, 346, 132, 
  // 7333
  105, 347, 76, 
  // 7336
  105, 348, 76, 
  // 7339
  97, 351, 130, 105, 
  // 7343
  97, 352, 132, 105, 
  // 7347
  97, 353, 76, 105, 
  // 7351
  97, 354, 76, 105, 
  // 7355
  107, 129, 
  // 7357
  97, 355, 130, 105, 
  // 7361
  97, 356, 132, 105, 
  // 7365
  97, 343, 130, 105, 
  // 7369
  97, 346, 132, 105, 
  // 7373
  97, 347, 76, 105, 
  // 7377
  97, 348, 76, 105, 
  // 7381
  97, 344, 130, 105, 
  // 7385
  97, 345, 132, 105, 
  // 7389
  77, 77, 90, 
  // 7392
  77, 77, 90, 90, 
  // 7396
  77, 77, 90, 90, 90, 
  // 7401
  77, 77, 
  // 7403
  19, 86, 
  // 7405
  76, 85, 93, 360, 361, 
  // 7410
  97, 22, 
  // 7412
  22, 
  // 7413
  19, 22, 
  // 7415
  97, 22, 76, 
  // 7418
  97, 22, 23, 362, 
  // 7422
  85, 
  // 7423
  83, 90, 
  // 7425
  83, 90, 90, 
  // 7428
  83, 90, 90, 90, 
  // 7432
  83, 364, 
  // 7434
  83, 364, 364, 
  // 7437
  83, 364, 364, 364, 
  // 7441
  270, 336, 88, 257, 27, 
  // 7446
  270, 336, 88, 257, 257, 257, 
  // 7452
  132, 336, 88, 257, 27, 
  // 7457
  132, 336, 88, 257, 257, 257, 
  // 7463
  137, 336, 88, 257, 27, 
  // 7468
  137, 336, 88, 257, 257, 257, 
  // 7474
  27, 340, 88, 257, 27, 
  // 7479
  27, 340, 88, 257, 257, 257, 
  // 7485
  270, 335, 88, 27, 27, 
  // 7490
  270, 335, 88, 27, 27, 27, 
  // 7496
  132, 335, 88, 27, 27, 
  // 7501
  132, 335, 88, 27, 27, 27, 
  // 7507
  137, 335, 88, 27, 27, 
  // 7512
  137, 335, 88, 27, 27, 27, 
  // 7518
  270, 338, 88, 270, 270, 270, 
  // 7524
  270, 338, 88, 270, 27, 
  // 7529
  132, 338, 88, 270, 270, 270, 
  // 7535
  132, 338, 88, 270, 27, 
  // 7540
  137, 338, 88, 270, 270, 270, 
  // 7546
  137, 338, 88, 270, 27, 
  // 7551
  270, 337, 88, 257, 27, 
  // 7556
  270, 337, 88, 257, 27, 27, 
  // 7562
  132, 337, 88, 257, 27, 
  // 7567
  132, 337, 88, 257, 27, 27, 
  // 7573
  137, 337, 88, 257, 27, 
  // 7578
  137, 337, 88, 257, 27, 27, 
  // 7584
  270, 339, 88, 270, 27, 
  // 7589
  270, 339, 88, 270, 257, 257, 
  // 7595
  132, 339, 88, 270, 27, 
  // 7600
  132, 339, 88, 270, 257, 257, 
  // 7606
  137, 339, 88, 270, 27, 
  // 7611
  137, 339, 88, 270, 257, 257, 
  // 7617
  27, 341, 88, 270, 27, 
  // 7622
  27, 341, 88, 270, 257, 257, 
  // 7628
  97, 351, 130, 76, 270, 
  // 7633
  97, 351, 130, 76, 132, 
  // 7638
  97, 351, 130, 76, 137, 
  // 7643
  97, 357, 130, 76, 27, 
  // 7648
  97, 353, 76, 76, 270, 
  // 7653
  97, 353, 76, 76, 132, 
  // 7658
  97, 353, 76, 76, 137, 
  // 7663
  97, 355, 130, 76, 270, 
  // 7668
  97, 355, 130, 76, 132, 
  // 7673
  97, 355, 130, 76, 137, 
  // 7678
  97, 352, 132, 76, 270, 
  // 7683
  97, 352, 132, 76, 132, 
  // 7688
  97, 352, 132, 76, 137, 
  // 7693
  97, 358, 132, 76, 27, 
  // 7698
  97, 356, 132, 76, 270, 
  // 7703
  97, 356, 132, 76, 132, 
  // 7708
  97, 356, 132, 76, 137, 
  // 7713
  270, 365, 130, 76, 
  // 7717
  132, 365, 130, 76, 
  // 7721
  137, 365, 130, 76, 
  // 7725
  270, 366, 132, 76, 
  // 7729
  132, 366, 132, 76, 
  // 7733
  137, 366, 132, 76, 
  // 7737
  27, 367, 130, 76, 
  // 7741
  27, 368, 132, 76, 
  // 7745
  76, 365, 
  // 7747
  130, 365, 
  // 7749
  90, 366, 
  // 7751
  76, 366, 
  // 7753
  130, 366, 
  // 7755
  76, 367, 
  // 7757
  130, 367, 
  // 7759
  76, 368, 
  // 7761
  130, 368, 
  // 7763
  90, 368, 
  // 7765
  76, 369, 
  // 7767
  130, 369, 
  // 7769
  76, 370, 
  // 7771
  130, 370, 
  // 7773
  76, 371, 
  // 7775
  130, 371, 
  // 7777
  76, 372, 
  // 7779
  130, 372, 
  // 7781
  90, 370, 
  // 7783
  90, 372, 
  // 7785
  270, 373, 130, 76, 
  // 7789
  132, 373, 130, 76, 
  // 7793
  137, 373, 130, 76, 
  // 7797
  270, 374, 132, 76, 
  // 7801
  132, 374, 132, 76, 
  // 7805
  137, 374, 132, 76, 
  // 7809
  27, 375, 130, 76, 
  // 7813
  27, 376, 132, 76, 
  // 7817
  76, 373, 
  // 7819
  130, 373, 
  // 7821
  76, 374, 
  // 7823
  130, 374, 
  // 7825
  76, 375, 
  // 7827
  130, 375, 
  // 7829
  76, 376, 
  // 7831
  130, 376, 
  // 7833
  90, 374, 
  // 7835
  90, 376, 
  // 7837
  77, 77, 93, 
  // 7840
  21, 21, 93, 
  // 7843
  2, 2, 93, 
  // 7846
  21, 21, 
  // 7848
  76, 
  // 7849
  76, 0, 
  // 7851
  1, 1, 93, 
  // 7854
  137, 76, 
  // 7856
  76, 137, 
  // 7858
  76, 137, 93, 
  // 7861
  93, 137, 
  // 7863
  137, 
};

static const OpenCLBuiltinStruct BuiltinTable[] = {
  // 1: convert_float2_rtz, convert_float2, convert_float2_rte, convert_float2_rtn, convert_float2_rtp, 
  { 0, 2, 0, 1, 0, 43, 31 },
  { 145, 2, 0, 1, 0, 43, 31 },
  { 239, 2, 0, 1, 0, 43, 31 },
  { 313, 2, 0, 1, 0, 43, 31 },
  { 397, 2, 0, 1, 0, 43, 31 },
  { 481, 2, 0, 1, 0, 43, 31 },
  { 565, 2, 0, 1, 0, 43, 31 },
  { 649, 2, 0, 1, 0, 43, 31 },
  { 731, 2, 0, 1, 0, 43, 31 },
  { 805, 2, 0, 1, 0, 43, 31 },
  { 887, 2, 0, 1, 0, 43, 31 },
  // 12: convert_half16, convert_half16_rte, convert_half16_rtn, convert_half16_rtp, convert_half16_rtz, 
  { 2, 2, 0, 1, 0, 43, 31 },
  { 127, 2, 0, 1, 0, 43, 31 },
  { 143, 2, 0, 1, 0, 43, 31 },
  { 159, 2, 0, 1, 0, 43, 31 },
  { 3895, 2, 0, 1, 0, 43, 31 },
  { 4274, 2, 0, 1, 0, 43, 31 },
  { 4820, 2, 0, 1, 0, 43, 31 },
  { 5368, 2, 0, 1, 0, 43, 31 },
  { 5684, 2, 0, 1, 0, 43, 31 },
  { 6775, 2, 0, 1, 0, 43, 31 },
  { 7355, 2, 0, 1, 0, 43, 31 },
  // 23: sub_group_non_uniform_reduce_max, sub_group_non_uniform_reduce_mul, sub_group_non_uniform_scan_exclusive_add, sub_group_non_uniform_scan_exclusive_min, sub_group_non_uniform_scan_exclusive_max, sub_group_non_uniform_scan_exclusive_mul, sub_group_non_uniform_scan_inclusive_add, sub_group_non_uniform_scan_inclusive_min, sub_group_non_uniform_scan_inclusive_max, sub_group_non_uniform_scan_inclusive_mul, sub_group_non_uniform_reduce_add, sub_group_non_uniform_reduce_min, 
  { 4, 2, 0, 0, 0, 38, 31 },
  // 24: sub_group_non_uniform_reduce_or, sub_group_non_uniform_reduce_xor, sub_group_non_uniform_scan_exclusive_and, sub_group_non_uniform_scan_exclusive_or, sub_group_non_uniform_scan_exclusive_xor, sub_group_non_uniform_scan_inclusive_and, sub_group_non_uniform_scan_inclusive_or, sub_group_non_uniform_scan_inclusive_xor, sub_group_non_uniform_reduce_and, 
  { 6, 2, 0, 0, 0, 38, 31 },
  // 25: sub_group_non_uniform_reduce_logical_or, sub_group_non_uniform_reduce_logical_xor, sub_group_non_uniform_scan_exclusive_logical_and, sub_group_non_uniform_scan_exclusive_logical_or, sub_group_non_uniform_scan_exclusive_logical_xor, sub_group_non_uniform_scan_inclusive_logical_and, sub_group_non_uniform_scan_inclusive_logical_or, sub_group_non_uniform_scan_inclusive_logical_xor, sub_group_non_uniform_reduce_logical_and, 
  { 8, 2, 0, 0, 0, 38, 31 },
  // 26: convert_half_rte, convert_half_rtn, convert_half_rtp, convert_half_rtz, convert_half, 
  { 10, 2, 0, 1, 0, 43, 31 },
  { 115, 2, 0, 1, 0, 43, 31 },
  { 133, 2, 0, 1, 0, 43, 31 },
  { 147, 2, 0, 1, 0, 43, 31 },
  { 3817, 2, 0, 1, 0, 43, 31 },
  { 4223, 2, 0, 1, 0, 43, 31 },
  { 4798, 2, 0, 1, 0, 43, 31 },
  { 5356, 2, 0, 1, 0, 43, 31 },
  { 5524, 2, 0, 1, 0, 43, 31 },
  { 6573, 2, 0, 1, 0, 43, 31 },
  { 7233, 2, 0, 1, 0, 43, 31 },
  // 37: convert_half2_rte, convert_half2_rtn, convert_half2_rtp, convert_half2_rtz, convert_half2, 
  { 12, 2, 0, 1, 0, 43, 31 },
  { 117, 2, 0, 1, 0, 43, 31 },
  { 135, 2, 0, 1, 0, 43, 31 },
  { 149, 2, 0, 1, 0, 43, 31 },
  { 3839, 2, 0, 1, 0, 43, 31 },
  { 4254, 2, 0, 1, 0, 43, 31 },
  { 4800, 2, 0, 1, 0, 43, 31 },
  { 5358, 2, 0, 1, 0, 43, 31 },
  { 5556, 2, 0, 1, 0, 43, 31 },
  { 6615, 2, 0, 1, 0, 43, 31 },
  { 7239, 2, 0, 1, 0, 43, 31 },
  // 48: sub_group_shuffle, sub_group_shuffle_xor, 
  { 14, 3, 0, 0, 0, 40, 31 },
  // 49: sub_group_shuffle_up, sub_group_shuffle_down, 
  { 14, 3, 0, 0, 0, 41, 31 },
  // 50: convert_half3_rte, convert_half3_rtn, convert_half3_rtp, convert_half3_rtz, convert_half3, 
  { 17, 2, 0, 1, 0, 43, 31 },
  { 119, 2, 0, 1, 0, 43, 31 },
  { 137, 2, 0, 1, 0, 43, 31 },
  { 151, 2, 0, 1, 0, 43, 31 },
  { 3853, 2, 0, 1, 0, 43, 31 },
  { 4256, 2, 0, 1, 0, 43, 31 },
  { 4814, 2, 0, 1, 0, 43, 31 },
  { 5360, 2, 0, 1, 0, 43, 31 },
  { 5588, 2, 0, 1, 0, 43, 31 },
  { 6657, 2, 0, 1, 0, 43, 31 },
  { 7253, 2, 0, 1, 0, 43, 31 },
  // 61: sub_group_clustered_reduce_add, sub_group_clustered_reduce_min, sub_group_clustered_reduce_max, sub_group_clustered_reduce_mul, 
  { 14, 3, 0, 0, 0, 36, 31 },
  // 62: sub_group_clustered_reduce_and, sub_group_clustered_reduce_or, sub_group_clustered_reduce_xor, 
  { 19, 3, 0, 0, 0, 36, 31 },
  // 63: sub_group_clustered_reduce_logical_and, sub_group_clustered_reduce_logical_or, sub_group_clustered_reduce_logical_xor, 
  { 22, 3, 0, 0, 0, 36, 31 },
  // 64: convert_half4_rte, convert_half4_rtn, convert_half4_rtp, convert_half4_rtz, convert_half4, 
  { 25, 2, 0, 1, 0, 43, 31 },
  { 121, 2, 0, 1, 0, 43, 31 },
  { 139, 2, 0, 1, 0, 43, 31 },
  { 153, 2, 0, 1, 0, 43, 31 },
  { 3873, 2, 0, 1, 0, 43, 31 },
  { 4258, 2, 0, 1, 0, 43, 31 },
  { 4816, 2, 0, 1, 0, 43, 31 },
  { 5362, 2, 0, 1, 0, 43, 31 },
  { 5620, 2, 0, 1, 0, 43, 31 },
  { 6699, 2, 0, 1, 0, 43, 31 },
  { 7291, 2, 0, 1, 0, 43, 31 },
  // 75: bitfield_insert, 
  { 27, 5, 0, 1, 0, 25, 31 },
  // 76: bitfield_extract_signed, 
  { 32, 4, 0, 1, 0, 25, 31 },
  { 36, 4, 0, 1, 0, 25, 31 },
  // 78: bitfield_extract_unsigned, 
  { 40, 4, 0, 1, 0, 25, 31 },
  { 44, 4, 0, 1, 0, 25, 31 },
  // 80: bit_reverse, 
  { 48, 2, 0, 1, 0, 25, 31 },
  // 81: dot, 
  { 50, 3, 0, 1, 0, 51, 31 },
  { 53, 3, 0, 1, 0, 51, 31 },
  { 56, 3, 0, 1, 0, 51, 31 },
  { 61, 3, 0, 1, 0, 51, 31 },
  { 1692, 3, 0, 1, 0, 43, 31 },
  { 1695, 3, 0, 1, 0, 43, 31 },
  { 1698, 3, 0, 1, 0, 43, 31 },
  // 88: convert_half8_rte, convert_half8_rtn, convert_half8_rtp, convert_half8_rtz, convert_half8, 
  { 59, 2, 0, 1, 0, 43, 31 },
  { 123, 2, 0, 1, 0, 43, 31 },
  { 141, 2, 0, 1, 0, 43, 31 },
  { 155, 2, 0, 1, 0, 43, 31 },
  { 3880, 2, 0, 1, 0, 43, 31 },
  { 4272, 2, 0, 1, 0, 43, 31 },
  { 4818, 2, 0, 1, 0, 43, 31 },
  { 5364, 2, 0, 1, 0, 43, 31 },
  { 5652, 2, 0, 1, 0, 43, 31 },
  { 6741, 2, 0, 1, 0, 43, 31 },
  { 7319, 2, 0, 1, 0, 43, 31 },
  // 99: dot_acc_sat, 
  { 64, 4, 0, 1, 0, 51, 31 },
  { 68, 4, 0, 1, 0, 51, 31 },
  { 72, 4, 0, 1, 0, 51, 31 },
  { 76, 4, 0, 1, 0, 51, 31 },
  // 103: dot_4x8packed_uu_uint, 
  { 80, 3, 0, 1, 0, 52, 31 },
  // 104: dot_4x8packed_ss_int, dot_4x8packed_us_int, dot_4x8packed_su_int, 
  { 83, 3, 0, 1, 0, 52, 31 },
  // 105: dot_acc_sat_4x8packed_uu_uint, 
  { 86, 4, 0, 1, 0, 52, 31 },
  // 106: dot_acc_sat_4x8packed_ss_int, dot_acc_sat_4x8packed_us_int, dot_acc_sat_4x8packed_su_int, 
  { 90, 4, 0, 1, 0, 52, 31 },
  // 107: sub_group_rotate, 
  { 94, 3, 0, 0, 1, 53, 31 },
  // 108: sub_group_clustered_rotate, 
  { 97, 4, 0, 0, 1, 53, 31 },
  // 109: clock_read_device, 
  { 101, 1, 0, 0, 0, 54, 31 },
  // 110: clock_read_hilo_device, 
  { 102, 1, 0, 0, 0, 54, 31 },
  // 111: clock_read_work_group, 
  { 101, 1, 0, 0, 0, 55, 31 },
  // 112: clock_read_hilo_work_group, 
  { 102, 1, 0, 0, 0, 55, 31 },
  // 113: clock_read_sub_group, 
  { 101, 1, 0, 0, 0, 56, 31 },
  // 114: clock_read_hilo_sub_group, 
  { 102, 1, 0, 0, 0, 56, 31 },
  // 115: arm_dot, 
  { 50, 3, 0, 0, 0, 3, 31 },
  { 53, 3, 0, 0, 0, 3, 31 },
  // 117: arm_dot_acc, 
  { 64, 4, 0, 0, 0, 1, 31 },
  { 68, 4, 0, 0, 0, 1, 31 },
  { 103, 4, 0, 0, 0, 0, 31 },
  { 107, 4, 0, 0, 0, 0, 31 },
  // 121: arm_dot_acc_sat, 
  { 64, 4, 0, 0, 0, 2, 31 },
  { 68, 4, 0, 0, 0, 2, 31 },
  // 123: convert_float3_rtz, convert_float3, convert_float3_rte, convert_float3_rtn, convert_float3_rtp, 
  { 111, 2, 0, 1, 0, 43, 31 },
  { 157, 2, 0, 1, 0, 43, 31 },
  { 243, 2, 0, 1, 0, 43, 31 },
  { 327, 2, 0, 1, 0, 43, 31 },
  { 409, 2, 0, 1, 0, 43, 31 },
  { 483, 2, 0, 1, 0, 43, 31 },
  { 567, 2, 0, 1, 0, 43, 31 },
  { 651, 2, 0, 1, 0, 43, 31 },
  { 735, 2, 0, 1, 0, 43, 31 },
  { 819, 2, 0, 1, 0, 43, 31 },
  { 899, 2, 0, 1, 0, 43, 31 },
  // 134: convert_float4_rtz, convert_float4, convert_float4_rte, convert_float4_rtn, convert_float4_rtp, 
  { 113, 2, 0, 1, 0, 43, 31 },
  { 161, 2, 0, 1, 0, 43, 31 },
  { 245, 2, 0, 1, 0, 43, 31 },
  { 329, 2, 0, 1, 0, 43, 31 },
  { 413, 2, 0, 1, 0, 43, 31 },
  { 497, 2, 0, 1, 0, 43, 31 },
  { 579, 2, 0, 1, 0, 43, 31 },
  { 653, 2, 0, 1, 0, 43, 31 },
  { 737, 2, 0, 1, 0, 43, 31 },
  { 821, 2, 0, 1, 0, 43, 31 },
  { 903, 2, 0, 1, 0, 43, 31 },
  // 145: convert_float8_rtz, convert_float8, convert_float8_rte, convert_float8_rtn, convert_float8_rtp, 
  { 125, 2, 0, 1, 0, 43, 31 },
  { 175, 2, 0, 1, 0, 43, 31 },
  { 257, 2, 0, 1, 0, 43, 31 },
  { 331, 2, 0, 1, 0, 43, 31 },
  { 415, 2, 0, 1, 0, 43, 31 },
  { 499, 2, 0, 1, 0, 43, 31 },
  { 583, 2, 0, 1, 0, 43, 31 },
  { 667, 2, 0, 1, 0, 43, 31 },
  { 749, 2, 0, 1, 0, 43, 31 },
  { 823, 2, 0, 1, 0, 43, 31 },
  { 905, 2, 0, 1, 0, 43, 31 },
  // 156: convert_float16_rtz, convert_float16, convert_float16_rte, convert_float16_rtn, convert_float16_rtp, 
  { 129, 2, 0, 1, 0, 43, 31 },
  { 177, 2, 0, 1, 0, 43, 31 },
  { 261, 2, 0, 1, 0, 43, 31 },
  { 345, 2, 0, 1, 0, 43, 31 },
  { 427, 2, 0, 1, 0, 43, 31 },
  { 501, 2, 0, 1, 0, 43, 31 },
  { 585, 2, 0, 1, 0, 43, 31 },
  { 669, 2, 0, 1, 0, 43, 31 },
  { 753, 2, 0, 1, 0, 43, 31 },
  { 837, 2, 0, 1, 0, 43, 31 },
  { 917, 2, 0, 1, 0, 43, 31 },
  // 167: convert_float, convert_float_rte, convert_float_rtn, convert_float_rtp, convert_float_rtz, 
  { 131, 2, 0, 1, 0, 43, 31 },
  { 227, 2, 0, 1, 0, 43, 31 },
  { 311, 2, 0, 1, 0, 43, 31 },
  { 395, 2, 0, 1, 0, 43, 31 },
  { 479, 2, 0, 1, 0, 43, 31 },
  { 561, 2, 0, 1, 0, 43, 31 },
  { 635, 2, 0, 1, 0, 43, 31 },
  { 719, 2, 0, 1, 0, 43, 31 },
  { 803, 2, 0, 1, 0, 43, 31 },
  { 885, 2, 0, 1, 0, 43, 31 },
  { 2449, 2, 0, 1, 0, 43, 31 },
  // 178: convert_char, convert_char_rte, convert_char_rtn, convert_char_rtp, convert_char_rtz, convert_char_sat, convert_char_sat_rte, convert_char_sat_rtn, convert_char_sat_rtp, convert_char_sat_rtz, 
  { 163, 2, 0, 1, 0, 43, 31 },
  { 179, 2, 0, 1, 0, 43, 31 },
  { 191, 2, 0, 1, 0, 43, 31 },
  { 203, 2, 0, 1, 0, 43, 31 },
  { 215, 2, 0, 1, 0, 43, 31 },
  { 229, 2, 0, 1, 0, 43, 31 },
  { 247, 2, 0, 1, 0, 43, 31 },
  { 263, 2, 0, 1, 0, 43, 31 },
  { 275, 2, 0, 1, 0, 43, 31 },
  { 287, 2, 0, 1, 0, 43, 31 },
  { 299, 2, 0, 1, 0, 43, 31 },
  // 189: convert_char2, convert_char2_rte, convert_char2_rtn, convert_char2_rtp, convert_char2_rtz, convert_char2_sat, convert_char2_sat_rte, convert_char2_sat_rtn, convert_char2_sat_rtp, convert_char2_sat_rtz, 
  { 165, 2, 0, 1, 0, 43, 31 },
  { 181, 2, 0, 1, 0, 43, 31 },
  { 193, 2, 0, 1, 0, 43, 31 },
  { 205, 2, 0, 1, 0, 43, 31 },
  { 217, 2, 0, 1, 0, 43, 31 },
  { 231, 2, 0, 1, 0, 43, 31 },
  { 249, 2, 0, 1, 0, 43, 31 },
  { 265, 2, 0, 1, 0, 43, 31 },
  { 277, 2, 0, 1, 0, 43, 31 },
  { 289, 2, 0, 1, 0, 43, 31 },
  { 301, 2, 0, 1, 0, 43, 31 },
  // 200: convert_char3, convert_char3_rte, convert_char3_rtn, convert_char3_rtp, convert_char3_rtz, convert_char3_sat, convert_char3_sat_rte, convert_char3_sat_rtn, convert_char3_sat_rtp, convert_char3_sat_rtz, 
  { 167, 2, 0, 1, 0, 43, 31 },
  { 183, 2, 0, 1, 0, 43, 31 },
  { 195, 2, 0, 1, 0, 43, 31 },
  { 207, 2, 0, 1, 0, 43, 31 },
  { 219, 2, 0, 1, 0, 43, 31 },
  { 233, 2, 0, 1, 0, 43, 31 },
  { 251, 2, 0, 1, 0, 43, 31 },
  { 267, 2, 0, 1, 0, 43, 31 },
  { 279, 2, 0, 1, 0, 43, 31 },
  { 291, 2, 0, 1, 0, 43, 31 },
  { 303, 2, 0, 1, 0, 43, 31 },
  // 211: convert_char4, convert_char4_rte, convert_char4_rtn, convert_char4_rtp, convert_char4_rtz, convert_char4_sat, convert_char4_sat_rte, convert_char4_sat_rtn, convert_char4_sat_rtp, convert_char4_sat_rtz, 
  { 169, 2, 0, 1, 0, 43, 31 },
  { 185, 2, 0, 1, 0, 43, 31 },
  { 197, 2, 0, 1, 0, 43, 31 },
  { 209, 2, 0, 1, 0, 43, 31 },
  { 221, 2, 0, 1, 0, 43, 31 },
  { 235, 2, 0, 1, 0, 43, 31 },
  { 253, 2, 0, 1, 0, 43, 31 },
  { 269, 2, 0, 1, 0, 43, 31 },
  { 281, 2, 0, 1, 0, 43, 31 },
  { 293, 2, 0, 1, 0, 43, 31 },
  { 305, 2, 0, 1, 0, 43, 31 },
  // 222: convert_char8, convert_char8_rte, convert_char8_rtn, convert_char8_rtp, convert_char8_rtz, convert_char8_sat, convert_char8_sat_rte, convert_char8_sat_rtn, convert_char8_sat_rtp, convert_char8_sat_rtz, 
  { 171, 2, 0, 1, 0, 43, 31 },
  { 187, 2, 0, 1, 0, 43, 31 },
  { 199, 2, 0, 1, 0, 43, 31 },
  { 211, 2, 0, 1, 0, 43, 31 },
  { 223, 2, 0, 1, 0, 43, 31 },
  { 237, 2, 0, 1, 0, 43, 31 },
  { 255, 2, 0, 1, 0, 43, 31 },
  { 271, 2, 0, 1, 0, 43, 31 },
  { 283, 2, 0, 1, 0, 43, 31 },
  { 295, 2, 0, 1, 0, 43, 31 },
  { 307, 2, 0, 1, 0, 43, 31 },
  // 233: convert_char16, convert_char16_rte, convert_char16_rtn, convert_char16_rtp, convert_char16_rtz, convert_char16_sat, convert_char16_sat_rte, convert_char16_sat_rtn, convert_char16_sat_rtp, convert_char16_sat_rtz, 
  { 173, 2, 0, 1, 0, 43, 31 },
  { 189, 2, 0, 1, 0, 43, 31 },
  { 201, 2, 0, 1, 0, 43, 31 },
  { 213, 2, 0, 1, 0, 43, 31 },
  { 225, 2, 0, 1, 0, 43, 31 },
  { 241, 2, 0, 1, 0, 43, 31 },
  { 259, 2, 0, 1, 0, 43, 31 },
  { 273, 2, 0, 1, 0, 43, 31 },
  { 285, 2, 0, 1, 0, 43, 31 },
  { 297, 2, 0, 1, 0, 43, 31 },
  { 309, 2, 0, 1, 0, 43, 31 },
  // 244: convert_uchar, convert_uchar_rte, convert_uchar_rtn, convert_uchar_rtp, convert_uchar_rtz, convert_uchar_sat, convert_uchar_sat_rte, convert_uchar_sat_rtn, convert_uchar_sat_rtp, convert_uchar_sat_rtz, 
  { 315, 2, 0, 1, 0, 43, 31 },
  { 333, 2, 0, 1, 0, 43, 31 },
  { 347, 2, 0, 1, 0, 43, 31 },
  { 359, 2, 0, 1, 0, 43, 31 },
  { 371, 2, 0, 1, 0, 43, 31 },
  { 383, 2, 0, 1, 0, 43, 31 },
  { 399, 2, 0, 1, 0, 43, 31 },
  { 417, 2, 0, 1, 0, 43, 31 },
  { 431, 2, 0, 1, 0, 43, 31 },
  { 443, 2, 0, 1, 0, 43, 31 },
  { 455, 2, 0, 1, 0, 43, 31 },
  // 255: convert_uchar2, convert_uchar2_rte, convert_uchar2_rtn, convert_uchar2_rtp, convert_uchar2_rtz, convert_uchar2_sat, convert_uchar2_sat_rte, convert_uchar2_sat_rtn, convert_uchar2_sat_rtp, convert_uchar2_sat_rtz, 
  { 317, 2, 0, 1, 0, 43, 31 },
  { 335, 2, 0, 1, 0, 43, 31 },
  { 349, 2, 0, 1, 0, 43, 31 },
  { 361, 2, 0, 1, 0, 43, 31 },
  { 373, 2, 0, 1, 0, 43, 31 },
  { 385, 2, 0, 1, 0, 43, 31 },
  { 401, 2, 0, 1, 0, 43, 31 },
  { 419, 2, 0, 1, 0, 43, 31 },
  { 433, 2, 0, 1, 0, 43, 31 },
  { 445, 2, 0, 1, 0, 43, 31 },
  { 457, 2, 0, 1, 0, 43, 31 },
  // 266: convert_uchar3, convert_uchar3_rte, convert_uchar3_rtn, convert_uchar3_rtp, convert_uchar3_rtz, convert_uchar3_sat, convert_uchar3_sat_rte, convert_uchar3_sat_rtn, convert_uchar3_sat_rtp, convert_uchar3_sat_rtz, 
  { 319, 2, 0, 1, 0, 43, 31 },
  { 337, 2, 0, 1, 0, 43, 31 },
  { 351, 2, 0, 1, 0, 43, 31 },
  { 363, 2, 0, 1, 0, 43, 31 },
  { 375, 2, 0, 1, 0, 43, 31 },
  { 387, 2, 0, 1, 0, 43, 31 },
  { 403, 2, 0, 1, 0, 43, 31 },
  { 421, 2, 0, 1, 0, 43, 31 },
  { 435, 2, 0, 1, 0, 43, 31 },
  { 447, 2, 0, 1, 0, 43, 31 },
  { 459, 2, 0, 1, 0, 43, 31 },
  // 277: convert_uchar4, convert_uchar4_rte, convert_uchar4_rtn, convert_uchar4_rtp, convert_uchar4_rtz, convert_uchar4_sat, convert_uchar4_sat_rte, convert_uchar4_sat_rtn, convert_uchar4_sat_rtp, convert_uchar4_sat_rtz, 
  { 321, 2, 0, 1, 0, 43, 31 },
  { 339, 2, 0, 1, 0, 43, 31 },
  { 353, 2, 0, 1, 0, 43, 31 },
  { 365, 2, 0, 1, 0, 43, 31 },
  { 377, 2, 0, 1, 0, 43, 31 },
  { 389, 2, 0, 1, 0, 43, 31 },
  { 405, 2, 0, 1, 0, 43, 31 },
  { 423, 2, 0, 1, 0, 43, 31 },
  { 437, 2, 0, 1, 0, 43, 31 },
  { 449, 2, 0, 1, 0, 43, 31 },
  { 461, 2, 0, 1, 0, 43, 31 },
  // 288: convert_uchar8, convert_uchar8_rte, convert_uchar8_rtn, convert_uchar8_rtp, convert_uchar8_rtz, convert_uchar8_sat, convert_uchar8_sat_rte, convert_uchar8_sat_rtn, convert_uchar8_sat_rtp, convert_uchar8_sat_rtz, 
  { 323, 2, 0, 1, 0, 43, 31 },
  { 341, 2, 0, 1, 0, 43, 31 },
  { 355, 2, 0, 1, 0, 43, 31 },
  { 367, 2, 0, 1, 0, 43, 31 },
  { 379, 2, 0, 1, 0, 43, 31 },
  { 391, 2, 0, 1, 0, 43, 31 },
  { 407, 2, 0, 1, 0, 43, 31 },
  { 425, 2, 0, 1, 0, 43, 31 },
  { 439, 2, 0, 1, 0, 43, 31 },
  { 451, 2, 0, 1, 0, 43, 31 },
  { 463, 2, 0, 1, 0, 43, 31 },
  // 299: convert_uchar16, convert_uchar16_rte, convert_uchar16_rtn, convert_uchar16_rtp, convert_uchar16_rtz, convert_uchar16_sat, convert_uchar16_sat_rte, convert_uchar16_sat_rtn, convert_uchar16_sat_rtp, convert_uchar16_sat_rtz, 
  { 325, 2, 0, 1, 0, 43, 31 },
  { 343, 2, 0, 1, 0, 43, 31 },
  { 357, 2, 0, 1, 0, 43, 31 },
  { 369, 2, 0, 1, 0, 43, 31 },
  { 381, 2, 0, 1, 0, 43, 31 },
  { 393, 2, 0, 1, 0, 43, 31 },
  { 411, 2, 0, 1, 0, 43, 31 },
  { 429, 2, 0, 1, 0, 43, 31 },
  { 441, 2, 0, 1, 0, 43, 31 },
  { 453, 2, 0, 1, 0, 43, 31 },
  { 465, 2, 0, 1, 0, 43, 31 },
  // 310: convert_short, convert_short_rte, convert_short_rtn, convert_short_rtp, convert_short_rtz, convert_short_sat, convert_short_sat_rte, convert_short_sat_rtn, convert_short_sat_rtp, convert_short_sat_rtz, 
  { 467, 2, 0, 1, 0, 43, 31 },
  { 485, 2, 0, 1, 0, 43, 31 },
  { 503, 2, 0, 1, 0, 43, 31 },
  { 515, 2, 0, 1, 0, 43, 31 },
  { 527, 2, 0, 1, 0, 43, 31 },
  { 539, 2, 0, 1, 0, 43, 31 },
  { 551, 2, 0, 1, 0, 43, 31 },
  { 569, 2, 0, 1, 0, 43, 31 },
  { 587, 2, 0, 1, 0, 43, 31 },
  { 599, 2, 0, 1, 0, 43, 31 },
  { 611, 2, 0, 1, 0, 43, 31 },
  // 321: convert_short2, convert_short2_rte, convert_short2_rtn, convert_short2_rtp, convert_short2_rtz, convert_short2_sat, convert_short2_sat_rte, convert_short2_sat_rtn, convert_short2_sat_rtp, convert_short2_sat_rtz, 
  { 469, 2, 0, 1, 0, 43, 31 },
  { 487, 2, 0, 1, 0, 43, 31 },
  { 505, 2, 0, 1, 0, 43, 31 },
  { 517, 2, 0, 1, 0, 43, 31 },
  { 529, 2, 0, 1, 0, 43, 31 },
  { 541, 2, 0, 1, 0, 43, 31 },
  { 553, 2, 0, 1, 0, 43, 31 },
  { 571, 2, 0, 1, 0, 43, 31 },
  { 589, 2, 0, 1, 0, 43, 31 },
  { 601, 2, 0, 1, 0, 43, 31 },
  { 613, 2, 0, 1, 0, 43, 31 },
  // 332: convert_short3, convert_short3_rte, convert_short3_rtn, convert_short3_rtp, convert_short3_rtz, convert_short3_sat, convert_short3_sat_rte, convert_short3_sat_rtn, convert_short3_sat_rtp, convert_short3_sat_rtz, 
  { 471, 2, 0, 1, 0, 43, 31 },
  { 489, 2, 0, 1, 0, 43, 31 },
  { 507, 2, 0, 1, 0, 43, 31 },
  { 519, 2, 0, 1, 0, 43, 31 },
  { 531, 2, 0, 1, 0, 43, 31 },
  { 543, 2, 0, 1, 0, 43, 31 },
  { 555, 2, 0, 1, 0, 43, 31 },
  { 573, 2, 0, 1, 0, 43, 31 },
  { 591, 2, 0, 1, 0, 43, 31 },
  { 603, 2, 0, 1, 0, 43, 31 },
  { 615, 2, 0, 1, 0, 43, 31 },
  // 343: convert_short4, convert_short4_rte, convert_short4_rtn, convert_short4_rtp, convert_short4_rtz, convert_short4_sat, convert_short4_sat_rte, convert_short4_sat_rtn, convert_short4_sat_rtp, convert_short4_sat_rtz, 
  { 473, 2, 0, 1, 0, 43, 31 },
  { 491, 2, 0, 1, 0, 43, 31 },
  { 509, 2, 0, 1, 0, 43, 31 },
  { 521, 2, 0, 1, 0, 43, 31 },
  { 533, 2, 0, 1, 0, 43, 31 },
  { 545, 2, 0, 1, 0, 43, 31 },
  { 557, 2, 0, 1, 0, 43, 31 },
  { 575, 2, 0, 1, 0, 43, 31 },
  { 593, 2, 0, 1, 0, 43, 31 },
  { 605, 2, 0, 1, 0, 43, 31 },
  { 617, 2, 0, 1, 0, 43, 31 },
  // 354: convert_short8, convert_short8_rte, convert_short8_rtn, convert_short8_rtp, convert_short8_rtz, convert_short8_sat, convert_short8_sat_rte, convert_short8_sat_rtn, convert_short8_sat_rtp, convert_short8_sat_rtz, 
  { 475, 2, 0, 1, 0, 43, 31 },
  { 493, 2, 0, 1, 0, 43, 31 },
  { 511, 2, 0, 1, 0, 43, 31 },
  { 523, 2, 0, 1, 0, 43, 31 },
  { 535, 2, 0, 1, 0, 43, 31 },
  { 547, 2, 0, 1, 0, 43, 31 },
  { 559, 2, 0, 1, 0, 43, 31 },
  { 577, 2, 0, 1, 0, 43, 31 },
  { 595, 2, 0, 1, 0, 43, 31 },
  { 607, 2, 0, 1, 0, 43, 31 },
  { 619, 2, 0, 1, 0, 43, 31 },
  // 365: convert_short16, convert_short16_rte, convert_short16_rtn, convert_short16_rtp, convert_short16_rtz, convert_short16_sat, convert_short16_sat_rte, convert_short16_sat_rtn, convert_short16_sat_rtp, convert_short16_sat_rtz, 
  { 477, 2, 0, 1, 0, 43, 31 },
  { 495, 2, 0, 1, 0, 43, 31 },
  { 513, 2, 0, 1, 0, 43, 31 },
  { 525, 2, 0, 1, 0, 43, 31 },
  { 537, 2, 0, 1, 0, 43, 31 },
  { 549, 2, 0, 1, 0, 43, 31 },
  { 563, 2, 0, 1, 0, 43, 31 },
  { 581, 2, 0, 1, 0, 43, 31 },
  { 597, 2, 0, 1, 0, 43, 31 },
  { 609, 2, 0, 1, 0, 43, 31 },
  { 621, 2, 0, 1, 0, 43, 31 },
  // 376: convert_ushort, convert_ushort_rte, convert_ushort_rtn, convert_ushort_rtp, convert_ushort_rtz, convert_ushort_sat, convert_ushort_sat_rte, convert_ushort_sat_rtn, convert_ushort_sat_rtp, convert_ushort_sat_rtz, 
  { 623, 2, 0, 1, 0, 43, 31 },
  { 637, 2, 0, 1, 0, 43, 31 },
  { 655, 2, 0, 1, 0, 43, 31 },
  { 671, 2, 0, 1, 0, 43, 31 },
  { 683, 2, 0, 1, 0, 43, 31 },
  { 695, 2, 0, 1, 0, 43, 31 },
  { 707, 2, 0, 1, 0, 43, 31 },
  { 721, 2, 0, 1, 0, 43, 31 },
  { 739, 2, 0, 1, 0, 43, 31 },
  { 755, 2, 0, 1, 0, 43, 31 },
  { 767, 2, 0, 1, 0, 43, 31 },
  // 387: convert_ushort2, convert_ushort2_rte, convert_ushort2_rtn, convert_ushort2_rtp, convert_ushort2_rtz, convert_ushort2_sat, convert_ushort2_sat_rte, convert_ushort2_sat_rtn, convert_ushort2_sat_rtp, convert_ushort2_sat_rtz, 
  { 625, 2, 0, 1, 0, 43, 31 },
  { 639, 2, 0, 1, 0, 43, 31 },
  { 657, 2, 0, 1, 0, 43, 31 },
  { 673, 2, 0, 1, 0, 43, 31 },
  { 685, 2, 0, 1, 0, 43, 31 },
  { 697, 2, 0, 1, 0, 43, 31 },
  { 709, 2, 0, 1, 0, 43, 31 },
  { 723, 2, 0, 1, 0, 43, 31 },
  { 741, 2, 0, 1, 0, 43, 31 },
  { 757, 2, 0, 1, 0, 43, 31 },
  { 769, 2, 0, 1, 0, 43, 31 },
  // 398: convert_ushort3, convert_ushort3_rte, convert_ushort3_rtn, convert_ushort3_rtp, convert_ushort3_rtz, convert_ushort3_sat, convert_ushort3_sat_rte, convert_ushort3_sat_rtn, convert_ushort3_sat_rtp, convert_ushort3_sat_rtz, 
  { 627, 2, 0, 1, 0, 43, 31 },
  { 641, 2, 0, 1, 0, 43, 31 },
  { 659, 2, 0, 1, 0, 43, 31 },
  { 675, 2, 0, 1, 0, 43, 31 },
  { 687, 2, 0, 1, 0, 43, 31 },
  { 699, 2, 0, 1, 0, 43, 31 },
  { 711, 2, 0, 1, 0, 43, 31 },
  { 725, 2, 0, 1, 0, 43, 31 },
  { 743, 2, 0, 1, 0, 43, 31 },
  { 759, 2, 0, 1, 0, 43, 31 },
  { 771, 2, 0, 1, 0, 43, 31 },
  // 409: convert_ushort4, convert_ushort4_rte, convert_ushort4_rtn, convert_ushort4_rtp, convert_ushort4_rtz, convert_ushort4_sat, convert_ushort4_sat_rte, convert_ushort4_sat_rtn, convert_ushort4_sat_rtp, convert_ushort4_sat_rtz, 
  { 629, 2, 0, 1, 0, 43, 31 },
  { 643, 2, 0, 1, 0, 43, 31 },
  { 661, 2, 0, 1, 0, 43, 31 },
  { 677, 2, 0, 1, 0, 43, 31 },
  { 689, 2, 0, 1, 0, 43, 31 },
  { 701, 2, 0, 1, 0, 43, 31 },
  { 713, 2, 0, 1, 0, 43, 31 },
  { 727, 2, 0, 1, 0, 43, 31 },
  { 745, 2, 0, 1, 0, 43, 31 },
  { 761, 2, 0, 1, 0, 43, 31 },
  { 773, 2, 0, 1, 0, 43, 31 },
  // 420: convert_ushort8, convert_ushort8_rte, convert_ushort8_rtn, convert_ushort8_rtp, convert_ushort8_rtz, convert_ushort8_sat, convert_ushort8_sat_rte, convert_ushort8_sat_rtn, convert_ushort8_sat_rtp, convert_ushort8_sat_rtz, 
  { 631, 2, 0, 1, 0, 43, 31 },
  { 645, 2, 0, 1, 0, 43, 31 },
  { 663, 2, 0, 1, 0, 43, 31 },
  { 679, 2, 0, 1, 0, 43, 31 },
  { 691, 2, 0, 1, 0, 43, 31 },
  { 703, 2, 0, 1, 0, 43, 31 },
  { 715, 2, 0, 1, 0, 43, 31 },
  { 729, 2, 0, 1, 0, 43, 31 },
  { 747, 2, 0, 1, 0, 43, 31 },
  { 763, 2, 0, 1, 0, 43, 31 },
  { 775, 2, 0, 1, 0, 43, 31 },
  // 431: convert_ushort16, convert_ushort16_rte, convert_ushort16_rtn, convert_ushort16_rtp, convert_ushort16_rtz, convert_ushort16_sat, convert_ushort16_sat_rte, convert_ushort16_sat_rtn, convert_ushort16_sat_rtp, convert_ushort16_sat_rtz, 
  { 633, 2, 0, 1, 0, 43, 31 },
  { 647, 2, 0, 1, 0, 43, 31 },
  { 665, 2, 0, 1, 0, 43, 31 },
  { 681, 2, 0, 1, 0, 43, 31 },
  { 693, 2, 0, 1, 0, 43, 31 },
  { 705, 2, 0, 1, 0, 43, 31 },
  { 717, 2, 0, 1, 0, 43, 31 },
  { 733, 2, 0, 1, 0, 43, 31 },
  { 751, 2, 0, 1, 0, 43, 31 },
  { 765, 2, 0, 1, 0, 43, 31 },
  { 777, 2, 0, 1, 0, 43, 31 },
  // 442: convert_int, convert_int_rte, convert_int_rtn, convert_int_rtp, convert_int_rtz, convert_int_sat, convert_int_sat_rte, convert_int_sat_rtn, convert_int_sat_rtp, convert_int_sat_rtz, 
  { 779, 2, 0, 1, 0, 43, 31 },
  { 791, 2, 0, 1, 0, 43, 31 },
  { 807, 2, 0, 1, 0, 43, 31 },
  { 825, 2, 0, 1, 0, 43, 31 },
  { 839, 2, 0, 1, 0, 43, 31 },
  { 851, 2, 0, 1, 0, 43, 31 },
  { 863, 2, 0, 1, 0, 43, 31 },
  { 8, 2, 0, 1, 0, 43, 31 },
  { 889, 2, 0, 1, 0, 43, 31 },
  { 907, 2, 0, 1, 0, 43, 31 },
  { 921, 2, 0, 1, 0, 43, 31 },
  // 453: convert_int2, convert_int2_rte, convert_int2_rtn, convert_int2_rtp, convert_int2_rtz, convert_int2_sat, convert_int2_sat_rte, convert_int2_sat_rtn, convert_int2_sat_rtp, convert_int2_sat_rtz, 
  { 781, 2, 0, 1, 0, 43, 31 },
  { 793, 2, 0, 1, 0, 43, 31 },
  { 809, 2, 0, 1, 0, 43, 31 },
  { 827, 2, 0, 1, 0, 43, 31 },
  { 841, 2, 0, 1, 0, 43, 31 },
  { 853, 2, 0, 1, 0, 43, 31 },
  { 865, 2, 0, 1, 0, 43, 31 },
  { 875, 2, 0, 1, 0, 43, 31 },
  { 891, 2, 0, 1, 0, 43, 31 },
  { 909, 2, 0, 1, 0, 43, 31 },
  { 923, 2, 0, 1, 0, 43, 31 },
  // 464: convert_int3, convert_int3_rte, convert_int3_rtn, convert_int3_rtp, convert_int3_rtz, convert_int3_sat, convert_int3_sat_rte, convert_int3_sat_rtn, convert_int3_sat_rtp, convert_int3_sat_rtz, 
  { 783, 2, 0, 1, 0, 43, 31 },
  { 795, 2, 0, 1, 0, 43, 31 },
  { 811, 2, 0, 1, 0, 43, 31 },
  { 829, 2, 0, 1, 0, 43, 31 },
  { 843, 2, 0, 1, 0, 43, 31 },
  { 855, 2, 0, 1, 0, 43, 31 },
  { 867, 2, 0, 1, 0, 43, 31 },
  { 877, 2, 0, 1, 0, 43, 31 },
  { 893, 2, 0, 1, 0, 43, 31 },
  { 911, 2, 0, 1, 0, 43, 31 },
  { 925, 2, 0, 1, 0, 43, 31 },
  // 475: convert_int4, convert_int4_rte, convert_int4_rtn, convert_int4_rtp, convert_int4_rtz, convert_int4_sat, convert_int4_sat_rte, convert_int4_sat_rtn, convert_int4_sat_rtp, convert_int4_sat_rtz, 
  { 785, 2, 0, 1, 0, 43, 31 },
  { 797, 2, 0, 1, 0, 43, 31 },
  { 813, 2, 0, 1, 0, 43, 31 },
  { 831, 2, 0, 1, 0, 43, 31 },
  { 845, 2, 0, 1, 0, 43, 31 },
  { 857, 2, 0, 1, 0, 43, 31 },
  { 869, 2, 0, 1, 0, 43, 31 },
  { 879, 2, 0, 1, 0, 43, 31 },
  { 895, 2, 0, 1, 0, 43, 31 },
  { 913, 2, 0, 1, 0, 43, 31 },
  { 927, 2, 0, 1, 0, 43, 31 },
  // 486: convert_int8, convert_int8_rte, convert_int8_rtn, convert_int8_rtp, convert_int8_rtz, convert_int8_sat, convert_int8_sat_rte, convert_int8_sat_rtn, convert_int8_sat_rtp, convert_int8_sat_rtz, 
  { 787, 2, 0, 1, 0, 43, 31 },
  { 799, 2, 0, 1, 0, 43, 31 },
  { 815, 2, 0, 1, 0, 43, 31 },
  { 833, 2, 0, 1, 0, 43, 31 },
  { 847, 2, 0, 1, 0, 43, 31 },
  { 859, 2, 0, 1, 0, 43, 31 },
  { 871, 2, 0, 1, 0, 43, 31 },
  { 881, 2, 0, 1, 0, 43, 31 },
  { 897, 2, 0, 1, 0, 43, 31 },
  { 915, 2, 0, 1, 0, 43, 31 },
  { 929, 2, 0, 1, 0, 43, 31 },
  // 497: convert_int16, convert_int16_rte, convert_int16_rtn, convert_int16_rtp, convert_int16_rtz, convert_int16_sat, convert_int16_sat_rte, convert_int16_sat_rtn, convert_int16_sat_rtp, convert_int16_sat_rtz, 
  { 789, 2, 0, 1, 0, 43, 31 },
  { 801, 2, 0, 1, 0, 43, 31 },
  { 817, 2, 0, 1, 0, 43, 31 },
  { 835, 2, 0, 1, 0, 43, 31 },
  { 849, 2, 0, 1, 0, 43, 31 },
  { 861, 2, 0, 1, 0, 43, 31 },
  { 873, 2, 0, 1, 0, 43, 31 },
  { 883, 2, 0, 1, 0, 43, 31 },
  { 901, 2, 0, 1, 0, 43, 31 },
  { 919, 2, 0, 1, 0, 43, 31 },
  { 931, 2, 0, 1, 0, 43, 31 },
  // 508: convert_uint, convert_uint_rte, convert_uint_rtn, convert_uint_rtp, convert_uint_rtz, convert_uint_sat, convert_uint_sat_rte, convert_uint_sat_rtn, convert_uint_sat_rtp, convert_uint_sat_rtz, 
  { 933, 2, 0, 1, 0, 43, 31 },
  { 945, 2, 0, 1, 0, 43, 31 },
  { 957, 2, 0, 1, 0, 43, 31 },
  { 979, 2, 0, 1, 0, 43, 31 },
  { 993, 2, 0, 1, 0, 43, 31 },
  { 1005, 2, 0, 1, 0, 43, 31 },
  { 1017, 2, 0, 1, 0, 43, 31 },
  { 1029, 2, 0, 1, 0, 43, 31 },
  { 1051, 2, 0, 1, 0, 43, 31 },
  { 1065, 2, 0, 1, 0, 43, 31 },
  { 1077, 2, 0, 1, 0, 43, 31 },
  // 519: convert_uint2, convert_uint2_rte, convert_uint2_rtn, convert_uint2_rtp, convert_uint2_rtz, convert_uint2_sat, convert_uint2_sat_rte, convert_uint2_sat_rtn, convert_uint2_sat_rtp, convert_uint2_sat_rtz, 
  { 935, 2, 0, 1, 0, 43, 31 },
  { 947, 2, 0, 1, 0, 43, 31 },
  { 959, 2, 0, 1, 0, 43, 31 },
  { 981, 2, 0, 1, 0, 43, 31 },
  { 995, 2, 0, 1, 0, 43, 31 },
  { 1007, 2, 0, 1, 0, 43, 31 },
  { 1019, 2, 0, 1, 0, 43, 31 },
  { 1031, 2, 0, 1, 0, 43, 31 },
  { 1053, 2, 0, 1, 0, 43, 31 },
  { 1067, 2, 0, 1, 0, 43, 31 },
  { 1079, 2, 0, 1, 0, 43, 31 },
  // 530: convert_uint3, convert_uint3_rte, convert_uint3_rtn, convert_uint3_rtp, convert_uint3_rtz, convert_uint3_sat, convert_uint3_sat_rte, convert_uint3_sat_rtn, convert_uint3_sat_rtp, convert_uint3_sat_rtz, 
  { 937, 2, 0, 1, 0, 43, 31 },
  { 949, 2, 0, 1, 0, 43, 31 },
  { 961, 2, 0, 1, 0, 43, 31 },
  { 983, 2, 0, 1, 0, 43, 31 },
  { 997, 2, 0, 1, 0, 43, 31 },
  { 1009, 2, 0, 1, 0, 43, 31 },
  { 1021, 2, 0, 1, 0, 43, 31 },
  { 1033, 2, 0, 1, 0, 43, 31 },
  { 1055, 2, 0, 1, 0, 43, 31 },
  { 1069, 2, 0, 1, 0, 43, 31 },
  { 1081, 2, 0, 1, 0, 43, 31 },
  // 541: convert_uint4, convert_uint4_rte, convert_uint4_rtn, convert_uint4_rtp, convert_uint4_rtz, convert_uint4_sat, convert_uint4_sat_rte, convert_uint4_sat_rtn, convert_uint4_sat_rtp, convert_uint4_sat_rtz, 
  { 939, 2, 0, 1, 0, 43, 31 },
  { 951, 2, 0, 1, 0, 43, 31 },
  { 963, 2, 0, 1, 0, 43, 31 },
  { 985, 2, 0, 1, 0, 43, 31 },
  { 999, 2, 0, 1, 0, 43, 31 },
  { 1011, 2, 0, 1, 0, 43, 31 },
  { 1023, 2, 0, 1, 0, 43, 31 },
  { 1035, 2, 0, 1, 0, 43, 31 },
  { 1057, 2, 0, 1, 0, 43, 31 },
  { 1071, 2, 0, 1, 0, 43, 31 },
  { 1083, 2, 0, 1, 0, 43, 31 },
  // 552: convert_uint8, convert_uint8_rte, convert_uint8_rtn, convert_uint8_rtp, convert_uint8_rtz, convert_uint8_sat, convert_uint8_sat_rte, convert_uint8_sat_rtn, convert_uint8_sat_rtp, convert_uint8_sat_rtz, 
  { 941, 2, 0, 1, 0, 43, 31 },
  { 953, 2, 0, 1, 0, 43, 31 },
  { 965, 2, 0, 1, 0, 43, 31 },
  { 987, 2, 0, 1, 0, 43, 31 },
  { 1001, 2, 0, 1, 0, 43, 31 },
  { 1013, 2, 0, 1, 0, 43, 31 },
  { 1025, 2, 0, 1, 0, 43, 31 },
  { 1037, 2, 0, 1, 0, 43, 31 },
  { 1059, 2, 0, 1, 0, 43, 31 },
  { 1073, 2, 0, 1, 0, 43, 31 },
  { 1085, 2, 0, 1, 0, 43, 31 },
  // 563: convert_uint16, convert_uint16_rte, convert_uint16_rtn, convert_uint16_rtp, convert_uint16_rtz, convert_uint16_sat, convert_uint16_sat_rte, convert_uint16_sat_rtn, convert_uint16_sat_rtp, convert_uint16_sat_rtz, 
  { 943, 2, 0, 1, 0, 43, 31 },
  { 955, 2, 0, 1, 0, 43, 31 },
  { 967, 2, 0, 1, 0, 43, 31 },
  { 991, 2, 0, 1, 0, 43, 31 },
  { 1003, 2, 0, 1, 0, 43, 31 },
  { 1015, 2, 0, 1, 0, 43, 31 },
  { 1027, 2, 0, 1, 0, 43, 31 },
  { 1039, 2, 0, 1, 0, 43, 31 },
  { 1063, 2, 0, 1, 0, 43, 31 },
  { 1075, 2, 0, 1, 0, 43, 31 },
  { 1087, 2, 0, 1, 0, 43, 31 },
  // 574: convert_double, convert_double_rte, convert_double_rtn, convert_double_rtp, convert_double_rtz, 
  { 969, 2, 0, 1, 0, 43, 31 },
  { 1041, 2, 0, 1, 0, 43, 31 },
  { 1113, 2, 0, 1, 0, 43, 31 },
  { 1185, 2, 0, 1, 0, 43, 31 },
  { 1257, 2, 0, 1, 0, 43, 31 },
  { 1329, 2, 0, 1, 0, 43, 31 },
  { 1401, 2, 0, 1, 0, 43, 31 },
  { 1701, 2, 0, 1, 0, 43, 31 },
  { 2264, 2, 0, 1, 0, 43, 31 },
  { 3251, 2, 0, 1, 0, 43, 31 },
  { 3641, 2, 0, 1, 0, 43, 31 },
  // 585: convert_double2, convert_double2_rte, convert_double2_rtn, convert_double2_rtp, convert_double2_rtz, 
  { 971, 2, 0, 1, 0, 43, 31 },
  { 1043, 2, 0, 1, 0, 43, 31 },
  { 1115, 2, 0, 1, 0, 43, 31 },
  { 1187, 2, 0, 1, 0, 43, 31 },
  { 1259, 2, 0, 1, 0, 43, 31 },
  { 1331, 2, 0, 1, 0, 43, 31 },
  { 1403, 2, 0, 1, 0, 43, 31 },
  { 1707, 2, 0, 1, 0, 43, 31 },
  { 2303, 2, 0, 1, 0, 43, 31 },
  { 3284, 2, 0, 1, 0, 43, 31 },
  { 3643, 2, 0, 1, 0, 43, 31 },
  // 596: convert_double3, convert_double3_rte, convert_double3_rtn, convert_double3_rtp, convert_double3_rtz, 
  { 973, 2, 0, 1, 0, 43, 31 },
  { 1045, 2, 0, 1, 0, 43, 31 },
  { 1117, 2, 0, 1, 0, 43, 31 },
  { 1189, 2, 0, 1, 0, 43, 31 },
  { 1261, 2, 0, 1, 0, 43, 31 },
  { 1333, 2, 0, 1, 0, 43, 31 },
  { 1405, 2, 0, 1, 0, 43, 31 },
  { 1709, 2, 0, 1, 0, 43, 31 },
  { 2339, 2, 0, 1, 0, 43, 31 },
  { 3324, 2, 0, 1, 0, 43, 31 },
  { 3645, 2, 0, 1, 0, 43, 31 },
  // 607: convert_double4, convert_double4_rte, convert_double4_rtn, convert_double4_rtp, convert_double4_rtz, 
  { 975, 2, 0, 1, 0, 43, 31 },
  { 1047, 2, 0, 1, 0, 43, 31 },
  { 1119, 2, 0, 1, 0, 43, 31 },
  { 1191, 2, 0, 1, 0, 43, 31 },
  { 1263, 2, 0, 1, 0, 43, 31 },
  { 1335, 2, 0, 1, 0, 43, 31 },
  { 1407, 2, 0, 1, 0, 43, 31 },
  { 1725, 2, 0, 1, 0, 43, 31 },
  { 2376, 2, 0, 1, 0, 43, 31 },
  { 3338, 2, 0, 1, 0, 43, 31 },
  { 3647, 2, 0, 1, 0, 43, 31 },
  // 618: convert_double8, convert_double8_rte, convert_double8_rtn, convert_double8_rtp, convert_double8_rtz, 
  { 977, 2, 0, 1, 0, 43, 31 },
  { 1049, 2, 0, 1, 0, 43, 31 },
  { 1121, 2, 0, 1, 0, 43, 31 },
  { 1193, 2, 0, 1, 0, 43, 31 },
  { 1265, 2, 0, 1, 0, 43, 31 },
  { 1337, 2, 0, 1, 0, 43, 31 },
  { 1409, 2, 0, 1, 0, 43, 31 },
  { 1730, 2, 0, 1, 0, 43, 31 },
  { 2414, 2, 0, 1, 0, 43, 31 },
  { 3355, 2, 0, 1, 0, 43, 31 },
  { 3661, 2, 0, 1, 0, 43, 31 },
  // 629: convert_double16, convert_double16_rte, convert_double16_rtn, convert_double16_rtp, convert_double16_rtz, 
  { 989, 2, 0, 1, 0, 43, 31 },
  { 1061, 2, 0, 1, 0, 43, 31 },
  { 1133, 2, 0, 1, 0, 43, 31 },
  { 1205, 2, 0, 1, 0, 43, 31 },
  { 1277, 2, 0, 1, 0, 43, 31 },
  { 1349, 2, 0, 1, 0, 43, 31 },
  { 1414, 2, 0, 1, 0, 43, 31 },
  { 1732, 2, 0, 1, 0, 43, 31 },
  { 2451, 2, 0, 1, 0, 43, 31 },
  { 3387, 2, 0, 1, 0, 43, 31 },
  { 3685, 2, 0, 1, 0, 43, 31 },
  // 640: convert_long, convert_long_rte, convert_long_rtn, convert_long_rtp, convert_long_rtz, convert_long_sat, convert_long_sat_rte, convert_long_sat_rtn, convert_long_sat_rtp, convert_long_sat_rtz, 
  { 1089, 2, 0, 1, 0, 43, 31 },
  { 1101, 2, 0, 1, 0, 43, 31 },
  { 1123, 2, 0, 1, 0, 43, 31 },
  { 1137, 2, 0, 1, 0, 43, 31 },
  { 1149, 2, 0, 1, 0, 43, 31 },
  { 1161, 2, 0, 1, 0, 43, 31 },
  { 1173, 2, 0, 1, 0, 43, 31 },
  { 1195, 2, 0, 1, 0, 43, 31 },
  { 1209, 2, 0, 1, 0, 43, 31 },
  { 1221, 2, 0, 1, 0, 43, 31 },
  { 1233, 2, 0, 1, 0, 43, 31 },
  // 651: convert_long2, convert_long2_rte, convert_long2_rtn, convert_long2_rtp, convert_long2_rtz, convert_long2_sat, convert_long2_sat_rte, convert_long2_sat_rtn, convert_long2_sat_rtp, convert_long2_sat_rtz, 
  { 1091, 2, 0, 1, 0, 43, 31 },
  { 1103, 2, 0, 1, 0, 43, 31 },
  { 1125, 2, 0, 1, 0, 43, 31 },
  { 1139, 2, 0, 1, 0, 43, 31 },
  { 1151, 2, 0, 1, 0, 43, 31 },
  { 1163, 2, 0, 1, 0, 43, 31 },
  { 1175, 2, 0, 1, 0, 43, 31 },
  { 1197, 2, 0, 1, 0, 43, 31 },
  { 1211, 2, 0, 1, 0, 43, 31 },
  { 1223, 2, 0, 1, 0, 43, 31 },
  { 1235, 2, 0, 1, 0, 43, 31 },
  // 662: convert_long3, convert_long3_rte, convert_long3_rtn, convert_long3_rtp, convert_long3_rtz, convert_long3_sat, convert_long3_sat_rte, convert_long3_sat_rtn, convert_long3_sat_rtp, convert_long3_sat_rtz, 
  { 1093, 2, 0, 1, 0, 43, 31 },
  { 1105, 2, 0, 1, 0, 43, 31 },
  { 1127, 2, 0, 1, 0, 43, 31 },
  { 1141, 2, 0, 1, 0, 43, 31 },
  { 1153, 2, 0, 1, 0, 43, 31 },
  { 1165, 2, 0, 1, 0, 43, 31 },
  { 1177, 2, 0, 1, 0, 43, 31 },
  { 1199, 2, 0, 1, 0, 43, 31 },
  { 1213, 2, 0, 1, 0, 43, 31 },
  { 1225, 2, 0, 1, 0, 43, 31 },
  { 1237, 2, 0, 1, 0, 43, 31 },
  // 673: convert_long4, convert_long4_rte, convert_long4_rtn, convert_long4_rtp, convert_long4_rtz, convert_long4_sat, convert_long4_sat_rte, convert_long4_sat_rtn, convert_long4_sat_rtp, convert_long4_sat_rtz, 
  { 1095, 2, 0, 1, 0, 43, 31 },
  { 1107, 2, 0, 1, 0, 43, 31 },
  { 1129, 2, 0, 1, 0, 43, 31 },
  { 1143, 2, 0, 1, 0, 43, 31 },
  { 1155, 2, 0, 1, 0, 43, 31 },
  { 1167, 2, 0, 1, 0, 43, 31 },
  { 1179, 2, 0, 1, 0, 43, 31 },
  { 1201, 2, 0, 1, 0, 43, 31 },
  { 1215, 2, 0, 1, 0, 43, 31 },
  { 1227, 2, 0, 1, 0, 43, 31 },
  { 1239, 2, 0, 1, 0, 43, 31 },
  // 684: convert_long8, convert_long8_rte, convert_long8_rtn, convert_long8_rtp, convert_long8_rtz, convert_long8_sat, convert_long8_sat_rte, convert_long8_sat_rtn, convert_long8_sat_rtp, convert_long8_sat_rtz, 
  { 1097, 2, 0, 1, 0, 43, 31 },
  { 1109, 2, 0, 1, 0, 43, 31 },
  { 1131, 2, 0, 1, 0, 43, 31 },
  { 1145, 2, 0, 1, 0, 43, 31 },
  { 1157, 2, 0, 1, 0, 43, 31 },
  { 1169, 2, 0, 1, 0, 43, 31 },
  { 1181, 2, 0, 1, 0, 43, 31 },
  { 1203, 2, 0, 1, 0, 43, 31 },
  { 1217, 2, 0, 1, 0, 43, 31 },
  { 1229, 2, 0, 1, 0, 43, 31 },
  { 1241, 2, 0, 1, 0, 43, 31 },
  // 695: convert_long16, convert_long16_rte, convert_long16_rtn, convert_long16_rtp, convert_long16_rtz, convert_long16_sat, convert_long16_sat_rte, convert_long16_sat_rtn, convert_long16_sat_rtp, convert_long16_sat_rtz, 
  { 1099, 2, 0, 1, 0, 43, 31 },
  { 1111, 2, 0, 1, 0, 43, 31 },
  { 1135, 2, 0, 1, 0, 43, 31 },
  { 1147, 2, 0, 1, 0, 43, 31 },
  { 1159, 2, 0, 1, 0, 43, 31 },
  { 1171, 2, 0, 1, 0, 43, 31 },
  { 1183, 2, 0, 1, 0, 43, 31 },
  { 1207, 2, 0, 1, 0, 43, 31 },
  { 1219, 2, 0, 1, 0, 43, 31 },
  { 1231, 2, 0, 1, 0, 43, 31 },
  { 1243, 2, 0, 1, 0, 43, 31 },
  // 706: convert_ulong, convert_ulong_rte, convert_ulong_rtn, convert_ulong_rtp, convert_ulong_rtz, convert_ulong_sat, convert_ulong_sat_rte, convert_ulong_sat_rtn, convert_ulong_sat_rtp, convert_ulong_sat_rtz, 
  { 1245, 2, 0, 1, 0, 43, 31 },
  { 1267, 2, 0, 1, 0, 43, 31 },
  { 1281, 2, 0, 1, 0, 43, 31 },
  { 1293, 2, 0, 1, 0, 43, 31 },
  { 1305, 2, 0, 1, 0, 43, 31 },
  { 1317, 2, 0, 1, 0, 43, 31 },
  { 1339, 2, 0, 1, 0, 43, 31 },
  { 1353, 2, 0, 1, 0, 43, 31 },
  { 1365, 2, 0, 1, 0, 43, 31 },
  { 1377, 2, 0, 1, 0, 43, 31 },
  { 1389, 2, 0, 1, 0, 43, 31 },
  // 717: convert_ulong2, convert_ulong2_rte, convert_ulong2_rtn, convert_ulong2_rtp, convert_ulong2_rtz, convert_ulong2_sat, convert_ulong2_sat_rte, convert_ulong2_sat_rtn, convert_ulong2_sat_rtp, convert_ulong2_sat_rtz, 
  { 1247, 2, 0, 1, 0, 43, 31 },
  { 1269, 2, 0, 1, 0, 43, 31 },
  { 1283, 2, 0, 1, 0, 43, 31 },
  { 1295, 2, 0, 1, 0, 43, 31 },
  { 1307, 2, 0, 1, 0, 43, 31 },
  { 1319, 2, 0, 1, 0, 43, 31 },
  { 1341, 2, 0, 1, 0, 43, 31 },
  { 1355, 2, 0, 1, 0, 43, 31 },
  { 1367, 2, 0, 1, 0, 43, 31 },
  { 1379, 2, 0, 1, 0, 43, 31 },
  { 1391, 2, 0, 1, 0, 43, 31 },
  // 728: convert_ulong3, convert_ulong3_rte, convert_ulong3_rtn, convert_ulong3_rtp, convert_ulong3_rtz, convert_ulong3_sat, convert_ulong3_sat_rte, convert_ulong3_sat_rtn, convert_ulong3_sat_rtp, convert_ulong3_sat_rtz, 
  { 1249, 2, 0, 1, 0, 43, 31 },
  { 1271, 2, 0, 1, 0, 43, 31 },
  { 1285, 2, 0, 1, 0, 43, 31 },
  { 1297, 2, 0, 1, 0, 43, 31 },
  { 1309, 2, 0, 1, 0, 43, 31 },
  { 1321, 2, 0, 1, 0, 43, 31 },
  { 1343, 2, 0, 1, 0, 43, 31 },
  { 1357, 2, 0, 1, 0, 43, 31 },
  { 1369, 2, 0, 1, 0, 43, 31 },
  { 1381, 2, 0, 1, 0, 43, 31 },
  { 1393, 2, 0, 1, 0, 43, 31 },
  // 739: convert_ulong4, convert_ulong4_rte, convert_ulong4_rtn, convert_ulong4_rtp, convert_ulong4_rtz, convert_ulong4_sat, convert_ulong4_sat_rte, convert_ulong4_sat_rtn, convert_ulong4_sat_rtp, convert_ulong4_sat_rtz, 
  { 1251, 2, 0, 1, 0, 43, 31 },
  { 1273, 2, 0, 1, 0, 43, 31 },
  { 1287, 2, 0, 1, 0, 43, 31 },
  { 1299, 2, 0, 1, 0, 43, 31 },
  { 1311, 2, 0, 1, 0, 43, 31 },
  { 1323, 2, 0, 1, 0, 43, 31 },
  { 1345, 2, 0, 1, 0, 43, 31 },
  { 1359, 2, 0, 1, 0, 43, 31 },
  { 1371, 2, 0, 1, 0, 43, 31 },
  { 1383, 2, 0, 1, 0, 43, 31 },
  { 1395, 2, 0, 1, 0, 43, 31 },
  // 750: convert_ulong8, convert_ulong8_rte, convert_ulong8_rtn, convert_ulong8_rtp, convert_ulong8_rtz, convert_ulong8_sat, convert_ulong8_sat_rte, convert_ulong8_sat_rtn, convert_ulong8_sat_rtp, convert_ulong8_sat_rtz, 
  { 1253, 2, 0, 1, 0, 43, 31 },
  { 1275, 2, 0, 1, 0, 43, 31 },
  { 1289, 2, 0, 1, 0, 43, 31 },
  { 1301, 2, 0, 1, 0, 43, 31 },
  { 1313, 2, 0, 1, 0, 43, 31 },
  { 1325, 2, 0, 1, 0, 43, 31 },
  { 1347, 2, 0, 1, 0, 43, 31 },
  { 1361, 2, 0, 1, 0, 43, 31 },
  { 1373, 2, 0, 1, 0, 43, 31 },
  { 1385, 2, 0, 1, 0, 43, 31 },
  { 1397, 2, 0, 1, 0, 43, 31 },
  // 761: convert_ulong16, convert_ulong16_rte, convert_ulong16_rtn, convert_ulong16_rtp, convert_ulong16_rtz, convert_ulong16_sat, convert_ulong16_sat_rte, convert_ulong16_sat_rtn, convert_ulong16_sat_rtp, convert_ulong16_sat_rtz, 
  { 1255, 2, 0, 1, 0, 43, 31 },
  { 1279, 2, 0, 1, 0, 43, 31 },
  { 1291, 2, 0, 1, 0, 43, 31 },
  { 1303, 2, 0, 1, 0, 43, 31 },
  { 1315, 2, 0, 1, 0, 43, 31 },
  { 1327, 2, 0, 1, 0, 43, 31 },
  { 1351, 2, 0, 1, 0, 43, 31 },
  { 1363, 2, 0, 1, 0, 43, 31 },
  { 1375, 2, 0, 1, 0, 43, 31 },
  { 1387, 2, 0, 1, 0, 43, 31 },
  { 1399, 2, 0, 1, 0, 43, 31 },
  // 772: get_work_dim, 
  { 1411, 1, 0, 1, 0, 43, 31 },
  // 773: get_global_size, get_global_id, get_local_size, get_local_id, get_num_groups, get_group_id, get_global_offset, 
  { 1412, 2, 0, 1, 0, 43, 31 },
  // 774: get_enqueued_local_size, 
  { 1412, 2, 0, 0, 0, 43, 24 },
  // 775: get_global_linear_id, get_local_linear_id, 
  { 1416, 1, 0, 0, 0, 43, 24 },
  // 776: acos, acosh, acospi, asin, asinh, asinpi, atan, atanh, atanpi, cbrt, ceil, cos, cosh, cospi, erfc, erf, exp, exp2, exp10, expm1, fabs, floor, log, log2, log10, log1p, logb, rint, round, rsqrt, sin, sinh, sinpi, sqrt, tan, tanh, tanpi, tgamma, trunc, lgamma, degrees, radians, sign, 
  { 1417, 2, 0, 1, 0, 43, 31 },
  // 777: nan, 
  { 1419, 2, 0, 1, 0, 43, 31 },
  { 1421, 2, 0, 1, 0, 43, 31 },
  { 1423, 2, 0, 1, 0, 43, 31 },
  // 780: atan2, atan2pi, copysign, fdim, fmod, hypot, maxmag, minmag, nextafter, pow, powr, remainder, 
  { 1425, 3, 0, 1, 0, 43, 31 },
  // 781: fmax, fmin, 
  { 1425, 3, 0, 1, 0, 43, 31 },
  { 1428, 3, 0, 1, 0, 43, 31 },
  { 1431, 3, 0, 1, 0, 43, 31 },
  { 1434, 3, 0, 1, 0, 43, 31 },
  // 785: ilogb, 
  { 1437, 2, 0, 1, 0, 43, 31 },
  { 1439, 2, 0, 1, 0, 43, 31 },
  { 1441, 2, 0, 1, 0, 43, 31 },
  // 788: ldexp, 
  { 1443, 3, 0, 1, 0, 43, 31 },
  { 1446, 3, 0, 1, 0, 43, 31 },
  { 1449, 3, 0, 1, 0, 43, 31 },
  { 1452, 3, 0, 1, 0, 43, 31 },
  { 1455, 3, 0, 1, 0, 43, 31 },
  { 1458, 3, 0, 1, 0, 43, 31 },
  // 794: pown, rootn, 
  { 1443, 3, 0, 1, 0, 43, 31 },
  { 1449, 3, 0, 1, 0, 43, 31 },
  { 1455, 3, 0, 1, 0, 43, 31 },
  // 797: fma, mad, 
  { 1461, 4, 0, 1, 0, 43, 31 },
  // 798: fract, modf, sincos, 
  { 1465, 3, 0, 0, 0, 46, 31 },
  { 1489, 3, 0, 0, 0, 46, 31 },
  { 1513, 3, 0, 0, 0, 46, 31 },
  { 1537, 3, 0, 0, 0, 45, 31 },
  // 802: frexp, lgamma_r, 
  { 1468, 3, 0, 0, 0, 46, 31 },
  { 1475, 3, 0, 0, 0, 46, 31 },
  { 1478, 3, 0, 0, 0, 46, 31 },
  { 1492, 3, 0, 0, 0, 46, 31 },
  { 1495, 3, 0, 0, 0, 46, 31 },
  { 1498, 3, 0, 0, 0, 46, 31 },
  { 1516, 3, 0, 0, 0, 46, 31 },
  { 1519, 3, 0, 0, 0, 46, 31 },
  { 1522, 3, 0, 0, 0, 46, 31 },
  { 1540, 3, 0, 0, 0, 45, 31 },
  { 1543, 3, 0, 0, 0, 45, 31 },
  { 1546, 3, 0, 0, 0, 45, 31 },
  // 814: remquo, 
  { 1471, 4, 0, 0, 0, 46, 31 },
  { 1481, 4, 0, 0, 0, 46, 31 },
  { 1485, 4, 0, 0, 0, 46, 31 },
  { 1501, 4, 0, 0, 0, 46, 31 },
  { 1505, 4, 0, 0, 0, 46, 31 },
  { 1509, 4, 0, 0, 0, 46, 31 },
  { 1525, 4, 0, 0, 0, 46, 31 },
  { 1529, 4, 0, 0, 0, 46, 31 },
  { 1533, 4, 0, 0, 0, 46, 31 },
  { 1549, 4, 0, 0, 0, 45, 31 },
  { 1553, 4, 0, 0, 0, 45, 31 },
  { 1557, 4, 0, 0, 0, 45, 31 },
  // 826: half_cos, half_exp, half_exp2, half_exp10, half_log, half_log2, half_log10, half_recip, half_rsqrt, half_sin, half_sqrt, half_tan, native_cos, native_exp, native_exp2, native_exp10, native_log, native_log2, native_log10, native_recip, native_rsqrt, native_sin, native_sqrt, native_tan, 
  { 1561, 2, 0, 1, 0, 43, 31 },
  // 827: half_divide, half_powr, native_divide, native_powr, 
  { 1563, 3, 0, 1, 0, 43, 31 },
  // 828: abs, 
  { 1566, 2, 0, 1, 0, 43, 31 },
  // 829: clz, 
  { 48, 2, 0, 1, 0, 43, 31 },
  // 830: popcount, 
  { 48, 2, 0, 1, 0, 43, 28 },
  // 831: ctz, 
  { 48, 2, 0, 1, 0, 43, 24 },
  // 832: abs_diff, 
  { 1568, 3, 0, 1, 0, 43, 31 },
  // 833: add_sat, hadd, rhadd, mul_hi, rotate, sub_sat, 
  { 1571, 3, 0, 1, 0, 43, 31 },
  // 834: max, min, 
  { 1571, 3, 0, 1, 0, 43, 31 },
  { 1574, 3, 0, 1, 0, 43, 31 },
  { 1425, 3, 0, 1, 0, 43, 31 },
  { 1428, 3, 0, 1, 0, 43, 31 },
  { 1431, 3, 0, 1, 0, 43, 31 },
  { 1434, 3, 0, 1, 0, 43, 31 },
  // 840: upsample, 
  { 1577, 3, 0, 1, 0, 43, 31 },
  { 1580, 3, 0, 1, 0, 43, 31 },
  { 1583, 3, 0, 1, 0, 43, 31 },
  { 1586, 3, 0, 1, 0, 43, 31 },
  { 1589, 3, 0, 1, 0, 43, 31 },
  { 1592, 3, 0, 1, 0, 43, 31 },
  // 846: clamp, 
  { 1595, 4, 0, 1, 0, 43, 31 },
  { 1599, 4, 0, 1, 0, 43, 31 },
  { 1461, 4, 0, 1, 0, 43, 31 },
  { 1626, 4, 0, 1, 0, 43, 31 },
  { 1630, 4, 0, 1, 0, 43, 31 },
  { 1634, 4, 0, 1, 0, 43, 31 },
  // 852: mad_hi, mad_sat, 
  { 1595, 4, 0, 1, 0, 43, 31 },
  // 853: mad24, 
  { 1603, 4, 0, 1, 0, 43, 31 },
  { 1607, 4, 0, 1, 0, 43, 31 },
  // 855: mul24, 
  { 1611, 3, 0, 1, 0, 43, 31 },
  { 1614, 3, 0, 1, 0, 43, 31 },
  // 857: step, 
  { 1425, 3, 0, 1, 0, 43, 31 },
  { 1617, 3, 0, 1, 0, 43, 31 },
  { 1620, 3, 0, 1, 0, 43, 31 },
  { 1623, 3, 0, 1, 0, 43, 31 },
  // 861: mix, 
  { 1461, 4, 0, 1, 0, 43, 31 },
  { 1638, 4, 0, 1, 0, 43, 31 },
  { 1642, 4, 0, 1, 0, 43, 31 },
  { 1646, 4, 0, 1, 0, 43, 31 },
  // 865: smoothstep, 
  { 1461, 4, 0, 1, 0, 43, 31 },
  { 1650, 4, 0, 1, 0, 43, 31 },
  { 1654, 4, 0, 1, 0, 43, 31 },
  { 1658, 4, 0, 1, 0, 43, 31 },
  // 869: length, 
  { 1662, 2, 0, 1, 0, 43, 31 },
  { 1664, 2, 0, 1, 0, 43, 31 },
  { 1666, 2, 0, 1, 0, 43, 31 },
  // 872: normalize, 
  { 1668, 2, 0, 1, 0, 43, 31 },
  { 1670, 2, 0, 1, 0, 43, 31 },
  { 1672, 2, 0, 1, 0, 43, 31 },
  // 875: fast_length, 
  { 1662, 2, 0, 1, 0, 43, 31 },
  // 876: fast_normalize, 
  { 1668, 2, 0, 1, 0, 43, 31 },
  // 877: cross, 
  { 1674, 3, 0, 1, 0, 43, 31 },
  { 1677, 3, 0, 1, 0, 43, 31 },
  { 1680, 3, 0, 1, 0, 43, 31 },
  { 1683, 3, 0, 1, 0, 43, 31 },
  { 1686, 3, 0, 1, 0, 43, 31 },
  { 1689, 3, 0, 1, 0, 43, 31 },
  // 883: distance, 
  { 1692, 3, 0, 1, 0, 43, 31 },
  { 1695, 3, 0, 1, 0, 43, 31 },
  { 1698, 3, 0, 1, 0, 43, 31 },
  // 886: fast_distance, 
  { 1692, 3, 0, 1, 0, 43, 31 },
  // 887: isfinite, isinf, isnan, isnormal, signbit, 
  { 1437, 2, 0, 1, 0, 43, 31 },
  { 791, 2, 0, 1, 0, 43, 31 },
  { 1703, 2, 0, 1, 0, 43, 31 },
  { 807, 2, 0, 1, 0, 43, 31 },
  { 1705, 2, 0, 1, 0, 43, 31 },
  // 892: any, all, 
  { 1711, 2, 0, 1, 0, 43, 31 },
  // 893: isequal, isnotequal, isgreater, isgreaterequal, isless, islessequal, islessgreater, isordered, isunordered, 
  { 1713, 3, 0, 1, 0, 43, 31 },
  { 1716, 3, 0, 1, 0, 43, 31 },
  { 1719, 3, 0, 1, 0, 43, 31 },
  { 1722, 3, 0, 1, 0, 43, 31 },
  { 1727, 3, 0, 1, 0, 43, 31 },
  // 898: bitselect, 
  { 1734, 4, 0, 1, 0, 43, 31 },
  // 899: select, 
  { 1738, 4, 0, 1, 0, 43, 31 },
  { 1742, 4, 0, 1, 0, 43, 31 },
  { 1746, 4, 0, 1, 0, 43, 31 },
  { 1750, 4, 0, 1, 0, 43, 31 },
  { 1754, 4, 0, 1, 0, 43, 31 },
  { 1758, 4, 0, 1, 0, 43, 31 },
  { 1762, 4, 0, 1, 0, 43, 31 },
  { 1766, 4, 0, 1, 0, 43, 31 },
  { 1770, 4, 0, 1, 0, 43, 31 },
  { 1774, 4, 0, 1, 0, 43, 31 },
  // 909: vload2, 
  { 1778, 3, 1, 0, 0, 46, 31 },
  { 1781, 3, 1, 0, 0, 46, 31 },
  { 1784, 3, 1, 0, 0, 46, 31 },
  { 1787, 3, 1, 0, 0, 46, 31 },
  { 1790, 3, 1, 0, 0, 46, 31 },
  { 1793, 3, 1, 0, 0, 46, 31 },
  { 1796, 3, 1, 0, 0, 46, 31 },
  { 1799, 3, 1, 0, 0, 46, 31 },
  { 1802, 3, 1, 0, 0, 46, 31 },
  { 1805, 3, 1, 0, 0, 46, 31 },
  { 1808, 3, 1, 0, 0, 46, 31 },
  { 2163, 3, 1, 0, 0, 46, 31 },
  { 2166, 3, 1, 0, 0, 46, 31 },
  { 2169, 3, 1, 0, 0, 46, 31 },
  { 2172, 3, 1, 0, 0, 46, 31 },
  { 2175, 3, 1, 0, 0, 46, 31 },
  { 2178, 3, 1, 0, 0, 46, 31 },
  { 2181, 3, 1, 0, 0, 46, 31 },
  { 2184, 3, 1, 0, 0, 46, 31 },
  { 2187, 3, 1, 0, 0, 46, 31 },
  { 2190, 3, 1, 0, 0, 46, 31 },
  { 2193, 3, 1, 0, 0, 46, 31 },
  { 2562, 3, 1, 0, 0, 46, 31 },
  { 2565, 3, 1, 0, 0, 46, 31 },
  { 2568, 3, 1, 0, 0, 46, 31 },
  { 2571, 3, 1, 0, 0, 46, 31 },
  { 2574, 3, 1, 0, 0, 46, 31 },
  { 2577, 3, 1, 0, 0, 46, 31 },
  { 2580, 3, 1, 0, 0, 46, 31 },
  { 2583, 3, 1, 0, 0, 46, 31 },
  { 2586, 3, 1, 0, 0, 46, 31 },
  { 2589, 3, 1, 0, 0, 46, 31 },
  { 2592, 3, 1, 0, 0, 46, 31 },
  { 2947, 3, 1, 0, 0, 45, 31 },
  { 2950, 3, 1, 0, 0, 45, 31 },
  { 2953, 3, 1, 0, 0, 45, 31 },
  { 2956, 3, 1, 0, 0, 45, 31 },
  { 2959, 3, 1, 0, 0, 45, 31 },
  { 2962, 3, 1, 0, 0, 45, 31 },
  { 2965, 3, 1, 0, 0, 45, 31 },
  { 2968, 3, 1, 0, 0, 45, 31 },
  { 2971, 3, 1, 0, 0, 45, 31 },
  { 2974, 3, 1, 0, 0, 45, 31 },
  { 2977, 3, 1, 0, 0, 45, 31 },
  { 3340, 3, 1, 0, 0, 43, 31 },
  { 3343, 3, 1, 0, 0, 43, 31 },
  { 3346, 3, 1, 0, 0, 43, 31 },
  { 3349, 3, 1, 0, 0, 43, 31 },
  { 3352, 3, 1, 0, 0, 43, 31 },
  { 3357, 3, 1, 0, 0, 43, 31 },
  { 3360, 3, 1, 0, 0, 43, 31 },
  { 3363, 3, 1, 0, 0, 43, 31 },
  { 3366, 3, 1, 0, 0, 43, 31 },
  { 3369, 3, 1, 0, 0, 43, 31 },
  { 3372, 3, 1, 0, 0, 43, 31 },
  // 964: vstore2, 
  { 1811, 4, 0, 0, 0, 46, 31 },
  { 1815, 4, 0, 0, 0, 46, 31 },
  { 1819, 4, 0, 0, 0, 46, 31 },
  { 1823, 4, 0, 0, 0, 46, 31 },
  { 1827, 4, 0, 0, 0, 46, 31 },
  { 1831, 4, 0, 0, 0, 46, 31 },
  { 1835, 4, 0, 0, 0, 46, 31 },
  { 1839, 4, 0, 0, 0, 46, 31 },
  { 1843, 4, 0, 0, 0, 46, 31 },
  { 1847, 4, 0, 0, 0, 46, 31 },
  { 1851, 4, 0, 0, 0, 46, 31 },
  { 2196, 4, 0, 0, 0, 46, 31 },
  { 2200, 4, 0, 0, 0, 46, 31 },
  { 2204, 4, 0, 0, 0, 46, 31 },
  { 2208, 4, 0, 0, 0, 46, 31 },
  { 2212, 4, 0, 0, 0, 46, 31 },
  { 2216, 4, 0, 0, 0, 46, 31 },
  { 2220, 4, 0, 0, 0, 46, 31 },
  { 2224, 4, 0, 0, 0, 46, 31 },
  { 2228, 4, 0, 0, 0, 46, 31 },
  { 2232, 4, 0, 0, 0, 46, 31 },
  { 2236, 4, 0, 0, 0, 46, 31 },
  { 2595, 4, 0, 0, 0, 46, 31 },
  { 2599, 4, 0, 0, 0, 46, 31 },
  { 2603, 4, 0, 0, 0, 46, 31 },
  { 2607, 4, 0, 0, 0, 46, 31 },
  { 2611, 4, 0, 0, 0, 46, 31 },
  { 2615, 4, 0, 0, 0, 46, 31 },
  { 2619, 4, 0, 0, 0, 46, 31 },
  { 2623, 4, 0, 0, 0, 46, 31 },
  { 2627, 4, 0, 0, 0, 46, 31 },
  { 2631, 4, 0, 0, 0, 46, 31 },
  { 2635, 4, 0, 0, 0, 46, 31 },
  { 2980, 4, 0, 0, 0, 45, 31 },
  { 2984, 4, 0, 0, 0, 45, 31 },
  { 2988, 4, 0, 0, 0, 45, 31 },
  { 2992, 4, 0, 0, 0, 45, 31 },
  { 2996, 4, 0, 0, 0, 45, 31 },
  { 3000, 4, 0, 0, 0, 45, 31 },
  { 3004, 4, 0, 0, 0, 45, 31 },
  { 3008, 4, 0, 0, 0, 45, 31 },
  { 3012, 4, 0, 0, 0, 45, 31 },
  { 3016, 4, 0, 0, 0, 45, 31 },
  { 3020, 4, 0, 0, 0, 45, 31 },
  // 1008: vload3, 
  { 1855, 3, 1, 0, 0, 46, 31 },
  { 1858, 3, 1, 0, 0, 46, 31 },
  { 1861, 3, 1, 0, 0, 46, 31 },
  { 1864, 3, 1, 0, 0, 46, 31 },
  { 1867, 3, 1, 0, 0, 46, 31 },
  { 1870, 3, 1, 0, 0, 46, 31 },
  { 1873, 3, 1, 0, 0, 46, 31 },
  { 1876, 3, 1, 0, 0, 46, 31 },
  { 1879, 3, 1, 0, 0, 46, 31 },
  { 1882, 3, 1, 0, 0, 46, 31 },
  { 1885, 3, 1, 0, 0, 46, 31 },
  { 2240, 3, 1, 0, 0, 46, 31 },
  { 2243, 3, 1, 0, 0, 46, 31 },
  { 2246, 3, 1, 0, 0, 46, 31 },
  { 2249, 3, 1, 0, 0, 46, 31 },
  { 2252, 3, 1, 0, 0, 46, 31 },
  { 2255, 3, 1, 0, 0, 46, 31 },
  { 2258, 3, 1, 0, 0, 46, 31 },
  { 2261, 3, 1, 0, 0, 46, 31 },
  { 2266, 3, 1, 0, 0, 46, 31 },
  { 2269, 3, 1, 0, 0, 46, 31 },
  { 2272, 3, 1, 0, 0, 46, 31 },
  { 2639, 3, 1, 0, 0, 46, 31 },
  { 2642, 3, 1, 0, 0, 46, 31 },
  { 2645, 3, 1, 0, 0, 46, 31 },
  { 2648, 3, 1, 0, 0, 46, 31 },
  { 2651, 3, 1, 0, 0, 46, 31 },
  { 2654, 3, 1, 0, 0, 46, 31 },
  { 2657, 3, 1, 0, 0, 46, 31 },
  { 2660, 3, 1, 0, 0, 46, 31 },
  { 2663, 3, 1, 0, 0, 46, 31 },
  { 2666, 3, 1, 0, 0, 46, 31 },
  { 2669, 3, 1, 0, 0, 46, 31 },
  { 3024, 3, 1, 0, 0, 45, 31 },
  { 3027, 3, 1, 0, 0, 45, 31 },
  { 3030, 3, 1, 0, 0, 45, 31 },
  { 3033, 3, 1, 0, 0, 45, 31 },
  { 3036, 3, 1, 0, 0, 45, 31 },
  { 3039, 3, 1, 0, 0, 45, 31 },
  { 3042, 3, 1, 0, 0, 45, 31 },
  { 3045, 3, 1, 0, 0, 45, 31 },
  { 3048, 3, 1, 0, 0, 45, 31 },
  { 3051, 3, 1, 0, 0, 45, 31 },
  { 3054, 3, 1, 0, 0, 45, 31 },
  { 3375, 3, 1, 0, 0, 43, 31 },
  { 3378, 3, 1, 0, 0, 43, 31 },
  { 3381, 3, 1, 0, 0, 43, 31 },
  { 3384, 3, 1, 0, 0, 43, 31 },
  { 3389, 3, 1, 0, 0, 43, 31 },
  { 3392, 3, 1, 0, 0, 43, 31 },
  { 3395, 3, 1, 0, 0, 43, 31 },
  { 3398, 3, 1, 0, 0, 43, 31 },
  { 3401, 3, 1, 0, 0, 43, 31 },
  { 3404, 3, 1, 0, 0, 43, 31 },
  { 3407, 3, 1, 0, 0, 43, 31 },
  // 1063: vstore3, 
  { 1888, 4, 0, 0, 0, 46, 31 },
  { 1892, 4, 0, 0, 0, 46, 31 },
  { 1896, 4, 0, 0, 0, 46, 31 },
  { 1900, 4, 0, 0, 0, 46, 31 },
  { 1904, 4, 0, 0, 0, 46, 31 },
  { 1908, 4, 0, 0, 0, 46, 31 },
  { 1912, 4, 0, 0, 0, 46, 31 },
  { 1916, 4, 0, 0, 0, 46, 31 },
  { 1920, 4, 0, 0, 0, 46, 31 },
  { 1924, 4, 0, 0, 0, 46, 31 },
  { 1928, 4, 0, 0, 0, 46, 31 },
  { 2275, 4, 0, 0, 0, 46, 31 },
  { 2279, 4, 0, 0, 0, 46, 31 },
  { 2283, 4, 0, 0, 0, 46, 31 },
  { 2287, 4, 0, 0, 0, 46, 31 },
  { 2291, 4, 0, 0, 0, 46, 31 },
  { 2295, 4, 0, 0, 0, 46, 31 },
  { 2299, 4, 0, 0, 0, 46, 31 },
  { 2305, 4, 0, 0, 0, 46, 31 },
  { 2309, 4, 0, 0, 0, 46, 31 },
  { 2313, 4, 0, 0, 0, 46, 31 },
  { 2317, 4, 0, 0, 0, 46, 31 },
  { 2672, 4, 0, 0, 0, 46, 31 },
  { 2676, 4, 0, 0, 0, 46, 31 },
  { 2680, 4, 0, 0, 0, 46, 31 },
  { 2684, 4, 0, 0, 0, 46, 31 },
  { 2688, 4, 0, 0, 0, 46, 31 },
  { 2692, 4, 0, 0, 0, 46, 31 },
  { 2696, 4, 0, 0, 0, 46, 31 },
  { 2700, 4, 0, 0, 0, 46, 31 },
  { 2704, 4, 0, 0, 0, 46, 31 },
  { 2708, 4, 0, 0, 0, 46, 31 },
  { 2712, 4, 0, 0, 0, 46, 31 },
  { 3057, 4, 0, 0, 0, 45, 31 },
  { 3061, 4, 0, 0, 0, 45, 31 },
  { 3065, 4, 0, 0, 0, 45, 31 },
  { 3069, 4, 0, 0, 0, 45, 31 },
  { 3073, 4, 0, 0, 0, 45, 31 },
  { 3077, 4, 0, 0, 0, 45, 31 },
  { 3081, 4, 0, 0, 0, 45, 31 },
  { 3085, 4, 0, 0, 0, 45, 31 },
  { 3089, 4, 0, 0, 0, 45, 31 },
  { 3093, 4, 0, 0, 0, 45, 31 },
  { 3097, 4, 0, 0, 0, 45, 31 },
  // 1107: vload4, 
  { 1932, 3, 1, 0, 0, 46, 31 },
  { 1935, 3, 1, 0, 0, 46, 31 },
  { 1938, 3, 1, 0, 0, 46, 31 },
  { 1941, 3, 1, 0, 0, 46, 31 },
  { 1944, 3, 1, 0, 0, 46, 31 },
  { 1947, 3, 1, 0, 0, 46, 31 },
  { 1950, 3, 1, 0, 0, 46, 31 },
  { 1953, 3, 1, 0, 0, 46, 31 },
  { 1956, 3, 1, 0, 0, 46, 31 },
  { 1959, 3, 1, 0, 0, 46, 31 },
  { 1962, 3, 1, 0, 0, 46, 31 },
  { 2321, 3, 1, 0, 0, 46, 31 },
  { 2324, 3, 1, 0, 0, 46, 31 },
  { 2327, 3, 1, 0, 0, 46, 31 },
  { 2330, 3, 1, 0, 0, 46, 31 },
  { 2333, 3, 1, 0, 0, 46, 31 },
  { 2336, 3, 1, 0, 0, 46, 31 },
  { 2341, 3, 1, 0, 0, 46, 31 },
  { 2344, 3, 1, 0, 0, 46, 31 },
  { 2347, 3, 1, 0, 0, 46, 31 },
  { 2350, 3, 1, 0, 0, 46, 31 },
  { 2353, 3, 1, 0, 0, 46, 31 },
  { 2716, 3, 1, 0, 0, 46, 31 },
  { 2719, 3, 1, 0, 0, 46, 31 },
  { 2722, 3, 1, 0, 0, 46, 31 },
  { 2725, 3, 1, 0, 0, 46, 31 },
  { 2728, 3, 1, 0, 0, 46, 31 },
  { 2731, 3, 1, 0, 0, 46, 31 },
  { 2734, 3, 1, 0, 0, 46, 31 },
  { 2737, 3, 1, 0, 0, 46, 31 },
  { 2740, 3, 1, 0, 0, 46, 31 },
  { 2743, 3, 1, 0, 0, 46, 31 },
  { 2746, 3, 1, 0, 0, 46, 31 },
  { 3101, 3, 1, 0, 0, 45, 31 },
  { 3104, 3, 1, 0, 0, 45, 31 },
  { 3107, 3, 1, 0, 0, 45, 31 },
  { 3110, 3, 1, 0, 0, 45, 31 },
  { 3113, 3, 1, 0, 0, 45, 31 },
  { 3116, 3, 1, 0, 0, 45, 31 },
  { 3119, 3, 1, 0, 0, 45, 31 },
  { 3122, 3, 1, 0, 0, 45, 31 },
  { 3125, 3, 1, 0, 0, 45, 31 },
  { 3128, 3, 1, 0, 0, 45, 31 },
  { 3131, 3, 1, 0, 0, 45, 31 },
  { 3410, 3, 1, 0, 0, 43, 31 },
  { 3413, 3, 1, 0, 0, 43, 31 },
  { 3416, 3, 1, 0, 0, 43, 31 },
  { 3419, 3, 1, 0, 0, 43, 31 },
  { 3422, 3, 1, 0, 0, 43, 31 },
  { 3425, 3, 1, 0, 0, 43, 31 },
  { 3428, 3, 1, 0, 0, 43, 31 },
  { 3431, 3, 1, 0, 0, 43, 31 },
  { 3434, 3, 1, 0, 0, 43, 31 },
  { 3437, 3, 1, 0, 0, 43, 31 },
  { 3440, 3, 1, 0, 0, 43, 31 },
  // 1162: vstore4, 
  { 1965, 4, 0, 0, 0, 46, 31 },
  { 1969, 4, 0, 0, 0, 46, 31 },
  { 1973, 4, 0, 0, 0, 46, 31 },
  { 1977, 4, 0, 0, 0, 46, 31 },
  { 1981, 4, 0, 0, 0, 46, 31 },
  { 1985, 4, 0, 0, 0, 46, 31 },
  { 1989, 4, 0, 0, 0, 46, 31 },
  { 1993, 4, 0, 0, 0, 46, 31 },
  { 1997, 4, 0, 0, 0, 46, 31 },
  { 2001, 4, 0, 0, 0, 46, 31 },
  { 2005, 4, 0, 0, 0, 46, 31 },
  { 2356, 4, 0, 0, 0, 46, 31 },
  { 2360, 4, 0, 0, 0, 46, 31 },
  { 2364, 4, 0, 0, 0, 46, 31 },
  { 2368, 4, 0, 0, 0, 46, 31 },
  { 2372, 4, 0, 0, 0, 46, 31 },
  { 2378, 4, 0, 0, 0, 46, 31 },
  { 2382, 4, 0, 0, 0, 46, 31 },
  { 2386, 4, 0, 0, 0, 46, 31 },
  { 2390, 4, 0, 0, 0, 46, 31 },
  { 2394, 4, 0, 0, 0, 46, 31 },
  { 2398, 4, 0, 0, 0, 46, 31 },
  { 2749, 4, 0, 0, 0, 46, 31 },
  { 2753, 4, 0, 0, 0, 46, 31 },
  { 2757, 4, 0, 0, 0, 46, 31 },
  { 2761, 4, 0, 0, 0, 46, 31 },
  { 2765, 4, 0, 0, 0, 46, 31 },
  { 2769, 4, 0, 0, 0, 46, 31 },
  { 2773, 4, 0, 0, 0, 46, 31 },
  { 2777, 4, 0, 0, 0, 46, 31 },
  { 2781, 4, 0, 0, 0, 46, 31 },
  { 2785, 4, 0, 0, 0, 46, 31 },
  { 2789, 4, 0, 0, 0, 46, 31 },
  { 3134, 4, 0, 0, 0, 45, 31 },
  { 3138, 4, 0, 0, 0, 45, 31 },
  { 3142, 4, 0, 0, 0, 45, 31 },
  { 3146, 4, 0, 0, 0, 45, 31 },
  { 3150, 4, 0, 0, 0, 45, 31 },
  { 3154, 4, 0, 0, 0, 45, 31 },
  { 3158, 4, 0, 0, 0, 45, 31 },
  { 3162, 4, 0, 0, 0, 45, 31 },
  { 3166, 4, 0, 0, 0, 45, 31 },
  { 3170, 4, 0, 0, 0, 45, 31 },
  { 3174, 4, 0, 0, 0, 45, 31 },
  // 1206: vload8, 
  { 2009, 3, 1, 0, 0, 46, 31 },
  { 2012, 3, 1, 0, 0, 46, 31 },
  { 2015, 3, 1, 0, 0, 46, 31 },
  { 2018, 3, 1, 0, 0, 46, 31 },
  { 2021, 3, 1, 0, 0, 46, 31 },
  { 2024, 3, 1, 0, 0, 46, 31 },
  { 2027, 3, 1, 0, 0, 46, 31 },
  { 2030, 3, 1, 0, 0, 46, 31 },
  { 2033, 3, 1, 0, 0, 46, 31 },
  { 2036, 3, 1, 0, 0, 46, 31 },
  { 2039, 3, 1, 0, 0, 46, 31 },
  { 2402, 3, 1, 0, 0, 46, 31 },
  { 2405, 3, 1, 0, 0, 46, 31 },
  { 2408, 3, 1, 0, 0, 46, 31 },
  { 2411, 3, 1, 0, 0, 46, 31 },
  { 2416, 3, 1, 0, 0, 46, 31 },
  { 2419, 3, 1, 0, 0, 46, 31 },
  { 2422, 3, 1, 0, 0, 46, 31 },
  { 2425, 3, 1, 0, 0, 46, 31 },
  { 2428, 3, 1, 0, 0, 46, 31 },
  { 2431, 3, 1, 0, 0, 46, 31 },
  { 2434, 3, 1, 0, 0, 46, 31 },
  { 2793, 3, 1, 0, 0, 46, 31 },
  { 2796, 3, 1, 0, 0, 46, 31 },
  { 2799, 3, 1, 0, 0, 46, 31 },
  { 2802, 3, 1, 0, 0, 46, 31 },
  { 2805, 3, 1, 0, 0, 46, 31 },
  { 2808, 3, 1, 0, 0, 46, 31 },
  { 2811, 3, 1, 0, 0, 46, 31 },
  { 2814, 3, 1, 0, 0, 46, 31 },
  { 2817, 3, 1, 0, 0, 46, 31 },
  { 2820, 3, 1, 0, 0, 46, 31 },
  { 2823, 3, 1, 0, 0, 46, 31 },
  { 3178, 3, 1, 0, 0, 45, 31 },
  { 3181, 3, 1, 0, 0, 45, 31 },
  { 3184, 3, 1, 0, 0, 45, 31 },
  { 3187, 3, 1, 0, 0, 45, 31 },
  { 3190, 3, 1, 0, 0, 45, 31 },
  { 3193, 3, 1, 0, 0, 45, 31 },
  { 3196, 3, 1, 0, 0, 45, 31 },
  { 3199, 3, 1, 0, 0, 45, 31 },
  { 3202, 3, 1, 0, 0, 45, 31 },
  { 3205, 3, 1, 0, 0, 45, 31 },
  { 3208, 3, 1, 0, 0, 45, 31 },
  { 3443, 3, 1, 0, 0, 43, 31 },
  { 3446, 3, 1, 0, 0, 43, 31 },
  { 3449, 3, 1, 0, 0, 43, 31 },
  { 3452, 3, 1, 0, 0, 43, 31 },
  { 3455, 3, 1, 0, 0, 43, 31 },
  { 3458, 3, 1, 0, 0, 43, 31 },
  { 3461, 3, 1, 0, 0, 43, 31 },
  { 3464, 3, 1, 0, 0, 43, 31 },
  { 3467, 3, 1, 0, 0, 43, 31 },
  { 3470, 3, 1, 0, 0, 43, 31 },
  { 3473, 3, 1, 0, 0, 43, 31 },
  // 1261: vstore8, 
  { 2042, 4, 0, 0, 0, 46, 31 },
  { 2046, 4, 0, 0, 0, 46, 31 },
  { 2050, 4, 0, 0, 0, 46, 31 },
  { 2054, 4, 0, 0, 0, 46, 31 },
  { 2058, 4, 0, 0, 0, 46, 31 },
  { 2062, 4, 0, 0, 0, 46, 31 },
  { 2066, 4, 0, 0, 0, 46, 31 },
  { 2070, 4, 0, 0, 0, 46, 31 },
  { 2074, 4, 0, 0, 0, 46, 31 },
  { 2078, 4, 0, 0, 0, 46, 31 },
  { 2082, 4, 0, 0, 0, 46, 31 },
  { 2437, 4, 0, 0, 0, 46, 31 },
  { 2441, 4, 0, 0, 0, 46, 31 },
  { 2445, 4, 0, 0, 0, 46, 31 },
  { 2453, 4, 0, 0, 0, 46, 31 },
  { 2457, 4, 0, 0, 0, 46, 31 },
  { 2461, 4, 0, 0, 0, 46, 31 },
  { 2465, 4, 0, 0, 0, 46, 31 },
  { 2469, 4, 0, 0, 0, 46, 31 },
  { 2473, 4, 0, 0, 0, 46, 31 },
  { 2477, 4, 0, 0, 0, 46, 31 },
  { 2481, 4, 0, 0, 0, 46, 31 },
  { 2826, 4, 0, 0, 0, 46, 31 },
  { 2830, 4, 0, 0, 0, 46, 31 },
  { 2834, 4, 0, 0, 0, 46, 31 },
  { 2838, 4, 0, 0, 0, 46, 31 },
  { 2842, 4, 0, 0, 0, 46, 31 },
  { 2846, 4, 0, 0, 0, 46, 31 },
  { 2850, 4, 0, 0, 0, 46, 31 },
  { 2854, 4, 0, 0, 0, 46, 31 },
  { 2858, 4, 0, 0, 0, 46, 31 },
  { 2862, 4, 0, 0, 0, 46, 31 },
  { 2866, 4, 0, 0, 0, 46, 31 },
  { 3211, 4, 0, 0, 0, 45, 31 },
  { 3215, 4, 0, 0, 0, 45, 31 },
  { 3219, 4, 0, 0, 0, 45, 31 },
  { 3223, 4, 0, 0, 0, 45, 31 },
  { 3227, 4, 0, 0, 0, 45, 31 },
  { 3231, 4, 0, 0, 0, 45, 31 },
  { 3235, 4, 0, 0, 0, 45, 31 },
  { 3239, 4, 0, 0, 0, 45, 31 },
  { 3243, 4, 0, 0, 0, 45, 31 },
  { 3247, 4, 0, 0, 0, 45, 31 },
  { 3253, 4, 0, 0, 0, 45, 31 },
  // 1305: vload16, 
  { 2086, 3, 1, 0, 0, 46, 31 },
  { 2089, 3, 1, 0, 0, 46, 31 },
  { 2092, 3, 1, 0, 0, 46, 31 },
  { 2095, 3, 1, 0, 0, 46, 31 },
  { 2098, 3, 1, 0, 0, 46, 31 },
  { 2101, 3, 1, 0, 0, 46, 31 },
  { 2104, 3, 1, 0, 0, 46, 31 },
  { 2107, 3, 1, 0, 0, 46, 31 },
  { 2110, 3, 1, 0, 0, 46, 31 },
  { 2113, 3, 1, 0, 0, 46, 31 },
  { 2116, 3, 1, 0, 0, 46, 31 },
  { 2485, 3, 1, 0, 0, 46, 31 },
  { 2488, 3, 1, 0, 0, 46, 31 },
  { 2491, 3, 1, 0, 0, 46, 31 },
  { 2494, 3, 1, 0, 0, 46, 31 },
  { 2497, 3, 1, 0, 0, 46, 31 },
  { 2500, 3, 1, 0, 0, 46, 31 },
  { 2503, 3, 1, 0, 0, 46, 31 },
  { 2506, 3, 1, 0, 0, 46, 31 },
  { 2509, 3, 1, 0, 0, 46, 31 },
  { 2512, 3, 1, 0, 0, 46, 31 },
  { 2515, 3, 1, 0, 0, 46, 31 },
  { 2870, 3, 1, 0, 0, 46, 31 },
  { 2873, 3, 1, 0, 0, 46, 31 },
  { 2876, 3, 1, 0, 0, 46, 31 },
  { 2879, 3, 1, 0, 0, 46, 31 },
  { 2882, 3, 1, 0, 0, 46, 31 },
  { 2885, 3, 1, 0, 0, 46, 31 },
  { 2888, 3, 1, 0, 0, 46, 31 },
  { 2891, 3, 1, 0, 0, 46, 31 },
  { 2894, 3, 1, 0, 0, 46, 31 },
  { 2897, 3, 1, 0, 0, 46, 31 },
  { 2900, 3, 1, 0, 0, 46, 31 },
  { 3257, 3, 1, 0, 0, 45, 31 },
  { 3260, 3, 1, 0, 0, 45, 31 },
  { 3263, 3, 1, 0, 0, 45, 31 },
  { 3266, 3, 1, 0, 0, 45, 31 },
  { 3269, 3, 1, 0, 0, 45, 31 },
  { 3272, 3, 1, 0, 0, 45, 31 },
  { 3275, 3, 1, 0, 0, 45, 31 },
  { 3278, 3, 1, 0, 0, 45, 31 },
  { 3281, 3, 1, 0, 0, 45, 31 },
  { 3286, 3, 1, 0, 0, 45, 31 },
  { 3289, 3, 1, 0, 0, 45, 31 },
  { 3476, 3, 1, 0, 0, 43, 31 },
  { 3479, 3, 1, 0, 0, 43, 31 },
  { 3482, 3, 1, 0, 0, 43, 31 },
  { 3485, 3, 1, 0, 0, 43, 31 },
  { 3488, 3, 1, 0, 0, 43, 31 },
  { 3491, 3, 1, 0, 0, 43, 31 },
  { 3494, 3, 1, 0, 0, 43, 31 },
  { 3497, 3, 1, 0, 0, 43, 31 },
  { 3500, 3, 1, 0, 0, 43, 31 },
  { 3503, 3, 1, 0, 0, 43, 31 },
  { 3506, 3, 1, 0, 0, 43, 31 },
  // 1360: vstore16, 
  { 2119, 4, 0, 0, 0, 46, 31 },
  { 2123, 4, 0, 0, 0, 46, 31 },
  { 2127, 4, 0, 0, 0, 46, 31 },
  { 2131, 4, 0, 0, 0, 46, 31 },
  { 2135, 4, 0, 0, 0, 46, 31 },
  { 2139, 4, 0, 0, 0, 46, 31 },
  { 2143, 4, 0, 0, 0, 46, 31 },
  { 2147, 4, 0, 0, 0, 46, 31 },
  { 2151, 4, 0, 0, 0, 46, 31 },
  { 2155, 4, 0, 0, 0, 46, 31 },
  { 2159, 4, 0, 0, 0, 46, 31 },
  { 2518, 4, 0, 0, 0, 46, 31 },
  { 2522, 4, 0, 0, 0, 46, 31 },
  { 2526, 4, 0, 0, 0, 46, 31 },
  { 2530, 4, 0, 0, 0, 46, 31 },
  { 2534, 4, 0, 0, 0, 46, 31 },
  { 2538, 4, 0, 0, 0, 46, 31 },
  { 2542, 4, 0, 0, 0, 46, 31 },
  { 2546, 4, 0, 0, 0, 46, 31 },
  { 2550, 4, 0, 0, 0, 46, 31 },
  { 2554, 4, 0, 0, 0, 46, 31 },
  { 2558, 4, 0, 0, 0, 46, 31 },
  { 2903, 4, 0, 0, 0, 46, 31 },
  { 2907, 4, 0, 0, 0, 46, 31 },
  { 2911, 4, 0, 0, 0, 46, 31 },
  { 2915, 4, 0, 0, 0, 46, 31 },
  { 2919, 4, 0, 0, 0, 46, 31 },
  { 2923, 4, 0, 0, 0, 46, 31 },
  { 2927, 4, 0, 0, 0, 46, 31 },
  { 2931, 4, 0, 0, 0, 46, 31 },
  { 2935, 4, 0, 0, 0, 46, 31 },
  { 2939, 4, 0, 0, 0, 46, 31 },
  { 2943, 4, 0, 0, 0, 46, 31 },
  { 3292, 4, 0, 0, 0, 45, 31 },
  { 3296, 4, 0, 0, 0, 45, 31 },
  { 3300, 4, 0, 0, 0, 45, 31 },
  { 3304, 4, 0, 0, 0, 45, 31 },
  { 3308, 4, 0, 0, 0, 45, 31 },
  { 3312, 4, 0, 0, 0, 45, 31 },
  { 3316, 4, 0, 0, 0, 45, 31 },
  { 3320, 4, 0, 0, 0, 45, 31 },
  { 3326, 4, 0, 0, 0, 45, 31 },
  { 3330, 4, 0, 0, 0, 45, 31 },
  { 3334, 4, 0, 0, 0, 45, 31 },
  // 1404: vload_half, 
  { 3509, 3, 1, 0, 0, 46, 31 },
  { 3575, 3, 1, 0, 0, 46, 31 },
  { 3649, 3, 1, 0, 0, 46, 31 },
  { 3719, 3, 1, 0, 0, 45, 31 },
  { 3785, 3, 1, 0, 0, 43, 31 },
  // 1409: vload_half2, vloada_half2, 
  { 3512, 3, 1, 0, 0, 46, 31 },
  { 3578, 3, 1, 0, 0, 46, 31 },
  { 3652, 3, 1, 0, 0, 46, 31 },
  { 3722, 3, 1, 0, 0, 45, 31 },
  { 3788, 3, 1, 0, 0, 43, 31 },
  // 1414: vstore_half, vstore_half_rte, vstore_half_rtz, vstore_half_rtp, vstore_half_rtn, 
  { 3515, 4, 0, 0, 0, 46, 31 },
  { 3519, 4, 0, 0, 0, 46, 31 },
  { 3593, 4, 0, 0, 0, 46, 31 },
  { 3597, 4, 0, 0, 0, 46, 31 },
  { 3669, 4, 0, 0, 0, 46, 31 },
  { 3673, 4, 0, 0, 0, 46, 31 },
  { 3737, 4, 0, 0, 0, 45, 31 },
  { 3741, 4, 0, 0, 0, 45, 31 },
  // 1422: vstore_half2, vstorea_half2, vstore_half2_rte, vstorea_half2_rte, vstore_half2_rtz, vstorea_half2_rtz, vstore_half2_rtp, vstorea_half2_rtp, vstore_half2_rtn, vstorea_half2_rtn, 
  { 3523, 4, 0, 0, 0, 46, 31 },
  { 3527, 4, 0, 0, 0, 46, 31 },
  { 3601, 4, 0, 0, 0, 46, 31 },
  { 3605, 4, 0, 0, 0, 46, 31 },
  { 3677, 4, 0, 0, 0, 46, 31 },
  { 3681, 4, 0, 0, 0, 46, 31 },
  { 3745, 4, 0, 0, 0, 45, 31 },
  { 3749, 4, 0, 0, 0, 45, 31 },
  // 1430: vload_half3, vloada_half3, 
  { 3531, 3, 1, 0, 0, 46, 31 },
  { 3581, 3, 1, 0, 0, 46, 31 },
  { 3655, 3, 1, 0, 0, 46, 31 },
  { 3725, 3, 1, 0, 0, 45, 31 },
  { 3791, 3, 1, 0, 0, 43, 31 },
  // 1435: vload_half4, vloada_half4, 
  { 3534, 3, 1, 0, 0, 46, 31 },
  { 3584, 3, 1, 0, 0, 46, 31 },
  { 3658, 3, 1, 0, 0, 46, 31 },
  { 3728, 3, 1, 0, 0, 45, 31 },
  { 3794, 3, 1, 0, 0, 43, 31 },
  // 1440: vload_half8, vloada_half8, 
  { 3537, 3, 1, 0, 0, 46, 31 },
  { 3587, 3, 1, 0, 0, 46, 31 },
  { 3663, 3, 1, 0, 0, 46, 31 },
  { 3731, 3, 1, 0, 0, 45, 31 },
  { 3797, 3, 1, 0, 0, 43, 31 },
  // 1445: vload_half16, vloada_half16, 
  { 3540, 3, 1, 0, 0, 46, 31 },
  { 3590, 3, 1, 0, 0, 46, 31 },
  { 3666, 3, 1, 0, 0, 46, 31 },
  { 3734, 3, 1, 0, 0, 45, 31 },
  { 3800, 3, 1, 0, 0, 43, 31 },
  // 1450: vstore_half3, vstorea_half3, vstore_half3_rte, vstorea_half3_rte, vstore_half3_rtz, vstorea_half3_rtz, vstore_half3_rtp, vstorea_half3_rtp, vstore_half3_rtn, vstorea_half3_rtn, 
  { 3543, 4, 0, 0, 0, 46, 31 },
  { 3547, 4, 0, 0, 0, 46, 31 },
  { 3609, 4, 0, 0, 0, 46, 31 },
  { 3613, 4, 0, 0, 0, 46, 31 },
  { 3687, 4, 0, 0, 0, 46, 31 },
  { 3691, 4, 0, 0, 0, 46, 31 },
  { 3753, 4, 0, 0, 0, 45, 31 },
  { 3757, 4, 0, 0, 0, 45, 31 },
  // 1458: vstore_half4, vstorea_half4, vstore_half4_rte, vstorea_half4_rte, vstore_half4_rtz, vstorea_half4_rtz, vstore_half4_rtp, vstorea_half4_rtp, vstore_half4_rtn, vstorea_half4_rtn, 
  { 3551, 4, 0, 0, 0, 46, 31 },
  { 3555, 4, 0, 0, 0, 46, 31 },
  { 3617, 4, 0, 0, 0, 46, 31 },
  { 3621, 4, 0, 0, 0, 46, 31 },
  { 3695, 4, 0, 0, 0, 46, 31 },
  { 3699, 4, 0, 0, 0, 46, 31 },
  { 3761, 4, 0, 0, 0, 45, 31 },
  { 3765, 4, 0, 0, 0, 45, 31 },
  // 1466: vstore_half8, vstorea_half8, vstore_half8_rte, vstorea_half8_rte, vstore_half8_rtz, vstorea_half8_rtz, vstore_half8_rtp, vstorea_half8_rtp, vstore_half8_rtn, vstorea_half8_rtn, 
  { 3559, 4, 0, 0, 0, 46, 31 },
  { 3563, 4, 0, 0, 0, 46, 31 },
  { 3625, 4, 0, 0, 0, 46, 31 },
  { 3629, 4, 0, 0, 0, 46, 31 },
  { 3703, 4, 0, 0, 0, 46, 31 },
  { 3707, 4, 0, 0, 0, 46, 31 },
  { 3769, 4, 0, 0, 0, 45, 31 },
  { 3773, 4, 0, 0, 0, 45, 31 },
  // 1474: vstore_half16, vstorea_half16, vstore_half16_rte, vstorea_half16_rte, vstore_half16_rtz, vstorea_half16_rtz, vstore_half16_rtp, vstorea_half16_rtp, vstore_half16_rtn, vstorea_half16_rtn, 
  { 3567, 4, 0, 0, 0, 46, 31 },
  { 3571, 4, 0, 0, 0, 46, 31 },
  { 3633, 4, 0, 0, 0, 46, 31 },
  { 3637, 4, 0, 0, 0, 46, 31 },
  { 3711, 4, 0, 0, 0, 46, 31 },
  { 3715, 4, 0, 0, 0, 46, 31 },
  { 3777, 4, 0, 0, 0, 45, 31 },
  { 3781, 4, 0, 0, 0, 45, 31 },
  // 1482: barrier, 
  { 3803, 2, 0, 0, 1, 43, 31 },
  // 1483: work_group_barrier, 
  { 3803, 2, 0, 0, 1, 43, 24 },
  { 3805, 3, 0, 0, 1, 43, 24 },
  // 1485: mem_fence, read_mem_fence, write_mem_fence, 
  { 3803, 2, 0, 0, 0, 43, 31 },
  // 1486: get_fence, 
  { 3808, 2, 0, 0, 0, 45, 31 },
  { 3810, 2, 0, 0, 0, 45, 31 },
  // 1488: async_work_group_copy, 
  { 3812, 5, 0, 0, 0, 43, 31 },
  { 3819, 5, 0, 0, 0, 43, 31 },
  // 1490: async_work_group_strided_copy, 
  { 3824, 6, 0, 0, 0, 43, 31 },
  { 3830, 6, 0, 0, 0, 43, 31 },
  // 1492: wait_group_events, 
  { 3836, 3, 0, 0, 0, 43, 31 },
  // 1493: prefetch, 
  { 3841, 3, 0, 0, 0, 43, 31 },
  // 1494: atom_add, atom_sub, atom_xchg, 
  { 3844, 3, 0, 0, 0, 27, 31 },
  { 3855, 3, 0, 0, 0, 27, 31 },
  { 3864, 3, 0, 0, 0, 31, 31 },
  { 3875, 3, 0, 0, 0, 31, 31 },
  { 3886, 3, 0, 0, 0, 29, 31 },
  { 3897, 3, 0, 0, 0, 29, 31 },
  { 3906, 3, 0, 0, 0, 29, 31 },
  { 3915, 3, 0, 0, 0, 29, 31 },
  // 1502: atom_inc, atom_dec, 
  { 3847, 2, 0, 0, 0, 27, 31 },
  { 3858, 2, 0, 0, 0, 27, 31 },
  { 3867, 2, 0, 0, 0, 31, 31 },
  { 3878, 2, 0, 0, 0, 31, 31 },
  { 3889, 2, 0, 0, 0, 29, 31 },
  { 3900, 2, 0, 0, 0, 29, 31 },
  { 3909, 2, 0, 0, 0, 29, 31 },
  { 3918, 2, 0, 0, 0, 29, 31 },
  // 1510: atom_cmpxchg, 
  { 3849, 4, 0, 0, 0, 27, 31 },
  { 3860, 4, 0, 0, 0, 27, 31 },
  { 3869, 4, 0, 0, 0, 31, 31 },
  { 3882, 4, 0, 0, 0, 31, 31 },
  { 3891, 4, 0, 0, 0, 29, 31 },
  { 3902, 4, 0, 0, 0, 29, 31 },
  { 3911, 4, 0, 0, 0, 29, 31 },
  { 3920, 4, 0, 0, 0, 29, 31 },
  // 1518: atom_min, atom_max, atom_and, atom_or, atom_xor, 
  { 3844, 3, 0, 0, 0, 28, 31 },
  { 3855, 3, 0, 0, 0, 28, 31 },
  { 3864, 3, 0, 0, 0, 32, 31 },
  { 3875, 3, 0, 0, 0, 32, 31 },
  { 3886, 3, 0, 0, 0, 30, 31 },
  { 3897, 3, 0, 0, 0, 30, 31 },
  { 3906, 3, 0, 0, 0, 30, 31 },
  { 3915, 3, 0, 0, 0, 30, 31 },
  // 1526: atomic_xchg, 
  { 3924, 3, 0, 0, 0, 43, 31 },
  { 3844, 3, 0, 0, 0, 43, 31 },
  { 3855, 3, 0, 0, 0, 43, 31 },
  { 3927, 3, 0, 0, 0, 43, 31 },
  { 3864, 3, 0, 0, 0, 43, 31 },
  { 3875, 3, 0, 0, 0, 43, 31 },
  { 3930, 3, 0, 0, 0, 50, 31 },
  { 3939, 3, 0, 0, 0, 50, 31 },
  // 1534: atomic_add, atomic_sub, atomic_min, atomic_max, atomic_and, atomic_or, atomic_xor, 
  { 3844, 3, 0, 0, 0, 43, 31 },
  { 3855, 3, 0, 0, 0, 43, 31 },
  { 3864, 3, 0, 0, 0, 43, 31 },
  { 3875, 3, 0, 0, 0, 43, 31 },
  { 3930, 3, 0, 0, 0, 50, 31 },
  { 3939, 3, 0, 0, 0, 50, 31 },
  // 1540: atomic_inc, atomic_dec, 
  { 3847, 2, 0, 0, 0, 43, 31 },
  { 3858, 2, 0, 0, 0, 43, 31 },
  { 3867, 2, 0, 0, 0, 43, 31 },
  { 3878, 2, 0, 0, 0, 43, 31 },
  { 3933, 2, 0, 0, 0, 50, 31 },
  { 3942, 2, 0, 0, 0, 50, 31 },
  // 1546: atomic_cmpxchg, 
  { 3849, 4, 0, 0, 0, 43, 31 },
  { 3860, 4, 0, 0, 0, 43, 31 },
  { 3869, 4, 0, 0, 0, 43, 31 },
  { 3882, 4, 0, 0, 0, 43, 31 },
  { 3935, 4, 0, 0, 0, 50, 31 },
  { 3944, 4, 0, 0, 0, 50, 31 },
  // 1552: atomic_store, 
  { 3948, 3, 0, 0, 0, 57, 24 },
  { 4002, 3, 0, 0, 0, 57, 24 },
  { 4052, 3, 0, 0, 0, 57, 24 },
  { 4102, 3, 0, 0, 0, 57, 24 },
  { 4152, 3, 0, 0, 0, 57, 24 },
  { 4202, 3, 0, 0, 0, 57, 24 },
  { 4294, 3, 0, 0, 0, 59, 24 },
  { 4378, 3, 0, 0, 0, 59, 24 },
  { 4462, 3, 0, 0, 0, 59, 24 },
  { 4546, 3, 0, 0, 0, 59, 24 },
  { 4630, 3, 0, 0, 0, 59, 24 },
  { 4714, 3, 0, 0, 0, 59, 24 },
  { 4840, 3, 0, 0, 0, 59, 24 },
  { 4924, 3, 0, 0, 0, 59, 24 },
  { 5008, 3, 0, 0, 0, 59, 24 },
  { 5092, 3, 0, 0, 0, 59, 24 },
  { 5176, 3, 0, 0, 0, 59, 24 },
  { 5260, 3, 0, 0, 0, 59, 24 },
  { 5386, 3, 0, 0, 0, 61, 24 },
  { 5419, 3, 0, 0, 0, 75, 24 },
  { 5452, 3, 0, 0, 0, 89, 24 },
  // 1573: atomic_store_explicit, 
  { 3951, 4, 0, 0, 0, 58, 24 },
  { 3955, 5, 0, 0, 0, 45, 24 },
  { 4005, 4, 0, 0, 0, 58, 24 },
  { 4009, 5, 0, 0, 0, 45, 24 },
  { 4055, 4, 0, 0, 0, 58, 24 },
  { 4059, 5, 0, 0, 0, 45, 24 },
  { 4105, 4, 0, 0, 0, 58, 24 },
  { 4109, 5, 0, 0, 0, 45, 24 },
  { 4155, 4, 0, 0, 0, 58, 24 },
  { 4159, 5, 0, 0, 0, 45, 24 },
  { 4205, 4, 0, 0, 0, 58, 24 },
  { 4209, 5, 0, 0, 0, 45, 24 },
  { 4297, 4, 0, 0, 0, 60, 24 },
  { 4301, 5, 0, 0, 0, 46, 24 },
  { 4381, 4, 0, 0, 0, 60, 24 },
  { 4385, 5, 0, 0, 0, 46, 24 },
  { 4465, 4, 0, 0, 0, 60, 24 },
  { 4469, 5, 0, 0, 0, 46, 24 },
  { 4549, 4, 0, 0, 0, 60, 24 },
  { 4553, 5, 0, 0, 0, 46, 24 },
  { 4633, 4, 0, 0, 0, 60, 24 },
  { 4637, 5, 0, 0, 0, 46, 24 },
  { 4717, 4, 0, 0, 0, 60, 24 },
  { 4721, 5, 0, 0, 0, 46, 24 },
  { 4843, 4, 0, 0, 0, 60, 24 },
  { 4847, 5, 0, 0, 0, 46, 24 },
  { 4927, 4, 0, 0, 0, 60, 24 },
  { 4931, 5, 0, 0, 0, 46, 24 },
  { 5011, 4, 0, 0, 0, 60, 24 },
  { 5015, 5, 0, 0, 0, 46, 24 },
  { 5095, 4, 0, 0, 0, 60, 24 },
  { 5099, 5, 0, 0, 0, 46, 24 },
  { 5179, 4, 0, 0, 0, 60, 24 },
  { 5183, 5, 0, 0, 0, 46, 24 },
  { 5263, 4, 0, 0, 0, 60, 24 },
  { 5267, 5, 0, 0, 0, 46, 24 },
  { 5389, 4, 0, 0, 0, 62, 24 },
  { 5393, 5, 0, 0, 0, 8, 24 },
  { 5422, 4, 0, 0, 0, 76, 24 },
  { 5426, 5, 0, 0, 0, 11, 24 },
  { 5455, 4, 0, 0, 0, 90, 24 },
  { 5459, 5, 0, 0, 0, 5, 24 },
  // 1615: atomic_init, 
  { 3948, 3, 0, 0, 0, 45, 24 },
  { 4002, 3, 0, 0, 0, 45, 24 },
  { 4052, 3, 0, 0, 0, 45, 24 },
  { 4102, 3, 0, 0, 0, 45, 24 },
  { 4152, 3, 0, 0, 0, 45, 24 },
  { 4202, 3, 0, 0, 0, 45, 24 },
  { 4294, 3, 0, 0, 0, 46, 24 },
  { 4378, 3, 0, 0, 0, 46, 24 },
  { 4462, 3, 0, 0, 0, 46, 24 },
  { 4546, 3, 0, 0, 0, 46, 24 },
  { 4630, 3, 0, 0, 0, 46, 24 },
  { 4714, 3, 0, 0, 0, 46, 24 },
  { 4840, 3, 0, 0, 0, 46, 24 },
  { 4924, 3, 0, 0, 0, 46, 24 },
  { 5008, 3, 0, 0, 0, 46, 24 },
  { 5092, 3, 0, 0, 0, 46, 24 },
  { 5176, 3, 0, 0, 0, 46, 24 },
  { 5260, 3, 0, 0, 0, 46, 24 },
  // 1633: atomic_compare_exchange_weak, atomic_compare_exchange_strong, 
  { 3960, 4, 0, 0, 0, 57, 24 },
  { 4035, 4, 0, 0, 0, 57, 24 },
  { 4085, 4, 0, 0, 0, 57, 24 },
  { 4135, 4, 0, 0, 0, 57, 24 },
  { 4185, 4, 0, 0, 0, 57, 24 },
  { 4237, 4, 0, 0, 0, 57, 24 },
  { 4327, 4, 0, 0, 0, 59, 24 },
  { 4344, 4, 0, 0, 0, 59, 24 },
  { 4361, 4, 0, 0, 0, 59, 24 },
  { 4411, 4, 0, 0, 0, 59, 24 },
  { 4428, 4, 0, 0, 0, 59, 24 },
  { 4445, 4, 0, 0, 0, 59, 24 },
  { 4495, 4, 0, 0, 0, 59, 24 },
  { 4512, 4, 0, 0, 0, 59, 24 },
  { 4529, 4, 0, 0, 0, 59, 24 },
  { 4579, 4, 0, 0, 0, 59, 24 },
  { 4596, 4, 0, 0, 0, 59, 24 },
  { 4613, 4, 0, 0, 0, 59, 24 },
  { 4663, 4, 0, 0, 0, 59, 24 },
  { 4680, 4, 0, 0, 0, 59, 24 },
  { 4697, 4, 0, 0, 0, 59, 24 },
  { 4747, 4, 0, 0, 0, 59, 24 },
  { 4764, 4, 0, 0, 0, 59, 24 },
  { 4781, 4, 0, 0, 0, 59, 24 },
  { 4873, 4, 0, 0, 0, 59, 24 },
  { 4890, 4, 0, 0, 0, 59, 24 },
  { 4907, 4, 0, 0, 0, 59, 24 },
  { 4957, 4, 0, 0, 0, 59, 24 },
  { 4974, 4, 0, 0, 0, 59, 24 },
  { 4991, 4, 0, 0, 0, 59, 24 },
  { 5041, 4, 0, 0, 0, 59, 24 },
  { 5058, 4, 0, 0, 0, 59, 24 },
  { 5075, 4, 0, 0, 0, 59, 24 },
  { 5125, 4, 0, 0, 0, 59, 24 },
  { 5142, 4, 0, 0, 0, 59, 24 },
  { 5159, 4, 0, 0, 0, 59, 24 },
  { 5209, 4, 0, 0, 0, 59, 24 },
  { 5226, 4, 0, 0, 0, 59, 24 },
  { 5243, 4, 0, 0, 0, 59, 24 },
  { 5293, 4, 0, 0, 0, 59, 24 },
  { 5310, 4, 0, 0, 0, 59, 24 },
  { 5327, 4, 0, 0, 0, 59, 24 },
  // 1675: atomic_compare_exchange_weak_explicit, atomic_compare_exchange_strong_explicit, 
  { 3964, 6, 0, 0, 0, 58, 24 },
  { 3970, 7, 0, 0, 0, 45, 24 },
  { 4039, 6, 0, 0, 0, 58, 24 },
  { 4045, 7, 0, 0, 0, 45, 24 },
  { 4089, 6, 0, 0, 0, 58, 24 },
  { 4095, 7, 0, 0, 0, 45, 24 },
  { 4139, 6, 0, 0, 0, 58, 24 },
  { 4145, 7, 0, 0, 0, 45, 24 },
  { 4189, 6, 0, 0, 0, 58, 24 },
  { 4195, 7, 0, 0, 0, 45, 24 },
  { 4241, 6, 0, 0, 0, 58, 24 },
  { 4247, 7, 0, 0, 0, 45, 24 },
  { 4331, 6, 0, 0, 0, 60, 24 },
  { 4337, 7, 0, 0, 0, 46, 24 },
  { 4348, 6, 0, 0, 0, 60, 24 },
  { 4354, 7, 0, 0, 0, 46, 24 },
  { 4365, 6, 0, 0, 0, 60, 24 },
  { 4371, 7, 0, 0, 0, 46, 24 },
  { 4415, 6, 0, 0, 0, 60, 24 },
  { 4421, 7, 0, 0, 0, 46, 24 },
  { 4432, 6, 0, 0, 0, 60, 24 },
  { 4438, 7, 0, 0, 0, 46, 24 },
  { 4449, 6, 0, 0, 0, 60, 24 },
  { 4455, 7, 0, 0, 0, 46, 24 },
  { 4499, 6, 0, 0, 0, 60, 24 },
  { 4505, 7, 0, 0, 0, 46, 24 },
  { 4516, 6, 0, 0, 0, 60, 24 },
  { 4522, 7, 0, 0, 0, 46, 24 },
  { 4533, 6, 0, 0, 0, 60, 24 },
  { 4539, 7, 0, 0, 0, 46, 24 },
  { 4583, 6, 0, 0, 0, 60, 24 },
  { 4589, 7, 0, 0, 0, 46, 24 },
  { 4600, 6, 0, 0, 0, 60, 24 },
  { 4606, 7, 0, 0, 0, 46, 24 },
  { 4617, 6, 0, 0, 0, 60, 24 },
  { 4623, 7, 0, 0, 0, 46, 24 },
  { 4667, 6, 0, 0, 0, 60, 24 },
  { 4673, 7, 0, 0, 0, 46, 24 },
  { 4684, 6, 0, 0, 0, 60, 24 },
  { 4690, 7, 0, 0, 0, 46, 24 },
  { 4701, 6, 0, 0, 0, 60, 24 },
  { 4707, 7, 0, 0, 0, 46, 24 },
  { 4751, 6, 0, 0, 0, 60, 24 },
  { 4757, 7, 0, 0, 0, 46, 24 },
  { 4768, 6, 0, 0, 0, 60, 24 },
  { 4774, 7, 0, 0, 0, 46, 24 },
  { 4785, 6, 0, 0, 0, 60, 24 },
  { 4791, 7, 0, 0, 0, 46, 24 },
  { 4877, 6, 0, 0, 0, 60, 24 },
  { 4883, 7, 0, 0, 0, 46, 24 },
  { 4894, 6, 0, 0, 0, 60, 24 },
  { 4900, 7, 0, 0, 0, 46, 24 },
  { 4911, 6, 0, 0, 0, 60, 24 },
  { 4917, 7, 0, 0, 0, 46, 24 },
  { 4961, 6, 0, 0, 0, 60, 24 },
  { 4967, 7, 0, 0, 0, 46, 24 },
  { 4978, 6, 0, 0, 0, 60, 24 },
  { 4984, 7, 0, 0, 0, 46, 24 },
  { 4995, 6, 0, 0, 0, 60, 24 },
  { 5001, 7, 0, 0, 0, 46, 24 },
  { 5045, 6, 0, 0, 0, 60, 24 },
  { 5051, 7, 0, 0, 0, 46, 24 },
  { 5062, 6, 0, 0, 0, 60, 24 },
  { 5068, 7, 0, 0, 0, 46, 24 },
  { 5079, 6, 0, 0, 0, 60, 24 },
  { 5085, 7, 0, 0, 0, 46, 24 },
  { 5129, 6, 0, 0, 0, 60, 24 },
  { 5135, 7, 0, 0, 0, 46, 24 },
  { 5146, 6, 0, 0, 0, 60, 24 },
  { 5152, 7, 0, 0, 0, 46, 24 },
  { 5163, 6, 0, 0, 0, 60, 24 },
  { 5169, 7, 0, 0, 0, 46, 24 },
  { 5213, 6, 0, 0, 0, 60, 24 },
  { 5219, 7, 0, 0, 0, 46, 24 },
  { 5230, 6, 0, 0, 0, 60, 24 },
  { 5236, 7, 0, 0, 0, 46, 24 },
  { 5247, 6, 0, 0, 0, 60, 24 },
  { 5253, 7, 0, 0, 0, 46, 24 },
  { 5297, 6, 0, 0, 0, 60, 24 },
  { 5303, 7, 0, 0, 0, 46, 24 },
  { 5314, 6, 0, 0, 0, 60, 24 },
  { 5320, 7, 0, 0, 0, 46, 24 },
  { 5331, 6, 0, 0, 0, 60, 24 },
  { 5337, 7, 0, 0, 0, 46, 24 },
  // 1759: atomic_work_item_fence, 
  { 3977, 4, 0, 0, 0, 43, 24 },
  // 1760: atomic_load, 
  { 3981, 2, 0, 0, 0, 57, 24 },
  { 4014, 2, 0, 0, 0, 57, 24 },
  { 4064, 2, 0, 0, 0, 57, 24 },
  { 4114, 2, 0, 0, 0, 57, 24 },
  { 4164, 2, 0, 0, 0, 57, 24 },
  { 4214, 2, 0, 0, 0, 57, 24 },
  { 4306, 2, 0, 0, 0, 59, 24 },
  { 4390, 2, 0, 0, 0, 59, 24 },
  { 4474, 2, 0, 0, 0, 59, 24 },
  { 4558, 2, 0, 0, 0, 59, 24 },
  { 4642, 2, 0, 0, 0, 59, 24 },
  { 4726, 2, 0, 0, 0, 59, 24 },
  { 4852, 2, 0, 0, 0, 59, 24 },
  { 4936, 2, 0, 0, 0, 59, 24 },
  { 5020, 2, 0, 0, 0, 59, 24 },
  { 5104, 2, 0, 0, 0, 59, 24 },
  { 5188, 2, 0, 0, 0, 59, 24 },
  { 5272, 2, 0, 0, 0, 59, 24 },
  { 5398, 2, 0, 0, 0, 61, 24 },
  { 5431, 2, 0, 0, 0, 75, 24 },
  { 5464, 2, 0, 0, 0, 89, 24 },
  // 1781: atomic_load_explicit, 
  { 3983, 3, 0, 0, 0, 58, 24 },
  { 3986, 4, 0, 0, 0, 45, 24 },
  { 4016, 3, 0, 0, 0, 58, 24 },
  { 4019, 4, 0, 0, 0, 45, 24 },
  { 4066, 3, 0, 0, 0, 58, 24 },
  { 4069, 4, 0, 0, 0, 45, 24 },
  { 4116, 3, 0, 0, 0, 58, 24 },
  { 4119, 4, 0, 0, 0, 45, 24 },
  { 4166, 3, 0, 0, 0, 58, 24 },
  { 4169, 4, 0, 0, 0, 45, 24 },
  { 4216, 3, 0, 0, 0, 58, 24 },
  { 4219, 4, 0, 0, 0, 45, 24 },
  { 4308, 3, 0, 0, 0, 60, 24 },
  { 4311, 4, 0, 0, 0, 46, 24 },
  { 4392, 3, 0, 0, 0, 60, 24 },
  { 4395, 4, 0, 0, 0, 46, 24 },
  { 4476, 3, 0, 0, 0, 60, 24 },
  { 4479, 4, 0, 0, 0, 46, 24 },
  { 4560, 3, 0, 0, 0, 60, 24 },
  { 4563, 4, 0, 0, 0, 46, 24 },
  { 4644, 3, 0, 0, 0, 60, 24 },
  { 4647, 4, 0, 0, 0, 46, 24 },
  { 4728, 3, 0, 0, 0, 60, 24 },
  { 4731, 4, 0, 0, 0, 46, 24 },
  { 4854, 3, 0, 0, 0, 60, 24 },
  { 4857, 4, 0, 0, 0, 46, 24 },
  { 4938, 3, 0, 0, 0, 60, 24 },
  { 4941, 4, 0, 0, 0, 46, 24 },
  { 5022, 3, 0, 0, 0, 60, 24 },
  { 5025, 4, 0, 0, 0, 46, 24 },
  { 5106, 3, 0, 0, 0, 60, 24 },
  { 5109, 4, 0, 0, 0, 46, 24 },
  { 5190, 3, 0, 0, 0, 60, 24 },
  { 5193, 4, 0, 0, 0, 46, 24 },
  { 5274, 3, 0, 0, 0, 60, 24 },
  { 5277, 4, 0, 0, 0, 46, 24 },
  { 5400, 3, 0, 0, 0, 62, 24 },
  { 5403, 4, 0, 0, 0, 8, 24 },
  { 5433, 3, 0, 0, 0, 76, 24 },
  { 5436, 4, 0, 0, 0, 11, 24 },
  { 5466, 3, 0, 0, 0, 90, 24 },
  { 5469, 4, 0, 0, 0, 5, 24 },
  // 1823: atomic_exchange, atomic_fetch_min, atomic_fetch_max, 
  { 3990, 3, 0, 0, 0, 57, 24 },
  { 4023, 3, 0, 0, 0, 57, 24 },
  { 4073, 3, 0, 0, 0, 57, 24 },
  { 4123, 3, 0, 0, 0, 57, 24 },
  { 4173, 3, 0, 0, 0, 57, 24 },
  { 4225, 3, 0, 0, 0, 57, 24 },
  { 4315, 3, 0, 0, 0, 59, 24 },
  { 4399, 3, 0, 0, 0, 59, 24 },
  { 4483, 3, 0, 0, 0, 59, 24 },
  { 4567, 3, 0, 0, 0, 59, 24 },
  { 4651, 3, 0, 0, 0, 59, 24 },
  { 4735, 3, 0, 0, 0, 59, 24 },
  { 4861, 3, 0, 0, 0, 59, 24 },
  { 4945, 3, 0, 0, 0, 59, 24 },
  { 5029, 3, 0, 0, 0, 59, 24 },
  { 5113, 3, 0, 0, 0, 59, 24 },
  { 5197, 3, 0, 0, 0, 59, 24 },
  { 5281, 3, 0, 0, 0, 59, 24 },
  { 5407, 3, 0, 0, 0, 61, 24 },
  { 5440, 3, 0, 0, 0, 75, 24 },
  { 5473, 3, 0, 0, 0, 89, 24 },
  // 1844: atomic_exchange_explicit, atomic_fetch_min_explicit, atomic_fetch_max_explicit, 
  { 3993, 4, 0, 0, 0, 58, 24 },
  { 3997, 5, 0, 0, 0, 45, 24 },
  { 4026, 4, 0, 0, 0, 58, 24 },
  { 4030, 5, 0, 0, 0, 45, 24 },
  { 4076, 4, 0, 0, 0, 58, 24 },
  { 4080, 5, 0, 0, 0, 45, 24 },
  { 4126, 4, 0, 0, 0, 58, 24 },
  { 4130, 5, 0, 0, 0, 45, 24 },
  { 4176, 4, 0, 0, 0, 58, 24 },
  { 4180, 5, 0, 0, 0, 45, 24 },
  { 4228, 4, 0, 0, 0, 58, 24 },
  { 4232, 5, 0, 0, 0, 45, 24 },
  { 4318, 4, 0, 0, 0, 60, 24 },
  { 4322, 5, 0, 0, 0, 46, 24 },
  { 4402, 4, 0, 0, 0, 60, 24 },
  { 4406, 5, 0, 0, 0, 46, 24 },
  { 4486, 4, 0, 0, 0, 60, 24 },
  { 4490, 5, 0, 0, 0, 46, 24 },
  { 4570, 4, 0, 0, 0, 60, 24 },
  { 4574, 5, 0, 0, 0, 46, 24 },
  { 4654, 4, 0, 0, 0, 60, 24 },
  { 4658, 5, 0, 0, 0, 46, 24 },
  { 4738, 4, 0, 0, 0, 60, 24 },
  { 4742, 5, 0, 0, 0, 46, 24 },
  { 4864, 4, 0, 0, 0, 60, 24 },
  { 4868, 5, 0, 0, 0, 46, 24 },
  { 4948, 4, 0, 0, 0, 60, 24 },
  { 4952, 5, 0, 0, 0, 46, 24 },
  { 5032, 4, 0, 0, 0, 60, 24 },
  { 5036, 5, 0, 0, 0, 46, 24 },
  { 5116, 4, 0, 0, 0, 60, 24 },
  { 5120, 5, 0, 0, 0, 46, 24 },
  { 5200, 4, 0, 0, 0, 60, 24 },
  { 5204, 5, 0, 0, 0, 46, 24 },
  { 5284, 4, 0, 0, 0, 60, 24 },
  { 5288, 5, 0, 0, 0, 46, 24 },
  { 5410, 4, 0, 0, 0, 62, 24 },
  { 5414, 5, 0, 0, 0, 8, 24 },
  { 5443, 4, 0, 0, 0, 76, 24 },
  { 5447, 5, 0, 0, 0, 11, 24 },
  { 5476, 4, 0, 0, 0, 90, 24 },
  { 5480, 5, 0, 0, 0, 5, 24 },
  // 1886: atomic_fetch_add, atomic_fetch_sub, 
  { 3990, 3, 0, 0, 0, 57, 24 },
  { 4023, 3, 0, 0, 0, 57, 24 },
  { 4073, 3, 0, 0, 0, 57, 24 },
  { 4123, 3, 0, 0, 0, 57, 24 },
  { 4260, 3, 0, 0, 0, 57, 24 },
  { 4315, 3, 0, 0, 0, 59, 24 },
  { 4399, 3, 0, 0, 0, 59, 24 },
  { 4483, 3, 0, 0, 0, 59, 24 },
  { 4567, 3, 0, 0, 0, 59, 24 },
  { 4802, 3, 0, 0, 0, 59, 24 },
  { 4861, 3, 0, 0, 0, 59, 24 },
  { 4945, 3, 0, 0, 0, 59, 24 },
  { 5029, 3, 0, 0, 0, 59, 24 },
  { 5113, 3, 0, 0, 0, 59, 24 },
  { 5344, 3, 0, 0, 0, 59, 24 },
  { 5407, 3, 0, 0, 0, 63, 24 },
  { 4651, 3, 0, 0, 0, 65, 24 },
  { 4735, 3, 0, 0, 0, 67, 24 },
  { 5440, 3, 0, 0, 0, 77, 24 },
  { 5197, 3, 0, 0, 0, 79, 24 },
  { 5281, 3, 0, 0, 0, 81, 24 },
  { 5473, 3, 0, 0, 0, 91, 24 },
  { 4173, 3, 0, 0, 0, 93, 24 },
  { 4225, 3, 0, 0, 0, 95, 24 },
  // 1910: atomic_fetch_add_explicit, atomic_fetch_sub_explicit, 
  { 3993, 4, 0, 0, 0, 58, 24 },
  { 3997, 5, 0, 0, 0, 45, 24 },
  { 4026, 4, 0, 0, 0, 58, 24 },
  { 4030, 5, 0, 0, 0, 45, 24 },
  { 4076, 4, 0, 0, 0, 58, 24 },
  { 4080, 5, 0, 0, 0, 45, 24 },
  { 4126, 4, 0, 0, 0, 58, 24 },
  { 4130, 5, 0, 0, 0, 45, 24 },
  { 4263, 4, 0, 0, 0, 58, 24 },
  { 4267, 5, 0, 0, 0, 45, 24 },
  { 4318, 4, 0, 0, 0, 60, 24 },
  { 4322, 5, 0, 0, 0, 46, 24 },
  { 4402, 4, 0, 0, 0, 60, 24 },
  { 4406, 5, 0, 0, 0, 46, 24 },
  { 4486, 4, 0, 0, 0, 60, 24 },
  { 4490, 5, 0, 0, 0, 46, 24 },
  { 4570, 4, 0, 0, 0, 60, 24 },
  { 4574, 5, 0, 0, 0, 46, 24 },
  { 4805, 4, 0, 0, 0, 60, 24 },
  { 4809, 5, 0, 0, 0, 46, 24 },
  { 4864, 4, 0, 0, 0, 60, 24 },
  { 4868, 5, 0, 0, 0, 46, 24 },
  { 4948, 4, 0, 0, 0, 60, 24 },
  { 4952, 5, 0, 0, 0, 46, 24 },
  { 5032, 4, 0, 0, 0, 60, 24 },
  { 5036, 5, 0, 0, 0, 46, 24 },
  { 5116, 4, 0, 0, 0, 60, 24 },
  { 5120, 5, 0, 0, 0, 46, 24 },
  { 5347, 4, 0, 0, 0, 60, 24 },
  { 5351, 5, 0, 0, 0, 46, 24 },
  { 5410, 4, 0, 0, 0, 64, 24 },
  { 5414, 5, 0, 0, 0, 7, 24 },
  { 4654, 4, 0, 0, 0, 66, 24 },
  { 4658, 5, 0, 0, 0, 15, 24 },
  { 4738, 4, 0, 0, 0, 68, 24 },
  { 4742, 5, 0, 0, 0, 21, 24 },
  { 5443, 4, 0, 0, 0, 78, 24 },
  { 5447, 5, 0, 0, 0, 10, 24 },
  { 5200, 4, 0, 0, 0, 80, 24 },
  { 5204, 5, 0, 0, 0, 17, 24 },
  { 5284, 4, 0, 0, 0, 82, 24 },
  { 5288, 5, 0, 0, 0, 23, 24 },
  { 5476, 4, 0, 0, 0, 92, 24 },
  { 5480, 5, 0, 0, 0, 4, 24 },
  { 4176, 4, 0, 0, 0, 94, 24 },
  { 4180, 5, 0, 0, 0, 13, 24 },
  { 4228, 4, 0, 0, 0, 96, 24 },
  { 4232, 5, 0, 0, 0, 19, 24 },
  // 1958: atomic_fetch_or, atomic_fetch_xor, atomic_fetch_and, 
  { 3990, 3, 0, 0, 0, 57, 24 },
  { 4023, 3, 0, 0, 0, 57, 24 },
  { 4073, 3, 0, 0, 0, 57, 24 },
  { 4123, 3, 0, 0, 0, 57, 24 },
  { 4315, 3, 0, 0, 0, 59, 24 },
  { 4399, 3, 0, 0, 0, 59, 24 },
  { 4483, 3, 0, 0, 0, 59, 24 },
  { 4567, 3, 0, 0, 0, 59, 24 },
  { 4861, 3, 0, 0, 0, 59, 24 },
  { 4945, 3, 0, 0, 0, 59, 24 },
  { 5029, 3, 0, 0, 0, 59, 24 },
  { 5113, 3, 0, 0, 0, 59, 24 },
  // 1970: atomic_fetch_or_explicit, atomic_fetch_xor_explicit, atomic_fetch_and_explicit, 
  { 3993, 4, 0, 0, 0, 58, 24 },
  { 3997, 5, 0, 0, 0, 45, 24 },
  { 4026, 4, 0, 0, 0, 58, 24 },
  { 4030, 5, 0, 0, 0, 45, 24 },
  { 4076, 4, 0, 0, 0, 58, 24 },
  { 4080, 5, 0, 0, 0, 45, 24 },
  { 4126, 4, 0, 0, 0, 58, 24 },
  { 4130, 5, 0, 0, 0, 45, 24 },
  { 4318, 4, 0, 0, 0, 60, 24 },
  { 4322, 5, 0, 0, 0, 46, 24 },
  { 4402, 4, 0, 0, 0, 60, 24 },
  { 4406, 5, 0, 0, 0, 46, 24 },
  { 4486, 4, 0, 0, 0, 60, 24 },
  { 4490, 5, 0, 0, 0, 46, 24 },
  { 4570, 4, 0, 0, 0, 60, 24 },
  { 4574, 5, 0, 0, 0, 46, 24 },
  { 4864, 4, 0, 0, 0, 60, 24 },
  { 4868, 5, 0, 0, 0, 46, 24 },
  { 4948, 4, 0, 0, 0, 60, 24 },
  { 4952, 5, 0, 0, 0, 46, 24 },
  { 5032, 4, 0, 0, 0, 60, 24 },
  { 5036, 5, 0, 0, 0, 46, 24 },
  { 5116, 4, 0, 0, 0, 60, 24 },
  { 5120, 5, 0, 0, 0, 46, 24 },
  // 1994: atomic_flag_clear, 
  { 4276, 2, 0, 0, 0, 57, 24 },
  { 4822, 2, 0, 0, 0, 59, 24 },
  { 5366, 2, 0, 0, 0, 59, 24 },
  // 1997: atomic_flag_clear_explicit, 
  { 4278, 3, 0, 0, 0, 58, 24 },
  { 4281, 4, 0, 0, 0, 45, 24 },
  { 4824, 3, 0, 0, 0, 60, 24 },
  { 4827, 4, 0, 0, 0, 46, 24 },
  { 5370, 3, 0, 0, 0, 60, 24 },
  { 5373, 4, 0, 0, 0, 46, 24 },
  // 2003: atomic_flag_test_and_set, 
  { 4285, 2, 0, 0, 0, 57, 24 },
  { 4831, 2, 0, 0, 0, 59, 24 },
  { 5377, 2, 0, 0, 0, 59, 24 },
  // 2006: atomic_flag_test_and_set_explicit, 
  { 4287, 3, 0, 0, 0, 58, 24 },
  { 4290, 4, 0, 0, 0, 45, 24 },
  { 4833, 3, 0, 0, 0, 60, 24 },
  { 4836, 4, 0, 0, 0, 46, 24 },
  { 5379, 3, 0, 0, 0, 60, 24 },
  { 5382, 4, 0, 0, 0, 46, 24 },
  // 2012: shuffle, 
  { 5485, 3, 0, 1, 0, 43, 31 },
  { 5488, 3, 0, 1, 0, 43, 31 },
  { 5491, 3, 0, 1, 0, 43, 31 },
  { 5494, 3, 0, 1, 0, 43, 31 },
  { 5497, 3, 0, 1, 0, 43, 31 },
  { 5500, 3, 0, 1, 0, 43, 31 },
  { 5503, 3, 0, 1, 0, 43, 31 },
  { 5506, 3, 0, 1, 0, 43, 31 },
  { 5509, 3, 0, 1, 0, 43, 31 },
  { 5512, 3, 0, 1, 0, 43, 31 },
  { 5515, 3, 0, 1, 0, 43, 31 },
  { 5518, 3, 0, 1, 0, 43, 31 },
  { 5521, 3, 0, 1, 0, 43, 31 },
  { 5526, 3, 0, 1, 0, 43, 31 },
  { 5529, 3, 0, 1, 0, 43, 31 },
  { 5532, 3, 0, 1, 0, 43, 31 },
  { 5535, 3, 0, 1, 0, 43, 31 },
  { 5538, 3, 0, 1, 0, 43, 31 },
  { 5541, 3, 0, 1, 0, 43, 31 },
  { 5544, 3, 0, 1, 0, 43, 31 },
  { 5547, 3, 0, 1, 0, 43, 31 },
  { 5550, 3, 0, 1, 0, 43, 31 },
  { 5553, 3, 0, 1, 0, 43, 31 },
  { 5558, 3, 0, 1, 0, 43, 31 },
  { 5561, 3, 0, 1, 0, 43, 31 },
  { 5564, 3, 0, 1, 0, 43, 31 },
  { 5567, 3, 0, 1, 0, 43, 31 },
  { 5570, 3, 0, 1, 0, 43, 31 },
  { 5573, 3, 0, 1, 0, 43, 31 },
  { 5576, 3, 0, 1, 0, 43, 31 },
  { 5579, 3, 0, 1, 0, 43, 31 },
  { 5582, 3, 0, 1, 0, 43, 31 },
  { 5585, 3, 0, 1, 0, 43, 31 },
  { 5590, 3, 0, 1, 0, 43, 31 },
  { 5593, 3, 0, 1, 0, 43, 31 },
  { 5596, 3, 0, 1, 0, 43, 31 },
  { 5599, 3, 0, 1, 0, 43, 31 },
  { 5602, 3, 0, 1, 0, 43, 31 },
  { 5605, 3, 0, 1, 0, 43, 31 },
  { 5608, 3, 0, 1, 0, 43, 31 },
  { 5611, 3, 0, 1, 0, 43, 31 },
  { 5614, 3, 0, 1, 0, 43, 31 },
  { 5617, 3, 0, 1, 0, 43, 31 },
  { 5622, 3, 0, 1, 0, 43, 31 },
  { 5625, 3, 0, 1, 0, 43, 31 },
  { 5628, 3, 0, 1, 0, 43, 31 },
  { 5631, 3, 0, 1, 0, 43, 31 },
  { 5634, 3, 0, 1, 0, 43, 31 },
  { 5637, 3, 0, 1, 0, 43, 31 },
  { 5640, 3, 0, 1, 0, 43, 31 },
  { 5643, 3, 0, 1, 0, 43, 31 },
  { 5646, 3, 0, 1, 0, 43, 31 },
  { 5649, 3, 0, 1, 0, 43, 31 },
  { 5654, 3, 0, 1, 0, 43, 31 },
  { 5657, 3, 0, 1, 0, 43, 31 },
  { 5660, 3, 0, 1, 0, 43, 31 },
  { 5663, 3, 0, 1, 0, 43, 31 },
  { 5666, 3, 0, 1, 0, 43, 31 },
  { 5669, 3, 0, 1, 0, 43, 31 },
  { 5672, 3, 0, 1, 0, 43, 31 },
  { 5675, 3, 0, 1, 0, 43, 31 },
  { 5678, 3, 0, 1, 0, 43, 31 },
  { 5681, 3, 0, 1, 0, 43, 31 },
  { 5686, 3, 0, 1, 0, 43, 31 },
  { 5689, 3, 0, 1, 0, 43, 31 },
  { 5692, 3, 0, 1, 0, 43, 31 },
  { 5695, 3, 0, 1, 0, 43, 31 },
  { 5698, 3, 0, 1, 0, 43, 31 },
  { 5701, 3, 0, 1, 0, 43, 31 },
  { 5704, 3, 0, 1, 0, 43, 31 },
  { 5707, 3, 0, 1, 0, 43, 31 },
  { 5710, 3, 0, 1, 0, 43, 31 },
  { 5713, 3, 0, 1, 0, 43, 31 },
  { 5716, 3, 0, 1, 0, 43, 31 },
  { 5719, 3, 0, 1, 0, 43, 31 },
  { 5722, 3, 0, 1, 0, 43, 31 },
  { 5725, 3, 0, 1, 0, 43, 31 },
  { 5728, 3, 0, 1, 0, 43, 31 },
  { 5731, 3, 0, 1, 0, 43, 31 },
  { 5734, 3, 0, 1, 0, 43, 31 },
  { 5737, 3, 0, 1, 0, 43, 31 },
  { 5740, 3, 0, 1, 0, 43, 31 },
  { 5743, 3, 0, 1, 0, 43, 31 },
  { 5746, 3, 0, 1, 0, 43, 31 },
  { 5749, 3, 0, 1, 0, 43, 31 },
  { 5752, 3, 0, 1, 0, 43, 31 },
  { 5755, 3, 0, 1, 0, 43, 31 },
  { 5758, 3, 0, 1, 0, 43, 31 },
  { 5761, 3, 0, 1, 0, 43, 31 },
  { 5764, 3, 0, 1, 0, 43, 31 },
  { 5767, 3, 0, 1, 0, 43, 31 },
  { 5770, 3, 0, 1, 0, 43, 31 },
  { 5773, 3, 0, 1, 0, 43, 31 },
  { 5776, 3, 0, 1, 0, 43, 31 },
  { 5779, 3, 0, 1, 0, 43, 31 },
  { 5782, 3, 0, 1, 0, 43, 31 },
  { 5785, 3, 0, 1, 0, 43, 31 },
  { 5788, 3, 0, 1, 0, 43, 31 },
  { 5791, 3, 0, 1, 0, 43, 31 },
  { 5794, 3, 0, 1, 0, 43, 31 },
  { 5797, 3, 0, 1, 0, 43, 31 },
  { 5800, 3, 0, 1, 0, 43, 31 },
  { 5803, 3, 0, 1, 0, 43, 31 },
  { 5806, 3, 0, 1, 0, 43, 31 },
  { 5809, 3, 0, 1, 0, 43, 31 },
  { 5812, 3, 0, 1, 0, 43, 31 },
  { 5815, 3, 0, 1, 0, 43, 31 },
  { 5818, 3, 0, 1, 0, 43, 31 },
  { 5821, 3, 0, 1, 0, 43, 31 },
  { 5824, 3, 0, 1, 0, 43, 31 },
  { 5827, 3, 0, 1, 0, 43, 31 },
  { 5830, 3, 0, 1, 0, 43, 31 },
  { 5833, 3, 0, 1, 0, 43, 31 },
  { 5836, 3, 0, 1, 0, 43, 31 },
  { 5839, 3, 0, 1, 0, 43, 31 },
  { 5842, 3, 0, 1, 0, 43, 31 },
  { 5845, 3, 0, 1, 0, 43, 31 },
  { 5848, 3, 0, 1, 0, 43, 31 },
  { 5851, 3, 0, 1, 0, 43, 31 },
  { 5854, 3, 0, 1, 0, 43, 31 },
  { 5857, 3, 0, 1, 0, 43, 31 },
  { 5860, 3, 0, 1, 0, 43, 31 },
  { 5863, 3, 0, 1, 0, 43, 31 },
  { 5866, 3, 0, 1, 0, 43, 31 },
  { 5869, 3, 0, 1, 0, 43, 31 },
  { 5872, 3, 0, 1, 0, 43, 31 },
  { 5875, 3, 0, 1, 0, 43, 31 },
  { 5878, 3, 0, 1, 0, 43, 31 },
  { 5881, 3, 0, 1, 0, 43, 31 },
  { 5884, 3, 0, 1, 0, 43, 31 },
  { 5887, 3, 0, 1, 0, 43, 31 },
  { 5890, 3, 0, 1, 0, 43, 31 },
  { 5893, 3, 0, 1, 0, 43, 31 },
  { 5896, 3, 0, 1, 0, 43, 31 },
  { 5899, 3, 0, 1, 0, 43, 31 },
  { 5902, 3, 0, 1, 0, 43, 31 },
  { 5905, 3, 0, 1, 0, 43, 31 },
  { 5908, 3, 0, 1, 0, 43, 31 },
  { 5911, 3, 0, 1, 0, 43, 31 },
  { 5914, 3, 0, 1, 0, 43, 31 },
  { 5917, 3, 0, 1, 0, 43, 31 },
  { 5920, 3, 0, 1, 0, 43, 31 },
  { 5923, 3, 0, 1, 0, 43, 31 },
  { 5926, 3, 0, 1, 0, 43, 31 },
  { 5929, 3, 0, 1, 0, 43, 31 },
  { 5932, 3, 0, 1, 0, 43, 31 },
  { 5935, 3, 0, 1, 0, 43, 31 },
  { 5938, 3, 0, 1, 0, 43, 31 },
  { 5941, 3, 0, 1, 0, 43, 31 },
  { 5944, 3, 0, 1, 0, 43, 31 },
  { 5947, 3, 0, 1, 0, 43, 31 },
  { 5950, 3, 0, 1, 0, 43, 31 },
  { 5953, 3, 0, 1, 0, 43, 31 },
  { 5956, 3, 0, 1, 0, 43, 31 },
  { 5959, 3, 0, 1, 0, 43, 31 },
  { 5962, 3, 0, 1, 0, 43, 31 },
  { 5965, 3, 0, 1, 0, 43, 31 },
  { 5968, 3, 0, 1, 0, 43, 31 },
  { 5971, 3, 0, 1, 0, 43, 31 },
  { 5974, 3, 0, 1, 0, 43, 31 },
  { 5977, 3, 0, 1, 0, 43, 31 },
  { 5980, 3, 0, 1, 0, 43, 31 },
  { 5983, 3, 0, 1, 0, 43, 31 },
  { 5986, 3, 0, 1, 0, 43, 31 },
  { 5989, 3, 0, 1, 0, 43, 31 },
  { 5992, 3, 0, 1, 0, 43, 31 },
  { 5995, 3, 0, 1, 0, 43, 31 },
  { 5998, 3, 0, 1, 0, 43, 31 },
  { 6001, 3, 0, 1, 0, 43, 31 },
  { 6004, 3, 0, 1, 0, 43, 31 },
  { 6007, 3, 0, 1, 0, 43, 31 },
  { 6010, 3, 0, 1, 0, 43, 31 },
  { 6013, 3, 0, 1, 0, 43, 31 },
  { 6016, 3, 0, 1, 0, 43, 31 },
  { 6019, 3, 0, 1, 0, 43, 31 },
  { 6022, 3, 0, 1, 0, 43, 31 },
  // 2188: shuffle2, 
  { 6025, 4, 0, 1, 0, 43, 31 },
  { 6029, 4, 0, 1, 0, 43, 31 },
  { 6033, 4, 0, 1, 0, 43, 31 },
  { 6037, 4, 0, 1, 0, 43, 31 },
  { 6041, 4, 0, 1, 0, 43, 31 },
  { 6045, 4, 0, 1, 0, 43, 31 },
  { 6049, 4, 0, 1, 0, 43, 31 },
  { 6053, 4, 0, 1, 0, 43, 31 },
  { 6057, 4, 0, 1, 0, 43, 31 },
  { 6061, 4, 0, 1, 0, 43, 31 },
  { 6065, 4, 0, 1, 0, 43, 31 },
  { 6069, 4, 0, 1, 0, 43, 31 },
  { 6073, 4, 0, 1, 0, 43, 31 },
  { 6077, 4, 0, 1, 0, 43, 31 },
  { 6081, 4, 0, 1, 0, 43, 31 },
  { 6085, 4, 0, 1, 0, 43, 31 },
  { 6089, 4, 0, 1, 0, 43, 31 },
  { 6093, 4, 0, 1, 0, 43, 31 },
  { 6097, 4, 0, 1, 0, 43, 31 },
  { 6101, 4, 0, 1, 0, 43, 31 },
  { 6105, 4, 0, 1, 0, 43, 31 },
  { 6109, 4, 0, 1, 0, 43, 31 },
  { 6113, 4, 0, 1, 0, 43, 31 },
  { 6117, 4, 0, 1, 0, 43, 31 },
  { 6121, 4, 0, 1, 0, 43, 31 },
  { 6125, 4, 0, 1, 0, 43, 31 },
  { 6129, 4, 0, 1, 0, 43, 31 },
  { 6133, 4, 0, 1, 0, 43, 31 },
  { 6137, 4, 0, 1, 0, 43, 31 },
  { 6141, 4, 0, 1, 0, 43, 31 },
  { 6145, 4, 0, 1, 0, 43, 31 },
  { 6149, 4, 0, 1, 0, 43, 31 },
  { 6153, 4, 0, 1, 0, 43, 31 },
  { 6157, 4, 0, 1, 0, 43, 31 },
  { 6161, 4, 0, 1, 0, 43, 31 },
  { 6165, 4, 0, 1, 0, 43, 31 },
  { 6169, 4, 0, 1, 0, 43, 31 },
  { 6173, 4, 0, 1, 0, 43, 31 },
  { 6177, 4, 0, 1, 0, 43, 31 },
  { 6181, 4, 0, 1, 0, 43, 31 },
  { 6185, 4, 0, 1, 0, 43, 31 },
  { 6189, 4, 0, 1, 0, 43, 31 },
  { 6193, 4, 0, 1, 0, 43, 31 },
  { 6197, 4, 0, 1, 0, 43, 31 },
  { 6201, 4, 0, 1, 0, 43, 31 },
  { 6205, 4, 0, 1, 0, 43, 31 },
  { 6209, 4, 0, 1, 0, 43, 31 },
  { 6213, 4, 0, 1, 0, 43, 31 },
  { 6217, 4, 0, 1, 0, 43, 31 },
  { 6221, 4, 0, 1, 0, 43, 31 },
  { 6225, 4, 0, 1, 0, 43, 31 },
  { 6229, 4, 0, 1, 0, 43, 31 },
  { 6233, 4, 0, 1, 0, 43, 31 },
  { 6237, 4, 0, 1, 0, 43, 31 },
  { 6241, 4, 0, 1, 0, 43, 31 },
  { 6245, 4, 0, 1, 0, 43, 31 },
  { 6249, 4, 0, 1, 0, 43, 31 },
  { 6253, 4, 0, 1, 0, 43, 31 },
  { 6257, 4, 0, 1, 0, 43, 31 },
  { 6261, 4, 0, 1, 0, 43, 31 },
  { 6265, 4, 0, 1, 0, 43, 31 },
  { 6269, 4, 0, 1, 0, 43, 31 },
  { 6273, 4, 0, 1, 0, 43, 31 },
  { 6277, 4, 0, 1, 0, 43, 31 },
  { 6281, 4, 0, 1, 0, 43, 31 },
  { 6285, 4, 0, 1, 0, 43, 31 },
  { 6289, 4, 0, 1, 0, 43, 31 },
  { 6293, 4, 0, 1, 0, 43, 31 },
  { 6297, 4, 0, 1, 0, 43, 31 },
  { 6301, 4, 0, 1, 0, 43, 31 },
  { 6305, 4, 0, 1, 0, 43, 31 },
  { 6309, 4, 0, 1, 0, 43, 31 },
  { 6313, 4, 0, 1, 0, 43, 31 },
  { 6317, 4, 0, 1, 0, 43, 31 },
  { 6321, 4, 0, 1, 0, 43, 31 },
  { 6325, 4, 0, 1, 0, 43, 31 },
  { 6329, 4, 0, 1, 0, 43, 31 },
  { 6333, 4, 0, 1, 0, 43, 31 },
  { 6337, 4, 0, 1, 0, 43, 31 },
  { 6341, 4, 0, 1, 0, 43, 31 },
  { 6345, 4, 0, 1, 0, 43, 31 },
  { 6349, 4, 0, 1, 0, 43, 31 },
  { 6353, 4, 0, 1, 0, 43, 31 },
  { 6357, 4, 0, 1, 0, 43, 31 },
  { 6361, 4, 0, 1, 0, 43, 31 },
  { 6365, 4, 0, 1, 0, 43, 31 },
  { 6369, 4, 0, 1, 0, 43, 31 },
  { 6373, 4, 0, 1, 0, 43, 31 },
  { 6377, 4, 0, 1, 0, 43, 31 },
  { 6381, 4, 0, 1, 0, 43, 31 },
  { 6385, 4, 0, 1, 0, 43, 31 },
  { 6389, 4, 0, 1, 0, 43, 31 },
  { 6393, 4, 0, 1, 0, 43, 31 },
  { 6397, 4, 0, 1, 0, 43, 31 },
  { 6401, 4, 0, 1, 0, 43, 31 },
  { 6405, 4, 0, 1, 0, 43, 31 },
  { 6409, 4, 0, 1, 0, 43, 31 },
  { 6413, 4, 0, 1, 0, 43, 31 },
  { 6417, 4, 0, 1, 0, 43, 31 },
  { 6421, 4, 0, 1, 0, 43, 31 },
  { 6425, 4, 0, 1, 0, 43, 31 },
  { 6429, 4, 0, 1, 0, 43, 31 },
  { 6433, 4, 0, 1, 0, 43, 31 },
  { 6437, 4, 0, 1, 0, 43, 31 },
  { 6441, 4, 0, 1, 0, 43, 31 },
  { 6445, 4, 0, 1, 0, 43, 31 },
  { 6449, 4, 0, 1, 0, 43, 31 },
  { 6453, 4, 0, 1, 0, 43, 31 },
  { 6457, 4, 0, 1, 0, 43, 31 },
  { 6461, 4, 0, 1, 0, 43, 31 },
  { 6465, 4, 0, 1, 0, 43, 31 },
  { 6469, 4, 0, 1, 0, 43, 31 },
  { 6473, 4, 0, 1, 0, 43, 31 },
  { 6477, 4, 0, 1, 0, 43, 31 },
  { 6481, 4, 0, 1, 0, 43, 31 },
  { 6485, 4, 0, 1, 0, 43, 31 },
  { 6489, 4, 0, 1, 0, 43, 31 },
  { 6493, 4, 0, 1, 0, 43, 31 },
  { 6497, 4, 0, 1, 0, 43, 31 },
  { 6501, 4, 0, 1, 0, 43, 31 },
  { 6505, 4, 0, 1, 0, 43, 31 },
  { 6509, 4, 0, 1, 0, 43, 31 },
  { 6513, 4, 0, 1, 0, 43, 31 },
  { 6517, 4, 0, 1, 0, 43, 31 },
  { 6521, 4, 0, 1, 0, 43, 31 },
  { 6525, 4, 0, 1, 0, 43, 31 },
  { 6529, 4, 0, 1, 0, 43, 31 },
  { 6533, 4, 0, 1, 0, 43, 31 },
  { 6537, 4, 0, 1, 0, 43, 31 },
  { 6541, 4, 0, 1, 0, 43, 31 },
  { 6545, 4, 0, 1, 0, 43, 31 },
  { 6549, 4, 0, 1, 0, 43, 31 },
  { 6553, 4, 0, 1, 0, 43, 31 },
  { 6557, 4, 0, 1, 0, 43, 31 },
  { 6561, 4, 0, 1, 0, 43, 31 },
  { 6565, 4, 0, 1, 0, 43, 31 },
  { 6569, 4, 0, 1, 0, 43, 31 },
  { 6575, 4, 0, 1, 0, 43, 31 },
  { 6579, 4, 0, 1, 0, 43, 31 },
  { 6583, 4, 0, 1, 0, 43, 31 },
  { 6587, 4, 0, 1, 0, 43, 31 },
  { 6591, 4, 0, 1, 0, 43, 31 },
  { 6595, 4, 0, 1, 0, 43, 31 },
  { 6599, 4, 0, 1, 0, 43, 31 },
  { 6603, 4, 0, 1, 0, 43, 31 },
  { 6607, 4, 0, 1, 0, 43, 31 },
  { 6611, 4, 0, 1, 0, 43, 31 },
  { 6617, 4, 0, 1, 0, 43, 31 },
  { 6621, 4, 0, 1, 0, 43, 31 },
  { 6625, 4, 0, 1, 0, 43, 31 },
  { 6629, 4, 0, 1, 0, 43, 31 },
  { 6633, 4, 0, 1, 0, 43, 31 },
  { 6637, 4, 0, 1, 0, 43, 31 },
  { 6641, 4, 0, 1, 0, 43, 31 },
  { 6645, 4, 0, 1, 0, 43, 31 },
  { 6649, 4, 0, 1, 0, 43, 31 },
  { 6653, 4, 0, 1, 0, 43, 31 },
  { 6659, 4, 0, 1, 0, 43, 31 },
  { 6663, 4, 0, 1, 0, 43, 31 },
  { 6667, 4, 0, 1, 0, 43, 31 },
  { 6671, 4, 0, 1, 0, 43, 31 },
  { 6675, 4, 0, 1, 0, 43, 31 },
  { 6679, 4, 0, 1, 0, 43, 31 },
  { 6683, 4, 0, 1, 0, 43, 31 },
  { 6687, 4, 0, 1, 0, 43, 31 },
  { 6691, 4, 0, 1, 0, 43, 31 },
  { 6695, 4, 0, 1, 0, 43, 31 },
  { 6701, 4, 0, 1, 0, 43, 31 },
  { 6705, 4, 0, 1, 0, 43, 31 },
  { 6709, 4, 0, 1, 0, 43, 31 },
  { 6713, 4, 0, 1, 0, 43, 31 },
  { 6717, 4, 0, 1, 0, 43, 31 },
  { 6721, 4, 0, 1, 0, 43, 31 },
  { 6725, 4, 0, 1, 0, 43, 31 },
  { 6729, 4, 0, 1, 0, 43, 31 },
  { 6733, 4, 0, 1, 0, 43, 31 },
  // 2364: read_imagef, 
  { 6737, 4, 1, 0, 0, 43, 31 },
  { 6751, 4, 1, 0, 0, 43, 31 },
  { 6763, 4, 1, 0, 0, 43, 31 },
  { 6777, 4, 1, 0, 0, 43, 31 },
  { 6789, 4, 1, 0, 0, 43, 31 },
  { 6801, 4, 1, 0, 0, 43, 31 },
  { 6813, 4, 1, 0, 0, 43, 31 },
  { 6825, 4, 1, 0, 0, 43, 31 },
  { 6837, 4, 1, 0, 0, 43, 31 },
  { 6849, 4, 1, 0, 0, 43, 31 },
  { 6861, 4, 1, 0, 0, 43, 31 },
  { 6865, 4, 1, 0, 0, 43, 31 },
  { 6869, 4, 1, 0, 0, 43, 31 },
  { 6873, 4, 1, 0, 0, 43, 31 },
  { 6877, 3, 1, 0, 0, 43, 28 },
  { 6886, 3, 1, 0, 0, 43, 28 },
  { 6895, 3, 1, 0, 0, 43, 28 },
  { 6904, 3, 1, 0, 0, 43, 28 },
  { 6907, 3, 1, 0, 0, 43, 28 },
  { 6910, 3, 1, 0, 0, 43, 28 },
  { 6919, 3, 1, 0, 0, 43, 28 },
  { 6928, 3, 1, 0, 0, 43, 28 },
  { 6937, 3, 1, 0, 0, 48, 28 },
  { 6946, 3, 1, 0, 0, 48, 28 },
  { 6955, 3, 1, 0, 0, 48, 28 },
  { 6964, 3, 1, 0, 0, 48, 28 },
  { 6973, 3, 1, 0, 0, 48, 28 },
  { 6982, 3, 1, 0, 0, 48, 28 },
  { 6991, 3, 1, 0, 0, 48, 28 },
  { 6994, 3, 1, 0, 0, 48, 28 },
  { 7441, 5, 1, 0, 0, 33, 31 },
  { 7446, 6, 1, 0, 0, 33, 31 },
  { 7474, 5, 1, 0, 0, 33, 31 },
  { 7479, 6, 1, 0, 0, 33, 31 },
  { 7485, 5, 1, 0, 0, 33, 31 },
  { 7490, 6, 1, 0, 0, 33, 31 },
  { 7518, 6, 1, 0, 0, 33, 31 },
  { 7524, 5, 1, 0, 0, 33, 31 },
  { 7551, 5, 1, 0, 0, 33, 31 },
  { 7556, 6, 1, 0, 0, 33, 31 },
  { 7584, 5, 1, 0, 0, 33, 31 },
  { 7589, 6, 1, 0, 0, 33, 31 },
  { 7617, 5, 1, 0, 0, 33, 31 },
  { 7622, 6, 1, 0, 0, 33, 31 },
  { 7713, 4, 1, 0, 0, 26, 31 },
  { 7725, 4, 1, 0, 0, 26, 31 },
  { 7737, 4, 1, 0, 0, 26, 31 },
  { 7741, 4, 1, 0, 0, 26, 31 },
  { 7785, 4, 1, 0, 0, 26, 31 },
  { 7797, 4, 1, 0, 0, 26, 31 },
  { 7809, 4, 1, 0, 0, 26, 31 },
  { 7813, 4, 1, 0, 0, 26, 31 },
  // 2416: read_imagei, 
  { 6743, 4, 1, 0, 0, 43, 31 },
  { 6755, 4, 1, 0, 0, 43, 31 },
  { 6767, 4, 1, 0, 0, 43, 31 },
  { 6781, 4, 1, 0, 0, 43, 31 },
  { 6793, 4, 1, 0, 0, 43, 31 },
  { 6805, 4, 1, 0, 0, 43, 31 },
  { 6817, 4, 1, 0, 0, 43, 31 },
  { 6829, 4, 1, 0, 0, 43, 31 },
  { 6841, 4, 1, 0, 0, 43, 31 },
  { 6853, 4, 1, 0, 0, 43, 31 },
  { 6880, 3, 1, 0, 0, 43, 28 },
  { 6889, 3, 1, 0, 0, 43, 28 },
  { 6898, 3, 1, 0, 0, 43, 28 },
  { 6913, 3, 1, 0, 0, 43, 28 },
  { 6922, 3, 1, 0, 0, 43, 28 },
  { 6931, 3, 1, 0, 0, 43, 28 },
  { 6940, 3, 1, 0, 0, 48, 28 },
  { 6949, 3, 1, 0, 0, 48, 28 },
  { 6958, 3, 1, 0, 0, 48, 28 },
  { 6967, 3, 1, 0, 0, 48, 28 },
  { 6976, 3, 1, 0, 0, 48, 28 },
  { 6985, 3, 1, 0, 0, 48, 28 },
  { 7452, 5, 1, 0, 0, 33, 31 },
  { 7457, 6, 1, 0, 0, 33, 31 },
  { 7496, 5, 1, 0, 0, 33, 31 },
  { 7501, 6, 1, 0, 0, 33, 31 },
  { 7529, 6, 1, 0, 0, 33, 31 },
  { 7535, 5, 1, 0, 0, 33, 31 },
  { 7562, 5, 1, 0, 0, 33, 31 },
  { 7567, 6, 1, 0, 0, 33, 31 },
  { 7595, 5, 1, 0, 0, 33, 31 },
  { 7600, 6, 1, 0, 0, 33, 31 },
  { 7717, 4, 1, 0, 0, 26, 31 },
  { 7729, 4, 1, 0, 0, 26, 31 },
  { 7789, 4, 1, 0, 0, 26, 31 },
  { 7801, 4, 1, 0, 0, 26, 31 },
  // 2452: read_imageui, 
  { 6747, 4, 1, 0, 0, 43, 31 },
  { 6759, 4, 1, 0, 0, 43, 31 },
  { 6771, 4, 1, 0, 0, 43, 31 },
  { 6785, 4, 1, 0, 0, 43, 31 },
  { 6797, 4, 1, 0, 0, 43, 31 },
  { 6809, 4, 1, 0, 0, 43, 31 },
  { 6821, 4, 1, 0, 0, 43, 31 },
  { 6833, 4, 1, 0, 0, 43, 31 },
  { 6845, 4, 1, 0, 0, 43, 31 },
  { 6857, 4, 1, 0, 0, 43, 31 },
  { 6883, 3, 1, 0, 0, 43, 28 },
  { 6892, 3, 1, 0, 0, 43, 28 },
  { 6901, 3, 1, 0, 0, 43, 28 },
  { 6916, 3, 1, 0, 0, 43, 28 },
  { 6925, 3, 1, 0, 0, 43, 28 },
  { 6934, 3, 1, 0, 0, 43, 28 },
  { 6943, 3, 1, 0, 0, 48, 28 },
  { 6952, 3, 1, 0, 0, 48, 28 },
  { 6961, 3, 1, 0, 0, 48, 28 },
  { 6970, 3, 1, 0, 0, 48, 28 },
  { 6979, 3, 1, 0, 0, 48, 28 },
  { 6988, 3, 1, 0, 0, 48, 28 },
  { 7463, 5, 1, 0, 0, 33, 31 },
  { 7468, 6, 1, 0, 0, 33, 31 },
  { 7507, 5, 1, 0, 0, 33, 31 },
  { 7512, 6, 1, 0, 0, 33, 31 },
  { 7540, 6, 1, 0, 0, 33, 31 },
  { 7546, 5, 1, 0, 0, 33, 31 },
  { 7573, 5, 1, 0, 0, 33, 31 },
  { 7578, 6, 1, 0, 0, 33, 31 },
  { 7606, 5, 1, 0, 0, 33, 31 },
  { 7611, 6, 1, 0, 0, 33, 31 },
  { 7721, 4, 1, 0, 0, 26, 31 },
  { 7733, 4, 1, 0, 0, 26, 31 },
  { 7793, 4, 1, 0, 0, 26, 31 },
  { 7805, 4, 1, 0, 0, 26, 31 },
  // 2488: write_imagef, 
  { 6997, 4, 0, 0, 0, 43, 31 },
  { 7009, 4, 0, 0, 0, 43, 31 },
  { 7021, 4, 0, 0, 0, 43, 31 },
  { 7033, 4, 0, 0, 0, 43, 31 },
  { 7045, 4, 0, 0, 0, 43, 31 },
  { 7057, 4, 0, 0, 0, 43, 31 },
  { 7061, 4, 0, 0, 0, 43, 31 },
  { 7065, 4, 0, 0, 0, 43, 31 },
  { 7077, 4, 0, 0, 0, 48, 31 },
  { 7089, 4, 0, 0, 0, 48, 31 },
  { 7101, 4, 0, 0, 0, 48, 31 },
  { 7113, 4, 0, 0, 0, 48, 31 },
  { 7125, 4, 0, 0, 0, 48, 31 },
  { 7137, 4, 0, 0, 0, 48, 31 },
  { 7149, 4, 0, 0, 0, 48, 31 },
  { 7153, 4, 0, 0, 0, 48, 31 },
  { 7628, 5, 0, 0, 0, 34, 31 },
  { 7643, 5, 0, 0, 0, 34, 31 },
  { 7648, 5, 0, 0, 0, 34, 31 },
  { 7663, 5, 0, 0, 0, 34, 31 },
  { 7678, 5, 0, 0, 0, 34, 31 },
  { 7693, 5, 0, 0, 0, 34, 31 },
  { 7698, 5, 0, 0, 0, 34, 31 },
  // 2511: write_imagei, 
  { 7001, 4, 0, 0, 0, 43, 31 },
  { 7013, 4, 0, 0, 0, 43, 31 },
  { 7025, 4, 0, 0, 0, 43, 31 },
  { 7037, 4, 0, 0, 0, 43, 31 },
  { 7049, 4, 0, 0, 0, 43, 31 },
  { 7069, 4, 0, 0, 0, 43, 31 },
  { 7081, 4, 0, 0, 0, 48, 31 },
  { 7093, 4, 0, 0, 0, 48, 31 },
  { 7105, 4, 0, 0, 0, 48, 31 },
  { 7117, 4, 0, 0, 0, 48, 31 },
  { 7129, 4, 0, 0, 0, 48, 31 },
  { 7141, 4, 0, 0, 0, 48, 31 },
  { 7633, 5, 0, 0, 0, 34, 31 },
  { 7653, 5, 0, 0, 0, 34, 31 },
  { 7668, 5, 0, 0, 0, 34, 31 },
  { 7683, 5, 0, 0, 0, 34, 31 },
  { 7703, 5, 0, 0, 0, 34, 31 },
  // 2528: write_imageui, 
  { 7005, 4, 0, 0, 0, 43, 31 },
  { 7017, 4, 0, 0, 0, 43, 31 },
  { 7029, 4, 0, 0, 0, 43, 31 },
  { 7041, 4, 0, 0, 0, 43, 31 },
  { 7053, 4, 0, 0, 0, 43, 31 },
  { 7073, 4, 0, 0, 0, 43, 31 },
  { 7085, 4, 0, 0, 0, 48, 31 },
  { 7097, 4, 0, 0, 0, 48, 31 },
  { 7109, 4, 0, 0, 0, 48, 31 },
  { 7121, 4, 0, 0, 0, 48, 31 },
  { 7133, 4, 0, 0, 0, 48, 31 },
  { 7145, 4, 0, 0, 0, 48, 31 },
  { 7638, 5, 0, 0, 0, 34, 31 },
  { 7658, 5, 0, 0, 0, 34, 31 },
  { 7673, 5, 0, 0, 0, 34, 31 },
  { 7688, 5, 0, 0, 0, 34, 31 },
  { 7708, 5, 0, 0, 0, 34, 31 },
  // 2545: get_image_width, get_image_channel_data_type, get_image_channel_order, 
  { 7157, 2, 0, 1, 0, 43, 31 },
  { 7169, 2, 0, 1, 0, 43, 31 },
  { 7159, 2, 0, 1, 0, 43, 31 },
  { 7161, 2, 0, 1, 0, 43, 31 },
  { 7171, 2, 0, 1, 0, 43, 31 },
  { 7173, 2, 0, 1, 0, 43, 31 },
  { 7175, 2, 0, 1, 0, 43, 31 },
  { 7177, 2, 0, 1, 0, 43, 31 },
  { 7189, 2, 0, 1, 0, 43, 31 },
  { 7191, 2, 0, 1, 0, 43, 31 },
  { 7193, 2, 0, 1, 0, 43, 31 },
  { 7195, 2, 0, 1, 0, 43, 31 },
  { 7197, 2, 0, 1, 0, 43, 31 },
  { 7199, 2, 0, 1, 0, 43, 31 },
  { 7201, 2, 0, 1, 0, 43, 31 },
  { 7203, 2, 0, 1, 0, 43, 31 },
  { 7221, 2, 0, 1, 0, 48, 31 },
  { 7223, 2, 0, 1, 0, 48, 31 },
  { 7225, 2, 0, 1, 0, 48, 31 },
  { 7227, 2, 0, 1, 0, 48, 31 },
  { 7229, 2, 0, 1, 0, 48, 31 },
  { 7231, 2, 0, 1, 0, 48, 31 },
  { 7235, 2, 0, 1, 0, 48, 31 },
  { 7237, 2, 0, 1, 0, 48, 31 },
  { 7745, 2, 0, 1, 0, 26, 31 },
  { 7751, 2, 0, 1, 0, 26, 31 },
  { 7755, 2, 0, 1, 0, 26, 31 },
  { 7759, 2, 0, 1, 0, 26, 31 },
  { 7765, 2, 0, 1, 0, 26, 31 },
  { 7769, 2, 0, 1, 0, 26, 31 },
  { 7773, 2, 0, 1, 0, 26, 31 },
  { 7777, 2, 0, 1, 0, 26, 31 },
  { 7817, 2, 0, 1, 0, 26, 31 },
  { 7821, 2, 0, 1, 0, 26, 31 },
  { 7825, 2, 0, 1, 0, 26, 31 },
  { 7829, 2, 0, 1, 0, 26, 31 },
  // 2581: get_image_height, 
  { 7159, 2, 0, 1, 0, 43, 31 },
  { 7161, 2, 0, 1, 0, 43, 31 },
  { 7173, 2, 0, 1, 0, 43, 31 },
  { 7175, 2, 0, 1, 0, 43, 31 },
  { 7177, 2, 0, 1, 0, 43, 31 },
  { 7193, 2, 0, 1, 0, 43, 31 },
  { 7195, 2, 0, 1, 0, 43, 31 },
  { 7199, 2, 0, 1, 0, 43, 31 },
  { 7201, 2, 0, 1, 0, 43, 31 },
  { 7203, 2, 0, 1, 0, 43, 31 },
  { 7225, 2, 0, 1, 0, 48, 31 },
  { 7227, 2, 0, 1, 0, 48, 31 },
  { 7231, 2, 0, 1, 0, 48, 31 },
  { 7235, 2, 0, 1, 0, 48, 31 },
  { 7237, 2, 0, 1, 0, 48, 31 },
  { 7745, 2, 0, 1, 0, 26, 31 },
  { 7751, 2, 0, 1, 0, 26, 31 },
  { 7755, 2, 0, 1, 0, 26, 31 },
  { 7759, 2, 0, 1, 0, 26, 31 },
  { 7765, 2, 0, 1, 0, 26, 31 },
  { 7769, 2, 0, 1, 0, 26, 31 },
  { 7773, 2, 0, 1, 0, 26, 31 },
  { 7777, 2, 0, 1, 0, 26, 31 },
  { 7817, 2, 0, 1, 0, 26, 31 },
  { 7821, 2, 0, 1, 0, 26, 31 },
  { 7825, 2, 0, 1, 0, 26, 31 },
  { 7829, 2, 0, 1, 0, 26, 31 },
  // 2608: get_image_depth, 
  { 7161, 2, 0, 1, 0, 43, 31 },
  { 7195, 2, 0, 1, 0, 43, 31 },
  { 7227, 2, 0, 1, 0, 48, 31 },
  // 2611: get_image_dim, 
  { 7163, 2, 0, 1, 0, 43, 31 },
  { 7165, 2, 0, 1, 0, 43, 31 },
  { 7179, 2, 0, 1, 0, 43, 31 },
  { 7181, 2, 0, 1, 0, 43, 31 },
  { 7183, 2, 0, 1, 0, 43, 31 },
  { 7205, 2, 0, 1, 0, 43, 31 },
  { 7207, 2, 0, 1, 0, 43, 31 },
  { 7209, 2, 0, 1, 0, 43, 31 },
  { 7211, 2, 0, 1, 0, 43, 31 },
  { 7213, 2, 0, 1, 0, 43, 31 },
  { 7241, 2, 0, 1, 0, 48, 31 },
  { 7243, 2, 0, 1, 0, 48, 31 },
  { 7245, 2, 0, 1, 0, 48, 31 },
  { 7247, 2, 0, 1, 0, 48, 31 },
  { 7249, 2, 0, 1, 0, 48, 31 },
  { 7747, 2, 0, 1, 0, 26, 31 },
  { 7753, 2, 0, 1, 0, 26, 31 },
  { 7757, 2, 0, 1, 0, 26, 31 },
  { 7761, 2, 0, 1, 0, 26, 31 },
  { 7767, 2, 0, 1, 0, 26, 31 },
  { 7771, 2, 0, 1, 0, 26, 31 },
  { 7775, 2, 0, 1, 0, 26, 31 },
  { 7779, 2, 0, 1, 0, 26, 31 },
  { 7819, 2, 0, 1, 0, 26, 31 },
  { 7823, 2, 0, 1, 0, 26, 31 },
  { 7827, 2, 0, 1, 0, 26, 31 },
  { 7831, 2, 0, 1, 0, 26, 31 },
  // 2638: get_image_array_size, 
  { 7167, 2, 0, 1, 0, 43, 31 },
  { 7185, 2, 0, 1, 0, 43, 31 },
  { 7187, 2, 0, 1, 0, 43, 31 },
  { 7215, 2, 0, 1, 0, 43, 31 },
  { 7217, 2, 0, 1, 0, 43, 31 },
  { 7219, 2, 0, 1, 0, 43, 31 },
  { 7251, 2, 0, 1, 0, 48, 31 },
  { 7255, 2, 0, 1, 0, 48, 31 },
  { 7257, 2, 0, 1, 0, 48, 31 },
  { 7749, 2, 0, 1, 0, 26, 31 },
  { 7763, 2, 0, 1, 0, 26, 31 },
  { 7781, 2, 0, 1, 0, 26, 31 },
  { 7783, 2, 0, 1, 0, 26, 31 },
  { 7833, 2, 0, 1, 0, 26, 31 },
  { 7835, 2, 0, 1, 0, 26, 31 },
  // 2653: read_imageh, 
  { 7259, 4, 1, 0, 0, 43, 31 },
  { 7263, 4, 1, 0, 0, 43, 31 },
  { 7267, 4, 1, 0, 0, 43, 31 },
  { 7271, 4, 1, 0, 0, 43, 31 },
  { 7275, 4, 1, 0, 0, 43, 31 },
  { 7279, 4, 1, 0, 0, 43, 31 },
  { 7283, 4, 1, 0, 0, 43, 31 },
  { 7287, 4, 1, 0, 0, 43, 31 },
  { 7293, 4, 1, 0, 0, 43, 31 },
  { 7297, 4, 1, 0, 0, 43, 31 },
  { 7301, 3, 1, 0, 0, 43, 28 },
  { 7304, 3, 1, 0, 0, 43, 28 },
  { 7307, 3, 1, 0, 0, 43, 28 },
  { 7310, 3, 1, 0, 0, 43, 28 },
  { 7313, 3, 1, 0, 0, 43, 28 },
  { 7316, 3, 1, 0, 0, 43, 28 },
  { 7321, 3, 1, 0, 0, 48, 28 },
  { 7324, 3, 1, 0, 0, 48, 28 },
  { 7327, 3, 1, 0, 0, 48, 28 },
  { 7330, 3, 1, 0, 0, 48, 28 },
  { 7333, 3, 1, 0, 0, 48, 28 },
  { 7336, 3, 1, 0, 0, 48, 28 },
  // 2675: write_imageh, 
  { 7339, 4, 0, 0, 0, 43, 31 },
  { 7343, 4, 0, 0, 0, 43, 31 },
  { 7347, 4, 0, 0, 0, 43, 31 },
  { 7351, 4, 0, 0, 0, 43, 31 },
  { 7357, 4, 0, 0, 0, 43, 31 },
  { 7361, 4, 0, 0, 0, 43, 31 },
  { 7365, 4, 0, 0, 0, 48, 31 },
  { 7369, 4, 0, 0, 0, 48, 31 },
  { 7373, 4, 0, 0, 0, 48, 31 },
  { 7377, 4, 0, 0, 0, 48, 31 },
  { 7381, 4, 0, 0, 0, 48, 31 },
  { 7385, 4, 0, 0, 0, 48, 31 },
  // 2687: work_group_all, work_group_any, 
  { 8, 2, 0, 0, 1, 49, 31 },
  // 2688: work_group_broadcast, 
  { 7389, 3, 0, 0, 1, 49, 31 },
  { 7392, 4, 0, 0, 1, 49, 31 },
  { 7396, 5, 0, 0, 1, 49, 31 },
  // 2691: work_group_reduce_add, work_group_scan_exclusive_add, work_group_scan_inclusive_add, work_group_reduce_min, work_group_scan_exclusive_min, work_group_scan_inclusive_min, work_group_reduce_max, work_group_scan_exclusive_max, work_group_scan_inclusive_max, 
  { 7401, 2, 0, 0, 1, 49, 31 },
  // 2692: is_valid_reserve_id, 
  { 7403, 2, 0, 0, 0, 47, 31 },
  // 2693: enqueue_marker, 
  { 7405, 5, 0, 0, 0, 44, 31 },
  // 2694: retain_event, release_event, 
  { 7410, 2, 0, 0, 0, 44, 31 },
  // 2695: create_user_event, 
  { 7412, 1, 0, 0, 0, 44, 31 },
  // 2696: is_valid_event, 
  { 7413, 2, 0, 0, 0, 44, 31 },
  // 2697: set_user_event_status, 
  { 7415, 3, 0, 0, 0, 44, 31 },
  // 2698: capture_event_profiling_info, 
  { 7418, 4, 0, 0, 0, 44, 31 },
  // 2699: get_default_queue, 
  { 7422, 1, 0, 0, 0, 44, 31 },
  // 2700: ndrange_1D, 
  { 7423, 2, 0, 0, 0, 44, 31 },
  { 7425, 3, 0, 0, 0, 44, 31 },
  { 7428, 4, 0, 0, 0, 44, 31 },
  // 2703: ndrange_2D, ndrange_3D, 
  { 7432, 2, 0, 0, 0, 44, 31 },
  { 7434, 3, 0, 0, 0, 44, 31 },
  { 7437, 4, 0, 0, 0, 44, 31 },
  // 2706: get_image_num_mip_levels, 
  { 7157, 2, 0, 0, 0, 33, 31 },
  { 7159, 2, 0, 0, 0, 33, 31 },
  { 7161, 2, 0, 0, 0, 33, 31 },
  { 7171, 2, 0, 0, 0, 33, 31 },
  { 7173, 2, 0, 0, 0, 33, 31 },
  { 7175, 2, 0, 0, 0, 33, 31 },
  { 7177, 2, 0, 0, 0, 33, 31 },
  { 7189, 2, 0, 0, 0, 33, 31 },
  { 7193, 2, 0, 0, 0, 33, 31 },
  { 7195, 2, 0, 0, 0, 33, 31 },
  { 7197, 2, 0, 0, 0, 33, 31 },
  { 7199, 2, 0, 0, 0, 33, 31 },
  { 7201, 2, 0, 0, 0, 33, 31 },
  { 7203, 2, 0, 0, 0, 33, 31 },
  { 7221, 2, 0, 0, 0, 33, 31 },
  { 7225, 2, 0, 0, 0, 33, 31 },
  { 7227, 2, 0, 0, 0, 33, 31 },
  { 7229, 2, 0, 0, 0, 33, 31 },
  { 7231, 2, 0, 0, 0, 33, 31 },
  { 7235, 2, 0, 0, 0, 33, 31 },
  { 7237, 2, 0, 0, 0, 33, 31 },
  // 2727: get_image_num_samples, 
  { 7745, 2, 0, 1, 0, 26, 31 },
  { 7751, 2, 0, 1, 0, 26, 31 },
  { 7755, 2, 0, 1, 0, 26, 31 },
  { 7759, 2, 0, 1, 0, 26, 31 },
  { 7765, 2, 0, 1, 0, 26, 31 },
  { 7769, 2, 0, 1, 0, 26, 31 },
  { 7773, 2, 0, 1, 0, 26, 31 },
  { 7777, 2, 0, 1, 0, 26, 31 },
  { 7817, 2, 0, 1, 0, 26, 31 },
  { 7821, 2, 0, 1, 0, 26, 31 },
  { 7825, 2, 0, 1, 0, 26, 31 },
  { 7829, 2, 0, 1, 0, 26, 31 },
  // 2739: get_sub_group_size, get_max_sub_group_size, get_num_sub_groups, get_sub_group_id, get_sub_group_local_id, 
  { 1411, 1, 0, 0, 0, 42, 31 },
  // 2740: get_enqueued_num_sub_groups, 
  { 1411, 1, 0, 0, 0, 42, 24 },
  // 2741: sub_group_barrier, 
  { 3803, 2, 0, 0, 1, 42, 31 },
  { 3805, 3, 0, 0, 1, 42, 24 },
  // 2743: sub_group_all, sub_group_any, 
  { 8, 2, 0, 0, 1, 42, 31 },
  // 2744: sub_group_broadcast, 
  { 7837, 3, 0, 0, 1, 42, 31 },
  { 7840, 3, 0, 0, 1, 37, 31 },
  { 7843, 3, 0, 0, 1, 37, 31 },
  // 2747: sub_group_reduce_add, sub_group_reduce_min, sub_group_reduce_max, sub_group_scan_exclusive_add, sub_group_scan_exclusive_min, sub_group_scan_exclusive_max, sub_group_scan_inclusive_add, sub_group_scan_inclusive_min, sub_group_scan_inclusive_max, 
  { 7401, 2, 0, 0, 1, 42, 31 },
  { 7846, 2, 0, 0, 1, 37, 31 },
  // 2749: sub_group_elect, 
  { 7848, 1, 0, 0, 0, 39, 31 },
  // 2750: sub_group_non_uniform_all, sub_group_non_uniform_any, 
  { 8, 2, 0, 0, 0, 39, 31 },
  // 2751: sub_group_non_uniform_all_equal, 
  { 7849, 2, 0, 0, 0, 39, 31 },
  // 2752: sub_group_non_uniform_broadcast, 
  { 7851, 3, 0, 0, 0, 35, 31 },
  // 2753: sub_group_broadcast_first, 
  { 4, 2, 0, 0, 0, 35, 31 },
  // 2754: sub_group_ballot, 
  { 7854, 2, 0, 0, 0, 35, 31 },
  // 2755: sub_group_inverse_ballot, 
  { 7856, 2, 0, 1, 0, 35, 31 },
  // 2756: sub_group_ballot_bit_extract, 
  { 7858, 3, 0, 1, 0, 35, 31 },
  // 2757: sub_group_ballot_bit_count, 
  { 7861, 2, 0, 1, 0, 35, 31 },
  // 2758: sub_group_ballot_inclusive_scan, sub_group_ballot_exclusive_scan, sub_group_ballot_find_lsb, sub_group_ballot_find_msb, 
  { 7861, 2, 0, 0, 0, 35, 31 },
  // 2759: get_sub_group_eq_mask, get_sub_group_ge_mask, get_sub_group_gt_mask, get_sub_group_le_mask, get_sub_group_lt_mask, 
  { 7863, 1, 0, 1, 0, 35, 31 },
};


// Find out whether a string matches an existing OpenCL builtin function name.
// Returns: A pair <0, 0> if no name matches.
//          A pair <Index, Len> indexing the BuiltinTable if the name is
//          matching an OpenCL builtin function.
static std::pair<unsigned, unsigned> isOpenCLBuiltin(llvm::StringRef Name) {

  switch (Name.size()) {
  default: break;
  case 3:	 // 19 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (Name[2] != 's')
          break;
        return std::make_pair(828, 1);	 // "abs"
      case 'l':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return std::make_pair(892, 1);	 // "all"
      case 'n':	 // 1 string to match.
        if (Name[2] != 'y')
          break;
        return std::make_pair(892, 1);	 // "any"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (Name[2] != 'z')
          break;
        return std::make_pair(829, 1);	 // "clz"
      case 'o':	 // 1 string to match.
        if (Name[2] != 's')
          break;
        return std::make_pair(776, 1);	 // "cos"
      case 't':	 // 1 string to match.
        if (Name[2] != 'z')
          break;
        return std::make_pair(831, 1);	 // "ctz"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ot", 2) != 0)
        break;
      return std::make_pair(81, 7);	 // "dot"
    case 'e':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (Name[2] != 'f')
          break;
        return std::make_pair(776, 1);	 // "erf"
      case 'x':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return std::make_pair(776, 1);	 // "exp"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ma", 2) != 0)
        break;
      return std::make_pair(797, 1);	 // "fma"
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+1, "og", 2) != 0)
        break;
      return std::make_pair(776, 1);	 // "log"
    case 'm':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'd':	 // 1 string to match.
          return std::make_pair(797, 1);	 // "mad"
        case 'x':	 // 1 string to match.
          return std::make_pair(834, 6);	 // "max"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'n':	 // 1 string to match.
          return std::make_pair(834, 6);	 // "min"
        case 'x':	 // 1 string to match.
          return std::make_pair(861, 4);	 // "mix"
        }
        break;
      }
      break;
    case 'n':	 // 1 string to match.
      if (memcmp(Name.data()+1, "an", 2) != 0)
        break;
      return std::make_pair(777, 3);	 // "nan"
    case 'p':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ow", 2) != 0)
        break;
      return std::make_pair(780, 1);	 // "pow"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "in", 2) != 0)
        break;
      return std::make_pair(776, 1);	 // "sin"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "an", 2) != 0)
        break;
      return std::make_pair(776, 1);	 // "tan"
    }
    break;
  case 4:	 // 25 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+2, "os", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "acos"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "in", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "asin"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+2, "an", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "atan"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+2, "rt", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "cbrt"
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "il", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "ceil"
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+2, "sh", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "cosh"
      }
      break;
    case 'e':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "fc", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "erfc"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+2, "p2", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "exp2"
      }
      break;
    case 'f':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+2, "bs", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "fabs"
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+2, "im", 2) != 0)
          break;
        return std::make_pair(780, 1);	 // "fdim"
      case 'm':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Name[3] != 'x')
            break;
          return std::make_pair(781, 4);	 // "fmax"
        case 'i':	 // 1 string to match.
          if (Name[3] != 'n')
            break;
          return std::make_pair(781, 4);	 // "fmin"
        case 'o':	 // 1 string to match.
          if (Name[3] != 'd')
            break;
          return std::make_pair(780, 1);	 // "fmod"
        }
        break;
      }
      break;
    case 'h':	 // 1 string to match.
      if (memcmp(Name.data()+1, "add", 3) != 0)
        break;
      return std::make_pair(833, 1);	 // "hadd"
    case 'l':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "og", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '2':	 // 1 string to match.
        return std::make_pair(776, 1);	 // "log2"
      case 'b':	 // 1 string to match.
        return std::make_pair(776, 1);	 // "logb"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(Name.data()+1, "odf", 3) != 0)
        break;
      return std::make_pair(798, 4);	 // "modf"
    case 'p':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ow", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case 'n':	 // 1 string to match.
        return std::make_pair(794, 3);	 // "pown"
      case 'r':	 // 1 string to match.
        return std::make_pair(780, 1);	 // "powr"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "int", 3) != 0)
        break;
      return std::make_pair(776, 1);	 // "rint"
    case 's':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'g':	 // 1 string to match.
          if (Name[3] != 'n')
            break;
          return std::make_pair(776, 1);	 // "sign"
        case 'n':	 // 1 string to match.
          if (Name[3] != 'h')
            break;
          return std::make_pair(776, 1);	 // "sinh"
        }
        break;
      case 'q':	 // 1 string to match.
        if (memcmp(Name.data()+2, "rt", 2) != 0)
          break;
        return std::make_pair(776, 1);	 // "sqrt"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ep", 2) != 0)
          break;
        return std::make_pair(857, 4);	 // "step"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "anh", 3) != 0)
        break;
      return std::make_pair(776, 1);	 // "tanh"
    }
    break;
  case 5:	 // 28 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+2, "osh", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "acosh"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "inh", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "asinh"
      case 't':	 // 2 strings to match.
        if (memcmp(Name.data()+2, "an", 2) != 0)
          break;
        switch (Name[4]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(780, 1);	 // "atan2"
        case 'h':	 // 1 string to match.
          return std::make_pair(776, 1);	 // "atanh"
        }
        break;
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "amp", 3) != 0)
          break;
        return std::make_pair(846, 6);	 // "clamp"
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+2, "spi", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "cospi"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "oss", 3) != 0)
          break;
        return std::make_pair(877, 6);	 // "cross"
      }
      break;
    case 'e':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "xp", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[4] != '0')
          break;
        return std::make_pair(776, 1);	 // "exp10"
      case 'm':	 // 1 string to match.
        if (Name[4] != '1')
          break;
        return std::make_pair(776, 1);	 // "expm1"
      }
      break;
    case 'f':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "oor", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "floor"
      case 'r':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+3, "ct", 2) != 0)
            break;
          return std::make_pair(798, 4);	 // "fract"
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+3, "xp", 2) != 0)
            break;
          return std::make_pair(802, 12);	 // "frexp"
        }
        break;
      }
      break;
    case 'h':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ypot", 4) != 0)
        break;
      return std::make_pair(780, 1);	 // "hypot"
    case 'i':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ogb", 3) != 0)
          break;
        return std::make_pair(785, 3);	 // "ilogb"
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+3, "nf", 2) != 0)
            break;
          return std::make_pair(887, 5);	 // "isinf"
        case 'n':	 // 1 string to match.
          if (memcmp(Name.data()+3, "an", 2) != 0)
            break;
          return std::make_pair(887, 5);	 // "isnan"
        }
        break;
      }
      break;
    case 'l':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+2, "exp", 3) != 0)
          break;
        return std::make_pair(788, 6);	 // "ldexp"
      case 'o':	 // 2 strings to match.
        if (memcmp(Name.data()+2, "g1", 2) != 0)
          break;
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return std::make_pair(776, 1);	 // "log10"
        case 'p':	 // 1 string to match.
          return std::make_pair(776, 1);	 // "log1p"
        }
        break;
      }
      break;
    case 'm':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+2, "d24", 3) != 0)
          break;
        return std::make_pair(853, 2);	 // "mad24"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+2, "l24", 3) != 0)
          break;
        return std::make_pair(855, 2);	 // "mul24"
      }
      break;
    case 'r':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        if (memcmp(Name.data()+2, "add", 3) != 0)
          break;
        return std::make_pair(833, 1);	 // "rhadd"
      case 'o':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'o':	 // 1 string to match.
          if (memcmp(Name.data()+3, "tn", 2) != 0)
            break;
          return std::make_pair(794, 3);	 // "rootn"
        case 'u':	 // 1 string to match.
          if (memcmp(Name.data()+3, "nd", 2) != 0)
            break;
          return std::make_pair(776, 1);	 // "round"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "qrt", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "rsqrt"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "inpi", 4) != 0)
        break;
      return std::make_pair(776, 1);	 // "sinpi"
    case 't':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+2, "npi", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "tanpi"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "unc", 3) != 0)
          break;
        return std::make_pair(776, 1);	 // "trunc"
      }
      break;
    }
    break;
  case 6:	 // 19 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ospi", 4) != 0)
          break;
        return std::make_pair(776, 1);	 // "acospi"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "inpi", 4) != 0)
          break;
        return std::make_pair(776, 1);	 // "asinpi"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+2, "anpi", 4) != 0)
          break;
        return std::make_pair(776, 1);	 // "atanpi"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sless", 5) != 0)
        break;
      return std::make_pair(893, 5);	 // "isless"
    case 'l':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ngth", 4) != 0)
          break;
        return std::make_pair(869, 3);	 // "length"
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+2, "amma", 4) != 0)
          break;
        return std::make_pair(776, 1);	 // "lgamma"
      }
      break;
    case 'm':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (memcmp(Name.data()+3, "_hi", 3) != 0)
            break;
          return std::make_pair(852, 1);	 // "mad_hi"
        case 'x':	 // 1 string to match.
          if (memcmp(Name.data()+3, "mag", 3) != 0)
            break;
          return std::make_pair(780, 1);	 // "maxmag"
        }
        break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+2, "nmag", 4) != 0)
          break;
        return std::make_pair(780, 1);	 // "minmag"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+2, "l_hi", 4) != 0)
          break;
        return std::make_pair(833, 1);	 // "mul_hi"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "mquo", 4) != 0)
          break;
        return std::make_pair(814, 12);	 // "remquo"
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+2, "tate", 4) != 0)
          break;
        return std::make_pair(833, 1);	 // "rotate"
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "lect", 4) != 0)
          break;
        return std::make_pair(899, 10);	 // "select"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ncos", 4) != 0)
          break;
        return std::make_pair(798, 4);	 // "sincos"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "gamma", 5) != 0)
        break;
      return std::make_pair(776, 1);	 // "tgamma"
    case 'v':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "load", 4) != 0)
        break;
      switch (Name[5]) {
      default: break;
      case '2':	 // 1 string to match.
        return std::make_pair(909, 55);	 // "vload2"
      case '3':	 // 1 string to match.
        return std::make_pair(1008, 55);	 // "vload3"
      case '4':	 // 1 string to match.
        return std::make_pair(1107, 55);	 // "vload4"
      case '8':	 // 1 string to match.
        return std::make_pair(1206, 55);	 // "vload8"
      }
      break;
    }
    break;
  case 7:	 // 17 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+2, "d_sat", 5) != 0)
          break;
        return std::make_pair(833, 1);	 // "add_sat"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "m_dot", 5) != 0)
          break;
        return std::make_pair(115, 2);	 // "arm_dot"
      case 't':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+3, "n2pi", 4) != 0)
            break;
          return std::make_pair(780, 1);	 // "atan2pi"
        case 'o':	 // 1 string to match.
          if (memcmp(Name.data()+3, "m_or", 4) != 0)
            break;
          return std::make_pair(1518, 8);	 // "atom_or"
        }
        break;
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "arrier", 6) != 0)
        break;
      return std::make_pair(1482, 1);	 // "barrier"
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "egrees", 6) != 0)
        break;
      return std::make_pair(776, 1);	 // "degrees"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sequal", 6) != 0)
        break;
      return std::make_pair(893, 5);	 // "isequal"
    case 'm':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ad_sat", 6) != 0)
        break;
      return std::make_pair(852, 1);	 // "mad_sat"
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "adians", 6) != 0)
        break;
      return std::make_pair(776, 1);	 // "radians"
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        if (memcmp(Name.data()+2, "uffle", 5) != 0)
          break;
        return std::make_pair(2012, 176);	 // "shuffle"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+2, "gnbit", 5) != 0)
          break;
        return std::make_pair(887, 5);	 // "signbit"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+2, "b_sat", 5) != 0)
          break;
        return std::make_pair(833, 1);	 // "sub_sat"
      }
      break;
    case 'v':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "oad16", 5) != 0)
          break;
        return std::make_pair(1305, 55);	 // "vload16"
      case 's':	 // 4 strings to match.
        if (memcmp(Name.data()+2, "tore", 4) != 0)
          break;
        switch (Name[6]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(964, 44);	 // "vstore2"
        case '3':	 // 1 string to match.
          return std::make_pair(1063, 44);	 // "vstore3"
        case '4':	 // 1 string to match.
          return std::make_pair(1162, 44);	 // "vstore4"
        case '8':	 // 1 string to match.
          return std::make_pair(1261, 44);	 // "vstore8"
        }
        break;
      }
      break;
    }
    break;
  case 8:	 // 24 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 9 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+2, "s_diff", 6) != 0)
          break;
        return std::make_pair(832, 1);	 // "abs_diff"
      case 't':	 // 8 strings to match.
        if (memcmp(Name.data()+2, "om_", 3) != 0)
          break;
        switch (Name[5]) {
        default: break;
        case 'a':	 // 2 strings to match.
          switch (Name[6]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Name[7] != 'd')
              break;
            return std::make_pair(1494, 8);	 // "atom_add"
          case 'n':	 // 1 string to match.
            if (Name[7] != 'd')
              break;
            return std::make_pair(1518, 8);	 // "atom_and"
          }
          break;
        case 'd':	 // 1 string to match.
          if (memcmp(Name.data()+6, "ec", 2) != 0)
            break;
          return std::make_pair(1502, 8);	 // "atom_dec"
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+6, "nc", 2) != 0)
            break;
          return std::make_pair(1502, 8);	 // "atom_inc"
        case 'm':	 // 2 strings to match.
          switch (Name[6]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[7] != 'x')
              break;
            return std::make_pair(1518, 8);	 // "atom_max"
          case 'i':	 // 1 string to match.
            if (Name[7] != 'n')
              break;
            return std::make_pair(1518, 8);	 // "atom_min"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+6, "ub", 2) != 0)
            break;
          return std::make_pair(1494, 8);	 // "atom_sub"
        case 'x':	 // 1 string to match.
          if (memcmp(Name.data()+6, "or", 2) != 0)
            break;
          return std::make_pair(1518, 8);	 // "atom_xor"
        }
        break;
      }
      break;
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "opysign", 7) != 0)
        break;
      return std::make_pair(780, 1);	 // "copysign"
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "istance", 7) != 0)
        break;
      return std::make_pair(883, 3);	 // "distance"
    case 'h':	 // 5 strings to match.
      if (memcmp(Name.data()+1, "alf_", 4) != 0)
        break;
      switch (Name[5]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+6, "os", 2) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_cos"
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+6, "xp", 2) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_exp"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+6, "og", 2) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_log"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+6, "in", 2) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_sin"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+6, "an", 2) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_tan"
      }
      break;
    case 'i':	 // 2 strings to match.
      if (Name[1] != 's')
        break;
      switch (Name[2]) {
      default: break;
      case 'f':	 // 1 string to match.
        if (memcmp(Name.data()+3, "inite", 5) != 0)
          break;
        return std::make_pair(887, 5);	 // "isfinite"
      case 'n':	 // 1 string to match.
        if (memcmp(Name.data()+3, "ormal", 5) != 0)
          break;
        return std::make_pair(887, 5);	 // "isnormal"
      }
      break;
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+1, "gamma_r", 7) != 0)
        break;
      return std::make_pair(802, 12);	 // "lgamma_r"
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+2, "pcount", 6) != 0)
          break;
        return std::make_pair(830, 1);	 // "popcount"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "efetch", 6) != 0)
          break;
        return std::make_pair(1493, 1);	 // "prefetch"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "huffle2", 7) != 0)
        break;
      return std::make_pair(2188, 176);	 // "shuffle2"
    case 'u':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psample", 7) != 0)
        break;
      return std::make_pair(840, 6);	 // "upsample"
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "store16", 7) != 0)
        break;
      return std::make_pair(1360, 44);	 // "vstore16"
    }
    break;
  case 9:	 // 14 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "tom", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(Name.data()+5, "xchg", 4) != 0)
          break;
        return std::make_pair(1494, 8);	 // "atom_xchg"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "c_or", 4) != 0)
          break;
        return std::make_pair(1534, 6);	 // "atomic_or"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "itselect", 8) != 0)
        break;
      return std::make_pair(898, 1);	 // "bitselect"
    case 'g':	 // 1 string to match.
      if (memcmp(Name.data()+1, "et_fence", 8) != 0)
        break;
      return std::make_pair(1486, 2);	 // "get_fence"
    case 'h':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "alf_", 4) != 0)
        break;
      switch (Name[5]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+6, "xp2", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_exp2"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+6, "og2", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_log2"
      case 'p':	 // 1 string to match.
        if (memcmp(Name.data()+6, "owr", 3) != 0)
          break;
        return std::make_pair(827, 1);	 // "half_powr"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+6, "qrt", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_sqrt"
      }
      break;
    case 'i':	 // 2 strings to match.
      if (Name[1] != 's')
        break;
      switch (Name[2]) {
      default: break;
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+3, "reater", 6) != 0)
          break;
        return std::make_pair(893, 5);	 // "isgreater"
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+3, "rdered", 6) != 0)
          break;
        return std::make_pair(893, 5);	 // "isordered"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(Name.data()+1, "em_fence", 8) != 0)
        break;
      return std::make_pair(1485, 1);	 // "mem_fence"
    case 'n':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "xtafter", 7) != 0)
          break;
        return std::make_pair(780, 1);	 // "nextafter"
      case 'o':	 // 1 string to match.
        if (memcmp(Name.data()+2, "rmalize", 7) != 0)
          break;
        return std::make_pair(872, 3);	 // "normalize"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "emainder", 8) != 0)
        break;
      return std::make_pair(780, 1);	 // "remainder"
    }
    break;
  case 10:	 // 23 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "tomic_", 6) != 0)
        break;
      switch (Name[7]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[8]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Name[9] != 'd')
            break;
          return std::make_pair(1534, 6);	 // "atomic_add"
        case 'n':	 // 1 string to match.
          if (Name[9] != 'd')
            break;
          return std::make_pair(1534, 6);	 // "atomic_and"
        }
        break;
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+8, "ec", 2) != 0)
          break;
        return std::make_pair(1540, 6);	 // "atomic_dec"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+8, "nc", 2) != 0)
          break;
        return std::make_pair(1540, 6);	 // "atomic_inc"
      case 'm':	 // 2 strings to match.
        switch (Name[8]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Name[9] != 'x')
            break;
          return std::make_pair(1534, 6);	 // "atomic_max"
        case 'i':	 // 1 string to match.
          if (Name[9] != 'n')
            break;
          return std::make_pair(1534, 6);	 // "atomic_min"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+8, "ub", 2) != 0)
          break;
        return std::make_pair(1534, 6);	 // "atomic_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+8, "or", 2) != 0)
          break;
        return std::make_pair(1534, 6);	 // "atomic_xor"
      }
      break;
    case 'h':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "alf_", 4) != 0)
        break;
      switch (Name[5]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+6, "xp10", 4) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_exp10"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+6, "og10", 4) != 0)
          break;
        return std::make_pair(826, 1);	 // "half_log10"
      case 'r':	 // 2 strings to match.
        switch (Name[6]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+7, "cip", 3) != 0)
            break;
          return std::make_pair(826, 1);	 // "half_recip"
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+7, "qrt", 3) != 0)
            break;
          return std::make_pair(826, 1);	 // "half_rsqrt"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "snotequal", 9) != 0)
        break;
      return std::make_pair(893, 5);	 // "isnotequal"
    case 'n':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 5 strings to match.
        if (memcmp(Name.data()+2, "tive_", 5) != 0)
          break;
        switch (Name[7]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(Name.data()+8, "os", 2) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_cos"
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+8, "xp", 2) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_exp"
        case 'l':	 // 1 string to match.
          if (memcmp(Name.data()+8, "og", 2) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_log"
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+8, "in", 2) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_sin"
        case 't':	 // 1 string to match.
          if (memcmp(Name.data()+8, "an", 2) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_tan"
        }
        break;
      case 'd':	 // 3 strings to match.
        if (memcmp(Name.data()+2, "range_", 6) != 0)
          break;
        switch (Name[8]) {
        default: break;
        case '1':	 // 1 string to match.
          if (Name[9] != 'D')
            break;
          return std::make_pair(2700, 3);	 // "ndrange_1D"
        case '2':	 // 1 string to match.
          if (Name[9] != 'D')
            break;
          return std::make_pair(2703, 3);	 // "ndrange_2D"
        case '3':	 // 1 string to match.
          if (Name[9] != 'D')
            break;
          return std::make_pair(2703, 3);	 // "ndrange_3D"
        }
        break;
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "moothstep", 9) != 0)
        break;
      return std::make_pair(865, 4);	 // "smoothstep"
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "load_half", 9) != 0)
        break;
      return std::make_pair(1404, 5);	 // "vload_half"
    }
    break;
  case 11:	 // 23 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "m_dot_acc", 9) != 0)
          break;
        return std::make_pair(117, 4);	 // "arm_dot_acc"
      case 't':	 // 3 strings to match.
        if (memcmp(Name.data()+2, "omic_", 5) != 0)
          break;
        switch (Name[7]) {
        default: break;
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+8, "nit", 3) != 0)
            break;
          return std::make_pair(1615, 18);	 // "atomic_init"
        case 'l':	 // 1 string to match.
          if (memcmp(Name.data()+8, "oad", 3) != 0)
            break;
          return std::make_pair(1760, 21);	 // "atomic_load"
        case 'x':	 // 1 string to match.
          if (memcmp(Name.data()+8, "chg", 3) != 0)
            break;
          return std::make_pair(1526, 8);	 // "atomic_xchg"
        }
        break;
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "it_reverse", 10) != 0)
        break;
      return std::make_pair(80, 1);	 // "bit_reverse"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "onvert_int", 10) != 0)
        break;
      return std::make_pair(442, 11);	 // "convert_int"
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ot_acc_sat", 10) != 0)
        break;
      return std::make_pair(99, 4);	 // "dot_acc_sat"
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ast_length", 10) != 0)
        break;
      return std::make_pair(875, 1);	 // "fast_length"
    case 'h':	 // 1 string to match.
      if (memcmp(Name.data()+1, "alf_divide", 10) != 0)
        break;
      return std::make_pair(827, 1);	 // "half_divide"
    case 'i':	 // 2 strings to match.
      if (Name[1] != 's')
        break;
      switch (Name[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+3, "essequal", 8) != 0)
          break;
        return std::make_pair(893, 5);	 // "islessequal"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+3, "nordered", 8) != 0)
          break;
        return std::make_pair(893, 5);	 // "isunordered"
      }
      break;
    case 'n':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "ative_", 6) != 0)
        break;
      switch (Name[7]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+8, "xp2", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "native_exp2"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+8, "og2", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "native_log2"
      case 'p':	 // 1 string to match.
        if (memcmp(Name.data()+8, "owr", 3) != 0)
          break;
        return std::make_pair(827, 1);	 // "native_powr"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+8, "qrt", 3) != 0)
          break;
        return std::make_pair(826, 1);	 // "native_sqrt"
      }
      break;
    case 'r':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "ead_image", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'f':	 // 1 string to match.
        return std::make_pair(2364, 52);	 // "read_imagef"
      case 'h':	 // 1 string to match.
        return std::make_pair(2653, 22);	 // "read_imageh"
      case 'i':	 // 1 string to match.
        return std::make_pair(2416, 36);	 // "read_imagei"
      }
      break;
    case 'v':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 4 strings to match.
        if (memcmp(Name.data()+2, "oad_half", 8) != 0)
          break;
        switch (Name[10]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(1409, 5);	 // "vload_half2"
        case '3':	 // 1 string to match.
          return std::make_pair(1430, 5);	 // "vload_half3"
        case '4':	 // 1 string to match.
          return std::make_pair(1435, 5);	 // "vload_half4"
        case '8':	 // 1 string to match.
          return std::make_pair(1440, 5);	 // "vload_half8"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "tore_half", 9) != 0)
          break;
        return std::make_pair(1414, 8);	 // "vstore_half"
      }
      break;
    }
    break;
  case 12:	 // 31 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "tom", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(Name.data()+5, "cmpxchg", 7) != 0)
          break;
        return std::make_pair(1510, 8);	 // "atom_cmpxchg"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "c_store", 7) != 0)
          break;
        return std::make_pair(1552, 21);	 // "atomic_store"
      }
      break;
    case 'c':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+9, "har", 3) != 0)
          break;
        return std::make_pair(178, 11);	 // "convert_char"
      case 'h':	 // 1 string to match.
        if (memcmp(Name.data()+9, "alf", 3) != 0)
          break;
        return std::make_pair(26, 11);	 // "convert_half"
      case 'i':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "nt", 2) != 0)
          break;
        switch (Name[11]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(453, 11);	 // "convert_int2"
        case '3':	 // 1 string to match.
          return std::make_pair(464, 11);	 // "convert_int3"
        case '4':	 // 1 string to match.
          return std::make_pair(475, 11);	 // "convert_int4"
        case '8':	 // 1 string to match.
          return std::make_pair(486, 11);	 // "convert_int8"
        }
        break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+9, "ong", 3) != 0)
          break;
        return std::make_pair(640, 11);	 // "convert_long"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+9, "int", 3) != 0)
          break;
        return std::make_pair(508, 11);	 // "convert_uint"
      }
      break;
    case 'g':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+5, "roup_id", 7) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_group_id"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ocal_id", 7) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_local_id"
      case 'w':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ork_dim", 7) != 0)
          break;
        return std::make_pair(772, 1);	 // "get_work_dim"
      }
      break;
    case 'n':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "ative_", 6) != 0)
        break;
      switch (Name[7]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+8, "xp10", 4) != 0)
          break;
        return std::make_pair(826, 1);	 // "native_exp10"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+8, "og10", 4) != 0)
          break;
        return std::make_pair(826, 1);	 // "native_log10"
      case 'r':	 // 2 strings to match.
        switch (Name[8]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+9, "cip", 3) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_recip"
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+9, "qrt", 3) != 0)
            break;
          return std::make_pair(826, 1);	 // "native_rsqrt"
        }
        break;
      }
      break;
    case 'r':	 // 2 strings to match.
      if (Name[1] != 'e')
        break;
      switch (Name[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+3, "d_imageui", 9) != 0)
          break;
        return std::make_pair(2452, 36);	 // "read_imageui"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+3, "ain_event", 9) != 0)
          break;
        return std::make_pair(2694, 1);	 // "retain_event"
      }
      break;
    case 'v':	 // 9 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 5 strings to match.
        if (memcmp(Name.data()+2, "oad", 3) != 0)
          break;
        switch (Name[5]) {
        default: break;
        case '_':	 // 1 string to match.
          if (memcmp(Name.data()+6, "half16", 6) != 0)
            break;
          return std::make_pair(1445, 5);	 // "vload_half16"
        case 'a':	 // 4 strings to match.
          if (memcmp(Name.data()+6, "_half", 5) != 0)
            break;
          switch (Name[11]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(1409, 5);	 // "vloada_half2"
          case '3':	 // 1 string to match.
            return std::make_pair(1430, 5);	 // "vloada_half3"
          case '4':	 // 1 string to match.
            return std::make_pair(1435, 5);	 // "vloada_half4"
          case '8':	 // 1 string to match.
            return std::make_pair(1440, 5);	 // "vloada_half8"
          }
          break;
        }
        break;
      case 's':	 // 4 strings to match.
        if (memcmp(Name.data()+2, "tore_half", 9) != 0)
          break;
        switch (Name[11]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(1422, 8);	 // "vstore_half2"
        case '3':	 // 1 string to match.
          return std::make_pair(1450, 8);	 // "vstore_half3"
        case '4':	 // 1 string to match.
          return std::make_pair(1458, 8);	 // "vstore_half4"
        case '8':	 // 1 string to match.
          return std::make_pair(1466, 8);	 // "vstore_half8"
        }
        break;
      }
      break;
    case 'w':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "rite_image", 10) != 0)
        break;
      switch (Name[11]) {
      default: break;
      case 'f':	 // 1 string to match.
        return std::make_pair(2488, 23);	 // "write_imagef"
      case 'h':	 // 1 string to match.
        return std::make_pair(2675, 12);	 // "write_imageh"
      case 'i':	 // 1 string to match.
        return std::make_pair(2511, 17);	 // "write_imagei"
      }
      break;
    }
    break;
  case 13:	 // 36 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 21 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'c':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "har", 3) != 0)
          break;
        switch (Name[12]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(189, 11);	 // "convert_char2"
        case '3':	 // 1 string to match.
          return std::make_pair(200, 11);	 // "convert_char3"
        case '4':	 // 1 string to match.
          return std::make_pair(211, 11);	 // "convert_char4"
        case '8':	 // 1 string to match.
          return std::make_pair(222, 11);	 // "convert_char8"
        }
        break;
      case 'f':	 // 1 string to match.
        if (memcmp(Name.data()+9, "loat", 4) != 0)
          break;
        return std::make_pair(167, 11);	 // "convert_float"
      case 'h':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "alf", 3) != 0)
          break;
        switch (Name[12]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(37, 11);	 // "convert_half2"
        case '3':	 // 1 string to match.
          return std::make_pair(50, 11);	 // "convert_half3"
        case '4':	 // 1 string to match.
          return std::make_pair(64, 11);	 // "convert_half4"
        case '8':	 // 1 string to match.
          return std::make_pair(88, 11);	 // "convert_half8"
        }
        break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+9, "nt16", 4) != 0)
          break;
        return std::make_pair(497, 11);	 // "convert_int16"
      case 'l':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "ong", 3) != 0)
          break;
        switch (Name[12]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(651, 11);	 // "convert_long2"
        case '3':	 // 1 string to match.
          return std::make_pair(662, 11);	 // "convert_long3"
        case '4':	 // 1 string to match.
          return std::make_pair(673, 11);	 // "convert_long4"
        case '8':	 // 1 string to match.
          return std::make_pair(684, 11);	 // "convert_long8"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+9, "hort", 4) != 0)
          break;
        return std::make_pair(310, 11);	 // "convert_short"
      case 'u':	 // 6 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(Name.data()+10, "har", 3) != 0)
            break;
          return std::make_pair(244, 11);	 // "convert_uchar"
        case 'i':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "nt", 2) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(519, 11);	 // "convert_uint2"
          case '3':	 // 1 string to match.
            return std::make_pair(530, 11);	 // "convert_uint3"
          case '4':	 // 1 string to match.
            return std::make_pair(541, 11);	 // "convert_uint4"
          case '8':	 // 1 string to match.
            return std::make_pair(552, 11);	 // "convert_uint8"
          }
          break;
        case 'l':	 // 1 string to match.
          if (memcmp(Name.data()+10, "ong", 3) != 0)
            break;
          return std::make_pair(706, 11);	 // "convert_ulong"
        }
        break;
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ast_distance", 12) != 0)
        break;
      return std::make_pair(886, 1);	 // "fast_distance"
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+5, "lobal_id", 8) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_global_id"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "mage_dim", 8) != 0)
          break;
        return std::make_pair(2611, 27);	 // "get_image_dim"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "slessgreater", 12) != 0)
        break;
      return std::make_pair(893, 5);	 // "islessgreater"
    case 'n':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ative_divide", 12) != 0)
        break;
      return std::make_pair(827, 1);	 // "native_divide"
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "elease_event", 12) != 0)
        break;
      return std::make_pair(2694, 1);	 // "release_event"
    case 's':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ub_group_a", 10) != 0)
        break;
      switch (Name[11]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (Name[12] != 'l')
          break;
        return std::make_pair(2743, 1);	 // "sub_group_all"
      case 'n':	 // 1 string to match.
        if (Name[12] != 'y')
          break;
        return std::make_pair(2743, 1);	 // "sub_group_any"
      }
      break;
    case 'v':	 // 6 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "oada_half16", 11) != 0)
          break;
        return std::make_pair(1445, 5);	 // "vloada_half16"
      case 's':	 // 5 strings to match.
        if (memcmp(Name.data()+2, "tore", 4) != 0)
          break;
        switch (Name[6]) {
        default: break;
        case '_':	 // 1 string to match.
          if (memcmp(Name.data()+7, "half16", 6) != 0)
            break;
          return std::make_pair(1474, 8);	 // "vstore_half16"
        case 'a':	 // 4 strings to match.
          if (memcmp(Name.data()+7, "_half", 5) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(1422, 8);	 // "vstorea_half2"
          case '3':	 // 1 string to match.
            return std::make_pair(1450, 8);	 // "vstorea_half3"
          case '4':	 // 1 string to match.
            return std::make_pair(1458, 8);	 // "vstorea_half4"
          case '8':	 // 1 string to match.
            return std::make_pair(1466, 8);	 // "vstorea_half8"
          }
          break;
        }
        break;
      }
      break;
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "rite_imageui", 12) != 0)
        break;
      return std::make_pair(2528, 17);	 // "write_imageui"
    }
    break;
  case 14:	 // 33 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_cmpxchg", 13) != 0)
        break;
      return std::make_pair(1546, 6);	 // "atomic_cmpxchg"
    case 'c':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+9, "har16", 5) != 0)
          break;
        return std::make_pair(233, 11);	 // "convert_char16"
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+9, "ouble", 5) != 0)
          break;
        return std::make_pair(574, 11);	 // "convert_double"
      case 'f':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "loat", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(1, 11);	 // "convert_float2"
        case '3':	 // 1 string to match.
          return std::make_pair(123, 11);	 // "convert_float3"
        case '4':	 // 1 string to match.
          return std::make_pair(134, 11);	 // "convert_float4"
        case '8':	 // 1 string to match.
          return std::make_pair(145, 11);	 // "convert_float8"
        }
        break;
      case 'h':	 // 1 string to match.
        if (memcmp(Name.data()+9, "alf16", 5) != 0)
          break;
        return std::make_pair(12, 11);	 // "convert_half16"
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+9, "ong16", 5) != 0)
          break;
        return std::make_pair(695, 11);	 // "convert_long16"
      case 's':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "hort", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(321, 11);	 // "convert_short2"
        case '3':	 // 1 string to match.
          return std::make_pair(332, 11);	 // "convert_short3"
        case '4':	 // 1 string to match.
          return std::make_pair(343, 11);	 // "convert_short4"
        case '8':	 // 1 string to match.
          return std::make_pair(354, 11);	 // "convert_short8"
        }
        break;
      case 'u':	 // 10 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "har", 3) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(255, 11);	 // "convert_uchar2"
          case '3':	 // 1 string to match.
            return std::make_pair(266, 11);	 // "convert_uchar3"
          case '4':	 // 1 string to match.
            return std::make_pair(277, 11);	 // "convert_uchar4"
          case '8':	 // 1 string to match.
            return std::make_pair(288, 11);	 // "convert_uchar8"
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+10, "nt16", 4) != 0)
            break;
          return std::make_pair(563, 11);	 // "convert_uint16"
        case 'l':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "ong", 3) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(717, 11);	 // "convert_ulong2"
          case '3':	 // 1 string to match.
            return std::make_pair(728, 11);	 // "convert_ulong3"
          case '4':	 // 1 string to match.
            return std::make_pair(739, 11);	 // "convert_ulong4"
          case '8':	 // 1 string to match.
            return std::make_pair(750, 11);	 // "convert_ulong8"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+10, "hort", 4) != 0)
            break;
          return std::make_pair(376, 11);	 // "convert_ushort"
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(Name.data()+1, "nqueue_marker", 13) != 0)
        break;
      return std::make_pair(2693, 1);	 // "enqueue_marker"
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ast_normalize", 13) != 0)
        break;
      return std::make_pair(876, 1);	 // "fast_normalize"
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ocal_size", 9) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_local_size"
      case 'n':	 // 1 string to match.
        if (memcmp(Name.data()+5, "um_groups", 9) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_num_groups"
      }
      break;
    case 'i':	 // 2 strings to match.
      if (Name[1] != 's')
        break;
      switch (Name[2]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(Name.data()+3, "valid_event", 11) != 0)
          break;
        return std::make_pair(2696, 1);	 // "is_valid_event"
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+3, "reaterequal", 11) != 0)
          break;
        return std::make_pair(893, 5);	 // "isgreaterequal"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ead_mem_fence", 13) != 0)
        break;
      return std::make_pair(1485, 1);	 // "read_mem_fence"
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "storea_half16", 13) != 0)
        break;
      return std::make_pair(1474, 8);	 // "vstorea_half16"
    case 'w':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ork_group_a", 11) != 0)
        break;
      switch (Name[12]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (Name[13] != 'l')
          break;
        return std::make_pair(2687, 1);	 // "work_group_all"
      case 'n':	 // 1 string to match.
        if (Name[13] != 'y')
          break;
        return std::make_pair(2687, 1);	 // "work_group_any"
      }
      break;
    }
    break;
  case 15:	 // 30 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "m_dot_acc_sat", 13) != 0)
          break;
        return std::make_pair(121, 2);	 // "arm_dot_acc_sat"
      case 't':	 // 2 strings to match.
        if (memcmp(Name.data()+2, "omic_", 5) != 0)
          break;
        switch (Name[7]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+8, "xchange", 7) != 0)
            break;
          return std::make_pair(1823, 21);	 // "atomic_exchange"
        case 'f':	 // 1 string to match.
          if (memcmp(Name.data()+8, "etch_or", 7) != 0)
            break;
          return std::make_pair(1958, 12);	 // "atomic_fetch_or"
        }
        break;
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "itfield_insert", 14) != 0)
        break;
      return std::make_pair(75, 1);	 // "bitfield_insert"
    case 'c':	 // 17 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'd':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "ouble", 5) != 0)
          break;
        switch (Name[14]) {
        default: break;
        case '2':	 // 1 string to match.
          return std::make_pair(585, 11);	 // "convert_double2"
        case '3':	 // 1 string to match.
          return std::make_pair(596, 11);	 // "convert_double3"
        case '4':	 // 1 string to match.
          return std::make_pair(607, 11);	 // "convert_double4"
        case '8':	 // 1 string to match.
          return std::make_pair(618, 11);	 // "convert_double8"
        }
        break;
      case 'f':	 // 1 string to match.
        if (memcmp(Name.data()+9, "loat16", 6) != 0)
          break;
        return std::make_pair(156, 11);	 // "convert_float16"
      case 'i':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "nt_", 3) != 0)
          break;
        switch (Name[12]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[13] != 't')
            break;
          switch (Name[14]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(442, 11);	 // "convert_int_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(442, 11);	 // "convert_int_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(442, 11);	 // "convert_int_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(442, 11);	 // "convert_int_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+13, "at", 2) != 0)
            break;
          return std::make_pair(442, 11);	 // "convert_int_sat"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+9, "hort16", 6) != 0)
          break;
        return std::make_pair(365, 11);	 // "convert_short16"
      case 'u':	 // 6 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(Name.data()+10, "har16", 5) != 0)
            break;
          return std::make_pair(299, 11);	 // "convert_uchar16"
        case 'l':	 // 1 string to match.
          if (memcmp(Name.data()+10, "ong16", 5) != 0)
            break;
          return std::make_pair(761, 11);	 // "convert_ulong16"
        case 's':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "hort", 4) != 0)
            break;
          switch (Name[14]) {
          default: break;
          case '2':	 // 1 string to match.
            return std::make_pair(387, 11);	 // "convert_ushort2"
          case '3':	 // 1 string to match.
            return std::make_pair(398, 11);	 // "convert_ushort3"
          case '4':	 // 1 string to match.
            return std::make_pair(409, 11);	 // "convert_ushort4"
          case '8':	 // 1 string to match.
            return std::make_pair(420, 11);	 // "convert_ushort8"
          }
          break;
        }
        break;
      }
      break;
    case 'g':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+5, "lobal_size", 10) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_global_size"
      case 'i':	 // 2 strings to match.
        if (memcmp(Name.data()+5, "mage_", 5) != 0)
          break;
        switch (Name[10]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (memcmp(Name.data()+11, "epth", 4) != 0)
            break;
          return std::make_pair(2608, 3);	 // "get_image_depth"
        case 'w':	 // 1 string to match.
          if (memcmp(Name.data()+11, "idth", 4) != 0)
            break;
          return std::make_pair(2545, 36);	 // "get_image_width"
        }
        break;
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_elect", 14) != 0)
        break;
      return std::make_pair(2749, 1);	 // "sub_group_elect"
    case 'v':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "store_half_rt", 13) != 0)
        break;
      switch (Name[14]) {
      default: break;
      case 'e':	 // 1 string to match.
        return std::make_pair(1414, 8);	 // "vstore_half_rte"
      case 'n':	 // 1 string to match.
        return std::make_pair(1414, 8);	 // "vstore_half_rtn"
      case 'p':	 // 1 string to match.
        return std::make_pair(1414, 8);	 // "vstore_half_rtp"
      case 'z':	 // 1 string to match.
        return std::make_pair(1414, 8);	 // "vstore_half_rtz"
      }
      break;
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "rite_mem_fence", 14) != 0)
        break;
      return std::make_pair(1485, 1);	 // "write_mem_fence"
    }
    break;
  case 16:	 // 67 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "tomic_fetch_", 12) != 0)
        break;
      switch (Name[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Name[15] != 'd')
            break;
          return std::make_pair(1886, 24);	 // "atomic_fetch_add"
        case 'n':	 // 1 string to match.
          if (Name[15] != 'd')
            break;
          return std::make_pair(1958, 12);	 // "atomic_fetch_and"
        }
        break;
      case 'm':	 // 2 strings to match.
        switch (Name[14]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Name[15] != 'x')
            break;
          return std::make_pair(1823, 21);	 // "atomic_fetch_max"
        case 'i':	 // 1 string to match.
          if (Name[15] != 'n')
            break;
          return std::make_pair(1823, 21);	 // "atomic_fetch_min"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+14, "ub", 2) != 0)
          break;
        return std::make_pair(1886, 24);	 // "atomic_fetch_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+14, "or", 2) != 0)
          break;
        return std::make_pair(1958, 12);	 // "atomic_fetch_xor"
      }
      break;
    case 'c':	 // 41 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'c':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "har_", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[14] != 't')
            break;
          switch (Name[15]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+14, "at", 2) != 0)
            break;
          return std::make_pair(178, 11);	 // "convert_char_sat"
        }
        break;
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+9, "ouble16", 7) != 0)
          break;
        return std::make_pair(629, 11);	 // "convert_double16"
      case 'h':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "alf_rt", 6) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(26, 11);	 // "convert_half_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(26, 11);	 // "convert_half_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(26, 11);	 // "convert_half_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(26, 11);	 // "convert_half_rtz"
        }
        break;
      case 'i':	 // 20 strings to match.
        if (memcmp(Name.data()+9, "nt", 2) != 0)
          break;
        switch (Name[11]) {
        default: break;
        case '2':	 // 5 strings to match.
          if (Name[12] != '_')
            break;
          switch (Name[13]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[14] != 't')
              break;
            switch (Name[15]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+14, "at", 2) != 0)
              break;
            return std::make_pair(453, 11);	 // "convert_int2_sat"
          }
          break;
        case '3':	 // 5 strings to match.
          if (Name[12] != '_')
            break;
          switch (Name[13]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[14] != 't')
              break;
            switch (Name[15]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+14, "at", 2) != 0)
              break;
            return std::make_pair(464, 11);	 // "convert_int3_sat"
          }
          break;
        case '4':	 // 5 strings to match.
          if (Name[12] != '_')
            break;
          switch (Name[13]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[14] != 't')
              break;
            switch (Name[15]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+14, "at", 2) != 0)
              break;
            return std::make_pair(475, 11);	 // "convert_int4_sat"
          }
          break;
        case '8':	 // 5 strings to match.
          if (Name[12] != '_')
            break;
          switch (Name[13]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[14] != 't')
              break;
            switch (Name[15]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+14, "at", 2) != 0)
              break;
            return std::make_pair(486, 11);	 // "convert_int8_sat"
          }
          break;
        }
        break;
      case 'l':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "ong_", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[14] != 't')
            break;
          switch (Name[15]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+14, "at", 2) != 0)
            break;
          return std::make_pair(640, 11);	 // "convert_long_sat"
        }
        break;
      case 'u':	 // 6 strings to match.
        switch (Name[9]) {
        default: break;
        case 'i':	 // 5 strings to match.
          if (memcmp(Name.data()+10, "nt_", 3) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[14] != 't')
              break;
            switch (Name[15]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+14, "at", 2) != 0)
              break;
            return std::make_pair(508, 11);	 // "convert_uint_sat"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+10, "hort16", 6) != 0)
            break;
          return std::make_pair(431, 11);	 // "convert_ushort16"
        }
        break;
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "mage_height", 11) != 0)
          break;
        return std::make_pair(2581, 27);	 // "get_image_height"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ub_group_id", 11) != 0)
          break;
        return std::make_pair(2739, 1);	 // "get_sub_group_id"
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+11, "allot", 5) != 0)
          break;
        return std::make_pair(2754, 1);	 // "sub_group_ballot"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+11, "otate", 5) != 0)
          break;
        return std::make_pair(107, 1);	 // "sub_group_rotate"
      }
      break;
    case 'v':	 // 16 strings to match.
      if (memcmp(Name.data()+1, "store_half", 10) != 0)
        break;
      switch (Name[11]) {
      default: break;
      case '2':	 // 4 strings to match.
        if (memcmp(Name.data()+12, "_rt", 3) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(1422, 8);	 // "vstore_half2_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(1422, 8);	 // "vstore_half2_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(1422, 8);	 // "vstore_half2_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(1422, 8);	 // "vstore_half2_rtz"
        }
        break;
      case '3':	 // 4 strings to match.
        if (memcmp(Name.data()+12, "_rt", 3) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(1450, 8);	 // "vstore_half3_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(1450, 8);	 // "vstore_half3_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(1450, 8);	 // "vstore_half3_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(1450, 8);	 // "vstore_half3_rtz"
        }
        break;
      case '4':	 // 4 strings to match.
        if (memcmp(Name.data()+12, "_rt", 3) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(1458, 8);	 // "vstore_half4_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(1458, 8);	 // "vstore_half4_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(1458, 8);	 // "vstore_half4_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(1458, 8);	 // "vstore_half4_rtz"
        }
        break;
      case '8':	 // 4 strings to match.
        if (memcmp(Name.data()+12, "_rt", 3) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(1466, 8);	 // "vstore_half8_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(1466, 8);	 // "vstore_half8_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(1466, 8);	 // "vstore_half8_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(1466, 8);	 // "vstore_half8_rtz"
        }
        break;
      }
      break;
    }
    break;
  case 17:	 // 128 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_flag_clear", 16) != 0)
        break;
      return std::make_pair(1994, 3);	 // "atomic_flag_clear"
    case 'c':	 // 102 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ock_read_device", 15) != 0)
          break;
        return std::make_pair(109, 1);	 // "clock_read_device"
      case 'o':	 // 100 strings to match.
        if (memcmp(Name.data()+2, "nvert_", 6) != 0)
          break;
        switch (Name[8]) {
        default: break;
        case 'c':	 // 20 strings to match.
          if (memcmp(Name.data()+9, "har", 3) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(189, 11);	 // "convert_char2_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(189, 11);	 // "convert_char2_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(189, 11);	 // "convert_char2_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(189, 11);	 // "convert_char2_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(189, 11);	 // "convert_char2_sat"
            }
            break;
          case '3':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(200, 11);	 // "convert_char3_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(200, 11);	 // "convert_char3_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(200, 11);	 // "convert_char3_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(200, 11);	 // "convert_char3_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(200, 11);	 // "convert_char3_sat"
            }
            break;
          case '4':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(211, 11);	 // "convert_char4_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(211, 11);	 // "convert_char4_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(211, 11);	 // "convert_char4_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(211, 11);	 // "convert_char4_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(211, 11);	 // "convert_char4_sat"
            }
            break;
          case '8':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(222, 11);	 // "convert_char8_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(222, 11);	 // "convert_char8_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(222, 11);	 // "convert_char8_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(222, 11);	 // "convert_char8_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(222, 11);	 // "convert_char8_sat"
            }
            break;
          }
          break;
        case 'f':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "loat_rt", 7) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(167, 11);	 // "convert_float_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(167, 11);	 // "convert_float_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(167, 11);	 // "convert_float_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(167, 11);	 // "convert_float_rtz"
          }
          break;
        case 'h':	 // 16 strings to match.
          if (memcmp(Name.data()+9, "alf", 3) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_rt", 3) != 0)
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(37, 11);	 // "convert_half2_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(37, 11);	 // "convert_half2_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(37, 11);	 // "convert_half2_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(37, 11);	 // "convert_half2_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_rt", 3) != 0)
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(50, 11);	 // "convert_half3_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(50, 11);	 // "convert_half3_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(50, 11);	 // "convert_half3_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(50, 11);	 // "convert_half3_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_rt", 3) != 0)
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(64, 11);	 // "convert_half4_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(64, 11);	 // "convert_half4_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(64, 11);	 // "convert_half4_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(64, 11);	 // "convert_half4_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_rt", 3) != 0)
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(88, 11);	 // "convert_half8_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(88, 11);	 // "convert_half8_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(88, 11);	 // "convert_half8_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(88, 11);	 // "convert_half8_rtz"
            }
            break;
          }
          break;
        case 'i':	 // 5 strings to match.
          if (memcmp(Name.data()+9, "nt16_", 5) != 0)
            break;
          switch (Name[14]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[15] != 't')
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(497, 11);	 // "convert_int16_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(497, 11);	 // "convert_int16_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(497, 11);	 // "convert_int16_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(497, 11);	 // "convert_int16_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+15, "at", 2) != 0)
              break;
            return std::make_pair(497, 11);	 // "convert_int16_sat"
          }
          break;
        case 'l':	 // 20 strings to match.
          if (memcmp(Name.data()+9, "ong", 3) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(651, 11);	 // "convert_long2_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(651, 11);	 // "convert_long2_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(651, 11);	 // "convert_long2_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(651, 11);	 // "convert_long2_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(651, 11);	 // "convert_long2_sat"
            }
            break;
          case '3':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(662, 11);	 // "convert_long3_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(662, 11);	 // "convert_long3_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(662, 11);	 // "convert_long3_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(662, 11);	 // "convert_long3_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(662, 11);	 // "convert_long3_sat"
            }
            break;
          case '4':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(673, 11);	 // "convert_long4_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(673, 11);	 // "convert_long4_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(673, 11);	 // "convert_long4_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(673, 11);	 // "convert_long4_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(673, 11);	 // "convert_long4_sat"
            }
            break;
          case '8':	 // 5 strings to match.
            if (Name[13] != '_')
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(684, 11);	 // "convert_long8_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(684, 11);	 // "convert_long8_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(684, 11);	 // "convert_long8_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(684, 11);	 // "convert_long8_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(684, 11);	 // "convert_long8_sat"
            }
            break;
          }
          break;
        case 's':	 // 5 strings to match.
          if (memcmp(Name.data()+9, "hort_", 5) != 0)
            break;
          switch (Name[14]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[15] != 't')
              break;
            switch (Name[16]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(310, 11);	 // "convert_short_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(310, 11);	 // "convert_short_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(310, 11);	 // "convert_short_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(310, 11);	 // "convert_short_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+15, "at", 2) != 0)
              break;
            return std::make_pair(310, 11);	 // "convert_short_sat"
          }
          break;
        case 'u':	 // 30 strings to match.
          switch (Name[9]) {
          default: break;
          case 'c':	 // 5 strings to match.
            if (memcmp(Name.data()+10, "har_", 4) != 0)
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(244, 11);	 // "convert_uchar_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(244, 11);	 // "convert_uchar_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(244, 11);	 // "convert_uchar_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(244, 11);	 // "convert_uchar_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(244, 11);	 // "convert_uchar_sat"
            }
            break;
          case 'i':	 // 20 strings to match.
            if (memcmp(Name.data()+10, "nt", 2) != 0)
              break;
            switch (Name[12]) {
            default: break;
            case '2':	 // 5 strings to match.
              if (Name[13] != '_')
                break;
              switch (Name[14]) {
              default: break;
              case 'r':	 // 4 strings to match.
                if (Name[15] != 't')
                  break;
                switch (Name[16]) {
                default: break;
                case 'e':	 // 1 string to match.
                  return std::make_pair(519, 11);	 // "convert_uint2_rte"
                case 'n':	 // 1 string to match.
                  return std::make_pair(519, 11);	 // "convert_uint2_rtn"
                case 'p':	 // 1 string to match.
                  return std::make_pair(519, 11);	 // "convert_uint2_rtp"
                case 'z':	 // 1 string to match.
                  return std::make_pair(519, 11);	 // "convert_uint2_rtz"
                }
                break;
              case 's':	 // 1 string to match.
                if (memcmp(Name.data()+15, "at", 2) != 0)
                  break;
                return std::make_pair(519, 11);	 // "convert_uint2_sat"
              }
              break;
            case '3':	 // 5 strings to match.
              if (Name[13] != '_')
                break;
              switch (Name[14]) {
              default: break;
              case 'r':	 // 4 strings to match.
                if (Name[15] != 't')
                  break;
                switch (Name[16]) {
                default: break;
                case 'e':	 // 1 string to match.
                  return std::make_pair(530, 11);	 // "convert_uint3_rte"
                case 'n':	 // 1 string to match.
                  return std::make_pair(530, 11);	 // "convert_uint3_rtn"
                case 'p':	 // 1 string to match.
                  return std::make_pair(530, 11);	 // "convert_uint3_rtp"
                case 'z':	 // 1 string to match.
                  return std::make_pair(530, 11);	 // "convert_uint3_rtz"
                }
                break;
              case 's':	 // 1 string to match.
                if (memcmp(Name.data()+15, "at", 2) != 0)
                  break;
                return std::make_pair(530, 11);	 // "convert_uint3_sat"
              }
              break;
            case '4':	 // 5 strings to match.
              if (Name[13] != '_')
                break;
              switch (Name[14]) {
              default: break;
              case 'r':	 // 4 strings to match.
                if (Name[15] != 't')
                  break;
                switch (Name[16]) {
                default: break;
                case 'e':	 // 1 string to match.
                  return std::make_pair(541, 11);	 // "convert_uint4_rte"
                case 'n':	 // 1 string to match.
                  return std::make_pair(541, 11);	 // "convert_uint4_rtn"
                case 'p':	 // 1 string to match.
                  return std::make_pair(541, 11);	 // "convert_uint4_rtp"
                case 'z':	 // 1 string to match.
                  return std::make_pair(541, 11);	 // "convert_uint4_rtz"
                }
                break;
              case 's':	 // 1 string to match.
                if (memcmp(Name.data()+15, "at", 2) != 0)
                  break;
                return std::make_pair(541, 11);	 // "convert_uint4_sat"
              }
              break;
            case '8':	 // 5 strings to match.
              if (Name[13] != '_')
                break;
              switch (Name[14]) {
              default: break;
              case 'r':	 // 4 strings to match.
                if (Name[15] != 't')
                  break;
                switch (Name[16]) {
                default: break;
                case 'e':	 // 1 string to match.
                  return std::make_pair(552, 11);	 // "convert_uint8_rte"
                case 'n':	 // 1 string to match.
                  return std::make_pair(552, 11);	 // "convert_uint8_rtn"
                case 'p':	 // 1 string to match.
                  return std::make_pair(552, 11);	 // "convert_uint8_rtp"
                case 'z':	 // 1 string to match.
                  return std::make_pair(552, 11);	 // "convert_uint8_rtz"
                }
                break;
              case 's':	 // 1 string to match.
                if (memcmp(Name.data()+15, "at", 2) != 0)
                  break;
                return std::make_pair(552, 11);	 // "convert_uint8_sat"
              }
              break;
            }
            break;
          case 'l':	 // 5 strings to match.
            if (memcmp(Name.data()+10, "ong_", 4) != 0)
              break;
            switch (Name[14]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[15] != 't')
                break;
              switch (Name[16]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(706, 11);	 // "convert_ulong_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(706, 11);	 // "convert_ulong_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(706, 11);	 // "convert_ulong_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(706, 11);	 // "convert_ulong_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+15, "at", 2) != 0)
                break;
              return std::make_pair(706, 11);	 // "convert_ulong_sat"
            }
            break;
          }
          break;
        }
        break;
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+2, "eate_user_event", 15) != 0)
          break;
        return std::make_pair(2695, 1);	 // "create_user_event"
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(Name.data()+5, "efault_queue", 12) != 0)
          break;
        return std::make_pair(2699, 1);	 // "get_default_queue"
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+5, "lobal_offset", 12) != 0)
          break;
        return std::make_pair(773, 1);	 // "get_global_offset"
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+11, "arrier", 6) != 0)
          break;
        return std::make_pair(2741, 2);	 // "sub_group_barrier"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+11, "huffle", 6) != 0)
          break;
        return std::make_pair(48, 1);	 // "sub_group_shuffle"
      }
      break;
    case 'v':	 // 20 strings to match.
      if (memcmp(Name.data()+1, "store", 5) != 0)
        break;
      switch (Name[6]) {
      default: break;
      case '_':	 // 4 strings to match.
        if (memcmp(Name.data()+7, "half16_rt", 9) != 0)
          break;
        switch (Name[16]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(1474, 8);	 // "vstore_half16_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(1474, 8);	 // "vstore_half16_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(1474, 8);	 // "vstore_half16_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(1474, 8);	 // "vstore_half16_rtz"
        }
        break;
      case 'a':	 // 16 strings to match.
        if (memcmp(Name.data()+7, "_half", 5) != 0)
          break;
        switch (Name[12]) {
        default: break;
        case '2':	 // 4 strings to match.
          if (memcmp(Name.data()+13, "_rt", 3) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(1422, 8);	 // "vstorea_half2_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(1422, 8);	 // "vstorea_half2_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(1422, 8);	 // "vstorea_half2_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(1422, 8);	 // "vstorea_half2_rtz"
          }
          break;
        case '3':	 // 4 strings to match.
          if (memcmp(Name.data()+13, "_rt", 3) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(1450, 8);	 // "vstorea_half3_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(1450, 8);	 // "vstorea_half3_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(1450, 8);	 // "vstorea_half3_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(1450, 8);	 // "vstorea_half3_rtz"
          }
          break;
        case '4':	 // 4 strings to match.
          if (memcmp(Name.data()+13, "_rt", 3) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(1458, 8);	 // "vstorea_half4_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(1458, 8);	 // "vstorea_half4_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(1458, 8);	 // "vstorea_half4_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(1458, 8);	 // "vstorea_half4_rtz"
          }
          break;
        case '8':	 // 4 strings to match.
          if (memcmp(Name.data()+13, "_rt", 3) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(1466, 8);	 // "vstorea_half8_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(1466, 8);	 // "vstorea_half8_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(1466, 8);	 // "vstorea_half8_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(1466, 8);	 // "vstorea_half8_rtz"
          }
          break;
        }
        break;
      }
      break;
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ait_group_events", 16) != 0)
        break;
      return std::make_pair(1492, 1);	 // "wait_group_events"
    }
    break;
  case 18:	 // 111 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 104 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'c':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "har16_", 6) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[16] != 't')
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+16, "at", 2) != 0)
            break;
          return std::make_pair(233, 11);	 // "convert_char16_sat"
        }
        break;
      case 'd':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "ouble_rt", 8) != 0)
          break;
        switch (Name[17]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(574, 11);	 // "convert_double_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(574, 11);	 // "convert_double_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(574, 11);	 // "convert_double_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(574, 11);	 // "convert_double_rtz"
        }
        break;
      case 'f':	 // 16 strings to match.
        if (memcmp(Name.data()+9, "loat", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case '2':	 // 4 strings to match.
          if (memcmp(Name.data()+14, "_rt", 3) != 0)
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(1, 11);	 // "convert_float2_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(1, 11);	 // "convert_float2_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(1, 11);	 // "convert_float2_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(1, 11);	 // "convert_float2_rtz"
          }
          break;
        case '3':	 // 4 strings to match.
          if (memcmp(Name.data()+14, "_rt", 3) != 0)
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(123, 11);	 // "convert_float3_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(123, 11);	 // "convert_float3_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(123, 11);	 // "convert_float3_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(123, 11);	 // "convert_float3_rtz"
          }
          break;
        case '4':	 // 4 strings to match.
          if (memcmp(Name.data()+14, "_rt", 3) != 0)
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(134, 11);	 // "convert_float4_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(134, 11);	 // "convert_float4_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(134, 11);	 // "convert_float4_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(134, 11);	 // "convert_float4_rtz"
          }
          break;
        case '8':	 // 4 strings to match.
          if (memcmp(Name.data()+14, "_rt", 3) != 0)
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(145, 11);	 // "convert_float8_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(145, 11);	 // "convert_float8_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(145, 11);	 // "convert_float8_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(145, 11);	 // "convert_float8_rtz"
          }
          break;
        }
        break;
      case 'h':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "alf16_rt", 8) != 0)
          break;
        switch (Name[17]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(12, 11);	 // "convert_half16_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(12, 11);	 // "convert_half16_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(12, 11);	 // "convert_half16_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(12, 11);	 // "convert_half16_rtz"
        }
        break;
      case 'l':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "ong16_", 6) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[16] != 't')
            break;
          switch (Name[17]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+16, "at", 2) != 0)
            break;
          return std::make_pair(695, 11);	 // "convert_long16_sat"
        }
        break;
      case 's':	 // 20 strings to match.
        if (memcmp(Name.data()+9, "hort", 4) != 0)
          break;
        switch (Name[13]) {
        default: break;
        case '2':	 // 5 strings to match.
          if (Name[14] != '_')
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(321, 11);	 // "convert_short2_sat"
          }
          break;
        case '3':	 // 5 strings to match.
          if (Name[14] != '_')
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(332, 11);	 // "convert_short3_sat"
          }
          break;
        case '4':	 // 5 strings to match.
          if (Name[14] != '_')
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(343, 11);	 // "convert_short4_sat"
          }
          break;
        case '8':	 // 5 strings to match.
          if (Name[14] != '_')
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(354, 11);	 // "convert_short8_sat"
          }
          break;
        }
        break;
      case 'u':	 // 50 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 20 strings to match.
          if (memcmp(Name.data()+10, "har", 3) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case '2':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(255, 11);	 // "convert_uchar2_sat"
            }
            break;
          case '3':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(266, 11);	 // "convert_uchar3_sat"
            }
            break;
          case '4':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(277, 11);	 // "convert_uchar4_sat"
            }
            break;
          case '8':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(288, 11);	 // "convert_uchar8_sat"
            }
            break;
          }
          break;
        case 'i':	 // 5 strings to match.
          if (memcmp(Name.data()+10, "nt16_", 5) != 0)
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(563, 11);	 // "convert_uint16_sat"
          }
          break;
        case 'l':	 // 20 strings to match.
          if (memcmp(Name.data()+10, "ong", 3) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case '2':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(717, 11);	 // "convert_ulong2_sat"
            }
            break;
          case '3':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(728, 11);	 // "convert_ulong3_sat"
            }
            break;
          case '4':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(739, 11);	 // "convert_ulong4_sat"
            }
            break;
          case '8':	 // 5 strings to match.
            if (Name[14] != '_')
              break;
            switch (Name[15]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[16] != 't')
                break;
              switch (Name[17]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+16, "at", 2) != 0)
                break;
              return std::make_pair(750, 11);	 // "convert_ulong8_sat"
            }
            break;
          }
          break;
        case 's':	 // 5 strings to match.
          if (memcmp(Name.data()+10, "hort_", 5) != 0)
            break;
          switch (Name[15]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[16] != 't')
              break;
            switch (Name[17]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+16, "at", 2) != 0)
              break;
            return std::make_pair(376, 11);	 // "convert_ushort_sat"
          }
          break;
        }
        break;
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(Name.data()+5, "um_sub_groups", 13) != 0)
          break;
        return std::make_pair(2739, 1);	 // "get_num_sub_groups"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ub_group_size", 13) != 0)
          break;
        return std::make_pair(2739, 1);	 // "get_sub_group_size"
      }
      break;
    case 'v':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "storea_half16_rt", 16) != 0)
        break;
      switch (Name[17]) {
      default: break;
      case 'e':	 // 1 string to match.
        return std::make_pair(1474, 8);	 // "vstorea_half16_rte"
      case 'n':	 // 1 string to match.
        return std::make_pair(1474, 8);	 // "vstorea_half16_rtn"
      case 'p':	 // 1 string to match.
        return std::make_pair(1474, 8);	 // "vstorea_half16_rtp"
      case 'z':	 // 1 string to match.
        return std::make_pair(1474, 8);	 // "vstorea_half16_rtz"
      }
      break;
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ork_group_barrier", 17) != 0)
        break;
      return std::make_pair(1483, 2);	 // "work_group_barrier"
    }
    break;
  case 19:	 // 62 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 59 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 'd':	 // 16 strings to match.
        if (memcmp(Name.data()+9, "ouble", 5) != 0)
          break;
        switch (Name[14]) {
        default: break;
        case '2':	 // 4 strings to match.
          if (memcmp(Name.data()+15, "_rt", 3) != 0)
            break;
          switch (Name[18]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(585, 11);	 // "convert_double2_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(585, 11);	 // "convert_double2_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(585, 11);	 // "convert_double2_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(585, 11);	 // "convert_double2_rtz"
          }
          break;
        case '3':	 // 4 strings to match.
          if (memcmp(Name.data()+15, "_rt", 3) != 0)
            break;
          switch (Name[18]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(596, 11);	 // "convert_double3_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(596, 11);	 // "convert_double3_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(596, 11);	 // "convert_double3_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(596, 11);	 // "convert_double3_rtz"
          }
          break;
        case '4':	 // 4 strings to match.
          if (memcmp(Name.data()+15, "_rt", 3) != 0)
            break;
          switch (Name[18]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(607, 11);	 // "convert_double4_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(607, 11);	 // "convert_double4_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(607, 11);	 // "convert_double4_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(607, 11);	 // "convert_double4_rtz"
          }
          break;
        case '8':	 // 4 strings to match.
          if (memcmp(Name.data()+15, "_rt", 3) != 0)
            break;
          switch (Name[18]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(618, 11);	 // "convert_double8_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(618, 11);	 // "convert_double8_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(618, 11);	 // "convert_double8_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(618, 11);	 // "convert_double8_rtz"
          }
          break;
        }
        break;
      case 'f':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "loat16_rt", 9) != 0)
          break;
        switch (Name[18]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(156, 11);	 // "convert_float16_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(156, 11);	 // "convert_float16_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(156, 11);	 // "convert_float16_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(156, 11);	 // "convert_float16_rtz"
        }
        break;
      case 'i':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "nt_sat_rt", 9) != 0)
          break;
        switch (Name[18]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(442, 11);	 // "convert_int_sat_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(442, 11);	 // "convert_int_sat_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(442, 11);	 // "convert_int_sat_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(442, 11);	 // "convert_int_sat_rtz"
        }
        break;
      case 's':	 // 5 strings to match.
        if (memcmp(Name.data()+9, "hort16_", 7) != 0)
          break;
        switch (Name[16]) {
        default: break;
        case 'r':	 // 4 strings to match.
          if (Name[17] != 't')
            break;
          switch (Name[18]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(365, 11);	 // "convert_short16_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(365, 11);	 // "convert_short16_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(365, 11);	 // "convert_short16_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(365, 11);	 // "convert_short16_rtz"
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+17, "at", 2) != 0)
            break;
          return std::make_pair(365, 11);	 // "convert_short16_sat"
        }
        break;
      case 'u':	 // 30 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 5 strings to match.
          if (memcmp(Name.data()+10, "har16_", 6) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[17] != 't')
              break;
            switch (Name[18]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(299, 11);	 // "convert_uchar16_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(299, 11);	 // "convert_uchar16_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(299, 11);	 // "convert_uchar16_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(299, 11);	 // "convert_uchar16_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+17, "at", 2) != 0)
              break;
            return std::make_pair(299, 11);	 // "convert_uchar16_sat"
          }
          break;
        case 'l':	 // 5 strings to match.
          if (memcmp(Name.data()+10, "ong16_", 6) != 0)
            break;
          switch (Name[16]) {
          default: break;
          case 'r':	 // 4 strings to match.
            if (Name[17] != 't')
              break;
            switch (Name[18]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(761, 11);	 // "convert_ulong16_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(761, 11);	 // "convert_ulong16_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(761, 11);	 // "convert_ulong16_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(761, 11);	 // "convert_ulong16_rtz"
            }
            break;
          case 's':	 // 1 string to match.
            if (memcmp(Name.data()+17, "at", 2) != 0)
              break;
            return std::make_pair(761, 11);	 // "convert_ulong16_sat"
          }
          break;
        case 's':	 // 20 strings to match.
          if (memcmp(Name.data()+10, "hort", 4) != 0)
            break;
          switch (Name[14]) {
          default: break;
          case '2':	 // 5 strings to match.
            if (Name[15] != '_')
              break;
            switch (Name[16]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[17] != 't')
                break;
              switch (Name[18]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(387, 11);	 // "convert_ushort2_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(387, 11);	 // "convert_ushort2_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(387, 11);	 // "convert_ushort2_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(387, 11);	 // "convert_ushort2_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+17, "at", 2) != 0)
                break;
              return std::make_pair(387, 11);	 // "convert_ushort2_sat"
            }
            break;
          case '3':	 // 5 strings to match.
            if (Name[15] != '_')
              break;
            switch (Name[16]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[17] != 't')
                break;
              switch (Name[18]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(398, 11);	 // "convert_ushort3_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(398, 11);	 // "convert_ushort3_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(398, 11);	 // "convert_ushort3_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(398, 11);	 // "convert_ushort3_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+17, "at", 2) != 0)
                break;
              return std::make_pair(398, 11);	 // "convert_ushort3_sat"
            }
            break;
          case '4':	 // 5 strings to match.
            if (Name[15] != '_')
              break;
            switch (Name[16]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[17] != 't')
                break;
              switch (Name[18]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(409, 11);	 // "convert_ushort4_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(409, 11);	 // "convert_ushort4_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(409, 11);	 // "convert_ushort4_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(409, 11);	 // "convert_ushort4_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+17, "at", 2) != 0)
                break;
              return std::make_pair(409, 11);	 // "convert_ushort4_sat"
            }
            break;
          case '8':	 // 5 strings to match.
            if (Name[15] != '_')
              break;
            switch (Name[16]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[17] != 't')
                break;
              switch (Name[18]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(420, 11);	 // "convert_ushort8_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(420, 11);	 // "convert_ushort8_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(420, 11);	 // "convert_ushort8_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(420, 11);	 // "convert_ushort8_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+17, "at", 2) != 0)
                break;
              return std::make_pair(420, 11);	 // "convert_ushort8_sat"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    case 'g':	 // 1 string to match.
      if (memcmp(Name.data()+1, "et_local_linear_id", 18) != 0)
        break;
      return std::make_pair(775, 1);	 // "get_local_linear_id"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "s_valid_reserve_id", 18) != 0)
        break;
      return std::make_pair(2692, 1);	 // "is_valid_reserve_id"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_broadcast", 18) != 0)
        break;
      return std::make_pair(2744, 3);	 // "sub_group_broadcast"
    }
    break;
  case 20:	 // 49 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_load_explicit", 19) != 0)
        break;
      return std::make_pair(1781, 42);	 // "atomic_load_explicit"
    case 'c':	 // 38 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ock_read_sub_group", 18) != 0)
          break;
        return std::make_pair(113, 1);	 // "clock_read_sub_group"
      case 'o':	 // 37 strings to match.
        if (memcmp(Name.data()+2, "nvert_", 6) != 0)
          break;
        switch (Name[8]) {
        default: break;
        case 'c':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "har_sat_rt", 10) != 0)
            break;
          switch (Name[19]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(178, 11);	 // "convert_char_sat_rtz"
          }
          break;
        case 'd':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "ouble16_rt", 10) != 0)
            break;
          switch (Name[19]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(629, 11);	 // "convert_double16_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(629, 11);	 // "convert_double16_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(629, 11);	 // "convert_double16_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(629, 11);	 // "convert_double16_rtz"
          }
          break;
        case 'i':	 // 16 strings to match.
          if (memcmp(Name.data()+9, "nt", 2) != 0)
            break;
          switch (Name[11]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+12, "_sat_rt", 7) != 0)
              break;
            switch (Name[19]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(453, 11);	 // "convert_int2_sat_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+12, "_sat_rt", 7) != 0)
              break;
            switch (Name[19]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(464, 11);	 // "convert_int3_sat_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+12, "_sat_rt", 7) != 0)
              break;
            switch (Name[19]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(475, 11);	 // "convert_int4_sat_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+12, "_sat_rt", 7) != 0)
              break;
            switch (Name[19]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(486, 11);	 // "convert_int8_sat_rtz"
            }
            break;
          }
          break;
        case 'l':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "ong_sat_rt", 10) != 0)
            break;
          switch (Name[19]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(640, 11);	 // "convert_long_sat_rtz"
          }
          break;
        case 'u':	 // 9 strings to match.
          switch (Name[9]) {
          default: break;
          case 'i':	 // 4 strings to match.
            if (memcmp(Name.data()+10, "nt_sat_rt", 9) != 0)
              break;
            switch (Name[19]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(508, 11);	 // "convert_uint_sat_rtz"
            }
            break;
          case 's':	 // 5 strings to match.
            if (memcmp(Name.data()+10, "hort16_", 7) != 0)
              break;
            switch (Name[17]) {
            default: break;
            case 'r':	 // 4 strings to match.
              if (Name[18] != 't')
                break;
              switch (Name[19]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(431, 11);	 // "convert_ushort16_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(431, 11);	 // "convert_ushort16_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(431, 11);	 // "convert_ushort16_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(431, 11);	 // "convert_ushort16_rtz"
              }
              break;
            case 's':	 // 1 string to match.
              if (memcmp(Name.data()+18, "at", 2) != 0)
                break;
              return std::make_pair(431, 11);	 // "convert_ushort16_sat"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    case 'd':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "ot_4x8packed_", 13) != 0)
        break;
      switch (Name[14]) {
      default: break;
      case 's':	 // 2 strings to match.
        switch (Name[15]) {
        default: break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+16, "_int", 4) != 0)
            break;
          return std::make_pair(104, 1);	 // "dot_4x8packed_ss_int"
        case 'u':	 // 1 string to match.
          if (memcmp(Name.data()+16, "_int", 4) != 0)
            break;
          return std::make_pair(104, 1);	 // "dot_4x8packed_su_int"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+15, "s_int", 5) != 0)
          break;
        return std::make_pair(104, 1);	 // "dot_4x8packed_us_int"
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'g':	 // 1 string to match.
        if (memcmp(Name.data()+5, "lobal_linear_id", 15) != 0)
          break;
        return std::make_pair(775, 1);	 // "get_global_linear_id"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "mage_array_size", 15) != 0)
          break;
        return std::make_pair(2638, 15);	 // "get_image_array_size"
      }
      break;
    case 's':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'r':	 // 3 strings to match.
        if (memcmp(Name.data()+11, "educe_", 6) != 0)
          break;
        switch (Name[17]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+18, "dd", 2) != 0)
            break;
          return std::make_pair(2747, 2);	 // "sub_group_reduce_add"
        case 'm':	 // 2 strings to match.
          switch (Name[18]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[19] != 'x')
              break;
            return std::make_pair(2747, 2);	 // "sub_group_reduce_max"
          case 'i':	 // 1 string to match.
            if (Name[19] != 'n')
              break;
            return std::make_pair(2747, 2);	 // "sub_group_reduce_min"
          }
          break;
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+11, "huffle_up", 9) != 0)
          break;
        return std::make_pair(49, 1);	 // "sub_group_shuffle_up"
      }
      break;
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ork_group_broadcast", 19) != 0)
        break;
      return std::make_pair(2688, 3);	 // "work_group_broadcast"
    }
    break;
  case 21:	 // 79 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ync_work_group_copy", 19) != 0)
          break;
        return std::make_pair(1488, 2);	 // "async_work_group_copy"
      case 't':	 // 1 string to match.
        if (memcmp(Name.data()+2, "omic_store_explicit", 19) != 0)
          break;
        return std::make_pair(1573, 42);	 // "atomic_store_explicit"
      }
      break;
    case 'c':	 // 65 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ock_read_work_group", 19) != 0)
          break;
        return std::make_pair(111, 1);	 // "clock_read_work_group"
      case 'o':	 // 64 strings to match.
        if (memcmp(Name.data()+2, "nvert_", 6) != 0)
          break;
        switch (Name[8]) {
        default: break;
        case 'c':	 // 16 strings to match.
          if (memcmp(Name.data()+9, "har", 3) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(189, 11);	 // "convert_char2_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(189, 11);	 // "convert_char2_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(189, 11);	 // "convert_char2_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(189, 11);	 // "convert_char2_sat_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(200, 11);	 // "convert_char3_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(200, 11);	 // "convert_char3_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(200, 11);	 // "convert_char3_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(200, 11);	 // "convert_char3_sat_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(211, 11);	 // "convert_char4_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(211, 11);	 // "convert_char4_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(211, 11);	 // "convert_char4_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(211, 11);	 // "convert_char4_sat_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(222, 11);	 // "convert_char8_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(222, 11);	 // "convert_char8_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(222, 11);	 // "convert_char8_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(222, 11);	 // "convert_char8_sat_rtz"
            }
            break;
          }
          break;
        case 'i':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "nt16_sat_rt", 11) != 0)
            break;
          switch (Name[20]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(497, 11);	 // "convert_int16_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(497, 11);	 // "convert_int16_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(497, 11);	 // "convert_int16_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(497, 11);	 // "convert_int16_sat_rtz"
          }
          break;
        case 'l':	 // 16 strings to match.
          if (memcmp(Name.data()+9, "ong", 3) != 0)
            break;
          switch (Name[12]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(651, 11);	 // "convert_long2_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(651, 11);	 // "convert_long2_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(651, 11);	 // "convert_long2_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(651, 11);	 // "convert_long2_sat_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(662, 11);	 // "convert_long3_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(662, 11);	 // "convert_long3_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(662, 11);	 // "convert_long3_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(662, 11);	 // "convert_long3_sat_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(673, 11);	 // "convert_long4_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(673, 11);	 // "convert_long4_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(673, 11);	 // "convert_long4_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(673, 11);	 // "convert_long4_sat_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(684, 11);	 // "convert_long8_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(684, 11);	 // "convert_long8_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(684, 11);	 // "convert_long8_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(684, 11);	 // "convert_long8_sat_rtz"
            }
            break;
          }
          break;
        case 's':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "hort_sat_rt", 11) != 0)
            break;
          switch (Name[20]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(310, 11);	 // "convert_short_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(310, 11);	 // "convert_short_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(310, 11);	 // "convert_short_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(310, 11);	 // "convert_short_sat_rtz"
          }
          break;
        case 'u':	 // 24 strings to match.
          switch (Name[9]) {
          default: break;
          case 'c':	 // 4 strings to match.
            if (memcmp(Name.data()+10, "har_sat_rt", 10) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(244, 11);	 // "convert_uchar_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(244, 11);	 // "convert_uchar_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(244, 11);	 // "convert_uchar_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(244, 11);	 // "convert_uchar_sat_rtz"
            }
            break;
          case 'i':	 // 16 strings to match.
            if (memcmp(Name.data()+10, "nt", 2) != 0)
              break;
            switch (Name[12]) {
            default: break;
            case '2':	 // 4 strings to match.
              if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
                break;
              switch (Name[20]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(519, 11);	 // "convert_uint2_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(519, 11);	 // "convert_uint2_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(519, 11);	 // "convert_uint2_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(519, 11);	 // "convert_uint2_sat_rtz"
              }
              break;
            case '3':	 // 4 strings to match.
              if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
                break;
              switch (Name[20]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(530, 11);	 // "convert_uint3_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(530, 11);	 // "convert_uint3_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(530, 11);	 // "convert_uint3_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(530, 11);	 // "convert_uint3_sat_rtz"
              }
              break;
            case '4':	 // 4 strings to match.
              if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
                break;
              switch (Name[20]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(541, 11);	 // "convert_uint4_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(541, 11);	 // "convert_uint4_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(541, 11);	 // "convert_uint4_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(541, 11);	 // "convert_uint4_sat_rtz"
              }
              break;
            case '8':	 // 4 strings to match.
              if (memcmp(Name.data()+13, "_sat_rt", 7) != 0)
                break;
              switch (Name[20]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(552, 11);	 // "convert_uint8_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(552, 11);	 // "convert_uint8_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(552, 11);	 // "convert_uint8_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(552, 11);	 // "convert_uint8_sat_rtz"
              }
              break;
            }
            break;
          case 'l':	 // 4 strings to match.
            if (memcmp(Name.data()+10, "ong_sat_rt", 10) != 0)
              break;
            switch (Name[20]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(706, 11);	 // "convert_ulong_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(706, 11);	 // "convert_ulong_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(706, 11);	 // "convert_ulong_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(706, 11);	 // "convert_ulong_sat_rtz"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ot_4x8packed_uu_uint", 20) != 0)
        break;
      return std::make_pair(103, 1);	 // "dot_4x8packed_uu_uint"
    case 'g':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "mage_num_samples", 16) != 0)
          break;
        return std::make_pair(2727, 12);	 // "get_image_num_samples"
      case 's':	 // 5 strings to match.
        if (memcmp(Name.data()+5, "ub_group_", 9) != 0)
          break;
        switch (Name[14]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+15, "q_mask", 6) != 0)
            break;
          return std::make_pair(2759, 1);	 // "get_sub_group_eq_mask"
        case 'g':	 // 2 strings to match.
          switch (Name[15]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (memcmp(Name.data()+16, "_mask", 5) != 0)
              break;
            return std::make_pair(2759, 1);	 // "get_sub_group_ge_mask"
          case 't':	 // 1 string to match.
            if (memcmp(Name.data()+16, "_mask", 5) != 0)
              break;
            return std::make_pair(2759, 1);	 // "get_sub_group_gt_mask"
          }
          break;
        case 'l':	 // 2 strings to match.
          switch (Name[15]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (memcmp(Name.data()+16, "_mask", 5) != 0)
              break;
            return std::make_pair(2759, 1);	 // "get_sub_group_le_mask"
          case 't':	 // 1 string to match.
            if (memcmp(Name.data()+16, "_mask", 5) != 0)
              break;
            return std::make_pair(2759, 1);	 // "get_sub_group_lt_mask"
          }
          break;
        }
        break;
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+2, "t_user_event_status", 19) != 0)
          break;
        return std::make_pair(2697, 1);	 // "set_user_event_status"
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+2, "b_group_shuffle_xor", 19) != 0)
          break;
        return std::make_pair(48, 1);	 // "sub_group_shuffle_xor"
      }
      break;
    case 'w':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "ork_group_reduce_", 17) != 0)
        break;
      switch (Name[18]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+19, "dd", 2) != 0)
          break;
        return std::make_pair(2691, 1);	 // "work_group_reduce_add"
      case 'm':	 // 2 strings to match.
        switch (Name[19]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Name[20] != 'x')
            break;
          return std::make_pair(2691, 1);	 // "work_group_reduce_max"
        case 'i':	 // 1 string to match.
          if (Name[20] != 'n')
            break;
          return std::make_pair(2691, 1);	 // "work_group_reduce_min"
        }
        break;
      }
      break;
    }
    break;
  case 22:	 // 69 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_work_item_fence", 21) != 0)
        break;
      return std::make_pair(1759, 1);	 // "atomic_work_item_fence"
    case 'c':	 // 65 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ock_read_hilo_device", 20) != 0)
          break;
        return std::make_pair(110, 1);	 // "clock_read_hilo_device"
      case 'o':	 // 64 strings to match.
        if (memcmp(Name.data()+2, "nvert_", 6) != 0)
          break;
        switch (Name[8]) {
        default: break;
        case 'c':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "har16_sat_rt", 12) != 0)
            break;
          switch (Name[21]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(233, 11);	 // "convert_char16_sat_rtz"
          }
          break;
        case 'l':	 // 4 strings to match.
          if (memcmp(Name.data()+9, "ong16_sat_rt", 12) != 0)
            break;
          switch (Name[21]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(695, 11);	 // "convert_long16_sat_rtz"
          }
          break;
        case 's':	 // 16 strings to match.
          if (memcmp(Name.data()+9, "hort", 4) != 0)
            break;
          switch (Name[13]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(321, 11);	 // "convert_short2_sat_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(332, 11);	 // "convert_short3_sat_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(343, 11);	 // "convert_short4_sat_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(354, 11);	 // "convert_short8_sat_rtz"
            }
            break;
          }
          break;
        case 'u':	 // 40 strings to match.
          switch (Name[9]) {
          default: break;
          case 'c':	 // 16 strings to match.
            if (memcmp(Name.data()+10, "har", 3) != 0)
              break;
            switch (Name[13]) {
            default: break;
            case '2':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(255, 11);	 // "convert_uchar2_sat_rtz"
              }
              break;
            case '3':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(266, 11);	 // "convert_uchar3_sat_rtz"
              }
              break;
            case '4':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(277, 11);	 // "convert_uchar4_sat_rtz"
              }
              break;
            case '8':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(288, 11);	 // "convert_uchar8_sat_rtz"
              }
              break;
            }
            break;
          case 'i':	 // 4 strings to match.
            if (memcmp(Name.data()+10, "nt16_sat_rt", 11) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(563, 11);	 // "convert_uint16_sat_rtz"
            }
            break;
          case 'l':	 // 16 strings to match.
            if (memcmp(Name.data()+10, "ong", 3) != 0)
              break;
            switch (Name[13]) {
            default: break;
            case '2':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(717, 11);	 // "convert_ulong2_sat_rtz"
              }
              break;
            case '3':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(728, 11);	 // "convert_ulong3_sat_rtz"
              }
              break;
            case '4':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(739, 11);	 // "convert_ulong4_sat_rtz"
              }
              break;
            case '8':	 // 4 strings to match.
              if (memcmp(Name.data()+14, "_sat_rt", 7) != 0)
                break;
              switch (Name[21]) {
              default: break;
              case 'e':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_sat_rte"
              case 'n':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_sat_rtn"
              case 'p':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_sat_rtp"
              case 'z':	 // 1 string to match.
                return std::make_pair(750, 11);	 // "convert_ulong8_sat_rtz"
              }
              break;
            }
            break;
          case 's':	 // 4 strings to match.
            if (memcmp(Name.data()+10, "hort_sat_rt", 11) != 0)
              break;
            switch (Name[21]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(376, 11);	 // "convert_ushort_sat_rtz"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ax_sub_group_size", 17) != 0)
          break;
        return std::make_pair(2739, 1);	 // "get_max_sub_group_size"
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+5, "ub_group_local_id", 17) != 0)
          break;
        return std::make_pair(2739, 1);	 // "get_sub_group_local_id"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_shuffle_down", 21) != 0)
        break;
      return std::make_pair(49, 1);	 // "sub_group_shuffle_down"
    }
    break;
  case 23:	 // 31 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "itfield_extract_signed", 22) != 0)
        break;
      return std::make_pair(76, 2);	 // "bitfield_extract_signed"
    case 'c':	 // 28 strings to match.
      if (memcmp(Name.data()+1, "onvert_", 7) != 0)
        break;
      switch (Name[8]) {
      default: break;
      case 's':	 // 4 strings to match.
        if (memcmp(Name.data()+9, "hort16_sat_rt", 13) != 0)
          break;
        switch (Name[22]) {
        default: break;
        case 'e':	 // 1 string to match.
          return std::make_pair(365, 11);	 // "convert_short16_sat_rte"
        case 'n':	 // 1 string to match.
          return std::make_pair(365, 11);	 // "convert_short16_sat_rtn"
        case 'p':	 // 1 string to match.
          return std::make_pair(365, 11);	 // "convert_short16_sat_rtp"
        case 'z':	 // 1 string to match.
          return std::make_pair(365, 11);	 // "convert_short16_sat_rtz"
        }
        break;
      case 'u':	 // 24 strings to match.
        switch (Name[9]) {
        default: break;
        case 'c':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "har16_sat_rt", 12) != 0)
            break;
          switch (Name[22]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(299, 11);	 // "convert_uchar16_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(299, 11);	 // "convert_uchar16_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(299, 11);	 // "convert_uchar16_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(299, 11);	 // "convert_uchar16_sat_rtz"
          }
          break;
        case 'l':	 // 4 strings to match.
          if (memcmp(Name.data()+10, "ong16_sat_rt", 12) != 0)
            break;
          switch (Name[22]) {
          default: break;
          case 'e':	 // 1 string to match.
            return std::make_pair(761, 11);	 // "convert_ulong16_sat_rte"
          case 'n':	 // 1 string to match.
            return std::make_pair(761, 11);	 // "convert_ulong16_sat_rtn"
          case 'p':	 // 1 string to match.
            return std::make_pair(761, 11);	 // "convert_ulong16_sat_rtp"
          case 'z':	 // 1 string to match.
            return std::make_pair(761, 11);	 // "convert_ulong16_sat_rtz"
          }
          break;
        case 's':	 // 16 strings to match.
          if (memcmp(Name.data()+10, "hort", 4) != 0)
            break;
          switch (Name[14]) {
          default: break;
          case '2':	 // 4 strings to match.
            if (memcmp(Name.data()+15, "_sat_rt", 7) != 0)
              break;
            switch (Name[22]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(387, 11);	 // "convert_ushort2_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(387, 11);	 // "convert_ushort2_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(387, 11);	 // "convert_ushort2_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(387, 11);	 // "convert_ushort2_sat_rtz"
            }
            break;
          case '3':	 // 4 strings to match.
            if (memcmp(Name.data()+15, "_sat_rt", 7) != 0)
              break;
            switch (Name[22]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(398, 11);	 // "convert_ushort3_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(398, 11);	 // "convert_ushort3_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(398, 11);	 // "convert_ushort3_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(398, 11);	 // "convert_ushort3_sat_rtz"
            }
            break;
          case '4':	 // 4 strings to match.
            if (memcmp(Name.data()+15, "_sat_rt", 7) != 0)
              break;
            switch (Name[22]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(409, 11);	 // "convert_ushort4_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(409, 11);	 // "convert_ushort4_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(409, 11);	 // "convert_ushort4_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(409, 11);	 // "convert_ushort4_sat_rtz"
            }
            break;
          case '8':	 // 4 strings to match.
            if (memcmp(Name.data()+15, "_sat_rt", 7) != 0)
              break;
            switch (Name[22]) {
            default: break;
            case 'e':	 // 1 string to match.
              return std::make_pair(420, 11);	 // "convert_ushort8_sat_rte"
            case 'n':	 // 1 string to match.
              return std::make_pair(420, 11);	 // "convert_ushort8_sat_rtn"
            case 'p':	 // 1 string to match.
              return std::make_pair(420, 11);	 // "convert_ushort8_sat_rtp"
            case 'z':	 // 1 string to match.
              return std::make_pair(420, 11);	 // "convert_ushort8_sat_rtz"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    case 'g':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "et_", 3) != 0)
        break;
      switch (Name[4]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+5, "nqueued_local_size", 18) != 0)
          break;
        return std::make_pair(774, 1);	 // "get_enqueued_local_size"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+5, "mage_channel_order", 18) != 0)
          break;
        return std::make_pair(2545, 36);	 // "get_image_channel_order"
      }
      break;
    }
    break;
  case 24:	 // 9 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "tomic_", 6) != 0)
        break;
      switch (Name[7]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+8, "xchange_explicit", 16) != 0)
          break;
        return std::make_pair(1844, 42);	 // "atomic_exchange_explicit"
      case 'f':	 // 2 strings to match.
        switch (Name[8]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+9, "tch_or_explicit", 15) != 0)
            break;
          return std::make_pair(1970, 24);	 // "atomic_fetch_or_explicit"
        case 'l':	 // 1 string to match.
          if (memcmp(Name.data()+9, "ag_test_and_set", 15) != 0)
            break;
          return std::make_pair(2003, 3);	 // "atomic_flag_test_and_set"
        }
        break;
      }
      break;
    case 'c':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "onvert_ushort16_sat_rt", 22) != 0)
        break;
      switch (Name[23]) {
      default: break;
      case 'e':	 // 1 string to match.
        return std::make_pair(431, 11);	 // "convert_ushort16_sat_rte"
      case 'n':	 // 1 string to match.
        return std::make_pair(431, 11);	 // "convert_ushort16_sat_rtn"
      case 'p':	 // 1 string to match.
        return std::make_pair(431, 11);	 // "convert_ushort16_sat_rtp"
      case 'z':	 // 1 string to match.
        return std::make_pair(431, 11);	 // "convert_ushort16_sat_rtz"
      }
      break;
    case 'g':	 // 1 string to match.
      if (memcmp(Name.data()+1, "et_image_num_mip_levels", 23) != 0)
        break;
      return std::make_pair(2706, 21);	 // "get_image_num_mip_levels"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_inverse_ballot", 23) != 0)
        break;
      return std::make_pair(2755, 1);	 // "sub_group_inverse_ballot"
    }
    break;
  case 25:	 // 13 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "tomic_fetch_", 12) != 0)
        break;
      switch (Name[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (memcmp(Name.data()+15, "d_explicit", 10) != 0)
            break;
          return std::make_pair(1910, 48);	 // "atomic_fetch_add_explicit"
        case 'n':	 // 1 string to match.
          if (memcmp(Name.data()+15, "d_explicit", 10) != 0)
            break;
          return std::make_pair(1970, 24);	 // "atomic_fetch_and_explicit"
        }
        break;
      case 'm':	 // 2 strings to match.
        switch (Name[14]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+15, "x_explicit", 10) != 0)
            break;
          return std::make_pair(1844, 42);	 // "atomic_fetch_max_explicit"
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+15, "n_explicit", 10) != 0)
            break;
          return std::make_pair(1844, 42);	 // "atomic_fetch_min_explicit"
        }
        break;
      case 's':	 // 1 string to match.
        if (memcmp(Name.data()+14, "ub_explicit", 11) != 0)
          break;
        return std::make_pair(1910, 48);	 // "atomic_fetch_sub_explicit"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+14, "or_explicit", 11) != 0)
          break;
        return std::make_pair(1970, 24);	 // "atomic_fetch_xor_explicit"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "itfield_extract_unsigned", 24) != 0)
        break;
      return std::make_pair(78, 2);	 // "bitfield_extract_unsigned"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lock_read_hilo_sub_group", 24) != 0)
        break;
      return std::make_pair(114, 1);	 // "clock_read_hilo_sub_group"
    case 's':	 // 5 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'b':	 // 3 strings to match.
        switch (Name[11]) {
        default: break;
        case 'a':	 // 2 strings to match.
          if (memcmp(Name.data()+12, "llot_find_", 10) != 0)
            break;
          switch (Name[22]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (memcmp(Name.data()+23, "sb", 2) != 0)
              break;
            return std::make_pair(2758, 1);	 // "sub_group_ballot_find_lsb"
          case 'm':	 // 1 string to match.
            if (memcmp(Name.data()+23, "sb", 2) != 0)
              break;
            return std::make_pair(2758, 1);	 // "sub_group_ballot_find_msb"
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Name.data()+12, "oadcast_first", 13) != 0)
            break;
          return std::make_pair(2753, 1);	 // "sub_group_broadcast_first"
        }
        break;
      case 'n':	 // 2 strings to match.
        if (memcmp(Name.data()+11, "on_uniform_a", 12) != 0)
          break;
        switch (Name[23]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (Name[24] != 'l')
            break;
          return std::make_pair(2750, 1);	 // "sub_group_non_uniform_all"
        case 'n':	 // 1 string to match.
          if (Name[24] != 'y')
            break;
          return std::make_pair(2750, 1);	 // "sub_group_non_uniform_any"
        }
        break;
      }
      break;
    }
    break;
  case 26:	 // 4 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_flag_clear_explicit", 25) != 0)
        break;
      return std::make_pair(1997, 6);	 // "atomic_flag_clear_explicit"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lock_read_hilo_work_group", 25) != 0)
        break;
      return std::make_pair(112, 1);	 // "clock_read_hilo_work_group"
    case 's':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+11, "allot_bit_count", 15) != 0)
          break;
        return std::make_pair(2757, 1);	 // "sub_group_ballot_bit_count"
      case 'c':	 // 1 string to match.
        if (memcmp(Name.data()+11, "lustered_rotate", 15) != 0)
          break;
        return std::make_pair(108, 1);	 // "sub_group_clustered_rotate"
      }
      break;
    }
    break;
  case 27:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "get_", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(Name.data()+5, "nqueued_num_sub_groups", 22) != 0)
        break;
      return std::make_pair(2740, 1);	 // "get_enqueued_num_sub_groups"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+5, "mage_channel_data_type", 22) != 0)
        break;
      return std::make_pair(2545, 36);	 // "get_image_channel_data_type"
    }
    break;
  case 28:	 // 12 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_compare_exchange_weak", 27) != 0)
        break;
      return std::make_pair(1633, 42);	 // "atomic_compare_exchange_weak"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "apture_event_profiling_info", 27) != 0)
        break;
      return std::make_pair(2698, 1);	 // "capture_event_profiling_info"
    case 'd':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "ot_acc_sat_4x8packed_", 21) != 0)
        break;
      switch (Name[22]) {
      default: break;
      case 's':	 // 2 strings to match.
        switch (Name[23]) {
        default: break;
        case 's':	 // 1 string to match.
          if (memcmp(Name.data()+24, "_int", 4) != 0)
            break;
          return std::make_pair(106, 1);	 // "dot_acc_sat_4x8packed_ss_int"
        case 'u':	 // 1 string to match.
          if (memcmp(Name.data()+24, "_int", 4) != 0)
            break;
          return std::make_pair(106, 1);	 // "dot_acc_sat_4x8packed_su_int"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(Name.data()+23, "s_int", 5) != 0)
          break;
        return std::make_pair(106, 1);	 // "dot_acc_sat_4x8packed_us_int"
      }
      break;
    case 's':	 // 7 strings to match.
      if (memcmp(Name.data()+1, "ub_group_", 9) != 0)
        break;
      switch (Name[10]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+11, "allot_bit_extract", 17) != 0)
          break;
        return std::make_pair(2756, 1);	 // "sub_group_ballot_bit_extract"
      case 's':	 // 6 strings to match.
        if (memcmp(Name.data()+11, "can_", 4) != 0)
          break;
        switch (Name[15]) {
        default: break;
        case 'e':	 // 3 strings to match.
          if (memcmp(Name.data()+16, "xclusive_", 9) != 0)
            break;
          switch (Name[25]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Name.data()+26, "dd", 2) != 0)
              break;
            return std::make_pair(2747, 2);	 // "sub_group_scan_exclusive_add"
          case 'm':	 // 2 strings to match.
            switch (Name[26]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Name[27] != 'x')
                break;
              return std::make_pair(2747, 2);	 // "sub_group_scan_exclusive_max"
            case 'i':	 // 1 string to match.
              if (Name[27] != 'n')
                break;
              return std::make_pair(2747, 2);	 // "sub_group_scan_exclusive_min"
            }
            break;
          }
          break;
        case 'i':	 // 3 strings to match.
          if (memcmp(Name.data()+16, "nclusive_", 9) != 0)
            break;
          switch (Name[25]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Name.data()+26, "dd", 2) != 0)
              break;
            return std::make_pair(2747, 2);	 // "sub_group_scan_inclusive_add"
          case 'm':	 // 2 strings to match.
            switch (Name[26]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Name[27] != 'x')
                break;
              return std::make_pair(2747, 2);	 // "sub_group_scan_inclusive_max"
            case 'i':	 // 1 string to match.
              if (Name[27] != 'n')
                break;
              return std::make_pair(2747, 2);	 // "sub_group_scan_inclusive_min"
            }
            break;
          }
          break;
        }
        break;
      }
      break;
    }
    break;
  case 29:	 // 9 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sync_work_group_strided_copy", 28) != 0)
        break;
      return std::make_pair(1490, 2);	 // "async_work_group_strided_copy"
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ot_acc_sat_4x8packed_uu_uint", 28) != 0)
        break;
      return std::make_pair(105, 1);	 // "dot_acc_sat_4x8packed_uu_uint"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_clustered_reduce_or", 28) != 0)
        break;
      return std::make_pair(62, 1);	 // "sub_group_clustered_reduce_or"
    case 'w':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "ork_group_scan_", 15) != 0)
        break;
      switch (Name[16]) {
      default: break;
      case 'e':	 // 3 strings to match.
        if (memcmp(Name.data()+17, "xclusive_", 9) != 0)
          break;
        switch (Name[26]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+27, "dd", 2) != 0)
            break;
          return std::make_pair(2691, 1);	 // "work_group_scan_exclusive_add"
        case 'm':	 // 2 strings to match.
          switch (Name[27]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[28] != 'x')
              break;
            return std::make_pair(2691, 1);	 // "work_group_scan_exclusive_max"
          case 'i':	 // 1 string to match.
            if (Name[28] != 'n')
              break;
            return std::make_pair(2691, 1);	 // "work_group_scan_exclusive_min"
          }
          break;
        }
        break;
      case 'i':	 // 3 strings to match.
        if (memcmp(Name.data()+17, "nclusive_", 9) != 0)
          break;
        switch (Name[26]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Name.data()+27, "dd", 2) != 0)
            break;
          return std::make_pair(2691, 1);	 // "work_group_scan_inclusive_add"
        case 'm':	 // 2 strings to match.
          switch (Name[27]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[28] != 'x')
              break;
            return std::make_pair(2691, 1);	 // "work_group_scan_inclusive_max"
          case 'i':	 // 1 string to match.
            if (Name[28] != 'n')
              break;
            return std::make_pair(2691, 1);	 // "work_group_scan_inclusive_min"
          }
          break;
        }
        break;
      }
      break;
    }
    break;
  case 30:	 // 7 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_compare_exchange_strong", 29) != 0)
        break;
      return std::make_pair(1633, 42);	 // "atomic_compare_exchange_strong"
    case 's':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "ub_group_clustered_reduce_", 26) != 0)
        break;
      switch (Name[27]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (Name[28]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (Name[29] != 'd')
            break;
          return std::make_pair(61, 1);	 // "sub_group_clustered_reduce_add"
        case 'n':	 // 1 string to match.
          if (Name[29] != 'd')
            break;
          return std::make_pair(62, 1);	 // "sub_group_clustered_reduce_and"
        }
        break;
      case 'm':	 // 3 strings to match.
        switch (Name[28]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Name[29] != 'x')
            break;
          return std::make_pair(61, 1);	 // "sub_group_clustered_reduce_max"
        case 'i':	 // 1 string to match.
          if (Name[29] != 'n')
            break;
          return std::make_pair(61, 1);	 // "sub_group_clustered_reduce_min"
        case 'u':	 // 1 string to match.
          if (Name[29] != 'l')
            break;
          return std::make_pair(61, 1);	 // "sub_group_clustered_reduce_mul"
        }
        break;
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+28, "or", 2) != 0)
          break;
        return std::make_pair(62, 1);	 // "sub_group_clustered_reduce_xor"
      }
      break;
    }
    break;
  case 31:	 // 5 strings to match.
    if (memcmp(Name.data()+0, "sub_group_", 10) != 0)
      break;
    switch (Name[10]) {
    default: break;
    case 'b':	 // 2 strings to match.
      if (memcmp(Name.data()+11, "allot_", 6) != 0)
        break;
      switch (Name[17]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Name.data()+18, "xclusive_scan", 13) != 0)
          break;
        return std::make_pair(2758, 1);	 // "sub_group_ballot_exclusive_scan"
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+18, "nclusive_scan", 13) != 0)
          break;
        return std::make_pair(2758, 1);	 // "sub_group_ballot_inclusive_scan"
      }
      break;
    case 'n':	 // 3 strings to match.
      if (memcmp(Name.data()+11, "on_uniform_", 11) != 0)
        break;
      switch (Name[22]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+23, "ll_equal", 8) != 0)
          break;
        return std::make_pair(2751, 1);	 // "sub_group_non_uniform_all_equal"
      case 'b':	 // 1 string to match.
        if (memcmp(Name.data()+23, "roadcast", 8) != 0)
          break;
        return std::make_pair(2752, 1);	 // "sub_group_non_uniform_broadcast"
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+23, "educe_or", 8) != 0)
          break;
        return std::make_pair(24, 1);	 // "sub_group_non_uniform_reduce_or"
      }
      break;
    }
    break;
  case 32:	 // 6 strings to match.
    if (memcmp(Name.data()+0, "sub_group_non_uniform_reduce_", 29) != 0)
      break;
    switch (Name[29]) {
    default: break;
    case 'a':	 // 2 strings to match.
      switch (Name[30]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (Name[31] != 'd')
          break;
        return std::make_pair(23, 1);	 // "sub_group_non_uniform_reduce_add"
      case 'n':	 // 1 string to match.
        if (Name[31] != 'd')
          break;
        return std::make_pair(24, 1);	 // "sub_group_non_uniform_reduce_and"
      }
      break;
    case 'm':	 // 3 strings to match.
      switch (Name[30]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[31] != 'x')
          break;
        return std::make_pair(23, 1);	 // "sub_group_non_uniform_reduce_max"
      case 'i':	 // 1 string to match.
        if (Name[31] != 'n')
          break;
        return std::make_pair(23, 1);	 // "sub_group_non_uniform_reduce_min"
      case 'u':	 // 1 string to match.
        if (Name[31] != 'l')
          break;
        return std::make_pair(23, 1);	 // "sub_group_non_uniform_reduce_mul"
      }
      break;
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+30, "or", 2) != 0)
        break;
      return std::make_pair(24, 1);	 // "sub_group_non_uniform_reduce_xor"
    }
    break;
  case 33:	 // 1 string to match.
    if (memcmp(Name.data()+0, "atomic_flag_test_and_set_explicit", 33) != 0)
      break;
    return std::make_pair(2006, 6);	 // "atomic_flag_test_and_set_explicit"
  case 37:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_compare_exchange_weak_explicit", 36) != 0)
        break;
      return std::make_pair(1675, 84);	 // "atomic_compare_exchange_weak_explicit"
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ub_group_clustered_reduce_logical_or", 36) != 0)
        break;
      return std::make_pair(63, 1);	 // "sub_group_clustered_reduce_logical_or"
    }
    break;
  case 38:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "sub_group_clustered_reduce_logical_", 35) != 0)
      break;
    switch (Name[35]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+36, "nd", 2) != 0)
        break;
      return std::make_pair(63, 1);	 // "sub_group_clustered_reduce_logical_and"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+36, "or", 2) != 0)
        break;
      return std::make_pair(63, 1);	 // "sub_group_clustered_reduce_logical_xor"
    }
    break;
  case 39:	 // 4 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "tomic_compare_exchange_strong_explicit", 38) != 0)
        break;
      return std::make_pair(1675, 84);	 // "atomic_compare_exchange_strong_explicit"
    case 's':	 // 3 strings to match.
      if (memcmp(Name.data()+1, "ub_group_non_uniform_", 21) != 0)
        break;
      switch (Name[22]) {
      default: break;
      case 'r':	 // 1 string to match.
        if (memcmp(Name.data()+23, "educe_logical_or", 16) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_reduce_logical_or"
      case 's':	 // 2 strings to match.
        if (memcmp(Name.data()+23, "can_", 4) != 0)
          break;
        switch (Name[27]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (memcmp(Name.data()+28, "xclusive_or", 11) != 0)
            break;
          return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_exclusive_or"
        case 'i':	 // 1 string to match.
          if (memcmp(Name.data()+28, "nclusive_or", 11) != 0)
            break;
          return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_inclusive_or"
        }
        break;
      }
      break;
    }
    break;
  case 40:	 // 14 strings to match.
    if (memcmp(Name.data()+0, "sub_group_non_uniform_", 22) != 0)
      break;
    switch (Name[22]) {
    default: break;
    case 'r':	 // 2 strings to match.
      if (memcmp(Name.data()+23, "educe_logical_", 14) != 0)
        break;
      switch (Name[37]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+38, "nd", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_reduce_logical_and"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+38, "or", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_reduce_logical_xor"
      }
      break;
    case 's':	 // 12 strings to match.
      if (memcmp(Name.data()+23, "can_", 4) != 0)
        break;
      switch (Name[27]) {
      default: break;
      case 'e':	 // 6 strings to match.
        if (memcmp(Name.data()+28, "xclusive_", 9) != 0)
          break;
        switch (Name[37]) {
        default: break;
        case 'a':	 // 2 strings to match.
          switch (Name[38]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Name[39] != 'd')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_exclusive_add"
          case 'n':	 // 1 string to match.
            if (Name[39] != 'd')
              break;
            return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_exclusive_and"
          }
          break;
        case 'm':	 // 3 strings to match.
          switch (Name[38]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[39] != 'x')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_exclusive_max"
          case 'i':	 // 1 string to match.
            if (Name[39] != 'n')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_exclusive_min"
          case 'u':	 // 1 string to match.
            if (Name[39] != 'l')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_exclusive_mul"
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Name.data()+38, "or", 2) != 0)
            break;
          return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_exclusive_xor"
        }
        break;
      case 'i':	 // 6 strings to match.
        if (memcmp(Name.data()+28, "nclusive_", 9) != 0)
          break;
        switch (Name[37]) {
        default: break;
        case 'a':	 // 2 strings to match.
          switch (Name[38]) {
          default: break;
          case 'd':	 // 1 string to match.
            if (Name[39] != 'd')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_inclusive_add"
          case 'n':	 // 1 string to match.
            if (Name[39] != 'd')
              break;
            return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_inclusive_and"
          }
          break;
        case 'm':	 // 3 strings to match.
          switch (Name[38]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Name[39] != 'x')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_inclusive_max"
          case 'i':	 // 1 string to match.
            if (Name[39] != 'n')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_inclusive_min"
          case 'u':	 // 1 string to match.
            if (Name[39] != 'l')
              break;
            return std::make_pair(23, 1);	 // "sub_group_non_uniform_scan_inclusive_mul"
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Name.data()+38, "or", 2) != 0)
            break;
          return std::make_pair(24, 1);	 // "sub_group_non_uniform_scan_inclusive_xor"
        }
        break;
      }
      break;
    }
    break;
  case 47:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "sub_group_non_uniform_scan_", 27) != 0)
      break;
    switch (Name[27]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(Name.data()+28, "xclusive_logical_or", 19) != 0)
        break;
      return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_exclusive_logical_or"
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+28, "nclusive_logical_or", 19) != 0)
        break;
      return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_inclusive_logical_or"
    }
    break;
  case 48:	 // 4 strings to match.
    if (memcmp(Name.data()+0, "sub_group_non_uniform_scan_", 27) != 0)
      break;
    switch (Name[27]) {
    default: break;
    case 'e':	 // 2 strings to match.
      if (memcmp(Name.data()+28, "xclusive_logical_", 17) != 0)
        break;
      switch (Name[45]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+46, "nd", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_exclusive_logical_and"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+46, "or", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_exclusive_logical_xor"
      }
      break;
    case 'i':	 // 2 strings to match.
      if (memcmp(Name.data()+28, "nclusive_logical_", 17) != 0)
        break;
      switch (Name[45]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Name.data()+46, "nd", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_inclusive_logical_and"
      case 'x':	 // 1 string to match.
        if (memcmp(Name.data()+46, "or", 2) != 0)
          break;
        return std::make_pair(25, 1);	 // "sub_group_non_uniform_scan_inclusive_logical_xor"
      }
      break;
    }
    break;
  }
  return std::make_pair(0, 0);
} // isOpenCLBuiltin


static QualType getOpenCLEnumType(Sema &S, llvm::StringRef Name);
static QualType getOpenCLTypedefType(Sema &S, llvm::StringRef Name);

// Convert an OpenCLTypeStruct type to a list of QualTypes.
// Generic types represent multiple types and vector sizes, thus a vector
// is returned. The conversion is done in two steps:
// Step 1: A switch statement fills a vector with scalar base types for the
//         Cartesian product of (vector sizes) x (types) for generic types,
//         or a single scalar type for non generic types.
// Step 2: Qualifiers and other type properties such as vector size are
//         applied.
static void OCL2Qual(Sema &S, const OpenCLTypeStruct &Ty,
                     llvm::SmallVectorImpl<QualType> &QT) {
  ASTContext &Context = S.Context;
  // Number of scalar types in the GenType.
  unsigned GenTypeNumTypes;
  // Pointer to the list of vector sizes for the GenType.
  llvm::ArrayRef<unsigned> GenVectorSizes;
  constexpr unsigned ListVec1[] = {1, };
  constexpr unsigned ListVec1234[] = {1, 2, 3, 4, };
  constexpr unsigned ListVecAndScalar[] = {1, 2, 3, 4, 8, 16, };
  constexpr unsigned ListVecNoScalar[] = {2, 3, 4, 8, 16, };

  switch (Ty.ID) {
    case OCLT_image2d_depth_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dDepthROTy);
          }
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dDepthRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dDepthWOTy);
          }
          break;
      }
      break;
    case OCLT_image2d_array_msaa_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dArrayMSAAROTy);
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dArrayMSAAWOTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dArrayMSAARWTy);
          }
          break;
      }
      break;
    case OCLT_image2d_msaa_depth_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dMSAADepthROTy);
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dMSAADepthWOTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dMSAADepthRWTy);
          }
          break;
      }
      break;
    case OCLT_image2d_msaa_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dMSAAROTy);
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dMSAAWOTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dMSAARWTy);
          }
          break;
      }
      break;
    case OCLT_image1d_buffer_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage1dBufferROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage1dBufferRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage1dBufferWOTy);
          break;
      }
      break;
    case OCLT_image1d_array_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage1dArrayROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage1dArrayRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage1dArrayWOTy);
          break;
      }
      break;
    case OCLT_image2d_array_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dArrayROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dArrayRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dArrayWOTy);
          break;
      }
      break;
    case OCLT_image1d_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage1dROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage1dRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage1dWOTy);
          break;
      }
      break;
    case OCLT_image2d_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dWOTy);
          break;
      }
      break;
    case OCLT_image3d_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage3dROTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("cl_khr_3d_image_writes") && S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage3dRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          if (S.getPreprocessor().isMacroDefined("cl_khr_3d_image_writes")) {
            QT.push_back(Context.OCLImage3dWOTy);
          }
          break;
      }
      break;
    case OCLT_image2d_array_depth_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dArrayDepthROTy);
          }
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dArrayDepthRWTy);
          }
          break;
        case OCLAQ_WriteOnly:
          if (S.getPreprocessor().isMacroDefined("cl_khr_depth_images")) {
            QT.push_back(Context.OCLImage2dArrayDepthWOTy);
          }
          break;
      }
      break;
    case OCLT_image2d_array_msaa_depth_t:
      switch (Ty.AccessQualifier) {
        case OCLAQ_None:
          llvm_unreachable("Image without access qualifier");
        case OCLAQ_ReadOnly:
          QT.push_back(Context.OCLImage2dArrayMSAADepthROTy);
          break;
        case OCLAQ_WriteOnly:
          QT.push_back(Context.OCLImage2dArrayMSAADepthWOTy);
          break;
        case OCLAQ_ReadWrite:
          if (S.getPreprocessor().isMacroDefined("__opencl_c_read_write_images")) {
            QT.push_back(Context.OCLImage2dArrayMSAADepthRWTy);
          }
          break;
      }
      break;
    case OCLT_AGenType1: {
      SmallVector<QualType, 11> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      TypeList.push_back(Context.FloatTy);
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(11);
      for (unsigned I = 0; I < 1; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1;
      break;
    }
    case OCLT_AGenTypeN: {
      SmallVector<QualType, 11> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      TypeList.push_back(Context.FloatTy);
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(66);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_AGenTypeNNoScalar: {
      SmallVector<QualType, 11> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      TypeList.push_back(Context.FloatTy);
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(55);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_AI2UGenTypeN: {
      SmallVector<QualType, 8> TypeList;
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.UnsignedLongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(48);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_AIGenType1: {
      SmallVector<QualType, 8> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(8);
      for (unsigned I = 0; I < 1; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1;
      break;
    }
    case OCLT_AIGenTypeN: {
      SmallVector<QualType, 8> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(48);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_AIGenTypeNNoScalar: {
      SmallVector<QualType, 8> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(40);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_CharShortGenType1: {
      SmallVector<QualType, 4> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.UnsignedShortTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(4);
      for (unsigned I = 0; I < 1; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1;
      break;
    }
    case OCLT_FGenTypeN: {
      SmallVector<QualType, 3> TypeList;
      TypeList.push_back(Context.FloatTy);
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(18);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeCharVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.CharTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeCharVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.CharTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeDoubleVec1234: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(4);
      for (unsigned I = 0; I < 4; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1234;
      break;
    }
    case OCLT_GenTypeDoubleVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeDoubleVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeFloatVec1234: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.FloatTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(4);
      for (unsigned I = 0; I < 4; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1234;
      break;
    }
    case OCLT_GenTypeFloatVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.FloatTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeFloatVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.FloatTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeHalfVec1234: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(4);
      for (unsigned I = 0; I < 4; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1234;
      break;
    }
    case OCLT_GenTypeHalfVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeHalfVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeIntVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.IntTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeIntVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.IntTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeLongVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.LongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeLongVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.LongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeShortVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.ShortTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeShortVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.ShortTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeUCharVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedCharTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeUCharVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedCharTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeUIntVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedIntTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeUIntVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedIntTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeULongVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeULongVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_GenTypeUShortVecAndScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedShortTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(6);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_GenTypeUShortVecNoScalar: {
      SmallVector<QualType, 1> TypeList;
      TypeList.push_back(Context.UnsignedShortTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(5);
      for (unsigned I = 0; I < 5; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecNoScalar;
      break;
    }
    case OCLT_IntLongFloatGenType1: {
      SmallVector<QualType, 7> TypeList;
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.LongTy);
      TypeList.push_back(Context.UnsignedLongTy);
      TypeList.push_back(Context.FloatTy);
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        TypeList.push_back(Context.DoubleTy);
      }
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        TypeList.push_back(Context.HalfTy);
      }
      GenTypeNumTypes = TypeList.size();
      QT.reserve(7);
      for (unsigned I = 0; I < 1; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVec1;
      break;
    }
    case OCLT_SGenTypeN: {
      SmallVector<QualType, 4> TypeList;
      TypeList.push_back(Context.CharTy);
      TypeList.push_back(Context.ShortTy);
      TypeList.push_back(Context.IntTy);
      TypeList.push_back(Context.LongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(24);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_UGenTypeN: {
      SmallVector<QualType, 4> TypeList;
      TypeList.push_back(Context.UnsignedCharTy);
      TypeList.push_back(Context.UnsignedShortTy);
      TypeList.push_back(Context.UnsignedIntTy);
      TypeList.push_back(Context.UnsignedLongTy);
      GenTypeNumTypes = TypeList.size();
      QT.reserve(24);
      for (unsigned I = 0; I < 6; I++) {
        QT.append(TypeList);
      }
      GenVectorSizes = ListVecAndScalar;
      break;
    }
    case OCLT_atomic_double:
      if (S.getPreprocessor().isMacroDefined("cl_khr_int64_base_atomics") && S.getPreprocessor().isMacroDefined("cl_khr_int64_extended_atomics") && S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        QT.push_back(Context.getAtomicType(Context.DoubleTy));
      }
      break;
    case OCLT_atomic_flag:
      QT.push_back(getOpenCLTypedefType(S, "atomic_flag"));
      break;
    case OCLT_atomic_float:
      QT.push_back(Context.getAtomicType(Context.FloatTy));
      break;
    case OCLT_atomic_half:
      QT.push_back(Context.getAtomicType(Context.HalfTy));
      break;
    case OCLT_atomic_int:
      QT.push_back(Context.getAtomicType(Context.IntTy));
      break;
    case OCLT_atomic_intptr_t:
      QT.push_back(Context.getAtomicType(Context.getIntPtrType()));
      break;
    case OCLT_atomic_long:
      if (S.getPreprocessor().isMacroDefined("cl_khr_int64_base_atomics") && S.getPreprocessor().isMacroDefined("cl_khr_int64_extended_atomics")) {
        QT.push_back(Context.getAtomicType(Context.LongTy));
      }
      break;
    case OCLT_atomic_ptrdiff_t:
      QT.push_back(Context.getAtomicType(Context.getPointerDiffType()));
      break;
    case OCLT_atomic_size_t:
      QT.push_back(Context.getAtomicType(Context.getSizeType()));
      break;
    case OCLT_atomic_uint:
      QT.push_back(Context.getAtomicType(Context.UnsignedIntTy));
      break;
    case OCLT_atomic_uintptr_t:
      QT.push_back(Context.getAtomicType(Context.getUIntPtrType()));
      break;
    case OCLT_atomic_ulong:
      if (S.getPreprocessor().isMacroDefined("cl_khr_int64_base_atomics") && S.getPreprocessor().isMacroDefined("cl_khr_int64_extended_atomics")) {
        QT.push_back(Context.getAtomicType(Context.UnsignedLongTy));
      }
      break;
    case OCLT_bool:
      QT.push_back(Context.BoolTy);
      break;
    case OCLT_char:
      QT.push_back(Context.CharTy);
      break;
    case OCLT_clk_event_t:
      QT.push_back(Context.OCLClkEventTy);
      break;
    case OCLT_clk_profiling_info:
      QT.push_back(getOpenCLTypedefType(S, "clk_profiling_info"));
      break;
    case OCLT_double:
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp64")) {
        QT.push_back(Context.DoubleTy);
      }
      break;
    case OCLT_event_t:
      QT.push_back(Context.OCLEventTy);
      break;
    case OCLT_float:
      QT.push_back(Context.FloatTy);
      break;
    case OCLT_half:
      if (S.getPreprocessor().isMacroDefined("cl_khr_fp16")) {
        QT.push_back(Context.HalfTy);
      }
      break;
    case OCLT___half:
      QT.push_back(Context.HalfTy);
      break;
    case OCLT_int:
      QT.push_back(Context.IntTy);
      break;
    case OCLT_intptr_t:
      QT.push_back(Context.getIntPtrType());
      break;
    case OCLT_long:
      QT.push_back(Context.LongTy);
      break;
    case OCLT_cl_mem_fence_flags:
      QT.push_back(getOpenCLTypedefType(S, "cl_mem_fence_flags"));
      break;
    case OCLT_memory_order:
      QT.push_back(getOpenCLEnumType(S, "memory_order"));
      break;
    case OCLT_memory_scope:
      QT.push_back(getOpenCLEnumType(S, "memory_scope"));
      break;
    case OCLT_ndrange_t:
      QT.push_back(getOpenCLTypedefType(S, "ndrange_t"));
      break;
    case OCLT_ptrdiff_t:
      QT.push_back(Context.getPointerDiffType());
      break;
    case OCLT_queue_t:
      QT.push_back(Context.OCLQueueTy);
      break;
    case OCLT_reserve_id_t:
      QT.push_back(Context.OCLReserveIDTy);
      break;
    case OCLT_sampler_t:
      QT.push_back(Context.OCLSamplerTy);
      break;
    case OCLT_short:
      QT.push_back(Context.ShortTy);
      break;
    case OCLT_size_t:
      QT.push_back(Context.getSizeType());
      break;
    case OCLT_uchar:
      QT.push_back(Context.UnsignedCharTy);
      break;
    case OCLT_uint:
      QT.push_back(Context.UnsignedIntTy);
      break;
    case OCLT_uintptr_t:
      QT.push_back(Context.getUIntPtrType());
      break;
    case OCLT_ulong:
      QT.push_back(Context.UnsignedLongTy);
      break;
    case OCLT_ushort:
      QT.push_back(Context.UnsignedShortTy);
      break;
    case OCLT_void:
      QT.push_back(Context.VoidTy);
      break;
  } // end of switch (Ty.ID)

  // Construct the different vector types for each generic type.
  if (Ty.ID >= 52) {
    for (unsigned I = 0; I < QT.size(); I++) {
      // For scalars, size is 1.
      if (GenVectorSizes[I / GenTypeNumTypes] != 1) {
        QT[I] = Context.getExtVectorType(QT[I],
                          GenVectorSizes[I / GenTypeNumTypes]);
      }
    }
  }

  // Set vector size for non-generic vector types.
  if (Ty.VectorWidth > 1) {
    for (unsigned Index = 0; Index < QT.size(); Index++) {
      QT[Index] = Context.getExtVectorType(QT[Index], Ty.VectorWidth);
    }
  }

  if (Ty.IsVolatile != 0) {
    for (unsigned Index = 0; Index < QT.size(); Index++) {
      QT[Index] = Context.getVolatileType(QT[Index]);
    }
  }

  if (Ty.IsConst != 0) {
    for (unsigned Index = 0; Index < QT.size(); Index++) {
      QT[Index] = Context.getConstType(QT[Index]);
    }
  }

  // Transform the type to a pointer as the last step, if necessary.
  // Builtin functions only have pointers on [const|volatile], no
  // [const|volatile] pointers, so this is ok to do it as a last step.
  if (Ty.IsPointer != 0) {
    for (unsigned Index = 0; Index < QT.size(); Index++) {
      QT[Index] = Context.getAddrSpaceQualType(QT[Index], Ty.AS);
      QT[Index] = Context.getPointerType(QT[Index]);
    }
  }

} // OCL2Qual
