/* reversi-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from reversi-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2010-2013 Robert Ancell
   Copyright 2013-2014 Michael Catanzaro
   Copyright 2014-2019 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>

#define REVERSI_VIEW_HIGHLIGHT_MAX ((guint8) 5)
#define REVERSI_VIEW_PIXMAP_FLIP_DELAY 20
#define REVERSI_VIEW_HUMANS_OPENING_INTENSITY_MAX ((guint8) 15)
#define REVERSI_VIEW_OVERTURE_STEPS_MAX ((guint8) 10)
#define REVERSI_VIEW_HALF_PI G_PI_2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_REVERSI_VIEW (reversi_view_get_type ())
#define REVERSI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REVERSI_VIEW, ReversiView))
#define REVERSI_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REVERSI_VIEW, ReversiViewClass))
#define IS_REVERSI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REVERSI_VIEW))
#define IS_REVERSI_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REVERSI_VIEW))
#define REVERSI_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REVERSI_VIEW, ReversiViewClass))

typedef struct _ReversiView ReversiView;
typedef struct _ReversiViewClass ReversiViewClass;
typedef struct _ReversiViewPrivate ReversiViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;

#define TYPE_GAME_STATE_OBJECT (game_state_object_get_type ())
#define GAME_STATE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_STATE_OBJECT, GameStateObject))
#define GAME_STATE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_STATE_OBJECT, GameStateObjectClass))
#define IS_GAME_STATE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_STATE_OBJECT))
#define IS_GAME_STATE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_STATE_OBJECT))
#define GAME_STATE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_STATE_OBJECT, GameStateObjectClass))

typedef struct _GameStateObject GameStateObject;
typedef struct _GameStateObjectClass GameStateObjectClass;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())
enum  {
	REVERSI_VIEW_0_PROPERTY,
	REVERSI_VIEW_SHOW_PLAYABLE_TILES_PROPERTY,
	REVERSI_VIEW_SHOW_TURNABLE_TILES_PROPERTY,
	REVERSI_VIEW_GAME_PROPERTY,
	REVERSI_VIEW_IAGNO_INSTANCE_PROPERTY,
	REVERSI_VIEW_THEME_MANAGER_PROPERTY,
	REVERSI_VIEW_NUM_PROPERTIES
};
static GParamSpec* reversi_view_properties[REVERSI_VIEW_NUM_PROPERTIES];
typedef enum  {
	REVERSI_VIEW_DIRECTION_TOP,
	REVERSI_VIEW_DIRECTION_LEFT,
	REVERSI_VIEW_DIRECTION_RIGHT,
	REVERSI_VIEW_DIRECTION_BOTTOM
} ReversiViewDirection;

#define REVERSI_VIEW_TYPE_DIRECTION (reversi_view_direction_get_type ())
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	OPENING_HUMANS,
	OPENING_REVERSI,
	OPENING_INVERTED,
	OPENING_ALTER_TOP,
	OPENING_ALTER_LEFT,
	OPENING_ALTER_RIGHT,
	OPENING_ALTER_BOTTOM
} Opening;

#define TYPE_OPENING (opening_get_type ())

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_POSSIBLE_MOVE (possible_move_get_type ())
typedef struct _PossibleMove PossibleMove;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	REVERSI_VIEW_MOVE_SIGNAL,
	REVERSI_VIEW_CLEAR_IMPOSSIBLE_TO_MOVE_HERE_WARNING_SIGNAL,
	REVERSI_VIEW_NOTIFY_FINAL_ANIMATION_SIGNAL,
	REVERSI_VIEW_NUM_SIGNALS
};
static guint reversi_view_signals[REVERSI_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ReversiView {
	GtkDrawingArea parent_instance;
	ReversiViewPrivate * priv;
};

struct _ReversiViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ReversiViewPrivate {
	gboolean _show_playable_tiles;
	gboolean _show_turnable_tiles;
	gint board_x;
	gint board_y;
	gboolean show_highlight;
	gboolean highlight_set;
	guint8 highlight_x;
	guint8 highlight_y;
	guint8 old_highlight_x;
	guint8 old_highlight_y;
	guint8 highlight_state;
	gboolean show_mouse_highlight;
	gboolean mouse_position_set;
	guint8 mouse_highlight_x;
	guint8 mouse_highlight_y;
	guint8 mouse_position_x;
	guint8 mouse_position_y;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	cairo_pattern_t* board_pattern;
	gboolean noise_pixbuf_loaded;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	guint8 humans_opening_intensity;
	gboolean game_is_set;
	guint8 game_size;
	Game* _game;
	Iagno* _iagno_instance;
	ThemeManager* _theme_manager;
	gboolean configuration_done;
	gint paving_size;
	gint tile_size;
	gint board_size;
	gint* tile_xs;
	gint tile_xs_length1;
	gint tile_xs_length2;
	gint* tile_ys;
	gint tile_ys_length1;
	gint tile_ys_length2;
	gint* overture_origin_xs;
	gint overture_origin_xs_length1;
	gint _overture_origin_xs_size_;
	gint overture_origin_y;
	guint8* overture_steps;
	gint overture_steps_length1;
	gint _overture_steps_size_;
	guint8* overture_target;
	gint overture_target_length1;
	gint _overture_target_size_;
	guint8 current_overture_playable;
	gboolean last_state_set;
	GameStateObject* last_state;
	gboolean flip_final_result_now;
	Player winning_color;
	gint n_winning_tiles;
	Player losing_color;
	gint n_losing_tiles;
	GtkEventControllerMotion* motion_controller;
	GtkGestureMultiPress* click_controller;
	gboolean mouse_is_in;
	guint timeout_id;
	GtkEventControllerKey* key_controller;
	guint8 playable_tiles_highlight_state;
	gboolean* possible_moves;
	gint possible_moves_length1;
	gint possible_moves_length2;
};

struct _PossibleMove {
	guint8 x;
	guint8 y;
	guint8 n_tiles;
	guint8 n_tiles_n;
	guint8 n_tiles_ne;
	guint8 n_tiles_e;
	guint8 n_tiles_se;
	guint8 n_tiles_s;
	guint8 n_tiles_so;
	guint8 n_tiles_o;
	guint8 n_tiles_no;
};

struct _Block7Data {
	int _ref_count_;
	ReversiView* self;
	gboolean is_final_animation;
};

struct _Block8Data {
	int _ref_count_;
	ReversiView* self;
	guint8 x;
	guint8 y;
};

static gint ReversiView_private_offset;
static gpointer reversi_view_parent_class = NULL;

VALA_EXTERN GType reversi_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReversiView, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType iagno_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Iagno, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
VALA_EXTERN GType game_state_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameStateObject, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
static GType reversi_view_direction_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN ReversiView* reversi_view_new (Iagno* iagno_instance,
                               ThemeManager* theme_manager);
VALA_EXTERN ReversiView* reversi_view_construct (GType object_type,
                                     Iagno* iagno_instance,
                                     ThemeManager* theme_manager);
static gboolean reversi_view_real_configure_event (GtkWidget* base,
                                            GdkEventConfigure* e);
static void reversi_view_configure_theme (ReversiView* self);
static ThemeManager* reversi_view_get_theme_manager (ReversiView* self);
VALA_EXTERN gint theme_manager_get_border_width (ThemeManager* self);
VALA_EXTERN gint theme_manager_get_spacing_width (ThemeManager* self);
static inline void reversi_view_configure_overture_origin (ReversiView* self);
static gboolean reversi_view_real_draw (GtkWidget* base,
                                 cairo_t* cr);
static inline void reversi_view_init_patterns (ReversiView* self,
                                 cairo_t* cr);
static inline void reversi_view_draw_overture (ReversiView* self,
                                 cairo_t* cr);
static inline void reversi_view_draw_highlight (ReversiView* self,
                                  cairo_t* cr);
static inline void reversi_view_add_highlights (ReversiView* self,
                                  cairo_t* cr);
static inline void reversi_view_draw_playables (ReversiView* self,
                                  cairo_t* cr);
static inline void reversi_view_draw_overture_playables (ReversiView* self,
                                           cairo_t* cr);
VALA_EXTERN RsvgHandle* theme_manager_get_tileset_handle (ThemeManager* self);
VALA_EXTERN gboolean theme_manager_get_apply_texture (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_texture_alpha (ThemeManager* self);
static inline void reversi_view_draw_board_background (ReversiView* self,
                                         cairo_t* cr);
static inline void reversi_view_draw_tiles_background (ReversiView* self,
                                         cairo_t* cr,
                                         cairo_pattern_t** noise_pattern);
VALA_EXTERN gdouble theme_manager_get_spacing_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_spacing_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_spacing_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_half_border_width (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_blue (ThemeManager* self);
static inline void reversi_view_draw_tile_background (ReversiView* self,
                                        cairo_t* cr,
                                        cairo_pattern_t** noise_pattern,
                                        gint tile_x,
                                        gint tile_y);
VALA_EXTERN gdouble theme_manager_get_background_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_background_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_background_blue (ThemeManager* self);
static void reversi_view_rounded_square (ReversiView* self,
                                  cairo_t* cr,
                                  gdouble x,
                                  gdouble y,
                                  gint size,
                                  gdouble width,
                                  gdouble radius_percent);
VALA_EXTERN gint theme_manager_get_background_radius (ThemeManager* self);
static void reversi_view_darken_tile (ReversiView* self,
                               cairo_t* cr,
                               guint8 x,
                               guint8 y);
VALA_EXTERN Game* reversi_view_get_game (ReversiView* self);
VALA_EXTERN GType opening_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Opening game_get_opening (Game* self);
VALA_EXTERN gboolean game_get_is_complete (Game* self);
static Iagno* reversi_view_get_iagno_instance (ReversiView* self);
VALA_EXTERN Player iagno_get_player_one (Iagno* self);
VALA_EXTERN Player game_get_current_color (Game* self);
VALA_EXTERN GType computer_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerPlayer, g_object_unref)
VALA_EXTERN ComputerPlayer* iagno_get_computer (Iagno* self);
static inline void reversi_view_draw_tile_highlight (ReversiView* self,
                                       cairo_t* cr,
                                       guint8 x,
                                       guint8 y);
VALA_EXTERN GType possible_move_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PossibleMove* possible_move_dup (const PossibleMove* self);
VALA_EXTERN void possible_move_free (PossibleMove* self);
VALA_EXTERN gboolean game_test_placing_tile (Game* self,
                                 guint8 x,
                                 guint8 y,
                                 PossibleMove* move);
static void reversi_view_queue_draw_tile (ReversiView* self,
                                   guint8 x,
                                   guint8 y);
static void reversi_view_highlight_tile (ReversiView* self,
                                  cairo_t* cr,
                                  guint8 x,
                                  guint8 y,
                                  guint8 intensity,
                                  gboolean soft_highlight);
static gboolean reversi_view_get_show_turnable_tiles (ReversiView* self);
static inline void reversi_view_highlight_turnable_tiles (ReversiView* self,
                                            cairo_t* cr,
                                            guint8 x,
                                            guint8 y,
                                            gint8 x_step,
                                            gint8 y_step,
                                            guint8 count);
static gboolean reversi_view_get_show_playable_tiles (ReversiView* self);
static void reversi_view_init_possible_moves (ReversiView* self);
static inline void reversi_view_add_highlight (ReversiView* self,
                                 cairo_t* cr,
                                 guint8 x,
                                 guint8 y,
                                 guint8 intensity);
static inline void reversi_view_draw_playable (ReversiView* self,
                                 cairo_t* cr,
                                 gint pixmap,
                                 gint tile_x,
                                 gint tile_y);
static inline void reversi_view_draw_overture_indicator (ReversiView* self,
                                           cairo_t* cr);
static inline void reversi_view_draw_overture_playable (ReversiView* self,
                                          cairo_t* cr,
                                          guint8 playable_id);
static void reversi_view_get_x_and_y (ReversiView* self,
                               guint8 playable_id,
                               guint8* x,
                               guint8* y);
static void _reversi_view_draw_overture_playable (ReversiView* self,
                                           cairo_t* cr,
                                           gint tile_x,
                                           gint tile_y,
                                           gint pixmap);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_alpha (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_alpha (ThemeManager* self);
static inline void reversi_view_update_highlight_after_undo (ReversiView* self);
static void reversi_view_get_missing_tile (ReversiView* self,
                                    guint8* x,
                                    guint8* y);
static void reversi_view_set_square (ReversiView* self,
                              guint8 x,
                              guint8 y,
                              gint pixmap,
                              gboolean is_final_animation,
                              gboolean force_redraw);
static gint reversi_view_get_pixmap (Player color);
VALA_EXTERN Player game_get_owner (Game* self,
                       guint8 x,
                       guint8 y);
static inline void reversi_view_highlight_playable_tiles (ReversiView* self,
                                            gboolean force_reload);
VALA_EXTERN Player game_state_object_get_owner (GameStateObject* self,
                                    guint8 x,
                                    guint8 y);
static void reversi_view_turn_ended_cb (ReversiView* self,
                                 gboolean undoing,
                                 gboolean no_draw);
VALA_EXTERN GameStateObject* game_get_current_state (Game* self);
static inline void reversi_view_update_squares (ReversiView* self);
static inline void reversi_view_update_square (ReversiView* self,
                                 guint8 x,
                                 guint8 y);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda17_ (Block7Data* _data7_);
static void reversi_view_flip_final_result_tile (ReversiView* self,
                                          guint8 x,
                                          guint8 y);
static void _reversi_view_on_motion (ReversiView* self,
                              guint8 x,
                              guint8 y,
                              gboolean force_redraw);
static gboolean _____lambda17__gsource_func (gpointer self);
static void reversi_view_game_is_complete_cb (ReversiView* self);
VALA_EXTERN guint8 game_get_n_light_tiles (Game* self);
VALA_EXTERN guint8 game_get_n_dark_tiles (Game* self);
static gboolean ___lambda16_ (ReversiView* self);
static void reversi_view_set_winner_and_loser_variables (ReversiView* self);
static gboolean ____lambda16__gsource_func (gpointer self);
VALA_EXTERN gboolean reversi_view_undo_final_animation (ReversiView* self);
static void reversi_view_init_mouse (ReversiView* self);
static void reversi_view_on_motion (ReversiView* self,
                             GtkEventControllerMotion* _motion_controller,
                             gdouble event_x,
                             gdouble event_y);
static void _reversi_view_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self);
static inline void reversi_view_on_click (ReversiView* self,
                            GtkGestureMultiPress* _click_controller,
                            gint n_press,
                            gdouble event_x,
                            gdouble event_y);
static void _reversi_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                             gint n_press,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self);
static gboolean reversi_view_real_enter_notify_event (GtkWidget* base,
                                               GdkEventCrossing* event);
static gboolean reversi_view_pointer_is_in_board (ReversiView* self,
                                           gdouble pos_x,
                                           gdouble pos_y,
                                           guint8* x,
                                           guint8* y);
static void reversi_view_on_cursor_moving_in (ReversiView* self,
                                       guint8 x,
                                       guint8 y);
static gboolean reversi_view_real_leave_notify_event (GtkWidget* base,
                                               GdkEventCrossing* event);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean ______lambda19_ (Block8Data* _data8_);
static gboolean _______lambda19__gsource_func (gpointer self);
static inline void reversi_view_move_if_possible (ReversiView* self,
                                    guint8 x,
                                    guint8 y);
static void reversi_view_init_keyboard (ReversiView* self);
static inline gboolean reversi_view_on_key_pressed (ReversiView* self,
                                      GtkEventControllerKey* _key_controller,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType state);
static gboolean _reversi_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self);
static void reversi_view_set_highlight_position_if_needed (ReversiView* self,
                                                    ReversiViewDirection direction);
static void reversi_view_init_highlight_on_light_tile_if_needed (ReversiView* self);
static void reversi_view_init_highlight_on_light_tile (ReversiView* self);
VALA_EXTERN void game_get_possible_moves (Game* self,
                              GSList** moves);
static void _possible_move_free0_ (gpointer var);
static inline void _g_slist_free__possible_move_free0_ (GSList* self);
static void __lambda18_ (ReversiView* self,
                  PossibleMove* move);
static void ___lambda18__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void reversi_view_set_show_playable_tiles (ReversiView* self,
                                           gboolean value);
VALA_EXTERN void reversi_view_set_show_turnable_tiles (ReversiView* self,
                                           gboolean value);
VALA_EXTERN void reversi_view_set_game (ReversiView* self,
                            Game* value);
VALA_EXTERN guint8 game_get_size (Game* self);
static void _reversi_view_game_is_complete_cb_game_completeness_updated (Game* _sender,
                                                                  gboolean completeness,
                                                                  gpointer self);
static void _reversi_view_turn_ended_cb_game_turn_ended (Game* _sender,
                                                  gboolean undoing,
                                                  gboolean no_draw,
                                                  gpointer self);
static void reversi_view_set_iagno_instance (ReversiView* self,
                                      Iagno* value);
static void reversi_view_set_theme_manager (ReversiView* self,
                                     ThemeManager* value);
static void g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static GObject * reversi_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _reversi_view___lambda20_ (ReversiView* self);
static void __reversi_view___lambda20__theme_manager_theme_changed (ThemeManager* _sender,
                                                             gpointer self);
static void reversi_view_finalize (GObject * obj);
static GType reversi_view_get_type_once (void);
static void _vala_reversi_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_reversi_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
reversi_view_get_instance_private (ReversiView* self)
{
	return G_STRUCT_MEMBER_P (self, ReversiView_private_offset);
}

static GType
reversi_view_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{REVERSI_VIEW_DIRECTION_TOP, "REVERSI_VIEW_DIRECTION_TOP", "top"}, {REVERSI_VIEW_DIRECTION_LEFT, "REVERSI_VIEW_DIRECTION_LEFT", "left"}, {REVERSI_VIEW_DIRECTION_RIGHT, "REVERSI_VIEW_DIRECTION_RIGHT", "right"}, {REVERSI_VIEW_DIRECTION_BOTTOM, "REVERSI_VIEW_DIRECTION_BOTTOM", "bottom"}, {0, NULL, NULL}};
	GType reversi_view_direction_type_id;
	reversi_view_direction_type_id = g_enum_register_static ("ReversiViewDirection", values);
	return reversi_view_direction_type_id;
}

static GType
reversi_view_direction_get_type (void)
{
	static volatile gsize reversi_view_direction_type_id__once = 0;
	if (g_once_init_enter (&reversi_view_direction_type_id__once)) {
		GType reversi_view_direction_type_id;
		reversi_view_direction_type_id = reversi_view_direction_get_type_once ();
		g_once_init_leave (&reversi_view_direction_type_id__once, reversi_view_direction_type_id);
	}
	return reversi_view_direction_type_id__once;
}

ReversiView*
reversi_view_construct (GType object_type,
                        Iagno* iagno_instance,
                        ThemeManager* theme_manager)
{
	ReversiView * self = NULL;
	g_return_val_if_fail (iagno_instance != NULL, NULL);
	g_return_val_if_fail (theme_manager != NULL, NULL);
	self = (ReversiView*) g_object_new (object_type, "iagno-instance", iagno_instance, "theme-manager", theme_manager, NULL);
	return self;
}

ReversiView*
reversi_view_new (Iagno* iagno_instance,
                  ThemeManager* theme_manager)
{
	return reversi_view_construct (TYPE_REVERSI_VIEW, iagno_instance, theme_manager);
}

static gboolean
reversi_view_real_configure_event (GtkWidget* base,
                                   GdkEventConfigure* e)
{
	ReversiView * self;
	gboolean result;
	self = (ReversiView*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	_vala_return_val_if_fail (self->priv->game_is_set, "game_is_set", FALSE);
	reversi_view_configure_theme (self);
	self->priv->configuration_done = TRUE;
	result = TRUE;
	return result;
}

static void
reversi_view_configure_theme (ReversiView* self)
{
	gint allocated_width = 0;
	gint allocated_height = 0;
	gint size = 0;
	ThemeManager* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ThemeManager* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ThemeManager* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ThemeManager* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	ThemeManager* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	ThemeManager* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ThemeManager* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	allocated_width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	allocated_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	size = MIN (allocated_width, allocated_height);
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_border_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_spacing_width (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->paving_size = ((size - (2 * _tmp2_)) + _tmp5_) / self->priv->game_size;
	_tmp6_ = self->priv->_theme_manager;
	_tmp7_ = theme_manager_get_spacing_width (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->tile_size = self->priv->paving_size - _tmp8_;
	_tmp9_ = self->priv->_theme_manager;
	_tmp10_ = theme_manager_get_spacing_width (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_theme_manager;
	_tmp13_ = theme_manager_get_border_width (_tmp12_);
	_tmp14_ = _tmp13_;
	self->priv->board_size = ((self->priv->paving_size * self->priv->game_size) - _tmp11_) + (2 * _tmp14_);
	_tmp15_ = self->priv->_theme_manager;
	_tmp16_ = theme_manager_get_border_width (_tmp15_);
	_tmp17_ = _tmp16_;
	self->priv->board_x = ((allocated_width - self->priv->board_size) / 2) + _tmp17_;
	_tmp18_ = self->priv->_theme_manager;
	_tmp19_ = theme_manager_get_border_width (_tmp18_);
	_tmp20_ = _tmp19_;
	self->priv->board_y = ((allocated_height - self->priv->board_size) / 2) + _tmp20_;
	if (((gint) self->priv->humans_opening_intensity) != 0) {
		reversi_view_configure_overture_origin (self);
	}
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				if (!_tmp21_) {
					guint8 _tmp22_;
					_tmp22_ = x;
					x = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint* _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gint* _tmp26_;
							gint _tmp26__length1;
							gint _tmp26__length2;
							if (!_tmp23_) {
								guint8 _tmp24_;
								_tmp24_ = y;
								y = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							_tmp25_ = self->priv->tile_xs;
							_tmp25__length1 = self->priv->tile_xs_length1;
							_tmp25__length2 = self->priv->tile_xs_length2;
							_tmp25_[(x * _tmp25__length2) + y] = self->priv->paving_size * ((gint) x);
							_tmp26_ = self->priv->tile_ys;
							_tmp26__length1 = self->priv->tile_ys_length1;
							_tmp26__length2 = self->priv->tile_ys_length2;
							_tmp26_[(x * _tmp26__length2) + y] = self->priv->paving_size * ((gint) y);
						}
					}
				}
			}
		}
	}
}

static inline void
reversi_view_configure_overture_origin (ReversiView* self)
{
	g_return_if_fail (self != NULL);
	if ((self->priv->game_size % 2) == 0) {
		gint* _tmp0_;
		gint _tmp0__length1;
		ThemeManager* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint* _tmp4_;
		gint _tmp4__length1;
		ThemeManager* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint* _tmp8_;
		gint _tmp8__length1;
		ThemeManager* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint* _tmp12_;
		gint _tmp12__length1;
		ThemeManager* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp0_ = self->priv->overture_origin_xs;
		_tmp0__length1 = self->priv->overture_origin_xs_length1;
		_tmp1_ = self->priv->_theme_manager;
		_tmp2_ = theme_manager_get_border_width (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_[0] = ((((self->priv->game_size - 3) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp3_) - (self->priv->tile_size / 2);
		_tmp4_ = self->priv->overture_origin_xs;
		_tmp4__length1 = self->priv->overture_origin_xs_length1;
		_tmp5_ = self->priv->_theme_manager;
		_tmp6_ = theme_manager_get_border_width (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp4_[1] = ((((self->priv->game_size - 1) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp7_) - (self->priv->tile_size / 2);
		_tmp8_ = self->priv->overture_origin_xs;
		_tmp8__length1 = self->priv->overture_origin_xs_length1;
		_tmp9_ = self->priv->_theme_manager;
		_tmp10_ = theme_manager_get_border_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_[2] = ((((self->priv->game_size + 1) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp11_) - (self->priv->tile_size / 2);
		_tmp12_ = self->priv->overture_origin_xs;
		_tmp12__length1 = self->priv->overture_origin_xs_length1;
		_tmp13_ = self->priv->_theme_manager;
		_tmp14_ = theme_manager_get_border_width (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp12_[3] = ((((self->priv->game_size + 3) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp15_) - (self->priv->tile_size / 2);
		if (((gint) self->priv->game_size) == 4) {
			ThemeManager* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = self->priv->_theme_manager;
			_tmp17_ = theme_manager_get_border_width (_tmp16_);
			_tmp18_ = _tmp17_;
			self->priv->overture_origin_y = (gint) (((((self->priv->game_size + 2.6) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp18_) - (self->priv->tile_size / 2));
		} else {
			ThemeManager* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = self->priv->_theme_manager;
			_tmp20_ = theme_manager_get_border_width (_tmp19_);
			_tmp21_ = _tmp20_;
			self->priv->overture_origin_y = ((((self->priv->game_size + 4) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp21_) - (self->priv->tile_size / 2);
		}
	} else {
		gint* _tmp22_;
		gint _tmp22__length1;
		ThemeManager* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint* _tmp26_;
		gint _tmp26__length1;
		ThemeManager* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint* _tmp30_;
		gint _tmp30__length1;
		ThemeManager* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint* _tmp35_;
		gint _tmp35__length1;
		gint _tmp36_;
		gint* _tmp37_;
		gint _tmp37__length1;
		gint* _tmp38_;
		gint _tmp38__length1;
		gint _tmp39_;
		gint* _tmp40_;
		gint _tmp40__length1;
		gint* _tmp41_;
		gint _tmp41__length1;
		gint _tmp42_;
		_tmp22_ = self->priv->overture_origin_xs;
		_tmp22__length1 = self->priv->overture_origin_xs_length1;
		_tmp23_ = self->priv->_theme_manager;
		_tmp24_ = theme_manager_get_border_width (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp22_[0] = ((((self->priv->game_size - 2) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp25_) - (self->priv->tile_size / 2);
		_tmp26_ = self->priv->overture_origin_xs;
		_tmp26__length1 = self->priv->overture_origin_xs_length1;
		_tmp27_ = self->priv->_theme_manager;
		_tmp28_ = theme_manager_get_border_width (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp26_[2] = (((self->priv->game_size * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp29_) - (self->priv->tile_size / 2);
		_tmp30_ = self->priv->overture_origin_xs;
		_tmp30__length1 = self->priv->overture_origin_xs_length1;
		_tmp31_ = self->priv->_theme_manager;
		_tmp32_ = theme_manager_get_border_width (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp30_[4] = ((((self->priv->game_size + 2) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp33_) - (self->priv->tile_size / 2);
		_tmp34_ = self->priv->overture_origin_xs;
		_tmp34__length1 = self->priv->overture_origin_xs_length1;
		_tmp35_ = self->priv->overture_origin_xs;
		_tmp35__length1 = self->priv->overture_origin_xs_length1;
		_tmp36_ = _tmp35_[0];
		_tmp34_[1] = _tmp36_;
		_tmp37_ = self->priv->overture_origin_xs;
		_tmp37__length1 = self->priv->overture_origin_xs_length1;
		_tmp38_ = self->priv->overture_origin_xs;
		_tmp38__length1 = self->priv->overture_origin_xs_length1;
		_tmp39_ = _tmp38_[2];
		_tmp37_[3] = _tmp39_;
		_tmp40_ = self->priv->overture_origin_xs;
		_tmp40__length1 = self->priv->overture_origin_xs_length1;
		_tmp41_ = self->priv->overture_origin_xs;
		_tmp41__length1 = self->priv->overture_origin_xs_length1;
		_tmp42_ = _tmp41_[4];
		_tmp40_[5] = _tmp42_;
		if (((gint) self->priv->game_size) == 5) {
			ThemeManager* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			_tmp43_ = self->priv->_theme_manager;
			_tmp44_ = theme_manager_get_border_width (_tmp43_);
			_tmp45_ = _tmp44_;
			self->priv->overture_origin_y = (gint) (((((self->priv->game_size + 3.6) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp45_) - (self->priv->tile_size / 2));
		} else {
			ThemeManager* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			_tmp46_ = self->priv->_theme_manager;
			_tmp47_ = theme_manager_get_border_width (_tmp46_);
			_tmp48_ = _tmp47_;
			self->priv->overture_origin_y = ((((self->priv->game_size + 5) * self->priv->board_size) / (2 * self->priv->game_size)) - _tmp48_) - (self->priv->tile_size / 2);
		}
	}
}

static gboolean
reversi_view_real_draw (GtkWidget* base,
                        cairo_t* cr)
{
	ReversiView * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_pattern_t* _tmp2_;
	ThemeManager* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ThemeManager* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	cairo_pattern_t* _tmp10_;
	ThemeManager* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	ThemeManager* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean result;
	self = (ReversiView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	if (!self->priv->game_is_set) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->board_pattern;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		cairo_pattern_t* _tmp3_;
		_tmp3_ = self->priv->tiles_pattern;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->render_size != ((guint) self->priv->tile_size);
	}
	if (_tmp0_) {
		reversi_view_init_patterns (self, cr);
	}
	_tmp4_ = self->priv->_theme_manager;
	_tmp5_ = theme_manager_get_border_width (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_theme_manager;
	_tmp8_ = theme_manager_get_border_width (_tmp7_);
	_tmp9_ = _tmp8_;
	cairo_translate (cr, (gdouble) (self->priv->board_x - _tmp6_), (gdouble) (self->priv->board_y - _tmp9_));
	_tmp10_ = self->priv->board_pattern;
	cairo_set_source (cr, (cairo_pattern_t*) _tmp10_);
	cairo_rectangle (cr, 0.0, 0.0, (gdouble) self->priv->board_size, (gdouble) self->priv->board_size);
	cairo_fill (cr);
	_tmp11_ = self->priv->_theme_manager;
	_tmp12_ = theme_manager_get_border_width (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_theme_manager;
	_tmp15_ = theme_manager_get_border_width (_tmp14_);
	_tmp16_ = _tmp15_;
	cairo_translate (cr, (gdouble) _tmp13_, (gdouble) _tmp16_);
	if (((gint) self->priv->humans_opening_intensity) != 0) {
		reversi_view_draw_overture (self, cr);
	}
	reversi_view_draw_highlight (self, cr);
	reversi_view_add_highlights (self, cr);
	if (((gint) self->priv->humans_opening_intensity) == 0) {
		reversi_view_draw_playables (self, cr);
	} else {
		reversi_view_draw_overture_playables (self, cr);
	}
	result = FALSE;
	return result;
}

static inline void
reversi_view_init_patterns (ReversiView* self,
                            cairo_t* cr)
{
	cairo_surface_t* surface = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_t* _tmp3_;
	RsvgDimensionData size = {0};
	ThemeManager* _tmp4_;
	RsvgHandle* _tmp5_;
	RsvgHandle* _tmp6_;
	RsvgDimensionData _tmp7_ = {0};
	cairo_t* _tmp8_;
	RsvgDimensionData _tmp9_;
	RsvgDimensionData _tmp10_;
	ThemeManager* _tmp11_;
	RsvgHandle* _tmp12_;
	RsvgHandle* _tmp13_;
	cairo_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_pattern_t* noise_pattern = NULL;
	ThemeManager* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	cairo_surface_t* _tmp38_;
	cairo_surface_t* _tmp39_;
	cairo_surface_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_surface_t* _tmp44_;
	cairo_pattern_t* _tmp45_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	self->priv->render_size = (guint) self->priv->tile_size;
	_tmp0_ = cairo_get_target (cr);
	_tmp1_ = cairo_surface_create_similar (_tmp0_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->tile_size * 8, self->priv->tile_size * 4);
	_cairo_surface_destroy0 (surface);
	surface = _tmp1_;
	_tmp2_ = surface;
	_tmp3_ = cairo_create (_tmp2_);
	_cairo_destroy0 (context);
	context = _tmp3_;
	_tmp4_ = self->priv->_theme_manager;
	_tmp5_ = theme_manager_get_tileset_handle (_tmp4_);
	_tmp6_ = _tmp5_;
	rsvg_handle_get_dimensions (_tmp6_, &_tmp7_);
	size = _tmp7_;
	_tmp8_ = context;
	_tmp9_ = size;
	_tmp10_ = size;
	cairo_scale (_tmp8_, (((gdouble) self->priv->tile_size) * 8.0) / ((gdouble) _tmp9_.width), (((gdouble) self->priv->tile_size) * 4.0) / ((gdouble) _tmp10_.height));
	_tmp11_ = self->priv->_theme_manager;
	_tmp12_ = theme_manager_get_tileset_handle (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = context;
	rsvg_handle_render_cairo (_tmp13_, _tmp14_);
	_tmp15_ = surface;
	_tmp16_ = cairo_pattern_create_for_surface (_tmp15_);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = _tmp16_;
	noise_pattern = NULL;
	_tmp17_ = self->priv->_theme_manager;
	_tmp18_ = theme_manager_get_apply_texture (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GdkPixbuf* noise_pixbuf = NULL;
		GdkPixbuf* _tmp25_;
		noise_pixbuf = NULL;
		{
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* _tmp21_;
			GdkPixbuf* _tmp22_;
			_tmp21_ = gdk_pixbuf_new_from_resource_at_scale ("/org/gnome/Reversi/ui/noise.png", self->priv->tile_size, self->priv->tile_size, FALSE, &_inner_error0_);
			_tmp20_ = _tmp21_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp22_ = _tmp20_;
			_tmp20_ = NULL;
			_g_object_unref0 (noise_pixbuf);
			noise_pixbuf = _tmp22_;
			_g_object_unref0 (_tmp20_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning ("reversi-view.vala:335: %s", _tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (noise_pixbuf);
			_cairo_pattern_destroy0 (noise_pattern);
			_cairo_destroy0 (context);
			_cairo_surface_destroy0 (surface);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp25_ = noise_pixbuf;
		self->priv->noise_pixbuf_loaded = _tmp25_ != NULL;
		if (self->priv->noise_pixbuf_loaded) {
			cairo_surface_t* _tmp26_;
			cairo_surface_t* _tmp27_;
			cairo_surface_t* _tmp28_;
			cairo_t* _tmp29_;
			cairo_t* _tmp30_;
			GdkPixbuf* _tmp31_;
			cairo_t* _tmp32_;
			ThemeManager* _tmp33_;
			gdouble _tmp34_;
			gdouble _tmp35_;
			cairo_surface_t* _tmp36_;
			cairo_pattern_t* _tmp37_;
			_tmp26_ = cairo_get_target (cr);
			_tmp27_ = cairo_surface_create_similar (_tmp26_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->tile_size, self->priv->tile_size);
			_cairo_surface_destroy0 (surface);
			surface = _tmp27_;
			_tmp28_ = surface;
			_tmp29_ = cairo_create (_tmp28_);
			_cairo_destroy0 (context);
			context = _tmp29_;
			_tmp30_ = context;
			_tmp31_ = noise_pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gdk_pixbuf_get_type (), GdkPixbuf), 0.0, 0.0);
			_tmp32_ = context;
			_tmp33_ = self->priv->_theme_manager;
			_tmp34_ = theme_manager_get_texture_alpha (_tmp33_);
			_tmp35_ = _tmp34_;
			cairo_paint_with_alpha (_tmp32_, _tmp35_);
			_tmp36_ = surface;
			_tmp37_ = cairo_pattern_create_for_surface (_tmp36_);
			_cairo_pattern_destroy0 (noise_pattern);
			noise_pattern = _tmp37_;
		}
		_g_object_unref0 (noise_pixbuf);
	}
	_tmp38_ = cairo_get_target (cr);
	_tmp39_ = cairo_surface_create_similar (_tmp38_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->board_size, self->priv->board_size);
	_cairo_surface_destroy0 (surface);
	surface = _tmp39_;
	_tmp40_ = surface;
	_tmp41_ = cairo_create (_tmp40_);
	_cairo_destroy0 (context);
	context = _tmp41_;
	_tmp42_ = context;
	reversi_view_draw_board_background (self, _tmp42_);
	_tmp43_ = context;
	reversi_view_draw_tiles_background (self, _tmp43_, &noise_pattern);
	_tmp44_ = surface;
	_tmp45_ = cairo_pattern_create_for_surface (_tmp44_);
	_cairo_pattern_destroy0 (self->priv->board_pattern);
	self->priv->board_pattern = _tmp45_;
	_cairo_pattern_destroy0 (noise_pattern);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
}

static inline void
reversi_view_draw_board_background (ReversiView* self,
                                    cairo_t* cr)
{
	ThemeManager* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	ThemeManager* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	ThemeManager* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	ThemeManager* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	ThemeManager* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	ThemeManager* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ThemeManager* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ThemeManager* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	ThemeManager* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	ThemeManager* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	ThemeManager* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_spacing_red (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_spacing_green (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_theme_manager;
	_tmp7_ = theme_manager_get_spacing_blue (_tmp6_);
	_tmp8_ = _tmp7_;
	cairo_set_source_rgba (cr, _tmp2_, _tmp5_, _tmp8_, 1.0);
	_tmp9_ = self->priv->_theme_manager;
	_tmp10_ = theme_manager_get_half_border_width (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_theme_manager;
	_tmp13_ = theme_manager_get_half_border_width (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_theme_manager;
	_tmp16_ = theme_manager_get_border_width (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_theme_manager;
	_tmp19_ = theme_manager_get_border_width (_tmp18_);
	_tmp20_ = _tmp19_;
	cairo_rectangle (cr, _tmp11_, _tmp14_, (gdouble) (self->priv->board_size - _tmp17_), (gdouble) (self->priv->board_size - _tmp20_));
	cairo_fill_preserve (cr);
	_tmp21_ = self->priv->_theme_manager;
	_tmp22_ = theme_manager_get_border_red (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->_theme_manager;
	_tmp25_ = theme_manager_get_border_green (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->_theme_manager;
	_tmp28_ = theme_manager_get_border_blue (_tmp27_);
	_tmp29_ = _tmp28_;
	cairo_set_source_rgba (cr, _tmp23_, _tmp26_, _tmp29_, 1.0);
	_tmp30_ = self->priv->_theme_manager;
	_tmp31_ = theme_manager_get_border_width (_tmp30_);
	_tmp32_ = _tmp31_;
	cairo_set_line_width (cr, (gdouble) _tmp32_);
	cairo_stroke (cr);
}

static inline void
reversi_view_draw_tiles_background (ReversiView* self,
                                    cairo_t* cr,
                                    cairo_pattern_t** noise_pattern)
{
	ThemeManager* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ThemeManager* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_border_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_border_width (_tmp3_);
	_tmp5_ = _tmp4_;
	cairo_translate (cr, (gdouble) _tmp2_, (gdouble) _tmp5_);
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint _tmp11_;
							gint* _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							gint _tmp13_;
							if (!_tmp8_) {
								guint8 _tmp9_;
								_tmp9_ = y;
								y = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							_tmp10_ = self->priv->tile_xs;
							_tmp10__length1 = self->priv->tile_xs_length1;
							_tmp10__length2 = self->priv->tile_xs_length2;
							_tmp11_ = _tmp10_[(x * _tmp10__length2) + y];
							_tmp12_ = self->priv->tile_ys;
							_tmp12__length1 = self->priv->tile_ys_length1;
							_tmp12__length2 = self->priv->tile_ys_length2;
							_tmp13_ = _tmp12_[(x * _tmp12__length2) + y];
							reversi_view_draw_tile_background (self, cr, noise_pattern, _tmp11_, _tmp13_);
						}
					}
				}
			}
		}
	}
}

static inline void
reversi_view_draw_tile_background (ReversiView* self,
                                   cairo_t* cr,
                                   cairo_pattern_t** noise_pattern,
                                   gint tile_x,
                                   gint tile_y)
{
	ThemeManager* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	ThemeManager* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	ThemeManager* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	ThemeManager* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	ThemeManager* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_background_red (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_background_green (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_theme_manager;
	_tmp7_ = theme_manager_get_background_blue (_tmp6_);
	_tmp8_ = _tmp7_;
	cairo_set_source_rgba (cr, _tmp2_, _tmp5_, _tmp8_, 1.0);
	_tmp9_ = self->priv->_theme_manager;
	_tmp10_ = theme_manager_get_background_radius (_tmp9_);
	_tmp11_ = _tmp10_;
	reversi_view_rounded_square (self, cr, (gdouble) tile_x, (gdouble) tile_y, self->priv->tile_size, (gdouble) 0, (gdouble) _tmp11_);
	_tmp13_ = self->priv->_theme_manager;
	_tmp14_ = theme_manager_get_apply_texture (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_tmp12_ = self->priv->noise_pixbuf_loaded;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		cairo_matrix_t matrix = {0};
		cairo_matrix_t _tmp16_;
		cairo_fill_preserve (cr);
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_translate (&matrix, (gdouble) (-tile_x), (gdouble) (-tile_y));
		_tmp16_ = matrix;
		cairo_pattern_set_matrix ((cairo_pattern_t*) (*noise_pattern), &_tmp16_);
		cairo_set_source (cr, (cairo_pattern_t*) (*noise_pattern));
	}
	cairo_fill (cr);
}

static inline void
reversi_view_draw_overture (ReversiView* self,
                            cairo_t* cr)
{
	guint8 half_game_size = 0U;
	Game* _tmp14_;
	Game* _tmp15_;
	Opening _tmp16_;
	Opening _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	half_game_size = (guint8) (self->priv->game_size / 2);
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							gboolean _tmp4_ = FALSE;
							gboolean _tmp5_ = FALSE;
							gboolean _tmp7_ = FALSE;
							if (!_tmp2_) {
								guint8 _tmp3_;
								_tmp3_ = y;
								y = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							if (x == half_game_size) {
								_tmp5_ = TRUE;
							} else {
								_tmp5_ = ((gint) x) == (half_game_size - 1);
							}
							if (_tmp5_) {
								gboolean _tmp6_ = FALSE;
								if (y == half_game_size) {
									_tmp6_ = TRUE;
								} else {
									_tmp6_ = ((gint) y) == (half_game_size - 1);
								}
								_tmp4_ = _tmp6_;
							} else {
								_tmp4_ = FALSE;
							}
							if (_tmp4_) {
								continue;
							}
							if ((self->priv->game_size % 2) != 0) {
								gboolean _tmp8_ = FALSE;
								gboolean _tmp9_ = FALSE;
								if (((gint) y) == (half_game_size + 1)) {
									gboolean _tmp10_ = FALSE;
									gboolean _tmp11_ = FALSE;
									if (((gint) x) == (half_game_size - 1)) {
										_tmp11_ = TRUE;
									} else {
										_tmp11_ = x == half_game_size;
									}
									if (_tmp11_) {
										_tmp10_ = TRUE;
									} else {
										_tmp10_ = ((gint) x) == (half_game_size + 1);
									}
									_tmp9_ = _tmp10_;
								} else {
									_tmp9_ = FALSE;
								}
								if (_tmp9_) {
									_tmp8_ = TRUE;
								} else {
									gboolean _tmp12_ = FALSE;
									if (((gint) x) == (half_game_size + 1)) {
										gboolean _tmp13_ = FALSE;
										if (((gint) y) == (half_game_size - 1)) {
											_tmp13_ = TRUE;
										} else {
											_tmp13_ = y == half_game_size;
										}
										_tmp12_ = _tmp13_;
									} else {
										_tmp12_ = FALSE;
									}
									_tmp8_ = _tmp12_;
								}
								_tmp7_ = _tmp8_;
							} else {
								_tmp7_ = FALSE;
							}
							if (_tmp7_) {
								continue;
							}
							reversi_view_darken_tile (self, cr, x, y);
						}
					}
				}
			}
		}
	}
	_tmp14_ = reversi_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = game_get_opening (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != OPENING_HUMANS) {
		guint8 _tmp18_;
		_tmp18_ = self->priv->humans_opening_intensity;
		self->priv->humans_opening_intensity = _tmp18_ - 1;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

static inline void
reversi_view_draw_highlight (ReversiView* self,
                             cairo_t* cr)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean display_mouse_highlight = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean display_keybd_highlight = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean display_ghost_highlight = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_is_complete (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	if (!self->priv->show_highlight) {
		gboolean _tmp6_ = FALSE;
		if (self->priv->show_mouse_highlight) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = ((gint) self->priv->highlight_state) != 0;
		}
		_tmp5_ = _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp7_ = FALSE;
		Iagno* _tmp8_;
		Player _tmp9_;
		Player _tmp10_;
		Game* _tmp11_;
		Game* _tmp12_;
		Player _tmp13_;
		Player _tmp14_;
		_tmp8_ = self->priv->_iagno_instance;
		_tmp9_ = iagno_get_player_one (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = reversi_view_get_game (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = game_get_current_color (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp10_ == _tmp14_) {
			_tmp7_ = TRUE;
		} else {
			Iagno* _tmp15_;
			ComputerPlayer* _tmp16_;
			ComputerPlayer* _tmp17_;
			_tmp15_ = self->priv->_iagno_instance;
			_tmp16_ = iagno_get_computer (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp7_ = _tmp17_ == NULL;
		}
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	display_mouse_highlight = _tmp4_;
	if (self->priv->show_highlight) {
		_tmp18_ = !self->priv->show_mouse_highlight;
	} else {
		_tmp18_ = FALSE;
	}
	display_keybd_highlight = _tmp18_;
	if (!self->priv->show_highlight) {
		_tmp22_ = !self->priv->show_mouse_highlight;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = ((gint) self->priv->highlight_state) != 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = self->priv->old_highlight_x != G_MAXUINT8;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = self->priv->old_highlight_y != G_MAXUINT8;
	} else {
		_tmp19_ = FALSE;
	}
	display_ghost_highlight = _tmp19_;
	if (display_ghost_highlight) {
		reversi_view_draw_tile_highlight (self, cr, self->priv->old_highlight_x, self->priv->old_highlight_y);
	} else {
		if (display_mouse_highlight) {
			reversi_view_draw_tile_highlight (self, cr, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
		} else {
			if (display_keybd_highlight) {
				reversi_view_draw_tile_highlight (self, cr, self->priv->highlight_x, self->priv->highlight_y);
			}
		}
	}
}

static inline void
reversi_view_draw_tile_highlight (ReversiView* self,
                                  cairo_t* cr,
                                  guint8 x,
                                  guint8 y)
{
	PossibleMove move = {0};
	gboolean test_placing_tile = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	PossibleMove _tmp2_ = {0};
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean highlight_on = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp3_ = game_test_placing_tile (_tmp1_, x, y, &_tmp2_);
	move = _tmp2_;
	test_placing_tile = _tmp3_;
	if (self->priv->show_highlight) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (self->priv->mouse_is_in) {
			_tmp6_ = self->priv->show_mouse_highlight;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = test_placing_tile;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	highlight_on = _tmp4_;
	if (highlight_on) {
		_tmp7_ = self->priv->highlight_state != REVERSI_VIEW_HIGHLIGHT_MAX;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		guint8 _tmp8_;
		_tmp8_ = self->priv->highlight_state;
		self->priv->highlight_state = _tmp8_ + 1;
		reversi_view_queue_draw_tile (self, x, y);
	} else {
		gboolean _tmp9_ = FALSE;
		if (!highlight_on) {
			_tmp9_ = ((gint) self->priv->highlight_state) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			guint8 _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = self->priv->highlight_state;
			self->priv->highlight_state = _tmp10_ - 1;
			reversi_view_queue_draw_tile (self, x, y);
			if (self->priv->old_highlight_x != x) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = self->priv->old_highlight_y != y;
			}
			if (_tmp11_) {
				return;
			}
		}
	}
	reversi_view_highlight_tile (self, cr, x, y, self->priv->highlight_state, FALSE);
	if (test_placing_tile) {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_show_turnable_tiles;
		_tmp13_ = _tmp14_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp15_ = FALSE;
		Iagno* _tmp16_;
		ComputerPlayer* _tmp17_;
		ComputerPlayer* _tmp18_;
		_tmp16_ = self->priv->_iagno_instance;
		_tmp17_ = iagno_get_computer (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ != NULL) {
			Iagno* _tmp19_;
			Player _tmp20_;
			Player _tmp21_;
			Game* _tmp22_;
			Game* _tmp23_;
			Player _tmp24_;
			Player _tmp25_;
			_tmp19_ = self->priv->_iagno_instance;
			_tmp20_ = iagno_get_player_one (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = reversi_view_get_game (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = game_get_current_color (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp15_ = _tmp21_ != _tmp25_;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp12_ = !_tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		PossibleMove _tmp26_;
		PossibleMove _tmp27_;
		PossibleMove _tmp28_;
		PossibleMove _tmp29_;
		PossibleMove _tmp30_;
		PossibleMove _tmp31_;
		PossibleMove _tmp32_;
		PossibleMove _tmp33_;
		PossibleMove _tmp34_;
		PossibleMove _tmp35_;
		PossibleMove _tmp36_;
		PossibleMove _tmp37_;
		PossibleMove _tmp38_;
		PossibleMove _tmp39_;
		PossibleMove _tmp40_;
		PossibleMove _tmp41_;
		PossibleMove _tmp42_;
		PossibleMove _tmp43_;
		PossibleMove _tmp44_;
		PossibleMove _tmp45_;
		PossibleMove _tmp46_;
		PossibleMove _tmp47_;
		PossibleMove _tmp48_;
		PossibleMove _tmp49_;
		_tmp26_ = move;
		_tmp27_ = move;
		_tmp28_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp26_.x, _tmp27_.y, (gint8) 0, (gint8) -1, _tmp28_.n_tiles_n);
		_tmp29_ = move;
		_tmp30_ = move;
		_tmp31_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp29_.x, _tmp30_.y, (gint8) 1, (gint8) -1, _tmp31_.n_tiles_ne);
		_tmp32_ = move;
		_tmp33_ = move;
		_tmp34_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp32_.x, _tmp33_.y, (gint8) 1, (gint8) 0, _tmp34_.n_tiles_e);
		_tmp35_ = move;
		_tmp36_ = move;
		_tmp37_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp35_.x, _tmp36_.y, (gint8) 1, (gint8) 1, _tmp37_.n_tiles_se);
		_tmp38_ = move;
		_tmp39_ = move;
		_tmp40_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp38_.x, _tmp39_.y, (gint8) 0, (gint8) 1, _tmp40_.n_tiles_s);
		_tmp41_ = move;
		_tmp42_ = move;
		_tmp43_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp41_.x, _tmp42_.y, (gint8) -1, (gint8) 1, _tmp43_.n_tiles_so);
		_tmp44_ = move;
		_tmp45_ = move;
		_tmp46_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp44_.x, _tmp45_.y, (gint8) -1, (gint8) 0, _tmp46_.n_tiles_o);
		_tmp47_ = move;
		_tmp48_ = move;
		_tmp49_ = move;
		reversi_view_highlight_turnable_tiles (self, cr, _tmp47_.x, _tmp48_.y, (gint8) -1, (gint8) -1, _tmp49_.n_tiles_no);
	}
}

static inline void
reversi_view_highlight_turnable_tiles (ReversiView* self,
                                       cairo_t* cr,
                                       guint8 x,
                                       guint8 y,
                                       gint8 x_step,
                                       gint8 y_step,
                                       guint8 count)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint8 _x = 0;
			gint8 _y = 0;
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = count;
				count = _tmp1_ - 1;
			}
			_tmp0_ = FALSE;
			if (!(((gint) count) > 0)) {
				break;
			}
			_x = ((gint8) x) + (((gint8) count) * x_step);
			_y = ((gint8) y) + (((gint8) count) * y_step);
			reversi_view_queue_draw_tile (self, (guint8) _x, (guint8) _y);
			reversi_view_highlight_tile (self, cr, (guint8) _x, (guint8) _y, self->priv->highlight_state, TRUE);
		}
	}
}

static inline void
reversi_view_add_highlights (ReversiView* self,
                             cairo_t* cr)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	Iagno* _tmp4_;
	ComputerPlayer* _tmp5_;
	ComputerPlayer* _tmp6_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean decreasing = FALSE;
	guint8 intensity = 0U;
	gboolean _tmp32_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp1_ = reversi_view_get_show_playable_tiles (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = ((gint) self->priv->playable_tiles_highlight_state) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->_iagno_instance;
	_tmp5_ = iagno_get_computer (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		Iagno* _tmp7_;
		Player _tmp8_;
		Player _tmp9_;
		Game* _tmp10_;
		Game* _tmp11_;
		Player _tmp12_;
		Player _tmp13_;
		_tmp7_ = self->priv->_iagno_instance;
		_tmp8_ = iagno_get_player_one (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = reversi_view_get_game (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = game_get_current_color (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp3_ = _tmp9_ != _tmp13_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		reversi_view_init_possible_moves (self);
		return;
	}
	_tmp15_ = reversi_view_get_show_playable_tiles (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_;
		_tmp17_ = self->priv->_show_turnable_tiles;
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		PossibleMove move = {0};
		gboolean _tmp18_ = FALSE;
		gboolean _tmp23_ = FALSE;
		if (self->priv->show_mouse_highlight) {
			Game* _tmp19_;
			Game* _tmp20_;
			PossibleMove _tmp21_ = {0};
			gboolean _tmp22_;
			_tmp19_ = reversi_view_get_game (self);
			_tmp20_ = _tmp19_;
			_tmp22_ = game_test_placing_tile (_tmp20_, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y, &_tmp21_);
			move = _tmp21_;
			_tmp18_ = _tmp22_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			return;
		}
		if (self->priv->show_highlight) {
			Game* _tmp24_;
			Game* _tmp25_;
			PossibleMove _tmp26_ = {0};
			gboolean _tmp27_;
			_tmp24_ = reversi_view_get_game (self);
			_tmp25_ = _tmp24_;
			_tmp27_ = game_test_placing_tile (_tmp25_, self->priv->highlight_x, self->priv->highlight_y, &_tmp26_);
			move = _tmp26_;
			_tmp23_ = _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			return;
		}
	}
	decreasing = self->priv->playable_tiles_highlight_state > REVERSI_VIEW_HIGHLIGHT_MAX;
	if (decreasing) {
		intensity = (guint8) (((2 * REVERSI_VIEW_HIGHLIGHT_MAX) + 1) - self->priv->playable_tiles_highlight_state);
	} else {
		intensity = self->priv->playable_tiles_highlight_state;
	}
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				if (!_tmp28_) {
					guint8 _tmp29_;
					_tmp29_ = x;
					x = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							if (!_tmp30_) {
								guint8 _tmp31_;
								_tmp31_ = y;
								y = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							reversi_view_add_highlight (self, cr, x, y, intensity);
						}
					}
				}
			}
		}
	}
	if (decreasing) {
		_tmp32_ = ((gint) intensity) == 1;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		reversi_view_init_possible_moves (self);
	} else {
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp33_ = reversi_view_get_show_playable_tiles (self);
		_tmp34_ = _tmp33_;
		if (!_tmp34_) {
			guint8 _tmp35_;
			_tmp35_ = self->priv->playable_tiles_highlight_state;
			self->priv->playable_tiles_highlight_state = _tmp35_ + 1;
		} else {
			if (self->priv->playable_tiles_highlight_state < REVERSI_VIEW_HIGHLIGHT_MAX) {
				guint8 _tmp36_;
				_tmp36_ = self->priv->playable_tiles_highlight_state;
				self->priv->playable_tiles_highlight_state = _tmp36_ + 1;
			}
		}
	}
}

static inline void
reversi_view_add_highlight (ReversiView* self,
                            cairo_t* cr,
                            guint8 x,
                            guint8 y,
                            guint8 intensity)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->possible_moves;
	_tmp0__length1 = self->priv->possible_moves_length1;
	_tmp0__length2 = self->priv->possible_moves_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_ == FALSE) {
		return;
	}
	reversi_view_queue_draw_tile (self, x, y);
	reversi_view_highlight_tile (self, cr, x, y, intensity, TRUE);
}

static inline void
reversi_view_draw_playables (ReversiView* self,
                             cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							gint* _tmp4_;
							gint _tmp4__length1;
							gint _tmp4__length2;
							gint _tmp5_;
							gint* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gint _tmp7_;
							gint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							if (!_tmp2_) {
								guint8 _tmp3_;
								_tmp3_ = y;
								y = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							_tmp4_ = self->priv->pixmaps;
							_tmp4__length1 = self->priv->pixmaps_length1;
							_tmp4__length2 = self->priv->pixmaps_length2;
							_tmp5_ = _tmp4_[(x * _tmp4__length2) + y];
							_tmp6_ = self->priv->tile_xs;
							_tmp6__length1 = self->priv->tile_xs_length1;
							_tmp6__length2 = self->priv->tile_xs_length2;
							_tmp7_ = _tmp6_[(x * _tmp6__length2) + y];
							_tmp8_ = self->priv->tile_ys;
							_tmp8__length1 = self->priv->tile_ys_length1;
							_tmp8__length2 = self->priv->tile_ys_length2;
							_tmp9_ = _tmp8_[(x * _tmp8__length2) + y];
							reversi_view_draw_playable (self, cr, _tmp5_, _tmp7_, _tmp9_);
						}
					}
				}
			}
		}
	}
}

static inline void
reversi_view_draw_playable (ReversiView* self,
                            cairo_t* cr,
                            gint pixmap,
                            gint tile_x,
                            gint tile_y)
{
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp0_;
	cairo_matrix_t _tmp1_;
	cairo_pattern_t* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (pixmap == 0) {
		return;
	}
	cairo_matrix_init_identity (&matrix);
	cairo_matrix_translate (&matrix, (gdouble) (((pixmap % 8) * self->priv->tile_size) - tile_x), (gdouble) (((pixmap / 8) * self->priv->tile_size) - tile_y));
	_tmp0_ = self->priv->tiles_pattern;
	_tmp1_ = matrix;
	cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp0_, &_tmp1_);
	_tmp2_ = self->priv->tiles_pattern;
	cairo_set_source (cr, (cairo_pattern_t*) _tmp2_);
	cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) self->priv->tile_size, (gdouble) self->priv->tile_size);
	cairo_fill (cr);
}

static inline void
reversi_view_draw_overture_playables (ReversiView* self,
                                      cairo_t* cr)
{
	gboolean even_board = FALSE;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	even_board = (self->priv->game_size % 2) == 0;
	if (even_board) {
		_tmp0_ = 4;
	} else {
		_tmp0_ = 6;
	}
	if (((gint) self->priv->current_overture_playable) < _tmp0_) {
		reversi_view_draw_overture_indicator (self, cr);
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (even_board) {
					_tmp3_ = 4;
				} else {
					_tmp3_ = 6;
				}
				if (!(((gint) i) < _tmp3_)) {
					break;
				}
				reversi_view_draw_overture_playable (self, cr, i);
			}
		}
	}
	if (!even_board) {
		guint8 half_game_size = 0U;
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		gint _tmp5_;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		gint _tmp7_;
		gint* _tmp8_;
		gint _tmp8__length1;
		gint _tmp8__length2;
		gint _tmp9_;
		half_game_size = (guint8) (self->priv->game_size / 2);
		_tmp4_ = self->priv->pixmaps;
		_tmp4__length1 = self->priv->pixmaps_length1;
		_tmp4__length2 = self->priv->pixmaps_length2;
		_tmp5_ = _tmp4_[(half_game_size * _tmp4__length2) + half_game_size];
		_tmp6_ = self->priv->tile_xs;
		_tmp6__length1 = self->priv->tile_xs_length1;
		_tmp6__length2 = self->priv->tile_xs_length2;
		_tmp7_ = _tmp6_[(half_game_size * _tmp6__length2) + half_game_size];
		_tmp8_ = self->priv->tile_ys;
		_tmp8__length1 = self->priv->tile_ys_length1;
		_tmp8__length2 = self->priv->tile_ys_length2;
		_tmp9_ = _tmp8_[(half_game_size * _tmp8__length2) + half_game_size];
		reversi_view_draw_playable (self, cr, _tmp5_, _tmp7_, _tmp9_);
	}
}

static inline void
reversi_view_draw_overture_indicator (ReversiView* self,
                                      cairo_t* cr)
{
	gdouble _tmp0_ = 0.0;
	gdouble diameter_factor = 0.0;
	ThemeManager* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	ThemeManager* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	ThemeManager* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (((gint) self->priv->game_size) == 4) {
		_tmp0_ = 1.95;
	} else {
		_tmp0_ = 1.8;
	}
	diameter_factor = _tmp0_;
	_tmp1_ = self->priv->_theme_manager;
	_tmp2_ = theme_manager_get_background_red (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_theme_manager;
	_tmp5_ = theme_manager_get_background_green (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_theme_manager;
	_tmp8_ = theme_manager_get_background_blue (_tmp7_);
	_tmp9_ = _tmp8_;
	cairo_set_source_rgba (cr, _tmp3_, _tmp6_, _tmp9_, 1.0);
	_tmp10_ = self->priv->overture_origin_xs;
	_tmp10__length1 = self->priv->overture_origin_xs_length1;
	_tmp11_ = _tmp10_[self->priv->current_overture_playable];
	cairo_arc (cr, ((gdouble) _tmp11_) + (((gdouble) self->priv->tile_size) / 2.0), ((gdouble) self->priv->overture_origin_y) + (((gdouble) self->priv->tile_size) / 2.0), ((gdouble) self->priv->tile_size) / diameter_factor, 0.0, G_PI * 2.0);
	cairo_fill (cr);
}

static inline void
reversi_view_draw_overture_playable (ReversiView* self,
                                     cairo_t* cr,
                                     guint8 playable_id)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8 _tmp1_;
	gint tile_x = 0;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	gint tile_y = 0;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8 _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->overture_steps;
	_tmp0__length1 = self->priv->overture_steps_length1;
	_tmp1_ = _tmp0_[playable_id];
	if (_tmp1_ == REVERSI_VIEW_OVERTURE_STEPS_MAX) {
		guint8 x = 0U;
		guint8 y = 0U;
		guint8 _tmp2_ = 0U;
		guint8 _tmp3_ = 0U;
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		gint _tmp5_;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		gint _tmp7_;
		gint* _tmp8_;
		gint _tmp8__length1;
		gint _tmp8__length2;
		gint _tmp9_;
		reversi_view_get_x_and_y (self, playable_id, &_tmp2_, &_tmp3_);
		x = _tmp2_;
		y = _tmp3_;
		_tmp4_ = self->priv->pixmaps;
		_tmp4__length1 = self->priv->pixmaps_length1;
		_tmp4__length2 = self->priv->pixmaps_length2;
		_tmp5_ = _tmp4_[(x * _tmp4__length2) + y];
		_tmp6_ = self->priv->tile_xs;
		_tmp6__length1 = self->priv->tile_xs_length1;
		_tmp6__length2 = self->priv->tile_xs_length2;
		_tmp7_ = _tmp6_[(x * _tmp6__length2) + y];
		_tmp8_ = self->priv->tile_ys;
		_tmp8__length1 = self->priv->tile_ys_length1;
		_tmp8__length2 = self->priv->tile_ys_length2;
		_tmp9_ = _tmp8_[(x * _tmp8__length2) + y];
		reversi_view_draw_playable (self, cr, _tmp5_, _tmp7_, _tmp9_);
		return;
	}
	_tmp10_ = self->priv->overture_origin_xs;
	_tmp10__length1 = self->priv->overture_origin_xs_length1;
	_tmp11_ = _tmp10_[playable_id];
	tile_x = _tmp11_;
	tile_y = self->priv->overture_origin_y;
	_tmp12_ = self->priv->overture_target;
	_tmp12__length1 = self->priv->overture_target_length1;
	_tmp13_ = _tmp12_[playable_id];
	if (((gint) _tmp13_) != 0) {
		guint8 x = 0U;
		guint8 y = 0U;
		guint8 _tmp14_ = 0U;
		guint8 _tmp15_ = 0U;
		gint* _tmp16_;
		gint _tmp16__length1;
		gint _tmp16__length2;
		gint _tmp17_;
		guint8* _tmp18_;
		gint _tmp18__length1;
		guint8 _tmp19_;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint _tmp20__length2;
		gint _tmp21_;
		guint8* _tmp22_;
		gint _tmp22__length1;
		guint8 _tmp23_;
		guint8* _tmp24_;
		gint _tmp24__length1;
		guint8 _tmp25_;
		reversi_view_get_x_and_y (self, playable_id, &_tmp14_, &_tmp15_);
		x = _tmp14_;
		y = _tmp15_;
		_tmp16_ = self->priv->tile_xs;
		_tmp16__length1 = self->priv->tile_xs_length1;
		_tmp16__length2 = self->priv->tile_xs_length2;
		_tmp17_ = _tmp16_[(x * _tmp16__length2) + y];
		_tmp18_ = self->priv->overture_steps;
		_tmp18__length1 = self->priv->overture_steps_length1;
		_tmp19_ = _tmp18_[playable_id];
		tile_x += ((_tmp17_ - tile_x) * _tmp19_) / REVERSI_VIEW_OVERTURE_STEPS_MAX;
		_tmp20_ = self->priv->tile_ys;
		_tmp20__length1 = self->priv->tile_ys_length1;
		_tmp20__length2 = self->priv->tile_ys_length2;
		_tmp21_ = _tmp20_[(x * _tmp20__length2) + y];
		_tmp22_ = self->priv->overture_steps;
		_tmp22__length1 = self->priv->overture_steps_length1;
		_tmp23_ = _tmp22_[playable_id];
		tile_y += ((_tmp21_ - tile_y) * _tmp23_) / REVERSI_VIEW_OVERTURE_STEPS_MAX;
		_tmp24_ = self->priv->overture_steps;
		_tmp24__length1 = self->priv->overture_steps_length1;
		_tmp25_ = _tmp24_[playable_id];
		_tmp24_[playable_id] = _tmp25_ + 1;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	if ((self->priv->game_size % 2) == 0) {
		_reversi_view_draw_overture_playable (self, cr, tile_x, tile_y, ((playable_id % 2) * 30) + 1);
	} else {
		_reversi_view_draw_overture_playable (self, cr, tile_x, tile_y, ((((playable_id / 2) + 1) % 2) * 30) + 1);
	}
}

static void
_reversi_view_draw_overture_playable (ReversiView* self,
                                      cairo_t* cr,
                                      gint tile_x,
                                      gint tile_y,
                                      gint pixmap)
{
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp0_;
	cairo_matrix_t _tmp1_;
	cairo_pattern_t* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_matrix_init_identity (&matrix);
	cairo_matrix_translate (&matrix, (gdouble) (((pixmap % 8) * self->priv->tile_size) - tile_x), (gdouble) (((pixmap / 8) * self->priv->tile_size) - tile_y));
	_tmp0_ = self->priv->tiles_pattern;
	_tmp1_ = matrix;
	cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp0_, &_tmp1_);
	_tmp2_ = self->priv->tiles_pattern;
	cairo_set_source (cr, (cairo_pattern_t*) _tmp2_);
	cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) self->priv->tile_size, (gdouble) self->priv->tile_size);
	cairo_fill (cr);
}

static void
reversi_view_get_x_and_y (ReversiView* self,
                          guint8 playable_id,
                          guint8* x,
                          guint8* y)
{
	guint8 _vala_x = 0U;
	guint8 _vala_y = 0U;
	guint8 half_game_size = 0U;
	g_return_if_fail (self != NULL);
	half_game_size = (guint8) (self->priv->game_size / 2);
	if ((self->priv->game_size % 2) == 0) {
		guint8* _tmp0_;
		gint _tmp0__length1;
		guint8 _tmp1_;
		_tmp0_ = self->priv->overture_target;
		_tmp0__length1 = self->priv->overture_target_length1;
		_tmp1_ = _tmp0_[playable_id];
		switch (_tmp1_) {
			case 1:
			{
				_vala_x = (guint8) (half_game_size - 1);
				_vala_y = (guint8) (half_game_size - 1);
				break;
			}
			case 2:
			{
				_vala_x = half_game_size;
				_vala_y = (guint8) (half_game_size - 1);
				break;
			}
			case 3:
			{
				_vala_x = (guint8) (half_game_size - 1);
				_vala_y = half_game_size;
				break;
			}
			case 4:
			{
				_vala_x = half_game_size;
				_vala_y = half_game_size;
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	} else {
		guint8* _tmp2_;
		gint _tmp2__length1;
		guint8 _tmp3_;
		_tmp2_ = self->priv->overture_target;
		_tmp2__length1 = self->priv->overture_target_length1;
		_tmp3_ = _tmp2_[playable_id];
		switch (_tmp3_) {
			case 1:
			{
				_vala_x = (guint8) (half_game_size - 1);
				_vala_y = (guint8) (half_game_size - 1);
				break;
			}
			case 2:
			{
				_vala_x = half_game_size;
				_vala_y = (guint8) (half_game_size - 1);
				break;
			}
			case 3:
			{
				_vala_x = (guint8) (half_game_size + 1);
				_vala_y = (guint8) (half_game_size - 1);
				break;
			}
			case 4:
			{
				_vala_x = (guint8) (half_game_size - 1);
				_vala_y = half_game_size;
				break;
			}
			case 6:
			{
				_vala_x = (guint8) (half_game_size + 1);
				_vala_y = half_game_size;
				break;
			}
			case 7:
			{
				_vala_x = (guint8) (half_game_size - 1);
				_vala_y = (guint8) (half_game_size + 1);
				break;
			}
			case 8:
			{
				_vala_x = half_game_size;
				_vala_y = (guint8) (half_game_size + 1);
				break;
			}
			case 9:
			{
				_vala_x = (guint8) (half_game_size + 1);
				_vala_y = (guint8) (half_game_size + 1);
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static void
reversi_view_rounded_square (ReversiView* self,
                             cairo_t* cr,
                             gdouble x,
                             gdouble y,
                             gint size,
                             gdouble width,
                             gdouble radius_percent)
{
	gdouble radius_border = 0.0;
	gdouble radius_arc = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (radius_percent <= 0.0) {
		cairo_rectangle (cr, x + (width / 2.0), y + (width / 2.0), size + width, size + width);
		return;
	}
	if (radius_percent > 50.0) {
		radius_percent = 50.0;
	}
	radius_border = (radius_percent * size) / 100.0;
	radius_arc = radius_border - (width / 2.0);
	x1 = x + radius_border;
	y1 = y + radius_border;
	x2 = (x + size) - radius_border;
	y2 = (y + size) - radius_border;
	cairo_arc (cr, x1, y1, radius_arc, G_PI, -REVERSI_VIEW_HALF_PI);
	cairo_arc (cr, x2, y1, radius_arc, -REVERSI_VIEW_HALF_PI, 0.0);
	cairo_arc (cr, x2, y2, radius_arc, 0.0, REVERSI_VIEW_HALF_PI);
	cairo_arc (cr, x1, y2, radius_arc, REVERSI_VIEW_HALF_PI, G_PI);
	cairo_arc (cr, x1, y1, radius_arc, G_PI, -REVERSI_VIEW_HALF_PI);
}

static void
reversi_view_highlight_tile (ReversiView* self,
                             cairo_t* cr,
                             guint8 x,
                             guint8 y,
                             guint8 intensity,
                             gboolean soft_highlight)
{
	gint* _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	gint _tmp25_;
	gint* _tmp26_;
	gint _tmp26__length1;
	gint _tmp26__length2;
	gint _tmp27_;
	ThemeManager* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (soft_highlight) {
		ThemeManager* _tmp0_;
		gdouble _tmp1_;
		gdouble _tmp2_;
		ThemeManager* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		ThemeManager* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		ThemeManager* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp0_ = self->priv->_theme_manager;
		_tmp1_ = theme_manager_get_highlight_soft_red (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_theme_manager;
		_tmp4_ = theme_manager_get_highlight_soft_green (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_theme_manager;
		_tmp7_ = theme_manager_get_highlight_soft_blue (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_theme_manager;
		_tmp10_ = theme_manager_get_highlight_soft_alpha (_tmp9_);
		_tmp11_ = _tmp10_;
		cairo_set_source_rgba (cr, _tmp2_, _tmp5_, _tmp8_, _tmp11_);
	} else {
		ThemeManager* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		ThemeManager* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		ThemeManager* _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		ThemeManager* _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		_tmp12_ = self->priv->_theme_manager;
		_tmp13_ = theme_manager_get_highlight_hard_red (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->_theme_manager;
		_tmp16_ = theme_manager_get_highlight_hard_green (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->_theme_manager;
		_tmp19_ = theme_manager_get_highlight_hard_blue (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_theme_manager;
		_tmp22_ = theme_manager_get_highlight_hard_alpha (_tmp21_);
		_tmp23_ = _tmp22_;
		cairo_set_source_rgba (cr, _tmp14_, _tmp17_, _tmp20_, _tmp23_);
	}
	_tmp24_ = self->priv->tile_xs;
	_tmp24__length1 = self->priv->tile_xs_length1;
	_tmp24__length2 = self->priv->tile_xs_length2;
	_tmp25_ = _tmp24_[(x * _tmp24__length2) + y];
	_tmp26_ = self->priv->tile_ys;
	_tmp26__length1 = self->priv->tile_ys_length1;
	_tmp26__length2 = self->priv->tile_ys_length2;
	_tmp27_ = _tmp26_[(x * _tmp26__length2) + y];
	_tmp28_ = self->priv->_theme_manager;
	_tmp29_ = theme_manager_get_background_radius (_tmp28_);
	_tmp30_ = _tmp29_;
	reversi_view_rounded_square (self, cr, (gdouble) (_tmp25_ + ((self->priv->tile_size * (REVERSI_VIEW_HIGHLIGHT_MAX - intensity)) / (2 * REVERSI_VIEW_HIGHLIGHT_MAX))), (gdouble) (_tmp27_ + ((self->priv->tile_size * (REVERSI_VIEW_HIGHLIGHT_MAX - intensity)) / (2 * REVERSI_VIEW_HIGHLIGHT_MAX))), (self->priv->tile_size * intensity) / REVERSI_VIEW_HIGHLIGHT_MAX, (gdouble) 0, (gdouble) _tmp30_);
	cairo_fill (cr);
}

static void
reversi_view_darken_tile (ReversiView* self,
                          cairo_t* cr,
                          guint8 x,
                          guint8 y)
{
	gdouble alpha = 0.0;
	ThemeManager* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	ThemeManager* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	ThemeManager* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	ThemeManager* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint _tmp13_;
	gint* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	gint _tmp15_;
	ThemeManager* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_highlight_hard_alpha (_tmp0_);
	_tmp2_ = _tmp1_;
	alpha = ((_tmp2_ * 1.6) * ((gdouble) self->priv->humans_opening_intensity)) / ((gdouble) REVERSI_VIEW_HUMANS_OPENING_INTENSITY_MAX);
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_highlight_hard_red (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_theme_manager;
	_tmp7_ = theme_manager_get_highlight_hard_green (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_theme_manager;
	_tmp10_ = theme_manager_get_highlight_hard_blue (_tmp9_);
	_tmp11_ = _tmp10_;
	cairo_set_source_rgba (cr, _tmp5_, _tmp8_, _tmp11_, alpha);
	_tmp12_ = self->priv->tile_xs;
	_tmp12__length1 = self->priv->tile_xs_length1;
	_tmp12__length2 = self->priv->tile_xs_length2;
	_tmp13_ = _tmp12_[(x * _tmp12__length2) + y];
	_tmp14_ = self->priv->tile_ys;
	_tmp14__length1 = self->priv->tile_ys_length1;
	_tmp14__length2 = self->priv->tile_ys_length2;
	_tmp15_ = _tmp14_[(x * _tmp14__length2) + y];
	_tmp16_ = self->priv->_theme_manager;
	_tmp17_ = theme_manager_get_background_radius (_tmp16_);
	_tmp18_ = _tmp17_;
	reversi_view_rounded_square (self, cr, (gdouble) _tmp13_, (gdouble) _tmp15_, self->priv->tile_size, (gdouble) 0, (gdouble) _tmp18_);
	cairo_fill (cr);
}

static void
reversi_view_queue_draw_tile (ReversiView* self,
                              guint8 x,
                              guint8 y)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (x < self->priv->game_size, "x < game_size");
	_vala_return_if_fail (y < self->priv->game_size, "y < game_size");
	_tmp0_ = self->priv->tile_xs;
	_tmp0__length1 = self->priv->tile_xs_length1;
	_tmp0__length2 = self->priv->tile_xs_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	_tmp2_ = self->priv->tile_ys;
	_tmp2__length1 = self->priv->tile_ys_length1;
	_tmp2__length2 = self->priv->tile_ys_length2;
	_tmp3_ = _tmp2_[(x * _tmp2__length2) + y];
	gtk_widget_queue_draw_area ((GtkWidget*) self, self->priv->board_x + _tmp1_, self->priv->board_y + _tmp3_, self->priv->tile_size, self->priv->tile_size);
}

static inline void
reversi_view_update_highlight_after_undo (ReversiView* self)
{
	guint8 x = 0U;
	guint8 y = 0U;
	guint8 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->last_state_set, "last_state_set");
	reversi_view_get_missing_tile (self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	if (self->priv->show_highlight) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->show_mouse_highlight;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = ((gint) self->priv->highlight_state) != 0;
	}
	if (_tmp2_) {
		Game* _tmp8_;
		Game* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		self->priv->highlight_state = (guint8) 0;
		if (self->priv->show_highlight) {
			Game* _tmp4_;
			Game* _tmp5_;
			_tmp4_ = reversi_view_get_game (self);
			_tmp5_ = _tmp4_;
			reversi_view_set_square (self, self->priv->highlight_x, self->priv->highlight_y, reversi_view_get_pixmap (game_get_owner (_tmp5_, self->priv->highlight_x, self->priv->highlight_y)), FALSE, TRUE);
		}
		if (self->priv->show_mouse_highlight) {
			Game* _tmp6_;
			Game* _tmp7_;
			_tmp6_ = reversi_view_get_game (self);
			_tmp7_ = _tmp6_;
			reversi_view_set_square (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y, reversi_view_get_pixmap (game_get_owner (_tmp7_, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y)), FALSE, TRUE);
		}
		_tmp8_ = reversi_view_get_game (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = game_get_is_complete (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			if (self->priv->show_highlight) {
				_tmp13_ = x == self->priv->highlight_x;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_tmp12_ = y == self->priv->highlight_y;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				self->priv->highlight_state = REVERSI_VIEW_HIGHLIGHT_MAX;
			} else {
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				if (self->priv->show_mouse_highlight) {
					_tmp15_ = x == self->priv->mouse_highlight_x;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					_tmp14_ = y == self->priv->mouse_highlight_y;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					self->priv->highlight_state = REVERSI_VIEW_HIGHLIGHT_MAX;
				} else {
					self->priv->highlight_state = (guint8) 1;
				}
			}
		}
	}
	self->priv->highlight_set = TRUE;
	self->priv->highlight_x = x;
	self->priv->highlight_y = y;
	self->priv->mouse_highlight_x = x;
	self->priv->mouse_highlight_y = y;
	if (!self->priv->mouse_is_in) {
		self->priv->show_highlight = TRUE;
	} else {
		if (!self->priv->show_highlight) {
			self->priv->show_mouse_highlight = TRUE;
		}
	}
	_tmp16_ = reversi_view_get_show_playable_tiles (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		reversi_view_init_possible_moves (self);
		reversi_view_highlight_playable_tiles (self, TRUE);
	}
}

static void
reversi_view_get_missing_tile (ReversiView* self,
                               guint8* x,
                               guint8* y)
{
	guint8 _vala_x = 0U;
	guint8 _vala_y = 0U;
	g_return_if_fail (self != NULL);
	_vala_y = (guint8) 0;
	{
		gboolean _tmp0_ = FALSE;
		_vala_x = (guint8) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = _vala_x;
				_vala_x = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(_vala_x < self->priv->game_size)) {
				break;
			}
			{
				gboolean _tmp2_ = FALSE;
				_vala_y = (guint8) 0;
				_tmp2_ = TRUE;
				while (TRUE) {
					Game* _tmp4_;
					Game* _tmp5_;
					GameStateObject* _tmp6_;
					Game* _tmp7_;
					Game* _tmp8_;
					Player _tmp9_;
					Player _tmp10_;
					if (!_tmp2_) {
						guint8 _tmp3_;
						_tmp3_ = _vala_y;
						_vala_y = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(_vala_y < self->priv->game_size)) {
						break;
					}
					_tmp4_ = reversi_view_get_game (self);
					_tmp5_ = _tmp4_;
					if (game_get_owner (_tmp5_, _vala_x, _vala_y) != PLAYER_NONE) {
						continue;
					}
					_tmp6_ = self->priv->last_state;
					_tmp7_ = reversi_view_get_game (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = game_get_current_color (_tmp8_);
					_tmp10_ = _tmp9_;
					if (game_state_object_get_owner (_tmp6_, _vala_x, _vala_y) == _tmp10_) {
						if (x) {
							*x = _vala_x;
						}
						if (y) {
							*y = _vala_y;
						}
						return;
					}
				}
			}
		}
	}
	g_assert_not_reached ();
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
reversi_view_turn_ended_cb (ReversiView* self,
                            gboolean undoing,
                            gboolean no_draw)
{
	Game* _tmp92_;
	Game* _tmp93_;
	GameStateObject* _tmp94_;
	GameStateObject* _tmp95_;
	GameStateObject* _tmp96_;
	g_return_if_fail (self != NULL);
	if (((gint) self->priv->humans_opening_intensity) != 0) {
		gboolean even_board = FALSE;
		guint8 half_game_size = 0U;
		guint8 target = 0U;
		even_board = (self->priv->game_size % 2) == 0;
		half_game_size = (guint8) (self->priv->game_size / 2);
		if (even_board) {
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			guint8* _tmp28_;
			gint _tmp28__length1;
			guint8 _tmp29_;
			if (!self->priv->last_state_set) {
				_tmp1_ = TRUE;
			} else {
				GameStateObject* _tmp2_;
				_tmp2_ = self->priv->last_state;
				_tmp1_ = game_state_object_get_owner (_tmp2_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE;
			}
			if (_tmp1_) {
				Game* _tmp3_;
				Game* _tmp4_;
				GameStateObject* _tmp5_;
				GameStateObject* _tmp6_;
				_tmp3_ = reversi_view_get_game (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = game_get_current_state (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = game_state_object_get_owner (_tmp6_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) != PLAYER_NONE;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				target = (guint8) 1;
			} else {
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!self->priv->last_state_set) {
					_tmp8_ = TRUE;
				} else {
					GameStateObject* _tmp9_;
					_tmp9_ = self->priv->last_state;
					_tmp8_ = game_state_object_get_owner (_tmp9_, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_NONE;
				}
				if (_tmp8_) {
					Game* _tmp10_;
					Game* _tmp11_;
					GameStateObject* _tmp12_;
					GameStateObject* _tmp13_;
					_tmp10_ = reversi_view_get_game (self);
					_tmp11_ = _tmp10_;
					_tmp12_ = game_get_current_state (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp7_ = game_state_object_get_owner (_tmp13_, half_game_size, (guint8) (half_game_size - 1)) != PLAYER_NONE;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					target = (guint8) 2;
				} else {
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					if (!self->priv->last_state_set) {
						_tmp15_ = TRUE;
					} else {
						GameStateObject* _tmp16_;
						_tmp16_ = self->priv->last_state;
						_tmp15_ = game_state_object_get_owner (_tmp16_, (guint8) (half_game_size - 1), half_game_size) == PLAYER_NONE;
					}
					if (_tmp15_) {
						Game* _tmp17_;
						Game* _tmp18_;
						GameStateObject* _tmp19_;
						GameStateObject* _tmp20_;
						_tmp17_ = reversi_view_get_game (self);
						_tmp18_ = _tmp17_;
						_tmp19_ = game_get_current_state (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp14_ = game_state_object_get_owner (_tmp20_, (guint8) (half_game_size - 1), half_game_size) != PLAYER_NONE;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						target = (guint8) 3;
					} else {
						gboolean _tmp21_ = FALSE;
						gboolean _tmp22_ = FALSE;
						if (!self->priv->last_state_set) {
							_tmp22_ = TRUE;
						} else {
							GameStateObject* _tmp23_;
							_tmp23_ = self->priv->last_state;
							_tmp22_ = game_state_object_get_owner (_tmp23_, half_game_size, half_game_size) == PLAYER_NONE;
						}
						if (_tmp22_) {
							Game* _tmp24_;
							Game* _tmp25_;
							GameStateObject* _tmp26_;
							GameStateObject* _tmp27_;
							_tmp24_ = reversi_view_get_game (self);
							_tmp25_ = _tmp24_;
							_tmp26_ = game_get_current_state (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp21_ = game_state_object_get_owner (_tmp27_, half_game_size, half_game_size) != PLAYER_NONE;
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							target = (guint8) 4;
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
			_tmp28_ = self->priv->overture_target;
			_tmp28__length1 = self->priv->overture_target_length1;
			_tmp28_[self->priv->current_overture_playable] = target;
			_tmp29_ = self->priv->current_overture_playable;
			self->priv->current_overture_playable = _tmp29_ + 1;
		} else {
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
			guint8* _tmp86_;
			gint _tmp86__length1;
			guint8 _tmp87_;
			guint8* _tmp88_;
			gint _tmp88__length1;
			guint8 _tmp89_;
			if (!self->priv->last_state_set) {
				_tmp31_ = TRUE;
			} else {
				GameStateObject* _tmp32_;
				_tmp32_ = self->priv->last_state;
				_tmp31_ = game_state_object_get_owner (_tmp32_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE;
			}
			if (_tmp31_) {
				Game* _tmp33_;
				Game* _tmp34_;
				GameStateObject* _tmp35_;
				GameStateObject* _tmp36_;
				_tmp33_ = reversi_view_get_game (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = game_get_current_state (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp30_ = game_state_object_get_owner (_tmp36_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) != PLAYER_NONE;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				target = (guint8) 1;
			} else {
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				if (!self->priv->last_state_set) {
					_tmp38_ = TRUE;
				} else {
					GameStateObject* _tmp39_;
					_tmp39_ = self->priv->last_state;
					_tmp38_ = game_state_object_get_owner (_tmp39_, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_NONE;
				}
				if (_tmp38_) {
					Game* _tmp40_;
					Game* _tmp41_;
					GameStateObject* _tmp42_;
					GameStateObject* _tmp43_;
					_tmp40_ = reversi_view_get_game (self);
					_tmp41_ = _tmp40_;
					_tmp42_ = game_get_current_state (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp37_ = game_state_object_get_owner (_tmp43_, half_game_size, (guint8) (half_game_size - 1)) != PLAYER_NONE;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					target = (guint8) 2;
				} else {
					gboolean _tmp44_ = FALSE;
					gboolean _tmp45_ = FALSE;
					if (!self->priv->last_state_set) {
						_tmp45_ = TRUE;
					} else {
						GameStateObject* _tmp46_;
						_tmp46_ = self->priv->last_state;
						_tmp45_ = game_state_object_get_owner (_tmp46_, (guint8) (half_game_size + 1), (guint8) (half_game_size - 1)) == PLAYER_NONE;
					}
					if (_tmp45_) {
						Game* _tmp47_;
						Game* _tmp48_;
						GameStateObject* _tmp49_;
						GameStateObject* _tmp50_;
						_tmp47_ = reversi_view_get_game (self);
						_tmp48_ = _tmp47_;
						_tmp49_ = game_get_current_state (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp44_ = game_state_object_get_owner (_tmp50_, (guint8) (half_game_size + 1), (guint8) (half_game_size - 1)) != PLAYER_NONE;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						target = (guint8) 3;
					} else {
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						if (!self->priv->last_state_set) {
							_tmp52_ = TRUE;
						} else {
							GameStateObject* _tmp53_;
							_tmp53_ = self->priv->last_state;
							_tmp52_ = game_state_object_get_owner (_tmp53_, (guint8) (half_game_size - 1), half_game_size) == PLAYER_NONE;
						}
						if (_tmp52_) {
							Game* _tmp54_;
							Game* _tmp55_;
							GameStateObject* _tmp56_;
							GameStateObject* _tmp57_;
							_tmp54_ = reversi_view_get_game (self);
							_tmp55_ = _tmp54_;
							_tmp56_ = game_get_current_state (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp51_ = game_state_object_get_owner (_tmp57_, (guint8) (half_game_size - 1), half_game_size) != PLAYER_NONE;
						} else {
							_tmp51_ = FALSE;
						}
						if (_tmp51_) {
							target = (guint8) 4;
						} else {
							gboolean _tmp58_ = FALSE;
							gboolean _tmp59_ = FALSE;
							if (!self->priv->last_state_set) {
								_tmp59_ = TRUE;
							} else {
								GameStateObject* _tmp60_;
								_tmp60_ = self->priv->last_state;
								_tmp59_ = game_state_object_get_owner (_tmp60_, (guint8) (half_game_size + 1), half_game_size) == PLAYER_NONE;
							}
							if (_tmp59_) {
								Game* _tmp61_;
								Game* _tmp62_;
								GameStateObject* _tmp63_;
								GameStateObject* _tmp64_;
								_tmp61_ = reversi_view_get_game (self);
								_tmp62_ = _tmp61_;
								_tmp63_ = game_get_current_state (_tmp62_);
								_tmp64_ = _tmp63_;
								_tmp58_ = game_state_object_get_owner (_tmp64_, (guint8) (half_game_size + 1), half_game_size) != PLAYER_NONE;
							} else {
								_tmp58_ = FALSE;
							}
							if (_tmp58_) {
								target = (guint8) 6;
							} else {
								gboolean _tmp65_ = FALSE;
								gboolean _tmp66_ = FALSE;
								if (!self->priv->last_state_set) {
									_tmp66_ = TRUE;
								} else {
									GameStateObject* _tmp67_;
									_tmp67_ = self->priv->last_state;
									_tmp66_ = game_state_object_get_owner (_tmp67_, (guint8) (half_game_size - 1), (guint8) (half_game_size + 1)) == PLAYER_NONE;
								}
								if (_tmp66_) {
									Game* _tmp68_;
									Game* _tmp69_;
									GameStateObject* _tmp70_;
									GameStateObject* _tmp71_;
									_tmp68_ = reversi_view_get_game (self);
									_tmp69_ = _tmp68_;
									_tmp70_ = game_get_current_state (_tmp69_);
									_tmp71_ = _tmp70_;
									_tmp65_ = game_state_object_get_owner (_tmp71_, (guint8) (half_game_size - 1), (guint8) (half_game_size + 1)) != PLAYER_NONE;
								} else {
									_tmp65_ = FALSE;
								}
								if (_tmp65_) {
									target = (guint8) 7;
								} else {
									gboolean _tmp72_ = FALSE;
									gboolean _tmp73_ = FALSE;
									if (!self->priv->last_state_set) {
										_tmp73_ = TRUE;
									} else {
										GameStateObject* _tmp74_;
										_tmp74_ = self->priv->last_state;
										_tmp73_ = game_state_object_get_owner (_tmp74_, half_game_size, (guint8) (half_game_size + 1)) == PLAYER_NONE;
									}
									if (_tmp73_) {
										Game* _tmp75_;
										Game* _tmp76_;
										GameStateObject* _tmp77_;
										GameStateObject* _tmp78_;
										_tmp75_ = reversi_view_get_game (self);
										_tmp76_ = _tmp75_;
										_tmp77_ = game_get_current_state (_tmp76_);
										_tmp78_ = _tmp77_;
										_tmp72_ = game_state_object_get_owner (_tmp78_, half_game_size, (guint8) (half_game_size + 1)) != PLAYER_NONE;
									} else {
										_tmp72_ = FALSE;
									}
									if (_tmp72_) {
										target = (guint8) 8;
									} else {
										gboolean _tmp79_ = FALSE;
										gboolean _tmp80_ = FALSE;
										if (!self->priv->last_state_set) {
											_tmp80_ = TRUE;
										} else {
											GameStateObject* _tmp81_;
											_tmp81_ = self->priv->last_state;
											_tmp80_ = game_state_object_get_owner (_tmp81_, (guint8) (half_game_size + 1), (guint8) (half_game_size + 1)) == PLAYER_NONE;
										}
										if (_tmp80_) {
											Game* _tmp82_;
											Game* _tmp83_;
											GameStateObject* _tmp84_;
											GameStateObject* _tmp85_;
											_tmp82_ = reversi_view_get_game (self);
											_tmp83_ = _tmp82_;
											_tmp84_ = game_get_current_state (_tmp83_);
											_tmp85_ = _tmp84_;
											_tmp79_ = game_state_object_get_owner (_tmp85_, (guint8) (half_game_size + 1), (guint8) (half_game_size + 1)) != PLAYER_NONE;
										} else {
											_tmp79_ = FALSE;
										}
										if (_tmp79_) {
											target = (guint8) 9;
										} else {
											g_assert_not_reached ();
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp86_ = self->priv->overture_target;
			_tmp86__length1 = self->priv->overture_target_length1;
			_tmp86_[self->priv->current_overture_playable] = target;
			_tmp87_ = self->priv->current_overture_playable;
			self->priv->current_overture_playable = _tmp87_ + 1;
			_tmp88_ = self->priv->overture_target;
			_tmp88__length1 = self->priv->overture_target_length1;
			_tmp88_[self->priv->current_overture_playable] = (guint8) (10 - target);
			_tmp89_ = self->priv->current_overture_playable;
			self->priv->current_overture_playable = _tmp89_ + 1;
		}
	}
	if (!no_draw) {
		reversi_view_update_squares (self);
		self->priv->playable_tiles_highlight_state = (guint8) 0;
		if (undoing) {
			reversi_view_update_highlight_after_undo (self);
		} else {
			gboolean _tmp90_;
			gboolean _tmp91_;
			_tmp90_ = reversi_view_get_show_playable_tiles (self);
			_tmp91_ = _tmp90_;
			if (_tmp91_) {
				reversi_view_highlight_playable_tiles (self, FALSE);
			}
		}
	}
	_tmp92_ = reversi_view_get_game (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = game_get_current_state (_tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = _g_object_ref0 (_tmp95_);
	_g_object_unref0 (self->priv->last_state);
	self->priv->last_state = _tmp96_;
	self->priv->last_state_set = TRUE;
}

static inline void
reversi_view_update_squares (ReversiView* self)
{
	g_return_if_fail (self != NULL);
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							if (!_tmp2_) {
								guint8 _tmp3_;
								_tmp3_ = y;
								y = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							reversi_view_update_square (self, x, y);
						}
					}
				}
			}
		}
	}
}

static inline void
reversi_view_update_square (ReversiView* self,
                            guint8 x,
                            guint8 y)
{
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	reversi_view_set_square (self, x, y, reversi_view_get_pixmap (game_get_owner (_tmp1_, x, y)), FALSE, FALSE);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ReversiView* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
____lambda17_ (Block7Data* _data7_)
{
	ReversiView* self;
	gboolean animating = FALSE;
	gboolean result;
	self = _data7_->self;
	animating = FALSE;
	{
		guint8 ix = 0U;
		ix = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = ix;
					ix = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(ix < self->priv->game_size)) {
					break;
				}
				{
					guint8 iy = 0U;
					iy = (guint8) 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							gint old = 0;
							gint* _tmp4_;
							gint _tmp4__length1;
							gint _tmp4__length2;
							gint _tmp5_;
							gboolean _tmp6_ = FALSE;
							gboolean _tmp7_ = FALSE;
							gint* _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							gint _tmp13_;
							if (!_tmp2_) {
								guint8 _tmp3_;
								_tmp3_ = iy;
								iy = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(iy < self->priv->game_size)) {
								break;
							}
							_tmp4_ = self->priv->pixmaps;
							_tmp4__length1 = self->priv->pixmaps_length1;
							_tmp4__length2 = self->priv->pixmaps_length2;
							_tmp5_ = _tmp4_[(ix * _tmp4__length2) + iy];
							old = _tmp5_;
							if (_data7_->is_final_animation) {
								_tmp7_ = self->priv->flip_final_result_now;
							} else {
								_tmp7_ = FALSE;
							}
							if (_tmp7_) {
								Game* _tmp8_;
								Game* _tmp9_;
								gboolean _tmp10_;
								gboolean _tmp11_;
								_tmp8_ = reversi_view_get_game (self);
								_tmp9_ = _tmp8_;
								_tmp10_ = game_get_is_complete (_tmp9_);
								_tmp11_ = _tmp10_;
								_tmp6_ = _tmp11_;
							} else {
								_tmp6_ = FALSE;
							}
							if (_tmp6_) {
								reversi_view_flip_final_result_tile (self, ix, iy);
							} else {
								reversi_view_update_square (self, ix, iy);
							}
							_tmp12_ = self->priv->pixmaps;
							_tmp12__length1 = self->priv->pixmaps_length1;
							_tmp12__length2 = self->priv->pixmaps_length2;
							_tmp13_ = _tmp12_[(ix * _tmp12__length2) + iy];
							if (_tmp13_ != old) {
								animating = TRUE;
							}
						}
					}
				}
			}
		}
	}
	if (animating) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		self->priv->animate_timeout = (guint) 0;
		if (!self->priv->show_highlight) {
			_reversi_view_on_motion (self, self->priv->mouse_position_x, self->priv->mouse_position_y, TRUE);
		}
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
_____lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda17_ (self);
	return result;
}

static void
reversi_view_set_square (ReversiView* self,
                         guint8 x,
                         guint8 y,
                         gint pixmap,
                         gboolean is_final_animation,
                         gboolean force_redraw)
{
	Block7Data* _data7_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->is_final_animation = is_final_animation;
	if (!force_redraw) {
		gint* _tmp1_;
		gint _tmp1__length1;
		gint _tmp1__length2;
		gint _tmp2_;
		_tmp1_ = self->priv->pixmaps;
		_tmp1__length1 = self->priv->pixmaps_length1;
		_tmp1__length2 = self->priv->pixmaps_length2;
		_tmp2_ = _tmp1_[(x * _tmp1__length2) + y];
		_tmp0_ = _tmp2_ == pixmap;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	if (pixmap == 0) {
		_tmp3_ = TRUE;
	} else {
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		gint _tmp5_;
		_tmp4_ = self->priv->pixmaps;
		_tmp4__length1 = self->priv->pixmaps_length1;
		_tmp4__length2 = self->priv->pixmaps_length2;
		_tmp5_ = _tmp4_[(x * _tmp4__length2) + y];
		_tmp3_ = _tmp5_ == 0;
	}
	if (_tmp3_) {
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		_tmp6_ = self->priv->pixmaps;
		_tmp6__length1 = self->priv->pixmaps_length1;
		_tmp6__length2 = self->priv->pixmaps_length2;
		_tmp6_[(x * _tmp6__length2) + y] = pixmap;
	} else {
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		_tmp7_ = self->priv->pixmaps;
		_tmp7__length1 = self->priv->pixmaps_length1;
		_tmp7__length2 = self->priv->pixmaps_length2;
		_tmp8_ = _tmp7_[(x * _tmp7__length2) + y];
		if (pixmap > _tmp8_) {
			gint* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
			gint _tmp10_;
			_tmp9_ = self->priv->pixmaps;
			_tmp9__length1 = self->priv->pixmaps_length1;
			_tmp9__length2 = self->priv->pixmaps_length2;
			_tmp10_ = _tmp9_[(x * _tmp9__length2) + y];
			_tmp9_[(x * _tmp9__length2) + y] = _tmp10_ + 1;
		} else {
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp11__length2;
			gint _tmp12_;
			_tmp11_ = self->priv->pixmaps;
			_tmp11__length1 = self->priv->pixmaps_length1;
			_tmp11__length2 = self->priv->pixmaps_length2;
			_tmp12_ = _tmp11_[(x * _tmp11__length2) + y];
			_tmp11_[(x * _tmp11__length2) + y] = _tmp12_ - 1;
		}
		if (self->priv->animate_timeout == ((guint) 0)) {
			self->priv->animate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) REVERSI_VIEW_PIXMAP_FLIP_DELAY, _____lambda17__gsource_func, block7_data_ref (_data7_), block7_data_unref);
		}
	}
	reversi_view_queue_draw_tile (self, x, y);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gint
reversi_view_get_pixmap (Player color)
{
	gint result;
	switch (color) {
		default:
		case PLAYER_NONE:
		{
			result = 0;
			return result;
		}
		case PLAYER_DARK:
		{
			result = 1;
			return result;
		}
		case PLAYER_LIGHT:
		{
			result = 31;
			return result;
		}
	}
}

static gboolean
___lambda16_ (ReversiView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_is_complete (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	g_signal_emit (self, reversi_view_signals[REVERSI_VIEW_NOTIFY_FINAL_ANIMATION_SIGNAL], 0, FALSE);
	reversi_view_set_winner_and_loser_variables (self);
	self->priv->flip_final_result_now = TRUE;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					guint8 _tmp5_;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							if (!_tmp6_) {
								guint8 _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							reversi_view_flip_final_result_tile (self, x, y);
						}
					}
				}
			}
		}
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda16_ ((ReversiView*) self);
	return result;
}

static void
reversi_view_game_is_complete_cb (ReversiView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_;
	Game* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_is_complete (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp5_ = reversi_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_n_light_tiles (_tmp6_);
	_tmp8_ = _tmp7_;
	if (((gint) _tmp8_) == 0) {
		_tmp4_ = TRUE;
	} else {
		Game* _tmp9_;
		Game* _tmp10_;
		guint8 _tmp11_;
		guint8 _tmp12_;
		_tmp9_ = reversi_view_get_game (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = game_get_n_dark_tiles (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp4_ = ((gint) _tmp12_) == 0;
	}
	if (_tmp4_) {
		return;
	}
	if (((gint) self->priv->game_size) >= 6) {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda16__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
reversi_view_flip_final_result_tile (ReversiView* self,
                                     guint8 x,
                                     guint8 y)
{
	gint pixmap = 0;
	guint8 n = 0U;
	g_return_if_fail (self != NULL);
	n = (y * self->priv->game_size) + x;
	if (((gint) n) < self->priv->n_winning_tiles) {
		pixmap = reversi_view_get_pixmap (self->priv->winning_color);
	} else {
		if (((gint) n) < (self->priv->n_winning_tiles + self->priv->n_losing_tiles)) {
			pixmap = reversi_view_get_pixmap (self->priv->losing_color);
		} else {
			pixmap = reversi_view_get_pixmap (PLAYER_NONE);
		}
	}
	reversi_view_set_square (self, x, y, pixmap, TRUE, FALSE);
}

static void
reversi_view_set_winner_and_loser_variables (ReversiView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->n_winning_tiles = (gint) _tmp3_;
	_tmp4_ = reversi_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_n_dark_tiles (_tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->n_losing_tiles = (gint) _tmp7_;
	if (self->priv->n_losing_tiles > self->priv->n_winning_tiles) {
		gint t = 0;
		self->priv->winning_color = PLAYER_DARK;
		self->priv->losing_color = PLAYER_LIGHT;
		t = self->priv->n_winning_tiles;
		self->priv->n_winning_tiles = self->priv->n_losing_tiles;
		self->priv->n_losing_tiles = t;
	} else {
		self->priv->winning_color = PLAYER_LIGHT;
		self->priv->losing_color = PLAYER_DARK;
	}
}

gboolean
reversi_view_undo_final_animation (ReversiView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->flip_final_result_now) {
		result = FALSE;
		return result;
	}
	g_signal_emit (self, reversi_view_signals[REVERSI_VIEW_NOTIFY_FINAL_ANIMATION_SIGNAL], 0, TRUE);
	self->priv->flip_final_result_now = FALSE;
	reversi_view_update_squares (self);
	reversi_view_highlight_playable_tiles (self, FALSE);
	result = TRUE;
	return result;
}

static void
_reversi_view_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self)
{
	reversi_view_on_motion ((ReversiView*) self, _sender, x, y);
}

static void
_reversi_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                        gint n_press,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self)
{
	reversi_view_on_click ((ReversiView*) self, _sender, n_press, x, y);
}

static void
reversi_view_init_mouse (ReversiView* self)
{
	GtkEventControllerMotion* _tmp0_;
	GtkEventControllerMotion* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	GtkGestureMultiPress* _tmp3_;
	GtkGestureMultiPress* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp0_;
	_tmp1_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp1_, "motion", (GCallback) _reversi_view_on_motion_gtk_event_controller_motion_motion, self, 0);
	_tmp2_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp2_;
	_tmp3_ = self->priv->click_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp3_, (guint) 0);
	_tmp4_ = self->priv->click_controller;
	g_signal_connect_object (_tmp4_, "pressed", (GCallback) _reversi_view_on_click_gtk_gesture_multi_press_pressed, self, 0);
}

static gboolean
reversi_view_real_enter_notify_event (GtkWidget* base,
                                      GdkEventCrossing* event)
{
	ReversiView * self;
	guint8 x = 0U;
	guint8 y = 0U;
	guint8 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
	gboolean _tmp2_;
	gboolean result;
	self = (ReversiView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = reversi_view_pointer_is_in_board (self, event->x, event->y, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	if (_tmp2_) {
		reversi_view_on_cursor_moving_in (self, x, y);
	} else {
		if (self->priv->mouse_is_in) {
			g_assert_not_reached ();
		}
	}
	result = FALSE;
	return result;
}

static void
reversi_view_on_cursor_moving_in (ReversiView* self,
                                  guint8 x,
                                  guint8 y)
{
	g_return_if_fail (self != NULL);
	self->priv->mouse_position_x = x;
	self->priv->mouse_position_y = y;
	self->priv->mouse_position_set = TRUE;
	self->priv->mouse_is_in = TRUE;
	_reversi_view_on_motion (self, x, y, TRUE);
}

static gboolean
reversi_view_real_leave_notify_event (GtkWidget* base,
                                      GdkEventCrossing* event)
{
	ReversiView * self;
	gboolean result;
	self = (ReversiView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->mouse_is_in = FALSE;
	if (self->priv->mouse_position_set) {
		reversi_view_queue_draw_tile (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
	}
	result = FALSE;
	return result;
}

static gboolean
reversi_view_pointer_is_in_board (ReversiView* self,
                                  gdouble pos_x,
                                  gdouble pos_y,
                                  guint8* x,
                                  guint8* y)
{
	guint8 _vala_x = 0U;
	guint8 _vala_y = 0U;
	gint _x = 0;
	gint _y = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_x = (gint) floor ((pos_x - ((gdouble) self->priv->board_x)) / ((gdouble) self->priv->paving_size));
	_y = (gint) floor ((pos_y - ((gdouble) self->priv->board_y)) / ((gdouble) self->priv->paving_size));
	if (_x >= 0) {
		_tmp2_ = _x < ((gint) self->priv->game_size);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = _y >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = _y < ((gint) self->priv->game_size);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_vala_x = (guint8) _x;
		_vala_y = (guint8) _y;
		result = TRUE;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		return result;
	} else {
		_vala_x = G_MAXUINT8;
		_vala_y = G_MAXUINT8;
		result = FALSE;
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		return result;
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ReversiView* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
______lambda19_ (Block8Data* _data8_)
{
	ReversiView* self;
	gboolean result;
	self = _data8_->self;
	if (self->priv->mouse_is_in) {
		_reversi_view_on_motion (self, _data8_->x, _data8_->y, FALSE);
	}
	self->priv->timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_______lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = ______lambda19_ (self);
	return result;
}

static void
reversi_view_on_motion (ReversiView* self,
                        GtkEventControllerMotion* _motion_controller,
                        gdouble event_x,
                        gdouble event_y)
{
	Block8Data* _data8_;
	guint8 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_motion_controller != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp2_ = reversi_view_pointer_is_in_board (self, event_x, event_y, &_tmp0_, &_tmp1_);
	_data8_->x = _tmp0_;
	_data8_->y = _tmp1_;
	if (_tmp2_) {
		if (!self->priv->mouse_is_in) {
			reversi_view_on_cursor_moving_in (self, _data8_->x, _data8_->y);
		} else {
			gboolean _tmp3_ = FALSE;
			if (_data8_->x != self->priv->mouse_position_x) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = _data8_->y != self->priv->mouse_position_y;
			}
			if (_tmp3_) {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				self->priv->mouse_position_x = _data8_->x;
				self->priv->mouse_position_y = _data8_->y;
				self->priv->mouse_position_set = TRUE;
				if (self->priv->show_highlight) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = _data8_->x != self->priv->mouse_highlight_x;
				}
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = _data8_->y != self->priv->mouse_highlight_y;
				}
				if (_tmp4_) {
					guint delay = 0U;
					gboolean _tmp6_;
					if (self->priv->timeout_id != ((guint) 0)) {
						g_source_remove (self->priv->timeout_id);
						self->priv->timeout_id = (guint) 0;
					}
					_tmp6_ = self->priv->_show_turnable_tiles;
					if (_tmp6_) {
						delay = (guint) 120;
					} else {
						gboolean _tmp7_;
						gboolean _tmp8_;
						_tmp7_ = reversi_view_get_show_playable_tiles (self);
						_tmp8_ = _tmp7_;
						if (_tmp8_) {
							delay = (guint) 50;
						} else {
							delay = (guint) 200;
						}
					}
					self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, delay, _______lambda19__gsource_func, block8_data_ref (_data8_), block8_data_unref);
				}
			}
		}
	} else {
		self->priv->mouse_is_in = FALSE;
		self->priv->show_mouse_highlight = FALSE;
		if (self->priv->mouse_position_set) {
			reversi_view_queue_draw_tile (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
		}
	}
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
_reversi_view_on_motion (ReversiView* self,
                         guint8 x,
                         guint8 y,
                         gboolean force_redraw)
{
	gboolean _tmp0_ = FALSE;
	gboolean old_show_mouse_highlight = FALSE;
	PossibleMove move = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp7_ = FALSE;
	guint8 old_mouse_highlight_x = 0U;
	guint8 old_mouse_highlight_y = 0U;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!force_redraw) {
		gboolean _tmp1_ = FALSE;
		if (x != self->priv->mouse_position_x) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = y != self->priv->mouse_position_y;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	old_show_mouse_highlight = self->priv->show_mouse_highlight;
	if (self->priv->mouse_is_in) {
		Game* _tmp3_;
		Game* _tmp4_;
		PossibleMove _tmp5_ = {0};
		gboolean _tmp6_;
		_tmp3_ = reversi_view_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp6_ = game_test_placing_tile (_tmp4_, x, y, &_tmp5_);
		move = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	self->priv->show_mouse_highlight = _tmp2_;
	if (self->priv->show_mouse_highlight) {
		g_signal_emit (self, reversi_view_signals[REVERSI_VIEW_CLEAR_IMPOSSIBLE_TO_MOVE_HERE_WARNING_SIGNAL], 0);
	}
	if (old_show_mouse_highlight) {
		_tmp7_ = !self->priv->show_mouse_highlight;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		self->priv->old_highlight_x = G_MAXUINT8;
		self->priv->old_highlight_y = G_MAXUINT8;
	}
	old_mouse_highlight_x = self->priv->mouse_highlight_x;
	old_mouse_highlight_y = self->priv->mouse_highlight_y;
	self->priv->mouse_highlight_x = x;
	self->priv->mouse_highlight_y = y;
	if (old_mouse_highlight_x != G_MAXUINT8) {
		_tmp8_ = old_mouse_highlight_y != G_MAXUINT8;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		reversi_view_queue_draw_tile (self, old_mouse_highlight_x, old_mouse_highlight_y);
	}
	if (self->priv->show_mouse_highlight) {
		_tmp9_ = self->priv->show_highlight;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		self->priv->show_highlight = FALSE;
		if (self->priv->highlight_x != x) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = self->priv->highlight_y != y;
		}
		if (_tmp10_) {
			reversi_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
		}
	}
	if (self->priv->show_mouse_highlight) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = force_redraw;
	}
	if (_tmp12_) {
		gboolean _tmp13_ = FALSE;
		if (self->priv->mouse_highlight_x != G_MAXUINT8) {
			_tmp13_ = self->priv->mouse_highlight_y != G_MAXUINT8;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp11_ = _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		reversi_view_queue_draw_tile (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
	}
}

static inline void
reversi_view_on_click (ReversiView* self,
                       GtkGestureMultiPress* _click_controller,
                       gint n_press,
                       gdouble event_x,
                       gdouble event_y)
{
	guint button = 0U;
	gboolean _tmp0_ = FALSE;
	guint8 x = 0U;
	guint8 y = 0U;
	guint8 _tmp1_ = 0U;
	guint8 _tmp2_ = 0U;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	if (!self->priv->game_is_set) {
		return;
	}
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _click_controller);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = button != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = reversi_view_pointer_is_in_board (self, event_x, event_y, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	if (_tmp3_) {
		self->priv->mouse_is_in = TRUE;
		self->priv->show_highlight = FALSE;
		self->priv->old_highlight_x = self->priv->highlight_x;
		self->priv->old_highlight_y = self->priv->highlight_y;
		gtk_widget_queue_draw ((GtkWidget*) self);
		self->priv->highlight_set = TRUE;
		self->priv->highlight_x = x;
		self->priv->highlight_y = y;
		reversi_view_move_if_possible (self, self->priv->highlight_x, self->priv->highlight_y);
	}
}

static gboolean
_reversi_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state,
                                                                   gpointer self)
{
	gboolean result;
	result = reversi_view_on_key_pressed ((ReversiView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
reversi_view_init_keyboard (ReversiView* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _reversi_view_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
reversi_view_on_key_pressed (ReversiView* self,
                             GtkEventControllerKey* _key_controller,
                             guint keyval,
                             guint keycode,
                             GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* key = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	GQuark _tmp66_ = 0U;
	static GQuark _tmp65_label0 = 0;
	static GQuark _tmp65_label1 = 0;
	static GQuark _tmp65_label2 = 0;
	static GQuark _tmp65_label3 = 0;
	static GQuark _tmp65_label4 = 0;
	static GQuark _tmp65_label5 = 0;
	static GQuark _tmp65_label6 = 0;
	static GQuark _tmp65_label7 = 0;
	static GQuark _tmp65_label8 = 0;
	static GQuark _tmp65_label9 = 0;
	static GQuark _tmp65_label10 = 0;
	static GQuark _tmp65_label11 = 0;
	static GQuark _tmp65_label12 = 0;
	static GQuark _tmp65_label13 = 0;
	static GQuark _tmp65_label14 = 0;
	static GQuark _tmp65_label15 = 0;
	static GQuark _tmp65_label16 = 0;
	static GQuark _tmp65_label17 = 0;
	static GQuark _tmp65_label18 = 0;
	static GQuark _tmp65_label19 = 0;
	static GQuark _tmp65_label20 = 0;
	static GQuark _tmp65_label21 = 0;
	static GQuark _tmp65_label22 = 0;
	static GQuark _tmp65_label23 = 0;
	static GQuark _tmp65_label24 = 0;
	static GQuark _tmp65_label25 = 0;
	static GQuark _tmp65_label26 = 0;
	static GQuark _tmp65_label27 = 0;
	static GQuark _tmp65_label28 = 0;
	static GQuark _tmp65_label29 = 0;
	static GQuark _tmp65_label30 = 0;
	static GQuark _tmp65_label31 = 0;
	static GQuark _tmp65_label32 = 0;
	static GQuark _tmp65_label33 = 0;
	static GQuark _tmp65_label34 = 0;
	static GQuark _tmp65_label35 = 0;
	static GQuark _tmp65_label36 = 0;
	static GQuark _tmp65_label37 = 0;
	static GQuark _tmp65_label38 = 0;
	static GQuark _tmp65_label39 = 0;
	static GQuark _tmp65_label40 = 0;
	static GQuark _tmp65_label41 = 0;
	static GQuark _tmp65_label42 = 0;
	static GQuark _tmp65_label43 = 0;
	static GQuark _tmp65_label44 = 0;
	static GQuark _tmp65_label45 = 0;
	static GQuark _tmp65_label46 = 0;
	static GQuark _tmp65_label47 = 0;
	static GQuark _tmp65_label48 = 0;
	static GQuark _tmp65_label49 = 0;
	static GQuark _tmp65_label50 = 0;
	static GQuark _tmp65_label51 = 0;
	static GQuark _tmp65_label52 = 0;
	static GQuark _tmp65_label53 = 0;
	static GQuark _tmp65_label54 = 0;
	static GQuark _tmp65_label55 = 0;
	static GQuark _tmp65_label56 = 0;
	static GQuark _tmp65_label57 = 0;
	static GQuark _tmp65_label58 = 0;
	static GQuark _tmp65_label59 = 0;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	const gchar* _tmp73_;
	const gchar* _tmp76_;
	gboolean _tmp77_ = FALSE;
	const gchar* _tmp78_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	if (!self->priv->game_is_set) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	key = _tmp2_;
	_tmp3_ = key;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	if (self->priv->show_highlight) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = key;
		if (g_strcmp0 (_tmp7_, "space") == 0) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = key;
			_tmp6_ = g_strcmp0 (_tmp8_, "Return") == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = key;
			_tmp5_ = g_strcmp0 (_tmp9_, "KP_Enter") == 0;
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		reversi_view_move_if_possible (self, self->priv->highlight_x, self->priv->highlight_y);
		result = TRUE;
		_g_free0 (key);
		return result;
	}
	if (((gint) self->priv->game_size) <= 4) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_tmp19_ = key;
		if (g_strcmp0 (_tmp19_, "e") == 0) {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = key;
			_tmp18_ = g_strcmp0 (_tmp20_, "E") == 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = key;
			_tmp17_ = g_strcmp0 (_tmp21_, "5") == 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp22_;
			_tmp22_ = key;
			_tmp16_ = g_strcmp0 (_tmp22_, "KP_5") == 0;
		}
		_tmp15_ = _tmp16_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp23_ = FALSE;
		if (((gint) self->priv->game_size) <= 5) {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			const gchar* _tmp27_;
			_tmp27_ = key;
			if (g_strcmp0 (_tmp27_, "f") == 0) {
				_tmp26_ = TRUE;
			} else {
				const gchar* _tmp28_;
				_tmp28_ = key;
				_tmp26_ = g_strcmp0 (_tmp28_, "F") == 0;
			}
			if (_tmp26_) {
				_tmp25_ = TRUE;
			} else {
				const gchar* _tmp29_;
				_tmp29_ = key;
				_tmp25_ = g_strcmp0 (_tmp29_, "6") == 0;
			}
			if (_tmp25_) {
				_tmp24_ = TRUE;
			} else {
				const gchar* _tmp30_;
				_tmp30_ = key;
				_tmp24_ = g_strcmp0 (_tmp30_, "KP_6") == 0;
			}
			_tmp23_ = _tmp24_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp14_ = _tmp23_;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp31_ = FALSE;
		if (((gint) self->priv->game_size) <= 6) {
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_;
			_tmp35_ = key;
			if (g_strcmp0 (_tmp35_, "g") == 0) {
				_tmp34_ = TRUE;
			} else {
				const gchar* _tmp36_;
				_tmp36_ = key;
				_tmp34_ = g_strcmp0 (_tmp36_, "G") == 0;
			}
			if (_tmp34_) {
				_tmp33_ = TRUE;
			} else {
				const gchar* _tmp37_;
				_tmp37_ = key;
				_tmp33_ = g_strcmp0 (_tmp37_, "7") == 0;
			}
			if (_tmp33_) {
				_tmp32_ = TRUE;
			} else {
				const gchar* _tmp38_;
				_tmp38_ = key;
				_tmp32_ = g_strcmp0 (_tmp38_, "KP_7") == 0;
			}
			_tmp31_ = _tmp32_;
		} else {
			_tmp31_ = FALSE;
		}
		_tmp13_ = _tmp31_;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp39_ = FALSE;
		if (((gint) self->priv->game_size) <= 7) {
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			const gchar* _tmp43_;
			_tmp43_ = key;
			if (g_strcmp0 (_tmp43_, "h") == 0) {
				_tmp42_ = TRUE;
			} else {
				const gchar* _tmp44_;
				_tmp44_ = key;
				_tmp42_ = g_strcmp0 (_tmp44_, "H") == 0;
			}
			if (_tmp42_) {
				_tmp41_ = TRUE;
			} else {
				const gchar* _tmp45_;
				_tmp45_ = key;
				_tmp41_ = g_strcmp0 (_tmp45_, "8") == 0;
			}
			if (_tmp41_) {
				_tmp40_ = TRUE;
			} else {
				const gchar* _tmp46_;
				_tmp46_ = key;
				_tmp40_ = g_strcmp0 (_tmp46_, "KP_8") == 0;
			}
			_tmp39_ = _tmp40_;
		} else {
			_tmp39_ = FALSE;
		}
		_tmp12_ = _tmp39_;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp47_ = FALSE;
		if (((gint) self->priv->game_size) <= 8) {
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			const gchar* _tmp51_;
			_tmp51_ = key;
			if (g_strcmp0 (_tmp51_, "i") == 0) {
				_tmp50_ = TRUE;
			} else {
				const gchar* _tmp52_;
				_tmp52_ = key;
				_tmp50_ = g_strcmp0 (_tmp52_, "I") == 0;
			}
			if (_tmp50_) {
				_tmp49_ = TRUE;
			} else {
				const gchar* _tmp53_;
				_tmp53_ = key;
				_tmp49_ = g_strcmp0 (_tmp53_, "9") == 0;
			}
			if (_tmp49_) {
				_tmp48_ = TRUE;
			} else {
				const gchar* _tmp54_;
				_tmp54_ = key;
				_tmp48_ = g_strcmp0 (_tmp54_, "KP_9") == 0;
			}
			_tmp47_ = _tmp48_;
		} else {
			_tmp47_ = FALSE;
		}
		_tmp11_ = _tmp47_;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp55_ = FALSE;
		if (((gint) self->priv->game_size) <= 9) {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			const gchar* _tmp59_;
			_tmp59_ = key;
			if (g_strcmp0 (_tmp59_, "j") == 0) {
				_tmp58_ = TRUE;
			} else {
				const gchar* _tmp60_;
				_tmp60_ = key;
				_tmp58_ = g_strcmp0 (_tmp60_, "J") == 0;
			}
			if (_tmp58_) {
				_tmp57_ = TRUE;
			} else {
				const gchar* _tmp61_;
				_tmp61_ = key;
				_tmp57_ = g_strcmp0 (_tmp61_, "0") == 0;
			}
			if (_tmp57_) {
				_tmp56_ = TRUE;
			} else {
				const gchar* _tmp62_;
				_tmp62_ = key;
				_tmp56_ = g_strcmp0 (_tmp62_, "KP_0") == 0;
			}
			_tmp55_ = _tmp56_;
		} else {
			_tmp55_ = FALSE;
		}
		_tmp10_ = _tmp55_;
	}
	if (_tmp10_) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	self->priv->old_highlight_x = self->priv->highlight_x;
	self->priv->old_highlight_y = self->priv->highlight_y;
	_tmp63_ = key;
	_tmp64_ = _tmp63_;
	_tmp66_ = (NULL == _tmp64_) ? 0 : g_quark_from_string (_tmp64_);
	if ((_tmp66_ == ((0 != _tmp65_label0) ? _tmp65_label0 : (_tmp65_label0 = g_quark_from_static_string ("Up")))) || (_tmp66_ == ((0 != _tmp65_label1) ? _tmp65_label1 : (_tmp65_label1 = g_quark_from_static_string ("KP_Up"))))) {
		switch (0) {
			default:
			{
				reversi_view_set_highlight_position_if_needed (self, REVERSI_VIEW_DIRECTION_TOP);
				if (((gint) self->priv->highlight_y) > 0) {
					guint8 _tmp67_;
					_tmp67_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp67_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label2) ? _tmp65_label2 : (_tmp65_label2 = g_quark_from_static_string ("Left")))) || (_tmp66_ == ((0 != _tmp65_label3) ? _tmp65_label3 : (_tmp65_label3 = g_quark_from_static_string ("KP_Left"))))) {
		switch (0) {
			default:
			{
				reversi_view_set_highlight_position_if_needed (self, REVERSI_VIEW_DIRECTION_LEFT);
				if (((gint) self->priv->highlight_x) > 0) {
					guint8 _tmp68_;
					_tmp68_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp68_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label4) ? _tmp65_label4 : (_tmp65_label4 = g_quark_from_static_string ("Right")))) || (_tmp66_ == ((0 != _tmp65_label5) ? _tmp65_label5 : (_tmp65_label5 = g_quark_from_static_string ("KP_Right"))))) {
		switch (0) {
			default:
			{
				reversi_view_set_highlight_position_if_needed (self, REVERSI_VIEW_DIRECTION_RIGHT);
				if (((gint) self->priv->highlight_x) < (self->priv->game_size - 1)) {
					guint8 _tmp69_;
					_tmp69_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp69_ + 1;
				}
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label6) ? _tmp65_label6 : (_tmp65_label6 = g_quark_from_static_string ("Down")))) || (_tmp66_ == ((0 != _tmp65_label7) ? _tmp65_label7 : (_tmp65_label7 = g_quark_from_static_string ("KP_Down"))))) {
		switch (0) {
			default:
			{
				reversi_view_set_highlight_position_if_needed (self, REVERSI_VIEW_DIRECTION_BOTTOM);
				if (((gint) self->priv->highlight_y) < (self->priv->game_size - 1)) {
					guint8 _tmp70_;
					_tmp70_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp70_ + 1;
				}
				break;
			}
		}
	} else if (((_tmp66_ == ((0 != _tmp65_label8) ? _tmp65_label8 : (_tmp65_label8 = g_quark_from_static_string ("space")))) || (_tmp66_ == ((0 != _tmp65_label9) ? _tmp65_label9 : (_tmp65_label9 = g_quark_from_static_string ("Return"))))) || (_tmp66_ == ((0 != _tmp65_label10) ? _tmp65_label10 : (_tmp65_label10 = g_quark_from_static_string ("KP_Enter"))))) {
		switch (0) {
			default:
			{
				if (self->priv->show_mouse_highlight) {
					reversi_view_move_if_possible (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
					result = TRUE;
					_g_free0 (key);
					return result;
				} else {
					if (self->priv->mouse_position_set) {
						self->priv->highlight_x = self->priv->mouse_position_x;
						self->priv->highlight_y = self->priv->mouse_position_y;
					} else {
						reversi_view_init_highlight_on_light_tile_if_needed (self);
					}
				}
				break;
			}
		}
	} else if (_tmp66_ == ((0 != _tmp65_label11) ? _tmp65_label11 : (_tmp65_label11 = g_quark_from_static_string ("Escape")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label12) ? _tmp65_label12 : (_tmp65_label12 = g_quark_from_static_string ("a")))) || (_tmp66_ == ((0 != _tmp65_label13) ? _tmp65_label13 : (_tmp65_label13 = g_quark_from_static_string ("A"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label14) ? _tmp65_label14 : (_tmp65_label14 = g_quark_from_static_string ("b")))) || (_tmp66_ == ((0 != _tmp65_label15) ? _tmp65_label15 : (_tmp65_label15 = g_quark_from_static_string ("B"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 1;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label16) ? _tmp65_label16 : (_tmp65_label16 = g_quark_from_static_string ("c")))) || (_tmp66_ == ((0 != _tmp65_label17) ? _tmp65_label17 : (_tmp65_label17 = g_quark_from_static_string ("C"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 2;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label18) ? _tmp65_label18 : (_tmp65_label18 = g_quark_from_static_string ("d")))) || (_tmp66_ == ((0 != _tmp65_label19) ? _tmp65_label19 : (_tmp65_label19 = g_quark_from_static_string ("D"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 3;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label20) ? _tmp65_label20 : (_tmp65_label20 = g_quark_from_static_string ("e")))) || (_tmp66_ == ((0 != _tmp65_label21) ? _tmp65_label21 : (_tmp65_label21 = g_quark_from_static_string ("E"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 4;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label22) ? _tmp65_label22 : (_tmp65_label22 = g_quark_from_static_string ("f")))) || (_tmp66_ == ((0 != _tmp65_label23) ? _tmp65_label23 : (_tmp65_label23 = g_quark_from_static_string ("F"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 5;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label24) ? _tmp65_label24 : (_tmp65_label24 = g_quark_from_static_string ("g")))) || (_tmp66_ == ((0 != _tmp65_label25) ? _tmp65_label25 : (_tmp65_label25 = g_quark_from_static_string ("G"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 6;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label26) ? _tmp65_label26 : (_tmp65_label26 = g_quark_from_static_string ("h")))) || (_tmp66_ == ((0 != _tmp65_label27) ? _tmp65_label27 : (_tmp65_label27 = g_quark_from_static_string ("H"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 7;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label28) ? _tmp65_label28 : (_tmp65_label28 = g_quark_from_static_string ("i")))) || (_tmp66_ == ((0 != _tmp65_label29) ? _tmp65_label29 : (_tmp65_label29 = g_quark_from_static_string ("I"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 8;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label30) ? _tmp65_label30 : (_tmp65_label30 = g_quark_from_static_string ("j")))) || (_tmp66_ == ((0 != _tmp65_label31) ? _tmp65_label31 : (_tmp65_label31 = g_quark_from_static_string ("J"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 9;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label32) ? _tmp65_label32 : (_tmp65_label32 = g_quark_from_static_string ("1")))) || (_tmp66_ == ((0 != _tmp65_label33) ? _tmp65_label33 : (_tmp65_label33 = g_quark_from_static_string ("KP_1"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label34) ? _tmp65_label34 : (_tmp65_label34 = g_quark_from_static_string ("2")))) || (_tmp66_ == ((0 != _tmp65_label35) ? _tmp65_label35 : (_tmp65_label35 = g_quark_from_static_string ("KP_2"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 1;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label36) ? _tmp65_label36 : (_tmp65_label36 = g_quark_from_static_string ("3")))) || (_tmp66_ == ((0 != _tmp65_label37) ? _tmp65_label37 : (_tmp65_label37 = g_quark_from_static_string ("KP_3"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 2;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label38) ? _tmp65_label38 : (_tmp65_label38 = g_quark_from_static_string ("4")))) || (_tmp66_ == ((0 != _tmp65_label39) ? _tmp65_label39 : (_tmp65_label39 = g_quark_from_static_string ("KP_4"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 3;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label40) ? _tmp65_label40 : (_tmp65_label40 = g_quark_from_static_string ("5")))) || (_tmp66_ == ((0 != _tmp65_label41) ? _tmp65_label41 : (_tmp65_label41 = g_quark_from_static_string ("KP_5"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 4;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label42) ? _tmp65_label42 : (_tmp65_label42 = g_quark_from_static_string ("6")))) || (_tmp66_ == ((0 != _tmp65_label43) ? _tmp65_label43 : (_tmp65_label43 = g_quark_from_static_string ("KP_6"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 5;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label44) ? _tmp65_label44 : (_tmp65_label44 = g_quark_from_static_string ("7")))) || (_tmp66_ == ((0 != _tmp65_label45) ? _tmp65_label45 : (_tmp65_label45 = g_quark_from_static_string ("KP_7"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 6;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label46) ? _tmp65_label46 : (_tmp65_label46 = g_quark_from_static_string ("8")))) || (_tmp66_ == ((0 != _tmp65_label47) ? _tmp65_label47 : (_tmp65_label47 = g_quark_from_static_string ("KP_8"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 7;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label48) ? _tmp65_label48 : (_tmp65_label48 = g_quark_from_static_string ("9")))) || (_tmp66_ == ((0 != _tmp65_label49) ? _tmp65_label49 : (_tmp65_label49 = g_quark_from_static_string ("KP_9"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 8;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label50) ? _tmp65_label50 : (_tmp65_label50 = g_quark_from_static_string ("0")))) || (_tmp66_ == ((0 != _tmp65_label51) ? _tmp65_label51 : (_tmp65_label51 = g_quark_from_static_string ("KP_0"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 9;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label52) ? _tmp65_label52 : (_tmp65_label52 = g_quark_from_static_string ("Home")))) || (_tmp66_ == ((0 != _tmp65_label53) ? _tmp65_label53 : (_tmp65_label53 = g_quark_from_static_string ("KP_Home"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label54) ? _tmp65_label54 : (_tmp65_label54 = g_quark_from_static_string ("End")))) || (_tmp66_ == ((0 != _tmp65_label55) ? _tmp65_label55 : (_tmp65_label55 = g_quark_from_static_string ("KP_End"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_x = (guint8) (self->priv->game_size - 1);
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label56) ? _tmp65_label56 : (_tmp65_label56 = g_quark_from_static_string ("Page_Up")))) || (_tmp66_ == ((0 != _tmp65_label57) ? _tmp65_label57 : (_tmp65_label57 = g_quark_from_static_string ("KP_Page_Up"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp66_ == ((0 != _tmp65_label58) ? _tmp65_label58 : (_tmp65_label58 = g_quark_from_static_string ("Page_Down")))) || (_tmp66_ == ((0 != _tmp65_label59) ? _tmp65_label59 : (_tmp65_label59 = g_quark_from_static_string ("KP_Next"))))) {
		switch (0) {
			default:
			{
				reversi_view_init_highlight_on_light_tile_if_needed (self);
				self->priv->highlight_y = (guint8) (self->priv->game_size - 1);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (key);
				return result;
			}
		}
	}
	self->priv->highlight_set = TRUE;
	_tmp73_ = key;
	if (g_strcmp0 (_tmp73_, "space") != 0) {
		const gchar* _tmp74_;
		_tmp74_ = key;
		_tmp72_ = g_strcmp0 (_tmp74_, "Return") != 0;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		const gchar* _tmp75_;
		_tmp75_ = key;
		_tmp71_ = g_strcmp0 (_tmp75_, "KP_Enter") != 0;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		g_signal_emit (self, reversi_view_signals[REVERSI_VIEW_CLEAR_IMPOSSIBLE_TO_MOVE_HERE_WARNING_SIGNAL], 0);
	}
	_tmp76_ = key;
	if (g_strcmp0 (_tmp76_, "Escape") == 0) {
		self->priv->show_highlight = FALSE;
	} else {
		if (self->priv->show_highlight) {
			self->priv->highlight_state = REVERSI_VIEW_HIGHLIGHT_MAX;
		} else {
			self->priv->show_highlight = TRUE;
		}
	}
	reversi_view_queue_draw_tile (self, self->priv->old_highlight_x, self->priv->old_highlight_y);
	if (self->priv->old_highlight_x != self->priv->highlight_x) {
		_tmp77_ = TRUE;
	} else {
		_tmp77_ = self->priv->old_highlight_y != self->priv->highlight_y;
	}
	if (_tmp77_) {
		reversi_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
	}
	_tmp78_ = key;
	if (g_strcmp0 (_tmp78_, "Escape") != 0) {
		self->priv->show_mouse_highlight = FALSE;
		if (self->priv->mouse_position_set) {
			reversi_view_queue_draw_tile (self, self->priv->mouse_highlight_x, self->priv->mouse_highlight_y);
		}
	} else {
		gboolean _tmp79_ = FALSE;
		if (self->priv->mouse_position_set) {
			_tmp79_ = self->priv->mouse_is_in;
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			self->priv->highlight_x = self->priv->mouse_position_x;
			self->priv->highlight_y = self->priv->mouse_position_y;
			_reversi_view_on_motion (self, self->priv->highlight_x, self->priv->highlight_y, TRUE);
		}
	}
	result = TRUE;
	_g_free0 (key);
	return result;
}

static void
reversi_view_set_highlight_position_if_needed (ReversiView* self,
                                               ReversiViewDirection direction)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	gboolean _tmp5_ = FALSE;
	Iagno* _tmp6_;
	ComputerPlayer* _tmp7_;
	ComputerPlayer* _tmp8_;
	Game* _tmp20_;
	Game* _tmp21_;
	Opening _tmp22_;
	Opening _tmp23_;
	g_return_if_fail (self != NULL);
	if (self->priv->mouse_position_set) {
		_tmp0_ = self->priv->show_mouse_highlight;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->highlight_x = self->priv->mouse_highlight_x;
		self->priv->highlight_y = self->priv->mouse_highlight_y;
		return;
	}
	if (self->priv->highlight_set) {
		return;
	}
	_tmp1_ = reversi_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_LIGHT) {
		reversi_view_init_highlight_on_light_tile (self);
		return;
	}
	_tmp6_ = self->priv->_iagno_instance;
	_tmp7_ = iagno_get_computer (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		Iagno* _tmp9_;
		Player _tmp10_;
		Player _tmp11_;
		_tmp9_ = self->priv->_iagno_instance;
		_tmp10_ = iagno_get_player_one (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp11_ == PLAYER_LIGHT;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		if (gtk_get_locale_direction () == GTK_TEXT_DIR_LTR) {
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					guint8 _tmp12_;
					_tmp12_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp12_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					guint8 _tmp13_;
					guint8 _tmp14_;
					_tmp13_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp13_ + 1;
					_tmp14_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp14_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp15_;
					_tmp15_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp15_ + 1;
					break;
				}
				default:
				break;
			}
		} else {
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					guint8 _tmp16_;
					guint8 _tmp17_;
					_tmp16_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp16_ + 1;
					_tmp17_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp17_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					guint8 _tmp18_;
					_tmp18_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp18_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp19_;
					_tmp19_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp19_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					break;
				}
				default:
				break;
			}
		}
		return;
	}
	_tmp20_ = reversi_view_get_game (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = game_get_opening (_tmp21_);
	_tmp23_ = _tmp22_;
	switch (_tmp23_) {
		case OPENING_HUMANS:
		{
			if (gtk_get_locale_direction () == GTK_TEXT_DIR_LTR) {
				switch (direction) {
					case REVERSI_VIEW_DIRECTION_TOP:
					{
						guint8 _tmp24_;
						_tmp24_ = self->priv->highlight_y;
						self->priv->highlight_y = _tmp24_ + 1;
						break;
					}
					case REVERSI_VIEW_DIRECTION_LEFT:
					{
						guint8 _tmp25_;
						guint8 _tmp26_;
						_tmp25_ = self->priv->highlight_x;
						self->priv->highlight_x = _tmp25_ + 1;
						_tmp26_ = self->priv->highlight_y;
						self->priv->highlight_y = _tmp26_ + 1;
						break;
					}
					case REVERSI_VIEW_DIRECTION_RIGHT:
					{
						break;
					}
					case REVERSI_VIEW_DIRECTION_BOTTOM:
					{
						guint8 _tmp27_;
						_tmp27_ = self->priv->highlight_x;
						self->priv->highlight_x = _tmp27_ + 1;
						break;
					}
					default:
					break;
				}
			} else {
				switch (direction) {
					case REVERSI_VIEW_DIRECTION_TOP:
					{
						guint8 _tmp28_;
						guint8 _tmp29_;
						_tmp28_ = self->priv->highlight_x;
						self->priv->highlight_x = _tmp28_ + 1;
						_tmp29_ = self->priv->highlight_y;
						self->priv->highlight_y = _tmp29_ + 1;
						break;
					}
					case REVERSI_VIEW_DIRECTION_LEFT:
					{
						guint8 _tmp30_;
						_tmp30_ = self->priv->highlight_x;
						self->priv->highlight_x = _tmp30_ + 1;
						break;
					}
					case REVERSI_VIEW_DIRECTION_RIGHT:
					{
						guint8 _tmp31_;
						_tmp31_ = self->priv->highlight_y;
						self->priv->highlight_y = _tmp31_ + 1;
						break;
					}
					case REVERSI_VIEW_DIRECTION_BOTTOM:
					{
						break;
					}
					default:
					break;
				}
			}
			return;
		}
		case OPENING_REVERSI:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp32_;
					guint8 _tmp33_;
					_tmp32_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp32_ + 1;
					_tmp33_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp33_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp34_;
					guint8 _tmp35_;
					_tmp34_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp34_ + 1;
					_tmp35_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp35_ + 1;
					break;
				}
				default:
				break;
			}
			return;
		}
		case OPENING_INVERTED:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					guint8 _tmp36_;
					_tmp36_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp36_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					guint8 _tmp37_;
					_tmp37_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp37_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp38_;
					_tmp38_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp38_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp39_;
					_tmp39_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp39_ + 1;
					break;
				}
				default:
				break;
			}
			return;
		}
		case OPENING_ALTER_TOP:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					guint8 _tmp40_;
					_tmp40_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp40_ + 1;
					self->priv->highlight_y = (guint8) (self->priv->highlight_y + 3);
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					self->priv->highlight_y = (guint8) (self->priv->highlight_y + 2);
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp41_;
					_tmp41_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp41_ + 1;
					self->priv->highlight_y = (guint8) (self->priv->highlight_y + 2);
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp42_;
					_tmp42_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp42_ + 1;
					break;
				}
				default:
				break;
			}
			return;
		}
		case OPENING_ALTER_LEFT:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					self->priv->highlight_x = (guint8) (self->priv->highlight_x + 2);
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					guint8 _tmp43_;
					self->priv->highlight_x = (guint8) (self->priv->highlight_x + 3);
					_tmp43_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp43_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp44_;
					_tmp44_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp44_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp45_;
					self->priv->highlight_x = (guint8) (self->priv->highlight_x + 2);
					_tmp45_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp45_ + 1;
					break;
				}
				default:
				break;
			}
			return;
		}
		case OPENING_ALTER_RIGHT:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					guint8 _tmp46_;
					_tmp46_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp46_ - 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp47_;
					self->priv->highlight_x = (guint8) (self->priv->highlight_x - 2);
					_tmp47_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp47_ + 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp48_;
					guint8 _tmp49_;
					_tmp48_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp48_ - 1;
					_tmp49_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp49_ + 1;
					break;
				}
				default:
				break;
			}
			return;
		}
		case OPENING_ALTER_BOTTOM:
		{
			switch (direction) {
				case REVERSI_VIEW_DIRECTION_TOP:
				{
					break;
				}
				case REVERSI_VIEW_DIRECTION_LEFT:
				{
					guint8 _tmp50_;
					_tmp50_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp50_ - 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_RIGHT:
				{
					guint8 _tmp51_;
					guint8 _tmp52_;
					_tmp51_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp51_ + 1;
					_tmp52_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp52_ - 1;
					break;
				}
				case REVERSI_VIEW_DIRECTION_BOTTOM:
				{
					guint8 _tmp53_;
					_tmp53_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp53_ + 1;
					self->priv->highlight_y = (guint8) (self->priv->highlight_y - 2);
					break;
				}
				default:
				break;
			}
			return;
		}
		default:
		break;
	}
	g_assert_not_reached ();
}

static void
reversi_view_init_highlight_on_light_tile_if_needed (ReversiView* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!self->priv->highlight_set) {
		Game* _tmp1_;
		Game* _tmp2_;
		Player _tmp3_;
		Player _tmp4_;
		_tmp1_ = reversi_view_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = game_get_current_color (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == PLAYER_LIGHT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		reversi_view_init_highlight_on_light_tile (self);
	}
}

static void
reversi_view_init_highlight_on_light_tile (ReversiView* self)
{
	guint8 half_size = 0U;
	Game* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	g_return_if_fail (self != NULL);
	half_size = (guint8) (self->priv->game_size / 2);
	_tmp0_ = reversi_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (game_get_owner (_tmp1_, (guint8) (half_size - 1), (guint8) (half_size - 1)) == PLAYER_LIGHT) {
		self->priv->highlight_x = (guint8) (half_size - 1);
		self->priv->highlight_y = self->priv->highlight_x;
		return;
	}
	_tmp2_ = reversi_view_get_game (self);
	_tmp3_ = _tmp2_;
	if (game_get_owner (_tmp3_, half_size, half_size) == PLAYER_LIGHT) {
		self->priv->highlight_x = half_size;
		self->priv->highlight_y = half_size;
		return;
	}
	_tmp4_ = reversi_view_get_game (self);
	_tmp5_ = _tmp4_;
	if (game_get_owner (_tmp5_, (guint8) (half_size - 1), half_size) == PLAYER_LIGHT) {
		self->priv->highlight_x = (guint8) (half_size - 1);
		self->priv->highlight_y = half_size;
		return;
	}
	_tmp6_ = reversi_view_get_game (self);
	_tmp7_ = _tmp6_;
	if (game_get_owner (_tmp7_, half_size, (guint8) (half_size - 1)) == PLAYER_LIGHT) {
		self->priv->highlight_x = half_size;
		self->priv->highlight_y = (guint8) (half_size - 1);
		return;
	}
	g_assert_not_reached ();
}

static void
reversi_view_init_possible_moves (ReversiView* self)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->playable_tiles_highlight_state = (guint8) 0;
	_tmp0_ = g_new0 (gboolean, self->priv->game_size * self->priv->game_size);
	self->priv->possible_moves = (g_free (self->priv->possible_moves), NULL);
	self->priv->possible_moves = _tmp0_;
	self->priv->possible_moves_length1 = self->priv->game_size;
	self->priv->possible_moves_length2 = self->priv->game_size;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gboolean* _tmp5_;
							gint _tmp5__length1;
							gint _tmp5__length2;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							_tmp5_ = self->priv->possible_moves;
							_tmp5__length1 = self->priv->possible_moves_length1;
							_tmp5__length2 = self->priv->possible_moves_length2;
							_tmp5_[(x * _tmp5__length2) + y] = FALSE;
						}
					}
				}
			}
		}
	}
}

static inline void
reversi_view_move_if_possible (ReversiView* self,
                               guint8 x,
                               guint8 y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Iagno* _tmp2_;
	ComputerPlayer* _tmp3_;
	ComputerPlayer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_iagno_instance;
	_tmp3_ = iagno_get_computer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		Iagno* _tmp5_;
		Player _tmp6_;
		Player _tmp7_;
		Game* _tmp8_;
		Game* _tmp9_;
		Player _tmp10_;
		Player _tmp11_;
		_tmp5_ = self->priv->_iagno_instance;
		_tmp6_ = iagno_get_player_one (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = reversi_view_get_game (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = game_get_current_color (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp7_ == _tmp11_;
	}
	if (_tmp1_) {
		Game* _tmp12_;
		Game* _tmp13_;
		_tmp12_ = reversi_view_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp0_ = game_get_owner (_tmp13_, x, y) != PLAYER_NONE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		reversi_view_highlight_playable_tiles (self, FALSE);
	} else {
		g_signal_emit (self, reversi_view_signals[REVERSI_VIEW_MOVE_SIGNAL], 0, x, y);
	}
}

static void
_possible_move_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (possible_move_free (var), NULL));
}

static inline void
_g_slist_free__possible_move_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _possible_move_free0_);
}

static void
__lambda18_ (ReversiView* self,
             PossibleMove* move)
{
	guint8 x = 0U;
	guint8 y = 0U;
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	x = ((PossibleMove) (*move)).x;
	y = ((PossibleMove) (*move)).y;
	_tmp0_ = self->priv->possible_moves;
	_tmp0__length1 = self->priv->possible_moves_length1;
	_tmp0__length2 = self->priv->possible_moves_length2;
	_tmp0_[(x * _tmp0__length2) + y] = TRUE;
	reversi_view_queue_draw_tile (self, x, y);
}

static void
___lambda18__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda18_ ((ReversiView*) self, (PossibleMove*) data);
}

static inline void
reversi_view_highlight_playable_tiles (ReversiView* self,
                                       gboolean force_reload)
{
	gboolean _tmp0_ = FALSE;
	GSList* moves = NULL;
	Game* _tmp1_;
	Game* _tmp2_;
	GSList* _tmp3_ = NULL;
	GSList* _tmp4_;
	g_return_if_fail (self != NULL);
	if (!force_reload) {
		_tmp0_ = ((gint) self->priv->playable_tiles_highlight_state) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = reversi_view_get_game (self);
	_tmp2_ = _tmp1_;
	game_get_possible_moves (_tmp2_, &_tmp3_);
	(moves == NULL) ? NULL : (moves = (_g_slist_free__possible_move_free0_ (moves), NULL));
	moves = _tmp3_;
	self->priv->playable_tiles_highlight_state = (guint8) 1;
	_tmp4_ = moves;
	g_slist_foreach (_tmp4_, ___lambda18__gfunc, self);
	(moves == NULL) ? NULL : (moves = (_g_slist_free__possible_move_free0_ (moves), NULL));
}

static gboolean
reversi_view_get_show_playable_tiles (ReversiView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_playable_tiles;
	return result;
}

void
reversi_view_set_show_playable_tiles (ReversiView* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_playable_tiles = value;
	if (self->priv->game_is_set) {
		reversi_view_highlight_playable_tiles (self, FALSE);
	}
}

static gboolean
reversi_view_get_show_turnable_tiles (ReversiView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_turnable_tiles;
	return result;
}

void
reversi_view_set_show_turnable_tiles (ReversiView* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_turnable_tiles = value;
}

Game*
reversi_view_get_game (ReversiView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->game_is_set) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_reversi_view_game_is_complete_cb_game_completeness_updated (Game* _sender,
                                                             gboolean completeness,
                                                             gpointer self)
{
	reversi_view_game_is_complete_cb ((ReversiView*) self);
}

static void
_reversi_view_turn_ended_cb_game_turn_ended (Game* _sender,
                                             gboolean undoing,
                                             gboolean no_draw,
                                             gpointer self)
{
	reversi_view_turn_ended_cb ((ReversiView*) self, undoing, no_draw);
}

void
reversi_view_set_game (ReversiView* self,
                       Game* value)
{
	Game* test = NULL;
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	Game* _tmp15_;
	Game* _tmp16_;
	gboolean even_board = FALSE;
	Game* _tmp17_;
	Opening _tmp18_;
	Opening _tmp19_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	test = _tmp0_;
	if (test == NULL) {
		g_assert_not_reached ();
	}
	if (self->priv->game_is_set) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	_tmp4_ = game_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->game_size = _tmp5_;
	if (!self->priv->game_is_set) {
		gint* _tmp6_;
		gint* _tmp7_;
		gint* _tmp8_;
		_tmp6_ = g_new0 (gint, self->priv->game_size * self->priv->game_size);
		self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
		self->priv->pixmaps = _tmp6_;
		self->priv->pixmaps_length1 = self->priv->game_size;
		self->priv->pixmaps_length2 = self->priv->game_size;
		_tmp7_ = g_new0 (gint, self->priv->game_size * self->priv->game_size);
		self->priv->tile_xs = (g_free (self->priv->tile_xs), NULL);
		self->priv->tile_xs = _tmp7_;
		self->priv->tile_xs_length1 = self->priv->game_size;
		self->priv->tile_xs_length2 = self->priv->game_size;
		_tmp8_ = g_new0 (gint, self->priv->game_size * self->priv->game_size);
		self->priv->tile_ys = (g_free (self->priv->tile_ys), NULL);
		self->priv->tile_ys = _tmp8_;
		self->priv->tile_ys_length1 = self->priv->game_size;
		self->priv->tile_ys_length2 = self->priv->game_size;
		self->priv->game_is_set = TRUE;
	}
	reversi_view_init_possible_moves (self);
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				if (!_tmp9_) {
					guint8 _tmp10_;
					_tmp10_ = x;
					x = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(x < self->priv->game_size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gint* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							Game* _tmp14_;
							if (!_tmp11_) {
								guint8 _tmp12_;
								_tmp12_ = y;
								y = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							if (!(y < self->priv->game_size)) {
								break;
							}
							_tmp13_ = self->priv->pixmaps;
							_tmp13__length1 = self->priv->pixmaps_length1;
							_tmp13__length2 = self->priv->pixmaps_length2;
							_tmp14_ = self->priv->_game;
							_tmp13_[(x * _tmp13__length2) + y] = reversi_view_get_pixmap (game_get_owner (_tmp14_, x, y));
						}
					}
				}
			}
		}
	}
	_tmp15_ = self->priv->_game;
	g_signal_connect_object (_tmp15_, "completeness-updated", (GCallback) _reversi_view_game_is_complete_cb_game_completeness_updated, self, 0);
	_tmp16_ = self->priv->_game;
	g_signal_connect_object (_tmp16_, "turn-ended", (GCallback) _reversi_view_turn_ended_cb_game_turn_ended, self, 0);
	self->priv->show_highlight = FALSE;
	even_board = (self->priv->game_size % 2) == 0;
	if (even_board) {
		self->priv->highlight_set = FALSE;
		self->priv->highlight_x = (guint8) ((self->priv->game_size / 2) - 1);
	} else {
		self->priv->highlight_set = TRUE;
		self->priv->highlight_x = (guint8) (self->priv->game_size / 2);
	}
	self->priv->highlight_y = self->priv->highlight_x;
	self->priv->old_highlight_x = G_MAXUINT8;
	self->priv->old_highlight_y = G_MAXUINT8;
	self->priv->highlight_state = (guint8) 0;
	self->priv->show_mouse_highlight = FALSE;
	self->priv->mouse_position_set = FALSE;
	self->priv->mouse_highlight_x = G_MAXUINT8;
	self->priv->mouse_highlight_y = G_MAXUINT8;
	self->priv->mouse_position_x = G_MAXUINT8;
	self->priv->mouse_position_y = G_MAXUINT8;
	self->priv->last_state_set = FALSE;
	_tmp17_ = self->priv->_game;
	_tmp18_ = game_get_opening (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == OPENING_HUMANS) {
		if (even_board) {
			guint8* _tmp20_;
			guint8* _tmp21_;
			_tmp20_ = g_new0 (guint8, 4);
			_tmp20_[0] = (guint8) 0;
			_tmp20_[1] = (guint8) 0;
			_tmp20_[2] = (guint8) 0;
			_tmp20_[3] = (guint8) 0;
			self->priv->overture_steps = (g_free (self->priv->overture_steps), NULL);
			self->priv->overture_steps = _tmp20_;
			self->priv->overture_steps_length1 = 4;
			self->priv->_overture_steps_size_ = self->priv->overture_steps_length1;
			_tmp21_ = g_new0 (guint8, 4);
			_tmp21_[0] = (guint8) 0;
			_tmp21_[1] = (guint8) 0;
			_tmp21_[2] = (guint8) 0;
			_tmp21_[3] = (guint8) 0;
			self->priv->overture_target = (g_free (self->priv->overture_target), NULL);
			self->priv->overture_target = _tmp21_;
			self->priv->overture_target_length1 = 4;
			self->priv->_overture_target_size_ = self->priv->overture_target_length1;
		} else {
			guint8* _tmp22_;
			guint8* _tmp23_;
			_tmp22_ = g_new0 (guint8, 6);
			_tmp22_[0] = (guint8) 0;
			_tmp22_[1] = (guint8) 0;
			_tmp22_[2] = (guint8) 0;
			_tmp22_[3] = (guint8) 0;
			_tmp22_[4] = (guint8) 0;
			_tmp22_[5] = (guint8) 0;
			self->priv->overture_steps = (g_free (self->priv->overture_steps), NULL);
			self->priv->overture_steps = _tmp22_;
			self->priv->overture_steps_length1 = 6;
			self->priv->_overture_steps_size_ = self->priv->overture_steps_length1;
			_tmp23_ = g_new0 (guint8, 6);
			_tmp23_[0] = (guint8) 0;
			_tmp23_[1] = (guint8) 0;
			_tmp23_[2] = (guint8) 0;
			_tmp23_[3] = (guint8) 0;
			_tmp23_[4] = (guint8) 0;
			_tmp23_[5] = (guint8) 0;
			self->priv->overture_target = (g_free (self->priv->overture_target), NULL);
			self->priv->overture_target = _tmp23_;
			self->priv->overture_target_length1 = 6;
			self->priv->_overture_target_size_ = self->priv->overture_target_length1;
		}
		self->priv->current_overture_playable = (guint8) 0;
		if (self->priv->configuration_done) {
			reversi_view_configure_overture_origin (self);
		}
		self->priv->humans_opening_intensity = REVERSI_VIEW_HUMANS_OPENING_INTENSITY_MAX;
	} else {
		self->priv->humans_opening_intensity = (guint8) 0;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp24_ = reversi_view_get_show_playable_tiles (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_) {
		reversi_view_highlight_playable_tiles (self, FALSE);
	}
	_g_object_unref0 (test);
}

static Iagno*
reversi_view_get_iagno_instance (ReversiView* self)
{
	Iagno* result;
	Iagno* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iagno_instance;
	result = _tmp0_;
	return result;
}

static void
reversi_view_set_iagno_instance (ReversiView* self,
                                 Iagno* value)
{
	Iagno* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_iagno_instance);
	self->priv->_iagno_instance = _tmp0_;
}

static ThemeManager*
reversi_view_get_theme_manager (ReversiView* self)
{
	ThemeManager* result;
	ThemeManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_manager;
	result = _tmp0_;
	return result;
}

static void
reversi_view_set_theme_manager (ReversiView* self,
                                ThemeManager* value)
{
	ThemeManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_theme_manager);
	self->priv->_theme_manager = _tmp0_;
}

static void
g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UCHAR_UCHAR) (gpointer data1, guint8 arg_1, guint8 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UCHAR_UCHAR callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UCHAR_UCHAR) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uchar (param_values + 1), g_value_get_uchar (param_values + 2), data2);
}

static void
_reversi_view___lambda20_ (ReversiView* self)
{
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	if (self->priv->configuration_done) {
		reversi_view_configure_theme (self);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
__reversi_view___lambda20__theme_manager_theme_changed (ThemeManager* _sender,
                                                        gpointer self)
{
	_reversi_view___lambda20_ ((ReversiView*) self);
}

static GObject *
reversi_view_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ReversiView * self;
	ThemeManager* _tmp0_;
	parent_class = G_OBJECT_CLASS (reversi_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REVERSI_VIEW, ReversiView);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, (gint) ((((((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_STRUCTURE_MASK));
	reversi_view_init_mouse (self);
	reversi_view_init_keyboard (self);
	_tmp0_ = self->priv->_theme_manager;
	g_signal_connect_object (_tmp0_, "theme-changed", (GCallback) __reversi_view___lambda20__theme_manager_theme_changed, self, 0);
	return obj;
}

static void
reversi_view_class_init (ReversiViewClass * klass,
                         gpointer klass_data)
{
	reversi_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ReversiView_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) reversi_view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) reversi_view_real_draw;
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) reversi_view_real_enter_notify_event;
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) reversi_view_real_leave_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_reversi_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_reversi_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = reversi_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = reversi_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), REVERSI_VIEW_SHOW_PLAYABLE_TILES_PROPERTY, reversi_view_properties[REVERSI_VIEW_SHOW_PLAYABLE_TILES_PROPERTY] = g_param_spec_boolean ("show-playable-tiles", "show-playable-tiles", "show-playable-tiles", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REVERSI_VIEW_SHOW_TURNABLE_TILES_PROPERTY, reversi_view_properties[REVERSI_VIEW_SHOW_TURNABLE_TILES_PROPERTY] = g_param_spec_boolean ("show-turnable-tiles", "show-turnable-tiles", "show-turnable-tiles", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REVERSI_VIEW_GAME_PROPERTY, reversi_view_properties[REVERSI_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REVERSI_VIEW_IAGNO_INSTANCE_PROPERTY, reversi_view_properties[REVERSI_VIEW_IAGNO_INSTANCE_PROPERTY] = g_param_spec_object ("iagno-instance", "iagno-instance", "iagno-instance", TYPE_IAGNO, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REVERSI_VIEW_THEME_MANAGER_PROPERTY, reversi_view_properties[REVERSI_VIEW_THEME_MANAGER_PROPERTY] = g_param_spec_object ("theme-manager", "theme-manager", "theme-manager", TYPE_THEME_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	reversi_view_signals[REVERSI_VIEW_MOVE_SIGNAL] = g_signal_new ("move", TYPE_REVERSI_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UCHAR_UCHAR, G_TYPE_NONE, 2, G_TYPE_UCHAR, G_TYPE_UCHAR);
	reversi_view_signals[REVERSI_VIEW_CLEAR_IMPOSSIBLE_TO_MOVE_HERE_WARNING_SIGNAL] = g_signal_new ("clear-impossible-to-move-here-warning", TYPE_REVERSI_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	reversi_view_signals[REVERSI_VIEW_NOTIFY_FINAL_ANIMATION_SIGNAL] = g_signal_new ("notify-final-animation", TYPE_REVERSI_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
reversi_view_instance_init (ReversiView * self,
                            gpointer klass)
{
	gint* _tmp0_;
	guint8* _tmp1_;
	guint8* _tmp2_;
	self->priv = reversi_view_get_instance_private (self);
	self->priv->_show_playable_tiles = FALSE;
	self->priv->_show_turnable_tiles = FALSE;
	self->priv->show_highlight = FALSE;
	self->priv->highlight_set = FALSE;
	self->priv->highlight_x = G_MAXUINT8;
	self->priv->highlight_y = G_MAXUINT8;
	self->priv->old_highlight_x = G_MAXUINT8;
	self->priv->old_highlight_y = G_MAXUINT8;
	self->priv->highlight_state = (guint8) 0;
	self->priv->show_mouse_highlight = FALSE;
	self->priv->mouse_position_set = FALSE;
	self->priv->mouse_highlight_x = G_MAXUINT8;
	self->priv->mouse_highlight_y = G_MAXUINT8;
	self->priv->mouse_position_x = G_MAXUINT8;
	self->priv->mouse_position_y = G_MAXUINT8;
	self->priv->render_size = (guint) 0;
	self->priv->tiles_pattern = NULL;
	self->priv->board_pattern = NULL;
	self->priv->noise_pixbuf_loaded = FALSE;
	self->priv->animate_timeout = (guint) 0;
	self->priv->humans_opening_intensity = (guint8) 0;
	self->priv->game_is_set = FALSE;
	self->priv->configuration_done = FALSE;
	_tmp0_ = g_new0 (gint, 6);
	self->priv->overture_origin_xs = _tmp0_;
	self->priv->overture_origin_xs_length1 = 6;
	self->priv->_overture_origin_xs_size_ = self->priv->overture_origin_xs_length1;
	self->priv->overture_origin_y = 0;
	_tmp1_ = g_new0 (guint8, 6);
	_tmp1_[0] = (guint8) 0;
	_tmp1_[1] = (guint8) 0;
	_tmp1_[2] = (guint8) 0;
	_tmp1_[3] = (guint8) 0;
	_tmp1_[4] = (guint8) 0;
	_tmp1_[5] = (guint8) 0;
	self->priv->overture_steps = _tmp1_;
	self->priv->overture_steps_length1 = 6;
	self->priv->_overture_steps_size_ = self->priv->overture_steps_length1;
	_tmp2_ = g_new0 (guint8, 6);
	_tmp2_[0] = (guint8) 0;
	_tmp2_[1] = (guint8) 0;
	_tmp2_[2] = (guint8) 0;
	_tmp2_[3] = (guint8) 0;
	_tmp2_[4] = (guint8) 0;
	_tmp2_[5] = (guint8) 0;
	self->priv->overture_target = _tmp2_;
	self->priv->overture_target_length1 = 6;
	self->priv->_overture_target_size_ = self->priv->overture_target_length1;
	self->priv->current_overture_playable = (guint8) 0;
	self->priv->last_state_set = FALSE;
	self->priv->flip_final_result_now = FALSE;
	self->priv->mouse_is_in = FALSE;
	self->priv->timeout_id = (guint) 0;
}

static void
reversi_view_finalize (GObject * obj)
{
	ReversiView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REVERSI_VIEW, ReversiView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_cairo_pattern_destroy0 (self->priv->board_pattern);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->_iagno_instance);
	_g_object_unref0 (self->priv->_theme_manager);
	self->priv->tile_xs = (g_free (self->priv->tile_xs), NULL);
	self->priv->tile_ys = (g_free (self->priv->tile_ys), NULL);
	self->priv->overture_origin_xs = (g_free (self->priv->overture_origin_xs), NULL);
	self->priv->overture_steps = (g_free (self->priv->overture_steps), NULL);
	self->priv->overture_target = (g_free (self->priv->overture_target), NULL);
	_g_object_unref0 (self->priv->last_state);
	_g_object_unref0 (self->priv->motion_controller);
	_g_object_unref0 (self->priv->click_controller);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->possible_moves = (g_free (self->priv->possible_moves), NULL);
	G_OBJECT_CLASS (reversi_view_parent_class)->finalize (obj);
}

static GType
reversi_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ReversiViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) reversi_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReversiView), 0, (GInstanceInitFunc) reversi_view_instance_init, NULL };
	GType reversi_view_type_id;
	reversi_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ReversiView", &g_define_type_info, 0);
	ReversiView_private_offset = g_type_add_instance_private (reversi_view_type_id, sizeof (ReversiViewPrivate));
	return reversi_view_type_id;
}

GType
reversi_view_get_type (void)
{
	static volatile gsize reversi_view_type_id__once = 0;
	if (g_once_init_enter (&reversi_view_type_id__once)) {
		GType reversi_view_type_id;
		reversi_view_type_id = reversi_view_get_type_once ();
		g_once_init_leave (&reversi_view_type_id__once, reversi_view_type_id);
	}
	return reversi_view_type_id__once;
}

static void
_vala_reversi_view_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ReversiView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REVERSI_VIEW, ReversiView);
	switch (property_id) {
		case REVERSI_VIEW_SHOW_PLAYABLE_TILES_PROPERTY:
		g_value_set_boolean (value, reversi_view_get_show_playable_tiles (self));
		break;
		case REVERSI_VIEW_SHOW_TURNABLE_TILES_PROPERTY:
		g_value_set_boolean (value, reversi_view_get_show_turnable_tiles (self));
		break;
		case REVERSI_VIEW_GAME_PROPERTY:
		g_value_set_object (value, reversi_view_get_game (self));
		break;
		case REVERSI_VIEW_IAGNO_INSTANCE_PROPERTY:
		g_value_set_object (value, reversi_view_get_iagno_instance (self));
		break;
		case REVERSI_VIEW_THEME_MANAGER_PROPERTY:
		g_value_set_object (value, reversi_view_get_theme_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_reversi_view_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ReversiView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REVERSI_VIEW, ReversiView);
	switch (property_id) {
		case REVERSI_VIEW_SHOW_PLAYABLE_TILES_PROPERTY:
		reversi_view_set_show_playable_tiles (self, g_value_get_boolean (value));
		break;
		case REVERSI_VIEW_SHOW_TURNABLE_TILES_PROPERTY:
		reversi_view_set_show_turnable_tiles (self, g_value_get_boolean (value));
		break;
		case REVERSI_VIEW_GAME_PROPERTY:
		reversi_view_set_game (self, g_value_get_object (value));
		break;
		case REVERSI_VIEW_IAGNO_INSTANCE_PROPERTY:
		reversi_view_set_iagno_instance (self, g_value_get_object (value));
		break;
		case REVERSI_VIEW_THEME_MANAGER_PROPERTY:
		reversi_view_set_theme_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

