/* iagno.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2010-2013 Robert Ancell
   Copyright 2013-2014 Michael Catanzaro
   Copyright 2014-2020 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gsound.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>

#define IAGNO_PROGRAM_NAME _ ("Reversi")
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.7
#define IAGNO_SLOW_MOVE_DELAY 1.9
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_APPLICATION (base_application_get_type ())
#define BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_APPLICATION, BaseApplication))
#define IS_BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_APPLICATION))
#define BASE_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BASE_APPLICATION, BaseApplicationIface))

typedef struct _BaseApplication BaseApplication;
typedef struct _BaseApplicationIface BaseApplicationIface;

#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_REVERSI_VIEW (reversi_view_get_type ())
#define REVERSI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REVERSI_VIEW, ReversiView))
#define REVERSI_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REVERSI_VIEW, ReversiViewClass))
#define IS_REVERSI_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REVERSI_VIEW))
#define IS_REVERSI_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REVERSI_VIEW))
#define REVERSI_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REVERSI_VIEW, ReversiViewClass))

typedef struct _ReversiView ReversiView;
typedef struct _ReversiViewClass ReversiViewClass;

#define TYPE_NEW_GAME_SCREEN (new_game_screen_get_type ())
#define NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreen))
#define NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))
#define IS_NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_SCREEN))
#define IS_NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_SCREEN))
#define NEW_GAME_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))

typedef struct _NewGameScreen NewGameScreen;
typedef struct _NewGameScreenClass NewGameScreenClass;

#define TYPE_HISTORY_BUTTON (history_button_get_type ())
#define HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_BUTTON, HistoryButton))
#define HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_BUTTON, HistoryButtonClass))
#define IS_HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_BUTTON))
#define IS_HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_BUTTON))
#define HISTORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_BUTTON, HistoryButtonClass))

typedef struct _HistoryButton HistoryButton;
typedef struct _HistoryButtonClass HistoryButtonClass;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_NIGHT_LIGHT_MONITOR (night_light_monitor_get_type ())
#define NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor))
#define NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))
#define IS_NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_LIGHT_MONITOR))
#define IS_NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_LIGHT_MONITOR))
#define NIGHT_LIGHT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))

typedef struct _NightLightMonitor NightLightMonitor;
typedef struct _NightLightMonitorClass NightLightMonitorClass;
typedef enum  {
	IAGNO_SOUND_CONTEXT_STATE_INITIAL,
	IAGNO_SOUND_CONTEXT_STATE_WORKING,
	IAGNO_SOUND_CONTEXT_STATE_ERRORED
} IagnoSoundContextState;

#define IAGNO_TYPE_SOUND_CONTEXT_STATE (iagno_sound_context_state_get_type ())
enum  {
	IAGNO_0_PROPERTY,
	IAGNO_COMPUTER_PROPERTY,
	IAGNO_PLAYER_ONE_PROPERTY,
	IAGNO_NUM_PROPERTIES
};
static GParamSpec* iagno_properties[IAGNO_NUM_PROPERTIES];
typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef enum  {
	NEW_GAME_SCREEN_MENU_BUTTON_ONE,
	NEW_GAME_SCREEN_MENU_BUTTON_TWO
} NewGameScreenMenuButton;

#define NEW_GAME_SCREEN_TYPE_MENU_BUTTON (new_game_screen_menu_button_get_type ())
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	GAME_WINDOW_FLAGS_HAS_SOUND = 1 << 0,
	GAME_WINDOW_FLAGS_SHORTCUTS = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HELP = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	OPENING_HUMANS,
	OPENING_REVERSI,
	OPENING_INVERTED,
	OPENING_ALTER_TOP,
	OPENING_ALTER_LEFT,
	OPENING_ALTER_RIGHT,
	OPENING_ALTER_BOTTOM
} Opening;

#define TYPE_OPENING (opening_get_type ())

#define TYPE_COMPUTER_REVERSI (computer_reversi_get_type ())
#define COMPUTER_REVERSI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_REVERSI, ComputerReversi))
#define COMPUTER_REVERSI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_REVERSI, ComputerReversiClass))
#define IS_COMPUTER_REVERSI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_REVERSI))
#define IS_COMPUTER_REVERSI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_REVERSI))
#define COMPUTER_REVERSI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_REVERSI, ComputerReversiClass))

typedef struct _ComputerReversi ComputerReversi;
typedef struct _ComputerReversiClass ComputerReversiClass;

#define TYPE_COMPUTER_REVERSE_EASY (computer_reverse_easy_get_type ())
#define COMPUTER_REVERSE_EASY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_REVERSE_EASY, ComputerReverseEasy))
#define COMPUTER_REVERSE_EASY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_REVERSE_EASY, ComputerReverseEasyClass))
#define IS_COMPUTER_REVERSE_EASY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_REVERSE_EASY))
#define IS_COMPUTER_REVERSE_EASY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_REVERSE_EASY))
#define COMPUTER_REVERSE_EASY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_REVERSE_EASY, ComputerReverseEasyClass))

typedef struct _ComputerReverseEasy ComputerReverseEasy;
typedef struct _ComputerReverseEasyClass ComputerReverseEasyClass;

#define TYPE_COMPUTER_REVERSE_HARD (computer_reverse_hard_get_type ())
#define COMPUTER_REVERSE_HARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_REVERSE_HARD, ComputerReverseHard))
#define COMPUTER_REVERSE_HARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_REVERSE_HARD, ComputerReverseHardClass))
#define IS_COMPUTER_REVERSE_HARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_REVERSE_HARD))
#define IS_COMPUTER_REVERSE_HARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_REVERSE_HARD))
#define COMPUTER_REVERSE_HARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_REVERSE_HARD, ComputerReverseHardClass))

typedef struct _ComputerReverseHard ComputerReverseHard;
typedef struct _ComputerReverseHardClass ComputerReverseHardClass;

#define TYPE_COMPUTER_REVERSI_EASY (computer_reversi_easy_get_type ())
#define COMPUTER_REVERSI_EASY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_REVERSI_EASY, ComputerReversiEasy))
#define COMPUTER_REVERSI_EASY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_REVERSI_EASY, ComputerReversiEasyClass))
#define IS_COMPUTER_REVERSI_EASY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_REVERSI_EASY))
#define IS_COMPUTER_REVERSI_EASY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_REVERSI_EASY))
#define COMPUTER_REVERSI_EASY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_REVERSI_EASY, ComputerReversiEasyClass))

typedef struct _ComputerReversiEasy ComputerReversiEasy;
typedef struct _ComputerReversiEasyClass ComputerReversiEasyClass;

#define TYPE_COMPUTER_REVERSI_HARD (computer_reversi_hard_get_type ())
#define COMPUTER_REVERSI_HARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_REVERSI_HARD, ComputerReversiHard))
#define COMPUTER_REVERSI_HARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_REVERSI_HARD, ComputerReversiHardClass))
#define IS_COMPUTER_REVERSI_HARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_REVERSI_HARD))
#define IS_COMPUTER_REVERSI_HARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_REVERSI_HARD))
#define COMPUTER_REVERSI_HARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_REVERSI_HARD, ComputerReversiHardClass))

typedef struct _ComputerReversiHard ComputerReversiHard;
typedef struct _ComputerReversiHardClass ComputerReversiHardClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BaseApplicationIface {
	GTypeInterface parent_iface;
	void (*copy) (BaseApplication* self, const gchar* text);
	void (*get_about_dialog_infos) (BaseApplication* self, gchar*** artists, gint* artists_length1, gchar*** authors, gint* authors_length1, gchar** comments, gchar** copyright, gchar*** documenters, gint* documenters_length1, gchar** logo_icon_name, gchar** program_name, gchar** translator_credits, gchar** version, gchar** website, gchar** website_label);
};

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	ReversiView* view;
	NewGameScreen* new_game_screen;
	HistoryButton* history_button_1;
	HistoryButton* history_button_2;
	GMenu* history_menu;
	GMenu* finish_menu;
	ThemeManager* theme_manager;
	ComputerPlayer* _computer;
	Player _player_one;
	Game* game;
	gboolean game_is_set;
	NightLightMonitor* night_light_monitor;
	GSimpleAction* alternate_who_starts_action;
	gboolean game_type_changed_1;
	gboolean game_type_changed_2;
	gboolean level_changed;
	GSimpleAction* change_level_action;
	gboolean first_player_is_human;
	GSoundContext* sound_context;
	IagnoSoundContextState sound_context_state;
};

static gint Iagno_private_offset;
static gpointer iagno_parent_class = NULL;
static gboolean iagno_alternative_start;
static gboolean iagno_classic_game;
static gboolean iagno_fast_mode;
static gchar* iagno_level;
static gboolean iagno_print_logs;
static gboolean iagno_random_start;
static gboolean iagno_reverse_game;
static gint iagno_size;
static gboolean iagno_usual_start;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_print_logs = FALSE;
static gboolean iagno_alternative_start = FALSE;
static gboolean iagno_random_start = FALSE;
static gboolean iagno_usual_start = FALSE;
static gboolean iagno_classic_game = FALSE;
static gboolean iagno_reverse_game = FALSE;
static gchar* iagno_level = NULL;
static gint iagno_size = 8;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean iagno_two_players;
static gboolean iagno_two_players = FALSE;
static gboolean* iagno_play_first;
static gboolean* iagno_play_first = NULL;
static BaseApplicationIface * iagno_base_application_parent_iface = NULL;

VALA_EXTERN GType base_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseApplication, g_object_unref)
VALA_EXTERN GType iagno_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Iagno, g_object_unref)
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType reversi_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReversiView, g_object_unref)
VALA_EXTERN GType new_game_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameScreen, g_object_unref)
VALA_EXTERN GType history_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryButton, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
VALA_EXTERN GType computer_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerPlayer, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType night_light_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightLightMonitor, g_object_unref)
static GType iagno_sound_context_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType iagno_sound_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void iagno_change_alternate_who_starts (Iagno* self,
                                        GSimpleAction* action,
                                        GVariant* gvariant);
static void _iagno_change_alternate_who_starts_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self);
static void iagno_change_game_type (Iagno* self,
                             GSimpleAction* action,
                             GVariant* gvariant);
static void _iagno_change_game_type_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void iagno_change_level_cb (Iagno* self,
                            GSimpleAction* action,
                            GVariant* gvariant);
static void _iagno_change_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void iagno_set_use_night_mode (Iagno* self,
                               GSimpleAction* action,
                               GVariant* gvariant);
static void _iagno_set_use_night_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN ThemeManager* theme_manager_new (void);
VALA_EXTERN ThemeManager* theme_manager_construct (GType object_type);
static gint iagno_main (gchar** args,
                 gint args_length1);
static Iagno* iagno_new (void);
static Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base,
                                      GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static void iagno_create_window (Iagno* self);
VALA_EXTERN ReversiView* reversi_view_new (Iagno* iagno_instance,
                               ThemeManager* theme_manager);
VALA_EXTERN ReversiView* reversi_view_construct (GType object_type,
                                     Iagno* iagno_instance,
                                     ThemeManager* theme_manager);
static void iagno_player_move_cb (Iagno* self,
                           guint8 x,
                           guint8 y);
static void _iagno_player_move_cb_reversi_view_move (ReversiView* _sender,
                                              guint8 x,
                                              guint8 y,
                                              gpointer self);
static void iagno_clear_impossible_to_move_here_warning (Iagno* self);
static void _iagno_clear_impossible_to_move_here_warning_reversi_view_clear_impossible_to_move_here_warning (ReversiView* _sender,
                                                                                                      gpointer self);
VALA_EXTERN NewGameScreen* new_game_screen_new (const gchar* modelbutton_one_label,
                                    const gchar* modelbutton_one_action,
                                    const gchar* modelbutton_two_label,
                                    const gchar* modelbutton_two_action);
VALA_EXTERN NewGameScreen* new_game_screen_construct (GType object_type,
                                          const gchar* modelbutton_one_label,
                                          const gchar* modelbutton_one_action,
                                          const gchar* modelbutton_two_label,
                                          const gchar* modelbutton_two_action);
VALA_EXTERN GType new_game_screen_menu_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void new_game_screen_update_menubutton_menu (NewGameScreen* self,
                                             NewGameScreenMenuButton button,
                                             GMenu* menu);
static void iagno_init_sound (Iagno* self);
VALA_EXTERN void theme_manager_set_theme (ThemeManager* self,
                              const gchar* value);
VALA_EXTERN HistoryButton* history_button_new (GMenu* menu,
                                   ThemeManager* theme_manager);
VALA_EXTERN HistoryButton* history_button_construct (GType object_type,
                                         GMenu* menu,
                                         ThemeManager* theme_manager);
static void __lambda24_ (Iagno* self,
                  gboolean undoing);
VALA_EXTERN void history_button_update_menu (HistoryButton* self,
                                 GMenu* menu);
static void ___lambda24__reversi_view_notify_final_animation (ReversiView* _sender,
                                                       gboolean undo,
                                                       gpointer self);
static void iagno_init_night_mode (Iagno* self);
VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             const gchar* about_action_label,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* view_content,
                             GMenu* appearance_menu,
                             GtkWidget* game_widget_1,
                             GtkWidget* game_widget_2,
                             NightLightMonitor* night_light_monitor);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   const gchar* about_action_label,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* view_content,
                                   GMenu* appearance_menu,
                                   GtkWidget* game_widget_1,
                                   GtkWidget* game_widget_2,
                                   NightLightMonitor* night_light_monitor);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender,
                                         gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender,
                                      gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender,
                                      gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender,
                                      gpointer self);
VALA_EXTERN void theme_manager_gtk_theme_changed (ThemeManager* self);
static void _theme_manager_gtk_theme_changed_adaptative_window_gtk_theme_changed (AdaptativeWindow* _sender,
                                                                           gpointer self);
static void __lambda25_ (Iagno* self,
                  GSettings* _settings,
                  const gchar* key_name);
static void ___lambda25__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda26_ (Iagno* self);
static void iagno_update_level_button_state (Iagno* self,
                                      gint level);
static void ___lambda26__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda27_ (Iagno* self);
static void iagno_update_game_type_button_label (Iagno* self,
                                          const gchar* type);
static void ___lambda27__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda28_ (Iagno* self);
static void ___lambda28__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
VALA_EXTERN NightLightMonitor* night_light_monitor_new (const gchar* _schema_path);
VALA_EXTERN NightLightMonitor* night_light_monitor_construct (GType object_type,
                                                  const gchar* _schema_path);
VALA_EXTERN void night_light_monitor_set_use_night_mode (NightLightMonitor* self,
                                             gboolean night_mode_state);
VALA_EXTERN void new_game_screen_update_menubutton_label (NewGameScreen* self,
                                              NewGameScreenMenuButton button,
                                              const gchar* label);
VALA_EXTERN void new_game_screen_update_menubutton_sensitivity (NewGameScreen* self,
                                                    NewGameScreenMenuButton button,
                                                    gboolean new_sensitivity);
static void iagno_update_level_button_label (Iagno* self,
                                      guint8 level);
static void iagno_set_window_title (Iagno* self);
VALA_EXTERN Player game_get_current_color (Game* self);
VALA_EXTERN Player iagno_get_player_one (Iagno* self);
VALA_EXTERN ComputerPlayer* iagno_get_computer (Iagno* self);
VALA_EXTERN gboolean game_get_is_complete (Game* self);
VALA_EXTERN void computer_player_move (ComputerPlayer* self,
                           gdouble delay_seconds);
static void iagno_game_complete (Iagno* self,
                          gboolean play_gameover_sound);
VALA_EXTERN void computer_player_cancel_move (ComputerPlayer* self);
VALA_EXTERN GType opening_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Game* game_new (gboolean _reverse,
                Opening _opening,
                guint8 _size,
                gboolean _print_logs);
VALA_EXTERN Game* game_construct (GType object_type,
                      gboolean _reverse,
                      Opening _opening,
                      guint8 _size,
                      gboolean _print_logs);
static void iagno_turn_ended_cb (Iagno* self,
                          gboolean undoing,
                          gboolean no_draw);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender,
                                           gboolean undoing,
                                           gboolean no_draw,
                                           gpointer self);
VALA_EXTERN void reversi_view_set_game (ReversiView* self,
                            Game* value);
VALA_EXTERN void history_button_set_player (HistoryButton* self,
                                Player player);
static void iagno_set_computer (Iagno* self,
                         ComputerPlayer* value);
VALA_EXTERN ComputerReverseEasy* computer_reverse_easy_new (Game* game);
VALA_EXTERN ComputerReverseEasy* computer_reverse_easy_construct (GType object_type,
                                                      Game* game);
VALA_EXTERN GType computer_reversi_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerReversi, g_object_unref)
VALA_EXTERN GType computer_reverse_easy_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerReverseEasy, g_object_unref)
VALA_EXTERN ComputerReverseHard* computer_reverse_hard_new (Game* game,
                                                guint8 initial_depth,
                                                gboolean fixed_heuristic);
VALA_EXTERN ComputerReverseHard* computer_reverse_hard_construct (GType object_type,
                                                      Game* game,
                                                      guint8 initial_depth,
                                                      gboolean fixed_heuristic);
VALA_EXTERN GType computer_reverse_hard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerReverseHard, g_object_unref)
VALA_EXTERN ComputerReversiEasy* computer_reversi_easy_new (Game* game);
VALA_EXTERN ComputerReversiEasy* computer_reversi_easy_construct (GType object_type,
                                                      Game* game);
VALA_EXTERN GType computer_reversi_easy_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerReversiEasy, g_object_unref)
VALA_EXTERN ComputerReversiHard* computer_reversi_hard_new (Game* game,
                                                guint8 initial_depth,
                                                gboolean fixed_heuristic);
VALA_EXTERN ComputerReversiHard* computer_reversi_hard_construct (GType object_type,
                                                      Game* game,
                                                      guint8 initial_depth,
                                                      gboolean fixed_heuristic);
VALA_EXTERN GType computer_reversi_hard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerReversiHard, g_object_unref)
static void iagno_set_player_one (Iagno* self,
                           Player value);
static void iagno_update_ui (Iagno* self);
VALA_EXTERN guint8 game_get_number_of_moves (Game* self);
VALA_EXTERN void game_window_new_turn_start (GameWindow* self,
                                 gboolean can_undo);
VALA_EXTERN gboolean reversi_view_undo_final_animation (ReversiView* self);
static void iagno_play_sound (Iagno* self,
                       IagnoSound sound);
VALA_EXTERN void game_undo (Game* self,
                guint8 count);
VALA_EXTERN gboolean game_get_current_player_can_move (Game* self);
static void iagno_update_scoreboard (Iagno* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
VALA_EXTERN gboolean game_pass (Game* self);
VALA_EXTERN void base_window_show_notification (BaseWindow* self,
                                    const gchar* notification);
VALA_EXTERN void game_window_finish_game (GameWindow* self);
VALA_EXTERN gboolean game_get_reverse (Game* self);
VALA_EXTERN guint8 game_get_n_light_tiles (Game* self);
VALA_EXTERN guint8 game_get_n_dark_tiles (Game* self);
VALA_EXTERN gboolean game_place_tile (Game* self,
                          guint8 x,
                          guint8 y);
VALA_EXTERN Opening game_get_opening (Game* self);
VALA_EXTERN guint8 game_get_size (Game* self);
VALA_EXTERN void game_window_clear_subtitle (GameWindow* self);
VALA_EXTERN void game_window_update_title (GameWindow* self,
                               const gchar* game_name);
static inline void _iagno_play_sound (IagnoSound sound,
                        GSoundContext* sound_context,
                        ThemeManager* theme_manager);
VALA_EXTERN const gchar* theme_manager_get_sound_flip (ThemeManager* self);
VALA_EXTERN const gchar* theme_manager_get_sound_gameover (ThemeManager* self);
static void iagno_real_copy (BaseApplication* base,
                      const gchar* text);
static void iagno_real_get_about_dialog_infos (BaseApplication* base,
                                        gchar*** artists,
                                        gint* artists_length1,
                                        gchar*** authors,
                                        gint* authors_length1,
                                        gchar** comments,
                                        gchar** copyright,
                                        gchar*** documenters,
                                        gint* documenters_length1,
                                        gchar** logo_icon_name,
                                        gchar** program_name,
                                        gchar** translator_credits,
                                        gchar** version,
                                        gchar** website,
                                        gchar** website_label);
VALA_EXTERN void base_application_copy (BaseApplication* self,
                            const gchar* text);
VALA_EXTERN void base_application_get_about_dialog_infos (BaseApplication* self,
                                              gchar*** artists,
                                              gint* artists_length1,
                                              gchar*** authors,
                                              gint* authors_length1,
                                              gchar** comments,
                                              gchar** copyright,
                                              gchar*** documenters,
                                              gint* documenters_length1,
                                              gchar** logo_icon_name,
                                              gchar** program_name,
                                              gchar** translator_credits,
                                              gchar** version,
                                              gchar** website,
                                              gchar** website_label);
static void iagno_finalize (GObject * obj);
static GType iagno_get_type_once (void);
static void _vala_iagno_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_iagno_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GOptionEntry IAGNO_option_entries[16] = {{"alternative-start", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_alternative_start, N_ ("Start with an alternative position"), NULL}, {"classic", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_classic_game, N_ ("Play Classic Reversi"), NULL}, {"fast-mode", 'f', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_fast_mode, N_ ("Reduce delay before AI moves"), NULL}, {"first", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Play first"), NULL}, {"level", 'l', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING, &iagno_level, N_ ("Set the level of the computer’s AI"), N_ ("LEVEL")}, {"mute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn off the sound"), NULL}, {"print-logs", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &iagno_print_logs, N_ ("Log the game moves"), NULL}, {"random-start", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_random_start, N_ ("Start with a random position"), NULL}, {"reverse", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_reverse_game, N_ ("Play Reverse Reversi"), NULL}, {"second", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Play second"), NULL}, {"size", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &iagno_size, N_ ("Size of the board (debug only)"), N_ ("SIZE")}, {"two-players", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Two-players mode"), NULL}, {"unmute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn on the sound"), NULL}, {"usual-start", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &iagno_usual_start, N_ ("Start with the usual position"), NULL}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {0}};
static const GActionEntry IAGNO_app_actions[5] = {{"alternate-who-starts", NULL, NULL, "false", _iagno_change_alternate_who_starts_gsimple_action_change_state_callback}, {"game-type", _iagno_change_game_type_gsimple_action_activate_callback, "s"}, {"change-level", _iagno_change_level_cb_gsimple_action_activate_callback, "s"}, {"set-use-night-mode", _iagno_set_use_night_mode_gsimple_action_activate_callback, "b"}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static inline gpointer
iagno_get_instance_private (Iagno* self)
{
	return G_STRUCT_MEMBER_P (self, Iagno_private_offset);
}

static GType
iagno_sound_get_type_once (void)
{
	static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
	GType iagno_sound_type_id;
	iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
	return iagno_sound_type_id;
}

static GType
iagno_sound_get_type (void)
{
	static volatile gsize iagno_sound_type_id__once = 0;
	if (g_once_init_enter (&iagno_sound_type_id__once)) {
		GType iagno_sound_type_id;
		iagno_sound_type_id = iagno_sound_get_type_once ();
		g_once_init_leave (&iagno_sound_type_id__once, iagno_sound_type_id);
	}
	return iagno_sound_type_id__once;
}

static GType
iagno_sound_context_state_get_type_once (void)
{
	static const GEnumValue values[] = {{IAGNO_SOUND_CONTEXT_STATE_INITIAL, "IAGNO_SOUND_CONTEXT_STATE_INITIAL", "initial"}, {IAGNO_SOUND_CONTEXT_STATE_WORKING, "IAGNO_SOUND_CONTEXT_STATE_WORKING", "working"}, {IAGNO_SOUND_CONTEXT_STATE_ERRORED, "IAGNO_SOUND_CONTEXT_STATE_ERRORED", "errored"}, {0, NULL, NULL}};
	GType iagno_sound_context_state_type_id;
	iagno_sound_context_state_type_id = g_enum_register_static ("IagnoSoundContextState", values);
	return iagno_sound_context_state_type_id;
}

static GType
iagno_sound_context_state_get_type (void)
{
	static volatile gsize iagno_sound_context_state_type_id__once = 0;
	if (g_once_init_enter (&iagno_sound_context_state_type_id__once)) {
		GType iagno_sound_context_state_type_id;
		iagno_sound_context_state_type_id = iagno_sound_context_state_get_type_once ();
		g_once_init_leave (&iagno_sound_context_state_type_id__once, iagno_sound_context_state_type_id);
	}
	return iagno_sound_context_state_type_id__once;
}

static void
_iagno_change_alternate_who_starts_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self)
{
	iagno_change_alternate_who_starts ((Iagno*) self, action, value);
}

static void
_iagno_change_game_type_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	iagno_change_game_type ((Iagno*) self, action, parameter);
}

static void
_iagno_change_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	iagno_change_level_cb ((Iagno*) self, action, parameter);
}

static void
_iagno_set_use_night_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	iagno_set_use_night_mode ((Iagno*) self, action, parameter);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static gint
iagno_main (gchar** args,
            gint args_length1)
{
	Iagno* _tmp0_;
	Iagno* _tmp1_;
	gint _tmp2_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (IAGNO_PROGRAM_NAME);
	g_set_prgname ("org.gnome.Reversi");
	gtk_window_set_default_icon_name ("org.gnome.Reversi");
	_tmp0_ = iagno_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return iagno_main (argv, argc);
}

static Iagno*
iagno_construct (GType object_type)
{
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.Reversi", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
	return self;
}

static Iagno*
iagno_new (void)
{
	return iagno_construct (TYPE_IAGNO);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint
iagno_real_handle_local_options (GApplication* base,
                                 GVariantDict* options)
{
	Iagno * self;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint result;
	self = (Iagno*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "iagno", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (iagno_usual_start) {
		_tmp3_ = iagno_random_start;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (iagno_random_start) {
			_tmp4_ = iagno_alternative_start;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (iagno_alternative_start) {
			_tmp5_ = iagno_usual_start;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		FILE* _tmp6_;
		_tmp6_ = stderr;
		fprintf (_tmp6_, "%s\n", _ ("The “--alternative-start”, “--random-start” and “--usual-start” argume" \
"nts are mutually exclusive."));
		result = EXIT_FAILURE;
		return result;
	}
	if (iagno_classic_game) {
		_tmp7_ = iagno_reverse_game;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		FILE* _tmp8_;
		_tmp8_ = stderr;
		fprintf (_tmp8_, "%s\n", _ ("The “--classic” and “--reverse” arguments are mutually exclusive."));
		result = EXIT_FAILURE;
		return result;
	}
	if (iagno_size < 4) {
		FILE* _tmp9_;
		_tmp9_ = stderr;
		fprintf (_tmp9_, "%s\n", _ ("Size must be at least 4."));
		result = EXIT_FAILURE;
		return result;
	}
	if (iagno_size > 16) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "%s\n", _ ("Size must not be more than 16."));
		result = EXIT_FAILURE;
		return result;
	}
	if (g_variant_dict_contains (options, "mute")) {
		gboolean _tmp11_;
		gboolean* _tmp12_;
		_tmp11_ = FALSE;
		_tmp12_ = __bool_dup0 (&_tmp11_);
		_g_free0 (iagno_sound);
		iagno_sound = _tmp12_;
	} else {
		if (g_variant_dict_contains (options, "unmute")) {
			gboolean _tmp13_;
			gboolean* _tmp14_;
			_tmp13_ = TRUE;
			_tmp14_ = __bool_dup0 (&_tmp13_);
			_g_free0 (iagno_sound);
			iagno_sound = _tmp14_;
		}
	}
	if (g_variant_dict_contains (options, "two-players")) {
		iagno_two_players = TRUE;
	} else {
		if (g_variant_dict_contains (options, "first")) {
			gboolean _tmp15_;
			gboolean* _tmp16_;
			_tmp15_ = TRUE;
			_tmp16_ = __bool_dup0 (&_tmp15_);
			_g_free0 (iagno_play_first);
			iagno_play_first = _tmp16_;
		} else {
			if (g_variant_dict_contains (options, "second")) {
				gboolean _tmp17_;
				gboolean* _tmp18_;
				_tmp17_ = FALSE;
				_tmp18_ = __bool_dup0 (&_tmp17_);
				_g_free0 (iagno_play_first);
				iagno_play_first = _tmp18_;
			}
		}
	}
	result = -1;
	return result;
}

static void
iagno_real_startup (GApplication* base)
{
	Iagno * self;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GSettings* _tmp20_;
	GAction* _tmp21_;
	GAction* _tmp22_;
	GSettings* _tmp23_;
	GAction* _tmp24_;
	GAction* _tmp25_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GSettings* _tmp31_;
	GAction* _tmp32_;
	GAction* _tmp33_;
	GSettings* _tmp34_;
	GAction* _tmp35_;
	GAction* _tmp36_;
	GSettings* _tmp37_;
	GAction* _tmp38_;
	GAction* _tmp39_;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.Reversi");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, (gint) G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp1_ = g_strdup ("<Primary>n");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.new-game", _tmp3_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = g_strdup ("<Shift><Primary>n");
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.start-game", _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = g_strdup ("<Primary>q");
	_tmp8_ = g_strdup ("<Shift><Primary>q");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = g_strdup ("<Primary>z");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.undo", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = g_strdup ("Escape");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.escape", _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = g_strdup ("F10");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.toggle-hamburger", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_create_action (_tmp20_, "highlight-playable-tiles");
	_tmp22_ = _tmp21_;
	g_action_map_add_action ((GActionMap*) self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_create_action (_tmp23_, "highlight-turnable-tiles");
	_tmp25_ = _tmp24_;
	g_action_map_add_action ((GActionMap*) self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	if (!iagno_alternative_start) {
		_tmp27_ = !iagno_random_start;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		_tmp26_ = !iagno_usual_start;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GSettings* _tmp28_;
		GAction* _tmp29_;
		GAction* _tmp30_;
		_tmp28_ = self->priv->settings;
		_tmp29_ = g_settings_create_action (_tmp28_, "random-start-position");
		_tmp30_ = _tmp29_;
		g_action_map_add_action ((GActionMap*) self, _tmp30_);
		_g_object_unref0 (_tmp30_);
	}
	_tmp31_ = self->priv->settings;
	_tmp32_ = g_settings_create_action (_tmp31_, "sound");
	_tmp33_ = _tmp32_;
	g_action_map_add_action ((GActionMap*) self, _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = self->priv->settings;
	_tmp35_ = g_settings_create_action (_tmp34_, "theme");
	_tmp36_ = _tmp35_;
	g_action_map_add_action ((GActionMap*) self, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = g_settings_create_action (_tmp37_, "type");
	_tmp39_ = _tmp38_;
	g_action_map_add_action ((GActionMap*) self, _tmp39_);
	_g_object_unref0 (_tmp39_);
}

static void
_iagno_player_move_cb_reversi_view_move (ReversiView* _sender,
                                         guint8 x,
                                         guint8 y,
                                         gpointer self)
{
	iagno_player_move_cb ((Iagno*) self, x, y);
}

static void
_iagno_clear_impossible_to_move_here_warning_reversi_view_clear_impossible_to_move_here_warning (ReversiView* _sender,
                                                                                                 gpointer self)
{
	iagno_clear_impossible_to_move_here_warning ((Iagno*) self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda24_ (Iagno* self,
             gboolean undoing)
{
	GMenu* _tmp0_ = NULL;
	HistoryButton* _tmp3_;
	GMenu* _tmp4_ = NULL;
	HistoryButton* _tmp7_;
	if (undoing) {
		GMenu* _tmp1_;
		_tmp1_ = self->priv->history_menu;
		_tmp0_ = _tmp1_;
	} else {
		GMenu* _tmp2_;
		_tmp2_ = self->priv->finish_menu;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = self->priv->history_button_1;
	history_button_update_menu (_tmp3_, _tmp0_);
	if (undoing) {
		GMenu* _tmp5_;
		_tmp5_ = self->priv->history_menu;
		_tmp4_ = _tmp5_;
	} else {
		GMenu* _tmp6_;
		_tmp6_ = self->priv->finish_menu;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = self->priv->history_button_2;
	history_button_update_menu (_tmp7_, _tmp4_);
}

static void
___lambda24__reversi_view_notify_final_animation (ReversiView* _sender,
                                                  gboolean undo,
                                                  gpointer self)
{
	__lambda24_ ((Iagno*) self, undo);
}

static void
_iagno_start_game_game_window_play (GameWindow* _sender,
                                    gpointer self)
{
	iagno_start_game ((Iagno*) self);
}

static void
_iagno_wait_cb_game_window_wait (GameWindow* _sender,
                                 gpointer self)
{
	iagno_wait_cb ((Iagno*) self);
}

static void
_iagno_back_cb_game_window_back (GameWindow* _sender,
                                 gpointer self)
{
	iagno_back_cb ((Iagno*) self);
}

static void
_iagno_undo_cb_game_window_undo (GameWindow* _sender,
                                 gpointer self)
{
	iagno_undo_cb ((Iagno*) self);
}

static void
_theme_manager_gtk_theme_changed_adaptative_window_gtk_theme_changed (AdaptativeWindow* _sender,
                                                                      gpointer self)
{
	theme_manager_gtk_theme_changed ((ThemeManager*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda25_ (Iagno* self,
             GSettings* _settings,
             const gchar* key_name)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (key_name != NULL);
	_tmp0_ = self->priv->alternate_who_starts_action;
	_tmp1_ = g_settings_get_value (_settings, key_name);
	_tmp2_ = _tmp1_;
	g_simple_action_set_state (_tmp0_, _tmp2_);
	_g_variant_unref0 (_tmp2_);
}

static void
___lambda25__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda25_ ((Iagno*) self, _sender, key);
}

static void
__lambda26_ (Iagno* self)
{
	if (self->priv->level_changed) {
		self->priv->level_changed = FALSE;
	} else {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->settings;
		if (g_settings_get_int (_tmp0_, "num-players") == 1) {
			GSettings* _tmp1_;
			_tmp1_ = self->priv->settings;
			iagno_update_level_button_state (self, g_settings_get_int (_tmp1_, "computer-level"));
		}
	}
}

static void
___lambda26__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda26_ ((Iagno*) self);
}

static void
__lambda27_ (Iagno* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	if (self->priv->game_type_changed_1) {
		self->priv->game_type_changed_1 = FALSE;
		return;
	}
	_tmp0_ = self->priv->settings;
	if (g_settings_get_int (_tmp0_, "num-players") == 2) {
		return;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "color");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "dark") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		iagno_update_game_type_button_label (self, "dark");
	} else {
		iagno_update_game_type_button_label (self, "light");
	}
}

static void
___lambda27__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda27_ ((Iagno*) self);
}

static void
__lambda28_ (Iagno* self)
{
	GSettings* _tmp0_;
	if (self->priv->game_type_changed_2) {
		self->priv->game_type_changed_2 = FALSE;
		return;
	}
	_tmp0_ = self->priv->settings;
	if (g_settings_get_int (_tmp0_, "num-players") == 2) {
		iagno_update_level_button_state (self, 0);
		iagno_update_game_type_button_label (self, "two");
	} else {
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->priv->settings;
		iagno_update_level_button_state (self, g_settings_get_int (_tmp1_, "computer-level"));
		_tmp2_ = self->priv->settings;
		_tmp3_ = g_settings_get_string (_tmp2_, "color");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strcmp0 (_tmp4_, "dark") == 0;
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			iagno_update_game_type_button_label (self, "dark");
		} else {
			iagno_update_game_type_button_label (self, "light");
		}
	}
}

static void
___lambda28__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda28_ ((Iagno*) self);
}

static void
iagno_create_window (Iagno* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean start_now = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean* _tmp6_;
	ThemeManager* _tmp30_;
	ReversiView* _tmp31_;
	ReversiView* _tmp32_;
	ReversiView* _tmp33_;
	GMenu* type_menu = NULL;
	GMenu* _tmp34_;
	GMenu* section = NULL;
	GMenu* _tmp35_;
	GMenu* _tmp36_;
	GMenu* _tmp37_;
	GMenu* _tmp38_;
	GMenu* _tmp39_;
	GMenu* _tmp40_;
	GMenu* _tmp41_;
	GMenu* _tmp42_;
	GMenu* _tmp43_;
	GMenu* _tmp44_;
	GMenu* _tmp45_;
	GMenu* _tmp46_;
	GMenu* _tmp47_;
	GMenu* _tmp48_;
	GMenu* _tmp49_;
	GMenu* _tmp50_;
	GMenu* _tmp51_;
	GMenu* level_menu = NULL;
	GMenu* _tmp52_;
	GMenu* _tmp53_;
	GMenu* _tmp54_;
	GMenu* _tmp55_;
	GMenu* _tmp56_;
	GMenu* _tmp57_;
	GMenu* _tmp58_;
	GMenu* _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GMenu* _tmp67_;
	NewGameScreen* _tmp68_;
	NewGameScreen* _tmp69_;
	GMenu* _tmp70_;
	NewGameScreen* _tmp71_;
	GMenu* _tmp72_;
	GSettings* _tmp73_;
	GMenu* appearance_menu = NULL;
	GMenu* _tmp74_;
	GMenu* _tmp75_;
	GMenu* _tmp76_;
	GDir* dir = NULL;
	gchar* wanted_theme_id = NULL;
	GSettings* _tmp77_;
	gchar* _tmp78_;
	gboolean theme_name_found = FALSE;
	gboolean _tmp113_ = FALSE;
	GMenu* _tmp121_;
	GMenu* _tmp122_;
	GMenu* _tmp123_;
	GMenu* _tmp124_;
	GMenu* _tmp125_;
	GMenu* _tmp126_;
	GMenu* _tmp127_;
	GMenu* _tmp128_;
	GMenu* _tmp129_;
	GMenu* _tmp130_;
	GMenu* _tmp131_;
	GMenu* _tmp132_;
	GMenu* _tmp133_;
	GMenu* _tmp134_;
	GMenu* _tmp135_;
	GMenu* _tmp136_;
	GMenu* _tmp137_;
	ThemeManager* _tmp138_;
	HistoryButton* _tmp139_;
	GMenu* _tmp140_;
	ThemeManager* _tmp141_;
	HistoryButton* _tmp142_;
	ReversiView* _tmp143_;
	HistoryButton* _tmp144_;
	HistoryButton* _tmp145_;
	NewGameScreen* _tmp146_;
	ReversiView* _tmp147_;
	GMenu* _tmp148_;
	HistoryButton* _tmp149_;
	HistoryButton* _tmp150_;
	NightLightMonitor* _tmp151_;
	GameWindow* _tmp152_;
	GameWindow* _tmp153_;
	GameWindow* _tmp154_;
	GameWindow* _tmp155_;
	GameWindow* _tmp156_;
	GameWindow* _tmp157_;
	ThemeManager* _tmp158_;
	GSettings* _tmp159_;
	ReversiView* _tmp160_;
	GSettings* _tmp161_;
	ReversiView* _tmp162_;
	GSettings* _tmp163_;
	ThemeManager* _tmp164_;
	GAction* _tmp165_;
	GSimpleAction* _tmp166_;
	GAction* _tmp167_;
	GSimpleAction* _tmp168_;
	GSettings* _tmp169_;
	GSimpleAction* _tmp170_;
	GSettings* _tmp171_;
	GVariant* _tmp172_;
	GVariant* _tmp173_;
	GSettings* _tmp174_;
	GSettings* _tmp175_;
	GSettings* _tmp176_;
	GSettings* _tmp177_;
	GameWindow* _tmp184_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (iagno_two_players == TRUE) {
		_tmp0_ = TRUE;
	} else {
		gboolean* _tmp1_;
		_tmp1_ = iagno_play_first;
		_tmp0_ = _tmp1_ != NULL;
	}
	start_now = _tmp0_;
	_tmp6_ = iagno_sound;
	if (_tmp6_ != NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = start_now;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = iagno_level;
		_tmp4_ = _tmp7_ != NULL;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = iagno_classic_game;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = iagno_reverse_game;
	}
	if (_tmp2_) {
		GSettings* _tmp8_;
		gboolean* _tmp11_;
		gboolean* _tmp16_;
		const gchar* _tmp20_;
		GSettings* _tmp29_;
		_tmp8_ = self->priv->settings;
		g_settings_delay (_tmp8_);
		if (iagno_classic_game) {
			GSettings* _tmp9_;
			_tmp9_ = self->priv->settings;
			g_settings_set_string (_tmp9_, "type", "classic");
		} else {
			if (iagno_reverse_game) {
				GSettings* _tmp10_;
				_tmp10_ = self->priv->settings;
				g_settings_set_string (_tmp10_, "type", "reverse");
			}
		}
		_tmp11_ = iagno_sound;
		if (_tmp11_ != NULL) {
			GSettings* _tmp12_;
			gboolean* _tmp13_;
			_tmp12_ = self->priv->settings;
			_tmp13_ = iagno_sound;
			g_settings_set_boolean (_tmp12_, "sound", (gboolean) (*_tmp13_));
		}
		if (start_now) {
			gint _tmp14_ = 0;
			GSettings* _tmp15_;
			if (iagno_two_players) {
				_tmp14_ = 2;
			} else {
				_tmp14_ = 1;
			}
			_tmp15_ = self->priv->settings;
			g_settings_set_int (_tmp15_, "num-players", _tmp14_);
		}
		_tmp16_ = iagno_play_first;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_ = NULL;
			gboolean* _tmp18_;
			GSettings* _tmp19_;
			_tmp18_ = iagno_play_first;
			if ((gboolean) (*_tmp18_)) {
				_tmp17_ = "dark";
			} else {
				_tmp17_ = "light";
			}
			_tmp19_ = self->priv->settings;
			g_settings_set_string (_tmp19_, "color", _tmp17_);
		}
		_tmp20_ = iagno_level;
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			GQuark _tmp24_ = 0U;
			static GQuark _tmp23_label0 = 0;
			static GQuark _tmp23_label1 = 0;
			static GQuark _tmp23_label2 = 0;
			static GQuark _tmp23_label3 = 0;
			static GQuark _tmp23_label4 = 0;
			static GQuark _tmp23_label5 = 0;
			static GQuark _tmp23_label6 = 0;
			static GQuark _tmp23_label7 = 0;
			static GQuark _tmp23_label8 = 0;
			_tmp21_ = iagno_level;
			_tmp22_ = (const gchar*) _tmp21_;
			_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
			if (((_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("1")))) || (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string ("easy"))))) || (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string ("one"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp25_;
						_tmp25_ = self->priv->settings;
						g_settings_set_int (_tmp25_, "computer-level", 1);
						break;
					}
				}
			} else if (((_tmp24_ == ((0 != _tmp23_label3) ? _tmp23_label3 : (_tmp23_label3 = g_quark_from_static_string ("2")))) || (_tmp24_ == ((0 != _tmp23_label4) ? _tmp23_label4 : (_tmp23_label4 = g_quark_from_static_string ("medium"))))) || (_tmp24_ == ((0 != _tmp23_label5) ? _tmp23_label5 : (_tmp23_label5 = g_quark_from_static_string ("two"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp26_;
						_tmp26_ = self->priv->settings;
						g_settings_set_int (_tmp26_, "computer-level", 2);
						break;
					}
				}
			} else if (((_tmp24_ == ((0 != _tmp23_label6) ? _tmp23_label6 : (_tmp23_label6 = g_quark_from_static_string ("3")))) || (_tmp24_ == ((0 != _tmp23_label7) ? _tmp23_label7 : (_tmp23_label7 = g_quark_from_static_string ("hard"))))) || (_tmp24_ == ((0 != _tmp23_label8) ? _tmp23_label8 : (_tmp23_label8 = g_quark_from_static_string ("three"))))) {
				switch (0) {
					default:
					{
						GSettings* _tmp27_;
						_tmp27_ = self->priv->settings;
						g_settings_set_int (_tmp27_, "computer-level", 3);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						FILE* _tmp28_;
						_tmp28_ = stderr;
						fprintf (_tmp28_, "%s\n", _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged."));
						break;
					}
				}
			}
		}
		_tmp29_ = self->priv->settings;
		g_settings_apply (_tmp29_);
	}
	_tmp30_ = self->priv->theme_manager;
	_tmp31_ = reversi_view_new (self, _tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp31_;
	_tmp32_ = self->priv->view;
	g_signal_connect_object (_tmp32_, "move", (GCallback) _iagno_player_move_cb_reversi_view_move, self, 0);
	_tmp33_ = self->priv->view;
	g_signal_connect_object (_tmp33_, "clear-impossible-to-move-here-warning", (GCallback) _iagno_clear_impossible_to_move_here_warning_reversi_view_clear_impossible_to_move_here_warning, self, 0);
	_tmp34_ = g_menu_new ();
	type_menu = _tmp34_;
	_tmp35_ = g_menu_new ();
	section = _tmp35_;
	_tmp36_ = section;
	g_menu_append (_tmp36_, _ ("Play _first (Dark)"), "app.game-type('dark')");
	_tmp37_ = section;
	g_menu_append (_tmp37_, _ ("Play _second (Light)"), "app.game-type('light')");
	_tmp38_ = section;
	g_menu_freeze (_tmp38_);
	_tmp39_ = type_menu;
	_tmp40_ = section;
	g_menu_append_section (_tmp39_, NULL, (GMenuModel*) _tmp40_);
	_tmp41_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp41_;
	_tmp42_ = section;
	g_menu_append (_tmp42_, _ ("_Alternate who starts"), "app.alternate-who-starts");
	_tmp43_ = section;
	g_menu_freeze (_tmp43_);
	_tmp44_ = type_menu;
	_tmp45_ = section;
	g_menu_append_section (_tmp44_, NULL, (GMenuModel*) _tmp45_);
	_tmp46_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp46_;
	_tmp47_ = section;
	g_menu_append (_tmp47_, _ ("_Two players"), "app.game-type('two')");
	_tmp48_ = section;
	g_menu_freeze (_tmp48_);
	_tmp49_ = type_menu;
	_tmp50_ = section;
	g_menu_append_section (_tmp49_, NULL, (GMenuModel*) _tmp50_);
	_tmp51_ = type_menu;
	g_menu_freeze (_tmp51_);
	_tmp52_ = g_menu_new ();
	level_menu = _tmp52_;
	_tmp53_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp53_;
	_tmp54_ = level_menu;
	g_menu_append (_tmp54_, _ ("_Easy"), "app.change-level('1')");
	_tmp55_ = level_menu;
	g_menu_append (_tmp55_, _ ("_Medium"), "app.change-level('2')");
	_tmp56_ = level_menu;
	g_menu_append (_tmp56_, _ ("_Hard"), "app.change-level('3')");
	_tmp57_ = section;
	g_menu_freeze (_tmp57_);
	_tmp58_ = level_menu;
	_tmp59_ = section;
	g_menu_append_section (_tmp58_, NULL, (GMenuModel*) _tmp59_);
	if (!iagno_alternative_start) {
		_tmp61_ = !iagno_random_start;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		_tmp60_ = !iagno_usual_start;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		GMenu* _tmp62_;
		GMenu* _tmp63_;
		GMenu* _tmp64_;
		GMenu* _tmp65_;
		GMenu* _tmp66_;
		_tmp62_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp62_;
		_tmp63_ = section;
		g_menu_append (_tmp63_, _ ("_Vary start position"), "app.random-start-position");
		_tmp64_ = section;
		g_menu_freeze (_tmp64_);
		_tmp65_ = level_menu;
		_tmp66_ = section;
		g_menu_append_section (_tmp65_, NULL, (GMenuModel*) _tmp66_);
	}
	_tmp67_ = level_menu;
	g_menu_freeze (_tmp67_);
	_tmp68_ = new_game_screen_new (_ ("Classic Reversi"), "app.type('classic')", _ ("Reverse Reversi"), "app.type('reverse')");
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp68_;
	_tmp69_ = self->priv->new_game_screen;
	_tmp70_ = type_menu;
	new_game_screen_update_menubutton_menu (_tmp69_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp70_);
	_tmp71_ = self->priv->new_game_screen;
	_tmp72_ = level_menu;
	new_game_screen_update_menubutton_menu (_tmp71_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp72_);
	_tmp73_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp73_, "sound")) {
		iagno_init_sound (self);
	}
	_tmp74_ = g_menu_new ();
	appearance_menu = _tmp74_;
	_tmp75_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp75_;
	_tmp76_ = section;
	g_menu_append (_tmp76_, _ ("Default"), "app.theme('default')");
	_tmp77_ = self->priv->settings;
	_tmp78_ = g_settings_get_string (_tmp77_, "theme");
	wanted_theme_id = _tmp78_;
	theme_name_found = FALSE;
	{
		GDir* _tmp79_ = NULL;
		gchar* _tmp80_;
		gchar* _tmp81_;
		GDir* _tmp82_;
		GDir* _tmp83_;
		GDir* _tmp84_;
		_tmp80_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_dir_open (_tmp81_, (guint) 0, &_inner_error0_);
		_tmp83_ = _tmp82_;
		_g_free0 (_tmp81_);
		_tmp79_ = _tmp83_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (wanted_theme_id);
			_g_dir_close0 (dir);
			_g_object_unref0 (appearance_menu);
			_g_object_unref0 (level_menu);
			_g_object_unref0 (section);
			_g_object_unref0 (type_menu);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp84_ = _tmp79_;
		_tmp79_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp84_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* path = NULL;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			GKeyFile* key = NULL;
			GKeyFile* _tmp92_;
			gchar* theme_name = NULL;
			GMenu* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			const gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			const gchar* _tmp107_;
			const gchar* _tmp108_;
			_tmp85_ = dir;
			_tmp86_ = g_dir_read_name (_tmp85_);
			_tmp87_ = g_strdup (_tmp86_);
			filename = _tmp87_;
			_tmp88_ = filename;
			if (_tmp88_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp89_ = filename;
			if (g_strcmp0 (_tmp89_, "default") == 0) {
				g_warning ("iagno.vala:374: There should not be a theme filename named \"default\"" \
", ignoring it.");
				_g_free0 (filename);
				continue;
			}
			_tmp90_ = filename;
			_tmp91_ = g_build_filename (DATA_DIRECTORY, "themes", "key", (const gchar*) _tmp90_, NULL);
			path = _tmp91_;
			_tmp92_ = g_key_file_new ();
			key = _tmp92_;
			{
				GKeyFile* _tmp93_;
				const gchar* _tmp94_;
				gchar* _tmp95_ = NULL;
				GKeyFile* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				_tmp93_ = key;
				_tmp94_ = path;
				g_key_file_load_from_file (_tmp93_, _tmp94_, G_KEY_FILE_NONE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					goto __finally1;
				}
				_tmp96_ = key;
				_tmp97_ = g_key_file_get_locale_string (_tmp96_, "Theme", "Name", NULL, &_inner_error0_);
				_tmp95_ = _tmp97_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					_g_free0 (theme_name);
					_g_key_file_unref0 (key);
					_g_free0 (path);
					_g_free0 (filename);
					_g_dir_close0 (_tmp79_);
					_g_free0 (wanted_theme_id);
					_g_dir_close0 (dir);
					_g_object_unref0 (appearance_menu);
					_g_object_unref0 (level_menu);
					_g_object_unref0 (section);
					_g_object_unref0 (type_menu);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp98_ = _tmp95_;
				_tmp95_ = NULL;
				_g_free0 (theme_name);
				theme_name = _tmp98_;
				_g_free0 (_tmp95_);
			}
			goto __finally1;
			__catch1_g_key_file_error:
			{
				GError* e = NULL;
				GError* _tmp99_;
				const gchar* _tmp100_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp99_ = e;
				_tmp100_ = _tmp99_->message;
				g_warning ("iagno.vala:388: oops: %s", _tmp100_);
				_g_error_free0 (e);
				_g_free0 (theme_name);
				_g_key_file_unref0 (key);
				_g_free0 (path);
				_g_free0 (filename);
				continue;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (theme_name);
				_g_key_file_unref0 (key);
				_g_free0 (path);
				_g_free0 (filename);
				_g_dir_close0 (_tmp79_);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (wanted_theme_id);
				_g_dir_close0 (dir);
				_g_object_unref0 (appearance_menu);
				_g_object_unref0 (level_menu);
				_g_object_unref0 (section);
				_g_object_unref0 (type_menu);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp101_ = section;
			_tmp102_ = theme_name;
			_tmp103_ = filename;
			_tmp104_ = string_to_string ((const gchar*) _tmp103_);
			_tmp105_ = g_strconcat ("app.theme('", _tmp104_, "')", NULL);
			_tmp106_ = _tmp105_;
			g_menu_append (_tmp101_, _tmp102_, _tmp106_);
			_g_free0 (_tmp106_);
			_tmp107_ = wanted_theme_id;
			_tmp108_ = filename;
			if (g_strcmp0 (_tmp107_, (const gchar*) _tmp108_) == 0) {
				ThemeManager* _tmp109_;
				const gchar* _tmp110_;
				theme_name_found = TRUE;
				_tmp109_ = self->priv->theme_manager;
				_tmp110_ = wanted_theme_id;
				theme_manager_set_theme (_tmp109_, _tmp110_);
			}
			_g_free0 (theme_name);
			_g_key_file_unref0 (key);
			_g_free0 (path);
			_g_free0 (filename);
		}
		_g_dir_close0 (_tmp79_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp111_;
		const gchar* _tmp112_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp111_ = e;
		_tmp112_ = _tmp111_->message;
		g_warning ("iagno.vala:402: Failed to load themes: %s", _tmp112_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (wanted_theme_id);
		_g_dir_close0 (dir);
		_g_object_unref0 (appearance_menu);
		_g_object_unref0 (level_menu);
		_g_object_unref0 (section);
		_g_object_unref0 (type_menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (!theme_name_found) {
		const gchar* _tmp114_;
		_tmp114_ = wanted_theme_id;
		_tmp113_ = g_strcmp0 (_tmp114_, "default") != 0;
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		const gchar* _tmp115_;
		const gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		GSettings* _tmp119_;
		gchar* _tmp120_;
		_tmp115_ = wanted_theme_id;
		_tmp116_ = string_to_string (_tmp115_);
		_tmp117_ = g_strconcat ("Theme ", _tmp116_, " not found, using default.", NULL);
		_tmp118_ = _tmp117_;
		g_warning ("iagno.vala:406: %s", _tmp118_);
		_g_free0 (_tmp118_);
		_tmp119_ = self->priv->settings;
		g_settings_set_string (_tmp119_, "theme", "default");
		_tmp120_ = g_strdup ("default");
		_g_free0 (wanted_theme_id);
		wanted_theme_id = _tmp120_;
	}
	_tmp121_ = section;
	g_menu_freeze (_tmp121_);
	_tmp122_ = appearance_menu;
	_tmp123_ = section;
	g_menu_append_section (_tmp122_, NULL, (GMenuModel*) _tmp123_);
	_tmp124_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp124_;
	_tmp125_ = section;
	g_menu_append (_tmp125_, _ ("Pla_yable tiles"), "app.highlight-playable-tiles");
	_tmp126_ = section;
	g_menu_append (_tmp126_, _ ("_Capturable tiles"), "app.highlight-turnable-tiles");
	_tmp127_ = section;
	g_menu_freeze (_tmp127_);
	_tmp128_ = appearance_menu;
	_tmp129_ = section;
	g_menu_append_section (_tmp128_, _ ("Highlights"), (GMenuModel*) _tmp129_);
	_tmp130_ = appearance_menu;
	g_menu_freeze (_tmp130_);
	_tmp131_ = g_menu_new ();
	_g_object_unref0 (self->priv->history_menu);
	self->priv->history_menu = _tmp131_;
	_tmp132_ = self->priv->history_menu;
	g_menu_append (_tmp132_, _ ("_Undo last move"), "ui.undo");
	_tmp133_ = self->priv->history_menu;
	g_menu_freeze (_tmp133_);
	_tmp134_ = g_menu_new ();
	_g_object_unref0 (self->priv->finish_menu);
	self->priv->finish_menu = _tmp134_;
	_tmp135_ = self->priv->finish_menu;
	g_menu_append (_tmp135_, _ ("_Show final board"), "ui.undo");
	_tmp136_ = self->priv->finish_menu;
	g_menu_freeze (_tmp136_);
	_tmp137_ = self->priv->history_menu;
	_tmp138_ = self->priv->theme_manager;
	_tmp139_ = history_button_new (_tmp137_, _tmp138_);
	g_object_ref_sink (_tmp139_);
	_g_object_unref0 (self->priv->history_button_1);
	self->priv->history_button_1 = _tmp139_;
	_tmp140_ = self->priv->history_menu;
	_tmp141_ = self->priv->theme_manager;
	_tmp142_ = history_button_new (_tmp140_, _tmp141_);
	g_object_ref_sink (_tmp142_);
	_g_object_unref0 (self->priv->history_button_2);
	self->priv->history_button_2 = _tmp142_;
	_tmp143_ = self->priv->view;
	g_signal_connect_object (_tmp143_, "notify-final-animation", (GCallback) ___lambda24__reversi_view_notify_final_animation, self, 0);
	_tmp144_ = self->priv->history_button_1;
	gtk_widget_show ((GtkWidget*) _tmp144_);
	_tmp145_ = self->priv->history_button_2;
	gtk_widget_show ((GtkWidget*) _tmp145_);
	iagno_init_night_mode (self);
	_tmp146_ = self->priv->new_game_screen;
	_tmp147_ = self->priv->view;
	_tmp148_ = appearance_menu;
	_tmp149_ = self->priv->history_button_1;
	_tmp150_ = self->priv->history_button_2;
	_tmp151_ = self->priv->night_light_monitor;
	_tmp152_ = game_window_new ("/org/gnome/Reversi/ui/iagno.css", IAGNO_PROGRAM_NAME, _ ("_About Reversi"), start_now, ((GAME_WINDOW_FLAGS_SHOW_START_BUTTON | GAME_WINDOW_FLAGS_HAS_SOUND) | GAME_WINDOW_FLAGS_SHORTCUTS) | GAME_WINDOW_FLAGS_SHOW_HELP, G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp147_, _tmp148_, (GtkWidget*) _tmp149_, (GtkWidget*) _tmp150_, _tmp151_);
	g_object_ref_sink (_tmp152_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp152_;
	_tmp153_ = self->priv->window;
	g_signal_connect_object (_tmp153_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
	_tmp154_ = self->priv->window;
	g_signal_connect_object (_tmp154_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
	_tmp155_ = self->priv->window;
	g_signal_connect_object (_tmp155_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
	_tmp156_ = self->priv->window;
	g_signal_connect_object (_tmp156_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
	_tmp157_ = self->priv->window;
	_tmp158_ = self->priv->theme_manager;
	g_signal_connect_object ((AdaptativeWindow*) _tmp157_, "gtk-theme-changed", (GCallback) _theme_manager_gtk_theme_changed_adaptative_window_gtk_theme_changed, _tmp158_, 0);
	_tmp159_ = self->priv->settings;
	_tmp160_ = self->priv->view;
	g_settings_bind (_tmp159_, "highlight-playable-tiles", (GObject*) _tmp160_, "show-playable-tiles", G_SETTINGS_BIND_GET);
	_tmp161_ = self->priv->settings;
	_tmp162_ = self->priv->view;
	g_settings_bind (_tmp161_, "highlight-turnable-tiles", (GObject*) _tmp162_, "show-turnable-tiles", G_SETTINGS_BIND_GET);
	_tmp163_ = self->priv->settings;
	_tmp164_ = self->priv->theme_manager;
	g_settings_bind (_tmp163_, "theme", (GObject*) _tmp164_, "theme", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp165_ = g_action_map_lookup_action ((GActionMap*) self, "alternate-who-starts");
	_tmp166_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->alternate_who_starts_action);
	self->priv->alternate_who_starts_action = _tmp166_;
	_tmp167_ = g_action_map_lookup_action ((GActionMap*) self, "change-level");
	_tmp168_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp167_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->change_level_action);
	self->priv->change_level_action = _tmp168_;
	_tmp169_ = self->priv->settings;
	g_signal_connect_object (_tmp169_, "changed::alternate-who-starts", (GCallback) ___lambda25__g_settings_changed, self, 0);
	_tmp170_ = self->priv->alternate_who_starts_action;
	_tmp171_ = self->priv->settings;
	_tmp172_ = g_settings_get_value (_tmp171_, "alternate-who-starts");
	_tmp173_ = _tmp172_;
	g_simple_action_set_state (_tmp170_, _tmp173_);
	_g_variant_unref0 (_tmp173_);
	_tmp174_ = self->priv->settings;
	g_signal_connect_object (_tmp174_, "changed::computer-level", (GCallback) ___lambda26__g_settings_changed, self, 0);
	_tmp175_ = self->priv->settings;
	g_signal_connect_object (_tmp175_, "changed::color", (GCallback) ___lambda27__g_settings_changed, self, 0);
	_tmp176_ = self->priv->settings;
	g_signal_connect_object (_tmp176_, "changed::num-players", (GCallback) ___lambda28__g_settings_changed, self, 0);
	_tmp177_ = self->priv->settings;
	if (g_settings_get_int (_tmp177_, "num-players") == 2) {
		GSimpleAction* _tmp178_;
		iagno_update_level_button_state (self, 0);
		iagno_update_game_type_button_label (self, "two");
		_tmp178_ = self->priv->alternate_who_starts_action;
		g_simple_action_set_enabled (_tmp178_, FALSE);
	} else {
		GSettings* _tmp179_;
		GSettings* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gboolean _tmp183_;
		_tmp179_ = self->priv->settings;
		iagno_update_level_button_state (self, g_settings_get_int (_tmp179_, "computer-level"));
		_tmp180_ = self->priv->settings;
		_tmp181_ = g_settings_get_string (_tmp180_, "color");
		_tmp182_ = _tmp181_;
		_tmp183_ = g_strcmp0 (_tmp182_, "dark") == 0;
		_g_free0 (_tmp182_);
		if (_tmp183_) {
			iagno_update_game_type_button_label (self, "dark");
		} else {
			iagno_update_game_type_button_label (self, "light");
		}
	}
	if (start_now) {
		iagno_start_game (self);
	}
	_tmp184_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp184_);
	_g_free0 (wanted_theme_id);
	_g_dir_close0 (dir);
	_g_object_unref0 (appearance_menu);
	_g_object_unref0 (level_menu);
	_g_object_unref0 (section);
	_g_object_unref0 (type_menu);
}

static void
iagno_real_activate (GApplication* base)
{
	Iagno * self;
	GtkWindow* _tmp0_;
	GameWindow* _tmp1_;
	self = (Iagno*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		iagno_create_window (self);
	}
	_tmp1_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static void
iagno_real_shutdown (GApplication* base)
{
	Iagno * self;
	GtkWindow* _tmp0_;
	self = (Iagno*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		GameWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
iagno_init_night_mode (Iagno* self)
{
	NightLightMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = night_light_monitor_new ("/org/gnome/iagno/");
	_g_object_unref0 (self->priv->night_light_monitor);
	self->priv->night_light_monitor = _tmp0_;
}

static void
iagno_set_use_night_mode (Iagno* self,
                          GSimpleAction* action,
                          GVariant* gvariant)
{
	NightLightMonitor* _tmp0_;
	ThemeManager* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = self->priv->night_light_monitor;
	night_light_monitor_set_use_night_mode (_tmp0_, g_variant_get_boolean ((GVariant*) gvariant));
	_tmp1_ = self->priv->theme_manager;
	theme_manager_gtk_theme_changed (_tmp1_);
}

static void
iagno_change_alternate_who_starts (Iagno* self,
                                   GSimpleAction* action,
                                   GVariant* gvariant)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = self->priv->settings;
	g_settings_set_value (_tmp0_, "alternate-who-starts", (GVariant*) gvariant);
}

static void
iagno_change_game_type (Iagno* self,
                        GSimpleAction* action,
                        GVariant* gvariant)
{
	gchar* type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) gvariant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	iagno_update_game_type_button_label (self, _tmp2_);
	self->priv->game_type_changed_1 = TRUE;
	self->priv->game_type_changed_2 = TRUE;
	_tmp3_ = type;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("two")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp7_;
				GSimpleAction* _tmp8_;
				_tmp7_ = self->priv->settings;
				g_settings_set_int (_tmp7_, "num-players", 2);
				iagno_update_level_button_state (self, 0);
				_tmp8_ = self->priv->alternate_who_starts_action;
				g_simple_action_set_enabled (_tmp8_, FALSE);
				_g_free0 (type);
				return;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("dark")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp9_;
				GSettings* _tmp10_;
				GSettings* _tmp11_;
				GSimpleAction* _tmp12_;
				_tmp9_ = self->priv->settings;
				g_settings_set_int (_tmp9_, "num-players", 1);
				_tmp10_ = self->priv->settings;
				iagno_update_level_button_state (self, g_settings_get_int (_tmp10_, "computer-level"));
				_tmp11_ = self->priv->settings;
				g_settings_set_string (_tmp11_, "color", "dark");
				_tmp12_ = self->priv->alternate_who_starts_action;
				g_simple_action_set_enabled (_tmp12_, TRUE);
				_g_free0 (type);
				return;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("light")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp13_;
				GSettings* _tmp14_;
				GSettings* _tmp15_;
				GSimpleAction* _tmp16_;
				_tmp13_ = self->priv->settings;
				g_settings_set_int (_tmp13_, "num-players", 1);
				_tmp14_ = self->priv->settings;
				iagno_update_level_button_state (self, g_settings_get_int (_tmp14_, "computer-level"));
				_tmp15_ = self->priv->settings;
				g_settings_set_string (_tmp15_, "color", "light");
				_tmp16_ = self->priv->alternate_who_starts_action;
				g_simple_action_set_enabled (_tmp16_, TRUE);
				_g_free0 (type);
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static void
iagno_update_game_type_button_label (Iagno* self,
                                     const gchar* type)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("two")))) {
		switch (0) {
			default:
			{
				NewGameScreen* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = self->priv->new_game_screen;
				_tmp4_ = g_strdup_printf ("%s ▾", _ ("Two players"));
				_tmp5_ = _tmp4_;
				new_game_screen_update_menubutton_label (_tmp3_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp5_);
				_g_free0 (_tmp5_);
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("dark")))) {
		switch (0) {
			default:
			{
				NewGameScreen* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = self->priv->new_game_screen;
				_tmp7_ = g_strdup_printf ("%s ▾", _ ("Color: Dark"));
				_tmp8_ = _tmp7_;
				new_game_screen_update_menubutton_label (_tmp6_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp8_);
				_g_free0 (_tmp8_);
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("light")))) {
		switch (0) {
			default:
			{
				NewGameScreen* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = self->priv->new_game_screen;
				_tmp10_ = g_strdup_printf ("%s ▾", _ ("Color: Light"));
				_tmp11_ = _tmp10_;
				new_game_screen_update_menubutton_label (_tmp9_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp11_);
				_g_free0 (_tmp11_);
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static void
iagno_change_level_cb (Iagno* self,
                       GSimpleAction* action,
                       GVariant* gvariant)
{
	GSettings* _tmp0_;
	gint level = 0;
	const gchar* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = self->priv->settings;
	if (g_settings_get_int (_tmp0_, "num-players") == 2) {
		return;
	}
	self->priv->level_changed = TRUE;
	_tmp1_ = g_variant_get_string ((GVariant*) gvariant, NULL);
	level = atoi (_tmp1_);
	iagno_update_level_button_state (self, level);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "computer-level", level);
}

static void
iagno_update_level_button_state (Iagno* self,
                                 gint level)
{
	g_return_if_fail (self != NULL);
	switch (level) {
		case 0:
		{
			GSimpleAction* _tmp0_;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			_tmp0_ = self->priv->change_level_action;
			g_simple_action_set_enabled (_tmp0_, FALSE);
			if (iagno_alternative_start) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = iagno_random_start;
			}
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = iagno_usual_start;
			}
			if (_tmp1_) {
				NewGameScreen* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->new_game_screen;
				new_game_screen_update_menubutton_sensitivity (_tmp3_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, FALSE);
				_tmp4_ = self->priv->settings;
				iagno_update_level_button_label (self, (guint8) g_settings_get_int (_tmp4_, "computer-level"));
			} else {
				iagno_update_level_button_label (self, (guint8) 0);
			}
			return;
		}
		case 1:
		{
			GSimpleAction* _tmp5_;
			NewGameScreen* _tmp6_;
			_tmp5_ = self->priv->change_level_action;
			g_simple_action_set_enabled (_tmp5_, TRUE);
			_tmp6_ = self->priv->new_game_screen;
			new_game_screen_update_menubutton_sensitivity (_tmp6_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, TRUE);
			iagno_update_level_button_label (self, (guint8) 1);
			return;
		}
		case 2:
		{
			GSimpleAction* _tmp7_;
			NewGameScreen* _tmp8_;
			_tmp7_ = self->priv->change_level_action;
			g_simple_action_set_enabled (_tmp7_, TRUE);
			_tmp8_ = self->priv->new_game_screen;
			new_game_screen_update_menubutton_sensitivity (_tmp8_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, TRUE);
			iagno_update_level_button_label (self, (guint8) 2);
			return;
		}
		case 3:
		{
			GSimpleAction* _tmp9_;
			NewGameScreen* _tmp10_;
			_tmp9_ = self->priv->change_level_action;
			g_simple_action_set_enabled (_tmp9_, TRUE);
			_tmp10_ = self->priv->new_game_screen;
			new_game_screen_update_menubutton_sensitivity (_tmp10_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, TRUE);
			iagno_update_level_button_label (self, (guint8) 3);
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
iagno_update_level_button_label (Iagno* self,
                                 guint8 level)
{
	g_return_if_fail (self != NULL);
	switch (level) {
		case 0:
		{
			NewGameScreen* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp0_ = self->priv->new_game_screen;
			_tmp1_ = g_strdup_printf ("%s ▾", _ ("More options"));
			_tmp2_ = _tmp1_;
			new_game_screen_update_menubutton_label (_tmp0_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp2_);
			_g_free0 (_tmp2_);
			return;
		}
		case 1:
		{
			NewGameScreen* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = self->priv->new_game_screen;
			_tmp4_ = g_strdup_printf ("%s ▾", _ ("Difficulty: Easy"));
			_tmp5_ = _tmp4_;
			new_game_screen_update_menubutton_label (_tmp3_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp5_);
			_g_free0 (_tmp5_);
			return;
		}
		case 2:
		{
			NewGameScreen* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->new_game_screen;
			_tmp7_ = g_strdup_printf ("%s ▾", _ ("Difficulty: Medium"));
			_tmp8_ = _tmp7_;
			new_game_screen_update_menubutton_label (_tmp6_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp8_);
			_g_free0 (_tmp8_);
			return;
		}
		case 3:
		{
			NewGameScreen* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = self->priv->new_game_screen;
			_tmp10_ = g_strdup_printf ("%s ▾", _ ("Difficulty: Hard"));
			_tmp11_ = _tmp10_;
			new_game_screen_update_menubutton_label (_tmp9_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp11_);
			_g_free0 (_tmp11_);
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
iagno_back_cb (Iagno* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	Player _tmp5_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	iagno_set_window_title (self);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->_computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_is_complete (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ComputerPlayer* _tmp10_;
		_tmp10_ = self->priv->_computer;
		computer_player_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_COMPUTER_PLAYER, ComputerPlayer), IAGNO_SLOW_MOVE_DELAY);
	} else {
		Game* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			iagno_game_complete (self, FALSE);
		}
	}
}

static void
iagno_wait_cb (Iagno* self)
{
	ComputerPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_computer;
	if (_tmp0_ != NULL) {
		ComputerPlayer* _tmp1_;
		_tmp1_ = self->priv->_computer;
		computer_player_cancel_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_COMPUTER_PLAYER, ComputerPlayer));
	}
}

static void
_iagno_turn_ended_cb_game_turn_ended (Game* _sender,
                                      gboolean undoing,
                                      gboolean no_draw,
                                      gpointer self)
{
	iagno_turn_ended_cb ((Iagno*) self, undoing, no_draw);
}

static void
iagno_start_game (Iagno* self)
{
	ComputerPlayer* _tmp1_;
	gboolean two_players = FALSE;
	GSettings* _tmp3_;
	gboolean even_board = FALSE;
	gboolean random_start_settings = FALSE;
	GSettings* _tmp4_;
	Opening opening = 0;
	gboolean reverse = FALSE;
	GSettings* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	Game* _tmp14_;
	Game* _tmp15_;
	ReversiView* _tmp16_;
	Game* _tmp17_;
	HistoryButton* _tmp18_;
	HistoryButton* _tmp19_;
	HistoryButton* _tmp20_;
	GMenu* _tmp21_;
	HistoryButton* _tmp22_;
	GMenu* _tmp23_;
	GSettings* _tmp43_;
	gboolean _tmp44_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->game_is_set) {
		Game* _tmp0_;
		_tmp0_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp0_, NULL, self);
	}
	_tmp1_ = self->priv->_computer;
	if (_tmp1_ != NULL) {
		ComputerPlayer* _tmp2_;
		_tmp2_ = self->priv->_computer;
		computer_player_cancel_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_COMPUTER_PLAYER, ComputerPlayer));
	}
	_tmp3_ = self->priv->settings;
	two_players = g_settings_get_int (_tmp3_, "num-players") == 2;
	even_board = (iagno_size % 2) == 0;
	_tmp4_ = self->priv->settings;
	random_start_settings = g_settings_get_boolean (_tmp4_, "random-start-position");
	if (iagno_alternative_start) {
		if (even_board) {
			Opening _tmp5_ = 0;
			if (gtk_get_locale_direction () == GTK_TEXT_DIR_LTR) {
				_tmp5_ = OPENING_ALTER_LEFT;
			} else {
				_tmp5_ = OPENING_ALTER_RIGHT;
			}
			opening = _tmp5_;
		} else {
			Opening _tmp6_ = 0;
			if (gtk_get_locale_direction () == GTK_TEXT_DIR_LTR) {
				_tmp6_ = OPENING_ALTER_RIGHT;
			} else {
				_tmp6_ = OPENING_ALTER_LEFT;
			}
			opening = _tmp6_;
		}
	} else {
		if (iagno_usual_start) {
			opening = OPENING_REVERSI;
		} else {
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			if (two_players) {
				_tmp8_ = random_start_settings;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = !iagno_random_start;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				opening = OPENING_HUMANS;
			} else {
				gboolean _tmp9_ = FALSE;
				if (iagno_random_start) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = random_start_settings;
				}
				if (_tmp9_) {
					switch (g_random_int_range ((gint32) 0, (gint32) 8)) {
						case 0:
						case 1:
						{
							opening = OPENING_REVERSI;
							break;
						}
						case 2:
						case 3:
						{
							opening = OPENING_INVERTED;
							break;
						}
						case 4:
						{
							opening = OPENING_ALTER_TOP;
							break;
						}
						case 5:
						{
							opening = OPENING_ALTER_LEFT;
							break;
						}
						case 6:
						{
							opening = OPENING_ALTER_RIGHT;
							break;
						}
						case 7:
						{
							opening = OPENING_ALTER_BOTTOM;
							break;
						}
						default:
						{
							g_assert_not_reached ();
						}
					}
				} else {
					opening = OPENING_REVERSI;
				}
			}
		}
	}
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_string (_tmp10_, "type");
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strcmp0 (_tmp12_, "reverse") == 0;
	_g_free0 (_tmp12_);
	reverse = _tmp13_;
	_tmp14_ = game_new (reverse, opening, (guint8) iagno_size, iagno_print_logs);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp14_;
	iagno_set_window_title (self);
	self->priv->game_is_set = TRUE;
	_tmp15_ = self->priv->game;
	g_signal_connect_object (_tmp15_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
	_tmp16_ = self->priv->view;
	_tmp17_ = self->priv->game;
	reversi_view_set_game (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->history_button_1;
	history_button_set_player (_tmp18_, PLAYER_DARK);
	_tmp19_ = self->priv->history_button_2;
	history_button_set_player (_tmp19_, PLAYER_DARK);
	_tmp20_ = self->priv->history_button_1;
	_tmp21_ = self->priv->history_menu;
	history_button_update_menu (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->history_button_2;
	_tmp23_ = self->priv->history_menu;
	history_button_update_menu (_tmp22_, _tmp23_);
	if (two_players) {
		iagno_set_computer (self, NULL);
	} else {
		guint8 computer_level = 0U;
		GSettings* _tmp24_;
		_tmp24_ = self->priv->settings;
		computer_level = (guint8) g_settings_get_int (_tmp24_, "computer-level");
		if (reverse) {
			switch (computer_level) {
				case 1:
				{
					Game* _tmp25_;
					ComputerReverseEasy* _tmp26_;
					ComputerReverseEasy* _tmp27_;
					_tmp25_ = self->priv->game;
					_tmp26_ = computer_reverse_easy_new (_tmp25_);
					_tmp27_ = _tmp26_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp27_);
					_g_object_unref0 (_tmp27_);
					break;
				}
				case 2:
				{
					Game* _tmp28_;
					ComputerReverseHard* _tmp29_;
					ComputerReverseHard* _tmp30_;
					_tmp28_ = self->priv->game;
					_tmp29_ = computer_reverse_hard_new (_tmp28_, (guint8) 1, FALSE);
					_tmp30_ = _tmp29_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp30_);
					_g_object_unref0 (_tmp30_);
					break;
				}
				case 3:
				{
					Game* _tmp31_;
					ComputerReverseHard* _tmp32_;
					ComputerReverseHard* _tmp33_;
					_tmp31_ = self->priv->game;
					_tmp32_ = computer_reverse_hard_new (_tmp31_, (guint8) 2, FALSE);
					_tmp33_ = _tmp32_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp33_);
					_g_object_unref0 (_tmp33_);
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
		} else {
			switch (computer_level) {
				case 1:
				{
					Game* _tmp34_;
					ComputerReversiEasy* _tmp35_;
					ComputerReversiEasy* _tmp36_;
					_tmp34_ = self->priv->game;
					_tmp35_ = computer_reversi_easy_new (_tmp34_);
					_tmp36_ = _tmp35_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp36_);
					_g_object_unref0 (_tmp36_);
					break;
				}
				case 2:
				{
					Game* _tmp37_;
					ComputerReversiHard* _tmp38_;
					ComputerReversiHard* _tmp39_;
					_tmp37_ = self->priv->game;
					_tmp38_ = computer_reversi_hard_new (_tmp37_, (guint8) 0, FALSE);
					_tmp39_ = _tmp38_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp39_);
					_g_object_unref0 (_tmp39_);
					break;
				}
				case 3:
				{
					Game* _tmp40_;
					ComputerReversiHard* _tmp41_;
					ComputerReversiHard* _tmp42_;
					_tmp40_ = self->priv->game;
					_tmp41_ = computer_reversi_hard_new (_tmp40_, (guint8) 1, FALSE);
					_tmp42_ = _tmp41_;
					iagno_set_computer (self, (ComputerPlayer*) _tmp42_);
					_g_object_unref0 (_tmp42_);
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp43_ = self->priv->settings;
	if (g_settings_get_enum (_tmp43_, "color") == 1) {
		iagno_set_player_one (self, PLAYER_LIGHT);
	} else {
		iagno_set_player_one (self, PLAYER_DARK);
	}
	if (two_players) {
		_tmp44_ = TRUE;
	} else {
		Player _tmp45_;
		_tmp45_ = self->priv->_player_one;
		_tmp44_ = _tmp45_ == PLAYER_DARK;
	}
	self->priv->first_player_is_human = _tmp44_;
	iagno_update_ui (self);
	if (!two_players) {
		Player _tmp46_;
		_tmp46_ = self->priv->_player_one;
		if (_tmp46_ == PLAYER_DARK) {
			GSettings* _tmp47_;
			_tmp47_ = self->priv->settings;
			if (g_settings_get_boolean (_tmp47_, "alternate-who-starts")) {
				GSettings* _tmp48_;
				_tmp48_ = self->priv->settings;
				g_settings_set_string (_tmp48_, "color", "light");
			}
		} else {
			GSettings* _tmp49_;
			ComputerPlayer* _tmp51_;
			_tmp49_ = self->priv->settings;
			if (g_settings_get_boolean (_tmp49_, "alternate-who-starts")) {
				GSettings* _tmp50_;
				_tmp50_ = self->priv->settings;
				g_settings_set_string (_tmp50_, "color", "dark");
			}
			_tmp51_ = self->priv->_computer;
			computer_player_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_COMPUTER_PLAYER, ComputerPlayer), IAGNO_MODERATE_MOVE_DELAY);
		}
	}
}

static void
iagno_update_ui (Iagno* self)
{
	gboolean _tmp0_ = FALSE;
	GameWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	if (self->priv->first_player_is_human) {
		Game* _tmp1_;
		guint8 _tmp2_;
		guint8 _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = game_get_number_of_moves (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = ((gint) _tmp3_) >= 1;
	} else {
		Game* _tmp4_;
		guint8 _tmp5_;
		guint8 _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = game_get_number_of_moves (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = ((gint) _tmp6_) >= 2;
	}
	_tmp7_ = self->priv->window;
	game_window_new_turn_start (_tmp7_, _tmp0_);
}

static void
iagno_undo_cb (Iagno* self)
{
	ReversiView* _tmp0_;
	ComputerPlayer* _tmp1_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	_tmp0_ = self->priv->view;
	if (reversi_view_undo_final_animation (_tmp0_)) {
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
		return;
	}
	_tmp1_ = self->priv->_computer;
	if (_tmp1_ == NULL) {
		Game* _tmp2_;
		Game* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->game;
		game_undo (_tmp2_, (guint8) 1);
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_current_player_can_move (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!_tmp5_) {
			Game* _tmp6_;
			_tmp6_ = self->priv->game;
			game_undo (_tmp6_, (guint8) 1);
		}
	} else {
		ComputerPlayer* _tmp7_;
		Game* _tmp8_;
		Player _tmp9_;
		Player _tmp10_;
		Player _tmp11_;
		_tmp7_ = self->priv->_computer;
		computer_player_cancel_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_COMPUTER_PLAYER, ComputerPlayer));
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_color (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_player_one;
		if (_tmp10_ != _tmp11_) {
			Game* _tmp12_;
			_tmp12_ = self->priv->game;
			game_undo (_tmp12_, (guint8) 1);
		} else {
			Game* _tmp13_;
			_tmp13_ = self->priv->game;
			game_undo (_tmp13_, (guint8) 2);
		}
		while (TRUE) {
			Game* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			Game* _tmp17_;
			_tmp14_ = self->priv->game;
			_tmp15_ = game_get_current_player_can_move (_tmp14_);
			_tmp16_ = _tmp15_;
			if (!(!_tmp16_)) {
				break;
			}
			_tmp17_ = self->priv->game;
			game_undo (_tmp17_, (guint8) 2);
		}
	}
	iagno_update_ui (self);
	iagno_update_scoreboard (self);
}

static void
iagno_turn_ended_cb (Iagno* self,
                     gboolean undoing,
                     gboolean no_draw)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	if (undoing) {
		_tmp0_ = no_draw;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	iagno_update_ui (self);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_player_can_move (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		iagno_prepare_move (self);
	} else {
		Game* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = game_get_is_complete (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			iagno_game_complete (self, TRUE);
		} else {
			iagno_pass (self);
		}
	}
}

static void
iagno_prepare_move (Iagno* self)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Player _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	iagno_update_scoreboard (self);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_player_one;
	if (_tmp3_ != _tmp4_) {
		ComputerPlayer* _tmp5_;
		_tmp5_ = self->priv->_computer;
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdouble _tmp6_ = 0.0;
		ComputerPlayer* _tmp7_;
		if (iagno_fast_mode) {
			_tmp6_ = IAGNO_QUICK_MOVE_DELAY;
		} else {
			_tmp6_ = IAGNO_SLOW_MOVE_DELAY;
		}
		_tmp7_ = self->priv->_computer;
		computer_player_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_COMPUTER_PLAYER, ComputerPlayer), _tmp6_);
	}
}

static void
iagno_pass (Iagno* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	Player _tmp2_;
	Player _tmp3_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	iagno_update_scoreboard (self);
	_tmp0_ = self->priv->game;
	if (!game_pass (_tmp0_)) {
		g_assert_not_reached ();
	}
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_DARK) {
		GameWindow* _tmp4_;
		_tmp4_ = self->priv->window;
		base_window_show_notification ((BaseWindow*) _tmp4_, _ ("Light must pass, Dark’s move"));
	} else {
		GameWindow* _tmp5_;
		_tmp5_ = self->priv->window;
		base_window_show_notification ((BaseWindow*) _tmp5_, _ ("Dark must pass, Light’s move"));
	}
}

static void
iagno_game_complete (Iagno* self,
                     gboolean play_gameover_sound)
{
	GameWindow* _tmp0_;
	HistoryButton* _tmp1_;
	HistoryButton* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	_tmp0_ = self->priv->window;
	game_window_finish_game (_tmp0_);
	_tmp1_ = self->priv->history_button_1;
	history_button_set_player (_tmp1_, PLAYER_NONE);
	_tmp2_ = self->priv->history_button_2;
	history_button_set_player (_tmp2_, PLAYER_NONE);
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_reverse (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		Game* _tmp8_;
		guint8 _tmp9_;
		guint8 _tmp10_;
		Game* _tmp11_;
		guint8 _tmp12_;
		guint8 _tmp13_;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_n_light_tiles (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_n_dark_tiles (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp4_ = _tmp10_ > _tmp13_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		Game* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = self->priv->game;
		_tmp16_ = game_get_reverse (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			Game* _tmp18_;
			guint8 _tmp19_;
			guint8 _tmp20_;
			Game* _tmp21_;
			guint8 _tmp22_;
			guint8 _tmp23_;
			_tmp18_ = self->priv->game;
			_tmp19_ = game_get_n_light_tiles (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->game;
			_tmp22_ = game_get_n_dark_tiles (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp14_ = _tmp20_ < _tmp23_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp3_ = _tmp14_;
	}
	if (_tmp3_) {
		GameWindow* _tmp24_;
		Game* _tmp25_;
		guint8 _tmp26_;
		guint8 _tmp27_;
		Game* _tmp28_;
		guint8 _tmp29_;
		guint8 _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp24_ = self->priv->window;
		_tmp25_ = self->priv->game;
		_tmp26_ = game_get_n_light_tiles (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->game;
		_tmp29_ = game_get_n_dark_tiles (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup_printf (_ ("Light wins! (%u-%u)"), (guint) _tmp27_, (guint) _tmp30_);
		_tmp32_ = _tmp31_;
		base_window_show_notification ((BaseWindow*) _tmp24_, _tmp32_);
		_g_free0 (_tmp32_);
	} else {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		Game* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp35_ = self->priv->game;
		_tmp36_ = game_get_reverse (_tmp35_);
		_tmp37_ = _tmp36_;
		if (!_tmp37_) {
			Game* _tmp38_;
			guint8 _tmp39_;
			guint8 _tmp40_;
			Game* _tmp41_;
			guint8 _tmp42_;
			guint8 _tmp43_;
			_tmp38_ = self->priv->game;
			_tmp39_ = game_get_n_light_tiles (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = self->priv->game;
			_tmp42_ = game_get_n_dark_tiles (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp34_ = _tmp40_ < _tmp43_;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			_tmp33_ = TRUE;
		} else {
			gboolean _tmp44_ = FALSE;
			Game* _tmp45_;
			gboolean _tmp46_;
			gboolean _tmp47_;
			_tmp45_ = self->priv->game;
			_tmp46_ = game_get_reverse (_tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_) {
				Game* _tmp48_;
				guint8 _tmp49_;
				guint8 _tmp50_;
				Game* _tmp51_;
				guint8 _tmp52_;
				guint8 _tmp53_;
				_tmp48_ = self->priv->game;
				_tmp49_ = game_get_n_light_tiles (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->game;
				_tmp52_ = game_get_n_dark_tiles (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp44_ = _tmp50_ > _tmp53_;
			} else {
				_tmp44_ = FALSE;
			}
			_tmp33_ = _tmp44_;
		}
		if (_tmp33_) {
			GameWindow* _tmp54_;
			Game* _tmp55_;
			guint8 _tmp56_;
			guint8 _tmp57_;
			Game* _tmp58_;
			guint8 _tmp59_;
			guint8 _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp54_ = self->priv->window;
			_tmp55_ = self->priv->game;
			_tmp56_ = game_get_n_dark_tiles (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = self->priv->game;
			_tmp59_ = game_get_n_light_tiles (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strdup_printf (_ ("Dark wins! (%u-%u)"), (guint) _tmp57_, (guint) _tmp60_);
			_tmp62_ = _tmp61_;
			base_window_show_notification ((BaseWindow*) _tmp54_, _tmp62_);
			_g_free0 (_tmp62_);
		} else {
			GameWindow* _tmp63_;
			_tmp63_ = self->priv->window;
			base_window_show_notification ((BaseWindow*) _tmp63_, _ ("The game is draw."));
		}
	}
	if (play_gameover_sound) {
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
	}
}

static void
iagno_player_move_cb (Iagno* self,
                      guint8 x,
                      guint8 y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	Player _tmp5_;
	Game* _tmp10_;
	Game* _tmp11_;
	Opening _tmp12_;
	Opening _tmp13_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->_computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->game;
	if (game_place_tile (_tmp10_, x, y)) {
		return;
	}
	_tmp11_ = self->priv->game;
	_tmp12_ = game_get_opening (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != OPENING_HUMANS) {
		GameWindow* _tmp14_;
		_tmp14_ = self->priv->window;
		base_window_show_notification ((BaseWindow*) _tmp14_, _ ("You can’t move there!"));
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Game* _tmp18_;
		Player _tmp19_;
		Player _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = game_get_current_color (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == PLAYER_LIGHT) {
			Game* _tmp21_;
			guint8 _tmp22_;
			guint8 _tmp23_;
			_tmp21_ = self->priv->game;
			_tmp22_ = game_get_n_light_tiles (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = ((gint) _tmp23_) == 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gboolean _tmp24_ = FALSE;
			Game* _tmp25_;
			guint8 _tmp26_;
			guint8 _tmp27_;
			_tmp25_ = self->priv->game;
			_tmp26_ = game_get_size (_tmp25_);
			_tmp27_ = _tmp26_;
			if (((gint) x) == ((_tmp27_ / 2) - 1)) {
				_tmp24_ = TRUE;
			} else {
				Game* _tmp28_;
				guint8 _tmp29_;
				guint8 _tmp30_;
				_tmp28_ = self->priv->game;
				_tmp29_ = game_get_size (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp24_ = ((gint) x) == (_tmp30_ / 2);
			}
			_tmp16_ = _tmp24_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			gboolean _tmp31_ = FALSE;
			Game* _tmp32_;
			guint8 _tmp33_;
			guint8 _tmp34_;
			_tmp32_ = self->priv->game;
			_tmp33_ = game_get_size (_tmp32_);
			_tmp34_ = _tmp33_;
			if (((gint) y) == ((_tmp34_ / 2) - 1)) {
				_tmp31_ = TRUE;
			} else {
				Game* _tmp35_;
				guint8 _tmp36_;
				guint8 _tmp37_;
				_tmp35_ = self->priv->game;
				_tmp36_ = game_get_size (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp31_ = ((gint) y) == (_tmp37_ / 2);
			}
			_tmp15_ = _tmp31_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GameWindow* _tmp38_;
			_tmp38_ = self->priv->window;
			base_window_show_notification ((BaseWindow*) _tmp38_, _ ("In this opening, Light can only play on tiles bordering on Dark one."));
		} else {
			GameWindow* _tmp39_;
			_tmp39_ = self->priv->window;
			base_window_show_notification ((BaseWindow*) _tmp39_, _ ("Click on one of the highlighted tiles to move the selected piece there" \
"."));
		}
	}
}

static void
iagno_clear_impossible_to_move_here_warning (Iagno* self)
{
	GameWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->game_is_set, "game_is_set");
	_tmp0_ = self->priv->window;
	game_window_clear_subtitle (_tmp0_);
}

static void
iagno_update_scoreboard (Iagno* self)
{
	HistoryButton* _tmp0_;
	Game* _tmp1_;
	Player _tmp2_;
	Player _tmp3_;
	HistoryButton* _tmp4_;
	Game* _tmp5_;
	Player _tmp6_;
	Player _tmp7_;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp0_ = self->priv->history_button_1;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	history_button_set_player (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->history_button_2;
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_current_color (_tmp5_);
	_tmp7_ = _tmp6_;
	history_button_set_player (_tmp4_, _tmp7_);
}

static void
iagno_set_window_title (Iagno* self)
{
	const gchar* _tmp0_ = NULL;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GameWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_reverse (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = _ ("Reverse Reversi");
	} else {
		_tmp0_ = _ ("Classic Reversi");
	}
	_tmp4_ = self->priv->window;
	game_window_update_title (_tmp4_, _tmp0_);
}

static void
iagno_init_sound (Iagno* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->sound_context);
		self->priv->sound_context = _tmp2_;
		self->priv->sound_context_state = IAGNO_SOUND_CONTEXT_STATE_WORKING;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:1023: %s", _tmp4_);
		self->priv->sound_context_state = IAGNO_SOUND_CONTEXT_STATE_ERRORED;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
iagno_play_sound (Iagno* self,
                  IagnoSound sound)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "sound")) {
		if (self->priv->sound_context_state == IAGNO_SOUND_CONTEXT_STATE_INITIAL) {
			iagno_init_sound (self);
		}
		if (self->priv->sound_context_state == IAGNO_SOUND_CONTEXT_STATE_WORKING) {
			GSoundContext* _tmp1_;
			ThemeManager* _tmp2_;
			_tmp1_ = self->priv->sound_context;
			_tmp2_ = self->priv->theme_manager;
			_iagno_play_sound (sound, _tmp1_, _tmp2_);
		}
	}
}

static inline void
_iagno_play_sound (IagnoSound sound,
                   GSoundContext* sound_context,
                   ThemeManager* theme_manager)
{
	gchar* name = NULL;
	const gchar* _tmp6_;
	gchar* path = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (sound_context != NULL);
	g_return_if_fail (theme_manager != NULL);
	switch (sound) {
		case IAGNO_SOUND_FLIP:
		{
			const gchar* _tmp0_;
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp0_ = theme_manager_get_sound_flip (theme_manager);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_strdup (_tmp1_);
			_g_free0 (name);
			name = _tmp2_;
			break;
		}
		case IAGNO_SOUND_GAMEOVER:
		{
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = theme_manager_get_sound_gameover (theme_manager);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (name);
			name = _tmp5_;
			break;
		}
		default:
		{
			_g_free0 (name);
			return;
		}
	}
	_tmp6_ = name;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		g_assert_not_reached ();
	}
	_tmp7_ = name;
	_tmp8_ = g_build_filename (SOUND_DIRECTORY, _tmp7_, NULL);
	path = _tmp8_;
	{
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = name;
		_tmp10_ = path;
		gsound_context_play_simple (sound_context, NULL, &_inner_error0_, GSOUND_ATTR_MEDIA_NAME, _tmp9_, GSOUND_ATTR_MEDIA_FILENAME, _tmp10_, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("iagno.vala:1065: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	_g_free0 (name);
}

static void
iagno_real_copy (BaseApplication* base,
                 const gchar* text)
{
	Iagno * self;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp3_;
	GtkClipboard* _tmp4_;
	GtkClipboard* _tmp5_;
	GtkClipboard* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (Iagno*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (display);
		return;
	}
	_tmp3_ = display;
	_tmp4_ = gtk_clipboard_get_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_display_get_type (), GdkDisplay));
	_tmp5_ = _g_object_ref0 (_tmp4_);
	clipboard = _tmp5_;
	_tmp6_ = clipboard;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	gtk_clipboard_set_text (_tmp6_, text, _tmp8_);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

static void
iagno_real_get_about_dialog_infos (BaseApplication* base,
                                   gchar*** artists,
                                   gint* artists_length1,
                                   gchar*** authors,
                                   gint* authors_length1,
                                   gchar** comments,
                                   gchar** copyright,
                                   gchar*** documenters,
                                   gint* documenters_length1,
                                   gchar** logo_icon_name,
                                   gchar** program_name,
                                   gchar** translator_credits,
                                   gchar** version,
                                   gchar** website,
                                   gchar** website_label)
{
	Iagno * self;
	gchar** _vala_artists = NULL;
	gint _vala_artists_length1 = 0;
	gchar** _vala_authors = NULL;
	gint _vala_authors_length1 = 0;
	gchar* _vala_comments = NULL;
	gchar* _vala_copyright = NULL;
	gchar** _vala_documenters = NULL;
	gint _vala_documenters_length1 = 0;
	gchar* _vala_logo_icon_name = NULL;
	gchar* _vala_program_name = NULL;
	gchar* _vala_translator_credits = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_website = NULL;
	gchar* _vala_website_label = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	self = (Iagno*) base;
	_tmp0_ = g_strdup (_ ("A disk flipping game derived from Reversi"));
	_g_free0 (_vala_comments);
	_vala_comments = _tmp0_;
	_tmp1_ = g_strdup (_ ("Masuichi Ito (pieces)"));
	_tmp2_ = g_strdup (_ ("Arnaud Bonatti (themes)"));
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	_vala_artists = _tmp3_;
	_vala_artists_length1 = 2;
	_tmp4_ = g_strdup (_ ("Ian Peters"));
	_tmp5_ = g_strdup (_ ("Robert Ancell"));
	_tmp6_ = g_strdup (_ ("Arnaud Bonatti"));
	_tmp7_ = g_new0 (gchar*, 3 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	_vala_authors = _tmp7_;
	_vala_authors_length1 = 3;
	_tmp8_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Ian Peters"), (guint) 1998, (guint) 2008);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Michael Catanzaro"), (guint) 2013, (guint) 2015);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2014, (guint) 2020);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
	_g_free0 (_vala_copyright);
	_vala_copyright = _tmp20_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp21_ = g_strdup (_ ("Tiffany Antopolski"));
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	_vala_documenters = _tmp22_;
	_vala_documenters_length1 = 1;
	_tmp23_ = g_strdup ("org.gnome.Reversi");
	_g_free0 (_vala_logo_icon_name);
	_vala_logo_icon_name = _tmp23_;
	_tmp24_ = g_strdup (IAGNO_PROGRAM_NAME);
	_g_free0 (_vala_program_name);
	_vala_program_name = _tmp24_;
	_tmp25_ = g_strdup (_ ("translator-credits"));
	_g_free0 (_vala_translator_credits);
	_vala_translator_credits = _tmp25_;
	_tmp26_ = g_strdup (VERSION);
	_g_free0 (_vala_version);
	_vala_version = _tmp26_;
	_tmp27_ = g_strdup ("https://wiki.gnome.org/Apps/Reversi");
	_g_free0 (_vala_website);
	_vala_website = _tmp27_;
	_tmp28_ = g_strdup (_ ("Page on GNOME wiki"));
	_g_free0 (_vala_website_label);
	_vala_website_label = _tmp28_;
	if (artists) {
		*artists = _vala_artists;
	} else {
		_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	}
	if (artists_length1) {
		*artists_length1 = _vala_artists_length1;
	}
	if (authors) {
		*authors = _vala_authors;
	} else {
		_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	}
	if (authors_length1) {
		*authors_length1 = _vala_authors_length1;
	}
	if (comments) {
		*comments = _vala_comments;
	} else {
		_g_free0 (_vala_comments);
	}
	if (copyright) {
		*copyright = _vala_copyright;
	} else {
		_g_free0 (_vala_copyright);
	}
	if (documenters) {
		*documenters = _vala_documenters;
	} else {
		_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	}
	if (documenters_length1) {
		*documenters_length1 = _vala_documenters_length1;
	}
	if (logo_icon_name) {
		*logo_icon_name = _vala_logo_icon_name;
	} else {
		_g_free0 (_vala_logo_icon_name);
	}
	if (program_name) {
		*program_name = _vala_program_name;
	} else {
		_g_free0 (_vala_program_name);
	}
	if (translator_credits) {
		*translator_credits = _vala_translator_credits;
	} else {
		_g_free0 (_vala_translator_credits);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (website) {
		*website = _vala_website;
	} else {
		_g_free0 (_vala_website);
	}
	if (website_label) {
		*website_label = _vala_website_label;
	} else {
		_g_free0 (_vala_website_label);
	}
}

ComputerPlayer*
iagno_get_computer (Iagno* self)
{
	ComputerPlayer* result;
	ComputerPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_computer;
	result = _tmp0_;
	return result;
}

static void
iagno_set_computer (Iagno* self,
                    ComputerPlayer* value)
{
	ComputerPlayer* old_value;
	g_return_if_fail (self != NULL);
	old_value = iagno_get_computer (self);
	if (old_value != value) {
		ComputerPlayer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_computer);
		self->priv->_computer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, iagno_properties[IAGNO_COMPUTER_PROPERTY]);
	}
}

Player
iagno_get_player_one (Iagno* self)
{
	Player result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_player_one;
	return result;
}

static void
iagno_set_player_one (Iagno* self,
                      Player value)
{
	Player old_value;
	g_return_if_fail (self != NULL);
	old_value = iagno_get_player_one (self);
	if (old_value != value) {
		self->priv->_player_one = value;
		g_object_notify_by_pspec ((GObject *) self, iagno_properties[IAGNO_PLAYER_ONE_PROPERTY]);
	}
}

static void
iagno_class_init (IagnoClass * klass,
                  gpointer klass_data)
{
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Iagno_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) iagno_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) iagno_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) iagno_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_iagno_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_iagno_set_property;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IAGNO_COMPUTER_PROPERTY, iagno_properties[IAGNO_COMPUTER_PROPERTY] = g_param_spec_object ("computer", "computer", "computer", TYPE_COMPUTER_PLAYER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IAGNO_PLAYER_ONE_PROPERTY, iagno_properties[IAGNO_PLAYER_ONE_PROPERTY] = g_param_spec_enum ("player-one", "player-one", "player-one", TYPE_PLAYER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
iagno_base_application_interface_init (BaseApplicationIface * iface,
                                       gpointer iface_data)
{
	iagno_base_application_parent_iface = g_type_interface_peek_parent (iface);
	iface->copy = (void (*) (BaseApplication*, const gchar*)) iagno_real_copy;
	iface->get_about_dialog_infos = (void (*) (BaseApplication*, gchar***, gint*, gchar***, gint*, gchar**, gchar**, gchar***, gint*, gchar**, gchar**, gchar**, gchar**, gchar**, gchar**)) iagno_real_get_about_dialog_infos;
}

static void
iagno_instance_init (Iagno * self,
                     gpointer klass)
{
	ThemeManager* _tmp0_;
	self->priv = iagno_get_instance_private (self);
	_tmp0_ = theme_manager_new ();
	self->priv->theme_manager = _tmp0_;
	self->priv->_computer = NULL;
	self->priv->game_is_set = FALSE;
	self->priv->game_type_changed_1 = FALSE;
	self->priv->game_type_changed_2 = FALSE;
	self->priv->level_changed = FALSE;
	self->priv->first_player_is_human = FALSE;
	self->priv->sound_context_state = IAGNO_SOUND_CONTEXT_STATE_INITIAL;
}

static void
iagno_finalize (GObject * obj)
{
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->history_button_1);
	_g_object_unref0 (self->priv->history_button_2);
	_g_object_unref0 (self->priv->history_menu);
	_g_object_unref0 (self->priv->finish_menu);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->_computer);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->night_light_monitor);
	_g_object_unref0 (self->priv->alternate_who_starts_action);
	_g_object_unref0 (self->priv->change_level_action);
	_g_object_unref0 (self->priv->sound_context);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}

static GType
iagno_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
	static const GInterfaceInfo base_application_info = { (GInterfaceInitFunc) iagno_base_application_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType iagno_type_id;
	iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
	g_type_add_interface_static (iagno_type_id, TYPE_BASE_APPLICATION, &base_application_info);
	Iagno_private_offset = g_type_add_instance_private (iagno_type_id, sizeof (IagnoPrivate));
	return iagno_type_id;
}

GType
iagno_get_type (void)
{
	static volatile gsize iagno_type_id__once = 0;
	if (g_once_init_enter (&iagno_type_id__once)) {
		GType iagno_type_id;
		iagno_type_id = iagno_get_type_once ();
		g_once_init_leave (&iagno_type_id__once, iagno_type_id);
	}
	return iagno_type_id__once;
}

static void
_vala_iagno_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IAGNO, Iagno);
	switch (property_id) {
		case IAGNO_COMPUTER_PROPERTY:
		g_value_set_object (value, iagno_get_computer (self));
		break;
		case IAGNO_PLAYER_ONE_PROPERTY:
		g_value_set_enum (value, iagno_get_player_one (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_iagno_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IAGNO, Iagno);
	switch (property_id) {
		case IAGNO_COMPUTER_PROPERTY:
		iagno_set_computer (self, g_value_get_object (value));
		break;
		case IAGNO_PLAYER_ONE_PROPERTY:
		iagno_set_player_one (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

