{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about a color stop on a color line.
-- 
-- Color lines typically have offsets ranging between 0 and 1,
-- but that is not required.
-- 
-- Note: despite /@color@/ being unpremultiplied here, interpolation in
-- gradients shall happen in premultiplied space. See the OpenType spec
-- <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details.
-- 
-- /Since: 7.0.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.ColorStopT
    ( 

-- * Exported types
    ColorStopT(..)                          ,
    newZeroColorStopT                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveColorStopTMethod                 ,
#endif



 -- * Properties


-- ** color #attr:color#
-- | the color, unpremultiplied

#if defined(ENABLE_OVERLOADING)
    colorStopT_color                        ,
#endif
    getColorStopTColor                      ,
    setColorStopTColor                      ,


-- ** isForeground #attr:isForeground#
-- | whether the color is the foreground

#if defined(ENABLE_OVERLOADING)
    colorStopT_isForeground                 ,
#endif
    getColorStopTIsForeground               ,
    setColorStopTIsForeground               ,


-- ** offset #attr:offset#
-- | the offset of the color stop

#if defined(ENABLE_OVERLOADING)
    colorStopT_offset                       ,
#endif
    getColorStopTOffset                     ,
    setColorStopTOffset                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ColorStopT = ColorStopT (SP.ManagedPtr ColorStopT)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorStopT where
    toManagedPtr (ColorStopT p) = p

foreign import ccall "hb_gobject_color_stop_get_type" c_hb_gobject_color_stop_get_type :: 
    IO GType

type instance O.ParentTypes ColorStopT = '[]
instance O.HasParentTypes ColorStopT

instance B.Types.TypedObject ColorStopT where
    glibType = c_hb_gobject_color_stop_get_type

instance B.Types.GBoxed ColorStopT

-- | Convert t'ColorStopT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColorStopT) where
    gvalueGType_ = c_hb_gobject_color_stop_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ColorStopT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ColorStopT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ColorStopT ptr
        else return P.Nothing
        
    

-- | Construct a t'ColorStopT' struct initialized to zero.
newZeroColorStopT :: MonadIO m => m ColorStopT
newZeroColorStopT = liftIO $ callocBoxedBytes 12 >>= wrapBoxed ColorStopT

instance tag ~ 'AttrSet => Constructible ColorStopT tag where
    new _ attrs = do
        o <- newZeroColorStopT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorStopT #offset
-- @
getColorStopTOffset :: MonadIO m => ColorStopT -> m Float
getColorStopTOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorStopT [ #offset 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorStopTOffset :: MonadIO m => ColorStopT -> Float -> m ()
setColorStopTOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data ColorStopTOffsetFieldInfo
instance AttrInfo ColorStopTOffsetFieldInfo where
    type AttrBaseTypeConstraint ColorStopTOffsetFieldInfo = (~) ColorStopT
    type AttrAllowedOps ColorStopTOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorStopTOffsetFieldInfo = (~) Float
    type AttrTransferTypeConstraint ColorStopTOffsetFieldInfo = (~)Float
    type AttrTransferType ColorStopTOffsetFieldInfo = Float
    type AttrGetType ColorStopTOffsetFieldInfo = Float
    type AttrLabel ColorStopTOffsetFieldInfo = "offset"
    type AttrOrigin ColorStopTOffsetFieldInfo = ColorStopT
    attrGet = getColorStopTOffset
    attrSet = setColorStopTOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorStopT.offset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorStopT.html#g:attr:offset"
        })

colorStopT_offset :: AttrLabelProxy "offset"
colorStopT_offset = AttrLabelProxy

#endif


-- | Get the value of the “@is_foreground@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorStopT #isForeground
-- @
getColorStopTIsForeground :: MonadIO m => ColorStopT -> m Int32
getColorStopTIsForeground s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@is_foreground@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorStopT [ #isForeground 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorStopTIsForeground :: MonadIO m => ColorStopT -> Int32 -> m ()
setColorStopTIsForeground s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data ColorStopTIsForegroundFieldInfo
instance AttrInfo ColorStopTIsForegroundFieldInfo where
    type AttrBaseTypeConstraint ColorStopTIsForegroundFieldInfo = (~) ColorStopT
    type AttrAllowedOps ColorStopTIsForegroundFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorStopTIsForegroundFieldInfo = (~) Int32
    type AttrTransferTypeConstraint ColorStopTIsForegroundFieldInfo = (~)Int32
    type AttrTransferType ColorStopTIsForegroundFieldInfo = Int32
    type AttrGetType ColorStopTIsForegroundFieldInfo = Int32
    type AttrLabel ColorStopTIsForegroundFieldInfo = "is_foreground"
    type AttrOrigin ColorStopTIsForegroundFieldInfo = ColorStopT
    attrGet = getColorStopTIsForeground
    attrSet = setColorStopTIsForeground
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorStopT.isForeground"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorStopT.html#g:attr:isForeground"
        })

colorStopT_isForeground :: AttrLabelProxy "isForeground"
colorStopT_isForeground = AttrLabelProxy

#endif


-- | Get the value of the “@color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorStopT #color
-- @
getColorStopTColor :: MonadIO m => ColorStopT -> m Word32
getColorStopTColor s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorStopT [ #color 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorStopTColor :: MonadIO m => ColorStopT -> Word32 -> m ()
setColorStopTColor s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data ColorStopTColorFieldInfo
instance AttrInfo ColorStopTColorFieldInfo where
    type AttrBaseTypeConstraint ColorStopTColorFieldInfo = (~) ColorStopT
    type AttrAllowedOps ColorStopTColorFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorStopTColorFieldInfo = (~) Word32
    type AttrTransferTypeConstraint ColorStopTColorFieldInfo = (~)Word32
    type AttrTransferType ColorStopTColorFieldInfo = Word32
    type AttrGetType ColorStopTColorFieldInfo = Word32
    type AttrLabel ColorStopTColorFieldInfo = "color"
    type AttrOrigin ColorStopTColorFieldInfo = ColorStopT
    attrGet = getColorStopTColor
    attrSet = setColorStopTColor
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.ColorStopT.color"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-ColorStopT.html#g:attr:color"
        })

colorStopT_color :: AttrLabelProxy "color"
colorStopT_color = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorStopT
type instance O.AttributeList ColorStopT = ColorStopTAttributeList
type ColorStopTAttributeList = ('[ '("offset", ColorStopTOffsetFieldInfo), '("isForeground", ColorStopTIsForegroundFieldInfo), '("color", ColorStopTColorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveColorStopTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorStopTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorStopTMethod t ColorStopT, O.OverloadedMethod info ColorStopT p) => OL.IsLabel t (ColorStopT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorStopTMethod t ColorStopT, O.OverloadedMethod info ColorStopT p, R.HasField t ColorStopT p) => R.HasField t ColorStopT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorStopTMethod t ColorStopT, O.OverloadedMethodInfo info ColorStopT) => OL.IsLabel t (O.MethodProxy info ColorStopT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


