{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gsk.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ ]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Gsk.Config"
 , "GI.Gsk"
 , "GI.Gsk.Callbacks"
 , "GI.Gsk.Enums"
 , "GI.Gsk.Flags"
 , "GI.Gsk.Functions"
 , "GI.Gsk.Objects"
 , "GI.Gsk.Objects.BlendNode"
 , "GI.Gsk.Objects.BlurNode"
 , "GI.Gsk.Objects.BorderNode"
 , "GI.Gsk.Objects.BroadwayRenderer"
 , "GI.Gsk.Objects.CairoNode"
 , "GI.Gsk.Objects.CairoRenderer"
 , "GI.Gsk.Objects.ClipNode"
 , "GI.Gsk.Objects.ColorMatrixNode"
 , "GI.Gsk.Objects.ColorNode"
 , "GI.Gsk.Objects.ComponentTransferNode"
 , "GI.Gsk.Objects.ConicGradientNode"
 , "GI.Gsk.Objects.ContainerNode"
 , "GI.Gsk.Objects.CrossFadeNode"
 , "GI.Gsk.Objects.DebugNode"
 , "GI.Gsk.Objects.FillNode"
 , "GI.Gsk.Objects.GLRenderer"
 , "GI.Gsk.Objects.GLShader"
 , "GI.Gsk.Objects.GLShaderNode"
 , "GI.Gsk.Objects.InsetShadowNode"
 , "GI.Gsk.Objects.LinearGradientNode"
 , "GI.Gsk.Objects.MaskNode"
 , "GI.Gsk.Objects.NglRenderer"
 , "GI.Gsk.Objects.OpacityNode"
 , "GI.Gsk.Objects.OutsetShadowNode"
 , "GI.Gsk.Objects.RadialGradientNode"
 , "GI.Gsk.Objects.RenderNode"
 , "GI.Gsk.Objects.Renderer"
 , "GI.Gsk.Objects.RepeatNode"
 , "GI.Gsk.Objects.RepeatingLinearGradientNode"
 , "GI.Gsk.Objects.RepeatingRadialGradientNode"
 , "GI.Gsk.Objects.RoundedClipNode"
 , "GI.Gsk.Objects.ShadowNode"
 , "GI.Gsk.Objects.StrokeNode"
 , "GI.Gsk.Objects.SubsurfaceNode"
 , "GI.Gsk.Objects.TextNode"
 , "GI.Gsk.Objects.TextureNode"
 , "GI.Gsk.Objects.TextureScaleNode"
 , "GI.Gsk.Objects.TransformNode"
 , "GI.Gsk.Objects.VulkanRenderer"
 , "GI.Gsk.Structs"
 , "GI.Gsk.Structs.ColorStop"
 , "GI.Gsk.Structs.ComponentTransfer"
 , "GI.Gsk.Structs.ParseLocation"
 , "GI.Gsk.Structs.Path"
 , "GI.Gsk.Structs.PathBuilder"
 , "GI.Gsk.Structs.PathMeasure"
 , "GI.Gsk.Structs.PathPoint"
 , "GI.Gsk.Structs.RoundedRect"
 , "GI.Gsk.Structs.ShaderArgsBuilder"
 , "GI.Gsk.Structs.Shadow"
 , "GI.Gsk.Structs.Stroke"
 , "GI.Gsk.Structs.Transform"]
