{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Atk.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace Atk"
 , ""
 , "# Not marked properly as a GType struct (which we hide)"
 , "ignore _RegistryClass"
 , ""
 , "# Generated from atk 2.20.0 with xsltproc Nullable.xslt Atk-1.0.gir"
 , "set-attr Atk/Action/get_description/@return-value nullable 1"
 , "set-attr Atk/Action/get_keybinding/@return-value nullable 1"
 , "set-attr Atk/Action/get_localized_name/@return-value nullable 1"
 , "set-attr Atk/Action/get_name/@return-value nullable 1"
 , "set-attr Atk/Action/get_description/@return-value nullable 1"
 , "set-attr Atk/Action/get_keybinding/@return-value nullable 1"
 , "set-attr Atk/Action/get_localized_name/@return-value nullable 1"
 , "set-attr Atk/Action/get_name/@return-value nullable 1"
 , "set-attr Atk/ActionIface/get_description/get_description/@return-value nullable 1"
 , "set-attr Atk/ActionIface/get_name/get_name/@return-value nullable 1"
 , "set-attr Atk/ActionIface/get_keybinding/get_keybinding/@return-value nullable 1"
 , "set-attr Atk/ActionIface/get_localized_name/get_localized_name/@return-value nullable 1"
 , "set-attr Atk/Component/ref_accessible_at_point/@return-value nullable 1"
 , "set-attr Atk/Component/ref_accessible_at_point/@return-value nullable 1"
 , "set-attr Atk/ComponentIface/ref_accessible_at_point/ref_accessible_at_point/@return-value nullable 1"
 , "set-attr Atk/Document/get_document/@return-value nullable 1"
 , "set-attr Atk/Document/get_attribute_value/@return-value nullable 1"
 , "set-attr Atk/Document/get_document/@return-value nullable 1"
 , "set-attr Atk/DocumentIface/get_document/get_document/@return-value nullable 1"
 , "set-attr Atk/Function/@parameters/user_data nullable 1"
 , "set-attr Atk/Image/get_image_locale/@return-value nullable 1"
 , "set-attr Atk/Image/get_image_locale/@return-value nullable 1"
 , "set-attr Atk/ImageIface/get_image_locale/get_image_locale/@return-value nullable 1"
 , "set-attr Atk/KeySnoopFunc/@parameters/user_data nullable 1"
 , "set-attr Atk/Object/active_descendant_changed/@parameters/child nullable 1"
 , "set-attr Atk/Object/children_changed/@parameters/changed_child nullable 1"
 , "set-attr Atk/Object/initialize/@parameters/data nullable 1"
 , "set-attr Atk/Object/initialize/@parameters/data nullable 1"
 , "set-attr Atk/Object/active-descendant-changed/@parameters/arg1 nullable 1"
 , "set-attr Atk/Object/children-changed/@parameters/arg2 nullable 1"
 , "set-attr Atk/Object/property-change/@parameters/arg1 nullable 1"
 , "set-attr Atk/ObjectClass/initialize/initialize/@parameters/data nullable 1"
 , "set-attr Atk/ObjectClass/children_changed/children_changed/@parameters/changed_child nullable 1"
 , "set-attr Atk/ObjectClass/active_descendant_changed/active_descendant_changed/@parameters/child nullable 1"
 , "set-attr Atk/Selection/ref_selection/@return-value nullable 1"
 , "set-attr Atk/Selection/ref_selection/@return-value nullable 1"
 , "set-attr Atk/SelectionIface/ref_selection/ref_selection/@return-value nullable 1"
 , "set-attr Atk/StateSet/or_sets/@return-value nullable 1"
 , "set-attr Atk/StreamableContent/get_uri/@return-value nullable 1"
 , "set-attr Atk/StreamableContent/get_uri/@return-value nullable 1"
 , "set-attr Atk/StreamableContentIface/get_uri/get_uri/@return-value nullable 1"
 , "set-attr Atk/Table/get_caption/@return-value nullable 1"
 , "set-attr Atk/Table/get_column_header/@return-value nullable 1"
 , "set-attr Atk/Table/get_row_description/@return-value nullable 1"
 , "set-attr Atk/Table/get_row_header/@return-value nullable 1"
 , "set-attr Atk/Table/get_caption/@return-value nullable 1"
 , "set-attr Atk/Table/get_column_header/@return-value nullable 1"
 , "set-attr Atk/Table/get_row_description/@return-value nullable 1"
 , "set-attr Atk/Table/get_row_header/@return-value nullable 1"
 , "set-attr Atk/TableIface/get_caption/get_caption/@return-value nullable 1"
 , "set-attr Atk/TableIface/get_column_header/get_column_header/@return-value nullable 1"
 , "set-attr Atk/TableIface/get_row_description/get_row_description/@return-value nullable 1"
 , "set-attr Atk/TableIface/get_row_header/get_row_header/@return-value nullable 1"
 , "set-attr Atk/Text/get_string_at_offset/@return-value nullable 1"
 , "set-attr Atk/Text/get_string_at_offset/@return-value nullable 1"
 , "set-attr Atk/TextAttribute/get_value/@return-value nullable 1"
 , "set-attr Atk/TextIface/get_string_at_offset/get_string_at_offset/@return-value nullable 1"
 , "set-attr Atk/UtilClass/add_key_event_listener/add_key_event_listener/@parameters/data nullable 1"
 , "set-attr Atk/Value/get_range/@return-value nullable 1"
 , "set-attr Atk/Value/get_range/@return-value nullable 1"
 , "set-attr Atk/ValueIface/get_range/get_range/@return-value nullable 1"
 , "set-attr Atk/add_key_event_listener/@parameters/data nullable 1"
 , "set-attr Atk/text_attribute_get_value/@return-value nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Atk.Config"
 , "GI.Atk"
 , "GI.Atk.Callbacks"
 , "GI.Atk.Constants"
 , "GI.Atk.Enums"
 , "GI.Atk.Flags"
 , "GI.Atk.Functions"
 , "GI.Atk.Interfaces"
 , "GI.Atk.Interfaces.Action"
 , "GI.Atk.Interfaces.Component"
 , "GI.Atk.Interfaces.Document"
 , "GI.Atk.Interfaces.EditableText"
 , "GI.Atk.Interfaces.HyperlinkImpl"
 , "GI.Atk.Interfaces.Hypertext"
 , "GI.Atk.Interfaces.Image"
 , "GI.Atk.Interfaces.ImplementorIface"
 , "GI.Atk.Interfaces.Selection"
 , "GI.Atk.Interfaces.StreamableContent"
 , "GI.Atk.Interfaces.Table"
 , "GI.Atk.Interfaces.TableCell"
 , "GI.Atk.Interfaces.Text"
 , "GI.Atk.Interfaces.Value"
 , "GI.Atk.Interfaces.Window"
 , "GI.Atk.Objects"
 , "GI.Atk.Objects.GObjectAccessible"
 , "GI.Atk.Objects.Hyperlink"
 , "GI.Atk.Objects.Misc"
 , "GI.Atk.Objects.NoOpObject"
 , "GI.Atk.Objects.NoOpObjectFactory"
 , "GI.Atk.Objects.Object"
 , "GI.Atk.Objects.ObjectFactory"
 , "GI.Atk.Objects.Plug"
 , "GI.Atk.Objects.Registry"
 , "GI.Atk.Objects.Relation"
 , "GI.Atk.Objects.RelationSet"
 , "GI.Atk.Objects.Socket"
 , "GI.Atk.Objects.StateSet"
 , "GI.Atk.Objects.Util"
 , "GI.Atk.Structs"
 , "GI.Atk.Structs.Attribute"
 , "GI.Atk.Structs.Implementor"
 , "GI.Atk.Structs.KeyEventStruct"
 , "GI.Atk.Structs.PropertyValues"
 , "GI.Atk.Structs.Range"
 , "GI.Atk.Structs.Rectangle"
 , "GI.Atk.Structs.TextRange"
 , "GI.Atk.Structs.TextRectangle"
 , "GI.Atk.Structs.TextSelection"]
