/* gpx-track.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-track.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gpx.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_TRACK_0_PROPERTY,
	GPX_TRACK_NAME_PROPERTY,
	GPX_TRACK_TRACK_TYPE_PROPERTY,
	GPX_TRACK_IS_ROUTE_PROPERTY,
	GPX_TRACK_NUM_PROPERTIES
};
static GParamSpec* gpx_track_properties[GPX_TRACK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
enum  {
	GPX_TRACK_POINT_REMOVED_SIGNAL,
	GPX_TRACK_NUM_SIGNALS
};
static guint gpx_track_signals[GPX_TRACK_NUM_SIGNALS] = {0};

struct _GpxTrackPrivate {
	gchar* _name;
	gchar* _track_type;
	gint* _number;
	gboolean _is_route;
	GpxPoint* last;
};

static gint GpxTrack_private_offset;
static gpointer gpx_track_parent_class = NULL;

static void _gpx_point_unref0_ (gpointer var);
static inline void _g_list_free__gpx_point_unref0_ (GList* self);
static gint* _int_dup (gint* self);
static void g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void gpx_track_finalize (GObject * obj);
static GType gpx_track_get_type_once (void);
static void _vala_gpx_track_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_gpx_track_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GpxHeartRateMonitorTrack*
gpx_heart_rate_monitor_track_dup (const GpxHeartRateMonitorTrack* self)
{
	GpxHeartRateMonitorTrack* dup;
#line 22 "../gpx-viewer/libgpx/gpx-track.vala"
	dup = g_new0 (GpxHeartRateMonitorTrack, 1);
#line 22 "../gpx-viewer/libgpx/gpx-track.vala"
	memcpy (dup, self, sizeof (GpxHeartRateMonitorTrack));
#line 22 "../gpx-viewer/libgpx/gpx-track.vala"
	return dup;
#line 101 "gpx-track.c"
}

void
gpx_heart_rate_monitor_track_free (GpxHeartRateMonitorTrack* self)
{
#line 22 "../gpx-viewer/libgpx/gpx-track.vala"
	g_free (self);
#line 109 "gpx-track.c"
}

static GType
gpx_heart_rate_monitor_track_get_type_once (void)
{
	GType gpx_heart_rate_monitor_track_type_id;
	gpx_heart_rate_monitor_track_type_id = g_boxed_type_register_static ("GpxHeartRateMonitorTrack", (GBoxedCopyFunc) gpx_heart_rate_monitor_track_dup, (GBoxedFreeFunc) gpx_heart_rate_monitor_track_free);
	return gpx_heart_rate_monitor_track_type_id;
}

GType
gpx_heart_rate_monitor_track_get_type (void)
{
	static volatile gsize gpx_heart_rate_monitor_track_type_id__once = 0;
	if (g_once_init_enter (&gpx_heart_rate_monitor_track_type_id__once)) {
		GType gpx_heart_rate_monitor_track_type_id;
		gpx_heart_rate_monitor_track_type_id = gpx_heart_rate_monitor_track_get_type_once ();
		g_once_init_leave (&gpx_heart_rate_monitor_track_type_id__once, gpx_heart_rate_monitor_track_type_id);
	}
	return gpx_heart_rate_monitor_track_type_id__once;
}

static inline gpointer
gpx_track_get_instance_private (GpxTrack* self)
{
	return G_STRUCT_MEMBER_P (self, GpxTrack_private_offset);
}

static void
_gpx_point_unref0_ (gpointer var)
{
#line 51 "../gpx-viewer/libgpx/gpx-track.vala"
	(var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL));
#line 143 "gpx-track.c"
}

static inline void
_g_list_free__gpx_point_unref0_ (GList* self)
{
#line 51 "../gpx-viewer/libgpx/gpx-track.vala"
	g_list_free_full (self, (GDestroyNotify) _gpx_point_unref0_);
#line 151 "gpx-track.c"
}

GpxPoint*
gpx_track_get_last (GpxTrack* self)
{
	GpxPoint* _tmp0_;
	GpxPoint* result;
#line 64 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->priv->last;
#line 64 "../gpx-viewer/libgpx/gpx-track.vala"
	result = _tmp0_;
#line 64 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 165 "gpx-track.c"
}

/** This function will try to remove useless points */
void
gpx_track_filter_points (GpxTrack* self)
{
	GList* a = NULL;
	GList* b = NULL;
	GList* c = NULL;
	gdouble davg = 0.0;
	gdouble avg = 0.0;
	gdouble _tmp69_ = 0.0;
#line 70 "../gpx-viewer/libgpx/gpx-track.vala"
	a = NULL;
#line 71 "../gpx-viewer/libgpx/gpx-track.vala"
	b = NULL;
#line 72 "../gpx-viewer/libgpx/gpx-track.vala"
	c = NULL;
#line 74 "../gpx-viewer/libgpx/gpx-track.vala"
	davg = gpx_track_get_track_average (self);
#line 186 "gpx-track.c"
	{
		GList* iter = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = self->points;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp1_ = g_list_first (_tmp0_);
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
		iter = _tmp1_;
#line 197 "gpx-track.c"
		{
			gboolean _tmp2_ = FALSE;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp2_ = TRUE;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
			while (TRUE) {
#line 204 "gpx-track.c"
				GList* _tmp5_;
				GList* _tmp6_;
				GList* _tmp8_;
				GList* _tmp10_;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				GList* _tmp13_;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!_tmp2_) {
#line 214 "gpx-track.c"
					GList* _tmp3_;
					GList* _tmp4_;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp3_ = iter;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = _tmp3_->next;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
					iter = _tmp4_;
#line 223 "gpx-track.c"
				}
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp2_ = FALSE;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp5_ = iter;
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!(_tmp5_ != NULL)) {
#line 76 "../gpx-viewer/libgpx/gpx-track.vala"
					break;
#line 233 "gpx-track.c"
				}
#line 78 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp6_ = b;
#line 78 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp6_ != NULL) {
#line 239 "gpx-track.c"
					GList* _tmp7_;
#line 78 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp7_ = b;
#line 78 "../gpx-viewer/libgpx/gpx-track.vala"
					c = _tmp7_;
#line 245 "gpx-track.c"
				}
#line 79 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp8_ = a;
#line 79 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp8_ != NULL) {
#line 251 "gpx-track.c"
					GList* _tmp9_;
#line 79 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp9_ = a;
#line 79 "../gpx-viewer/libgpx/gpx-track.vala"
					b = _tmp9_;
#line 257 "gpx-track.c"
				}
#line 80 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp10_ = iter;
#line 80 "../gpx-viewer/libgpx/gpx-track.vala"
				a = _tmp10_;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp13_ = a;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp13_ != NULL) {
#line 267 "gpx-track.c"
					GList* _tmp14_;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp14_ = b;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp12_ = _tmp14_ != NULL;
#line 273 "gpx-track.c"
				} else {
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp12_ = FALSE;
#line 277 "gpx-track.c"
				}
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp12_) {
#line 281 "gpx-track.c"
					GList* _tmp15_;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp15_ = c;
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp11_ = _tmp15_ != NULL;
#line 287 "gpx-track.c"
				} else {
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp11_ = FALSE;
#line 291 "gpx-track.c"
				}
#line 81 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp11_) {
#line 295 "gpx-track.c"
					gdouble elapsed_ca = 0.0;
					GList* _tmp16_;
					gconstpointer _tmp17_;
					GList* _tmp18_;
					gconstpointer _tmp19_;
					gdouble elapsed_cb = 0.0;
					GList* _tmp20_;
					gconstpointer _tmp21_;
					GList* _tmp22_;
					gconstpointer _tmp23_;
					gdouble lat_rico_ca = 0.0;
					GList* _tmp24_;
					gconstpointer _tmp25_;
					GList* _tmp26_;
					gconstpointer _tmp27_;
					gdouble lon_rico_ca = 0.0;
					GList* _tmp28_;
					gconstpointer _tmp29_;
					GList* _tmp30_;
					gconstpointer _tmp31_;
					gdouble lat_rico_cb = 0.0;
					GList* _tmp32_;
					gconstpointer _tmp33_;
					GList* _tmp34_;
					gconstpointer _tmp35_;
					gdouble lon_rico_cb = 0.0;
					GList* _tmp36_;
					gconstpointer _tmp37_;
					GList* _tmp38_;
					gconstpointer _tmp39_;
					gdouble elv_rico_ca = 0.0;
					GList* _tmp40_;
					gconstpointer _tmp41_;
					GList* _tmp42_;
					gconstpointer _tmp43_;
					gdouble elv_rico_cb = 0.0;
					GList* _tmp44_;
					gconstpointer _tmp45_;
					GList* _tmp46_;
					gconstpointer _tmp47_;
					gdouble l = 0.0;
					gdouble m = 0.0;
					gdouble e = 0.0;
					gdouble abs_diff = 0.0;
					GList* _tmp48_;
					gconstpointer _tmp49_;
					GList* _tmp50_;
					gconstpointer _tmp51_;
					GList* _tmp52_;
					gconstpointer _tmp53_;
					GList* _tmp54_;
					gconstpointer _tmp55_;
					gdouble diff = 0.0;
					GList* _tmp56_;
					gconstpointer _tmp57_;
					GList* _tmp58_;
					gconstpointer _tmp59_;
					GList* _tmp60_;
					gconstpointer _tmp61_;
					GList* _tmp62_;
					gconstpointer _tmp63_;
					gboolean _tmp64_ = FALSE;
#line 83 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp16_ = a;
#line 83 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp17_ = _tmp16_->data;
#line 83 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp18_ = c;
#line 83 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp19_ = _tmp18_->data;
#line 83 "../gpx-viewer/libgpx/gpx-track.vala"
					elapsed_ca = (gdouble) (gpx_point_get_time ((GpxPoint*) _tmp17_) - gpx_point_get_time ((GpxPoint*) _tmp19_));
#line 84 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp20_ = a;
#line 84 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp21_ = _tmp20_->data;
#line 84 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp22_ = b;
#line 84 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp23_ = _tmp22_->data;
#line 84 "../gpx-viewer/libgpx/gpx-track.vala"
					elapsed_cb = (gdouble) (gpx_point_get_time ((GpxPoint*) _tmp21_) - gpx_point_get_time ((GpxPoint*) _tmp23_));
#line 86 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp24_ = a;
#line 86 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp25_ = _tmp24_->data;
#line 86 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp26_ = c;
#line 86 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp27_ = _tmp26_->data;
#line 86 "../gpx-viewer/libgpx/gpx-track.vala"
					lat_rico_ca = (((GpxPoint*) _tmp25_)->lat_dec - ((GpxPoint*) _tmp27_)->lat_dec) / ((gdouble) elapsed_ca);
#line 87 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp28_ = a;
#line 87 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp29_ = _tmp28_->data;
#line 87 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp30_ = c;
#line 87 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp31_ = _tmp30_->data;
#line 87 "../gpx-viewer/libgpx/gpx-track.vala"
					lon_rico_ca = (((GpxPoint*) _tmp29_)->lon_dec - ((GpxPoint*) _tmp31_)->lon_dec) / ((gdouble) elapsed_ca);
#line 88 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp32_ = b;
#line 88 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp33_ = _tmp32_->data;
#line 88 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp34_ = c;
#line 88 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp35_ = _tmp34_->data;
#line 88 "../gpx-viewer/libgpx/gpx-track.vala"
					lat_rico_cb = (((GpxPoint*) _tmp33_)->lat_dec - ((GpxPoint*) _tmp35_)->lat_dec) / ((gdouble) elapsed_cb);
#line 89 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp36_ = b;
#line 89 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp37_ = _tmp36_->data;
#line 89 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp38_ = c;
#line 89 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp39_ = _tmp38_->data;
#line 89 "../gpx-viewer/libgpx/gpx-track.vala"
					lon_rico_cb = (((GpxPoint*) _tmp37_)->lon_dec - ((GpxPoint*) _tmp39_)->lon_dec) / ((gdouble) elapsed_cb);
#line 91 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp40_ = a;
#line 91 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp41_ = _tmp40_->data;
#line 91 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp42_ = c;
#line 91 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp43_ = _tmp42_->data;
#line 91 "../gpx-viewer/libgpx/gpx-track.vala"
					elv_rico_ca = (((GpxPoint*) _tmp41_)->elevation - ((GpxPoint*) _tmp43_)->elevation) / ((gdouble) elapsed_ca);
#line 92 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp44_ = a;
#line 92 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp45_ = _tmp44_->data;
#line 92 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp46_ = b;
#line 92 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp47_ = _tmp46_->data;
#line 92 "../gpx-viewer/libgpx/gpx-track.vala"
					elv_rico_cb = (((GpxPoint*) _tmp45_)->elevation - ((GpxPoint*) _tmp47_)->elevation) / ((gdouble) elapsed_cb);
#line 94 "../gpx-viewer/libgpx/gpx-track.vala"
					l = fabs (1.0 - (lat_rico_ca / lat_rico_cb));
#line 95 "../gpx-viewer/libgpx/gpx-track.vala"
					m = fabs (1.0 - (lon_rico_ca / lon_rico_cb));
#line 96 "../gpx-viewer/libgpx/gpx-track.vala"
					e = fabs (1.0 - (elv_rico_ca / elv_rico_cb));
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp48_ = b;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp49_ = _tmp48_->data;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp50_ = a;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp51_ = _tmp50_->data;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp52_ = c;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp53_ = _tmp52_->data;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp54_ = b;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp55_ = _tmp54_->data;
#line 98 "../gpx-viewer/libgpx/gpx-track.vala"
					abs_diff = fabs (((GpxPoint*) _tmp49_)->speed - ((GpxPoint*) _tmp51_)->speed) + fabs (((GpxPoint*) _tmp53_)->speed - ((GpxPoint*) _tmp55_)->speed);
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp56_ = b;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp57_ = _tmp56_->data;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp58_ = a;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp59_ = _tmp58_->data;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp60_ = c;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp61_ = _tmp60_->data;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp62_ = b;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp63_ = _tmp62_->data;
#line 99 "../gpx-viewer/libgpx/gpx-track.vala"
					diff = fabs ((((GpxPoint*) _tmp57_)->speed - ((GpxPoint*) _tmp59_)->speed) + (((GpxPoint*) _tmp61_)->speed - ((GpxPoint*) _tmp63_)->speed));
#line 100 "../gpx-viewer/libgpx/gpx-track.vala"
					if (diff < (0.2 * abs_diff)) {
#line 100 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp64_ = abs_diff > (3 * davg);
#line 484 "gpx-track.c"
					} else {
#line 100 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp64_ = FALSE;
#line 488 "gpx-track.c"
					}
#line 100 "../gpx-viewer/libgpx/gpx-track.vala"
					if (_tmp64_) {
#line 492 "gpx-track.c"
						GList* _tmp65_;
#line 101 "../gpx-viewer/libgpx/gpx-track.vala"
						g_debug ("gpx-track.vala:101: ----- %f %f filter points", diff, abs_diff);
#line 102 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp65_ = b;
#line 102 "../gpx-viewer/libgpx/gpx-track.vala"
						self->points = g_list_remove_link (self->points, _tmp65_);
#line 500 "gpx-track.c"
					} else {
#line 105 "../gpx-viewer/libgpx/gpx-track.vala"
						if (l <= 0.2) {
#line 107 "../gpx-viewer/libgpx/gpx-track.vala"
							if (m <= 0.2) {
#line 506 "gpx-track.c"
								GList* _tmp66_;
								gint _tmp67_;
								GList* _tmp68_;
#line 110 "../gpx-viewer/libgpx/gpx-track.vala"
								_tmp66_ = b;
#line 110 "../gpx-viewer/libgpx/gpx-track.vala"
								self->points = g_list_remove_link (self->points, _tmp66_);
#line 111 "../gpx-viewer/libgpx/gpx-track.vala"
								_tmp67_ = self->filtered_points;
#line 111 "../gpx-viewer/libgpx/gpx-track.vala"
								self->filtered_points = _tmp67_ + 1;
#line 113 "../gpx-viewer/libgpx/gpx-track.vala"
								_tmp68_ = c;
#line 113 "../gpx-viewer/libgpx/gpx-track.vala"
								b = _tmp68_;
#line 522 "gpx-track.c"
							}
						}
					}
				}
			}
		}
	}
#line 119 "../gpx-viewer/libgpx/gpx-track.vala"
	gpx_track_recalculate (self);
#line 120 "../gpx-viewer/libgpx/gpx-track.vala"
	avg = gpx_track_get_track_average (self) / 20;
#line 121 "../gpx-viewer/libgpx/gpx-track.vala"
	if (avg > ((gdouble) 2)) {
#line 121 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp69_ = (gdouble) 2;
#line 538 "gpx-track.c"
	} else {
#line 121 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp69_ = avg;
#line 542 "gpx-track.c"
	}
#line 121 "../gpx-viewer/libgpx/gpx-track.vala"
	avg = _tmp69_;
#line 546 "gpx-track.c"
	{
		GList* iter = NULL;
		GList* _tmp70_;
		GList* _tmp71_;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp70_ = self->points;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp71_ = g_list_first (_tmp70_);
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
		iter = _tmp71_;
#line 557 "gpx-track.c"
		{
			gboolean _tmp72_ = FALSE;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp72_ = TRUE;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
			while (TRUE) {
#line 564 "gpx-track.c"
				GList* _tmp75_;
				GpxPoint* p = NULL;
				GList* _tmp76_;
				gconstpointer _tmp77_;
				gboolean _tmp78_ = FALSE;
				gboolean _tmp79_ = FALSE;
				GpxPoint* _tmp80_;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!_tmp72_) {
#line 574 "gpx-track.c"
					GList* _tmp73_;
					GList* _tmp74_;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp73_ = iter;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp74_ = _tmp73_->next;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
					iter = _tmp74_;
#line 583 "gpx-track.c"
				}
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp72_ = FALSE;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp75_ = iter;
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!(_tmp75_ != NULL)) {
#line 122 "../gpx-viewer/libgpx/gpx-track.vala"
					break;
#line 593 "gpx-track.c"
				}
#line 124 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp76_ = iter;
#line 124 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp77_ = _tmp76_->data;
#line 124 "../gpx-viewer/libgpx/gpx-track.vala"
				p = (GpxPoint*) _tmp77_;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp80_ = p;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp80_->distance < 0.01) {
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp79_ = TRUE;
#line 607 "gpx-track.c"
				} else {
					GpxPoint* _tmp81_;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp81_ = p;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp79_ = _tmp81_->speed < avg;
#line 614 "gpx-track.c"
				}
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp79_) {
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp78_ = TRUE;
#line 620 "gpx-track.c"
				} else {
					GpxPoint* _tmp82_;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp82_ = p;
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp78_ = !gpx_point_has_position (_tmp82_);
#line 627 "gpx-track.c"
				}
#line 125 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp78_) {
#line 631 "gpx-track.c"
					GpxPoint* _tmp83_;
#line 126 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp83_ = p;
#line 126 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp83_->stopped = TRUE;
#line 637 "gpx-track.c"
				}
			}
		}
	}
#line 129 "../gpx-viewer/libgpx/gpx-track.vala"
	g_debug ("gpx-track.vala:129: Removed %i points", self->filtered_points);
#line 644 "gpx-track.c"
}

/**
 * This will recalculates all speeds and distances. Call this when the list was modified.
 */
void
gpx_track_recalculate (GpxTrack* self)
{
	GList* last = NULL;
#line 136 "../gpx-viewer/libgpx/gpx-track.vala"
	last = NULL;
#line 137 "../gpx-viewer/libgpx/gpx-track.vala"
	self->total_distance = (gdouble) 0;
#line 138 "../gpx-viewer/libgpx/gpx-track.vala"
	self->max_speed = (gdouble) 0;
#line 139 "../gpx-viewer/libgpx/gpx-track.vala"
	self->max_elevation = 0.0;
#line 140 "../gpx-viewer/libgpx/gpx-track.vala"
	self->min_elevation = 0.0;
#line 664 "gpx-track.c"
	{
		GList* iter = NULL;
		GList* _tmp0_;
		GList* _tmp1_;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = self->points;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp1_ = g_list_first (_tmp0_);
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
		iter = _tmp1_;
#line 675 "gpx-track.c"
		{
			gboolean _tmp2_ = FALSE;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp2_ = TRUE;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
			while (TRUE) {
#line 682 "gpx-track.c"
				GList* _tmp5_;
				GpxPoint* point = NULL;
				GList* _tmp6_;
				gconstpointer _tmp7_;
				GList* _tmp8_;
				gdouble radius = 0.0;
				gdouble elevation_value = 0.0;
				GpxPoint* _tmp29_;
				gdouble weights = 0.0;
				GList* env_iter = NULL;
				GList* _tmp30_;
				gint i = 0;
				GList* _tmp40_;
				GpxPoint* _tmp50_;
				GpxPoint* _tmp51_;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!_tmp2_) {
#line 700 "gpx-track.c"
					GList* _tmp3_;
					GList* _tmp4_;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp3_ = iter;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = _tmp3_->next;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
					iter = _tmp4_;
#line 709 "gpx-track.c"
				}
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp2_ = FALSE;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp5_ = iter;
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!(_tmp5_ != NULL)) {
#line 141 "../gpx-viewer/libgpx/gpx-track.vala"
					break;
#line 719 "gpx-track.c"
				}
#line 143 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp6_ = iter;
#line 143 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp7_ = _tmp6_->data;
#line 143 "../gpx-viewer/libgpx/gpx-track.vala"
				point = (GpxPoint*) _tmp7_;
#line 144 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp8_ = last;
#line 144 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp8_ != NULL) {
#line 731 "gpx-track.c"
					GpxPoint* _tmp9_;
#line 145 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp9_ = point;
#line 145 "../gpx-viewer/libgpx/gpx-track.vala"
					if (gpx_point_has_position (_tmp9_)) {
#line 737 "gpx-track.c"
						GList* _tmp10_;
						gconstpointer _tmp11_;
						GpxPoint* _tmp12_;
						GpxPoint* _tmp13_;
						GpxPoint* _tmp14_;
						GList* _tmp15_;
						gconstpointer _tmp16_;
						GpxPoint* _tmp17_;
						GpxPoint* _tmp18_;
						GpxPoint* _tmp20_;
						GpxPoint* _tmp22_;
#line 146 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp10_ = last;
#line 146 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp11_ = _tmp10_->data;
#line 146 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp12_ = point;
#line 146 "../gpx-viewer/libgpx/gpx-track.vala"
						self->total_distance = self->total_distance + gpx_track_calculate_distance ((GpxPoint*) _tmp11_, _tmp12_);
#line 147 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp13_ = point;
#line 147 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp13_->distance = self->total_distance;
#line 148 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp14_ = point;
#line 148 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp15_ = last;
#line 148 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp16_ = _tmp15_->data;
#line 148 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp17_ = point;
#line 148 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp14_->speed = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp16_, _tmp17_);
#line 149 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp18_ = point;
#line 149 "../gpx-viewer/libgpx/gpx-track.vala"
						if (_tmp18_->elevation > self->max_elevation) {
#line 775 "gpx-track.c"
							GpxPoint* _tmp19_;
#line 149 "../gpx-viewer/libgpx/gpx-track.vala"
							_tmp19_ = point;
#line 149 "../gpx-viewer/libgpx/gpx-track.vala"
							self->max_elevation = _tmp19_->elevation;
#line 781 "gpx-track.c"
						}
#line 150 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp20_ = point;
#line 150 "../gpx-viewer/libgpx/gpx-track.vala"
						if (_tmp20_->elevation < self->min_elevation) {
#line 787 "gpx-track.c"
							GpxPoint* _tmp21_;
#line 150 "../gpx-viewer/libgpx/gpx-track.vala"
							_tmp21_ = point;
#line 150 "../gpx-viewer/libgpx/gpx-track.vala"
							self->min_elevation = _tmp21_->elevation;
#line 793 "gpx-track.c"
						}
#line 151 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp22_ = point;
#line 151 "../gpx-viewer/libgpx/gpx-track.vala"
						if (_tmp22_->speed > self->max_speed) {
#line 799 "gpx-track.c"
							GpxPoint* _tmp23_;
#line 151 "../gpx-viewer/libgpx/gpx-track.vala"
							_tmp23_ = point;
#line 151 "../gpx-viewer/libgpx/gpx-track.vala"
							self->max_speed = _tmp23_->speed;
#line 805 "gpx-track.c"
						}
					}
				} else {
					GpxPoint* _tmp24_;
					GpxPoint* _tmp26_;
					GpxPoint* _tmp28_;
#line 154 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp24_ = point;
#line 154 "../gpx-viewer/libgpx/gpx-track.vala"
					if (_tmp24_->elevation > self->max_elevation) {
#line 816 "gpx-track.c"
						GpxPoint* _tmp25_;
#line 154 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp25_ = point;
#line 154 "../gpx-viewer/libgpx/gpx-track.vala"
						self->max_elevation = _tmp25_->elevation;
#line 822 "gpx-track.c"
					}
#line 155 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp26_ = point;
#line 155 "../gpx-viewer/libgpx/gpx-track.vala"
					if (_tmp26_->elevation < self->min_elevation) {
#line 828 "gpx-track.c"
						GpxPoint* _tmp27_;
#line 155 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp27_ = point;
#line 155 "../gpx-viewer/libgpx/gpx-track.vala"
						self->min_elevation = _tmp27_->elevation;
#line 834 "gpx-track.c"
					}
#line 156 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp28_ = point;
#line 156 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp28_->distance = (gdouble) 0;
#line 840 "gpx-track.c"
				}
#line 159 "../gpx-viewer/libgpx/gpx-track.vala"
				radius = 0.2;
#line 162 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp29_ = point;
#line 162 "../gpx-viewer/libgpx/gpx-track.vala"
				elevation_value = _tmp29_->elevation * radius;
#line 163 "../gpx-viewer/libgpx/gpx-track.vala"
				weights = radius;
#line 166 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp30_ = iter;
#line 166 "../gpx-viewer/libgpx/gpx-track.vala"
				env_iter = _tmp30_;
#line 167 "../gpx-viewer/libgpx/gpx-track.vala"
				i = 0;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
				while (TRUE) {
#line 858 "gpx-track.c"
					GList* _tmp31_;
					GList* _tmp32_;
					GList* _tmp33_;
					gint _tmp34_;
					gdouble mydist = 0.0;
					GList* _tmp35_;
					gconstpointer _tmp36_;
					GpxPoint* _tmp37_;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp31_ = env_iter;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp32_ = _tmp31_->prev;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
					env_iter = _tmp32_;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp33_ = env_iter;
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
					if (!(_tmp33_ != NULL)) {
#line 168 "../gpx-viewer/libgpx/gpx-track.vala"
						break;
#line 879 "gpx-track.c"
					}
#line 169 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp34_ = i;
#line 169 "../gpx-viewer/libgpx/gpx-track.vala"
					i = _tmp34_ + 1;
#line 170 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp35_ = env_iter;
#line 170 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp36_ = _tmp35_->data;
#line 170 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp37_ = point;
#line 170 "../gpx-viewer/libgpx/gpx-track.vala"
					mydist = gpx_track_calculate_distance ((GpxPoint*) _tmp36_, _tmp37_);
#line 171 "../gpx-viewer/libgpx/gpx-track.vala"
					if (mydist < radius) {
#line 895 "gpx-track.c"
						GList* _tmp38_;
						gconstpointer _tmp39_;
#line 172 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp38_ = env_iter;
#line 172 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp39_ = _tmp38_->data;
#line 172 "../gpx-viewer/libgpx/gpx-track.vala"
						elevation_value += ((GpxPoint*) _tmp39_)->elevation * (radius - mydist);
#line 173 "../gpx-viewer/libgpx/gpx-track.vala"
						weights += radius - mydist;
#line 906 "gpx-track.c"
					} else {
#line 174 "../gpx-viewer/libgpx/gpx-track.vala"
						break;
#line 910 "gpx-track.c"
					}
				}
#line 177 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp40_ = iter;
#line 177 "../gpx-viewer/libgpx/gpx-track.vala"
				env_iter = _tmp40_;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
				while (TRUE) {
#line 919 "gpx-track.c"
					GList* _tmp41_;
					GList* _tmp42_;
					GList* _tmp43_;
					gint _tmp44_;
					gdouble mydist = 0.0;
					GList* _tmp45_;
					gconstpointer _tmp46_;
					GpxPoint* _tmp47_;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp41_ = env_iter;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp42_ = _tmp41_->prev;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
					env_iter = _tmp42_;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp43_ = env_iter;
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
					if (!(_tmp43_ != NULL)) {
#line 178 "../gpx-viewer/libgpx/gpx-track.vala"
						break;
#line 940 "gpx-track.c"
					}
#line 179 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp44_ = i;
#line 179 "../gpx-viewer/libgpx/gpx-track.vala"
					i = _tmp44_ + 1;
#line 180 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp45_ = env_iter;
#line 180 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp46_ = _tmp45_->data;
#line 180 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp47_ = point;
#line 180 "../gpx-viewer/libgpx/gpx-track.vala"
					mydist = gpx_track_calculate_distance ((GpxPoint*) _tmp46_, _tmp47_);
#line 181 "../gpx-viewer/libgpx/gpx-track.vala"
					if (mydist < radius) {
#line 956 "gpx-track.c"
						GList* _tmp48_;
						gconstpointer _tmp49_;
#line 182 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp48_ = env_iter;
#line 182 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp49_ = _tmp48_->data;
#line 182 "../gpx-viewer/libgpx/gpx-track.vala"
						elevation_value += ((GpxPoint*) _tmp49_)->elevation * (radius - mydist);
#line 183 "../gpx-viewer/libgpx/gpx-track.vala"
						weights += radius - mydist;
#line 967 "gpx-track.c"
					} else {
#line 184 "../gpx-viewer/libgpx/gpx-track.vala"
						break;
#line 971 "gpx-track.c"
					}
				}
#line 186 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp50_ = point;
#line 186 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp50_->smooth_elevation = elevation_value / weights;
#line 188 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp51_ = point;
#line 188 "../gpx-viewer/libgpx/gpx-track.vala"
				if (gpx_point_has_position (_tmp51_)) {
#line 982 "gpx-track.c"
					GList* _tmp52_;
#line 189 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp52_ = iter;
#line 189 "../gpx-viewer/libgpx/gpx-track.vala"
					last = _tmp52_;
#line 988 "gpx-track.c"
				}
			}
		}
	}
}

static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 244 "../gpx-viewer/libgpx/gpx-track.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 1000 "gpx-track.c"
}

void
gpx_track_add_point (GpxTrack* self,
                     GpxPoint* point)
{
	GpxPoint* _tmp0_;
	GpxPoint* _tmp44_;
	GpxPoint* _tmp45_;
#line 197 "../gpx-viewer/libgpx/gpx-track.vala"
	point->speed = 0.0;
#line 199 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->priv->last;
#line 199 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp0_ != NULL) {
#line 1016 "gpx-track.c"
		gdouble distance = 0.0;
		GpxPoint* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GpxPoint* _tmp4_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		GpxPoint* _tmp13_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		GpxPoint* _tmp22_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		GpxPoint* _tmp31_;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		GpxPoint* _tmp40_;
		const gchar* _tmp41_;
#line 201 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp1_ = self->priv->last;
#line 201 "../gpx-viewer/libgpx/gpx-track.vala"
		distance = gpx_track_calculate_distance (_tmp1_, point);
#line 202 "../gpx-viewer/libgpx/gpx-track.vala"
		self->total_distance = self->total_distance + distance;
#line 203 "../gpx-viewer/libgpx/gpx-track.vala"
		point->distance = self->total_distance;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp4_ = self->top;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp4_ == NULL) {
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp3_ = TRUE;
#line 1049 "gpx-track.c"
		} else {
			GpxPoint* _tmp5_;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp5_ = self->top;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp3_ = _tmp5_->lat_dec == ((gdouble) 1000);
#line 1056 "gpx-track.c"
		}
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp3_) {
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp2_ = TRUE;
#line 1062 "gpx-track.c"
		} else {
			GpxPoint* _tmp6_;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp6_ = self->top;
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp2_ = _tmp6_->lat_dec < point->lat_dec;
#line 1069 "gpx-track.c"
		}
#line 205 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp2_) {
#line 1073 "gpx-track.c"
			GpxPoint* _tmp7_;
			GpxPoint* _tmp9_;
			GpxPoint* _tmp10_;
#line 207 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp7_ = self->top;
#line 207 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp7_ == NULL) {
#line 1081 "gpx-track.c"
				GpxPoint* _tmp8_;
#line 207 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp8_ = gpx_point_new ();
#line 207 "../gpx-viewer/libgpx/gpx-track.vala"
				_gpx_point_unref0 (self->top);
#line 207 "../gpx-viewer/libgpx/gpx-track.vala"
				self->top = _tmp8_;
#line 1089 "gpx-track.c"
			}
#line 208 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp9_ = self->top;
#line 208 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp9_->lat_dec = point->lat_dec;
#line 209 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp10_ = self->top;
#line 209 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp10_->lat = point->lat;
#line 1099 "gpx-track.c"
		}
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp13_ = self->top;
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp13_ == NULL) {
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp12_ = TRUE;
#line 1107 "gpx-track.c"
		} else {
			GpxPoint* _tmp14_;
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp14_ = self->top;
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp12_ = _tmp14_->lon_dec == ((gdouble) 1000);
#line 1114 "gpx-track.c"
		}
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp12_) {
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp11_ = TRUE;
#line 1120 "gpx-track.c"
		} else {
			GpxPoint* _tmp15_;
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp15_ = self->top;
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp11_ = _tmp15_->lon_dec < point->lon_dec;
#line 1127 "gpx-track.c"
		}
#line 211 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp11_) {
#line 1131 "gpx-track.c"
			GpxPoint* _tmp16_;
			GpxPoint* _tmp18_;
			GpxPoint* _tmp19_;
#line 213 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp16_ = self->top;
#line 213 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp16_ == NULL) {
#line 1139 "gpx-track.c"
				GpxPoint* _tmp17_;
#line 213 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp17_ = gpx_point_new ();
#line 213 "../gpx-viewer/libgpx/gpx-track.vala"
				_gpx_point_unref0 (self->top);
#line 213 "../gpx-viewer/libgpx/gpx-track.vala"
				self->top = _tmp17_;
#line 1147 "gpx-track.c"
			}
#line 214 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp18_ = self->top;
#line 214 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp18_->lon_dec = point->lon_dec;
#line 215 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp19_ = self->top;
#line 215 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp19_->lon = point->lon;
#line 1157 "gpx-track.c"
		}
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp22_ = self->bottom;
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp22_ == NULL) {
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp21_ = TRUE;
#line 1165 "gpx-track.c"
		} else {
			GpxPoint* _tmp23_;
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp23_ = self->bottom;
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp21_ = _tmp23_->lat_dec == ((gdouble) 1000);
#line 1172 "gpx-track.c"
		}
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp21_) {
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp20_ = TRUE;
#line 1178 "gpx-track.c"
		} else {
			GpxPoint* _tmp24_;
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp24_ = self->bottom;
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp20_ = _tmp24_->lat_dec > point->lat_dec;
#line 1185 "gpx-track.c"
		}
#line 217 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp20_) {
#line 1189 "gpx-track.c"
			GpxPoint* _tmp25_;
			GpxPoint* _tmp27_;
			GpxPoint* _tmp28_;
#line 219 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp25_ = self->bottom;
#line 219 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp25_ == NULL) {
#line 1197 "gpx-track.c"
				GpxPoint* _tmp26_;
#line 219 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp26_ = gpx_point_new ();
#line 219 "../gpx-viewer/libgpx/gpx-track.vala"
				_gpx_point_unref0 (self->bottom);
#line 219 "../gpx-viewer/libgpx/gpx-track.vala"
				self->bottom = _tmp26_;
#line 1205 "gpx-track.c"
			}
#line 220 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp27_ = self->bottom;
#line 220 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp27_->lat_dec = point->lat_dec;
#line 221 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp28_ = self->bottom;
#line 221 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp28_->lat = point->lat;
#line 1215 "gpx-track.c"
		}
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp31_ = self->bottom;
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp31_ == NULL) {
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp30_ = TRUE;
#line 1223 "gpx-track.c"
		} else {
			GpxPoint* _tmp32_;
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp32_ = self->bottom;
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp30_ = _tmp32_->lon_dec == ((gdouble) 1000);
#line 1230 "gpx-track.c"
		}
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp30_) {
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp29_ = TRUE;
#line 1236 "gpx-track.c"
		} else {
			GpxPoint* _tmp33_;
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp33_ = self->bottom;
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp29_ = _tmp33_->lon_dec > point->lon_dec;
#line 1243 "gpx-track.c"
		}
#line 223 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp29_) {
#line 1247 "gpx-track.c"
			GpxPoint* _tmp34_;
			GpxPoint* _tmp36_;
			GpxPoint* _tmp37_;
#line 225 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp34_ = self->bottom;
#line 225 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp34_ == NULL) {
#line 1255 "gpx-track.c"
				GpxPoint* _tmp35_;
#line 225 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp35_ = gpx_point_new ();
#line 225 "../gpx-viewer/libgpx/gpx-track.vala"
				_gpx_point_unref0 (self->bottom);
#line 225 "../gpx-viewer/libgpx/gpx-track.vala"
				self->bottom = _tmp35_;
#line 1263 "gpx-track.c"
			}
#line 226 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp36_ = self->bottom;
#line 226 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp36_->lon_dec = point->lon_dec;
#line 227 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp37_ = self->bottom;
#line 227 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp37_->lon = point->lon;
#line 1273 "gpx-track.c"
		}
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp40_ = self->priv->last;
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp41_ = _tmp40_->time;
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp41_ != NULL) {
#line 1281 "gpx-track.c"
			const gchar* _tmp42_;
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp42_ = point->time;
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp39_ = _tmp42_ != NULL;
#line 1287 "gpx-track.c"
		} else {
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp39_ = FALSE;
#line 1291 "gpx-track.c"
		}
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp39_) {
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp38_ = gpx_point_has_position (point);
#line 1297 "gpx-track.c"
		} else {
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp38_ = FALSE;
#line 1301 "gpx-track.c"
		}
#line 229 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp38_) {
#line 1305 "gpx-track.c"
			GpxPoint* _tmp43_;
#line 231 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp43_ = self->priv->last;
#line 231 "../gpx-viewer/libgpx/gpx-track.vala"
			point->speed = gpx_track_calculate_point_to_point_speed (self, _tmp43_, point);
#line 232 "../gpx-viewer/libgpx/gpx-track.vala"
			if (point->speed > self->max_speed) {
#line 232 "../gpx-viewer/libgpx/gpx-track.vala"
				self->max_speed = point->speed;
#line 1315 "gpx-track.c"
			}
#line 233 "../gpx-viewer/libgpx/gpx-track.vala"
			if (point->elevation > self->max_elevation) {
#line 233 "../gpx-viewer/libgpx/gpx-track.vala"
				self->max_elevation = point->elevation;
#line 1321 "gpx-track.c"
			}
#line 234 "../gpx-viewer/libgpx/gpx-track.vala"
			if (point->elevation < self->min_elevation) {
#line 234 "../gpx-viewer/libgpx/gpx-track.vala"
				self->min_elevation = point->elevation;
#line 1327 "gpx-track.c"
			}
		}
	} else {
#line 241 "../gpx-viewer/libgpx/gpx-track.vala"
		self->max_elevation = point->elevation;
#line 242 "../gpx-viewer/libgpx/gpx-track.vala"
		self->min_elevation = point->elevation;
#line 1335 "gpx-track.c"
	}
#line 244 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp44_ = _gpx_point_ref0 (point);
#line 244 "../gpx-viewer/libgpx/gpx-track.vala"
	self->points = g_list_append (self->points, _tmp44_);
#line 245 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp45_ = _gpx_point_ref0 (point);
#line 245 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (self->priv->last);
#line 245 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->last = _tmp45_;
#line 1347 "gpx-track.c"
}

GpxTrack*
gpx_track_cleanup_speed (GpxTrack* self)
{
	GpxTrack* retv = NULL;
	GpxTrack* _tmp0_;
	GpxTrack* _tmp1_;
	const gchar* _tmp2_;
	guint num_points = 0U;
	GList* _tmp3_;
	gdouble mean = 0.0;
	gdouble deviation = 0.0;
	GList* list_copy = NULL;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* iter = NULL;
	GList* _tmp6_;
	GList* _tmp7_;
	GList* _tmp13_;
	GList* _tmp14_;
	guint i = 0U;
	GList* _tmp69_;
	GList* _tmp70_;
	GpxTrack* result;
#line 250 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = gpx_track_new ();
#line 250 "../gpx-viewer/libgpx/gpx-track.vala"
	retv = _tmp0_;
#line 252 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = retv;
#line 252 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = self->priv->_name;
#line 252 "../gpx-viewer/libgpx/gpx-track.vala"
	gpx_track_set_name (_tmp1_, _tmp2_);
#line 254 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp3_ = self->points;
#line 254 "../gpx-viewer/libgpx/gpx-track.vala"
	num_points = g_list_length (_tmp3_);
#line 255 "../gpx-viewer/libgpx/gpx-track.vala"
	mean = gpx_track_get_track_average (self);
#line 256 "../gpx-viewer/libgpx/gpx-track.vala"
	deviation = 0.0;
#line 259 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp4_ = self->points;
#line 259 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp5_ = g_list_copy (_tmp4_);
#line 259 "../gpx-viewer/libgpx/gpx-track.vala"
	list_copy = _tmp5_;
#line 260 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp6_ = list_copy;
#line 260 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp7_ = g_list_first (_tmp6_);
#line 260 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp7_;
#line 261 "../gpx-viewer/libgpx/gpx-track.vala"
	while (TRUE) {
#line 1405 "gpx-track.c"
		GList* _tmp8_;
		gdouble diff = 0.0;
		GList* _tmp9_;
		gconstpointer _tmp10_;
		GList* _tmp11_;
		GList* _tmp12_;
#line 261 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp8_ = iter;
#line 261 "../gpx-viewer/libgpx/gpx-track.vala"
		if (!(_tmp8_ != NULL)) {
#line 261 "../gpx-viewer/libgpx/gpx-track.vala"
			break;
#line 1418 "gpx-track.c"
		}
#line 263 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp9_ = iter;
#line 263 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp10_ = _tmp9_->data;
#line 263 "../gpx-viewer/libgpx/gpx-track.vala"
		diff = ((GpxPoint*) _tmp10_)->speed - mean;
#line 264 "../gpx-viewer/libgpx/gpx-track.vala"
		deviation += diff * diff;
#line 265 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp11_ = iter;
#line 265 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp12_ = _tmp11_->next;
#line 265 "../gpx-viewer/libgpx/gpx-track.vala"
		iter = _tmp12_;
#line 1434 "gpx-track.c"
	}
#line 267 "../gpx-viewer/libgpx/gpx-track.vala"
	deviation /= (gdouble) num_points;
#line 269 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp13_ = list_copy;
#line 269 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp14_ = g_list_first (_tmp13_);
#line 269 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp14_;
#line 270 "../gpx-viewer/libgpx/gpx-track.vala"
	i = (guint) 0;
#line 271 "../gpx-viewer/libgpx/gpx-track.vala"
	while (TRUE) {
#line 1448 "gpx-track.c"
		GList* _tmp15_;
		gdouble pspeed = 0.0;
		GList* _tmp16_;
		gconstpointer _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		gdouble pdf = 0.0;
		gboolean _tmp23_ = FALSE;
#line 271 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp15_ = iter;
#line 271 "../gpx-viewer/libgpx/gpx-track.vala"
		if (!(_tmp15_ != NULL)) {
#line 271 "../gpx-viewer/libgpx/gpx-track.vala"
			break;
#line 1463 "gpx-track.c"
		}
#line 273 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp16_ = iter;
#line 273 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp17_ = _tmp16_->data;
#line 273 "../gpx-viewer/libgpx/gpx-track.vala"
		pspeed = ((GpxPoint*) _tmp17_)->speed;
#line 274 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp18_ = iter;
#line 274 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp19_ = _tmp18_->next;
#line 274 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp19_ != NULL) {
#line 1477 "gpx-track.c"
			GList* _tmp20_;
			GList* _tmp21_;
			gconstpointer _tmp22_;
#line 275 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp20_ = iter;
#line 275 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp21_ = _tmp20_->next;
#line 275 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp22_ = _tmp21_->data;
#line 275 "../gpx-viewer/libgpx/gpx-track.vala"
			pspeed = ((GpxPoint*) _tmp22_)->speed;
#line 1489 "gpx-track.c"
		}
#line 277 "../gpx-viewer/libgpx/gpx-track.vala"
		pdf = (1 / sqrt ((2 * G_PI) * deviation)) * exp ((-((pspeed - mean) * (pspeed - mean))) / (2 * deviation));
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
		if ((num_points * pdf) < 0.1) {
#line 1495 "gpx-track.c"
			GList* _tmp24_;
			gconstpointer _tmp25_;
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp24_ = iter;
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp25_ = _tmp24_->data;
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp23_ = !((GpxPoint*) _tmp25_)->stopped;
#line 1504 "gpx-track.c"
		} else {
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp23_ = FALSE;
#line 1508 "gpx-track.c"
		}
#line 279 "../gpx-viewer/libgpx/gpx-track.vala"
		if (_tmp23_) {
#line 1512 "gpx-track.c"
			GList* temp = NULL;
			GList* _tmp26_;
			GList* _tmp27_;
			GList* _tmp28_;
			GList* _tmp29_;
#line 281 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp26_ = iter;
#line 281 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp27_ = _tmp26_->prev;
#line 281 "../gpx-viewer/libgpx/gpx-track.vala"
			temp = _tmp27_;
#line 282 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp28_ = iter;
#line 282 "../gpx-viewer/libgpx/gpx-track.vala"
			list_copy = g_list_remove_link (list_copy, _tmp28_);
#line 283 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp29_ = temp;
#line 283 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp29_ != NULL) {
#line 1532 "gpx-track.c"
				GList* _tmp30_;
				GList* _tmp31_;
				GList* _tmp32_;
#line 285 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp30_ = temp;
#line 285 "../gpx-viewer/libgpx/gpx-track.vala"
				iter = _tmp30_;
#line 286 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp31_ = iter;
#line 286 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp32_ = _tmp31_->next;
#line 286 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp32_ != NULL) {
#line 1546 "gpx-track.c"
					GList* _tmp33_;
					GList* _tmp34_;
					gconstpointer _tmp35_;
					GList* _tmp36_;
					gconstpointer _tmp37_;
					GList* _tmp38_;
					GList* _tmp39_;
					gconstpointer _tmp40_;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp33_ = iter;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp34_ = _tmp33_->next;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp35_ = _tmp34_->data;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp36_ = iter;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp37_ = _tmp36_->data;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp38_ = iter;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp39_ = _tmp38_->next;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp40_ = _tmp39_->data;
#line 287 "../gpx-viewer/libgpx/gpx-track.vala"
					((GpxPoint*) _tmp35_)->speed = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp37_, (GpxPoint*) _tmp40_);
#line 1573 "gpx-track.c"
				}
			} else {
				GList* _tmp41_;
				GList* _tmp42_;
				GList* _tmp43_;
#line 293 "../gpx-viewer/libgpx/gpx-track.vala"
				i = (guint) 0;
#line 294 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp41_ = list_copy;
#line 294 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp42_ = g_list_first (_tmp41_);
#line 294 "../gpx-viewer/libgpx/gpx-track.vala"
				iter = _tmp42_;
#line 295 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp43_ = iter;
#line 295 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp43_ != NULL) {
#line 1591 "gpx-track.c"
					GList* _tmp44_;
					gconstpointer _tmp45_;
					GList* _tmp46_;
					gconstpointer _tmp47_;
					GList* _tmp48_;
					GList* _tmp49_;
#line 296 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp44_ = iter;
#line 296 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp45_ = _tmp44_->data;
#line 296 "../gpx-viewer/libgpx/gpx-track.vala"
					((GpxPoint*) _tmp45_)->speed = 0.0;
#line 297 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp46_ = iter;
#line 297 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp47_ = _tmp46_->data;
#line 297 "../gpx-viewer/libgpx/gpx-track.vala"
					((GpxPoint*) _tmp47_)->distance = 0.0;
#line 298 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp48_ = iter;
#line 298 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp49_ = _tmp48_->next;
#line 298 "../gpx-viewer/libgpx/gpx-track.vala"
					if (_tmp49_ != NULL) {
#line 1616 "gpx-track.c"
						GList* _tmp50_;
						GList* _tmp51_;
						gconstpointer _tmp52_;
						GList* _tmp53_;
						gconstpointer _tmp54_;
						GList* _tmp55_;
						GList* _tmp56_;
						gconstpointer _tmp57_;
						GList* _tmp58_;
						GList* _tmp59_;
						gconstpointer _tmp60_;
						GList* _tmp61_;
						gconstpointer _tmp62_;
						GList* _tmp63_;
						GList* _tmp64_;
						gconstpointer _tmp65_;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp50_ = iter;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp51_ = _tmp50_->next;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp52_ = _tmp51_->data;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp53_ = iter;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp54_ = _tmp53_->data;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp55_ = iter;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp56_ = _tmp55_->next;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp57_ = _tmp56_->data;
#line 299 "../gpx-viewer/libgpx/gpx-track.vala"
						((GpxPoint*) _tmp52_)->distance = gpx_track_calculate_distance ((GpxPoint*) _tmp54_, (GpxPoint*) _tmp57_);
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp58_ = iter;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp59_ = _tmp58_->next;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp60_ = _tmp59_->data;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp61_ = iter;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp62_ = _tmp61_->data;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp63_ = iter;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp64_ = _tmp63_->next;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp65_ = _tmp64_->data;
#line 300 "../gpx-viewer/libgpx/gpx-track.vala"
						((GpxPoint*) _tmp60_)->speed = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp62_, (GpxPoint*) _tmp65_);
#line 1669 "gpx-track.c"
					}
				}
			}
		} else {
			GList* _tmp66_;
			GList* _tmp67_;
			guint _tmp68_;
#line 306 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp66_ = iter;
#line 306 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp67_ = _tmp66_->next;
#line 306 "../gpx-viewer/libgpx/gpx-track.vala"
			iter = _tmp67_;
#line 307 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp68_ = i;
#line 307 "../gpx-viewer/libgpx/gpx-track.vala"
			i = _tmp68_ + 1;
#line 1687 "gpx-track.c"
		}
	}
#line 311 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp69_ = list_copy;
#line 311 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp70_ = g_list_first (_tmp69_);
#line 311 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp70_;
#line 312 "../gpx-viewer/libgpx/gpx-track.vala"
	while (TRUE) {
#line 1698 "gpx-track.c"
		GList* _tmp71_;
		GpxTrack* _tmp72_;
		GList* _tmp73_;
		gconstpointer _tmp74_;
		GList* _tmp75_;
		GList* _tmp76_;
#line 312 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp71_ = iter;
#line 312 "../gpx-viewer/libgpx/gpx-track.vala"
		if (!(_tmp71_ != NULL)) {
#line 312 "../gpx-viewer/libgpx/gpx-track.vala"
			break;
#line 1711 "gpx-track.c"
		}
#line 314 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp72_ = retv;
#line 314 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp73_ = iter;
#line 314 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp74_ = _tmp73_->data;
#line 314 "../gpx-viewer/libgpx/gpx-track.vala"
		gpx_track_add_point (_tmp72_, (GpxPoint*) _tmp74_);
#line 315 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp75_ = iter;
#line 315 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp76_ = _tmp75_->next;
#line 315 "../gpx-viewer/libgpx/gpx-track.vala"
		iter = _tmp76_;
#line 1727 "gpx-track.c"
	}
#line 317 "../gpx-viewer/libgpx/gpx-track.vala"
	result = retv;
#line 317 "../gpx-viewer/libgpx/gpx-track.vala"
	(list_copy == NULL) ? NULL : (list_copy = (g_list_free (list_copy), NULL));
#line 317 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 1735 "gpx-track.c"
}

/**
         * Calculate the speed of the full track
         *
         * @returns the average speed of the full track in km/h.
         */
gdouble
gpx_track_get_track_average (GpxTrack* self)
{
	GList* first = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* last = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	gdouble result;
#line 329 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->points;
#line 329 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = g_list_first (_tmp0_);
#line 329 "../gpx-viewer/libgpx/gpx-track.vala"
	first = _tmp1_;
#line 330 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = self->points;
#line 330 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp3_ = g_list_last (_tmp2_);
#line 330 "../gpx-viewer/libgpx/gpx-track.vala"
	last = _tmp3_;
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp5_ = first;
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp5_ != NULL) {
#line 1771 "gpx-track.c"
		GList* _tmp6_;
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp6_ = last;
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp4_ = _tmp6_ != NULL;
#line 1777 "gpx-track.c"
	} else {
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp4_ = FALSE;
#line 1781 "gpx-track.c"
	}
#line 331 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp4_) {
#line 1785 "gpx-track.c"
		GList* _tmp7_;
		gconstpointer _tmp8_;
		GList* _tmp9_;
		gconstpointer _tmp10_;
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp7_ = first;
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp8_ = _tmp7_->data;
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp9_ = last;
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp10_ = _tmp9_->data;
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		result = gpx_track_calculate_point_to_point_speed (self, (GpxPoint*) _tmp8_, (GpxPoint*) _tmp10_);
#line 333 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 1802 "gpx-track.c"
	}
#line 335 "../gpx-viewer/libgpx/gpx-track.vala"
	result = (gdouble) 0;
#line 335 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 1808 "gpx-track.c"
}

/**
         * Calculate the average speed between Point a and Point b on the track
         */
gdouble
gpx_track_calculate_point_to_point_speed (GpxTrack* self,
                                          GpxPoint* a,
                                          GpxPoint* b)
{
	gdouble dist = 0.0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	time_t ta = 0;
	time_t tb = 0;
	gdouble speed = 0.0;
	gdouble result;
#line 343 "../gpx-viewer/libgpx/gpx-track.vala"
	dist = b->distance - a->distance;
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = a->time;
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp1_ == NULL) {
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = TRUE;
#line 1834 "gpx-track.c"
	} else {
		const gchar* _tmp2_;
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp2_ = b->time;
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1841 "gpx-track.c"
	}
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp0_) {
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (gdouble) 0;
#line 344 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 1849 "gpx-track.c"
	}
#line 345 "../gpx-viewer/libgpx/gpx-track.vala"
	ta = gpx_point_get_time (a);
#line 346 "../gpx-viewer/libgpx/gpx-track.vala"
	tb = gpx_point_get_time (b);
#line 347 "../gpx-viewer/libgpx/gpx-track.vala"
	if ((tb - ta) == ((time_t) 0)) {
#line 347 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (gdouble) 0;
#line 347 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 1861 "gpx-track.c"
	}
#line 348 "../gpx-viewer/libgpx/gpx-track.vala"
	speed = ((60.0 * 60.0) * dist) / (tb - ta);
#line 349 "../gpx-viewer/libgpx/gpx-track.vala"
	result = speed;
#line 349 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 1869 "gpx-track.c"
}

time_t
gpx_track_get_total_time (GpxTrack* self)
{
	GpxPoint* a = NULL;
	GpxPoint* b = NULL;
	GList* na = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* nb = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GpxPoint* _tmp9_;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	GpxPoint* _tmp12_;
	time_t time = 0;
	GpxPoint* _tmp13_;
	GpxPoint* _tmp14_;
	time_t result;
#line 354 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->points;
#line 354 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = g_list_first (_tmp0_);
#line 354 "../gpx-viewer/libgpx/gpx-track.vala"
	na = _tmp1_;
#line 355 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = self->points;
#line 355 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp3_ = g_list_last (_tmp2_);
#line 355 "../gpx-viewer/libgpx/gpx-track.vala"
	nb = _tmp3_;
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp5_ = na;
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp5_ == NULL) {
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp4_ = TRUE;
#line 1913 "gpx-track.c"
	} else {
		GList* _tmp6_;
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp6_ = nb;
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 1920 "gpx-track.c"
	}
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp4_) {
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (time_t) 0;
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		_gpx_point_unref0 (b);
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		_gpx_point_unref0 (a);
#line 356 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 1932 "gpx-track.c"
	}
#line 357 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp7_ = na;
#line 357 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp8_ = _tmp7_->data;
#line 357 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp9_ = _gpx_point_ref0 ((GpxPoint*) _tmp8_);
#line 357 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (a);
#line 357 "../gpx-viewer/libgpx/gpx-track.vala"
	a = _tmp9_;
#line 358 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp10_ = nb;
#line 358 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp11_ = _tmp10_->data;
#line 358 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp12_ = _gpx_point_ref0 ((GpxPoint*) _tmp11_);
#line 358 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (b);
#line 358 "../gpx-viewer/libgpx/gpx-track.vala"
	b = _tmp12_;
#line 359 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp13_ = b;
#line 359 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp14_ = a;
#line 359 "../gpx-viewer/libgpx/gpx-track.vala"
	time = gpx_point_get_time (_tmp13_) - gpx_point_get_time (_tmp14_);
#line 360 "../gpx-viewer/libgpx/gpx-track.vala"
	result = time;
#line 360 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (b);
#line 360 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (a);
#line 360 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 1968 "gpx-track.c"
}

/**
         * Try not to calculate time that we "stopped"  in average
         */
gdouble
gpx_track_calculate_moving_average (GpxTrack* self,
                                    GpxPoint* start,
                                    GpxPoint* stop,
                                    time_t* moving_time)
{
	time_t _vala_moving_time = 0;
	gdouble time = 0.0;
	gdouble distance = 0.0;
	GList* iter = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gdouble result;
#line 367 "../gpx-viewer/libgpx/gpx-track.vala"
	time = (gdouble) 0;
#line 368 "../gpx-viewer/libgpx/gpx-track.vala"
	distance = (gdouble) 0;
#line 369 "../gpx-viewer/libgpx/gpx-track.vala"
	_vala_moving_time = (time_t) 0;
#line 370 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->points;
#line 370 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = g_list_find (_tmp0_, start);
#line 370 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp1_;
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = iter;
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp2_ == NULL) {
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (gdouble) 0;
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
		if (moving_time) {
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
			*moving_time = _vala_moving_time;
#line 2011 "gpx-track.c"
		}
#line 371 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 2015 "gpx-track.c"
	}
#line 372 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp3_ = iter;
#line 372 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp3_ != NULL) {
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
		while (TRUE) {
#line 2023 "gpx-track.c"
			gboolean _tmp4_ = FALSE;
			GList* _tmp5_;
			GList* _tmp6_;
			GList* _tmp7_;
			GpxPoint* b = NULL;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			GpxPoint* _tmp13_;
			GpxPoint* _tmp14_;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp5_ = iter;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp6_ = _tmp5_->next;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			iter = _tmp6_;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp7_ = iter;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp7_ != NULL) {
#line 2043 "gpx-track.c"
				GList* _tmp8_;
				GList* _tmp9_;
				gconstpointer _tmp10_;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp8_ = iter;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp9_ = _tmp8_->prev;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp10_ = _tmp9_->data;
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp4_ = ((GpxPoint*) _tmp10_) != stop;
#line 2055 "gpx-track.c"
			} else {
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp4_ = FALSE;
#line 2059 "gpx-track.c"
			}
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			if (!_tmp4_) {
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
				break;
#line 2065 "gpx-track.c"
			}
#line 376 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp11_ = iter;
#line 376 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp12_ = _tmp11_->data;
#line 376 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp13_ = _gpx_point_ref0 ((GpxPoint*) _tmp12_);
#line 376 "../gpx-viewer/libgpx/gpx-track.vala"
			b = _tmp13_;
#line 378 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp14_ = b;
#line 378 "../gpx-viewer/libgpx/gpx-track.vala"
			if (!_tmp14_->stopped) {
#line 2079 "gpx-track.c"
				GpxPoint* _tmp15_;
				GList* _tmp16_;
				GList* _tmp17_;
				gconstpointer _tmp18_;
				GpxPoint* _tmp19_;
				GList* _tmp20_;
				GList* _tmp21_;
				gconstpointer _tmp22_;
#line 380 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp15_ = b;
#line 380 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp16_ = iter;
#line 380 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp17_ = _tmp16_->prev;
#line 380 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp18_ = _tmp17_->data;
#line 380 "../gpx-viewer/libgpx/gpx-track.vala"
				time += (gdouble) (gpx_point_get_time (_tmp15_) - gpx_point_get_time ((GpxPoint*) _tmp18_));
#line 381 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp19_ = b;
#line 381 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp20_ = iter;
#line 381 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp21_ = _tmp20_->prev;
#line 381 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp22_ = _tmp21_->data;
#line 381 "../gpx-viewer/libgpx/gpx-track.vala"
				distance += _tmp19_->distance - ((GpxPoint*) _tmp22_)->distance;
#line 2108 "gpx-track.c"
			}
#line 374 "../gpx-viewer/libgpx/gpx-track.vala"
			_gpx_point_unref0 (b);
#line 2112 "gpx-track.c"
		}
	}
#line 385 "../gpx-viewer/libgpx/gpx-track.vala"
	_vala_moving_time = (time_t) time;
#line 386 "../gpx-viewer/libgpx/gpx-track.vala"
	result = distance / (time / (60.0 * 60.0));
#line 386 "../gpx-viewer/libgpx/gpx-track.vala"
	if (moving_time) {
#line 386 "../gpx-viewer/libgpx/gpx-track.vala"
		*moving_time = _vala_moving_time;
#line 2123 "gpx-track.c"
	}
#line 386 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2127 "gpx-track.c"
}

void
gpx_track_calculate_total_elevation (GpxTrack* self,
                                     GpxPoint* start,
                                     GpxPoint* stop,
                                     gdouble* up,
                                     gdouble* down)
{
	gdouble _vala_up = 0.0;
	gdouble _vala_down = 0.0;
	GList* iter = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* last = NULL;
	GList* _tmp2_;
#line 391 "../gpx-viewer/libgpx/gpx-track.vala"
	_vala_up = 0.0;
#line 392 "../gpx-viewer/libgpx/gpx-track.vala"
	_vala_down = 0.0;
#line 393 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->points;
#line 393 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = g_list_find (_tmp0_, start);
#line 393 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp1_;
#line 394 "../gpx-viewer/libgpx/gpx-track.vala"
	last = NULL;
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = iter;
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp2_ == NULL) {
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
		if (up) {
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
			*up = _vala_up;
#line 2164 "gpx-track.c"
		}
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
		if (down) {
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
			*down = _vala_down;
#line 2170 "gpx-track.c"
		}
#line 395 "../gpx-viewer/libgpx/gpx-track.vala"
		return;
#line 2174 "gpx-track.c"
	}
	{
		gboolean _tmp3_ = FALSE;
#line 396 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp3_ = TRUE;
#line 396 "../gpx-viewer/libgpx/gpx-track.vala"
		while (TRUE) {
#line 2182 "gpx-track.c"
			GList* _tmp11_;
			GList* _tmp24_;
#line 396 "../gpx-viewer/libgpx/gpx-track.vala"
			if (!_tmp3_) {
#line 2187 "gpx-track.c"
				gboolean _tmp4_ = FALSE;
				GList* _tmp5_;
				GList* _tmp6_;
				GList* _tmp7_;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp5_ = iter;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp6_ = _tmp5_->next;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				iter = _tmp6_;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp7_ = iter;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp7_ != NULL) {
#line 2202 "gpx-track.c"
					GList* _tmp8_;
					GList* _tmp9_;
					gconstpointer _tmp10_;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp8_ = iter;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp9_ = _tmp8_->prev;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp10_ = _tmp9_->data;
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = ((GpxPoint*) _tmp10_) != stop;
#line 2214 "gpx-track.c"
				} else {
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = FALSE;
#line 2218 "gpx-track.c"
				}
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!_tmp4_) {
#line 405 "../gpx-viewer/libgpx/gpx-track.vala"
					break;
#line 2224 "gpx-track.c"
				}
			}
#line 396 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp3_ = FALSE;
#line 397 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp11_ = last;
#line 397 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp11_ != NULL) {
#line 2233 "gpx-track.c"
				GList* _tmp12_;
				gconstpointer _tmp13_;
				GList* _tmp14_;
				gconstpointer _tmp15_;
#line 398 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp12_ = iter;
#line 398 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp13_ = _tmp12_->data;
#line 398 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp14_ = last;
#line 398 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp15_ = _tmp14_->data;
#line 398 "../gpx-viewer/libgpx/gpx-track.vala"
				if (((GpxPoint*) _tmp13_)->smooth_elevation > ((GpxPoint*) _tmp15_)->smooth_elevation) {
#line 2248 "gpx-track.c"
					GList* _tmp16_;
					gconstpointer _tmp17_;
					GList* _tmp18_;
					gconstpointer _tmp19_;
#line 399 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp16_ = iter;
#line 399 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp17_ = _tmp16_->data;
#line 399 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp18_ = last;
#line 399 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp19_ = _tmp18_->data;
#line 399 "../gpx-viewer/libgpx/gpx-track.vala"
					_vala_up = _vala_up + (((GpxPoint*) _tmp17_)->smooth_elevation - ((GpxPoint*) _tmp19_)->smooth_elevation);
#line 2263 "gpx-track.c"
				} else {
					GList* _tmp20_;
					gconstpointer _tmp21_;
					GList* _tmp22_;
					gconstpointer _tmp23_;
#line 401 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp20_ = last;
#line 401 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp21_ = _tmp20_->data;
#line 401 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp22_ = iter;
#line 401 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp23_ = _tmp22_->data;
#line 401 "../gpx-viewer/libgpx/gpx-track.vala"
					_vala_down = _vala_down + (((GpxPoint*) _tmp21_)->smooth_elevation - ((GpxPoint*) _tmp23_)->smooth_elevation);
#line 2279 "gpx-track.c"
				}
			}
#line 404 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp24_ = iter;
#line 404 "../gpx-viewer/libgpx/gpx-track.vala"
			last = _tmp24_;
#line 2286 "gpx-track.c"
		}
	}
#line 389 "../gpx-viewer/libgpx/gpx-track.vala"
	if (up) {
#line 389 "../gpx-viewer/libgpx/gpx-track.vala"
		*up = _vala_up;
#line 2293 "gpx-track.c"
	}
#line 389 "../gpx-viewer/libgpx/gpx-track.vala"
	if (down) {
#line 389 "../gpx-viewer/libgpx/gpx-track.vala"
		*down = _vala_down;
#line 2299 "gpx-track.c"
	}
}

/**
 * @param lon_a longitude in radians of point a
 * @param lat_a latitude in radians of point a
 * @param lon_b longitude in radians of point b
 * @param lat_a latitude in radians of point b
         * Calculate distance between point a and point b using great circular distance method
         * Elevation is not taken into account.
         *
         * @returns distance in km.		 
 */
gdouble
gpx_track_calculate_distance_coords (gdouble lon_a,
                                     gdouble lat_a,
                                     gdouble ele_a,
                                     gdouble lon_b,
                                     gdouble lat_b,
                                     gdouble ele_b)
{
	gdouble retv = 0.0;
	gdouble ele = 0.0;
	gdouble result;
#line 419 "../gpx-viewer/libgpx/gpx-track.vala"
	retv = (gdouble) 0;
#line 420 "../gpx-viewer/libgpx/gpx-track.vala"
	retv = 6378.7 * acos ((sin (lat_a) * sin (lat_b)) + ((cos (lat_a) * cos (lat_b)) * cos (lon_b - lon_a)));
#line 424 "../gpx-viewer/libgpx/gpx-track.vala"
	if (isnan (retv) == 1) {
#line 426 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (gdouble) 0;
#line 426 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 2334 "gpx-track.c"
	}
#line 428 "../gpx-viewer/libgpx/gpx-track.vala"
	ele = (ele_b - ele_a) / 1000;
#line 429 "../gpx-viewer/libgpx/gpx-track.vala"
	retv = sqrt (pow (retv, (gdouble) 2) + pow (ele, (gdouble) 2));
#line 430 "../gpx-viewer/libgpx/gpx-track.vala"
	result = fabs (retv);
#line 430 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2344 "gpx-track.c"
}

/**
         * @param a the first Gpx.Point
         * @param b the second Gpx.Point
         *
         * Calculate distance between point a and point b using great circular distance method
         * Elevation is not taken into account.
         *
         * @returns distance in km.
         */
gdouble
gpx_track_calculate_distance (GpxPoint* a,
                              GpxPoint* b)
{
	gboolean _tmp0_ = FALSE;
	gdouble result;
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
	if (a->lat == b->lat) {
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = a->lon == b->lon;
#line 2366 "gpx-track.c"
	} else {
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = FALSE;
#line 2370 "gpx-track.c"
	}
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp0_) {
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (gdouble) 0;
#line 444 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 2378 "gpx-track.c"
	}
#line 445 "../gpx-viewer/libgpx/gpx-track.vala"
	result = gpx_track_calculate_distance_coords (a->lon, a->lat, a->elevation, b->lon, b->lat, b->elevation);
#line 445 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2384 "gpx-track.c"
}

guint
gpx_track_heartrate_avg (GpxTrack* self,
                         GpxPoint* start,
                         GpxPoint* stop)
{
	gdouble total = 0.0;
	gdouble total_time = 0.0;
	GpxPoint* prev = NULL;
	GList* iter = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp23_ = 0U;
	guint result;
#line 451 "../gpx-viewer/libgpx/gpx-track.vala"
	total = (gdouble) 0;
#line 452 "../gpx-viewer/libgpx/gpx-track.vala"
	total_time = 0.0;
#line 453 "../gpx-viewer/libgpx/gpx-track.vala"
	prev = NULL;
#line 454 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->points;
#line 454 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp1_ = g_list_find (_tmp0_, start);
#line 454 "../gpx-viewer/libgpx/gpx-track.vala"
	iter = _tmp1_;
#line 455 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp2_ = iter;
#line 455 "../gpx-viewer/libgpx/gpx-track.vala"
	if (_tmp2_ == NULL) {
#line 455 "../gpx-viewer/libgpx/gpx-track.vala"
		result = (guint) 0;
#line 455 "../gpx-viewer/libgpx/gpx-track.vala"
		return result;
#line 2421 "gpx-track.c"
	}
	{
		gboolean _tmp3_ = FALSE;
#line 456 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp3_ = TRUE;
#line 456 "../gpx-viewer/libgpx/gpx-track.vala"
		while (TRUE) {
#line 2429 "gpx-track.c"
			GpxPoint* p = NULL;
			GList* _tmp9_;
			gconstpointer _tmp10_;
			GpxPoint* _tmp11_;
			GpxPoint* _tmp12_;
			GpxHeartRateMonitorPoint _tmp13_;
			GList* _tmp21_;
			GList* _tmp22_;
#line 456 "../gpx-viewer/libgpx/gpx-track.vala"
			if (!_tmp3_) {
#line 2440 "gpx-track.c"
				gboolean _tmp4_ = FALSE;
				GList* _tmp5_;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp5_ = iter;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp5_ != NULL) {
#line 2447 "gpx-track.c"
					GList* _tmp6_;
					GList* _tmp7_;
					gconstpointer _tmp8_;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp6_ = iter;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp7_ = _tmp6_->prev;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp8_ = _tmp7_->data;
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = ((GpxPoint*) _tmp8_) != stop;
#line 2459 "gpx-track.c"
				} else {
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp4_ = FALSE;
#line 2463 "gpx-track.c"
				}
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
				if (!_tmp4_) {
#line 473 "../gpx-viewer/libgpx/gpx-track.vala"
					break;
#line 2469 "gpx-track.c"
				}
			}
#line 456 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp3_ = FALSE;
#line 457 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp9_ = iter;
#line 457 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp10_ = _tmp9_->data;
#line 457 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp11_ = _gpx_point_ref0 ((GpxPoint*) _tmp10_);
#line 457 "../gpx-viewer/libgpx/gpx-track.vala"
			p = _tmp11_;
#line 458 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp12_ = p;
#line 458 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp13_ = _tmp12_->tpe;
#line 458 "../gpx-viewer/libgpx/gpx-track.vala"
			if (_tmp13_.heartrate != 0) {
#line 2488 "gpx-track.c"
				GpxPoint* _tmp14_;
#line 459 "../gpx-viewer/libgpx/gpx-track.vala"
				_tmp14_ = prev;
#line 459 "../gpx-viewer/libgpx/gpx-track.vala"
				if (_tmp14_ == NULL) {
#line 2494 "gpx-track.c"
					GpxPoint* _tmp15_;
#line 460 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp15_ = p;
#line 460 "../gpx-viewer/libgpx/gpx-track.vala"
					prev = _tmp15_;
#line 2500 "gpx-track.c"
				} else {
					gdouble diff = 0.0;
					GpxPoint* _tmp16_;
					GpxPoint* _tmp17_;
					GpxPoint* _tmp20_;
#line 462 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp16_ = p;
#line 462 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp17_ = prev;
#line 462 "../gpx-viewer/libgpx/gpx-track.vala"
					diff = ((gdouble) gpx_point_get_time (_tmp16_)) - ((gdouble) gpx_point_get_time (_tmp17_));
#line 2512 "gpx-track.c"
					{
						GpxPoint* _tmp18_;
						GpxHeartRateMonitorPoint _tmp19_;
#line 465 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp18_ = prev;
#line 465 "../gpx-viewer/libgpx/gpx-track.vala"
						_tmp19_ = _tmp18_->tpe;
#line 465 "../gpx-viewer/libgpx/gpx-track.vala"
						total += _tmp19_.heartrate * diff;
#line 466 "../gpx-viewer/libgpx/gpx-track.vala"
						total_time += diff;
#line 2524 "gpx-track.c"
					}
#line 469 "../gpx-viewer/libgpx/gpx-track.vala"
					_tmp20_ = p;
#line 469 "../gpx-viewer/libgpx/gpx-track.vala"
					prev = _tmp20_;
#line 2530 "gpx-track.c"
				}
			}
#line 472 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp21_ = iter;
#line 472 "../gpx-viewer/libgpx/gpx-track.vala"
			_tmp22_ = _tmp21_->next;
#line 472 "../gpx-viewer/libgpx/gpx-track.vala"
			iter = _tmp22_;
#line 456 "../gpx-viewer/libgpx/gpx-track.vala"
			_gpx_point_unref0 (p);
#line 2541 "gpx-track.c"
		}
	}
#line 474 "../gpx-viewer/libgpx/gpx-track.vala"
	if (total_time > ((gdouble) 0)) {
#line 474 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp23_ = (guint) (total / total_time);
#line 2548 "gpx-track.c"
	} else {
#line 474 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp23_ = (guint) 0;
#line 2552 "gpx-track.c"
	}
#line 474 "../gpx-viewer/libgpx/gpx-track.vala"
	result = _tmp23_;
#line 474 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2558 "gpx-track.c"
}

guint
gpx_track_get_burned_calories (GpxTrack* self)
{
	GpxHeartRateMonitorTrack _tmp0_;
	guint result;
#line 479 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->hrmt;
#line 479 "../gpx-viewer/libgpx/gpx-track.vala"
	result = (guint) _tmp0_.calories;
#line 479 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2572 "gpx-track.c"
}

void
gpx_track_set_burned_calories (GpxTrack* self,
                               guint value)
{
#line 483 "../gpx-viewer/libgpx/gpx-track.vala"
	self->hrmt.calories = (guint32) value;
#line 2581 "gpx-track.c"
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
#line 5234 "glib-2.0.vapi"
	l = self;
#line 5235 "glib-2.0.vapi"
	while (TRUE) {
#line 2595 "gpx-track.c"
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
#line 5235 "glib-2.0.vapi"
		_tmp0_ = l;
#line 5235 "glib-2.0.vapi"
		if (!(_tmp0_ != NULL)) {
#line 5235 "glib-2.0.vapi"
			break;
#line 2605 "gpx-track.c"
		}
#line 5236 "glib-2.0.vapi"
		_tmp1_ = l;
#line 5236 "glib-2.0.vapi"
		_tmp2_ = ((GList*) _tmp1_)->data;
#line 5236 "glib-2.0.vapi"
		if (_tmp2_ != data) {
#line 2613 "gpx-track.c"
			GList* _tmp3_;
			GList* _tmp4_;
#line 5237 "glib-2.0.vapi"
			_tmp3_ = l;
#line 5237 "glib-2.0.vapi"
			_tmp4_ = ((GList*) _tmp3_)->next;
#line 5237 "glib-2.0.vapi"
			l = _tmp4_;
#line 2622 "gpx-track.c"
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
#line 5239 "glib-2.0.vapi"
			_tmp5_ = l;
#line 5239 "glib-2.0.vapi"
			_tmp6_ = ((GList*) _tmp5_)->data;
#line 5239 "glib-2.0.vapi"
			func (_tmp6_);
#line 5240 "glib-2.0.vapi"
			_tmp7_ = l;
#line 5240 "glib-2.0.vapi"
			self = g_list_delete_link (self, (GList*) _tmp7_);
#line 5241 "glib-2.0.vapi"
			break;
#line 2639 "gpx-track.c"
		}
	}
#line 5244 "glib-2.0.vapi"
	result = self;
#line 5244 "glib-2.0.vapi"
	return result;
#line 2646 "gpx-track.c"
}

void
gpx_track_remove_point (GpxTrack* self,
                        GpxPoint* point,
                        gboolean update)
{
#line 490 "../gpx-viewer/libgpx/gpx-track.vala"
	self->points = vala_g_list_remove_full (self->points, point, _gpx_point_unref0_);
#line 491 "../gpx-viewer/libgpx/gpx-track.vala"
	if (update) {
#line 492 "../gpx-viewer/libgpx/gpx-track.vala"
		gpx_track_recalculate (self);
#line 493 "../gpx-viewer/libgpx/gpx-track.vala"
		g_signal_emit (self, gpx_track_signals[GPX_TRACK_POINT_REMOVED_SIGNAL], 0, point);
#line 2662 "gpx-track.c"
	}
}

GpxTrack*
gpx_track_construct (GType object_type)
{
	GpxTrack * self = NULL;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	self = (GpxTrack*) g_object_new (object_type, NULL);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	return self;
#line 2674 "gpx-track.c"
}

GpxTrack*
gpx_track_new (void)
{
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	return gpx_track_construct (GPX_TYPE_TRACK);
#line 2682 "gpx-track.c"
}

const gchar*
gpx_track_get_name (GpxTrack* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->priv->_name;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	result = _tmp0_;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2696 "gpx-track.c"
}

void
gpx_track_set_name (GpxTrack* self,
                    const gchar* value)
{
	gchar* old_value;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	old_value = gpx_track_get_name (self);
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2708 "gpx-track.c"
		gchar* _tmp0_;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = g_strdup (value);
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
		_g_free0 (self->priv->_name);
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
		self->priv->_name = _tmp0_;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
		g_object_notify_by_pspec ((GObject *) self, gpx_track_properties[GPX_TRACK_NAME_PROPERTY]);
#line 2718 "gpx-track.c"
	}
}

const gchar*
gpx_track_get_track_type (GpxTrack* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->priv->_track_type;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	result = _tmp0_;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2733 "gpx-track.c"
}

void
gpx_track_set_track_type (GpxTrack* self,
                          const gchar* value)
{
	gchar* old_value;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	old_value = gpx_track_get_track_type (self);
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2745 "gpx-track.c"
		gchar* _tmp0_;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
		_tmp0_ = g_strdup (value);
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
		_g_free0 (self->priv->_track_type);
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
		self->priv->_track_type = _tmp0_;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
		g_object_notify_by_pspec ((GObject *) self, gpx_track_properties[GPX_TRACK_TRACK_TYPE_PROPERTY]);
#line 2755 "gpx-track.c"
	}
}

gint*
gpx_track_get_number (GpxTrack* self)
{
	gint* result;
	gint* _tmp0_;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = self->priv->_number;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	result = _tmp0_;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2770 "gpx-track.c"
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	dup = g_new0 (gint, 1);
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	memcpy (dup, self, sizeof (gint));
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	return dup;
#line 2783 "gpx-track.c"
}

static gpointer
__int_dup0 (gpointer self)
{
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	return self ? _int_dup (self) : NULL;
#line 2791 "gpx-track.c"
}

void
gpx_track_set_number (GpxTrack* self,
                      gint* value)
{
	gint* _tmp0_;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_ = __int_dup0 (value);
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	_g_free0 (self->priv->_number);
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->_number = _tmp0_;
#line 2805 "gpx-track.c"
}

gboolean
gpx_track_get_is_route (GpxTrack* self)
{
	gboolean result;
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
	result = self->priv->_is_route;
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
	return result;
#line 2816 "gpx-track.c"
}

void
gpx_track_set_is_route (GpxTrack* self,
                        gboolean value)
{
	gboolean old_value;
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
	old_value = gpx_track_get_is_route (self);
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
	if (old_value != value) {
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
		self->priv->_is_route = value;
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
		g_object_notify_by_pspec ((GObject *) self, gpx_track_properties[GPX_TRACK_IS_ROUTE_PROPERTY]);
#line 2832 "gpx-track.c"
	}
}

static void
g_cclosure_user_marshal_VOID__GPX_POINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__GPX_POINT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GPX_POINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	g_return_if_fail (n_param_values == 2);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		data1 = closure->data;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		data2 = param_values->data[0].v_pointer;
#line 2858 "gpx-track.c"
	} else {
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		data1 = param_values->data[0].v_pointer;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		data2 = closure->data;
#line 2864 "gpx-track.c"
	}
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	callback = (GMarshalFunc_VOID__GPX_POINT) (marshal_data ? marshal_data : cc->callback);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	callback (data1, gpx_value_get_point (param_values + 1), data2);
#line 2870 "gpx-track.c"
}

static void
gpx_track_class_init (GpxTrackClass * klass,
                      gpointer klass_data)
{
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	gpx_track_parent_class = g_type_class_peek_parent (klass);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	g_type_class_adjust_private_offset (klass, &GpxTrack_private_offset);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_track_get_property;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_track_set_property;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_track_finalize;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_TRACK_NAME_PROPERTY, gpx_track_properties[GPX_TRACK_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_TRACK_TRACK_TYPE_PROPERTY, gpx_track_properties[GPX_TRACK_TRACK_TYPE_PROPERTY] = g_param_spec_string ("track-type", "track-type", "track-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_TRACK_IS_ROUTE_PROPERTY, gpx_track_properties[GPX_TRACK_IS_ROUTE_PROPERTY] = g_param_spec_boolean ("is-route", "is-route", "is-route", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	gpx_track_signals[GPX_TRACK_POINT_REMOVED_SIGNAL] = g_signal_new ("point-removed", GPX_TYPE_TRACK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__GPX_POINT, G_TYPE_NONE, 1, GPX_TYPE_POINT);
#line 2895 "gpx-track.c"
}

static void
gpx_track_instance_init (GpxTrack * self,
                         gpointer klass)
{
	GpxHeartRateMonitorTrack _tmp0_ = {0};
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv = gpx_track_get_instance_private (self);
#line 34 "../gpx-viewer/libgpx/gpx-track.vala"
	memset (&_tmp0_, 0, sizeof (GpxHeartRateMonitorTrack));
#line 34 "../gpx-viewer/libgpx/gpx-track.vala"
	_tmp0_.calories = (guint32) 0;
#line 34 "../gpx-viewer/libgpx/gpx-track.vala"
	self->hrmt = _tmp0_;
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->_name = NULL;
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->_track_type = NULL;
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->_number = NULL;
#line 39 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->_is_route = FALSE;
#line 41 "../gpx-viewer/libgpx/gpx-track.vala"
	self->filtered_points = 0;
#line 45 "../gpx-viewer/libgpx/gpx-track.vala"
	self->total_distance = 0.0;
#line 46 "../gpx-viewer/libgpx/gpx-track.vala"
	self->max_speed = 0.0;
#line 47 "../gpx-viewer/libgpx/gpx-track.vala"
	self->max_elevation = 0.0;
#line 48 "../gpx-viewer/libgpx/gpx-track.vala"
	self->min_elevation = 0.0;
#line 51 "../gpx-viewer/libgpx/gpx-track.vala"
	self->points = NULL;
#line 54 "../gpx-viewer/libgpx/gpx-track.vala"
	self->priv->last = NULL;
#line 58 "../gpx-viewer/libgpx/gpx-track.vala"
	self->top = NULL;
#line 59 "../gpx-viewer/libgpx/gpx-track.vala"
	self->bottom = NULL;
#line 2937 "gpx-track.c"
}

static void
gpx_track_finalize (GObject * obj)
{
	GpxTrack * self;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_TRACK, GpxTrack);
#line 36 "../gpx-viewer/libgpx/gpx-track.vala"
	_g_free0 (self->priv->_name);
#line 37 "../gpx-viewer/libgpx/gpx-track.vala"
	_g_free0 (self->priv->_track_type);
#line 38 "../gpx-viewer/libgpx/gpx-track.vala"
	_g_free0 (self->priv->_number);
#line 51 "../gpx-viewer/libgpx/gpx-track.vala"
	(self->points == NULL) ? NULL : (self->points = (_g_list_free__gpx_point_unref0_ (self->points), NULL));
#line 54 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (self->priv->last);
#line 58 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (self->top);
#line 59 "../gpx-viewer/libgpx/gpx-track.vala"
	_gpx_point_unref0 (self->bottom);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	G_OBJECT_CLASS (gpx_track_parent_class)->finalize (obj);
#line 2962 "gpx-track.c"
}

/**
     * This class represents a Track in a gpx file.
     * The tracks contains the points connecting everything together.
     * Info like total distance, average speed, moving speed/time etc are available.
     */
static GType
gpx_track_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxTrackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_track_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxTrack), 0, (GInstanceInitFunc) gpx_track_instance_init, NULL };
	GType gpx_track_type_id;
	gpx_track_type_id = g_type_register_static (G_TYPE_OBJECT, "GpxTrack", &g_define_type_info, 0);
	GpxTrack_private_offset = g_type_add_instance_private (gpx_track_type_id, sizeof (GpxTrackPrivate));
	return gpx_track_type_id;
}

GType
gpx_track_get_type (void)
{
	static volatile gsize gpx_track_type_id__once = 0;
	if (g_once_init_enter (&gpx_track_type_id__once)) {
		GType gpx_track_type_id;
		gpx_track_type_id = gpx_track_get_type_once ();
		g_once_init_leave (&gpx_track_type_id__once, gpx_track_type_id);
	}
	return gpx_track_type_id__once;
}

static void
_vala_gpx_track_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GpxTrack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_TRACK, GpxTrack);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	switch (property_id) {
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_NAME_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		g_value_set_string (value, gpx_track_get_name (self));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_TRACK_TYPE_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		g_value_set_string (value, gpx_track_get_track_type (self));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_IS_ROUTE_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		g_value_set_boolean (value, gpx_track_get_is_route (self));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 3020 "gpx-track.c"
		default:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 3026 "gpx-track.c"
	}
}

static void
_vala_gpx_track_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GpxTrack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_TYPE_TRACK, GpxTrack);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
	switch (property_id) {
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_NAME_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		gpx_track_set_name (self, g_value_get_string (value));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_TRACK_TYPE_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		gpx_track_set_track_type (self, g_value_get_string (value));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		case GPX_TRACK_IS_ROUTE_PROPERTY:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		gpx_track_set_is_route (self, g_value_get_boolean (value));
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 3058 "gpx-track.c"
		default:
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "../gpx-viewer/libgpx/gpx-track.vala"
		break;
#line 3064 "gpx-track.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

