/* gpx-track-treemodel.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-track-treemodel.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define _XOPEN_SOURCE

#include "gpx.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_TRACK_TREE_MODEL_0_PROPERTY,
	GPX_TRACK_TREE_MODEL_NUM_PROPERTIES
};
static GParamSpec* gpx_track_tree_model_properties[GPX_TRACK_TREE_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GpxTrackTreeModelPrivate {
	GType* ColumnType;
	gint ColumnType_length1;
	gint _ColumnType_size_;
	gint stamp;
	GpxTrack* track;
};

static gint GpxTrackTreeModel_private_offset;
static gpointer gpx_track_tree_model_parent_class = NULL;
static GtkTreeModelIface * gpx_track_tree_model_gtk_tree_model_parent_iface = NULL;

static GType gpx_track_tree_model_real_get_column_type (GtkTreeModel* base,
                                                 gint index_);
static gboolean gpx_track_tree_model_real_get_iter (GtkTreeModel* base,
                                             GtkTreeIter* iter,
                                             GtkTreePath* path);
static gint gpx_track_tree_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* gpx_track_tree_model_real_get_path (GtkTreeModel* base,
                                                 GtkTreeIter* iter);
static void gpx_track_tree_model_real_get_value (GtkTreeModel* base,
                                          GtkTreeIter* iter,
                                          gint column,
                                          GValue* value);
static gboolean gpx_track_tree_model_real_iter_children (GtkTreeModel* base,
                                                  GtkTreeIter* iter,
                                                  GtkTreeIter* parent);
static gboolean gpx_track_tree_model_real_iter_has_child (GtkTreeModel* base,
                                                   GtkTreeIter* iter);
static gint gpx_track_tree_model_real_iter_n_children (GtkTreeModel* base,
                                                GtkTreeIter* iter);
static GtkTreeModelFlags gpx_track_tree_model_real_get_flags (GtkTreeModel* base);
static gboolean gpx_track_tree_model_real_iter_next (GtkTreeModel* base,
                                              GtkTreeIter* iter);
static gboolean gpx_track_tree_model_real_iter_nth_child (GtkTreeModel* base,
                                                   GtkTreeIter* iter,
                                                   GtkTreeIter* parent,
                                                   gint n);
static gboolean gpx_track_tree_model_real_iter_parent (GtkTreeModel* base,
                                                GtkTreeIter* iter,
                                                GtkTreeIter* child);
static void gpx_track_tree_model_real_ref_node (GtkTreeModel* base,
                                         GtkTreeIter* iter);
static void gpx_track_tree_model_real_unref_node (GtkTreeModel* base,
                                           GtkTreeIter* iter);
static void gpx_track_tree_model_finalize (GObject * obj);
static GType gpx_track_tree_model_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gpx_track_tree_model_get_instance_private (GpxTrackTreeModel* self)
{
	return G_STRUCT_MEMBER_P (self, GpxTrackTreeModel_private_offset);
}

static GType
gpx_track_tree_model_column_get_type_once (void)
{
	static const GEnumValue values[] = {{GPX_TRACK_TREE_MODEL_COLUMN_TIME, "GPX_TRACK_TREE_MODEL_COLUMN_TIME", "time"}, {GPX_TRACK_TREE_MODEL_COLUMN_DISTANCE, "GPX_TRACK_TREE_MODEL_COLUMN_DISTANCE", "distance"}, {GPX_TRACK_TREE_MODEL_COLUMN_ELEVATION, "GPX_TRACK_TREE_MODEL_COLUMN_ELEVATION", "elevation"}, {GPX_TRACK_TREE_MODEL_COLUMN_SPEED, "GPX_TRACK_TREE_MODEL_COLUMN_SPEED", "speed"}, {GPX_TRACK_TREE_MODEL_COLUMN_NUM_COLUMNS, "GPX_TRACK_TREE_MODEL_COLUMN_NUM_COLUMNS", "num-columns"}, {0, NULL, NULL}};
	GType gpx_track_tree_model_column_type_id;
	gpx_track_tree_model_column_type_id = g_enum_register_static ("GpxTrackTreeModelColumn", values);
	return gpx_track_tree_model_column_type_id;
}

GType
gpx_track_tree_model_column_get_type (void)
{
	static volatile gsize gpx_track_tree_model_column_type_id__once = 0;
	if (g_once_init_enter (&gpx_track_tree_model_column_type_id__once)) {
		GType gpx_track_tree_model_column_type_id;
		gpx_track_tree_model_column_type_id = gpx_track_tree_model_column_get_type_once ();
		g_once_init_leave (&gpx_track_tree_model_column_type_id__once, gpx_track_tree_model_column_type_id);
	}
	return gpx_track_tree_model_column_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 44 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return self ? g_object_ref (self) : NULL;
#line 140 "gpx-track-treemodel.c"
}

GpxTrackTreeModel*
gpx_track_tree_model_construct (GType object_type,
                                GpxTrack* track)
{
	GpxTrackTreeModel * self = NULL;
	GpxTrack* _tmp0_;
#line 42 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) g_object_new (object_type, NULL);
#line 44 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = _g_object_ref0 (track);
#line 44 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_g_object_unref0 (self->priv->track);
#line 44 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->track = _tmp0_;
#line 42 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return self;
#line 159 "gpx-track-treemodel.c"
}

GpxTrackTreeModel*
gpx_track_tree_model_new (GpxTrack* track)
{
#line 42 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return gpx_track_tree_model_construct (GPX_TYPE_TRACK_TREE_MODEL, track);
#line 167 "gpx-track-treemodel.c"
}

static GType
gpx_track_tree_model_real_get_column_type (GtkTreeModel* base,
                                           gint index_)
{
	GpxTrackTreeModel * self;
	GType* _tmp0_;
	gint _tmp0__length1;
	GType _tmp1_;
	GType result;
#line 47 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 49 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = self->priv->ColumnType;
#line 49 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0__length1 = self->priv->ColumnType_length1;
#line 49 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp1_ = _tmp0_[index_];
#line 49 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = _tmp1_;
#line 49 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 191 "gpx-track-treemodel.c"
}

static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 199 "gpx-track-treemodel.c"
}

static gboolean
gpx_track_tree_model_real_get_iter (GtkTreeModel* base,
                                    GtkTreeIter* iter,
                                    GtkTreePath* path)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _vala_iter = {0};
	gint depth = 0;
	gint n = 0;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	GpxPoint* p = NULL;
	GpxTrack* _tmp6_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GpxPoint* _tmp9_;
	gboolean result;
#line 52 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 54 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 55 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	depth = gtk_tree_path_get_depth (path);
#line 56 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (depth == 1, "depth == 1");
#line 57 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
#line 57 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp2_ = _tmp1_[0];
#line 57 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	n = _tmp2_;
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (n >= 0) {
#line 237 "gpx-track-treemodel.c"
		GpxTrack* _tmp4_;
		GList* _tmp5_;
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp4_ = self->priv->track;
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp5_ = _tmp4_->points;
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp3_ = n < ((gint) g_list_length (_tmp5_));
#line 246 "gpx-track-treemodel.c"
	} else {
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp3_ = FALSE;
#line 250 "gpx-track-treemodel.c"
	}
#line 58 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (_tmp3_, "n >= 0 && n < (int)this.track.points.length ()");
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp6_ = self->priv->track;
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp7_ = _tmp6_->points;
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) n);
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp9_ = _gpx_point_ref0 ((GpxPoint*) _tmp8_);
#line 59 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	p = _tmp9_;
#line 60 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.stamp = self->priv->stamp;
#line 61 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.user_data = p;
#line 62 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.user_data2 = NULL;
#line 63 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.user_data3 = NULL;
#line 64 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = TRUE;
#line 64 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_gpx_point_unref0 (p);
#line 64 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (iter) {
#line 64 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		*iter = _vala_iter;
#line 280 "gpx-track-treemodel.c"
	}
#line 64 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 284 "gpx-track-treemodel.c"
}

static gint
gpx_track_tree_model_real_get_n_columns (GtkTreeModel* base)
{
	GpxTrackTreeModel * self;
	gint result;
#line 67 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 69 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = (gint) GPX_TRACK_TREE_MODEL_COLUMN_NUM_COLUMNS;
#line 69 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 298 "gpx-track-treemodel.c"
}

/**
         * Given an iter, returns a path
         */
static GtkTreePath*
gpx_track_tree_model_real_get_path (GtkTreeModel* base,
                                    GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GpxPoint* p = NULL;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	GpxPoint* _tmp4_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp5_;
	gint pos = 0;
	GpxTrack* _tmp6_;
	GList* _tmp7_;
	GtkTreePath* result;
#line 75 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 76 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = *iter;
#line 76 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp1_ = _tmp0_.user_data;
#line 76 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (_tmp1_ != NULL, "iter.user_data != null");
#line 77 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp2_ = *iter;
#line 77 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp3_ = _tmp2_.user_data;
#line 77 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp4_ = _gpx_point_ref0 (GPX_IS_POINT (_tmp3_) ? ((GpxPoint*) _tmp3_) : NULL);
#line 77 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	p = _tmp4_;
#line 79 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp5_ = gtk_tree_path_new ();
#line 79 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	path = _tmp5_;
#line 80 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp6_ = self->priv->track;
#line 80 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp7_ = _tmp6_->points;
#line 80 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	pos = g_list_index (_tmp7_, p);
#line 81 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (pos != -1, "pos != -1");
#line 82 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	gtk_tree_path_append_index (path, pos);
#line 83 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = path;
#line 83 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_gpx_point_unref0 (p);
#line 83 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 357 "gpx-track-treemodel.c"
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 3317 "glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 3317 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 3318 "glib-2.0.vapi"
	*result = _result_;
#line 3318 "glib-2.0.vapi"
	return;
#line 374 "gpx-track-treemodel.c"
}

static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gchar* result;
#line 3326 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 3326 "glib-2.0.vapi"
	buffer = _tmp0_;
#line 3326 "glib-2.0.vapi"
	buffer_length1 = 64;
#line 3326 "glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 3327 "glib-2.0.vapi"
	strftime (buffer, (gint) buffer_length1, format, &(*self));
#line 3328 "glib-2.0.vapi"
	_tmp1_ = g_strdup ((const gchar*) buffer);
#line 3328 "glib-2.0.vapi"
	result = _tmp1_;
#line 3328 "glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 3328 "glib-2.0.vapi"
	return result;
#line 405 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_real_get_value (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     gint column,
                                     GValue* value)
{
	GpxTrackTreeModel * self;
	GValue _vala_value = {0};
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GpxPoint* p = NULL;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	GpxPoint* _tmp4_;
	GValue _tmp5_ = {0};
#line 85 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 87 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = *iter;
#line 87 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp1_ = _tmp0_.user_data;
#line 87 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (_tmp1_ != NULL, "iter.user_data != null");
#line 88 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp2_ = *iter;
#line 88 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp3_ = _tmp2_.user_data;
#line 88 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp4_ = _gpx_point_ref0 (GPX_IS_POINT (_tmp3_) ? ((GpxPoint*) _tmp3_) : NULL);
#line 88 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	p = _tmp4_;
#line 89 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	g_value_init (&_tmp5_, gtk_tree_model_get_column_type ((GtkTreeModel*) self, column));
#line 89 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 89 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_value = _tmp5_;
#line 90 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	switch (column) {
#line 90 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		case GPX_TRACK_TREE_MODEL_COLUMN_TIME:
#line 449 "gpx-track-treemodel.c"
		{
			struct tm t = {0};
			GpxPoint* _tmp6_;
			struct tm _tmp7_ = {0};
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 92 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp6_ = p;
#line 92 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			g_time_local (gpx_point_get_time (_tmp6_), &_tmp7_);
#line 92 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			t = _tmp7_;
#line 93 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp8_ = g_time_format (&t, "%D - %X");
#line 93 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp9_ = _tmp8_;
#line 93 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			g_value_set_string (&_vala_value, _tmp9_);
#line 93 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_g_free0 (_tmp9_);
#line 94 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			break;
#line 472 "gpx-track-treemodel.c"
		}
#line 90 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		case GPX_TRACK_TREE_MODEL_COLUMN_DISTANCE:
#line 476 "gpx-track-treemodel.c"
		{
			GpxPoint* _tmp10_;
#line 96 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp10_ = p;
#line 96 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			g_value_set_double (&_vala_value, _tmp10_->distance);
#line 97 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			break;
#line 485 "gpx-track-treemodel.c"
		}
#line 90 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		case GPX_TRACK_TREE_MODEL_COLUMN_ELEVATION:
#line 489 "gpx-track-treemodel.c"
		{
			GpxPoint* _tmp11_;
#line 99 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp11_ = p;
#line 99 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			g_value_set_double (&_vala_value, _tmp11_->elevation);
#line 100 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			break;
#line 498 "gpx-track-treemodel.c"
		}
#line 90 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		case GPX_TRACK_TREE_MODEL_COLUMN_SPEED:
#line 502 "gpx-track-treemodel.c"
		{
			GpxPoint* _tmp12_;
#line 102 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			_tmp12_ = p;
#line 102 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			g_value_set_double (&_vala_value, _tmp12_->speed);
#line 103 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			break;
#line 511 "gpx-track-treemodel.c"
		}
		default:
		{
#line 105 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			break;
#line 517 "gpx-track-treemodel.c"
		}
	}
#line 85 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_gpx_point_unref0 (p);
#line 85 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (value) {
#line 85 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		*value = _vala_value;
#line 526 "gpx-track-treemodel.c"
	} else {
#line 85 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 530 "gpx-track-treemodel.c"
	}
}

/**
         * Should never be reached since iter_has_child is never true
         */
static gboolean
gpx_track_tree_model_real_iter_children (GtkTreeModel* base,
                                         GtkTreeIter* iter,
                                         GtkTreeIter* parent)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result;
#line 111 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 112 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 113 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = FALSE;
#line 113 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (iter) {
#line 113 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		*iter = _vala_iter;
#line 555 "gpx-track-treemodel.c"
	}
#line 113 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 559 "gpx-track-treemodel.c"
}

/**
         * always false since this is a list
         */
static gboolean
gpx_track_tree_model_real_iter_has_child (GtkTreeModel* base,
                                          GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
	gboolean result;
#line 119 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 120 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = FALSE;
#line 120 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 577 "gpx-track-treemodel.c"
}

/**
         * Number of children for an iter: treated only the special case,
         * where iter == null, returns the number of elements in the list
         */
static gint
gpx_track_tree_model_real_iter_n_children (GtkTreeModel* base,
                                           GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
	gint result;
#line 127 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 128 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (iter == NULL) {
#line 594 "gpx-track-treemodel.c"
		guint n_children = 0U;
		GpxTrack* _tmp0_;
		GList* _tmp1_;
#line 129 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp0_ = self->priv->track;
#line 129 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp1_ = _tmp0_->points;
#line 129 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		n_children = g_list_length (_tmp1_);
#line 130 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		result = (gint) n_children;
#line 130 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		return result;
#line 608 "gpx-track-treemodel.c"
	} else {
#line 132 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		result = 0;
#line 132 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		return result;
#line 614 "gpx-track-treemodel.c"
	}
}

static GtkTreeModelFlags
gpx_track_tree_model_real_get_flags (GtkTreeModel* base)
{
	GpxTrackTreeModel * self;
	GtkTreeModelFlags flags = 0U;
	GtkTreeModelFlags result;
#line 135 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 136 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	flags = GTK_TREE_MODEL_LIST_ONLY | GTK_TREE_MODEL_ITERS_PERSIST;
#line 137 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = flags;
#line 137 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 632 "gpx-track-treemodel.c"
}

/**
         * Given an iter, modify it to point to the next file
         */
static gboolean
gpx_track_tree_model_real_iter_next (GtkTreeModel* base,
                                     GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GpxPoint* p = NULL;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	GpxPoint* _tmp4_;
	GList* node = NULL;
	GpxTrack* _tmp5_;
	GList* _tmp6_;
	GpxPoint* _tmp7_;
	GList* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GList* _tmp10_;
	gboolean result;
#line 142 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 143 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = *iter;
#line 143 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp1_ = _tmp0_.user_data;
#line 143 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_assert (_tmp1_ != NULL, "iter.user_data != null");
#line 144 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp2_ = *iter;
#line 144 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp3_ = _tmp2_.user_data;
#line 144 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp4_ = _gpx_point_ref0 (GPX_IS_POINT (_tmp3_) ? ((GpxPoint*) _tmp3_) : NULL);
#line 144 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	p = _tmp4_;
#line 145 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp5_ = self->priv->track;
#line 145 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp6_ = _tmp5_->points;
#line 145 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp7_ = p;
#line 145 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp8_ = g_list_find (_tmp6_, _tmp7_);
#line 145 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	node = _tmp8_;
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp10_ = node;
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (_tmp10_ != NULL) {
#line 687 "gpx-track-treemodel.c"
		GList* _tmp11_;
		GList* _tmp12_;
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp11_ = node;
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp12_ = _tmp11_->next;
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp9_ = _tmp12_ != NULL;
#line 696 "gpx-track-treemodel.c"
	} else {
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp9_ = FALSE;
#line 700 "gpx-track-treemodel.c"
	}
#line 146 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (_tmp9_) {
#line 704 "gpx-track-treemodel.c"
		GList* _tmp13_;
		GList* _tmp14_;
		gconstpointer _tmp15_;
#line 148 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		(*iter).stamp = self->priv->stamp;
#line 149 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp13_ = node;
#line 149 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp14_ = _tmp13_->next;
#line 149 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp15_ = _tmp14_->data;
#line 149 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		(*iter).user_data = _tmp15_;
#line 150 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		result = TRUE;
#line 150 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_gpx_point_unref0 (p);
#line 150 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		return result;
#line 724 "gpx-track-treemodel.c"
	}
#line 152 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = FALSE;
#line 152 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_gpx_point_unref0 (p);
#line 152 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 732 "gpx-track-treemodel.c"
}

static gboolean
gpx_track_tree_model_real_iter_nth_child (GtkTreeModel* base,
                                          GtkTreeIter* iter,
                                          GtkTreeIter* parent,
                                          gint n)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean _tmp0_ = FALSE;
	GpxTrack* _tmp3_;
	GList* _tmp4_;
	gconstpointer _tmp5_;
	gboolean result;
#line 155 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 157 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 158 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (parent == NULL) {
#line 159 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		result = FALSE;
#line 159 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		if (iter) {
#line 159 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			*iter = _vala_iter;
#line 760 "gpx-track-treemodel.c"
		}
#line 159 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		return result;
#line 764 "gpx-track-treemodel.c"
	}
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (n < 0) {
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp0_ = TRUE;
#line 770 "gpx-track-treemodel.c"
	} else {
		GpxTrack* _tmp1_;
		GList* _tmp2_;
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp1_ = self->priv->track;
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp2_ = _tmp1_->points;
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		_tmp0_ = ((guint) n) >= g_list_length (_tmp2_);
#line 780 "gpx-track-treemodel.c"
	}
#line 160 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (_tmp0_) {
#line 161 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		result = FALSE;
#line 161 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		if (iter) {
#line 161 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
			*iter = _vala_iter;
#line 790 "gpx-track-treemodel.c"
		}
#line 161 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		return result;
#line 794 "gpx-track-treemodel.c"
	}
#line 162 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.stamp = self->priv->stamp;
#line 163 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp3_ = self->priv->track;
#line 163 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp4_ = _tmp3_->points;
#line 163 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp5_ = g_list_nth_data (_tmp4_, (guint) n);
#line 163 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_vala_iter.user_data = (GpxPoint*) _tmp5_;
#line 164 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = TRUE;
#line 164 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (iter) {
#line 164 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		*iter = _vala_iter;
#line 812 "gpx-track-treemodel.c"
	}
#line 164 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 816 "gpx-track-treemodel.c"
}

/**
         * again, not implemented since this is not a tree
         */
static gboolean
gpx_track_tree_model_real_iter_parent (GtkTreeModel* base,
                                       GtkTreeIter* iter,
                                       GtkTreeIter* child)
{
	GpxTrackTreeModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result;
#line 170 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 171 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 172 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	result = FALSE;
#line 172 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	if (iter) {
#line 172 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
		*iter = _vala_iter;
#line 840 "gpx-track-treemodel.c"
	}
#line 172 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	return result;
#line 844 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_real_ref_node (GtkTreeModel* base,
                                    GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
#line 175 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 854 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_real_unref_node (GtkTreeModel* base,
                                      GtkTreeIter* iter)
{
	GpxTrackTreeModel * self;
#line 179 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = (GpxTrackTreeModel*) base;
#line 864 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_class_init (GpxTrackTreeModelClass * klass,
                                 gpointer klass_data)
{
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	gpx_track_tree_model_parent_class = g_type_class_peek_parent (klass);
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	g_type_class_adjust_private_offset (klass, &GpxTrackTreeModel_private_offset);
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_track_tree_model_finalize;
#line 877 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                                    gpointer iface_data)
{
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	gpx_track_tree_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_column_type = (GType (*) (GtkTreeModel*, gint)) gpx_track_tree_model_real_get_column_type;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_iter = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) gpx_track_tree_model_real_get_iter;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_n_columns = (gint (*) (GtkTreeModel*)) gpx_track_tree_model_real_get_n_columns;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_get_path;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) gpx_track_tree_model_real_get_value;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_children = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) gpx_track_tree_model_real_iter_children;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_has_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_iter_has_child;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_n_children = (gint (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_iter_n_children;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel*)) gpx_track_tree_model_real_get_flags;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_next = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_iter_next;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) gpx_track_tree_model_real_iter_nth_child;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->iter_parent = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) gpx_track_tree_model_real_iter_parent;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->ref_node = (void (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_ref_node;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	iface->unref_node = (void (*) (GtkTreeModel*, GtkTreeIter*)) gpx_track_tree_model_real_unref_node;
#line 914 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_instance_init (GpxTrackTreeModel * self,
                                    gpointer klass)
{
	GType* _tmp0_;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv = gpx_track_tree_model_get_instance_private (self);
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_ = g_new0 (GType, 4);
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_[0] = G_TYPE_STRING;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_[1] = G_TYPE_DOUBLE;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_[2] = G_TYPE_DOUBLE;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_tmp0_[3] = G_TYPE_DOUBLE;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->ColumnType = _tmp0_;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->ColumnType_length1 = 4;
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->_ColumnType_size_ = self->priv->ColumnType_length1;
#line 40 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->stamp = 42;
#line 41 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->track = NULL;
#line 944 "gpx-track-treemodel.c"
}

static void
gpx_track_tree_model_finalize (GObject * obj)
{
	GpxTrackTreeModel * self;
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_TRACK_TREE_MODEL, GpxTrackTreeModel);
#line 32 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	self->priv->ColumnType = (g_free (self->priv->ColumnType), NULL);
#line 41 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	_g_object_unref0 (self->priv->track);
#line 22 "../gpx-viewer/libgpx/gpx-track-treemodel.vala"
	G_OBJECT_CLASS (gpx_track_tree_model_parent_class)->finalize (obj);
#line 959 "gpx-track-treemodel.c"
}

static GType
gpx_track_tree_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxTrackTreeModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_track_tree_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxTrackTreeModel), 0, (GInstanceInitFunc) gpx_track_tree_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) gpx_track_tree_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gpx_track_tree_model_type_id;
	gpx_track_tree_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GpxTrackTreeModel", &g_define_type_info, 0);
	g_type_add_interface_static (gpx_track_tree_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	GpxTrackTreeModel_private_offset = g_type_add_instance_private (gpx_track_tree_model_type_id, sizeof (GpxTrackTreeModelPrivate));
	return gpx_track_tree_model_type_id;
}

GType
gpx_track_tree_model_get_type (void)
{
	static volatile gsize gpx_track_tree_model_type_id__once = 0;
	if (g_once_init_enter (&gpx_track_tree_model_type_id__once)) {
		GType gpx_track_tree_model_type_id;
		gpx_track_tree_model_type_id = gpx_track_tree_model_get_type_once ();
		g_once_init_leave (&gpx_track_tree_model_type_id__once, gpx_track_tree_model_type_id);
	}
	return gpx_track_tree_model_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

