/* gpx-convert.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-convert.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gpx.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define GPX_VIEWER_MISC_KM_IN_MILE 0.621371192
#define GPX_VIEWER_MISC_M_IN_FEET 0.3048
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
gpx_viewer_misc_speed_format_get_type_once (void)
{
	static const GEnumValue values[] = {{DISTANCE, "DISTANCE", "distance"}, {SPEED, "SPEED", "speed"}, {ELEVATION, "ELEVATION", "elevation"}, {ACCEL, "ACCEL", "accel"}, {NA, "NA", "na"}, {0, NULL, NULL}};
	GType gpx_viewer_misc_speed_format_type_id;
	gpx_viewer_misc_speed_format_type_id = g_enum_register_static ("SpeedFormat", values);
	return gpx_viewer_misc_speed_format_type_id;
}

GType
gpx_viewer_misc_speed_format_get_type (void)
{
	static volatile gsize gpx_viewer_misc_speed_format_type_id__once = 0;
	if (g_once_init_enter (&gpx_viewer_misc_speed_format_type_id__once)) {
		GType gpx_viewer_misc_speed_format_type_id;
		gpx_viewer_misc_speed_format_type_id = gpx_viewer_misc_speed_format_get_type_once ();
		g_once_init_leave (&gpx_viewer_misc_speed_format_type_id__once, gpx_viewer_misc_speed_format_type_id);
	}
	return gpx_viewer_misc_speed_format_type_id__once;
}

gchar*
gpx_viewer_misc_convert (gdouble speed,
                         SpeedFormat format)
{
	gchar* retv = NULL;
	gboolean do_miles = FALSE;
	gchar* result;
#line 37 "../gpx-viewer/libgpx/gpx-convert.vala"
	retv = NULL;
#line 39 "../gpx-viewer/libgpx/gpx-convert.vala"
	do_miles = FALSE;
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
	switch (format) {
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
		case DISTANCE:
#line 84 "gpx-convert.c"
		{
#line 43 "../gpx-viewer/libgpx/gpx-convert.vala"
			if (do_miles) {
#line 88 "gpx-convert.c"
				gchar* _tmp0_;
#line 44 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp0_ = g_strdup_printf ("% .2f %s", speed / GPX_VIEWER_MISC_KM_IN_MILE, _ ("Miles"));
#line 44 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 44 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp0_;
#line 96 "gpx-convert.c"
			} else {
				gchar* _tmp1_;
#line 46 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp1_ = g_strdup_printf ("% .2f %s", speed, _ ("km"));
#line 46 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 46 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp1_;
#line 105 "gpx-convert.c"
			}
#line 47 "../gpx-viewer/libgpx/gpx-convert.vala"
			break;
#line 109 "gpx-convert.c"
		}
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
		case SPEED:
#line 113 "gpx-convert.c"
		{
#line 49 "../gpx-viewer/libgpx/gpx-convert.vala"
			if (do_miles) {
#line 117 "gpx-convert.c"
				gchar* _tmp2_;
#line 50 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp2_ = g_strdup_printf ("% .2f %s", speed / GPX_VIEWER_MISC_KM_IN_MILE, _ ("Miles/h"));
#line 50 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 50 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp2_;
#line 125 "gpx-convert.c"
			} else {
				gchar* _tmp3_;
#line 52 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp3_ = g_strdup_printf ("% .2f %s", speed, _ ("km/h"));
#line 52 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 52 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp3_;
#line 134 "gpx-convert.c"
			}
#line 53 "../gpx-viewer/libgpx/gpx-convert.vala"
			break;
#line 138 "gpx-convert.c"
		}
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
		case ELEVATION:
#line 142 "gpx-convert.c"
		{
#line 55 "../gpx-viewer/libgpx/gpx-convert.vala"
			if (do_miles) {
#line 146 "gpx-convert.c"
				gchar* _tmp4_;
#line 57 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp4_ = g_strdup_printf ("% .2f %s", speed / GPX_VIEWER_MISC_M_IN_FEET, _ ("ft"));
#line 57 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 57 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp4_;
#line 154 "gpx-convert.c"
			} else {
				gchar* _tmp5_;
#line 59 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp5_ = g_strdup_printf ("% .2f %s", speed, _ ("m"));
#line 59 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 59 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp5_;
#line 163 "gpx-convert.c"
			}
#line 60 "../gpx-viewer/libgpx/gpx-convert.vala"
			break;
#line 167 "gpx-convert.c"
		}
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
		case ACCEL:
#line 171 "gpx-convert.c"
		{
#line 62 "../gpx-viewer/libgpx/gpx-convert.vala"
			if (do_miles) {
#line 175 "gpx-convert.c"
				gchar* _tmp6_;
#line 64 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp6_ = g_strdup_printf ("% .2f %s", speed / GPX_VIEWER_MISC_M_IN_FEET, _ ("ft/s²"));
#line 64 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 64 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp6_;
#line 183 "gpx-convert.c"
			} else {
				gchar* _tmp7_;
#line 66 "../gpx-viewer/libgpx/gpx-convert.vala"
				_tmp7_ = g_strdup_printf ("% .2f %s", speed, _ ("m/s²"));
#line 66 "../gpx-viewer/libgpx/gpx-convert.vala"
				_g_free0 (retv);
#line 66 "../gpx-viewer/libgpx/gpx-convert.vala"
				retv = _tmp7_;
#line 192 "gpx-convert.c"
			}
#line 67 "../gpx-viewer/libgpx/gpx-convert.vala"
			break;
#line 196 "gpx-convert.c"
		}
		default:
#line 40 "../gpx-viewer/libgpx/gpx-convert.vala"
		case NA:
#line 201 "gpx-convert.c"
		{
			gchar* _tmp8_;
#line 70 "../gpx-viewer/libgpx/gpx-convert.vala"
			_tmp8_ = g_strdup (_ ("n/a"));
#line 70 "../gpx-viewer/libgpx/gpx-convert.vala"
			_g_free0 (retv);
#line 70 "../gpx-viewer/libgpx/gpx-convert.vala"
			retv = _tmp8_;
#line 71 "../gpx-viewer/libgpx/gpx-convert.vala"
			break;
#line 212 "gpx-convert.c"
		}
	}
#line 73 "../gpx-viewer/libgpx/gpx-convert.vala"
	result = retv;
#line 73 "../gpx-viewer/libgpx/gpx-convert.vala"
	return result;
#line 219 "gpx-convert.c"
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

