/* gpx.h generated by valac 0.56.18, the Vala compiler, do not modify */

#ifndef __LIBGPX_GPX_H__
#define __LIBGPX_GPX_H__

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <time.h>
#include <champlain-gtk/champlain-gtk.h>
#include <champlain/champlain.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GPX_TYPE_FILE_BASE (gpx_file_base_get_type ())
#define GPX_FILE_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_FILE_BASE, GpxFileBase))
#define GPX_FILE_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_FILE_BASE, GpxFileBaseClass))
#define GPX_IS_FILE_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_FILE_BASE))
#define GPX_IS_FILE_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_FILE_BASE))
#define GPX_FILE_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_FILE_BASE, GpxFileBaseClass))

typedef struct _GpxFileBase GpxFileBase;
typedef struct _GpxFileBaseClass GpxFileBaseClass;
typedef struct _GpxFileBasePrivate GpxFileBasePrivate;

#define GPX_TYPE_TRACK (gpx_track_get_type ())
#define GPX_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_TRACK, GpxTrack))
#define GPX_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_TRACK, GpxTrackClass))
#define GPX_IS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_TRACK))
#define GPX_IS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_TRACK))
#define GPX_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_TRACK, GpxTrackClass))

typedef struct _GpxTrack GpxTrack;
typedef struct _GpxTrackClass GpxTrackClass;

#define GPX_TYPE_POINT (gpx_point_get_type ())
#define GPX_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_POINT, GpxPoint))
#define GPX_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_POINT, GpxPointClass))
#define GPX_IS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_POINT))
#define GPX_IS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_POINT))
#define GPX_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_POINT, GpxPointClass))

typedef struct _GpxPoint GpxPoint;
typedef struct _GpxPointClass GpxPointClass;

#define GPX_TYPE_FIT_FILE (gpx_fit_file_get_type ())
#define GPX_FIT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_FIT_FILE, GpxFitFile))
#define GPX_FIT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_FIT_FILE, GpxFitFileClass))
#define GPX_IS_FIT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_FIT_FILE))
#define GPX_IS_FIT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_FIT_FILE))
#define GPX_FIT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_FIT_FILE, GpxFitFileClass))

typedef struct _GpxFitFile GpxFitFile;
typedef struct _GpxFitFileClass GpxFitFileClass;
typedef struct _GpxFitFilePrivate GpxFitFilePrivate;

#define GPX_TYPE_FILE_ERROR (gpx_file_error_get_type ())
typedef enum  {
	DISTANCE,
	SPEED,
	ELEVATION,
	ACCEL,
	NA
} SpeedFormat;

#define GPX_VIEWER_MISC_TYPE_SPEED_FORMAT (gpx_viewer_misc_speed_format_get_type ())

#define GPX_TYPE_GRAPH (gpx_graph_get_type ())
#define GPX_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_GRAPH, GpxGraph))
#define GPX_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_GRAPH, GpxGraphClass))
#define GPX_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_GRAPH))
#define GPX_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_GRAPH))
#define GPX_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_GRAPH, GpxGraphClass))

typedef struct _GpxGraph GpxGraph;
typedef struct _GpxGraphClass GpxGraphClass;
typedef struct _GpxGraphPrivate GpxGraphPrivate;
typedef enum  {
	GPX_GRAPH_GRAPH_MODE_SPEED,
	GPX_GRAPH_GRAPH_MODE_ELEVATION,
	GPX_GRAPH_GRAPH_MODE_DISTANCE,
	GPX_GRAPH_GRAPH_MODE_TOTAL_DISTANCE,
	GPX_GRAPH_GRAPH_MODE_ACCELERATION_H,
	GPX_GRAPH_GRAPH_MODE_SPEED_V,
	GPX_GRAPH_GRAPH_MODE_HEARTRATE,
	GPX_GRAPH_GRAPH_MODE_CADENCE,
	GPX_GRAPH_GRAPH_MODE_NUM_GRAPH_MODES
} GpxGraphGraphMode;

#define GPX_GRAPH_TYPE_GRAPH_MODE (gpx_graph_graph_mode_get_type ())

#define GPX_TYPE_XML_FILE (gpx_xml_file_get_type ())
#define GPX_XML_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_XML_FILE, GpxXmlFile))
#define GPX_XML_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_XML_FILE, GpxXmlFileClass))
#define GPX_IS_XML_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_XML_FILE))
#define GPX_IS_XML_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_XML_FILE))
#define GPX_XML_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_XML_FILE, GpxXmlFileClass))

typedef struct _GpxXmlFile GpxXmlFile;
typedef struct _GpxXmlFileClass GpxXmlFileClass;
typedef struct _GpxXmlFilePrivate GpxXmlFilePrivate;

#define GPX_TYPE_JSON_FILE (gpx_json_file_get_type ())
#define GPX_JSON_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_JSON_FILE, GpxJsonFile))
#define GPX_JSON_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_JSON_FILE, GpxJsonFileClass))
#define GPX_IS_JSON_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_JSON_FILE))
#define GPX_IS_JSON_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_JSON_FILE))
#define GPX_JSON_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_JSON_FILE, GpxJsonFileClass))

typedef struct _GpxJsonFile GpxJsonFile;
typedef struct _GpxJsonFileClass GpxJsonFileClass;
typedef struct _GpxJsonFilePrivate GpxJsonFilePrivate;

#define GPX_TYPE_HEART_RATE_MONITOR_POINT (gpx_heart_rate_monitor_point_get_type ())
typedef struct _GpxHeartRateMonitorPoint GpxHeartRateMonitorPoint;
typedef struct _GpxPointPrivate GpxPointPrivate;

#define GPX_TYPE_PLAYBACK (gpx_playback_get_type ())
#define GPX_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_PLAYBACK, GpxPlayback))
#define GPX_PLAYBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_PLAYBACK, GpxPlaybackClass))
#define GPX_IS_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_PLAYBACK))
#define GPX_IS_PLAYBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_PLAYBACK))
#define GPX_PLAYBACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_PLAYBACK, GpxPlaybackClass))

typedef struct _GpxPlayback GpxPlayback;
typedef struct _GpxPlaybackClass GpxPlaybackClass;
typedef struct _GpxPlaybackPrivate GpxPlaybackPrivate;
typedef enum  {
	GPX_PLAYBACK_STATE_STOPPED,
	GPX_PLAYBACK_STATE_PAUSED,
	GPX_PLAYBACK_STATE_PLAY
} GpxPlaybackState;

#define GPX_PLAYBACK_TYPE_STATE (gpx_playback_state_get_type ())

#define GPX_VIEWER_TYPE_SETTINGS (gpx_viewer_settings_get_type ())
#define GPX_VIEWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_VIEWER_TYPE_SETTINGS, GpxViewerSettings))
#define GPX_VIEWER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_VIEWER_TYPE_SETTINGS, GpxViewerSettingsClass))
#define GPX_VIEWER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_VIEWER_TYPE_SETTINGS))
#define GPX_VIEWER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_VIEWER_TYPE_SETTINGS))
#define GPX_VIEWER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_VIEWER_TYPE_SETTINGS, GpxViewerSettingsClass))

typedef struct _GpxViewerSettings GpxViewerSettings;
typedef struct _GpxViewerSettingsClass GpxViewerSettingsClass;
typedef struct _GpxViewerSettingsPrivate GpxViewerSettingsPrivate;

#define GPX_TYPE_HEART_RATE_MONITOR_TRACK (gpx_heart_rate_monitor_track_get_type ())
typedef struct _GpxHeartRateMonitorTrack GpxHeartRateMonitorTrack;
typedef struct _GpxTrackPrivate GpxTrackPrivate;

#define GPX_TYPE_TRACK_TREE_MODEL (gpx_track_tree_model_get_type ())
#define GPX_TRACK_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_TYPE_TRACK_TREE_MODEL, GpxTrackTreeModel))
#define GPX_TRACK_TREE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_TYPE_TRACK_TREE_MODEL, GpxTrackTreeModelClass))
#define GPX_IS_TRACK_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_TYPE_TRACK_TREE_MODEL))
#define GPX_IS_TRACK_TREE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_TYPE_TRACK_TREE_MODEL))
#define GPX_TRACK_TREE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_TYPE_TRACK_TREE_MODEL, GpxTrackTreeModelClass))

typedef struct _GpxTrackTreeModel GpxTrackTreeModel;
typedef struct _GpxTrackTreeModelClass GpxTrackTreeModelClass;
typedef struct _GpxTrackTreeModelPrivate GpxTrackTreeModelPrivate;
typedef enum  {
	GPX_TRACK_TREE_MODEL_COLUMN_TIME,
	GPX_TRACK_TREE_MODEL_COLUMN_DISTANCE,
	GPX_TRACK_TREE_MODEL_COLUMN_ELEVATION,
	GPX_TRACK_TREE_MODEL_COLUMN_SPEED,
	GPX_TRACK_TREE_MODEL_COLUMN_NUM_COLUMNS
} GpxTrackTreeModelColumn;

#define GPX_TRACK_TREE_MODEL_TYPE_COLUMN (gpx_track_tree_model_column_get_type ())

#define GPX_VIEWER_TYPE_MAP_VIEW (gpx_viewer_map_view_get_type ())
#define GPX_VIEWER_MAP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView))
#define GPX_VIEWER_MAP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapViewClass))
#define GPX_VIEWER_IS_MAP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_VIEWER_TYPE_MAP_VIEW))
#define GPX_VIEWER_IS_MAP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_VIEWER_TYPE_MAP_VIEW))
#define GPX_VIEWER_MAP_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapViewClass))

typedef struct _GpxViewerMapView GpxViewerMapView;
typedef struct _GpxViewerMapViewClass GpxViewerMapViewClass;
typedef struct _GpxViewerMapViewPrivate GpxViewerMapViewPrivate;

#define GPX_VIEWER_TYPE_PATH_LAYER (gpx_viewer_path_layer_get_type ())
#define GPX_VIEWER_PATH_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayer))
#define GPX_VIEWER_PATH_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayerClass))
#define GPX_VIEWER_IS_PATH_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPX_VIEWER_TYPE_PATH_LAYER))
#define GPX_VIEWER_IS_PATH_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GPX_VIEWER_TYPE_PATH_LAYER))
#define GPX_VIEWER_PATH_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayerClass))

typedef struct _GpxViewerPathLayer GpxViewerPathLayer;
typedef struct _GpxViewerPathLayerClass GpxViewerPathLayerClass;
typedef struct _GpxViewerPathLayerPrivate GpxViewerPathLayerPrivate;

struct _GpxFileBase {
	GObject parent_instance;
	GpxFileBasePrivate * priv;
	GList* tracks;
	GList* waypoints;
	GList* routes;
	GFile* file;
	gchar* creator;
	gchar* name;
	gchar* description;
	gchar* time;
	gchar* keywords;
};

struct _GpxFileBaseClass {
	GObjectClass parent_class;
};

struct _GpxFitFile {
	GpxFileBase parent_instance;
	GpxFitFilePrivate * priv;
};

struct _GpxFitFileClass {
	GpxFileBaseClass parent_class;
};

typedef enum  {
	GPX_FILE_ERROR_INVALID_FILE,
	GPX_FILE_ERROR_IO_ERROR
} GpxFileError;
#define GPX_FILE_ERROR gpx_file_error_quark ()

struct _GpxGraph {
	GtkEventBox parent_instance;
	GpxGraphPrivate * priv;
	GpxTrack* track;
};

struct _GpxGraphClass {
	GtkEventBoxClass parent_class;
};

struct _GpxXmlFile {
	GpxFileBase parent_instance;
	GpxXmlFilePrivate * priv;
};

struct _GpxXmlFileClass {
	GpxFileBaseClass parent_class;
};

struct _GpxJsonFile {
	GpxFileBase parent_instance;
	GpxJsonFilePrivate * priv;
};

struct _GpxJsonFileClass {
	GpxFileBaseClass parent_class;
};

struct _GpxHeartRateMonitorPoint {
	gint heartrate;
};

struct _GpxPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GpxPointPrivate * priv;
	gdouble lat;
	gdouble lon;
	gdouble lat_dec;
	gdouble lon_dec;
	gdouble distance;
	gdouble elevation;
	gdouble smooth_elevation;
	gchar* time;
	gdouble speed;
	gboolean stopped;
	guint32 cadence;
	GpxHeartRateMonitorPoint tpe;
};

struct _GpxPointClass {
	GTypeClass parent_class;
	void (*finalize) (GpxPoint *self);
};

struct _GpxPlayback {
	GObject parent_instance;
	GpxPlaybackPrivate * priv;
};

struct _GpxPlaybackClass {
	GObjectClass parent_class;
};

struct _GpxViewerSettings {
	GObject parent_instance;
	GpxViewerSettingsPrivate * priv;
};

struct _GpxViewerSettingsClass {
	GObjectClass parent_class;
};

struct _GpxHeartRateMonitorTrack {
	guint32 calories;
};

struct _GpxTrack {
	GObject parent_instance;
	GpxTrackPrivate * priv;
	GpxHeartRateMonitorTrack hrmt;
	gint filtered_points;
	gdouble total_distance;
	gdouble max_speed;
	gdouble max_elevation;
	gdouble min_elevation;
	GList* points;
	GpxPoint* top;
	GpxPoint* bottom;
};

struct _GpxTrackClass {
	GObjectClass parent_class;
};

struct _GpxTrackTreeModel {
	GObject parent_instance;
	GpxTrackTreeModelPrivate * priv;
};

struct _GpxTrackTreeModelClass {
	GObjectClass parent_class;
};

struct _GpxViewerMapView {
	GtkChamplainEmbed parent_instance;
	GpxViewerMapViewPrivate * priv;
};

struct _GpxViewerMapViewClass {
	GtkChamplainEmbedClass parent_class;
};

struct _GpxViewerPathLayer {
	ChamplainLayer parent_instance;
	GpxViewerPathLayerPrivate * priv;
};

struct _GpxViewerPathLayerClass {
	ChamplainLayerClass parent_class;
};

VALA_EXTERN GType gpx_file_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxFileBase, g_object_unref)
VALA_EXTERN GType gpx_track_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxTrack, g_object_unref)
VALA_EXTERN gpointer gpx_point_ref (gpointer instance);
VALA_EXTERN void gpx_point_unref (gpointer instance);
VALA_EXTERN GParamSpec* gpx_param_spec_point (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void gpx_value_set_point (GValue* value,
                          gpointer v_object);
VALA_EXTERN void gpx_value_take_point (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer gpx_value_get_point (const GValue* value);
VALA_EXTERN GType gpx_point_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxPoint, gpx_point_unref)
VALA_EXTERN GType gpx_fit_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxFitFile, g_object_unref)
VALA_EXTERN GQuark gpx_file_error_quark (void);
VALA_EXTERN GType gpx_file_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpxFitFile* gpx_fit_file_new (GFile* file,
                              GError** error);
VALA_EXTERN GpxFitFile* gpx_fit_file_construct (GType object_type,
                                    GFile* file,
                                    GError** error);
VALA_EXTERN GType gpx_viewer_misc_speed_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* gpx_viewer_misc_convert (gdouble speed,
                                SpeedFormat format);
VALA_EXTERN gchar* gpx_file_base_get_keywords (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_time (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_name (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_description (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_creator (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_uri (GpxFileBase* self);
VALA_EXTERN gchar* gpx_file_base_get_basename (GpxFileBase* self);
VALA_EXTERN GList* gpx_file_base_get_tracks (GpxFileBase* self);
VALA_EXTERN GList* gpx_file_base_get_waypoints (GpxFileBase* self);
VALA_EXTERN GList* gpx_file_base_get_routes (GpxFileBase* self);
VALA_EXTERN GpxFileBase* gpx_file_base_construct (GType object_type);
VALA_EXTERN GpxFileBase* gpx_file_open (GFile* path,
                            GError** error);
VALA_EXTERN GType gpx_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxGraph, g_object_unref)
VALA_EXTERN GType gpx_graph_graph_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gpx_graph_hide_info (GpxGraph* self);
VALA_EXTERN void gpx_graph_show_info (GpxGraph* self,
                          GpxPoint* cur_point);
VALA_EXTERN void gpx_graph_highlight_point (GpxGraph* self,
                                GpxPoint* p);
VALA_EXTERN void gpx_graph_set_highlight (GpxGraph* self,
                              time_t highlight);
VALA_EXTERN GpxGraph* gpx_graph_new (void);
VALA_EXTERN GpxGraph* gpx_graph_construct (GType object_type);
VALA_EXTERN void gpx_graph_set_track (GpxGraph* self,
                          GpxTrack* track);
VALA_EXTERN gboolean gpx_graph_select_next_point (GpxGraph* self);
VALA_EXTERN gboolean gpx_graph_select_prev_point (GpxGraph* self);
VALA_EXTERN void gpx_graph_remove_selected (GpxGraph* self);
VALA_EXTERN void gpx_graph_remove_selected_point (GpxGraph* self);
VALA_EXTERN void gpx_graph_remove_non_selected_range (GpxGraph* self);
VALA_EXTERN gint gpx_graph_get_smooth_factor (GpxGraph* self);
VALA_EXTERN void gpx_graph_set_smooth_factor (GpxGraph* self,
                                  gint value);
VALA_EXTERN gboolean gpx_graph_get_show_points (GpxGraph* self);
VALA_EXTERN void gpx_graph_set_show_points (GpxGraph* self,
                                gboolean value);
VALA_EXTERN GpxGraphGraphMode gpx_graph_get_mode (GpxGraph* self);
VALA_EXTERN void gpx_graph_set_mode (GpxGraph* self,
                         GpxGraphGraphMode value);
VALA_EXTERN GType gpx_xml_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxXmlFile, g_object_unref)
VALA_EXTERN GpxXmlFile* gpx_xml_file_new (GFile* file);
VALA_EXTERN GpxXmlFile* gpx_xml_file_construct (GType object_type,
                                    GFile* file);
VALA_EXTERN GType gpx_json_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxJsonFile, g_object_unref)
VALA_EXTERN GpxJsonFile* gpx_json_file_new (GFile* file);
VALA_EXTERN GpxJsonFile* gpx_json_file_construct (GType object_type,
                                      GFile* file);
VALA_EXTERN GType gpx_heart_rate_monitor_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpxHeartRateMonitorPoint* gpx_heart_rate_monitor_point_dup (const GpxHeartRateMonitorPoint* self);
VALA_EXTERN void gpx_heart_rate_monitor_point_free (GpxHeartRateMonitorPoint* self);
VALA_EXTERN gboolean gpx_point_has_position (GpxPoint* self);
VALA_EXTERN GpxPoint* gpx_point_copy (GpxPoint* self);
VALA_EXTERN void gpx_point_set_position_lat (GpxPoint* self,
                                 gdouble lat_d);
VALA_EXTERN void gpx_point_set_position_lon (GpxPoint* self,
                                 gdouble lon_d);
VALA_EXTERN void gpx_point_set_position (GpxPoint* self,
                             gdouble lat,
                             gdouble lon);
VALA_EXTERN void gpx_point_set_utime (GpxPoint* self,
                          time_t ut);
VALA_EXTERN time_t gpx_point_get_time (GpxPoint* self);
VALA_EXTERN GDateTime* gpx_point_get_datetime (GpxPoint* self);
VALA_EXTERN GpxPoint* gpx_point_new (void);
VALA_EXTERN GpxPoint* gpx_point_construct (GType object_type);
VALA_EXTERN const gchar* gpx_point_get_name (GpxPoint* self);
VALA_EXTERN void gpx_point_set_name (GpxPoint* self,
                         const gchar* value);
VALA_EXTERN const gchar* gpx_point_get_description (GpxPoint* self);
VALA_EXTERN void gpx_point_set_description (GpxPoint* self,
                                const gchar* value);
VALA_EXTERN GType gpx_playback_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxPlayback, g_object_unref)
VALA_EXTERN GType gpx_playback_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gpx_playback_set_track (GpxPlayback* self,
                             GpxTrack* track);
VALA_EXTERN GpxPlayback* gpx_playback_new (GpxTrack* track);
VALA_EXTERN GpxPlayback* gpx_playback_construct (GType object_type,
                                     GpxTrack* track);
VALA_EXTERN gboolean gpx_playback_timer_callback (GpxPlayback* self);
VALA_EXTERN void gpx_playback_start (GpxPlayback* self);
VALA_EXTERN void gpx_playback_pause (GpxPlayback* self);
VALA_EXTERN void gpx_playback_stop (GpxPlayback* self);
VALA_EXTERN gint gpx_playback_get_speedup (GpxPlayback* self);
VALA_EXTERN void gpx_playback_set_speedup (GpxPlayback* self,
                               gint value);
VALA_EXTERN GType gpx_viewer_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxViewerSettings, g_object_unref)
VALA_EXTERN GType gpx_viewer_settings_enum_type;
VALA_EXTERN GpxViewerSettings* gpx_viewer_settings_new (void);
VALA_EXTERN GpxViewerSettings* gpx_viewer_settings_construct (GType object_type);
VALA_EXTERN void gpx_viewer_settings_add_object_property (GpxViewerSettings* self,
                                              GObject* wobject,
                                              const gchar* property);
VALA_EXTERN gint gpx_viewer_settings_get_integer (GpxViewerSettings* self,
                                      const gchar* class,
                                      const gchar* name,
                                      gint def);
VALA_EXTERN gchar* gpx_viewer_settings_get_string (GpxViewerSettings* self,
                                       const gchar* class,
                                       const gchar* name,
                                       const gchar* def);
VALA_EXTERN void gpx_viewer_settings_set_integer (GpxViewerSettings* self,
                                      const gchar* class,
                                      const gchar* name,
                                      gint val);
VALA_EXTERN void gpx_viewer_settings_set_string (GpxViewerSettings* self,
                                     const gchar* class,
                                     const gchar* name,
                                     const gchar* val);
VALA_EXTERN gdouble gpx_viewer_settings_get_double (GpxViewerSettings* self,
                                        const gchar* class,
                                        const gchar* name,
                                        gdouble def);
VALA_EXTERN gboolean gpx_viewer_settings_get_boolean (GpxViewerSettings* self,
                                          const gchar* class,
                                          const gchar* name,
                                          gboolean def);
VALA_EXTERN GType gpx_heart_rate_monitor_track_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpxHeartRateMonitorTrack* gpx_heart_rate_monitor_track_dup (const GpxHeartRateMonitorTrack* self);
VALA_EXTERN void gpx_heart_rate_monitor_track_free (GpxHeartRateMonitorTrack* self);
VALA_EXTERN GpxPoint* gpx_track_get_last (GpxTrack* self);
VALA_EXTERN void gpx_track_filter_points (GpxTrack* self);
VALA_EXTERN void gpx_track_recalculate (GpxTrack* self);
VALA_EXTERN void gpx_track_add_point (GpxTrack* self,
                          GpxPoint* point);
VALA_EXTERN GpxTrack* gpx_track_cleanup_speed (GpxTrack* self);
VALA_EXTERN gdouble gpx_track_get_track_average (GpxTrack* self);
VALA_EXTERN gdouble gpx_track_calculate_point_to_point_speed (GpxTrack* self,
                                                  GpxPoint* a,
                                                  GpxPoint* b);
VALA_EXTERN time_t gpx_track_get_total_time (GpxTrack* self);
VALA_EXTERN gdouble gpx_track_calculate_moving_average (GpxTrack* self,
                                            GpxPoint* start,
                                            GpxPoint* stop,
                                            time_t* moving_time);
VALA_EXTERN void gpx_track_calculate_total_elevation (GpxTrack* self,
                                          GpxPoint* start,
                                          GpxPoint* stop,
                                          gdouble* up,
                                          gdouble* down);
VALA_EXTERN gdouble gpx_track_calculate_distance_coords (gdouble lon_a,
                                             gdouble lat_a,
                                             gdouble ele_a,
                                             gdouble lon_b,
                                             gdouble lat_b,
                                             gdouble ele_b);
VALA_EXTERN gdouble gpx_track_calculate_distance (GpxPoint* a,
                                      GpxPoint* b);
VALA_EXTERN guint gpx_track_heartrate_avg (GpxTrack* self,
                               GpxPoint* start,
                               GpxPoint* stop);
VALA_EXTERN guint gpx_track_get_burned_calories (GpxTrack* self);
VALA_EXTERN void gpx_track_set_burned_calories (GpxTrack* self,
                                    guint value);
VALA_EXTERN void gpx_track_remove_point (GpxTrack* self,
                             GpxPoint* point,
                             gboolean update);
VALA_EXTERN GpxTrack* gpx_track_new (void);
VALA_EXTERN GpxTrack* gpx_track_construct (GType object_type);
VALA_EXTERN const gchar* gpx_track_get_name (GpxTrack* self);
VALA_EXTERN void gpx_track_set_name (GpxTrack* self,
                         const gchar* value);
VALA_EXTERN const gchar* gpx_track_get_track_type (GpxTrack* self);
VALA_EXTERN void gpx_track_set_track_type (GpxTrack* self,
                               const gchar* value);
VALA_EXTERN gint* gpx_track_get_number (GpxTrack* self);
VALA_EXTERN void gpx_track_set_number (GpxTrack* self,
                           gint* value);
VALA_EXTERN gboolean gpx_track_get_is_route (GpxTrack* self);
VALA_EXTERN void gpx_track_set_is_route (GpxTrack* self,
                             gboolean value);
VALA_EXTERN GType gpx_track_tree_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxTrackTreeModel, g_object_unref)
VALA_EXTERN GType gpx_track_tree_model_column_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpxTrackTreeModel* gpx_track_tree_model_new (GpxTrack* track);
VALA_EXTERN GpxTrackTreeModel* gpx_track_tree_model_construct (GType object_type,
                                                   GpxTrack* track);
VALA_EXTERN GType gpx_viewer_map_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxViewerMapView, g_object_unref)
VALA_EXTERN ChamplainMarker* gpx_viewer_map_view_create_marker (GpxViewerMapView* self,
                                                    GpxPoint* p,
                                                    const gchar* icon,
                                                    gint size);
VALA_EXTERN void gpx_viewer_map_view_click_marker_show (GpxViewerMapView* self,
                                            GpxPoint* p);
VALA_EXTERN void gpx_viewer_map_view_click_marker_hide (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_increase_zoom_level (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_decrease_zoom_level (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_add_waypoint (GpxViewerMapView* self,
                                       GpxPoint* p);
VALA_EXTERN void gpx_viewer_map_view_add_marker (GpxViewerMapView* self,
                                     ChamplainMarker* marker);
VALA_EXTERN GtkTreeModel* gpx_viewer_map_view_get_model (GpxViewerMapView* self);
VALA_EXTERN GpxViewerMapView* gpx_viewer_map_view_new (void);
VALA_EXTERN GpxViewerMapView* gpx_viewer_map_view_construct (GType object_type);
VALA_EXTERN gboolean gpx_viewer_map_view_get_show_waypoints (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_set_show_waypoints (GpxViewerMapView* self,
                                             gboolean value);
VALA_EXTERN gboolean gpx_viewer_map_view_get_show_markers (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_set_show_markers (GpxViewerMapView* self,
                                           gboolean value);
VALA_EXTERN const gchar* gpx_viewer_map_view_get_map_source (GpxViewerMapView* self);
VALA_EXTERN void gpx_viewer_map_view_set_map_source (GpxViewerMapView* self,
                                         const gchar* value);
VALA_EXTERN GType gpx_viewer_path_layer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GpxViewerPathLayer, g_object_unref)
VALA_EXTERN GpxViewerPathLayer* gpx_viewer_path_layer_new (void);
VALA_EXTERN GpxViewerPathLayer* gpx_viewer_path_layer_construct (GType object_type);
VALA_EXTERN ClutterColor* gpx_viewer_path_layer_get_stroke_color (GpxViewerPathLayer* self);
VALA_EXTERN void gpx_viewer_path_layer_set_stroke_color (GpxViewerPathLayer* self,
                                             ClutterColor* value);
VALA_EXTERN gdouble gpx_viewer_path_layer_get_stroke_width (GpxViewerPathLayer* self);
VALA_EXTERN void gpx_viewer_path_layer_set_stroke_width (GpxViewerPathLayer* self,
                                             gdouble value);
VALA_EXTERN gboolean gpx_viewer_path_layer_get_visible (GpxViewerPathLayer* self);
VALA_EXTERN void gpx_viewer_path_layer_set_visible (GpxViewerPathLayer* self,
                                        gboolean value);
VALA_EXTERN void gpx_viewer_path_layer_set_track (GpxViewerPathLayer* self,
                                      GpxTrack* value);

G_END_DECLS

#endif
