
#line 1 "source/parser/TextFileParser.rl"
#include "parser/TextFile.h"
#include "Color.h"
#include <string.h>
#include <stdlib.h>
#include <cstddef>
#include <functional>
#include <vector>
#include <string>
#include <iostream>
#include <cmath>
using namespace std;
namespace text_file_parser
{
struct FSM
{
	public:
		int cs;
		char separator;
		int act;
		int top;
		char *ts;
		char *te;
		int stack[256];
		char buffer[8 * 1024];
		int line;
		int column;
		int line_start;
		int buffer_offset;
		int64_t number_i64;
		vector<int64_t> numbers_i64;
		char *number_double_start;
		vector<double> numbers_double;
		function<void(const Color&)> addColor;
		void handleNewline()
		{
			line++;
			column = 0;
			line_start = te - buffer;
		}
		int hexToInt(char hex)
		{
			if (hex >= '0' && hex <= '9') return hex - '0';
			if (hex >= 'a' && hex <= 'f') return hex - 'a' + 10;
			if (hex >= 'A' && hex <= 'F') return hex - 'A' + 10;
			return 0;
		}
		int hexPairToInt(const char *hex_pair)
		{
			return hexToInt(hex_pair[0]) << 4 | hexToInt(hex_pair[1]);
		}
		void colorHexFull(bool with_hash_symbol)
		{
			Color color;
			int start_index = with_hash_symbol ? 1 : 0;
			color.red = hexPairToInt(ts + start_index) / 255.0f;
			color.green = hexPairToInt(ts + start_index + 2) / 255.0f;
			color.blue = hexPairToInt(ts + start_index + 4) / 255.0f;
			color.alpha = 1;
			addColor(color);
		}
		void colorHexShort(bool with_hash_symbol)
		{
			Color color;
			int start_index = with_hash_symbol ? 1 : 0;
			color.red = hexToInt(ts[start_index + 0]) / 15.0f;
			color.green = hexToInt(ts[start_index + 1]) / 15.0f;
			color.blue = hexToInt(ts[start_index + 2]) / 15.0f;
			color.alpha = 1;
			addColor(color);
		}
		void colorRgb()
		{
			Color color;
			color.red = numbers_i64[0] / 255.0f;
			color.green = numbers_i64[1] / 255.0f;
			color.blue = numbers_i64[2] / 255.0f;
			color.alpha = 1;
			numbers_i64.clear();
			addColor(color);
		}
		void colorRgba()
		{
			Color color;
			color.red = numbers_i64[0] / 255.0f;
			color.green = numbers_i64[1] / 255.0f;
			color.blue = numbers_i64[2] / 255.0f;
			color.alpha = static_cast<float>(numbers_double[0]);
			numbers_i64.clear();
			numbers_double.clear();
			addColor(color);
		}
		void colorValues()
		{
			Color color;
			color.red = static_cast<float>(numbers_double[0]);
			color.green = static_cast<float>(numbers_double[1]);
			color.blue = static_cast<float>(numbers_double[2]);
			color.alpha = 1;
			numbers_double.clear();
			addColor(color);
		}
		void colorValueIntegers()
		{
			Color color;
			color.red = numbers_i64[0] / 255.0f;
			color.green = numbers_i64[1] / 255.0f;
			color.blue = numbers_i64[2] / 255.0f;
			color.alpha = 1;
			numbers_i64.clear();
			addColor(color);
		}
		double parseDouble(const char *start, const char *end)
		{
			string v(start, end);
			try {
				return stod(v.c_str());
			} catch(...) {
				return 0;
			}
		}
		void clearNumberStacks()
		{
			numbers_i64.clear();
			numbers_double.clear();
		}
};



#line 162 "source/parser/TextFileParser.rl"



#line 137 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
static const char _text_file_actions[] = {
	0, 1, 1, 1, 2, 1, 3, 1, 
	4, 1, 5, 1, 6, 1, 7, 1, 
	8, 1, 9, 1, 10, 1, 21, 1, 
	22, 1, 23, 1, 24, 1, 25, 1, 
	30, 1, 31, 1, 32, 1, 33, 1, 
	34, 1, 35, 1, 36, 1, 37, 1, 
	38, 2, 0, 1, 2, 2, 4, 2, 
	2, 22, 2, 4, 23, 2, 4, 28, 
	2, 4, 29, 2, 10, 11, 2, 10, 
	12, 2, 10, 15, 2, 10, 16, 2, 
	10, 17, 2, 10, 18, 2, 10, 19, 
	2, 10, 20, 3, 0, 1, 3, 3, 
	2, 4, 26, 3, 2, 4, 27, 3, 
	10, 1, 13, 3, 10, 1, 14, 3, 
	10, 1, 20, 3, 10, 3, 15, 3, 
	10, 3, 16, 3, 10, 3, 19, 3, 
	10, 11, 1, 3, 10, 12, 1, 5, 
	10, 0, 1, 3, 20, 5, 10, 0, 
	1, 13, 3, 5, 10, 0, 1, 14, 
	3
};

static const short _text_file_key_offsets[] = {
	0, 0, 6, 12, 18, 24, 32, 41, 
	44, 46, 53, 61, 64, 66, 70, 72, 
	76, 78, 83, 91, 99, 102, 104, 112, 
	116, 124, 127, 129, 133, 135, 139, 141, 
	147, 156, 160, 162, 168, 177, 179, 188, 
	196, 205, 209, 217, 225, 233, 238, 244, 
	248, 253, 259, 263, 268, 274, 278, 283, 
	289, 293, 298, 304, 308, 313, 319, 323, 
	331, 334, 336, 344, 348, 352, 354, 360, 
	369, 371, 374, 375, 401, 411, 414, 418, 
	426, 440, 446, 457, 467, 471, 473, 478, 
	482, 484, 489, 499, 520, 525, 530, 551, 
	572, 593, 614, 631, 645, 659, 675, 693, 
	709, 727, 745, 761, 779, 797, 813, 831, 
	849, 865, 877, 889, 902, 913, 913
};

static const char _text_file_trans_keys[] = {
	48, 57, 65, 70, 97, 102, 48, 57, 
	65, 70, 97, 102, 48, 57, 65, 70, 
	97, 102, 48, 57, 65, 70, 97, 102, 
	32, 44, 69, 101, 9, 13, 48, 57, 
	32, 44, 46, 9, 13, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 32, 69, 
	101, 9, 13, 48, 57, 32, 43, 45, 
	46, 9, 13, 48, 57, 46, 48, 57, 
	48, 57, 43, 45, 48, 57, 48, 57, 
	43, 45, 48, 57, 48, 57, 32, 9, 
	13, 48, 57, 32, 46, 69, 101, 9, 
	13, 48, 57, 32, 43, 45, 46, 9, 
	13, 48, 57, 46, 48, 57, 48, 57, 
	32, 44, 69, 101, 9, 13, 48, 57, 
	32, 44, 9, 13, 32, 43, 45, 46, 
	9, 13, 48, 57, 46, 48, 57, 48, 
	57, 43, 45, 48, 57, 48, 57, 43, 
	45, 48, 57, 48, 57, 32, 44, 9, 
	13, 48, 57, 32, 44, 46, 69, 101, 
	9, 13, 48, 57, 43, 45, 48, 57, 
	48, 57, 32, 44, 9, 13, 48, 57, 
	32, 44, 46, 69, 101, 9, 13, 48, 
	57, 48, 57, 32, 44, 46, 9, 13, 
	43, 45, 48, 57, 32, 43, 45, 46, 
	9, 13, 48, 57, 32, 44, 46, 69, 
	101, 9, 13, 48, 57, 32, 44, 9, 
	13, 32, 43, 45, 46, 9, 13, 48, 
	57, 32, 46, 69, 101, 9, 13, 48, 
	57, 32, 43, 45, 46, 9, 13, 48, 
	57, 32, 9, 13, 48, 57, 32, 44, 
	9, 13, 48, 57, 32, 44, 9, 13, 
	32, 9, 13, 48, 57, 32, 44, 9, 
	13, 48, 57, 32, 44, 9, 13, 32, 
	9, 13, 48, 57, 32, 41, 9, 13, 
	48, 57, 32, 41, 9, 13, 32, 9, 
	13, 48, 57, 32, 44, 9, 13, 48, 
	57, 32, 44, 9, 13, 32, 9, 13, 
	48, 57, 32, 44, 9, 13, 48, 57, 
	32, 44, 9, 13, 32, 9, 13, 48, 
	57, 32, 44, 9, 13, 48, 57, 32, 
	44, 9, 13, 32, 43, 45, 46, 9, 
	13, 48, 57, 46, 48, 57, 48, 57, 
	32, 41, 69, 101, 9, 13, 48, 57, 
	32, 41, 9, 13, 43, 45, 48, 57, 
	48, 57, 32, 41, 9, 13, 48, 57, 
	32, 41, 46, 69, 101, 9, 13, 48, 
	57, 10, 42, 10, 42, 47, 10, 10, 
	13, 32, 35, 43, 45, 46, 47, 82, 
	114, 9, 12, 33, 44, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 9, 13, 32, 47, 58, 64, 91, 
	96, 123, 126, 32, 9, 13, 10, 32, 
	9, 13, 33, 47, 58, 64, 91, 96, 
	123, 126, 33, 47, 48, 57, 58, 64, 
	65, 70, 91, 96, 97, 102, 123, 126, 
	48, 57, 65, 70, 97, 102, 46, 33, 
	47, 48, 57, 58, 64, 91, 96, 123, 
	126, 33, 47, 48, 57, 58, 64, 91, 
	96, 123, 126, 69, 101, 48, 57, 48, 
	57, 46, 69, 101, 48, 57, 69, 101, 
	48, 57, 48, 57, 46, 69, 101, 48, 
	57, 42, 47, 33, 46, 58, 64, 91, 
	96, 123, 126, 32, 44, 46, 69, 101, 
	9, 13, 33, 47, 48, 57, 58, 64, 
	65, 70, 91, 96, 97, 102, 123, 126, 
	46, 69, 101, 48, 57, 46, 69, 101, 
	48, 57, 32, 44, 46, 69, 101, 9, 
	13, 33, 47, 48, 57, 58, 64, 65, 
	70, 91, 96, 97, 102, 123, 126, 32, 
	44, 46, 69, 101, 9, 13, 33, 47, 
	48, 57, 58, 64, 65, 70, 91, 96, 
	97, 102, 123, 126, 32, 44, 46, 69, 
	101, 9, 13, 33, 47, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 32, 44, 46, 69, 101, 9, 13, 
	33, 47, 48, 57, 58, 64, 65, 70, 
	91, 96, 97, 102, 123, 126, 32, 44, 
	46, 69, 101, 9, 13, 33, 47, 48, 
	57, 58, 64, 91, 96, 123, 126, 43, 
	45, 9, 13, 32, 47, 48, 57, 58, 
	64, 91, 96, 123, 126, 32, 44, 9, 
	13, 33, 47, 48, 57, 58, 64, 91, 
	96, 123, 126, 9, 13, 32, 47, 48, 
	57, 58, 64, 65, 70, 91, 96, 97, 
	102, 123, 126, 43, 45, 9, 13, 32, 
	47, 48, 57, 58, 64, 65, 70, 91, 
	96, 97, 102, 123, 126, 9, 13, 32, 
	47, 48, 57, 58, 64, 65, 70, 91, 
	96, 97, 102, 123, 126, 43, 45, 9, 
	13, 32, 47, 48, 57, 58, 64, 65, 
	70, 91, 96, 97, 102, 123, 126, 32, 
	44, 9, 13, 33, 47, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 9, 13, 32, 47, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 43, 45, 9, 13, 32, 47, 48, 
	57, 58, 64, 65, 70, 91, 96, 97, 
	102, 123, 126, 32, 44, 9, 13, 33, 
	47, 48, 57, 58, 64, 65, 70, 91, 
	96, 97, 102, 123, 126, 9, 13, 32, 
	47, 48, 57, 58, 64, 65, 70, 91, 
	96, 97, 102, 123, 126, 43, 45, 9, 
	13, 32, 47, 48, 57, 58, 64, 65, 
	70, 91, 96, 97, 102, 123, 126, 32, 
	44, 9, 13, 33, 47, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 9, 13, 32, 47, 48, 57, 58, 
	64, 65, 70, 91, 96, 97, 102, 123, 
	126, 71, 103, 9, 13, 32, 47, 58, 
	64, 91, 96, 123, 126, 66, 98, 9, 
	13, 32, 47, 58, 64, 91, 96, 123, 
	126, 40, 65, 97, 9, 13, 32, 47, 
	58, 64, 91, 96, 123, 126, 40, 9, 
	13, 32, 47, 58, 64, 91, 96, 123, 
	126, 0
};

static const char _text_file_single_lengths[] = {
	0, 0, 0, 0, 0, 4, 3, 1, 
	0, 3, 4, 1, 0, 2, 0, 2, 
	0, 1, 4, 4, 1, 0, 4, 2, 
	4, 1, 0, 2, 0, 2, 0, 2, 
	5, 2, 0, 2, 5, 0, 3, 4, 
	5, 2, 4, 4, 4, 1, 2, 2, 
	1, 2, 2, 1, 2, 2, 1, 2, 
	2, 1, 2, 2, 1, 2, 2, 4, 
	1, 0, 4, 2, 2, 0, 2, 5, 
	2, 3, 1, 10, 0, 1, 2, 0, 
	0, 0, 1, 0, 2, 0, 3, 2, 
	0, 3, 2, 5, 3, 3, 5, 5, 
	5, 5, 5, 2, 2, 0, 2, 0, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	0, 2, 2, 3, 1, 0, 0
};

static const char _text_file_range_lengths[] = {
	0, 3, 3, 3, 3, 2, 3, 1, 
	1, 2, 2, 1, 1, 1, 1, 1, 
	1, 2, 2, 2, 1, 1, 2, 1, 
	2, 1, 1, 1, 1, 1, 1, 2, 
	2, 1, 1, 2, 2, 1, 3, 2, 
	2, 1, 2, 2, 2, 2, 2, 1, 
	2, 2, 1, 2, 2, 1, 2, 2, 
	1, 2, 2, 1, 2, 2, 1, 2, 
	1, 1, 2, 1, 1, 1, 2, 2, 
	0, 0, 0, 8, 5, 1, 1, 4, 
	7, 3, 5, 5, 1, 1, 1, 1, 
	1, 1, 4, 8, 1, 1, 8, 8, 
	8, 8, 6, 6, 6, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 5, 5, 5, 0, 0
};

static const short _text_file_index_offsets[] = {
	0, 0, 4, 8, 12, 16, 23, 30, 
	33, 35, 41, 48, 51, 53, 57, 59, 
	63, 65, 69, 76, 83, 86, 88, 95, 
	99, 106, 109, 111, 115, 117, 121, 123, 
	128, 136, 140, 142, 147, 155, 157, 164, 
	171, 179, 183, 190, 197, 204, 208, 213, 
	217, 221, 226, 230, 234, 239, 243, 247, 
	252, 256, 260, 265, 269, 273, 278, 282, 
	289, 292, 294, 301, 305, 309, 311, 316, 
	324, 327, 331, 333, 352, 358, 361, 365, 
	370, 378, 382, 389, 395, 399, 401, 406, 
	410, 412, 417, 424, 438, 443, 448, 462, 
	476, 490, 504, 516, 525, 534, 543, 554, 
	563, 574, 585, 594, 605, 616, 625, 636, 
	647, 656, 664, 672, 681, 688, 689
};

static const unsigned char _text_file_indicies[] = {
	1, 1, 1, 0, 2, 2, 2, 0, 
	4, 4, 4, 3, 5, 5, 5, 3, 
	7, 8, 10, 10, 7, 9, 6, 11, 
	13, 14, 11, 12, 15, 6, 16, 17, 
	6, 18, 6, 19, 20, 20, 19, 18, 
	6, 21, 22, 22, 23, 21, 24, 6, 
	25, 26, 6, 27, 6, 28, 28, 29, 
	6, 29, 6, 30, 30, 31, 6, 31, 
	6, 19, 19, 31, 6, 19, 16, 20, 
	20, 19, 17, 6, 13, 32, 32, 33, 
	13, 34, 6, 35, 36, 6, 37, 6, 
	38, 39, 40, 40, 38, 37, 6, 41, 
	42, 41, 6, 42, 43, 43, 44, 42, 
	45, 6, 46, 47, 6, 48, 6, 49, 
	49, 50, 6, 50, 6, 51, 51, 52, 
	6, 52, 6, 38, 39, 38, 52, 6, 
	38, 39, 35, 40, 40, 38, 36, 6, 
	53, 53, 54, 6, 54, 6, 7, 8, 
	7, 54, 6, 7, 8, 56, 10, 10, 
	7, 57, 55, 9, 6, 58, 59, 14, 
	58, 12, 60, 6, 59, 32, 32, 33, 
	59, 61, 6, 62, 63, 35, 40, 40, 
	62, 64, 6, 65, 66, 65, 6, 66, 
	43, 43, 44, 66, 67, 6, 68, 16, 
	20, 20, 68, 69, 6, 70, 22, 22, 
	23, 70, 71, 6, 73, 73, 74, 72, 
	75, 76, 75, 77, 72, 78, 79, 78, 
	72, 79, 79, 80, 72, 81, 82, 81, 
	83, 72, 84, 85, 84, 72, 85, 85, 
	86, 72, 87, 88, 87, 89, 72, 90, 
	91, 90, 72, 92, 92, 93, 72, 94, 
	95, 94, 96, 72, 97, 98, 97, 72, 
	98, 98, 99, 72, 100, 101, 100, 102, 
	72, 103, 104, 103, 72, 104, 104, 105, 
	72, 106, 107, 106, 108, 72, 109, 110, 
	109, 72, 110, 111, 111, 112, 110, 113, 
	72, 114, 115, 72, 116, 72, 117, 118, 
	119, 119, 117, 116, 72, 120, 121, 120, 
	72, 122, 122, 123, 72, 123, 72, 117, 
	118, 117, 123, 72, 117, 118, 114, 119, 
	119, 117, 115, 72, 125, 126, 124, 125, 
	126, 127, 124, 129, 128, 132, 133, 131, 
	135, 136, 136, 137, 138, 141, 141, 131, 
	134, 139, 134, 140, 134, 140, 134, 130, 
	6, 6, 6, 6, 6, 130, 131, 131, 
	142, 132, 131, 131, 142, 134, 134, 134, 
	134, 6, 134, 144, 134, 144, 134, 144, 
	134, 143, 146, 146, 146, 145, 148, 134, 
	57, 134, 134, 134, 147, 134, 9, 134, 
	134, 134, 147, 150, 150, 27, 149, 29, 
	149, 25, 150, 150, 26, 149, 152, 152, 
	48, 151, 50, 151, 46, 152, 152, 47, 
	151, 153, 154, 134, 134, 134, 134, 147, 
	156, 157, 56, 160, 160, 156, 155, 158, 
	155, 159, 155, 159, 155, 130, 162, 164, 
	164, 163, 161, 166, 168, 168, 167, 165, 
	156, 157, 56, 171, 171, 156, 155, 169, 
	155, 170, 155, 170, 155, 130, 156, 157, 
	56, 175, 175, 156, 172, 173, 172, 174, 
	172, 174, 172, 130, 156, 157, 56, 178, 
	178, 156, 155, 176, 155, 177, 155, 177, 
	155, 130, 156, 157, 56, 181, 181, 156, 
	155, 179, 155, 180, 155, 180, 155, 130, 
	156, 157, 56, 183, 183, 156, 6, 182, 
	6, 6, 6, 130, 53, 53, 6, 6, 
	184, 6, 6, 6, 130, 7, 8, 7, 
	6, 184, 6, 6, 6, 130, 155, 155, 
	180, 155, 180, 155, 180, 155, 130, 53, 
	53, 155, 155, 185, 155, 180, 155, 180, 
	155, 130, 155, 155, 177, 155, 177, 155, 
	177, 155, 130, 53, 53, 155, 155, 186, 
	155, 177, 155, 177, 155, 130, 7, 8, 
	7, 155, 185, 155, 180, 155, 180, 155, 
	130, 172, 172, 174, 172, 174, 172, 174, 
	172, 130, 53, 53, 172, 172, 187, 172, 
	174, 172, 174, 172, 130, 7, 8, 7, 
	155, 186, 155, 177, 155, 177, 155, 130, 
	155, 155, 170, 155, 170, 155, 170, 155, 
	130, 53, 53, 155, 155, 188, 155, 170, 
	155, 170, 155, 130, 7, 8, 7, 172, 
	187, 172, 174, 172, 174, 172, 130, 155, 
	155, 159, 155, 159, 155, 159, 155, 130, 
	189, 189, 155, 155, 155, 155, 155, 130, 
	190, 190, 155, 155, 155, 155, 155, 130, 
	73, 191, 191, 155, 155, 155, 155, 155, 
	130, 92, 155, 155, 155, 155, 155, 130, 
	192, 192, 0
};

static const char _text_file_trans_targs[] = {
	75, 2, 81, 75, 4, 75, 75, 6, 
	19, 5, 33, 6, 7, 19, 8, 18, 
	8, 18, 9, 10, 15, 10, 11, 12, 
	86, 12, 86, 84, 14, 85, 16, 17, 
	20, 21, 32, 21, 32, 22, 23, 24, 
	29, 23, 24, 25, 26, 89, 26, 89, 
	87, 28, 88, 30, 31, 34, 35, 75, 
	37, 36, 38, 39, 43, 40, 41, 42, 
	40, 41, 42, 92, 44, 43, 44, 93, 
	75, 45, 46, 47, 48, 46, 47, 48, 
	49, 50, 51, 49, 50, 51, 52, 53, 
	75, 52, 53, 75, 54, 55, 56, 57, 
	55, 56, 57, 58, 59, 60, 58, 59, 
	60, 61, 62, 63, 61, 62, 63, 64, 
	65, 71, 65, 71, 66, 67, 75, 68, 
	67, 75, 69, 70, 72, 72, 73, 117, 
	74, 118, 76, 77, 77, 78, 79, 80, 
	82, 83, 90, 91, 112, 113, 75, 75, 
	1, 75, 3, 75, 83, 75, 13, 75, 
	27, 79, 79, 75, 38, 39, 94, 109, 
	110, 75, 26, 92, 27, 75, 12, 93, 
	13, 95, 106, 107, 75, 96, 103, 104, 
	97, 101, 102, 98, 76, 99, 98, 99, 
	100, 100, 105, 108, 111, 114, 115, 116, 
	0
};

static const unsigned char _text_file_trans_actions[] = {
	41, 0, 19, 39, 0, 21, 47, 7, 
	7, 0, 0, 0, 5, 0, 5, 5, 
	0, 0, 0, 7, 0, 0, 5, 5, 
	119, 0, 76, 76, 0, 0, 0, 0, 
	5, 5, 5, 0, 0, 0, 7, 7, 
	0, 0, 0, 5, 5, 115, 0, 73, 
	73, 0, 0, 0, 0, 0, 0, 43, 
	0, 0, 0, 0, 91, 91, 52, 52, 
	1, 0, 0, 141, 52, 1, 0, 147, 
	45, 0, 49, 3, 3, 1, 0, 0, 
	49, 3, 3, 1, 0, 0, 49, 3, 
	55, 1, 0, 23, 0, 49, 3, 3, 
	1, 0, 0, 49, 3, 3, 1, 0, 
	0, 49, 3, 3, 1, 0, 0, 5, 
	5, 5, 0, 0, 0, 7, 58, 0, 
	0, 25, 0, 0, 0, 9, 0, 11, 
	0, 13, 88, 0, 9, 0, 85, 19, 
	123, 123, 0, 135, 0, 0, 33, 31, 
	0, 27, 0, 35, 85, 64, 0, 61, 
	0, 82, 79, 37, 52, 52, 111, 0, 
	88, 95, 3, 103, 3, 99, 3, 107, 
	3, 131, 0, 70, 29, 111, 0, 88, 
	111, 0, 88, 127, 67, 67, 111, 88, 
	88, 67, 88, 88, 70, 0, 19, 19, 
	0
};

static const unsigned char _text_file_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	15, 0, 15, 15, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const unsigned char _text_file_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 17, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _text_file_eof_trans[] = {
	0, 1, 1, 4, 4, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 56, 7, 7, 7, 
	7, 7, 7, 7, 7, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	0, 0, 0, 0, 7, 143, 143, 7, 
	144, 146, 148, 148, 150, 150, 150, 152, 
	152, 152, 148, 156, 162, 166, 156, 173, 
	156, 156, 7, 7, 7, 156, 156, 156, 
	156, 156, 173, 173, 156, 156, 156, 173, 
	156, 156, 156, 156, 156, 0, 0
};

static const int text_file_start = 75;
static const int text_file_first_final = 75;
static const int text_file_error = 0;

static const int text_file_en_multi_line_comment = 72;
static const int text_file_en_single_line_comment = 74;
static const int text_file_en_main = 75;


#line 165 "source/parser/TextFileParser.rl"

bool scanner(TextFile &text_file, const Configuration &configuration)
{
	FSM fsm_struct;
	FSM *fsm = &fsm_struct;
	fsm->ts = 0;
	fsm->te = 0;
	fsm->line = 0;
	fsm->line_start = 0;
	fsm->column = 0;
	fsm->buffer_offset = 0;
	bool parse_error = false;
	fsm->addColor = [&text_file](const Color &color){
		text_file.addColor(color.normalizeRgb());
	};
	
#line 577 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
	{
	 fsm->cs = text_file_start;
	 fsm->ts = 0;
	 fsm->te = 0;
	 fsm->act = 0;
	}

#line 181 "source/parser/TextFileParser.rl"
	int have = 0;
	while (1){
		char *p = fsm->buffer + have;
		int space = sizeof(fsm->buffer) - have;
		if (space == 0){
			text_file.outOfMemory();
			break;
		}
		char *eof = 0;
		auto read_size = text_file.read(fsm->buffer + have, space);
		char *pe = p + read_size;
		if (read_size > 0){
			if (read_size < sizeof(fsm->buffer)) eof = pe;
			
#line 600 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if (  fsm->cs == 0 )
		goto _out;
_resume:
	_acts = _text_file_actions + _text_file_from_state_actions[ fsm->cs];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 ) {
		switch ( *_acts++ ) {
	case 9:
#line 1 "NONE"
	{ fsm->ts = p;}
	break;
#line 621 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
		}
	}

	_keys = _text_file_trans_keys + _text_file_key_offsets[ fsm->cs];
	_trans = _text_file_index_offsets[ fsm->cs];

	_klen = _text_file_single_lengths[ fsm->cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _text_file_range_lengths[ fsm->cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _text_file_indicies[_trans];
_eof_trans:
	 fsm->cs = _text_file_trans_targs[_trans];

	if ( _text_file_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _text_file_actions + _text_file_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 132 "source/parser/TextFileParser.rl"
	{ fsm->number_i64 = 0; }
	break;
	case 1:
#line 132 "source/parser/TextFileParser.rl"
	{ fsm->number_i64 = fsm->number_i64 * 10 + (*p - '0'); }
	break;
	case 2:
#line 135 "source/parser/TextFileParser.rl"
	{ fsm->numbers_i64.push_back(fsm->number_i64); }
	break;
	case 3:
#line 136 "source/parser/TextFileParser.rl"
	{ fsm->number_double_start = p; }
	break;
	case 4:
#line 136 "source/parser/TextFileParser.rl"
	{ fsm->numbers_double.push_back(fsm->parseDouble(fsm->number_double_start, p)); }
	break;
	case 5:
#line 138 "source/parser/TextFileParser.rl"
	{ fsm->handleNewline(); }
	break;
	case 6:
#line 140 "source/parser/TextFileParser.rl"
	{ { fsm->cs = 75;goto _again;} }
	break;
	case 7:
#line 141 "source/parser/TextFileParser.rl"
	{ { fsm->cs = 75;goto _again;} }
	break;
	case 10:
#line 1 "NONE"
	{ fsm->te = p+1;}
	break;
	case 11:
#line 146 "source/parser/TextFileParser.rl"
	{ fsm->act = 3;}
	break;
	case 12:
#line 147 "source/parser/TextFileParser.rl"
	{ fsm->act = 4;}
	break;
	case 13:
#line 150 "source/parser/TextFileParser.rl"
	{ fsm->act = 7;}
	break;
	case 14:
#line 151 "source/parser/TextFileParser.rl"
	{ fsm->act = 8;}
	break;
	case 15:
#line 152 "source/parser/TextFileParser.rl"
	{ fsm->act = 9;}
	break;
	case 16:
#line 153 "source/parser/TextFileParser.rl"
	{ fsm->act = 10;}
	break;
	case 17:
#line 154 "source/parser/TextFileParser.rl"
	{ fsm->act = 11;}
	break;
	case 18:
#line 155 "source/parser/TextFileParser.rl"
	{ fsm->act = 12;}
	break;
	case 19:
#line 158 "source/parser/TextFileParser.rl"
	{ fsm->act = 15;}
	break;
	case 20:
#line 159 "source/parser/TextFileParser.rl"
	{ fsm->act = 16;}
	break;
	case 21:
#line 144 "source/parser/TextFileParser.rl"
	{ fsm->te = p+1;{ if (configuration.full_hex) fsm->colorHexFull(true); }}
	break;
	case 22:
#line 148 "source/parser/TextFileParser.rl"
	{ fsm->te = p+1;{ if (configuration.css_rgb) fsm->colorRgb(); else fsm->clearNumberStacks(); }}
	break;
	case 23:
#line 149 "source/parser/TextFileParser.rl"
	{ fsm->te = p+1;{ if (configuration.css_rgba) fsm->colorRgba(); else fsm->clearNumberStacks(); }}
	break;
	case 24:
#line 145 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.short_hex) fsm->colorHexShort(true); }}
	break;
	case 25:
#line 147 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.short_hex) fsm->colorHexShort(false); }}
	break;
	case 26:
#line 150 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.int_values) fsm->colorValueIntegers(); else fsm->clearNumberStacks(); }}
	break;
	case 27:
#line 151 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.int_values) fsm->colorValueIntegers(); else fsm->clearNumberStacks(); }}
	break;
	case 28:
#line 152 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.float_values) fsm->colorValues(); else fsm->clearNumberStacks(); }}
	break;
	case 29:
#line 153 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.float_values) fsm->colorValues(); else fsm->clearNumberStacks(); }}
	break;
	case 30:
#line 156 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ if (configuration.single_line_hash_comments) { fsm->cs = 74;goto _again;} }}
	break;
	case 31:
#line 157 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ }}
	break;
	case 32:
#line 158 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ }}
	break;
	case 33:
#line 159 "source/parser/TextFileParser.rl"
	{ fsm->te = p;p--;{ }}
	break;
	case 34:
#line 145 "source/parser/TextFileParser.rl"
	{{p = (( fsm->te))-1;}{ if (configuration.short_hex) fsm->colorHexShort(true); }}
	break;
	case 35:
#line 156 "source/parser/TextFileParser.rl"
	{{p = (( fsm->te))-1;}{ if (configuration.single_line_hash_comments) { fsm->cs = 74;goto _again;} }}
	break;
	case 36:
#line 158 "source/parser/TextFileParser.rl"
	{{p = (( fsm->te))-1;}{ }}
	break;
	case 37:
#line 159 "source/parser/TextFileParser.rl"
	{{p = (( fsm->te))-1;}{ }}
	break;
	case 38:
#line 1 "NONE"
	{	switch(  fsm->act ) {
	case 3:
	{{p = (( fsm->te))-1;} if (configuration.full_hex) fsm->colorHexFull(false); }
	break;
	case 4:
	{{p = (( fsm->te))-1;} if (configuration.short_hex) fsm->colorHexShort(false); }
	break;
	case 7:
	{{p = (( fsm->te))-1;} if (configuration.int_values) fsm->colorValueIntegers(); else fsm->clearNumberStacks(); }
	break;
	case 8:
	{{p = (( fsm->te))-1;} if (configuration.int_values) fsm->colorValueIntegers(); else fsm->clearNumberStacks(); }
	break;
	case 9:
	{{p = (( fsm->te))-1;} if (configuration.float_values) fsm->colorValues(); else fsm->clearNumberStacks(); }
	break;
	case 10:
	{{p = (( fsm->te))-1;} if (configuration.float_values) fsm->colorValues(); else fsm->clearNumberStacks(); }
	break;
	case 11:
	{{p = (( fsm->te))-1;} if (configuration.single_line_c_comments) { fsm->cs = 74;goto _again;} }
	break;
	case 12:
	{{p = (( fsm->te))-1;}  if (configuration.multi_line_c_comments) { fsm->cs = 72;goto _again;} }
	break;
	case 15:
	{{p = (( fsm->te))-1;} }
	break;
	case 16:
	{{p = (( fsm->te))-1;} }
	break;
	}
	}
	break;
#line 867 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
		}
	}

_again:
	_acts = _text_file_actions + _text_file_to_state_actions[ fsm->cs];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 ) {
		switch ( *_acts++ ) {
	case 8:
#line 1 "NONE"
	{ fsm->ts = 0;}
	break;
#line 880 "/build/gpick/src/gpick-0.3/build/CMakeFiles/TextFileParser.cpp"
		}
	}

	if (  fsm->cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _text_file_eof_trans[ fsm->cs] > 0 ) {
		_trans = _text_file_eof_trans[ fsm->cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}

#line 195 "source/parser/TextFileParser.rl"
			if (fsm->cs == text_file_error) {
				parse_error = true;
				text_file.syntaxError(fsm->line, fsm->ts - fsm->buffer - fsm->line_start, fsm->line, fsm->te - fsm->buffer - fsm->line_start);
				break;
			}
			if (fsm->ts == 0){
				have = 0;
				fsm->line_start -= sizeof(fsm->buffer);
			}else{
				have = pe - fsm->ts;
				memmove(fsm->buffer, fsm->ts, have);
				int buffer_movement = fsm->ts - fsm->buffer;
				fsm->te -= buffer_movement;
				fsm->line_start -= buffer_movement;
				fsm->ts = fsm->buffer;
				fsm->buffer_offset += fsm->ts - fsm->buffer;
			}
		}else{
			break;
		}
	}
	return parse_error == false;
}

}
