/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_correlate_access_code_ff_ts = R"doc(Examine input for specified access code, one bit at a time.

input: stream of floats (generally, soft decisions) output: a tagged stream set of samples from the payload following the access code and header.


This block searches for the given access code by slicing the soft decision symbol inputs. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


The output of this block is appropriate for use with tagged stream blocks.

Constructor Specific Documentation:



Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong
    tag_name : key of the tag inserted into the tag stream)doc";


static const char*
    __doc_gr_digital_correlate_access_code_ff_ts_correlate_access_code_ff_ts_0 =
        R"doc()doc";


static const char*
    __doc_gr_digital_correlate_access_code_ff_ts_correlate_access_code_ff_ts_1 =
        R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_ff_ts_make = R"doc(Examine input for specified access code, one bit at a time.

input: stream of floats (generally, soft decisions) output: a tagged stream set of samples from the payload following the access code and header.


This block searches for the given access code by slicing the soft decision symbol inputs. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


The output of this block is appropriate for use with tagged stream blocks.

Constructor Specific Documentation:



Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong
    tag_name : key of the tag inserted into the tag stream)doc";


static const char* __doc_gr_digital_correlate_access_code_ff_ts_set_access_code =
    R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_ff_ts_access_code = R"doc()doc";
