/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_ctrlport_probe2_b = R"doc(A ControlPort probe to export vectors of signals.

This block acts as a sink in the flowgraph but also exports vectors of complex samples over ControlPort. This block holds the latest  number of complex samples so that every query by a ControlPort client will get the same length vector.

Constructor Specific Documentation:

Make a ControlPort probe block.

Args:
    id : A string ID to name the probe over ControlPort.
    desc : A string describing the probe.
    len : Number of samples to transmit.
    disp_mask : Mask to set default display params.)doc";


static const char* __doc_gr_blocks_ctrlport_probe2_b_ctrlport_probe2_b_0 = R"doc()doc";


static const char* __doc_gr_blocks_ctrlport_probe2_b_ctrlport_probe2_b_1 = R"doc()doc";


static const char* __doc_gr_blocks_ctrlport_probe2_b_make = R"doc(A ControlPort probe to export vectors of signals.

This block acts as a sink in the flowgraph but also exports vectors of complex samples over ControlPort. This block holds the latest  number of complex samples so that every query by a ControlPort client will get the same length vector.

Constructor Specific Documentation:

Make a ControlPort probe block.

Args:
    id : A string ID to name the probe over ControlPort.
    desc : A string describing the probe.
    len : Number of samples to transmit.
    disp_mask : Mask to set default display params.)doc";


static const char* __doc_gr_blocks_ctrlport_probe2_b_get = R"doc()doc";


static const char* __doc_gr_blocks_ctrlport_probe2_b_set_length = R"doc()doc";
