/* taquin-main.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from taquin-main.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Taquin.

   Copyright (C) 2014-2020 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME Taquin is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Taquin is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Taquin.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gsound.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>

#define TAQUIN_PROGRAM_NAME _ ("Taquin")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_APPLICATION (base_application_get_type ())
#define BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_APPLICATION, BaseApplication))
#define IS_BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_APPLICATION))
#define BASE_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BASE_APPLICATION, BaseApplicationIface))

typedef struct _BaseApplication BaseApplication;
typedef struct _BaseApplicationIface BaseApplicationIface;

#define TYPE_TAQUIN (taquin_get_type ())
#define TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN, Taquin))
#define TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN, TaquinClass))
#define IS_TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN))
#define IS_TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN))
#define TAQUIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN, TaquinClass))

typedef struct _Taquin Taquin;
typedef struct _TaquinClass TaquinClass;
typedef struct _TaquinPrivate TaquinPrivate;
typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;

#define TYPE_NEW_GAME_SCREEN (new_game_screen_get_type ())
#define NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreen))
#define NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))
#define IS_NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_SCREEN))
#define IS_NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_SCREEN))
#define NEW_GAME_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))

typedef struct _NewGameScreen NewGameScreen;
typedef struct _NewGameScreenClass NewGameScreenClass;

#define TYPE_HISTORY_BUTTON (history_button_get_type ())
#define HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_BUTTON, HistoryButton))
#define HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_BUTTON, HistoryButtonClass))
#define IS_HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_BUTTON))
#define IS_HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_BUTTON))
#define HISTORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_BUTTON, HistoryButtonClass))

typedef struct _HistoryButton HistoryButton;
typedef struct _HistoryButtonClass HistoryButtonClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_NIGHT_LIGHT_MONITOR (night_light_monitor_get_type ())
#define NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor))
#define NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))
#define IS_NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_LIGHT_MONITOR))
#define IS_NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_LIGHT_MONITOR))
#define NIGHT_LIGHT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))

typedef struct _NightLightMonitor NightLightMonitor;
typedef struct _NightLightMonitorClass NightLightMonitorClass;
typedef enum  {
	TAQUIN_SOUND_CONTEXT_STATE_INITIAL,
	TAQUIN_SOUND_CONTEXT_STATE_WORKING,
	TAQUIN_SOUND_CONTEXT_STATE_ERRORED
} TaquinSoundContextState;

#define TAQUIN_TYPE_SOUND_CONTEXT_STATE (taquin_sound_context_state_get_type ())
enum  {
	TAQUIN_0_PROPERTY,
	TAQUIN_NUM_PROPERTIES
};
static GParamSpec* taquin_properties[TAQUIN_NUM_PROPERTIES];
typedef enum  {
	TAQUIN_SOUND_SLIDING_1,
	TAQUIN_SOUND_SLIDING_N,
	TAQUIN_SOUND_GAME_OVER
} TaquinSound;

#define TAQUIN_TYPE_SOUND (taquin_sound_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef enum  {
	NEW_GAME_SCREEN_MENU_BUTTON_ONE,
	NEW_GAME_SCREEN_MENU_BUTTON_TWO
} NewGameScreenMenuButton;

#define NEW_GAME_SCREEN_TYPE_MENU_BUTTON (new_game_screen_menu_button_get_type ())
typedef enum  {
	GAME_WINDOW_FLAGS_HAS_SOUND = 1 << 0,
	GAME_WINDOW_FLAGS_SHORTCUTS = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HELP = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
typedef enum  {
	GAME_BAD_CLICK_EMPTY_TILE,
	GAME_BAD_CLICK_NOT_MOVING,
	GAME_BAD_CLICK_IS_OUTSIDE,
	GAME_BAD_CLICK_USE_ARROWS
} GameBadClick;

#define GAME_TYPE_BAD_CLICK (game_bad_click_get_type ())
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BaseApplicationIface {
	GTypeInterface parent_iface;
	void (*copy) (BaseApplication* self, const gchar* text);
	void (*get_about_dialog_infos) (BaseApplication* self, gchar*** artists, gint* artists_length1, gchar*** authors, gint* authors_length1, gchar** comments, gchar** copyright, gchar*** documenters, gint* documenters_length1, gchar** logo_icon_name, gchar** program_name, gchar** translator_credits, gchar** version, gchar** website, gchar** website_label);
};

struct _Taquin {
	GtkApplication parent_instance;
	TaquinPrivate * priv;
};

struct _TaquinClass {
	GtkApplicationClass parent_class;
};

struct _TaquinPrivate {
	GSettings* settings;
	GameType* tmp_type;
	gboolean size_changed;
	gboolean theme_changed;
	GameWindow* window;
	TaquinView* view;
	NewGameScreen* new_game_screen;
	HistoryButton* history_button_1;
	HistoryButton* history_button_2;
	GMenu* size_menu_fifteen;
	GMenu* size_menu_sixteen;
	Game* game;
	GList* theme_dirlist;
	NightLightMonitor* night_light_monitor;
	gboolean move_done;
	GSoundContext* sound_context;
	TaquinSoundContextState sound_context_state;
};

static gint Taquin_private_offset;
static gpointer taquin_parent_class = NULL;
static gint taquin_tmp_size;
static gint taquin_tmp_size = 0;
static gboolean* taquin_sound;
static gboolean* taquin_sound = NULL;
static BaseApplicationIface * taquin_base_application_parent_iface = NULL;

VALA_EXTERN GType base_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseApplication, g_object_unref)
VALA_EXTERN GType taquin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Taquin, g_object_unref)
VALA_EXTERN GType game_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType taquin_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TaquinView, g_object_unref)
VALA_EXTERN GType new_game_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameScreen, g_object_unref)
VALA_EXTERN GType history_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryButton, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType night_light_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightLightMonitor, g_object_unref)
static GType taquin_sound_context_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType taquin_sound_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void taquin_play_fifteen_game (Taquin* self);
static void _taquin_play_fifteen_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void taquin_play_sixteen_game (Taquin* self);
static void _taquin_play_sixteen_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void taquin_change_size_cb (Taquin* self,
                            GSimpleAction* action,
                            GVariant* variant);
static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void taquin_change_theme_cb (Taquin* self,
                             GSimpleAction* action,
                             GVariant* variant);
static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void taquin_set_use_night_mode (Taquin* self,
                                GSimpleAction* action,
                                GVariant* gvariant);
static void _taquin_set_use_night_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static gint taquin_main (gchar** args,
                  gint args_length1);
static Taquin* taquin_new (void);
static Taquin* taquin_construct (GType object_type);
static gint taquin_real_handle_local_options (GApplication* base,
                                       GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static GameType* _game_type_dup (GameType* self);
static void taquin_real_startup (GApplication* base);
VALA_EXTERN gchar* game_type_to_string (GameType self);
static void taquin_create_window (Taquin* self);
VALA_EXTERN TaquinView* taquin_view_new (void);
VALA_EXTERN TaquinView* taquin_view_construct (GType object_type);
VALA_EXTERN NewGameScreen* new_game_screen_new (const gchar* modelbutton_one_label,
                                    const gchar* modelbutton_one_action,
                                    const gchar* modelbutton_two_label,
                                    const gchar* modelbutton_two_action);
VALA_EXTERN NewGameScreen* new_game_screen_construct (GType object_type,
                                          const gchar* modelbutton_one_label,
                                          const gchar* modelbutton_one_action,
                                          const gchar* modelbutton_two_label,
                                          const gchar* modelbutton_two_action);
static void __lambda16_ (Taquin* self);
VALA_EXTERN GType new_game_screen_menu_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void new_game_screen_update_menubutton_menu (NewGameScreen* self,
                                             NewGameScreenMenuButton button,
                                             GMenu* menu);
static void ___lambda16__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN HistoryButton* history_button_new (void);
VALA_EXTERN HistoryButton* history_button_construct (GType object_type);
static void taquin_init_night_mode (Taquin* self);
VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             const gchar* about_action_label,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* view_content,
                             GMenu* appearance_menu,
                             GtkWidget* game_widget_1,
                             GtkWidget* game_widget_2,
                             NightLightMonitor* night_light_monitor);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   const gchar* about_action_label,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* view_content,
                                   GMenu* appearance_menu,
                                   GtkWidget* game_widget_1,
                                   GtkWidget* game_widget_2,
                                   NightLightMonitor* night_light_monitor);
static void taquin_start_game (Taquin* self);
static void _taquin_start_game_game_window_play (GameWindow* _sender,
                                          gpointer self);
static void taquin_back_cb (Taquin* self);
static void _taquin_back_cb_game_window_back (GameWindow* _sender,
                                       gpointer self);
static void taquin_undo_cb (Taquin* self);
static void _taquin_undo_cb_game_window_undo (GameWindow* _sender,
                                       gpointer self);
static void taquin_restart_cb (Taquin* self);
static void _taquin_restart_cb_game_window_restart (GameWindow* _sender,
                                             gpointer self);
static void __lambda17_ (Taquin* self);
static void taquin_update_size_button_label (Taquin* self,
                                      gint size);
static void ___lambda17__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda18_ (Taquin* self);
static void taquin_update_theme (Taquin* self,
                          const gchar* theme_id);
static void ___lambda18__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void taquin_init_sound (Taquin* self);
static void taquin_real_activate (GApplication* base);
static void taquin_real_shutdown (GApplication* base);
VALA_EXTERN NightLightMonitor* night_light_monitor_new (const gchar* _schema_path);
VALA_EXTERN NightLightMonitor* night_light_monitor_construct (GType object_type,
                                                  const gchar* _schema_path);
VALA_EXTERN void night_light_monitor_set_use_night_mode (NightLightMonitor* self,
                                             gboolean night_mode_state);
VALA_EXTERN void history_button_new_game (HistoryButton* self);
VALA_EXTERN Game* game_new (GameType game_type,
                gint8 size);
VALA_EXTERN Game* game_construct (GType object_type,
                      GameType game_type,
                      gint8 size);
static void taquin_set_window_title (Taquin* self);
VALA_EXTERN void taquin_view_set_game (TaquinView* self,
                           Game* value);
VALA_EXTERN void game_window_move_done (GameWindow* self,
                            guint moves_count);
VALA_EXTERN void history_button_set_moves_count (HistoryButton* self,
                                     guint moves_count);
VALA_EXTERN void taquin_view_set_theme (TaquinView* self,
                            const gchar* value);
static void taquin_game_complete_cb (Taquin* self);
static void _taquin_game_complete_cb_game_complete (Game* _sender,
                                             gpointer self);
VALA_EXTERN GType game_bad_click_get_type (void) G_GNUC_CONST ;
static void taquin_bad_click_cb (Taquin* self,
                          GameBadClick reason,
                          gboolean keyboard_call);
static void _taquin_bad_click_cb_game_bad_click (Game* _sender,
                                          GameBadClick reason,
                                          gboolean keyboard_call,
                                          gpointer self);
static void taquin_move_cb (Taquin* self,
                     gboolean x_axis,
                     gint8 number,
                     gint8 x_gap,
                     gint8 y_gap,
                     guint moves_count,
                     gboolean disable_animation);
static void _taquin_move_cb_game_move (Game* _sender,
                                gboolean x_axis,
                                gint8 number,
                                gint8 x_gap,
                                gint8 y_gap,
                                guint moves_count,
                                gboolean disable_animation,
                                gpointer self);
VALA_EXTERN GameType game_get_game_type (Game* self);
VALA_EXTERN void game_window_update_title (GameWindow* self,
                               const gchar* game_name);
VALA_EXTERN void game_restart (Game* self);
static void taquin_play_sound (Taquin* self,
                        TaquinSound sound);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_window_finish_game (GameWindow* self);
VALA_EXTERN void history_button_save_best_score (HistoryButton* self,
                                     gchar** best_score_string);
VALA_EXTERN void base_window_show_notification (BaseWindow* self,
                                    const gchar* notification);
VALA_EXTERN void new_game_screen_update_menubutton_label (NewGameScreen* self,
                                              NewGameScreenMenuButton button,
                                              const gchar* label);
VALA_EXTERN gchar* new_game_screen_get_size_button_label (gint size);
static gboolean _taquin_update_theme (Taquin* self,
                               const gchar* theme_id);
static inline gchar* taquin_get_theme_button_label (const gchar* theme_id);
static void _taquin_play_sound (TaquinSound sound,
                         GSoundContext* sound_context);
static void taquin_real_copy (BaseApplication* base,
                       const gchar* text);
static void taquin_real_get_about_dialog_infos (BaseApplication* base,
                                         gchar*** artists,
                                         gint* artists_length1,
                                         gchar*** authors,
                                         gint* authors_length1,
                                         gchar** comments,
                                         gchar** copyright,
                                         gchar*** documenters,
                                         gint* documenters_length1,
                                         gchar** logo_icon_name,
                                         gchar** program_name,
                                         gchar** translator_credits,
                                         gchar** version,
                                         gchar** website,
                                         gchar** website_label);
VALA_EXTERN void base_application_copy (BaseApplication* self,
                            const gchar* text);
VALA_EXTERN void base_application_get_about_dialog_infos (BaseApplication* self,
                                              gchar*** artists,
                                              gint* artists_length1,
                                              gchar*** authors,
                                              gint* authors_length1,
                                              gchar** comments,
                                              gchar** copyright,
                                              gchar*** documenters,
                                              gint* documenters_length1,
                                              gchar** logo_icon_name,
                                              gchar** program_name,
                                              gchar** translator_credits,
                                              gchar** version,
                                              gchar** website,
                                              gchar** website_label);
static void taquin_finalize (GObject * obj);
static GType taquin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GOptionEntry TAQUIN_option_entries[7] = {{"fifteen", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Play the classical 1880s’ 15-puzzle"), NULL}, {"sixteen", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Try this fun alternative 16-puzzle"), NULL}, {"size", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &taquin_tmp_size, N_ ("Sets the puzzle edges’ size (3-5, 2-9 for debug)"), N_ ("SIZE")}, {"mute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn off the sound"), NULL}, {"unmute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn on the sound"), NULL}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {0}};
static const GActionEntry TAQUIN_action_entries[6] = {{"fifteen", _taquin_play_fifteen_game_gsimple_action_activate_callback}, {"sixteen", _taquin_play_sixteen_game_gsimple_action_activate_callback}, {"change-size", _taquin_change_size_cb_gsimple_action_activate_callback, "s"}, {"change-theme", _taquin_change_theme_cb_gsimple_action_activate_callback, "s"}, {"set-use-night-mode", _taquin_set_use_night_mode_gsimple_action_activate_callback, "b"}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static inline gpointer
taquin_get_instance_private (Taquin* self)
{
	return G_STRUCT_MEMBER_P (self, Taquin_private_offset);
}

static GType
taquin_sound_get_type_once (void)
{
	static const GEnumValue values[] = {{TAQUIN_SOUND_SLIDING_1, "TAQUIN_SOUND_SLIDING_1", "sliding-1"}, {TAQUIN_SOUND_SLIDING_N, "TAQUIN_SOUND_SLIDING_N", "sliding-n"}, {TAQUIN_SOUND_GAME_OVER, "TAQUIN_SOUND_GAME_OVER", "game-over"}, {0, NULL, NULL}};
	GType taquin_sound_type_id;
	taquin_sound_type_id = g_enum_register_static ("TaquinSound", values);
	return taquin_sound_type_id;
}

static GType
taquin_sound_get_type (void)
{
	static volatile gsize taquin_sound_type_id__once = 0;
	if (g_once_init_enter (&taquin_sound_type_id__once)) {
		GType taquin_sound_type_id;
		taquin_sound_type_id = taquin_sound_get_type_once ();
		g_once_init_leave (&taquin_sound_type_id__once, taquin_sound_type_id);
	}
	return taquin_sound_type_id__once;
}

static GType
taquin_sound_context_state_get_type_once (void)
{
	static const GEnumValue values[] = {{TAQUIN_SOUND_CONTEXT_STATE_INITIAL, "TAQUIN_SOUND_CONTEXT_STATE_INITIAL", "initial"}, {TAQUIN_SOUND_CONTEXT_STATE_WORKING, "TAQUIN_SOUND_CONTEXT_STATE_WORKING", "working"}, {TAQUIN_SOUND_CONTEXT_STATE_ERRORED, "TAQUIN_SOUND_CONTEXT_STATE_ERRORED", "errored"}, {0, NULL, NULL}};
	GType taquin_sound_context_state_type_id;
	taquin_sound_context_state_type_id = g_enum_register_static ("TaquinSoundContextState", values);
	return taquin_sound_context_state_type_id;
}

static GType
taquin_sound_context_state_get_type (void)
{
	static volatile gsize taquin_sound_context_state_type_id__once = 0;
	if (g_once_init_enter (&taquin_sound_context_state_type_id__once)) {
		GType taquin_sound_context_state_type_id;
		taquin_sound_context_state_type_id = taquin_sound_context_state_get_type_once ();
		g_once_init_leave (&taquin_sound_context_state_type_id__once, taquin_sound_context_state_type_id);
	}
	return taquin_sound_context_state_type_id__once;
}

static void
_taquin_play_fifteen_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	taquin_play_fifteen_game ((Taquin*) self);
}

static void
_taquin_play_sixteen_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	taquin_play_sixteen_game ((Taquin*) self);
}

static void
_taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	taquin_change_size_cb ((Taquin*) self, action, parameter);
}

static void
_taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	taquin_change_theme_cb ((Taquin*) self, action, parameter);
}

static void
_taquin_set_use_night_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	taquin_set_use_night_mode ((Taquin*) self, action, parameter);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gint
taquin_main (gchar** args,
             gint args_length1)
{
	Taquin* _tmp0_;
	Taquin* _tmp1_;
	gint _tmp2_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (TAQUIN_PROGRAM_NAME);
	g_set_prgname ("org.gnome.Taquin");
	gtk_window_set_default_icon_name ("org.gnome.Taquin");
	_tmp0_ = taquin_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return taquin_main (argv, argc);
}

static Taquin*
taquin_construct (GType object_type)
{
	Taquin * self = NULL;
	self = (Taquin*) g_object_new (object_type, "application-id", "org.gnome.Taquin", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, TAQUIN_option_entries);
	return self;
}

static Taquin*
taquin_new (void)
{
	return taquin_construct (TYPE_TAQUIN);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static GameType*
_game_type_dup (GameType* self)
{
	GameType* dup;
	dup = g_new0 (GameType, 1);
	memcpy (dup, self, sizeof (GameType));
	return dup;
}

static gpointer
__game_type_dup0 (gpointer self)
{
	return self ? _game_type_dup (self) : NULL;
}

static gint
taquin_real_handle_local_options (GApplication* base,
                                  GVariantDict* options)
{
	Taquin * self;
	gboolean _tmp1_ = FALSE;
	gint result;
	self = (Taquin*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "gnome-taquin", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (taquin_tmp_size != 0) {
		_tmp1_ = taquin_tmp_size < 2;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		taquin_tmp_size = 2;
	}
	if (g_variant_dict_contains (options, "mute")) {
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp2_ = FALSE;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (taquin_sound);
		taquin_sound = _tmp3_;
	} else {
		if (g_variant_dict_contains (options, "unmute")) {
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp4_ = TRUE;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (taquin_sound);
			taquin_sound = _tmp5_;
		}
	}
	if (g_variant_dict_contains (options, "fifteen")) {
		GameType _tmp6_;
		GameType* _tmp7_;
		_tmp6_ = GAME_TYPE_FIFTEEN;
		_tmp7_ = __game_type_dup0 (&_tmp6_);
		_g_free0 (self->priv->tmp_type);
		self->priv->tmp_type = _tmp7_;
	} else {
		if (g_variant_dict_contains (options, "sixteen")) {
			GameType _tmp8_;
			GameType* _tmp9_;
			_tmp8_ = GAME_TYPE_SIXTEEN;
			_tmp9_ = __game_type_dup0 (&_tmp8_);
			_g_free0 (self->priv->tmp_type);
			self->priv->tmp_type = _tmp9_;
		}
	}
	result = -1;
	return result;
}

static void
taquin_real_startup (GApplication* base)
{
	Taquin * self;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	GSettings* _tmp55_;
	GAction* _tmp56_;
	GAction* _tmp57_;
	GSettings* _tmp58_;
	GAction* _tmp59_;
	GAction* _tmp60_;
	self = (Taquin*) base;
	G_APPLICATION_CLASS (taquin_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.Taquin");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp3_ = taquin_sound;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = taquin_tmp_size > 1;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GameType* _tmp4_;
		_tmp4_ = self->priv->tmp_type;
		_tmp1_ = _tmp4_ != NULL;
	}
	if (_tmp1_) {
		GSettings* _tmp5_;
		gboolean* _tmp6_;
		GameType* _tmp10_;
		GSettings* _tmp15_;
		_tmp5_ = self->priv->settings;
		g_settings_delay (_tmp5_);
		_tmp6_ = taquin_sound;
		if (_tmp6_ != NULL) {
			GSettings* _tmp7_;
			gboolean* _tmp8_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = taquin_sound;
			g_settings_set_boolean (_tmp7_, "sound", (gboolean) (*_tmp8_));
		}
		if (taquin_tmp_size > 1) {
			GSettings* _tmp9_;
			_tmp9_ = self->priv->settings;
			g_settings_set_int (_tmp9_, "size", taquin_tmp_size);
		}
		_tmp10_ = self->priv->tmp_type;
		if (_tmp10_ != NULL) {
			GSettings* _tmp11_;
			GameType* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = self->priv->tmp_type;
			_tmp13_ = game_type_to_string ((GameType) (*_tmp12_));
			_tmp14_ = _tmp13_;
			g_settings_set_string (_tmp11_, "type", _tmp14_);
			_g_free0 (_tmp14_);
		}
		_tmp15_ = self->priv->settings;
		g_settings_apply (_tmp15_);
	}
	_tmp16_ = g_strdup ("<Primary>c");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.copy", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = g_strdup ("<Shift><Primary>c");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.copy-alt", _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("<Primary>n");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.new-game", _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("<Shift><Primary>n");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.start-or-restart", _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = g_strdup ("<Primary>q");
	_tmp29_ = g_strdup ("<Shift><Primary>q");
	_tmp30_ = g_new0 (gchar*, 2 + 1);
	_tmp30_[0] = _tmp28_;
	_tmp30_[1] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Primary>v");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.paste", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Shift><Primary>v");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.paste-alt", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("<Primary>z");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "ui.undo", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = g_strdup ("Escape");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.escape", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = g_strdup ("F10");
	_tmp45_ = g_strdup ("Menu");
	_tmp46_ = g_new0 (gchar*, 2 + 1);
	_tmp46_[0] = _tmp44_;
	_tmp46_[1] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.toggle-hamburger", _tmp47_);
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
	_tmp48_ = g_strdup ("F1");
	_tmp49_ = g_strdup ("<Primary>F1");
	_tmp50_ = g_strdup ("<Shift><Primary>F1");
	_tmp51_ = g_strdup ("<Primary>question");
	_tmp52_ = g_strdup ("<Shift><Primary>question");
	_tmp53_ = g_new0 (gchar*, 5 + 1);
	_tmp53_[0] = _tmp48_;
	_tmp53_[1] = _tmp49_;
	_tmp53_[2] = _tmp50_;
	_tmp53_[3] = _tmp51_;
	_tmp53_[4] = _tmp52_;
	_tmp54_ = _tmp53_;
	_tmp54__length1 = 5;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-help-overlay", _tmp54_);
	_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries ((GActionMap*) self, TAQUIN_action_entries, (gint) G_N_ELEMENTS (TAQUIN_action_entries), self);
	_tmp55_ = self->priv->settings;
	_tmp56_ = g_settings_create_action (_tmp55_, "sound");
	_tmp57_ = _tmp56_;
	g_action_map_add_action ((GActionMap*) self, _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = self->priv->settings;
	_tmp59_ = g_settings_create_action (_tmp58_, "type");
	_tmp60_ = _tmp59_;
	g_action_map_add_action ((GActionMap*) self, _tmp60_);
	_g_object_unref0 (_tmp60_);
}

static void
__lambda16_ (Taquin* self)
{
	GMenu* _tmp0_ = NULL;
	GSettings* _tmp1_;
	NewGameScreen* _tmp4_;
	_tmp1_ = self->priv->settings;
	if (((GameType) g_settings_get_enum (_tmp1_, "type")) == GAME_TYPE_FIFTEEN) {
		GMenu* _tmp2_;
		_tmp2_ = self->priv->size_menu_fifteen;
		_tmp0_ = _tmp2_;
	} else {
		GMenu* _tmp3_;
		_tmp3_ = self->priv->size_menu_sixteen;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = self->priv->new_game_screen;
	new_game_screen_update_menubutton_menu (_tmp4_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp0_);
}

static void
___lambda16__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda16_ ((Taquin*) self);
}

static void
_taquin_start_game_game_window_play (GameWindow* _sender,
                                     gpointer self)
{
	taquin_start_game ((Taquin*) self);
}

static void
_taquin_back_cb_game_window_back (GameWindow* _sender,
                                  gpointer self)
{
	taquin_back_cb ((Taquin*) self);
}

static void
_taquin_undo_cb_game_window_undo (GameWindow* _sender,
                                  gpointer self)
{
	taquin_undo_cb ((Taquin*) self);
}

static void
_taquin_restart_cb_game_window_restart (GameWindow* _sender,
                                        gpointer self)
{
	taquin_restart_cb ((Taquin*) self);
}

static void
__lambda17_ (Taquin* self)
{
	if (!self->priv->size_changed) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->settings;
		taquin_update_size_button_label (self, g_settings_get_int (_tmp0_, "size"));
	}
	self->priv->size_changed = FALSE;
}

static void
___lambda17__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda17_ ((Taquin*) self);
}

static void
__lambda18_ (Taquin* self)
{
	if (!self->priv->theme_changed) {
		GSettings* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_string (_tmp0_, "theme");
		_tmp2_ = _tmp1_;
		taquin_update_theme (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	self->priv->theme_changed = FALSE;
}

static void
___lambda18__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda18_ ((Taquin*) self);
}

static void
taquin_create_window (Taquin* self)
{
	TaquinView* _tmp0_;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GMenu* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GMenu* _tmp8_;
	GMenu* _tmp9_;
	GMenu* _tmp10_;
	GMenu* theme_menu = NULL;
	GMenu* _tmp11_;
	GMenu* _tmp12_;
	GMenu* _tmp13_;
	GMenu* _tmp14_;
	NewGameScreen* _tmp15_;
	GSettings* _tmp16_;
	GMenu* _tmp17_ = NULL;
	GSettings* _tmp18_;
	NewGameScreen* _tmp21_;
	NewGameScreen* _tmp22_;
	GMenu* _tmp23_;
	HistoryButton* _tmp24_;
	HistoryButton* _tmp25_;
	HistoryButton* _tmp26_;
	HistoryButton* _tmp27_;
	NewGameScreen* _tmp28_;
	TaquinView* _tmp29_;
	HistoryButton* _tmp30_;
	HistoryButton* _tmp31_;
	NightLightMonitor* _tmp32_;
	GameWindow* _tmp33_;
	GameWindow* _tmp34_;
	GameWindow* _tmp35_;
	GameWindow* _tmp36_;
	GameWindow* _tmp37_;
	GSettings* _tmp38_;
	GSettings* _tmp39_;
	GSettings* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GSettings* _tmp44_;
	GameWindow* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = taquin_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp0_;
	_tmp1_ = g_menu_new ();
	_g_object_unref0 (self->priv->size_menu_fifteen);
	self->priv->size_menu_fifteen = _tmp1_;
	_tmp2_ = self->priv->size_menu_fifteen;
	g_menu_append (_tmp2_, _ ("3 × 3\t1 minute"), "app.change-size('3')");
	_tmp3_ = self->priv->size_menu_fifteen;
	g_menu_append (_tmp3_, _ ("4 × 4\t5 minutes"), "app.change-size('4')");
	_tmp4_ = self->priv->size_menu_fifteen;
	g_menu_append (_tmp4_, _ ("5 × 5\t15 minutes"), "app.change-size('5')");
	_tmp5_ = self->priv->size_menu_fifteen;
	g_menu_freeze (_tmp5_);
	_tmp6_ = g_menu_new ();
	_g_object_unref0 (self->priv->size_menu_sixteen);
	self->priv->size_menu_sixteen = _tmp6_;
	_tmp7_ = self->priv->size_menu_sixteen;
	g_menu_append (_tmp7_, _ ("3 × 3\t1 minute"), "app.change-size('3')");
	_tmp8_ = self->priv->size_menu_sixteen;
	g_menu_append (_tmp8_, _ ("4 × 4\t3 minutes"), "app.change-size('4')");
	_tmp9_ = self->priv->size_menu_sixteen;
	g_menu_append (_tmp9_, _ ("5 × 5\t5 minutes"), "app.change-size('5')");
	_tmp10_ = self->priv->size_menu_sixteen;
	g_menu_freeze (_tmp10_);
	_tmp11_ = g_menu_new ();
	theme_menu = _tmp11_;
	_tmp12_ = theme_menu;
	g_menu_append (_tmp12_, _ ("Cats"), "app.change-theme('cats')");
	_tmp13_ = theme_menu;
	g_menu_append (_tmp13_, _ ("Numbers"), "app.change-theme('numbers')");
	_tmp14_ = theme_menu;
	g_menu_freeze (_tmp14_);
	_tmp15_ = new_game_screen_new (_ ("15-Puzzle"), "app.type('fifteen')", _ ("16-Puzzle"), "app.type('sixteen')");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp15_;
	_tmp16_ = self->priv->settings;
	g_signal_connect_object (_tmp16_, "changed::type", (GCallback) ___lambda16__g_settings_changed, self, 0);
	_tmp18_ = self->priv->settings;
	if (((GameType) g_settings_get_enum (_tmp18_, "type")) == GAME_TYPE_FIFTEEN) {
		GMenu* _tmp19_;
		_tmp19_ = self->priv->size_menu_fifteen;
		_tmp17_ = _tmp19_;
	} else {
		GMenu* _tmp20_;
		_tmp20_ = self->priv->size_menu_sixteen;
		_tmp17_ = _tmp20_;
	}
	_tmp21_ = self->priv->new_game_screen;
	new_game_screen_update_menubutton_menu (_tmp21_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp17_);
	_tmp22_ = self->priv->new_game_screen;
	_tmp23_ = theme_menu;
	new_game_screen_update_menubutton_menu (_tmp22_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp23_);
	_tmp24_ = history_button_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->history_button_1);
	self->priv->history_button_1 = _tmp24_;
	_tmp25_ = history_button_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->history_button_2);
	self->priv->history_button_2 = _tmp25_;
	_tmp26_ = self->priv->history_button_1;
	gtk_widget_show ((GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->history_button_2;
	gtk_widget_show ((GtkWidget*) _tmp27_);
	taquin_init_night_mode (self);
	_tmp28_ = self->priv->new_game_screen;
	_tmp29_ = self->priv->view;
	_tmp30_ = self->priv->history_button_1;
	_tmp31_ = self->priv->history_button_2;
	_tmp32_ = self->priv->night_light_monitor;
	_tmp33_ = game_window_new ("/org/gnome/Taquin/ui/taquin.css", TAQUIN_PROGRAM_NAME, _ ("About Taquin"), TRUE, ((GAME_WINDOW_FLAGS_SHOW_START_BUTTON | GAME_WINDOW_FLAGS_HAS_SOUND) | GAME_WINDOW_FLAGS_SHORTCUTS) | GAME_WINDOW_FLAGS_SHOW_HELP, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp29_, NULL, (GtkWidget*) _tmp30_, (GtkWidget*) _tmp31_, _tmp32_);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp33_;
	_tmp34_ = self->priv->window;
	g_signal_connect_object (_tmp34_, "play", (GCallback) _taquin_start_game_game_window_play, self, 0);
	_tmp35_ = self->priv->window;
	g_signal_connect_object (_tmp35_, "back", (GCallback) _taquin_back_cb_game_window_back, self, 0);
	_tmp36_ = self->priv->window;
	g_signal_connect_object (_tmp36_, "undo", (GCallback) _taquin_undo_cb_game_window_undo, self, 0);
	_tmp37_ = self->priv->window;
	g_signal_connect_object (_tmp37_, "restart", (GCallback) _taquin_restart_cb_game_window_restart, self, 0);
	_tmp38_ = self->priv->settings;
	g_signal_connect_object (_tmp38_, "changed::size", (GCallback) ___lambda17__g_settings_changed, self, 0);
	_tmp39_ = self->priv->settings;
	taquin_update_size_button_label (self, g_settings_get_int (_tmp39_, "size"));
	_tmp40_ = self->priv->settings;
	g_signal_connect_object (_tmp40_, "changed::theme", (GCallback) ___lambda18__g_settings_changed, self, 0);
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_string (_tmp41_, "theme");
	_tmp43_ = _tmp42_;
	taquin_update_theme (self, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp44_, "sound")) {
		taquin_init_sound (self);
	}
	_tmp45_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp45_);
	_g_object_unref0 (theme_menu);
}

static void
taquin_real_activate (GApplication* base)
{
	Taquin * self;
	GtkWindow* _tmp0_;
	Game* _tmp1_;
	GameWindow* _tmp2_;
	self = (Taquin*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		taquin_create_window (self);
	}
	_tmp1_ = self->priv->game;
	if (_tmp1_ == NULL) {
		taquin_start_game (self);
	}
	_tmp2_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp2_);
}

static void
taquin_play_fifteen_game (Taquin* self)
{
	GtkWindow* _tmp0_;
	Game* _tmp1_;
	GameWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		taquin_create_window (self);
	}
	_tmp1_ = self->priv->game;
	if (_tmp1_ == NULL) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_string (_tmp2_, "type", "fifteen");
		taquin_start_game (self);
	}
	_tmp3_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp3_);
}

static void
taquin_play_sixteen_game (Taquin* self)
{
	GtkWindow* _tmp0_;
	Game* _tmp1_;
	GameWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		taquin_create_window (self);
	}
	_tmp1_ = self->priv->game;
	if (_tmp1_ == NULL) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_string (_tmp2_, "type", "sixteen");
		taquin_start_game (self);
	}
	_tmp3_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp3_);
}

static void
taquin_real_shutdown (GApplication* base)
{
	Taquin * self;
	GtkWindow* _tmp0_;
	self = (Taquin*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		GameWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
	G_APPLICATION_CLASS (taquin_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
taquin_init_night_mode (Taquin* self)
{
	NightLightMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = night_light_monitor_new ("/org/gnome/taquin/");
	_g_object_unref0 (self->priv->night_light_monitor);
	self->priv->night_light_monitor = _tmp0_;
}

static void
taquin_set_use_night_mode (Taquin* self,
                           GSimpleAction* action,
                           GVariant* gvariant)
{
	NightLightMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = self->priv->night_light_monitor;
	night_light_monitor_set_use_night_mode (_tmp0_, g_variant_get_boolean ((GVariant*) gvariant));
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
_taquin_game_complete_cb_game_complete (Game* _sender,
                                        gpointer self)
{
	taquin_game_complete_cb ((Taquin*) self);
}

static void
_taquin_bad_click_cb_game_bad_click (Game* _sender,
                                     GameBadClick reason,
                                     gboolean keyboard_call,
                                     gpointer self)
{
	taquin_bad_click_cb ((Taquin*) self, reason, keyboard_call);
}

static void
_taquin_move_cb_game_move (Game* _sender,
                           gboolean x_axis,
                           gint8 number,
                           gint8 x_gap,
                           gint8 y_gap,
                           guint moves_count,
                           gboolean disable_animation,
                           gpointer self)
{
	taquin_move_cb ((Taquin*) self, x_axis, number, x_gap, y_gap, moves_count, disable_animation);
}

static void
taquin_start_game (Taquin* self)
{
	Game* _tmp0_;
	HistoryButton* _tmp4_;
	HistoryButton* _tmp5_;
	GameType type = 0;
	GSettings* _tmp6_;
	gint8 size = 0;
	GSettings* _tmp7_;
	Game* _tmp8_;
	TaquinView* _tmp9_;
	Game* _tmp10_;
	GameWindow* _tmp11_;
	HistoryButton* _tmp12_;
	HistoryButton* _tmp13_;
	gchar* filename = NULL;
	gchar* _tmp14_;
	GList* dirlist = NULL;
	GList* _tmp15_;
	GList* _tmp16_;
	TaquinView* _tmp36_;
	GSettings* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	TaquinView* _tmp43_;
	Game* _tmp44_;
	Game* _tmp45_;
	Game* _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		Game* _tmp2_;
		GameWindow* _tmp3_;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_GAME, Game), NULL, self);
		_tmp2_ = self->priv->game;
		_tmp3_ = self->priv->window;
		g_signal_handlers_disconnect_by_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_GAME, Game), NULL, _tmp3_);
	}
	_tmp4_ = self->priv->history_button_1;
	history_button_new_game (_tmp4_);
	_tmp5_ = self->priv->history_button_2;
	history_button_new_game (_tmp5_);
	_tmp6_ = self->priv->settings;
	type = (GameType) g_settings_get_enum (_tmp6_, "type");
	_tmp7_ = self->priv->settings;
	size = (gint8) g_settings_get_int (_tmp7_, "size");
	_tmp8_ = game_new (type, size);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp8_;
	taquin_set_window_title (self);
	_tmp9_ = self->priv->view;
	_tmp10_ = self->priv->game;
	taquin_view_set_game (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_GAME, Game));
	_tmp11_ = self->priv->window;
	game_window_move_done (_tmp11_, (guint) 0);
	_tmp12_ = self->priv->history_button_1;
	history_button_set_moves_count (_tmp12_, (guint) 0);
	_tmp13_ = self->priv->history_button_2;
	history_button_set_moves_count (_tmp13_, (guint) 0);
	self->priv->move_done = FALSE;
	_tmp14_ = g_strdup ("");
	filename = _tmp14_;
	_tmp15_ = self->priv->theme_dirlist;
	_tmp16_ = g_list_copy (_tmp15_);
	dirlist = _tmp16_;
	{
		gboolean _tmp17_ = FALSE;
		_tmp17_ = TRUE;
		while (TRUE) {
			gint random = 0;
			GList* _tmp27_;
			GList* _tmp28_;
			gconstpointer _tmp29_;
			gchar* _tmp30_;
			GList* entry = NULL;
			GList* _tmp31_;
			const gchar* _tmp32_;
			GCompareFunc _tmp33_;
			GList* _tmp34_;
			GList* _tmp35_;
			if (!_tmp17_) {
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
				_tmp19_ = filename;
				if (string_get (_tmp19_, (glong) 0) == '0') {
					_tmp18_ = TRUE;
				} else {
					gboolean _tmp20_ = FALSE;
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_;
					_tmp22_ = filename;
					if (string_get (_tmp22_, (glong) 0) != '1') {
						const gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp23_ = filename;
						_tmp24_ = g_strdup_printf ("%hhi", size);
						_tmp25_ = _tmp24_;
						_tmp21_ = string_get (_tmp23_, (glong) 0) != string_get (_tmp25_, (glong) 0);
						_g_free0 (_tmp25_);
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						GList* _tmp26_;
						_tmp26_ = dirlist;
						_tmp20_ = g_list_length (_tmp26_) != ((guint) 0);
					} else {
						_tmp20_ = FALSE;
					}
					_tmp18_ = _tmp20_;
				}
				if (!_tmp18_) {
					break;
				}
			}
			_tmp17_ = FALSE;
			_tmp27_ = dirlist;
			random = (gint) g_random_int_range ((gint32) 0, (gint32) ((gint) g_list_length (_tmp27_)));
			_tmp28_ = dirlist;
			_tmp29_ = g_list_nth_data (_tmp28_, (guint) random);
			_tmp30_ = g_strdup ((const gchar*) _tmp29_);
			_g_free0 (filename);
			filename = _tmp30_;
			_tmp31_ = dirlist;
			_tmp32_ = filename;
			_tmp33_ = ((GCompareFunc) g_strcmp0);
			_tmp34_ = g_list_find_custom (_tmp31_, _tmp32_, _tmp33_);
			entry = _tmp34_;
			_tmp35_ = entry;
			dirlist = g_list_remove_link (dirlist, _tmp35_);
		}
	}
	_tmp36_ = self->priv->view;
	_tmp37_ = self->priv->settings;
	_tmp38_ = g_settings_get_string (_tmp37_, "theme");
	_tmp39_ = _tmp38_;
	_tmp40_ = filename;
	_tmp41_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp39_, _tmp40_, NULL);
	_tmp42_ = _tmp41_;
	taquin_view_set_theme (_tmp36_, _tmp42_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp39_);
	_tmp43_ = self->priv->view;
	gtk_widget_realize ((GtkWidget*) _tmp43_);
	_tmp44_ = self->priv->game;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_GAME, Game), "complete", (GCallback) _taquin_game_complete_cb_game_complete, self, 0);
	_tmp45_ = self->priv->game;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_GAME, Game), "bad-click", (GCallback) _taquin_bad_click_cb_game_bad_click, self, 0);
	_tmp46_ = self->priv->game;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_GAME, Game), "move", (GCallback) _taquin_move_cb_game_move, self, 0);
	(dirlist == NULL) ? NULL : (dirlist = (g_list_free (dirlist), NULL));
	_g_free0 (filename);
}

static void
taquin_set_window_title (Taquin* self)
{
	const gchar* _tmp0_ = NULL;
	Game* _tmp1_;
	GameType _tmp2_;
	GameType _tmp3_;
	GameWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_game_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_GAME, Game));
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_TYPE_FIFTEEN) {
		_tmp0_ = _ ("15-Puzzle");
	} else {
		_tmp0_ = _ ("16-Puzzle");
	}
	_tmp4_ = self->priv->window;
	game_window_update_title (_tmp4_, _tmp0_);
}

static void
taquin_restart_cb (Taquin* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	_tmp1_ = self->priv->game;
	game_restart (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_GAME, Game));
	taquin_play_sound (self, TAQUIN_SOUND_SLIDING_N);
	self->priv->move_done = FALSE;
}

static void
taquin_back_cb (Taquin* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	taquin_set_window_title (self);
}

static void
taquin_undo_cb (Taquin* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	_tmp1_ = self->priv->game;
	game_undo (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_GAME, Game));
	taquin_play_sound (self, TAQUIN_SOUND_SLIDING_1);
}

static void
taquin_move_cb (Taquin* self,
                gboolean x_axis,
                gint8 number,
                gint8 x_gap,
                gint8 y_gap,
                guint moves_count,
                gboolean disable_animation)
{
	GameWindow* _tmp0_;
	HistoryButton* _tmp1_;
	HistoryButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_move_done (_tmp0_, moves_count);
	_tmp1_ = self->priv->history_button_1;
	history_button_set_moves_count (_tmp1_, moves_count);
	_tmp2_ = self->priv->history_button_2;
	history_button_set_moves_count (_tmp2_, moves_count);
	taquin_play_sound (self, TAQUIN_SOUND_SLIDING_1);
	self->priv->move_done = TRUE;
}

static void
taquin_game_complete_cb (Taquin* self)
{
	GameWindow* _tmp0_;
	gchar* best_score_string = NULL;
	HistoryButton* _tmp1_;
	gchar* _tmp2_ = NULL;
	HistoryButton* _tmp3_;
	gchar* _tmp4_ = NULL;
	GameWindow* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_finish_game (_tmp0_);
	taquin_play_sound (self, TAQUIN_SOUND_GAME_OVER);
	_tmp1_ = self->priv->history_button_1;
	history_button_save_best_score (_tmp1_, &_tmp2_);
	_g_free0 (best_score_string);
	best_score_string = _tmp2_;
	_tmp3_ = self->priv->history_button_2;
	history_button_save_best_score (_tmp3_, &_tmp4_);
	_g_free0 (best_score_string);
	best_score_string = _tmp4_;
	_tmp5_ = self->priv->window;
	_tmp6_ = best_score_string;
	base_window_show_notification ((BaseWindow*) _tmp5_, _tmp6_);
	_g_free0 (best_score_string);
}

static void
taquin_bad_click_cb (Taquin* self,
                     GameBadClick reason,
                     gboolean keyboard_call)
{
	g_return_if_fail (self != NULL);
	switch (reason) {
		case GAME_BAD_CLICK_NOT_MOVING:
		{
			GameWindow* _tmp0_;
			_tmp0_ = self->priv->window;
			base_window_show_notification ((BaseWindow*) _tmp0_, _ ("You can’t move this tile!"));
			return;
		}
		case GAME_BAD_CLICK_USE_ARROWS:
		{
			if (self->priv->move_done) {
				return;
			}
			if (keyboard_call) {
				GameWindow* _tmp1_;
				_tmp1_ = self->priv->window;
				base_window_show_notification ((BaseWindow*) _tmp1_, _ ("Use Shift and an arrow to move tiles!"));
			} else {
				GameWindow* _tmp2_;
				_tmp2_ = self->priv->window;
				base_window_show_notification ((BaseWindow*) _tmp2_, _ ("Click on the arrows to move tiles!"));
			}
			return;
		}
		default:
		case GAME_BAD_CLICK_IS_OUTSIDE:
		case GAME_BAD_CLICK_EMPTY_TILE:
		{
			return;
		}
	}
}

static void
taquin_change_size_cb (Taquin* self,
                       GSimpleAction* action,
                       GVariant* variant)
{
	gint size = 0;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	self->priv->size_changed = TRUE;
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	size = atoi (_tmp0_);
	taquin_update_size_button_label (self, size);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "size", size);
}

static void
taquin_update_size_button_label (Taquin* self,
                                 gint size)
{
	NewGameScreen* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_screen;
	_tmp1_ = new_game_screen_get_size_button_label (size);
	_tmp2_ = _tmp1_;
	new_game_screen_update_menubutton_label (_tmp0_, NEW_GAME_SCREEN_MENU_BUTTON_ONE, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
taquin_change_theme_cb (Taquin* self,
                        GSimpleAction* action,
                        GVariant* variant)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	taquin_update_theme (self, _tmp0_);
}

static void
taquin_update_theme (Taquin* self,
                     const gchar* theme_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_id != NULL);
	self->priv->theme_changed = TRUE;
	if (_taquin_update_theme (self, theme_id)) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->settings;
		g_settings_set_string (_tmp0_, "theme", theme_id);
	} else {
		GSettings* _tmp1_;
		if (!_taquin_update_theme (self, "cats")) {
			g_assert_not_reached ();
		}
		_tmp1_ = self->priv->settings;
		g_settings_set_string (_tmp1_, "theme", "cats");
	}
}

static gboolean
_taquin_update_theme (Taquin* self,
                      const gchar* theme_id)
{
	NewGameScreen* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GDir* dir = NULL;
	gboolean success = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (theme_id != NULL, FALSE);
	_tmp0_ = self->priv->new_game_screen;
	_tmp1_ = taquin_get_theme_button_label (theme_id);
	_tmp2_ = _tmp1_;
	new_game_screen_update_menubutton_label (_tmp0_, NEW_GAME_SCREEN_MENU_BUTTON_TWO, _tmp2_);
	_g_free0 (_tmp2_);
	(self->priv->theme_dirlist == NULL) ? NULL : (self->priv->theme_dirlist = (_g_list_free__g_free0_ (self->priv->theme_dirlist), NULL));
	self->priv->theme_dirlist = NULL;
	success = FALSE;
	{
		GDir* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GDir* _tmp6_;
		GDir* _tmp7_;
		GDir* _tmp9_;
		_tmp4_ = g_build_filename (DATA_DIRECTORY, "themes", theme_id, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_dir_open (_tmp5_, (guint) 0, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp3_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
		_tmp9_ = _tmp3_;
		_tmp3_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp9_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = dir;
			_tmp11_ = g_dir_read_name (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			filename = _tmp12_;
			_tmp13_ = filename;
			if (_tmp13_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp14_ = filename;
			_tmp15_ = g_strdup ((const gchar*) _tmp14_);
			self->priv->theme_dirlist = g_list_append (self->priv->theme_dirlist, _tmp15_);
			_g_free0 (filename);
		}
		success = TRUE;
		_g_dir_close0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("taquin-main.vala:536: Failed to load images: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = success;
	_g_dir_close0 (dir);
	return result;
}

static inline gchar*
taquin_get_theme_button_label (const gchar* theme_id)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	gchar* result;
	g_return_val_if_fail (theme_id != NULL, NULL);
	_tmp0_ = theme_id;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("cats")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (_ ("Theme: Cats ▾"));
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("numbers")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("Theme: Numbers ▾"));
				result = _tmp4_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup_printf (_ ("Theme: %s ▾"), theme_id);
				result = _tmp5_;
				return result;
			}
		}
	}
}

static void
taquin_init_sound (Taquin* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->sound_context);
		self->priv->sound_context = _tmp2_;
		self->priv->sound_context_state = TAQUIN_SOUND_CONTEXT_STATE_WORKING;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("taquin-main.vala:586: %s", _tmp4_);
		self->priv->sound_context_state = TAQUIN_SOUND_CONTEXT_STATE_ERRORED;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
taquin_play_sound (Taquin* self,
                   TaquinSound sound)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "sound")) {
		if (self->priv->sound_context_state == TAQUIN_SOUND_CONTEXT_STATE_INITIAL) {
			taquin_init_sound (self);
		}
		if (self->priv->sound_context_state == TAQUIN_SOUND_CONTEXT_STATE_WORKING) {
			GSoundContext* _tmp1_;
			_tmp1_ = self->priv->sound_context;
			_taquin_play_sound (sound, _tmp1_);
		}
	}
}

static void
_taquin_play_sound (TaquinSound sound,
                    GSoundContext* sound_context)
{
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (sound_context != NULL);
	switch (sound) {
		case TAQUIN_SOUND_SLIDING_1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("sliding-1.ogg");
			_g_free0 (name);
			name = _tmp0_;
			break;
		}
		case TAQUIN_SOUND_SLIDING_N:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("sliding-n.ogg");
			_g_free0 (name);
			name = _tmp1_;
			break;
		}
		case TAQUIN_SOUND_GAME_OVER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("gameover.ogg");
			_g_free0 (name);
			name = _tmp2_;
			break;
		}
		default:
		{
			_g_free0 (name);
			return;
		}
	}
	_tmp3_ = name;
	_tmp4_ = g_build_filename (SOUND_DIRECTORY, _tmp3_, NULL);
	path = _tmp4_;
	{
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = name;
		_tmp6_ = path;
		gsound_context_play_simple (sound_context, NULL, &_inner_error0_, GSOUND_ATTR_MEDIA_NAME, _tmp5_, GSOUND_ATTR_MEDIA_FILENAME, _tmp6_, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("taquin-main.vala:628: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	_g_free0 (name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
taquin_real_copy (BaseApplication* base,
                  const gchar* text)
{
	Taquin * self;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp3_;
	GtkClipboard* _tmp4_;
	GtkClipboard* _tmp5_;
	GtkClipboard* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (Taquin*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (display);
		return;
	}
	_tmp3_ = display;
	_tmp4_ = gtk_clipboard_get_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_display_get_type (), GdkDisplay));
	_tmp5_ = _g_object_ref0 (_tmp4_);
	clipboard = _tmp5_;
	_tmp6_ = clipboard;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	gtk_clipboard_set_text (_tmp6_, text, _tmp8_);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

static void
taquin_real_get_about_dialog_infos (BaseApplication* base,
                                    gchar*** artists,
                                    gint* artists_length1,
                                    gchar*** authors,
                                    gint* authors_length1,
                                    gchar** comments,
                                    gchar** copyright,
                                    gchar*** documenters,
                                    gint* documenters_length1,
                                    gchar** logo_icon_name,
                                    gchar** program_name,
                                    gchar** translator_credits,
                                    gchar** version,
                                    gchar** website,
                                    gchar** website_label)
{
	Taquin * self;
	gchar** _vala_artists = NULL;
	gint _vala_artists_length1 = 0;
	gchar** _vala_authors = NULL;
	gint _vala_authors_length1 = 0;
	gchar* _vala_comments = NULL;
	gchar* _vala_copyright = NULL;
	gchar** _vala_documenters = NULL;
	gint _vala_documenters_length1 = 0;
	gchar* _vala_logo_icon_name = NULL;
	gchar* _vala_program_name = NULL;
	gchar* _vala_translator_credits = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_website = NULL;
	gchar* _vala_website_label = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	self = (Taquin*) base;
	_tmp0_ = g_strdup (_ ("A classic 15-puzzle game"));
	_g_free0 (_vala_comments);
	_vala_comments = _tmp0_;
	_tmp1_ = g_strdup (_ ("Abelard (Wikimedia)"));
	_tmp2_ = g_strdup (_ ("Alvesgaspar (Wikimedia)"));
	_tmp3_ = g_strdup (_ ("Mueller-rech.muenchen (Wikimedia)"));
	_tmp4_ = g_strdup (_ ("Ruskis (Wikimedia)"));
	_tmp5_ = g_strdup (_ ("Toyah (Wikimedia)"));
	_tmp6_ = g_strdup (_ ("(see COPYING.themes for information)"));
	_tmp7_ = g_new0 (gchar*, 6 + 1);
	_tmp7_[0] = _tmp1_;
	_tmp7_[1] = _tmp2_;
	_tmp7_[2] = _tmp3_;
	_tmp7_[3] = _tmp4_;
	_tmp7_[4] = _tmp5_;
	_tmp7_[5] = _tmp6_;
	_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	_vala_artists = _tmp7_;
	_vala_artists_length1 = 6;
	_tmp8_ = g_strdup (_ ("Arnaud Bonatti"));
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	_vala_authors = _tmp9_;
	_vala_authors_length1 = 1;
	_tmp10_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2014, (guint) 2020);
	_g_free0 (_vala_copyright);
	_vala_copyright = _tmp10_;
	_tmp11_ = g_strdup (_ ("Arnaud Bonatti"));
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	_vala_documenters = _tmp12_;
	_vala_documenters_length1 = 1;
	_tmp13_ = g_strdup ("org.gnome.Taquin");
	_g_free0 (_vala_logo_icon_name);
	_vala_logo_icon_name = _tmp13_;
	_tmp14_ = g_strdup (TAQUIN_PROGRAM_NAME);
	_g_free0 (_vala_program_name);
	_vala_program_name = _tmp14_;
	_tmp15_ = g_strdup (_ ("translator-credits"));
	_g_free0 (_vala_translator_credits);
	_vala_translator_credits = _tmp15_;
	_tmp16_ = g_strdup (VERSION);
	_g_free0 (_vala_version);
	_vala_version = _tmp16_;
	_tmp17_ = g_strdup ("https://wiki.gnome.org/Apps/Taquin");
	_g_free0 (_vala_website);
	_vala_website = _tmp17_;
	_tmp18_ = g_strdup (_ ("Page on GNOME wiki"));
	_g_free0 (_vala_website_label);
	_vala_website_label = _tmp18_;
	if (artists) {
		*artists = _vala_artists;
	} else {
		_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	}
	if (artists_length1) {
		*artists_length1 = _vala_artists_length1;
	}
	if (authors) {
		*authors = _vala_authors;
	} else {
		_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	}
	if (authors_length1) {
		*authors_length1 = _vala_authors_length1;
	}
	if (comments) {
		*comments = _vala_comments;
	} else {
		_g_free0 (_vala_comments);
	}
	if (copyright) {
		*copyright = _vala_copyright;
	} else {
		_g_free0 (_vala_copyright);
	}
	if (documenters) {
		*documenters = _vala_documenters;
	} else {
		_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	}
	if (documenters_length1) {
		*documenters_length1 = _vala_documenters_length1;
	}
	if (logo_icon_name) {
		*logo_icon_name = _vala_logo_icon_name;
	} else {
		_g_free0 (_vala_logo_icon_name);
	}
	if (program_name) {
		*program_name = _vala_program_name;
	} else {
		_g_free0 (_vala_program_name);
	}
	if (translator_credits) {
		*translator_credits = _vala_translator_credits;
	} else {
		_g_free0 (_vala_translator_credits);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (website) {
		*website = _vala_website;
	} else {
		_g_free0 (_vala_website);
	}
	if (website_label) {
		*website_label = _vala_website_label;
	} else {
		_g_free0 (_vala_website_label);
	}
}

static void
taquin_class_init (TaquinClass * klass,
                   gpointer klass_data)
{
	taquin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Taquin_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) taquin_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) taquin_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) taquin_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) taquin_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = taquin_finalize;
}

static void
taquin_base_application_interface_init (BaseApplicationIface * iface,
                                        gpointer iface_data)
{
	taquin_base_application_parent_iface = g_type_interface_peek_parent (iface);
	iface->copy = (void (*) (BaseApplication*, const gchar*)) taquin_real_copy;
	iface->get_about_dialog_infos = (void (*) (BaseApplication*, gchar***, gint*, gchar***, gint*, gchar**, gchar**, gchar***, gint*, gchar**, gchar**, gchar**, gchar**, gchar**, gchar**)) taquin_real_get_about_dialog_infos;
}

static void
taquin_instance_init (Taquin * self,
                      gpointer klass)
{
	self->priv = taquin_get_instance_private (self);
	self->priv->tmp_type = NULL;
	self->priv->size_changed = FALSE;
	self->priv->theme_changed = FALSE;
	self->priv->game = NULL;
	self->priv->move_done = FALSE;
	self->priv->sound_context_state = TAQUIN_SOUND_CONTEXT_STATE_INITIAL;
}

static void
taquin_finalize (GObject * obj)
{
	Taquin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN, Taquin);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->tmp_type);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->history_button_1);
	_g_object_unref0 (self->priv->history_button_2);
	_g_object_unref0 (self->priv->size_menu_fifteen);
	_g_object_unref0 (self->priv->size_menu_sixteen);
	_g_object_unref0 (self->priv->game);
	(self->priv->theme_dirlist == NULL) ? NULL : (self->priv->theme_dirlist = (_g_list_free__g_free0_ (self->priv->theme_dirlist), NULL));
	_g_object_unref0 (self->priv->night_light_monitor);
	_g_object_unref0 (self->priv->sound_context);
	G_OBJECT_CLASS (taquin_parent_class)->finalize (obj);
}

static GType
taquin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TaquinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Taquin), 0, (GInstanceInitFunc) taquin_instance_init, NULL };
	static const GInterfaceInfo base_application_info = { (GInterfaceInitFunc) taquin_base_application_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType taquin_type_id;
	taquin_type_id = g_type_register_static (gtk_application_get_type (), "Taquin", &g_define_type_info, 0);
	g_type_add_interface_static (taquin_type_id, TYPE_BASE_APPLICATION, &base_application_info);
	Taquin_private_offset = g_type_add_instance_private (taquin_type_id, sizeof (TaquinPrivate));
	return taquin_type_id;
}

GType
taquin_get_type (void)
{
	static volatile gsize taquin_type_id__once = 0;
	if (g_once_init_enter (&taquin_type_id__once)) {
		GType taquin_type_id;
		taquin_type_id = taquin_get_type_once ();
		g_once_init_leave (&taquin_type_id__once, taquin_type_id);
	}
	return taquin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

