/* fingerprint.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from fingerprint.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

VALA_EXTERN gchar* games_fingerprint_get_for_file_uri (GamesUri* uri,
                                           gsize start,
                                           gsize* length,
                                           GError** error);
VALA_EXTERN gchar* games_fingerprint_get_for_file_input_stream (GFileInputStream* file_stream,
                                                    gsize start,
                                                    gsize* length,
                                                    GError** error);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
games_fingerprint_get_for_file_uri (GamesUri* uri,
                                    gsize start,
                                    gsize* length,
                                    GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInputStream* istream = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	gchar* _tmp3_ = NULL;
	GFileInputStream* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	istream = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp4_ = istream;
	_tmp5_ = games_fingerprint_get_for_file_input_stream (_tmp4_, start, length, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (istream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp3_);
	_g_object_unref0 (istream);
	_g_object_unref0 (file);
	return result;
}

gchar*
games_fingerprint_get_for_file_input_stream (GFileInputStream* file_stream,
                                             gsize start,
                                             gsize* length,
                                             GError** error)
{
	gsize size = 0UL;
	GBytes* bytes = NULL;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file_stream != NULL, NULL);
	if (length == NULL) {
		G_TYPE_INSTANCE_GET_CLASS (file_stream, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (file_stream, (gint64) 0, G_SEEK_END, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		size = (gsize) G_TYPE_INSTANCE_GET_CLASS (file_stream, g_file_input_stream_get_type (), GFileInputStreamClass)->tell (file_stream);
	} else {
		size = *length;
	}
	G_TYPE_INSTANCE_GET_CLASS (file_stream, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (file_stream, (gint64) start, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = g_input_stream_read_bytes ((GInputStream*) file_stream, size, NULL, &_inner_error0_);
	bytes = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = bytes;
	_tmp2_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp1_);
	result = _tmp2_;
	_g_bytes_unref0 (bytes);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
games_fingerprint_get_uid (GamesUri* uri,
                           const gchar* prefix,
                           GError** error)
{
	gchar* fingerprint = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = games_fingerprint_get_for_file_uri (uri, (gsize) 0, NULL, &_inner_error0_);
	fingerprint = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = string_to_string (prefix);
	_tmp2_ = string_to_string (fingerprint);
	_tmp3_ = g_strconcat (_tmp1_, "-", _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (fingerprint);
	return result;
}

gchar*
games_fingerprint_get_uid_for_chunk (GamesUri* uri,
                                     const gchar* prefix,
                                     gsize start,
                                     gsize length,
                                     GError** error)
{
	gchar* fingerprint = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = games_fingerprint_get_for_file_uri (uri, start, &length, &_inner_error0_);
	fingerprint = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = string_to_string (prefix);
	_tmp2_ = string_to_string (fingerprint);
	_tmp3_ = g_strconcat (_tmp1_, "-", _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (fingerprint);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

