/* snapshot-thumbnail.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from snapshot-thumbnail.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include "gnome-games.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_SNAPSHOT_THUMBNAIL (games_snapshot_thumbnail_get_type ())
#define GAMES_SNAPSHOT_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnail))
#define GAMES_SNAPSHOT_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnailClass))
#define GAMES_IS_SNAPSHOT_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SNAPSHOT_THUMBNAIL))
#define GAMES_IS_SNAPSHOT_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SNAPSHOT_THUMBNAIL))
#define GAMES_SNAPSHOT_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnailClass))

typedef struct _GamesSnapshotThumbnail GamesSnapshotThumbnail;
typedef struct _GamesSnapshotThumbnailClass GamesSnapshotThumbnailClass;
typedef struct _GamesSnapshotThumbnailPrivate GamesSnapshotThumbnailPrivate;
enum  {
	GAMES_SNAPSHOT_THUMBNAIL_0_PROPERTY,
	GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY,
	GAMES_SNAPSHOT_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* games_snapshot_thumbnail_properties[GAMES_SNAPSHOT_THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesSnapshotThumbnail {
	GtkDrawingArea parent_instance;
	GamesSnapshotThumbnailPrivate * priv;
};

struct _GamesSnapshotThumbnailClass {
	GtkDrawingAreaClass parent_class;
};

struct _GamesSnapshotThumbnailPrivate {
	GamesSnapshot* _snapshot;
	GdkPixbuf* pixbuf;
};

static gint GamesSnapshotThumbnail_private_offset;
static gpointer games_snapshot_thumbnail_parent_class = NULL;

VALA_EXTERN GType games_snapshot_thumbnail_get_type (void) G_GNUC_CONST ;
static void games_snapshot_thumbnail_load_thumbnail (GamesSnapshotThumbnail* self);
VALA_EXTERN GamesSnapshot* games_snapshot_thumbnail_get_snapshot (GamesSnapshotThumbnail* self);
static void games_snapshot_thumbnail_real_size_allocate (GtkWidget* base,
                                                  GtkAllocation* alloc);
static gboolean games_snapshot_thumbnail_real_draw (GtkWidget* base,
                                             cairo_t* cr);
static void games_snapshot_thumbnail_rounded_rectangle (GamesSnapshotThumbnail* self,
                                                 cairo_t* cr,
                                                 gdouble x,
                                                 gdouble y,
                                                 gdouble width,
                                                 gdouble height,
                                                 gdouble radius);
VALA_EXTERN GamesSnapshotThumbnail* games_snapshot_thumbnail_new (void);
VALA_EXTERN GamesSnapshotThumbnail* games_snapshot_thumbnail_construct (GType object_type);
VALA_EXTERN void games_snapshot_thumbnail_set_snapshot (GamesSnapshotThumbnail* self,
                                            GamesSnapshot* value);
static GObject * games_snapshot_thumbnail_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _games_snapshot_thumbnail_load_thumbnail_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void games_snapshot_thumbnail_finalize (GObject * obj);
static GType games_snapshot_thumbnail_get_type_once (void);
static void _vala_games_snapshot_thumbnail_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_games_snapshot_thumbnail_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_snapshot_thumbnail_get_instance_private (GamesSnapshotThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSnapshotThumbnail_private_offset);
}

static void
games_snapshot_thumbnail_load_thumbnail (GamesSnapshotThumbnail* self)
{
	GamesSnapshot* _tmp0_;
	GamesSnapshot* _tmp1_;
	gchar* screenshot_path = NULL;
	GamesSnapshot* _tmp2_;
	GamesSnapshot* _tmp3_;
	gchar* _tmp4_;
	gint screenshot_width = 0;
	gint screenshot_height = 0;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gdouble aspect_ratio = 0.0;
	GamesSnapshot* _tmp8_;
	GamesSnapshot* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gint thumbnail_width = 0;
	gint thumbnail_height = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_snapshot_thumbnail_get_snapshot (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = games_snapshot_thumbnail_get_snapshot (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_snapshot_get_screenshot_path (_tmp3_);
	screenshot_path = _tmp4_;
	screenshot_width = 0;
	screenshot_height = 0;
	_tmp5_ = screenshot_path;
	gdk_pixbuf_get_file_info (_tmp5_, &_tmp6_, &_tmp7_);
	screenshot_width = _tmp6_;
	screenshot_height = _tmp7_;
	_tmp8_ = games_snapshot_thumbnail_get_snapshot (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = games_snapshot_get_screenshot_aspect_ratio (_tmp9_);
	_tmp11_ = _tmp10_;
	aspect_ratio = _tmp11_;
	if (aspect_ratio == ((gdouble) 0)) {
		aspect_ratio = ((gdouble) screenshot_width) / screenshot_height;
	}
	thumbnail_width = screenshot_width;
	thumbnail_height = (gint) (screenshot_width / aspect_ratio);
	if (thumbnail_width > thumbnail_height) {
		thumbnail_width = GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE;
		thumbnail_height = (gint) (GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE / aspect_ratio);
	} else {
		thumbnail_height = GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE;
		thumbnail_width = (gint) (GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE * aspect_ratio);
	}
	_tmp12_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp13_ = _tmp12_;
	thumbnail_width *= _tmp13_;
	_tmp14_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp15_ = _tmp14_;
	thumbnail_height *= _tmp15_;
	{
		GdkPixbuf* _tmp16_ = NULL;
		const gchar* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		_tmp17_ = screenshot_path;
		_tmp18_ = gdk_pixbuf_new_from_file_at_scale (_tmp17_, thumbnail_width, thumbnail_height, FALSE, &_inner_error0_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp19_ = _tmp16_;
		_tmp16_ = NULL;
		_g_object_unref0 (self->priv->pixbuf);
		self->priv->pixbuf = _tmp19_;
		_g_object_unref0 (_tmp16_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("snapshot-thumbnail.vala:65: Failed to load snapshot thumbnail: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (screenshot_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (screenshot_path);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_snapshot_thumbnail_real_size_allocate (GtkWidget* base,
                                             GtkAllocation* alloc)
{
	GamesSnapshotThumbnail * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GdkRectangle clip = {0};
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
	GdkRectangle _tmp6_ = {0};
	GtkAllocation _tmp7_;
	GdkRectangle _tmp8_;
	self = (GamesSnapshotThumbnail*) base;
	g_return_if_fail (alloc != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = *alloc;
	_tmp3_ = *alloc;
	_tmp4_ = *alloc;
	_tmp5_ = *alloc;
	gtk_render_background_get_clip (context, (gdouble) _tmp2_.x, (gdouble) _tmp3_.y, (gdouble) _tmp4_.width, (gdouble) _tmp5_.height, &_tmp6_);
	clip = _tmp6_;
	_tmp7_ = *alloc;
	GTK_WIDGET_CLASS (games_snapshot_thumbnail_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), &_tmp7_);
	_tmp8_ = clip;
	gtk_widget_set_clip ((GtkWidget*) self, &_tmp8_);
	_g_object_unref0 (context);
}

static gboolean
games_snapshot_thumbnail_real_draw (GtkWidget* base,
                                    cairo_t* cr)
{
	GamesSnapshotThumbnail * self;
	gint width = 0;
	gint height = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GdkPixbuf* _tmp4_;
	GtkStateFlags flags = 0U;
	gint border_radius = 0;
	GtkStyleContext* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint x_offset = 0;
	gint _tmp13_;
	gint _tmp14_;
	GdkPixbuf* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint y_offset = 0;
	gint _tmp18_;
	gint _tmp19_;
	GdkPixbuf* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GdkPixbuf* _tmp23_;
	gboolean result;
	self = (GamesSnapshotThumbnail*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style = _tmp1_;
	_tmp2_ = style;
	gtk_render_background (_tmp2_, cr, 0.0, 0.0, (gdouble) width, (gdouble) height);
	_tmp3_ = style;
	gtk_render_frame (_tmp3_, cr, 0.0, 0.0, (gdouble) width, (gdouble) height);
	_tmp4_ = self->priv->pixbuf;
	if (_tmp4_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (style);
		return result;
	}
	cairo_save (cr);
	flags = gtk_widget_get_state_flags ((GtkWidget*) self);
	_tmp5_ = style;
	gtk_style_context_get_property (_tmp5_, GTK_STYLE_PROPERTY_BORDER_RADIUS, flags, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_value_get_int (&_tmp6_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	border_radius = _tmp8_;
	border_radius = CLAMP (border_radius, 0, MAX (width / 2, height / 2));
	games_snapshot_thumbnail_rounded_rectangle (self, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) border_radius);
	cairo_clip (cr);
	_tmp9_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp12_ = _tmp11_;
	cairo_scale (cr, 1.0 / _tmp10_, 1.0 / _tmp12_);
	_tmp13_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->pixbuf;
	_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
	_tmp17_ = _tmp16_;
	x_offset = ((width * _tmp14_) - _tmp17_) / 2;
	_tmp18_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->pixbuf;
	_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
	_tmp22_ = _tmp21_;
	y_offset = ((height * _tmp19_) - _tmp22_) / 2;
	_tmp23_ = self->priv->pixbuf;
	gdk_cairo_set_source_pixbuf (cr, _tmp23_, (gdouble) x_offset, (gdouble) y_offset);
	cairo_paint (cr);
	cairo_restore (cr);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (style);
	return result;
}

static void
games_snapshot_thumbnail_rounded_rectangle (GamesSnapshotThumbnail* self,
                                            cairo_t* cr,
                                            gdouble x,
                                            gdouble y,
                                            gdouble width,
                                            gdouble height,
                                            gdouble radius)
{
	static const gdouble ARC_0 = (gdouble) 0;
	static const gdouble ARC_1 = G_PI * 0.5;
	static const gdouble ARC_2 = G_PI;
	static const gdouble ARC_3 = G_PI * 1.5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_new_sub_path (cr);
	cairo_arc (cr, (x + width) - radius, y + radius, radius, ARC_3, ARC_0);
	cairo_arc (cr, (x + width) - radius, (y + height) - radius, radius, ARC_0, ARC_1);
	cairo_arc (cr, x + radius, (y + height) - radius, radius, ARC_1, ARC_2);
	cairo_arc (cr, x + radius, y + radius, radius, ARC_2, ARC_3);
	cairo_close_path (cr);
}

GamesSnapshotThumbnail*
games_snapshot_thumbnail_construct (GType object_type)
{
	GamesSnapshotThumbnail * self = NULL;
	self = (GamesSnapshotThumbnail*) g_object_new (object_type, NULL);
	return self;
}

GamesSnapshotThumbnail*
games_snapshot_thumbnail_new (void)
{
	return games_snapshot_thumbnail_construct (GAMES_TYPE_SNAPSHOT_THUMBNAIL);
}

GamesSnapshot*
games_snapshot_thumbnail_get_snapshot (GamesSnapshotThumbnail* self)
{
	GamesSnapshot* result;
	GamesSnapshot* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_snapshot;
	result = _tmp0_;
	return result;
}

void
games_snapshot_thumbnail_set_snapshot (GamesSnapshotThumbnail* self,
                                       GamesSnapshot* value)
{
	GamesSnapshot* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_snapshot);
	self->priv->_snapshot = _tmp0_;
	games_snapshot_thumbnail_load_thumbnail (self);
	g_object_notify_by_pspec ((GObject *) self, games_snapshot_thumbnail_properties[GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY]);
}

static void
_games_snapshot_thumbnail_load_thumbnail_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	games_snapshot_thumbnail_load_thumbnail ((GamesSnapshotThumbnail*) self);
}

static GObject *
games_snapshot_thumbnail_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesSnapshotThumbnail * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (games_snapshot_thumbnail_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnail);
	g_object_set ((GtkWidget*) self, "width-request", GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE, NULL);
	g_object_set ((GtkWidget*) self, "height-request", GAMES_SNAPSHOT_THUMBNAIL_THUMBNAIL_SIZE, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "snapshot-thumbnail");
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) _games_snapshot_thumbnail_load_thumbnail_g_object_notify, self, 0);
	return obj;
}

static void
games_snapshot_thumbnail_class_init (GamesSnapshotThumbnailClass * klass,
                                     gpointer klass_data)
{
	games_snapshot_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSnapshotThumbnail_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) games_snapshot_thumbnail_real_size_allocate;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) games_snapshot_thumbnail_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_snapshot_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_snapshot_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_snapshot_thumbnail_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_snapshot_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY, games_snapshot_thumbnail_properties[GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY] = g_param_spec_object ("snapshot", "snapshot", "snapshot", GAMES_TYPE_SNAPSHOT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_snapshot_thumbnail_instance_init (GamesSnapshotThumbnail * self,
                                        gpointer klass)
{
	self->priv = games_snapshot_thumbnail_get_instance_private (self);
}

static void
games_snapshot_thumbnail_finalize (GObject * obj)
{
	GamesSnapshotThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnail);
	_g_object_unref0 (self->priv->_snapshot);
	_g_object_unref0 (self->priv->pixbuf);
	G_OBJECT_CLASS (games_snapshot_thumbnail_parent_class)->finalize (obj);
}

static GType
games_snapshot_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSnapshotThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_snapshot_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSnapshotThumbnail), 0, (GInstanceInitFunc) games_snapshot_thumbnail_instance_init, NULL };
	GType games_snapshot_thumbnail_type_id;
	games_snapshot_thumbnail_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GamesSnapshotThumbnail", &g_define_type_info, 0);
	GamesSnapshotThumbnail_private_offset = g_type_add_instance_private (games_snapshot_thumbnail_type_id, sizeof (GamesSnapshotThumbnailPrivate));
	return games_snapshot_thumbnail_type_id;
}

GType
games_snapshot_thumbnail_get_type (void)
{
	static volatile gsize games_snapshot_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&games_snapshot_thumbnail_type_id__once)) {
		GType games_snapshot_thumbnail_type_id;
		games_snapshot_thumbnail_type_id = games_snapshot_thumbnail_get_type_once ();
		g_once_init_leave (&games_snapshot_thumbnail_type_id__once, games_snapshot_thumbnail_type_id);
	}
	return games_snapshot_thumbnail_type_id__once;
}

static void
_vala_games_snapshot_thumbnail_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GamesSnapshotThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnail);
	switch (property_id) {
		case GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY:
		g_value_set_object (value, games_snapshot_thumbnail_get_snapshot (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_snapshot_thumbnail_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GamesSnapshotThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SNAPSHOT_THUMBNAIL, GamesSnapshotThumbnail);
	switch (property_id) {
		case GAMES_SNAPSHOT_THUMBNAIL_SNAPSHOT_PROPERTY:
		games_snapshot_thumbnail_set_snapshot (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

