/* gamepad-view-configuration.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gamepad-view-configuration.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "linux/input-event-codes.h"
#include <float.h>
#include <math.h>
#include "gnome-games.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_GAMEPAD_BUTTON_PATH (games_gamepad_button_path_get_type ())
typedef struct _GamesGamepadButtonPath GamesGamepadButtonPath;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;

#define GAMES_TYPE_GAMEPAD_ANALOG_PATH (games_gamepad_analog_path_get_type ())
typedef struct _GamesGamepadAnalogPath GamesGamepadAnalogPath;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadButtonPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadAnalogPath {
	GamesGamepadInput input_x;
	GamesGamepadInput input_y;
	gdouble offset_radius;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadButtonPath* button_paths;
	gint button_paths_length1;
	gint _button_paths_size_;
	GamesGamepadAnalogPath* analog_paths;
	gint analog_paths_length1;
	gint _analog_paths_size_;
	gchar** background_paths;
	gint background_paths_length1;
	gint _background_paths_size_;
};

VALA_EXTERN GType games_gamepad_button_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
VALA_EXTERN GamesGamepadButtonPath* games_gamepad_button_path_dup (const GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_free (GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                     GamesGamepadButtonPath* dest);
VALA_EXTERN void games_gamepad_button_path_destroy (GamesGamepadButtonPath* self);
VALA_EXTERN GType games_gamepad_analog_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadAnalogPath* games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_free (GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                     GamesGamepadAnalogPath* dest);
VALA_EXTERN void games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self);
VALA_EXTERN GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                            GamesGamepadViewConfiguration* dest);
VALA_EXTERN void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
static void _vala_GamesGamepadButtonPath_array_free (GamesGamepadButtonPath * array,
                                              gssize array_length);
static void _vala_GamesGamepadAnalogPath_array_free (GamesGamepadAnalogPath * array,
                                              gssize array_length);
VALA_EXTERN void games_gamepad_view_configuration_get_default (GamesGamepadViewConfiguration* result);
static GamesGamepadButtonPath* _vala_array_dup23 (GamesGamepadButtonPath* self,
                                           gssize length);
static GamesGamepadAnalogPath* _vala_array_dup24 (GamesGamepadAnalogPath* self,
                                           gssize length);
static gchar** _vala_array_dup25 (gchar** self,
                           gssize length);
static GamesGamepadButtonPath* _vala_array_dup26 (GamesGamepadButtonPath* self,
                                           gssize length);
static GamesGamepadAnalogPath* _vala_array_dup27 (GamesGamepadAnalogPath* self,
                                           gssize length);
static gchar** _vala_array_dup28 (gchar** self,
                           gssize length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const GamesGamepadButtonPath GAMES_STANDARD_GAMEPAD_BUTTON_PATHS[17] = {{{EV_KEY, BTN_EAST}, "east"}, {{EV_KEY, BTN_SOUTH}, "south"}, {{EV_KEY, BTN_DPAD_DOWN}, "dpdown"}, {{EV_KEY, BTN_DPAD_LEFT}, "dpleft"}, {{EV_KEY, BTN_DPAD_RIGHT}, "dpright"}, {{EV_KEY, BTN_DPAD_UP}, "dpup"}, {{EV_KEY, BTN_MODE}, "guide"}, {{EV_KEY, BTN_SELECT}, "back"}, {{EV_KEY, BTN_TL}, "leftshoulder"}, {{EV_KEY, BTN_TR}, "rightshoulder"}, {{EV_KEY, BTN_START}, "start"}, {{EV_KEY, BTN_THUMBL}, "leftstick"}, {{EV_KEY, BTN_THUMBR}, "rightstick"}, {{EV_KEY, BTN_TL2}, "lefttrigger"}, {{EV_KEY, BTN_TR2}, "righttrigger"}, {{EV_KEY, BTN_NORTH}, "north"}, {{EV_KEY, BTN_WEST}, "west"}};
const GamesGamepadAnalogPath GAMES_STANDARD_GAMEPAD_ANALOG_PATHS[2] = {{{EV_ABS, ABS_X}, {EV_ABS, ABS_Y}, (gdouble) 6, "leftstick"}, {{EV_ABS, ABS_RX}, {EV_ABS, ABS_RY}, (gdouble) 6, "rightstick"}};
const gchar* GAMES_BACKGROUND_PATHS[2] = {"leftstick-base", "rightstick-base"};

void
games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                GamesGamepadButtonPath* dest)
{
	GamesGamepadInput _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).input;
	(*dest).input = _tmp0_;
	_tmp1_ = (*self).path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp2_;
}

void
games_gamepad_button_path_destroy (GamesGamepadButtonPath* self)
{
	_g_free0 ((*self).path);
}

GamesGamepadButtonPath*
games_gamepad_button_path_dup (const GamesGamepadButtonPath* self)
{
	GamesGamepadButtonPath* dup;
	dup = g_new0 (GamesGamepadButtonPath, 1);
	games_gamepad_button_path_copy (self, dup);
	return dup;
}

void
games_gamepad_button_path_free (GamesGamepadButtonPath* self)
{
	games_gamepad_button_path_destroy (self);
	g_free (self);
}

static GType
games_gamepad_button_path_get_type_once (void)
{
	GType games_gamepad_button_path_type_id;
	games_gamepad_button_path_type_id = g_boxed_type_register_static ("GamesGamepadButtonPath", (GBoxedCopyFunc) games_gamepad_button_path_dup, (GBoxedFreeFunc) games_gamepad_button_path_free);
	return games_gamepad_button_path_type_id;
}

GType
games_gamepad_button_path_get_type (void)
{
	static volatile gsize games_gamepad_button_path_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_button_path_type_id__once)) {
		GType games_gamepad_button_path_type_id;
		games_gamepad_button_path_type_id = games_gamepad_button_path_get_type_once ();
		g_once_init_leave (&games_gamepad_button_path_type_id__once, games_gamepad_button_path_type_id);
	}
	return games_gamepad_button_path_type_id__once;
}

void
games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                GamesGamepadAnalogPath* dest)
{
	GamesGamepadInput _tmp0_;
	GamesGamepadInput _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).input_x;
	(*dest).input_x = _tmp0_;
	_tmp1_ = (*self).input_y;
	(*dest).input_y = _tmp1_;
	(*dest).offset_radius = (*self).offset_radius;
	_tmp2_ = (*self).path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp3_;
}

void
games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self)
{
	_g_free0 ((*self).path);
}

GamesGamepadAnalogPath*
games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self)
{
	GamesGamepadAnalogPath* dup;
	dup = g_new0 (GamesGamepadAnalogPath, 1);
	games_gamepad_analog_path_copy (self, dup);
	return dup;
}

void
games_gamepad_analog_path_free (GamesGamepadAnalogPath* self)
{
	games_gamepad_analog_path_destroy (self);
	g_free (self);
}

static GType
games_gamepad_analog_path_get_type_once (void)
{
	GType games_gamepad_analog_path_type_id;
	games_gamepad_analog_path_type_id = g_boxed_type_register_static ("GamesGamepadAnalogPath", (GBoxedCopyFunc) games_gamepad_analog_path_dup, (GBoxedFreeFunc) games_gamepad_analog_path_free);
	return games_gamepad_analog_path_type_id;
}

GType
games_gamepad_analog_path_get_type (void)
{
	static volatile gsize games_gamepad_analog_path_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_analog_path_type_id__once)) {
		GType games_gamepad_analog_path_type_id;
		games_gamepad_analog_path_type_id = games_gamepad_analog_path_get_type_once ();
		g_once_init_leave (&games_gamepad_analog_path_type_id__once, games_gamepad_analog_path_type_id);
	}
	return games_gamepad_analog_path_type_id__once;
}

static void
_vala_GamesGamepadButtonPath_array_free (GamesGamepadButtonPath * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_button_path_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_GamesGamepadAnalogPath_array_free (GamesGamepadAnalogPath * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_analog_path_destroy (&array[i]);
		}
	}
	g_free (array);
}

static GamesGamepadButtonPath*
_vala_array_dup23 (GamesGamepadButtonPath* self,
                   gssize length)
{
	if (length > 0) {
		GamesGamepadButtonPath* result;
		gssize i;
		result = g_new0 (GamesGamepadButtonPath, length);
		for (i = 0; i < length; i++) {
			GamesGamepadButtonPath _tmp0_;
			GamesGamepadButtonPath _tmp1_ = {0};
			_tmp0_ = self[i];
			games_gamepad_button_path_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static GamesGamepadAnalogPath*
_vala_array_dup24 (GamesGamepadAnalogPath* self,
                   gssize length)
{
	if (length > 0) {
		GamesGamepadAnalogPath* result;
		gssize i;
		result = g_new0 (GamesGamepadAnalogPath, length);
		for (i = 0; i < length; i++) {
			GamesGamepadAnalogPath _tmp0_;
			GamesGamepadAnalogPath _tmp1_ = {0};
			_tmp0_ = self[i];
			games_gamepad_analog_path_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup25 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
games_gamepad_view_configuration_get_default (GamesGamepadViewConfiguration* result)
{
	GamesGamepadViewConfiguration conf = {0};
	GamesGamepadViewConfiguration _tmp0_ = {0};
	gchar* _tmp1_;
	GamesGamepadButtonPath* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadAnalogPath* _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	conf = _tmp0_;
	_tmp1_ = g_strdup ("/org/gnome/Games/gamepad/standard-gamepad.svg");
	_g_free0 (conf.svg_path);
	conf.svg_path = _tmp1_;
	_tmp2_ = _vala_array_dup23 (GAMES_STANDARD_GAMEPAD_BUTTON_PATHS, G_N_ELEMENTS (GAMES_STANDARD_GAMEPAD_BUTTON_PATHS));
	_tmp2__length1 = G_N_ELEMENTS (GAMES_STANDARD_GAMEPAD_BUTTON_PATHS);
	conf.button_paths = (_vala_GamesGamepadButtonPath_array_free (conf.button_paths, conf.button_paths_length1), NULL);
	conf.button_paths = _tmp2_;
	conf.button_paths_length1 = _tmp2__length1;
	conf._button_paths_size_ = conf.button_paths_length1;
	_tmp3_ = _vala_array_dup24 (GAMES_STANDARD_GAMEPAD_ANALOG_PATHS, G_N_ELEMENTS (GAMES_STANDARD_GAMEPAD_ANALOG_PATHS));
	_tmp3__length1 = G_N_ELEMENTS (GAMES_STANDARD_GAMEPAD_ANALOG_PATHS);
	conf.analog_paths = (_vala_GamesGamepadAnalogPath_array_free (conf.analog_paths, conf.analog_paths_length1), NULL);
	conf.analog_paths = _tmp3_;
	conf.analog_paths_length1 = _tmp3__length1;
	conf._analog_paths_size_ = conf.analog_paths_length1;
	_tmp4_ = _vala_array_dup25 (GAMES_BACKGROUND_PATHS, G_N_ELEMENTS (GAMES_BACKGROUND_PATHS));
	_tmp4__length1 = G_N_ELEMENTS (GAMES_BACKGROUND_PATHS);
	conf.background_paths = (_vala_array_free (conf.background_paths, conf.background_paths_length1, (GDestroyNotify) g_free), NULL);
	conf.background_paths = _tmp4_;
	conf.background_paths_length1 = _tmp4__length1;
	conf._background_paths_size_ = conf.background_paths_length1;
	*result = conf;
	return;
}

static GamesGamepadButtonPath*
_vala_array_dup26 (GamesGamepadButtonPath* self,
                   gssize length)
{
	if (length > 0) {
		GamesGamepadButtonPath* result;
		gssize i;
		result = g_new0 (GamesGamepadButtonPath, length);
		for (i = 0; i < length; i++) {
			GamesGamepadButtonPath _tmp0_;
			GamesGamepadButtonPath _tmp1_ = {0};
			_tmp0_ = self[i];
			games_gamepad_button_path_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static GamesGamepadAnalogPath*
_vala_array_dup27 (GamesGamepadAnalogPath* self,
                   gssize length)
{
	if (length > 0) {
		GamesGamepadAnalogPath* result;
		gssize i;
		result = g_new0 (GamesGamepadAnalogPath, length);
		for (i = 0; i < length; i++) {
			GamesGamepadAnalogPath _tmp0_;
			GamesGamepadAnalogPath _tmp1_ = {0};
			_tmp0_ = self[i];
			games_gamepad_analog_path_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup28 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                       GamesGamepadViewConfiguration* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesGamepadButtonPath* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadButtonPath* _tmp3_;
	gint _tmp3__length1;
	GamesGamepadAnalogPath* _tmp4_;
	gint _tmp4__length1;
	GamesGamepadAnalogPath* _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	_tmp0_ = (*self).svg_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).svg_path);
	(*dest).svg_path = _tmp1_;
	_tmp2_ = (*self).button_paths;
	_tmp2__length1 = (*self).button_paths_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup26 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).button_paths = (_vala_GamesGamepadButtonPath_array_free ((*dest).button_paths, (*dest).button_paths_length1), NULL);
	(*dest).button_paths = _tmp3_;
	(*dest).button_paths_length1 = _tmp3__length1;
	(*dest)._button_paths_size_ = (*dest).button_paths_length1;
	_tmp4_ = (*self).analog_paths;
	_tmp4__length1 = (*self).analog_paths_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup27 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	(*dest).analog_paths = (_vala_GamesGamepadAnalogPath_array_free ((*dest).analog_paths, (*dest).analog_paths_length1), NULL);
	(*dest).analog_paths = _tmp5_;
	(*dest).analog_paths_length1 = _tmp5__length1;
	(*dest)._analog_paths_size_ = (*dest).analog_paths_length1;
	_tmp6_ = (*self).background_paths;
	_tmp6__length1 = (*self).background_paths_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup28 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	(*dest).background_paths = (_vala_array_free ((*dest).background_paths, (*dest).background_paths_length1, (GDestroyNotify) g_free), NULL);
	(*dest).background_paths = _tmp7_;
	(*dest).background_paths_length1 = _tmp7__length1;
	(*dest)._background_paths_size_ = (*dest).background_paths_length1;
}

void
games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self)
{
	_g_free0 ((*self).svg_path);
	(*self).button_paths = (_vala_GamesGamepadButtonPath_array_free ((*self).button_paths, (*self).button_paths_length1), NULL);
	(*self).analog_paths = (_vala_GamesGamepadAnalogPath_array_free ((*self).analog_paths, (*self).analog_paths_length1), NULL);
	(*self).background_paths = (_vala_array_free ((*self).background_paths, (*self).background_paths_length1, (GDestroyNotify) g_free), NULL);
}

GamesGamepadViewConfiguration*
games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self)
{
	GamesGamepadViewConfiguration* dup;
	dup = g_new0 (GamesGamepadViewConfiguration, 1);
	games_gamepad_view_configuration_copy (self, dup);
	return dup;
}

void
games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self)
{
	games_gamepad_view_configuration_destroy (self);
	g_free (self);
}

static GType
games_gamepad_view_configuration_get_type_once (void)
{
	GType games_gamepad_view_configuration_type_id;
	games_gamepad_view_configuration_type_id = g_boxed_type_register_static ("GamesGamepadViewConfiguration", (GBoxedCopyFunc) games_gamepad_view_configuration_dup, (GBoxedFreeFunc) games_gamepad_view_configuration_free);
	return games_gamepad_view_configuration_type_id;
}

GType
games_gamepad_view_configuration_get_type (void)
{
	static volatile gsize games_gamepad_view_configuration_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_view_configuration_type_id__once)) {
		GType games_gamepad_view_configuration_type_id;
		games_gamepad_view_configuration_type_id = games_gamepad_view_configuration_get_type_once ();
		g_once_init_leave (&games_gamepad_view_configuration_type_id__once, games_gamepad_view_configuration_type_id);
	}
	return games_gamepad_view_configuration_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

