/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "cc-dbus-color-manager.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_connector,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_red,
        GVariant *arg_green,
        GVariant *arg_blue,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ColorManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcDBusColorManager
 * @title: CcDBusColorManager
 * @short_description: Generated C code for the org.gnome.Mutter.ColorManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ColorManager ---- */

static const _ExtendedGDBusArgInfo _cc_dbus_color_manager_method_info_calibrate_monitor_IN_ARG_connector =
{
  {
    -1,
    (gchar *) "connector",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_dbus_color_manager_method_info_calibrate_monitor_IN_ARG_pointers[] =
{
  &_cc_dbus_color_manager_method_info_calibrate_monitor_IN_ARG_connector.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cc_dbus_color_manager_method_info_calibrate_monitor_OUT_ARG_session =
{
  {
    -1,
    (gchar *) "session",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_dbus_color_manager_method_info_calibrate_monitor_OUT_ARG_pointers[] =
{
  &_cc_dbus_color_manager_method_info_calibrate_monitor_OUT_ARG_session.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_dbus_color_manager_method_info_calibrate_monitor =
{
  {
    -1,
    (gchar *) "CalibrateMonitor",
    (GDBusArgInfo **) &_cc_dbus_color_manager_method_info_calibrate_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_cc_dbus_color_manager_method_info_calibrate_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-calibrate-monitor",
  FALSE
};

static const GDBusMethodInfo * const _cc_dbus_color_manager_method_info_pointers[] =
{
  &_cc_dbus_color_manager_method_info_calibrate_monitor.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_dbus_color_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ColorManager",
    (GDBusMethodInfo **) &_cc_dbus_color_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "color-manager",
};


/**
 * cc_dbus_color_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_dbus_color_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct;
}

/**
 * cc_dbus_color_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcDBusColorManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_dbus_color_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
cc_dbus_color_manager_method_marshal_calibrate_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcDBusColorManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link>.
 */

/**
 * CcDBusColorManagerIface:
 * @parent_iface: The parent interface.
 * @handle_calibrate_monitor: Handler for the #CcDBusColorManager::handle-calibrate-monitor signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link>.
 */

typedef CcDBusColorManagerIface CcDBusColorManagerInterface;
G_DEFINE_INTERFACE (CcDBusColorManager, cc_dbus_color_manager, G_TYPE_OBJECT)

static void
cc_dbus_color_manager_default_init (CcDBusColorManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcDBusColorManager::handle-calibrate-monitor:
   * @object: A #CcDBusColorManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connector: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager.CalibrateMonitor">CalibrateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_dbus_color_manager_complete_calibrate_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-calibrate-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcDBusColorManagerIface, handle_calibrate_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      cc_dbus_color_manager_method_marshal_calibrate_monitor,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

}

/**
 * cc_dbus_color_manager_call_calibrate_monitor:
 * @proxy: A #CcDBusColorManagerProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager.CalibrateMonitor">CalibrateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_call_calibrate_monitor_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_call_calibrate_monitor_sync() for the synchronous, blocking version of this method.
 */
void
cc_dbus_color_manager_call_calibrate_monitor (
    CcDBusColorManager *proxy,
    const gchar *arg_connector,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CalibrateMonitor",
    g_variant_new ("(s)",
                   arg_connector),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_dbus_color_manager_call_calibrate_monitor_finish:
 * @proxy: A #CcDBusColorManagerProxy.
 * @out_session: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_call_calibrate_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_dbus_color_manager_call_calibrate_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_call_calibrate_monitor_finish (
    CcDBusColorManager *proxy,
    gchar **out_session,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_call_calibrate_monitor_sync:
 * @proxy: A #CcDBusColorManagerProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @out_session: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager.CalibrateMonitor">CalibrateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_call_calibrate_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_call_calibrate_monitor_sync (
    CcDBusColorManager *proxy,
    const gchar *arg_connector,
    gchar **out_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CalibrateMonitor",
    g_variant_new ("(s)",
                   arg_connector),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_complete_calibrate_monitor:
 * @object: A #CcDBusColorManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager.CalibrateMonitor">CalibrateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_dbus_color_manager_complete_calibrate_monitor (
    CcDBusColorManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session));
}

/* ------------------------------------------------------------------------ */

/**
 * CcDBusColorManagerProxy:
 *
 * The #CcDBusColorManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcDBusColorManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcDBusColorManagerProxy.
 */

struct _CcDBusColorManagerProxyPrivate
{
  GData *qdata;
};

static void cc_dbus_color_manager_proxy_iface_init (CcDBusColorManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerProxy, cc_dbus_color_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcDBusColorManagerProxy)
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER, cc_dbus_color_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerProxy, cc_dbus_color_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER, cc_dbus_color_manager_proxy_iface_init))

#endif
static void
cc_dbus_color_manager_proxy_finalize (GObject *object)
{
  CcDBusColorManagerProxy *proxy = CC_DBUS_COLOR_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_dbus_color_manager_proxy_parent_class)->finalize (object);
}

static void
cc_dbus_color_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cc_dbus_color_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cc_dbus_color_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_DBUS_TYPE_COLOR_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_DBUS_TYPE_COLOR_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_dbus_color_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcDBusColorManagerProxy *proxy = CC_DBUS_COLOR_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
cc_dbus_color_manager_proxy_init (CcDBusColorManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_dbus_color_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_DBUS_TYPE_COLOR_MANAGER_PROXY, CcDBusColorManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_dbus_color_manager_interface_info ());
}

static void
cc_dbus_color_manager_proxy_class_init (CcDBusColorManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_dbus_color_manager_proxy_finalize;
  gobject_class->get_property = cc_dbus_color_manager_proxy_get_property;
  gobject_class->set_property = cc_dbus_color_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_dbus_color_manager_proxy_g_signal;
  proxy_class->g_properties_changed = cc_dbus_color_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcDBusColorManagerProxyPrivate));
#endif
}

static void
cc_dbus_color_manager_proxy_iface_init (CcDBusColorManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * cc_dbus_color_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_proxy_new_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_dbus_color_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_DBUS_TYPE_COLOR_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager", NULL);
}

/**
 * cc_dbus_color_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_dbus_color_manager_proxy_new().
 *
 * Returns: (transfer full) (type CcDBusColorManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManager *
cc_dbus_color_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER (ret);
  else
    return NULL;
}

/**
 * cc_dbus_color_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcDBusColorManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManager *
cc_dbus_color_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_DBUS_TYPE_COLOR_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager", NULL);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER (ret);
  else
    return NULL;
}


/**
 * cc_dbus_color_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_dbus_color_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_dbus_color_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_DBUS_TYPE_COLOR_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager", NULL);
}

/**
 * cc_dbus_color_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_dbus_color_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcDBusColorManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManager *
cc_dbus_color_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER (ret);
  else
    return NULL;
}

/**
 * cc_dbus_color_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_dbus_color_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcDBusColorManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManager *
cc_dbus_color_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_DBUS_TYPE_COLOR_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager", NULL);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcDBusColorManagerSkeleton:
 *
 * The #CcDBusColorManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcDBusColorManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcDBusColorManagerSkeleton.
 */

struct _CcDBusColorManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_dbus_color_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcDBusColorManagerSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_DBUS_TYPE_COLOR_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_DBUS_TYPE_COLOR_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_dbus_color_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcDBusColorManagerSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_dbus_color_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcDBusColorManagerSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_dbus_color_manager_skeleton_vtable =
{
  _cc_dbus_color_manager_skeleton_handle_method_call,
  _cc_dbus_color_manager_skeleton_handle_get_property,
  _cc_dbus_color_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_dbus_color_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_dbus_color_manager_interface_info ();
}

static GDBusInterfaceVTable *
cc_dbus_color_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_dbus_color_manager_skeleton_vtable;
}

static GVariant *
cc_dbus_color_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcDBusColorManagerSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_dbus_color_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_dbus_color_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_dbus_color_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_dbus_color_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ColorManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
cc_dbus_color_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void cc_dbus_color_manager_skeleton_iface_init (CcDBusColorManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerSkeleton, cc_dbus_color_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcDBusColorManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER, cc_dbus_color_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerSkeleton, cc_dbus_color_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER, cc_dbus_color_manager_skeleton_iface_init))

#endif
static void
cc_dbus_color_manager_skeleton_finalize (GObject *object)
{
  CcDBusColorManagerSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_dbus_color_manager_skeleton_parent_class)->finalize (object);
}

static void
cc_dbus_color_manager_skeleton_init (CcDBusColorManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_dbus_color_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_DBUS_TYPE_COLOR_MANAGER_SKELETON, CcDBusColorManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
cc_dbus_color_manager_skeleton_class_init (CcDBusColorManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_dbus_color_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_dbus_color_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_dbus_color_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_dbus_color_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_dbus_color_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcDBusColorManagerSkeletonPrivate));
#endif
}

static void
cc_dbus_color_manager_skeleton_iface_init (CcDBusColorManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * cc_dbus_color_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager.top_of_page">org.gnome.Mutter.ColorManager</link>.
 *
 * Returns: (transfer full) (type CcDBusColorManagerSkeleton): The skeleton object.
 */
CcDBusColorManager *
cc_dbus_color_manager_skeleton_new (void)
{
  return CC_DBUS_COLOR_MANAGER (g_object_new (CC_DBUS_TYPE_COLOR_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ColorManager.Calibration
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcDBusColorManagerCalibration
 * @title: CcDBusColorManagerCalibration
 * @short_description: Generated C code for the org.gnome.Mutter.ColorManager.Calibration D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ColorManager.Calibration ---- */

static const _ExtendedGDBusArgInfo _cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_red =
{
  {
    -1,
    (gchar *) "red",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_green =
{
  {
    -1,
    (gchar *) "green",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_blue =
{
  {
    -1,
    (gchar *) "blue",
    (gchar *) "aq",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_pointers[] =
{
  &_cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_red.parent_struct,
  &_cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_green.parent_struct,
  &_cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_blue.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut =
{
  {
    -1,
    (gchar *) "SetCrtcGammaLut",
    (GDBusArgInfo **) &_cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-crtc-gamma-lut",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cc_dbus_color_manager_calibration_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const GDBusMethodInfo * const _cc_dbus_color_manager_calibration_method_info_pointers[] =
{
  &_cc_dbus_color_manager_calibration_method_info_set_crtc_gamma_lut.parent_struct,
  &_cc_dbus_color_manager_calibration_method_info_stop.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cc_dbus_color_manager_calibration_property_info_gamma_lut_size =
{
  {
    -1,
    (gchar *) "GammaLutSize",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gamma-lut-size",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cc_dbus_color_manager_calibration_property_info_pointers[] =
{
  &_cc_dbus_color_manager_calibration_property_info_gamma_lut_size.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_dbus_color_manager_calibration_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ColorManager.Calibration",
    (GDBusMethodInfo **) &_cc_dbus_color_manager_calibration_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_cc_dbus_color_manager_calibration_property_info_pointers,
    NULL
  },
  "color-manager-calibration",
};


/**
 * cc_dbus_color_manager_calibration_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_dbus_color_manager_calibration_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct;
}

/**
 * cc_dbus_color_manager_calibration_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcDBusColorManagerCalibration interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_dbus_color_manager_calibration_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "gamma-lut-size");
  return property_id_begin - 1;
}


inline static void
cc_dbus_color_manager_calibration_method_marshal_set_crtc_gamma_lut (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_dbus_color_manager_calibration_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcDBusColorManagerCalibration:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link>.
 */

/**
 * CcDBusColorManagerCalibrationIface:
 * @parent_iface: The parent interface.
 * @handle_set_crtc_gamma_lut: Handler for the #CcDBusColorManagerCalibration::handle-set-crtc-gamma-lut signal.
 * @handle_stop: Handler for the #CcDBusColorManagerCalibration::handle-stop signal.
 * @get_gamma_lut_size: Getter for the #CcDBusColorManagerCalibration:gamma-lut-size property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link>.
 */

typedef CcDBusColorManagerCalibrationIface CcDBusColorManagerCalibrationInterface;
G_DEFINE_INTERFACE (CcDBusColorManagerCalibration, cc_dbus_color_manager_calibration, G_TYPE_OBJECT)

static void
cc_dbus_color_manager_calibration_default_init (CcDBusColorManagerCalibrationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcDBusColorManagerCalibration::handle-set-crtc-gamma-lut:
   * @object: A #CcDBusColorManagerCalibration.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_red: Argument passed by remote caller.
   * @arg_green: Argument passed by remote caller.
   * @arg_blue: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.SetCrtcGammaLut">SetCrtcGammaLut()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_dbus_color_manager_calibration_complete_set_crtc_gamma_lut() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-crtc-gamma-lut",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcDBusColorManagerCalibrationIface, handle_set_crtc_gamma_lut),
    g_signal_accumulator_true_handled,
    NULL,
      cc_dbus_color_manager_calibration_method_marshal_set_crtc_gamma_lut,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * CcDBusColorManagerCalibration::handle-stop:
   * @object: A #CcDBusColorManagerCalibration.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_dbus_color_manager_calibration_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcDBusColorManagerCalibrationIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      cc_dbus_color_manager_calibration_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * CcDBusColorManagerCalibration:gamma-lut-size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-ColorManager-Calibration.GammaLutSize">"GammaLutSize"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("gamma-lut-size", "GammaLutSize", "GammaLutSize", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cc_dbus_color_manager_calibration_get_gamma_lut_size: (skip)
 * @object: A #CcDBusColorManagerCalibration.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-ColorManager-Calibration.GammaLutSize">"GammaLutSize"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
cc_dbus_color_manager_calibration_get_gamma_lut_size (CcDBusColorManagerCalibration *object)
{
  g_return_val_if_fail (CC_DBUS_IS_COLOR_MANAGER_CALIBRATION (object), 0);

  return CC_DBUS_COLOR_MANAGER_CALIBRATION_GET_IFACE (object)->get_gamma_lut_size (object);
}

/**
 * cc_dbus_color_manager_calibration_set_gamma_lut_size: (skip)
 * @object: A #CcDBusColorManagerCalibration.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-ColorManager-Calibration.GammaLutSize">"GammaLutSize"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_dbus_color_manager_calibration_set_gamma_lut_size (CcDBusColorManagerCalibration *object, guint value)
{
  g_object_set (G_OBJECT (object), "gamma-lut-size", value, NULL);
}

/**
 * cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @arg_red: Argument to pass with the method invocation.
 * @arg_green: Argument to pass with the method invocation.
 * @arg_blue: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.SetCrtcGammaLut">SetCrtcGammaLut()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_sync() for the synchronous, blocking version of this method.
 */
void
cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut (
    CcDBusColorManagerCalibration *proxy,
    GVariant *arg_red,
    GVariant *arg_green,
    GVariant *arg_blue,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCrtcGammaLut",
    g_variant_new ("(@aq@aq@aq)",
                   arg_red,
                   arg_green,
                   arg_blue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_finish:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_finish (
    CcDBusColorManagerCalibration *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_sync:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @arg_red: Argument to pass with the method invocation.
 * @arg_green: Argument to pass with the method invocation.
 * @arg_blue: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.SetCrtcGammaLut">SetCrtcGammaLut()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_calibration_call_set_crtc_gamma_lut_sync (
    CcDBusColorManagerCalibration *proxy,
    GVariant *arg_red,
    GVariant *arg_green,
    GVariant *arg_blue,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCrtcGammaLut",
    g_variant_new ("(@aq@aq@aq)",
                   arg_red,
                   arg_green,
                   arg_blue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_calibration_call_stop:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_calibration_call_stop_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_calibration_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
cc_dbus_color_manager_calibration_call_stop (
    CcDBusColorManagerCalibration *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_dbus_color_manager_calibration_call_stop_finish:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_calibration_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_dbus_color_manager_calibration_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_calibration_call_stop_finish (
    CcDBusColorManagerCalibration *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_calibration_call_stop_sync:
 * @proxy: A #CcDBusColorManagerCalibrationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_calibration_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_dbus_color_manager_calibration_call_stop_sync (
    CcDBusColorManagerCalibration *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_dbus_color_manager_calibration_complete_set_crtc_gamma_lut:
 * @object: A #CcDBusColorManagerCalibration.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.SetCrtcGammaLut">SetCrtcGammaLut()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_dbus_color_manager_calibration_complete_set_crtc_gamma_lut (
    CcDBusColorManagerCalibration *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cc_dbus_color_manager_calibration_complete_stop:
 * @object: A #CcDBusColorManagerCalibration.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ColorManager-Calibration.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_dbus_color_manager_calibration_complete_stop (
    CcDBusColorManagerCalibration *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CcDBusColorManagerCalibrationProxy:
 *
 * The #CcDBusColorManagerCalibrationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcDBusColorManagerCalibrationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcDBusColorManagerCalibrationProxy.
 */

struct _CcDBusColorManagerCalibrationProxyPrivate
{
  GData *qdata;
};

static void cc_dbus_color_manager_calibration_proxy_iface_init (CcDBusColorManagerCalibrationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerCalibrationProxy, cc_dbus_color_manager_calibration_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcDBusColorManagerCalibrationProxy)
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION, cc_dbus_color_manager_calibration_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerCalibrationProxy, cc_dbus_color_manager_calibration_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION, cc_dbus_color_manager_calibration_proxy_iface_init))

#endif
static void
cc_dbus_color_manager_calibration_proxy_finalize (GObject *object)
{
  CcDBusColorManagerCalibrationProxy *proxy = CC_DBUS_COLOR_MANAGER_CALIBRATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_dbus_color_manager_calibration_proxy_parent_class)->finalize (object);
}

static void
cc_dbus_color_manager_calibration_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_dbus_color_manager_calibration_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cc_dbus_color_manager_calibration_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.ColorManager.Calibration: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cc_dbus_color_manager_calibration_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_dbus_color_manager_calibration_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.ColorManager.Calibration", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cc_dbus_color_manager_calibration_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cc_dbus_color_manager_calibration_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_dbus_color_manager_calibration_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcDBusColorManagerCalibrationProxy *proxy = CC_DBUS_COLOR_MANAGER_CALIBRATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
cc_dbus_color_manager_calibration_proxy_get_gamma_lut_size (CcDBusColorManagerCalibration *object)
{
  CcDBusColorManagerCalibrationProxy *proxy = CC_DBUS_COLOR_MANAGER_CALIBRATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GammaLutSize");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
cc_dbus_color_manager_calibration_proxy_init (CcDBusColorManagerCalibrationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_dbus_color_manager_calibration_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_PROXY, CcDBusColorManagerCalibrationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_dbus_color_manager_calibration_interface_info ());
}

static void
cc_dbus_color_manager_calibration_proxy_class_init (CcDBusColorManagerCalibrationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_dbus_color_manager_calibration_proxy_finalize;
  gobject_class->get_property = cc_dbus_color_manager_calibration_proxy_get_property;
  gobject_class->set_property = cc_dbus_color_manager_calibration_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_dbus_color_manager_calibration_proxy_g_signal;
  proxy_class->g_properties_changed = cc_dbus_color_manager_calibration_proxy_g_properties_changed;

  cc_dbus_color_manager_calibration_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcDBusColorManagerCalibrationProxyPrivate));
#endif
}

static void
cc_dbus_color_manager_calibration_proxy_iface_init (CcDBusColorManagerCalibrationIface *iface)
{
  iface->get_gamma_lut_size = cc_dbus_color_manager_calibration_proxy_get_gamma_lut_size;
}

/**
 * cc_dbus_color_manager_calibration_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_calibration_proxy_new_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_calibration_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_dbus_color_manager_calibration_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager.Calibration", NULL);
}

/**
 * cc_dbus_color_manager_calibration_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_calibration_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_dbus_color_manager_calibration_proxy_new().
 *
 * Returns: (transfer full) (type CcDBusColorManagerCalibrationProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManagerCalibration *
cc_dbus_color_manager_calibration_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER_CALIBRATION (ret);
  else
    return NULL;
}

/**
 * cc_dbus_color_manager_calibration_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_calibration_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcDBusColorManagerCalibrationProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManagerCalibration *
cc_dbus_color_manager_calibration_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager.Calibration", NULL);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER_CALIBRATION (ret);
  else
    return NULL;
}


/**
 * cc_dbus_color_manager_calibration_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_dbus_color_manager_calibration_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_dbus_color_manager_calibration_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_dbus_color_manager_calibration_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_dbus_color_manager_calibration_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager.Calibration", NULL);
}

/**
 * cc_dbus_color_manager_calibration_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_dbus_color_manager_calibration_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_dbus_color_manager_calibration_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcDBusColorManagerCalibrationProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManagerCalibration *
cc_dbus_color_manager_calibration_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER_CALIBRATION (ret);
  else
    return NULL;
}

/**
 * cc_dbus_color_manager_calibration_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_dbus_color_manager_calibration_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_dbus_color_manager_calibration_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcDBusColorManagerCalibrationProxy): The constructed proxy object or %NULL if @error is set.
 */
CcDBusColorManagerCalibration *
cc_dbus_color_manager_calibration_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ColorManager.Calibration", NULL);
  if (ret != NULL)
    return CC_DBUS_COLOR_MANAGER_CALIBRATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcDBusColorManagerCalibrationSkeleton:
 *
 * The #CcDBusColorManagerCalibrationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcDBusColorManagerCalibrationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcDBusColorManagerCalibrationSkeleton.
 */

struct _CcDBusColorManagerCalibrationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_dbus_color_manager_calibration_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_dbus_color_manager_calibration_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_dbus_color_manager_calibration_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_dbus_color_manager_calibration_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_dbus_color_manager_calibration_skeleton_vtable =
{
  _cc_dbus_color_manager_calibration_skeleton_handle_method_call,
  _cc_dbus_color_manager_calibration_skeleton_handle_get_property,
  _cc_dbus_color_manager_calibration_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_dbus_color_manager_calibration_interface_info ();
}

static GDBusInterfaceVTable *
cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_dbus_color_manager_calibration_skeleton_vtable;
}

static GVariant *
cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_dbus_color_manager_calibration_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_dbus_color_manager_calibration_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_dbus_color_manager_calibration_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_dbus_color_manager_calibration_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ColorManager.Calibration", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cc_dbus_color_manager_calibration_emit_changed (gpointer user_data);

static void
cc_dbus_color_manager_calibration_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cc_dbus_color_manager_calibration_emit_changed (skeleton);
}

static void cc_dbus_color_manager_calibration_skeleton_iface_init (CcDBusColorManagerCalibrationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerCalibrationSkeleton, cc_dbus_color_manager_calibration_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcDBusColorManagerCalibrationSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION, cc_dbus_color_manager_calibration_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcDBusColorManagerCalibrationSkeleton, cc_dbus_color_manager_calibration_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION, cc_dbus_color_manager_calibration_skeleton_iface_init))

#endif
static void
cc_dbus_color_manager_calibration_skeleton_finalize (GObject *object)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_dbus_color_manager_calibration_skeleton_parent_class)->finalize (object);
}

static void
cc_dbus_color_manager_calibration_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cc_dbus_color_manager_calibration_emit_changed (gpointer user_data)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.ColorManager.Calibration",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cc_dbus_color_manager_calibration_schedule_emit_changed (CcDBusColorManagerCalibrationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cc_dbus_color_manager_calibration_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cc_dbus_color_manager_calibration_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cc_dbus_color_manager_calibration_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cc_dbus_color_manager_calibration_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_dbus_color_manager_calibration_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cc_dbus_color_manager_calibration_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cc_dbus_color_manager_calibration_skeleton_init (CcDBusColorManagerCalibrationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_dbus_color_manager_calibration_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_SKELETON, CcDBusColorManagerCalibrationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
cc_dbus_color_manager_calibration_skeleton_get_gamma_lut_size (CcDBusColorManagerCalibration *object)
{
  CcDBusColorManagerCalibrationSkeleton *skeleton = CC_DBUS_COLOR_MANAGER_CALIBRATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cc_dbus_color_manager_calibration_skeleton_class_init (CcDBusColorManagerCalibrationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_dbus_color_manager_calibration_skeleton_finalize;
  gobject_class->get_property = cc_dbus_color_manager_calibration_skeleton_get_property;
  gobject_class->set_property = cc_dbus_color_manager_calibration_skeleton_set_property;
  gobject_class->notify       = cc_dbus_color_manager_calibration_skeleton_notify;


  cc_dbus_color_manager_calibration_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_dbus_color_manager_calibration_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_dbus_color_manager_calibration_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcDBusColorManagerCalibrationSkeletonPrivate));
#endif
}

static void
cc_dbus_color_manager_calibration_skeleton_iface_init (CcDBusColorManagerCalibrationIface *iface)
{
  iface->get_gamma_lut_size = cc_dbus_color_manager_calibration_skeleton_get_gamma_lut_size;
}

/**
 * cc_dbus_color_manager_calibration_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ColorManager-Calibration.top_of_page">org.gnome.Mutter.ColorManager.Calibration</link>.
 *
 * Returns: (transfer full) (type CcDBusColorManagerCalibrationSkeleton): The skeleton object.
 */
CcDBusColorManagerCalibration *
cc_dbus_color_manager_calibration_skeleton_new (void)
{
  return CC_DBUS_COLOR_MANAGER_CALIBRATION (g_object_new (CC_DBUS_TYPE_COLOR_MANAGER_CALIBRATION_SKELETON, NULL));
}

