/* contacts-avatar-selector.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-avatar-selector.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "contactscore.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <adwaita.h>
#include <folks/folks.h>
#include <libportal/portal.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "contacts.h"

#define MAIN_SIZE 128
#define ICONS_SIZE 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_THUMBNAIL (contacts_thumbnail_get_type ())
#define CONTACTS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail))
#define CONTACTS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnailClass))
#define CONTACTS_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_THUMBNAIL))
#define CONTACTS_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_THUMBNAIL))
#define CONTACTS_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnailClass))

typedef struct _ContactsThumbnail ContactsThumbnail;
typedef struct _ContactsThumbnailClass ContactsThumbnailClass;
typedef struct _ContactsThumbnailPrivate ContactsThumbnailPrivate;
enum  {
	CONTACTS_THUMBNAIL_0_PROPERTY,
	CONTACTS_THUMBNAIL_TEXTURE_PROPERTY,
	CONTACTS_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* contacts_thumbnail_properties[CONTACTS_THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsThumbnailForChunkData ContactsThumbnailForChunkData;
typedef struct _ContactsThumbnailForFileData ContactsThumbnailForFileData;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;

#define CONTACTS_TYPE_AVATAR_SELECTOR (contacts_avatar_selector_get_type ())
#define CONTACTS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector))
#define CONTACTS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))
#define CONTACTS_IS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_IS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_AVATAR_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))

typedef struct _ContactsAvatarSelector ContactsAvatarSelector;
typedef struct _ContactsAvatarSelectorClass ContactsAvatarSelectorClass;
typedef struct _ContactsAvatarSelectorPrivate ContactsAvatarSelectorPrivate;
enum  {
	CONTACTS_AVATAR_SELECTOR_0_PROPERTY,
	CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY,
	CONTACTS_AVATAR_SELECTOR_NUM_PROPERTIES
};
static GParamSpec* contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsAvatarSelectorSetupCameraPortalData ContactsAvatarSelectorSetupCameraPortalData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _Block8Data Block8Data;

#define CONTACTS_TYPE_CROP_DIALOG (contacts_crop_dialog_get_type ())
#define CONTACTS_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialog))
#define CONTACTS_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialogClass))
#define CONTACTS_IS_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CROP_DIALOG))
#define CONTACTS_IS_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CROP_DIALOG))
#define CONTACTS_CROP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialogClass))

typedef struct _ContactsCropDialog ContactsCropDialog;
typedef struct _ContactsCropDialogClass ContactsCropDialogClass;
typedef struct _Block9Data Block9Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsAvatarSelectorChooseFileData ContactsAvatarSelectorChooseFileData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsThumbnail {
	GtkFlowBoxChild parent_instance;
	ContactsThumbnailPrivate * priv;
};

struct _ContactsThumbnailClass {
	GtkFlowBoxChildClass parent_class;
};

struct _ContactsThumbnailPrivate {
	GdkTexture* _texture;
};

struct _ContactsThumbnailForChunkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatarChunk* chunk;
	ContactsThumbnail* result;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GInputStream* stream;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_;
	GInputStream* _tmp4_;
	GdkPixbuf* pixbuf;
	GInputStream* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkTexture* _tmp8_;
	GdkTexture* _tmp9_;
	ContactsThumbnail* _tmp10_;
	ContactsThumbnail* _tmp11_;
	GError* _inner_error0_;
};

struct _ContactsThumbnailForFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	ContactsThumbnail* result;
	GFileInputStream* stream;
	GFileInputStream* _tmp0_;
	GdkPixbuf* pixbuf;
	GFileInputStream* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkTexture* _tmp4_;
	GdkTexture* _tmp5_;
	ContactsThumbnail* _tmp6_;
	ContactsThumbnail* _tmp7_;
	GError* _inner_error0_;
};

struct _ContactsAvatarSelector {
	AdwDialog parent_instance;
	ContactsAvatarSelectorPrivate * priv;
};

struct _ContactsAvatarSelectorClass {
	AdwDialogClass parent_class;
};

struct _ContactsAvatarSelectorPrivate {
	ContactsContact* _contact;
	GtkFlowBox* thumbnail_grid;
	GtkButton* camera_button;
	XdpPortal* portal;
	GdkTexture* selected;
};

struct _ContactsAvatarSelectorSetupCameraPortalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatarSelector* self;
	XdpPortal* _tmp0_;
	XdpPortal* _tmp1_;
	XdpPortal* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	XdpPortal* _tmp6_;
	XdpPortal* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	ContactsAvatarSelector* self;
	const gchar* filename;
};

struct _Block9Data {
	int _ref_count_;
	ContactsAvatarSelector* self;
	GListStore* filters;
	GtkFileFilter* any_image_filter;
	gpointer _async_data_;
};

struct _ContactsAvatarSelectorChooseFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatarSelector* self;
	Block9Data* _data9_;
	GtkFileDialog* file_dialog;
	GtkFileDialog* _tmp0_;
	GtkFileDialog* _tmp1_;
	GtkFileDialog* _tmp2_;
	GtkFileDialog* _tmp3_;
	GListStore* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GSList* _tmp7_;
	GSList* _tmp8_;
	GListStore* _tmp9_;
	GtkFileFilter* _tmp10_;
	GtkFileDialog* _tmp11_;
	GListStore* _tmp12_;
	GtkFileDialog* _tmp13_;
	GtkFileFilter* _tmp14_;
	const gchar* pictures_folder;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GtkFileDialog* _tmp17_;
	const gchar* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GtkWindow* parent_window;
	GtkRoot* _tmp21_;
	GtkWindow* _tmp22_;
	GFile* file;
	GtkFileDialog* _tmp23_;
	GtkWindow* _tmp24_;
	GFile* _tmp25_;
	GFileInputStream* in_stream;
	GFile* _tmp26_;
	GFileInputStream* _tmp27_;
	GdkPixbuf* pixbuf;
	GFileInputStream* _tmp28_;
	GdkPixbuf* _tmp29_;
	GdkTexture* texture;
	GdkPixbuf* _tmp30_;
	GdkTexture* _tmp31_;
	GFileInputStream* _tmp32_;
	ContactsCropDialog* dialog;
	GdkTexture* _tmp33_;
	ContactsCropDialog* _tmp34_;
	ContactsCropDialog* _tmp35_;
	ContactsCropDialog* _tmp36_;
	GtkWindow* _tmp37_;
	GError* _error_;
	GError* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	GError* e;
	GError* _tmp43_;
	const gchar* _tmp44_;
	AdwAlertDialog* _vala1_dialog;
	AdwAlertDialog* _tmp45_;
	AdwAlertDialog* _tmp46_;
	AdwAlertDialog* _tmp47_;
	AdwAlertDialog* _tmp48_;
	GError* _inner_error0_;
};

static gint ContactsThumbnail_private_offset;
static gpointer contacts_thumbnail_parent_class = NULL;
static gint ContactsAvatarSelector_private_offset;
static gpointer contacts_avatar_selector_parent_class = NULL;

VALA_EXTERN GType contacts_thumbnail_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsThumbnail, g_object_unref)
static ContactsThumbnail* contacts_thumbnail_new (GdkTexture* texture);
static ContactsThumbnail* contacts_thumbnail_construct (GType object_type,
                                                 GdkTexture* texture);
static void contacts_thumbnail_for_chunk_data_free (gpointer _data);
VALA_EXTERN void contacts_thumbnail_for_chunk (ContactsAvatarChunk* chunk,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_for_chunk_finish (GAsyncResult* _res_,
                                                        GError** error);
static gboolean contacts_thumbnail_for_chunk_co (ContactsThumbnailForChunkData* _data_);
static void contacts_thumbnail_for_chunk_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void contacts_thumbnail_for_file_data_free (gpointer _data);
VALA_EXTERN void contacts_thumbnail_for_file (GFile* file,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_for_file_finish (GAsyncResult* _res_,
                                                       GError** error);
static gboolean contacts_thumbnail_for_file_co (ContactsThumbnailForFileData* _data_);
static void contacts_thumbnail_for_file_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN GdkTexture* contacts_thumbnail_get_texture (ContactsThumbnail* self);
VALA_EXTERN void contacts_thumbnail_set_texture (ContactsThumbnail* self,
                                     GdkTexture* value);
static GObject * contacts_thumbnail_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
VALA_EXTERN void contacts_avatar_set_paintable (ContactsAvatar* self,
                                    GdkPaintable* paintable);
static void contacts_thumbnail_finalize (GObject * obj);
static GType contacts_thumbnail_get_type_once (void);
static void _vala_contacts_thumbnail_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_contacts_thumbnail_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType contacts_avatar_selector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatarSelector, g_object_unref)
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_new (ContactsContact* contact);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_construct (GType object_type,
                                                            ContactsContact* contact);
static void contacts_avatar_selector_on_thumbnails_selected (ContactsAvatarSelector* self,
                                                      GtkFlowBox* thumbnail_grid);
static void _contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                              gpointer self);
static void contacts_avatar_selector_on_thumbnail_activated (ContactsAvatarSelector* self,
                                                      GtkFlowBox* thumbnail_grid,
                                                      GtkFlowBoxChild* child);
static void _contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                    GtkFlowBoxChild* child,
                                                                                    gpointer self);
static void contacts_avatar_selector_update_thumbnail_grid (ContactsAvatarSelector* self);
static void contacts_avatar_selector_setup_camera_portal (ContactsAvatarSelector* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void contacts_avatar_selector_setup_camera_portal_finish (ContactsAvatarSelector* self,
                                                          GAsyncResult* _res_);
static void contacts_avatar_selector_setup_camera_portal_data_free (gpointer _data);
static gboolean contacts_avatar_selector_setup_camera_portal_co (ContactsAvatarSelectorSetupCameraPortalData* _data_);
static void contacts_avatar_selector_on_set_avatar (ContactsAvatarSelector* self,
                                             const gchar* action_name,
                                             GVariant* param);
VALA_EXTERN ContactsContact* contacts_avatar_selector_get_contact (ContactsAvatarSelector* self);
static void _____lambda17_ (ContactsAvatarSelector* self,
                     GObject* obj,
                     GAsyncResult* res);
static void ______lambda17__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ____lambda18_ (Block8Data* _data8_,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda18__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void contacts_avatar_selector_on_camera_button_clicked (ContactsAvatarSelector* self,
                                                        GtkButton* button);
VALA_EXTERN GType contacts_crop_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsCropDialog, g_object_unref)
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_new_for_portal (XdpPortal* portal,
                                                         GtkWindow* parent);
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_construct_for_portal (GType object_type,
                                                               XdpPortal* portal,
                                                               GtkWindow* parent);
static void __lambda22_ (ContactsAvatarSelector* self,
                  ContactsCropDialog* dialog,
                  GdkTexture* texture);
static void ___lambda22__contacts_crop_dialog_cropped (ContactsCropDialog* _sender,
                                                GdkTexture* texture,
                                                gpointer self);
static void _contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void contacts_avatar_selector_on_file_clicked (ContactsAvatarSelector* self,
                                               GtkButton* button);
static void contacts_avatar_selector_choose_file (ContactsAvatarSelector* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void contacts_avatar_selector_choose_file_finish (ContactsAvatarSelector* self,
                                                  GAsyncResult* _res_);
static void __lambda25_ (ContactsAvatarSelector* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda25__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _contacts_avatar_selector_on_file_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void contacts_avatar_selector_choose_file_data_free (gpointer _data);
static gboolean contacts_avatar_selector_choose_file_co (ContactsAvatarSelectorChooseFileData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda23_ (Block9Data* _data9_,
                  GdkPixbufFormat* format);
static void ___lambda23__gfunc (gconstpointer data,
                         gpointer self);
static void contacts_avatar_selector_choose_file_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_new_for_paintable (GdkPaintable* paintable);
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_construct_for_paintable (GType object_type,
                                                                  GdkPaintable* paintable);
static void ___lambda24_ (ContactsAvatarSelector* self,
                   ContactsCropDialog* dialog,
                   GdkTexture* texture);
static void ____lambda24__contacts_crop_dialog_cropped (ContactsCropDialog* _sender,
                                                 GdkTexture* texture,
                                                 gpointer self);
VALA_EXTERN void contacts_avatar_selector_set_contact (ContactsAvatarSelector* self,
                                           ContactsContact* value);
static void contacts_avatar_selector_finalize (GObject * obj);
static GType contacts_avatar_selector_get_type_once (void);
static void _vala_contacts_avatar_selector_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_avatar_selector_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
contacts_thumbnail_get_instance_private (ContactsThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsThumbnail_private_offset);
}

static ContactsThumbnail*
contacts_thumbnail_construct (GType object_type,
                              GdkTexture* texture)
{
	ContactsThumbnail * self = NULL;
	g_return_val_if_fail (texture != NULL, NULL);
	self = (ContactsThumbnail*) g_object_new (object_type, "texture", texture, NULL);
	return self;
}

static ContactsThumbnail*
contacts_thumbnail_new (GdkTexture* texture)
{
	return contacts_thumbnail_construct (CONTACTS_TYPE_THUMBNAIL, texture);
}

static void
contacts_thumbnail_for_chunk_data_free (gpointer _data)
{
	ContactsThumbnailForChunkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->chunk);
	_g_object_unref0 (_data_->result);
	g_slice_free (ContactsThumbnailForChunkData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_thumbnail_for_chunk (ContactsAvatarChunk* chunk,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ContactsThumbnailForChunkData* _data_;
	ContactsAvatarChunk* _tmp0_;
	g_return_if_fail (chunk != NULL);
	_data_ = g_slice_new0 (ContactsThumbnailForChunkData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_thumbnail_for_chunk_data_free);
	_tmp0_ = _g_object_ref0 (chunk);
	_g_object_unref0 (_data_->chunk);
	_data_->chunk = _tmp0_;
	contacts_thumbnail_for_chunk_co (_data_);
}

ContactsThumbnail*
contacts_thumbnail_for_chunk_finish (GAsyncResult* _res_,
                                     GError** error)
{
	ContactsThumbnail* result;
	ContactsThumbnailForChunkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
contacts_thumbnail_for_chunk_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	ContactsThumbnailForChunkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_thumbnail_for_chunk_co (_data_);
}

static gboolean
contacts_thumbnail_for_chunk_co (ContactsThumbnailForChunkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_avatar_chunk_get_avatar (_data_->chunk);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (_data_->_tmp1_ != NULL, "chunk.avatar != null", FALSE);
	_data_->_tmp2_ = contacts_avatar_chunk_get_avatar (_data_->chunk);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	g_loadable_icon_load_async (_data_->_tmp3_, MAIN_SIZE, NULL, contacts_thumbnail_for_chunk_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = g_loadable_icon_load_finish (_data_->_tmp3_, _data_->_res_, NULL, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->stream;
	_data_->_state_ = 2;
	gdk_pixbuf_new_from_stream_async (_data_->_tmp5_, NULL, contacts_thumbnail_for_chunk_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp6_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->pixbuf = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stream);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->pixbuf;
	_data_->_tmp8_ = gdk_texture_new_for_pixbuf (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = contacts_thumbnail_new (_data_->_tmp9_);
	g_object_ref_sink (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp9_);
	_data_->result = _data_->_tmp11_;
	_g_object_unref0 (_data_->pixbuf);
	_g_object_unref0 (_data_->stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_thumbnail_for_file_data_free (gpointer _data)
{
	ContactsThumbnailForFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->result);
	g_slice_free (ContactsThumbnailForFileData, _data_);
}

void
contacts_thumbnail_for_file (GFile* file,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ContactsThumbnailForFileData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (ContactsThumbnailForFileData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_thumbnail_for_file_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	contacts_thumbnail_for_file_co (_data_);
}

ContactsThumbnail*
contacts_thumbnail_for_file_finish (GAsyncResult* _res_,
                                    GError** error)
{
	ContactsThumbnail* result;
	ContactsThumbnailForFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
contacts_thumbnail_for_file_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ContactsThumbnailForFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_thumbnail_for_file_co (_data_);
}

static gboolean
contacts_thumbnail_for_file_co (ContactsThumbnailForFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_file_read_async (_data_->file, G_PRIORITY_DEFAULT, NULL, contacts_thumbnail_for_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = g_file_read_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->stream;
	_data_->_state_ = 2;
	gdk_pixbuf_new_from_stream_async ((GInputStream*) _data_->_tmp1_, NULL, contacts_thumbnail_for_file_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->pixbuf = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stream);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->pixbuf;
	_data_->_tmp4_ = gdk_texture_new_for_pixbuf (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = contacts_thumbnail_new (_data_->_tmp5_);
	g_object_ref_sink (_data_->_tmp6_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp5_);
	_data_->result = _data_->_tmp7_;
	_g_object_unref0 (_data_->pixbuf);
	_g_object_unref0 (_data_->stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GdkTexture*
contacts_thumbnail_get_texture (ContactsThumbnail* self)
{
	GdkTexture* result;
	GdkTexture* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_texture;
	result = _tmp0_;
	return result;
}

void
contacts_thumbnail_set_texture (ContactsThumbnail* self,
                                GdkTexture* value)
{
	GdkTexture* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_thumbnail_get_texture (self);
	if (old_value != value) {
		GdkTexture* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_texture);
		self->priv->_texture = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_thumbnail_properties[CONTACTS_THUMBNAIL_TEXTURE_PROPERTY]);
	}
}

static GObject *
contacts_thumbnail_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsThumbnail * self;
	ContactsAvatar* avatar = NULL;
	ContactsAvatar* _tmp0_;
	ContactsAvatar* _tmp1_;
	GdkTexture* _tmp2_;
	ContactsAvatar* _tmp3_;
	parent_class = G_OBJECT_CLASS (contacts_thumbnail_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_add_css_class ((GtkWidget*) self, "circular");
	_tmp0_ = contacts_avatar_new (ICONS_SIZE, NULL);
	g_object_ref_sink (_tmp0_);
	avatar = _tmp0_;
	_tmp1_ = avatar;
	_tmp2_ = self->priv->_texture;
	contacts_avatar_set_paintable (_tmp1_, (GdkPaintable*) _tmp2_);
	_tmp3_ = avatar;
	gtk_flow_box_child_set_child ((GtkFlowBoxChild*) self, (GtkWidget*) _tmp3_);
	_g_object_unref0 (avatar);
	return obj;
}

static void
contacts_thumbnail_class_init (ContactsThumbnailClass * klass,
                               gpointer klass_data)
{
	contacts_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsThumbnail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_thumbnail_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_THUMBNAIL_TEXTURE_PROPERTY, contacts_thumbnail_properties[CONTACTS_THUMBNAIL_TEXTURE_PROPERTY] = g_param_spec_object ("texture", "texture", "texture", gdk_texture_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_thumbnail_instance_init (ContactsThumbnail * self,
                                  gpointer klass)
{
	self->priv = contacts_thumbnail_get_instance_private (self);
}

static void
contacts_thumbnail_finalize (GObject * obj)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	_g_object_unref0 (self->priv->_texture);
	G_OBJECT_CLASS (contacts_thumbnail_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsThumbnail), 0, (GInstanceInitFunc) contacts_thumbnail_instance_init, NULL };
	GType contacts_thumbnail_type_id;
	contacts_thumbnail_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "ContactsThumbnail", &g_define_type_info, 0);
	ContactsThumbnail_private_offset = g_type_add_instance_private (contacts_thumbnail_type_id, sizeof (ContactsThumbnailPrivate));
	return contacts_thumbnail_type_id;
}

GType
contacts_thumbnail_get_type (void)
{
	static volatile gsize contacts_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&contacts_thumbnail_type_id__once)) {
		GType contacts_thumbnail_type_id;
		contacts_thumbnail_type_id = contacts_thumbnail_get_type_once ();
		g_once_init_leave (&contacts_thumbnail_type_id__once, contacts_thumbnail_type_id);
	}
	return contacts_thumbnail_type_id__once;
}

static void
_vala_contacts_thumbnail_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	switch (property_id) {
		case CONTACTS_THUMBNAIL_TEXTURE_PROPERTY:
		g_value_set_object (value, contacts_thumbnail_get_texture (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_thumbnail_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	switch (property_id) {
		case CONTACTS_THUMBNAIL_TEXTURE_PROPERTY:
		contacts_thumbnail_set_texture (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_avatar_selector_get_instance_private (ContactsAvatarSelector* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAvatarSelector_private_offset);
}

static void
_contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                         gpointer self)
{
	contacts_avatar_selector_on_thumbnails_selected ((ContactsAvatarSelector*) self, _sender);
}

static void
_contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                               GtkFlowBoxChild* child,
                                                                               gpointer self)
{
	contacts_avatar_selector_on_thumbnail_activated ((ContactsAvatarSelector*) self, _sender, child);
}

ContactsAvatarSelector*
contacts_avatar_selector_construct (GType object_type,
                                    ContactsContact* contact)
{
	ContactsAvatarSelector * self = NULL;
	GtkFlowBox* _tmp0_;
	GtkFlowBox* _tmp1_;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsAvatarSelector*) g_object_new (object_type, "contact", contact, NULL);
	_tmp0_ = self->priv->thumbnail_grid;
	g_signal_connect_object (_tmp0_, "selected-children-changed", (GCallback) _contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed, self, 0);
	_tmp1_ = self->priv->thumbnail_grid;
	g_signal_connect_object (_tmp1_, "child-activated", (GCallback) _contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated, self, 0);
	contacts_avatar_selector_update_thumbnail_grid (self);
	contacts_avatar_selector_setup_camera_portal (self, NULL, NULL);
	return self;
}

ContactsAvatarSelector*
contacts_avatar_selector_new (ContactsContact* contact)
{
	return contacts_avatar_selector_construct (CONTACTS_TYPE_AVATAR_SELECTOR, contact);
}

static void
contacts_avatar_selector_on_thumbnails_selected (ContactsAvatarSelector* self,
                                                 GtkFlowBox* thumbnail_grid)
{
	GList* selected = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thumbnail_grid != NULL);
	_tmp0_ = gtk_flow_box_get_selected_children (thumbnail_grid);
	selected = _tmp0_;
	_tmp1_ = selected;
	if (_tmp1_ != NULL) {
		ContactsThumbnail* thumbnail = NULL;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		ContactsThumbnail* _tmp4_;
		GdkTexture* _tmp5_;
		GdkTexture* _tmp6_;
		GdkTexture* _tmp7_;
		_tmp2_ = selected;
		_tmp3_ = _tmp2_->data;
		thumbnail = G_TYPE_CHECK_INSTANCE_CAST ((GtkFlowBoxChild*) _tmp3_, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
		_tmp4_ = thumbnail;
		_tmp5_ = contacts_thumbnail_get_texture (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = _tmp7_;
	} else {
		_g_object_unref0 (self->priv->selected);
		self->priv->selected = NULL;
	}
	(selected == NULL) ? NULL : (selected = (g_list_free (selected), NULL));
}

static void
contacts_avatar_selector_on_thumbnail_activated (ContactsAvatarSelector* self,
                                                 GtkFlowBox* thumbnail_grid,
                                                 GtkFlowBoxChild* child)
{
	ContactsThumbnail* thumbnail = NULL;
	GdkTexture* _tmp0_;
	GdkTexture* _tmp1_;
	GdkTexture* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thumbnail_grid != NULL);
	g_return_if_fail (child != NULL);
	thumbnail = G_TYPE_CHECK_INSTANCE_CAST (child, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	_tmp0_ = contacts_thumbnail_get_texture (thumbnail);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp2_;
	gtk_widget_activate_action_variant ((GtkWidget*) self, "set-avatar", NULL);
}

static void
contacts_avatar_selector_setup_camera_portal_data_free (gpointer _data)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarSelectorSetupCameraPortalData, _data_);
}

static void
contacts_avatar_selector_setup_camera_portal (ContactsAvatarSelector* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	ContactsAvatarSelector* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarSelectorSetupCameraPortalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_selector_setup_camera_portal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_avatar_selector_setup_camera_portal_co (_data_);
}

static void
contacts_avatar_selector_setup_camera_portal_finish (ContactsAvatarSelector* self,
                                                     GAsyncResult* _res_)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
contacts_avatar_selector_setup_camera_portal_co (ContactsAvatarSelectorSetupCameraPortalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = xdp_portal_initable_new (&_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->portal);
		_data_->self->priv->portal = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("contacts-avatar-selector.vala:102: Failed to create XdpPortal instance" \
": %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->portal;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->self->priv->portal;
		_data_->_tmp5_ = xdp_portal_is_camera_present (_data_->_tmp7_);
	} else {
		_data_->_tmp5_ = FALSE;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp8_ = _data_->self->priv->camera_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp8_, TRUE);
	} else {
		_data_->_tmp9_ = _data_->self->priv->camera_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _data_->_tmp9_, _ ("No Camera Detected"));
		_data_->_tmp10_ = _data_->self->priv->camera_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp10_, FALSE);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Sets the selected avatar on the contact (it does _not_ save it) */
static void
contacts_avatar_selector_on_set_avatar (ContactsAvatarSelector* self,
                                        const gchar* action_name,
                                        GVariant* param)
{
	GdkTexture* _tmp0_;
	GBytes* bytes = NULL;
	GdkTexture* _tmp1_;
	GBytes* _tmp2_;
	GBytesIcon* icon = NULL;
	GBytes* _tmp3_;
	GBytesIcon* _tmp4_;
	ContactsChunk* avatar_chunk = NULL;
	ContactsContact* _tmp5_;
	ContactsChunk* _tmp6_;
	ContactsChunk* _tmp7_;
	ContactsChunk* _tmp8_;
	ContactsChunk* _tmp12_;
	GBytesIcon* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = self->priv->selected;
	if (_tmp0_ == NULL) {
		g_warning ("contacts-avatar-selector.vala:116: Trying to save avatar, but none sel" \
"ected");
		return;
	}
	g_debug ("contacts-avatar-selector.vala:120: Saving avatar");
	_tmp1_ = self->priv->selected;
	_tmp2_ = gdk_texture_save_to_png_bytes (_tmp1_);
	bytes = _tmp2_;
	_tmp3_ = bytes;
	_tmp4_ = (GBytesIcon*) g_bytes_icon_new (_tmp3_);
	icon = _tmp4_;
	_tmp5_ = self->priv->_contact;
	_tmp6_ = contacts_contact_get_most_relevant_chunk (_tmp5_, "avatar", TRUE);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	avatar_chunk = _tmp7_;
	_tmp8_ = avatar_chunk;
	if (_tmp8_ == NULL) {
		ContactsContact* _tmp9_;
		ContactsChunk* _tmp10_;
		ContactsChunk* _tmp11_;
		_tmp9_ = self->priv->_contact;
		_tmp10_ = contacts_contact_create_chunk (_tmp9_, "avatar", NULL);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (avatar_chunk);
		avatar_chunk = _tmp11_;
	}
	_tmp12_ = avatar_chunk;
	_tmp13_ = icon;
	contacts_avatar_chunk_set_avatar (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, CONTACTS_TYPE_AVATAR_CHUNK, ContactsAvatarChunk), (GLoadableIcon*) _tmp13_);
	g_signal_emit_by_name ((GtkWidget*) self, "destroy");
	_g_object_unref0 (avatar_chunk);
	_g_object_unref0 (icon);
	_g_bytes_unref0 (bytes);
}

static void
_____lambda17_ (ContactsAvatarSelector* self,
                GObject* obj,
                GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsThumbnail* thumbnail = NULL;
		ContactsThumbnail* _tmp0_;
		GtkFlowBox* _tmp1_;
		_tmp0_ = contacts_thumbnail_for_chunk_finish (res, &_inner_error0_);
		thumbnail = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->thumbnail_grid;
		gtk_flow_box_insert (_tmp1_, (GtkWidget*) thumbnail, -1);
		_g_object_unref0 (thumbnail);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("contacts-avatar-selector.vala:142: Couldn't create thumbnail for chunk" \
": %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
______lambda17__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda17_ ((ContactsAvatarSelector*) self, source_object, res);
	g_object_unref (self);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ContactsAvatarSelector* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
____lambda18_ (Block8Data* _data8_,
               GObject* obj,
               GAsyncResult* res)
{
	ContactsAvatarSelector* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsThumbnail* thumbnail = NULL;
		ContactsThumbnail* _tmp0_;
		GtkFlowBox* _tmp1_;
		_tmp0_ = contacts_thumbnail_for_file_finish (res, &_inner_error0_);
		thumbnail = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->thumbnail_grid;
		gtk_flow_box_insert (_tmp1_, (GtkWidget*) thumbnail, -1);
		_g_object_unref0 (thumbnail);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _data8_->filename;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("contacts-avatar-selector.vala:155: Couldn't create thumbnail for file " \
"'%s': %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda18__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda18_ (self, source_object, res);
	block8_data_unref (self);
}

static void
contacts_avatar_selector_update_thumbnail_grid (ContactsAvatarSelector* self)
{
	ContactsChunkFilter* filter = NULL;
	ContactsChunkFilter* _tmp0_;
	GtkFilterListModel* chunks = NULL;
	ContactsContact* _tmp1_;
	GListModel* _tmp2_;
	ContactsChunkFilter* _tmp3_;
	GtkFilterListModel* _tmp4_;
	gchar** stock_files = NULL;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint stock_files_length1;
	gint _stock_files_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_chunk_filter_new_for_property ("avatar", FALSE);
	filter = _tmp0_;
	_tmp1_ = self->priv->_contact;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = filter;
	filter = NULL;
	_tmp4_ = gtk_filter_list_model_new (_tmp2_, (GtkFilter*) _tmp3_);
	chunks = _tmp4_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkFilterListModel* _tmp7_;
				ContactsAvatarChunk* chunk = NULL;
				GtkFilterListModel* _tmp8_;
				GObject* _tmp9_;
				ContactsAvatarChunk* _tmp10_;
				if (!_tmp5_) {
					guint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = chunks;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					break;
				}
				_tmp8_ = chunks;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CONTACTS_TYPE_AVATAR_CHUNK, ContactsAvatarChunk);
				_tmp10_ = chunk;
				contacts_thumbnail_for_chunk (_tmp10_, ______lambda17__gasync_ready_callback, g_object_ref (self));
				_g_object_unref0 (chunk);
			}
		}
	}
	_tmp12_ = contacts_utils_get_stock_avatars (&_tmp11_);
	stock_files = _tmp12_;
	stock_files_length1 = _tmp11_;
	_stock_files_size_ = stock_files_length1;
	_tmp13_ = stock_files;
	_tmp13__length1 = stock_files_length1;
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = _tmp13_;
		filename_collection_length1 = _tmp13__length1;
		for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
			const gchar* filename = NULL;
			filename = filename_collection[filename_it];
			{
				Block8Data* _data8_;
				GFile* file = NULL;
				const gchar* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->self = g_object_ref (self);
				_data8_->filename = filename;
				_tmp14_ = _data8_->filename;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				file = _tmp15_;
				_tmp16_ = file;
				contacts_thumbnail_for_file (_tmp16_, _____lambda18__gasync_ready_callback, block8_data_ref (_data8_));
				_g_object_unref0 (file);
				block8_data_unref (_data8_);
				_data8_ = NULL;
			}
		}
	}
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (chunks);
	_g_object_unref0 (filter);
}

static void
__lambda22_ (ContactsAvatarSelector* self,
             ContactsCropDialog* dialog,
             GdkTexture* texture)
{
	GdkTexture* _tmp0_;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (texture != NULL);
	_tmp0_ = _g_object_ref0 (texture);
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp0_;
	gtk_widget_activate_action_variant ((GtkWidget*) self, "set-avatar", NULL);
	adw_dialog_close ((AdwDialog*) dialog);
	adw_dialog_close ((AdwDialog*) self);
}

static void
___lambda22__contacts_crop_dialog_cropped (ContactsCropDialog* _sender,
                                           GdkTexture* texture,
                                           gpointer self)
{
	__lambda22_ ((ContactsAvatarSelector*) self, _sender, texture);
}

static void
contacts_avatar_selector_on_camera_button_clicked (ContactsAvatarSelector* self,
                                                   GtkButton* button)
{
	ContactsCropDialog* dialog = NULL;
	XdpPortal* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsCropDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->portal;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = contacts_crop_dialog_new_for_portal (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	g_signal_connect_object (dialog, "cropped", (GCallback) ___lambda22__contacts_crop_dialog_cropped, self, 0);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) self);
	_g_object_unref0 (dialog);
}

static void
_contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	contacts_avatar_selector_on_camera_button_clicked ((ContactsAvatarSelector*) self, _sender);
}

static void
__lambda25_ (ContactsAvatarSelector* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	contacts_avatar_selector_choose_file_finish (self, res);
}

static void
___lambda25__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda25_ ((ContactsAvatarSelector*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_avatar_selector_on_file_clicked (ContactsAvatarSelector* self,
                                          GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	contacts_avatar_selector_choose_file (self, ___lambda25__gasync_ready_callback, g_object_ref (self));
}

static void
_contacts_avatar_selector_on_file_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	contacts_avatar_selector_on_file_clicked ((ContactsAvatarSelector*) self, _sender);
}

static void
contacts_avatar_selector_choose_file_data_free (gpointer _data)
{
	ContactsAvatarSelectorChooseFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarSelectorChooseFileData, _data_);
}

static void
contacts_avatar_selector_choose_file (ContactsAvatarSelector* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ContactsAvatarSelectorChooseFileData* _data_;
	ContactsAvatarSelector* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarSelectorChooseFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_selector_choose_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_avatar_selector_choose_file_co (_data_);
}

static void
contacts_avatar_selector_choose_file_finish (ContactsAvatarSelector* self,
                                             GAsyncResult* _res_)
{
	ContactsAvatarSelectorChooseFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ContactsAvatarSelector* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->any_image_filter);
		_g_object_unref0 (_data9_->filters);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda23_ (Block9Data* _data9_,
             GdkPixbufFormat* format)
{
	ContactsAvatarSelector* self;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	GListStore* _tmp18_;
	GtkFileFilter* _tmp19_;
	self = _data9_->self;
	g_return_if_fail (format != NULL);
	_tmp0_ = gtk_file_filter_new ();
	filter = _tmp0_;
	_tmp1_ = filter;
	_tmp2_ = gdk_pixbuf_format_get_description (format);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp1_, "name", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_tmp5_ = _tmp4_ = gdk_pixbuf_format_get_mime_types (format);
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = _tmp5_;
		mime_type_collection_length1 = _vala_array_length (_tmp4_);
		for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
			gchar* _tmp6_;
			gchar* mime_type = NULL;
			_tmp6_ = g_strdup (mime_type_collection[mime_type_it]);
			mime_type = _tmp6_;
			{
				GtkFileFilter* _tmp7_;
				const gchar* _tmp8_;
				GtkFileFilter* _tmp9_;
				const gchar* _tmp10_;
				_tmp7_ = filter;
				_tmp8_ = mime_type;
				gtk_file_filter_add_mime_type (_tmp7_, _tmp8_);
				_tmp9_ = _data9_->any_image_filter;
				_tmp10_ = mime_type;
				gtk_file_filter_add_suffix (_tmp9_, _tmp10_);
				_g_free0 (mime_type);
			}
		}
		mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp12_ = _tmp11_ = gdk_pixbuf_format_get_extensions (format);
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = _tmp12_;
		extension_collection_length1 = _vala_array_length (_tmp11_);
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
			gchar* _tmp13_;
			gchar* extension = NULL;
			_tmp13_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp13_;
			{
				GtkFileFilter* _tmp14_;
				const gchar* _tmp15_;
				GtkFileFilter* _tmp16_;
				const gchar* _tmp17_;
				_tmp14_ = filter;
				_tmp15_ = extension;
				gtk_file_filter_add_suffix (_tmp14_, _tmp15_);
				_tmp16_ = _data9_->any_image_filter;
				_tmp17_ = extension;
				gtk_file_filter_add_suffix (_tmp16_, _tmp17_);
				_g_free0 (extension);
			}
		}
		extension_collection = (_vala_array_free (extension_collection, extension_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = _data9_->filters;
	_tmp19_ = filter;
	g_list_store_append (_tmp18_, (GObject*) _tmp19_);
	_g_object_unref0 (filter);
}

static void
___lambda23__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda23_ (self, (GdkPixbufFormat*) data);
}

static void
contacts_avatar_selector_choose_file_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ContactsAvatarSelectorChooseFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_avatar_selector_choose_file_co (_data_);
}

static void
___lambda24_ (ContactsAvatarSelector* self,
              ContactsCropDialog* dialog,
              GdkTexture* texture)
{
	GdkTexture* _tmp0_;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (texture != NULL);
	_tmp0_ = _g_object_ref0 (texture);
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp0_;
	gtk_widget_activate_action_variant ((GtkWidget*) self, "set-avatar", NULL);
	adw_dialog_close ((AdwDialog*) dialog);
	adw_dialog_close ((AdwDialog*) self);
}

static void
____lambda24__contacts_crop_dialog_cropped (ContactsCropDialog* _sender,
                                            GdkTexture* texture,
                                            gpointer self)
{
	___lambda24_ ((ContactsAvatarSelector*) self, _sender, texture);
}

static gboolean
contacts_avatar_selector_choose_file_co (ContactsAvatarSelectorChooseFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = gtk_file_dialog_new ();
	_data_->file_dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->file_dialog;
	gtk_file_dialog_set_title (_data_->_tmp1_, _ ("Browse for more pictures"));
	_data_->_tmp2_ = _data_->file_dialog;
	gtk_file_dialog_set_accept_label (_data_->_tmp2_, _ ("_Open"));
	_data_->_tmp3_ = _data_->file_dialog;
	gtk_file_dialog_set_modal (_data_->_tmp3_, TRUE);
	_data_->_tmp4_ = g_list_store_new (gtk_file_filter_get_type ());
	_data_->_data9_->filters = _data_->_tmp4_;
	_data_->_tmp5_ = gtk_file_filter_new ();
	_data_->_data9_->any_image_filter = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->_data9_->any_image_filter;
	g_object_set (_data_->_tmp6_, "name", _ ("Image File"), NULL);
	_data_->_tmp7_ = gdk_pixbuf_get_formats ();
	_data_->_tmp8_ = _data_->_tmp7_;
	g_slist_foreach (_data_->_tmp8_, ___lambda23__gfunc, _data_->_data9_);
	(_data_->_tmp8_ == NULL) ? NULL : (_data_->_tmp8_ = (g_slist_free (_data_->_tmp8_), NULL));
	_data_->_tmp9_ = _data_->_data9_->filters;
	_data_->_tmp10_ = _data_->_data9_->any_image_filter;
	g_list_store_append (_data_->_tmp9_, (GObject*) _data_->_tmp10_);
	_data_->_tmp11_ = _data_->file_dialog;
	_data_->_tmp12_ = _data_->_data9_->filters;
	gtk_file_dialog_set_filters (_data_->_tmp11_, (GListModel*) _data_->_tmp12_);
	_data_->_tmp13_ = _data_->file_dialog;
	_data_->_tmp14_ = _data_->_data9_->any_image_filter;
	gtk_file_dialog_set_default_filter (_data_->_tmp13_, _data_->_tmp14_);
	_data_->_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_data_->pictures_folder = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->pictures_folder;
	if (_data_->_tmp16_ != NULL) {
		_data_->_tmp17_ = _data_->file_dialog;
		_data_->_tmp18_ = _data_->pictures_folder;
		_data_->_tmp19_ = g_file_new_for_path (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		gtk_file_dialog_set_initial_folder (_data_->_tmp17_, _data_->_tmp20_);
		_g_object_unref0 (_data_->_tmp20_);
	}
	_data_->_tmp21_ = gtk_widget_get_root ((GtkWidget*) _data_->self);
	_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp21_) : NULL);
	_data_->parent_window = _data_->_tmp22_;
	{
		_data_->_tmp23_ = _data_->file_dialog;
		_data_->_tmp24_ = _data_->parent_window;
		_data_->_state_ = 1;
		gtk_file_dialog_open (_data_->_tmp23_, _data_->_tmp24_, NULL, contacts_avatar_selector_choose_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp25_ = gtk_file_dialog_open_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error0_);
		_data_->file = _data_->_tmp25_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == GTK_DIALOG_ERROR) {
				goto __catch0_gtk_dialog_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp26_ = _data_->file;
		_data_->_state_ = 2;
		g_file_read_async (_data_->_tmp26_, G_PRIORITY_DEFAULT, NULL, contacts_avatar_selector_choose_file_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp27_ = g_file_read_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
		_data_->in_stream = _data_->_tmp27_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			if (_data_->_inner_error0_->domain == GTK_DIALOG_ERROR) {
				goto __catch0_gtk_dialog_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp28_ = _data_->in_stream;
		_data_->_state_ = 3;
		gdk_pixbuf_new_from_stream_async ((GInputStream*) _data_->_tmp28_, NULL, contacts_avatar_selector_choose_file_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp29_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp29_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->in_stream);
			_g_object_unref0 (_data_->file);
			if (_data_->_inner_error0_->domain == GTK_DIALOG_ERROR) {
				goto __catch0_gtk_dialog_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp30_ = _data_->pixbuf;
		_data_->_tmp31_ = gdk_texture_new_for_pixbuf (_data_->_tmp30_);
		_data_->texture = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->in_stream;
		g_input_stream_close ((GInputStream*) _data_->_tmp32_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->texture);
			_g_object_unref0 (_data_->pixbuf);
			_g_object_unref0 (_data_->in_stream);
			_g_object_unref0 (_data_->file);
			if (_data_->_inner_error0_->domain == GTK_DIALOG_ERROR) {
				goto __catch0_gtk_dialog_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp33_ = _data_->texture;
		_data_->_tmp34_ = contacts_crop_dialog_new_for_paintable ((GdkPaintable*) _data_->_tmp33_);
		g_object_ref_sink (_data_->_tmp34_);
		_data_->dialog = _data_->_tmp34_;
		_data_->_tmp35_ = _data_->dialog;
		g_signal_connect_object (_data_->_tmp35_, "cropped", (GCallback) ____lambda24__contacts_crop_dialog_cropped, _data_->self, 0);
		_data_->_tmp36_ = _data_->dialog;
		_data_->_tmp37_ = _data_->parent_window;
		adw_dialog_present ((AdwDialog*) _data_->_tmp36_, (GtkWidget*) _data_->_tmp37_);
		_g_object_unref0 (_data_->dialog);
		_g_object_unref0 (_data_->texture);
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->in_stream);
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_gtk_dialog_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp38_ = _data_->_error_;
		switch (_data_->_tmp38_->code) {
			case GTK_DIALOG_ERROR_CANCELLED:
			case GTK_DIALOG_ERROR_DISMISSED:
			{
				_data_->_tmp39_ = _data_->_error_;
				_data_->_tmp40_ = _data_->_tmp39_->message;
				g_debug ("contacts-avatar-selector.vala:229: Dismissed opening file: %s", _data_->_tmp40_);
				break;
			}
			default:
			case GTK_DIALOG_ERROR_FAILED:
			{
				_data_->_tmp41_ = _data_->_error_;
				_data_->_tmp42_ = _data_->_tmp41_->message;
				g_warning ("contacts-avatar-selector.vala:233: Could not open file: %s", _data_->_tmp42_);
				break;
			}
		}
		_g_error_free0 (_data_->_error_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp43_ = _data_->e;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		g_warning ("contacts-avatar-selector.vala:237: Failed to set avatar: %s", _data_->_tmp44_);
		_data_->_tmp45_ = (AdwAlertDialog*) adw_alert_dialog_new (NULL, _ ("Failed to set avatar."));
		g_object_ref_sink (_data_->_tmp45_);
		_data_->_vala1_dialog = _data_->_tmp45_;
		_data_->_tmp46_ = _data_->_vala1_dialog;
		adw_alert_dialog_add_response (_data_->_tmp46_, "close", _ ("_Close"));
		_data_->_tmp47_ = _data_->_vala1_dialog;
		adw_alert_dialog_set_default_response (_data_->_tmp47_, "close");
		_data_->_tmp48_ = _data_->_vala1_dialog;
		adw_dialog_present ((AdwDialog*) _data_->_tmp48_, (GtkWidget*) _data_->self);
		_g_object_unref0 (_data_->_vala1_dialog);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->parent_window);
		_g_object_unref0 (_data_->file_dialog);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->parent_window);
	_g_object_unref0 (_data_->file_dialog);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsContact*
contacts_avatar_selector_get_contact (ContactsAvatarSelector* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_avatar_selector_set_contact (ContactsAvatarSelector* self,
                                      ContactsContact* value)
{
	ContactsContact* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_avatar_selector_get_contact (self);
	if (old_value != value) {
		self->priv->_contact = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY]);
	}
}

static void
contacts_avatar_selector_class_init (ContactsAvatarSelectorClass * klass,
                                     gpointer klass_data)
{
	contacts_avatar_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAvatarSelector_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_avatar_selector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_avatar_selector_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_selector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-avatar-selector.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnail_grid", FALSE, ContactsAvatarSelector_private_offset + G_STRUCT_OFFSET (ContactsAvatarSelectorPrivate, thumbnail_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "camera_button", FALSE, ContactsAvatarSelector_private_offset + G_STRUCT_OFFSET (ContactsAvatarSelectorPrivate, camera_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_camera_button_clicked", G_CALLBACK(_contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_file_clicked", G_CALLBACK(_contacts_avatar_selector_on_file_clicked_gtk_button_clicked));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "set-avatar", NULL, (GtkWidgetActionActivateFunc) contacts_avatar_selector_on_set_avatar);
}

static void
contacts_avatar_selector_instance_init (ContactsAvatarSelector * self,
                                        gpointer klass)
{
	self->priv = contacts_avatar_selector_get_instance_private (self);
	self->priv->portal = NULL;
	self->priv->selected = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_avatar_selector_finalize (GObject * obj)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	_g_object_unref0 (self->priv->portal);
	_g_object_unref0 (self->priv->selected);
	G_OBJECT_CLASS (contacts_avatar_selector_parent_class)->finalize (obj);
}

/**
 * The AvatarSelector can be used to choose the avatar for a contact.
 * This can be done by either choosing a stock thumbnail, an image file
 * provided by the user, or by using a webcam.
 *
 * After a user has initially chosen an avatar, we provide a cropping tool.
 */
 G_GNUC_NO_INLINE static GType
contacts_avatar_selector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarSelector), 0, (GInstanceInitFunc) contacts_avatar_selector_instance_init, NULL };
	GType contacts_avatar_selector_type_id;
	contacts_avatar_selector_type_id = g_type_register_static (adw_dialog_get_type (), "ContactsAvatarSelector", &g_define_type_info, 0);
	ContactsAvatarSelector_private_offset = g_type_add_instance_private (contacts_avatar_selector_type_id, sizeof (ContactsAvatarSelectorPrivate));
	return contacts_avatar_selector_type_id;
}

GType
contacts_avatar_selector_get_type (void)
{
	static volatile gsize contacts_avatar_selector_type_id__once = 0;
	if (g_once_init_enter (&contacts_avatar_selector_type_id__once)) {
		GType contacts_avatar_selector_type_id;
		contacts_avatar_selector_type_id = contacts_avatar_selector_get_type_once ();
		g_once_init_leave (&contacts_avatar_selector_type_id__once, contacts_avatar_selector_type_id);
	}
	return contacts_avatar_selector_type_id__once;
}

static void
_vala_contacts_avatar_selector_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	switch (property_id) {
		case CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_avatar_selector_get_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_avatar_selector_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	switch (property_id) {
		case CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY:
		contacts_avatar_selector_set_contact (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

