/* math-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
enum  {
	MATH_WINDOW_0_PROPERTY,
	MATH_WINDOW_EQUATION_PROPERTY,
	MATH_WINDOW_DISPLAY_PROPERTY,
	MATH_WINDOW_CONVERTER_PROPERTY,
	MATH_WINDOW_BUTTONS_PROPERTY,
	MATH_WINDOW_NUM_PROPERTIES
};
static GParamSpec* math_window_properties[MATH_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block12Data Block12Data;
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathWindow {
	AdwApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	gulong changed_handler;
	gint forked_row_index;
	gchar* saved_eq;
	HistoryView* history;
	MathDisplay* _display;
	MathConverter* _converter;
	MathButtons* _buttons;
	GtkMenuButton* menu_button;
	GtkButton* undo_button;
	GtkButton* redo_button;
	GtkButton* back_button;
	GtkBox* display_box;
	GtkEventControllerKey* event_controller;
	MathPreferencesDialog* preferences_dialog;
};

struct _Block12Data {
	int _ref_count_;
	MathWindow* self;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _HistoryEntry {
	GtkListBoxRow parent_instance;
	HistoryEntryPrivate * priv;
	GtkLabel* equation_label;
	GtkLabel* answer_label;
	GtkGrid* grid;
};

struct _HistoryEntryClass {
	GtkListBoxRowClass parent_class;
};

static gint MathWindow_private_offset;
static gpointer math_window_parent_class = NULL;

VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType history_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryView, g_object_unref)
VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN GType math_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPreferencesDialog, g_object_unref)
static void math_window_copy_cb (MathWindow* self);
static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_paste_cb (MathWindow* self);
static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_window_undo_cb (MathWindow* self);
static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_redo_cb (MathWindow* self);
static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_mode_cb (MathWindow* self,
                          GSimpleAction* action,
                          GVariant* parameter);
static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_clear_cb (MathWindow* self);
static void _math_window_clear_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_window_back_cb (MathWindow* self);
static void _math_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_show_preferences_cb (MathWindow* self);
static void _math_window_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void _gtk_window_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
VALA_EXTERN MathWindow* math_window_new (GtkApplication* app,
                             MathEquation* equation);
VALA_EXTERN MathWindow* math_window_construct (GType object_type,
                                   GtkApplication* app,
                                   MathEquation* equation);
static void math_window_construct_finish (MathWindow* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN MathEquation* math_window_get_equation (MathWindow* self);
static void __lambda47_ (Block12Data* _data12_);
static void ___lambda47__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean math_window_key_press_cb (MathWindow* self,
                                   GtkEventControllerKey* controller,
                                   guint keyval,
                                   guint keycode,
                                   GdkModifierType state);
static gboolean _math_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                         guint keyval,
                                                                         guint keycode,
                                                                         GdkModifierType state,
                                                                         gpointer self);
VALA_EXTERN void math_window_key_release_cb (MathWindow* self,
                                 GtkEventControllerKey* controller,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state);
static void _math_window_key_release_cb_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state,
                                                                        gpointer self);
VALA_EXTERN MathEquation* math_display_get_equation (MathDisplay* self);
VALA_EXTERN void history_view_set_serializer (HistoryView* self,
                                  Serializer* serializer);
static void _history_view_set_serializer_math_equation_display_changed (MathEquation* _sender,
                                                                 Serializer* serializer,
                                                                 gpointer self);
VALA_EXTERN void math_window_update_history (MathWindow* self,
                                 const gchar* answer,
                                 Number* number,
                                 gint number_base,
                                 guint representation_base);
static void _math_window_update_history_math_equation_history_signal (MathEquation* _sender,
                                                               const gchar* answer,
                                                               Number* number,
                                                               gint number_base,
                                                               guint representation_base,
                                                               gpointer self);
VALA_EXTERN void math_display_insert_text (MathDisplay* self,
                               const gchar* answer);
static void _math_display_insert_text_history_view_answer_clicked (HistoryView* _sender,
                                                            const gchar* ans,
                                                            gpointer self);
VALA_EXTERN void math_display_display_text (MathDisplay* self,
                                const gchar* prev_eq);
static void _math_display_display_text_history_view_equation_clicked (HistoryView* _sender,
                                                               const gchar* equation,
                                                               gpointer self);
static void math_window_eq_changed_cb (MathWindow* self);
static void _math_window_eq_changed_cb_history_view_row_added (HistoryView* _sender,
                                                        gpointer self);
static void math_window_arr_key_pressed_cb (MathWindow* self,
                                     guint keyval);
static void _math_window_arr_key_pressed_cb_math_display_arr_key_pressed (MathDisplay* _sender,
                                                                   guint keyval,
                                                                   gpointer self);
static void _math_window_eq_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                         gpointer self);
static void __lambda48_ (MathWindow* self);
static void ___lambda48__math_buttons_currency_conversion (MathButtons* _sender,
                                                    gpointer self);
static void math_window_mode_changed_cb (MathWindow* self);
static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
VALA_EXTERN void math_display_grab_focus (MathDisplay* self);
VALA_EXTERN void history_view_clear (HistoryView* self);
VALA_EXTERN MathButtons* math_window_get_buttons (MathWindow* self);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
VALA_EXTERN void math_display_set_enable_osk (MathDisplay* self,
                                  gboolean enable_osk);
VALA_EXTERN MathConverter* math_window_get_converter (MathWindow* self);
VALA_EXTERN void math_buttons_set_inverse (MathButtons* self,
                               gboolean value);
VALA_EXTERN void math_converter_paste (MathConverter* self);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
static void math_window_previous_in_history (MathWindow* self);
static void math_window_next_in_history (MathWindow* self);
VALA_EXTERN gint history_view_get_current (HistoryView* self);
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN HistoryEntry* history_view_get_entry_at (HistoryView* self,
                                         gint index);
static void math_window_set_display_text (MathWindow* self,
                                   const gchar* text);
VALA_EXTERN void history_view_insert_entry (HistoryView* self,
                                const gchar* equation,
                                Number* answer,
                                gint number_base,
                                guint representation_base);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_construct (GType object_type,
                                                          MathEquation* eq);
VALA_EXTERN void math_window_set_equation (MathWindow* self,
                               MathEquation* value);
VALA_EXTERN MathDisplay* math_window_get_display (MathWindow* self);
static GObject * math_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _math_window_construct_finish_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void math_window_finalize (GObject * obj);
static GType math_window_get_type_once (void);
static void _vala_math_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_math_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry MATH_WINDOW_window_entries[9] = {{"copy", _math_window_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _math_window_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _math_window_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _math_window_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _math_window_mode_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}, {"clear", _math_window_clear_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"back", _math_window_back_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"preferences", _math_window_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"close", _gtk_window_close_gsimple_action_activate_callback, NULL, NULL, NULL}};

static inline gpointer
math_window_get_instance_private (MathWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MathWindow_private_offset);
}

static void
_math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_copy_cb ((MathWindow*) self);
}

static void
_math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_window_paste_cb ((MathWindow*) self);
}

static void
_math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_undo_cb ((MathWindow*) self);
}

static void
_math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_redo_cb ((MathWindow*) self);
}

static void
_math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_mode_cb ((MathWindow*) self, action, parameter);
}

static void
_math_window_clear_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_window_clear_cb ((MathWindow*) self);
}

static void
_math_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_back_cb ((MathWindow*) self);
}

static void
_math_window_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_window_show_preferences_cb ((MathWindow*) self);
}

static void
_gtk_window_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	gtk_window_close ((GtkWindow*) self);
}

MathWindow*
math_window_construct (GType object_type,
                       GtkApplication* app,
                       MathEquation* equation)
{
	MathWindow * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	g_type_ensure (TYPE_HISTORY_VIEW);
	g_type_ensure (TYPE_MATH_DISPLAY);
	g_type_ensure (TYPE_MATH_CONVERTER);
	g_type_ensure (TYPE_MATH_BUTTONS);
	self = (MathWindow*) g_object_new (object_type, "application", app, "equation", equation, NULL);
	return self;
}

MathWindow*
math_window_new (GtkApplication* app,
                 MathEquation* equation)
{
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		MathWindow* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->redo_action);
		_g_object_unref0 (_data12_->undo_action);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda47_ (Block12Data* _data12_)
{
	MathWindow* self;
	GSimpleAction* _tmp0_;
	MathEquation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GSimpleAction* _tmp4_;
	MathEquation* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = _data12_->self;
	_tmp0_ = _data12_->undo_action;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_has_undo_action (_tmp1_);
	_tmp3_ = _tmp2_;
	g_simple_action_set_enabled (_tmp0_, _tmp3_);
	_tmp4_ = _data12_->redo_action;
	_tmp5_ = self->priv->_equation;
	_tmp6_ = math_equation_get_has_redo_action (_tmp5_);
	_tmp7_ = _tmp6_;
	g_simple_action_set_enabled (_tmp4_, _tmp7_);
}

static void
___lambda47__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda47_ (self);
}

static gboolean
_math_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                guint keyval,
                                                                guint keycode,
                                                                GdkModifierType state,
                                                                gpointer self)
{
	gboolean result;
	result = math_window_key_press_cb ((MathWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_math_window_key_release_cb_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state,
                                                                   gpointer self)
{
	math_window_key_release_cb ((MathWindow*) self, _sender, keyval, keycode, state);
}

static void
_history_view_set_serializer_math_equation_display_changed (MathEquation* _sender,
                                                            Serializer* serializer,
                                                            gpointer self)
{
	history_view_set_serializer ((HistoryView*) self, serializer);
}

static void
_math_window_update_history_math_equation_history_signal (MathEquation* _sender,
                                                          const gchar* answer,
                                                          Number* number,
                                                          gint number_base,
                                                          guint representation_base,
                                                          gpointer self)
{
	math_window_update_history ((MathWindow*) self, answer, number, number_base, representation_base);
}

static void
_math_display_insert_text_history_view_answer_clicked (HistoryView* _sender,
                                                       const gchar* ans,
                                                       gpointer self)
{
	math_display_insert_text ((MathDisplay*) self, ans);
}

static void
_math_display_display_text_history_view_equation_clicked (HistoryView* _sender,
                                                          const gchar* equation,
                                                          gpointer self)
{
	math_display_display_text ((MathDisplay*) self, equation);
}

static void
_math_window_eq_changed_cb_history_view_row_added (HistoryView* _sender,
                                                   gpointer self)
{
	math_window_eq_changed_cb ((MathWindow*) self);
}

static void
_math_window_arr_key_pressed_cb_math_display_arr_key_pressed (MathDisplay* _sender,
                                                              guint keyval,
                                                              gpointer self)
{
	math_window_arr_key_pressed_cb ((MathWindow*) self, keyval);
}

static void
_math_window_eq_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                    gpointer self)
{
	math_window_eq_changed_cb ((MathWindow*) self);
}

static void
__lambda48_ (MathWindow* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
}

static void
___lambda48__math_buttons_currency_conversion (MathButtons* _sender,
                                               gpointer self)
{
	__lambda48_ ((MathWindow*) self);
}

static void
_math_window_mode_changed_cb_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	math_window_mode_changed_cb ((MathWindow*) self);
}

static void
math_window_construct_finish (MathWindow* self)
{
	Block12Data* _data12_;
	MathEquation* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	MathEquation* _tmp11_;
	GSettings* _tmp12_;
	MathEquation* _tmp13_;
	GSettings* _tmp14_;
	MathEquation* _tmp15_;
	GSettings* _tmp16_;
	MathEquation* _tmp17_;
	GSettings* _tmp18_;
	MathEquation* _tmp19_;
	GSettings* _tmp20_;
	MathEquation* _tmp21_;
	GSettings* _tmp22_;
	MathEquation* _tmp23_;
	GtkEventControllerKey* _tmp24_;
	GtkEventControllerKey* _tmp25_;
	GtkEventController* _tmp26_;
	GtkEventControllerKey* _tmp27_;
	GtkEventControllerKey* _tmp28_;
	MathDisplay* _tmp29_;
	MathEquation* _tmp30_;
	MathEquation* _tmp31_;
	HistoryView* _tmp32_;
	MathDisplay* _tmp33_;
	MathEquation* _tmp34_;
	MathEquation* _tmp35_;
	HistoryView* _tmp36_;
	MathDisplay* _tmp37_;
	HistoryView* _tmp38_;
	MathDisplay* _tmp39_;
	HistoryView* _tmp40_;
	HistoryView* _tmp41_;
	MathDisplay* _tmp42_;
	MathEquation* _tmp43_;
	MathEquation* _tmp44_;
	Serializer* _tmp45_;
	Serializer* _tmp46_;
	MathDisplay* _tmp47_;
	MathDisplay* _tmp48_;
	MathEquation* _tmp49_;
	MathEquation* _tmp50_;
	gulong _tmp51_;
	MathButtons* _tmp52_;
	MathButtons* _tmp53_;
	MathDisplay* _tmp54_;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = self->priv->_equation;
	if (_tmp0_ == NULL) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	g_action_map_add_action_entries ((GActionMap*) self, MATH_WINDOW_window_entries, (gint) G_N_ELEMENTS (MATH_WINDOW_window_entries), self);
	_tmp1_ = g_settings_new ("org.gnome.calculator");
	settings = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = g_settings_create_action (_tmp2_, "number-format");
	_tmp4_ = _tmp3_;
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_data12_->undo_action = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_data12_->redo_action = _tmp8_;
	_tmp9_ = _data12_->undo_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_tmp10_ = _data12_->redo_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = self->priv->_equation;
	g_signal_connect_data ((GObject*) _tmp11_, "notify::display", (GCallback) ___lambda47__g_object_notify, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp12_ = settings;
	_tmp13_ = self->priv->_equation;
	g_settings_bind (_tmp12_, "number-format", (GObject*) _tmp13_, "number_format", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = settings;
	_tmp15_ = self->priv->_equation;
	g_settings_bind (_tmp14_, "accuracy", (GObject*) _tmp15_, "accuracy", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = settings;
	_tmp17_ = self->priv->_equation;
	g_settings_bind (_tmp16_, "show-zeroes", (GObject*) _tmp17_, "show_trailing_zeroes", G_SETTINGS_BIND_DEFAULT);
	_tmp18_ = settings;
	_tmp19_ = self->priv->_equation;
	g_settings_bind (_tmp18_, "show-thousands", (GObject*) _tmp19_, "show_thousands_separators", G_SETTINGS_BIND_DEFAULT);
	_tmp20_ = settings;
	_tmp21_ = self->priv->_equation;
	g_settings_bind (_tmp20_, "angle-units", (GObject*) _tmp21_, "angle_units", G_SETTINGS_BIND_DEFAULT);
	_tmp22_ = settings;
	_tmp23_ = self->priv->_equation;
	g_settings_bind (_tmp22_, "word-size", (GObject*) _tmp23_, "word_size", G_SETTINGS_BIND_DEFAULT);
	_tmp24_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->event_controller);
	self->priv->event_controller = _tmp24_;
	_tmp25_ = self->priv->event_controller;
	_tmp26_ = _g_object_ref0 ((GtkEventController*) _tmp25_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL, _tmp26_);
	_tmp27_ = self->priv->event_controller;
	g_signal_connect_object (_tmp27_, "key-pressed", (GCallback) _math_window_key_press_cb_gtk_event_controller_key_key_pressed, self, 0);
	_tmp28_ = self->priv->event_controller;
	g_signal_connect_object (_tmp28_, "key-released", (GCallback) _math_window_key_release_cb_gtk_event_controller_key_key_released, self, 0);
	_tmp29_ = self->priv->_display;
	_tmp30_ = math_display_get_equation (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->history;
	g_signal_connect_object (_tmp31_, "display-changed", (GCallback) _history_view_set_serializer_math_equation_display_changed, _tmp32_, 0);
	_tmp33_ = self->priv->_display;
	_tmp34_ = math_display_get_equation (_tmp33_);
	_tmp35_ = _tmp34_;
	g_signal_connect_object (_tmp35_, "history-signal", (GCallback) _math_window_update_history_math_equation_history_signal, self, 0);
	_tmp36_ = self->priv->history;
	_tmp37_ = self->priv->_display;
	g_signal_connect_object (_tmp36_, "answer-clicked", (GCallback) _math_display_insert_text_history_view_answer_clicked, _tmp37_, 0);
	_tmp38_ = self->priv->history;
	_tmp39_ = self->priv->_display;
	g_signal_connect_object (_tmp38_, "equation-clicked", (GCallback) _math_display_display_text_history_view_equation_clicked, _tmp39_, 0);
	_tmp40_ = self->priv->history;
	g_signal_connect_object (_tmp40_, "row-added", (GCallback) _math_window_eq_changed_cb_history_view_row_added, self, 0);
	_tmp41_ = self->priv->history;
	_tmp42_ = self->priv->_display;
	_tmp43_ = math_display_get_equation (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = math_equation_get_serializer (_tmp44_);
	_tmp46_ = _tmp45_;
	history_view_set_serializer (_tmp41_, _tmp46_);
	_tmp47_ = self->priv->_display;
	g_signal_connect_object (_tmp47_, "arr-key-pressed", (GCallback) _math_window_arr_key_pressed_cb_math_display_arr_key_pressed, self, 0);
	_tmp48_ = self->priv->_display;
	_tmp49_ = math_display_get_equation (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_signal_connect_object ((GtkTextBuffer*) _tmp50_, "changed", (GCallback) _math_window_eq_changed_cb_gtk_text_buffer_changed, self, 0);
	self->priv->changed_handler = _tmp51_;
	_tmp52_ = self->priv->_buttons;
	g_signal_connect_object (_tmp52_, "currency-conversion", (GCallback) ___lambda48__math_buttons_currency_conversion, self, 0);
	_tmp53_ = self->priv->_buttons;
	g_signal_connect_object ((GObject*) _tmp53_, "notify::mode", (GCallback) _math_window_mode_changed_cb_g_object_notify, self, 0);
	math_window_mode_changed_cb (self);
	if (DEVELOPMENT_BUILD) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_tmp54_ = self->priv->_display;
	math_display_grab_focus (_tmp54_);
	_g_object_unref0 (settings);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
math_window_clear_cb (MathWindow* self)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	history_view_clear (_tmp0_);
}

static void
math_window_mode_changed_cb (MathWindow* self)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	MathButtons* _tmp2_;
	MathButtons* _tmp3_;
	ButtonMode _tmp4_;
	ButtonMode _tmp5_;
	MathButtons* _tmp30_;
	ButtonMode _tmp31_;
	ButtonMode _tmp32_;
	MathDisplay* _tmp35_;
	MathButtons* _tmp36_;
	ButtonMode _tmp37_;
	ButtonMode _tmp38_;
	MathButtons* _tmp39_;
	MathButtons* _tmp40_;
	ButtonMode _tmp41_;
	ButtonMode _tmp42_;
	MathConverter* _tmp43_;
	MathConverter* _tmp44_;
	MathButtons* _tmp45_;
	ButtonMode _tmp46_;
	ButtonMode _tmp47_;
	GtkBox* _tmp48_;
	MathButtons* _tmp49_;
	ButtonMode _tmp50_;
	ButtonMode _tmp51_;
	GtkButton* _tmp52_;
	MathButtons* _tmp53_;
	ButtonMode _tmp54_;
	ButtonMode _tmp55_;
	GtkButton* _tmp56_;
	MathButtons* _tmp57_;
	ButtonMode _tmp58_;
	ButtonMode _tmp59_;
	GSimpleAction* copy_action = NULL;
	GAction* _tmp60_;
	GSimpleAction* _tmp61_;
	MathButtons* _tmp62_;
	ButtonMode _tmp63_;
	ButtonMode _tmp64_;
	GSimpleAction* clear_action = NULL;
	GAction* _tmp65_;
	GSimpleAction* _tmp66_;
	MathButtons* _tmp67_;
	ButtonMode _tmp68_;
	ButtonMode _tmp69_;
	GtkButton* _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp1_;
	_tmp2_ = math_window_get_buttons (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_buttons_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkMenuButton* _tmp6_;
			GSimpleAction* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			_tmp6_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp6_, _ ("Basic"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 360, NULL), NULL);
			_tmp7_ = action;
			_tmp8_ = g_variant_new_string ("basic");
			g_variant_ref_sink (_tmp8_);
			_tmp9_ = _tmp8_;
			g_simple_action_set_state (_tmp7_, _tmp9_);
			_g_variant_unref0 (_tmp9_);
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkMenuButton* _tmp10_;
			GSimpleAction* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			_tmp10_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp10_, _ ("Advanced"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 700, NULL), NULL);
			_tmp11_ = action;
			_tmp12_ = g_variant_new_string ("advanced");
			g_variant_ref_sink (_tmp12_);
			_tmp13_ = _tmp12_;
			g_simple_action_set_state (_tmp11_, _tmp13_);
			_g_variant_unref0 (_tmp13_);
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkMenuButton* _tmp14_;
			GSimpleAction* _tmp15_;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			_tmp14_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp14_, _ ("Financial"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 700, NULL), NULL);
			_tmp15_ = action;
			_tmp16_ = g_variant_new_string ("financial");
			g_variant_ref_sink (_tmp16_);
			_tmp17_ = _tmp16_;
			g_simple_action_set_state (_tmp15_, _tmp17_);
			_g_variant_unref0 (_tmp17_);
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkMenuButton* _tmp18_;
			GSimpleAction* _tmp19_;
			GVariant* _tmp20_;
			GVariant* _tmp21_;
			_tmp18_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp18_, _ ("Programming"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 700, NULL), NULL);
			_tmp19_ = action;
			_tmp20_ = g_variant_new_string ("programming");
			g_variant_ref_sink (_tmp20_);
			_tmp21_ = _tmp20_;
			g_simple_action_set_state (_tmp19_, _tmp21_);
			_g_variant_unref0 (_tmp21_);
			break;
		}
		case BUTTON_MODE_KEYBOARD:
		{
			GtkMenuButton* _tmp22_;
			GSimpleAction* _tmp23_;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			_tmp22_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp22_, _ ("Keyboard"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 700, NULL), NULL);
			_tmp23_ = action;
			_tmp24_ = g_variant_new_string ("keyboard");
			g_variant_ref_sink (_tmp24_);
			_tmp25_ = _tmp24_;
			g_simple_action_set_state (_tmp23_, _tmp25_);
			_g_variant_unref0 (_tmp25_);
			break;
		}
		case BUTTON_MODE_CONVERSION:
		{
			GtkMenuButton* _tmp26_;
			GSimpleAction* _tmp27_;
			GVariant* _tmp28_;
			GVariant* _tmp29_;
			_tmp26_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp26_, _ ("Conversion"));
			g_object_set ((GtkWindow*) self, "default-width", (gint) adw_length_unit_to_px (ADW_LENGTH_UNIT_SP, (gdouble) 360, NULL), NULL);
			_tmp27_ = action;
			_tmp28_ = g_variant_new_string ("conversion");
			g_variant_ref_sink (_tmp28_);
			_tmp29_ = _tmp28_;
			g_simple_action_set_state (_tmp27_, _tmp29_);
			_g_variant_unref0 (_tmp29_);
			break;
		}
	}
	_tmp30_ = self->priv->_buttons;
	_tmp31_ = math_buttons_get_mode (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == BUTTON_MODE_PROGRAMMING) {
		GtkBox* _tmp33_;
		_tmp33_ = self->priv->display_box;
		gtk_widget_add_css_class ((GtkWidget*) _tmp33_, "programming");
	} else {
		GtkBox* _tmp34_;
		_tmp34_ = self->priv->display_box;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp34_, "programming");
	}
	_tmp35_ = self->priv->_display;
	_tmp36_ = self->priv->_buttons;
	_tmp37_ = math_buttons_get_mode (_tmp36_);
	_tmp38_ = _tmp37_;
	math_display_set_enable_osk (_tmp35_, _tmp38_ == BUTTON_MODE_KEYBOARD);
	_tmp39_ = self->priv->_buttons;
	_tmp40_ = self->priv->_buttons;
	_tmp41_ = math_buttons_get_mode (_tmp40_);
	_tmp42_ = _tmp41_;
	gtk_widget_set_visible ((GtkWidget*) _tmp39_, _tmp42_ != BUTTON_MODE_KEYBOARD);
	_tmp43_ = math_window_get_converter (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = self->priv->_buttons;
	_tmp46_ = math_buttons_get_mode (_tmp45_);
	_tmp47_ = _tmp46_;
	gtk_widget_set_visible ((GtkWidget*) _tmp44_, _tmp47_ == BUTTON_MODE_CONVERSION);
	_tmp48_ = self->priv->display_box;
	_tmp49_ = self->priv->_buttons;
	_tmp50_ = math_buttons_get_mode (_tmp49_);
	_tmp51_ = _tmp50_;
	gtk_widget_set_visible ((GtkWidget*) _tmp48_, _tmp51_ != BUTTON_MODE_CONVERSION);
	_tmp52_ = self->priv->undo_button;
	_tmp53_ = self->priv->_buttons;
	_tmp54_ = math_buttons_get_mode (_tmp53_);
	_tmp55_ = _tmp54_;
	gtk_widget_set_visible ((GtkWidget*) _tmp52_, _tmp55_ != BUTTON_MODE_CONVERSION);
	_tmp56_ = self->priv->redo_button;
	_tmp57_ = self->priv->_buttons;
	_tmp58_ = math_buttons_get_mode (_tmp57_);
	_tmp59_ = _tmp58_;
	gtk_widget_set_visible ((GtkWidget*) _tmp56_, _tmp59_ != BUTTON_MODE_CONVERSION);
	_tmp60_ = g_action_map_lookup_action ((GActionMap*) self, "copy");
	_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, g_simple_action_get_type (), GSimpleAction));
	copy_action = _tmp61_;
	_tmp62_ = self->priv->_buttons;
	_tmp63_ = math_buttons_get_mode (_tmp62_);
	_tmp64_ = _tmp63_;
	g_simple_action_set_enabled (copy_action, _tmp64_ != BUTTON_MODE_CONVERSION);
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "clear");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, g_simple_action_get_type (), GSimpleAction));
	clear_action = _tmp66_;
	_tmp67_ = self->priv->_buttons;
	_tmp68_ = math_buttons_get_mode (_tmp67_);
	_tmp69_ = _tmp68_;
	g_simple_action_set_enabled (clear_action, _tmp69_ != BUTTON_MODE_CONVERSION);
	_tmp70_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp70_, FALSE);
	_g_object_unref0 (clear_action);
	_g_object_unref0 (copy_action);
	_g_object_unref0 (action);
}

gboolean
math_window_key_press_cb (MathWindow* self,
                          GtkEventControllerKey* controller,
                          guint keyval,
                          guint keycode,
                          GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	MathButtons* _tmp4_;
	MathButtons* _tmp5_;
	ButtonMode _tmp6_;
	ButtonMode _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	if (keyval == GDK_KEY_Shift_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_Shift_R;
	}
	if (_tmp0_) {
		MathButtons* _tmp1_;
		MathButtons* _tmp2_;
		_tmp1_ = math_window_get_buttons (self);
		_tmp2_ = _tmp1_;
		math_buttons_set_inverse (_tmp2_, TRUE);
	}
	_tmp4_ = math_window_get_buttons (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_buttons_get_mode (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == BUTTON_MODE_PROGRAMMING) {
		_tmp3_ = (state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		switch (keyval) {
			case GDK_KEY_b:
			{
				MathEquation* _tmp8_;
				_tmp8_ = self->priv->_equation;
				math_equation_set_number_base (_tmp8_, 2);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp9_;
				_tmp9_ = self->priv->_equation;
				math_equation_set_number_base (_tmp9_, 8);
				result = TRUE;
				return result;
			}
			case GDK_KEY_d:
			{
				MathEquation* _tmp10_;
				_tmp10_ = self->priv->_equation;
				math_equation_set_number_base (_tmp10_, 10);
				result = TRUE;
				return result;
			}
			case GDK_KEY_h:
			{
				MathEquation* _tmp11_;
				_tmp11_ = self->priv->_equation;
				math_equation_set_number_base (_tmp11_, 16);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = FALSE;
	return result;
}

void
math_window_key_release_cb (MathWindow* self,
                            GtkEventControllerKey* controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	if (keyval == GDK_KEY_Shift_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_Shift_R;
	}
	if (_tmp0_) {
		MathButtons* _tmp1_;
		MathButtons* _tmp2_;
		_tmp1_ = math_window_get_buttons (self);
		_tmp2_ = _tmp1_;
		math_buttons_set_inverse (_tmp2_, FALSE);
	}
}

static void
math_window_copy_cb (MathWindow* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_copy (_tmp0_);
}

static void
math_window_paste_cb (MathWindow* self)
{
	MathButtons* _tmp0_;
	MathButtons* _tmp1_;
	ButtonMode _tmp2_;
	ButtonMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_buttons (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_buttons_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != BUTTON_MODE_CONVERSION) {
		MathEquation* _tmp4_;
		_tmp4_ = self->priv->_equation;
		math_equation_paste (_tmp4_);
	} else {
		MathConverter* _tmp5_;
		MathConverter* _tmp6_;
		_tmp5_ = math_window_get_converter (self);
		_tmp6_ = _tmp5_;
		math_converter_paste (_tmp6_);
	}
}

static void
math_window_undo_cb (MathWindow* self)
{
	MathButtons* _tmp0_;
	MathButtons* _tmp1_;
	ButtonMode _tmp2_;
	ButtonMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_buttons (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_buttons_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != BUTTON_MODE_CONVERSION) {
		MathEquation* _tmp4_;
		_tmp4_ = self->priv->_equation;
		math_equation_undo (_tmp4_);
	}
}

static void
math_window_redo_cb (MathWindow* self)
{
	MathButtons* _tmp0_;
	MathButtons* _tmp1_;
	ButtonMode _tmp2_;
	ButtonMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_buttons (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_buttons_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != BUTTON_MODE_CONVERSION) {
		MathEquation* _tmp4_;
		_tmp4_ = self->priv->_equation;
		math_equation_redo (_tmp4_);
	}
}

static void
math_window_mode_cb (MathWindow* self,
                     GSimpleAction* action,
                     GVariant* parameter)
{
	const GVariantType* _tmp0_;
	GtkMenuButton* _tmp1_;
	MathDisplay* _tmp2_;
	ButtonMode mode = 0;
	gchar* mode_str = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	MathButtons* _tmp11_;
	MathButtons* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (parameter != NULL, "parameter != null");
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_vala_return_if_fail (g_variant_is_of_type (parameter, _tmp0_), "parameter.is_of_type (VariantType.STRING)");
	_tmp1_ = self->priv->menu_button;
	gtk_menu_button_popdown (_tmp1_);
	_tmp2_ = self->priv->_display;
	math_display_grab_focus (_tmp2_);
	mode = BUTTON_MODE_BASIC;
	_tmp3_ = g_variant_get_string (parameter, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	mode_str = _tmp4_;
	_tmp5_ = mode_str;
	if (g_strcmp0 (_tmp5_, "basic") == 0) {
		mode = BUTTON_MODE_BASIC;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = mode_str;
		if (g_strcmp0 (_tmp6_, "advanced") == 0) {
			mode = BUTTON_MODE_ADVANCED;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = mode_str;
			if (g_strcmp0 (_tmp7_, "financial") == 0) {
				mode = BUTTON_MODE_FINANCIAL;
			} else {
				const gchar* _tmp8_;
				_tmp8_ = mode_str;
				if (g_strcmp0 (_tmp8_, "programming") == 0) {
					mode = BUTTON_MODE_PROGRAMMING;
				} else {
					const gchar* _tmp9_;
					_tmp9_ = mode_str;
					if (g_strcmp0 (_tmp9_, "keyboard") == 0) {
						mode = BUTTON_MODE_KEYBOARD;
					} else {
						const gchar* _tmp10_;
						_tmp10_ = mode_str;
						if (g_strcmp0 (_tmp10_, "conversion") == 0) {
							mode = BUTTON_MODE_CONVERSION;
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
		}
	}
	_tmp11_ = math_window_get_buttons (self);
	_tmp12_ = _tmp11_;
	math_buttons_set_mode (_tmp12_, mode);
	_g_free0 (mode_str);
}

static void
math_window_arr_key_pressed_cb (MathWindow* self,
                                guint keyval)
{
	g_return_if_fail (self != NULL);
	switch (keyval) {
		case GDK_KEY_Left:
		{
			math_window_previous_in_history (self);
			break;
		}
		case GDK_KEY_Right:
		{
			math_window_next_in_history (self);
			break;
		}
		default:
		break;
	}
}

static void
math_window_eq_changed_cb (MathWindow* self)
{
	HistoryView* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = history_view_get_current (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->forked_row_index = _tmp2_ + 1;
	_g_free0 (self->priv->saved_eq);
	self->priv->saved_eq = NULL;
}

static void
math_window_previous_in_history (MathWindow* self)
{
	HistoryEntry* entry = NULL;
	HistoryView* _tmp0_;
	HistoryEntry* _tmp1_;
	HistoryEntry* _tmp2_;
	gint _tmp16_;
	HistoryEntry* _tmp17_;
	GtkLabel* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = history_view_get_entry_at (_tmp0_, self->priv->forked_row_index - 1);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		MathDisplay* _tmp3_;
		_tmp3_ = self->priv->_display;
		gtk_widget_keynav_failed ((GtkWidget*) _tmp3_, GTK_DIR_UP);
		_g_object_unref0 (entry);
		return;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->saved_eq;
		if (_tmp4_ == NULL) {
			GtkTextIter start = {0};
			GtkTextIter end = {0};
			MathEquation* _tmp5_;
			GtkTextIter _tmp6_ = {0};
			GtkTextIter _tmp7_ = {0};
			gboolean _tmp8_;
			MathEquation* _tmp12_;
			GtkTextIter _tmp13_;
			GtkTextIter _tmp14_;
			gchar* _tmp15_;
			_tmp5_ = self->priv->_equation;
			_tmp8_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp5_, &_tmp6_, &_tmp7_);
			start = _tmp6_;
			end = _tmp7_;
			if (!_tmp8_) {
				MathEquation* _tmp9_;
				GtkTextIter _tmp10_ = {0};
				GtkTextIter _tmp11_ = {0};
				_tmp9_ = self->priv->_equation;
				gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp9_, &_tmp10_, &_tmp11_);
				start = _tmp10_;
				end = _tmp11_;
			}
			_tmp12_ = self->priv->_equation;
			_tmp13_ = start;
			_tmp14_ = end;
			_tmp15_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp12_, &_tmp13_, &_tmp14_, FALSE);
			_g_free0 (self->priv->saved_eq);
			self->priv->saved_eq = _tmp15_;
		}
	}
	_tmp16_ = self->priv->forked_row_index;
	self->priv->forked_row_index = _tmp16_ - 1;
	_tmp17_ = entry;
	_tmp18_ = _tmp17_->equation_label;
	_tmp19_ = gtk_label_get_text (_tmp18_);
	math_window_set_display_text (self, _tmp19_);
	_g_object_unref0 (entry);
}

static void
math_window_next_in_history (MathWindow* self)
{
	HistoryEntry* entry = NULL;
	HistoryView* _tmp0_;
	HistoryEntry* _tmp1_;
	HistoryEntry* _tmp2_;
	HistoryEntry* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = history_view_get_entry_at (_tmp0_, self->priv->forked_row_index + 1);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->saved_eq;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->saved_eq;
			math_window_set_display_text (self, _tmp4_);
			math_window_eq_changed_cb (self);
		} else {
			MathDisplay* _tmp5_;
			_tmp5_ = self->priv->_display;
			gtk_widget_keynav_failed ((GtkWidget*) _tmp5_, GTK_DIR_DOWN);
		}
		_g_object_unref0 (entry);
		return;
	}
	_tmp6_ = entry;
	_tmp7_ = _tmp6_->equation_label;
	_tmp8_ = gtk_label_get_text (_tmp7_);
	math_window_set_display_text (self, _tmp8_);
	_tmp9_ = self->priv->forked_row_index;
	self->priv->forked_row_index = _tmp9_ + 1;
	_g_object_unref0 (entry);
}

static void
math_window_set_display_text (MathWindow* self,
                              const gchar* text)
{
	MathDisplay* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	MathDisplay* _tmp3_;
	MathDisplay* _tmp4_;
	MathEquation* _tmp5_;
	MathEquation* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = math_display_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_handler_block (_tmp2_, self->priv->changed_handler);
	_tmp3_ = self->priv->_display;
	math_display_display_text (_tmp3_, text);
	_tmp4_ = self->priv->_display;
	_tmp5_ = math_display_get_equation (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_handler_unblock (_tmp6_, self->priv->changed_handler);
}

void
math_window_update_history (MathWindow* self,
                            const gchar* answer,
                            Number* number,
                            gint number_base,
                            guint representation_base)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = self->priv->history;
	history_view_insert_entry (_tmp0_, answer, number, number_base, representation_base);
}

static void
math_window_back_cb (MathWindow* self)
{
	MathButtons* _tmp0_;
	MathButtons* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_buttons (self);
	_tmp1_ = _tmp0_;
	math_buttons_set_mode (_tmp1_, BUTTON_MODE_FINANCIAL);
}

static void
math_window_show_preferences_cb (MathWindow* self)
{
	MathPreferencesDialog* _tmp0_;
	MathPreferencesDialog* _tmp3_;
	MathPreferencesDialog* _tmp4_;
	AdwPreferencesPage* _tmp5_;
	MathPreferencesDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		MathEquation* _tmp1_;
		MathPreferencesDialog* _tmp2_;
		_tmp1_ = self->priv->_equation;
		_tmp2_ = math_preferences_dialog_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp2_;
	}
	_tmp3_ = self->priv->preferences_dialog;
	adw_preferences_dialog_pop_subpage ((AdwPreferencesDialog*) _tmp3_);
	_tmp4_ = self->priv->preferences_dialog;
	_tmp5_ = adw_preferences_dialog_get_visible_page ((AdwPreferencesDialog*) _tmp4_);
	adw_preferences_page_scroll_to_top (_tmp5_);
	_tmp6_ = self->priv->preferences_dialog;
	adw_dialog_present ((AdwDialog*) _tmp6_, (GtkWidget*) self);
}

MathEquation*
math_window_get_equation (MathWindow* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

void
math_window_set_equation (MathWindow* self,
                          MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_window_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_window_properties[MATH_WINDOW_EQUATION_PROPERTY]);
	}
}

MathDisplay*
math_window_get_display (MathWindow* self)
{
	MathDisplay* result;
	MathDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

MathConverter*
math_window_get_converter (MathWindow* self)
{
	MathConverter* result;
	MathConverter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_converter;
	result = _tmp0_;
	return result;
}

MathButtons*
math_window_get_buttons (MathWindow* self)
{
	MathButtons* result;
	MathButtons* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}

static void
_math_window_construct_finish_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	math_window_construct_finish ((MathWindow*) self);
}

static GObject *
math_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathWindow * self;
	parent_class = G_OBJECT_CLASS (math_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	g_signal_connect_object ((GObject*) self, "notify::equation", (GCallback) _math_window_construct_finish_g_object_notify, self, 0);
	return obj;
}

static void
math_window_class_init (MathWindowClass * klass,
                        gpointer klass_data)
{
	math_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION_PROPERTY, math_window_properties[MATH_WINDOW_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_DISPLAY_PROPERTY, math_window_properties[MATH_WINDOW_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_CONVERTER_PROPERTY, math_window_properties[MATH_WINDOW_CONVERTER_PROPERTY] = g_param_spec_object ("converter", "converter", "converter", TYPE_MATH_CONVERTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS_PROPERTY, math_window_properties[MATH_WINDOW_BUTTONS_PROPERTY] = g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "history", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, history));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_display", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, _display));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_converter", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, _converter));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_buttons", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, _buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "undo_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, undo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "redo_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, redo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "display_box", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, display_box));
}

static void
math_window_instance_init (MathWindow * self,
                           gpointer klass)
{
	self->priv = math_window_get_instance_private (self);
	self->priv->forked_row_index = 0;
	self->priv->saved_eq = NULL;
	g_type_ensure (TYPE_HISTORY_VIEW);
	g_type_ensure (TYPE_MATH_DISPLAY);
	g_type_ensure (TYPE_MATH_CONVERTER);
	g_type_ensure (TYPE_MATH_BUTTONS);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_window_finalize (GObject * obj)
{
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	_g_object_unref0 (self->priv->_equation);
	_g_free0 (self->priv->saved_eq);
	_g_object_unref0 (self->priv->event_controller);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
}

static GType
math_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
	GType math_window_type_id;
	math_window_type_id = g_type_register_static (adw_application_window_get_type (), "MathWindow", &g_define_type_info, 0);
	MathWindow_private_offset = g_type_add_instance_private (math_window_type_id, sizeof (MathWindowPrivate));
	return math_window_type_id;
}

GType
math_window_get_type (void)
{
	static volatile gsize math_window_type_id__once = 0;
	if (g_once_init_enter (&math_window_type_id__once)) {
		GType math_window_type_id;
		math_window_type_id = math_window_get_type_once ();
		g_once_init_leave (&math_window_type_id__once, math_window_type_id);
	}
	return math_window_type_id__once;
}

static void
_vala_math_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION_PROPERTY:
		g_value_set_object (value, math_window_get_equation (self));
		break;
		case MATH_WINDOW_DISPLAY_PROPERTY:
		g_value_set_object (value, math_window_get_display (self));
		break;
		case MATH_WINDOW_CONVERTER_PROPERTY:
		g_value_set_object (value, math_window_get_converter (self));
		break;
		case MATH_WINDOW_BUTTONS_PROPERTY:
		g_value_set_object (value, math_window_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION_PROPERTY:
		math_window_set_equation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

