/* BreakManagerDBusObject.c generated by valac 0.56.17, the Vala compiler
 * generated from BreakManagerDBusObject.vala, do not modify */

/* BreakManagerDBusObject.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_BREAK_MANAGER_DBUS_OBJECT_0_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_MANAGER_DBUS_OBJECT_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_break_manager_dbus_object_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_DBUS_OBJECT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BreakTimerDaemonBreakManagerDBusObjectPrivate {
	BreakTimerDaemonBreakManager* break_manager;
};

static gint BreakTimerDaemonBreakManagerDBusObject_private_offset;
static gpointer break_timer_daemon_break_manager_dbus_object_parent_class = NULL;
static BreakTimerCommonIBreakTimerIface * break_timer_daemon_break_manager_dbus_object_break_timer_common_ibreak_timer_parent_iface = NULL;

static gchar** break_timer_daemon_break_manager_dbus_object_real_get_current_active_break (BreakTimerCommonIBreakTimer* base,
                                                                                    gint* result_length1,
                                                                                    GError** error);
static gchar** break_timer_daemon_break_manager_dbus_object_real_get_break_ids (BreakTimerCommonIBreakTimer* base,
                                                                         gint* result_length1,
                                                                         GError** error);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** break_timer_daemon_break_manager_dbus_object_real_get_status_messages (BreakTimerCommonIBreakTimer* base,
                                                                               gint* result_length1,
                                                                               GError** error);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void break_timer_daemon_break_manager_dbus_object_real_activate_break (BreakTimerCommonIBreakTimer* base,
                                                                       const gchar* break_name,
                                                                       GError** error);
static void break_timer_daemon_break_manager_dbus_object_finalize (GObject * obj);
static GType break_timer_daemon_break_manager_dbus_object_get_type_once (void);
static void _dbus_break_timer_daemon_break_manager_dbus_object_get_current_active_break (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                                  GVariant* _parameters_,
                                                                                  GDBusMethodInvocation* invocation);
static void _dbus_break_timer_daemon_break_manager_dbus_object_is_active (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_break_timer_daemon_break_manager_dbus_object_get_break_ids (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                       GVariant* _parameters_,
                                                                       GDBusMethodInvocation* invocation);
static void _dbus_break_timer_daemon_break_manager_dbus_object_get_status_messages (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                             GVariant* _parameters_,
                                                                             GDBusMethodInvocation* invocation);
static void _dbus_break_timer_daemon_break_manager_dbus_object_activate_break (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                        GVariant* _parameters_,
                                                                        GDBusMethodInvocation* invocation);
static void break_timer_daemon_break_manager_dbus_object_dbus_interface_method_call (GDBusConnection* connection,
                                                                              const gchar* sender,
                                                                              const gchar* object_path,
                                                                              const gchar* interface_name,
                                                                              const gchar* method_name,
                                                                              GVariant* parameters,
                                                                              GDBusMethodInvocation* invocation,
                                                                              gpointer user_data);
static GVariant* break_timer_daemon_break_manager_dbus_object_dbus_interface_get_property (GDBusConnection* connection,
                                                                                    const gchar* sender,
                                                                                    const gchar* object_path,
                                                                                    const gchar* interface_name,
                                                                                    const gchar* property_name,
                                                                                    GError** error,
                                                                                    gpointer user_data);
static gboolean break_timer_daemon_break_manager_dbus_object_dbus_interface_set_property (GDBusConnection* connection,
                                                                                   const gchar* sender,
                                                                                   const gchar* object_path,
                                                                                   const gchar* interface_name,
                                                                                   const gchar* property_name,
                                                                                   GVariant* value,
                                                                                   GError** error,
                                                                                   gpointer user_data);
static void _break_timer_daemon_break_manager_dbus_object_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_out[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_result, NULL};
static const GDBusMethodInfo _break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_current_active_break = {-1, "GetCurrentActiveBreak", (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_in), (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_current_active_break_out), NULL};
static const GDBusArgInfo _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_out[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_result, NULL};
static const GDBusMethodInfo _break_timer_daemon_break_manager_dbus_object_dbus_method_info_is_active = {-1, "IsActive", (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_in), (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_is_active_out), NULL};
static const GDBusArgInfo _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_out[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_result, NULL};
static const GDBusMethodInfo _break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_break_ids = {-1, "GetBreakIds", (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_in), (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_break_ids_out), NULL};
static const GDBusArgInfo _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_out[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_result, NULL};
static const GDBusMethodInfo _break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_status_messages = {-1, "GetStatusMessages", (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_in), (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_get_status_messages_out), NULL};
static const GDBusArgInfo _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_break_name = {-1, "break_name", "s", NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_in[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_break_name, NULL};
static const GDBusArgInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_out[] = {NULL};
static const GDBusMethodInfo _break_timer_daemon_break_manager_dbus_object_dbus_method_info_activate_break = {-1, "ActivateBreak", (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_in), (GDBusArgInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_arg_info_activate_break_out), NULL};
static const GDBusMethodInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_method_info[] = {&_break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_current_active_break, &_break_timer_daemon_break_manager_dbus_object_dbus_method_info_is_active, &_break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_break_ids, &_break_timer_daemon_break_manager_dbus_object_dbus_method_info_get_status_messages, &_break_timer_daemon_break_manager_dbus_object_dbus_method_info_activate_break, NULL};
static const GDBusSignalInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _break_timer_daemon_break_manager_dbus_object_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _break_timer_daemon_break_manager_dbus_object_dbus_interface_info = {-1, "org.gnome.BreakTimer", (GDBusMethodInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_method_info), (GDBusSignalInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_signal_info), (GDBusPropertyInfo **) (&_break_timer_daemon_break_manager_dbus_object_dbus_property_info), NULL};
static const GDBusInterfaceVTable _break_timer_daemon_break_manager_dbus_object_dbus_interface_vtable = {break_timer_daemon_break_manager_dbus_object_dbus_interface_method_call, break_timer_daemon_break_manager_dbus_object_dbus_interface_get_property, break_timer_daemon_break_manager_dbus_object_dbus_interface_set_property};

static inline gpointer
break_timer_daemon_break_manager_dbus_object_get_instance_private (BreakTimerDaemonBreakManagerDBusObject* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonBreakManagerDBusObject_private_offset);
}

BreakTimerDaemonBreakManagerDBusObject*
break_timer_daemon_break_manager_dbus_object_construct (GType object_type,
                                                        BreakTimerDaemonBreakManager* break_manager)
{
	BreakTimerDaemonBreakManagerDBusObject * self = NULL;
	g_return_val_if_fail (break_manager != NULL, NULL);
	self = (BreakTimerDaemonBreakManagerDBusObject*) g_object_new (object_type, NULL);
	self->priv->break_manager = break_manager;
	return self;
}

BreakTimerDaemonBreakManagerDBusObject*
break_timer_daemon_break_manager_dbus_object_new (BreakTimerDaemonBreakManager* break_manager)
{
	return break_timer_daemon_break_manager_dbus_object_construct (BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER_DBUS_OBJECT, break_manager);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar**
break_timer_daemon_break_manager_dbus_object_real_get_current_active_break (BreakTimerCommonIBreakTimer* base,
                                                                            gint* result_length1,
                                                                            GError** error)
{
	BreakTimerDaemonBreakManagerDBusObject * self;
	BreakTimerDaemonBreakManager* _tmp0_;
	GList* _tmp1_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** result;
	self = (BreakTimerDaemonBreakManagerDBusObject*) base;
	_tmp0_ = self->priv->break_manager;
	_tmp1_ = break_timer_daemon_break_manager_all_breaks (_tmp0_);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp1_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp2_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp2_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				BreakTimerDaemonBreakBreakType* _tmp4_;
				BreakTimerDaemonBreakBreakView* _tmp5_;
				BreakTimerDaemonBreakBreakView* _tmp6_;
				gboolean is_active = FALSE;
				_tmp4_ = break_type;
				_tmp5_ = break_timer_daemon_break_break_type_get_break_view (_tmp4_);
				_tmp6_ = _tmp5_;
				if (break_timer_daemon_ui_fragment_has_ui_focus ((BreakTimerDaemonUIFragment*) _tmp6_)) {
					BreakTimerDaemonBreakBreakType* _tmp7_;
					BreakTimerDaemonBreakBreakController* _tmp8_;
					BreakTimerDaemonBreakBreakController* _tmp9_;
					_tmp7_ = break_type;
					_tmp8_ = break_timer_daemon_break_break_type_get_break_controller (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = break_timer_daemon_break_break_controller_is_active (_tmp9_);
				} else {
					_tmp3_ = FALSE;
				}
				is_active = _tmp3_;
				if (is_active) {
					BreakTimerDaemonBreakBreakType* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar** _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp10_ = break_type;
					_tmp11_ = break_timer_daemon_break_break_type_get_id (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup (_tmp12_);
					_tmp14_ = g_new0 (gchar*, 1 + 1);
					_tmp14_[0] = _tmp13_;
					_tmp15_ = _tmp14_;
					_tmp15__length1 = 1;
					if (result_length1) {
						*result_length1 = _tmp15__length1;
					}
					result = _tmp15_;
					_g_object_unref0 (break_type);
					(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
					return result;
				}
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	return result;
}

gboolean
break_timer_daemon_break_manager_dbus_object_is_active (BreakTimerDaemonBreakManagerDBusObject* self,
                                                        GError** error)
{
	gboolean active = FALSE;
	BreakTimerDaemonBreakManager* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	active = FALSE;
	_tmp0_ = self->priv->break_manager;
	_tmp1_ = break_timer_daemon_break_manager_all_breaks (_tmp0_);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp1_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp2_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp2_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				if (active) {
					_tmp3_ = TRUE;
				} else {
					BreakTimerDaemonBreakBreakType* _tmp4_;
					BreakTimerDaemonBreakBreakController* _tmp5_;
					BreakTimerDaemonBreakBreakController* _tmp6_;
					_tmp4_ = break_type;
					_tmp5_ = break_timer_daemon_break_break_type_get_break_controller (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp3_ = break_timer_daemon_break_break_controller_is_active (_tmp6_);
				}
				active = _tmp3_;
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	result = active;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
break_timer_daemon_break_manager_dbus_object_real_get_break_ids (BreakTimerCommonIBreakTimer* base,
                                                                 gint* result_length1,
                                                                 GError** error)
{
	BreakTimerDaemonBreakManagerDBusObject * self;
	GArray* break_ids = NULL;
	GArray* _tmp0_;
	BreakTimerDaemonBreakManager* _tmp1_;
	GList* _tmp2_;
	GArray* _tmp6_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** result;
	self = (BreakTimerDaemonBreakManagerDBusObject*) base;
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	break_ids = _tmp0_;
	_tmp1_ = self->priv->break_manager;
	_tmp2_ = break_timer_daemon_break_manager_all_break_ids (_tmp1_);
	{
		GList* break_id_collection = NULL;
		GList* break_id_it = NULL;
		break_id_collection = _tmp2_;
		for (break_id_it = break_id_collection; break_id_it != NULL; break_id_it = break_id_it->next) {
			const gchar* break_id = NULL;
			break_id = (const gchar*) break_id_it->data;
			{
				GArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = break_ids;
				_tmp4_ = break_id;
				_tmp5_ = g_strdup (_tmp4_);
				g_array_append_val (_tmp3_, _tmp5_);
			}
		}
		(break_id_collection == NULL) ? NULL : (break_id_collection = (g_list_free (break_id_collection), NULL));
	}
	_tmp6_ = break_ids;
	_tmp7_ = _tmp6_->data;
	_tmp7__length1 = _tmp6_->len;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup1 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_g_array_unref0 (break_ids);
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
break_timer_daemon_break_manager_dbus_object_real_get_status_messages (BreakTimerCommonIBreakTimer* base,
                                                                       gint* result_length1,
                                                                       GError** error)
{
	BreakTimerDaemonBreakManagerDBusObject * self;
	GArray* messages = NULL;
	GArray* _tmp0_;
	BreakTimerDaemonBreakManager* _tmp1_;
	GList* _tmp2_;
	GArray* _tmp14_;
	gpointer* _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** result;
	self = (BreakTimerDaemonBreakManagerDBusObject*) base;
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	messages = _tmp0_;
	_tmp1_ = self->priv->break_manager;
	_tmp2_ = break_timer_daemon_break_manager_all_breaks (_tmp1_);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp2_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp3_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp3_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp3_;
			{
				gchar* status_message = NULL;
				BreakTimerDaemonBreakBreakType* _tmp4_;
				BreakTimerDaemonBreakBreakView* _tmp5_;
				BreakTimerDaemonBreakBreakView* _tmp6_;
				gchar* _tmp7_;
				GArray* _tmp8_;
				BreakTimerDaemonBreakBreakType* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp4_ = break_type;
				_tmp5_ = break_timer_daemon_break_break_type_get_break_view (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = break_timer_daemon_break_break_view_get_status_message (_tmp6_);
				status_message = _tmp7_;
				_tmp8_ = messages;
				_tmp9_ = break_type;
				_tmp10_ = break_timer_daemon_break_break_type_get_id (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = status_message;
				_tmp13_ = g_strdup_printf ("%s:\t%s", _tmp11_, _tmp12_);
				g_array_append_val (_tmp8_, _tmp13_);
				_g_free0 (status_message);
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	_tmp14_ = messages;
	_tmp15_ = _tmp14_->data;
	_tmp15__length1 = _tmp14_->len;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup2 (_tmp15_, _tmp15__length1) : _tmp15_;
	_tmp16__length1 = _tmp15__length1;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_array_unref0 (messages);
	return result;
}

static void
break_timer_daemon_break_manager_dbus_object_real_activate_break (BreakTimerCommonIBreakTimer* base,
                                                                  const gchar* break_name,
                                                                  GError** error)
{
	BreakTimerDaemonBreakManagerDBusObject * self;
	BreakTimerDaemonBreakBreakType* break_type = NULL;
	BreakTimerDaemonBreakManager* _tmp0_;
	BreakTimerDaemonBreakBreakType* _tmp1_;
	BreakTimerDaemonBreakBreakType* _tmp2_;
	self = (BreakTimerDaemonBreakManagerDBusObject*) base;
	g_return_if_fail (break_name != NULL);
	_tmp0_ = self->priv->break_manager;
	_tmp1_ = break_timer_daemon_break_manager_get_break_type_for_name (_tmp0_, break_name);
	break_type = _tmp1_;
	_tmp2_ = break_type;
	if (_tmp2_ != NULL) {
		BreakTimerDaemonBreakBreakType* _tmp3_;
		BreakTimerDaemonBreakBreakController* _tmp4_;
		BreakTimerDaemonBreakBreakController* _tmp5_;
		_tmp3_ = break_type;
		_tmp4_ = break_timer_daemon_break_break_type_get_break_controller (_tmp3_);
		_tmp5_ = _tmp4_;
		break_timer_daemon_break_break_controller_activate (_tmp5_);
	}
	_g_object_unref0 (break_type);
}

static void
break_timer_daemon_break_manager_dbus_object_class_init (BreakTimerDaemonBreakManagerDBusObjectClass * klass,
                                                         gpointer klass_data)
{
	break_timer_daemon_break_manager_dbus_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonBreakManagerDBusObject_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_break_manager_dbus_object_finalize;
}

static void
break_timer_daemon_break_manager_dbus_object_break_timer_common_ibreak_timer_interface_init (BreakTimerCommonIBreakTimerIface * iface,
                                                                                             gpointer iface_data)
{
	break_timer_daemon_break_manager_dbus_object_break_timer_common_ibreak_timer_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_current_active_break = (gchar** (*) (BreakTimerCommonIBreakTimer*, gint*, GError**)) break_timer_daemon_break_manager_dbus_object_real_get_current_active_break;
	iface->get_break_ids = (gchar** (*) (BreakTimerCommonIBreakTimer*, gint*, GError**)) break_timer_daemon_break_manager_dbus_object_real_get_break_ids;
	iface->get_status_messages = (gchar** (*) (BreakTimerCommonIBreakTimer*, gint*, GError**)) break_timer_daemon_break_manager_dbus_object_real_get_status_messages;
	iface->activate_break = (void (*) (BreakTimerCommonIBreakTimer*, const gchar*, GError**)) break_timer_daemon_break_manager_dbus_object_real_activate_break;
}

static void
break_timer_daemon_break_manager_dbus_object_instance_init (BreakTimerDaemonBreakManagerDBusObject * self,
                                                            gpointer klass)
{
	self->priv = break_timer_daemon_break_manager_dbus_object_get_instance_private (self);
}

static void
break_timer_daemon_break_manager_dbus_object_finalize (GObject * obj)
{
	BreakTimerDaemonBreakManagerDBusObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER_DBUS_OBJECT, BreakTimerDaemonBreakManagerDBusObject);
	G_OBJECT_CLASS (break_timer_daemon_break_manager_dbus_object_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_break_manager_dbus_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonBreakManagerDBusObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_break_manager_dbus_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonBreakManagerDBusObject), 0, (GInstanceInitFunc) break_timer_daemon_break_manager_dbus_object_instance_init, NULL };
	static const GInterfaceInfo break_timer_common_ibreak_timer_info = { (GInterfaceInitFunc) break_timer_daemon_break_manager_dbus_object_break_timer_common_ibreak_timer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_break_manager_dbus_object_type_id;
	break_timer_daemon_break_manager_dbus_object_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonBreakManagerDBusObject", &g_define_type_info, 0);
	g_type_add_interface_static (break_timer_daemon_break_manager_dbus_object_type_id, BREAK_TIMER_COMMON_TYPE_IBREAK_TIMER, &break_timer_common_ibreak_timer_info);
	g_type_set_qdata (break_timer_daemon_break_manager_dbus_object_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) break_timer_daemon_break_manager_dbus_object_register_object);
	BreakTimerDaemonBreakManagerDBusObject_private_offset = g_type_add_instance_private (break_timer_daemon_break_manager_dbus_object_type_id, sizeof (BreakTimerDaemonBreakManagerDBusObjectPrivate));
	return break_timer_daemon_break_manager_dbus_object_type_id;
}

GType
break_timer_daemon_break_manager_dbus_object_get_type (void)
{
	static volatile gsize break_timer_daemon_break_manager_dbus_object_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_break_manager_dbus_object_type_id__once)) {
		GType break_timer_daemon_break_manager_dbus_object_type_id;
		break_timer_daemon_break_manager_dbus_object_type_id = break_timer_daemon_break_manager_dbus_object_get_type_once ();
		g_once_init_leave (&break_timer_daemon_break_manager_dbus_object_type_id__once, break_timer_daemon_break_manager_dbus_object_type_id);
	}
	return break_timer_daemon_break_manager_dbus_object_type_id__once;
}

static void
_dbus_break_timer_daemon_break_manager_dbus_object_get_current_active_break (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                             GVariant* _parameters_,
                                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp0_;
	GVariantBuilder _tmp1_;
	gint _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_current_active_break (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp0_ = result;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("as"));
	for (_tmp2_ = 0; _tmp2_ < result_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_string (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp1_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_daemon_break_manager_dbus_object_is_active (BreakTimerDaemonBreakManagerDBusObject* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_daemon_break_manager_dbus_object_is_active (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_daemon_break_manager_dbus_object_get_break_ids (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp3_;
	GVariantBuilder _tmp4_;
	gint _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_break_ids (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp3_ = result;
	g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE ("as"));
	for (_tmp5_ = 0; _tmp5_ < result_length1; _tmp5_++) {
		g_variant_builder_add_value (&_tmp4_, g_variant_new_string (*_tmp3_));
		_tmp3_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp4_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_daemon_break_manager_dbus_object_get_status_messages (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                        GVariant* _parameters_,
                                                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp6_;
	GVariantBuilder _tmp7_;
	gint _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_status_messages (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp6_ = result;
	g_variant_builder_init (&_tmp7_, G_VARIANT_TYPE ("as"));
	for (_tmp8_ = 0; _tmp8_ < result_length1; _tmp8_++) {
		g_variant_builder_add_value (&_tmp7_, g_variant_new_string (*_tmp6_));
		_tmp6_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp7_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_daemon_break_manager_dbus_object_activate_break (BreakTimerDaemonBreakManagerDBusObject* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* break_id = NULL;
	GVariant* _tmp9_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	break_id = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	break_timer_common_ibreak_timer_activate_break (self, break_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (break_id);
	;
}

static void
break_timer_daemon_break_manager_dbus_object_dbus_interface_method_call (GDBusConnection* connection,
                                                                         const gchar* sender,
                                                                         const gchar* object_path,
                                                                         const gchar* interface_name,
                                                                         const gchar* method_name,
                                                                         GVariant* parameters,
                                                                         GDBusMethodInvocation* invocation,
                                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCurrentActiveBreak") == 0) {
		_dbus_break_timer_daemon_break_manager_dbus_object_get_current_active_break (object, parameters, invocation);
	} else if (strcmp (method_name, "IsActive") == 0) {
		_dbus_break_timer_daemon_break_manager_dbus_object_is_active (object, parameters, invocation);
	} else if (strcmp (method_name, "GetBreakIds") == 0) {
		_dbus_break_timer_daemon_break_manager_dbus_object_get_break_ids (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatusMessages") == 0) {
		_dbus_break_timer_daemon_break_manager_dbus_object_get_status_messages (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateBreak") == 0) {
		_dbus_break_timer_daemon_break_manager_dbus_object_activate_break (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
break_timer_daemon_break_manager_dbus_object_dbus_interface_get_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GError** error,
                                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
break_timer_daemon_break_manager_dbus_object_dbus_interface_set_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GVariant* value,
                                                                          GError** error,
                                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
break_timer_daemon_break_manager_dbus_object_register_object (gpointer object,
                                                              GDBusConnection* connection,
                                                              const gchar* path,
                                                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_break_timer_daemon_break_manager_dbus_object_dbus_interface_info), &_break_timer_daemon_break_manager_dbus_object_dbus_interface_vtable, data, _break_timer_daemon_break_manager_dbus_object_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_break_timer_daemon_break_manager_dbus_object_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

