/* gitg-diff-view-file-renderer-image.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view-file-renderer-image.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2016 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include "libgitg.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE (gitg_diff_view_file_renderer_image_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImageClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImageClass))

typedef struct _GitgDiffViewFileRendererImage GitgDiffViewFileRendererImage;
typedef struct _GitgDiffViewFileRendererImageClass GitgDiffViewFileRendererImageClass;
typedef struct _GitgDiffViewFileRendererImagePrivate GitgDiffViewFileRendererImagePrivate;

#define GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE (gitg_diff_image_side_by_side_get_type ())
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySide))
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySideClass))
#define GITG_IS_DIFF_IMAGE_SIDE_BY_SIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE))
#define GITG_IS_DIFF_IMAGE_SIDE_BY_SIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE))
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySideClass))

typedef struct _GitgDiffImageSideBySide GitgDiffImageSideBySide;
typedef struct _GitgDiffImageSideBySideClass GitgDiffImageSideBySideClass;

#define GITG_TYPE_DIFF_IMAGE_COMPOSITE (gitg_diff_image_composite_get_type ())
#define GITG_DIFF_IMAGE_COMPOSITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageComposite))
#define GITG_DIFF_IMAGE_COMPOSITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageCompositeClass))
#define GITG_IS_DIFF_IMAGE_COMPOSITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE))
#define GITG_IS_DIFF_IMAGE_COMPOSITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_COMPOSITE))
#define GITG_DIFF_IMAGE_COMPOSITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageCompositeClass))

typedef struct _GitgDiffImageComposite GitgDiffImageComposite;
typedef struct _GitgDiffImageCompositeClass GitgDiffImageCompositeClass;

#define GITG_TYPE_DIFF_IMAGE_SLIDER (gitg_diff_image_slider_get_type ())
#define GITG_DIFF_IMAGE_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SLIDER, GitgDiffImageSlider))
#define GITG_DIFF_IMAGE_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_SLIDER, GitgDiffImageSliderClass))
#define GITG_IS_DIFF_IMAGE_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SLIDER))
#define GITG_IS_DIFF_IMAGE_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_SLIDER))
#define GITG_DIFF_IMAGE_SLIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_SLIDER, GitgDiffImageSliderClass))

typedef struct _GitgDiffImageSlider GitgDiffImageSlider;
typedef struct _GitgDiffImageSliderClass GitgDiffImageSliderClass;

#define GITG_TYPE_DIFF_IMAGE_OVERLAY (gitg_diff_image_overlay_get_type ())
#define GITG_DIFF_IMAGE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay))
#define GITG_DIFF_IMAGE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlayClass))
#define GITG_IS_DIFF_IMAGE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY))
#define GITG_IS_DIFF_IMAGE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_OVERLAY))
#define GITG_DIFF_IMAGE_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlayClass))

typedef struct _GitgDiffImageOverlay GitgDiffImageOverlay;
typedef struct _GitgDiffImageOverlayClass GitgDiffImageOverlayClass;

#define GITG_TYPE_DIFF_IMAGE_DIFFERENCE (gitg_diff_image_difference_get_type ())
#define GITG_DIFF_IMAGE_DIFFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_DIFFERENCE, GitgDiffImageDifference))
#define GITG_DIFF_IMAGE_DIFFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_DIFFERENCE, GitgDiffImageDifferenceClass))
#define GITG_IS_DIFF_IMAGE_DIFFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_DIFFERENCE))
#define GITG_IS_DIFF_IMAGE_DIFFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_DIFFERENCE))
#define GITG_DIFF_IMAGE_DIFFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_DIFFERENCE, GitgDiffImageDifferenceClass))

typedef struct _GitgDiffImageDifference GitgDiffImageDifference;
typedef struct _GitgDiffImageDifferenceClass GitgDiffImageDifferenceClass;

#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE (gitg_diff_view_file_renderer_image_surface_cache_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCache))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCacheClass))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_IS_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_IS_SURFACE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCacheClass))

typedef struct _GitgDiffViewFileRendererImageSurfaceCache GitgDiffViewFileRendererImageSurfaceCache;
typedef struct _GitgDiffViewFileRendererImageSurfaceCacheClass GitgDiffViewFileRendererImageSurfaceCacheClass;
enum  {
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_0_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_file_renderer_image_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_NUM_PROPERTIES];
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE (gitg_diff_image_surface_cache_get_type ())
#define GITG_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCache))
#define GITG_IS_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE))
#define GITG_DIFF_IMAGE_SURFACE_CACHE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCacheIface))

typedef struct _GitgDiffImageSurfaceCache GitgDiffImageSurfaceCache;
typedef struct _GitgDiffImageSurfaceCacheIface GitgDiffImageSurfaceCacheIface;
typedef struct _GitgDiffViewFileRendererImageSurfaceCachePrivate GitgDiffViewFileRendererImageSurfaceCachePrivate;
enum  {
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_0_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

struct _GitgDiffViewFileRendererImage {
	GtkGrid parent_instance;
	GitgDiffViewFileRendererImagePrivate * priv;
};

struct _GitgDiffViewFileRendererImageClass {
	GtkGridClass parent_class;
};

struct _GitgDiffViewFileRendererImagePrivate {
	GgitDiffDelta* _delta;
	GitgRepository* _repository;
	GitgDiffImageSideBySide* d_diff_image_side_by_side;
	GitgDiffImageSlider* d_diff_image_slider;
	GtkAdjustment* d_scale_slider_adjustment;
	GitgDiffImageOverlay* d_diff_image_overlay;
	GtkAdjustment* d_scale_overlay_adjustment;
	GitgDiffImageDifference* d_diff_image_difference;
	GtkStackSwitcher* d_stack_switcher;
	GitgDiffViewFileRendererImageSurfaceCache* d_cache;
};

struct _GitgDiffImageSurfaceCacheIface {
	GTypeInterface parent_iface;
	cairo_surface_t* (*get_old_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	cairo_surface_t* (*get_new_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	GdkPixbuf* (*get_old_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_old_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkPixbuf* (*get_new_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_new_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkWindow* (*get_window) (GitgDiffImageSurfaceCache* self);
	void (*set_window) (GitgDiffImageSurfaceCache* self, GdkWindow* value);
};

struct _GitgDiffViewFileRendererImageSurfaceCache {
	GObject parent_instance;
	GitgDiffViewFileRendererImageSurfaceCachePrivate * priv;
};

struct _GitgDiffViewFileRendererImageSurfaceCacheClass {
	GObjectClass parent_class;
};

struct _GitgDiffViewFileRendererImageSurfaceCachePrivate {
	cairo_surface_t* d_old_surface;
	cairo_surface_t* d_new_surface;
	GdkPixbuf* _old_pixbuf;
	GdkPixbuf* _new_pixbuf;
	GdkWindow* _window;
};

static gint GitgDiffViewFileRendererImage_private_offset;
static gpointer gitg_diff_view_file_renderer_image_parent_class = NULL;
static gint GitgDiffViewFileRendererImageSurfaceCache_private_offset;
static gpointer gitg_diff_view_file_renderer_image_surface_cache_parent_class = NULL;
static GitgDiffImageSurfaceCacheIface * gitg_diff_view_file_renderer_image_surface_cache_gitg_diff_image_surface_cache_parent_iface = NULL;
static GitgDiffViewFileRendererIface * gitg_diff_view_file_renderer_image_gitg_diff_view_file_renderer_parent_iface = NULL;

VALA_EXTERN GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_view_file_renderer_image_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_side_by_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_composite_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_slider_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_overlay_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_difference_get_type (void) G_GNUC_CONST ;
static GType gitg_diff_view_file_renderer_image_surface_cache_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GitgDiffViewFileRendererImage* gitg_diff_view_file_renderer_image_new (GitgRepository* repository,
                                                                       GgitDiffDelta* delta);
VALA_EXTERN GitgDiffViewFileRendererImage* gitg_diff_view_file_renderer_image_construct (GType object_type,
                                                                             GitgRepository* repository,
                                                                             GgitDiffDelta* delta);
static GdkPixbuf* gitg_diff_view_file_renderer_image_pixbuf_for_file (GitgDiffViewFileRendererImage* self,
                                                               GgitDiffFile* file);
VALA_EXTERN GitgRepository* gitg_diff_view_file_renderer_image_get_repository (GitgDiffViewFileRendererImage* self);
static guint8* _vala_array_dup11 (guint8* self,
                           gssize length);
static void gitg_diff_view_file_renderer_image_real_add_hunk (GitgDiffViewFileRenderer* base,
                                                       GgitDiffHunk* hunk,
                                                       GeeArrayList* lines);
VALA_EXTERN GgitDiffDelta* gitg_diff_view_file_renderer_image_get_delta (GitgDiffViewFileRendererImage* self);
VALA_EXTERN void gitg_diff_view_file_renderer_image_set_delta (GitgDiffViewFileRendererImage* self,
                                                   GgitDiffDelta* value);
VALA_EXTERN void gitg_diff_view_file_renderer_image_set_repository (GitgDiffViewFileRendererImage* self,
                                                        GitgRepository* value);
VALA_EXTERN GType gitg_diff_image_surface_cache_get_type (void) G_GNUC_CONST ;
static GitgDiffViewFileRendererImageSurfaceCache* gitg_diff_view_file_renderer_image_surface_cache_new (GdkPixbuf* old_pixbuf,
                                                                                                 GdkPixbuf* new_pixbuf);
static GitgDiffViewFileRendererImageSurfaceCache* gitg_diff_view_file_renderer_image_surface_cache_construct (GType object_type,
                                                                                                       GdkPixbuf* old_pixbuf,
                                                                                                       GdkPixbuf* new_pixbuf);
static cairo_surface_t* gitg_diff_view_file_renderer_image_surface_cache_real_get_old_surface (GitgDiffImageSurfaceCache* base,
                                                                                        GdkWindow* window);
static cairo_surface_t* gitg_diff_view_file_renderer_image_surface_cache_get_cached_surface (GitgDiffViewFileRendererImageSurfaceCache* self,
                                                                                      GdkWindow* window,
                                                                                      GdkPixbuf* pixbuf,
                                                                                      cairo_surface_t** cached);
VALA_EXTERN GdkPixbuf* gitg_diff_image_surface_cache_get_old_pixbuf (GitgDiffImageSurfaceCache* self);
static cairo_surface_t* gitg_diff_view_file_renderer_image_surface_cache_real_get_new_surface (GitgDiffImageSurfaceCache* base,
                                                                                        GdkWindow* window);
VALA_EXTERN GdkPixbuf* gitg_diff_image_surface_cache_get_new_pixbuf (GitgDiffImageSurfaceCache* self);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_old_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_new_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
VALA_EXTERN void gitg_diff_image_surface_cache_set_old_pixbuf (GitgDiffImageSurfaceCache* self,
                                                   GdkPixbuf* value);
VALA_EXTERN void gitg_diff_image_surface_cache_set_new_pixbuf (GitgDiffImageSurfaceCache* self,
                                                   GdkPixbuf* value);
VALA_EXTERN GdkWindow* gitg_diff_image_surface_cache_get_window (GitgDiffImageSurfaceCache* self);
VALA_EXTERN void gitg_diff_image_surface_cache_set_window (GitgDiffImageSurfaceCache* self,
                                               GdkWindow* value);
static void gitg_diff_view_file_renderer_image_surface_cache_finalize (GObject * obj);
static GType gitg_diff_view_file_renderer_image_surface_cache_get_type_once (void);
static void _vala_gitg_diff_view_file_renderer_image_surface_cache_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec);
static void _vala_gitg_diff_view_file_renderer_image_surface_cache_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec);
static GObject * gitg_diff_view_file_renderer_image_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
VALA_EXTERN void gitg_diff_image_side_by_side_set_cache (GitgDiffImageSideBySide* self,
                                             GitgDiffImageSurfaceCache* value);
VALA_EXTERN void gitg_diff_image_composite_set_cache (GitgDiffImageComposite* self,
                                          GitgDiffImageSurfaceCache* value);
VALA_EXTERN void gitg_diff_view_file_renderer_add_hunk (GitgDiffViewFileRenderer* self,
                                            GgitDiffHunk* hunk,
                                            GeeArrayList* lines);
static void gitg_diff_view_file_renderer_image_finalize (GObject * obj);
static GType gitg_diff_view_file_renderer_image_get_type_once (void);
static void _vala_gitg_diff_view_file_renderer_image_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_gitg_diff_view_file_renderer_image_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
gitg_diff_view_file_renderer_image_get_instance_private (GitgDiffViewFileRendererImage* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewFileRendererImage_private_offset);
}

GitgDiffViewFileRendererImage*
gitg_diff_view_file_renderer_image_construct (GType object_type,
                                              GitgRepository* repository,
                                              GgitDiffDelta* delta)
{
	GitgDiffViewFileRendererImage * self = NULL;
	g_return_val_if_fail (repository != NULL, NULL);
	g_return_val_if_fail (delta != NULL, NULL);
	self = (GitgDiffViewFileRendererImage*) g_object_new (object_type, "repository", repository, "delta", delta, NULL);
	return self;
}

GitgDiffViewFileRendererImage*
gitg_diff_view_file_renderer_image_new (GitgRepository* repository,
                                        GgitDiffDelta* delta)
{
	return gitg_diff_view_file_renderer_image_construct (GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, repository, delta);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static guint8*
_vala_array_dup11 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static GdkPixbuf*
gitg_diff_view_file_renderer_image_pixbuf_for_file (GitgDiffViewFileRendererImage* self,
                                                    GgitDiffFile* file)
{
	gboolean _tmp0_ = FALSE;
	GgitBlob* blob = NULL;
	GMemoryInputStream* stream = NULL;
	GgitBlob* _tmp13_;
	gsize _tmp14_ = 0;
	guint8* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	GMemoryInputStream* _tmp17_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	if ((ggit_diff_file_get_flags (file) & GGIT_DIFF_FLAG_VALID_ID) == 0) {
		_tmp0_ = TRUE;
	} else {
		GgitOId* _tmp1_;
		_tmp1_ = ggit_diff_file_get_oid (file);
		_tmp0_ = ggit_oid_is_zero (_tmp1_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	{
		GgitBlob* _tmp2_ = NULL;
		GitgRepository* _tmp3_;
		GgitOId* _tmp4_;
		gpointer _tmp5_;
		GgitBlob* _tmp6_;
		_tmp3_ = self->priv->_repository;
		_tmp4_ = ggit_diff_file_get_oid (file);
		_tmp5_ = gitg_repository_lookup (_tmp3_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_, &_inner_error0_);
		_tmp2_ = (GgitBlob*) _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (blob);
		blob = _tmp6_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("ERROR: failed to load image blob: ", _tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp7_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (blob);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (blob);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp13_ = blob;
	_tmp15_ = ggit_blob_get_raw_content (_tmp13_, &_tmp14_);
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup11 (_tmp15_, _tmp14_) : _tmp15_;
	_tmp16__length1 = _tmp14_;
	_tmp17_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp16_, _tmp16__length1, NULL);
	stream = _tmp17_;
	{
		GdkPixbuf* _tmp18_ = NULL;
		GMemoryInputStream* _tmp19_;
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_;
		_tmp19_ = stream;
		_tmp20_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp19_, NULL, &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp21_ = _tmp18_;
		_tmp18_ = NULL;
		result = _tmp21_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (stream);
		_g_object_unref0 (blob);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = stderr;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("ERROR: failed to create pixbuf: ", _tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp22_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		_g_object_unref0 (blob);
		return result;
	}
	__finally1:
	_g_object_unref0 (stream);
	_g_object_unref0 (blob);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gitg_diff_view_file_renderer_image_real_add_hunk (GitgDiffViewFileRenderer* base,
                                                  GgitDiffHunk* hunk,
                                                  GeeArrayList* lines)
{
	GitgDiffViewFileRendererImage * self;
	self = (GitgDiffViewFileRendererImage*) base;
	g_return_if_fail (hunk != NULL);
	g_return_if_fail (lines != NULL);
}

GgitDiffDelta*
gitg_diff_view_file_renderer_image_get_delta (GitgDiffViewFileRendererImage* self)
{
	GgitDiffDelta* result;
	GgitDiffDelta* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_delta;
	result = _tmp0_;
	return result;
}

static gpointer
_ggit_diff_delta_ref0 (gpointer self)
{
	return self ? ggit_diff_delta_ref (self) : NULL;
}

void
gitg_diff_view_file_renderer_image_set_delta (GitgDiffViewFileRendererImage* self,
                                              GgitDiffDelta* value)
{
	GgitDiffDelta* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_renderer_image_get_delta (self);
	if (old_value != value) {
		GgitDiffDelta* _tmp0_;
		_tmp0_ = _ggit_diff_delta_ref0 (value);
		_ggit_diff_delta_unref0 (self->priv->_delta);
		self->priv->_delta = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_renderer_image_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY]);
	}
}

GitgRepository*
gitg_diff_view_file_renderer_image_get_repository (GitgDiffViewFileRendererImage* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_repository;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_diff_view_file_renderer_image_set_repository (GitgDiffViewFileRendererImage* self,
                                                   GitgRepository* value)
{
	GitgRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_renderer_image_get_repository (self);
	if (old_value != value) {
		GitgRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_repository);
		self->priv->_repository = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_renderer_image_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY]);
	}
}

static inline gpointer
gitg_diff_view_file_renderer_image_surface_cache_get_instance_private (GitgDiffViewFileRendererImageSurfaceCache* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewFileRendererImageSurfaceCache_private_offset);
}

static GitgDiffViewFileRendererImageSurfaceCache*
gitg_diff_view_file_renderer_image_surface_cache_construct (GType object_type,
                                                            GdkPixbuf* old_pixbuf,
                                                            GdkPixbuf* new_pixbuf)
{
	GitgDiffViewFileRendererImageSurfaceCache * self = NULL;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) g_object_new (object_type, "old-pixbuf", old_pixbuf, "new-pixbuf", new_pixbuf, NULL);
	return self;
}

static GitgDiffViewFileRendererImageSurfaceCache*
gitg_diff_view_file_renderer_image_surface_cache_new (GdkPixbuf* old_pixbuf,
                                                      GdkPixbuf* new_pixbuf)
{
	return gitg_diff_view_file_renderer_image_surface_cache_construct (GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, old_pixbuf, new_pixbuf);
}

static cairo_surface_t*
gitg_diff_view_file_renderer_image_surface_cache_real_get_old_surface (GitgDiffImageSurfaceCache* base,
                                                                       GdkWindow* window)
{
	GitgDiffViewFileRendererImageSurfaceCache * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* result;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = gitg_diff_image_surface_cache_get_old_pixbuf ((GitgDiffImageSurfaceCache*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_diff_view_file_renderer_image_surface_cache_get_cached_surface (self, window, _tmp1_, &self->priv->d_old_surface);
	result = _tmp2_;
	return result;
}

static cairo_surface_t*
gitg_diff_view_file_renderer_image_surface_cache_real_get_new_surface (GitgDiffImageSurfaceCache* base,
                                                                       GdkWindow* window)
{
	GitgDiffViewFileRendererImageSurfaceCache * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* result;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = gitg_diff_image_surface_cache_get_new_pixbuf ((GitgDiffImageSurfaceCache*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_diff_view_file_renderer_image_surface_cache_get_cached_surface (self, window, _tmp1_, &self->priv->d_new_surface);
	result = _tmp2_;
	return result;
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static cairo_surface_t*
gitg_diff_view_file_renderer_image_surface_cache_get_cached_surface (GitgDiffViewFileRendererImageSurfaceCache* self,
                                                                     GdkWindow* window,
                                                                     GdkPixbuf* pixbuf,
                                                                     cairo_surface_t** cached)
{
	cairo_surface_t* _tmp1_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	if (pixbuf == NULL) {
		result = NULL;
		return result;
	}
	if ((*cached) == NULL) {
		cairo_surface_t* _tmp0_;
		_tmp0_ = gdk_cairo_surface_create_from_pixbuf (pixbuf, 0, window);
		_cairo_surface_destroy0 (*cached);
		*cached = _tmp0_;
	}
	_tmp1_ = _cairo_surface_reference0 (*cached);
	result = _tmp1_;
	return result;
}

static GdkPixbuf*
gitg_diff_view_file_renderer_image_surface_cache_real_get_old_pixbuf (GitgDiffImageSurfaceCache* base)
{
	GdkPixbuf* result;
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkPixbuf* _tmp0_;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	_tmp0_ = self->priv->_old_pixbuf;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_file_renderer_image_surface_cache_real_set_old_pixbuf (GitgDiffImageSurfaceCache* base,
                                                                      GdkPixbuf* value)
{
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkPixbuf* old_value;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	old_value = gitg_diff_view_file_renderer_image_surface_cache_real_get_old_pixbuf (base);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_old_pixbuf);
		self->priv->_old_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY]);
	}
}

static GdkPixbuf*
gitg_diff_view_file_renderer_image_surface_cache_real_get_new_pixbuf (GitgDiffImageSurfaceCache* base)
{
	GdkPixbuf* result;
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkPixbuf* _tmp0_;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	_tmp0_ = self->priv->_new_pixbuf;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_file_renderer_image_surface_cache_real_set_new_pixbuf (GitgDiffImageSurfaceCache* base,
                                                                      GdkPixbuf* value)
{
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkPixbuf* old_value;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	old_value = gitg_diff_view_file_renderer_image_surface_cache_real_get_new_pixbuf (base);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_new_pixbuf);
		self->priv->_new_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY]);
	}
}

static GdkWindow*
gitg_diff_view_file_renderer_image_surface_cache_real_get_window (GitgDiffImageSurfaceCache* base)
{
	GdkWindow* result;
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkWindow* _tmp0_;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_file_renderer_image_surface_cache_real_set_window (GitgDiffImageSurfaceCache* base,
                                                                  GdkWindow* value)
{
	GitgDiffViewFileRendererImageSurfaceCache* self;
	GdkWindow* old_value;
	self = (GitgDiffViewFileRendererImageSurfaceCache*) base;
	old_value = gitg_diff_view_file_renderer_image_surface_cache_real_get_window (base);
	if (old_value != value) {
		GdkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY]);
	}
}

static void
gitg_diff_view_file_renderer_image_surface_cache_class_init (GitgDiffViewFileRendererImageSurfaceCacheClass * klass,
                                                             gpointer klass_data)
{
	gitg_diff_view_file_renderer_image_surface_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewFileRendererImageSurfaceCache_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_file_renderer_image_surface_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_file_renderer_image_surface_cache_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_file_renderer_image_surface_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY] = g_param_spec_object ("old-pixbuf", "old-pixbuf", "old-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY] = g_param_spec_object ("new-pixbuf", "new-pixbuf", "new-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY, gitg_diff_view_file_renderer_image_surface_cache_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", gdk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gitg_diff_view_file_renderer_image_surface_cache_gitg_diff_image_surface_cache_interface_init (GitgDiffImageSurfaceCacheIface * iface,
                                                                                               gpointer iface_data)
{
	gitg_diff_view_file_renderer_image_surface_cache_gitg_diff_image_surface_cache_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_old_surface = (cairo_surface_t* (*) (GitgDiffImageSurfaceCache*, GdkWindow*)) gitg_diff_view_file_renderer_image_surface_cache_real_get_old_surface;
	iface->get_new_surface = (cairo_surface_t* (*) (GitgDiffImageSurfaceCache*, GdkWindow*)) gitg_diff_view_file_renderer_image_surface_cache_real_get_new_surface;
	iface->get_old_pixbuf = gitg_diff_view_file_renderer_image_surface_cache_real_get_old_pixbuf;
	iface->set_old_pixbuf = gitg_diff_view_file_renderer_image_surface_cache_real_set_old_pixbuf;
	iface->get_new_pixbuf = gitg_diff_view_file_renderer_image_surface_cache_real_get_new_pixbuf;
	iface->set_new_pixbuf = gitg_diff_view_file_renderer_image_surface_cache_real_set_new_pixbuf;
	iface->get_window = gitg_diff_view_file_renderer_image_surface_cache_real_get_window;
	iface->set_window = gitg_diff_view_file_renderer_image_surface_cache_real_set_window;
}

static void
gitg_diff_view_file_renderer_image_surface_cache_instance_init (GitgDiffViewFileRendererImageSurfaceCache * self,
                                                                gpointer klass)
{
	self->priv = gitg_diff_view_file_renderer_image_surface_cache_get_instance_private (self);
}

static void
gitg_diff_view_file_renderer_image_surface_cache_finalize (GObject * obj)
{
	GitgDiffViewFileRendererImageSurfaceCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCache);
	_cairo_surface_destroy0 (self->priv->d_old_surface);
	_cairo_surface_destroy0 (self->priv->d_new_surface);
	_g_object_unref0 (self->priv->_old_pixbuf);
	_g_object_unref0 (self->priv->_new_pixbuf);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (gitg_diff_view_file_renderer_image_surface_cache_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_file_renderer_image_surface_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewFileRendererImageSurfaceCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_file_renderer_image_surface_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewFileRendererImageSurfaceCache), 0, (GInstanceInitFunc) gitg_diff_view_file_renderer_image_surface_cache_instance_init, NULL };
	static const GInterfaceInfo gitg_diff_image_surface_cache_info = { (GInterfaceInitFunc) gitg_diff_view_file_renderer_image_surface_cache_gitg_diff_image_surface_cache_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_diff_view_file_renderer_image_surface_cache_type_id;
	gitg_diff_view_file_renderer_image_surface_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgDiffViewFileRendererImageSurfaceCache", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_diff_view_file_renderer_image_surface_cache_type_id, GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, &gitg_diff_image_surface_cache_info);
	GitgDiffViewFileRendererImageSurfaceCache_private_offset = g_type_add_instance_private (gitg_diff_view_file_renderer_image_surface_cache_type_id, sizeof (GitgDiffViewFileRendererImageSurfaceCachePrivate));
	return gitg_diff_view_file_renderer_image_surface_cache_type_id;
}

static GType
gitg_diff_view_file_renderer_image_surface_cache_get_type (void)
{
	static gsize gitg_diff_view_file_renderer_image_surface_cache_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_file_renderer_image_surface_cache_type_id__once)) {
		GType gitg_diff_view_file_renderer_image_surface_cache_type_id;
		gitg_diff_view_file_renderer_image_surface_cache_type_id = gitg_diff_view_file_renderer_image_surface_cache_get_type_once ();
		g_once_init_leave (&gitg_diff_view_file_renderer_image_surface_cache_type_id__once, gitg_diff_view_file_renderer_image_surface_cache_type_id);
	}
	return gitg_diff_view_file_renderer_image_surface_cache_type_id__once;
}

static void
_vala_gitg_diff_view_file_renderer_image_surface_cache_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec)
{
	GitgDiffViewFileRendererImageSurfaceCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCache);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY:
		g_value_set_object (value, gitg_diff_image_surface_cache_get_old_pixbuf ((GitgDiffImageSurfaceCache*) self));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY:
		g_value_set_object (value, gitg_diff_image_surface_cache_get_new_pixbuf ((GitgDiffImageSurfaceCache*) self));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY:
		g_value_set_object (value, gitg_diff_image_surface_cache_get_window ((GitgDiffImageSurfaceCache*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_file_renderer_image_surface_cache_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec)
{
	GitgDiffViewFileRendererImageSurfaceCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_TYPE_SURFACE_CACHE, GitgDiffViewFileRendererImageSurfaceCache);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_OLD_PIXBUF_PROPERTY:
		gitg_diff_image_surface_cache_set_old_pixbuf ((GitgDiffImageSurfaceCache*) self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_NEW_PIXBUF_PROPERTY:
		gitg_diff_image_surface_cache_set_new_pixbuf ((GitgDiffImageSurfaceCache*) self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_SURFACE_CACHE_WINDOW_PROPERTY:
		gitg_diff_image_surface_cache_set_window ((GitgDiffImageSurfaceCache*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
gitg_diff_view_file_renderer_image_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffViewFileRendererImage * self;
	GgitDiffDelta* _tmp0_;
	GgitDiffFile* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GgitDiffDelta* _tmp4_;
	GgitDiffFile* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp8_;
	GitgDiffImageSideBySide* _tmp9_;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp10_;
	GitgDiffImageSlider* _tmp11_;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp12_;
	GitgDiffImageOverlay* _tmp13_;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp14_;
	GitgDiffImageDifference* _tmp15_;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GitgDiffViewFileRendererImageSurfaceCache* _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GtkAdjustment* _tmp25_;
	GitgDiffImageSlider* _tmp26_;
	GtkAdjustment* _tmp27_;
	GitgDiffImageOverlay* _tmp28_;
	parent_class = G_OBJECT_CLASS (gitg_diff_view_file_renderer_image_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage);
	_tmp0_ = self->priv->_delta;
	_tmp1_ = ggit_diff_delta_get_old_file (_tmp0_);
	_tmp2_ = gitg_diff_view_file_renderer_image_pixbuf_for_file (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_delta;
	_tmp5_ = ggit_diff_delta_get_new_file (_tmp4_);
	_tmp6_ = gitg_diff_view_file_renderer_image_pixbuf_for_file (self, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gitg_diff_view_file_renderer_image_surface_cache_new (_tmp3_, _tmp7_);
	_g_object_unref0 (self->priv->d_cache);
	self->priv->d_cache = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp3_);
	_tmp9_ = self->priv->d_diff_image_side_by_side;
	_tmp10_ = self->priv->d_cache;
	gitg_diff_image_side_by_side_set_cache (_tmp9_, (GitgDiffImageSurfaceCache*) _tmp10_);
	_tmp11_ = self->priv->d_diff_image_slider;
	_tmp12_ = self->priv->d_cache;
	gitg_diff_image_composite_set_cache ((GitgDiffImageComposite*) _tmp11_, (GitgDiffImageSurfaceCache*) _tmp12_);
	_tmp13_ = self->priv->d_diff_image_overlay;
	_tmp14_ = self->priv->d_cache;
	gitg_diff_image_composite_set_cache ((GitgDiffImageComposite*) _tmp13_, (GitgDiffImageSurfaceCache*) _tmp14_);
	_tmp15_ = self->priv->d_diff_image_difference;
	_tmp16_ = self->priv->d_cache;
	gitg_diff_image_composite_set_cache ((GitgDiffImageComposite*) _tmp15_, (GitgDiffImageSurfaceCache*) _tmp16_);
	_tmp18_ = self->priv->d_cache;
	_tmp19_ = gitg_diff_image_surface_cache_get_old_pixbuf ((GitgDiffImageSurfaceCache*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		GitgDiffViewFileRendererImageSurfaceCache* _tmp21_;
		GdkPixbuf* _tmp22_;
		GdkPixbuf* _tmp23_;
		_tmp21_ = self->priv->d_cache;
		_tmp22_ = gitg_diff_image_surface_cache_get_new_pixbuf ((GitgDiffImageSurfaceCache*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_ == NULL;
	}
	if (_tmp17_) {
		GtkStackSwitcher* _tmp24_;
		_tmp24_ = self->priv->d_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, FALSE);
	}
	_tmp25_ = self->priv->d_scale_slider_adjustment;
	_tmp26_ = self->priv->d_diff_image_slider;
	g_object_bind_property_with_closures ((GObject*) _tmp25_, "value", (GObject*) _tmp26_, "position", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = self->priv->d_scale_overlay_adjustment;
	_tmp28_ = self->priv->d_diff_image_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp27_, "value", (GObject*) _tmp28_, "alpha", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
gitg_diff_view_file_renderer_image_class_init (GitgDiffViewFileRendererImageClass * klass,
                                               gpointer klass_data)
{
	gitg_diff_view_file_renderer_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewFileRendererImage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_file_renderer_image_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_file_renderer_image_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_view_file_renderer_image_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_file_renderer_image_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY, gitg_diff_view_file_renderer_image_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY] = g_param_spec_boxed ("delta", "delta", "delta", ggit_diff_delta_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY, gitg_diff_view_file_renderer_image_properties[GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view-file-renderer-image.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_image_side_by_side", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_diff_image_side_by_side));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_image_slider", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_diff_image_slider));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scale_slider_adjustment", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_scale_slider_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_image_overlay", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_diff_image_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scale_overlay_adjustment", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_scale_overlay_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_image_difference", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_diff_image_difference));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_switcher", FALSE, GitgDiffViewFileRendererImage_private_offset + G_STRUCT_OFFSET (GitgDiffViewFileRendererImagePrivate, d_stack_switcher));
}

static void
gitg_diff_view_file_renderer_image_gitg_diff_view_file_renderer_interface_init (GitgDiffViewFileRendererIface * iface,
                                                                                gpointer iface_data)
{
	gitg_diff_view_file_renderer_image_gitg_diff_view_file_renderer_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_hunk = (void (*) (GitgDiffViewFileRenderer*, GgitDiffHunk*, GeeArrayList*)) gitg_diff_view_file_renderer_image_real_add_hunk;
}

static void
gitg_diff_view_file_renderer_image_instance_init (GitgDiffViewFileRendererImage * self,
                                                  gpointer klass)
{
	self->priv = gitg_diff_view_file_renderer_image_get_instance_private (self);
	g_type_ensure (GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE);
	g_type_ensure (GITG_TYPE_DIFF_IMAGE_SLIDER);
	g_type_ensure (GITG_TYPE_DIFF_IMAGE_OVERLAY);
	g_type_ensure (GITG_TYPE_DIFF_IMAGE_DIFFERENCE);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_diff_view_file_renderer_image_finalize (GObject * obj)
{
	GitgDiffViewFileRendererImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage);
	_ggit_diff_delta_unref0 (self->priv->_delta);
	_g_object_unref0 (self->priv->_repository);
	_g_object_unref0 (self->priv->d_cache);
	G_OBJECT_CLASS (gitg_diff_view_file_renderer_image_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_file_renderer_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewFileRendererImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_file_renderer_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewFileRendererImage), 0, (GInstanceInitFunc) gitg_diff_view_file_renderer_image_instance_init, NULL };
	static const GInterfaceInfo gitg_diff_view_file_renderer_info = { (GInterfaceInitFunc) gitg_diff_view_file_renderer_image_gitg_diff_view_file_renderer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_diff_view_file_renderer_image_type_id;
	gitg_diff_view_file_renderer_image_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffViewFileRendererImage", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_diff_view_file_renderer_image_type_id, GITG_TYPE_DIFF_VIEW_FILE_RENDERER, &gitg_diff_view_file_renderer_info);
	GitgDiffViewFileRendererImage_private_offset = g_type_add_instance_private (gitg_diff_view_file_renderer_image_type_id, sizeof (GitgDiffViewFileRendererImagePrivate));
	return gitg_diff_view_file_renderer_image_type_id;
}

GType
gitg_diff_view_file_renderer_image_get_type (void)
{
	static gsize gitg_diff_view_file_renderer_image_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_file_renderer_image_type_id__once)) {
		GType gitg_diff_view_file_renderer_image_type_id;
		gitg_diff_view_file_renderer_image_type_id = gitg_diff_view_file_renderer_image_get_type_once ();
		g_once_init_leave (&gitg_diff_view_file_renderer_image_type_id__once, gitg_diff_view_file_renderer_image_type_id);
	}
	return gitg_diff_view_file_renderer_image_type_id__once;
}

static void
_vala_gitg_diff_view_file_renderer_image_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GitgDiffViewFileRendererImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY:
		g_value_set_boxed (value, gitg_diff_view_file_renderer_image_get_delta (self));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_diff_view_file_renderer_image_get_repository (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_file_renderer_image_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GitgDiffViewFileRendererImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_DELTA_PROPERTY:
		gitg_diff_view_file_renderer_image_set_delta (self, g_value_get_boxed (value));
		break;
		case GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_REPOSITORY_PROPERTY:
		gitg_diff_view_file_renderer_image_set_repository (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

