// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module VkDecoderSnapshot
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//

#include "VkDecoderSnapshot.h"

#include "VkDecoderGlobalState.h"
#include "VkReconstruction.h"
#include "VulkanHandleMapping.h"
#include "aemu/base/synchronization/Lock.h"

using namespace gfxstream::vk;
using emugl::GfxApiLogger;
using emugl::HealthMonitor;

class VkDecoderSnapshot::Impl {
   public:
    Impl() {}

    void save(android::base::Stream* stream) { mReconstruction.save(stream); }

    void load(android::base::Stream* stream, GfxApiLogger& gfx_logger,
              HealthMonitor<>* healthMonitor) {
        mReconstruction.load(stream, gfx_logger, healthMonitor);
    }

#ifdef VK_VERSION_1_0
    void vkCreateInstance(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result,
                          const VkInstanceCreateInfo* pCreateInfo,
                          const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pInstance create
        mReconstruction.addHandles((const uint64_t*)pInstance, 1);
        if (!pInstance) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateInstance, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pInstance, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pInstance, 1);
    }
    void vkDestroyInstance(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkInstance instance,
                           const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // instance destroy
        mReconstruction.removeHandles((const uint64_t*)(&instance), 1);
    }
    void vkEnumeratePhysicalDevices(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkResult input_result,
                                    VkInstance instance, uint32_t* pPhysicalDeviceCount,
                                    VkPhysicalDevice* pPhysicalDevices) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pPhysicalDevices create
        mReconstruction.addHandles((const uint64_t*)pPhysicalDevices, (*(pPhysicalDeviceCount)));
        mReconstruction.addHandleDependency((const uint64_t*)pPhysicalDevices,
                                            (*(pPhysicalDeviceCount)),
                                            (uint64_t)(uintptr_t)instance);
        if (!pPhysicalDevices) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkEnumeratePhysicalDevices, snapshotTraceBegin,
                                    snapshotTraceBytes);
        if (pPhysicalDeviceCount) {
            mReconstruction.forEachHandleAddApi((const uint64_t*)pPhysicalDevices,
                                                (*(pPhysicalDeviceCount)), apiHandle);
            mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pPhysicalDevices,
                                                    (*(pPhysicalDeviceCount)));
        }
    }
    void vkGetPhysicalDeviceFeatures(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkPhysicalDevice physicalDevice,
                                     VkPhysicalDeviceFeatures* pFeatures) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceFormatProperties(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkPhysicalDevice physicalDevice, VkFormat format,
                                             VkFormatProperties* pFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceImageFormatProperties(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type,
        VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags,
        VkImageFormatProperties* pImageFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceProperties(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool,
                                       VkPhysicalDevice physicalDevice,
                                       VkPhysicalDeviceProperties* pProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceQueueFamilyProperties(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkPhysicalDevice physicalDevice,
                                                  uint32_t* pQueueFamilyPropertyCount,
                                                  VkQueueFamilyProperties* pQueueFamilyProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceMemoryProperties(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkPhysicalDevice physicalDevice,
                                             VkPhysicalDeviceMemoryProperties* pMemoryProperties) {
        // TODO: Implement
    }
    void vkGetInstanceProcAddr(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, PFN_vkVoidFunction input_result,
                               VkInstance instance, const char* pName) {
        // TODO: Implement
    }
    void vkGetDeviceProcAddr(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, PFN_vkVoidFunction input_result,
                             VkDevice device, const char* pName) {
        // TODO: Implement
    }
    void vkCreateDevice(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkResult input_result,
                        VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo,
                        const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDevice create
        mReconstruction.addHandles((const uint64_t*)pDevice, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pDevice, 1,
                                            (uint64_t)(uintptr_t)physicalDevice);
        if (!pDevice) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateDevice, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pDevice, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pDevice, 1);
    }
    void vkDestroyDevice(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkDevice device,
                         const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // device destroy
        mReconstruction.removeHandles((const uint64_t*)(&device), 1);
    }
    void vkEnumerateInstanceExtensionProperties(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool,
                                                VkResult input_result, const char* pLayerName,
                                                uint32_t* pPropertyCount,
                                                VkExtensionProperties* pProperties) {
        // TODO: Implement
    }
    void vkEnumerateDeviceExtensionProperties(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkPhysicalDevice physicalDevice,
                                              const char* pLayerName, uint32_t* pPropertyCount,
                                              VkExtensionProperties* pProperties) {
        // TODO: Implement
    }
    void vkEnumerateInstanceLayerProperties(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkResult input_result,
                                            uint32_t* pPropertyCount,
                                            VkLayerProperties* pProperties) {
        // TODO: Implement
    }
    void vkEnumerateDeviceLayerProperties(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkPhysicalDevice physicalDevice,
                                          uint32_t* pPropertyCount,
                                          VkLayerProperties* pProperties) {
        // TODO: Implement
    }
    void vkGetDeviceQueue(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkDevice device, uint32_t queueFamilyIndex,
                          uint32_t queueIndex, VkQueue* pQueue) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pQueue create
        mReconstruction.addHandles((const uint64_t*)pQueue, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pQueue, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pQueue) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkGetDeviceQueue, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pQueue, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pQueue, 1);
    }
    void vkQueueSubmit(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkResult input_result, VkQueue queue,
                       uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) {
        // TODO: Implement
    }
    void vkQueueWaitIdle(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkResult input_result, VkQueue queue) {
        // TODO: Implement
    }
    void vkDeviceWaitIdle(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device) {
        // TODO: Implement
    }
    void vkAllocateMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                          const VkMemoryAllocateInfo* pAllocateInfo,
                          const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pMemory create
        mReconstruction.addHandles((const uint64_t*)pMemory, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pMemory, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pMemory) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkAllocateMemory, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pMemory, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pMemory, 1);
    }
    void vkFreeMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                      android::base::BumpPool* pool, VkDevice device, VkDeviceMemory memory,
                      const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // memory destroy
        mReconstruction.removeHandles((const uint64_t*)(&memory), 1);
    }
    void vkMapMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                     android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                     VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size,
                     VkMemoryMapFlags flags, void** ppData) {
        // TODO: Implement
    }
    void vkUnmapMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkDevice device, VkDeviceMemory memory) {
        // TODO: Implement
    }
    void vkFlushMappedMemoryRanges(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkResult input_result,
                                   VkDevice device, uint32_t memoryRangeCount,
                                   const VkMappedMemoryRange* pMemoryRanges) {
        // TODO: Implement
    }
    void vkInvalidateMappedMemoryRanges(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device,
                                        uint32_t memoryRangeCount,
                                        const VkMappedMemoryRange* pMemoryRanges) {
        // TODO: Implement
    }
    void vkGetDeviceMemoryCommitment(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkDevice device,
                                     VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) {
        // TODO: Implement
    }
    void vkBindBufferMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
        // TODO: Implement
    }
    void vkBindImageMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                           VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
        // TODO: Implement
    }
    void vkGetBufferMemoryRequirements(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetImageMemoryRequirements(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkDevice device, VkImage image,
                                      VkMemoryRequirements* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetImageSparseMemoryRequirements(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements* pSparseMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceSparseImageFormatProperties(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type,
        VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling,
        uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) {
        // TODO: Implement
    }
    void vkQueueBindSparse(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkQueue queue,
                           uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                           VkFence fence) {
        // TODO: Implement
    }
    void vkCreateFence(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                       const VkFenceCreateInfo* pCreateInfo,
                       const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pFence create
        mReconstruction.addHandles((const uint64_t*)pFence, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pFence, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pFence) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateFence, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pFence, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pFence, 1);
    }
    void vkDestroyFence(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkDevice device, VkFence fence,
                        const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // fence destroy
        mReconstruction.removeHandles((const uint64_t*)(&fence), 1);
    }
    void vkResetFences(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                       uint32_t fenceCount, const VkFence* pFences) {
        // TODO: Implement
    }
    void vkGetFenceStatus(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                          VkFence fence) {
        // TODO: Implement
    }
    void vkWaitForFences(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                         uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll,
                         uint64_t timeout) {
        // TODO: Implement
    }
    void vkCreateSemaphore(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                           const VkSemaphoreCreateInfo* pCreateInfo,
                           const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pSemaphore create
        mReconstruction.addHandles((const uint64_t*)pSemaphore, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pSemaphore, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pSemaphore) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateSemaphore, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pSemaphore, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pSemaphore, 1);
    }
    void vkDestroySemaphore(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkDevice device, VkSemaphore semaphore,
                            const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // semaphore destroy
        mReconstruction.removeHandles((const uint64_t*)(&semaphore), 1);
    }
    void vkCreateEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                       const VkEventCreateInfo* pCreateInfo,
                       const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pEvent create
        mReconstruction.addHandles((const uint64_t*)pEvent, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pEvent, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pEvent) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateEvent, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pEvent, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pEvent, 1);
    }
    void vkDestroyEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkDevice device, VkEvent event,
                        const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // event destroy
        mReconstruction.removeHandles((const uint64_t*)(&event), 1);
    }
    void vkGetEventStatus(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                          VkEvent event) {
        // TODO: Implement
    }
    void vkSetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                    android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                    VkEvent event) {
        // TODO: Implement
    }
    void vkResetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                      android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                      VkEvent event) {
        // TODO: Implement
    }
    void vkCreateQueryPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                           const VkQueryPoolCreateInfo* pCreateInfo,
                           const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pQueryPool create
        mReconstruction.addHandles((const uint64_t*)pQueryPool, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pQueryPool, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pQueryPool) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateQueryPool, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pQueryPool, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pQueryPool, 1);
    }
    void vkDestroyQueryPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkDevice device, VkQueryPool queryPool,
                            const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // queryPool destroy
        mReconstruction.removeHandles((const uint64_t*)(&queryPool), 1);
    }
    void vkGetQueryPoolResults(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, VkQueryPool queryPool, uint32_t firstQuery,
                               uint32_t queryCount, size_t dataSize, void* pData,
                               VkDeviceSize stride, VkQueryResultFlags flags) {
        // TODO: Implement
    }
    void vkCreateBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                        const VkBufferCreateInfo* pCreateInfo,
                        const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pBuffer create
        mReconstruction.addHandles((const uint64_t*)pBuffer, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pBuffer, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pBuffer) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateBuffer, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pBuffer, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pBuffer, 1);
    }
    void vkDestroyBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkDevice device, VkBuffer buffer,
                         const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // buffer destroy
        mReconstruction.removeHandles((const uint64_t*)(&buffer), 1);
    }
    void vkCreateBufferView(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            const VkBufferViewCreateInfo* pCreateInfo,
                            const VkAllocationCallbacks* pAllocator, VkBufferView* pView) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pView create
        mReconstruction.addHandles((const uint64_t*)pView, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pView, 1, (uint64_t)(uintptr_t)device);
        if (!pView) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateBufferView, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pView, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pView, 1);
    }
    void vkDestroyBufferView(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkDevice device,
                             VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // bufferView destroy
        mReconstruction.removeHandles((const uint64_t*)(&bufferView), 1);
    }
    void vkCreateImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                       const VkImageCreateInfo* pCreateInfo,
                       const VkAllocationCallbacks* pAllocator, VkImage* pImage) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pImage create
        mReconstruction.addHandles((const uint64_t*)pImage, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pImage, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pImage) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateImage, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pImage, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pImage, 1);
    }
    void vkDestroyImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkDevice device, VkImage image,
                        const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // image destroy
        mReconstruction.removeHandles((const uint64_t*)(&image), 1);
    }
    void vkGetImageSubresourceLayout(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkDevice device, VkImage image,
                                     const VkImageSubresource* pSubresource,
                                     VkSubresourceLayout* pLayout) {
        // TODO: Implement
    }
    void vkCreateImageView(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                           const VkImageViewCreateInfo* pCreateInfo,
                           const VkAllocationCallbacks* pAllocator, VkImageView* pView) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pView create
        mReconstruction.addHandles((const uint64_t*)pView, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pView, 1, (uint64_t)(uintptr_t)device);
        if (!pView) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateImageView, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pView, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pView, 1);
    }
    void vkDestroyImageView(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkDevice device, VkImageView imageView,
                            const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // imageView destroy
        mReconstruction.removeHandles((const uint64_t*)(&imageView), 1);
    }
    void vkCreateShaderModule(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                              const VkShaderModuleCreateInfo* pCreateInfo,
                              const VkAllocationCallbacks* pAllocator,
                              VkShaderModule* pShaderModule) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pShaderModule create
        mReconstruction.addHandles((const uint64_t*)pShaderModule, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pShaderModule, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pShaderModule) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateShaderModule, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pShaderModule, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pShaderModule, 1);
    }
    void vkDestroyShaderModule(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkDevice device,
                               VkShaderModule shaderModule,
                               const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // shaderModule destroy
        mReconstruction.removeHandles((const uint64_t*)(&shaderModule), 1);
    }
    void vkCreatePipelineCache(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo,
                               const VkAllocationCallbacks* pAllocator,
                               VkPipelineCache* pPipelineCache) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pPipelineCache create
        mReconstruction.addHandles((const uint64_t*)pPipelineCache, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pPipelineCache, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pPipelineCache) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreatePipelineCache, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pPipelineCache, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pPipelineCache, 1);
    }
    void vkDestroyPipelineCache(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkDevice device,
                                VkPipelineCache pipelineCache,
                                const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pipelineCache destroy
        mReconstruction.removeHandles((const uint64_t*)(&pipelineCache), 1);
    }
    void vkGetPipelineCacheData(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize,
                                void* pData) {
        // TODO: Implement
    }
    void vkMergePipelineCaches(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount,
                               const VkPipelineCache* pSrcCaches) {
        // TODO: Implement
    }
    void vkCreateGraphicsPipelines(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkResult input_result,
                                   VkDevice device, VkPipelineCache pipelineCache,
                                   uint32_t createInfoCount,
                                   const VkGraphicsPipelineCreateInfo* pCreateInfos,
                                   const VkAllocationCallbacks* pAllocator,
                                   VkPipeline* pPipelines) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pPipelines create
        mReconstruction.addHandles((const uint64_t*)pPipelines, ((createInfoCount)));
        mReconstruction.addHandleDependency((const uint64_t*)pPipelines, ((createInfoCount)),
                                            (uint64_t)(uintptr_t)device);
        if (!pPipelines) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateGraphicsPipelines, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pPipelines, ((createInfoCount)),
                                            apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pPipelines,
                                                ((createInfoCount)));
    }
    void vkCreateComputePipelines(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkResult input_result,
                                  VkDevice device, VkPipelineCache pipelineCache,
                                  uint32_t createInfoCount,
                                  const VkComputePipelineCreateInfo* pCreateInfos,
                                  const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pPipelines create
        mReconstruction.addHandles((const uint64_t*)pPipelines, ((createInfoCount)));
        mReconstruction.addHandleDependency((const uint64_t*)pPipelines, ((createInfoCount)),
                                            (uint64_t)(uintptr_t)device);
        if (!pPipelines) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateComputePipelines, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pPipelines, ((createInfoCount)),
                                            apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pPipelines,
                                                ((createInfoCount)));
    }
    void vkDestroyPipeline(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkDevice device, VkPipeline pipeline,
                           const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pipeline destroy
        mReconstruction.removeHandles((const uint64_t*)(&pipeline), 1);
    }
    void vkCreatePipelineLayout(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo,
                                const VkAllocationCallbacks* pAllocator,
                                VkPipelineLayout* pPipelineLayout) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pPipelineLayout create
        mReconstruction.addHandles((const uint64_t*)pPipelineLayout, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pPipelineLayout, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pPipelineLayout) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreatePipelineLayout, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pPipelineLayout, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pPipelineLayout, 1);
    }
    void vkDestroyPipelineLayout(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkDevice device,
                                 VkPipelineLayout pipelineLayout,
                                 const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pipelineLayout destroy
        mReconstruction.removeHandles((const uint64_t*)(&pipelineLayout), 1);
    }
    void vkCreateSampler(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                         const VkSamplerCreateInfo* pCreateInfo,
                         const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pSampler create
        mReconstruction.addHandles((const uint64_t*)pSampler, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pSampler, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pSampler) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateSampler, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pSampler, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pSampler, 1);
    }
    void vkDestroySampler(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkDevice device, VkSampler sampler,
                          const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // sampler destroy
        mReconstruction.removeHandles((const uint64_t*)(&sampler), 1);
    }
    void vkCreateDescriptorSetLayout(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkResult input_result,
                                     VkDevice device,
                                     const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                     const VkAllocationCallbacks* pAllocator,
                                     VkDescriptorSetLayout* pSetLayout) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pSetLayout create
        mReconstruction.addHandles((const uint64_t*)pSetLayout, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pSetLayout, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pSetLayout) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateDescriptorSetLayout, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pSetLayout, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pSetLayout, 1);
    }
    void vkDestroyDescriptorSetLayout(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkDevice device,
                                      VkDescriptorSetLayout descriptorSetLayout,
                                      const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // descriptorSetLayout destroy
        mReconstruction.removeHandles((const uint64_t*)(&descriptorSetLayout), 1);
    }
    void vkCreateDescriptorPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo,
                                const VkAllocationCallbacks* pAllocator,
                                VkDescriptorPool* pDescriptorPool) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDescriptorPool create
        mReconstruction.addHandles((const uint64_t*)pDescriptorPool, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pDescriptorPool, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pDescriptorPool) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateDescriptorPool, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pDescriptorPool, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pDescriptorPool, 1);
    }
    void vkDestroyDescriptorPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkDevice device,
                                 VkDescriptorPool descriptorPool,
                                 const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // descriptorPool destroy
        mReconstruction.removeHandles((const uint64_t*)(&descriptorPool), 1);
    }
    void vkResetDescriptorPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, VkDescriptorPool descriptorPool,
                               VkDescriptorPoolResetFlags flags) {
        // TODO: Implement
    }
    void vkAllocateDescriptorSets(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkResult input_result,
                                  VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo,
                                  VkDescriptorSet* pDescriptorSets) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDescriptorSets create
        mReconstruction.addHandles((const uint64_t*)pDescriptorSets,
                                   pAllocateInfo->descriptorSetCount);
        mReconstruction.addHandleDependency((const uint64_t*)pDescriptorSets,
                                            pAllocateInfo->descriptorSetCount,
                                            (uint64_t)(uintptr_t)device);
        if (!pDescriptorSets) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkAllocateDescriptorSets, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pDescriptorSets,
                                            pAllocateInfo->descriptorSetCount, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pDescriptorSets,
                                                pAllocateInfo->descriptorSetCount);
    }
    void vkFreeDescriptorSets(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                              VkDescriptorPool descriptorPool, uint32_t descriptorSetCount,
                              const VkDescriptorSet* pDescriptorSets) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDescriptorSets destroy
        mReconstruction.removeHandles((const uint64_t*)pDescriptorSets, ((descriptorSetCount)));
    }
    void vkUpdateDescriptorSets(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkDevice device,
                                uint32_t descriptorWriteCount,
                                const VkWriteDescriptorSet* pDescriptorWrites,
                                uint32_t descriptorCopyCount,
                                const VkCopyDescriptorSet* pDescriptorCopies) {
        // TODO: Implement
    }
    void vkCreateFramebuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             const VkFramebufferCreateInfo* pCreateInfo,
                             const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pFramebuffer create
        mReconstruction.addHandles((const uint64_t*)pFramebuffer, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pFramebuffer, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pFramebuffer) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateFramebuffer, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pFramebuffer, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pFramebuffer, 1);
    }
    void vkDestroyFramebuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkDevice device,
                              VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // framebuffer destroy
        mReconstruction.removeHandles((const uint64_t*)(&framebuffer), 1);
    }
    void vkCreateRenderPass(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            const VkRenderPassCreateInfo* pCreateInfo,
                            const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pRenderPass create
        mReconstruction.addHandles((const uint64_t*)pRenderPass, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pRenderPass, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pRenderPass) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateRenderPass, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pRenderPass, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pRenderPass, 1);
    }
    void vkDestroyRenderPass(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkDevice device,
                             VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // renderPass destroy
        mReconstruction.removeHandles((const uint64_t*)(&renderPass), 1);
    }
    void vkGetRenderAreaGranularity(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkDevice device,
                                    VkRenderPass renderPass, VkExtent2D* pGranularity) {
        // TODO: Implement
    }
    void vkCreateCommandPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             const VkCommandPoolCreateInfo* pCreateInfo,
                             const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pCommandPool create
        mReconstruction.addHandles((const uint64_t*)pCommandPool, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pCommandPool, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pCommandPool) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateCommandPool, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pCommandPool, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pCommandPool, 1);
    }
    void vkDestroyCommandPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkDevice device,
                              VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // commandPool destroy
        mReconstruction.removeHandles((const uint64_t*)(&commandPool), 1);
    }
    void vkResetCommandPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            VkCommandPool commandPool, VkCommandPoolResetFlags flags) {
        // TODO: Implement
    }
    void vkAllocateCommandBuffers(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkResult input_result,
                                  VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo,
                                  VkCommandBuffer* pCommandBuffers) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pCommandBuffers create
        mReconstruction.addHandles((const uint64_t*)pCommandBuffers,
                                   pAllocateInfo->commandBufferCount);
        mReconstruction.addHandleDependency(
            (const uint64_t*)pCommandBuffers, pAllocateInfo->commandBufferCount,
            (uint64_t)(uintptr_t)unboxed_to_boxed_non_dispatchable_VkCommandPool(
                pAllocateInfo->commandPool));
        if (!pCommandBuffers) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkAllocateCommandBuffers, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pCommandBuffers,
                                            pAllocateInfo->commandBufferCount, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pCommandBuffers,
                                                pAllocateInfo->commandBufferCount);
    }
    void vkFreeCommandBuffers(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkDevice device,
                              VkCommandPool commandPool, uint32_t commandBufferCount,
                              const VkCommandBuffer* pCommandBuffers) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pCommandBuffers destroy
        mReconstruction.removeHandles((const uint64_t*)pCommandBuffers, ((commandBufferCount)));
    }
    void vkBeginCommandBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkResult input_result,
                              VkCommandBuffer commandBuffer,
                              const VkCommandBufferBeginInfo* pBeginInfo) {
        // TODO: Implement
    }
    void vkEndCommandBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result,
                            VkCommandBuffer commandBuffer) {
        // TODO: Implement
    }
    void vkResetCommandBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkResult input_result,
                              VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) {
        // TODO: Implement
    }
    void vkCmdBindPipeline(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) {
        // TODO: Implement
    }
    void vkCmdSetViewport(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          uint32_t firstViewport, uint32_t viewportCount,
                          const VkViewport* pViewports) {
        // TODO: Implement
    }
    void vkCmdSetScissor(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) {
        // TODO: Implement
    }
    void vkCmdSetLineWidth(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           float lineWidth) {
        // TODO: Implement
    }
    void vkCmdSetDepthBias(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           float depthBiasConstantFactor, float depthBiasClamp,
                           float depthBiasSlopeFactor) {
        // TODO: Implement
    }
    void vkCmdSetBlendConstants(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                const float blendConstants[4]) {
        // TODO: Implement
    }
    void vkCmdSetDepthBounds(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             float minDepthBounds, float maxDepthBounds) {
        // TODO: Implement
    }
    void vkCmdSetStencilCompareMask(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    VkStencilFaceFlags faceMask, uint32_t compareMask) {
        // TODO: Implement
    }
    void vkCmdSetStencilWriteMask(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  VkStencilFaceFlags faceMask, uint32_t writeMask) {
        // TODO: Implement
    }
    void vkCmdSetStencilReference(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  VkStencilFaceFlags faceMask, uint32_t reference) {
        // TODO: Implement
    }
    void vkCmdBindDescriptorSets(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout,
                                 uint32_t firstSet, uint32_t descriptorSetCount,
                                 const VkDescriptorSet* pDescriptorSets,
                                 uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) {
        // TODO: Implement
    }
    void vkCmdBindIndexBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) {
        // TODO: Implement
    }
    void vkCmdBindVertexBuffers(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                uint32_t firstBinding, uint32_t bindingCount,
                                const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) {
        // TODO: Implement
    }
    void vkCmdDraw(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                   uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex,
                   uint32_t firstInstance) {
        // TODO: Implement
    }
    void vkCmdDrawIndexed(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex,
                          int32_t vertexOffset, uint32_t firstInstance) {
        // TODO: Implement
    }
    void vkCmdDrawIndirect(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount,
                           uint32_t stride) {
        // TODO: Implement
    }
    void vkCmdDrawIndexedIndirect(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount,
                                  uint32_t stride) {
        // TODO: Implement
    }
    void vkCmdDispatch(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                       uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
        // TODO: Implement
    }
    void vkCmdDispatchIndirect(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                               VkBuffer buffer, VkDeviceSize offset) {
        // TODO: Implement
    }
    void vkCmdCopyBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount,
                         const VkBufferCopy* pRegions) {
        // TODO: Implement
    }
    void vkCmdCopyImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                        VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage,
                        VkImageLayout dstImageLayout, uint32_t regionCount,
                        const VkImageCopy* pRegions) {
        // TODO: Implement
    }
    void vkCmdBlitImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                        VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage,
                        VkImageLayout dstImageLayout, uint32_t regionCount,
                        const VkImageBlit* pRegions, VkFilter filter) {
        // TODO: Implement
    }
    void vkCmdCopyBufferToImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout,
                                uint32_t regionCount, const VkBufferImageCopy* pRegions) {
        // TODO: Implement
    }
    void vkCmdCopyImageToBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer,
                                uint32_t regionCount, const VkBufferImageCopy* pRegions) {
        // TODO: Implement
    }
    void vkCmdUpdateBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize,
                           const void* pData) {
        // TODO: Implement
    }
    void vkCmdFillBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size,
                         uint32_t data) {
        // TODO: Implement
    }
    void vkCmdClearColorImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkImage image, VkImageLayout imageLayout,
                              const VkClearColorValue* pColor, uint32_t rangeCount,
                              const VkImageSubresourceRange* pRanges) {
        // TODO: Implement
    }
    void vkCmdClearDepthStencilImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                     VkImage image, VkImageLayout imageLayout,
                                     const VkClearDepthStencilValue* pDepthStencil,
                                     uint32_t rangeCount, const VkImageSubresourceRange* pRanges) {
        // TODO: Implement
    }
    void vkCmdClearAttachments(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                               uint32_t attachmentCount, const VkClearAttachment* pAttachments,
                               uint32_t rectCount, const VkClearRect* pRects) {
        // TODO: Implement
    }
    void vkCmdResolveImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage,
                           VkImageLayout dstImageLayout, uint32_t regionCount,
                           const VkImageResolve* pRegions) {
        // TODO: Implement
    }
    void vkCmdSetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer, VkEvent event,
                       VkPipelineStageFlags stageMask) {
        // TODO: Implement
    }
    void vkCmdResetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         VkEvent event, VkPipelineStageFlags stageMask) {
        // TODO: Implement
    }
    void vkCmdWaitEvents(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         uint32_t eventCount, const VkEvent* pEvents,
                         VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
                         uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
                         uint32_t bufferMemoryBarrierCount,
                         const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                         uint32_t imageMemoryBarrierCount,
                         const VkImageMemoryBarrier* pImageMemoryBarriers) {
        // TODO: Implement
    }
    void vkCmdPipelineBarrier(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
                              VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount,
                              const VkMemoryBarrier* pMemoryBarriers,
                              uint32_t bufferMemoryBarrierCount,
                              const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                              uint32_t imageMemoryBarrierCount,
                              const VkImageMemoryBarrier* pImageMemoryBarriers) {
        // TODO: Implement
    }
    void vkCmdBeginQuery(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) {
        // TODO: Implement
    }
    void vkCmdEndQuery(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                       VkQueryPool queryPool, uint32_t query) {
        // TODO: Implement
    }
    void vkCmdResetQueryPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
        // TODO: Implement
    }
    void vkCmdWriteTimestamp(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool,
                             uint32_t query) {
        // TODO: Implement
    }
    void vkCmdCopyQueryPoolResults(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount,
                                   VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride,
                                   VkQueryResultFlags flags) {
        // TODO: Implement
    }
    void vkCmdPushConstants(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset,
                            uint32_t size, const void* pValues) {
        // TODO: Implement
    }
    void vkCmdBeginRenderPass(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              const VkRenderPassBeginInfo* pRenderPassBegin,
                              VkSubpassContents contents) {
        // TODO: Implement
    }
    void vkCmdNextSubpass(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          VkSubpassContents contents) {
        // TODO: Implement
    }
    void vkCmdEndRenderPass(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer) {
        // TODO: Implement
    }
    void vkCmdExecuteCommands(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) {
        // TODO: Implement
    }
#endif
#ifdef VK_VERSION_1_1
    void vkEnumerateInstanceVersion(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkResult input_result,
                                    uint32_t* pApiVersion) {
        // TODO: Implement
    }
    void vkBindBufferMemory2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) {
        // TODO: Implement
    }
    void vkBindImageMemory2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) {
        // TODO: Implement
    }
    void vkGetDeviceGroupPeerMemoryFeatures(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            uint32_t heapIndex, uint32_t localDeviceIndex,
                                            uint32_t remoteDeviceIndex,
                                            VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
        // TODO: Implement
    }
    void vkCmdSetDeviceMask(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            uint32_t deviceMask) {
        // TODO: Implement
    }
    void vkCmdDispatchBase(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ,
                           uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
        // TODO: Implement
    }
    void vkEnumeratePhysicalDeviceGroups(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
        VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
        // TODO: Implement
    }
    void vkGetImageMemoryRequirements2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       const VkImageMemoryRequirementsInfo2* pInfo,
                                       VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetBufferMemoryRequirements2(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkDevice device,
                                        const VkBufferMemoryRequirementsInfo2* pInfo,
                                        VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetImageSparseMemoryRequirements2(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceFeatures2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool,
                                      VkPhysicalDevice physicalDevice,
                                      VkPhysicalDeviceFeatures2* pFeatures) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceProperties2(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkPhysicalDevice physicalDevice,
                                        VkPhysicalDeviceProperties2* pProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceFormatProperties2(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              VkPhysicalDevice physicalDevice, VkFormat format,
                                              VkFormatProperties2* pFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceImageFormatProperties2(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
        VkImageFormatProperties2* pImageFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceQueueFamilyProperties2(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount,
        VkQueueFamilyProperties2* pQueueFamilyProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceMemoryProperties2(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceSparseImageFormatProperties2(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
        uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
        // TODO: Implement
    }
    void vkTrimCommandPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkDevice device,
                           VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
        // TODO: Implement
    }
    void vkGetDeviceQueue2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkDevice device,
                           const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pQueue create
        mReconstruction.addHandles((const uint64_t*)pQueue, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pQueue, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pQueue) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkGetDeviceQueue2, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pQueue, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pQueue, 1);
    }
    void vkCreateSamplerYcbcrConversion(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device,
                                        const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                        const VkAllocationCallbacks* pAllocator,
                                        VkSamplerYcbcrConversion* pYcbcrConversion) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pYcbcrConversion create
        mReconstruction.addHandles((const uint64_t*)pYcbcrConversion, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pYcbcrConversion, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pYcbcrConversion) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateSamplerYcbcrConversion, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pYcbcrConversion, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pYcbcrConversion, 1);
    }
    void vkDestroySamplerYcbcrConversion(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                         const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // ycbcrConversion destroy
        mReconstruction.removeHandles((const uint64_t*)(&ycbcrConversion), 1);
    }
    void vkCreateDescriptorUpdateTemplate(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                          const VkAllocationCallbacks* pAllocator,
                                          VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDescriptorUpdateTemplate create
        mReconstruction.addHandles((const uint64_t*)pDescriptorUpdateTemplate, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pDescriptorUpdateTemplate, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pDescriptorUpdateTemplate) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateDescriptorUpdateTemplate,
                                    snapshotTraceBegin, snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pDescriptorUpdateTemplate, 1,
                                            apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle,
                                                (const uint64_t*)pDescriptorUpdateTemplate, 1);
    }
    void vkDestroyDescriptorUpdateTemplate(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device,
                                           VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                           const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // descriptorUpdateTemplate destroy
        mReconstruction.removeHandles((const uint64_t*)(&descriptorUpdateTemplate), 1);
    }
    void vkUpdateDescriptorSetWithTemplate(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device, VkDescriptorSet descriptorSet,
                                           VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                           const void* pData) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceExternalBufferProperties(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
        VkExternalBufferProperties* pExternalBufferProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceExternalFenceProperties(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
        VkExternalFenceProperties* pExternalFenceProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceExternalSemaphoreProperties(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
        VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
        // TODO: Implement
    }
    void vkGetDescriptorSetLayoutSupport(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device,
                                         const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                         VkDescriptorSetLayoutSupport* pSupport) {
        // TODO: Implement
    }
#endif
#ifdef VK_VERSION_1_2
    void vkCmdDrawIndirectCount(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer,
                                VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                uint32_t stride) {
        // TODO: Implement
    }
    void vkCmdDrawIndexedIndirectCount(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer,
                                       VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                       uint32_t stride) {
        // TODO: Implement
    }
    void vkCreateRenderPass2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             const VkRenderPassCreateInfo2* pCreateInfo,
                             const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pRenderPass create
        mReconstruction.addHandles((const uint64_t*)pRenderPass, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pRenderPass, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pRenderPass) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateRenderPass2, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pRenderPass, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pRenderPass, 1);
    }
    void vkCmdBeginRenderPass2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                               const VkRenderPassBeginInfo* pRenderPassBegin,
                               const VkSubpassBeginInfo* pSubpassBeginInfo) {
        // TODO: Implement
    }
    void vkCmdNextSubpass2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           const VkSubpassBeginInfo* pSubpassBeginInfo,
                           const VkSubpassEndInfo* pSubpassEndInfo) {
        // TODO: Implement
    }
    void vkCmdEndRenderPass2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             const VkSubpassEndInfo* pSubpassEndInfo) {
        // TODO: Implement
    }
    void vkResetQueryPool(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkDevice device, VkQueryPool queryPool,
                          uint32_t firstQuery, uint32_t queryCount) {
        // TODO: Implement
    }
    void vkGetSemaphoreCounterValue(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkResult input_result,
                                    VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
        // TODO: Implement
    }
    void vkWaitSemaphores(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                          const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
        // TODO: Implement
    }
    void vkSignalSemaphore(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                           const VkSemaphoreSignalInfo* pSignalInfo) {
        // TODO: Implement
    }
    void vkGetBufferDeviceAddress(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkDeviceAddress input_result,
                                  VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
        // TODO: Implement
    }
    void vkGetBufferOpaqueCaptureAddress(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         uint64_t input_result, VkDevice device,
                                         const VkBufferDeviceAddressInfo* pInfo) {
        // TODO: Implement
    }
    void vkGetDeviceMemoryOpaqueCaptureAddress(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        uint64_t input_result, VkDevice device,
        const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
        // TODO: Implement
    }
#endif
#ifdef VK_VERSION_1_3
    void vkGetPhysicalDeviceToolProperties(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkPhysicalDevice physicalDevice,
                                           uint32_t* pToolCount,
                                           VkPhysicalDeviceToolProperties* pToolProperties) {
        // TODO: Implement
    }
    void vkCreatePrivateDataSlot(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkResult input_result,
                                 VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                 const VkAllocationCallbacks* pAllocator,
                                 VkPrivateDataSlot* pPrivateDataSlot) {
        // TODO: Implement
    }
    void vkDestroyPrivateDataSlot(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkDevice device,
                                  VkPrivateDataSlot privateDataSlot,
                                  const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
    }
    void vkSetPrivateData(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                          VkObjectType objectType, uint64_t objectHandle,
                          VkPrivateDataSlot privateDataSlot, uint64_t data) {
        // TODO: Implement
    }
    void vkGetPrivateData(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkDevice device, VkObjectType objectType,
                          uint64_t objectHandle, VkPrivateDataSlot privateDataSlot,
                          uint64_t* pData) {
        // TODO: Implement
    }
    void vkCmdSetEvent2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkCommandBuffer commandBuffer, VkEvent event,
                        const VkDependencyInfo* pDependencyInfo) {
        // TODO: Implement
    }
    void vkCmdResetEvent2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          VkEvent event, VkPipelineStageFlags2 stageMask) {
        // TODO: Implement
    }
    void vkCmdWaitEvents2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          uint32_t eventCount, const VkEvent* pEvents,
                          const VkDependencyInfo* pDependencyInfos) {
        // TODO: Implement
    }
    void vkCmdPipelineBarrier2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                               const VkDependencyInfo* pDependencyInfo) {
        // TODO: Implement
    }
    void vkCmdWriteTimestamp2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query) {
        // TODO: Implement
    }
    void vkQueueSubmit2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                        android::base::BumpPool* pool, VkResult input_result, VkQueue queue,
                        uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
        // TODO: Implement
    }
    void vkCmdCopyBuffer2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          const VkCopyBufferInfo2* pCopyBufferInfo) {
        // TODO: Implement
    }
    void vkCmdCopyImage2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         const VkCopyImageInfo2* pCopyImageInfo) {
        // TODO: Implement
    }
    void vkCmdCopyBufferToImage2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
        // TODO: Implement
    }
    void vkCmdCopyImageToBuffer2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
        // TODO: Implement
    }
    void vkCmdBlitImage2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                         const VkBlitImageInfo2* pBlitImageInfo) {
        // TODO: Implement
    }
    void vkCmdResolveImage2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            const VkResolveImageInfo2* pResolveImageInfo) {
        // TODO: Implement
    }
    void vkCmdBeginRendering(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             const VkRenderingInfo* pRenderingInfo) {
        // TODO: Implement
    }
    void vkCmdEndRendering(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer) {
        // TODO: Implement
    }
    void vkCmdSetCullMode(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                          android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                          VkCullModeFlags cullMode) {
        // TODO: Implement
    }
    void vkCmdSetFrontFace(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkFrontFace frontFace) {
        // TODO: Implement
    }
    void vkCmdSetPrimitiveTopology(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   VkPrimitiveTopology primitiveTopology) {
        // TODO: Implement
    }
    void vkCmdSetViewportWithCount(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   uint32_t viewportCount, const VkViewport* pViewports) {
        // TODO: Implement
    }
    void vkCmdSetScissorWithCount(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  uint32_t scissorCount, const VkRect2D* pScissors) {
        // TODO: Implement
    }
    void vkCmdBindVertexBuffers2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 uint32_t firstBinding, uint32_t bindingCount,
                                 const VkBuffer* pBuffers, const VkDeviceSize* pOffsets,
                                 const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) {
        // TODO: Implement
    }
    void vkCmdSetDepthTestEnable(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 VkBool32 depthTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthWriteEnable(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  VkBool32 depthWriteEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthCompareOp(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                VkCompareOp depthCompareOp) {
        // TODO: Implement
    }
    void vkCmdSetDepthBoundsTestEnable(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       VkBool32 depthBoundsTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetStencilTestEnable(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   VkBool32 stencilTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetStencilOp(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp,
                           VkStencilOp depthFailOp, VkCompareOp compareOp) {
        // TODO: Implement
    }
    void vkCmdSetRasterizerDiscardEnable(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer,
                                         VkBool32 rasterizerDiscardEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthBiasEnable(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 VkBool32 depthBiasEnable) {
        // TODO: Implement
    }
    void vkCmdSetPrimitiveRestartEnable(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer,
                                        VkBool32 primitiveRestartEnable) {
        // TODO: Implement
    }
    void vkGetDeviceBufferMemoryRequirements(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkDevice device,
                                             const VkDeviceBufferMemoryRequirements* pInfo,
                                             VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetDeviceImageMemoryRequirements(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            const VkDeviceImageMemoryRequirements* pInfo,
                                            VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetDeviceImageSparseMemoryRequirements(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
    void vkCmdBeginRenderingKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                const VkRenderingInfo* pRenderingInfo) {
        // TODO: Implement
    }
    void vkCmdEndRenderingKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_get_physical_device_properties2
    void vkGetPhysicalDeviceFeatures2KHR(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkPhysicalDevice physicalDevice,
                                         VkPhysicalDeviceFeatures2* pFeatures) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceProperties2KHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkPhysicalDevice physicalDevice,
                                           VkPhysicalDeviceProperties2* pProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceFormatProperties2KHR(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkPhysicalDevice physicalDevice, VkFormat format,
                                                 VkFormatProperties2* pFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceImageFormatProperties2KHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
        VkImageFormatProperties2* pImageFormatProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceQueueFamilyProperties2KHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount,
        VkQueueFamilyProperties2* pQueueFamilyProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceMemoryProperties2KHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
        // TODO: Implement
    }
    void vkGetPhysicalDeviceSparseImageFormatProperties2KHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
        uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_maintenance1
    void vkTrimCommandPoolKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkDevice device,
                              VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_external_memory_capabilities
    void vkGetPhysicalDeviceExternalBufferPropertiesKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
        VkExternalBufferProperties* pExternalBufferProperties) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
    void vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
        VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
    void vkImportSemaphoreFdKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device,
                                const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) {
        // TODO: Implement
    }
    void vkGetSemaphoreFdKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
#endif
#ifdef VK_KHR_descriptor_update_template
    void vkCreateDescriptorUpdateTemplateKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device,
        const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pDescriptorUpdateTemplate create
        mReconstruction.addHandles((const uint64_t*)pDescriptorUpdateTemplate, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pDescriptorUpdateTemplate, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pDescriptorUpdateTemplate) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateDescriptorUpdateTemplateKHR,
                                    snapshotTraceBegin, snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pDescriptorUpdateTemplate, 1,
                                            apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle,
                                                (const uint64_t*)pDescriptorUpdateTemplate, 1);
    }
    void vkDestroyDescriptorUpdateTemplateKHR(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkDevice device,
                                              VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                              const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // descriptorUpdateTemplate destroy
        mReconstruction.removeHandles((const uint64_t*)(&descriptorUpdateTemplate), 1);
    }
    void vkUpdateDescriptorSetWithTemplateKHR(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkDevice device,
                                              VkDescriptorSet descriptorSet,
                                              VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                              const void* pData) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
    void vkCreateRenderPass2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                const VkAllocationCallbacks* pAllocator,
                                VkRenderPass* pRenderPass) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pRenderPass create
        mReconstruction.addHandles((const uint64_t*)pRenderPass, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pRenderPass, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pRenderPass) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateRenderPass2KHR, snapshotTraceBegin,
                                    snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pRenderPass, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pRenderPass, 1);
    }
    void vkCmdBeginRenderPass2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  const VkRenderPassBeginInfo* pRenderPassBegin,
                                  const VkSubpassBeginInfo* pSubpassBeginInfo) {
        // TODO: Implement
    }
    void vkCmdNextSubpass2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              const VkSubpassBeginInfo* pSubpassBeginInfo,
                              const VkSubpassEndInfo* pSubpassEndInfo) {
        // TODO: Implement
    }
    void vkCmdEndRenderPass2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                const VkSubpassEndInfo* pSubpassEndInfo) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_external_fence_capabilities
    void vkGetPhysicalDeviceExternalFencePropertiesKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
        VkExternalFenceProperties* pExternalFenceProperties) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
    void vkImportFenceFdKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                            const VkImportFenceFdInfoKHR* pImportFenceFdInfo) {
        // TODO: Implement
    }
    void vkGetFenceFdKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                         const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
    void vkGetImageMemoryRequirements2KHR(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkDevice device,
                                          const VkImageMemoryRequirementsInfo2* pInfo,
                                          VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetBufferMemoryRequirements2KHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device,
                                           const VkBufferMemoryRequirementsInfo2* pInfo,
                                           VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetImageSparseMemoryRequirements2KHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
    void vkCreateSamplerYcbcrConversionKHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator,
                                           VkSamplerYcbcrConversion* pYcbcrConversion) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pYcbcrConversion create
        mReconstruction.addHandles((const uint64_t*)pYcbcrConversion, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pYcbcrConversion, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pYcbcrConversion) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateSamplerYcbcrConversionKHR,
                                    snapshotTraceBegin, snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pYcbcrConversion, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pYcbcrConversion, 1);
    }
    void vkDestroySamplerYcbcrConversionKHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            VkSamplerYcbcrConversion ycbcrConversion,
                                            const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // ycbcrConversion destroy
        mReconstruction.removeHandles((const uint64_t*)(&ycbcrConversion), 1);
    }
#endif
#ifdef VK_KHR_bind_memory2
    void vkBindBufferMemory2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, uint32_t bindInfoCount,
                                const VkBindBufferMemoryInfo* pBindInfos) {
        // TODO: Implement
    }
    void vkBindImageMemory2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, uint32_t bindInfoCount,
                               const VkBindImageMemoryInfo* pBindInfos) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_maintenance3
    void vkGetDescriptorSetLayoutSupportKHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                            VkDescriptorSetLayoutSupport* pSupport) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
    void vkGetBufferDeviceAddressKHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkDeviceAddress input_result,
                                     VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
        // TODO: Implement
    }
    void vkGetBufferOpaqueCaptureAddressKHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, uint64_t input_result,
                                            VkDevice device,
                                            const VkBufferDeviceAddressInfo* pInfo) {
        // TODO: Implement
    }
    void vkGetDeviceMemoryOpaqueCaptureAddressKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        uint64_t input_result, VkDevice device,
        const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_pipeline_executable_properties
    void vkGetPipelineExecutablePropertiesKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device, const VkPipelineInfoKHR* pPipelineInfo,
        uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) {
        // TODO: Implement
    }
    void vkGetPipelineExecutableStatisticsKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo,
        uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) {
        // TODO: Implement
    }
    void vkGetPipelineExecutableInternalRepresentationsKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo,
        uint32_t* pInternalRepresentationCount,
        VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
    void vkCmdSetEvent2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                           VkEvent event, const VkDependencyInfo* pDependencyInfo) {
        // TODO: Implement
    }
    void vkCmdResetEvent2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             VkEvent event, VkPipelineStageFlags2 stageMask) {
        // TODO: Implement
    }
    void vkCmdWaitEvents2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             uint32_t eventCount, const VkEvent* pEvents,
                             const VkDependencyInfo* pDependencyInfos) {
        // TODO: Implement
    }
    void vkCmdPipelineBarrier2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  const VkDependencyInfo* pDependencyInfo) {
        // TODO: Implement
    }
    void vkCmdWriteTimestamp2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                 uint32_t query) {
        // TODO: Implement
    }
    void vkQueueSubmit2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                           android::base::BumpPool* pool, VkResult input_result, VkQueue queue,
                           uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
        // TODO: Implement
    }
    void vkCmdWriteBufferMarker2AMD(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    VkPipelineStageFlags2 stage, VkBuffer dstBuffer,
                                    VkDeviceSize dstOffset, uint32_t marker) {
        // TODO: Implement
    }
    void vkGetQueueCheckpointData2NV(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkQueue queue,
                                     uint32_t* pCheckpointDataCount,
                                     VkCheckpointData2NV* pCheckpointData) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
    void vkCmdCopyBuffer2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             const VkCopyBufferInfo2* pCopyBufferInfo) {
        // TODO: Implement
    }
    void vkCmdCopyImage2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            const VkCopyImageInfo2* pCopyImageInfo) {
        // TODO: Implement
    }
    void vkCmdCopyBufferToImage2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
        // TODO: Implement
    }
    void vkCmdCopyImageToBuffer2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
        // TODO: Implement
    }
    void vkCmdBlitImage2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            const VkBlitImageInfo2* pBlitImageInfo) {
        // TODO: Implement
    }
    void vkCmdResolveImage2KHR(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                               const VkResolveImageInfo2* pResolveImageInfo) {
        // TODO: Implement
    }
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
    void vkGetDeviceBufferMemoryRequirementsKHR(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool, VkDevice device,
                                                const VkDeviceBufferMemoryRequirements* pInfo,
                                                VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetDeviceImageMemoryRequirementsKHR(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool, VkDevice device,
                                               const VkDeviceImageMemoryRequirements* pInfo,
                                               VkMemoryRequirements2* pMemoryRequirements) {
        // TODO: Implement
    }
    void vkGetDeviceImageSparseMemoryRequirementsKHR(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
        // TODO: Implement
    }
#endif
#ifdef VK_ANDROID_native_buffer
    void vkGetSwapchainGrallocUsageANDROID(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device, VkFormat format,
                                           VkImageUsageFlags imageUsage, int* grallocUsage) {
        // TODO: Implement
    }
    void vkAcquireImageANDROID(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkResult input_result,
                               VkDevice device, VkImage image, int nativeFenceFd,
                               VkSemaphore semaphore, VkFence fence) {
        // TODO: Implement
    }
    void vkQueueSignalReleaseImageANDROID(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkQueue queue,
                                          uint32_t waitSemaphoreCount,
                                          const VkSemaphore* pWaitSemaphores, VkImage image,
                                          int* pNativeFenceFd) {
        // TODO: Implement
    }
    void vkGetSwapchainGrallocUsage2ANDROID(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device, VkFormat format, VkImageUsageFlags imageUsage,
        VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage,
        uint64_t* grallocProducerUsage) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_transform_feedback
    void vkCmdBindTransformFeedbackBuffersEXT(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
        const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) {
        // TODO: Implement
    }
    void vkCmdBeginTransformFeedbackEXT(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer,
                                        uint32_t counterBufferCount,
                                        const VkBuffer* pCounterBuffers,
                                        const VkDeviceSize* pCounterBufferOffsets) {
        // TODO: Implement
    }
    void vkCmdEndTransformFeedbackEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      uint32_t firstCounterBuffer, uint32_t counterBufferCount,
                                      const VkBuffer* pCounterBuffers,
                                      const VkDeviceSize* pCounterBufferOffsets) {
        // TODO: Implement
    }
    void vkCmdBeginQueryIndexedEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags,
                                   uint32_t index) {
        // TODO: Implement
    }
    void vkCmdEndQueryIndexedEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                 android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                 VkQueryPool queryPool, uint32_t query, uint32_t index) {
        // TODO: Implement
    }
    void vkCmdDrawIndirectByteCountEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       uint32_t instanceCount, uint32_t firstInstance,
                                       VkBuffer counterBuffer, VkDeviceSize counterBufferOffset,
                                       uint32_t counterOffset, uint32_t vertexStride) {
        // TODO: Implement
    }
#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
    void vkGetPhysicalDeviceToolPropertiesEXT(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkPhysicalDevice physicalDevice, uint32_t* pToolCount,
                                              VkPhysicalDeviceToolProperties* pToolProperties) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_provoking_vertex
#endif
#ifdef VK_EXT_line_rasterization
    void vkCmdSetLineStippleEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                uint32_t lineStippleFactor, uint16_t lineStipplePattern) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_index_type_uint8
#endif
#ifdef VK_EXT_extended_dynamic_state
    void vkCmdSetCullModeEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                             VkCullModeFlags cullMode) {
        // TODO: Implement
    }
    void vkCmdSetFrontFaceEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkFrontFace frontFace) {
        // TODO: Implement
    }
    void vkCmdSetPrimitiveTopologyEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      VkPrimitiveTopology primitiveTopology) {
        // TODO: Implement
    }
    void vkCmdSetViewportWithCountEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      uint32_t viewportCount, const VkViewport* pViewports) {
        // TODO: Implement
    }
    void vkCmdSetScissorWithCountEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                     uint32_t scissorCount, const VkRect2D* pScissors) {
        // TODO: Implement
    }
    void vkCmdBindVertexBuffers2EXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    uint32_t firstBinding, uint32_t bindingCount,
                                    const VkBuffer* pBuffers, const VkDeviceSize* pOffsets,
                                    const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) {
        // TODO: Implement
    }
    void vkCmdSetDepthTestEnableEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    VkBool32 depthTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthWriteEnableEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                     VkBool32 depthWriteEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthCompareOpEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                   VkCompareOp depthCompareOp) {
        // TODO: Implement
    }
    void vkCmdSetDepthBoundsTestEnableEXT(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer,
                                          VkBool32 depthBoundsTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetStencilTestEnableEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      VkBool32 stencilTestEnable) {
        // TODO: Implement
    }
    void vkCmdSetStencilOpEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                              android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                              VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp,
                              VkStencilOp depthFailOp, VkCompareOp compareOp) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_swapchain_maintenance1
    void vkReleaseSwapchainImagesEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkResult input_result,
                                     VkDevice device,
                                     const VkReleaseSwapchainImagesInfoEXT* pReleaseInfo) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
#endif
#ifdef VK_EXT_device_memory_report
#endif
#ifdef VK_EXT_custom_border_color
#endif
#ifdef VK_EXT_private_data
    void vkCreatePrivateDataSlotEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkResult input_result,
                                    VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                    const VkAllocationCallbacks* pAllocator,
                                    VkPrivateDataSlot* pPrivateDataSlot) {
        // TODO: Implement
    }
    void vkDestroyPrivateDataSlotEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkDevice device,
                                     VkPrivateDataSlot privateDataSlot,
                                     const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
    }
    void vkSetPrivateDataEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                             VkObjectType objectType, uint64_t objectHandle,
                             VkPrivateDataSlot privateDataSlot, uint64_t data) {
        // TODO: Implement
    }
    void vkGetPrivateDataEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                             android::base::BumpPool* pool, VkDevice device,
                             VkObjectType objectType, uint64_t objectHandle,
                             VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
    void vkGetImageSubresourceLayout2EXT(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, VkImage image,
                                         const VkImageSubresource2EXT* pSubresource,
                                         VkSubresourceLayout2EXT* pLayout) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_4444_formats
#endif
#ifdef VK_EXT_primitive_topology_list_restart
#endif
#ifdef VK_EXT_extended_dynamic_state2
    void vkCmdSetPatchControlPointsEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       uint32_t patchControlPoints) {
        // TODO: Implement
    }
    void vkCmdSetRasterizerDiscardEnableEXT(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            VkBool32 rasterizerDiscardEnable) {
        // TODO: Implement
    }
    void vkCmdSetDepthBiasEnableEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                    VkBool32 depthBiasEnable) {
        // TODO: Implement
    }
    void vkCmdSetLogicOpEXT(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                            android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                            VkLogicOp logicOp) {
        // TODO: Implement
    }
    void vkCmdSetPrimitiveRestartEnableEXT(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer,
                                           VkBool32 primitiveRestartEnable) {
        // TODO: Implement
    }
#endif
#ifdef VK_GOOGLE_gfxstream
    void vkMapMemoryIntoAddressSpaceGOOGLE(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           VkDeviceMemory memory, uint64_t* pAddress) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // memory modify
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkMapMemoryIntoAddressSpaceGOOGLE,
                                    snapshotTraceBegin, snapshotTraceBytes);
        for (uint32_t i = 0; i < 1; ++i) {
            VkDeviceMemory boxed = unboxed_to_boxed_non_dispatchable_VkDeviceMemory((&memory)[i]);
            mReconstruction.forEachHandleAddModifyApi((const uint64_t*)(&boxed), 1, apiHandle);
        }
    }
    void vkUpdateDescriptorSetWithTemplateSizedGOOGLE(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate, uint32_t imageInfoCount,
        uint32_t bufferInfoCount, uint32_t bufferViewCount, const uint32_t* pImageInfoEntryIndices,
        const uint32_t* pBufferInfoEntryIndices, const uint32_t* pBufferViewEntryIndices,
        const VkDescriptorImageInfo* pImageInfos, const VkDescriptorBufferInfo* pBufferInfos,
        const VkBufferView* pBufferViews) {
        // TODO: Implement
    }
    void vkBeginCommandBufferAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer,
                                         const VkCommandBufferBeginInfo* pBeginInfo) {
        // TODO: Implement
    }
    void vkEndCommandBufferAsyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool,
                                       VkCommandBuffer commandBuffer) {
        // TODO: Implement
    }
    void vkResetCommandBufferAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer,
                                         VkCommandBufferResetFlags flags) {
        // TODO: Implement
    }
    void vkCommandBufferHostSyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       uint32_t needHostSync, uint32_t sequenceNumber) {
        // TODO: Implement
    }
    void vkCreateImageWithRequirementsGOOGLE(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkResult input_result,
                                             VkDevice device, const VkImageCreateInfo* pCreateInfo,
                                             const VkAllocationCallbacks* pAllocator,
                                             VkImage* pImage,
                                             VkMemoryRequirements* pMemoryRequirements) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pImage create
        mReconstruction.addHandles((const uint64_t*)pImage, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pImage, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pImage) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateImageWithRequirementsGOOGLE,
                                    snapshotTraceBegin, snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pImage, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pImage, 1);
    }
    void vkCreateBufferWithRequirementsGOOGLE(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkResult input_result, VkDevice device, const VkBufferCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer,
        VkMemoryRequirements* pMemoryRequirements) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // pBuffer create
        mReconstruction.addHandles((const uint64_t*)pBuffer, 1);
        mReconstruction.addHandleDependency((const uint64_t*)pBuffer, 1,
                                            (uint64_t)(uintptr_t)device);
        if (!pBuffer) return;
        auto apiHandle = mReconstruction.createApiInfo();
        auto apiInfo = mReconstruction.getApiInfo(apiHandle);
        mReconstruction.setApiTrace(apiInfo, OP_vkCreateBufferWithRequirementsGOOGLE,
                                    snapshotTraceBegin, snapshotTraceBytes);
        mReconstruction.forEachHandleAddApi((const uint64_t*)pBuffer, 1, apiHandle);
        mReconstruction.setCreatedHandlesForApi(apiHandle, (const uint64_t*)pBuffer, 1);
    }
    void vkGetMemoryHostAddressInfoGOOGLE(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          VkDeviceMemory memory, uint64_t* pAddress,
                                          uint64_t* pSize, uint64_t* pHostmemId) {
        // TODO: Implement
    }
    void vkFreeMemorySyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                android::base::BumpPool* pool, VkResult input_result,
                                VkDevice device, VkDeviceMemory memory,
                                const VkAllocationCallbacks* pAllocator) {
        // TODO: Implement
        android::base::AutoLock lock(mLock);
        // memory destroy
        mReconstruction.removeHandles((const uint64_t*)(&memory), 1);
    }
    void vkQueueHostSyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                               android::base::BumpPool* pool, VkQueue queue, uint32_t needHostSync,
                               uint32_t sequenceNumber) {
        // TODO: Implement
    }
    void vkQueueSubmitAsyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkQueue queue,
                                  uint32_t submitCount, const VkSubmitInfo* pSubmits,
                                  VkFence fence) {
        // TODO: Implement
    }
    void vkQueueWaitIdleAsyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkQueue queue) {
        // TODO: Implement
    }
    void vkQueueBindSparseAsyncGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkQueue queue,
                                      uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                                      VkFence fence) {
        // TODO: Implement
    }
    void vkGetLinearImageLayoutGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkDevice device,
                                      VkFormat format, VkDeviceSize* pOffset,
                                      VkDeviceSize* pRowPitchAlignment) {
        // TODO: Implement
    }
    void vkGetLinearImageLayout2GOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       const VkImageCreateInfo* pCreateInfo, VkDeviceSize* pOffset,
                                       VkDeviceSize* pRowPitchAlignment) {
        // TODO: Implement
    }
    void vkQueueFlushCommandsGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkQueue queue,
                                    VkCommandBuffer commandBuffer, VkDeviceSize dataSize,
                                    const void* pData) {
        // TODO: Implement
    }
    void vkQueueCommitDescriptorSetUpdatesGOOGLE(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkQueue queue, uint32_t descriptorPoolCount, const VkDescriptorPool* pDescriptorPools,
        uint32_t descriptorSetCount, const VkDescriptorSetLayout* pSetLayouts,
        const uint64_t* pDescriptorSetPoolIds, const uint32_t* pDescriptorSetWhichPool,
        const uint32_t* pDescriptorSetPendingAllocation,
        const uint32_t* pDescriptorWriteStartingIndices, uint32_t pendingDescriptorWriteCount,
        const VkWriteDescriptorSet* pPendingDescriptorWrites) {
        // TODO: Implement
    }
    void vkCollectDescriptorPoolIdsGOOGLE(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkDevice device, VkDescriptorPool descriptorPool,
                                          uint32_t* pPoolIdCount, uint64_t* pPoolIds) {
        // TODO: Implement
    }
    void vkQueueSignalReleaseImageANDROIDAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool, VkQueue queue,
                                                     uint32_t waitSemaphoreCount,
                                                     const VkSemaphore* pWaitSemaphores,
                                                     VkImage image) {
        // TODO: Implement
    }
    void vkQueueFlushCommandsFromAuxMemoryGOOGLE(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool, VkQueue queue,
                                                 VkCommandBuffer commandBuffer,
                                                 VkDeviceMemory deviceMemory,
                                                 VkDeviceSize dataOffset, VkDeviceSize dataSize) {
        // TODO: Implement
    }
    void vkGetBlobGOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                         android::base::BumpPool* pool, VkResult input_result, VkDevice device,
                         VkDeviceMemory memory) {
        // TODO: Implement
    }
    void vkUpdateDescriptorSetWithTemplateSized2GOOGLE(
        const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
        VkDevice device, VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate, uint32_t imageInfoCount,
        uint32_t bufferInfoCount, uint32_t bufferViewCount, uint32_t inlineUniformBlockCount,
        const uint32_t* pImageInfoEntryIndices, const uint32_t* pBufferInfoEntryIndices,
        const uint32_t* pBufferViewEntryIndices, const VkDescriptorImageInfo* pImageInfos,
        const VkDescriptorBufferInfo* pBufferInfos, const VkBufferView* pBufferViews,
        const uint8_t* pInlineUniformBlockData) {
        // TODO: Implement
    }
    void vkQueueSubmitAsync2GOOGLE(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkQueue queue,
                                   uint32_t submitCount, const VkSubmitInfo2* pSubmits,
                                   VkFence fence) {
        // TODO: Implement
    }
#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
#endif

   private:
    android::base::Lock mLock;
    VkReconstruction mReconstruction;
};

VkDecoderSnapshot::VkDecoderSnapshot() : mImpl(new VkDecoderSnapshot::Impl()) {}

void VkDecoderSnapshot::save(android::base::Stream* stream) { mImpl->save(stream); }

void VkDecoderSnapshot::load(android::base::Stream* stream, GfxApiLogger& gfx_logger,
                             HealthMonitor<>* healthMonitor) {
    mImpl->load(stream, gfx_logger, healthMonitor);
}

VkDecoderSnapshot::~VkDecoderSnapshot() = default;
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateInstance(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result,
                                         const VkInstanceCreateInfo* pCreateInfo,
                                         const VkAllocationCallbacks* pAllocator,
                                         VkInstance* pInstance) {
    mImpl->vkCreateInstance(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, pCreateInfo,
                            pAllocator, pInstance);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyInstance(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkInstance instance,
                                          const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyInstance(snapshotTraceBegin, snapshotTraceBytes, pool, instance, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEnumeratePhysicalDevices(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkResult input_result, VkInstance instance,
                                                   uint32_t* pPhysicalDeviceCount,
                                                   VkPhysicalDevice* pPhysicalDevices) {
    mImpl->vkEnumeratePhysicalDevices(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                      instance, pPhysicalDeviceCount, pPhysicalDevices);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceFeatures(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool,
                                                    VkPhysicalDevice physicalDevice,
                                                    VkPhysicalDeviceFeatures* pFeatures) {
    mImpl->vkGetPhysicalDeviceFeatures(snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice,
                                       pFeatures);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceFormatProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) {
    mImpl->vkGetPhysicalDeviceFormatProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                               physicalDevice, format, pFormatProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceImageFormatProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type,
    VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags,
    VkImageFormatProperties* pImageFormatProperties) {
    mImpl->vkGetPhysicalDeviceImageFormatProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                    input_result, physicalDevice, format, type,
                                                    tiling, usage, flags, pImageFormatProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceProperties(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkPhysicalDevice physicalDevice,
                                                      VkPhysicalDeviceProperties* pProperties) {
    mImpl->vkGetPhysicalDeviceProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         physicalDevice, pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceQueueFamilyProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties* pQueueFamilyProperties) {
    mImpl->vkGetPhysicalDeviceQueueFamilyProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                    physicalDevice, pQueueFamilyPropertyCount,
                                                    pQueueFamilyProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceMemoryProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) {
    mImpl->vkGetPhysicalDeviceMemoryProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                               physicalDevice, pMemoryProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetInstanceProcAddr(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              PFN_vkVoidFunction input_result, VkInstance instance,
                                              const char* pName) {
    mImpl->vkGetInstanceProcAddr(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                 instance, pName);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetDeviceProcAddr(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            PFN_vkVoidFunction input_result, VkDevice device,
                                            const char* pName) {
    mImpl->vkGetDeviceProcAddr(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               pName);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateDevice(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkResult input_result,
                                       VkPhysicalDevice physicalDevice,
                                       const VkDeviceCreateInfo* pCreateInfo,
                                       const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) {
    mImpl->vkCreateDevice(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                          physicalDevice, pCreateInfo, pAllocator, pDevice);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyDevice(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkDevice device, const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyDevice(snapshotTraceBegin, snapshotTraceBytes, pool, device, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEnumerateInstanceExtensionProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, const char* pLayerName, uint32_t* pPropertyCount,
    VkExtensionProperties* pProperties) {
    mImpl->vkEnumerateInstanceExtensionProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                  input_result, pLayerName, pPropertyCount,
                                                  pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEnumerateDeviceExtensionProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice, const char* pLayerName,
    uint32_t* pPropertyCount, VkExtensionProperties* pProperties) {
    mImpl->vkEnumerateDeviceExtensionProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                input_result, physicalDevice, pLayerName,
                                                pPropertyCount, pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEnumerateInstanceLayerProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, uint32_t* pPropertyCount, VkLayerProperties* pProperties) {
    mImpl->vkEnumerateInstanceLayerProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                              input_result, pPropertyCount, pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEnumerateDeviceLayerProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
    VkLayerProperties* pProperties) {
    mImpl->vkEnumerateDeviceLayerProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                            input_result, physicalDevice, pPropertyCount,
                                            pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetDeviceQueue(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, uint32_t queueFamilyIndex,
                                         uint32_t queueIndex, VkQueue* pQueue) {
    mImpl->vkGetDeviceQueue(snapshotTraceBegin, snapshotTraceBytes, pool, device, queueFamilyIndex,
                            queueIndex, pQueue);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkQueueSubmit(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkResult input_result,
                                      VkQueue queue, uint32_t submitCount,
                                      const VkSubmitInfo* pSubmits, VkFence fence) {
    mImpl->vkQueueSubmit(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, queue,
                         submitCount, pSubmits, fence);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkQueueWaitIdle(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkQueue queue) {
    mImpl->vkQueueWaitIdle(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, queue);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDeviceWaitIdle(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device) {
    mImpl->vkDeviceWaitIdle(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkAllocateMemory(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device,
                                         const VkMemoryAllocateInfo* pAllocateInfo,
                                         const VkAllocationCallbacks* pAllocator,
                                         VkDeviceMemory* pMemory) {
    mImpl->vkAllocateMemory(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                            pAllocateInfo, pAllocator, pMemory);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkFreeMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkDevice device,
                                     VkDeviceMemory memory,
                                     const VkAllocationCallbacks* pAllocator) {
    mImpl->vkFreeMemory(snapshotTraceBegin, snapshotTraceBytes, pool, device, memory, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkMapMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                    android::base::BumpPool* pool, VkResult input_result,
                                    VkDevice device, VkDeviceMemory memory, VkDeviceSize offset,
                                    VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) {
    mImpl->vkMapMemory(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device, memory,
                       offset, size, flags, ppData);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkUnmapMemory(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkDevice device,
                                      VkDeviceMemory memory) {
    mImpl->vkUnmapMemory(snapshotTraceBegin, snapshotTraceBytes, pool, device, memory);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkFlushMappedMemoryRanges(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkResult input_result, VkDevice device,
                                                  uint32_t memoryRangeCount,
                                                  const VkMappedMemoryRange* pMemoryRanges) {
    mImpl->vkFlushMappedMemoryRanges(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                     device, memoryRangeCount, pMemoryRanges);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkInvalidateMappedMemoryRanges(const uint8_t* snapshotTraceBegin,
                                                       size_t snapshotTraceBytes,
                                                       android::base::BumpPool* pool,
                                                       VkResult input_result, VkDevice device,
                                                       uint32_t memoryRangeCount,
                                                       const VkMappedMemoryRange* pMemoryRanges) {
    mImpl->vkInvalidateMappedMemoryRanges(snapshotTraceBegin, snapshotTraceBytes, pool,
                                          input_result, device, memoryRangeCount, pMemoryRanges);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetDeviceMemoryCommitment(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool, VkDevice device,
                                                    VkDeviceMemory memory,
                                                    VkDeviceSize* pCommittedMemoryInBytes) {
    mImpl->vkGetDeviceMemoryCommitment(snapshotTraceBegin, snapshotTraceBytes, pool, device, memory,
                                       pCommittedMemoryInBytes);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkBindBufferMemory(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device, VkBuffer buffer,
                                           VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    mImpl->vkBindBufferMemory(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              buffer, memory, memoryOffset);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkBindImageMemory(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device, VkImage image,
                                          VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    mImpl->vkBindImageMemory(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                             image, memory, memoryOffset);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetBufferMemoryRequirements(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkDevice device, VkBuffer buffer,
                                                      VkMemoryRequirements* pMemoryRequirements) {
    mImpl->vkGetBufferMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                         buffer, pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetImageMemoryRequirements(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool, VkDevice device,
                                                     VkImage image,
                                                     VkMemoryRequirements* pMemoryRequirements) {
    mImpl->vkGetImageMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool, device, image,
                                        pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetImageSparseMemoryRequirements(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements* pSparseMemoryRequirements) {
    mImpl->vkGetImageSparseMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                              image, pSparseMemoryRequirementCount,
                                              pSparseMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPhysicalDeviceSparseImageFormatProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type,
    VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling,
    uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) {
    mImpl->vkGetPhysicalDeviceSparseImageFormatProperties(
        snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice, format, type, samples, usage,
        tiling, pPropertyCount, pProperties);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkQueueBindSparse(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkQueue queue,
                                          uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                                          VkFence fence) {
    mImpl->vkQueueBindSparse(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, queue,
                             bindInfoCount, pBindInfo, fence);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateFence(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkResult input_result,
                                      VkDevice device, const VkFenceCreateInfo* pCreateInfo,
                                      const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    mImpl->vkCreateFence(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                         pCreateInfo, pAllocator, pFence);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyFence(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       VkFence fence, const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyFence(snapshotTraceBegin, snapshotTraceBytes, pool, device, fence, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkResetFences(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkResult input_result,
                                      VkDevice device, uint32_t fenceCount,
                                      const VkFence* pFences) {
    mImpl->vkResetFences(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                         fenceCount, pFences);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetFenceStatus(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device, VkFence fence) {
    mImpl->vkGetFenceStatus(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                            fence);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkWaitForFences(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device, uint32_t fenceCount,
                                        const VkFence* pFences, VkBool32 waitAll,
                                        uint64_t timeout) {
    mImpl->vkWaitForFences(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                           fenceCount, pFences, waitAll, timeout);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateSemaphore(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          const VkSemaphoreCreateInfo* pCreateInfo,
                                          const VkAllocationCallbacks* pAllocator,
                                          VkSemaphore* pSemaphore) {
    mImpl->vkCreateSemaphore(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                             pCreateInfo, pAllocator, pSemaphore);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroySemaphore(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device, VkSemaphore semaphore,
                                           const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroySemaphore(snapshotTraceBegin, snapshotTraceBytes, pool, device, semaphore,
                              pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkResult input_result,
                                      VkDevice device, const VkEventCreateInfo* pCreateInfo,
                                      const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) {
    mImpl->vkCreateEvent(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                         pCreateInfo, pAllocator, pEvent);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       VkEvent event, const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyEvent(snapshotTraceBegin, snapshotTraceBytes, pool, device, event, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetEventStatus(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device, VkEvent event) {
    mImpl->vkGetEventStatus(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                            event);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkSetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                   android::base::BumpPool* pool, VkResult input_result,
                                   VkDevice device, VkEvent event) {
    mImpl->vkSetEvent(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device, event);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkResetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                     android::base::BumpPool* pool, VkResult input_result,
                                     VkDevice device, VkEvent event) {
    mImpl->vkResetEvent(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device, event);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateQueryPool(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          const VkQueryPoolCreateInfo* pCreateInfo,
                                          const VkAllocationCallbacks* pAllocator,
                                          VkQueryPool* pQueryPool) {
    mImpl->vkCreateQueryPool(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                             pCreateInfo, pAllocator, pQueryPool);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyQueryPool(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device, VkQueryPool queryPool,
                                           const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyQueryPool(snapshotTraceBegin, snapshotTraceBytes, pool, device, queryPool,
                              pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetQueryPoolResults(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkDevice device, VkQueryPool queryPool,
                                              uint32_t firstQuery, uint32_t queryCount,
                                              size_t dataSize, void* pData, VkDeviceSize stride,
                                              VkQueryResultFlags flags) {
    mImpl->vkGetQueryPoolResults(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateBuffer(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkResult input_result,
                                       VkDevice device, const VkBufferCreateInfo* pCreateInfo,
                                       const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) {
    mImpl->vkCreateBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                          pCreateInfo, pAllocator, pBuffer);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyBuffer(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkDevice device, VkBuffer buffer,
                                        const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, device, buffer,
                           pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateBufferView(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           const VkBufferViewCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator,
                                           VkBufferView* pView) {
    mImpl->vkCreateBufferView(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              pCreateInfo, pAllocator, pView);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyBufferView(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            VkBufferView bufferView,
                                            const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyBufferView(snapshotTraceBegin, snapshotTraceBytes, pool, device, bufferView,
                               pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkResult input_result,
                                      VkDevice device, const VkImageCreateInfo* pCreateInfo,
                                      const VkAllocationCallbacks* pAllocator, VkImage* pImage) {
    mImpl->vkCreateImage(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                         pCreateInfo, pAllocator, pImage);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkDevice device,
                                       VkImage image, const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyImage(snapshotTraceBegin, snapshotTraceBytes, pool, device, image, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetImageSubresourceLayout(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool, VkDevice device,
                                                    VkImage image,
                                                    const VkImageSubresource* pSubresource,
                                                    VkSubresourceLayout* pLayout) {
    mImpl->vkGetImageSubresourceLayout(snapshotTraceBegin, snapshotTraceBytes, pool, device, image,
                                       pSubresource, pLayout);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateImageView(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          const VkImageViewCreateInfo* pCreateInfo,
                                          const VkAllocationCallbacks* pAllocator,
                                          VkImageView* pView) {
    mImpl->vkCreateImageView(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                             pCreateInfo, pAllocator, pView);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyImageView(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkDevice device, VkImageView imageView,
                                           const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyImageView(snapshotTraceBegin, snapshotTraceBytes, pool, device, imageView,
                              pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateShaderModule(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) {
    mImpl->vkCreateShaderModule(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                pCreateInfo, pAllocator, pShaderModule);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyShaderModule(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkDevice device,
                                              VkShaderModule shaderModule,
                                              const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyShaderModule(snapshotTraceBegin, snapshotTraceBytes, pool, device, shaderModule,
                                 pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreatePipelineCache(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) {
    mImpl->vkCreatePipelineCache(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 pCreateInfo, pAllocator, pPipelineCache);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyPipelineCache(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool, VkDevice device,
                                               VkPipelineCache pipelineCache,
                                               const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyPipelineCache(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                  pipelineCache, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetPipelineCacheData(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool, VkResult input_result,
                                               VkDevice device, VkPipelineCache pipelineCache,
                                               size_t* pDataSize, void* pData) {
    mImpl->vkGetPipelineCacheData(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, pipelineCache, pDataSize, pData);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkMergePipelineCaches(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkDevice device, VkPipelineCache dstCache,
                                              uint32_t srcCacheCount,
                                              const VkPipelineCache* pSrcCaches) {
    mImpl->vkMergePipelineCaches(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 dstCache, srcCacheCount, pSrcCaches);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateGraphicsPipelines(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount,
    const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator,
    VkPipeline* pPipelines) {
    mImpl->vkCreateGraphicsPipelines(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                     device, pipelineCache, createInfoCount, pCreateInfos,
                                     pAllocator, pPipelines);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateComputePipelines(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount,
    const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator,
    VkPipeline* pPipelines) {
    mImpl->vkCreateComputePipelines(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                    device, pipelineCache, createInfoCount, pCreateInfos,
                                    pAllocator, pPipelines);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyPipeline(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkDevice device, VkPipeline pipeline,
                                          const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyPipeline(snapshotTraceBegin, snapshotTraceBytes, pool, device, pipeline,
                             pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreatePipelineLayout(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) {
    mImpl->vkCreatePipelineLayout(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, pCreateInfo, pAllocator, pPipelineLayout);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyPipelineLayout(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool, VkDevice device,
                                                VkPipelineLayout pipelineLayout,
                                                const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyPipelineLayout(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                   pipelineLayout, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateSampler(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device,
                                        const VkSamplerCreateInfo* pCreateInfo,
                                        const VkAllocationCallbacks* pAllocator,
                                        VkSampler* pSampler) {
    mImpl->vkCreateSampler(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                           pCreateInfo, pAllocator, pSampler);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroySampler(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, VkSampler sampler,
                                         const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroySampler(snapshotTraceBegin, snapshotTraceBytes, pool, device, sampler,
                            pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateDescriptorSetLayout(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) {
    mImpl->vkCreateDescriptorSetLayout(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                       device, pCreateInfo, pAllocator, pSetLayout);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyDescriptorSetLayout(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool, VkDevice device,
                                                     VkDescriptorSetLayout descriptorSetLayout,
                                                     const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyDescriptorSetLayout(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                        descriptorSetLayout, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateDescriptorPool(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) {
    mImpl->vkCreateDescriptorPool(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, pCreateInfo, pAllocator, pDescriptorPool);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyDescriptorPool(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool, VkDevice device,
                                                VkDescriptorPool descriptorPool,
                                                const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyDescriptorPool(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                   descriptorPool, pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkResetDescriptorPool(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkDevice device, VkDescriptorPool descriptorPool,
                                              VkDescriptorPoolResetFlags flags) {
    mImpl->vkResetDescriptorPool(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 descriptorPool, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkAllocateDescriptorSets(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkResult input_result, VkDevice device,
                                                 const VkDescriptorSetAllocateInfo* pAllocateInfo,
                                                 VkDescriptorSet* pDescriptorSets) {
    mImpl->vkAllocateDescriptorSets(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                    device, pAllocateInfo, pDescriptorSets);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkFreeDescriptorSets(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkResult input_result,
                                             VkDevice device, VkDescriptorPool descriptorPool,
                                             uint32_t descriptorSetCount,
                                             const VkDescriptorSet* pDescriptorSets) {
    mImpl->vkFreeDescriptorSets(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                descriptorPool, descriptorSetCount, pDescriptorSets);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkUpdateDescriptorSets(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites,
    uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) {
    mImpl->vkUpdateDescriptorSets(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                  descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                  pDescriptorCopies);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateFramebuffer(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkFramebufferCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) {
    mImpl->vkCreateFramebuffer(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               pCreateInfo, pAllocator, pFramebuffer);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyFramebuffer(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkDevice device,
                                             VkFramebuffer framebuffer,
                                             const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyFramebuffer(snapshotTraceBegin, snapshotTraceBytes, pool, device, framebuffer,
                                pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateRenderPass(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           const VkRenderPassCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator,
                                           VkRenderPass* pRenderPass) {
    mImpl->vkCreateRenderPass(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              pCreateInfo, pAllocator, pRenderPass);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyRenderPass(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            VkRenderPass renderPass,
                                            const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyRenderPass(snapshotTraceBegin, snapshotTraceBytes, pool, device, renderPass,
                               pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkGetRenderAreaGranularity(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool, VkDevice device,
                                                   VkRenderPass renderPass,
                                                   VkExtent2D* pGranularity) {
    mImpl->vkGetRenderAreaGranularity(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                      renderPass, pGranularity);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCreateCommandPool(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) {
    mImpl->vkCreateCommandPool(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               pCreateInfo, pAllocator, pCommandPool);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkDestroyCommandPool(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkDevice device,
                                             VkCommandPool commandPool,
                                             const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyCommandPool(snapshotTraceBegin, snapshotTraceBytes, pool, device, commandPool,
                                pAllocator);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkResetCommandPool(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           VkCommandPool commandPool,
                                           VkCommandPoolResetFlags flags) {
    mImpl->vkResetCommandPool(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              commandPool, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkAllocateCommandBuffers(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkResult input_result, VkDevice device,
                                                 const VkCommandBufferAllocateInfo* pAllocateInfo,
                                                 VkCommandBuffer* pCommandBuffers) {
    mImpl->vkAllocateCommandBuffers(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                    device, pAllocateInfo, pCommandBuffers);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkFreeCommandBuffers(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkDevice device,
                                             VkCommandPool commandPool, uint32_t commandBufferCount,
                                             const VkCommandBuffer* pCommandBuffers) {
    mImpl->vkFreeCommandBuffers(snapshotTraceBegin, snapshotTraceBytes, pool, device, commandPool,
                                commandBufferCount, pCommandBuffers);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkBeginCommandBuffer(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkResult input_result,
                                             VkCommandBuffer commandBuffer,
                                             const VkCommandBufferBeginInfo* pBeginInfo) {
    mImpl->vkBeginCommandBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                commandBuffer, pBeginInfo);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkEndCommandBuffer(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkCommandBuffer commandBuffer) {
    mImpl->vkEndCommandBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                              commandBuffer);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkResetCommandBuffer(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkResult input_result,
                                             VkCommandBuffer commandBuffer,
                                             VkCommandBufferResetFlags flags) {
    mImpl->vkResetCommandBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                commandBuffer, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBindPipeline(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer,
                                          VkPipelineBindPoint pipelineBindPoint,
                                          VkPipeline pipeline) {
    mImpl->vkCmdBindPipeline(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             pipelineBindPoint, pipeline);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetViewport(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer, uint32_t firstViewport,
                                         uint32_t viewportCount, const VkViewport* pViewports) {
    mImpl->vkCmdSetViewport(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                            firstViewport, viewportCount, pViewports);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetScissor(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, uint32_t firstScissor,
                                        uint32_t scissorCount, const VkRect2D* pScissors) {
    mImpl->vkCmdSetScissor(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                           firstScissor, scissorCount, pScissors);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetLineWidth(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, float lineWidth) {
    mImpl->vkCmdSetLineWidth(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             lineWidth);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetDepthBias(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer,
                                          float depthBiasConstantFactor, float depthBiasClamp,
                                          float depthBiasSlopeFactor) {
    mImpl->vkCmdSetDepthBias(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetBlendConstants(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool,
                                               VkCommandBuffer commandBuffer,
                                               const float blendConstants[4]) {
    mImpl->vkCmdSetBlendConstants(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  blendConstants);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetDepthBounds(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer, float minDepthBounds,
                                            float maxDepthBounds) {
    mImpl->vkCmdSetDepthBounds(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               minDepthBounds, maxDepthBounds);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetStencilCompareMask(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) {
    mImpl->vkCmdSetStencilCompareMask(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      faceMask, compareMask);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetStencilWriteMask(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 VkStencilFaceFlags faceMask, uint32_t writeMask) {
    mImpl->vkCmdSetStencilWriteMask(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    faceMask, writeMask);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetStencilReference(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 VkStencilFaceFlags faceMask, uint32_t reference) {
    mImpl->vkCmdSetStencilReference(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    faceMask, reference);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBindDescriptorSets(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout,
    uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets,
    uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) {
    mImpl->vkCmdBindDescriptorSets(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                   pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBindIndexBuffer(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer, VkBuffer buffer,
                                             VkDeviceSize offset, VkIndexType indexType) {
    mImpl->vkCmdBindIndexBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, buffer,
                                offset, indexType);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBindVertexBuffers(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool,
                                               VkCommandBuffer commandBuffer, uint32_t firstBinding,
                                               uint32_t bindingCount, const VkBuffer* pBuffers,
                                               const VkDeviceSize* pOffsets) {
    mImpl->vkCmdBindVertexBuffers(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  firstBinding, bindingCount, pBuffers, pOffsets);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDraw(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                  android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                  uint32_t vertexCount, uint32_t instanceCount,
                                  uint32_t firstVertex, uint32_t firstInstance) {
    mImpl->vkCmdDraw(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, vertexCount,
                     instanceCount, firstVertex, firstInstance);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDrawIndexed(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer, uint32_t indexCount,
                                         uint32_t instanceCount, uint32_t firstIndex,
                                         int32_t vertexOffset, uint32_t firstInstance) {
    mImpl->vkCmdDrawIndexed(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, indexCount,
                            instanceCount, firstIndex, vertexOffset, firstInstance);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDrawIndirect(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, VkBuffer buffer,
                                          VkDeviceSize offset, uint32_t drawCount,
                                          uint32_t stride) {
    mImpl->vkCmdDrawIndirect(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, buffer,
                             offset, drawCount, stride);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDrawIndexedIndirect(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer, VkBuffer buffer,
                                                 VkDeviceSize offset, uint32_t drawCount,
                                                 uint32_t stride) {
    mImpl->vkCmdDrawIndexedIndirect(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    buffer, offset, drawCount, stride);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDispatch(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      uint32_t groupCountX, uint32_t groupCountY,
                                      uint32_t groupCountZ) {
    mImpl->vkCmdDispatch(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, groupCountX,
                         groupCountY, groupCountZ);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdDispatchIndirect(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              VkCommandBuffer commandBuffer, VkBuffer buffer,
                                              VkDeviceSize offset) {
    mImpl->vkCmdDispatchIndirect(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                 buffer, offset);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdCopyBuffer(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, VkBuffer srcBuffer,
                                        VkBuffer dstBuffer, uint32_t regionCount,
                                        const VkBufferCopy* pRegions) {
    mImpl->vkCmdCopyBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, srcBuffer,
                           dstBuffer, regionCount, pRegions);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdCopyImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       VkImage srcImage, VkImageLayout srcImageLayout,
                                       VkImage dstImage, VkImageLayout dstImageLayout,
                                       uint32_t regionCount, const VkImageCopy* pRegions) {
    mImpl->vkCmdCopyImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, srcImage,
                          srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBlitImage(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       VkImage srcImage, VkImageLayout srcImageLayout,
                                       VkImage dstImage, VkImageLayout dstImageLayout,
                                       uint32_t regionCount, const VkImageBlit* pRegions,
                                       VkFilter filter) {
    mImpl->vkCmdBlitImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, srcImage,
                          srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdCopyBufferToImage(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage,
    VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    mImpl->vkCmdCopyBufferToImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdCopyImageToBuffer(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
    VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    mImpl->vkCmdCopyImageToBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdUpdateBuffer(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, VkBuffer dstBuffer,
                                          VkDeviceSize dstOffset, VkDeviceSize dataSize,
                                          const void* pData) {
    mImpl->vkCmdUpdateBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, dstBuffer,
                             dstOffset, dataSize, pData);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdFillBuffer(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, VkBuffer dstBuffer,
                                        VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) {
    mImpl->vkCmdFillBuffer(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, dstBuffer,
                           dstOffset, size, data);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdClearColorImage(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
    const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) {
    mImpl->vkCmdClearColorImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, image,
                                imageLayout, pColor, rangeCount, pRanges);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdClearDepthStencilImage(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
    const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount,
    const VkImageSubresourceRange* pRanges) {
    mImpl->vkCmdClearDepthStencilImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                       image, imageLayout, pDepthStencil, rangeCount, pRanges);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdClearAttachments(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments,
    uint32_t rectCount, const VkClearRect* pRects) {
    mImpl->vkCmdClearAttachments(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                 attachmentCount, pAttachments, rectCount, pRects);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdResolveImage(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, VkImage srcImage,
                                          VkImageLayout srcImageLayout, VkImage dstImage,
                                          VkImageLayout dstImageLayout, uint32_t regionCount,
                                          const VkImageResolve* pRegions) {
    mImpl->vkCmdResolveImage(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, srcImage,
                             srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdSetEvent(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      VkEvent event, VkPipelineStageFlags stageMask) {
    mImpl->vkCmdSetEvent(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                         stageMask);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdResetEvent(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, VkEvent event,
                                        VkPipelineStageFlags stageMask) {
    mImpl->vkCmdResetEvent(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                           stageMask);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdWaitEvents(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
    VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
    uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
    uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    mImpl->vkCmdWaitEvents(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, eventCount,
                           pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers,
                           bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount,
                           pImageMemoryBarriers);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdPipelineBarrier(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask,
    VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags,
    uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
    uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
    uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    mImpl->vkCmdPipelineBarrier(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                imageMemoryBarrierCount, pImageMemoryBarriers);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBeginQuery(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer, VkQueryPool queryPool,
                                        uint32_t query, VkQueryControlFlags flags) {
    mImpl->vkCmdBeginQuery(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, queryPool,
                           query, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdEndQuery(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                      android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                      VkQueryPool queryPool, uint32_t query) {
    mImpl->vkCmdEndQuery(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, queryPool,
                         query);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdResetQueryPool(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer, VkQueryPool queryPool,
                                            uint32_t firstQuery, uint32_t queryCount) {
    mImpl->vkCmdResetQueryPool(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               queryPool, firstQuery, queryCount);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdWriteTimestamp(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            VkPipelineStageFlagBits pipelineStage,
                                            VkQueryPool queryPool, uint32_t query) {
    mImpl->vkCmdWriteTimestamp(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               pipelineStage, queryPool, query);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdCopyQueryPoolResults(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount,
    VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) {
    mImpl->vkCmdCopyQueryPoolResults(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     queryPool, firstQuery, queryCount, dstBuffer, dstOffset,
                                     stride, flags);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdPushConstants(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer, VkPipelineLayout layout,
                                           VkShaderStageFlags stageFlags, uint32_t offset,
                                           uint32_t size, const void* pValues) {
    mImpl->vkCmdPushConstants(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, layout,
                              stageFlags, offset, size, pValues);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdBeginRenderPass(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer,
                                             const VkRenderPassBeginInfo* pRenderPassBegin,
                                             VkSubpassContents contents) {
    mImpl->vkCmdBeginRenderPass(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                pRenderPassBegin, contents);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdNextSubpass(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer,
                                         VkSubpassContents contents) {
    mImpl->vkCmdNextSubpass(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, contents);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdEndRenderPass(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer) {
    mImpl->vkCmdEndRenderPass(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer);
}
#endif
#ifdef VK_VERSION_1_0
void VkDecoderSnapshot::vkCmdExecuteCommands(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer,
                                             uint32_t commandBufferCount,
                                             const VkCommandBuffer* pCommandBuffers) {
    mImpl->vkCmdExecuteCommands(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                commandBufferCount, pCommandBuffers);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkEnumerateInstanceVersion(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkResult input_result, uint32_t* pApiVersion) {
    mImpl->vkEnumerateInstanceVersion(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                      pApiVersion);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkBindBufferMemory2(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkResult input_result,
                                            VkDevice device, uint32_t bindInfoCount,
                                            const VkBindBufferMemoryInfo* pBindInfos) {
    mImpl->vkBindBufferMemory2(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               bindInfoCount, pBindInfos);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkBindImageMemory2(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           uint32_t bindInfoCount,
                                           const VkBindImageMemoryInfo* pBindInfos) {
    mImpl->vkBindImageMemory2(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              bindInfoCount, pBindInfos);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetDeviceGroupPeerMemoryFeatures(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex,
    VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    mImpl->vkGetDeviceGroupPeerMemoryFeatures(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                              heapIndex, localDeviceIndex, remoteDeviceIndex,
                                              pPeerMemoryFeatures);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkCmdSetDeviceMask(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    mImpl->vkCmdSetDeviceMask(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                              deviceMask);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkCmdDispatchBase(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, uint32_t baseGroupX,
                                          uint32_t baseGroupY, uint32_t baseGroupZ,
                                          uint32_t groupCountX, uint32_t groupCountY,
                                          uint32_t groupCountZ) {
    mImpl->vkCmdDispatchBase(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                             groupCountZ);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkEnumeratePhysicalDeviceGroups(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
    VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    mImpl->vkEnumeratePhysicalDeviceGroups(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           input_result, instance, pPhysicalDeviceGroupCount,
                                           pPhysicalDeviceGroupProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetImageMemoryRequirements2(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkDevice device,
                                                      const VkImageMemoryRequirementsInfo2* pInfo,
                                                      VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetImageMemoryRequirements2(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                         pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetBufferMemoryRequirements2(const uint8_t* snapshotTraceBegin,
                                                       size_t snapshotTraceBytes,
                                                       android::base::BumpPool* pool,
                                                       VkDevice device,
                                                       const VkBufferMemoryRequirementsInfo2* pInfo,
                                                       VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetBufferMemoryRequirements2(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                          pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetImageSparseMemoryRequirements2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    mImpl->vkGetImageSparseMemoryRequirements2(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                               pInfo, pSparseMemoryRequirementCount,
                                               pSparseMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceFeatures2(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool,
                                                     VkPhysicalDevice physicalDevice,
                                                     VkPhysicalDeviceFeatures2* pFeatures) {
    mImpl->vkGetPhysicalDeviceFeatures2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                        physicalDevice, pFeatures);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceProperties2(const uint8_t* snapshotTraceBegin,
                                                       size_t snapshotTraceBytes,
                                                       android::base::BumpPool* pool,
                                                       VkPhysicalDevice physicalDevice,
                                                       VkPhysicalDeviceProperties2* pProperties) {
    mImpl->vkGetPhysicalDeviceProperties2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                          physicalDevice, pProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceFormatProperties2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) {
    mImpl->vkGetPhysicalDeviceFormatProperties2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                physicalDevice, format, pFormatProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceImageFormatProperties2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
    VkImageFormatProperties2* pImageFormatProperties) {
    mImpl->vkGetPhysicalDeviceImageFormatProperties2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                     input_result, physicalDevice, pImageFormatInfo,
                                                     pImageFormatProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceQueueFamilyProperties2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties2* pQueueFamilyProperties) {
    mImpl->vkGetPhysicalDeviceQueueFamilyProperties2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                     physicalDevice, pQueueFamilyPropertyCount,
                                                     pQueueFamilyProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceMemoryProperties2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    mImpl->vkGetPhysicalDeviceMemoryProperties2(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                physicalDevice, pMemoryProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceSparseImageFormatProperties2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
    uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
    mImpl->vkGetPhysicalDeviceSparseImageFormatProperties2(snapshotTraceBegin, snapshotTraceBytes,
                                                           pool, physicalDevice, pFormatInfo,
                                                           pPropertyCount, pProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkTrimCommandPool(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkDevice device, VkCommandPool commandPool,
                                          VkCommandPoolTrimFlags flags) {
    mImpl->vkTrimCommandPool(snapshotTraceBegin, snapshotTraceBytes, pool, device, commandPool,
                             flags);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetDeviceQueue2(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkDevice device, const VkDeviceQueueInfo2* pQueueInfo,
                                          VkQueue* pQueue) {
    mImpl->vkGetDeviceQueue2(snapshotTraceBegin, snapshotTraceBytes, pool, device, pQueueInfo,
                             pQueue);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkCreateSamplerYcbcrConversion(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) {
    mImpl->vkCreateSamplerYcbcrConversion(snapshotTraceBegin, snapshotTraceBytes, pool,
                                          input_result, device, pCreateInfo, pAllocator,
                                          pYcbcrConversion);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkDestroySamplerYcbcrConversion(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        VkDevice device,
                                                        VkSamplerYcbcrConversion ycbcrConversion,
                                                        const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroySamplerYcbcrConversion(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                           ycbcrConversion, pAllocator);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkCreateDescriptorUpdateTemplate(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    mImpl->vkCreateDescriptorUpdateTemplate(snapshotTraceBegin, snapshotTraceBytes, pool,
                                            input_result, device, pCreateInfo, pAllocator,
                                            pDescriptorUpdateTemplate);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkDestroyDescriptorUpdateTemplate(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyDescriptorUpdateTemplate(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                             descriptorUpdateTemplate, pAllocator);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkUpdateDescriptorSetWithTemplate(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    mImpl->vkUpdateDescriptorSetWithTemplate(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                             descriptorSet, descriptorUpdateTemplate, pData);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalBufferProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties) {
    mImpl->vkGetPhysicalDeviceExternalBufferProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                       physicalDevice, pExternalBufferInfo,
                                                       pExternalBufferProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalFenceProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
    VkExternalFenceProperties* pExternalFenceProperties) {
    mImpl->vkGetPhysicalDeviceExternalFenceProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                      physicalDevice, pExternalFenceInfo,
                                                      pExternalFenceProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalSemaphoreProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    mImpl->vkGetPhysicalDeviceExternalSemaphoreProperties(
        snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice, pExternalSemaphoreInfo,
        pExternalSemaphoreProperties);
}
#endif
#ifdef VK_VERSION_1_1
void VkDecoderSnapshot::vkGetDescriptorSetLayoutSupport(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    VkDescriptorSetLayoutSupport* pSupport) {
    mImpl->vkGetDescriptorSetLayoutSupport(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                           pCreateInfo, pSupport);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCmdDrawIndirectCount(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer,
    VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    mImpl->vkCmdDrawIndirectCount(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                  stride);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCmdDrawIndexedIndirectCount(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer,
    VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    mImpl->vkCmdDrawIndexedIndirectCount(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer, buffer, offset, countBuffer,
                                         countBufferOffset, maxDrawCount, stride);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCreateRenderPass2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    mImpl->vkCreateRenderPass2(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               pCreateInfo, pAllocator, pRenderPass);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCmdBeginRenderPass2(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              VkCommandBuffer commandBuffer,
                                              const VkRenderPassBeginInfo* pRenderPassBegin,
                                              const VkSubpassBeginInfo* pSubpassBeginInfo) {
    mImpl->vkCmdBeginRenderPass2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                 pRenderPassBegin, pSubpassBeginInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCmdNextSubpass2(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer,
                                          const VkSubpassBeginInfo* pSubpassBeginInfo,
                                          const VkSubpassEndInfo* pSubpassEndInfo) {
    mImpl->vkCmdNextSubpass2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             pSubpassBeginInfo, pSubpassEndInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkCmdEndRenderPass2(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            const VkSubpassEndInfo* pSubpassEndInfo) {
    mImpl->vkCmdEndRenderPass2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               pSubpassEndInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkResetQueryPool(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, VkQueryPool queryPool,
                                         uint32_t firstQuery, uint32_t queryCount) {
    mImpl->vkResetQueryPool(snapshotTraceBegin, snapshotTraceBytes, pool, device, queryPool,
                            firstQuery, queryCount);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkGetSemaphoreCounterValue(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkResult input_result, VkDevice device,
                                                   VkSemaphore semaphore, uint64_t* pValue) {
    mImpl->vkGetSemaphoreCounterValue(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                      device, semaphore, pValue);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkWaitSemaphores(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device,
                                         const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    mImpl->vkWaitSemaphores(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                            pWaitInfo, timeout);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkSignalSemaphore(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkDevice device,
                                          const VkSemaphoreSignalInfo* pSignalInfo) {
    mImpl->vkSignalSemaphore(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                             pSignalInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkGetBufferDeviceAddress(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkDeviceAddress input_result, VkDevice device,
                                                 const VkBufferDeviceAddressInfo* pInfo) {
    mImpl->vkGetBufferDeviceAddress(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                    device, pInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkGetBufferOpaqueCaptureAddress(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        uint64_t input_result, VkDevice device,
                                                        const VkBufferDeviceAddressInfo* pInfo) {
    mImpl->vkGetBufferOpaqueCaptureAddress(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           input_result, device, pInfo);
}
#endif
#ifdef VK_VERSION_1_2
void VkDecoderSnapshot::vkGetDeviceMemoryOpaqueCaptureAddress(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    uint64_t input_result, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    mImpl->vkGetDeviceMemoryOpaqueCaptureAddress(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                 input_result, device, pInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkGetPhysicalDeviceToolProperties(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice, uint32_t* pToolCount,
    VkPhysicalDeviceToolProperties* pToolProperties) {
    mImpl->vkGetPhysicalDeviceToolProperties(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             input_result, physicalDevice, pToolCount,
                                             pToolProperties);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCreatePrivateDataSlot(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    mImpl->vkCreatePrivateDataSlot(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                   device, pCreateInfo, pAllocator, pPrivateDataSlot);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkDestroyPrivateDataSlot(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool, VkDevice device,
                                                 VkPrivateDataSlot privateDataSlot,
                                                 const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyPrivateDataSlot(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                    privateDataSlot, pAllocator);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkSetPrivateData(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkResult input_result, VkDevice device,
                                         VkObjectType objectType, uint64_t objectHandle,
                                         VkPrivateDataSlot privateDataSlot, uint64_t data) {
    mImpl->vkSetPrivateData(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                            objectType, objectHandle, privateDataSlot, data);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkGetPrivateData(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkDevice device, VkObjectType objectType,
                                         uint64_t objectHandle, VkPrivateDataSlot privateDataSlot,
                                         uint64_t* pData) {
    mImpl->vkGetPrivateData(snapshotTraceBegin, snapshotTraceBytes, pool, device, objectType,
                            objectHandle, privateDataSlot, pData);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetEvent2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkCommandBuffer commandBuffer,
                                       VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    mImpl->vkCmdSetEvent2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                          pDependencyInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdResetEvent2(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer, VkEvent event,
                                         VkPipelineStageFlags2 stageMask) {
    mImpl->vkCmdResetEvent2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                            stageMask);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdWaitEvents2(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer, uint32_t eventCount,
                                         const VkEvent* pEvents,
                                         const VkDependencyInfo* pDependencyInfos) {
    mImpl->vkCmdWaitEvents2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, eventCount,
                            pEvents, pDependencyInfos);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdPipelineBarrier2(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              VkCommandBuffer commandBuffer,
                                              const VkDependencyInfo* pDependencyInfo) {
    mImpl->vkCmdPipelineBarrier2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                 pDependencyInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdWriteTimestamp2(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer,
                                             VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                             uint32_t query) {
    mImpl->vkCmdWriteTimestamp2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, stage,
                                queryPool, query);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkQueueSubmit2(const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes,
                                       android::base::BumpPool* pool, VkResult input_result,
                                       VkQueue queue, uint32_t submitCount,
                                       const VkSubmitInfo2* pSubmits, VkFence fence) {
    mImpl->vkQueueSubmit2(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, queue,
                          submitCount, pSubmits, fence);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdCopyBuffer2(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer,
                                         const VkCopyBufferInfo2* pCopyBufferInfo) {
    mImpl->vkCmdCopyBuffer2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                            pCopyBufferInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdCopyImage2(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer,
                                        const VkCopyImageInfo2* pCopyImageInfo) {
    mImpl->vkCmdCopyImage2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                           pCopyImageInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdCopyBufferToImage2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    mImpl->vkCmdCopyBufferToImage2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   pCopyBufferToImageInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdCopyImageToBuffer2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    mImpl->vkCmdCopyImageToBuffer2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   pCopyImageToBufferInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdBlitImage2(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkCommandBuffer commandBuffer,
                                        const VkBlitImageInfo2* pBlitImageInfo) {
    mImpl->vkCmdBlitImage2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                           pBlitImageInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdResolveImage2(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer,
                                           const VkResolveImageInfo2* pResolveImageInfo) {
    mImpl->vkCmdResolveImage2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                              pResolveImageInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdBeginRendering(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            const VkRenderingInfo* pRenderingInfo) {
    mImpl->vkCmdBeginRendering(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               pRenderingInfo);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdEndRendering(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer) {
    mImpl->vkCmdEndRendering(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetCullMode(const uint8_t* snapshotTraceBegin,
                                         size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                         VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    mImpl->vkCmdSetCullMode(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, cullMode);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetFrontFace(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    mImpl->vkCmdSetFrontFace(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                             frontFace);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetPrimitiveTopology(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkCommandBuffer commandBuffer,
                                                  VkPrimitiveTopology primitiveTopology) {
    mImpl->vkCmdSetPrimitiveTopology(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     primitiveTopology);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetViewportWithCount(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) {
    mImpl->vkCmdSetViewportWithCount(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     viewportCount, pViewports);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetScissorWithCount(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 uint32_t scissorCount, const VkRect2D* pScissors) {
    mImpl->vkCmdSetScissorWithCount(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    scissorCount, pScissors);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdBindVertexBuffers2(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
    const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes,
    const VkDeviceSize* pStrides) {
    mImpl->vkCmdBindVertexBuffers2(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                   pStrides);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetDepthTestEnable(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool,
                                                VkCommandBuffer commandBuffer,
                                                VkBool32 depthTestEnable) {
    mImpl->vkCmdSetDepthTestEnable(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   depthTestEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetDepthWriteEnable(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 VkBool32 depthWriteEnable) {
    mImpl->vkCmdSetDepthWriteEnable(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    depthWriteEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetDepthCompareOp(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool,
                                               VkCommandBuffer commandBuffer,
                                               VkCompareOp depthCompareOp) {
    mImpl->vkCmdSetDepthCompareOp(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  depthCompareOp);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetDepthBoundsTestEnable(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkCommandBuffer commandBuffer,
                                                      VkBool32 depthBoundsTestEnable) {
    mImpl->vkCmdSetDepthBoundsTestEnable(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer, depthBoundsTestEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetStencilTestEnable(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkCommandBuffer commandBuffer,
                                                  VkBool32 stencilTestEnable) {
    mImpl->vkCmdSetStencilTestEnable(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     stencilTestEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetStencilOp(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer,
                                          VkStencilFaceFlags faceMask, VkStencilOp failOp,
                                          VkStencilOp passOp, VkStencilOp depthFailOp,
                                          VkCompareOp compareOp) {
    mImpl->vkCmdSetStencilOp(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, faceMask,
                             failOp, passOp, depthFailOp, compareOp);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetRasterizerDiscardEnable(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        VkCommandBuffer commandBuffer,
                                                        VkBool32 rasterizerDiscardEnable) {
    mImpl->vkCmdSetRasterizerDiscardEnable(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           commandBuffer, rasterizerDiscardEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetDepthBiasEnable(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool,
                                                VkCommandBuffer commandBuffer,
                                                VkBool32 depthBiasEnable) {
    mImpl->vkCmdSetDepthBiasEnable(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   depthBiasEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkCmdSetPrimitiveRestartEnable(const uint8_t* snapshotTraceBegin,
                                                       size_t snapshotTraceBytes,
                                                       android::base::BumpPool* pool,
                                                       VkCommandBuffer commandBuffer,
                                                       VkBool32 primitiveRestartEnable) {
    mImpl->vkCmdSetPrimitiveRestartEnable(snapshotTraceBegin, snapshotTraceBytes, pool,
                                          commandBuffer, primitiveRestartEnable);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkGetDeviceBufferMemoryRequirements(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetDeviceBufferMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                               pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkGetDeviceImageMemoryRequirements(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetDeviceImageMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                              pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_VERSION_1_3
void VkDecoderSnapshot::vkGetDeviceImageSparseMemoryRequirements(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    mImpl->vkGetDeviceImageSparseMemoryRequirements(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                    device, pInfo, pSparseMemoryRequirementCount,
                                                    pSparseMemoryRequirements);
}
#endif
#ifdef VK_KHR_dynamic_rendering
void VkDecoderSnapshot::vkCmdBeginRenderingKHR(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool,
                                               VkCommandBuffer commandBuffer,
                                               const VkRenderingInfo* pRenderingInfo) {
    mImpl->vkCmdBeginRenderingKHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  pRenderingInfo);
}
#endif
#ifdef VK_KHR_dynamic_rendering
void VkDecoderSnapshot::vkCmdEndRenderingKHR(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer) {
    mImpl->vkCmdEndRenderingKHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceFeatures2KHR(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        VkPhysicalDevice physicalDevice,
                                                        VkPhysicalDeviceFeatures2* pFeatures) {
    mImpl->vkGetPhysicalDeviceFeatures2KHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           physicalDevice, pFeatures);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) {
    mImpl->vkGetPhysicalDeviceProperties2KHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             physicalDevice, pProperties);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceFormatProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) {
    mImpl->vkGetPhysicalDeviceFormatProperties2KHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                   physicalDevice, format, pFormatProperties);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceImageFormatProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
    VkImageFormatProperties2* pImageFormatProperties) {
    mImpl->vkGetPhysicalDeviceImageFormatProperties2KHR(snapshotTraceBegin, snapshotTraceBytes,
                                                        pool, input_result, physicalDevice,
                                                        pImageFormatInfo, pImageFormatProperties);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceQueueFamilyProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount,
    VkQueueFamilyProperties2* pQueueFamilyProperties) {
    mImpl->vkGetPhysicalDeviceQueueFamilyProperties2KHR(
        snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice, pQueueFamilyPropertyCount,
        pQueueFamilyProperties);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceMemoryProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    mImpl->vkGetPhysicalDeviceMemoryProperties2KHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                   physicalDevice, pMemoryProperties);
}
#endif
#ifdef VK_KHR_get_physical_device_properties2
void VkDecoderSnapshot::vkGetPhysicalDeviceSparseImageFormatProperties2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
    uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
    mImpl->vkGetPhysicalDeviceSparseImageFormatProperties2KHR(
        snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice, pFormatInfo, pPropertyCount,
        pProperties);
}
#endif
#ifdef VK_KHR_maintenance1
void VkDecoderSnapshot::vkTrimCommandPoolKHR(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool, VkDevice device,
                                             VkCommandPool commandPool,
                                             VkCommandPoolTrimFlags flags) {
    mImpl->vkTrimCommandPoolKHR(snapshotTraceBegin, snapshotTraceBytes, pool, device, commandPool,
                                flags);
}
#endif
#ifdef VK_KHR_external_memory_capabilities
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalBufferPropertiesKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties) {
    mImpl->vkGetPhysicalDeviceExternalBufferPropertiesKHR(snapshotTraceBegin, snapshotTraceBytes,
                                                          pool, physicalDevice, pExternalBufferInfo,
                                                          pExternalBufferProperties);
}
#endif
#ifdef VK_KHR_external_semaphore_capabilities
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice,
    const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    mImpl->vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(
        snapshotTraceBegin, snapshotTraceBytes, pool, physicalDevice, pExternalSemaphoreInfo,
        pExternalSemaphoreProperties);
}
#endif
#ifdef VK_KHR_external_semaphore_fd
void VkDecoderSnapshot::vkImportSemaphoreFdKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device,
    const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) {
    mImpl->vkImportSemaphoreFdKHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, pImportSemaphoreFdInfo);
}
#endif
#ifdef VK_KHR_external_semaphore_fd
void VkDecoderSnapshot::vkGetSemaphoreFdKHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkResult input_result,
                                            VkDevice device,
                                            const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) {
    mImpl->vkGetSemaphoreFdKHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               pGetFdInfo, pFd);
}
#endif
#ifdef VK_KHR_descriptor_update_template
void VkDecoderSnapshot::vkCreateDescriptorUpdateTemplateKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator,
    VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    mImpl->vkCreateDescriptorUpdateTemplateKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                               input_result, device, pCreateInfo, pAllocator,
                                               pDescriptorUpdateTemplate);
}
#endif
#ifdef VK_KHR_descriptor_update_template
void VkDecoderSnapshot::vkDestroyDescriptorUpdateTemplateKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
    const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyDescriptorUpdateTemplateKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                device, descriptorUpdateTemplate, pAllocator);
}
#endif
#ifdef VK_KHR_descriptor_update_template
void VkDecoderSnapshot::vkUpdateDescriptorSetWithTemplateKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    mImpl->vkUpdateDescriptorSetWithTemplateKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                device, descriptorSet, descriptorUpdateTemplate,
                                                pData);
}
#endif
#ifdef VK_KHR_create_renderpass2
void VkDecoderSnapshot::vkCreateRenderPass2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    mImpl->vkCreateRenderPass2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, pCreateInfo, pAllocator, pRenderPass);
}
#endif
#ifdef VK_KHR_create_renderpass2
void VkDecoderSnapshot::vkCmdBeginRenderPass2KHR(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 const VkRenderPassBeginInfo* pRenderPassBegin,
                                                 const VkSubpassBeginInfo* pSubpassBeginInfo) {
    mImpl->vkCmdBeginRenderPass2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    pRenderPassBegin, pSubpassBeginInfo);
}
#endif
#ifdef VK_KHR_create_renderpass2
void VkDecoderSnapshot::vkCmdNextSubpass2KHR(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer,
                                             const VkSubpassBeginInfo* pSubpassBeginInfo,
                                             const VkSubpassEndInfo* pSubpassEndInfo) {
    mImpl->vkCmdNextSubpass2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                pSubpassBeginInfo, pSubpassEndInfo);
}
#endif
#ifdef VK_KHR_create_renderpass2
void VkDecoderSnapshot::vkCmdEndRenderPass2KHR(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool,
                                               VkCommandBuffer commandBuffer,
                                               const VkSubpassEndInfo* pSubpassEndInfo) {
    mImpl->vkCmdEndRenderPass2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  pSubpassEndInfo);
}
#endif
#ifdef VK_KHR_external_fence_capabilities
void VkDecoderSnapshot::vkGetPhysicalDeviceExternalFencePropertiesKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
    VkExternalFenceProperties* pExternalFenceProperties) {
    mImpl->vkGetPhysicalDeviceExternalFencePropertiesKHR(snapshotTraceBegin, snapshotTraceBytes,
                                                         pool, physicalDevice, pExternalFenceInfo,
                                                         pExternalFenceProperties);
}
#endif
#ifdef VK_KHR_external_fence_fd
void VkDecoderSnapshot::vkImportFenceFdKHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkResult input_result, VkDevice device,
                                           const VkImportFenceFdInfoKHR* pImportFenceFdInfo) {
    mImpl->vkImportFenceFdKHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                              pImportFenceFdInfo);
}
#endif
#ifdef VK_KHR_external_fence_fd
void VkDecoderSnapshot::vkGetFenceFdKHR(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device,
                                        const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) {
    mImpl->vkGetFenceFdKHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                           pGetFdInfo, pFd);
}
#endif
#ifdef VK_KHR_get_memory_requirements2
void VkDecoderSnapshot::vkGetImageMemoryRequirements2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetImageMemoryRequirements2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                            pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_KHR_get_memory_requirements2
void VkDecoderSnapshot::vkGetBufferMemoryRequirements2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetBufferMemoryRequirements2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                             pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_KHR_get_memory_requirements2
void VkDecoderSnapshot::vkGetImageSparseMemoryRequirements2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    mImpl->vkGetImageSparseMemoryRequirements2KHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                  device, pInfo, pSparseMemoryRequirementCount,
                                                  pSparseMemoryRequirements);
}
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
void VkDecoderSnapshot::vkCreateSamplerYcbcrConversionKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) {
    mImpl->vkCreateSamplerYcbcrConversionKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             input_result, device, pCreateInfo, pAllocator,
                                             pYcbcrConversion);
}
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
void VkDecoderSnapshot::vkDestroySamplerYcbcrConversionKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
    const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroySamplerYcbcrConversionKHR(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                              ycbcrConversion, pAllocator);
}
#endif
#ifdef VK_KHR_bind_memory2
void VkDecoderSnapshot::vkBindBufferMemory2KHR(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool, VkResult input_result,
                                               VkDevice device, uint32_t bindInfoCount,
                                               const VkBindBufferMemoryInfo* pBindInfos) {
    mImpl->vkBindBufferMemory2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, bindInfoCount, pBindInfos);
}
#endif
#ifdef VK_KHR_bind_memory2
void VkDecoderSnapshot::vkBindImageMemory2KHR(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkDevice device, uint32_t bindInfoCount,
                                              const VkBindImageMemoryInfo* pBindInfos) {
    mImpl->vkBindImageMemory2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 bindInfoCount, pBindInfos);
}
#endif
#ifdef VK_KHR_maintenance3
void VkDecoderSnapshot::vkGetDescriptorSetLayoutSupportKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
    VkDescriptorSetLayoutSupport* pSupport) {
    mImpl->vkGetDescriptorSetLayoutSupportKHR(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                              pCreateInfo, pSupport);
}
#endif
#ifdef VK_KHR_buffer_device_address
void VkDecoderSnapshot::vkGetBufferDeviceAddressKHR(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool,
                                                    VkDeviceAddress input_result, VkDevice device,
                                                    const VkBufferDeviceAddressInfo* pInfo) {
    mImpl->vkGetBufferDeviceAddressKHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                       device, pInfo);
}
#endif
#ifdef VK_KHR_buffer_device_address
void VkDecoderSnapshot::vkGetBufferOpaqueCaptureAddressKHR(const uint8_t* snapshotTraceBegin,
                                                           size_t snapshotTraceBytes,
                                                           android::base::BumpPool* pool,
                                                           uint64_t input_result, VkDevice device,
                                                           const VkBufferDeviceAddressInfo* pInfo) {
    mImpl->vkGetBufferOpaqueCaptureAddressKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                              input_result, device, pInfo);
}
#endif
#ifdef VK_KHR_buffer_device_address
void VkDecoderSnapshot::vkGetDeviceMemoryOpaqueCaptureAddressKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    uint64_t input_result, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    mImpl->vkGetDeviceMemoryOpaqueCaptureAddressKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                    input_result, device, pInfo);
}
#endif
#ifdef VK_KHR_pipeline_executable_properties
void VkDecoderSnapshot::vkGetPipelineExecutablePropertiesKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPipelineInfoKHR* pPipelineInfo,
    uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) {
    mImpl->vkGetPipelineExecutablePropertiesKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                input_result, device, pPipelineInfo,
                                                pExecutableCount, pProperties);
}
#endif
#ifdef VK_KHR_pipeline_executable_properties
void VkDecoderSnapshot::vkGetPipelineExecutableStatisticsKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo,
    uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) {
    mImpl->vkGetPipelineExecutableStatisticsKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                input_result, device, pExecutableInfo,
                                                pStatisticCount, pStatistics);
}
#endif
#ifdef VK_KHR_pipeline_executable_properties
void VkDecoderSnapshot::vkGetPipelineExecutableInternalRepresentationsKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo,
    uint32_t* pInternalRepresentationCount,
    VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) {
    mImpl->vkGetPipelineExecutableInternalRepresentationsKHR(
        snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device, pExecutableInfo,
        pInternalRepresentationCount, pInternalRepresentations);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdSetEvent2KHR(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkCommandBuffer commandBuffer, VkEvent event,
                                          const VkDependencyInfo* pDependencyInfo) {
    mImpl->vkCmdSetEvent2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                             pDependencyInfo);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdResetEvent2KHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer, VkEvent event,
                                            VkPipelineStageFlags2 stageMask) {
    mImpl->vkCmdResetEvent2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, event,
                               stageMask);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdWaitEvents2KHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer, uint32_t eventCount,
                                            const VkEvent* pEvents,
                                            const VkDependencyInfo* pDependencyInfos) {
    mImpl->vkCmdWaitEvents2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               eventCount, pEvents, pDependencyInfos);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdPipelineBarrier2KHR(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool,
                                                 VkCommandBuffer commandBuffer,
                                                 const VkDependencyInfo* pDependencyInfo) {
    mImpl->vkCmdPipelineBarrier2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                    pDependencyInfo);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdWriteTimestamp2KHR(const uint8_t* snapshotTraceBegin,
                                                size_t snapshotTraceBytes,
                                                android::base::BumpPool* pool,
                                                VkCommandBuffer commandBuffer,
                                                VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                                uint32_t query) {
    mImpl->vkCmdWriteTimestamp2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   stage, queryPool, query);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkQueueSubmit2KHR(const uint8_t* snapshotTraceBegin,
                                          size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                          VkResult input_result, VkQueue queue,
                                          uint32_t submitCount, const VkSubmitInfo2* pSubmits,
                                          VkFence fence) {
    mImpl->vkQueueSubmit2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, queue,
                             submitCount, pSubmits, fence);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkCmdWriteBufferMarker2AMD(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkCommandBuffer commandBuffer,
                                                   VkPipelineStageFlags2 stage, VkBuffer dstBuffer,
                                                   VkDeviceSize dstOffset, uint32_t marker) {
    mImpl->vkCmdWriteBufferMarker2AMD(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      stage, dstBuffer, dstOffset, marker);
}
#endif
#ifdef VK_KHR_synchronization2
void VkDecoderSnapshot::vkGetQueueCheckpointData2NV(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool, VkQueue queue,
                                                    uint32_t* pCheckpointDataCount,
                                                    VkCheckpointData2NV* pCheckpointData) {
    mImpl->vkGetQueueCheckpointData2NV(snapshotTraceBegin, snapshotTraceBytes, pool, queue,
                                       pCheckpointDataCount, pCheckpointData);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdCopyBuffer2KHR(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            const VkCopyBufferInfo2* pCopyBufferInfo) {
    mImpl->vkCmdCopyBuffer2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               pCopyBufferInfo);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdCopyImage2KHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer,
                                           const VkCopyImageInfo2* pCopyImageInfo) {
    mImpl->vkCmdCopyImage2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                              pCopyImageInfo);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdCopyBufferToImage2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    mImpl->vkCmdCopyBufferToImage2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      pCopyBufferToImageInfo);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdCopyImageToBuffer2KHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    mImpl->vkCmdCopyImageToBuffer2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      pCopyImageToBufferInfo);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdBlitImage2KHR(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer,
                                           const VkBlitImageInfo2* pBlitImageInfo) {
    mImpl->vkCmdBlitImage2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                              pBlitImageInfo);
}
#endif
#ifdef VK_KHR_copy_commands2
void VkDecoderSnapshot::vkCmdResolveImage2KHR(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool,
                                              VkCommandBuffer commandBuffer,
                                              const VkResolveImageInfo2* pResolveImageInfo) {
    mImpl->vkCmdResolveImage2KHR(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                 pResolveImageInfo);
}
#endif
#ifdef VK_KHR_maintenance4
void VkDecoderSnapshot::vkGetDeviceBufferMemoryRequirementsKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetDeviceBufferMemoryRequirementsKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                  device, pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_KHR_maintenance4
void VkDecoderSnapshot::vkGetDeviceImageMemoryRequirementsKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
    VkMemoryRequirements2* pMemoryRequirements) {
    mImpl->vkGetDeviceImageMemoryRequirementsKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                 device, pInfo, pMemoryRequirements);
}
#endif
#ifdef VK_KHR_maintenance4
void VkDecoderSnapshot::vkGetDeviceImageSparseMemoryRequirementsKHR(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
    uint32_t* pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    mImpl->vkGetDeviceImageSparseMemoryRequirementsKHR(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                       device, pInfo, pSparseMemoryRequirementCount,
                                                       pSparseMemoryRequirements);
}
#endif
#ifdef VK_ANDROID_native_buffer
void VkDecoderSnapshot::vkGetSwapchainGrallocUsageANDROID(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, VkFormat format, VkImageUsageFlags imageUsage,
    int* grallocUsage) {
    mImpl->vkGetSwapchainGrallocUsageANDROID(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             input_result, device, format, imageUsage,
                                             grallocUsage);
}
#endif
#ifdef VK_ANDROID_native_buffer
void VkDecoderSnapshot::vkAcquireImageANDROID(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkResult input_result,
                                              VkDevice device, VkImage image, int nativeFenceFd,
                                              VkSemaphore semaphore, VkFence fence) {
    mImpl->vkAcquireImageANDROID(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                                 image, nativeFenceFd, semaphore, fence);
}
#endif
#ifdef VK_ANDROID_native_buffer
void VkDecoderSnapshot::vkQueueSignalReleaseImageANDROID(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkQueue queue, uint32_t waitSemaphoreCount,
    const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) {
    mImpl->vkQueueSignalReleaseImageANDROID(snapshotTraceBegin, snapshotTraceBytes, pool,
                                            input_result, queue, waitSemaphoreCount,
                                            pWaitSemaphores, image, pNativeFenceFd);
}
#endif
#ifdef VK_ANDROID_native_buffer
void VkDecoderSnapshot::vkGetSwapchainGrallocUsage2ANDROID(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, VkFormat format, VkImageUsageFlags imageUsage,
    VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage,
    uint64_t* grallocProducerUsage) {
    mImpl->vkGetSwapchainGrallocUsage2ANDROID(
        snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device, format, imageUsage,
        swapchainImageUsage, grallocConsumerUsage, grallocProducerUsage);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdBindTransformFeedbackBuffersEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
    const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) {
    mImpl->vkCmdBindTransformFeedbackBuffersEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                commandBuffer, firstBinding, bindingCount, pBuffers,
                                                pOffsets, pSizes);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdBeginTransformFeedbackEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount,
    const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) {
    mImpl->vkCmdBeginTransformFeedbackEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                          commandBuffer, firstCounterBuffer, counterBufferCount,
                                          pCounterBuffers, pCounterBufferOffsets);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdEndTransformFeedbackEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount,
    const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) {
    mImpl->vkCmdEndTransformFeedbackEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                        firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                        pCounterBufferOffsets);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdBeginQueryIndexedEXT(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkCommandBuffer commandBuffer,
                                                  VkQueryPool queryPool, uint32_t query,
                                                  VkQueryControlFlags flags, uint32_t index) {
    mImpl->vkCmdBeginQueryIndexedEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     queryPool, query, flags, index);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdEndQueryIndexedEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) {
    mImpl->vkCmdEndQueryIndexedEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                   queryPool, query, index);
}
#endif
#ifdef VK_EXT_transform_feedback
void VkDecoderSnapshot::vkCmdDrawIndirectByteCountEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance,
    VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset,
    uint32_t vertexStride) {
    mImpl->vkCmdDrawIndirectByteCountEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer, instanceCount, firstInstance, counterBuffer,
                                         counterBufferOffset, counterOffset, vertexStride);
}
#endif
#ifdef VK_EXT_tooling_info
void VkDecoderSnapshot::vkGetPhysicalDeviceToolPropertiesEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkPhysicalDevice physicalDevice, uint32_t* pToolCount,
    VkPhysicalDeviceToolProperties* pToolProperties) {
    mImpl->vkGetPhysicalDeviceToolPropertiesEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                input_result, physicalDevice, pToolCount,
                                                pToolProperties);
}
#endif
#ifdef VK_EXT_line_rasterization
void VkDecoderSnapshot::vkCmdSetLineStippleEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) {
    mImpl->vkCmdSetLineStippleEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                  lineStippleFactor, lineStipplePattern);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetCullModeEXT(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool,
                                            VkCommandBuffer commandBuffer,
                                            VkCullModeFlags cullMode) {
    mImpl->vkCmdSetCullModeEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                               cullMode);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetFrontFaceEXT(const uint8_t* snapshotTraceBegin,
                                             size_t snapshotTraceBytes,
                                             android::base::BumpPool* pool,
                                             VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    mImpl->vkCmdSetFrontFaceEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                frontFace);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetPrimitiveTopologyEXT(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool,
                                                     VkCommandBuffer commandBuffer,
                                                     VkPrimitiveTopology primitiveTopology) {
    mImpl->vkCmdSetPrimitiveTopologyEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                        primitiveTopology);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetViewportWithCountEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) {
    mImpl->vkCmdSetViewportWithCountEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                        viewportCount, pViewports);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetScissorWithCountEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) {
    mImpl->vkCmdSetScissorWithCountEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                       scissorCount, pScissors);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdBindVertexBuffers2EXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
    const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes,
    const VkDeviceSize* pStrides) {
    mImpl->vkCmdBindVertexBuffers2EXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                      pStrides);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetDepthTestEnableEXT(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkCommandBuffer commandBuffer,
                                                   VkBool32 depthTestEnable) {
    mImpl->vkCmdSetDepthTestEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      depthTestEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetDepthWriteEnableEXT(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool,
                                                    VkCommandBuffer commandBuffer,
                                                    VkBool32 depthWriteEnable) {
    mImpl->vkCmdSetDepthWriteEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                       depthWriteEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetDepthCompareOpEXT(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool,
                                                  VkCommandBuffer commandBuffer,
                                                  VkCompareOp depthCompareOp) {
    mImpl->vkCmdSetDepthCompareOpEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                     depthCompareOp);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetDepthBoundsTestEnableEXT(const uint8_t* snapshotTraceBegin,
                                                         size_t snapshotTraceBytes,
                                                         android::base::BumpPool* pool,
                                                         VkCommandBuffer commandBuffer,
                                                         VkBool32 depthBoundsTestEnable) {
    mImpl->vkCmdSetDepthBoundsTestEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                            commandBuffer, depthBoundsTestEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetStencilTestEnableEXT(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool,
                                                     VkCommandBuffer commandBuffer,
                                                     VkBool32 stencilTestEnable) {
    mImpl->vkCmdSetStencilTestEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                        stencilTestEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state
void VkDecoderSnapshot::vkCmdSetStencilOpEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp,
    VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    mImpl->vkCmdSetStencilOpEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                faceMask, failOp, passOp, depthFailOp, compareOp);
}
#endif
#ifdef VK_EXT_swapchain_maintenance1
void VkDecoderSnapshot::vkReleaseSwapchainImagesEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkReleaseSwapchainImagesInfoEXT* pReleaseInfo) {
    mImpl->vkReleaseSwapchainImagesEXT(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                       device, pReleaseInfo);
}
#endif
#ifdef VK_EXT_private_data
void VkDecoderSnapshot::vkCreatePrivateDataSlotEXT(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    mImpl->vkCreatePrivateDataSlotEXT(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                      device, pCreateInfo, pAllocator, pPrivateDataSlot);
}
#endif
#ifdef VK_EXT_private_data
void VkDecoderSnapshot::vkDestroyPrivateDataSlotEXT(const uint8_t* snapshotTraceBegin,
                                                    size_t snapshotTraceBytes,
                                                    android::base::BumpPool* pool, VkDevice device,
                                                    VkPrivateDataSlot privateDataSlot,
                                                    const VkAllocationCallbacks* pAllocator) {
    mImpl->vkDestroyPrivateDataSlotEXT(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                       privateDataSlot, pAllocator);
}
#endif
#ifdef VK_EXT_private_data
void VkDecoderSnapshot::vkSetPrivateDataEXT(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkResult input_result,
                                            VkDevice device, VkObjectType objectType,
                                            uint64_t objectHandle,
                                            VkPrivateDataSlot privateDataSlot, uint64_t data) {
    mImpl->vkSetPrivateDataEXT(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                               objectType, objectHandle, privateDataSlot, data);
}
#endif
#ifdef VK_EXT_private_data
void VkDecoderSnapshot::vkGetPrivateDataEXT(const uint8_t* snapshotTraceBegin,
                                            size_t snapshotTraceBytes,
                                            android::base::BumpPool* pool, VkDevice device,
                                            VkObjectType objectType, uint64_t objectHandle,
                                            VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    mImpl->vkGetPrivateDataEXT(snapshotTraceBegin, snapshotTraceBytes, pool, device, objectType,
                               objectHandle, privateDataSlot, pData);
}
#endif
#ifdef VK_EXT_image_compression_control
void VkDecoderSnapshot::vkGetImageSubresourceLayout2EXT(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        VkDevice device, VkImage image,
                                                        const VkImageSubresource2EXT* pSubresource,
                                                        VkSubresourceLayout2EXT* pLayout) {
    mImpl->vkGetImageSubresourceLayout2EXT(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                           image, pSubresource, pLayout);
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void VkDecoderSnapshot::vkCmdSetPatchControlPointsEXT(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkCommandBuffer commandBuffer,
                                                      uint32_t patchControlPoints) {
    mImpl->vkCmdSetPatchControlPointsEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer, patchControlPoints);
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void VkDecoderSnapshot::vkCmdSetRasterizerDiscardEnableEXT(const uint8_t* snapshotTraceBegin,
                                                           size_t snapshotTraceBytes,
                                                           android::base::BumpPool* pool,
                                                           VkCommandBuffer commandBuffer,
                                                           VkBool32 rasterizerDiscardEnable) {
    mImpl->vkCmdSetRasterizerDiscardEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                              commandBuffer, rasterizerDiscardEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void VkDecoderSnapshot::vkCmdSetDepthBiasEnableEXT(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool,
                                                   VkCommandBuffer commandBuffer,
                                                   VkBool32 depthBiasEnable) {
    mImpl->vkCmdSetDepthBiasEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer,
                                      depthBiasEnable);
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void VkDecoderSnapshot::vkCmdSetLogicOpEXT(const uint8_t* snapshotTraceBegin,
                                           size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                           VkCommandBuffer commandBuffer, VkLogicOp logicOp) {
    mImpl->vkCmdSetLogicOpEXT(snapshotTraceBegin, snapshotTraceBytes, pool, commandBuffer, logicOp);
}
#endif
#ifdef VK_EXT_extended_dynamic_state2
void VkDecoderSnapshot::vkCmdSetPrimitiveRestartEnableEXT(const uint8_t* snapshotTraceBegin,
                                                          size_t snapshotTraceBytes,
                                                          android::base::BumpPool* pool,
                                                          VkCommandBuffer commandBuffer,
                                                          VkBool32 primitiveRestartEnable) {
    mImpl->vkCmdSetPrimitiveRestartEnableEXT(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             commandBuffer, primitiveRestartEnable);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkMapMemoryIntoAddressSpaceGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, VkDeviceMemory memory, uint64_t* pAddress) {
    mImpl->vkMapMemoryIntoAddressSpaceGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                             input_result, device, memory, pAddress);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkUpdateDescriptorSetWithTemplateSizedGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate, uint32_t imageInfoCount,
    uint32_t bufferInfoCount, uint32_t bufferViewCount, const uint32_t* pImageInfoEntryIndices,
    const uint32_t* pBufferInfoEntryIndices, const uint32_t* pBufferViewEntryIndices,
    const VkDescriptorImageInfo* pImageInfos, const VkDescriptorBufferInfo* pBufferInfos,
    const VkBufferView* pBufferViews) {
    mImpl->vkUpdateDescriptorSetWithTemplateSizedGOOGLE(
        snapshotTraceBegin, snapshotTraceBytes, pool, device, descriptorSet,
        descriptorUpdateTemplate, imageInfoCount, bufferInfoCount, bufferViewCount,
        pImageInfoEntryIndices, pBufferInfoEntryIndices, pBufferViewEntryIndices, pImageInfos,
        pBufferInfos, pBufferViews);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkBeginCommandBufferAsyncGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) {
    mImpl->vkBeginCommandBufferAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           commandBuffer, pBeginInfo);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkEndCommandBufferAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                                      size_t snapshotTraceBytes,
                                                      android::base::BumpPool* pool,
                                                      VkCommandBuffer commandBuffer) {
    mImpl->vkEndCommandBufferAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkResetCommandBufferAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                                        size_t snapshotTraceBytes,
                                                        android::base::BumpPool* pool,
                                                        VkCommandBuffer commandBuffer,
                                                        VkCommandBufferResetFlags flags) {
    mImpl->vkResetCommandBufferAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                           commandBuffer, flags);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkCommandBufferHostSyncGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkCommandBuffer commandBuffer, uint32_t needHostSync, uint32_t sequenceNumber) {
    mImpl->vkCommandBufferHostSyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                         commandBuffer, needHostSync, sequenceNumber);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkCreateImageWithRequirementsGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkImageCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkImage* pImage,
    VkMemoryRequirements* pMemoryRequirements) {
    mImpl->vkCreateImageWithRequirementsGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                               input_result, device, pCreateInfo, pAllocator,
                                               pImage, pMemoryRequirements);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkCreateBufferWithRequirementsGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkResult input_result, VkDevice device, const VkBufferCreateInfo* pCreateInfo,
    const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer,
    VkMemoryRequirements* pMemoryRequirements) {
    mImpl->vkCreateBufferWithRequirementsGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                input_result, device, pCreateInfo, pAllocator,
                                                pBuffer, pMemoryRequirements);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkGetMemoryHostAddressInfoGOOGLE(const uint8_t* snapshotTraceBegin,
                                                         size_t snapshotTraceBytes,
                                                         android::base::BumpPool* pool,
                                                         VkResult input_result, VkDevice device,
                                                         VkDeviceMemory memory, uint64_t* pAddress,
                                                         uint64_t* pSize, uint64_t* pHostmemId) {
    mImpl->vkGetMemoryHostAddressInfoGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                            input_result, device, memory, pAddress, pSize,
                                            pHostmemId);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkFreeMemorySyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                               size_t snapshotTraceBytes,
                                               android::base::BumpPool* pool, VkResult input_result,
                                               VkDevice device, VkDeviceMemory memory,
                                               const VkAllocationCallbacks* pAllocator) {
    mImpl->vkFreeMemorySyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, input_result,
                                  device, memory, pAllocator);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueHostSyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                              size_t snapshotTraceBytes,
                                              android::base::BumpPool* pool, VkQueue queue,
                                              uint32_t needHostSync, uint32_t sequenceNumber) {
    mImpl->vkQueueHostSyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue, needHostSync,
                                 sequenceNumber);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueSubmitAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                                 size_t snapshotTraceBytes,
                                                 android::base::BumpPool* pool, VkQueue queue,
                                                 uint32_t submitCount, const VkSubmitInfo* pSubmits,
                                                 VkFence fence) {
    mImpl->vkQueueSubmitAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue,
                                    submitCount, pSubmits, fence);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueWaitIdleAsyncGOOGLE(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool, VkQueue queue) {
    mImpl->vkQueueWaitIdleAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueBindSparseAsyncGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) {
    mImpl->vkQueueBindSparseAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue,
                                        bindInfoCount, pBindInfo, fence);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkGetLinearImageLayoutGOOGLE(const uint8_t* snapshotTraceBegin,
                                                     size_t snapshotTraceBytes,
                                                     android::base::BumpPool* pool, VkDevice device,
                                                     VkFormat format, VkDeviceSize* pOffset,
                                                     VkDeviceSize* pRowPitchAlignment) {
    mImpl->vkGetLinearImageLayoutGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                        format, pOffset, pRowPitchAlignment);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkGetLinearImageLayout2GOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, const VkImageCreateInfo* pCreateInfo, VkDeviceSize* pOffset,
    VkDeviceSize* pRowPitchAlignment) {
    mImpl->vkGetLinearImageLayout2GOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                         pCreateInfo, pOffset, pRowPitchAlignment);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueFlushCommandsGOOGLE(const uint8_t* snapshotTraceBegin,
                                                   size_t snapshotTraceBytes,
                                                   android::base::BumpPool* pool, VkQueue queue,
                                                   VkCommandBuffer commandBuffer,
                                                   VkDeviceSize dataSize, const void* pData) {
    mImpl->vkQueueFlushCommandsGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue,
                                      commandBuffer, dataSize, pData);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueCommitDescriptorSetUpdatesGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkQueue queue, uint32_t descriptorPoolCount, const VkDescriptorPool* pDescriptorPools,
    uint32_t descriptorSetCount, const VkDescriptorSetLayout* pSetLayouts,
    const uint64_t* pDescriptorSetPoolIds, const uint32_t* pDescriptorSetWhichPool,
    const uint32_t* pDescriptorSetPendingAllocation,
    const uint32_t* pDescriptorWriteStartingIndices, uint32_t pendingDescriptorWriteCount,
    const VkWriteDescriptorSet* pPendingDescriptorWrites) {
    mImpl->vkQueueCommitDescriptorSetUpdatesGOOGLE(
        snapshotTraceBegin, snapshotTraceBytes, pool, queue, descriptorPoolCount, pDescriptorPools,
        descriptorSetCount, pSetLayouts, pDescriptorSetPoolIds, pDescriptorSetWhichPool,
        pDescriptorSetPendingAllocation, pDescriptorWriteStartingIndices,
        pendingDescriptorWriteCount, pPendingDescriptorWrites);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkCollectDescriptorPoolIdsGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorPool descriptorPool, uint32_t* pPoolIdCount, uint64_t* pPoolIds) {
    mImpl->vkCollectDescriptorPoolIdsGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, device,
                                            descriptorPool, pPoolIdCount, pPoolIds);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueSignalReleaseImageANDROIDAsyncGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image) {
    mImpl->vkQueueSignalReleaseImageANDROIDAsyncGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                       queue, waitSemaphoreCount, pWaitSemaphores,
                                                       image);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueFlushCommandsFromAuxMemoryGOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkQueue queue, VkCommandBuffer commandBuffer, VkDeviceMemory deviceMemory,
    VkDeviceSize dataOffset, VkDeviceSize dataSize) {
    mImpl->vkQueueFlushCommandsFromAuxMemoryGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool,
                                                   queue, commandBuffer, deviceMemory, dataOffset,
                                                   dataSize);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkGetBlobGOOGLE(const uint8_t* snapshotTraceBegin,
                                        size_t snapshotTraceBytes, android::base::BumpPool* pool,
                                        VkResult input_result, VkDevice device,
                                        VkDeviceMemory memory) {
    mImpl->vkGetBlobGOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, input_result, device,
                           memory);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkUpdateDescriptorSetWithTemplateSized2GOOGLE(
    const uint8_t* snapshotTraceBegin, size_t snapshotTraceBytes, android::base::BumpPool* pool,
    VkDevice device, VkDescriptorSet descriptorSet,
    VkDescriptorUpdateTemplate descriptorUpdateTemplate, uint32_t imageInfoCount,
    uint32_t bufferInfoCount, uint32_t bufferViewCount, uint32_t inlineUniformBlockCount,
    const uint32_t* pImageInfoEntryIndices, const uint32_t* pBufferInfoEntryIndices,
    const uint32_t* pBufferViewEntryIndices, const VkDescriptorImageInfo* pImageInfos,
    const VkDescriptorBufferInfo* pBufferInfos, const VkBufferView* pBufferViews,
    const uint8_t* pInlineUniformBlockData) {
    mImpl->vkUpdateDescriptorSetWithTemplateSized2GOOGLE(
        snapshotTraceBegin, snapshotTraceBytes, pool, device, descriptorSet,
        descriptorUpdateTemplate, imageInfoCount, bufferInfoCount, bufferViewCount,
        inlineUniformBlockCount, pImageInfoEntryIndices, pBufferInfoEntryIndices,
        pBufferViewEntryIndices, pImageInfos, pBufferInfos, pBufferViews, pInlineUniformBlockData);
}
#endif
#ifdef VK_GOOGLE_gfxstream
void VkDecoderSnapshot::vkQueueSubmitAsync2GOOGLE(const uint8_t* snapshotTraceBegin,
                                                  size_t snapshotTraceBytes,
                                                  android::base::BumpPool* pool, VkQueue queue,
                                                  uint32_t submitCount,
                                                  const VkSubmitInfo2* pSubmits, VkFence fence) {
    mImpl->vkQueueSubmitAsync2GOOGLE(snapshotTraceBegin, snapshotTraceBytes, pool, queue,
                                     submitCount, pSubmits, fence);
}
#endif
