/* util-email.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-email.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019-2021 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include "unicode/utypes.h"
#include "unicode/utext.h"
#include "unicode/ubrk.h"

#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_SEPARATOR ((gunichar) ':')
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_TEMPLATE "%s:%s"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT (util_email_search_expression_factory_factory_context_get_type ())
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_FACTORY_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, UtilEmailSearchExpressionFactoryFactoryContext))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_FACTORY_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, UtilEmailSearchExpressionFactoryFactoryContextClass))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_FACTORY_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_FACTORY_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_FACTORY_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, UtilEmailSearchExpressionFactoryFactoryContextClass))

typedef struct _UtilEmailSearchExpressionFactoryFactoryContext UtilEmailSearchExpressionFactoryFactoryContext;
typedef struct _UtilEmailSearchExpressionFactoryFactoryContextClass UtilEmailSearchExpressionFactoryFactoryContextClass;
enum  {
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_0_PROPERTY,
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY,
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY,
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_NUM_PROPERTIES
};
static GParamSpec* util_email_search_expression_factory_properties[UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_NUM_PROPERTIES];

#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER (util_email_search_expression_factory_tokeniser_get_type ())
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER, UtilEmailSearchExpressionFactoryTokeniser))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER, UtilEmailSearchExpressionFactoryTokeniserClass))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER))
#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER, UtilEmailSearchExpressionFactoryTokeniserClass))

typedef struct _UtilEmailSearchExpressionFactoryTokeniser UtilEmailSearchExpressionFactoryTokeniser;
typedef struct _UtilEmailSearchExpressionFactoryTokeniserClass UtilEmailSearchExpressionFactoryTokeniserClass;
#define _util_email_search_expression_factory_tokeniser_unref0(var) ((var == NULL) ? NULL : (var = (util_email_search_expression_factory_tokeniser_unref (var), NULL)))
#define _util_email_search_expression_factory_factory_context_unref0(var) ((var == NULL) ? NULL : (var = (util_email_search_expression_factory_factory_context_unref (var), NULL)))
typedef struct _UtilEmailSearchExpressionFactoryFactoryContextPrivate UtilEmailSearchExpressionFactoryFactoryContextPrivate;
typedef GearySearchQueryTerm* (*UtilEmailSearchExpressionFactoryOperatorFactory) (const gchar* value, gboolean is_quoted, gpointer user_data);
typedef struct _UtilEmailSearchExpressionFactoryParamSpecFactoryContext UtilEmailSearchExpressionFactoryParamSpecFactoryContext;
typedef struct _UtilEmailSearchExpressionFactoryTokeniserPrivate UtilEmailSearchExpressionFactoryTokeniserPrivate;
typedef enum  {
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_NONE = 1 << 0,
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD = 1 << 1,
	UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD = 1 << 2
} UtilEmailSearchExpressionFactoryTokeniserCharStatus;

#define UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_TYPE_CHAR_STATUS (util_email_search_expression_factory_tokeniser_char_status_get_type ())
#define _ubrk_close0(var) ((var == NULL) ? NULL : (var = (ubrk_close (var), NULL)))
#define _utext_close0(var) ((var == NULL) ? NULL : (var = (utext_close (var), NULL)))
typedef struct _UtilEmailSearchExpressionFactoryParamSpecTokeniser UtilEmailSearchExpressionFactoryParamSpecTokeniser;

struct _UtilEmailSearchExpressionFactoryPrivate {
	GearySearchQueryStrategy _default_strategy;
	GearyAccountInformation* _account;
	GeeMap* text_operators;
	GeeMap* boolean_operators;
	GeeSet* search_op_to_me;
	GeeSet* search_op_from_me;
};

struct _UtilEmailSearchExpressionFactoryFactoryContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UtilEmailSearchExpressionFactoryOperatorFactory factory;
	gpointer factory_target;
	UtilEmailSearchExpressionFactoryFactoryContextPrivate * priv;
};

struct _UtilEmailSearchExpressionFactoryFactoryContextClass {
	GTypeClass parent_class;
	void (*finalize) (UtilEmailSearchExpressionFactoryFactoryContext *self);
};

struct _UtilEmailSearchExpressionFactoryParamSpecFactoryContext {
	GParamSpec parent_instance;
};

struct _UtilEmailSearchExpressionFactoryTokeniser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UtilEmailSearchExpressionFactoryTokeniserPrivate * priv;
};

struct _UtilEmailSearchExpressionFactoryTokeniserClass {
	GTypeClass parent_class;
	void (*finalize) (UtilEmailSearchExpressionFactoryTokeniser *self);
};

struct _UtilEmailSearchExpressionFactoryTokeniserPrivate {
	gchar* query;
	gint current_pos;
	gint next_pos;
	gunichar c;
	UtilEmailSearchExpressionFactoryTokeniserCharStatus* char_status;
	gint char_status_length1;
	gint _char_status_size_;
};

struct _UtilEmailSearchExpressionFactoryParamSpecTokeniser {
	GParamSpec parent_instance;
};

static gint UtilEmailSearchExpressionFactory_private_offset;
static gpointer util_email_search_expression_factory_parent_class = NULL;
static gpointer util_email_search_expression_factory_factory_context_parent_class = NULL;
static gint UtilEmailSearchExpressionFactoryTokeniser_private_offset;
static gpointer util_email_search_expression_factory_tokeniser_parent_class = NULL;

VALA_EXTERN gchar* util_email_quote_body (GearyEmail* email,
                              const gchar* html_quote,
                              gboolean use_quotes,
                              GearyRFC822TextFormat format,
                              GError** error);
static gpointer util_email_search_expression_factory_factory_context_ref (gpointer instance);
static void util_email_search_expression_factory_factory_context_unref (gpointer instance);
static GParamSpec* util_email_search_expression_factory_param_spec_factory_context (const gchar* name,
                                                                             const gchar* nick,
                                                                             const gchar* blurb,
                                                                             GType object_type,
                                                                             GParamFlags flags) G_GNUC_UNUSED ;
static void util_email_search_expression_factory_value_set_factory_context (GValue* value,
                                                                     gpointer v_object) G_GNUC_UNUSED ;
static void util_email_search_expression_factory_value_take_factory_context (GValue* value,
                                                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer util_email_search_expression_factory_value_get_factory_context (const GValue* value) G_GNUC_UNUSED ;
static GType util_email_search_expression_factory_factory_context_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void util_email_search_expression_factory_set_default_strategy (UtilEmailSearchExpressionFactory* self,
                                                                GearySearchQueryStrategy value);
static void util_email_search_expression_factory_set_account (UtilEmailSearchExpressionFactory* self,
                                                       GearyAccountInformation* value);
static void util_email_search_expression_factory_construct_factories (UtilEmailSearchExpressionFactory* self);
static gpointer util_email_search_expression_factory_tokeniser_ref (gpointer instance);
static void util_email_search_expression_factory_tokeniser_unref (gpointer instance);
static GParamSpec* util_email_search_expression_factory_param_spec_tokeniser (const gchar* name,
                                                                       const gchar* nick,
                                                                       const gchar* blurb,
                                                                       GType object_type,
                                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void util_email_search_expression_factory_value_set_tokeniser (GValue* value,
                                                               gpointer v_object) G_GNUC_UNUSED ;
static void util_email_search_expression_factory_value_take_tokeniser (GValue* value,
                                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer util_email_search_expression_factory_value_get_tokeniser (const GValue* value) G_GNUC_UNUSED ;
static GType util_email_search_expression_factory_tokeniser_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static UtilEmailSearchExpressionFactoryTokeniser* util_email_search_expression_factory_tokeniser_new (const gchar* query);
static UtilEmailSearchExpressionFactoryTokeniser* util_email_search_expression_factory_tokeniser_construct (GType object_type,
                                                                                                     const gchar* query);
static gboolean util_email_search_expression_factory_tokeniser_get_has_next (UtilEmailSearchExpressionFactoryTokeniser* self);
static gboolean util_email_search_expression_factory_tokeniser_get_is_at_word (UtilEmailSearchExpressionFactoryTokeniser* self);
static gchar* util_email_search_expression_factory_tokeniser_consume_word (UtilEmailSearchExpressionFactoryTokeniser* self);
static gunichar util_email_search_expression_factory_tokeniser_get_current_character (UtilEmailSearchExpressionFactoryTokeniser* self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_extended_operator (UtilEmailSearchExpressionFactory* self,
                                                                                  const gchar* name,
                                                                                  UtilEmailSearchExpressionFactoryTokeniser* tokens);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_all_operator (UtilEmailSearchExpressionFactory* self,
                                                                                  const gchar* value,
                                                                                  gboolean is_quoted);
static gboolean util_email_search_expression_factory_tokeniser_get_is_at_quote (UtilEmailSearchExpressionFactoryTokeniser* self);
static gchar* util_email_search_expression_factory_tokeniser_consume_quote (UtilEmailSearchExpressionFactoryTokeniser* self);
static void util_email_search_expression_factory_tokeniser_skip_to_next (UtilEmailSearchExpressionFactoryTokeniser* self);
static void util_email_search_expression_factory_tokeniser_consume_char (UtilEmailSearchExpressionFactoryTokeniser* self);
static inline GearySearchQueryStrategy util_email_search_expression_factory_get_matching_strategy (UtilEmailSearchExpressionFactory* self,
                                                                                     gboolean is_quoted);
static GeeList* util_email_search_expression_factory_get_account_addresses (UtilEmailSearchExpressionFactory* self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_attachment_name_operator (UtilEmailSearchExpressionFactory* self,
                                                                                              const gchar* value,
                                                                                              gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_attachment_name_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                                     gboolean is_quoted,
                                                                                                                                                     gpointer self);
static UtilEmailSearchExpressionFactoryFactoryContext* util_email_search_expression_factory_factory_context_new (UtilEmailSearchExpressionFactoryOperatorFactory factory,
                                                                                                          gpointer factory_target);
static UtilEmailSearchExpressionFactoryFactoryContext* util_email_search_expression_factory_factory_context_construct (GType object_type,
                                                                                                                UtilEmailSearchExpressionFactoryOperatorFactory factory,
                                                                                                                gpointer factory_target);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_bcc_operator (UtilEmailSearchExpressionFactory* self,
                                                                                  const gchar* value,
                                                                                  gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_bcc_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                         gboolean is_quoted,
                                                                                                                                         gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_body_operator (UtilEmailSearchExpressionFactory* self,
                                                                                   const gchar* value,
                                                                                   gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_body_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                          gboolean is_quoted,
                                                                                                                                          gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_cc_operator (UtilEmailSearchExpressionFactory* self,
                                                                                 const gchar* value,
                                                                                 gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_cc_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                        gboolean is_quoted,
                                                                                                                                        gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_from_operator (UtilEmailSearchExpressionFactory* self,
                                                                                   const gchar* value,
                                                                                   gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_from_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                          gboolean is_quoted,
                                                                                                                                          gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_subject_operator (UtilEmailSearchExpressionFactory* self,
                                                                                      const gchar* value,
                                                                                      gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_subject_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                             gboolean is_quoted,
                                                                                                                                             gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_text_to_operator (UtilEmailSearchExpressionFactory* self,
                                                                                 const gchar* value,
                                                                                 gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_text_to_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                        gboolean is_quoted,
                                                                                                                                        gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_boolean_unread_operator (UtilEmailSearchExpressionFactory* self,
                                                                                        const gchar* value,
                                                                                        gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_boolean_unread_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                               gboolean is_quoted,
                                                                                                                                               gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_boolean_read_operator (UtilEmailSearchExpressionFactory* self,
                                                                                      const gchar* value,
                                                                                      gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_boolean_read_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                             gboolean is_quoted,
                                                                                                                                             gpointer self);
static GearySearchQueryTerm* util_email_search_expression_factory_new_boolean_starred_operator (UtilEmailSearchExpressionFactory* self,
                                                                                         const gchar* value,
                                                                                         gboolean is_quoted);
static GearySearchQueryTerm* _util_email_search_expression_factory_new_boolean_starred_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                                                gboolean is_quoted,
                                                                                                                                                gpointer self);
static void util_email_search_expression_factory_factory_context_finalize (UtilEmailSearchExpressionFactoryFactoryContext * obj);
static GType util_email_search_expression_factory_factory_context_get_type_once (void);
static GType util_email_search_expression_factory_tokeniser_char_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean _vala_unichar_array_contains (gunichar * stack,
                                       gssize stack_length,
                                       const gunichar needle);
static void util_email_search_expression_factory_tokeniser_finalize (UtilEmailSearchExpressionFactoryTokeniser * obj);
static GType util_email_search_expression_factory_tokeniser_get_type_once (void);
static void util_email_search_expression_factory_finalize (GObject * obj);
static GType util_email_search_expression_factory_get_type_once (void);
static void _vala_util_email_search_expression_factory_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_util_email_search_expression_factory_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gunichar UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CONTINUATION_CHARS[4] = {(gunichar) '-', (gunichar) '_', (gunichar) '.', (gunichar) '@'};

gint
util_email_compare_conversation_ascending (GearyAppConversation* a,
                                           GearyAppConversation* b)
{
	GearyEmail* a_latest = NULL;
	GearyEmail* _tmp0_;
	GearyEmail* b_latest = NULL;
	GearyEmail* _tmp1_;
	GearyEmail* _tmp2_;
	GearyEmail* _tmp6_;
	GearyEmail* _tmp7_;
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, GEARY_APP_TYPE_CONVERSATION), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, GEARY_APP_TYPE_CONVERSATION), 0);
	_tmp0_ = geary_app_conversation_get_latest_recv_email (a, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, NULL);
	a_latest = _tmp0_;
	_tmp1_ = geary_app_conversation_get_latest_recv_email (b, GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, NULL);
	b_latest = _tmp1_;
	_tmp2_ = a_latest;
	if (_tmp2_ == NULL) {
		gint _tmp3_ = 0;
		GearyEmail* _tmp4_;
		_tmp4_ = b_latest;
		if (_tmp4_ == NULL) {
			_tmp3_ = 0;
		} else {
			_tmp3_ = -1;
		}
		result = _tmp3_;
		_g_object_unref0 (b_latest);
		_g_object_unref0 (a_latest);
		return result;
	} else {
		GearyEmail* _tmp5_;
		_tmp5_ = b_latest;
		if (_tmp5_ == NULL) {
			result = 1;
			_g_object_unref0 (b_latest);
			_g_object_unref0 (a_latest);
			return result;
		}
	}
	_tmp6_ = a_latest;
	_tmp7_ = b_latest;
	result = geary_email_compare_recv_date_ascending (_tmp6_, _tmp7_);
	_g_object_unref0 (b_latest);
	_g_object_unref0 (a_latest);
	return result;
}

gint
util_email_compare_conversation_descending (GearyAppConversation* a,
                                            GearyAppConversation* b)
{
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, GEARY_APP_TYPE_CONVERSATION), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (b, GEARY_APP_TYPE_CONVERSATION), 0);
	result = util_email_compare_conversation_ascending (b, a);
	return result;
}

/**
     * Returns the subject for an email stripped of prefixes.
     *
     * If the email has no subject, returns a localised placeholder.
     */
gchar*
util_email_strip_subject_prefixes (GearyEmailHeaderSet* email)
{
	gchar* cleaned = NULL;
	GearyRFC822Subject* _tmp0_;
	GearyRFC822Subject* _tmp1_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL_HEADER_SET), NULL);
	cleaned = NULL;
	_tmp0_ = geary_email_header_set_get_subject (email);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GearyRFC822Subject* _tmp2_;
		GearyRFC822Subject* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = geary_email_header_set_get_subject (email);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_rf_c822_subject_strip_prefixes (_tmp3_);
		_g_free0 (cleaned);
		cleaned = _tmp4_;
	}
	_tmp6_ = cleaned;
	if (!geary_string_is_empty_or_whitespace (_tmp6_)) {
		const gchar* _tmp7_;
		_tmp7_ = cleaned;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = _ ("(No subject)");
	}
	_tmp8_ = g_strdup (_tmp5_);
	result = _tmp8_;
	_g_free0 (cleaned);
	return result;
}

/**
     * Returns a mailbox for the primary originator of an email.
     *
     * RFC 822 allows multiple and absent From header values, and
     * software such as Mailman and GitLab will mangle the names in
     * From mailboxes. This provides a canonical means to obtain a
     * mailbox (that is, name and email address) for the first
     * originator, and with the mailbox's name having been fixed up
     * where possible.
     *
     * The first From mailbox is used and de-mangled if found, if not
     * the Sender mailbox is used if present, else the first Reply-To
     * mailbox is used.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

GearyRFC822MailboxAddress*
util_email_get_primary_originator (GearyEmailHeaderSet* email)
{
	GearyRFC822MailboxAddress* primary = NULL;
	gboolean _tmp0_ = FALSE;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddress* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL_HEADER_SET), NULL);
	primary = NULL;
	_tmp1_ = geary_email_header_set_get_from (email);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GearyRFC822MailboxAddresses* _tmp3_;
		GearyRFC822MailboxAddresses* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = geary_email_header_set_get_from (email);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_rf_c822_mailbox_addresses_get_size (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyRFC822MailboxAddresses* from = NULL;
		GearyRFC822MailboxAddresses* _tmp7_;
		GearyRFC822MailboxAddresses* _tmp8_;
		GearyRFC822MailboxAddresses* _tmp9_;
		gchar* from_name = NULL;
		gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp12_;
		GearyRFC822MailboxAddresses* reply_to = NULL;
		GearyRFC822MailboxAddresses* _tmp23_;
		GearyRFC822MailboxAddresses* _tmp24_;
		GearyRFC822MailboxAddresses* _tmp25_;
		GearyRFC822MailboxAddress* primary_reply_to = NULL;
		gchar* reply_to_name = NULL;
		gchar* _tmp26_;
		gboolean _tmp27_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp28_;
		static const char VIA[] = " via ";
		gboolean _tmp39_ = FALSE;
		const gchar* _tmp40_;
		_tmp7_ = geary_email_header_set_get_from (email);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		from = _tmp9_;
		_tmp10_ = g_strdup ("");
		from_name = _tmp10_;
		_tmp12_ = from;
		if (_tmp12_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = from;
			_tmp14_ = geary_rf_c822_mailbox_addresses_get_size (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ > 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GearyRFC822MailboxAddresses* _tmp16_;
			GearyRFC822MailboxAddress* _tmp17_;
			const gchar* _tmp18_ = NULL;
			GearyRFC822MailboxAddress* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp16_ = from;
			_tmp17_ = geary_rf_c822_mailbox_addresses_get (_tmp16_, 0);
			_g_object_unref0 (primary);
			primary = _tmp17_;
			_tmp19_ = primary;
			_tmp20_ = geary_rf_c822_mailbox_address_get_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp18_ = _tmp21_;
			if (_tmp18_ == NULL) {
				_tmp18_ = "";
			}
			_tmp22_ = g_strdup (_tmp18_);
			_g_free0 (from_name);
			from_name = _tmp22_;
		}
		_tmp23_ = geary_email_header_set_get_reply_to (email);
		_tmp24_ = _tmp23_;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		reply_to = _tmp25_;
		primary_reply_to = NULL;
		_tmp26_ = g_strdup ("");
		reply_to_name = _tmp26_;
		_tmp28_ = reply_to;
		if (_tmp28_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			_tmp29_ = reply_to;
			_tmp30_ = geary_rf_c822_mailbox_addresses_get_size (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ > 0;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GearyRFC822MailboxAddresses* _tmp32_;
			GearyRFC822MailboxAddress* _tmp33_;
			const gchar* _tmp34_ = NULL;
			GearyRFC822MailboxAddress* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp32_ = reply_to;
			_tmp33_ = geary_rf_c822_mailbox_addresses_get (_tmp32_, 0);
			_g_object_unref0 (primary_reply_to);
			primary_reply_to = _tmp33_;
			_tmp35_ = primary_reply_to;
			_tmp36_ = geary_rf_c822_mailbox_address_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp34_ = _tmp37_;
			if (_tmp34_ == NULL) {
				_tmp34_ = "";
			}
			_tmp38_ = g_strdup (_tmp34_);
			_g_free0 (reply_to_name);
			reply_to_name = _tmp38_;
		}
		_tmp40_ = reply_to_name;
		if (g_strcmp0 (_tmp40_, "") != 0) {
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp41_ = from_name;
			_tmp42_ = reply_to_name;
			_tmp39_ = g_str_has_prefix (_tmp41_, _tmp42_);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			GearyRFC822MailboxAddress* _tmp43_;
			GearyRFC822MailboxAddress* _tmp44_;
			_tmp43_ = primary_reply_to;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (primary);
			primary = _tmp44_;
		} else {
			const gchar* _tmp45_;
			_tmp45_ = from_name;
			if (string_contains (_tmp45_, VIA)) {
				const gchar* _tmp46_;
				gchar** _tmp47_;
				gchar** _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				const gchar* _tmp50_;
				GearyRFC822MailboxAddress* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				GearyRFC822MailboxAddress* _tmp54_;
				_tmp46_ = from_name;
				_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, VIA, 2);
				_tmp49_ = _tmp48_;
				_tmp49__length1 = _vala_array_length (_tmp47_);
				_tmp50_ = _tmp49_[0];
				_tmp51_ = primary;
				_tmp52_ = geary_rf_c822_mailbox_address_get_address (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = geary_rf_c822_mailbox_address_new (_tmp50_, _tmp53_);
				_g_object_unref0 (primary);
				primary = _tmp54_;
				_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_free0 (reply_to_name);
		_g_object_unref0 (primary_reply_to);
		_g_object_unref0 (reply_to);
		_g_free0 (from_name);
		_g_object_unref0 (from);
	} else {
		GearyRFC822MailboxAddress* _tmp55_;
		GearyRFC822MailboxAddress* _tmp56_;
		_tmp55_ = geary_email_header_set_get_sender (email);
		_tmp56_ = _tmp55_;
		if (_tmp56_ != NULL) {
			GearyRFC822MailboxAddress* _tmp57_;
			GearyRFC822MailboxAddress* _tmp58_;
			GearyRFC822MailboxAddress* _tmp59_;
			_tmp57_ = geary_email_header_set_get_sender (email);
			_tmp58_ = _tmp57_;
			_tmp59_ = _g_object_ref0 (_tmp58_);
			_g_object_unref0 (primary);
			primary = _tmp59_;
		} else {
			gboolean _tmp60_ = FALSE;
			GearyRFC822MailboxAddresses* _tmp61_;
			GearyRFC822MailboxAddresses* _tmp62_;
			_tmp61_ = geary_email_header_set_get_reply_to (email);
			_tmp62_ = _tmp61_;
			if (_tmp62_ != NULL) {
				GearyRFC822MailboxAddresses* _tmp63_;
				GearyRFC822MailboxAddresses* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				_tmp63_ = geary_email_header_set_get_reply_to (email);
				_tmp64_ = _tmp63_;
				_tmp65_ = geary_rf_c822_mailbox_addresses_get_size (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp60_ = _tmp66_ > 0;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				GearyRFC822MailboxAddresses* _tmp67_;
				GearyRFC822MailboxAddresses* _tmp68_;
				GearyRFC822MailboxAddress* _tmp69_;
				_tmp67_ = geary_email_header_set_get_reply_to (email);
				_tmp68_ = _tmp67_;
				_tmp69_ = geary_rf_c822_mailbox_addresses_get (_tmp68_, 0);
				_g_object_unref0 (primary);
				primary = _tmp69_;
			}
		}
	}
	result = primary;
	return result;
}

/**
     * Returns a shortened recipient list suitable for display.
     *
     * This is useful in case there are a lot of recipients, or there
     * is little room for the display.
     *
     * @return a string containing at least the first mailbox
     * serialised by {@link
     * Geary.RFC822.MailboxAddress.to_short_display}, if the list
     * contains more mailboxes then an indication of how many
     * additional are present.
     */
gchar*
util_email_to_short_recipient_display (GearyEmailHeaderSet* headers)
{
	GearyRFC822MailboxAddresses* mailboxes = NULL;
	gint total = 0;
	GearyRFC822MailboxAddresses* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp9_;
	GearyRFC822MailboxAddresses* _tmp10_;
	GearyRFC822MailboxAddresses* _tmp19_;
	GearyRFC822MailboxAddresses* _tmp20_;
	gchar* display = NULL;
	gchar* _tmp29_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (headers, GEARY_TYPE_EMAIL_HEADER_SET), NULL);
	mailboxes = NULL;
	total = 0;
	_tmp0_ = geary_email_header_set_get_to (headers);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GearyRFC822MailboxAddresses* _tmp2_;
		GearyRFC822MailboxAddresses* _tmp3_;
		GearyRFC822MailboxAddresses* _tmp4_;
		GearyRFC822MailboxAddresses* _tmp5_;
		GearyRFC822MailboxAddresses* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp2_ = geary_email_header_set_get_to (headers);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (mailboxes);
		mailboxes = _tmp4_;
		_tmp5_ = geary_email_header_set_get_to (headers);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_rf_c822_mailbox_addresses_get_size (_tmp6_);
		_tmp8_ = _tmp7_;
		total += _tmp8_;
	}
	_tmp9_ = geary_email_header_set_get_cc (headers);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		GearyRFC822MailboxAddresses* _tmp11_;
		GearyRFC822MailboxAddresses* _tmp15_;
		GearyRFC822MailboxAddresses* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp11_ = mailboxes;
		if (_tmp11_ == NULL) {
			GearyRFC822MailboxAddresses* _tmp12_;
			GearyRFC822MailboxAddresses* _tmp13_;
			GearyRFC822MailboxAddresses* _tmp14_;
			_tmp12_ = geary_email_header_set_get_cc (headers);
			_tmp13_ = _tmp12_;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (mailboxes);
			mailboxes = _tmp14_;
		}
		_tmp15_ = geary_email_header_set_get_cc (headers);
		_tmp16_ = _tmp15_;
		_tmp17_ = geary_rf_c822_mailbox_addresses_get_size (_tmp16_);
		_tmp18_ = _tmp17_;
		total += _tmp18_;
	}
	_tmp19_ = geary_email_header_set_get_bcc (headers);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		GearyRFC822MailboxAddresses* _tmp21_;
		GearyRFC822MailboxAddresses* _tmp25_;
		GearyRFC822MailboxAddresses* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp21_ = mailboxes;
		if (_tmp21_ == NULL) {
			GearyRFC822MailboxAddresses* _tmp22_;
			GearyRFC822MailboxAddresses* _tmp23_;
			GearyRFC822MailboxAddresses* _tmp24_;
			_tmp22_ = geary_email_header_set_get_bcc (headers);
			_tmp23_ = _tmp22_;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			_g_object_unref0 (mailboxes);
			mailboxes = _tmp24_;
		}
		_tmp25_ = geary_email_header_set_get_bcc (headers);
		_tmp26_ = _tmp25_;
		_tmp27_ = geary_rf_c822_mailbox_addresses_get_size (_tmp26_);
		_tmp28_ = _tmp27_;
		total += _tmp28_;
	}
	_tmp29_ = g_strdup (_ ("(No recipients)"));
	display = _tmp29_;
	if (total > 0) {
		GearyRFC822MailboxAddresses* _tmp30_;
		GearyRFC822MailboxAddress* _tmp31_;
		GearyRFC822MailboxAddress* _tmp32_;
		gchar* _tmp33_;
		_tmp30_ = mailboxes;
		_tmp31_ = geary_rf_c822_mailbox_addresses_get (_tmp30_, 0);
		_tmp32_ = _tmp31_;
		_tmp33_ = geary_rf_c822_mailbox_address_to_short_display (_tmp32_);
		_g_free0 (display);
		display = _tmp33_;
		_g_object_unref0 (_tmp32_);
		if (total > 1) {
			const gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp34_ = display;
			_tmp35_ = g_strdup_printf (ngettext ("%s and %d other", "%s and %d others", (gulong) (total - 1)), _tmp34_, total - 1);
			_g_free0 (display);
			display = _tmp35_;
		}
	}
	result = display;
	_g_object_unref0 (mailboxes);
	return result;
}

/**
     * Returns a quoted text string needed for a reply.
     *
     * If there's no message body in the supplied email or quote text, this
     * function will return the empty string.
     *
     * If html_format is true, the message will be quoted in HTML format.
     * Otherwise it will be in plain text.
     */
gchar*
util_email_quote_email_for_reply (GearyEmail* email,
                                  const gchar* quote,
                                  GearyRFC822TextFormat format)
{
	gchar* quoted = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GearyRFC822Text* _tmp2_;
	GearyRFC822Text* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), NULL);
	_tmp0_ = g_strdup ("");
	quoted = _tmp0_;
	_tmp2_ = geary_email_get_body (email);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = quote != NULL;
	}
	if (_tmp1_) {
		gchar* date_format = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GearyRFC822Date* _tmp6_;
		GearyRFC822Date* _tmp7_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp4_ = g_strdup (_ ("%a, %b %-e %Y at %X %Z"));
		date_format = _tmp4_;
		_tmp6_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp8_;
			GearyRFC822MailboxAddresses* _tmp9_;
			_tmp8_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gchar* QUOTED_LABEL = NULL;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			GearyRFC822Date* _tmp13_;
			GearyRFC822Date* _tmp14_;
			GDateTime* _tmp15_;
			GDateTime* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GearyRFC822MailboxAddresses* _tmp20_;
			GearyRFC822MailboxAddresses* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp10_ = g_strdup (_ ("On %1$s, %2$s wrote:"));
			QUOTED_LABEL = _tmp10_;
			_tmp11_ = quoted;
			_tmp12_ = QUOTED_LABEL;
			_tmp13_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp14_ = _tmp13_;
			_tmp15_ = geary_rf_c822_date_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = date_format;
			_tmp18_ = g_date_time_format (_tmp16_, _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp21_ = _tmp20_;
			_tmp22_ = geary_rf_c822_utils_email_addresses_for_reply (_tmp21_, format);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf (_tmp12_, _tmp19_, _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp11_, _tmp25_, NULL);
			_g_free0 (quoted);
			quoted = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp19_);
			_g_free0 (QUOTED_LABEL);
		} else {
			GearyRFC822MailboxAddresses* _tmp27_;
			GearyRFC822MailboxAddresses* _tmp28_;
			_tmp27_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp28_ = _tmp27_;
			if (_tmp28_ != NULL) {
				gchar* QUOTED_LABEL = NULL;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				GearyRFC822MailboxAddresses* _tmp32_;
				GearyRFC822MailboxAddresses* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp29_ = g_strdup (_ ("%s wrote:"));
				QUOTED_LABEL = _tmp29_;
				_tmp30_ = quoted;
				_tmp31_ = QUOTED_LABEL;
				_tmp32_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp33_ = _tmp32_;
				_tmp34_ = geary_rf_c822_utils_email_addresses_for_reply (_tmp33_, format);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup_printf (_tmp31_, _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat (_tmp30_, _tmp37_, NULL);
				_g_free0 (quoted);
				quoted = _tmp38_;
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
				_g_free0 (QUOTED_LABEL);
			} else {
				GearyRFC822Date* _tmp39_;
				GearyRFC822Date* _tmp40_;
				_tmp39_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp40_ = _tmp39_;
				if (_tmp40_ != NULL) {
					gchar* QUOTED_LABEL = NULL;
					gchar* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					GearyRFC822Date* _tmp44_;
					GearyRFC822Date* _tmp45_;
					GDateTime* _tmp46_;
					GDateTime* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp41_ = g_strdup (_ ("On %s:"));
					QUOTED_LABEL = _tmp41_;
					_tmp42_ = quoted;
					_tmp43_ = QUOTED_LABEL;
					_tmp44_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_tmp45_ = _tmp44_;
					_tmp46_ = geary_rf_c822_date_get_value (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = date_format;
					_tmp49_ = g_date_time_format (_tmp47_, _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup_printf (_tmp43_, _tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strconcat (_tmp42_, _tmp52_, NULL);
					_g_free0 (quoted);
					quoted = _tmp53_;
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					_g_free0 (QUOTED_LABEL);
				}
			}
		}
		_tmp54_ = quoted;
		_tmp55_ = g_strconcat (_tmp54_, "<br />", NULL);
		_g_free0 (quoted);
		quoted = _tmp55_;
		{
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = util_email_quote_body (email, quote, TRUE, format, &_inner_error0_);
			_tmp56_ = _tmp57_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp58_ = quoted;
			_tmp59_ = _tmp56_;
			_tmp56_ = NULL;
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strconcat (_tmp58_, _tmp60_, NULL);
			_g_free0 (quoted);
			quoted = _tmp61_;
			_g_free0 (_tmp60_);
			_g_free0 (_tmp56_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp62_ = err;
			_tmp63_ = _tmp62_->message;
			_tmp64_ = g_strdup_printf ("Failed to quote body for replying: %s", _tmp63_);
			_tmp65_ = _tmp64_;
			g_debug ("util-email.vala:231: %s", _tmp65_);
			_g_free0 (_tmp65_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (date_format);
			_g_free0 (quoted);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (date_format);
	}
	result = quoted;
	return result;
}

/**
     * Returns a quoted text string needed for a forward.
     *
     * If there's no message body in the supplied email or quote text, this
     * function will return the empty string.
     *
     * If html_format is true, the message will be quoted in HTML format.
     * Otherwise it will be in plain text.
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
util_email_quote_email_for_forward (GearyEmail* email,
                                    const gchar* quote,
                                    GearyRFC822TextFormat format)
{
	gboolean _tmp0_ = FALSE;
	GearyRFC822Text* _tmp1_;
	GearyRFC822Text* _tmp2_;
	static const char HEADER_FORMAT[] = "%s %s\n";
	gchar* quoted = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* from_line = NULL;
	GearyRFC822MailboxAddresses* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp16_ = NULL;
	GearyRFC822Subject* _tmp17_;
	GearyRFC822Subject* _tmp18_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	GearyRFC822Date* _tmp28_;
	GearyRFC822Date* _tmp29_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* to_line = NULL;
	GearyRFC822MailboxAddresses* _tmp38_;
	GearyRFC822MailboxAddresses* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* cc_line = NULL;
	GearyRFC822MailboxAddresses* _tmp47_;
	GearyRFC822MailboxAddresses* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), NULL);
	_tmp1_ = geary_email_get_body (email);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = quote == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup (_ ("---------- Forwarded message ----------"));
	quoted = _tmp4_;
	_tmp5_ = quoted;
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
	_g_free0 (quoted);
	quoted = _tmp6_;
	_tmp7_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_rf_c822_utils_email_addresses_for_reply (_tmp8_, format);
	from_line = _tmp9_;
	_tmp10_ = from_line;
	if (!geary_string_is_empty_or_whitespace (_tmp10_)) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = quoted;
		_tmp12_ = from_line;
		_tmp13_ = g_strdup_printf (HEADER_FORMAT, _ ("From:"), _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
		_g_free0 (quoted);
		quoted = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp17_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		GearyRFC822Subject* _tmp19_;
		GearyRFC822Subject* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp20_ = _tmp19_;
		_tmp21_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp21_;
	} else {
		gchar* _tmp22_;
		_tmp22_ = g_strdup ("");
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp22_;
	}
	_tmp23_ = quoted;
	_tmp24_ = g_strdup_printf (HEADER_FORMAT, _ ("Subject:"), _tmp16_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
	_g_free0 (quoted);
	quoted = _tmp26_;
	_g_free0 (_tmp25_);
	_tmp28_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		GearyRFC822Date* _tmp30_;
		GearyRFC822Date* _tmp31_;
		gchar* _tmp32_;
		_tmp30_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp31_ = _tmp30_;
		_tmp32_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp27_);
		_tmp27_ = _tmp32_;
	} else {
		gchar* _tmp33_;
		_tmp33_ = g_strdup ("");
		_g_free0 (_tmp27_);
		_tmp27_ = _tmp33_;
	}
	_tmp34_ = quoted;
	_tmp35_ = g_strdup_printf (HEADER_FORMAT, _ ("Date:"), _tmp27_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
	_g_free0 (quoted);
	quoted = _tmp37_;
	_g_free0 (_tmp36_);
	_tmp38_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp39_ = _tmp38_;
	_tmp40_ = geary_rf_c822_utils_email_addresses_for_reply (_tmp39_, format);
	to_line = _tmp40_;
	_tmp41_ = to_line;
	if (!geary_string_is_empty_or_whitespace (_tmp41_)) {
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp42_ = quoted;
		_tmp43_ = to_line;
		_tmp44_ = g_strdup_printf (HEADER_FORMAT, _ ("To:"), _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp42_, _tmp45_, NULL);
		_g_free0 (quoted);
		quoted = _tmp46_;
		_g_free0 (_tmp45_);
	}
	_tmp47_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp48_ = _tmp47_;
	_tmp49_ = geary_rf_c822_utils_email_addresses_for_reply (_tmp48_, format);
	cc_line = _tmp49_;
	_tmp50_ = cc_line;
	if (!geary_string_is_empty_or_whitespace (_tmp50_)) {
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp51_ = quoted;
		_tmp52_ = cc_line;
		_tmp53_ = g_strdup_printf (HEADER_FORMAT, _ ("Cc:"), _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
		_g_free0 (quoted);
		quoted = _tmp55_;
		_g_free0 (_tmp54_);
	}
	_tmp56_ = quoted;
	_tmp57_ = g_strconcat (_tmp56_, "\n", NULL);
	_g_free0 (quoted);
	quoted = _tmp57_;
	_tmp58_ = quoted;
	_tmp59_ = string_replace (_tmp58_, "\n", "<br />");
	_g_free0 (quoted);
	quoted = _tmp59_;
	{
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp61_ = util_email_quote_body (email, quote, FALSE, format, &_inner_error0_);
		_tmp60_ = _tmp61_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp62_ = quoted;
		_tmp63_ = _tmp60_;
		_tmp60_ = NULL;
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat (_tmp62_, _tmp64_, NULL);
		_g_free0 (quoted);
		quoted = _tmp65_;
		_g_free0 (_tmp64_);
		_g_free0 (_tmp60_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp66_ = err;
		_tmp67_ = _tmp66_->message;
		_tmp68_ = g_strdup_printf ("Failed to quote body for forwarding: %s", _tmp67_);
		_tmp69_ = _tmp68_;
		g_debug ("util-email.vala:279: %s", _tmp69_);
		_g_free0 (_tmp69_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (cc_line);
		_g_free0 (to_line);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp16_);
		_g_free0 (from_line);
		_g_free0 (quoted);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = quoted;
	_g_free0 (cc_line);
	_g_free0 (to_line);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp16_);
	_g_free0 (from_line);
	return result;
}

gchar*
util_email_quote_body (GearyEmail* email,
                       const gchar* html_quote,
                       gboolean use_quotes,
                       GearyRFC822TextFormat format,
                       GError** error)
{
	GearyRFC822Message* message = NULL;
	GearyRFC822Message* _tmp0_;
	gchar* body_text = NULL;
	gboolean _tmp16_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), NULL);
	_tmp0_ = geary_email_get_message (email, &_inner_error0_);
	message = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	body_text = NULL;
	if (geary_string_is_empty (html_quote)) {
		switch (format) {
			case GEARY_RF_C822_TEXT_FORMAT_HTML:
			{
				gchar* _tmp1_ = NULL;
				GearyRFC822Message* _tmp2_;
				gchar* _tmp7_;
				_tmp2_ = message;
				if (geary_rf_c822_message_has_html_body (_tmp2_)) {
					GearyRFC822Message* _tmp3_;
					gchar* _tmp4_;
					_tmp3_ = message;
					_tmp4_ = geary_rf_c822_message_get_html_body (_tmp3_, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp4_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_tmp1_);
						_g_free0 (body_text);
						_g_object_unref0 (message);
						return NULL;
					}
				} else {
					GearyRFC822Message* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = message;
					_tmp6_ = geary_rf_c822_message_get_plain_body (_tmp5_, TRUE, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp1_);
					_tmp1_ = _tmp6_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_tmp1_);
						_g_free0 (body_text);
						_g_object_unref0 (message);
						return NULL;
					}
				}
				_tmp7_ = g_strdup (_tmp1_);
				_g_free0 (body_text);
				body_text = _tmp7_;
				_g_free0 (_tmp1_);
				break;
			}
			case GEARY_RF_C822_TEXT_FORMAT_PLAIN:
			{
				gchar* _tmp8_ = NULL;
				GearyRFC822Message* _tmp9_;
				gchar* _tmp14_;
				_tmp9_ = message;
				if (geary_rf_c822_message_has_plain_body (_tmp9_)) {
					GearyRFC822Message* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = message;
					_tmp11_ = geary_rf_c822_message_get_plain_body (_tmp10_, TRUE, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp8_);
					_tmp8_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_tmp8_);
						_g_free0 (body_text);
						_g_object_unref0 (message);
						return NULL;
					}
				} else {
					GearyRFC822Message* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = message;
					_tmp13_ = geary_rf_c822_message_get_html_body (_tmp12_, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp8_);
					_tmp8_ = _tmp13_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (_tmp8_);
						_g_free0 (body_text);
						_g_object_unref0 (message);
						return NULL;
					}
				}
				_tmp14_ = g_strdup (_tmp8_);
				_g_free0 (body_text);
				body_text = _tmp14_;
				_g_free0 (_tmp8_);
				break;
			}
			default:
			break;
		}
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (html_quote);
		_g_free0 (body_text);
		body_text = _tmp15_;
	}
	if (use_quotes) {
		const gchar* _tmp17_;
		_tmp17_ = body_text;
		_tmp16_ = !geary_string_is_empty (_tmp17_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = body_text;
		_tmp19_ = g_strdup_printf ("<blockquote type=\"cite\">%s</blockquote>", _tmp18_);
		_g_free0 (body_text);
		body_text = _tmp19_;
	}
	result = body_text;
	_g_object_unref0 (message);
	return result;
}

static inline gpointer
util_email_search_expression_factory_get_instance_private (UtilEmailSearchExpressionFactory* self)
{
	return G_STRUCT_MEMBER_P (self, UtilEmailSearchExpressionFactory_private_offset);
}

GearySearchQueryStrategy
util_email_search_expression_factory_get_default_strategy (UtilEmailSearchExpressionFactory* self)
{
	GearySearchQueryStrategy result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), 0);
	result = self->priv->_default_strategy;
	return result;
}

static void
util_email_search_expression_factory_set_default_strategy (UtilEmailSearchExpressionFactory* self,
                                                           GearySearchQueryStrategy value)
{
	GearySearchQueryStrategy old_value;
	g_return_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self));
	old_value = util_email_search_expression_factory_get_default_strategy (self);
	if (old_value != value) {
		self->priv->_default_strategy = value;
		g_object_notify_by_pspec ((GObject *) self, util_email_search_expression_factory_properties[UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY]);
	}
}

GearyAccountInformation*
util_email_search_expression_factory_get_account (UtilEmailSearchExpressionFactory* self)
{
	GearyAccountInformation* result;
	GearyAccountInformation* _tmp0_;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
util_email_search_expression_factory_set_account (UtilEmailSearchExpressionFactory* self,
                                                  GearyAccountInformation* value)
{
	GearyAccountInformation* old_value;
	g_return_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self));
	old_value = util_email_search_expression_factory_get_account (self);
	if (old_value != value) {
		GearyAccountInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, util_email_search_expression_factory_properties[UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY]);
	}
}

UtilEmailSearchExpressionFactory*
util_email_search_expression_factory_construct (GType object_type,
                                                GearySearchQueryStrategy default_strategy,
                                                GearyAccountInformation* account)
{
	UtilEmailSearchExpressionFactory * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	self = (UtilEmailSearchExpressionFactory*) geary_base_object_construct (object_type);
	util_email_search_expression_factory_set_default_strategy (self, default_strategy);
	util_email_search_expression_factory_set_account (self, account);
	util_email_search_expression_factory_construct_factories (self);
	return self;
}

UtilEmailSearchExpressionFactory*
util_email_search_expression_factory_new (GearySearchQueryStrategy default_strategy,
                                          GearyAccountInformation* account)
{
	return util_email_search_expression_factory_construct (UTIL_EMAIL_TYPE_SEARCH_EXPRESSION_FACTORY, default_strategy, account);
}

/** Constructs a search expression from the given query string. */
GeeList*
util_email_search_expression_factory_parse_query (UtilEmailSearchExpressionFactory* self,
                                                  const gchar* query)
{
	GeeLinkedList* operands = NULL;
	GeeLinkedList* _tmp0_;
	UtilEmailSearchExpressionFactoryTokeniser* tokens = NULL;
	UtilEmailSearchExpressionFactoryTokeniser* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gee_linked_list_new (GEARY_SEARCH_QUERY_TYPE_TERM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	operands = _tmp0_;
	_tmp1_ = util_email_search_expression_factory_tokeniser_new (query);
	tokens = _tmp1_;
	while (TRUE) {
		UtilEmailSearchExpressionFactoryTokeniser* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		UtilEmailSearchExpressionFactoryTokeniser* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = tokens;
		_tmp3_ = util_email_search_expression_factory_tokeniser_get_has_next (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = tokens;
		_tmp6_ = util_email_search_expression_factory_tokeniser_get_is_at_word (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			GearySearchQueryTerm* op = NULL;
			gchar* word = NULL;
			UtilEmailSearchExpressionFactoryTokeniser* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			UtilEmailSearchExpressionFactoryTokeniser* _tmp11_;
			gunichar _tmp12_;
			gunichar _tmp13_;
			GearySearchQueryTerm* _tmp20_;
			GeeLinkedList* _tmp23_;
			GearySearchQueryTerm* _tmp24_;
			op = NULL;
			_tmp8_ = tokens;
			_tmp9_ = util_email_search_expression_factory_tokeniser_consume_word (_tmp8_);
			word = _tmp9_;
			_tmp11_ = tokens;
			_tmp12_ = util_email_search_expression_factory_tokeniser_get_current_character (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ == UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_SEPARATOR) {
				UtilEmailSearchExpressionFactoryTokeniser* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = tokens;
				_tmp15_ = util_email_search_expression_factory_tokeniser_get_has_next (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = _tmp16_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				const gchar* _tmp17_;
				UtilEmailSearchExpressionFactoryTokeniser* _tmp18_;
				GearySearchQueryTerm* _tmp19_;
				_tmp17_ = word;
				_tmp18_ = tokens;
				_tmp19_ = util_email_search_expression_factory_new_extended_operator (self, _tmp17_, _tmp18_);
				_g_object_unref0 (op);
				op = _tmp19_;
			}
			_tmp20_ = op;
			if (_tmp20_ == NULL) {
				const gchar* _tmp21_;
				GearySearchQueryTerm* _tmp22_;
				_tmp21_ = word;
				_tmp22_ = util_email_search_expression_factory_new_text_all_operator (self, _tmp21_, FALSE);
				_g_object_unref0 (op);
				op = _tmp22_;
			}
			_tmp23_ = operands;
			_tmp24_ = op;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
			_g_free0 (word);
			_g_object_unref0 (op);
		} else {
			UtilEmailSearchExpressionFactoryTokeniser* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp25_ = tokens;
			_tmp26_ = util_email_search_expression_factory_tokeniser_get_is_at_quote (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_) {
				GeeLinkedList* _tmp28_;
				UtilEmailSearchExpressionFactoryTokeniser* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				GearySearchQueryTerm* _tmp32_;
				GearySearchQueryTerm* _tmp33_;
				_tmp28_ = operands;
				_tmp29_ = tokens;
				_tmp30_ = util_email_search_expression_factory_tokeniser_consume_quote (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = util_email_search_expression_factory_new_text_all_operator (self, _tmp31_, TRUE);
				_tmp33_ = _tmp32_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp33_);
				_g_object_unref0 (_tmp33_);
				_g_free0 (_tmp31_);
			} else {
				UtilEmailSearchExpressionFactoryTokeniser* _tmp34_;
				_tmp34_ = tokens;
				util_email_search_expression_factory_tokeniser_skip_to_next (_tmp34_);
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (operands, GEE_TYPE_LIST, GeeList);
	_util_email_search_expression_factory_tokeniser_unref0 (tokens);
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_extended_operator (UtilEmailSearchExpressionFactory* self,
                                                            const gchar* name,
                                                            UtilEmailSearchExpressionFactoryTokeniser* tokens)
{
	GearySearchQueryTerm* op = NULL;
	gboolean is_quoted = FALSE;
	gchar* value = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	UtilEmailSearchExpressionFactoryFactoryContext* context = NULL;
	const gchar* _tmp6_;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp15_;
	GearySearchQueryTerm* _tmp20_;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (tokens), NULL);
	op = NULL;
	util_email_search_expression_factory_tokeniser_consume_char (tokens);
	is_quoted = FALSE;
	value = NULL;
	_tmp0_ = util_email_search_expression_factory_tokeniser_get_is_at_word (tokens);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = util_email_search_expression_factory_tokeniser_consume_word (tokens);
		_g_free0 (value);
		value = _tmp2_;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = util_email_search_expression_factory_tokeniser_get_is_at_quote (tokens);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			gchar* _tmp5_;
			_tmp5_ = util_email_search_expression_factory_tokeniser_consume_quote (tokens);
			_g_free0 (value);
			value = _tmp5_;
			is_quoted = TRUE;
		}
	}
	context = NULL;
	_tmp6_ = value;
	if (_tmp6_ != NULL) {
		GeeMap* _tmp7_;
		gpointer _tmp8_;
		UtilEmailSearchExpressionFactoryFactoryContext* _tmp9_;
		_tmp7_ = self->priv->text_operators;
		_tmp8_ = gee_map_get (_tmp7_, name);
		_util_email_search_expression_factory_factory_context_unref0 (context);
		context = (UtilEmailSearchExpressionFactoryFactoryContext*) _tmp8_;
		_tmp9_ = context;
		if (_tmp9_ == NULL) {
			GeeMap* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gpointer _tmp14_;
			_tmp10_ = self->priv->boolean_operators;
			_tmp11_ = value;
			_tmp12_ = g_strdup_printf (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_TEMPLATE, name, _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_map_get (_tmp10_, _tmp13_);
			_util_email_search_expression_factory_factory_context_unref0 (context);
			context = (UtilEmailSearchExpressionFactoryFactoryContext*) _tmp14_;
			_g_free0 (_tmp13_);
		}
	}
	_tmp15_ = context;
	if (_tmp15_ != NULL) {
		UtilEmailSearchExpressionFactoryFactoryContext* _tmp16_;
		UtilEmailSearchExpressionFactoryOperatorFactory _tmp17_;
		gpointer _tmp17__target;
		const gchar* _tmp18_;
		GearySearchQueryTerm* _tmp19_;
		_tmp16_ = context;
		_tmp17_ = _tmp16_->factory;
		_tmp17__target = _tmp16_->factory_target;
		_tmp18_ = value;
		_tmp19_ = _tmp17_ (_tmp18_, is_quoted, _tmp17__target);
		_g_object_unref0 (op);
		op = _tmp19_;
	}
	_tmp20_ = op;
	if (_tmp20_ == NULL) {
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		gchar* term = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		GearySearchQueryTerm* _tmp28_;
		_tmp22_ = value;
		if (_tmp22_ == NULL) {
			gchar* _tmp23_;
			_tmp23_ = g_strdup_printf ("%s:", name);
			_g_free0 (_tmp21_);
			_tmp21_ = _tmp23_;
		} else {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp24_ = value;
			_tmp25_ = g_strdup_printf ("%s:%s", name, _tmp24_);
			_g_free0 (_tmp21_);
			_tmp21_ = _tmp25_;
		}
		_tmp26_ = g_strdup (_tmp21_);
		term = _tmp26_;
		_tmp27_ = term;
		_tmp28_ = util_email_search_expression_factory_new_text_all_operator (self, _tmp27_, FALSE);
		_g_object_unref0 (op);
		op = _tmp28_;
		_g_free0 (term);
		_g_free0 (_tmp21_);
	}
	result = op;
	_util_email_search_expression_factory_factory_context_unref0 (context);
	_g_free0 (value);
	return result;
}

static inline GearySearchQueryStrategy
util_email_search_expression_factory_get_matching_strategy (UtilEmailSearchExpressionFactory* self,
                                                            gboolean is_quoted)
{
	GearySearchQueryStrategy _tmp0_ = 0;
	GearySearchQueryStrategy result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), 0);
	if (is_quoted) {
		_tmp0_ = GEARY_SEARCH_QUERY_STRATEGY_EXACT;
	} else {
		GearySearchQueryStrategy _tmp1_;
		_tmp1_ = self->priv->_default_strategy;
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static GeeList*
util_email_search_expression_factory_get_account_addresses (UtilEmailSearchExpressionFactory* self)
{
	GeeList* mailboxes = NULL;
	GearyAccountInformation* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeLinkedList* addresses = NULL;
	GeeLinkedList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_account_information_get_sender_mailboxes (_tmp0_);
	_tmp2_ = _tmp1_;
	mailboxes = _tmp2_;
	_tmp3_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	addresses = _tmp3_;
	_tmp4_ = mailboxes;
	if (_tmp4_ != NULL) {
		{
			GeeList* _mailbox_list = NULL;
			GeeList* _tmp5_;
			gint _mailbox_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _mailbox_index = 0;
			_tmp5_ = mailboxes;
			_mailbox_list = _tmp5_;
			_tmp6_ = _mailbox_list;
			_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp8_ = _tmp7_;
			_mailbox_size = _tmp8_;
			_mailbox_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				GearyRFC822MailboxAddress* mailbox = NULL;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				GeeLinkedList* _tmp13_;
				GearyRFC822MailboxAddress* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_mailbox_index = _mailbox_index + 1;
				_tmp9_ = _mailbox_index;
				_tmp10_ = _mailbox_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _mailbox_list;
				_tmp12_ = gee_list_get (_tmp11_, _mailbox_index);
				mailbox = (GearyRFC822MailboxAddress*) _tmp12_;
				_tmp13_ = addresses;
				_tmp14_ = mailbox;
				_tmp15_ = geary_rf_c822_mailbox_address_get_address (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
				_g_object_unref0 (mailbox);
			}
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (addresses, GEE_TYPE_LIST, GeeList);
	_g_object_unref0 (mailboxes);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_attachment_name_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                               gboolean is_quoted,
                                                                                                                               gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_attachment_name_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_bcc_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                   gboolean is_quoted,
                                                                                                                   gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_bcc_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_body_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                    gboolean is_quoted,
                                                                                                                    gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_body_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_cc_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                  gboolean is_quoted,
                                                                                                                  gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_cc_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_from_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                    gboolean is_quoted,
                                                                                                                    gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_from_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_subject_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                       gboolean is_quoted,
                                                                                                                       gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_subject_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_text_to_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                  gboolean is_quoted,
                                                                                                                  gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_text_to_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_boolean_unread_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                         gboolean is_quoted,
                                                                                                                         gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_boolean_unread_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_boolean_read_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                       gboolean is_quoted,
                                                                                                                       gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_boolean_read_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static GearySearchQueryTerm*
_util_email_search_expression_factory_new_boolean_starred_operator_util_email_search_expression_factory_operator_factory (const gchar* value,
                                                                                                                          gboolean is_quoted,
                                                                                                                          gpointer self)
{
	GearySearchQueryTerm* result;
	result = util_email_search_expression_factory_new_boolean_starred_operator ((UtilEmailSearchExpressionFactory*) self, value, is_quoted);
	return result;
}

static void
util_email_search_expression_factory_construct_factories (UtilEmailSearchExpressionFactory* self)
{
	UtilEmailSearchExpressionFactoryFactoryContext* attachment_name = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	UtilEmailSearchExpressionFactoryFactoryContext* bcc = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	UtilEmailSearchExpressionFactoryFactoryContext* body = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp6_;
	GeeMap* _tmp7_;
	GeeMap* _tmp8_;
	UtilEmailSearchExpressionFactoryFactoryContext* cc = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	UtilEmailSearchExpressionFactoryFactoryContext* from = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	UtilEmailSearchExpressionFactoryFactoryContext* subject = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp15_;
	GeeMap* _tmp16_;
	GeeMap* _tmp17_;
	UtilEmailSearchExpressionFactoryFactoryContext* to = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp18_;
	GeeMap* _tmp19_;
	GeeMap* _tmp20_;
	GeeSet* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	gchar* bool_is_name = NULL;
	gchar* _tmp25_;
	gchar* bool_is_unread_value = NULL;
	gchar* _tmp26_;
	gchar* bool_is_read_value = NULL;
	gchar* _tmp27_;
	gchar* bool_is_starred_value = NULL;
	gchar* _tmp28_;
	UtilEmailSearchExpressionFactoryFactoryContext* is_unread = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp29_;
	GeeMap* _tmp30_;
	GeeMap* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	UtilEmailSearchExpressionFactoryFactoryContext* is_read = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp34_;
	GeeMap* _tmp35_;
	GeeMap* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	UtilEmailSearchExpressionFactoryFactoryContext* is_starred = NULL;
	UtilEmailSearchExpressionFactoryFactoryContext* _tmp39_;
	GeeMap* _tmp40_;
	GeeMap* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	g_return_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self));
	_tmp0_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_attachment_name_operator_util_email_search_expression_factory_operator_factory, self);
	attachment_name = _tmp0_;
	_tmp1_ = self->priv->text_operators;
	gee_map_set (_tmp1_, "attachment", attachment_name);
	_tmp2_ = self->priv->text_operators;
	gee_map_set (_tmp2_, C_ ("Search operator", "attachment"), attachment_name);
	_tmp3_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_bcc_operator_util_email_search_expression_factory_operator_factory, self);
	bcc = _tmp3_;
	_tmp4_ = self->priv->text_operators;
	gee_map_set (_tmp4_, "bcc", bcc);
	_tmp5_ = self->priv->text_operators;
	gee_map_set (_tmp5_, C_ ("Search operator", "bcc"), bcc);
	_tmp6_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_body_operator_util_email_search_expression_factory_operator_factory, self);
	body = _tmp6_;
	_tmp7_ = self->priv->text_operators;
	gee_map_set (_tmp7_, "body", body);
	_tmp8_ = self->priv->text_operators;
	gee_map_set (_tmp8_, C_ ("Search operator", "body"), body);
	_tmp9_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_cc_operator_util_email_search_expression_factory_operator_factory, self);
	cc = _tmp9_;
	_tmp10_ = self->priv->text_operators;
	gee_map_set (_tmp10_, "cc", cc);
	_tmp11_ = self->priv->text_operators;
	gee_map_set (_tmp11_, C_ ("Search operator", "cc"), cc);
	_tmp12_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_from_operator_util_email_search_expression_factory_operator_factory, self);
	from = _tmp12_;
	_tmp13_ = self->priv->text_operators;
	gee_map_set (_tmp13_, "from", from);
	_tmp14_ = self->priv->text_operators;
	gee_map_set (_tmp14_, C_ ("Search operator", "from"), from);
	_tmp15_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_subject_operator_util_email_search_expression_factory_operator_factory, self);
	subject = _tmp15_;
	_tmp16_ = self->priv->text_operators;
	gee_map_set (_tmp16_, "subject", subject);
	_tmp17_ = self->priv->text_operators;
	gee_map_set (_tmp17_, C_ ("Search operator", "subject"), subject);
	_tmp18_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_text_to_operator_util_email_search_expression_factory_operator_factory, self);
	to = _tmp18_;
	_tmp19_ = self->priv->text_operators;
	gee_map_set (_tmp19_, "to", to);
	_tmp20_ = self->priv->text_operators;
	gee_map_set (_tmp20_, C_ ("Search operator", "to"), to);
	_tmp21_ = self->priv->search_op_to_me;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), C_ ("Search operator value - mail addressed to the user", "me"));
	_tmp22_ = self->priv->search_op_to_me;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), "me");
	_tmp23_ = self->priv->search_op_from_me;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), C_ ("Search operator value - mail sent by the user", "me"));
	_tmp24_ = self->priv->search_op_from_me;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), "me");
	_tmp25_ = g_strdup (C_ ("Search operator", "is"));
	bool_is_name = _tmp25_;
	_tmp26_ = g_strdup (C_ ("'is:' search operator value", "unread"));
	bool_is_unread_value = _tmp26_;
	_tmp27_ = g_strdup (C_ ("'is:' search operator value", "read"));
	bool_is_read_value = _tmp27_;
	_tmp28_ = g_strdup (C_ ("'is:' search operator value", "starred"));
	bool_is_starred_value = _tmp28_;
	_tmp29_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_boolean_unread_operator_util_email_search_expression_factory_operator_factory, self);
	is_unread = _tmp29_;
	_tmp30_ = self->priv->boolean_operators;
	gee_map_set (_tmp30_, "is:unread", is_unread);
	_tmp31_ = self->priv->boolean_operators;
	_tmp32_ = g_strdup_printf (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_TEMPLATE, bool_is_name, bool_is_unread_value);
	_tmp33_ = _tmp32_;
	gee_map_set (_tmp31_, _tmp33_, is_unread);
	_g_free0 (_tmp33_);
	_tmp34_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_boolean_read_operator_util_email_search_expression_factory_operator_factory, self);
	is_read = _tmp34_;
	_tmp35_ = self->priv->boolean_operators;
	gee_map_set (_tmp35_, "is:read", is_read);
	_tmp36_ = self->priv->boolean_operators;
	_tmp37_ = g_strdup_printf (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_TEMPLATE, bool_is_name, bool_is_read_value);
	_tmp38_ = _tmp37_;
	gee_map_set (_tmp36_, _tmp38_, is_read);
	_g_free0 (_tmp38_);
	_tmp39_ = util_email_search_expression_factory_factory_context_new (_util_email_search_expression_factory_new_boolean_starred_operator_util_email_search_expression_factory_operator_factory, self);
	is_starred = _tmp39_;
	_tmp40_ = self->priv->boolean_operators;
	gee_map_set (_tmp40_, "is:starred", is_starred);
	_tmp41_ = self->priv->boolean_operators;
	_tmp42_ = g_strdup_printf (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_TEMPLATE, bool_is_name, bool_is_starred_value);
	_tmp43_ = _tmp42_;
	gee_map_set (_tmp41_, _tmp43_, is_starred);
	_g_free0 (_tmp43_);
	_util_email_search_expression_factory_factory_context_unref0 (is_starred);
	_util_email_search_expression_factory_factory_context_unref0 (is_read);
	_util_email_search_expression_factory_factory_context_unref0 (is_unread);
	_g_free0 (bool_is_starred_value);
	_g_free0 (bool_is_read_value);
	_g_free0 (bool_is_unread_value);
	_g_free0 (bool_is_name);
	_util_email_search_expression_factory_factory_context_unref0 (to);
	_util_email_search_expression_factory_factory_context_unref0 (subject);
	_util_email_search_expression_factory_factory_context_unref0 (from);
	_util_email_search_expression_factory_factory_context_unref0 (cc);
	_util_email_search_expression_factory_factory_context_unref0 (body);
	_util_email_search_expression_factory_factory_context_unref0 (bcc);
	_util_email_search_expression_factory_factory_context_unref0 (attachment_name);
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_all_operator (UtilEmailSearchExpressionFactory* self,
                                                            const gchar* value,
                                                            gboolean is_quoted)
{
	GearySearchQueryEmailTextTerm* _tmp0_;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ALL, util_email_search_expression_factory_get_matching_strategy (self, is_quoted), value);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_attachment_name_operator (UtilEmailSearchExpressionFactory* self,
                                                                        const gchar* value,
                                                                        gboolean is_quoted)
{
	GearySearchQueryEmailTextTerm* _tmp0_;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ATTACHMENT_NAME, util_email_search_expression_factory_get_matching_strategy (self, is_quoted), value);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_bcc_operator (UtilEmailSearchExpressionFactory* self,
                                                            const gchar* value,
                                                            gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	gboolean _tmp0_ = FALSE;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GeeSet* _tmp1_;
		_tmp1_ = self->priv->search_op_to_me;
		_tmp0_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), value);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		GearySearchQueryEmailTextTerm* _tmp4_;
		_tmp2_ = util_email_search_expression_factory_get_account_addresses (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_search_query_email_text_term_new_disjunction (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BCC, GEARY_SEARCH_QUERY_STRATEGY_EXACT, _tmp3_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp3_);
	} else {
		GearySearchQueryEmailTextTerm* _tmp5_;
		_tmp5_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BCC, GEARY_SEARCH_QUERY_STRATEGY_EXACT, value);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_body_operator (UtilEmailSearchExpressionFactory* self,
                                                             const gchar* value,
                                                             gboolean is_quoted)
{
	GearySearchQueryEmailTextTerm* _tmp0_;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BODY, util_email_search_expression_factory_get_matching_strategy (self, is_quoted), value);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_cc_operator (UtilEmailSearchExpressionFactory* self,
                                                           const gchar* value,
                                                           gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	gboolean _tmp0_ = FALSE;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GeeSet* _tmp1_;
		_tmp1_ = self->priv->search_op_to_me;
		_tmp0_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), value);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		GearySearchQueryEmailTextTerm* _tmp4_;
		_tmp2_ = util_email_search_expression_factory_get_account_addresses (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_search_query_email_text_term_new_disjunction (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_CC, GEARY_SEARCH_QUERY_STRATEGY_EXACT, _tmp3_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp3_);
	} else {
		GearySearchQueryEmailTextTerm* _tmp5_;
		_tmp5_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_CC, util_email_search_expression_factory_get_matching_strategy (self, is_quoted), value);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_from_operator (UtilEmailSearchExpressionFactory* self,
                                                             const gchar* value,
                                                             gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	gboolean _tmp0_ = FALSE;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GeeSet* _tmp1_;
		_tmp1_ = self->priv->search_op_from_me;
		_tmp0_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), value);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		GearySearchQueryEmailTextTerm* _tmp4_;
		_tmp2_ = util_email_search_expression_factory_get_account_addresses (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_search_query_email_text_term_new_disjunction (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_FROM, GEARY_SEARCH_QUERY_STRATEGY_EXACT, _tmp3_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp3_);
	} else {
		GearySearchQueryEmailTextTerm* _tmp5_;
		_tmp5_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_FROM, GEARY_SEARCH_QUERY_STRATEGY_EXACT, value);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_subject_operator (UtilEmailSearchExpressionFactory* self,
                                                                const gchar* value,
                                                                gboolean is_quoted)
{
	GearySearchQueryEmailTextTerm* _tmp0_;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_SUBJECT, util_email_search_expression_factory_get_matching_strategy (self, is_quoted), value);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_text_to_operator (UtilEmailSearchExpressionFactory* self,
                                                           const gchar* value,
                                                           gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	gboolean _tmp0_ = FALSE;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GeeSet* _tmp1_;
		_tmp1_ = self->priv->search_op_to_me;
		_tmp0_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), value);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		GearySearchQueryEmailTextTerm* _tmp4_;
		_tmp2_ = util_email_search_expression_factory_get_account_addresses (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_search_query_email_text_term_new_disjunction (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_TO, GEARY_SEARCH_QUERY_STRATEGY_EXACT, _tmp3_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp3_);
	} else {
		GearySearchQueryEmailTextTerm* _tmp5_;
		_tmp5_ = geary_search_query_email_text_term_new (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_TO, GEARY_SEARCH_QUERY_STRATEGY_EXACT, value);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_boolean_unread_operator (UtilEmailSearchExpressionFactory* self,
                                                                  const gchar* value,
                                                                  gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GearyNamedFlag* _tmp0_;
		GearyNamedFlag* _tmp1_;
		GearyNamedFlag* _tmp2_;
		GearySearchQueryEmailFlagTerm* _tmp3_;
		_tmp0_ = geary_email_flags_get_UNREAD ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_search_query_email_flag_term_new (_tmp2_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp2_);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_boolean_read_operator (UtilEmailSearchExpressionFactory* self,
                                                                const gchar* value,
                                                                gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GearyNamedFlag* _tmp0_;
		GearyNamedFlag* _tmp1_;
		GearyNamedFlag* _tmp2_;
		GearySearchQueryEmailFlagTerm* _tmp3_;
		GearySearchQueryTerm* _tmp4_;
		_tmp0_ = geary_email_flags_get_UNREAD ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_search_query_email_flag_term_new (_tmp2_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp2_);
		_tmp4_ = op;
		geary_search_query_term_set_is_negated (_tmp4_, TRUE);
	}
	result = op;
	return result;
}

static GearySearchQueryTerm*
util_email_search_expression_factory_new_boolean_starred_operator (UtilEmailSearchExpressionFactory* self,
                                                                   const gchar* value,
                                                                   gboolean is_quoted)
{
	GearySearchQueryTerm* op = NULL;
	GearySearchQueryTerm* result;
	g_return_val_if_fail (UTIL_EMAIL_IS_SEARCH_EXPRESSION_FACTORY (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	op = NULL;
	if (!is_quoted) {
		GearyNamedFlag* _tmp0_;
		GearyNamedFlag* _tmp1_;
		GearyNamedFlag* _tmp2_;
		GearySearchQueryEmailFlagTerm* _tmp3_;
		_tmp0_ = geary_email_flags_get_FLAGGED ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_search_query_email_flag_term_new (_tmp2_);
		_g_object_unref0 (op);
		op = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
		_g_object_unref0 (_tmp2_);
	}
	result = op;
	return result;
}

static UtilEmailSearchExpressionFactoryFactoryContext*
util_email_search_expression_factory_factory_context_construct (GType object_type,
                                                                UtilEmailSearchExpressionFactoryOperatorFactory factory,
                                                                gpointer factory_target)
{
	UtilEmailSearchExpressionFactoryFactoryContext* self = NULL;
	self = (UtilEmailSearchExpressionFactoryFactoryContext*) g_type_create_instance (object_type);
	self->factory = factory;
	self->factory_target = factory_target;
	return self;
}

static UtilEmailSearchExpressionFactoryFactoryContext*
util_email_search_expression_factory_factory_context_new (UtilEmailSearchExpressionFactoryOperatorFactory factory,
                                                          gpointer factory_target)
{
	return util_email_search_expression_factory_factory_context_construct (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, factory, factory_target);
}

static void
util_email_search_expression_factory_value_factory_context_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
util_email_search_expression_factory_value_factory_context_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		util_email_search_expression_factory_factory_context_unref (value->data[0].v_pointer);
	}
}

static void
util_email_search_expression_factory_value_factory_context_copy_value (const GValue* src_value,
                                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = util_email_search_expression_factory_factory_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
util_email_search_expression_factory_value_factory_context_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
util_email_search_expression_factory_value_factory_context_collect_value (GValue* value,
                                                                          guint n_collect_values,
                                                                          GTypeCValue* collect_values,
                                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UtilEmailSearchExpressionFactoryFactoryContext * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = util_email_search_expression_factory_factory_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
util_email_search_expression_factory_value_factory_context_lcopy_value (const GValue* value,
                                                                        guint n_collect_values,
                                                                        GTypeCValue* collect_values,
                                                                        guint collect_flags)
{
	UtilEmailSearchExpressionFactoryFactoryContext ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = util_email_search_expression_factory_factory_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
util_email_search_expression_factory_param_spec_factory_context (const gchar* name,
                                                                 const gchar* nick,
                                                                 const gchar* blurb,
                                                                 GType object_type,
                                                                 GParamFlags flags)
{
	UtilEmailSearchExpressionFactoryParamSpecFactoryContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
util_email_search_expression_factory_value_get_factory_context (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT), NULL);
	return value->data[0].v_pointer;
}

static void
util_email_search_expression_factory_value_set_factory_context (GValue* value,
                                                                gpointer v_object)
{
	UtilEmailSearchExpressionFactoryFactoryContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		util_email_search_expression_factory_factory_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_email_search_expression_factory_factory_context_unref (old);
	}
}

static void
util_email_search_expression_factory_value_take_factory_context (GValue* value,
                                                                 gpointer v_object)
{
	UtilEmailSearchExpressionFactoryFactoryContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_email_search_expression_factory_factory_context_unref (old);
	}
}

static void
util_email_search_expression_factory_factory_context_class_init (UtilEmailSearchExpressionFactoryFactoryContextClass * klass,
                                                                 gpointer klass_data)
{
	util_email_search_expression_factory_factory_context_parent_class = g_type_class_peek_parent (klass);
	((UtilEmailSearchExpressionFactoryFactoryContextClass *) klass)->finalize = util_email_search_expression_factory_factory_context_finalize;
}

static void
util_email_search_expression_factory_factory_context_instance_init (UtilEmailSearchExpressionFactoryFactoryContext * self,
                                                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
util_email_search_expression_factory_factory_context_finalize (UtilEmailSearchExpressionFactoryFactoryContext * obj)
{
	UtilEmailSearchExpressionFactoryFactoryContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, UtilEmailSearchExpressionFactoryFactoryContext);
	g_signal_handlers_destroy (self);
}

static GType
util_email_search_expression_factory_factory_context_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { util_email_search_expression_factory_value_factory_context_init, util_email_search_expression_factory_value_factory_context_free_value, util_email_search_expression_factory_value_factory_context_copy_value, util_email_search_expression_factory_value_factory_context_peek_pointer, "p", util_email_search_expression_factory_value_factory_context_collect_value, "p", util_email_search_expression_factory_value_factory_context_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilEmailSearchExpressionFactoryFactoryContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_email_search_expression_factory_factory_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilEmailSearchExpressionFactoryFactoryContext), 0, (GInstanceInitFunc) util_email_search_expression_factory_factory_context_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType util_email_search_expression_factory_factory_context_type_id;
	util_email_search_expression_factory_factory_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UtilEmailSearchExpressionFactoryFactoryContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return util_email_search_expression_factory_factory_context_type_id;
}

static GType
util_email_search_expression_factory_factory_context_get_type (void)
{
	static volatile gsize util_email_search_expression_factory_factory_context_type_id__once = 0;
	if (g_once_init_enter (&util_email_search_expression_factory_factory_context_type_id__once)) {
		GType util_email_search_expression_factory_factory_context_type_id;
		util_email_search_expression_factory_factory_context_type_id = util_email_search_expression_factory_factory_context_get_type_once ();
		g_once_init_leave (&util_email_search_expression_factory_factory_context_type_id__once, util_email_search_expression_factory_factory_context_type_id);
	}
	return util_email_search_expression_factory_factory_context_type_id__once;
}

static gpointer
util_email_search_expression_factory_factory_context_ref (gpointer instance)
{
	UtilEmailSearchExpressionFactoryFactoryContext * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
util_email_search_expression_factory_factory_context_unref (gpointer instance)
{
	UtilEmailSearchExpressionFactoryFactoryContext * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_FACTORY_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
util_email_search_expression_factory_tokeniser_get_instance_private (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	return G_STRUCT_MEMBER_P (self, UtilEmailSearchExpressionFactoryTokeniser_private_offset);
}

static GType
util_email_search_expression_factory_tokeniser_char_status_get_type_once (void)
{
	static const GFlagsValue values[] = {{UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_NONE, "UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_NONE", "none"}, {UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD, "UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD", "in-word"}, {UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD, "UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD", "end-word"}, {0, NULL, NULL}};
	GType util_email_search_expression_factory_tokeniser_char_status_type_id;
	util_email_search_expression_factory_tokeniser_char_status_type_id = g_flags_register_static ("UtilEmailSearchExpressionFactoryTokeniserCharStatus", values);
	return util_email_search_expression_factory_tokeniser_char_status_type_id;
}

static GType
util_email_search_expression_factory_tokeniser_char_status_get_type (void)
{
	static volatile gsize util_email_search_expression_factory_tokeniser_char_status_type_id__once = 0;
	if (g_once_init_enter (&util_email_search_expression_factory_tokeniser_char_status_type_id__once)) {
		GType util_email_search_expression_factory_tokeniser_char_status_type_id;
		util_email_search_expression_factory_tokeniser_char_status_type_id = util_email_search_expression_factory_tokeniser_char_status_get_type_once ();
		g_once_init_leave (&util_email_search_expression_factory_tokeniser_char_status_type_id__once, util_email_search_expression_factory_tokeniser_char_status_type_id);
	}
	return util_email_search_expression_factory_tokeniser_char_status_type_id__once;
}

static gboolean
util_email_search_expression_factory_tokeniser_get_has_next (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gboolean result;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), FALSE);
	_tmp0_ = self->priv->query;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->current_pos < _tmp2_;
	return result;
}

static gboolean
util_email_search_expression_factory_tokeniser_get_is_at_word (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gboolean result;
	UtilEmailSearchExpressionFactoryTokeniserCharStatus* _tmp0_;
	gint _tmp0__length1;
	UtilEmailSearchExpressionFactoryTokeniserCharStatus _tmp1_;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), FALSE);
	_tmp0_ = self->priv->char_status;
	_tmp0__length1 = self->priv->char_status_length1;
	_tmp1_ = _tmp0_[self->priv->current_pos];
	result = (_tmp1_ & UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD) == UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD;
	return result;
}

static gboolean
util_email_search_expression_factory_tokeniser_get_is_at_quote (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gboolean result;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), FALSE);
	result = self->priv->c == ((gunichar) '"');
	return result;
}

static gunichar
util_email_search_expression_factory_tokeniser_get_current_character (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gunichar result;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), 0U);
	result = self->priv->c;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static UtilEmailSearchExpressionFactoryTokeniser*
util_email_search_expression_factory_tokeniser_construct (GType object_type,
                                                          const gchar* query)
{
	UtilEmailSearchExpressionFactoryTokeniser* self = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	UtilEmailSearchExpressionFactoryTokeniserCharStatus* _tmp3_;
	UErrorCode icu_err = 0;
	UText* icu_text = NULL;
	const gchar* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_;
	gint _tmp7__length1;
	UText* _tmp8_;
	UBreakIterator* word_breaker = NULL;
	UBreakIterator* _tmp9_;
	UBreakIterator* _tmp10_;
	UText* _tmp11_;
	gint32 prev_index = 0;
	gint32 current_index = 0;
	UBreakIterator* _tmp12_;
	gint status = 0;
	g_return_val_if_fail (query != NULL, NULL);
	self = (UtilEmailSearchExpressionFactoryTokeniser*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (query);
	_g_free0 (self->priv->query);
	self->priv->query = _tmp0_;
	_tmp1_ = strlen (query);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (UtilEmailSearchExpressionFactoryTokeniserCharStatus, _tmp2_ + 1);
	self->priv->char_status = (g_free (self->priv->char_status), NULL);
	self->priv->char_status = _tmp3_;
	self->priv->char_status_length1 = _tmp2_ + 1;
	self->priv->_char_status_size_ = self->priv->char_status_length1;
	icu_err = U_ZERO_ERROR;
	_tmp4_ = self->priv->query;
	_tmp5_ = string_get_data (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = utext_openUTF8 (NULL, _tmp7_, (int64_t) _tmp7__length1, &icu_err);
	icu_text = _tmp8_;
	_tmp9_ = ubrk_open (UBRK_WORD, "en", NULL, (gint32) -1, &icu_err);
	word_breaker = _tmp9_;
	_tmp10_ = word_breaker;
	_tmp11_ = icu_text;
	ubrk_setUText (_tmp10_, _tmp11_, &icu_err);
	prev_index = (gint32) 0;
	_tmp12_ = word_breaker;
	current_index = ubrk_first (_tmp12_);
	status = 0;
	while (TRUE) {
		UBreakIterator* _tmp13_;
		gint32 _tmp14_;
		gint32 _tmp15_;
		gboolean _tmp16_ = FALSE;
		UBreakIterator* _tmp21_;
		if (!(current_index != UBRK_DONE)) {
			break;
		}
		_tmp13_ = word_breaker;
		_tmp14_ = ubrk_getRuleStatus (_tmp13_);
		_tmp15_ = _tmp14_;
		status = (gint) _tmp15_;
		if (status >= ((gint) UBRK_WORD_NONE)) {
			_tmp16_ = status < ((gint) UBRK_WORD_NONE_LIMIT);
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			UtilEmailSearchExpressionFactoryTokeniserCharStatus* _tmp20_;
			gint _tmp20__length1;
			{
				gint i = 0;
				i = (gint) prev_index;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						UtilEmailSearchExpressionFactoryTokeniserCharStatus* _tmp19_;
						gint _tmp19__length1;
						if (!_tmp17_) {
							gint _tmp18_;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp17_ = FALSE;
						if (!(i < ((gint) current_index))) {
							break;
						}
						_tmp19_ = self->priv->char_status;
						_tmp19__length1 = self->priv->char_status_length1;
						_tmp19_[i] |= UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_IN_WORD;
					}
				}
			}
			_tmp20_ = self->priv->char_status;
			_tmp20__length1 = self->priv->char_status_length1;
			_tmp20_[current_index] |= UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD;
		}
		prev_index = current_index;
		_tmp21_ = word_breaker;
		current_index = ubrk_next (_tmp21_);
	}
	util_email_search_expression_factory_tokeniser_consume_char (self);
	_ubrk_close0 (word_breaker);
	_utext_close0 (icu_text);
	return self;
}

static UtilEmailSearchExpressionFactoryTokeniser*
util_email_search_expression_factory_tokeniser_new (const gchar* query)
{
	return util_email_search_expression_factory_tokeniser_construct (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER, query);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
util_email_search_expression_factory_tokeniser_consume_char (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gint current_pos = 0;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self));
	current_pos = self->priv->next_pos;
	_tmp0_ = self->priv->query;
	string_get_next_char (_tmp0_, &self->priv->next_pos, &_tmp1_);
	self->priv->c = _tmp1_;
	self->priv->current_pos = current_pos;
}

static void
util_email_search_expression_factory_tokeniser_skip_to_next (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	g_return_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self));
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = util_email_search_expression_factory_tokeniser_get_has_next (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp4_ = util_email_search_expression_factory_tokeniser_get_is_at_quote (self);
			_tmp5_ = _tmp4_;
			_tmp1_ = !_tmp5_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = util_email_search_expression_factory_tokeniser_get_is_at_word (self);
			_tmp7_ = _tmp6_;
			_tmp0_ = !_tmp7_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		util_email_search_expression_factory_tokeniser_consume_char (self);
	}
}

static gboolean
_vala_unichar_array_contains (gunichar * stack,
                              gssize stack_length,
                              const gunichar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
util_email_search_expression_factory_tokeniser_consume_word (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gint start = 0;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), NULL);
	start = self->priv->current_pos;
	util_email_search_expression_factory_tokeniser_consume_char (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = util_email_search_expression_factory_tokeniser_get_has_next (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = self->priv->c != UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_OPERATOR_SEPARATOR;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp4_ = FALSE;
			if (_vala_unichar_array_contains (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CONTINUATION_CHARS, G_N_ELEMENTS (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CONTINUATION_CHARS), self->priv->c)) {
				_tmp4_ = TRUE;
			} else {
				UtilEmailSearchExpressionFactoryTokeniserCharStatus* _tmp5_;
				gint _tmp5__length1;
				UtilEmailSearchExpressionFactoryTokeniserCharStatus _tmp6_;
				_tmp5_ = self->priv->char_status;
				_tmp5__length1 = self->priv->char_status_length1;
				_tmp6_ = _tmp5_[self->priv->current_pos];
				_tmp4_ = !((_tmp6_ & UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD) == UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_CHAR_STATUS_END_WORD);
			}
			_tmp0_ = _tmp4_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		util_email_search_expression_factory_tokeniser_consume_char (self);
	}
	_tmp7_ = self->priv->query;
	_tmp8_ = string_slice (_tmp7_, (glong) start, (glong) self->priv->current_pos);
	result = _tmp8_;
	return result;
}

static gchar*
util_email_search_expression_factory_tokeniser_consume_quote (UtilEmailSearchExpressionFactoryTokeniser* self)
{
	gint start = 0;
	gunichar last_c = 0U;
	gchar* quote = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_IS_TOKENISER (self), NULL);
	util_email_search_expression_factory_tokeniser_consume_char (self);
	start = self->priv->current_pos;
	last_c = self->priv->c;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = util_email_search_expression_factory_tokeniser_get_has_next (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			gboolean _tmp3_ = FALSE;
			if (self->priv->c != ((gunichar) '"')) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = last_c == ((gunichar) '\\');
			}
			_tmp0_ = _tmp3_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		util_email_search_expression_factory_tokeniser_consume_char (self);
	}
	_tmp4_ = self->priv->query;
	_tmp5_ = string_slice (_tmp4_, (glong) start, (glong) self->priv->current_pos);
	quote = _tmp5_;
	util_email_search_expression_factory_tokeniser_consume_char (self);
	result = quote;
	return result;
}

static void
util_email_search_expression_factory_value_tokeniser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
util_email_search_expression_factory_value_tokeniser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		util_email_search_expression_factory_tokeniser_unref (value->data[0].v_pointer);
	}
}

static void
util_email_search_expression_factory_value_tokeniser_copy_value (const GValue* src_value,
                                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = util_email_search_expression_factory_tokeniser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
util_email_search_expression_factory_value_tokeniser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
util_email_search_expression_factory_value_tokeniser_collect_value (GValue* value,
                                                                    guint n_collect_values,
                                                                    GTypeCValue* collect_values,
                                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UtilEmailSearchExpressionFactoryTokeniser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = util_email_search_expression_factory_tokeniser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
util_email_search_expression_factory_value_tokeniser_lcopy_value (const GValue* value,
                                                                  guint n_collect_values,
                                                                  GTypeCValue* collect_values,
                                                                  guint collect_flags)
{
	UtilEmailSearchExpressionFactoryTokeniser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = util_email_search_expression_factory_tokeniser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
util_email_search_expression_factory_param_spec_tokeniser (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags)
{
	UtilEmailSearchExpressionFactoryParamSpecTokeniser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
util_email_search_expression_factory_value_get_tokeniser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER), NULL);
	return value->data[0].v_pointer;
}

static void
util_email_search_expression_factory_value_set_tokeniser (GValue* value,
                                                          gpointer v_object)
{
	UtilEmailSearchExpressionFactoryTokeniser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		util_email_search_expression_factory_tokeniser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_email_search_expression_factory_tokeniser_unref (old);
	}
}

static void
util_email_search_expression_factory_value_take_tokeniser (GValue* value,
                                                           gpointer v_object)
{
	UtilEmailSearchExpressionFactoryTokeniser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_email_search_expression_factory_tokeniser_unref (old);
	}
}

static void
util_email_search_expression_factory_tokeniser_class_init (UtilEmailSearchExpressionFactoryTokeniserClass * klass,
                                                           gpointer klass_data)
{
	util_email_search_expression_factory_tokeniser_parent_class = g_type_class_peek_parent (klass);
	((UtilEmailSearchExpressionFactoryTokeniserClass *) klass)->finalize = util_email_search_expression_factory_tokeniser_finalize;
	g_type_class_adjust_private_offset (klass, &UtilEmailSearchExpressionFactoryTokeniser_private_offset);
}

static void
util_email_search_expression_factory_tokeniser_instance_init (UtilEmailSearchExpressionFactoryTokeniser * self,
                                                              gpointer klass)
{
	self->priv = util_email_search_expression_factory_tokeniser_get_instance_private (self);
	self->priv->current_pos = -1;
	self->priv->next_pos = 0;
	self->priv->c = (gunichar) 0;
	self->ref_count = 1;
}

static void
util_email_search_expression_factory_tokeniser_finalize (UtilEmailSearchExpressionFactoryTokeniser * obj)
{
	UtilEmailSearchExpressionFactoryTokeniser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_TOKENISER, UtilEmailSearchExpressionFactoryTokeniser);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->query);
	self->priv->char_status = (g_free (self->priv->char_status), NULL);
}

static GType
util_email_search_expression_factory_tokeniser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { util_email_search_expression_factory_value_tokeniser_init, util_email_search_expression_factory_value_tokeniser_free_value, util_email_search_expression_factory_value_tokeniser_copy_value, util_email_search_expression_factory_value_tokeniser_peek_pointer, "p", util_email_search_expression_factory_value_tokeniser_collect_value, "p", util_email_search_expression_factory_value_tokeniser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilEmailSearchExpressionFactoryTokeniserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_email_search_expression_factory_tokeniser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilEmailSearchExpressionFactoryTokeniser), 0, (GInstanceInitFunc) util_email_search_expression_factory_tokeniser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType util_email_search_expression_factory_tokeniser_type_id;
	util_email_search_expression_factory_tokeniser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UtilEmailSearchExpressionFactoryTokeniser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UtilEmailSearchExpressionFactoryTokeniser_private_offset = g_type_add_instance_private (util_email_search_expression_factory_tokeniser_type_id, sizeof (UtilEmailSearchExpressionFactoryTokeniserPrivate));
	return util_email_search_expression_factory_tokeniser_type_id;
}

static GType
util_email_search_expression_factory_tokeniser_get_type (void)
{
	static volatile gsize util_email_search_expression_factory_tokeniser_type_id__once = 0;
	if (g_once_init_enter (&util_email_search_expression_factory_tokeniser_type_id__once)) {
		GType util_email_search_expression_factory_tokeniser_type_id;
		util_email_search_expression_factory_tokeniser_type_id = util_email_search_expression_factory_tokeniser_get_type_once ();
		g_once_init_leave (&util_email_search_expression_factory_tokeniser_type_id__once, util_email_search_expression_factory_tokeniser_type_id);
	}
	return util_email_search_expression_factory_tokeniser_type_id__once;
}

static gpointer
util_email_search_expression_factory_tokeniser_ref (gpointer instance)
{
	UtilEmailSearchExpressionFactoryTokeniser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
util_email_search_expression_factory_tokeniser_unref (gpointer instance)
{
	UtilEmailSearchExpressionFactoryTokeniser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TOKENISER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
util_email_search_expression_factory_class_init (UtilEmailSearchExpressionFactoryClass * klass,
                                                 gpointer klass_data)
{
	util_email_search_expression_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UtilEmailSearchExpressionFactory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_util_email_search_expression_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_util_email_search_expression_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = util_email_search_expression_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY, util_email_search_expression_factory_properties[UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY] = g_param_spec_enum ("default-strategy", "default-strategy", "default-strategy", GEARY_SEARCH_QUERY_TYPE_STRATEGY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY, util_email_search_expression_factory_properties[UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
util_email_search_expression_factory_instance_init (UtilEmailSearchExpressionFactory * self,
                                                    gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	self->priv = util_email_search_expression_factory_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, (GBoxedCopyFunc) util_email_search_expression_factory_factory_context_ref, (GDestroyNotify) util_email_search_expression_factory_factory_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->text_operators = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_TYPE_FACTORY_CONTEXT, (GBoxedCopyFunc) util_email_search_expression_factory_factory_context_ref, (GDestroyNotify) util_email_search_expression_factory_factory_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->boolean_operators = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->search_op_to_me = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->search_op_from_me = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
}

static void
util_email_search_expression_factory_finalize (GObject * obj)
{
	UtilEmailSearchExpressionFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_EMAIL_TYPE_SEARCH_EXPRESSION_FACTORY, UtilEmailSearchExpressionFactory);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->text_operators);
	_g_object_unref0 (self->priv->boolean_operators);
	_g_object_unref0 (self->priv->search_op_to_me);
	_g_object_unref0 (self->priv->search_op_from_me);
	G_OBJECT_CLASS (util_email_search_expression_factory_parent_class)->finalize (obj);
}

/**
 * Parses a human-entered email query string as a query expression.
 *
 * @see Geary.SearchQuery.Term
 */
static GType
util_email_search_expression_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UtilEmailSearchExpressionFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_email_search_expression_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilEmailSearchExpressionFactory), 0, (GInstanceInitFunc) util_email_search_expression_factory_instance_init, NULL };
	GType util_email_search_expression_factory_type_id;
	util_email_search_expression_factory_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "UtilEmailSearchExpressionFactory", &g_define_type_info, 0);
	UtilEmailSearchExpressionFactory_private_offset = g_type_add_instance_private (util_email_search_expression_factory_type_id, sizeof (UtilEmailSearchExpressionFactoryPrivate));
	return util_email_search_expression_factory_type_id;
}

GType
util_email_search_expression_factory_get_type (void)
{
	static volatile gsize util_email_search_expression_factory_type_id__once = 0;
	if (g_once_init_enter (&util_email_search_expression_factory_type_id__once)) {
		GType util_email_search_expression_factory_type_id;
		util_email_search_expression_factory_type_id = util_email_search_expression_factory_get_type_once ();
		g_once_init_leave (&util_email_search_expression_factory_type_id__once, util_email_search_expression_factory_type_id);
	}
	return util_email_search_expression_factory_type_id__once;
}

static void
_vala_util_email_search_expression_factory_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	UtilEmailSearchExpressionFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_EMAIL_TYPE_SEARCH_EXPRESSION_FACTORY, UtilEmailSearchExpressionFactory);
	switch (property_id) {
		case UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY:
		g_value_set_enum (value, util_email_search_expression_factory_get_default_strategy (self));
		break;
		case UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY:
		g_value_set_object (value, util_email_search_expression_factory_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_util_email_search_expression_factory_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	UtilEmailSearchExpressionFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UTIL_EMAIL_TYPE_SEARCH_EXPRESSION_FACTORY, UtilEmailSearchExpressionFactory);
	switch (property_id) {
		case UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_DEFAULT_STRATEGY_PROPERTY:
		util_email_search_expression_factory_set_default_strategy (self, g_value_get_enum (value));
		break;
		case UTIL_EMAIL_SEARCH_EXPRESSION_FACTORY_ACCOUNT_PROPERTY:
		util_email_search_expression_factory_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

