/* imap-db-gc.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-db-gc.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include "geary-engine.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define GEARY_IMAP_DB_GC_REAP_DAYS_SPAN 10
#define GEARY_IMAP_DB_GC_VACUUM_DAYS_SPAN 30
#define GEARY_IMAP_DB_GC_VACUUM_WHEN_REAPED_REACHES 10000
#define GEARY_IMAP_DB_GC_VACUUM_WHEN_FREE_BYTES ((glong) ((500 * 1024) * 1024))
#define GEARY_IMAP_DB_GC_UNLINKED_DAYS 30
#define GEARY_IMAP_DB_GC_SLEEP_MSEC ((guint) 15)
#define GEARY_IMAP_DB_GC_OPS_PER_SLEEP_CYCLE 10
#define GEARY_IMAP_DB_GC_REAP_ATTACHMENT_PER 5
#define GEARY_IMAP_DB_GC_ENUM_DIR_PER 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_IMAP_DB_TYPE_GC (geary_imap_db_gc_get_type ())
#define GEARY_IMAP_DB_GC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGC))
#define GEARY_IMAP_DB_GC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGCClass))
#define GEARY_IMAP_DB_IS_GC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_GC))
#define GEARY_IMAP_DB_IS_GC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_GC))
#define GEARY_IMAP_DB_GC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGCClass))

typedef struct _GearyImapDBGC GearyImapDBGC;
typedef struct _GearyImapDBGCClass GearyImapDBGCClass;
typedef struct _GearyImapDBGCPrivate GearyImapDBGCPrivate;

#define GEARY_IMAP_DB_TYPE_DATABASE (geary_imap_db_database_get_type ())
#define GEARY_IMAP_DB_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase))
#define GEARY_IMAP_DB_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabaseClass))
#define GEARY_IMAP_DB_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_DATABASE))
#define GEARY_IMAP_DB_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_DATABASE))
#define GEARY_IMAP_DB_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabaseClass))

typedef struct _GearyImapDBDatabase GearyImapDBDatabase;
typedef struct _GearyImapDBDatabaseClass GearyImapDBDatabaseClass;
typedef enum  {
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_NONE = 0,
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP = 1 << 0,
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM = 1 << 1
} GearyImapDBGCRecommendedOperation;

#define GEARY_IMAP_DB_GC_TYPE_RECOMMENDED_OPERATION (geary_imap_db_gc_recommended_operation_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_imap_db_gc_unref0(var) ((var == NULL) ? NULL : (var = (geary_imap_db_gc_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapDbGcShouldRunAsyncData GearyImapDbGcShouldRunAsyncData;
typedef struct _GearyImapDbGcVacuumAsyncData GearyImapDbGcVacuumAsyncData;
typedef struct _Block89Data Block89Data;
typedef struct _GearyImapDbGcInternalVacuumAsyncData GearyImapDbGcInternalVacuumAsyncData;
typedef struct _GearyImapDbGcReapAsyncData GearyImapDbGcReapAsyncData;
typedef struct _Block90Data Block90Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapDbGcInternalReapAsyncData GearyImapDbGcInternalReapAsyncData;
typedef struct _Block91Data Block91Data;

#define GEARY_IMAP_DB_TYPE_ATTACHMENT (geary_imap_db_attachment_get_type ())
#define GEARY_IMAP_DB_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment))
#define GEARY_IMAP_DB_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))
#define GEARY_IMAP_DB_IS_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_IS_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_ATTACHMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))

typedef struct _GearyImapDBAttachment GearyImapDBAttachment;
typedef struct _GearyImapDBAttachmentClass GearyImapDBAttachmentClass;
typedef struct _GearyImapDBDatabasePrivate GearyImapDBDatabasePrivate;
typedef struct _GearyImapDbGcReapMessageAsyncData GearyImapDbGcReapMessageAsyncData;
typedef struct _Block92Data Block92Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyImapDbGcReapAttachmentFilesAsyncData GearyImapDbGcReapAttachmentFilesAsyncData;
typedef struct _GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData;
typedef struct _Block93Data Block93Data;
typedef struct _GearyImapDbGcHasMessageRowsData GearyImapDbGcHasMessageRowsData;
typedef struct _Block94Data Block94Data;
typedef struct _GearyImapDbGcFetchGcInfoAsyncData GearyImapDbGcFetchGcInfoAsyncData;
typedef struct _GearyImapDBParamSpecGC GearyImapDBParamSpecGC;

struct _GearyImapDBGC {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GearyImapDBGCPrivate * priv;
};

struct _GearyImapDBGCClass {
	GTypeClass parent_class;
	void (*finalize) (GearyImapDBGC *self);
};

struct _GearyImapDBGCPrivate {
	gboolean _is_running;
	GearyImapDBDatabase* db;
	gint priority;
};

struct _GearyImapDbGcShouldRunAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	GearyImapDBGCRecommendedOperation result;
	GDateTime* last_reap_time;
	GDateTime* last_vacuum_time;
	gint reaped_messages_since_last_vacuum;
	gint64 free_page_bytes;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GearyImapDBGCRecommendedOperation op;
	gboolean _tmp18_;
	GDateTime* now;
	GDateTime* _tmp19_;
	gint64 days;
	GDateTime* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GDateTime* _tmp23_;
	GDateTime* _tmp24_;
	gint64 _tmp25_;
	gint64 _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GDateTime* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gboolean vacuum_permitted;
	GDateTime* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GDateTime* _tmp41_;
	GDateTime* _tmp42_;
	gint64 _tmp43_;
	gint64 _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gboolean fragmentation_exists;
	gboolean too_much_free_space;
	gboolean _tmp53_;
	gboolean _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GError* _inner_error0_;
};

struct _GearyImapDbGcVacuumAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _Block89Data {
	int _ref_count_;
	GearyImapDBGC* self;
	GDateTime* last_vacuum_time;
	GearyDbDatabaseConnection* cx;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyImapDbGcInternalVacuumAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	Block89Data* _data89_;
	GearyImapDBDatabase* _tmp0_;
	GearyDbDatabaseConnection* _tmp1_;
	GearyNonblockingConcurrent* _tmp2_;
	GearyNonblockingConcurrent* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GearyDbDatabaseConnection* _tmp6_;
	GError* _inner_error0_;
};

struct _GearyImapDbGcReapAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _Block90Data {
	int _ref_count_;
	GearyImapDBGC* self;
	GDateTime* reap_date;
	GeeHashSet* reap_message_ids;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyImapDbGcInternalReapAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	Block90Data* _data90_;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GeeHashSet* _tmp12_;
	GearyImapDBDatabase* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GeeHashSet* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint count;
	GeeIterator* _reap_message_id_it;
	GeeHashSet* _tmp19_;
	GeeIterator* _tmp20_;
	GeeIterator* _tmp21_;
	gint64 reap_message_id;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	gint64* _tmp24_;
	gint64 _tmp25_;
	gint _tmp26_;
	GError* err;
	GError* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gboolean _tmp40_;
	gint reaped;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GearyImapDBDatabase* _tmp48_;
	GError* _inner_error0_;
};

struct _Block91Data {
	int _ref_count_;
	GearyImapDBGC* self;
	gint64 message_id;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyImapDBDatabase {
	GearyDbVersionedDatabase parent_instance;
	GFile* attachments_path;
	GearyImapDBDatabasePrivate * priv;
};

struct _GearyImapDBDatabaseClass {
	GearyDbVersionedDatabaseClass parent_class;
};

struct _GearyImapDbGcReapMessageAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	gint64 message_id;
	GCancellable* cancellable;
	Block91Data* _data91_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	GError* _inner_error0_;
};

struct _Block92Data {
	int _ref_count_;
	GearyImapDBGC* self;
	gint deleted;
	gint limit;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyImapDbGcReapAttachmentFilesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	gint limit;
	GCancellable* cancellable;
	gint result;
	Block92Data* _data92_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GFile* current;
	GCancellable* cancellable;
	gboolean empty;
	gint result;
	GFile* _tmp0_;
	GearyImapDBDatabase* _tmp1_;
	GFile* _tmp2_;
	GFile* current_dir;
	GFile* _tmp3_;
	gint deleted;
	GFileEnumerator* file_enum;
	GFile* _tmp4_;
	GFileEnumerator* _tmp5_;
	gboolean _tmp6_;
	GList* infos;
	GFileEnumerator* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp11_;
	GFileInfo* info;
	GFileInfo* _tmp12_;
	GFile* child;
	GFile* _tmp13_;
	GFileInfo* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gboolean child_empty;
	gint _tmp17_;
	GFile* _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gchar* failure;
	gboolean _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	GError* err;
	GError* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	GFileEnumerator* _tmp38_;
	GError* _inner_error0_;
};

struct _Block93Data {
	int _ref_count_;
	GearyImapDBGC* self;
	gboolean ret;
	gpointer _async_data_;
};

struct _GearyImapDbGcHasMessageRowsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	gboolean result;
	Block93Data* _data93_;
	GearyImapDBDatabase* _tmp0_;
	GError* _inner_error0_;
};

struct _Block94Data {
	int _ref_count_;
	GearyImapDBGC* self;
	gint64 last_reap_time_t;
	gint64 last_vacuum_time_t;
	gint64 free_page_count;
	gint reaped_count;
	gint page_size;
	gpointer _async_data_;
};

struct _GearyImapDbGcFetchGcInfoAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBGC* self;
	GCancellable* cancellable;
	GDateTime* last_reap_time;
	GDateTime* last_vacuum_time;
	gint reaped_messages_since_last_vacuum;
	gint64 free_page_bytes;
	Block94Data* _data94_;
	GearyImapDBDatabase* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GError* _inner_error0_;
};

struct _GearyImapDBParamSpecGC {
	GParamSpec parent_instance;
};

static gint GearyImapDBGC_private_offset;
static gpointer geary_imap_db_gc_parent_class = NULL;

VALA_EXTERN gpointer geary_imap_db_gc_ref (gpointer instance);
VALA_EXTERN void geary_imap_db_gc_unref (gpointer instance);
VALA_EXTERN GParamSpec* geary_imap_db_param_spec_gc (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void geary_imap_db_value_set_gc (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void geary_imap_db_value_take_gc (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer geary_imap_db_value_get_gc (const GValue* value);
VALA_EXTERN GType geary_imap_db_gc_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_gc_recommended_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean geary_imap_db_gc_get_is_running (GearyImapDBGC* self);
static void geary_imap_db_gc_set_is_running (GearyImapDBGC* self,
                                      gboolean value);
VALA_EXTERN GearyImapDBGC* geary_imap_db_gc_new (GearyImapDBDatabase* db,
                                     gint priority);
VALA_EXTERN GearyImapDBGC* geary_imap_db_gc_construct (GType object_type,
                                           GearyImapDBDatabase* db,
                                           gint priority);
static void geary_imap_db_gc_should_run_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_db_gc_should_run_async (GearyImapDBGC* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GearyImapDBGCRecommendedOperation geary_imap_db_gc_should_run_finish (GearyImapDBGC* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static gboolean geary_imap_db_gc_should_run_async_co (GearyImapDbGcShouldRunAsyncData* _data_);
static void geary_imap_db_gc_fetch_gc_info_async (GearyImapDBGC* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void geary_imap_db_gc_fetch_gc_info_finish (GearyImapDBGC* self,
                                            GAsyncResult* _res_,
                                            GDateTime** last_reap_time,
                                            GDateTime** last_vacuum_time,
                                            gint* reaped_messages_since_last_vacuum,
                                            gint64* free_page_bytes,
                                            GError** error);
static void geary_imap_db_gc_should_run_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN gchar* geary_imap_db_gc_to_string (GearyImapDBGC* self);
static void geary_imap_db_gc_has_message_rows (GearyImapDBGC* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean geary_imap_db_gc_has_message_rows_finish (GearyImapDBGC* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gint64 geary_imap_db_gc_elapsed_days (GDateTime* end,
                                      GDateTime* start,
                                      gint64* days);
static void geary_imap_db_gc_vacuum_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_db_gc_vacuum_async (GearyImapDBGC* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void geary_imap_db_gc_vacuum_finish (GearyImapDBGC* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static gboolean geary_imap_db_gc_vacuum_async_co (GearyImapDbGcVacuumAsyncData* _data_);
static void geary_imap_db_gc_internal_vacuum_async (GearyImapDBGC* self,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void geary_imap_db_gc_internal_vacuum_finish (GearyImapDBGC* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void geary_imap_db_gc_vacuum_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void geary_imap_db_gc_internal_vacuum_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_internal_vacuum_async_co (GearyImapDbGcInternalVacuumAsyncData* _data_);
static Block89Data* block89_data_ref (Block89Data* _data89_);
static void block89_data_unref (void * _userdata_);
static void geary_imap_db_gc_internal_vacuum_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void __lambda27_ (Block89Data* _data89_,
                  GError** error);
static void ___lambda27__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static GearyDbTransactionOutcome __lambda28_ (Block89Data* _data89_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda28__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_reap_async_data_free (gpointer _data);
VALA_EXTERN void geary_imap_db_gc_reap_async (GearyImapDBGC* self,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void geary_imap_db_gc_reap_finish (GearyImapDBGC* self,
                                   GAsyncResult* _res_,
                                   GError** error);
static gboolean geary_imap_db_gc_reap_async_co (GearyImapDbGcReapAsyncData* _data_);
static void geary_imap_db_gc_internal_reap_async (GearyImapDBGC* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void geary_imap_db_gc_internal_reap_finish (GearyImapDBGC* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void geary_imap_db_gc_reap_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void geary_imap_db_gc_internal_reap_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_internal_reap_async_co (GearyImapDbGcInternalReapAsyncData* _data_);
static Block90Data* block90_data_ref (Block90Data* _data90_);
static void block90_data_unref (void * _userdata_);
static guint _geary_collection_int64_hash_func_gee_hash_data_func (gconstpointer v,
                                                            gpointer self);
static gboolean _geary_collection_int64_equal_func_gee_equal_data_func (gconstpointer a,
                                                                 gconstpointer b,
                                                                 gpointer self);
static gint64* _int64_dup (gint64* self);
static GearyDbTransactionOutcome __lambda29_ (Block90Data* _data90_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda29__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_internal_reap_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_imap_db_gc_reap_message_async (GearyImapDBGC* self,
                                          gint64 message_id,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void geary_imap_db_gc_reap_message_finish (GearyImapDBGC* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void geary_imap_db_gc_reap_attachment_files_async (GearyImapDBGC* self,
                                                   gint limit,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gint geary_imap_db_gc_reap_attachment_files_finish (GearyImapDBGC* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void geary_imap_db_gc_delete_empty_attachment_directories_async (GearyImapDBGC* self,
                                                                 GFile* current,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gint geary_imap_db_gc_delete_empty_attachment_directories_finish (GearyImapDBGC* self,
                                                                  GAsyncResult* _res_,
                                                                  gboolean* empty,
                                                                  GError** error);
static GearyDbTransactionOutcome __lambda32_ (Block90Data* _data90_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda32__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_reap_message_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_reap_message_async_co (GearyImapDbGcReapMessageAsyncData* _data_);
static Block91Data* block91_data_ref (Block91Data* _data91_);
static void block91_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda30_ (Block91Data* _data91_,
                                       GearyDbConnection* cx,
                                       GError** error);
VALA_EXTERN GType geary_imap_db_attachment_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeList* geary_imap_db_attachment_list_attachments (GearyDbConnection* cx,
                                                    GFile* attachments_path,
                                                    gint64 message_id,
                                                    GCancellable* cancellable,
                                                    GError** error);
static GearyDbTransactionOutcome ___lambda30__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_reap_message_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void geary_imap_db_gc_reap_attachment_files_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_reap_attachment_files_async_co (GearyImapDbGcReapAttachmentFilesAsyncData* _data_);
static Block92Data* block92_data_ref (Block92Data* _data92_);
static void block92_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda31_ (Block92Data* _data92_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda31__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_reap_attachment_files_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_imap_db_gc_delete_empty_attachment_directories_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_delete_empty_attachment_directories_async_co (GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_);
static void geary_imap_db_gc_delete_empty_attachment_directories_async_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void geary_imap_db_gc_has_message_rows_data_free (gpointer _data);
static gboolean geary_imap_db_gc_has_message_rows_co (GearyImapDbGcHasMessageRowsData* _data_);
static Block93Data* block93_data_ref (Block93Data* _data93_);
static void block93_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda26_ (Block93Data* _data93_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda26__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_has_message_rows_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void geary_imap_db_gc_fetch_gc_info_async_data_free (gpointer _data);
static gboolean geary_imap_db_gc_fetch_gc_info_async_co (GearyImapDbGcFetchGcInfoAsyncData* _data_);
static Block94Data* block94_data_ref (Block94Data* _data94_);
static void block94_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda25_ (Block94Data* _data94_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda25__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_gc_fetch_gc_info_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_imap_db_gc_finalize (GearyImapDBGC * obj);
static GType geary_imap_db_gc_get_type_once (void);

static inline gpointer
geary_imap_db_gc_get_instance_private (GearyImapDBGC* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDBGC_private_offset);
}

/**
     * Operation(s) recommended by {@link should_run_async}.
     */
 G_GNUC_NO_INLINE static GType
geary_imap_db_gc_recommended_operation_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_NONE, "GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_NONE", "none"}, {GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP, "GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP", "reap"}, {GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM, "GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM", "vacuum"}, {0, NULL, NULL}};
	GType geary_imap_db_gc_recommended_operation_type_id;
	geary_imap_db_gc_recommended_operation_type_id = g_flags_register_static ("GearyImapDBGCRecommendedOperation", values);
	return geary_imap_db_gc_recommended_operation_type_id;
}

GType
geary_imap_db_gc_recommended_operation_get_type (void)
{
	static gsize geary_imap_db_gc_recommended_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_gc_recommended_operation_type_id__once)) {
		GType geary_imap_db_gc_recommended_operation_type_id;
		geary_imap_db_gc_recommended_operation_type_id = geary_imap_db_gc_recommended_operation_get_type_once ();
		g_once_init_leave (&geary_imap_db_gc_recommended_operation_type_id__once, geary_imap_db_gc_recommended_operation_type_id);
	}
	return geary_imap_db_gc_recommended_operation_type_id__once;
}

gboolean
geary_imap_db_gc_get_is_running (GearyImapDBGC* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_GC (self), FALSE);
	result = self->priv->_is_running;
	return result;
}

static void
geary_imap_db_gc_set_is_running (GearyImapDBGC* self,
                                 gboolean value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	self->priv->_is_running = value;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapDBGC*
geary_imap_db_gc_construct (GType object_type,
                            GearyImapDBDatabase* db,
                            gint priority)
{
	GearyImapDBGC* self = NULL;
	GearyImapDBDatabase* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_DATABASE (db), NULL);
	self = (GearyImapDBGC*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (db);
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp0_;
	self->priv->priority = priority;
	return self;
}

GearyImapDBGC*
geary_imap_db_gc_new (GearyImapDBDatabase* db,
                      gint priority)
{
	return geary_imap_db_gc_construct (GEARY_IMAP_DB_TYPE_GC, db, priority);
}

static void
geary_imap_db_gc_should_run_async_data_free (gpointer _data)
{
	GearyImapDbGcShouldRunAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcShouldRunAsyncData, _data_);
}

static gpointer
_geary_imap_db_gc_ref0 (gpointer self)
{
	return self ? geary_imap_db_gc_ref (self) : NULL;
}

void
geary_imap_db_gc_should_run_async (GearyImapDBGC* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyImapDbGcShouldRunAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcShouldRunAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_should_run_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_should_run_async_co (_data_);
}

GearyImapDBGCRecommendedOperation
geary_imap_db_gc_should_run_finish (GearyImapDBGC* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GearyImapDBGCRecommendedOperation result;
	GearyImapDbGcShouldRunAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0U;
	}
	result = _data_->result;
	return result;
}

/**
     * Determines if the GC should be executed.
     *
     * @return a recommendation for the operation client to execute.
     */
static void
geary_imap_db_gc_should_run_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GearyImapDbGcShouldRunAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_should_run_async_co (_data_);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gboolean
geary_imap_db_gc_should_run_async_co (GearyImapDbGcShouldRunAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = 0LL;
	_data_->_state_ = 1;
	geary_imap_db_gc_fetch_gc_info_async (_data_->self, _data_->cancellable, geary_imap_db_gc_should_run_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_db_gc_fetch_gc_info_finish (_data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_tmp2_, &_data_->_tmp3_, &_data_->_inner_error0_);
	_g_date_time_unref0 (_data_->last_reap_time);
	_data_->last_reap_time = _data_->_tmp0_;
	_g_date_time_unref0 (_data_->last_vacuum_time);
	_data_->last_vacuum_time = _data_->_tmp1_;
	_data_->reaped_messages_since_last_vacuum = _data_->_tmp2_;
	_data_->free_page_bytes = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_date_time_unref0 (_data_->last_vacuum_time);
		_g_date_time_unref0 (_data_->last_reap_time);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->last_reap_time;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->last_reap_time;
		_data_->_tmp7_ = g_date_time_to_string (_data_->_tmp6_);
		_g_free0 (_data_->_tmp4_);
		_data_->_tmp4_ = _data_->_tmp7_;
	} else {
		_data_->_tmp8_ = g_strdup ("never");
		_g_free0 (_data_->_tmp4_);
		_data_->_tmp4_ = _data_->_tmp8_;
	}
	_data_->_tmp10_ = _data_->last_vacuum_time;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = _data_->last_vacuum_time;
		_data_->_tmp12_ = g_date_time_to_string (_data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
		_data_->_tmp9_ = _data_->_tmp12_;
	} else {
		_data_->_tmp13_ = g_strdup ("never");
		_g_free0 (_data_->_tmp9_);
		_data_->_tmp9_ = _data_->_tmp13_;
	}
	_data_->_tmp14_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->free_page_bytes);
	_data_->_tmp17_ = _data_->_tmp16_;
	g_debug ("imap-db-gc.vala:104: [%s] GC state: last_reap_time=%s last_vacuum_time" \
"=%s reaped_messages_since=%d free_page_bytes=%s", _data_->_tmp15_, _data_->_tmp4_, _data_->_tmp9_, _data_->reaped_messages_since_last_vacuum, _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_g_free0 (_data_->_tmp15_);
	_data_->op = GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_NONE;
	_data_->_state_ = 2;
	geary_imap_db_gc_has_message_rows (_data_->self, _data_->cancellable, geary_imap_db_gc_should_run_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp18_ = geary_imap_db_gc_has_message_rows_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_tmp9_);
		_g_free0 (_data_->_tmp4_);
		_g_date_time_unref0 (_data_->last_vacuum_time);
		_g_date_time_unref0 (_data_->last_reap_time);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_tmp18_) {
		_data_->result = _data_->op;
		_g_free0 (_data_->_tmp9_);
		_g_free0 (_data_->_tmp4_);
		_g_date_time_unref0 (_data_->last_vacuum_time);
		_g_date_time_unref0 (_data_->last_reap_time);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = g_date_time_new_now_local ();
	_data_->now = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->last_reap_time;
	if (_data_->_tmp20_ == NULL) {
		_data_->_tmp21_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp22_ = _data_->_tmp21_;
		g_debug ("imap-db-gc.vala:122: [%s] Recommending reaping: never completed", _data_->_tmp22_);
		_g_free0 (_data_->_tmp22_);
		_data_->op |= GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP;
	} else {
		_data_->_tmp23_ = _data_->now;
		_data_->_tmp24_ = _data_->last_reap_time;
		_data_->_tmp25_ = 0LL;
		_data_->_tmp26_ = geary_imap_db_gc_elapsed_days (_data_->_tmp23_, _data_->_tmp24_, &_data_->_tmp25_);
		_data_->days = _data_->_tmp25_;
		if (_data_->_tmp26_ >= ((gint64) GEARY_IMAP_DB_GC_REAP_DAYS_SPAN)) {
			_data_->_tmp27_ = geary_imap_db_gc_to_string (_data_->self);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->days);
			_data_->_tmp30_ = _data_->_tmp29_;
			g_debug ("imap-db-gc.vala:126: [%s] Recommending reaping: %s days since last run", _data_->_tmp28_, _data_->_tmp30_);
			_g_free0 (_data_->_tmp30_);
			_g_free0 (_data_->_tmp28_);
			_data_->op |= GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP;
		} else {
			_data_->_tmp31_ = geary_imap_db_gc_to_string (_data_->self);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = _data_->last_reap_time;
			_data_->_tmp34_ = g_date_time_to_string (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->days);
			_data_->_tmp37_ = _data_->_tmp36_;
			g_debug ("imap-db-gc.vala:131: [%s] Reaping last completed on %s (%s days ago)", _data_->_tmp32_, _data_->_tmp35_, _data_->_tmp37_);
			_g_free0 (_data_->_tmp37_);
			_g_free0 (_data_->_tmp35_);
			_g_free0 (_data_->_tmp32_);
		}
	}
	_data_->days = (gint64) 0;
	_data_->_tmp38_ = _data_->last_vacuum_time;
	if (_data_->_tmp38_ == NULL) {
		_data_->_tmp39_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp40_ = _data_->_tmp39_;
		g_debug ("imap-db-gc.vala:141: [%s] Database never vacuumed (%d messages reaped)", _data_->_tmp40_, _data_->reaped_messages_since_last_vacuum);
		_g_free0 (_data_->_tmp40_);
		_data_->vacuum_permitted = TRUE;
	} else {
		_data_->_tmp41_ = _data_->now;
		_data_->_tmp42_ = _data_->last_vacuum_time;
		_data_->_tmp43_ = 0LL;
		_data_->_tmp44_ = geary_imap_db_gc_elapsed_days (_data_->_tmp41_, _data_->_tmp42_, &_data_->_tmp43_);
		_data_->days = _data_->_tmp43_;
		if (_data_->_tmp44_ >= ((gint64) GEARY_IMAP_DB_GC_VACUUM_DAYS_SPAN)) {
			_data_->_tmp45_ = geary_imap_db_gc_to_string (_data_->self);
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp47_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->days);
			_data_->_tmp48_ = _data_->_tmp47_;
			g_debug ("imap-db-gc.vala:146: [%s] Database vacuuming permitted (%s days since " \
"last run, %d messages reaped since)", _data_->_tmp46_, _data_->_tmp48_, _data_->reaped_messages_since_last_vacuum);
			_g_free0 (_data_->_tmp48_);
			_g_free0 (_data_->_tmp46_);
			_data_->vacuum_permitted = TRUE;
		} else {
			_data_->_tmp49_ = geary_imap_db_gc_to_string (_data_->self);
			_data_->_tmp50_ = _data_->_tmp49_;
			_data_->_tmp51_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->days);
			_data_->_tmp52_ = _data_->_tmp51_;
			g_debug ("imap-db-gc.vala:151: [%s] Database vacuuming not permitted (%s days si" \
"nce last run, %d messages reaped since)", _data_->_tmp50_, _data_->_tmp52_, _data_->reaped_messages_since_last_vacuum);
			_g_free0 (_data_->_tmp52_);
			_g_free0 (_data_->_tmp50_);
			_data_->vacuum_permitted = FALSE;
		}
	}
	_data_->fragmentation_exists = _data_->reaped_messages_since_last_vacuum >= GEARY_IMAP_DB_GC_VACUUM_WHEN_REAPED_REACHES;
	_data_->too_much_free_space = _data_->free_page_bytes >= ((gint64) GEARY_IMAP_DB_GC_VACUUM_WHEN_FREE_BYTES);
	if (_data_->vacuum_permitted) {
		if (_data_->fragmentation_exists) {
			_data_->_tmp54_ = TRUE;
		} else {
			_data_->_tmp54_ = _data_->too_much_free_space;
		}
		_data_->_tmp53_ = _data_->_tmp54_;
	} else {
		_data_->_tmp53_ = FALSE;
	}
	if (_data_->_tmp53_) {
		_data_->_tmp55_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->days);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->free_page_bytes);
		_data_->_tmp60_ = _data_->_tmp59_;
		g_debug ("imap-db-gc.vala:164: [%s] Recommending database vacuum: %d messages re" \
"aped since last vacuum %s days ago, %s free bytes in file", _data_->_tmp56_, _data_->reaped_messages_since_last_vacuum, _data_->_tmp58_, _data_->_tmp60_);
		_g_free0 (_data_->_tmp60_);
		_g_free0 (_data_->_tmp58_);
		_g_free0 (_data_->_tmp56_);
		_data_->op |= GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM;
	}
	_data_->result = _data_->op;
	_g_date_time_unref0 (_data_->now);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp4_);
	_g_date_time_unref0 (_data_->last_vacuum_time);
	_g_date_time_unref0 (_data_->last_reap_time);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint64
geary_imap_db_gc_elapsed_days (GDateTime* end,
                               GDateTime* start,
                               gint64* days)
{
	gint64 _vala_days = 0LL;
	gint64 result;
	g_return_val_if_fail (end != NULL, 0LL);
	g_return_val_if_fail (start != NULL, 0LL);
	_vala_days = (gint64) (g_date_time_difference (end, start) / G_TIME_SPAN_DAY);
	result = _vala_days;
	if (days) {
		*days = _vala_days;
	}
	return result;
}

static void
geary_imap_db_gc_vacuum_async_data_free (gpointer _data)
{
	GearyImapDbGcVacuumAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcVacuumAsyncData, _data_);
}

void
geary_imap_db_gc_vacuum_async (GearyImapDBGC* self,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GearyImapDbGcVacuumAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcVacuumAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_vacuum_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_vacuum_async_co (_data_);
}

void
geary_imap_db_gc_vacuum_finish (GearyImapDBGC* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GearyImapDbGcVacuumAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Vacuum the database, reducing fragmentation and coalescing free space, to optimize access
     * and reduce disk usage.
     *
     * Should only be called from the foreground thread.
     *
     * Since this will lock the database for an extended period of time, the user should be
     * presented a busy indicator.  Operations against the database should not be expected to run
     * until this completes.  Cancellation will not work once vacuuming has started.
     *
     * @throws Geary.EngineError.ALREADY_OPEN if {@link is_running} is true.
     */
static void
geary_imap_db_gc_vacuum_async_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GearyImapDbGcVacuumAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_vacuum_async_co (_data_);
}

static gboolean
geary_imap_db_gc_vacuum_async_co (GearyImapDbGcVacuumAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_running;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "Cannot vacuum %s: already running", _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_free0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_imap_db_gc_set_is_running (_data_->self, TRUE);
	{
		_data_->_tmp5_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_debug ("imap-db-gc.vala:197: [%s] Starting vacuum of IMAP database", _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
		_data_->_state_ = 1;
		geary_imap_db_gc_internal_vacuum_async (_data_->self, _data_->cancellable, geary_imap_db_gc_vacuum_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_db_gc_internal_vacuum_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp7_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		g_debug ("imap-db-gc.vala:199: [%s] Completed vacuum of IMAP database", _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
	}
	__finally0:
	{
		geary_imap_db_gc_set_is_running (_data_->self, FALSE);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_internal_vacuum_async_data_free (gpointer _data)
{
	GearyImapDbGcInternalVacuumAsyncData* _data_;
	_data_ = _data;
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcInternalVacuumAsyncData, _data_);
}

static void
geary_imap_db_gc_internal_vacuum_async (GearyImapDBGC* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyImapDbGcInternalVacuumAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcInternalVacuumAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_internal_vacuum_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_internal_vacuum_async_co (_data_);
}

static void
geary_imap_db_gc_internal_vacuum_finish (GearyImapDBGC* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GearyImapDbGcInternalVacuumAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block89Data*
block89_data_ref (Block89Data* _data89_)
{
	g_atomic_int_inc (&_data89_->_ref_count_);
	return _data89_;
}

static void
block89_data_unref (void * _userdata_)
{
	Block89Data* _data89_;
	_data89_ = (Block89Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data89_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data89_->self;
		_g_object_unref0 (_data89_->cx);
		_g_date_time_unref0 (_data89_->last_vacuum_time);
		_g_object_unref0 (_data89_->cancellable);
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block89Data, _data89_);
	}
}

static void
geary_imap_db_gc_internal_vacuum_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyImapDbGcInternalVacuumAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_internal_vacuum_async_co (_data_);
}

static void
__lambda27_ (Block89Data* _data89_,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbDatabaseConnection* _tmp0_;
	GDateTime* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = _data89_->self;
	_tmp0_ = _data89_->cx;
	geary_db_connection_exec (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), "VACUUM", _data89_->cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (_data89_->last_vacuum_time);
	_data89_->last_vacuum_time = _tmp1_;
}

static void
___lambda27__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                               gpointer self,
                                                               GError** error)
{
	__lambda27_ (self, error);
}

static GearyDbTransactionOutcome
__lambda28_ (Block89Data* _data89_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GDateTime* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	GearyDbStatement* _tmp7_;
	GearyDbStatement* _tmp8_;
	GearyDbResult* _tmp9_;
	GearyDbResult* _tmp10_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data89_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                UPDATE GarbageCollectionTable\n" \
"                SET last_vacuum_time_t = ?, reaped_messages_since_last" \
"_vacuum = ?\n" \
"                WHERE id = 0\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = _data89_->last_vacuum_time;
	_tmp3_ = geary_db_statement_bind_int64 (_tmp1_, 0, g_date_time_to_unix (_tmp2_), &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp5_ = stmt;
	_tmp6_ = geary_db_statement_bind_int (_tmp5_, 1, 0, &_inner_error0_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp8_ = stmt;
	_tmp9_ = geary_db_statement_exec (_tmp8_, _data89_->cancellable, &_inner_error0_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda28__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda28_ (self, cx, error);
	return result;
}

static gboolean
geary_imap_db_gc_internal_vacuum_async_co (GearyImapDbGcInternalVacuumAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data89_ = g_slice_new0 (Block89Data);
	_data_->_data89_->_ref_count_ = 1;
	_data_->_data89_->self = geary_imap_db_gc_ref (_data_->self);
	_g_object_unref0 (_data_->_data89_->cancellable);
	_data_->_data89_->cancellable = _data_->cancellable;
	_data_->_data89_->_async_data_ = _data_;
	_data_->_data89_->last_vacuum_time = NULL;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_state_ = 1;
	geary_db_database_open_connection (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_data89_->cancellable, geary_imap_db_gc_internal_vacuum_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = geary_db_database_open_connection_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	_data_->_data89_->cx = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block89_data_unref (_data_->_data89_);
		_data_->_data89_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 2;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp3_, ___lambda27__geary_nonblocking_concurrent_concurrent_callback, _data_->_data89_, _data_->_data89_->cancellable, geary_imap_db_gc_internal_vacuum_async_ready, _data_);
	return FALSE;
	_state_2:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block89_data_unref (_data_->_data89_);
		_data_->_data89_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_data89_->last_vacuum_time;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (_data_->_data89_->last_vacuum_time);
		_data_->_data89_->last_vacuum_time = _data_->_tmp5_;
	}
	_data_->_tmp6_ = _data_->_data89_->cx;
	_data_->_state_ = 3;
	geary_db_database_connection_exec_transaction_async (_data_->_tmp6_, GEARY_DB_TRANSACTION_TYPE_WO, ___lambda28__geary_db_transaction_method, _data_->_data89_, NULL, geary_imap_db_gc_internal_vacuum_async_ready, _data_);
	return FALSE;
	_state_3:
	geary_db_database_connection_exec_transaction_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block89_data_unref (_data_->_data89_);
		_data_->_data89_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block89_data_unref (_data_->_data89_);
	_data_->_data89_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_reap_async_data_free (gpointer _data)
{
	GearyImapDbGcReapAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcReapAsyncData, _data_);
}

void
geary_imap_db_gc_reap_async (GearyImapDBGC* self,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GearyImapDbGcReapAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcReapAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_reap_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_reap_async_co (_data_);
}

void
geary_imap_db_gc_reap_finish (GearyImapDBGC* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GearyImapDbGcReapAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Run the garbage collector, which reaps unlinked messages from the database and deletes
     * their on-disk attachments.
     *
     * Should only be called from the foreground thread.  {@link reap_async} is designed to run in
     * the background, so the application may continue while it's executing.  It also is designed
     * to be interrupted (i.e. the application closes) and pick back up where it left off when the
     * application restarts.
     *
     * @throws Geary.EngineError.ALREADY_OPEN if {@link is_running} is true.
     */
static void
geary_imap_db_gc_reap_async_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GearyImapDbGcReapAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_reap_async_co (_data_);
}

static gboolean
geary_imap_db_gc_reap_async_co (GearyImapDbGcReapAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_running;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "Cannot garbage collect %s: already running", _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_free0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_imap_db_gc_set_is_running (_data_->self, TRUE);
	{
		_data_->_tmp5_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_debug ("imap-db-gc.vala:258: [%s] Starting garbage collection of IMAP database", _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
		_data_->_state_ = 1;
		geary_imap_db_gc_internal_reap_async (_data_->self, _data_->cancellable, geary_imap_db_gc_reap_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_db_gc_internal_reap_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp7_ = geary_imap_db_gc_to_string (_data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		g_debug ("imap-db-gc.vala:260: [%s] Completed garbage collection of IMAP databas" \
"e", _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
	}
	__finally0:
	{
		geary_imap_db_gc_set_is_running (_data_->self, FALSE);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_internal_reap_async_data_free (gpointer _data)
{
	GearyImapDbGcInternalReapAsyncData* _data_;
	_data_ = _data;
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcInternalReapAsyncData, _data_);
}

static void
geary_imap_db_gc_internal_reap_async (GearyImapDBGC* self,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyImapDbGcInternalReapAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcInternalReapAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_internal_reap_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_internal_reap_async_co (_data_);
}

static void
geary_imap_db_gc_internal_reap_finish (GearyImapDBGC* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GearyImapDbGcInternalReapAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block90Data*
block90_data_ref (Block90Data* _data90_)
{
	g_atomic_int_inc (&_data90_->_ref_count_);
	return _data90_;
}

static void
block90_data_unref (void * _userdata_)
{
	Block90Data* _data90_;
	_data90_ = (Block90Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data90_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data90_->self;
		_g_object_unref0 (_data90_->reap_message_ids);
		_g_date_time_unref0 (_data90_->reap_date);
		_g_object_unref0 (_data90_->cancellable);
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block90Data, _data90_);
	}
}

static guint
_geary_collection_int64_hash_func_gee_hash_data_func (gconstpointer v,
                                                      gpointer self)
{
	guint result;
	result = geary_collection_int64_hash_func ((gint64*) v);
	return result;
}

static gboolean
_geary_collection_int64_equal_func_gee_equal_data_func (gconstpointer a,
                                                        gconstpointer b,
                                                        gpointer self)
{
	gboolean result;
	result = geary_collection_int64_equal_func ((gint64*) a, (gint64*) b);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static GearyDbTransactionOutcome
__lambda29_ (Block90Data* _data90_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GDateTime* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbResult* _result_ = NULL;
	GearyDbStatement* _tmp5_;
	GearyDbResult* _tmp6_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data90_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                SELECT id\n" \
"                FROM MessageTable\n" \
"                WHERE (internaldate_time_t IS NULL OR internaldate_tim" \
"e_t <= ?)\n" \
"                AND NOT EXISTS (\n" \
"                    SELECT message_id\n" \
"                    FROM MessageLocationTable\n" \
"                    WHERE MessageLocationTable.message_id = MessageTab" \
"le.id\n" \
"                )\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = _data90_->reap_date;
	_tmp3_ = geary_db_statement_bind_int64 (_tmp1_, 0, g_date_time_to_unix (_tmp2_), &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp5_ = stmt;
	_tmp6_ = geary_db_statement_exec (_tmp5_, _data90_->cancellable, &_inner_error0_);
	_result_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	while (TRUE) {
		GearyDbResult* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gint64 _tmp10_ = 0LL;
		GearyDbResult* _tmp11_;
		GeeHashSet* _tmp12_;
		GearyDbResult* _tmp13_;
		_tmp7_ = _result_;
		_tmp8_ = geary_db_result_get_finished (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!(!_tmp9_)) {
			break;
		}
		_tmp11_ = _result_;
		_tmp10_ = geary_db_result_rowid_at (_tmp11_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp12_ = _data90_->reap_message_ids;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp10_);
		_tmp13_ = _result_;
		geary_db_result_next (_tmp13_, _data90_->cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			return 0;
		}
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_DONE;
	_g_object_unref0 (_result_);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda29__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda29_ (self, cx, error);
	return result;
}

static void
geary_imap_db_gc_internal_reap_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearyImapDbGcInternalReapAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_internal_reap_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static GearyDbTransactionOutcome
__lambda32_ (Block90Data* _data90_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	GearyDbResult* _tmp7_;
	GearyDbResult* _tmp8_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data90_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                UPDATE GarbageCollectionTable\n" \
"                SET last_reap_time_t = ?\n" \
"                WHERE id = 0\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_db_statement_bind_int64 (_tmp1_, 0, g_date_time_to_unix (_tmp3_), &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp6_ = stmt;
	_tmp7_ = geary_db_statement_exec (_tmp6_, _data90_->cancellable, &_inner_error0_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda32__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda32_ (self, cx, error);
	return result;
}

static gboolean
geary_imap_db_gc_internal_reap_async_co (GearyImapDbGcInternalReapAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data90_ = g_slice_new0 (Block90Data);
	_data_->_data90_->_ref_count_ = 1;
	_data_->_data90_->self = geary_imap_db_gc_ref (_data_->self);
	_g_object_unref0 (_data_->_data90_->cancellable);
	_data_->_data90_->cancellable = _data_->cancellable;
	_data_->_data90_->_async_data_ = _data_;
	_data_->_tmp0_ = g_date_time_new_now_local ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_date_time_add_days (_data_->_tmp1_, 0 - GEARY_IMAP_DB_GC_UNLINKED_DAYS);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_date_time_unref0 (_data_->_tmp1_);
	_data_->_data90_->reap_date = _data_->_tmp3_;
	_data_->_tmp4_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->_data90_->reap_date;
	_data_->_tmp7_ = g_date_time_to_string (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_data90_->reap_date;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_data_->_tmp9_));
	_data_->_tmp11_ = _data_->_tmp10_;
	g_debug ("imap-db-gc.vala:287: [%s] Garbage collector reaping date: %s (%s)", _data_->_tmp5_, _data_->_tmp8_, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp12_ = gee_hash_set_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, _geary_collection_int64_hash_func_gee_hash_data_func, NULL, NULL, _geary_collection_int64_equal_func_gee_equal_data_func, NULL, NULL);
	_data_->_data90_->reap_message_ids = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->db;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RO, ___lambda29__geary_db_transaction_method, _data_->_data90_, _data_->_data90_->cancellable, geary_imap_db_gc_internal_reap_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block90_data_unref (_data_->_data90_);
		_data_->_data90_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->_data90_->reap_message_ids;
	_data_->_tmp17_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp18_ = _data_->_tmp17_;
	g_message ("imap-db-gc.vala:316: [%s] Found %d email messages ready for reaping", _data_->_tmp15_, _data_->_tmp18_);
	_g_free0 (_data_->_tmp15_);
	_data_->count = 0;
	{
		_data_->_tmp19_ = _data_->_data90_->reap_message_ids;
		_data_->_tmp20_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_reap_message_id_it = _data_->_tmp20_;
		while (TRUE) {
			_data_->_tmp21_ = _data_->_reap_message_id_it;
			if (!gee_iterator_next (_data_->_tmp21_)) {
				break;
			}
			_data_->_tmp22_ = _data_->_reap_message_id_it;
			_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
			_data_->_tmp24_ = (gint64*) _data_->_tmp23_;
			_data_->_tmp25_ = *_data_->_tmp24_;
			_g_free0 (_data_->_tmp24_);
			_data_->reap_message_id = _data_->_tmp25_;
			{
				_data_->_state_ = 2;
				geary_imap_db_gc_reap_message_async (_data_->self, _data_->reap_message_id, _data_->_data90_->cancellable, geary_imap_db_gc_internal_reap_async_ready, _data_);
				return FALSE;
				_state_2:
				geary_imap_db_gc_reap_message_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp26_ = _data_->count;
				_data_->count = _data_->_tmp26_ + 1;
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp27_ = _data_->err;
				if (g_error_matches (_data_->_tmp27_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					_data_->_tmp28_ = _data_->err;
					_data_->_tmp29_ = _g_error_copy0 (_data_->_tmp28_);
					_data_->_inner_error0_ = _data_->_tmp29_;
					_g_error_free0 (_data_->err);
					goto __finally0;
				}
				_data_->_tmp30_ = geary_imap_db_gc_to_string (_data_->self);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->reap_message_id);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = _data_->err;
				_data_->_tmp35_ = _data_->_tmp34_->message;
				g_message ("imap-db-gc.vala:336: [%s] Unable to reap message #%s: %s", _data_->_tmp31_, _data_->_tmp33_, _data_->_tmp35_);
				_g_free0 (_data_->_tmp33_);
				_g_free0 (_data_->_tmp31_);
				_g_error_free0 (_data_->err);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->_reap_message_id_it);
				block90_data_unref (_data_->_data90_);
				_data_->_data90_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if ((_data_->count % GEARY_IMAP_DB_GC_OPS_PER_SLEEP_CYCLE) == 0) {
				_data_->_state_ = 3;
				geary_scheduler_sleep_ms_async (GEARY_IMAP_DB_GC_SLEEP_MSEC, geary_imap_db_gc_internal_reap_async_ready, _data_);
				return FALSE;
				_state_3:
				geary_scheduler_sleep_ms_finish (_data_->_res_);
			}
			if ((_data_->count % 5000) == 0) {
				_data_->_tmp36_ = geary_imap_db_gc_to_string (_data_->self);
				_data_->_tmp37_ = _data_->_tmp36_;
				g_debug ("imap-db-gc.vala:344: [%s] Reaped %d messages", _data_->_tmp37_, _data_->count);
				_g_free0 (_data_->_tmp37_);
			}
		}
		_g_object_unref0 (_data_->_reap_message_id_it);
	}
	_data_->_tmp38_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp39_ = _data_->_tmp38_;
	g_message ("imap-db-gc.vala:347: [%s] Reaped completed: %d messages", _data_->_tmp39_, _data_->count);
	_g_free0 (_data_->_tmp39_);
	_data_->count = 0;
	{
		_data_->_tmp40_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp40_) {
			}
			_data_->_tmp40_ = FALSE;
			_data_->_state_ = 4;
			geary_imap_db_gc_reap_attachment_files_async (_data_->self, GEARY_IMAP_DB_GC_REAP_ATTACHMENT_PER, _data_->_data90_->cancellable, geary_imap_db_gc_internal_reap_async_ready, _data_);
			return FALSE;
			_state_4:
			_data_->reaped = geary_imap_db_gc_reap_attachment_files_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				block90_data_unref (_data_->_data90_);
				_data_->_data90_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->reaped == 0) {
				break;
			}
			_data_->count += _data_->reaped;
			if ((_data_->count % GEARY_IMAP_DB_GC_OPS_PER_SLEEP_CYCLE) == 0) {
				_data_->_state_ = 5;
				geary_scheduler_sleep_ms_async (GEARY_IMAP_DB_GC_SLEEP_MSEC, geary_imap_db_gc_internal_reap_async_ready, _data_);
				return FALSE;
				_state_5:
				geary_scheduler_sleep_ms_finish (_data_->_res_);
			}
			if ((_data_->count % 1000) == 0) {
				_data_->_tmp41_ = geary_imap_db_gc_to_string (_data_->self);
				_data_->_tmp42_ = _data_->_tmp41_;
				g_debug ("imap-db-gc.vala:367: [%s] Reaped %d attachment files", _data_->_tmp42_, _data_->count);
				_g_free0 (_data_->_tmp42_);
			}
		}
	}
	_data_->_tmp43_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp44_ = _data_->_tmp43_;
	g_message ("imap-db-gc.vala:370: [%s] Completed: Reaped %d attachment files", _data_->_tmp44_, _data_->count);
	_g_free0 (_data_->_tmp44_);
	_data_->_state_ = 6;
	geary_imap_db_gc_delete_empty_attachment_directories_async (_data_->self, NULL, _data_->_data90_->cancellable, geary_imap_db_gc_internal_reap_async_ready, _data_);
	return FALSE;
	_state_6:
	_data_->_tmp45_ = geary_imap_db_gc_delete_empty_attachment_directories_finish (_data_->self, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block90_data_unref (_data_->_data90_);
		_data_->_data90_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->count = _data_->_tmp45_;
	_data_->_tmp46_ = geary_imap_db_gc_to_string (_data_->self);
	_data_->_tmp47_ = _data_->_tmp46_;
	g_message ("imap-db-gc.vala:379: [%s] Deleted %d empty attachment directories", _data_->_tmp47_, _data_->count);
	_g_free0 (_data_->_tmp47_);
	_data_->_tmp48_ = _data_->self->priv->db;
	_data_->_state_ = 7;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_WO, ___lambda32__geary_db_transaction_method, _data_->_data90_, _data_->_data90_->cancellable, geary_imap_db_gc_internal_reap_async_ready, _data_);
	return FALSE;
	_state_7:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp48_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block90_data_unref (_data_->_data90_);
		_data_->_data90_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block90_data_unref (_data_->_data90_);
	_data_->_data90_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_reap_message_async_data_free (gpointer _data)
{
	GearyImapDbGcReapMessageAsyncData* _data_;
	_data_ = _data;
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcReapMessageAsyncData, _data_);
}

static void
geary_imap_db_gc_reap_message_async (GearyImapDBGC* self,
                                     gint64 message_id,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyImapDbGcReapMessageAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcReapMessageAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_reap_message_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_data_->message_id = message_id;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_reap_message_async_co (_data_);
}

static void
geary_imap_db_gc_reap_message_finish (GearyImapDBGC* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyImapDbGcReapMessageAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block91Data*
block91_data_ref (Block91Data* _data91_)
{
	g_atomic_int_inc (&_data91_->_ref_count_);
	return _data91_;
}

static void
block91_data_unref (void * _userdata_)
{
	Block91Data* _data91_;
	_data91_ = (Block91Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data91_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data91_->self;
		_g_object_unref0 (_data91_->cancellable);
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block91Data, _data91_);
	}
}

static GearyDbTransactionOutcome
__lambda30_ (Block91Data* _data91_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbResult* _result_ = NULL;
	GearyDbStatement* _tmp4_;
	GearyDbResult* _tmp5_;
	GearyDbResult* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeList* attachments = NULL;
	GearyImapDBDatabase* _tmp13_;
	GFile* _tmp14_;
	GeeList* _tmp15_;
	GearyDbStatement* _tmp16_ = NULL;
	GearyDbStatement* _tmp17_;
	GearyDbStatement* _tmp18_;
	GearyDbStatement* _tmp19_;
	GearyDbStatement* _tmp20_;
	GearyDbStatement* _tmp21_;
	GearyDbStatement* _tmp22_;
	GearyDbResult* _tmp23_;
	GearyDbResult* _tmp24_;
	GearyDbStatement* _tmp25_ = NULL;
	GearyDbStatement* _tmp26_;
	GearyDbStatement* _tmp27_;
	GearyDbStatement* _tmp28_;
	GearyDbStatement* _tmp29_;
	GearyDbStatement* _tmp30_;
	GearyDbStatement* _tmp31_;
	GearyDbResult* _tmp32_;
	GearyDbResult* _tmp33_;
	GearyDbStatement* _tmp34_ = NULL;
	GearyDbStatement* _tmp35_;
	GearyDbStatement* _tmp36_;
	GearyDbStatement* _tmp37_;
	GearyDbStatement* _tmp38_;
	GearyDbStatement* _tmp39_;
	GearyDbStatement* _tmp40_;
	GearyDbResult* _tmp41_;
	GearyDbResult* _tmp42_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data91_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                SELECT id\n" \
"                FROM MessageLocationTable\n" \
"                WHERE message_id = ?\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_bind_rowid (_tmp1_, 0, _data91_->message_id, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp4_ = stmt;
	_tmp5_ = geary_db_statement_exec (_tmp4_, _data91_->cancellable, &_inner_error0_);
	_result_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp6_ = _result_;
	_tmp7_ = geary_db_result_get_finished (_tmp6_);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = geary_imap_db_gc_to_string (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data91_->message_id);
		_tmp12_ = _tmp11_;
		g_debug ("imap-db-gc.vala:416: [%s] Not reaping message #%s: found linked in Mes" \
"sageLocationTable", _tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		result = GEARY_DB_TRANSACTION_OUTCOME_ROLLBACK;
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return result;
	}
	_tmp13_ = self->priv->db;
	_tmp14_ = _tmp13_->attachments_path;
	_tmp15_ = geary_imap_db_attachment_list_attachments (cx, _tmp14_, _data91_->message_id, _data91_->cancellable, &_inner_error0_);
	attachments = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp17_ = geary_db_connection_prepare (cx, "\n" \
"                DELETE FROM MessageSearchTable\n" \
"                WHERE rowid = ?\n" \
"            ", &_inner_error0_);
	_tmp16_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp18_ = _tmp16_;
	_tmp16_ = NULL;
	_g_object_unref0 (stmt);
	stmt = _tmp18_;
	_tmp19_ = stmt;
	_tmp20_ = geary_db_statement_bind_rowid (_tmp19_, 0, _data91_->message_id, &_inner_error0_);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp21_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp22_ = stmt;
	_tmp23_ = geary_db_statement_exec (_tmp22_, _data91_->cancellable, &_inner_error0_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp24_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp26_ = geary_db_connection_prepare (cx, "\n" \
"                DELETE FROM MessageAttachmentTable\n" \
"                WHERE message_id = ?\n" \
"            ", &_inner_error0_);
	_tmp25_ = _tmp26_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp27_ = _tmp25_;
	_tmp25_ = NULL;
	_g_object_unref0 (stmt);
	stmt = _tmp27_;
	_tmp28_ = stmt;
	_tmp29_ = geary_db_statement_bind_rowid (_tmp28_, 0, _data91_->message_id, &_inner_error0_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (_tmp30_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp31_ = stmt;
	_tmp32_ = geary_db_statement_exec (_tmp31_, _data91_->cancellable, &_inner_error0_);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp33_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp35_ = geary_db_connection_prepare (cx, "\n" \
"                DELETE FROM MessageTable\n" \
"                WHERE id = ?\n" \
"            ", &_inner_error0_);
	_tmp34_ = _tmp35_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp36_ = _tmp34_;
	_tmp34_ = NULL;
	_g_object_unref0 (stmt);
	stmt = _tmp36_;
	_tmp37_ = stmt;
	_tmp38_ = geary_db_statement_bind_rowid (_tmp37_, 0, _data91_->message_id, &_inner_error0_);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (_tmp39_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp40_ = stmt;
	_tmp41_ = geary_db_statement_exec (_tmp40_, _data91_->cancellable, &_inner_error0_);
	_tmp42_ = _tmp41_;
	_g_object_unref0 (_tmp42_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	{
		GeeList* _attachment_list = NULL;
		GeeList* _tmp43_;
		gint _attachment_size = 0;
		GeeList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _attachment_index = 0;
		_tmp43_ = attachments;
		_attachment_list = _tmp43_;
		_tmp44_ = _attachment_list;
		_tmp45_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp46_ = _tmp45_;
		_attachment_size = _tmp46_;
		_attachment_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			GearyImapDBAttachment* attachment = NULL;
			GeeList* _tmp49_;
			gpointer _tmp50_;
			GearyDbStatement* _tmp51_ = NULL;
			GearyDbStatement* _tmp52_;
			GearyDbStatement* _tmp53_;
			GearyDbStatement* _tmp54_;
			GearyImapDBAttachment* _tmp55_;
			GFile* _tmp56_;
			GFile* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			GearyDbStatement* _tmp60_;
			GearyDbStatement* _tmp61_;
			GearyDbStatement* _tmp62_;
			GearyDbResult* _tmp63_;
			GearyDbResult* _tmp64_;
			_attachment_index = _attachment_index + 1;
			_tmp47_ = _attachment_index;
			_tmp48_ = _attachment_size;
			if (!(_tmp47_ < _tmp48_)) {
				break;
			}
			_tmp49_ = _attachment_list;
			_tmp50_ = gee_list_get (_tmp49_, _attachment_index);
			attachment = (GearyImapDBAttachment*) _tmp50_;
			_tmp52_ = geary_db_connection_prepare (cx, "\n" \
"                    INSERT INTO DeleteAttachmentFileTable (filename)\n" \
"                    VALUES (?)\n" \
"                ", &_inner_error0_);
			_tmp51_ = _tmp52_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (attachment);
				_g_object_unref0 (_tmp34_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (attachments);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp53_ = _tmp51_;
			_tmp51_ = NULL;
			_g_object_unref0 (stmt);
			stmt = _tmp53_;
			_tmp54_ = stmt;
			_tmp55_ = attachment;
			_tmp56_ = geary_attachment_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEARY_TYPE_ATTACHMENT, GearyAttachment));
			_tmp57_ = _tmp56_;
			_tmp58_ = g_file_get_path (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = geary_db_statement_bind_string (_tmp54_, 0, _tmp59_, &_inner_error0_);
			_tmp61_ = _tmp60_;
			_g_object_unref0 (_tmp61_);
			_g_free0 (_tmp59_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp51_);
				_g_object_unref0 (attachment);
				_g_object_unref0 (_tmp34_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (attachments);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp62_ = stmt;
			_tmp63_ = geary_db_statement_exec (_tmp62_, _data91_->cancellable, &_inner_error0_);
			_tmp64_ = _tmp63_;
			_g_object_unref0 (_tmp64_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp51_);
				_g_object_unref0 (attachment);
				_g_object_unref0 (_tmp34_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (attachments);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				return 0;
			}
			_g_object_unref0 (_tmp51_);
			_g_object_unref0 (attachment);
		}
	}
	geary_db_connection_exec (cx, "\n" \
"                UPDATE GarbageCollectionTable\n" \
"                SET reaped_messages_since_last_vacuum = reaped_message" \
"s_since_last_vacuum + 1\n" \
"                WHERE id = 0\n" \
"            ", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (attachments);
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
		return 0;
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_tmp34_);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (attachments);
	_g_object_unref0 (_result_);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda30__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda30_ (self, cx, error);
	return result;
}

static void
geary_imap_db_gc_reap_message_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GearyImapDbGcReapMessageAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_reap_message_async_co (_data_);
}

static gboolean
geary_imap_db_gc_reap_message_async_co (GearyImapDbGcReapMessageAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data91_ = g_slice_new0 (Block91Data);
	_data_->_data91_->_ref_count_ = 1;
	_data_->_data91_->self = geary_imap_db_gc_ref (_data_->self);
	_data_->_data91_->message_id = _data_->message_id;
	_g_object_unref0 (_data_->_data91_->cancellable);
	_data_->_data91_->cancellable = _data_->cancellable;
	_data_->_data91_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_tmp1_ = _data_->_data91_->cancellable;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda30__geary_db_transaction_method, _data_->_data91_, _data_->_tmp1_, geary_imap_db_gc_reap_message_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block91_data_unref (_data_->_data91_);
		_data_->_data91_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block91_data_unref (_data_->_data91_);
	_data_->_data91_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_reap_attachment_files_async_data_free (gpointer _data)
{
	GearyImapDbGcReapAttachmentFilesAsyncData* _data_;
	_data_ = _data;
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcReapAttachmentFilesAsyncData, _data_);
}

static void
geary_imap_db_gc_reap_attachment_files_async (GearyImapDBGC* self,
                                              gint limit,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyImapDbGcReapAttachmentFilesAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcReapAttachmentFilesAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_reap_attachment_files_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_data_->limit = limit;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_reap_attachment_files_async_co (_data_);
}

static gint
geary_imap_db_gc_reap_attachment_files_finish (GearyImapDBGC* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	gint result;
	GearyImapDbGcReapAttachmentFilesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block92Data*
block92_data_ref (Block92Data* _data92_)
{
	g_atomic_int_inc (&_data92_->_ref_count_);
	return _data92_;
}

static void
block92_data_unref (void * _userdata_)
{
	Block92Data* _data92_;
	_data92_ = (Block92Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data92_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data92_->self;
		_g_object_unref0 (_data92_->cancellable);
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block92Data, _data92_);
	}
}

static GearyDbTransactionOutcome
__lambda31_ (Block92Data* _data92_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GString* sql = NULL;
	GString* _tmp4_;
	GearyDbResult* _result_ = NULL;
	GearyDbStatement* _tmp5_;
	GearyDbResult* _tmp6_;
	gboolean first = FALSE;
	GString* _tmp32_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data92_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                SELECT id, filename\n" \
"                FROM DeleteAttachmentFileTable\n" \
"                LIMIT ?\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_bind_int (_tmp1_, 0, _data92_->limit, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp4_ = g_string_new ("\n" \
"                DELETE FROM DeleteAttachmentFileTable\n" \
"                WHERE id IN (\n" \
"            ");
	sql = _tmp4_;
	_tmp5_ = stmt;
	_tmp6_ = geary_db_statement_exec (_tmp5_, _data92_->cancellable, &_inner_error0_);
	_result_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sql);
		_g_object_unref0 (stmt);
		return 0;
	}
	first = TRUE;
	while (TRUE) {
		GearyDbResult* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gint64 id = 0LL;
		GearyDbResult* _tmp10_;
		const gchar* _tmp11_ = NULL;
		GearyDbResult* _tmp12_;
		const gchar* _tmp13_;
		GFile* file = NULL;
		GFile* _tmp14_;
		GString* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gint _tmp30_;
		GearyDbResult* _tmp31_;
		_tmp7_ = _result_;
		_tmp8_ = geary_db_result_get_finished (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!(!_tmp9_)) {
			break;
		}
		_tmp10_ = _result_;
		id = geary_db_result_rowid_at (_tmp10_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_string_free0 (sql);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp12_ = _result_;
		_tmp13_ = geary_db_result_string_at (_tmp12_, 1, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_string_free0 (sql);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp14_ = g_file_new_for_path (_tmp11_);
		file = _tmp14_;
		{
			GFile* _tmp15_;
			_tmp15_ = file;
			g_file_delete (_tmp15_, _data92_->cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp16_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = err;
			if (g_error_matches (_tmp16_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				GError* _tmp17_;
				GError* _tmp18_;
				_tmp17_ = err;
				_tmp18_ = _g_error_copy0 (_tmp17_);
				_inner_error0_ = _tmp18_;
				_g_error_free0 (err);
				goto __finally0;
			}
			_tmp19_ = geary_imap_db_gc_to_string (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = file;
			_tmp22_ = g_file_get_path (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = err;
			_tmp25_ = _tmp24_->message;
			g_debug ("imap-db-gc.vala:533: [%s] Unable to delete reaped attachment file \"%s" \
"\": %s", _tmp20_, _tmp23_, _tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			_g_object_unref0 (_result_);
			_g_string_free0 (sql);
			_g_object_unref0 (stmt);
			return 0;
		}
		if (!first) {
			GString* _tmp26_;
			_tmp26_ = sql;
			g_string_append (_tmp26_, ", ");
		}
		_tmp27_ = sql;
		_tmp28_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
		_tmp29_ = _tmp28_;
		g_string_append (_tmp27_, _tmp29_);
		_g_free0 (_tmp29_);
		first = FALSE;
		_tmp30_ = _data92_->deleted;
		_data92_->deleted = _tmp30_ + 1;
		_tmp31_ = _result_;
		geary_db_result_next (_tmp31_, _data92_->cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			_g_object_unref0 (_result_);
			_g_string_free0 (sql);
			_g_object_unref0 (stmt);
			return 0;
		}
		_g_object_unref0 (file);
	}
	_tmp32_ = sql;
	g_string_append (_tmp32_, ")");
	if (_data92_->deleted > 0) {
		GString* _tmp33_;
		const gchar* _tmp34_;
		_tmp33_ = sql;
		_tmp34_ = _tmp33_->str;
		geary_db_connection_exec (cx, _tmp34_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_string_free0 (sql);
			_g_object_unref0 (stmt);
			return 0;
		}
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_result_);
	_g_string_free0 (sql);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda31__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda31_ (self, cx, error);
	return result;
}

static void
geary_imap_db_gc_reap_attachment_files_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearyImapDbGcReapAttachmentFilesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_reap_attachment_files_async_co (_data_);
}

static gboolean
geary_imap_db_gc_reap_attachment_files_async_co (GearyImapDbGcReapAttachmentFilesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data92_ = g_slice_new0 (Block92Data);
	_data_->_data92_->_ref_count_ = 1;
	_data_->_data92_->self = geary_imap_db_gc_ref (_data_->self);
	_data_->_data92_->limit = _data_->limit;
	_g_object_unref0 (_data_->_data92_->cancellable);
	_data_->_data92_->cancellable = _data_->cancellable;
	_data_->_data92_->_async_data_ = _data_;
	if (_data_->_data92_->limit <= 0) {
		_data_->result = 0;
		block92_data_unref (_data_->_data92_);
		_data_->_data92_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data92_->deleted = 0;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_tmp1_ = _data_->_data92_->cancellable;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda31__geary_db_transaction_method, _data_->_data92_, _data_->_tmp1_, geary_imap_db_gc_reap_attachment_files_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block92_data_unref (_data_->_data92_);
		_data_->_data92_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_data92_->deleted;
	block92_data_unref (_data_->_data92_);
	_data_->_data92_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_delete_empty_attachment_directories_async_data_free (gpointer _data)
{
	GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->current);
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData, _data_);
}

static void
geary_imap_db_gc_delete_empty_attachment_directories_async (GearyImapDBGC* self,
                                                            GFile* current,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((current == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (current, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_delete_empty_attachment_directories_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (current);
	_g_object_unref0 (_data_->current);
	_data_->current = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_db_gc_delete_empty_attachment_directories_async_co (_data_);
}

static gint
geary_imap_db_gc_delete_empty_attachment_directories_finish (GearyImapDBGC* self,
                                                             GAsyncResult* _res_,
                                                             gboolean* empty,
                                                             GError** error)
{
	gint result;
	GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	if (empty) {
		*empty = _data_->empty;
	}
	result = _data_->result;
	return result;
}

static void
geary_imap_db_gc_delete_empty_attachment_directories_async_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_delete_empty_attachment_directories_async_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
geary_imap_db_gc_delete_empty_attachment_directories_async_co (GearyImapDbGcDeleteEmptyAttachmentDirectoriesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->current;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->self->priv->db;
		_data_->_tmp2_ = _data_->_tmp1_->attachments_path;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->current_dir = _data_->_tmp3_;
	_data_->empty = TRUE;
	_data_->deleted = 0;
	_data_->_tmp4_ = _data_->current_dir;
	_data_->_state_ = 1;
	g_file_enumerate_children_async (_data_->_tmp4_, "*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _data_->self->priv->priority, _data_->cancellable, geary_imap_db_gc_delete_empty_attachment_directories_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->file_enum = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->current_dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp6_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp6_) {
			}
			_data_->_tmp6_ = FALSE;
			_data_->_tmp7_ = _data_->file_enum;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp7_, GEARY_IMAP_DB_GC_ENUM_DIR_PER, _data_->self->priv->priority, _data_->cancellable, geary_imap_db_gc_delete_empty_attachment_directories_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = g_file_enumerator_next_files_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
			_data_->infos = _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->file_enum);
				_g_object_unref0 (_data_->current_dir);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp9_ = _data_->infos;
			if (g_list_length (_data_->_tmp9_) == ((guint) 0)) {
				(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
				break;
			}
			_data_->_tmp10_ = _data_->infos;
			{
				_data_->info_collection = _data_->_tmp10_;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->_tmp11_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
					_data_->info = _data_->_tmp11_;
					{
						_data_->_tmp12_ = _data_->info;
						if (g_file_info_get_file_type (_data_->_tmp12_) != G_FILE_TYPE_DIRECTORY) {
							_data_->empty = FALSE;
							_g_object_unref0 (_data_->info);
							continue;
						}
						_data_->_tmp13_ = _data_->current_dir;
						_data_->_tmp14_ = _data_->info;
						_data_->_tmp15_ = g_file_info_get_name (_data_->_tmp14_);
						_data_->_tmp16_ = g_file_get_child (_data_->_tmp13_, _data_->_tmp15_);
						_data_->child = _data_->_tmp16_;
						_data_->_tmp18_ = _data_->child;
						_data_->_tmp19_ = FALSE;
						_data_->_state_ = 3;
						geary_imap_db_gc_delete_empty_attachment_directories_async (_data_->self, _data_->_tmp18_, _data_->cancellable, geary_imap_db_gc_delete_empty_attachment_directories_async_ready, _data_);
						return FALSE;
						_state_3:
						_data_->_tmp20_ = geary_imap_db_gc_delete_empty_attachment_directories_finish (_data_->self, _data_->_res_, &_data_->_tmp19_, &_data_->_inner_error0_);
						_data_->child_empty = _data_->_tmp19_;
						_data_->_tmp17_ = _data_->_tmp20_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->child);
							_g_object_unref0 (_data_->info);
							(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
							_g_object_unref0 (_data_->file_enum);
							_g_object_unref0 (_data_->current_dir);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->deleted += _data_->_tmp17_;
						if (!_data_->child_empty) {
							_data_->empty = FALSE;
							_g_object_unref0 (_data_->child);
							_g_object_unref0 (_data_->info);
							continue;
						}
						_data_->failure = NULL;
						{
							_data_->_tmp22_ = _data_->child;
							_data_->_state_ = 4;
							g_file_delete_async (_data_->_tmp22_, _data_->self->priv->priority, _data_->cancellable, geary_imap_db_gc_delete_empty_attachment_directories_async_ready, _data_);
							return FALSE;
							_state_4:
							_data_->_tmp21_ = g_file_delete_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							if (!_data_->_tmp21_) {
								_data_->_tmp23_ = g_strdup ("delete indicates not empty");
								_g_free0 (_data_->failure);
								_data_->failure = _data_->_tmp23_;
							}
						}
						goto __finally0;
						__catch0_g_error:
						{
							_data_->err = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp24_ = _data_->err;
							if (g_error_matches (_data_->_tmp24_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
								_data_->_tmp25_ = _data_->err;
								_data_->_tmp26_ = _g_error_copy0 (_data_->_tmp25_);
								_data_->_inner_error0_ = _data_->_tmp26_;
								_g_error_free0 (_data_->err);
								goto __finally0;
							}
							_data_->_tmp27_ = _data_->err;
							_data_->_tmp28_ = _data_->_tmp27_->message;
							_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
							_g_free0 (_data_->failure);
							_data_->failure = _data_->_tmp29_;
							_g_error_free0 (_data_->err);
						}
						__finally0:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_free0 (_data_->failure);
							_g_object_unref0 (_data_->child);
							_g_object_unref0 (_data_->info);
							(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
							_g_object_unref0 (_data_->file_enum);
							_g_object_unref0 (_data_->current_dir);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp30_ = _data_->failure;
						if (_data_->_tmp30_ == NULL) {
							_data_->_tmp31_ = _data_->deleted;
							_data_->deleted = _data_->_tmp31_ + 1;
						} else {
							_data_->_tmp32_ = geary_imap_db_gc_to_string (_data_->self);
							_data_->_tmp33_ = _data_->_tmp32_;
							_data_->_tmp34_ = _data_->child;
							_data_->_tmp35_ = g_file_get_path (_data_->_tmp34_);
							_data_->_tmp36_ = _data_->_tmp35_;
							_data_->_tmp37_ = _data_->failure;
							g_message ("imap-db-gc.vala:607: [%s] Unable to delete empty attachment directory " \
"\"%s\": %s", _data_->_tmp33_, _data_->_tmp36_, _data_->_tmp37_);
							_g_free0 (_data_->_tmp36_);
							_g_free0 (_data_->_tmp33_);
							_data_->empty = FALSE;
						}
						_g_free0 (_data_->failure);
						_g_object_unref0 (_data_->child);
						_g_object_unref0 (_data_->info);
					}
				}
			}
			(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		}
	}
	_data_->_tmp38_ = _data_->file_enum;
	_data_->_state_ = 5;
	g_file_enumerator_close_async (_data_->_tmp38_, _data_->self->priv->priority, _data_->cancellable, geary_imap_db_gc_delete_empty_attachment_directories_async_ready, _data_);
	return FALSE;
	_state_5:
	g_file_enumerator_close_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->file_enum);
		_g_object_unref0 (_data_->current_dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->deleted;
	_g_object_unref0 (_data_->file_enum);
	_g_object_unref0 (_data_->current_dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_has_message_rows_data_free (gpointer _data)
{
	GearyImapDbGcHasMessageRowsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcHasMessageRowsData, _data_);
}

static void
geary_imap_db_gc_has_message_rows (GearyImapDBGC* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyImapDbGcHasMessageRowsData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcHasMessageRowsData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_has_message_rows_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_has_message_rows_co (_data_);
}

static gboolean
geary_imap_db_gc_has_message_rows_finish (GearyImapDBGC* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gboolean result;
	GearyImapDbGcHasMessageRowsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block93Data*
block93_data_ref (Block93Data* _data93_)
{
	g_atomic_int_inc (&_data93_->_ref_count_);
	return _data93_;
}

static void
block93_data_unref (void * _userdata_)
{
	Block93Data* _data93_;
	_data93_ = (Block93Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data93_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data93_->self;
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block93Data, _data93_);
	}
}

static GearyDbTransactionOutcome
__lambda26_ (Block93Data* _data93_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbResult* _result_ = NULL;
	GearyDbResult* _tmp0_;
	GearyDbTransactionOutcome txn_ret = 0;
	GearyDbResult* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data93_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_query (cx, "SELECT count(*) FROM MessageTable LIMIT 1", NULL, &_inner_error0_);
	_result_ = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	txn_ret = GEARY_DB_TRANSACTION_OUTCOME_FAILURE;
	_tmp1_ = _result_;
	_tmp2_ = geary_db_result_get_finished (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		gint64 _tmp4_ = 0LL;
		GearyDbResult* _tmp5_;
		txn_ret = GEARY_DB_TRANSACTION_OUTCOME_SUCCESS;
		_tmp5_ = _result_;
		_tmp4_ = geary_db_result_int64_at (_tmp5_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return 0;
		}
		_data93_->ret = _tmp4_ > ((gint64) 0);
	}
	result = txn_ret;
	_g_object_unref0 (_result_);
	return result;
}

static GearyDbTransactionOutcome
___lambda26__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda26_ (self, cx, error);
	return result;
}

static void
geary_imap_db_gc_has_message_rows_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GearyImapDbGcHasMessageRowsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_has_message_rows_co (_data_);
}

static gboolean
geary_imap_db_gc_has_message_rows_co (GearyImapDbGcHasMessageRowsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data93_ = g_slice_new0 (Block93Data);
	_data_->_data93_->_ref_count_ = 1;
	_data_->_data93_->self = geary_imap_db_gc_ref (_data_->self);
	_data_->_data93_->_async_data_ = _data_;
	_data_->_data93_->ret = FALSE;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RO, ___lambda26__geary_db_transaction_method, _data_->_data93_, _data_->cancellable, geary_imap_db_gc_has_message_rows_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block93_data_unref (_data_->_data93_);
		_data_->_data93_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_data93_->ret;
	block93_data_unref (_data_->_data93_);
	_data_->_data93_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_gc_fetch_gc_info_async_data_free (gpointer _data)
{
	GearyImapDbGcFetchGcInfoAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_imap_db_gc_unref0 (_data_->self);
	g_slice_free (GearyImapDbGcFetchGcInfoAsyncData, _data_);
}

static void
geary_imap_db_gc_fetch_gc_info_async (GearyImapDBGC* self,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyImapDbGcFetchGcInfoAsyncData* _data_;
	GearyImapDBGC* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_GC (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbGcFetchGcInfoAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_gc_fetch_gc_info_async_data_free);
	_tmp0_ = _geary_imap_db_gc_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_gc_fetch_gc_info_async_co (_data_);
}

static void
geary_imap_db_gc_fetch_gc_info_finish (GearyImapDBGC* self,
                                       GAsyncResult* _res_,
                                       GDateTime** last_reap_time,
                                       GDateTime** last_vacuum_time,
                                       gint* reaped_messages_since_last_vacuum,
                                       gint64* free_page_bytes,
                                       GError** error)
{
	GearyImapDbGcFetchGcInfoAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (last_reap_time) {
		*last_reap_time = _data_->last_reap_time;
	} else {
		_g_date_time_unref0 (_data_->last_reap_time);
	}
	_data_->last_reap_time = NULL;
	if (last_vacuum_time) {
		*last_vacuum_time = _data_->last_vacuum_time;
	} else {
		_g_date_time_unref0 (_data_->last_vacuum_time);
	}
	_data_->last_vacuum_time = NULL;
	if (reaped_messages_since_last_vacuum) {
		*reaped_messages_since_last_vacuum = _data_->reaped_messages_since_last_vacuum;
	}
	if (free_page_bytes) {
		*free_page_bytes = _data_->free_page_bytes;
	}
}

static Block94Data*
block94_data_ref (Block94Data* _data94_)
{
	g_atomic_int_inc (&_data94_->_ref_count_);
	return _data94_;
}

static void
block94_data_unref (void * _userdata_)
{
	Block94Data* _data94_;
	_data94_ = (Block94Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data94_->_ref_count_)) {
		GearyImapDBGC* self;
		self = _data94_->self;
		_geary_imap_db_gc_unref0 (self);
		g_slice_free (Block94Data, _data94_);
	}
}

static GearyDbTransactionOutcome
__lambda25_ (Block94Data* _data94_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBGC* self;
	GearyDbResult* _result_ = NULL;
	GearyDbResult* _tmp0_;
	GearyDbResult* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
	GearyDbResult* _tmp6_;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp9_ = FALSE;
	GearyDbResult* _tmp10_;
	gint _tmp12_ = 0;
	GearyDbResult* _tmp13_;
	gint64 _tmp14_ = 0LL;
	gint _tmp15_ = 0;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data94_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_query (cx, "\n" \
"                SELECT last_reap_time_t, last_vacuum_time_t, reaped_me" \
"ssages_since_last_vacuum\n" \
"                FROM GarbageCollectionTable\n" \
"                WHERE id = 0\n" \
"            ", NULL, &_inner_error0_);
	_result_ = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = _result_;
	_tmp2_ = geary_db_result_get_finished (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = GEARY_DB_TRANSACTION_OUTCOME_FAILURE;
		_g_object_unref0 (_result_);
		return result;
	}
	_tmp6_ = _result_;
	_tmp5_ = geary_db_result_is_null_at (_tmp6_, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		return 0;
	}
	if (!_tmp5_) {
		GearyDbResult* _tmp7_;
		_tmp7_ = _result_;
		_tmp4_ = geary_db_result_int64_at (_tmp7_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return 0;
		}
	} else {
		_tmp4_ = (gint64) -1;
	}
	_data94_->last_reap_time_t = _tmp4_;
	_tmp10_ = _result_;
	_tmp9_ = geary_db_result_is_null_at (_tmp10_, 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		return 0;
	}
	if (!_tmp9_) {
		GearyDbResult* _tmp11_;
		_tmp11_ = _result_;
		_tmp8_ = geary_db_result_int64_at (_tmp11_, 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return 0;
		}
	} else {
		_tmp8_ = (gint64) -1;
	}
	_data94_->last_vacuum_time_t = _tmp8_;
	_tmp13_ = _result_;
	_tmp12_ = geary_db_result_int_at (_tmp13_, 2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		return 0;
	}
	_data94_->reaped_count = _tmp12_;
	_tmp14_ = geary_db_connection_get_free_page_count (cx, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		return 0;
	}
	_data94_->free_page_count = _tmp14_;
	_tmp15_ = geary_db_connection_get_page_size (cx, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_result_);
		return 0;
	}
	_data94_->page_size = _tmp15_;
	result = GEARY_DB_TRANSACTION_OUTCOME_SUCCESS;
	_g_object_unref0 (_result_);
	return result;
}

static GearyDbTransactionOutcome
___lambda25__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda25_ (self, cx, error);
	return result;
}

static void
geary_imap_db_gc_fetch_gc_info_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearyImapDbGcFetchGcInfoAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_gc_fetch_gc_info_async_co (_data_);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
geary_imap_db_gc_fetch_gc_info_async_co (GearyImapDbGcFetchGcInfoAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data94_ = g_slice_new0 (Block94Data);
	_data_->_data94_->_ref_count_ = 1;
	_data_->_data94_->self = geary_imap_db_gc_ref (_data_->self);
	_data_->_data94_->_async_data_ = _data_;
	_data_->_data94_->last_reap_time_t = (gint64) -1;
	_data_->_data94_->last_vacuum_time_t = (gint64) -1;
	_data_->_data94_->free_page_count = (gint64) 0;
	_data_->_data94_->reaped_count = -1;
	_data_->_data94_->page_size = 0;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RO, ___lambda25__geary_db_transaction_method, _data_->_data94_, _data_->cancellable, geary_imap_db_gc_fetch_gc_info_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block94_data_unref (_data_->_data94_);
		_data_->_data94_ = NULL;
		_g_date_time_unref0 (_data_->last_reap_time);
		_g_date_time_unref0 (_data_->last_vacuum_time);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_data94_->last_reap_time_t >= ((gint64) 0)) {
		_data_->_tmp2_ = g_date_time_new_from_unix_local (_data_->_data94_->last_reap_time_t);
		_g_date_time_unref0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp2_;
	} else {
		_g_date_time_unref0 (_data_->_tmp1_);
		_data_->_tmp1_ = NULL;
	}
	_data_->_tmp3_ = _g_date_time_ref0 (_data_->_tmp1_);
	_g_date_time_unref0 (_data_->last_reap_time);
	_data_->last_reap_time = _data_->_tmp3_;
	if (_data_->_data94_->last_vacuum_time_t >= ((gint64) 0)) {
		_data_->_tmp5_ = g_date_time_new_from_unix_local (_data_->_data94_->last_vacuum_time_t);
		_g_date_time_unref0 (_data_->_tmp4_);
		_data_->_tmp4_ = _data_->_tmp5_;
	} else {
		_g_date_time_unref0 (_data_->_tmp4_);
		_data_->_tmp4_ = NULL;
	}
	_data_->_tmp6_ = _g_date_time_ref0 (_data_->_tmp4_);
	_g_date_time_unref0 (_data_->last_vacuum_time);
	_data_->last_vacuum_time = _data_->_tmp6_;
	_data_->reaped_messages_since_last_vacuum = _data_->_data94_->reaped_count;
	_data_->free_page_bytes = _data_->_data94_->free_page_count * _data_->_data94_->page_size;
	_g_date_time_unref0 (_data_->_tmp4_);
	_g_date_time_unref0 (_data_->_tmp1_);
	block94_data_unref (_data_->_data94_);
	_data_->_data94_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
geary_imap_db_gc_to_string (GearyImapDBGC* self)
{
	GearyImapDBDatabase* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_GC (self), NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = geary_db_database_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_DB_TYPE_DATABASE, GearyDbDatabase));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("GC:%s", _tmp2_);
	result = _tmp3_;
	return result;
}

static void
geary_imap_db_value_gc_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_imap_db_value_gc_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_imap_db_gc_unref (value->data[0].v_pointer);
	}
}

static void
geary_imap_db_value_gc_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_imap_db_gc_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_imap_db_value_gc_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_imap_db_value_gc_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyImapDBGC * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_imap_db_gc_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_imap_db_value_gc_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	GearyImapDBGC ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_imap_db_gc_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_imap_db_param_spec_gc (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	GearyImapDBParamSpecGC* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_IMAP_DB_TYPE_GC), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_imap_db_value_get_gc (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_GC), NULL);
	return value->data[0].v_pointer;
}

void
geary_imap_db_value_set_gc (GValue* value,
                            gpointer v_object)
{
	GearyImapDBGC * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_GC));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_IMAP_DB_TYPE_GC));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_imap_db_gc_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_imap_db_gc_unref (old);
	}
}

void
geary_imap_db_value_take_gc (GValue* value,
                             gpointer v_object)
{
	GearyImapDBGC * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_GC));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_IMAP_DB_TYPE_GC));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_imap_db_gc_unref (old);
	}
}

static void
geary_imap_db_gc_class_init (GearyImapDBGCClass * klass,
                             gpointer klass_data)
{
	geary_imap_db_gc_parent_class = g_type_class_peek_parent (klass);
	((GearyImapDBGCClass *) klass)->finalize = geary_imap_db_gc_finalize;
	g_type_class_adjust_private_offset (klass, &GearyImapDBGC_private_offset);
}

static void
geary_imap_db_gc_instance_init (GearyImapDBGC * self,
                                gpointer klass)
{
	self->priv = geary_imap_db_gc_get_instance_private (self);
	self->priv->_is_running = FALSE;
	self->ref_count = 1;
}

static void
geary_imap_db_gc_finalize (GearyImapDBGC * obj)
{
	GearyImapDBGC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_DB_TYPE_GC, GearyImapDBGC);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->db);
}

/**
 * IMAP database garbage collector.
 *
 * Currently the garbage collector reaps messages unlinked from the MessageLocationTable older than
 * a prescribed date.  It also removes their on-disk attachment files (in a transaction-safe manner)
 * and looks for empty directories in the attachment directory tree (caused by attachment files
 * being removed without deleting their parents).
 *
 * The garbage collector is designed to run in the background and in such a way that it can be
 * closed (even by application shutdown) and re-run later without the database going incoherent.
 *
 * In addition, GC can recommend when to perform a VACUUM on the database and perform that
 * operation for the caller.  Vacuuming locks the database for an extended period of time, and GC
 * attempts to determine when it's best to do that by tracking the number of messages reaped by
 * the garbage collector.  (Vacuuming is really only advantageous when lots of rows have been
 * deleted in the database; without garbage collection, Geary's database tends to merely grow in
 * size.)  Unlike garbage collection, vacuuming is not designed to run in the background and the
 * user should be presented a busy monitor while it's occurring.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_db_gc_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_imap_db_value_gc_init, geary_imap_db_value_gc_free_value, geary_imap_db_value_gc_copy_value, geary_imap_db_value_gc_peek_pointer, "p", geary_imap_db_value_gc_collect_value, "p", geary_imap_db_value_gc_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDBGCClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_db_gc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDBGC), 0, (GInstanceInitFunc) geary_imap_db_gc_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_imap_db_gc_type_id;
	geary_imap_db_gc_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyImapDBGC", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyImapDBGC_private_offset = g_type_add_instance_private (geary_imap_db_gc_type_id, sizeof (GearyImapDBGCPrivate));
	return geary_imap_db_gc_type_id;
}

GType
geary_imap_db_gc_get_type (void)
{
	static gsize geary_imap_db_gc_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_gc_type_id__once)) {
		GType geary_imap_db_gc_type_id;
		geary_imap_db_gc_type_id = geary_imap_db_gc_get_type_once ();
		g_once_init_leave (&geary_imap_db_gc_type_id__once, geary_imap_db_gc_type_id);
	}
	return geary_imap_db_gc_type_id__once;
}

gpointer
geary_imap_db_gc_ref (gpointer instance)
{
	GearyImapDBGC * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_imap_db_gc_unref (gpointer instance)
{
	GearyImapDBGC * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_IMAP_DB_GC_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

