/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gcr-dbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_callback,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringVariantStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_callback,
        const gchar *arg_type,
        GVariant *arg_properties,
        const gchar *arg_exchange,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringVariantStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringVariantStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_reply,
        GVariant *arg_properties,
        const gchar *arg_exchange,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.keyring.internal.Prompter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_GcrDbusPrompter
 * @title: _GcrDbusPrompter
 * @short_description: Generated C code for the org.gnome.keyring.internal.Prompter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.keyring.internal.Prompter ---- */

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_begin_prompting_IN_ARG_callback =
{
  {
    -1,
    (gchar *) "callback",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __gcr_dbus_prompter_method_info_begin_prompting_IN_ARG_pointers[] =
{
  &__gcr_dbus_prompter_method_info_begin_prompting_IN_ARG_callback.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __gcr_dbus_prompter_method_info_begin_prompting =
{
  {
    -1,
    (gchar *) "BeginPrompting",
    (GDBusArgInfo **) &__gcr_dbus_prompter_method_info_begin_prompting_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-prompting",
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_callback =
{
  {
    -1,
    (gchar *) "callback",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_exchange =
{
  {
    -1,
    (gchar *) "exchange",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_pointers[] =
{
  &__gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_callback.parent_struct,
  &__gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_type.parent_struct,
  &__gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_properties.parent_struct,
  &__gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_exchange.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __gcr_dbus_prompter_method_info_perform_prompt =
{
  {
    -1,
    (gchar *) "PerformPrompt",
    (GDBusArgInfo **) &__gcr_dbus_prompter_method_info_perform_prompt_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-perform-prompt",
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_method_info_stop_prompting_IN_ARG_callback =
{
  {
    -1,
    (gchar *) "callback",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __gcr_dbus_prompter_method_info_stop_prompting_IN_ARG_pointers[] =
{
  &__gcr_dbus_prompter_method_info_stop_prompting_IN_ARG_callback.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __gcr_dbus_prompter_method_info_stop_prompting =
{
  {
    -1,
    (gchar *) "StopPrompting",
    (GDBusArgInfo **) &__gcr_dbus_prompter_method_info_stop_prompting_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-stop-prompting",
  FALSE
};

static const GDBusMethodInfo * const __gcr_dbus_prompter_method_info_pointers[] =
{
  &__gcr_dbus_prompter_method_info_begin_prompting.parent_struct,
  &__gcr_dbus_prompter_method_info_perform_prompt.parent_struct,
  &__gcr_dbus_prompter_method_info_stop_prompting.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __gcr_dbus_prompter_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.keyring.internal.Prompter",
    (GDBusMethodInfo **) &__gcr_dbus_prompter_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "prompter",
};


/**
 * _gcr_dbus_prompter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_gcr_dbus_prompter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct;
}

/**
 * _gcr_dbus_prompter_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_GcrDbusPrompter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_gcr_dbus_prompter_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_gcr_dbus_prompter_method_marshal_begin_prompting (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_gcr_dbus_prompter_method_marshal_perform_prompt (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_gcr_dbus_prompter_method_marshal_stop_prompting (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _GcrDbusPrompter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link>.
 */

/**
 * _GcrDbusPrompterIface:
 * @parent_iface: The parent interface.
 * @handle_begin_prompting: Handler for the #_GcrDbusPrompter::handle-begin-prompting signal.
 * @handle_perform_prompt: Handler for the #_GcrDbusPrompter::handle-perform-prompt signal.
 * @handle_stop_prompting: Handler for the #_GcrDbusPrompter::handle-stop-prompting signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link>.
 */

typedef _GcrDbusPrompterIface _GcrDbusPrompterInterface;
G_DEFINE_INTERFACE (_GcrDbusPrompter, _gcr_dbus_prompter, G_TYPE_OBJECT)

static void
_gcr_dbus_prompter_default_init (_GcrDbusPrompterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _GcrDbusPrompter::handle-begin-prompting:
   * @object: A #_GcrDbusPrompter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_callback: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.BeginPrompting">BeginPrompting()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _gcr_dbus_prompter_complete_begin_prompting() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-prompting",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_GcrDbusPrompterIface, handle_begin_prompting),
    g_signal_accumulator_true_handled,
    NULL,
      _gcr_dbus_prompter_method_marshal_begin_prompting,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * _GcrDbusPrompter::handle-perform-prompt:
   * @object: A #_GcrDbusPrompter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_callback: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   * @arg_exchange: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.PerformPrompt">PerformPrompt()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _gcr_dbus_prompter_complete_perform_prompt() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-perform-prompt",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_GcrDbusPrompterIface, handle_perform_prompt),
    g_signal_accumulator_true_handled,
    NULL,
      _gcr_dbus_prompter_method_marshal_perform_prompt,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRING);

  /**
   * _GcrDbusPrompter::handle-stop-prompting:
   * @object: A #_GcrDbusPrompter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_callback: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.StopPrompting">StopPrompting()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _gcr_dbus_prompter_complete_stop_prompting() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-prompting",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_GcrDbusPrompterIface, handle_stop_prompting),
    g_signal_accumulator_true_handled,
    NULL,
      _gcr_dbus_prompter_method_marshal_stop_prompting,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

}

/**
 * _gcr_dbus_prompter_call_begin_prompting:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.BeginPrompting">BeginPrompting()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_call_begin_prompting_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_call_begin_prompting_sync() for the synchronous, blocking version of this method.
 */
void
_gcr_dbus_prompter_call_begin_prompting (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginPrompting",
    g_variant_new ("(o)",
                   arg_callback),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _gcr_dbus_prompter_call_begin_prompting_finish:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_call_begin_prompting().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _gcr_dbus_prompter_call_begin_prompting().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_begin_prompting_finish (
    _GcrDbusPrompter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_call_begin_prompting_sync:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.BeginPrompting">BeginPrompting()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_call_begin_prompting() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_begin_prompting_sync (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginPrompting",
    g_variant_new ("(o)",
                   arg_callback),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_call_perform_prompt:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_exchange: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.PerformPrompt">PerformPrompt()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_call_perform_prompt_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_call_perform_prompt_sync() for the synchronous, blocking version of this method.
 */
void
_gcr_dbus_prompter_call_perform_prompt (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    const gchar *arg_type,
    GVariant *arg_properties,
    const gchar *arg_exchange,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PerformPrompt",
    g_variant_new ("(os@a{sv}s)",
                   arg_callback,
                   arg_type,
                   arg_properties,
                   arg_exchange),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _gcr_dbus_prompter_call_perform_prompt_finish:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_call_perform_prompt().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _gcr_dbus_prompter_call_perform_prompt().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_perform_prompt_finish (
    _GcrDbusPrompter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_call_perform_prompt_sync:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_exchange: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.PerformPrompt">PerformPrompt()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_call_perform_prompt() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_perform_prompt_sync (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    const gchar *arg_type,
    GVariant *arg_properties,
    const gchar *arg_exchange,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PerformPrompt",
    g_variant_new ("(os@a{sv}s)",
                   arg_callback,
                   arg_type,
                   arg_properties,
                   arg_exchange),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_call_stop_prompting:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.StopPrompting">StopPrompting()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_call_stop_prompting_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_call_stop_prompting_sync() for the synchronous, blocking version of this method.
 */
void
_gcr_dbus_prompter_call_stop_prompting (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopPrompting",
    g_variant_new ("(o)",
                   arg_callback),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _gcr_dbus_prompter_call_stop_prompting_finish:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_call_stop_prompting().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _gcr_dbus_prompter_call_stop_prompting().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_stop_prompting_finish (
    _GcrDbusPrompter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_call_stop_prompting_sync:
 * @proxy: A #_GcrDbusPrompterProxy.
 * @arg_callback: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.StopPrompting">StopPrompting()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_call_stop_prompting() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_call_stop_prompting_sync (
    _GcrDbusPrompter *proxy,
    const gchar *arg_callback,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopPrompting",
    g_variant_new ("(o)",
                   arg_callback),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_complete_begin_prompting:
 * @object: A #_GcrDbusPrompter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.BeginPrompting">BeginPrompting()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_gcr_dbus_prompter_complete_begin_prompting (
    _GcrDbusPrompter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _gcr_dbus_prompter_complete_perform_prompt:
 * @object: A #_GcrDbusPrompter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.PerformPrompt">PerformPrompt()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_gcr_dbus_prompter_complete_perform_prompt (
    _GcrDbusPrompter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _gcr_dbus_prompter_complete_stop_prompting:
 * @object: A #_GcrDbusPrompter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter.StopPrompting">StopPrompting()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_gcr_dbus_prompter_complete_stop_prompting (
    _GcrDbusPrompter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _GcrDbusPrompterProxy:
 *
 * The #_GcrDbusPrompterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _GcrDbusPrompterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_GcrDbusPrompterProxy.
 */

struct __GcrDbusPrompterProxyPrivate
{
  GData *qdata;
};

static void _gcr_dbus_prompter_proxy_iface_init (_GcrDbusPrompterIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterProxy, _gcr_dbus_prompter_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_GcrDbusPrompterProxy)
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER, _gcr_dbus_prompter_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterProxy, _gcr_dbus_prompter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER, _gcr_dbus_prompter_proxy_iface_init))

#endif
static void
_gcr_dbus_prompter_proxy_finalize (GObject *object)
{
  _GcrDbusPrompterProxy *proxy = _GCR_DBUS_PROMPTER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_gcr_dbus_prompter_proxy_parent_class)->finalize (object);
}

static void
_gcr_dbus_prompter_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_gcr_dbus_prompter_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_gcr_dbus_prompter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _GCR_DBUS_TYPE_PROMPTER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _GCR_DBUS_TYPE_PROMPTER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_gcr_dbus_prompter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _GcrDbusPrompterProxy *proxy = _GCR_DBUS_PROMPTER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_gcr_dbus_prompter_proxy_init (_GcrDbusPrompterProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _gcr_dbus_prompter_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _GCR_DBUS_TYPE_PROMPTER_PROXY, _GcrDbusPrompterProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _gcr_dbus_prompter_interface_info ());
}

static void
_gcr_dbus_prompter_proxy_class_init (_GcrDbusPrompterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _gcr_dbus_prompter_proxy_finalize;
  gobject_class->get_property = _gcr_dbus_prompter_proxy_get_property;
  gobject_class->set_property = _gcr_dbus_prompter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _gcr_dbus_prompter_proxy_g_signal;
  proxy_class->g_properties_changed = _gcr_dbus_prompter_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_GcrDbusPrompterProxyPrivate));
#endif
}

static void
_gcr_dbus_prompter_proxy_iface_init (_GcrDbusPrompterIface *iface G_GNUC_UNUSED)
{
}

/**
 * _gcr_dbus_prompter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_proxy_new_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_gcr_dbus_prompter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_GCR_DBUS_TYPE_PROMPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter", NULL);
}

/**
 * _gcr_dbus_prompter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _gcr_dbus_prompter_proxy_new().
 *
 * Returns: (transfer full) (type _GcrDbusPrompterProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompter *
_gcr_dbus_prompter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER (ret);
  else
    return NULL;
}

/**
 * _gcr_dbus_prompter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompter *
_gcr_dbus_prompter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_GCR_DBUS_TYPE_PROMPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter", NULL);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER (ret);
  else
    return NULL;
}


/**
 * _gcr_dbus_prompter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _gcr_dbus_prompter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_gcr_dbus_prompter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_GCR_DBUS_TYPE_PROMPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter", NULL);
}

/**
 * _gcr_dbus_prompter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _gcr_dbus_prompter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _GcrDbusPrompterProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompter *
_gcr_dbus_prompter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER (ret);
  else
    return NULL;
}

/**
 * _gcr_dbus_prompter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _gcr_dbus_prompter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompter *
_gcr_dbus_prompter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_GCR_DBUS_TYPE_PROMPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter", NULL);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _GcrDbusPrompterSkeleton:
 *
 * The #_GcrDbusPrompterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _GcrDbusPrompterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_GcrDbusPrompterSkeleton.
 */

struct __GcrDbusPrompterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__gcr_dbus_prompter_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _GcrDbusPrompterSkeleton *skeleton = _GCR_DBUS_PROMPTER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _GCR_DBUS_TYPE_PROMPTER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _GCR_DBUS_TYPE_PROMPTER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__gcr_dbus_prompter_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _GcrDbusPrompterSkeleton *skeleton = _GCR_DBUS_PROMPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__gcr_dbus_prompter_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _GcrDbusPrompterSkeleton *skeleton = _GCR_DBUS_PROMPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __gcr_dbus_prompter_skeleton_vtable =
{
  __gcr_dbus_prompter_skeleton_handle_method_call,
  __gcr_dbus_prompter_skeleton_handle_get_property,
  __gcr_dbus_prompter_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_gcr_dbus_prompter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _gcr_dbus_prompter_interface_info ();
}

static GDBusInterfaceVTable *
_gcr_dbus_prompter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__gcr_dbus_prompter_skeleton_vtable;
}

static GVariant *
_gcr_dbus_prompter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _GcrDbusPrompterSkeleton *skeleton = _GCR_DBUS_PROMPTER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__gcr_dbus_prompter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __gcr_dbus_prompter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __gcr_dbus_prompter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __gcr_dbus_prompter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.keyring.internal.Prompter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_gcr_dbus_prompter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void _gcr_dbus_prompter_skeleton_iface_init (_GcrDbusPrompterIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterSkeleton, _gcr_dbus_prompter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_GcrDbusPrompterSkeleton)
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER, _gcr_dbus_prompter_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterSkeleton, _gcr_dbus_prompter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER, _gcr_dbus_prompter_skeleton_iface_init))

#endif
static void
_gcr_dbus_prompter_skeleton_finalize (GObject *object)
{
  _GcrDbusPrompterSkeleton *skeleton = _GCR_DBUS_PROMPTER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_gcr_dbus_prompter_skeleton_parent_class)->finalize (object);
}

static void
_gcr_dbus_prompter_skeleton_init (_GcrDbusPrompterSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _gcr_dbus_prompter_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _GCR_DBUS_TYPE_PROMPTER_SKELETON, _GcrDbusPrompterSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_gcr_dbus_prompter_skeleton_class_init (_GcrDbusPrompterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _gcr_dbus_prompter_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _gcr_dbus_prompter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _gcr_dbus_prompter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _gcr_dbus_prompter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _gcr_dbus_prompter_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_GcrDbusPrompterSkeletonPrivate));
#endif
}

static void
_gcr_dbus_prompter_skeleton_iface_init (_GcrDbusPrompterIface *iface G_GNUC_UNUSED)
{
}

/**
 * _gcr_dbus_prompter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter.top_of_page">org.gnome.keyring.internal.Prompter</link>.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterSkeleton): The skeleton object.
 */
_GcrDbusPrompter *
_gcr_dbus_prompter_skeleton_new (void)
{
  return _GCR_DBUS_PROMPTER (g_object_new (_GCR_DBUS_TYPE_PROMPTER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.keyring.internal.Prompter.Callback
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_GcrDbusPrompterCallback
 * @title: _GcrDbusPrompterCallback
 * @short_description: Generated C code for the org.gnome.keyring.internal.Prompter.Callback D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.keyring.internal.Prompter.Callback ---- */

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_exchange =
{
  {
    -1,
    (gchar *) "exchange",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_pointers[] =
{
  &__gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_reply.parent_struct,
  &__gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_properties.parent_struct,
  &__gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_exchange.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __gcr_dbus_prompter_callback_method_info_prompt_ready =
{
  {
    -1,
    (gchar *) "PromptReady",
    (GDBusArgInfo **) &__gcr_dbus_prompter_callback_method_info_prompt_ready_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-prompt-ready",
  FALSE
};

static const _ExtendedGDBusMethodInfo __gcr_dbus_prompter_callback_method_info_prompt_done =
{
  {
    -1,
    (gchar *) "PromptDone",
    NULL,
    NULL,
    NULL
  },
  "handle-prompt-done",
  FALSE
};

static const GDBusMethodInfo * const __gcr_dbus_prompter_callback_method_info_pointers[] =
{
  &__gcr_dbus_prompter_callback_method_info_prompt_ready.parent_struct,
  &__gcr_dbus_prompter_callback_method_info_prompt_done.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __gcr_dbus_prompter_callback_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.keyring.internal.Prompter.Callback",
    (GDBusMethodInfo **) &__gcr_dbus_prompter_callback_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "prompter-callback",
};


/**
 * _gcr_dbus_prompter_callback_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_gcr_dbus_prompter_callback_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct;
}

/**
 * _gcr_dbus_prompter_callback_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_GcrDbusPrompterCallback interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_gcr_dbus_prompter_callback_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_gcr_dbus_prompter_callback_method_marshal_prompt_ready (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_gcr_dbus_prompter_callback_method_marshal_prompt_done (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _GcrDbusPrompterCallback:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link>.
 */

/**
 * _GcrDbusPrompterCallbackIface:
 * @parent_iface: The parent interface.
 * @handle_prompt_done: Handler for the #_GcrDbusPrompterCallback::handle-prompt-done signal.
 * @handle_prompt_ready: Handler for the #_GcrDbusPrompterCallback::handle-prompt-ready signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link>.
 */

typedef _GcrDbusPrompterCallbackIface _GcrDbusPrompterCallbackInterface;
G_DEFINE_INTERFACE (_GcrDbusPrompterCallback, _gcr_dbus_prompter_callback, G_TYPE_OBJECT)

static void
_gcr_dbus_prompter_callback_default_init (_GcrDbusPrompterCallbackIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _GcrDbusPrompterCallback::handle-prompt-ready:
   * @object: A #_GcrDbusPrompterCallback.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_reply: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   * @arg_exchange: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptReady">PromptReady()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _gcr_dbus_prompter_callback_complete_prompt_ready() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prompt-ready",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_GcrDbusPrompterCallbackIface, handle_prompt_ready),
    g_signal_accumulator_true_handled,
    NULL,
      _gcr_dbus_prompter_callback_method_marshal_prompt_ready,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRING);

  /**
   * _GcrDbusPrompterCallback::handle-prompt-done:
   * @object: A #_GcrDbusPrompterCallback.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptDone">PromptDone()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _gcr_dbus_prompter_callback_complete_prompt_done() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prompt-done",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_GcrDbusPrompterCallbackIface, handle_prompt_done),
    g_signal_accumulator_true_handled,
    NULL,
      _gcr_dbus_prompter_callback_method_marshal_prompt_done,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * _gcr_dbus_prompter_callback_call_prompt_ready:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @arg_reply: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_exchange: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptReady">PromptReady()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_callback_call_prompt_ready_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_callback_call_prompt_ready_sync() for the synchronous, blocking version of this method.
 */
void
_gcr_dbus_prompter_callback_call_prompt_ready (
    _GcrDbusPrompterCallback *proxy,
    const gchar *arg_reply,
    GVariant *arg_properties,
    const gchar *arg_exchange,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PromptReady",
    g_variant_new ("(s@a{sv}s)",
                   arg_reply,
                   arg_properties,
                   arg_exchange),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _gcr_dbus_prompter_callback_call_prompt_ready_finish:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_callback_call_prompt_ready().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _gcr_dbus_prompter_callback_call_prompt_ready().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_callback_call_prompt_ready_finish (
    _GcrDbusPrompterCallback *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_callback_call_prompt_ready_sync:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @arg_reply: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_exchange: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptReady">PromptReady()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_callback_call_prompt_ready() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_callback_call_prompt_ready_sync (
    _GcrDbusPrompterCallback *proxy,
    const gchar *arg_reply,
    GVariant *arg_properties,
    const gchar *arg_exchange,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PromptReady",
    g_variant_new ("(s@a{sv}s)",
                   arg_reply,
                   arg_properties,
                   arg_exchange),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_callback_call_prompt_done:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptDone">PromptDone()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_callback_call_prompt_done_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_callback_call_prompt_done_sync() for the synchronous, blocking version of this method.
 */
void
_gcr_dbus_prompter_callback_call_prompt_done (
    _GcrDbusPrompterCallback *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PromptDone",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _gcr_dbus_prompter_callback_call_prompt_done_finish:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_callback_call_prompt_done().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _gcr_dbus_prompter_callback_call_prompt_done().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_callback_call_prompt_done_finish (
    _GcrDbusPrompterCallback *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_callback_call_prompt_done_sync:
 * @proxy: A #_GcrDbusPrompterCallbackProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptDone">PromptDone()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_callback_call_prompt_done() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_gcr_dbus_prompter_callback_call_prompt_done_sync (
    _GcrDbusPrompterCallback *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PromptDone",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _gcr_dbus_prompter_callback_complete_prompt_ready:
 * @object: A #_GcrDbusPrompterCallback.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptReady">PromptReady()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_gcr_dbus_prompter_callback_complete_prompt_ready (
    _GcrDbusPrompterCallback *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _gcr_dbus_prompter_callback_complete_prompt_done:
 * @object: A #_GcrDbusPrompterCallback.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-keyring-internal-Prompter-Callback.PromptDone">PromptDone()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_gcr_dbus_prompter_callback_complete_prompt_done (
    _GcrDbusPrompterCallback *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _GcrDbusPrompterCallbackProxy:
 *
 * The #_GcrDbusPrompterCallbackProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _GcrDbusPrompterCallbackProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_GcrDbusPrompterCallbackProxy.
 */

struct __GcrDbusPrompterCallbackProxyPrivate
{
  GData *qdata;
};

static void _gcr_dbus_prompter_callback_proxy_iface_init (_GcrDbusPrompterCallbackIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterCallbackProxy, _gcr_dbus_prompter_callback_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_GcrDbusPrompterCallbackProxy)
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER_CALLBACK, _gcr_dbus_prompter_callback_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterCallbackProxy, _gcr_dbus_prompter_callback_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER_CALLBACK, _gcr_dbus_prompter_callback_proxy_iface_init))

#endif
static void
_gcr_dbus_prompter_callback_proxy_finalize (GObject *object)
{
  _GcrDbusPrompterCallbackProxy *proxy = _GCR_DBUS_PROMPTER_CALLBACK_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_gcr_dbus_prompter_callback_proxy_parent_class)->finalize (object);
}

static void
_gcr_dbus_prompter_callback_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_gcr_dbus_prompter_callback_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_gcr_dbus_prompter_callback_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _GCR_DBUS_TYPE_PROMPTER_CALLBACK);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _GCR_DBUS_TYPE_PROMPTER_CALLBACK);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_gcr_dbus_prompter_callback_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _GcrDbusPrompterCallbackProxy *proxy = _GCR_DBUS_PROMPTER_CALLBACK_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_gcr_dbus_prompter_callback_proxy_init (_GcrDbusPrompterCallbackProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _gcr_dbus_prompter_callback_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _GCR_DBUS_TYPE_PROMPTER_CALLBACK_PROXY, _GcrDbusPrompterCallbackProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _gcr_dbus_prompter_callback_interface_info ());
}

static void
_gcr_dbus_prompter_callback_proxy_class_init (_GcrDbusPrompterCallbackProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _gcr_dbus_prompter_callback_proxy_finalize;
  gobject_class->get_property = _gcr_dbus_prompter_callback_proxy_get_property;
  gobject_class->set_property = _gcr_dbus_prompter_callback_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _gcr_dbus_prompter_callback_proxy_g_signal;
  proxy_class->g_properties_changed = _gcr_dbus_prompter_callback_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_GcrDbusPrompterCallbackProxyPrivate));
#endif
}

static void
_gcr_dbus_prompter_callback_proxy_iface_init (_GcrDbusPrompterCallbackIface *iface G_GNUC_UNUSED)
{
}

/**
 * _gcr_dbus_prompter_callback_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_callback_proxy_new_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_callback_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_gcr_dbus_prompter_callback_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_GCR_DBUS_TYPE_PROMPTER_CALLBACK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter.Callback", NULL);
}

/**
 * _gcr_dbus_prompter_callback_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_callback_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _gcr_dbus_prompter_callback_proxy_new().
 *
 * Returns: (transfer full) (type _GcrDbusPrompterCallbackProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompterCallback *
_gcr_dbus_prompter_callback_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER_CALLBACK (ret);
  else
    return NULL;
}

/**
 * _gcr_dbus_prompter_callback_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_callback_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterCallbackProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompterCallback *
_gcr_dbus_prompter_callback_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_GCR_DBUS_TYPE_PROMPTER_CALLBACK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter.Callback", NULL);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER_CALLBACK (ret);
  else
    return NULL;
}


/**
 * _gcr_dbus_prompter_callback_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _gcr_dbus_prompter_callback_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _gcr_dbus_prompter_callback_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _gcr_dbus_prompter_callback_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_gcr_dbus_prompter_callback_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_GCR_DBUS_TYPE_PROMPTER_CALLBACK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter.Callback", NULL);
}

/**
 * _gcr_dbus_prompter_callback_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _gcr_dbus_prompter_callback_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _gcr_dbus_prompter_callback_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _GcrDbusPrompterCallbackProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompterCallback *
_gcr_dbus_prompter_callback_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER_CALLBACK (ret);
  else
    return NULL;
}

/**
 * _gcr_dbus_prompter_callback_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _gcr_dbus_prompter_callback_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _gcr_dbus_prompter_callback_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterCallbackProxy): The constructed proxy object or %NULL if @error is set.
 */
_GcrDbusPrompterCallback *
_gcr_dbus_prompter_callback_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_GCR_DBUS_TYPE_PROMPTER_CALLBACK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.keyring.internal.Prompter.Callback", NULL);
  if (ret != NULL)
    return _GCR_DBUS_PROMPTER_CALLBACK (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _GcrDbusPrompterCallbackSkeleton:
 *
 * The #_GcrDbusPrompterCallbackSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _GcrDbusPrompterCallbackSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_GcrDbusPrompterCallbackSkeleton.
 */

struct __GcrDbusPrompterCallbackSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__gcr_dbus_prompter_callback_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _GcrDbusPrompterCallbackSkeleton *skeleton = _GCR_DBUS_PROMPTER_CALLBACK_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _GCR_DBUS_TYPE_PROMPTER_CALLBACK);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _GCR_DBUS_TYPE_PROMPTER_CALLBACK);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__gcr_dbus_prompter_callback_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _GcrDbusPrompterCallbackSkeleton *skeleton = _GCR_DBUS_PROMPTER_CALLBACK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__gcr_dbus_prompter_callback_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _GcrDbusPrompterCallbackSkeleton *skeleton = _GCR_DBUS_PROMPTER_CALLBACK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__gcr_dbus_prompter_callback_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __gcr_dbus_prompter_callback_skeleton_vtable =
{
  __gcr_dbus_prompter_callback_skeleton_handle_method_call,
  __gcr_dbus_prompter_callback_skeleton_handle_get_property,
  __gcr_dbus_prompter_callback_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_gcr_dbus_prompter_callback_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _gcr_dbus_prompter_callback_interface_info ();
}

static GDBusInterfaceVTable *
_gcr_dbus_prompter_callback_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__gcr_dbus_prompter_callback_skeleton_vtable;
}

static GVariant *
_gcr_dbus_prompter_callback_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _GcrDbusPrompterCallbackSkeleton *skeleton = _GCR_DBUS_PROMPTER_CALLBACK_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__gcr_dbus_prompter_callback_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __gcr_dbus_prompter_callback_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __gcr_dbus_prompter_callback_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __gcr_dbus_prompter_callback_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.keyring.internal.Prompter.Callback", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_gcr_dbus_prompter_callback_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void _gcr_dbus_prompter_callback_skeleton_iface_init (_GcrDbusPrompterCallbackIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterCallbackSkeleton, _gcr_dbus_prompter_callback_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_GcrDbusPrompterCallbackSkeleton)
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER_CALLBACK, _gcr_dbus_prompter_callback_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_GcrDbusPrompterCallbackSkeleton, _gcr_dbus_prompter_callback_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_GCR_DBUS_TYPE_PROMPTER_CALLBACK, _gcr_dbus_prompter_callback_skeleton_iface_init))

#endif
static void
_gcr_dbus_prompter_callback_skeleton_finalize (GObject *object)
{
  _GcrDbusPrompterCallbackSkeleton *skeleton = _GCR_DBUS_PROMPTER_CALLBACK_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_gcr_dbus_prompter_callback_skeleton_parent_class)->finalize (object);
}

static void
_gcr_dbus_prompter_callback_skeleton_init (_GcrDbusPrompterCallbackSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _gcr_dbus_prompter_callback_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _GCR_DBUS_TYPE_PROMPTER_CALLBACK_SKELETON, _GcrDbusPrompterCallbackSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_gcr_dbus_prompter_callback_skeleton_class_init (_GcrDbusPrompterCallbackSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _gcr_dbus_prompter_callback_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _gcr_dbus_prompter_callback_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _gcr_dbus_prompter_callback_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _gcr_dbus_prompter_callback_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _gcr_dbus_prompter_callback_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_GcrDbusPrompterCallbackSkeletonPrivate));
#endif
}

static void
_gcr_dbus_prompter_callback_skeleton_iface_init (_GcrDbusPrompterCallbackIface *iface G_GNUC_UNUSED)
{
}

/**
 * _gcr_dbus_prompter_callback_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-keyring-internal-Prompter-Callback.top_of_page">org.gnome.keyring.internal.Prompter.Callback</link>.
 *
 * Returns: (transfer full) (type _GcrDbusPrompterCallbackSkeleton): The skeleton object.
 */
_GcrDbusPrompterCallback *
_gcr_dbus_prompter_callback_skeleton_new (void)
{
  return _GCR_DBUS_PROMPTER_CALLBACK (g_object_new (_GCR_DBUS_TYPE_PROMPTER_CALLBACK_SKELETON, NULL));
}

