/* game-board-view.c generated by valac 0.56.18, the Vala compiler
 * generated from game-board-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2018 Jacob Humphrey

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_BOARD_VIEW (game_board_view_get_type ())
#define GAME_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_BOARD_VIEW, GameBoardView))
#define GAME_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_BOARD_VIEW, GameBoardViewClass))
#define IS_GAME_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_BOARD_VIEW))
#define IS_GAME_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_BOARD_VIEW))
#define GAME_BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_BOARD_VIEW, GameBoardViewClass))

typedef struct _GameBoardView GameBoardView;
typedef struct _GameBoardViewClass GameBoardViewClass;
typedef struct _GameBoardViewPrivate GameBoardViewPrivate;

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
enum  {
	GAME_BOARD_VIEW_0_PROPERTY,
	GAME_BOARD_VIEW_GAME_BOARD_PROPERTY,
	GAME_BOARD_VIEW_THEME_MANAGER_PROPERTY,
	GAME_BOARD_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_board_view_properties[GAME_BOARD_VIEW_NUM_PROPERTIES];
typedef enum  {
	GAME_BOARD_VIEW_TILE_PLAYER1,
	GAME_BOARD_VIEW_TILE_PLAYER2,
	GAME_BOARD_VIEW_TILE_CLEAR,
	GAME_BOARD_VIEW_TILE_CLEAR_CURSOR,
	GAME_BOARD_VIEW_TILE_PLAYER1_CURSOR,
	GAME_BOARD_VIEW_TILE_PLAYER2_CURSOR
} GameBoardViewTile;

#define GAME_BOARD_VIEW_TYPE_TILE (game_board_view_tile_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PLAYER_NOBODY,
	PLAYER_HUMAN,
	PLAYER_OPPONENT
} Player;

#define TYPE_PLAYER (player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GAME_BOARD_VIEW_COLUMN_CLICKED_SIGNAL,
	GAME_BOARD_VIEW_NUM_SIGNALS
};
static guint game_board_view_signals[GAME_BOARD_VIEW_NUM_SIGNALS] = {0};

struct _GameBoardView {
	GtkDrawingArea parent_instance;
	GameBoardViewPrivate * priv;
};

struct _GameBoardViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameBoardViewPrivate {
	Board* _game_board;
	ThemeManager* _theme_manager;
	gint board_size;
	gint tile_size;
	gint offset[6];
	gint board_x;
	gint board_y;
	GdkPixbuf* pb_tileset;
	GdkPixbuf* pb_bground;
	GtkGestureMultiPress* click_controller;
};

static gint GameBoardView_private_offset;
static gpointer game_board_view_parent_class = NULL;

VALA_EXTERN GType game_board_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameBoardView, g_object_unref)
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
static GType game_board_view_tile_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GameBoardView* game_board_view_new (Board* game_board,
                                    ThemeManager* theme_manager);
VALA_EXTERN GameBoardView* game_board_view_construct (GType object_type,
                                          Board* game_board,
                                          ThemeManager* theme_manager);
VALA_EXTERN void game_board_view_draw_tile (GameBoardView* self,
                                gint row,
                                gint col);
static gboolean game_board_view_real_configure_event (GtkWidget* base,
                                               GdkEventConfigure* e);
static Board* game_board_view_get_game_board (GameBoardView* self);
VALA_EXTERN guint8 board_get_size (Board* self);
static void game_board_view_refresh_pixmaps (GameBoardView* self);
static gboolean game_board_view_real_draw (GtkWidget* base,
                                    cairo_t* cr);
static inline void game_board_view_paint_tile (GameBoardView* self,
                                 cairo_t* cr,
                                 guint8 row,
                                 guint8 col);
static inline void game_board_view_draw_grid (GameBoardView* self,
                                cairo_t* cr);
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Player board_get (Board* self,
                  guint8 x,
                  guint8 y);
static ThemeManager* game_board_view_get_theme_manager (GameBoardView* self);
VALA_EXTERN gchar* theme_manager_get_grid_color (ThemeManager* self);
VALA_EXTERN GdkPixbuf* theme_manager_get_pb_tileset_raw (ThemeManager* self);
VALA_EXTERN GdkPixbuf* theme_manager_get_pb_bground_raw (ThemeManager* self);
static inline void game_board_view_init_mouse (GameBoardView* self);
static inline void game_board_view_on_click (GameBoardView* self,
                               GtkGestureMultiPress* _click_controller,
                               gint n_press,
                               gdouble event_x,
                               gdouble event_y);
static void _game_board_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                gint n_press,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static inline gboolean game_board_view_get_column (GameBoardView* self,
                                     gint x,
                                     gint y,
                                     guint8* col);
static void game_board_view_set_game_board (GameBoardView* self,
                                     Board* value);
static void game_board_view_set_theme_manager (GameBoardView* self,
                                        ThemeManager* value);
static void g_cclosure_user_marshal_BOOLEAN__UCHAR (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data);
static GObject * game_board_view_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _game_board_view_refresh_pixmaps_theme_manager_theme_changed (ThemeManager* _sender,
                                                                   gpointer self);
static void game_board_view_finalize (GObject * obj);
static GType game_board_view_get_type_once (void);
static void _vala_game_board_view_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_game_board_view_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
game_board_view_get_instance_private (GameBoardView* self)
{
	return G_STRUCT_MEMBER_P (self, GameBoardView_private_offset);
}

static GType
game_board_view_tile_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_BOARD_VIEW_TILE_PLAYER1, "GAME_BOARD_VIEW_TILE_PLAYER1", "player1"}, {GAME_BOARD_VIEW_TILE_PLAYER2, "GAME_BOARD_VIEW_TILE_PLAYER2", "player2"}, {GAME_BOARD_VIEW_TILE_CLEAR, "GAME_BOARD_VIEW_TILE_CLEAR", "clear"}, {GAME_BOARD_VIEW_TILE_CLEAR_CURSOR, "GAME_BOARD_VIEW_TILE_CLEAR_CURSOR", "clear-cursor"}, {GAME_BOARD_VIEW_TILE_PLAYER1_CURSOR, "GAME_BOARD_VIEW_TILE_PLAYER1_CURSOR", "player1-cursor"}, {GAME_BOARD_VIEW_TILE_PLAYER2_CURSOR, "GAME_BOARD_VIEW_TILE_PLAYER2_CURSOR", "player2-cursor"}, {0, NULL, NULL}};
	GType game_board_view_tile_type_id;
	game_board_view_tile_type_id = g_enum_register_static ("GameBoardViewTile", values);
	return game_board_view_tile_type_id;
}

static GType
game_board_view_tile_get_type (void)
{
	static volatile gsize game_board_view_tile_type_id__once = 0;
	if (g_once_init_enter (&game_board_view_tile_type_id__once)) {
		GType game_board_view_tile_type_id;
		game_board_view_tile_type_id = game_board_view_tile_get_type_once ();
		g_once_init_leave (&game_board_view_tile_type_id__once, game_board_view_tile_type_id);
	}
	return game_board_view_tile_type_id__once;
}

GameBoardView*
game_board_view_construct (GType object_type,
                           Board* game_board,
                           ThemeManager* theme_manager)
{
	GameBoardView * self = NULL;
	g_return_val_if_fail (game_board != NULL, NULL);
	g_return_val_if_fail (theme_manager != NULL, NULL);
	self = (GameBoardView*) g_object_new (object_type, "game-board", game_board, "theme-manager", theme_manager, NULL);
	return self;
}

GameBoardView*
game_board_view_new (Board* game_board,
                     ThemeManager* theme_manager)
{
	return game_board_view_construct (TYPE_GAME_BOARD_VIEW, game_board, theme_manager);
}

inline void
game_board_view_draw_tile (GameBoardView* self,
                           gint row,
                           gint col)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw_area ((GtkWidget*) self, (col * self->priv->tile_size) + self->priv->board_x, (row * self->priv->tile_size) + self->priv->board_y, self->priv->tile_size, self->priv->tile_size);
}

static gboolean
game_board_view_real_configure_event (GtkWidget* base,
                                      GdkEventConfigure* e)
{
	GameBoardView * self;
	gint allocated_width = 0;
	gint allocated_height = 0;
	gint size = 0;
	Board* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	Board* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	gboolean result;
	self = (GameBoardView*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	allocated_width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	allocated_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	size = MIN (allocated_width, allocated_height);
	_tmp0_ = self->priv->_game_board;
	_tmp1_ = board_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->tile_size = size / _tmp2_;
	_tmp3_ = self->priv->_game_board;
	_tmp4_ = board_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->board_size = self->priv->tile_size * _tmp5_;
	self->priv->board_x = (allocated_width - self->priv->board_size) / 2;
	self->priv->board_y = (allocated_height - self->priv->board_size) / 2;
	self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER1] = 0;
	self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER2] = self->priv->tile_size;
	self->priv->offset[GAME_BOARD_VIEW_TILE_CLEAR] = self->priv->tile_size * 2;
	self->priv->offset[GAME_BOARD_VIEW_TILE_CLEAR_CURSOR] = self->priv->tile_size * 3;
	self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER1_CURSOR] = self->priv->tile_size * 4;
	self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER2_CURSOR] = self->priv->tile_size * 5;
	game_board_view_refresh_pixmaps (self);
	result = TRUE;
	return result;
}

static gboolean
game_board_view_real_draw (GtkWidget* base,
                           cairo_t* cr)
{
	GameBoardView * self;
	GdkPixbuf* _tmp0_;
	gboolean result;
	self = (GameBoardView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_save (cr);
	cairo_translate (cr, (gdouble) self->priv->board_x, (gdouble) self->priv->board_y);
	_tmp0_ = self->priv->pb_bground;
	gdk_cairo_set_source_pixbuf (cr, _tmp0_, 0.0, 0.0);
	cairo_rectangle (cr, 0.0, 0.0, (gdouble) self->priv->board_size, (gdouble) self->priv->board_size);
	cairo_paint (cr);
	cairo_restore (cr);
	{
		guint8 row = 0U;
		row = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Board* _tmp3_;
				guint8 _tmp4_;
				guint8 _tmp5_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = row;
					row = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_game_board;
				_tmp4_ = board_get_size (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					guint8 col = 0U;
					col = (guint8) 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							Board* _tmp8_;
							guint8 _tmp9_;
							guint8 _tmp10_;
							if (!_tmp6_) {
								guint8 _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_game_board;
							_tmp9_ = board_get_size (_tmp8_);
							_tmp10_ = _tmp9_;
							if (!(col < _tmp10_)) {
								break;
							}
							game_board_view_paint_tile (self, cr, row, col);
						}
					}
				}
			}
		}
	}
	cairo_save (cr);
	cairo_translate (cr, (gdouble) self->priv->board_x, (gdouble) self->priv->board_y);
	game_board_view_draw_grid (self, cr);
	cairo_restore (cr);
	result = FALSE;
	return result;
}

static inline void
game_board_view_paint_tile (GameBoardView* self,
                            cairo_t* cr,
                            guint8 row,
                            guint8 col)
{
	Player tile = 0;
	Board* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint os = 0;
	gint x = 0;
	gint y = 0;
	GdkPixbuf* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_game_board;
	tile = board_get (_tmp0_, row, col);
	if (tile == PLAYER_NOBODY) {
		_tmp1_ = ((gint) row) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	os = 0;
	if (((gint) row) == 0) {
		switch (tile) {
			case PLAYER_HUMAN:
			{
				gint _tmp2_;
				_tmp2_ = self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER1_CURSOR];
				os = _tmp2_;
				break;
			}
			case PLAYER_OPPONENT:
			{
				gint _tmp3_;
				_tmp3_ = self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER2_CURSOR];
				os = _tmp3_;
				break;
			}
			case PLAYER_NOBODY:
			{
				gint _tmp4_;
				_tmp4_ = self->priv->offset[GAME_BOARD_VIEW_TILE_CLEAR_CURSOR];
				os = _tmp4_;
				break;
			}
			default:
			break;
		}
	} else {
		switch (tile) {
			case PLAYER_HUMAN:
			{
				gint _tmp5_;
				_tmp5_ = self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER1];
				os = _tmp5_;
				break;
			}
			case PLAYER_OPPONENT:
			{
				gint _tmp6_;
				_tmp6_ = self->priv->offset[GAME_BOARD_VIEW_TILE_PLAYER2];
				os = _tmp6_;
				break;
			}
			case PLAYER_NOBODY:
			{
				g_assert_not_reached ();
			}
			default:
			break;
		}
	}
	cairo_save (cr);
	x = (col * self->priv->tile_size) + self->priv->board_x;
	y = (row * self->priv->tile_size) + self->priv->board_y;
	_tmp7_ = self->priv->pb_tileset;
	gdk_cairo_set_source_pixbuf (cr, _tmp7_, (gdouble) (x - os), (gdouble) y);
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) self->priv->tile_size, (gdouble) self->priv->tile_size);
	cairo_clip (cr);
	cairo_paint (cr);
	cairo_restore (cr);
}

static inline void
game_board_view_draw_grid (GameBoardView* self,
                           cairo_t* cr)
{
	static const gdouble dashes[2] = {4.0, 4.0};
	GdkRGBA color = {0};
	ThemeManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_grid_color (_tmp0_);
	_tmp2_ = _tmp1_;
	gdk_rgba_parse (&color, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = color;
	gdk_cairo_set_source_rgba (cr, &_tmp3_);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_set_line_width (cr, 1.0);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_BUTT);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_MITER);
	cairo_set_dash (cr, dashes, (gint) G_N_ELEMENTS (dashes), 0.0);
	{
		guint8 i = 0U;
		i = (guint8) 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Board* _tmp6_;
				guint8 _tmp7_;
				guint8 _tmp8_;
				gdouble line_offset = 0.0;
				if (!_tmp4_) {
					guint8 _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->_game_board;
				_tmp7_ = board_get_size (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				line_offset = (i * self->priv->tile_size) + 0.5;
				cairo_move_to (cr, line_offset, 0.0);
				cairo_line_to (cr, line_offset, (gdouble) self->priv->board_size);
				cairo_move_to (cr, 0.0, line_offset);
				cairo_line_to (cr, (gdouble) self->priv->board_size, line_offset);
			}
		}
	}
	cairo_stroke (cr);
	cairo_set_dash (cr, NULL, (gint) 0, 0.0);
	cairo_move_to (cr, 0.0, self->priv->tile_size + 0.5);
	cairo_line_to (cr, (gdouble) self->priv->board_size, self->priv->tile_size + 0.5);
	cairo_stroke (cr);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
game_board_view_refresh_pixmaps (GameBoardView* self)
{
	GdkPixbuf* tmp_pixbuf = NULL;
	ThemeManager* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	ThemeManager* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	g_return_if_fail (self != NULL);
	if (self->priv->tile_size == 0) {
		return;
	}
	_tmp0_ = self->priv->_theme_manager;
	_tmp1_ = theme_manager_get_pb_tileset_raw (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_pixbuf_scale_simple (_tmp2_, self->priv->tile_size * 6, self->priv->tile_size, GDK_INTERP_BILINEAR);
	_g_object_unref0 (tmp_pixbuf);
	tmp_pixbuf = _tmp3_;
	_tmp4_ = tmp_pixbuf;
	if (_tmp4_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp5_ = tmp_pixbuf;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_pixbuf_get_type (), GdkPixbuf));
	_g_object_unref0 (self->priv->pb_tileset);
	self->priv->pb_tileset = _tmp6_;
	_tmp7_ = self->priv->_theme_manager;
	_tmp8_ = theme_manager_get_pb_bground_raw (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gdk_pixbuf_scale_simple (_tmp9_, self->priv->board_size, self->priv->board_size, GDK_INTERP_BILINEAR);
	_g_object_unref0 (tmp_pixbuf);
	tmp_pixbuf = _tmp10_;
	_tmp11_ = tmp_pixbuf;
	if (_tmp11_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp12_ = tmp_pixbuf;
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gdk_pixbuf_get_type (), GdkPixbuf));
	_g_object_unref0 (self->priv->pb_bground);
	self->priv->pb_bground = _tmp13_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (tmp_pixbuf);
}

static void
_game_board_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	game_board_view_on_click ((GameBoardView*) self, _sender, n_press, x, y);
}

static inline void
game_board_view_init_mouse (GameBoardView* self)
{
	GtkGestureMultiPress* _tmp0_;
	GtkGestureMultiPress* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp0_;
	_tmp1_ = self->priv->click_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp1_, (guint) 0);
	_tmp2_ = self->priv->click_controller;
	g_signal_connect_object (_tmp2_, "pressed", (GCallback) _game_board_view_on_click_gtk_gesture_multi_press_pressed, self, 0);
}

static inline void
game_board_view_on_click (GameBoardView* self,
                          GtkGestureMultiPress* _click_controller,
                          gint n_press,
                          gdouble event_x,
                          gdouble event_y)
{
	guint button = 0U;
	gboolean _tmp0_ = FALSE;
	guint8 col = 0U;
	guint8 _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _click_controller);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = button != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = game_board_view_get_column (self, (gint) round (event_x), (gint) round (event_y), &_tmp1_);
	col = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		g_signal_emit (self, game_board_view_signals[GAME_BOARD_VIEW_COLUMN_CLICKED_SIGNAL], 0, col, &_tmp3_);
	}
}

static inline gboolean
game_board_view_get_column (GameBoardView* self,
                            gint x,
                            gint y,
                            guint8* col)
{
	guint8 _vala_col = 0U;
	gint _col = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint row = 0;
	gboolean _tmp6_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_col = (x - self->priv->board_x) / self->priv->tile_size;
	if (x < self->priv->board_x) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = y < self->priv->board_y;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _col < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Board* _tmp3_;
		guint8 _tmp4_;
		guint8 _tmp5_;
		_tmp3_ = self->priv->_game_board;
		_tmp4_ = board_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _col > (_tmp5_ - 1);
	}
	if (_tmp0_) {
		_vala_col = (guint8) 0;
		result = FALSE;
		if (col) {
			*col = _vala_col;
		}
		return result;
	}
	_vala_col = (guint8) _col;
	row = (y - self->priv->board_y) / self->priv->tile_size;
	if (row < 0) {
		_tmp6_ = TRUE;
	} else {
		Board* _tmp7_;
		guint8 _tmp8_;
		guint8 _tmp9_;
		_tmp7_ = self->priv->_game_board;
		_tmp8_ = board_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp6_ = row > (_tmp9_ - 1);
	}
	if (_tmp6_) {
		result = FALSE;
		if (col) {
			*col = _vala_col;
		}
		return result;
	}
	result = TRUE;
	if (col) {
		*col = _vala_col;
	}
	return result;
}

static Board*
game_board_view_get_game_board (GameBoardView* self)
{
	Board* result;
	Board* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_board;
	result = _tmp0_;
	return result;
}

static void
game_board_view_set_game_board (GameBoardView* self,
                                Board* value)
{
	Board* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game_board);
	self->priv->_game_board = _tmp0_;
}

static ThemeManager*
game_board_view_get_theme_manager (GameBoardView* self)
{
	ThemeManager* result;
	ThemeManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_manager;
	result = _tmp0_;
	return result;
}

static void
game_board_view_set_theme_manager (GameBoardView* self,
                                   ThemeManager* value)
{
	ThemeManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_theme_manager);
	self->priv->_theme_manager = _tmp0_;
}

static void
g_cclosure_user_marshal_BOOLEAN__UCHAR (GClosure * closure,
                                        GValue * return_value,
                                        guint n_param_values,
                                        const GValue * param_values,
                                        gpointer invocation_hint,
                                        gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__UCHAR) (gpointer data1, guint8 arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__UCHAR callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__UCHAR) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_uchar (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
_game_board_view_refresh_pixmaps_theme_manager_theme_changed (ThemeManager* _sender,
                                                              gpointer self)
{
	game_board_view_refresh_pixmaps ((GameBoardView*) self);
}

static GObject *
game_board_view_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameBoardView * self;
	ThemeManager* _tmp0_;
	parent_class = G_OBJECT_CLASS (game_board_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_BOARD_VIEW, GameBoardView);
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK);
	_tmp0_ = self->priv->_theme_manager;
	g_signal_connect_object (_tmp0_, "theme-changed", (GCallback) _game_board_view_refresh_pixmaps_theme_manager_theme_changed, self, 0);
	game_board_view_init_mouse (self);
	return obj;
}

static void
game_board_view_class_init (GameBoardViewClass * klass,
                            gpointer klass_data)
{
	game_board_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameBoardView_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) game_board_view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) game_board_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_board_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_board_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_board_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_board_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_BOARD_VIEW_GAME_BOARD_PROPERTY, game_board_view_properties[GAME_BOARD_VIEW_GAME_BOARD_PROPERTY] = g_param_spec_object ("game-board", "game-board", "game-board", TYPE_BOARD, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_BOARD_VIEW_THEME_MANAGER_PROPERTY, game_board_view_properties[GAME_BOARD_VIEW_THEME_MANAGER_PROPERTY] = g_param_spec_object ("theme-manager", "theme-manager", "theme-manager", TYPE_THEME_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	/**
	     * column_clicked:
	     *
	     * emitted when a column on the game board is clicked
	     *
	     * @column:
	     *
	     * Which column was clicked on
	     */
	game_board_view_signals[GAME_BOARD_VIEW_COLUMN_CLICKED_SIGNAL] = g_signal_new ("column-clicked", TYPE_GAME_BOARD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__UCHAR, G_TYPE_BOOLEAN, 1, G_TYPE_UCHAR);
}

static void
game_board_view_instance_init (GameBoardView * self,
                               gpointer klass)
{
	self->priv = game_board_view_get_instance_private (self);
	self->priv->board_size = 0;
	self->priv->tile_size = 0;
}

static void
game_board_view_finalize (GObject * obj)
{
	GameBoardView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_BOARD_VIEW, GameBoardView);
	_g_object_unref0 (self->priv->_game_board);
	_g_object_unref0 (self->priv->_theme_manager);
	_g_object_unref0 (self->priv->pb_tileset);
	_g_object_unref0 (self->priv->pb_bground);
	_g_object_unref0 (self->priv->click_controller);
	G_OBJECT_CLASS (game_board_view_parent_class)->finalize (obj);
}

static GType
game_board_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameBoardViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_board_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameBoardView), 0, (GInstanceInitFunc) game_board_view_instance_init, NULL };
	GType game_board_view_type_id;
	game_board_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameBoardView", &g_define_type_info, 0);
	GameBoardView_private_offset = g_type_add_instance_private (game_board_view_type_id, sizeof (GameBoardViewPrivate));
	return game_board_view_type_id;
}

GType
game_board_view_get_type (void)
{
	static volatile gsize game_board_view_type_id__once = 0;
	if (g_once_init_enter (&game_board_view_type_id__once)) {
		GType game_board_view_type_id;
		game_board_view_type_id = game_board_view_get_type_once ();
		g_once_init_leave (&game_board_view_type_id__once, game_board_view_type_id);
	}
	return game_board_view_type_id__once;
}

static void
_vala_game_board_view_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GameBoardView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_BOARD_VIEW, GameBoardView);
	switch (property_id) {
		case GAME_BOARD_VIEW_GAME_BOARD_PROPERTY:
		g_value_set_object (value, game_board_view_get_game_board (self));
		break;
		case GAME_BOARD_VIEW_THEME_MANAGER_PROPERTY:
		g_value_set_object (value, game_board_view_get_theme_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_board_view_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GameBoardView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_BOARD_VIEW, GameBoardView);
	switch (property_id) {
		case GAME_BOARD_VIEW_GAME_BOARD_PROPERTY:
		game_board_view_set_game_board (self, g_value_get_object (value));
		break;
		case GAME_BOARD_VIEW_THEME_MANAGER_PROPERTY:
		game_board_view_set_theme_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

