/* WebFont.c generated by valac 0.56.18, the Vala compiler
 * generated from WebFont.vala, do not modify */

/* WebFont.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "font-manager.h"
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gstdio.h>

#define FONT_MANAGER_GOOGLE_FONTS_FONT_FACE "\n" \
"    @font-face {\n" \
"        font-family: '%s';\n" \
"        font-style: %s;\n" \
"        font-weight: %i;\n" \
"        src: local('%s'), local('%s'), url(%s) format('truetype');\n" \
"    }\n" \
"    "
#define FONT_MANAGER_GOOGLE_FONTS_GET "GET"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED,
	FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_INSTALLED,
	FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_REQUIRES_UPDATE
} FontManagerGoogleFontsFileStatus;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FILE_STATUS (font_manager_google_fonts_file_status_get_type ())

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY (font_manager_google_fonts_family_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))

typedef struct _FontManagerGoogleFontsFamily FontManagerGoogleFontsFamily;
typedef struct _FontManagerGoogleFontsFamilyClass FontManagerGoogleFontsFamilyClass;
typedef struct _FontManagerGoogleFontsFamilyPrivate FontManagerGoogleFontsFamilyPrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT (font_manager_google_fonts_font_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))

typedef struct _FontManagerGoogleFontsFont FontManagerGoogleFontsFont;
typedef struct _FontManagerGoogleFontsFontClass FontManagerGoogleFontsFontClass;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_INCONSISTENT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_COUNT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block40Data Block40Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block41Data Block41Data;
typedef enum  {
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN = 100,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT = 200,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT = 300,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR = 400,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM = 500,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD = 600,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD = 700,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD = 800,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK = 900
} FontManagerGoogleFontsWeight;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_WEIGHT (font_manager_google_fonts_weight_get_type ())
typedef struct _Block42Data Block42Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block43Data Block43Data;
typedef struct _Block44Data Block44Data;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_CHANGED_SIGNAL,
	FONT_MANAGER_GOOGLE_FONTS_FAMILY_NUM_SIGNALS
};
static guint font_manager_google_fonts_family_signals[FONT_MANAGER_GOOGLE_FONTS_FAMILY_NUM_SIGNALS] = {0};
typedef struct _FontManagerGoogleFontsFontPrivate FontManagerGoogleFontsFontPrivate;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_INCONSISTENT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_STYLE_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_CHANGED_SIGNAL,
	FONT_MANAGER_GOOGLE_FONTS_FONT_NUM_SIGNALS
};
static guint font_manager_google_fonts_font_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerGoogleFontsFamily {
	GObject parent_instance;
	FontManagerGoogleFontsFamilyPrivate * priv;
};

struct _FontManagerGoogleFontsFamilyClass {
	GObjectClass parent_class;
};

struct _FontManagerGoogleFontsFamilyPrivate {
	guint _position;
	gchar* _family;
	gchar* _category;
	GPtrArray* _variants;
	FontManagerStringSet* _subsets;
	gint _version;
};

struct _Block40Data {
	int _ref_count_;
	FontManagerGoogleFontsFamily* self;
	JsonObject* filelist;
};

struct _Block41Data {
	int _ref_count_;
	FontManagerGoogleFontsFamily* self;
	FontManagerGoogleFontsFont* _result_;
};

struct _Block42Data {
	int _ref_count_;
	FontManagerGoogleFontsFamily* self;
	GString* builder;
};

struct _Block43Data {
	int _ref_count_;
	FontManagerGoogleFontsFamily* self;
	gboolean value;
};

struct _Block44Data {
	int _ref_count_;
	Block43Data * _data43_;
	FontManagerGoogleFontsFont* entry;
};

struct _FontManagerGoogleFontsFont {
	GObject parent_instance;
	FontManagerGoogleFontsFontPrivate * priv;
};

struct _FontManagerGoogleFontsFontClass {
	GObjectClass parent_class;
};

struct _FontManagerGoogleFontsFontPrivate {
	guint _position;
	gchar* _family;
	gchar* _url;
	gint _weight;
	gboolean _italic;
	gint _version;
	FontManagerStringSet* _subsets;
};

static gint FontManagerGoogleFontsFamily_private_offset;
static gpointer font_manager_google_fonts_family_parent_class = NULL;
static gint FontManagerGoogleFontsFont_private_offset;
static gpointer font_manager_google_fonts_font_parent_class = NULL;

VALA_EXTERN GType font_manager_google_fonts_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType font_manager_google_fonts_family_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFamily, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_font_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFont, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsFamily* font_manager_google_fonts_family_new (JsonObject* source);
VALA_EXTERN FontManagerGoogleFontsFamily* font_manager_google_fonts_family_construct (GType object_type,
                                                                          JsonObject* source);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
VALA_EXTERN void font_manager_google_fonts_family_set_family (FontManagerGoogleFontsFamily* self,
                                                  const gchar* value);
VALA_EXTERN void font_manager_google_fonts_family_set_category (FontManagerGoogleFontsFamily* self,
                                                    const gchar* value);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void font_manager_google_fonts_family_set_variants (FontManagerGoogleFontsFamily* self,
                                                    GPtrArray* value);
VALA_EXTERN void font_manager_google_fonts_family_set_subsets (FontManagerGoogleFontsFamily* self,
                                                   FontManagerStringSet* value);
static void __lambda167_ (Block40Data* _data40_,
                   JsonArray* array,
                   guint index,
                   JsonNode* node);
VALA_EXTERN const gchar* font_manager_google_fonts_family_get_family (FontManagerGoogleFontsFamily* self);
VALA_EXTERN FontManagerStringSet* font_manager_google_fonts_family_get_subsets (FontManagerGoogleFontsFamily* self);
VALA_EXTERN FontManagerGoogleFontsFont* font_manager_google_fonts_font_new (const gchar* family,
                                                                const gchar* variant,
                                                                const gchar* url,
                                                                FontManagerStringSet* subsets);
VALA_EXTERN FontManagerGoogleFontsFont* font_manager_google_fonts_font_construct (GType object_type,
                                                                      const gchar* family,
                                                                      const gchar* variant,
                                                                      const gchar* url,
                                                                      FontManagerStringSet* subsets);
VALA_EXTERN GPtrArray* font_manager_google_fonts_family_get_variants (FontManagerGoogleFontsFamily* self);
static void __lambda168_ (FontManagerGoogleFontsFamily* self);
static gboolean __lambda169_ (FontManagerGoogleFontsFamily* self);
static gboolean ___lambda169__gsource_func (gpointer self);
static void ___lambda168__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda167__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
static void __lambda170_ (FontManagerGoogleFontsFamily* self,
                   JsonArray* array,
                   guint index,
                   JsonNode* node);
static void ___lambda170__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_url (FontManagerGoogleFontsFont* self);
static void font_manager_google_fonts_family_set_version (FontManagerGoogleFontsFamily* self,
                                                   gint value);
VALA_EXTERN FontManagerGoogleFontsFont* font_manager_google_fonts_family_get_default_variant (FontManagerGoogleFontsFamily* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void __lambda171_ (Block41Data* _data41_,
                   FontManagerGoogleFontsFont* variant);
VALA_EXTERN gboolean font_manager_google_fonts_font_get_italic (FontManagerGoogleFontsFont* self);
VALA_EXTERN gint font_manager_google_fonts_font_get_weight (FontManagerGoogleFontsFont* self);
VALA_EXTERN GType font_manager_google_fonts_weight_get_type (void) G_GNUC_CONST ;
static void ___lambda171__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN gchar* font_manager_google_fonts_family_to_stylesheet (FontManagerGoogleFontsFamily* self);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void __lambda172_ (Block42Data* _data42_,
                   FontManagerGoogleFontsFont* variant);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_font_face_rule (FontManagerGoogleFontsFont* self);
static void ___lambda172__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN FontManagerGoogleFontsFileStatus font_manager_google_fonts_family_get_installation_status (FontManagerGoogleFontsFamily* self);
VALA_EXTERN gboolean font_manager_google_fonts_font_get_active (FontManagerGoogleFontsFont* self);
VALA_EXTERN guint font_manager_google_fonts_family_get_position (FontManagerGoogleFontsFamily* self);
VALA_EXTERN void font_manager_google_fonts_family_set_position (FontManagerGoogleFontsFamily* self,
                                                    guint value);
VALA_EXTERN gboolean font_manager_google_fonts_family_get_inconsistent (FontManagerGoogleFontsFamily* self);
VALA_EXTERN gboolean font_manager_google_fonts_family_get_active (FontManagerGoogleFontsFamily* self);
VALA_EXTERN gint font_manager_google_fonts_family_get_count (FontManagerGoogleFontsFamily* self);
VALA_EXTERN void font_manager_google_fonts_family_set_active (FontManagerGoogleFontsFamily* self,
                                                  gboolean value);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static gboolean _font_manager_google_fonts_family_active_____lambda173_ (Block44Data* _data44_);
VALA_EXTERN void font_manager_google_fonts_font_set_active (FontManagerGoogleFontsFont* self,
                                                gboolean value);
static gboolean __font_manager_google_fonts_family_active_____lambda173__gsource_func (gpointer self);
VALA_EXTERN const gchar* font_manager_google_fonts_family_get_category (FontManagerGoogleFontsFamily* self);
VALA_EXTERN gint font_manager_google_fonts_family_get_version (FontManagerGoogleFontsFamily* self);
static void font_manager_google_fonts_family_finalize (GObject * obj);
static GType font_manager_google_fonts_family_get_type_once (void);
static void _vala_font_manager_google_fonts_family_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_font_manager_google_fonts_family_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
VALA_EXTERN gchar* font_manager_google_fonts_weight_to_string (FontManagerGoogleFontsWeight self);
VALA_EXTERN gchar* font_manager_google_fonts_weight_to_translatable_string (FontManagerGoogleFontsWeight self);
VALA_EXTERN void font_manager_google_fonts_font_set_italic (FontManagerGoogleFontsFont* self,
                                                gboolean value);
VALA_EXTERN void font_manager_google_fonts_font_set_weight (FontManagerGoogleFontsFont* self,
                                                gint value);
static void font_manager_google_fonts_font_set_version (FontManagerGoogleFontsFont* self,
                                                 gint value);
static FontManagerGoogleFontsFileStatus font_manager_google_fonts_font_get_installation_status (FontManagerGoogleFontsFont* self);
static void font_manager_google_fonts_font_set_installation_status (FontManagerGoogleFontsFont* self,
                                                             gboolean install);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_display_name (FontManagerGoogleFontsFont* self);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_description (FontManagerGoogleFontsFont* self);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_family (FontManagerGoogleFontsFont* self);
VALA_EXTERN gchar* font_manager_google_fonts_font_get_filename (FontManagerGoogleFontsFont* self);
VALA_EXTERN gint font_manager_google_fonts_font_get_version (FontManagerGoogleFontsFont* self);
static GFile* font_manager_google_fonts_font_get_outdated_file (FontManagerGoogleFontsFont* self);
VALA_EXTERN gchar* font_manager_google_fonts_get_font_directory (void);
static void font_manager_google_fonts_font_remove_outdated_files (FontManagerGoogleFontsFont* self);
VALA_EXTERN gboolean font_manager_remove_directory_tree_if_empty (GFile* dir);
static void font_manager_google_fonts_font_on_download_complete (FontManagerGoogleFontsFont* self,
                                                          GObject* source,
                                                          GTask* task);
static void font_manager_google_fonts_font_download_file (GTask* task,
                                                   GObject* source,
                                                   void* data,
                                                   GCancellable* cancellable);
static void _font_manager_google_fonts_font_on_download_complete_gasync_ready_callback (GObject* source_object,
                                                                                 GTask* task,
                                                                                 gpointer self);
static void _font_manager_google_fonts_font_download_file_gtask_thread_func (GTask* task,
                                                                      GObject* source_object,
                                                                      void* task_data,
                                                                      GCancellable* cancellable);
VALA_EXTERN guint font_manager_google_fonts_font_get_position (FontManagerGoogleFontsFont* self);
VALA_EXTERN void font_manager_google_fonts_font_set_position (FontManagerGoogleFontsFont* self,
                                                  guint value);
VALA_EXTERN gboolean font_manager_google_fonts_font_get_inconsistent (FontManagerGoogleFontsFont* self);
VALA_EXTERN void font_manager_google_fonts_font_set_family (FontManagerGoogleFontsFont* self,
                                                const gchar* value);
VALA_EXTERN void font_manager_google_fonts_font_set_url (FontManagerGoogleFontsFont* self,
                                             const gchar* value);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_style (FontManagerGoogleFontsFont* self);
VALA_EXTERN FontManagerStringSet* font_manager_google_fonts_font_get_subsets (FontManagerGoogleFontsFont* self);
VALA_EXTERN void font_manager_google_fonts_font_set_subsets (FontManagerGoogleFontsFont* self,
                                                 FontManagerStringSet* value);
static void font_manager_google_fonts_font_finalize (GObject * obj);
static GType font_manager_google_fonts_font_get_type_once (void);
static void _vala_font_manager_google_fonts_font_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_font_manager_google_fonts_font_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_file_status_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED, "FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED", "not-installed"}, {FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_INSTALLED, "FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_INSTALLED", "installed"}, {FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_REQUIRES_UPDATE, "FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_REQUIRES_UPDATE", "requires-update"}, {0, NULL, NULL}};
	GType font_manager_google_fonts_file_status_type_id;
	font_manager_google_fonts_file_status_type_id = g_enum_register_static ("FontManagerGoogleFontsFileStatus", values);
	return font_manager_google_fonts_file_status_type_id;
}

GType
font_manager_google_fonts_file_status_get_type (void)
{
	static volatile gsize font_manager_google_fonts_file_status_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_file_status_type_id__once)) {
		GType font_manager_google_fonts_file_status_type_id;
		font_manager_google_fonts_file_status_type_id = font_manager_google_fonts_file_status_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_file_status_type_id__once, font_manager_google_fonts_file_status_type_id);
	}
	return font_manager_google_fonts_file_status_type_id__once;
}

static inline gpointer
font_manager_google_fonts_family_get_instance_private (FontManagerGoogleFontsFamily* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsFamily_private_offset);
}

static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		FontManagerGoogleFontsFamily* self;
		self = _data40_->self;
		_json_object_unref0 (_data40_->filelist);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda169_ (FontManagerGoogleFontsFamily* self)
{
	gboolean result;
	g_object_notify ((GObject*) self, "active");
	g_object_notify ((GObject*) self, "inconsistent");
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda169__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda169_ ((FontManagerGoogleFontsFamily*) self);
	return result;
}

static void
__lambda168_ (FontManagerGoogleFontsFamily* self)
{
	g_idle_add_full (G_PRIORITY_LOW, ___lambda169__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda168__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda168_ ((FontManagerGoogleFontsFamily*) self);
}

static void
__lambda167_ (Block40Data* _data40_,
              JsonArray* array,
              guint index,
              JsonNode* node)
{
	FontManagerGoogleFontsFamily* self;
	gchar* entry = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FontManagerGoogleFontsFont* variant = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FontManagerStringSet* _tmp4_;
	FontManagerGoogleFontsFont* _tmp5_;
	GPtrArray* _tmp6_;
	FontManagerGoogleFontsFont* _tmp7_;
	self = _data40_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_node_get_string (node);
	_tmp1_ = g_strdup (_tmp0_);
	entry = _tmp1_;
	_tmp2_ = self->priv->_family;
	_tmp3_ = json_object_get_string_member (_data40_->filelist, entry);
	_tmp4_ = self->priv->_subsets;
	_tmp5_ = font_manager_google_fonts_font_new (_tmp2_, entry, _tmp3_, _tmp4_);
	variant = _tmp5_;
	_tmp6_ = self->priv->_variants;
	_tmp7_ = _g_object_ref0 (variant);
	g_ptr_array_insert (_tmp6_, (gint) index, _tmp7_);
	g_signal_connect_object ((GObject*) variant, "notify::active", (GCallback) ___lambda168__g_object_notify, self, 0);
	_g_object_unref0 (variant);
	_g_free0 (entry);
}

static void
___lambda167__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	__lambda167_ (self, array, index_, element_node);
}

static void
__lambda170_ (FontManagerGoogleFontsFamily* self,
              JsonArray* array,
              guint index,
              JsonNode* node)
{
	FontManagerStringSet* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->_subsets;
	_tmp1_ = json_node_get_string (node);
	font_manager_string_set_add (_tmp0_, _tmp1_);
}

static void
___lambda170__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	__lambda170_ ((FontManagerGoogleFontsFamily*) self, array, index_, element_node);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

FontManagerGoogleFontsFamily*
font_manager_google_fonts_family_construct (GType object_type,
                                            JsonObject* source)
{
	FontManagerGoogleFontsFamily * self = NULL;
	Block40Data* _data40_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	FontManagerStringSet* _tmp4_;
	FontManagerStringSet* _tmp5_;
	JsonObject* _tmp6_;
	JsonObject* _tmp7_;
	JsonArray* _tmp8_;
	JsonArray* _tmp9_;
	gchar** _version = NULL;
	GPtrArray* _tmp10_;
	gconstpointer _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _version_length1;
	gint __version_size_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (source != NULL, NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	self = (FontManagerGoogleFontsFamily*) g_object_new (object_type, NULL);
	_data40_->self = g_object_ref (self);
	_tmp0_ = json_object_get_string_member (source, "family");
	font_manager_google_fonts_family_set_family (self, _tmp0_);
	_tmp1_ = json_object_get_string_member (source, "category");
	font_manager_google_fonts_family_set_category (self, _tmp1_);
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	font_manager_google_fonts_family_set_variants (self, _tmp3_);
	_g_ptr_array_unref0 (_tmp3_);
	_tmp4_ = font_manager_string_set_new ();
	_tmp5_ = _tmp4_;
	font_manager_google_fonts_family_set_subsets (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = json_object_get_object_member (source, "files");
	_tmp7_ = _json_object_ref0 (_tmp6_);
	_data40_->filelist = _tmp7_;
	_tmp8_ = json_object_get_array_member (source, "variants");
	json_array_foreach_element (_tmp8_, ___lambda167__json_array_foreach, _data40_);
	_tmp9_ = json_object_get_array_member (source, "subsets");
	json_array_foreach_element (_tmp9_, ___lambda170__json_array_foreach, self);
	_tmp10_ = self->priv->_variants;
	_tmp11_ = g_ptr_array_index (_tmp10_, (guint) 0);
	_tmp12_ = font_manager_google_fonts_font_get_url ((FontManagerGoogleFontsFont*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
	_version = _tmp15_;
	_version_length1 = _vala_array_length (_tmp14_);
	__version_size_ = _version_length1;
	_tmp16_ = _version[_version_length1 - 2];
	_tmp17_ = string_replace (_tmp16_, "v", "");
	_tmp18_ = _tmp17_;
	font_manager_google_fonts_family_set_version (self, atoi (_tmp18_));
	_g_free0 (_tmp18_);
	_version = (_vala_array_free (_version, _version_length1, (GDestroyNotify) g_free), NULL);
	block40_data_unref (_data40_);
	_data40_ = NULL;
	return self;
}

FontManagerGoogleFontsFamily*
font_manager_google_fonts_family_new (JsonObject* source)
{
	return font_manager_google_fonts_family_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, source);
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		FontManagerGoogleFontsFamily* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->_result_);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
__lambda171_ (Block41Data* _data41_,
              FontManagerGoogleFontsFont* variant)
{
	FontManagerGoogleFontsFamily* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = _data41_->self;
	g_return_if_fail (variant != NULL);
	_tmp0_ = font_manager_google_fonts_font_get_italic (variant);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = font_manager_google_fonts_font_get_weight (variant);
	_tmp3_ = _tmp2_;
	if (((FontManagerGoogleFontsWeight) _tmp3_) == FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR) {
		FontManagerGoogleFontsFont* _tmp4_;
		_tmp4_ = _g_object_ref0 (variant);
		_g_object_unref0 (_data41_->_result_);
		_data41_->_result_ = _tmp4_;
	}
}

static void
___lambda171__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda171_ (self, (FontManagerGoogleFontsFont*) data);
}

FontManagerGoogleFontsFont*
font_manager_google_fonts_family_get_default_variant (FontManagerGoogleFontsFamily* self)
{
	Block41Data* _data41_;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	FontManagerGoogleFontsFont* _tmp2_;
	GPtrArray* _tmp3_;
	FontManagerGoogleFontsFont* _tmp4_;
	FontManagerGoogleFontsFont* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = self->priv->_variants;
	_tmp1_ = g_ptr_array_index (_tmp0_, (guint) 0);
	_tmp2_ = _g_object_ref0 ((FontManagerGoogleFontsFont*) _tmp1_);
	_data41_->_result_ = _tmp2_;
	_tmp3_ = self->priv->_variants;
	g_ptr_array_foreach (_tmp3_, ___lambda171__gfunc, _data41_);
	_tmp4_ = _g_object_ref0 (_data41_->_result_);
	result = _tmp4_;
	block41_data_unref (_data41_);
	_data41_ = NULL;
	return result;
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		FontManagerGoogleFontsFamily* self;
		self = _data42_->self;
		_g_string_free0 (_data42_->builder);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
__lambda172_ (Block42Data* _data42_,
              FontManagerGoogleFontsFont* variant)
{
	FontManagerGoogleFontsFamily* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data42_->self;
	g_return_if_fail (variant != NULL);
	_tmp0_ = font_manager_google_fonts_font_to_font_face_rule (variant);
	_tmp1_ = _tmp0_;
	g_string_append (_data42_->builder, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
___lambda172__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda172_ (self, (FontManagerGoogleFontsFont*) data);
}

gchar*
font_manager_google_fonts_family_to_stylesheet (FontManagerGoogleFontsFamily* self)
{
	Block42Data* _data42_;
	GString* _tmp0_;
	GPtrArray* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = g_string_new ("");
	_data42_->builder = _tmp0_;
	_tmp1_ = self->priv->_variants;
	g_ptr_array_foreach (_tmp1_, ___lambda172__gfunc, _data42_);
	_tmp2_ = _data42_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block42_data_unref (_data42_);
	_data42_ = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

FontManagerGoogleFontsFileStatus
font_manager_google_fonts_family_get_installation_status (FontManagerGoogleFontsFamily* self)
{
	FontManagerGoogleFontsFileStatus result;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_variants;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->_variants;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				_tmp7_ = font_manager_google_fonts_font_get_active ((FontManagerGoogleFontsFont*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					result = FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_INSTALLED;
					return result;
				}
			}
		}
	}
	result = FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED;
	return result;
}

guint
font_manager_google_fonts_family_get_position (FontManagerGoogleFontsFamily* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_position;
	return result;
}

void
font_manager_google_fonts_family_set_position (FontManagerGoogleFontsFamily* self,
                                               guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY]);
	}
}

gboolean
font_manager_google_fonts_family_get_inconsistent (FontManagerGoogleFontsFamily* self)
{
	gboolean result;
	gboolean possibly_sensitive = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint installed = 0;
	GPtrArray* _tmp2_;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = font_manager_google_fonts_family_get_active (self);
	_tmp1_ = _tmp0_;
	possibly_sensitive = _tmp1_;
	if (!possibly_sensitive) {
		result = FALSE;
		return result;
	}
	installed = 0;
	_tmp2_ = self->priv->_variants;
	{
		GPtrArray* entry_collection = NULL;
		guint entry_index = 0U;
		entry_collection = _tmp2_;
		for (entry_index = 0; entry_index < entry_collection->len; entry_index = entry_index + 1) {
			FontManagerGoogleFontsFont* _tmp3_;
			FontManagerGoogleFontsFont* entry = NULL;
			_tmp3_ = _g_object_ref0 ((FontManagerGoogleFontsFont*) g_ptr_array_index (entry_collection, entry_index));
			entry = _tmp3_;
			{
				FontManagerGoogleFontsFont* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp4_ = entry;
				_tmp5_ = font_manager_google_fonts_font_get_active (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					gint _tmp7_;
					_tmp7_ = installed;
					installed = _tmp7_ + 1;
				}
				_g_object_unref0 (entry);
			}
		}
	}
	if (possibly_sensitive) {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = font_manager_google_fonts_family_get_count (self);
		_tmp10_ = _tmp9_;
		_tmp8_ = installed < _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	result = _tmp8_;
	return result;
}

gboolean
font_manager_google_fonts_family_get_active (FontManagerGoogleFontsFamily* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = font_manager_google_fonts_family_get_installation_status (self) != FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED;
	return result;
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		FontManagerGoogleFontsFamily* self;
		self = _data43_->self;
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		FontManagerGoogleFontsFamily* self;
		self = _data44_->_data43_->self;
		_g_object_unref0 (_data44_->entry);
		block43_data_unref (_data44_->_data43_);
		_data44_->_data43_ = NULL;
		g_slice_free (Block44Data, _data44_);
	}
}

static gboolean
_font_manager_google_fonts_family_active_____lambda173_ (Block44Data* _data44_)
{
	Block43Data* _data43_;
	FontManagerGoogleFontsFamily* self;
	FontManagerGoogleFontsFont* _tmp0_;
	gboolean result;
	_data43_ = _data44_->_data43_;
	self = _data43_->self;
	_tmp0_ = _data44_->entry;
	font_manager_google_fonts_font_set_active (_tmp0_, _data43_->value);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__font_manager_google_fonts_family_active_____lambda173__gsource_func (gpointer self)
{
	gboolean result;
	result = _font_manager_google_fonts_family_active_____lambda173_ (self);
	return result;
}

void
font_manager_google_fonts_family_set_active (FontManagerGoogleFontsFamily* self,
                                             gboolean value)
{
	Block43Data* _data43_;
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_data43_->value = value;
	_tmp0_ = self->priv->_variants;
	{
		GPtrArray* entry_collection = NULL;
		guint entry_index = 0U;
		entry_collection = _tmp0_;
		for (entry_index = 0; entry_index < entry_collection->len; entry_index = entry_index + 1) {
			FontManagerGoogleFontsFont* _tmp1_;
			FontManagerGoogleFontsFont* entry = NULL;
			_tmp1_ = _g_object_ref0 ((FontManagerGoogleFontsFont*) g_ptr_array_index (entry_collection, entry_index));
			entry = _tmp1_;
			{
				Block44Data* _data44_;
				_data44_ = g_slice_new0 (Block44Data);
				_data44_->_ref_count_ = 1;
				_data44_->_data43_ = block43_data_ref (_data43_);
				_data44_->entry = entry;
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __font_manager_google_fonts_family_active_____lambda173__gsource_func, block44_data_ref (_data44_), block44_data_unref);
				block44_data_unref (_data44_);
				_data44_ = NULL;
			}
		}
	}
	g_object_notify ((GObject*) self, "active");
	block43_data_unref (_data43_);
	_data43_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY]);
}

const gchar*
font_manager_google_fonts_family_get_family (FontManagerGoogleFontsFamily* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_family_set_family (FontManagerGoogleFontsFamily* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_family (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_family);
		self->priv->_family = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY]);
	}
}

const gchar*
font_manager_google_fonts_family_get_category (FontManagerGoogleFontsFamily* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_family_set_category (FontManagerGoogleFontsFamily* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_category (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY]);
	}
}

GPtrArray*
font_manager_google_fonts_family_get_variants (FontManagerGoogleFontsFamily* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variants;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
font_manager_google_fonts_family_set_variants (FontManagerGoogleFontsFamily* self,
                                               GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_variants (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_variants);
		self->priv->_variants = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_google_fonts_family_get_subsets (FontManagerGoogleFontsFamily* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subsets;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_family_set_subsets (FontManagerGoogleFontsFamily* self,
                                              FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_subsets (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_subsets);
		self->priv->_subsets = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY]);
	}
}

gint
font_manager_google_fonts_family_get_count (FontManagerGoogleFontsFamily* self)
{
	gint result;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_variants;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
font_manager_google_fonts_family_get_version (FontManagerGoogleFontsFamily* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_version;
	return result;
}

static void
font_manager_google_fonts_family_set_version (FontManagerGoogleFontsFamily* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_family_get_version (self);
	if (old_value != value) {
		self->priv->_version = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY]);
	}
}

static void
font_manager_google_fonts_family_class_init (FontManagerGoogleFontsFamilyClass * klass,
                                             gpointer klass_data)
{
	font_manager_google_fonts_family_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsFamily_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_family_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_family_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_family_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY] = g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_INCONSISTENT_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_INCONSISTENT_PROPERTY] = g_param_spec_boolean ("inconsistent", "inconsistent", "inconsistent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY] = g_param_spec_string ("family", "family", "family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY] = g_param_spec_string ("category", "category", "category", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY] = g_param_spec_boxed ("variants", "variants", "variants", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY] = g_param_spec_object ("subsets", "subsets", "subsets", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_COUNT_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_COUNT_PROPERTY] = g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY, font_manager_google_fonts_family_properties[FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY] = g_param_spec_int ("version", "version", "version", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	font_manager_google_fonts_family_signals[FONT_MANAGER_GOOGLE_FONTS_FAMILY_CHANGED_SIGNAL] = g_signal_new ("changed", FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
font_manager_google_fonts_family_instance_init (FontManagerGoogleFontsFamily * self,
                                                gpointer klass)
{
	self->priv = font_manager_google_fonts_family_get_instance_private (self);
	self->priv->_position = (guint) 0;
	self->priv->_version = 1;
}

static void
font_manager_google_fonts_family_finalize (GObject * obj)
{
	FontManagerGoogleFontsFamily * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily);
	_g_free0 (self->priv->_family);
	_g_free0 (self->priv->_category);
	_g_ptr_array_unref0 (self->priv->_variants);
	_g_object_unref0 (self->priv->_subsets);
	G_OBJECT_CLASS (font_manager_google_fonts_family_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_family_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsFamilyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_family_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsFamily), 0, (GInstanceInitFunc) font_manager_google_fonts_family_instance_init, NULL };
	GType font_manager_google_fonts_family_type_id;
	font_manager_google_fonts_family_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerGoogleFontsFamily", &g_define_type_info, 0);
	FontManagerGoogleFontsFamily_private_offset = g_type_add_instance_private (font_manager_google_fonts_family_type_id, sizeof (FontManagerGoogleFontsFamilyPrivate));
	return font_manager_google_fonts_family_type_id;
}

GType
font_manager_google_fonts_family_get_type (void)
{
	static volatile gsize font_manager_google_fonts_family_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_family_type_id__once)) {
		GType font_manager_google_fonts_family_type_id;
		font_manager_google_fonts_family_type_id = font_manager_google_fonts_family_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_family_type_id__once, font_manager_google_fonts_family_type_id);
	}
	return font_manager_google_fonts_family_type_id__once;
}

static void
_vala_font_manager_google_fonts_family_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	FontManagerGoogleFontsFamily * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY:
		g_value_set_uint (value, font_manager_google_fonts_family_get_position (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_INCONSISTENT_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_family_get_inconsistent (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_family_get_active (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_family_get_family (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_family_get_category (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_family_get_variants (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_family_get_subsets (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_COUNT_PROPERTY:
		g_value_set_int (value, font_manager_google_fonts_family_get_count (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY:
		g_value_set_int (value, font_manager_google_fonts_family_get_version (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_family_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	FontManagerGoogleFontsFamily * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_POSITION_PROPERTY:
		font_manager_google_fonts_family_set_position (self, g_value_get_uint (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_ACTIVE_PROPERTY:
		font_manager_google_fonts_family_set_active (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_FAMILY_PROPERTY:
		font_manager_google_fonts_family_set_family (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_CATEGORY_PROPERTY:
		font_manager_google_fonts_family_set_category (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_VARIANTS_PROPERTY:
		font_manager_google_fonts_family_set_variants (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_SUBSETS_PROPERTY:
		font_manager_google_fonts_family_set_subsets (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FAMILY_VERSION_PROPERTY:
		font_manager_google_fonts_family_set_version (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
font_manager_google_fonts_weight_to_string (FontManagerGoogleFontsWeight self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Thin");
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ExtraLight");
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Light");
			result = _tmp2_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Regular");
			result = _tmp3_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Medium");
			result = _tmp4_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("SemiBold");
			result = _tmp5_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("Bold");
			result = _tmp6_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("ExtraBold");
			result = _tmp7_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("Black");
			result = _tmp8_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
font_manager_google_fonts_weight_to_translatable_string (FontManagerGoogleFontsWeight self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Thin"));
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("ExtraLight"));
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Light"));
			result = _tmp2_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Regular"));
			result = _tmp3_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Medium"));
			result = _tmp4_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("SemiBold"));
			result = _tmp5_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Bold"));
			result = _tmp6_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("ExtraBold"));
			result = _tmp7_;
			return result;
		}
		case FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Black"));
			result = _tmp8_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_weight_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN", "thin"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT", "extra-light"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT", "light"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR", "regular"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM", "medium"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD", "semi-bold"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD", "bold"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD", "extra-bold"}, {FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK, "FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK", "black"}, {0, NULL, NULL}};
	GType font_manager_google_fonts_weight_type_id;
	font_manager_google_fonts_weight_type_id = g_enum_register_static ("FontManagerGoogleFontsWeight", values);
	return font_manager_google_fonts_weight_type_id;
}

GType
font_manager_google_fonts_weight_get_type (void)
{
	static volatile gsize font_manager_google_fonts_weight_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_weight_type_id__once)) {
		GType font_manager_google_fonts_weight_type_id;
		font_manager_google_fonts_weight_type_id = font_manager_google_fonts_weight_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_weight_type_id__once, font_manager_google_fonts_weight_type_id);
	}
	return font_manager_google_fonts_weight_type_id__once;
}

static inline gpointer
font_manager_google_fonts_font_get_instance_private (FontManagerGoogleFontsFont* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsFont_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

FontManagerGoogleFontsFont*
font_manager_google_fonts_font_construct (GType object_type,
                                          const gchar* family,
                                          const gchar* variant,
                                          const gchar* url,
                                          FontManagerStringSet* subsets)
{
	FontManagerGoogleFontsFont * self = NULL;
	gboolean _tmp0_ = FALSE;
	gchar** _version = NULL;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _version_length1;
	gint __version_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (family != NULL, NULL);
	g_return_val_if_fail (variant != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	g_return_val_if_fail (subsets != NULL, NULL);
	self = (FontManagerGoogleFontsFont*) g_object_new (object_type, "family", family, "url", url, "subsets", subsets, NULL);
	font_manager_google_fonts_font_set_italic (self, string_contains (variant, "italic"));
	if (g_strcmp0 (variant, "regular") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (variant, "italic") == 0;
	}
	if (_tmp0_) {
		font_manager_google_fonts_font_set_weight (self, (gint) FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR);
	} else {
		gchar* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp2_ = self->priv->_italic;
		if (_tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = string_replace (variant, "italic", "");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (variant);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp4_;
		}
		font_manager_google_fonts_font_set_weight (self, atoi (_tmp1_));
		_g_free0 (_tmp1_);
	}
	_tmp6_ = _tmp5_ = g_strsplit (url, "/", 0);
	_version = _tmp6_;
	_version_length1 = _vala_array_length (_tmp5_);
	__version_size_ = _version_length1;
	_tmp7_ = _version;
	_tmp7__length1 = _version_length1;
	_tmp8_ = _version;
	_tmp8__length1 = _version_length1;
	_tmp9_ = _tmp7_[_tmp8__length1 - 2];
	_tmp10_ = string_replace (_tmp9_, "v", "");
	_tmp11_ = _tmp10_;
	font_manager_google_fonts_font_set_version (self, atoi (_tmp11_));
	_g_free0 (_tmp11_);
	if (font_manager_google_fonts_font_get_installation_status (self) == FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_REQUIRES_UPDATE) {
		font_manager_google_fonts_font_set_installation_status (self, TRUE);
	}
	_version = (_vala_array_free (_version, _version_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

FontManagerGoogleFontsFont*
font_manager_google_fonts_font_new (const gchar* family,
                                    const gchar* variant,
                                    const gchar* url,
                                    FontManagerStringSet* subsets)
{
	return font_manager_google_fonts_font_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, family, variant, url, subsets);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
font_manager_google_fonts_font_to_display_name (FontManagerGoogleFontsFont* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* ital = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_italic;
	if (_tmp1_) {
		_tmp0_ = _ ("Italic");
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	ital = _tmp2_;
	_tmp4_ = self->priv->_italic;
	if (_tmp4_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_weight;
		_tmp3_ = _tmp5_ == ((gint) FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = ital;
		return result;
	}
	_tmp6_ = self->priv->_weight;
	_tmp7_ = font_manager_google_fonts_weight_to_translatable_string ((FontManagerGoogleFontsWeight) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = ital;
	_tmp10_ = g_strdup_printf ("%s %s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_strip (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	result = _tmp13_;
	_g_free0 (ital);
	return result;
}

gchar*
font_manager_google_fonts_font_to_description (FontManagerGoogleFontsFont* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* ital = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_italic;
	if (_tmp1_) {
		_tmp0_ = "Italic";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	ital = _tmp2_;
	_tmp4_ = self->priv->_italic;
	if (_tmp4_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_weight;
		_tmp3_ = ((FontManagerGoogleFontsWeight) _tmp5_) == FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = ital;
		return result;
	}
	_tmp6_ = self->priv->_weight;
	_tmp7_ = font_manager_google_fonts_weight_to_string ((FontManagerGoogleFontsWeight) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = ital;
	_tmp10_ = g_strdup_printf ("%s %s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_strip (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	result = _tmp13_;
	_g_free0 (ital);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
font_manager_google_fonts_font_to_font_face_rule (FontManagerGoogleFontsFont* self)
{
	gchar* description = NULL;
	gchar* _tmp0_;
	gchar* local = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _local = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_;
	gchar* style = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = font_manager_google_fonts_font_to_description (self);
	description = _tmp0_;
	_tmp1_ = self->priv->_family;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = description;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp2_, " ", _tmp4_, NULL);
	local = _tmp5_;
	_tmp6_ = self->priv->_family;
	_tmp7_ = string_replace (_tmp6_, " ", "");
	_tmp8_ = _tmp7_;
	_tmp9_ = description;
	_tmp10_ = string_replace (_tmp9_, " ", "");
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s-%s", _tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_local = _tmp13_;
	_tmp15_ = self->priv->_italic;
	if (_tmp15_) {
		_tmp14_ = "italic";
	} else {
		_tmp14_ = "normal";
	}
	_tmp16_ = g_strdup (_tmp14_);
	style = _tmp16_;
	_tmp17_ = self->priv->_family;
	_tmp18_ = self->priv->_weight;
	_tmp19_ = local;
	_tmp20_ = _local;
	_tmp21_ = self->priv->_url;
	_tmp22_ = g_strdup_printf (FONT_MANAGER_GOOGLE_FONTS_FONT_FACE, _tmp17_, style, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
	result = _tmp22_;
	_g_free0 (style);
	_g_free0 (_local);
	_g_free0 (local);
	_g_free0 (description);
	return result;
}

gchar*
font_manager_google_fonts_font_get_filename (FontManagerGoogleFontsFont* self)
{
	gchar* ext = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* style = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* family = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	_tmp1_ = font_manager_get_file_extension (_tmp0_);
	ext = _tmp1_;
	_tmp2_ = font_manager_google_fonts_font_to_description (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, " ", "_");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	style = _tmp5_;
	_tmp6_ = self->priv->_family;
	_tmp7_ = string_replace (_tmp6_, " ", "_");
	family = _tmp7_;
	_tmp8_ = self->priv->_version;
	_tmp9_ = g_strdup_printf ("%s_%s.%i.%s", family, style, _tmp8_, ext);
	result = _tmp9_;
	_g_free0 (family);
	_g_free0 (style);
	_g_free0 (ext);
	return result;
}

static GFile*
font_manager_google_fonts_font_get_outdated_file (FontManagerGoogleFontsFont* self)
{
	GFile* font_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* ext = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* style = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* family = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* filename = NULL;
	gint _tmp15_;
	gchar* _tmp16_;
	GFile* outdated = NULL;
	GFile* _tmp17_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = font_manager_google_fonts_get_font_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_family;
	_tmp3_ = g_build_filename (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	font_dir = _tmp6_;
	_tmp7_ = self->priv->_url;
	_tmp8_ = font_manager_get_file_extension (_tmp7_);
	ext = _tmp8_;
	_tmp9_ = font_manager_google_fonts_font_to_description (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_replace (_tmp10_, " ", "_");
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	style = _tmp12_;
	_tmp13_ = self->priv->_family;
	_tmp14_ = string_replace (_tmp13_, " ", "_");
	family = _tmp14_;
	_tmp15_ = self->priv->_version;
	_tmp16_ = g_strdup_printf ("%s_%s.%i.%s", family, style, _tmp15_ - 1, ext);
	filename = _tmp16_;
	_tmp17_ = g_file_get_child (font_dir, filename);
	outdated = _tmp17_;
	result = outdated;
	_g_free0 (filename);
	_g_free0 (family);
	_g_free0 (style);
	_g_free0 (ext);
	_g_object_unref0 (font_dir);
	return result;
}

static FontManagerGoogleFontsFileStatus
font_manager_google_fonts_font_get_installation_status (FontManagerGoogleFontsFont* self)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* filepath = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* font = NULL;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* font_dir = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	FontManagerGoogleFontsFileStatus result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = font_manager_google_fonts_get_font_directory ();
	dir = _tmp0_;
	_tmp1_ = dir;
	_tmp2_ = self->priv->_family;
	_tmp3_ = font_manager_google_fonts_font_get_filename (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp1_, _tmp2_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	filepath = _tmp6_;
	_tmp7_ = filepath;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	font = _tmp8_;
	_tmp9_ = font;
	if (g_file_query_exists (_tmp9_, NULL)) {
		result = FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_INSTALLED;
		_g_object_unref0 (font);
		_g_free0 (filepath);
		_g_free0 (dir);
		return result;
	}
	_tmp10_ = dir;
	_tmp11_ = self->priv->_family;
	_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_new_for_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	font_dir = _tmp15_;
	_tmp16_ = font_dir;
	if (g_file_query_exists (_tmp16_, NULL)) {
		GFile* outdated = NULL;
		GFile* _tmp17_;
		GFile* _tmp18_;
		_tmp17_ = font_manager_google_fonts_font_get_outdated_file (self);
		outdated = _tmp17_;
		_tmp18_ = outdated;
		if (g_file_query_exists (_tmp18_, NULL)) {
			result = FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_REQUIRES_UPDATE;
			_g_object_unref0 (outdated);
			_g_object_unref0 (font_dir);
			_g_object_unref0 (font);
			_g_free0 (filepath);
			_g_free0 (dir);
			return result;
		}
		_g_object_unref0 (outdated);
	}
	result = FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED;
	_g_object_unref0 (font_dir);
	_g_object_unref0 (font);
	_g_free0 (filepath);
	_g_free0 (dir);
	return result;
}

static void
font_manager_google_fonts_font_remove_outdated_files (FontManagerGoogleFontsFont* self)
{
	GFile* outdated_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_google_fonts_font_get_outdated_file (self);
	outdated_file = _tmp0_;
	_tmp1_ = outdated_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		_g_object_unref0 (outdated_file);
		return;
	}
	{
		GFile* _tmp2_;
		gchar* font_dir = NULL;
		gchar* _tmp3_;
		gchar* target_dir = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		GFile* outdated_dir = NULL;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp2_ = outdated_file;
		g_file_delete (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = font_manager_google_fonts_get_font_directory ();
		font_dir = _tmp3_;
		_tmp4_ = font_dir;
		_tmp5_ = self->priv->_family;
		_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
		target_dir = _tmp6_;
		_tmp7_ = target_dir;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		outdated_dir = _tmp8_;
		_tmp9_ = outdated_dir;
		font_manager_remove_directory_tree_if_empty (_tmp9_);
		_g_object_unref0 (outdated_dir);
		_g_free0 (target_dir);
		_g_free0 (font_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* path = NULL;
		GFile* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		g_clear_error (&_inner_error0_);
		_tmp10_ = outdated_file;
		_tmp11_ = g_file_get_path (_tmp10_);
		path = _tmp11_;
		_tmp12_ = path;
		g_warning ("WebFont.vala:299: Failed to remove outdated font file : %s", _tmp12_);
		_g_free0 (path);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (outdated_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (outdated_file);
	return;
}

static void
font_manager_google_fonts_font_on_download_complete (FontManagerGoogleFontsFont* self,
                                                     GObject* source,
                                                     GTask* task)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_task_propagate_boolean (task, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			font_manager_google_fonts_font_remove_outdated_files (self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("WebFont.vala:309: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify ((GObject*) self, "active");
	return;
}

static void
font_manager_google_fonts_font_download_file (GTask* task,
                                              GObject* source,
                                              void* data,
                                              GCancellable* cancellable)
{
	FontManagerGoogleFontsFont* font = NULL;
	FontManagerGoogleFontsFont* _tmp0_;
	SoupSession* session = NULL;
	SoupSession* _tmp1_;
	gchar* font_dir = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FontManagerGoogleFontsFont* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* filename = NULL;
	FontManagerGoogleFontsFont* _tmp10_;
	gchar* _tmp11_;
	gchar* filepath = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	SoupMessage* message = NULL;
	FontManagerGoogleFontsFont* _tmp15_;
	const gchar* _tmp16_;
	SoupMessage* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	g_return_if_fail (source != NULL);
	_vala_assert (FONT_MANAGER_GOOGLE_FONTS_IS_FONT (source), "source is Font");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont));
	font = _tmp0_;
	_tmp1_ = soup_session_new ();
	session = _tmp1_;
	_tmp2_ = font_manager_google_fonts_get_font_directory ();
	_tmp3_ = _tmp2_;
	_tmp4_ = font;
	_tmp5_ = _tmp4_->priv->_family;
	_tmp6_ = g_build_filename (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	font_dir = _tmp7_;
	_tmp8_ = font_dir;
	if (g_mkdir_with_parents (_tmp8_, 0755) != 0) {
		const gchar* _tmp9_;
		_tmp9_ = font_dir;
		g_warning ("WebFont.vala:321: Failed to create directory : %s", _tmp9_);
		g_task_return_boolean (task, FALSE);
		_g_free0 (font_dir);
		_g_object_unref0 (session);
		_g_object_unref0 (font);
		return;
	}
	_tmp10_ = font;
	_tmp11_ = font_manager_google_fonts_font_get_filename (_tmp10_);
	filename = _tmp11_;
	_tmp12_ = font_dir;
	_tmp13_ = filename;
	_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
	filepath = _tmp14_;
	_tmp15_ = font;
	_tmp16_ = _tmp15_->priv->_url;
	_tmp17_ = soup_message_new (FONT_MANAGER_GOOGLE_FONTS_GET, _tmp16_);
	message = _tmp17_;
	{
		GBytes* bytes = NULL;
		SoupSession* _tmp18_;
		SoupMessage* _tmp19_;
		GBytes* _tmp20_;
		GBytes* _tmp21_;
		GBytes* _tmp22_;
		GFile* font_file = NULL;
		const gchar* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp27_;
		GFileOutputStream* _tmp28_;
		_tmp18_ = session;
		_tmp19_ = message;
		_tmp20_ = soup_session_send_and_read (_tmp18_, _tmp19_, NULL, &_inner_error0_);
		bytes = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp21_ = bytes;
		if (_tmp21_ == NULL) {
			g_task_return_boolean (task, FALSE);
		}
		_tmp22_ = bytes;
		g_return_if_fail (_tmp22_ != NULL);
		_tmp23_ = filepath;
		_tmp24_ = g_file_new_for_path (_tmp23_);
		font_file = _tmp24_;
		_tmp25_ = font_file;
		if (g_file_query_exists (_tmp25_, NULL)) {
			GFile* _tmp26_;
			_tmp26_ = font_file;
			g_file_delete (_tmp26_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (font_file);
				_g_bytes_unref0 (bytes);
				goto __catch0_g_error;
			}
		}
		_tmp27_ = font_file;
		_tmp28_ = g_file_create (_tmp27_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		stream = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (font_file);
			_g_bytes_unref0 (bytes);
			goto __catch0_g_error;
		}
		{
			GFileOutputStream* _tmp29_;
			GBytes* _tmp30_;
			GFileOutputStream* _tmp31_;
			_tmp29_ = stream;
			_tmp30_ = bytes;
			g_output_stream_write_bytes ((GOutputStream*) _tmp29_, _tmp30_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp31_ = stream;
			g_output_stream_close ((GOutputStream*) _tmp31_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp32_;
			GError* _tmp33_;
			const gchar* _tmp34_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			g_task_return_boolean (task, FALSE);
			_tmp32_ = filepath;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_warning ("WebFont.vala:343: Failed to write data to file : %s : %s", _tmp32_, _tmp34_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (font_file);
			_g_bytes_unref0 (bytes);
			goto __catch0_g_error;
		}
		_g_object_unref0 (stream);
		_g_object_unref0 (font_file);
		_g_bytes_unref0 (bytes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp35_;
		SoupMessage* _tmp36_;
		guint _tmp37_;
		guint _tmp38_;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_task_return_boolean (task, FALSE);
		_tmp35_ = filename;
		_tmp36_ = message;
		g_object_get (_tmp36_, "status-code", &_tmp37_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("WebFont.vala:347: Failed to read data for : %s :: %i :: %s", _tmp35_, (gint) _tmp38_, _tmp40_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (message);
		_g_free0 (filepath);
		_g_free0 (filename);
		_g_free0 (font_dir);
		_g_object_unref0 (session);
		_g_object_unref0 (font);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_task_return_boolean (task, TRUE);
	_g_object_unref0 (message);
	_g_free0 (filepath);
	_g_free0 (filename);
	_g_free0 (font_dir);
	_g_object_unref0 (session);
	_g_object_unref0 (font);
	return;
}

static void
_font_manager_google_fonts_font_on_download_complete_gasync_ready_callback (GObject* source_object,
                                                                            GTask* task,
                                                                            gpointer self)
{
	font_manager_google_fonts_font_on_download_complete ((FontManagerGoogleFontsFont*) self, source_object, task);
	g_object_unref (self);
}

static void
_font_manager_google_fonts_font_download_file_gtask_thread_func (GTask* task,
                                                                 GObject* source_object,
                                                                 void* task_data,
                                                                 GCancellable* cancellable)
{
	font_manager_google_fonts_font_download_file (task, source_object, task_data, cancellable);
}

static void
font_manager_google_fonts_font_set_installation_status (FontManagerGoogleFontsFont* self,
                                                        gboolean install)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (install) {
		GTask* task = NULL;
		GTask* _tmp0_;
		GTask* _tmp1_;
		_tmp0_ = g_task_new ((GObject*) self, NULL, _font_manager_google_fonts_font_on_download_complete_gasync_ready_callback, g_object_ref (self));
		task = _tmp0_;
		_tmp1_ = task;
		g_task_run_in_thread (_tmp1_, _font_manager_google_fonts_font_download_file_gtask_thread_func);
		_g_object_unref0 (task);
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = font_manager_google_fonts_font_get_active (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			gchar* font_dir = NULL;
			gchar* _tmp4_;
			gchar* file_name = NULL;
			gchar* _tmp5_;
			gchar* target_dir = NULL;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* target_file = NULL;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			GFile* dir = NULL;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* file = NULL;
			const gchar* _tmp14_;
			GFile* _tmp15_;
			_tmp4_ = font_manager_google_fonts_get_font_directory ();
			font_dir = _tmp4_;
			_tmp5_ = font_manager_google_fonts_font_get_filename (self);
			file_name = _tmp5_;
			_tmp6_ = font_dir;
			_tmp7_ = self->priv->_family;
			_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
			target_dir = _tmp8_;
			_tmp9_ = target_dir;
			_tmp10_ = file_name;
			_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
			target_file = _tmp11_;
			_tmp12_ = target_dir;
			_tmp13_ = g_file_new_for_path (_tmp12_);
			dir = _tmp13_;
			_tmp14_ = target_file;
			_tmp15_ = g_file_new_for_path (_tmp14_);
			file = _tmp15_;
			{
				gboolean _tmp16_ = FALSE;
				GFile* _tmp17_;
				_tmp17_ = file;
				_tmp16_ = g_file_delete (_tmp17_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (_tmp16_) {
					GFile* _tmp18_;
					_tmp18_ = dir;
					font_manager_remove_directory_tree_if_empty (_tmp18_);
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp19_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp19_ = e;
				if (_tmp19_->code != G_FILE_ERROR_NOENT) {
					GError* _tmp20_;
					const gchar* _tmp21_;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					g_warning ("WebFont.vala:372: %s", _tmp21_);
				}
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (dir);
				_g_free0 (target_file);
				_g_free0 (target_dir);
				_g_free0 (file_name);
				_g_free0 (font_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
			_g_object_unref0 (dir);
			_g_free0 (target_file);
			_g_free0 (target_dir);
			_g_free0 (file_name);
			_g_free0 (font_dir);
		}
	}
	return;
}

guint
font_manager_google_fonts_font_get_position (FontManagerGoogleFontsFont* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_position;
	return result;
}

void
font_manager_google_fonts_font_set_position (FontManagerGoogleFontsFont* self,
                                             guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY]);
	}
}

gboolean
font_manager_google_fonts_font_get_inconsistent (FontManagerGoogleFontsFont* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
font_manager_google_fonts_font_get_active (FontManagerGoogleFontsFont* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = font_manager_google_fonts_font_get_installation_status (self) != FONT_MANAGER_GOOGLE_FONTS_FILE_STATUS_NOT_INSTALLED;
	return result;
}

void
font_manager_google_fonts_font_set_active (FontManagerGoogleFontsFont* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	font_manager_google_fonts_font_set_installation_status (self, value);
	g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY]);
}

const gchar*
font_manager_google_fonts_font_get_family (FontManagerGoogleFontsFont* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_set_family (FontManagerGoogleFontsFont* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_family (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_family);
		self->priv->_family = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY]);
	}
}

const gchar*
font_manager_google_fonts_font_get_url (FontManagerGoogleFontsFont* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_set_url (FontManagerGoogleFontsFont* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY]);
	}
}

gint
font_manager_google_fonts_font_get_weight (FontManagerGoogleFontsFont* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_weight;
	return result;
}

void
font_manager_google_fonts_font_set_weight (FontManagerGoogleFontsFont* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_weight (self);
	if (old_value != value) {
		self->priv->_weight = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY]);
	}
}

gboolean
font_manager_google_fonts_font_get_italic (FontManagerGoogleFontsFont* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_italic;
	return result;
}

void
font_manager_google_fonts_font_set_italic (FontManagerGoogleFontsFont* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_italic (self);
	if (old_value != value) {
		self->priv->_italic = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY]);
	}
}

const gchar*
font_manager_google_fonts_font_get_style (FontManagerGoogleFontsFont* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_italic;
	if (_tmp1_) {
		_tmp0_ = "italic";
	} else {
		_tmp0_ = "normal";
	}
	result = _tmp0_;
	return result;
}

gint
font_manager_google_fonts_font_get_version (FontManagerGoogleFontsFont* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_version;
	return result;
}

static void
font_manager_google_fonts_font_set_version (FontManagerGoogleFontsFont* self,
                                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_version (self);
	if (old_value != value) {
		self->priv->_version = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_google_fonts_font_get_subsets (FontManagerGoogleFontsFont* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subsets;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_set_subsets (FontManagerGoogleFontsFont* self,
                                            FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_get_subsets (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_subsets);
		self->priv->_subsets = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY]);
	}
}

static void
font_manager_google_fonts_font_class_init (FontManagerGoogleFontsFontClass * klass,
                                           gpointer klass_data)
{
	font_manager_google_fonts_font_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsFont_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_font_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_font_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_font_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY] = g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_INCONSISTENT_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_INCONSISTENT_PROPERTY] = g_param_spec_boolean ("inconsistent", "inconsistent", "inconsistent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY] = g_param_spec_string ("family", "family", "family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY] = g_param_spec_int ("weight", "weight", "weight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY] = g_param_spec_boolean ("italic", "italic", "italic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_STYLE_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_STYLE_PROPERTY] = g_param_spec_string ("style", "style", "style", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY] = g_param_spec_int ("version", "version", "version", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY, font_manager_google_fonts_font_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY] = g_param_spec_object ("subsets", "subsets", "subsets", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	font_manager_google_fonts_font_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_CHANGED_SIGNAL] = g_signal_new ("changed", FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
font_manager_google_fonts_font_instance_init (FontManagerGoogleFontsFont * self,
                                              gpointer klass)
{
	self->priv = font_manager_google_fonts_font_get_instance_private (self);
	self->priv->_position = (guint) 0;
	self->priv->_version = 1;
}

static void
font_manager_google_fonts_font_finalize (GObject * obj)
{
	FontManagerGoogleFontsFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont);
	_g_free0 (self->priv->_family);
	_g_free0 (self->priv->_url);
	_g_object_unref0 (self->priv->_subsets);
	G_OBJECT_CLASS (font_manager_google_fonts_font_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_font_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsFontClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_font_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsFont), 0, (GInstanceInitFunc) font_manager_google_fonts_font_instance_init, NULL };
	GType font_manager_google_fonts_font_type_id;
	font_manager_google_fonts_font_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerGoogleFontsFont", &g_define_type_info, 0);
	FontManagerGoogleFontsFont_private_offset = g_type_add_instance_private (font_manager_google_fonts_font_type_id, sizeof (FontManagerGoogleFontsFontPrivate));
	return font_manager_google_fonts_font_type_id;
}

GType
font_manager_google_fonts_font_get_type (void)
{
	static volatile gsize font_manager_google_fonts_font_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_font_type_id__once)) {
		GType font_manager_google_fonts_font_type_id;
		font_manager_google_fonts_font_type_id = font_manager_google_fonts_font_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_font_type_id__once, font_manager_google_fonts_font_type_id);
	}
	return font_manager_google_fonts_font_type_id__once;
}

static void
_vala_font_manager_google_fonts_font_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerGoogleFontsFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY:
		g_value_set_uint (value, font_manager_google_fonts_font_get_position (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_INCONSISTENT_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_font_get_inconsistent (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_font_get_active (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_font_get_family (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_font_get_url (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY:
		g_value_set_int (value, font_manager_google_fonts_font_get_weight (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY:
		g_value_set_boolean (value, font_manager_google_fonts_font_get_italic (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_STYLE_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_font_get_style (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY:
		g_value_set_int (value, font_manager_google_fonts_font_get_version (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_font_get_subsets (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_font_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerGoogleFontsFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_POSITION_PROPERTY:
		font_manager_google_fonts_font_set_position (self, g_value_get_uint (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_ACTIVE_PROPERTY:
		font_manager_google_fonts_font_set_active (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_FAMILY_PROPERTY:
		font_manager_google_fonts_font_set_family (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_URL_PROPERTY:
		font_manager_google_fonts_font_set_url (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_WEIGHT_PROPERTY:
		font_manager_google_fonts_font_set_weight (self, g_value_get_int (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_ITALIC_PROPERTY:
		font_manager_google_fonts_font_set_italic (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_VERSION_PROPERTY:
		font_manager_google_fonts_font_set_version (self, g_value_get_int (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_SUBSETS_PROPERTY:
		font_manager_google_fonts_font_set_subsets (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

