/* GoogleFonts.c generated by valac 0.56.18, the Vala compiler
 * generated from GoogleFonts.vala, do not modify */

/* GoogleFonts.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "font-manager.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include "vala-common.h"
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define FONT_MANAGER_GOOGLE_FONTS_API_KEY "QUl6YVN5QTlpUmZqMFlYc184RGhJR1Q1YzNGRDBWNmtSQWV5cFA4"
#define FONT_MANAGER_GOOGLE_FONTS_GET "GET"
#define FONT_MANAGER_GOOGLE_FONTS_GOOGLE_FONTS_API "https://www.googleapis.com/webfonts/v1/webfonts?key=%s&sort=%s"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_DUAL_PANED (font_manager_dual_paned_get_type ())
#define FONT_MANAGER_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned))
#define FONT_MANAGER_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))
#define FONT_MANAGER_IS_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_IS_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_DUAL_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))

typedef struct _FontManagerDualPaned FontManagerDualPaned;
typedef struct _FontManagerDualPanedClass FontManagerDualPanedClass;
typedef struct _FontManagerDualPanedPrivate FontManagerDualPanedPrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG (font_manager_google_fonts_catalog_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalog))
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalogClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG))
#define FONT_MANAGER_GOOGLE_FONTS_IS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG))
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalogClass))

typedef struct _FontManagerGoogleFontsCatalog FontManagerGoogleFontsCatalog;
typedef struct _FontManagerGoogleFontsCatalogClass FontManagerGoogleFontsCatalogClass;
typedef struct _FontManagerGoogleFontsCatalogPrivate FontManagerGoogleFontsCatalogPrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE (font_manager_google_fonts_preview_page_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPage))
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPageClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_PREVIEW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE))
#define FONT_MANAGER_GOOGLE_FONTS_IS_PREVIEW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE))
#define FONT_MANAGER_GOOGLE_FONTS_PREVIEW_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_PREVIEW_PAGE, FontManagerGoogleFontsPreviewPageClass))

typedef struct _FontManagerGoogleFontsPreviewPage FontManagerGoogleFontsPreviewPage;
typedef struct _FontManagerGoogleFontsPreviewPageClass FontManagerGoogleFontsPreviewPageClass;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW (font_manager_google_fonts_font_list_view_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListViewClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListViewClass))

typedef struct _FontManagerGoogleFontsFontListView FontManagerGoogleFontsFontListView;
typedef struct _FontManagerGoogleFontsFontListViewClass FontManagerGoogleFontsFontListViewClass;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_CATALOG_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_CATALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_catalog_properties[FONT_MANAGER_GOOGLE_FONTS_CATALOG_NUM_PROPERTIES];
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR (font_manager_google_fonts_sidebar_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR, FontManagerGoogleFontsSidebar))
#define FONT_MANAGER_GOOGLE_FONTS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR, FontManagerGoogleFontsSidebarClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR))
#define FONT_MANAGER_GOOGLE_FONTS_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR))
#define FONT_MANAGER_GOOGLE_FONTS_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_SIDEBAR, FontManagerGoogleFontsSidebarClass))

typedef struct _FontManagerGoogleFontsSidebar FontManagerGoogleFontsSidebar;
typedef struct _FontManagerGoogleFontsSidebarClass FontManagerGoogleFontsSidebarClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block38Data Block38Data;
typedef struct _Block39Data Block39Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _FontManagerGoogleFontsCatalogUpdateCacheData FontManagerGoogleFontsCatalogUpdateCacheData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerDualPaned {
	GtkWidget parent_instance;
	FontManagerDualPanedPrivate * priv;
	GtkOverlay* overlay;
};

struct _FontManagerDualPanedClass {
	GtkWidgetClass parent_class;
	void (*on_map) (FontManagerDualPaned* self);
};

struct _FontManagerGoogleFontsCatalog {
	FontManagerDualPaned parent_instance;
	FontManagerGoogleFontsCatalogPrivate * priv;
};

struct _FontManagerGoogleFontsCatalogClass {
	FontManagerDualPanedClass parent_class;
};

struct _FontManagerGoogleFontsCatalogPrivate {
	JsonArray* _available_families;
	FontManagerWaterfallSettings* _waterfall_settings;
	gboolean initialized;
	guint status_code;
	gchar* reason_phrase;
	GError* error;
	GNetworkMonitor* network_monitor;
	FontManagerPlaceHolder* placeholder;
	FontManagerGoogleFontsPreviewPage* preview;
	FontManagerGoogleFontsFontListView* fontlist;
};

struct _Block38Data {
	int _ref_count_;
	FontManagerGoogleFontsCatalog* self;
	gchar* filename;
};

struct _Block39Data {
	int _ref_count_;
	Block38Data * _data38_;
	GFileOutputStream* stream;
};

struct _FontManagerGoogleFontsCatalogUpdateCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FontManagerGoogleFontsCatalog* self;
	gboolean result;
	SoupSession* session;
	SoupSession* _tmp0_;
	gchar* GFC_API_KEY;
	gsize _tmp1_;
	guchar* _tmp2_;
	const gchar** entry_collection;
	gint entry_collection_length1;
	gint _entry_collection_size_;
	gint entry_it;
	const gchar* entry;
	Block38Data* _data38_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	SoupMessage* message;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	SoupMessage* _tmp11_;
	SoupMessage* _tmp12_;
	Block39Data* _data39_;
	GBytes* bytes;
	SoupSession* _tmp13_;
	SoupMessage* _tmp14_;
	GBytes* _tmp15_;
	GBytes* _tmp16_;
	gchar* filepath;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* cache_file;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFileOutputStream* _tmp27_;
	GFileOutputStream* _tmp28_;
	GBytes* _tmp29_;
	GError* e;
	const gchar* _tmp30_;
	GError* _tmp31_;
	GError* _tmp32_;
	const gchar* _tmp33_;
	SoupMessage* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	SoupMessage* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GError* _tmp41_;
	SoupMessage* _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	SoupMessage* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	GError* _inner_error0_;
};

static gint FontManagerGoogleFontsCatalog_private_offset;
static gpointer font_manager_google_fonts_catalog_parent_class = NULL;

VALA_EXTERN gchar* font_manager_google_fonts_get_font_directory (void);
VALA_EXTERN GType font_manager_dual_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDualPaned, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_catalog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsCatalog, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_preview_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsPreviewPage, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_font_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFontListView, g_object_unref)
VALA_EXTERN void font_manager_dual_paned_on_map (FontManagerDualPaned* self);
VALA_EXTERN FontManagerGoogleFontsCatalog* font_manager_google_fonts_catalog_new (GSettings* settings);
VALA_EXTERN FontManagerGoogleFontsCatalog* font_manager_google_fonts_catalog_construct (GType object_type,
                                                                            GSettings* settings);
VALA_EXTERN FontManagerDualPaned* font_manager_dual_paned_new (GSettings* settings);
VALA_EXTERN FontManagerDualPaned* font_manager_dual_paned_construct (GType object_type,
                                                         GSettings* settings);
static void font_manager_google_fonts_catalog_real_on_map (FontManagerDualPaned* base);
VALA_EXTERN GType font_manager_google_fonts_sidebar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsSidebar, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsSidebar* font_manager_google_fonts_sidebar_new (void);
VALA_EXTERN FontManagerGoogleFontsSidebar* font_manager_google_fonts_sidebar_construct (GType object_type);
VALA_EXTERN FontManagerGoogleFontsFontListView* font_manager_google_fonts_font_list_view_new (void);
VALA_EXTERN FontManagerGoogleFontsFontListView* font_manager_google_fonts_font_list_view_construct (GType object_type);
VALA_EXTERN FontManagerGoogleFontsPreviewPage* font_manager_google_fonts_preview_page_new (void);
VALA_EXTERN FontManagerGoogleFontsPreviewPage* font_manager_google_fonts_preview_page_construct (GType object_type);
VALA_EXTERN void font_manager_dual_paned_set_sidebar_widget (FontManagerDualPaned* self,
                                                 GtkWidget* widget);
VALA_EXTERN void font_manager_dual_paned_set_list_widget (FontManagerDualPaned* self,
                                              GtkWidget* widget);
VALA_EXTERN void font_manager_dual_paned_set_content_widget (FontManagerDualPaned* self,
                                                 GtkWidget* widget);
static void font_manager_google_fonts_catalog_on_network_changed (FontManagerGoogleFontsCatalog* self);
static void _font_manager_google_fonts_catalog_on_network_changed_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                                                              gboolean network_available,
                                                                                              gpointer self);
static void font_manager_google_fonts_catalog_on_sort_changed (FontManagerGoogleFontsCatalog* self,
                                                        const gchar* order);
static void _font_manager_google_fonts_catalog_on_sort_changed_font_manager_google_fonts_sidebar_sort_changed (FontManagerGoogleFontsSidebar* _sender,
                                                                                                        const gchar* order,
                                                                                                        gpointer self);
static gboolean font_manager_google_fonts_catalog_network_available (FontManagerGoogleFontsCatalog* self);
static void font_manager_google_fonts_catalog_update_placeholder (FontManagerGoogleFontsCatalog* self);
VALA_EXTERN void font_manager_google_fonts_preview_page_restore_state (FontManagerGoogleFontsPreviewPage* self,
                                                           GSettings* settings);
VALA_EXTERN GSettings* font_manager_dual_paned_get_settings (FontManagerDualPaned* self);
static void font_manager_google_fonts_catalog_focus_search_entry (FontManagerGoogleFontsCatalog* self,
                                                           GtkWidget* widget,
                                                           const gchar* action,
                                                           GVariant* parameter);
VALA_EXTERN void font_manager_google_fonts_font_list_view_focus_search_entry (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN void font_manager_google_fonts_catalog_select_first_font (FontManagerGoogleFontsCatalog* self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_select_item (FontManagerGoogleFontsFontListView* self,
                                                           guint position);
static void font_manager_google_fonts_catalog_update_cache (FontManagerGoogleFontsCatalog* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean font_manager_google_fonts_catalog_update_cache_finish (FontManagerGoogleFontsCatalog* self,
                                                                GAsyncResult* _res_);
static void __lambda191_ (FontManagerGoogleFontsCatalog* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda191__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void font_manager_google_fonts_catalog_set_available_families (FontManagerGoogleFontsCatalog* self,
                                                               JsonArray* value);
VALA_EXTERN GtkWidget* font_manager_dual_paned_get_list_widget (FontManagerDualPaned* self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_queue_refilter (FontManagerGoogleFontsFontListView* self);
static void font_manager_google_fonts_catalog_set_placeholder_message (FontManagerGoogleFontsCatalog* self,
                                                                const gchar* title,
                                                                const gchar* subtitle,
                                                                const gchar* message,
                                                                const gchar* icon_name);
static gboolean font_manager_google_fonts_catalog_have_valid_cache (FontManagerGoogleFontsCatalog* self,
                                                             const gchar* filename);
static void font_manager_google_fonts_catalog_update_cache_data_free (gpointer _data);
static gboolean font_manager_google_fonts_catalog_update_cache_co (FontManagerGoogleFontsCatalogUpdateCacheData* _data_);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void _____lambda190_ (Block39Data* _data39_,
                      GObject* obj,
                      GAsyncResult* res);
static void ______lambda190__gasync_ready_callback (GObject* source_object,
                                             GAsyncResult* res,
                                             gpointer self);
static gboolean _font_manager_google_fonts_catalog_update_cache_co_gsource_func (gpointer self);
VALA_EXTERN JsonArray* font_manager_google_fonts_catalog_get_available_families (FontManagerGoogleFontsCatalog* self);
VALA_EXTERN FontManagerWaterfallSettings* font_manager_google_fonts_catalog_get_waterfall_settings (FontManagerGoogleFontsCatalog* self);
VALA_EXTERN void font_manager_google_fonts_catalog_set_waterfall_settings (FontManagerGoogleFontsCatalog* self,
                                                               FontManagerWaterfallSettings* value);
static void font_manager_google_fonts_catalog_finalize (GObject * obj);
static GType font_manager_google_fonts_catalog_get_type_once (void);
static void _vala_font_manager_google_fonts_catalog_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_font_manager_google_fonts_catalog_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* FONT_MANAGER_GOOGLE_FONTS_CACHE_FILES[4] = {"alpha", "date", "popularity", "trending"};

gchar*
font_manager_google_fonts_get_font_directory (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = font_manager_get_user_font_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "Google Fonts", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static inline gpointer
font_manager_google_fonts_catalog_get_instance_private (FontManagerGoogleFontsCatalog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsCatalog_private_offset);
}

FontManagerGoogleFontsCatalog*
font_manager_google_fonts_catalog_construct (GType object_type,
                                             GSettings* settings)
{
	FontManagerGoogleFontsCatalog * self = NULL;
	self = (FontManagerGoogleFontsCatalog*) font_manager_dual_paned_construct (object_type, settings);
	return self;
}

FontManagerGoogleFontsCatalog*
font_manager_google_fonts_catalog_new (GSettings* settings)
{
	return font_manager_google_fonts_catalog_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, settings);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_font_manager_google_fonts_catalog_on_network_changed_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                                                         gboolean network_available,
                                                                                         gpointer self)
{
	font_manager_google_fonts_catalog_on_network_changed ((FontManagerGoogleFontsCatalog*) self);
}

static void
_font_manager_google_fonts_catalog_on_sort_changed_font_manager_google_fonts_sidebar_sort_changed (FontManagerGoogleFontsSidebar* _sender,
                                                                                                   const gchar* order,
                                                                                                   gpointer self)
{
	font_manager_google_fonts_catalog_on_sort_changed ((FontManagerGoogleFontsCatalog*) self, order);
}

static void
font_manager_google_fonts_catalog_real_on_map (FontManagerDualPaned* base)
{
	FontManagerGoogleFontsCatalog * self;
	FontManagerGoogleFontsSidebar* sidebar = NULL;
	FontManagerGoogleFontsSidebar* _tmp0_;
	FontManagerGoogleFontsFontListView* _tmp1_;
	FontManagerGoogleFontsPreviewPage* _tmp2_;
	FontManagerGoogleFontsSidebar* _tmp3_;
	FontManagerGoogleFontsFontListView* _tmp4_;
	FontManagerGoogleFontsPreviewPage* _tmp5_;
	FontManagerPlaceHolder* _tmp6_;
	FontManagerPlaceHolder* _tmp7_;
	FontManagerPlaceHolder* _tmp8_;
	GtkOverlay* _tmp9_;
	FontManagerPlaceHolder* _tmp10_;
	FontManagerPlaceHolder* _tmp11_;
	FontManagerPlaceHolder* _tmp12_;
	GNetworkMonitor* _tmp13_;
	GNetworkMonitor* _tmp14_;
	GNetworkMonitor* _tmp15_;
	GBindingFlags flags = 0U;
	FontManagerGoogleFontsFontListView* _tmp16_;
	FontManagerGoogleFontsPreviewPage* _tmp17_;
	FontManagerGoogleFontsSidebar* _tmp18_;
	FontManagerGoogleFontsFontListView* _tmp19_;
	FontManagerGoogleFontsFontListView* _tmp20_;
	FontManagerGoogleFontsPreviewPage* _tmp21_;
	FontManagerGoogleFontsSidebar* _tmp22_;
	FontManagerGoogleFontsPreviewPage* _tmp23_;
	GSettings* _tmp24_;
	GSettings* _tmp25_;
	self = (FontManagerGoogleFontsCatalog*) base;
	FONT_MANAGER_DUAL_PANED_CLASS (font_manager_google_fonts_catalog_parent_class)->on_map (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned));
	if (self->priv->initialized) {
		return;
	}
	_tmp0_ = font_manager_google_fonts_sidebar_new ();
	g_object_ref_sink (_tmp0_);
	sidebar = _tmp0_;
	_tmp1_ = font_manager_google_fonts_font_list_view_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->fontlist);
	self->priv->fontlist = _tmp1_;
	_tmp2_ = font_manager_google_fonts_preview_page_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = _tmp2_;
	_tmp3_ = sidebar;
	font_manager_dual_paned_set_sidebar_widget ((FontManagerDualPaned*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->fontlist;
	font_manager_dual_paned_set_list_widget ((FontManagerDualPaned*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->preview;
	font_manager_dual_paned_set_content_widget ((FontManagerDualPaned*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (NULL, NULL, NULL, NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp6_;
	_tmp7_ = self->priv->placeholder;
	font_manager_widget_set_expand ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->placeholder;
	font_manager_widget_set_align ((GtkWidget*) _tmp8_, GTK_ALIGN_FILL);
	_tmp9_ = ((FontManagerDualPaned*) self)->overlay;
	_tmp10_ = self->priv->placeholder;
	gtk_overlay_add_overlay (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->placeholder;
	gtk_widget_set_opacity ((GtkWidget*) _tmp11_, 0.99);
	_tmp12_ = self->priv->placeholder;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
	_tmp13_ = g_network_monitor_get_default ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->network_monitor);
	self->priv->network_monitor = _tmp14_;
	_tmp15_ = self->priv->network_monitor;
	g_signal_connect_object (_tmp15_, "network-changed", (GCallback) _font_manager_google_fonts_catalog_on_network_changed_g_network_monitor_network_changed, self, 0);
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	_tmp16_ = self->priv->fontlist;
	g_object_bind_property_with_closures ((GObject*) self, "available-families", (GObject*) _tmp16_, "available-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = self->priv->preview;
	g_object_bind_property_with_closures ((GObject*) self, "waterfall-settings", (GObject*) _tmp17_, "waterfall-settings", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp18_ = sidebar;
	_tmp19_ = self->priv->fontlist;
	g_object_bind_property_with_closures ((GObject*) _tmp18_, "filter", (GObject*) _tmp19_, "filter", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = self->priv->fontlist;
	_tmp21_ = self->priv->preview;
	g_object_bind_property_with_closures ((GObject*) _tmp20_, "selected-item", (GObject*) _tmp21_, "selected-item", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = sidebar;
	g_signal_connect_object (_tmp22_, "sort-changed", (GCallback) _font_manager_google_fonts_catalog_on_sort_changed_font_manager_google_fonts_sidebar_sort_changed, self, 0);
	if (font_manager_google_fonts_catalog_network_available (self)) {
		font_manager_google_fonts_catalog_on_network_changed (self);
	} else {
		font_manager_google_fonts_catalog_update_placeholder (self);
	}
	_tmp23_ = self->priv->preview;
	_tmp24_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
	_tmp25_ = _tmp24_;
	font_manager_google_fonts_preview_page_restore_state (_tmp23_, _tmp25_);
	self->priv->initialized = TRUE;
	_g_object_unref0 (sidebar);
	return;
}

static void
font_manager_google_fonts_catalog_focus_search_entry (FontManagerGoogleFontsCatalog* self,
                                                      GtkWidget* widget,
                                                      const gchar* action,
                                                      GVariant* parameter)
{
	FontManagerGoogleFontsFontListView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->fontlist;
	font_manager_google_fonts_font_list_view_focus_search_entry (_tmp0_);
	return;
}

void
font_manager_google_fonts_catalog_select_first_font (FontManagerGoogleFontsCatalog* self)
{
	FontManagerGoogleFontsFontListView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fontlist;
	font_manager_google_fonts_font_list_view_select_item (_tmp0_, (guint) 0);
	return;
}

static void
__lambda191_ (FontManagerGoogleFontsCatalog* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	font_manager_google_fonts_catalog_update_cache_finish (self, res);
	font_manager_google_fonts_catalog_update_placeholder (self);
}

static void
___lambda191__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda191_ ((FontManagerGoogleFontsCatalog*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_google_fonts_catalog_on_network_changed (FontManagerGoogleFontsCatalog* self)
{
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_settings_get_boolean (_tmp4_, "restrict-network-access");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	font_manager_google_fonts_catalog_update_cache (self, ___lambda191__gasync_ready_callback, g_object_ref (self));
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static void
font_manager_google_fonts_catalog_on_sort_changed (FontManagerGoogleFontsCatalog* self,
                                                   const gchar* order)
{
	gchar* filename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* cache_dir = NULL;
	gchar* _tmp2_;
	gchar* cache = NULL;
	gchar* _tmp3_;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	GtkWidget* _tmp14_;
	FontManagerGoogleFontsFontListView* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (order != NULL);
	_tmp0_ = string_to_string (order);
	_tmp1_ = g_strconcat ("gfc-", _tmp0_, ".json", NULL);
	filename = _tmp1_;
	_tmp2_ = font_manager_get_package_cache_directory ();
	cache_dir = _tmp2_;
	_tmp3_ = g_build_filename (cache_dir, filename, NULL);
	cache = _tmp3_;
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonObject* jobject = NULL;
		JsonNode* _tmp5_;
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		JsonArray* items = NULL;
		JsonObject* _tmp8_;
		JsonArray* _tmp9_;
		JsonArray* _tmp10_;
		JsonArray* _tmp11_;
		json_parser_load_from_file (parser, cache, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = json_parser_get_root (parser);
		_tmp6_ = json_node_get_object (_tmp5_);
		_tmp7_ = _json_object_ref0 (_tmp6_);
		jobject = _tmp7_;
		_tmp8_ = jobject;
		_tmp9_ = json_object_get_array_member (_tmp8_, "items");
		_tmp10_ = _json_array_ref0 (_tmp9_);
		items = _tmp10_;
		_tmp11_ = items;
		font_manager_google_fonts_catalog_set_available_families (self, _tmp11_);
		_json_array_unref0 (items);
		_json_object_unref0 (jobject);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GError* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (self->priv->error);
		self->priv->error = NULL;
		_tmp12_ = e;
		_tmp13_ = g_error_copy (_tmp12_);
		_g_error_free0 (self->priv->error);
		self->priv->error = _tmp13_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (cache);
		_g_free0 (cache_dir);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	font_manager_google_fonts_catalog_update_placeholder (self);
	_tmp14_ = font_manager_dual_paned_get_list_widget ((FontManagerDualPaned*) self);
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView);
	font_manager_google_fonts_font_list_view_queue_refilter (_tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (parser);
	_g_free0 (cache);
	_g_free0 (cache_dir);
	_g_free0 (filename);
	return;
}

static gboolean
font_manager_google_fonts_catalog_network_available (FontManagerGoogleFontsCatalog* self)
{
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean available = FALSE;
	GNetworkMonitor* _tmp5_;
	GNetworkConnectivity _tmp6_;
	GNetworkConnectivity _tmp7_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_settings_get_boolean (_tmp4_, "restrict-network-access");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->network_monitor;
	_tmp6_ = g_network_monitor_get_connectivity (_tmp5_);
	_tmp7_ = _tmp6_;
	available = _tmp7_ == G_NETWORK_CONNECTIVITY_FULL;
	if (!available) {
		GNetworkMonitor* _tmp9_;
		GNetworkConnectivity _tmp10_;
		GNetworkConnectivity _tmp11_;
		_tmp9_ = self->priv->network_monitor;
		_tmp10_ = g_network_monitor_get_connectivity (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_ != G_NETWORK_CONNECTIVITY_LOCAL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		{
			GNetworkAddress* google = NULL;
			GNetworkAddress* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GNetworkMonitor* _tmp14_;
			GNetworkAddress* _tmp15_;
			_tmp12_ = (GNetworkAddress*) g_network_address_new ("www.google.com", (guint16) 80);
			google = _tmp12_;
			_tmp14_ = self->priv->network_monitor;
			_tmp15_ = google;
			_tmp13_ = g_network_monitor_can_reach (_tmp14_, (GSocketConnectable*) _tmp15_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (google);
				goto __catch0_g_error;
			}
			available = _tmp13_;
			_g_object_unref0 (google);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_debug ("GoogleFonts.vala:138: NetworkConnectivity check failed : %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
	}
	result = available;
	return result;
}

static void
font_manager_google_fonts_catalog_set_placeholder_message (FontManagerGoogleFontsCatalog* self,
                                                           const gchar* title,
                                                           const gchar* subtitle,
                                                           const gchar* message,
                                                           const gchar* icon_name)
{
	FontManagerPlaceHolder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->placeholder;
	g_object_set ((GObject*) _tmp0_, "title", title, "subtitle", subtitle, "message", message, "icon-name", icon_name, NULL, NULL);
	return;
}

static void
font_manager_google_fonts_catalog_update_placeholder (FontManagerGoogleFontsCatalog* self)
{
	FontManagerPlaceHolder* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->placeholder;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp2_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		_tmp4_ = font_manager_dual_paned_get_settings ((FontManagerDualPaned*) self);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_settings_get_boolean (_tmp5_, "restrict-network-access");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		font_manager_google_fonts_catalog_set_placeholder_message (self, _ ("Network Access Disabled"), _ ("Contact your system administrator to request access."), NULL, "network-offline-symbolic");
	} else {
		if (!font_manager_google_fonts_catalog_network_available (self)) {
			font_manager_google_fonts_catalog_set_placeholder_message (self, _ ("Network Offline"), _ ("An active internet connection is required to access the Google Fonts c" \
"atalog"), NULL, "network-offline-symbolic");
		} else {
			gboolean _tmp6_ = FALSE;
			GError* _tmp7_;
			_tmp7_ = self->priv->error;
			if (_tmp7_ == NULL) {
				_tmp6_ = self->priv->status_code == ((guint) SOUP_STATUS_OK);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				FontManagerPlaceHolder* _tmp8_;
				font_manager_google_fonts_catalog_set_placeholder_message (self, NULL, NULL, NULL, NULL);
				_tmp8_ = self->priv->placeholder;
				gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
			} else {
				GError* _tmp9_;
				_tmp9_ = self->priv->error;
				if (_tmp9_ != NULL) {
					GError* _tmp10_;
					const gchar* _tmp11_;
					GError* _tmp12_;
					GError* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp10_ = self->priv->error;
					_tmp11_ = g_quark_to_string (_tmp10_->domain);
					_tmp12_ = self->priv->error;
					_tmp13_ = self->priv->error;
					_tmp14_ = _tmp13_->message;
					_tmp15_ = g_strdup_printf ("%i : %s", _tmp12_->code, _tmp14_);
					_tmp16_ = _tmp15_;
					font_manager_google_fonts_catalog_set_placeholder_message (self, _tmp11_, _tmp16_, NULL, "dialog-error-symbolic");
					_g_free0 (_tmp16_);
				} else {
					gboolean _tmp17_ = FALSE;
					if (self->priv->status_code >= ((guint) SOUP_STATUS_BAD_REQUEST)) {
						_tmp17_ = self->priv->status_code < ((guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						const gchar* _tmp18_;
						_tmp18_ = self->priv->reason_phrase;
						font_manager_google_fonts_catalog_set_placeholder_message (self, _ ("Client Error"), _tmp18_, _ ("Try restarting the application. If the issue persists, please file a b" \
"ug."), "dialog-error-symbolic");
					} else {
						if (self->priv->status_code >= ((guint) SOUP_STATUS_INTERNAL_SERVER_ERROR)) {
							const gchar* _tmp19_;
							_tmp19_ = self->priv->reason_phrase;
							font_manager_google_fonts_catalog_set_placeholder_message (self, _ ("Server Error"), _tmp19_, NULL, "network-error-symbolic");
						}
					}
				}
			}
		}
	}
	return;
}

static gboolean
font_manager_google_fonts_catalog_have_valid_cache (FontManagerGoogleFontsCatalog* self,
                                                    const gchar* filename)
{
	gchar* cache_dir = NULL;
	gchar* _tmp0_;
	gchar* cache = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* cache_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = font_manager_get_package_cache_directory ();
	cache_dir = _tmp0_;
	_tmp1_ = cache_dir;
	_tmp2_ = g_build_filename (_tmp1_, filename, NULL);
	cache = _tmp2_;
	_tmp3_ = cache;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	cache_file = _tmp4_;
	_tmp5_ = cache_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		gboolean _tmp16_ = FALSE;
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp6_;
			GFileInfo* _tmp7_;
			guint64 ctime = 0ULL;
			GFileInfo* _tmp8_;
			GDateTime* now = NULL;
			GDateTime* _tmp9_;
			GDateTime* created = NULL;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GDateTime* _tmp12_;
			_tmp6_ = cache_file;
			_tmp7_ = g_file_query_info (_tmp6_, G_FILE_ATTRIBUTE_TIME_CREATED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			file_info = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = file_info;
			ctime = g_file_info_get_attribute_uint64 (_tmp8_, G_FILE_ATTRIBUTE_TIME_CREATED);
			_tmp9_ = g_date_time_new_now_local ();
			now = _tmp9_;
			_tmp10_ = g_date_time_new_from_unix_local ((gint64) ctime);
			created = _tmp10_;
			_tmp11_ = now;
			_tmp12_ = created;
			result = g_date_time_difference (_tmp11_, _tmp12_) <= (G_TIME_SPAN_DAY * 2);
			_g_date_time_unref0 (created);
			_g_date_time_unref0 (now);
			_g_object_unref0 (file_info);
			_g_object_unref0 (cache_file);
			_g_free0 (cache);
			_g_free0 (cache_dir);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = cache;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("GoogleFonts.vala:194: Failed to query file information : %s : %s", _tmp13_, _tmp15_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (cache_file);
			_g_free0 (cache);
			_g_free0 (cache_dir);
			return result;
		}
		__finally0:
		_g_object_unref0 (cache_file);
		_g_free0 (cache);
		_g_free0 (cache_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	result = FALSE;
	_g_object_unref0 (cache_file);
	_g_free0 (cache);
	_g_free0 (cache_dir);
	return result;
}

static void
font_manager_google_fonts_catalog_update_cache_data_free (gpointer _data)
{
	FontManagerGoogleFontsCatalogUpdateCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FontManagerGoogleFontsCatalogUpdateCacheData, _data_);
}

static void
font_manager_google_fonts_catalog_update_cache (FontManagerGoogleFontsCatalog* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	FontManagerGoogleFontsCatalogUpdateCacheData* _data_;
	FontManagerGoogleFontsCatalog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FontManagerGoogleFontsCatalogUpdateCacheData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, font_manager_google_fonts_catalog_update_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	font_manager_google_fonts_catalog_update_cache_co (_data_);
}

static gboolean
font_manager_google_fonts_catalog_update_cache_finish (FontManagerGoogleFontsCatalog* self,
                                                       GAsyncResult* _res_)
{
	gboolean result;
	FontManagerGoogleFontsCatalogUpdateCacheData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		FontManagerGoogleFontsCatalog* self;
		self = _data38_->self;
		_g_free0 (_data38_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		FontManagerGoogleFontsCatalog* self;
		self = _data39_->_data38_->self;
		_g_object_unref0 (_data39_->stream);
		block38_data_unref (_data39_->_data38_);
		_data39_->_data38_ = NULL;
		g_slice_free (Block39Data, _data39_);
	}
}

static void
_____lambda190_ (Block39Data* _data39_,
                 GObject* obj,
                 GAsyncResult* res)
{
	Block38Data* _data38_;
	FontManagerGoogleFontsCatalog* self;
	GError* _inner_error0_ = NULL;
	_data38_ = _data39_->_data38_;
	self = _data38_->self;
	g_return_if_fail (res != NULL);
	{
		GFileOutputStream* _tmp0_;
		GFileOutputStream* _tmp1_;
		_tmp0_ = _data39_->stream;
		g_output_stream_write_bytes_finish ((GOutputStream*) _tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = _data39_->stream;
		g_output_stream_close ((GOutputStream*) _tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _data38_->filename;
		_tmp3_ = e;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("GoogleFonts.vala:224: Failed to write data for : %s :: %i : %s", _tmp2_, _tmp3_->code, _tmp5_);
		_tmp6_ = e;
		_tmp7_ = g_error_copy (_tmp6_);
		_g_error_free0 (self->priv->error);
		self->priv->error = _tmp7_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
______lambda190__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self)
{
	_____lambda190_ (self, source_object, res);
	block39_data_unref (self);
}

static gboolean
_font_manager_google_fonts_catalog_update_cache_co_gsource_func (gpointer self)
{
	gboolean result;
	result = font_manager_google_fonts_catalog_update_cache_co (self);
	return result;
}

static gboolean
font_manager_google_fonts_catalog_update_cache_co (FontManagerGoogleFontsCatalogUpdateCacheData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_error_free0 (_data_->self->priv->error);
	_data_->self->priv->error = NULL;
	_data_->self->priv->status_code = (guint) SOUP_STATUS_OK;
	_data_->_tmp0_ = soup_session_new ();
	_data_->session = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = g_base64_decode (FONT_MANAGER_GOOGLE_FONTS_API_KEY, &_data_->_tmp1_);
	_data_->GFC_API_KEY = (gchar*) _data_->_tmp2_;
	{
		_data_->entry_collection_length1 = 0;
		_data_->_entry_collection_size_ = 0;
		_data_->entry_collection = FONT_MANAGER_GOOGLE_FONTS_CACHE_FILES;
		_data_->entry_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_GOOGLE_FONTS_CACHE_FILES);
		for (_data_->entry_it = 0; _data_->entry_it < _data_->entry_collection_length1; _data_->entry_it = _data_->entry_it + 1) {
			_data_->entry = _data_->entry_collection[_data_->entry_it];
			{
				_data_->_data38_ = g_slice_new0 (Block38Data);
				_data_->_data38_->_ref_count_ = 1;
				_data_->_data38_->self = g_object_ref (_data_->self);
				_data_->_tmp3_ = _data_->entry;
				_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
				_data_->_tmp5_ = g_strconcat ("gfc-", _data_->_tmp4_, ".json", NULL);
				_data_->_data38_->filename = _data_->_tmp5_;
				_data_->_tmp6_ = _data_->_data38_->filename;
				if (font_manager_google_fonts_catalog_have_valid_cache (_data_->self, _data_->_tmp6_)) {
					block38_data_unref (_data_->_data38_);
					_data_->_data38_ = NULL;
					continue;
				}
				_data_->_tmp7_ = _data_->GFC_API_KEY;
				_data_->_tmp8_ = _data_->entry;
				_data_->_tmp9_ = g_strdup_printf (FONT_MANAGER_GOOGLE_FONTS_GOOGLE_FONTS_API, _data_->_tmp7_, _data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				_data_->_tmp11_ = soup_message_new (FONT_MANAGER_GOOGLE_FONTS_GET, _data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				_g_free0 (_data_->_tmp10_);
				_data_->message = _data_->_tmp12_;
				{
					_data_->_data39_ = g_slice_new0 (Block39Data);
					_data_->_data39_->_ref_count_ = 1;
					_data_->_data39_->_data38_ = block38_data_ref (_data_->_data38_);
					_data_->_tmp13_ = _data_->session;
					_data_->_tmp14_ = _data_->message;
					_data_->_tmp15_ = soup_session_send_and_read (_data_->_tmp13_, _data_->_tmp14_, NULL, &_data_->_inner_error0_);
					_data_->bytes = _data_->_tmp15_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						block39_data_unref (_data_->_data39_);
						_data_->_data39_ = NULL;
						goto __catch0_g_error;
					}
					_data_->_tmp16_ = _data_->bytes;
					_vala_assert (_data_->_tmp16_ != NULL, "bytes != null");
					_data_->_tmp17_ = font_manager_get_package_cache_directory ();
					_data_->_tmp18_ = _data_->_tmp17_;
					_data_->_tmp19_ = _data_->_data38_->filename;
					_data_->_tmp20_ = g_build_filename (_data_->_tmp18_, _data_->_tmp19_, NULL);
					_data_->_tmp21_ = _data_->_tmp20_;
					_g_free0 (_data_->_tmp18_);
					_data_->filepath = _data_->_tmp21_;
					_data_->_tmp22_ = _data_->filepath;
					_data_->_tmp23_ = g_file_new_for_path (_data_->_tmp22_);
					_data_->cache_file = _data_->_tmp23_;
					_data_->_tmp24_ = _data_->cache_file;
					if (g_file_query_exists (_data_->_tmp24_, NULL)) {
						_data_->_tmp25_ = _data_->cache_file;
						g_file_delete (_data_->_tmp25_, NULL, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							_g_object_unref0 (_data_->cache_file);
							_g_free0 (_data_->filepath);
							_g_bytes_unref0 (_data_->bytes);
							block39_data_unref (_data_->_data39_);
							_data_->_data39_ = NULL;
							goto __catch0_g_error;
						}
					}
					_data_->_tmp26_ = _data_->cache_file;
					_data_->_tmp27_ = g_file_create (_data_->_tmp26_, G_FILE_CREATE_PRIVATE, NULL, &_data_->_inner_error0_);
					_data_->_data39_->stream = _data_->_tmp27_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->cache_file);
						_g_free0 (_data_->filepath);
						_g_bytes_unref0 (_data_->bytes);
						block39_data_unref (_data_->_data39_);
						_data_->_data39_ = NULL;
						goto __catch0_g_error;
					}
					_data_->_tmp28_ = _data_->_data39_->stream;
					_data_->_tmp29_ = _data_->bytes;
					g_output_stream_write_bytes_async ((GOutputStream*) _data_->_tmp28_, _data_->_tmp29_, G_PRIORITY_DEFAULT, NULL, ______lambda190__gasync_ready_callback, block39_data_ref (_data_->_data39_));
					_g_object_unref0 (_data_->cache_file);
					_g_free0 (_data_->filepath);
					_g_bytes_unref0 (_data_->bytes);
					block39_data_unref (_data_->_data39_);
					_data_->_data39_ = NULL;
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp30_ = _data_->_data38_->filename;
					_data_->_tmp31_ = _data_->e;
					_data_->_tmp32_ = _data_->e;
					_data_->_tmp33_ = _data_->_tmp32_->message;
					g_warning ("GoogleFonts.vala:229: Failed to write data for : %s :: %i : %s", _data_->_tmp30_, _data_->_tmp31_->code, _data_->_tmp33_);
					_data_->_tmp34_ = _data_->message;
					g_object_get (_data_->_tmp34_, "status-code", &_data_->_tmp35_, NULL);
					_data_->_tmp36_ = _data_->_tmp35_;
					_data_->self->priv->status_code = _data_->_tmp36_;
					_data_->_tmp37_ = _data_->message;
					_data_->_tmp38_ = soup_message_get_reason_phrase (_data_->_tmp37_);
					_data_->_tmp39_ = _data_->_tmp38_;
					_data_->_tmp40_ = g_strdup (_data_->_tmp39_);
					_g_free0 (_data_->self->priv->reason_phrase);
					_data_->self->priv->reason_phrase = _data_->_tmp40_;
					_data_->result = FALSE;
					_g_error_free0 (_data_->e);
					_g_object_unref0 (_data_->message);
					block38_data_unref (_data_->_data38_);
					_data_->_data38_ = NULL;
					_g_free0 (_data_->GFC_API_KEY);
					_g_object_unref0 (_data_->session);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->message);
					block38_data_unref (_data_->_data38_);
					_data_->_data38_ = NULL;
					_g_free0 (_data_->GFC_API_KEY);
					_g_object_unref0 (_data_->session);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp41_ = _data_->self->priv->error;
				if (_data_->_tmp41_ != NULL) {
					_data_->result = FALSE;
					_g_object_unref0 (_data_->message);
					block38_data_unref (_data_->_data38_);
					_data_->_data38_ = NULL;
					_g_free0 (_data_->GFC_API_KEY);
					_g_object_unref0 (_data_->session);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp42_ = _data_->message;
				g_object_get (_data_->_tmp42_, "status-code", &_data_->_tmp43_, NULL);
				_data_->_tmp44_ = _data_->_tmp43_;
				_data_->self->priv->status_code = _data_->_tmp44_;
				_data_->_tmp45_ = _data_->message;
				_data_->_tmp46_ = soup_message_get_reason_phrase (_data_->_tmp45_);
				_data_->_tmp47_ = _data_->_tmp46_;
				_data_->_tmp48_ = g_strdup (_data_->_tmp47_);
				_g_free0 (_data_->self->priv->reason_phrase);
				_data_->self->priv->reason_phrase = _data_->_tmp48_;
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _font_manager_google_fonts_catalog_update_cache_co_gsource_func, _data_, NULL);
				_data_->_state_ = 1;
				return FALSE;
				_state_1:
				;
				_g_object_unref0 (_data_->message);
				block38_data_unref (_data_->_data38_);
				_data_->_data38_ = NULL;
			}
		}
	}
	font_manager_google_fonts_catalog_on_sort_changed (_data_->self, "alpha");
	_data_->result = TRUE;
	_g_free0 (_data_->GFC_API_KEY);
	_g_object_unref0 (_data_->session);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

JsonArray*
font_manager_google_fonts_catalog_get_available_families (FontManagerGoogleFontsCatalog* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_families;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_catalog_set_available_families (FontManagerGoogleFontsCatalog* self,
                                                          JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_catalog_get_available_families (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_available_families);
		self->priv->_available_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_catalog_properties[FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY]);
	}
}

FontManagerWaterfallSettings*
font_manager_google_fonts_catalog_get_waterfall_settings (FontManagerGoogleFontsCatalog* self)
{
	FontManagerWaterfallSettings* result;
	FontManagerWaterfallSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_waterfall_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_catalog_set_waterfall_settings (FontManagerGoogleFontsCatalog* self,
                                                          FontManagerWaterfallSettings* value)
{
	FontManagerWaterfallSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_catalog_get_waterfall_settings (self);
	if (old_value != value) {
		FontManagerWaterfallSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_waterfall_settings);
		self->priv->_waterfall_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_catalog_properties[FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY]);
	}
}

static void
font_manager_google_fonts_catalog_class_init (FontManagerGoogleFontsCatalogClass * klass,
                                              gpointer klass_data)
{
	font_manager_google_fonts_catalog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsCatalog_private_offset);
	((FontManagerDualPanedClass *) klass)->on_map = (void (*) (FontManagerDualPaned*)) font_manager_google_fonts_catalog_real_on_map;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_catalog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_catalog_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_catalog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY, font_manager_google_fonts_catalog_properties[FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY] = g_param_spec_boxed ("available-families", "available-families", "available-families", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY, font_manager_google_fonts_catalog_properties[FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY] = g_param_spec_object ("waterfall-settings", "waterfall-settings", "waterfall-settings", FONT_MANAGER_TYPE_WATERFALL_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "focus-search", NULL, (GtkWidgetActionActivateFunc) font_manager_google_fonts_catalog_focus_search_entry);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_F, GDK_CONTROL_MASK, "focus-search", NULL, NULL);
}

static void
font_manager_google_fonts_catalog_instance_init (FontManagerGoogleFontsCatalog * self,
                                                 gpointer klass)
{
	self->priv = font_manager_google_fonts_catalog_get_instance_private (self);
	self->priv->_available_families = NULL;
	self->priv->initialized = FALSE;
	self->priv->status_code = (guint) SOUP_STATUS_NONE;
	self->priv->reason_phrase = NULL;
	self->priv->error = NULL;
}

static void
font_manager_google_fonts_catalog_finalize (GObject * obj)
{
	FontManagerGoogleFontsCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalog);
	_json_array_unref0 (self->priv->_available_families);
	_g_object_unref0 (self->priv->_waterfall_settings);
	_g_free0 (self->priv->reason_phrase);
	_g_error_free0 (self->priv->error);
	_g_object_unref0 (self->priv->network_monitor);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->preview);
	_g_object_unref0 (self->priv->fontlist);
	G_OBJECT_CLASS (font_manager_google_fonts_catalog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_catalog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsCatalog), 0, (GInstanceInitFunc) font_manager_google_fonts_catalog_instance_init, NULL };
	GType font_manager_google_fonts_catalog_type_id;
	font_manager_google_fonts_catalog_type_id = g_type_register_static (FONT_MANAGER_TYPE_DUAL_PANED, "FontManagerGoogleFontsCatalog", &g_define_type_info, 0);
	FontManagerGoogleFontsCatalog_private_offset = g_type_add_instance_private (font_manager_google_fonts_catalog_type_id, sizeof (FontManagerGoogleFontsCatalogPrivate));
	return font_manager_google_fonts_catalog_type_id;
}

GType
font_manager_google_fonts_catalog_get_type (void)
{
	static volatile gsize font_manager_google_fonts_catalog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_catalog_type_id__once)) {
		GType font_manager_google_fonts_catalog_type_id;
		font_manager_google_fonts_catalog_type_id = font_manager_google_fonts_catalog_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_catalog_type_id__once, font_manager_google_fonts_catalog_type_id);
	}
	return font_manager_google_fonts_catalog_type_id__once;
}

static void
_vala_font_manager_google_fonts_catalog_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	FontManagerGoogleFontsCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalog);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_catalog_get_available_families (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_catalog_get_waterfall_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_catalog_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	FontManagerGoogleFontsCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalog);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_CATALOG_AVAILABLE_FAMILIES_PROPERTY:
		font_manager_google_fonts_catalog_set_available_families (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_CATALOG_WATERFALL_SETTINGS_PROPERTY:
		font_manager_google_fonts_catalog_set_waterfall_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

