/* THIS FILE IS AUTOGENERATED FROM RTCRtpCapabilities.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "RTCRtpCapabilitiesBinding.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



RTCRtpCodec::RTCRtpCodec()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpCodec::InitIds(JSContext* cx, RTCRtpCodecAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sdpFmtpLine_id.init(cx, "sdpFmtpLine") ||
      !atomsCache->mimeType_id.init(cx, "mimeType") ||
      !atomsCache->clockRate_id.init(cx, "clockRate") ||
      !atomsCache->channels_id.init(cx, "channels")) {
    return false;
  }
  return true;
}

bool
RTCRtpCodec::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpCodecAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpCodecAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->channels_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChannels.Construct();
    if (!ValueToPrimitive<uint16_t, eDefault>(cx, temp.ref(), "'channels' member of RTCRtpCodec", &(mChannels.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->clockRate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'clockRate' member of RTCRtpCodec", &mClockRate)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'clockRate' member of RTCRtpCodec");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->mimeType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mMimeType)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'mimeType' member of RTCRtpCodec");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sdpFmtpLine_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSdpFmtpLine.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mSdpFmtpLine.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtpCodec::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpCodec::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpCodecAtoms* atomsCache = GetAtomCache<RTCRtpCodecAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mChannels.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint16_t const & currentValue = mChannels.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channels_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mClockRate;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->clockRate_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mMimeType;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->mimeType_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mSdpFmtpLine.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mSdpFmtpLine.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sdpFmtpLine_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpCodec::TraceDictionary(JSTracer* trc)
{
}

RTCRtpCodec&
RTCRtpCodec::operator=(const RTCRtpCodec& aOther)
{
  DictionaryBase::operator=(aOther);
  mChannels.Reset();
  if (aOther.mChannels.WasPassed()) {
    mChannels.Construct(aOther.mChannels.Value());
  }
  mClockRate = aOther.mClockRate;
  mMimeType = aOther.mMimeType;
  mSdpFmtpLine.Reset();
  if (aOther.mSdpFmtpLine.WasPassed()) {
    mSdpFmtpLine.Construct(aOther.mSdpFmtpLine.Value());
  }
  return *this;
}

bool
RTCRtpCodec::operator==(const RTCRtpCodec& aOther) const
{
  if (mChannels != aOther.mChannels) {
      return false;
  }
  if (mClockRate != aOther.mClockRate) {
      return false;
  }
  if (mMimeType != aOther.mMimeType) {
      return false;
  }
  if (mSdpFmtpLine != aOther.mSdpFmtpLine) {
      return false;
  }
  return true;
}



RTCRtpHeaderExtensionCapability::RTCRtpHeaderExtensionCapability()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRtpHeaderExtensionCapability::InitIds(JSContext* cx, RTCRtpHeaderExtensionCapabilityAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->uri_id.init(cx, "uri")) {
    return false;
  }
  return true;
}

bool
RTCRtpHeaderExtensionCapability::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCRtpHeaderExtensionCapability::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpHeaderExtensionCapabilityAtoms* atomsCache = GetAtomCache<RTCRtpHeaderExtensionCapabilityAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mUri;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->uri_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCRtpHeaderExtensionCapability::TraceDictionary(JSTracer* trc)
{
}

RTCRtpHeaderExtensionCapability&
RTCRtpHeaderExtensionCapability::operator=(const RTCRtpHeaderExtensionCapability& aOther)
{
  DictionaryBase::operator=(aOther);
  mUri = aOther.mUri;
  return *this;
}



RTCRtpCapabilities::RTCRtpCapabilities()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRtpCapabilities::InitIds(JSContext* cx, RTCRtpCapabilitiesAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->headerExtensions_id.init(cx, "headerExtensions") ||
      !atomsCache->codecs_id.init(cx, "codecs")) {
    return false;
  }
  return true;
}

bool
RTCRtpCapabilities::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCRtpCapabilities::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpCapabilitiesAtoms* atomsCache = GetAtomCache<RTCRtpCapabilitiesAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRtpCodec> const & currentValue = mCodecs;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->codecs_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRtpHeaderExtensionCapability> const & currentValue = mHeaderExtensions;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->headerExtensions_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCRtpCapabilities::TraceDictionary(JSTracer* trc)
{
}

RTCRtpCapabilities&
RTCRtpCapabilities::operator=(const RTCRtpCapabilities& aOther)
{
  DictionaryBase::operator=(aOther);
  mCodecs = aOther.mCodecs;
  mHeaderExtensions = aOther.mHeaderExtensions;
  return *this;
}


} // namespace mozilla::dom
