/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PopupPositionedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PopupPositionedEvent.h"
#include "PopupPositionedEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PopupPositionedEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


PopupPositionedEvent::PopupPositionedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PopupPositionedEvent::~PopupPositionedEvent()
{
}

PopupPositionedEvent*
PopupPositionedEvent::AsPopupPositionedEvent()
{
  return this;
}

JSObject*
PopupPositionedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PopupPositionedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PopupPositionedEvent>
PopupPositionedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PopupPositionedEventInit& aInit)
{
  RefPtr<PopupPositionedEvent> e = new PopupPositionedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aInit.mBubbles, aInit.mCancelable);
  e->mIsAnchored = aInit.mIsAnchored;
  e->mAlignmentPosition = aInit.mAlignmentPosition;
  e->mPopupAlignment = aInit.mPopupAlignment;
  e->mAlignmentOffset = aInit.mAlignmentOffset;
  e->SetTrusted(trusted);
  e->SetComposed(aInit.mComposed);
  return e.forget();
}

already_AddRefed<PopupPositionedEvent>
PopupPositionedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PopupPositionedEventInit& aInit)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aInit);
}

bool
PopupPositionedEvent::IsAnchored() const
{
  return mIsAnchored;
}

void
PopupPositionedEvent::GetAlignmentPosition(nsString& aRetVal) const
{
  aRetVal = mAlignmentPosition;
}

void
PopupPositionedEvent::GetPopupAlignment(nsString& aRetVal) const
{
  aRetVal = mPopupAlignment;
}

int32_t
PopupPositionedEvent::AlignmentOffset() const
{
  return mAlignmentOffset;
}


} // namespace mozilla::dom
