
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "urlinterceptor_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_UrlInterceptor_Type = nullptr;
static PyTypeObject *Sbk_UrlInterceptor_TypeF(void)
{
    return _Sbk_UrlInterceptor_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void UrlInterceptorWrapper::pysideInitQtMetaTypes()
{
}

void UrlInterceptorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

UrlInterceptorWrapper::UrlInterceptorWrapper(::QObject * parent) : UrlInterceptor(parent)
{
}

void UrlInterceptorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("UrlInterceptor", funcName, gil, pyOverride, event);
}

void UrlInterceptorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("UrlInterceptor", funcName, gil, pyOverride, signal);
}

void UrlInterceptorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("UrlInterceptor", funcName, gil, pyOverride, event);
}

void UrlInterceptorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("UrlInterceptor", funcName, gil, pyOverride, signal);
}

bool UrlInterceptorWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("UrlInterceptor", funcName, gil, pyOverride, event);
}

bool UrlInterceptorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("UrlInterceptor", funcName, gil, pyOverride, watched, event);
}

void UrlInterceptorWrapper::interceptRequest(::QWebEngineUrlRequestInfo & info)
{
    static const char *funcName = "interceptRequest";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("UrlInterceptor.interceptRequest");
        return;
    }
    sbk_o_interceptRequest("UrlInterceptor", funcName, gil, pyOverride, info);
}

void UrlInterceptorWrapper::sbk_o_interceptRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEngineUrlRequestInfo & info)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestInfo_IDX]), &info)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestInfo_IDX]), &info)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void UrlInterceptorWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_UrlInterceptor_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("UrlInterceptor", funcName, gil, pyOverride, event);
}

const QMetaObject *UrlInterceptorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return UrlInterceptor::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int UrlInterceptorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = UrlInterceptor::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *UrlInterceptorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< UrlInterceptorWrapper *>(this));
    }
    return UrlInterceptor::qt_metacast(_clname);
}

UrlInterceptorWrapper::~UrlInterceptorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_UrlInterceptor_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_UrlInterceptor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("UrlInterceptor");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::UrlInterceptor >()))
        return -1;

    UrlInterceptorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:UrlInterceptor", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: UrlInterceptor::UrlInterceptor(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // UrlInterceptor(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // UrlInterceptor(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = Q_NULLPTR;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // UrlInterceptor(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) UrlInterceptorWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new UrlInterceptorWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< UrlInterceptor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);
    };


    return 1;
}

static PyObject *Sbk_UrlInterceptorFunc_interceptRequest(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<UrlInterceptorWrapper *>(reinterpret_cast< ::UrlInterceptor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: UrlInterceptor::interceptRequest(QWebEngineUrlRequestInfo&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestInfo_IDX]), (pyArg)))) {
        overloadId = 0; // interceptRequest(QWebEngineUrlRequestInfo&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "interceptRequest", errInfo, SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlRequestInfo *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // interceptRequest(QWebEngineUrlRequestInfo&)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("UrlInterceptor.interceptRequest");
                return {};
            }
            cppSelf->interceptRequest(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_UrlInterceptor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_UrlInterceptor_methods[] = {
    {"interceptRequest", reinterpret_cast<PyCFunction>(Sbk_UrlInterceptorFunc_interceptRequest), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_UrlInterceptor_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::UrlInterceptor *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<UrlInterceptorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_UrlInterceptor_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_UrlInterceptor_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_UrlInterceptor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_UrlInterceptor_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_UrlInterceptor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_UrlInterceptor_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_UrlInterceptor_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_UrlInterceptor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_UrlInterceptor_spec = {
    "1:PyFalkon.UrlInterceptor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_UrlInterceptor_slots
};

} //extern "C"

static void *Sbk_UrlInterceptor_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::UrlInterceptor *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void UrlInterceptor_PythonToCpp_UrlInterceptor_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_UrlInterceptor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_UrlInterceptor_PythonToCpp_UrlInterceptor_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_UrlInterceptor_TypeF()))
        return UrlInterceptor_PythonToCpp_UrlInterceptor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *UrlInterceptor_PTR_CppToPython_UrlInterceptor(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::UrlInterceptor *>(const_cast<void *>(cppIn)), Sbk_UrlInterceptor_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *UrlInterceptor_SignatureStrings[] = {
    "PyFalkon.UrlInterceptor(self,parent:PySide6.QtCore.QObject=Q_NULLPTR)",
    "PyFalkon.UrlInterceptor.interceptRequest(self,info:PySide6.QtWebEngineCore.QWebEngineUrlRequestInfo)",
    nullptr}; // Sentinel
#else
static constexpr size_t UrlInterceptor_SignatureByteSize = 122;
static constexpr uint8_t UrlInterceptor_SignatureBytes[122] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x2d, 0xca, 0xf1, 0xcc,
    0x2b, 0x49, 0x2d, 0x4a, 0x4e, 0x2d, 0x28, 0xc9, 0x2f, 0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29,
    0x48, 0x2c, 0x4a, 0xcd, 0x2b, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c,
    0x71, 0xce, 0x2f, 0x4a, 0xd5, 0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d, 0x2e, 0xb1, 0x0d, 0x8c, 0xf7,
    0x0b, 0xf5, 0xf1, 0x09, 0x08, 0x09, 0xd2, 0xe4, 0x0a, 0xc0, 0x6e, 0x8a, 0x5e, 0x26, 0x8c, 0x1d,
    0x94, 0x5a, 0x58, 0x9a, 0x5a, 0x5c, 0x02, 0x31, 0x36, 0x33, 0x2f, 0x2d, 0x1f, 0xc9, 0xd0, 0xf0,
    0xd4, 0x24, 0xd7, 0xbc, 0xf4, 0xcc, 0xbc, 0x54, 0x88, 0xe9, 0x70, 0x2e, 0xd0, 0x2c, 0xa8, 0x36,
    0x4f, 0xa0, 0x06, 0x4d, 0x2e, 0x00, 0x3b, 0x70, 0x3f, 0x1d
};
#endif

PyTypeObject *init_UrlInterceptor(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX].type;

    Shiboken::AutoDecRef Sbk_UrlInterceptor_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_UrlInterceptor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "UrlInterceptor",
        "UrlInterceptor*",
        &Sbk_UrlInterceptor_spec,
        &Shiboken::callCppDestructor< UrlInterceptor >,
        Sbk_UrlInterceptor_Type_bases.object(),
        0);
    auto *pyType = Sbk_UrlInterceptor_TypeF(); // references _Sbk_UrlInterceptor_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, UrlInterceptor_SignatureStrings);
#else
    InitSignatureBytes(pyType, UrlInterceptor_SignatureBytes, UrlInterceptor_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_UrlInterceptor_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        UrlInterceptor_PythonToCpp_UrlInterceptor_PTR,
        is_UrlInterceptor_PythonToCpp_UrlInterceptor_PTR_Convertible,
        UrlInterceptor_PTR_CppToPython_UrlInterceptor);

    Shiboken::Conversions::registerConverterName(converter, "UrlInterceptor");
    Shiboken::Conversions::registerConverterName(converter, "UrlInterceptor*");
    Shiboken::Conversions::registerConverterName(converter, "UrlInterceptor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::UrlInterceptor).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(UrlInterceptorWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_UrlInterceptor_TypeF(), &Sbk_UrlInterceptor_typeDiscovery);

    UrlInterceptorWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::UrlInterceptor::staticMetaObject, sizeof(UrlInterceptorWrapper));

    return pyType;
}
