
Efl_Net_Ip_Address *_efl_net_ip_address_create(uint16_t port, const Eina_Slice address);

ECORE_CON_API ECORE_CON_API_WEAK Efl_Net_Ip_Address * efl_net_ip_address_create(uint16_t port, const Eina_Slice address)
{
   const Efl_Class *klass = efl_net_ip_address_class_get();
   EINA_SAFETY_ON_NULL_RETURN_VAL(klass,NULL);
   return _efl_net_ip_address_create(port, address);
}

Efl_Net_Ip_Address *_efl_net_ip_address_create_sockaddr(const void *sockaddr);

ECORE_CON_API ECORE_CON_API_WEAK Efl_Net_Ip_Address * efl_net_ip_address_create_sockaddr(const void *sockaddr)
{
   const Efl_Class *klass = efl_net_ip_address_class_get();
   EINA_SAFETY_ON_NULL_RETURN_VAL(klass,NULL);
   return _efl_net_ip_address_create_sockaddr(sockaddr);
}

Efl_Net_Ip_Address *_efl_net_ip_address_parse(const char *numeric_address);

ECORE_CON_API ECORE_CON_API_WEAK Efl_Net_Ip_Address * efl_net_ip_address_parse(const char *numeric_address)
{
   const Efl_Class *klass = efl_net_ip_address_class_get();
   EINA_SAFETY_ON_NULL_RETURN_VAL(klass,NULL);
   return _efl_net_ip_address_parse(numeric_address);
}

Eina_Future *_efl_net_ip_address_resolve(const char *address, int family, int flags);

ECORE_CON_API ECORE_CON_API_WEAK Eina_Future * efl_net_ip_address_resolve(const char *address, int family, int flags)
{
   const Efl_Class *klass = efl_net_ip_address_class_get();
   EINA_SAFETY_ON_NULL_RETURN_VAL(klass,NULL);
   return _efl_net_ip_address_resolve(address, family, flags);
}

const char *_efl_net_ip_address_string_get(const Eo *obj, Efl_Net_Ip_Address_Data *pd);


static Eina_Value
__eolian_efl_net_ip_address_string_get_reflect(const Eo *obj)
{
   const char *val = efl_net_ip_address_string_get(obj);
   return eina_value_string_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_string_get, const char *, NULL);

void _efl_net_ip_address_family_set(Eo *obj, Efl_Net_Ip_Address_Data *pd, int family);


static Eina_Error
__eolian_efl_net_ip_address_family_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   int cval;
   if (!eina_value_int_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_ip_address_family_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_ip_address_family_set, EFL_FUNC_CALL(family), int family);

int _efl_net_ip_address_family_get(const Eo *obj, Efl_Net_Ip_Address_Data *pd);


static Eina_Value
__eolian_efl_net_ip_address_family_get_reflect(const Eo *obj)
{
   int val = efl_net_ip_address_family_get(obj);
   return eina_value_int_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_family_get, int, 0);

void _efl_net_ip_address_port_set(Eo *obj, Efl_Net_Ip_Address_Data *pd, uint16_t port);

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_ip_address_port_set, EFL_FUNC_CALL(port), uint16_t port);

uint16_t _efl_net_ip_address_port_get(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_port_get, uint16_t, 0);

void _efl_net_ip_address_address_set(Eo *obj, Efl_Net_Ip_Address_Data *pd, const Eina_Slice address);

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_ip_address_set, EFL_FUNC_CALL(address), const Eina_Slice address);

Eina_Slice _efl_net_ip_address_address_get(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_get, Eina_Slice, ((Eina_Slice){0}));

void _efl_net_ip_address_sockaddr_set(Eo *obj, Efl_Net_Ip_Address_Data *pd, const void *sockaddr);

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_ip_address_sockaddr_set, EFL_FUNC_CALL(sockaddr), const void *sockaddr);

const void *_efl_net_ip_address_sockaddr_get(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_sockaddr_get, const void *, NULL);

Eina_Bool _efl_net_ip_address_ipv4_class_a_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv4_class_a_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv4_class_b_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv4_class_b_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv4_class_c_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv4_class_c_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv4_class_d_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv4_class_d_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv6_v4mapped_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv6_v4mapped_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv6_v4compat_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv6_v4compat_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv6_local_link_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv6_local_link_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_ipv6_local_site_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_ipv6_local_site_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_multicast_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_multicast_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_loopback_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_loopback_check, Eina_Bool, EINA_FALSE /* false */);

Eina_Bool _efl_net_ip_address_any_check(const Eo *obj, Efl_Net_Ip_Address_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_ip_address_any_check, Eina_Bool, EINA_FALSE /* false */);

Efl_Object *_efl_net_ip_address_efl_object_finalize(Eo *obj, Efl_Net_Ip_Address_Data *pd);


static Eina_Bool
_efl_net_ip_address_class_initializer(Efl_Class *klass)
{
   const Efl_Object_Ops *opsp = NULL;

   const Efl_Object_Property_Reflection_Ops *ropsp = NULL;

#ifndef EFL_NET_IP_ADDRESS_EXTRA_OPS
#define EFL_NET_IP_ADDRESS_EXTRA_OPS
#endif

   EFL_OPS_DEFINE(ops,
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_string_get, _efl_net_ip_address_string_get),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_family_set, _efl_net_ip_address_family_set),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_family_get, _efl_net_ip_address_family_get),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_port_set, _efl_net_ip_address_port_set),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_port_get, _efl_net_ip_address_port_get),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_set, _efl_net_ip_address_address_set),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_get, _efl_net_ip_address_address_get),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_sockaddr_set, _efl_net_ip_address_sockaddr_set),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_sockaddr_get, _efl_net_ip_address_sockaddr_get),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv4_class_a_check, _efl_net_ip_address_ipv4_class_a_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv4_class_b_check, _efl_net_ip_address_ipv4_class_b_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv4_class_c_check, _efl_net_ip_address_ipv4_class_c_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv4_class_d_check, _efl_net_ip_address_ipv4_class_d_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv6_v4mapped_check, _efl_net_ip_address_ipv6_v4mapped_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv6_v4compat_check, _efl_net_ip_address_ipv6_v4compat_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv6_local_link_check, _efl_net_ip_address_ipv6_local_link_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_ipv6_local_site_check, _efl_net_ip_address_ipv6_local_site_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_multicast_check, _efl_net_ip_address_multicast_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_loopback_check, _efl_net_ip_address_loopback_check),
      EFL_OBJECT_OP_FUNC(efl_net_ip_address_any_check, _efl_net_ip_address_any_check),
      EFL_OBJECT_OP_FUNC(efl_finalize, _efl_net_ip_address_efl_object_finalize),
      EFL_NET_IP_ADDRESS_EXTRA_OPS
   );
   opsp = &ops;

   static const Efl_Object_Property_Reflection refl_table[] = {
      {"string", NULL, __eolian_efl_net_ip_address_string_get_reflect},
      {"family", __eolian_efl_net_ip_address_family_set_reflect, __eolian_efl_net_ip_address_family_get_reflect},
   };
   static const Efl_Object_Property_Reflection_Ops rops = {
      refl_table, EINA_C_ARRAY_LENGTH(refl_table)
   };
   ropsp = &rops;

   return efl_class_functions_set(klass, opsp, ropsp);
}

static const Efl_Class_Description _efl_net_ip_address_class_desc = {
   EO_VERSION,
   "Efl.Net.Ip_Address",
   EFL_CLASS_TYPE_REGULAR,
   sizeof(Efl_Net_Ip_Address_Data),
   _efl_net_ip_address_class_initializer,
   NULL,
   NULL
};

EFL_DEFINE_CLASS(efl_net_ip_address_class_get, &_efl_net_ip_address_class_desc, EFL_OBJECT_CLASS, NULL);
