
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genLttngProvider.py

******************************************************************/


#define TRACEPOINT_DEFINE
#define TRACEPOINT_PROBE_DYNAMIC_LINKAGE

#include "stdlib.h"
#include "pal_mstypes.h"
#include "pal_error.h"
#include "pal.h"
#define PAL_free free
#define PAL_realloc realloc
#include "pal/stackstring.hpp"
#include "tpdotnetruntimerundown.h"

#ifndef tracepoint_enabled

extern "C" bool XplatEventLoggerIsEnabled();

#define tracepoint_enabled(provider, name) XplatEventLoggerIsEnabled()
#define do_tracepoint tracepoint
#endif

#define wcslen PAL_wcslen

bool ResizeBuffer(char *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

extern "C" BOOL  EventXplatEnabledCLRStackWalkDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, CLRStackWalkDCStart); }

extern "C" ULONG  FireEtXplatCLRStackWalkDCStart(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack)
{
    if (!EventXplatEnabledCLRStackWalkDCStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        CLRStackWalkDCStart,
        ClrInstanceID,
        Reserved1,
        Reserved2,
        FrameCount,
        (const size_t*) Stack);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSettingsRundown(){ return tracepoint_enabled(DotNETRuntimeRundown, GCSettingsRundown); }

extern "C" ULONG  FireEtXplatGCSettingsRundown(
    const unsigned __int64 HardLimit,
    const unsigned __int64 LOHThreshold,
    const unsigned __int64 PhysicalMemoryConfig,
    const unsigned __int64 Gen0MinBudgetConfig,
    const unsigned __int64 Gen0MaxBudgetConfig,
    const unsigned int HighMemPercentConfig,
    const unsigned int BitSettings,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSettingsRundown())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        GCSettingsRundown,
        HardLimit,
        LOHThreshold,
        PhysicalMemoryConfig,
        Gen0MinBudgetConfig,
        Gen0MaxBudgetConfig,
        HighMemPercentConfig,
        BitSettings,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStart); }

extern "C" ULONG  FireEtXplatMethodDCStart(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodDCStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCStart,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStart_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStart_V1); }

extern "C" ULONG  FireEtXplatMethodDCStart_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCStart_V1,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStart_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStart_V2); }

extern "C" ULONG  FireEtXplatMethodDCStart_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodDCStart_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCStart_V2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID,
        ReJITID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEnd); }

extern "C" ULONG  FireEtXplatMethodDCEnd(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodDCEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCEnd,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEnd_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEnd_V1); }

extern "C" ULONG  FireEtXplatMethodDCEnd_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCEnd_V1,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEnd_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEnd_V2); }

extern "C" ULONG  FireEtXplatMethodDCEnd_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodDCEnd_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        MethodDCEnd_V2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID,
        ReJITID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartVerbose(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStartVerbose); }

extern "C" ULONG  FireEtXplatMethodDCStartVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodDCStartVerbose())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        MethodDCStartVerbose,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartVerbose_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStartVerbose_V1); }

extern "C" ULONG  FireEtXplatMethodDCStartVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCStartVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    char stackBuffer[230];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCStartVerbose_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartVerbose_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStartVerbose_V2); }

extern "C" ULONG  FireEtXplatMethodDCStartVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodDCStartVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    char stackBuffer[238];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCStartVerbose_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndVerbose(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEndVerbose); }

extern "C" ULONG  FireEtXplatMethodDCEndVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodDCEndVerbose())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        MethodDCEndVerbose,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndVerbose_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEndVerbose_V1); }

extern "C" ULONG  FireEtXplatMethodDCEndVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCEndVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    char stackBuffer[230];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCEndVerbose_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndVerbose_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEndVerbose_V2); }

extern "C" ULONG  FireEtXplatMethodDCEndVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodDCEndVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    char stackBuffer[238];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCEndVerbose_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCStartComplete(){ return tracepoint_enabled(DotNETRuntimeRundown, DCStartComplete); }

extern "C" ULONG  FireEtXplatDCStartComplete(
)
{
    if (!EventXplatEnabledDCStartComplete())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown, DCStartComplete);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCStartComplete_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DCStartComplete_V1); }

extern "C" ULONG  FireEtXplatDCStartComplete_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDCStartComplete_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        DCStartComplete_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCEndComplete(){ return tracepoint_enabled(DotNETRuntimeRundown, DCEndComplete); }

extern "C" ULONG  FireEtXplatDCEndComplete(
)
{
    if (!EventXplatEnabledDCEndComplete())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown, DCEndComplete);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCEndComplete_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DCEndComplete_V1); }

extern "C" ULONG  FireEtXplatDCEndComplete_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDCEndComplete_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        DCEndComplete_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCStartInit(){ return tracepoint_enabled(DotNETRuntimeRundown, DCStartInit); }

extern "C" ULONG  FireEtXplatDCStartInit(
)
{
    if (!EventXplatEnabledDCStartInit())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown, DCStartInit);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCStartInit_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DCStartInit_V1); }

extern "C" ULONG  FireEtXplatDCStartInit_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDCStartInit_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        DCStartInit_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCEndInit(){ return tracepoint_enabled(DotNETRuntimeRundown, DCEndInit); }

extern "C" ULONG  FireEtXplatDCEndInit(
)
{
    if (!EventXplatEnabledDCEndInit())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown, DCEndInit);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCEndInit_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DCEndInit_V1); }

extern "C" ULONG  FireEtXplatDCEndInit_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDCEndInit_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        DCEndInit_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartILToNativeMap(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStartILToNativeMap); }

extern "C" ULONG  FireEtXplatMethodDCStartILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCStartILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    char stackBuffer[32];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCStartILToNativeMap, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartILToNativeMap_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCStartILToNativeMap_V1); }

extern "C" ULONG  FireEtXplatMethodDCStartILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID)
{
    if (!EventXplatEnabledMethodDCStartILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    char stackBuffer[37];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCStartILToNativeMap_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndILToNativeMap(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEndILToNativeMap); }

extern "C" ULONG  FireEtXplatMethodDCEndILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodDCEndILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    char stackBuffer[32];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCEndILToNativeMap, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndILToNativeMap_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, MethodDCEndILToNativeMap_V1); }

extern "C" ULONG  FireEtXplatMethodDCEndILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID)
{
    if (!EventXplatEnabledMethodDCEndILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    char stackBuffer[37];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, MethodDCEndILToNativeMap_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, DomainModuleDCStart); }

extern "C" ULONG  FireEtXplatDomainModuleDCStart(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledDomainModuleDCStart())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        DomainModuleDCStart,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleDCStart_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DomainModuleDCStart_V1); }

extern "C" ULONG  FireEtXplatDomainModuleDCStart_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDomainModuleDCStart_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        DomainModuleDCStart_V1,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, DomainModuleDCEnd); }

extern "C" ULONG  FireEtXplatDomainModuleDCEnd(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledDomainModuleDCEnd())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        DomainModuleDCEnd,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleDCEnd_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, DomainModuleDCEnd_V1); }

extern "C" ULONG  FireEtXplatDomainModuleDCEnd_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDomainModuleDCEnd_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        DomainModuleDCEnd_V1,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCStart); }

extern "C" ULONG  FireEtXplatModuleDCStart(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleDCStart())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        ModuleDCStart,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCStart_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCStart_V1); }

extern "C" ULONG  FireEtXplatModuleDCStart_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleDCStart_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        ModuleDCStart_V1,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCStart_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCStart_V2); }

extern "C" ULONG  FireEtXplatModuleDCStart_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath)
{
    if (!EventXplatEnabledModuleDCStart_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    char stackBuffer[290];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, ModuleDCStart_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCEnd); }

extern "C" ULONG  FireEtXplatModuleDCEnd(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleDCEnd())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        ModuleDCEnd,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCEnd_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCEnd_V1); }

extern "C" ULONG  FireEtXplatModuleDCEnd_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleDCEnd_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        ModuleDCEnd_V1,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCEnd_V2(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleDCEnd_V2); }

extern "C" ULONG  FireEtXplatModuleDCEnd_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath)
{
    if (!EventXplatEnabledModuleDCEnd_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    char stackBuffer[290];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, ModuleDCEnd_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, AssemblyDCStart); }

extern "C" ULONG  FireEtXplatAssemblyDCStart(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledAssemblyDCStart())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AssemblyDCStart,
        AssemblyID,
        AppDomainID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyDCStart_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, AssemblyDCStart_V1); }

extern "C" ULONG  FireEtXplatAssemblyDCStart_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAssemblyDCStart_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AssemblyDCStart_V1,
        AssemblyID,
        AppDomainID,
        BindingID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, AssemblyDCEnd); }

extern "C" ULONG  FireEtXplatAssemblyDCEnd(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledAssemblyDCEnd())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AssemblyDCEnd,
        AssemblyID,
        AppDomainID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyDCEnd_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, AssemblyDCEnd_V1); }

extern "C" ULONG  FireEtXplatAssemblyDCEnd_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAssemblyDCEnd_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AssemblyDCEnd_V1,
        AssemblyID,
        AppDomainID,
        BindingID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, AppDomainDCStart); }

extern "C" ULONG  FireEtXplatAppDomainDCStart(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName)
{
    if (!EventXplatEnabledAppDomainDCStart())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AppDomainDCStart,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainDCStart_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, AppDomainDCStart_V1); }

extern "C" ULONG  FireEtXplatAppDomainDCStart_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainDCStart_V1())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AppDomainDCStart_V1,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name,
        AppDomainIndex,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, AppDomainDCEnd); }

extern "C" ULONG  FireEtXplatAppDomainDCEnd(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName)
{
    if (!EventXplatEnabledAppDomainDCEnd())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AppDomainDCEnd,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainDCEnd_V1(){ return tracepoint_enabled(DotNETRuntimeRundown, AppDomainDCEnd_V1); }

extern "C" ULONG  FireEtXplatAppDomainDCEnd_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainDCEnd_V1())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        AppDomainDCEnd_V1,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name,
        AppDomainIndex,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadDC(){ return tracepoint_enabled(DotNETRuntimeRundown, ThreadDC); }

extern "C" ULONG  FireEtXplatThreadDC(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned int Flags,
    const unsigned int ManagedThreadIndex,
    const unsigned int OSThreadID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadDC())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        ThreadDC,
        ManagedThreadID,
        AppDomainID,
        Flags,
        ManagedThreadIndex,
        OSThreadID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleRangeDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleRangeDCStart); }

extern "C" ULONG  FireEtXplatModuleRangeDCStart(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType)
{
    if (!EventXplatEnabledModuleRangeDCStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        ModuleRangeDCStart,
        ClrInstanceID,
        ModuleID,
        RangeBegin,
        RangeSize,
        RangeType);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleRangeDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, ModuleRangeDCEnd); }

extern "C" ULONG  FireEtXplatModuleRangeDCEnd(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType)
{
    if (!EventXplatEnabledModuleRangeDCEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        ModuleRangeDCEnd,
        ClrInstanceID,
        ModuleID,
        RangeBegin,
        RangeSize,
        RangeType);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledRuntimeInformationDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, RuntimeInformationDCStart); }

extern "C" ULONG  FireEtXplatRuntimeInformationDCStart(
    const unsigned short ClrInstanceID,
    const unsigned short Sku,
    const unsigned short BclMajorVersion,
    const unsigned short BclMinorVersion,
    const unsigned short BclBuildNumber,
    const unsigned short BclQfeNumber,
    const unsigned short VMMajorVersion,
    const unsigned short VMMinorVersion,
    const unsigned short VMBuildNumber,
    const unsigned short VMQfeNumber,
    const unsigned int StartupFlags,
    const unsigned char StartupMode,
    PCWSTR CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR RuntimeDllPath)
{
    if (!EventXplatEnabledRuntimeInformationDCStart())
        return ERROR_SUCCESS;

    size_t size = 153;
    char stackBuffer[153];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Sku, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CommandLine, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ComObjectGuid, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RuntimeDllPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntimeRundown, RuntimeInformationDCStart, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationSettingsDCStart(){ return tracepoint_enabled(DotNETRuntimeRundown, TieredCompilationSettingsDCStart); }

extern "C" ULONG  FireEtXplatTieredCompilationSettingsDCStart(
    const unsigned short ClrInstanceID,
    const unsigned int Flags)
{
    if (!EventXplatEnabledTieredCompilationSettingsDCStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimeRundown,
        TieredCompilationSettingsDCStart,
        ClrInstanceID,
        Flags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecutionCheckpointDCEnd(){ return tracepoint_enabled(DotNETRuntimeRundown, ExecutionCheckpointDCEnd); }

extern "C" ULONG  FireEtXplatExecutionCheckpointDCEnd(
    const unsigned short ClrInstanceID,
    PCWSTR Name,
    const __int64 Timestamp)
{
    if (!EventXplatEnabledExecutionCheckpointDCEnd())
        return ERROR_SUCCESS;
    INT Name_path_size = -1;
    PathCharString Name_PS;
    INT Name_full_name_path_size = (wcslen(Name) + 1)*sizeof(WCHAR);
    CHAR* Name_full_name = Name_PS.OpenStringBuffer(Name_full_name_path_size );
    if (Name_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Name_path_size = WideCharToMultiByte( CP_ACP, 0, Name, -1, Name_full_name, Name_full_name_path_size, NULL, NULL );
    _ASSERTE(Name_path_size < Name_full_name_path_size );
    Name_PS.CloseBuffer(Name_path_size );
    if( Name_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimeRundown,
        ExecutionCheckpointDCEnd,
        ClrInstanceID,
        Name_full_name,
        Timestamp);

    return ERROR_SUCCESS;
}


