/* quake_window.c generated by valac 0.56.17, the Vala compiler
 * generated from quake_window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_QUAKE_WINDOW (widgets_quake_window_get_type ())
#define WIDGETS_QUAKE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_QUAKE_WINDOW, WidgetsQuakeWindow))
#define WIDGETS_QUAKE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_QUAKE_WINDOW, WidgetsQuakeWindowClass))
#define WIDGETS_IS_QUAKE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_QUAKE_WINDOW))
#define WIDGETS_IS_QUAKE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_QUAKE_WINDOW))
#define WIDGETS_QUAKE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_QUAKE_WINDOW, WidgetsQuakeWindowClass))

typedef struct _WidgetsQuakeWindow WidgetsQuakeWindow;
typedef struct _WidgetsQuakeWindowClass WidgetsQuakeWindowClass;
typedef struct _WidgetsQuakeWindowPrivate WidgetsQuakeWindowPrivate;
enum  {
	WIDGETS_QUAKE_WINDOW_0_PROPERTY,
	WIDGETS_QUAKE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* widgets_quake_window_properties[WIDGETS_QUAKE_WINDOW_NUM_PROPERTIES];
typedef struct _Block24Data Block24Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define __vala_GdkEventButton_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventButton_free (var), NULL)))
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block27Data Block27Data;

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;
typedef struct _Block28Data Block28Data;

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _WidgetsQuakeWindow {
	WidgetsConfigWindow parent_instance;
	WidgetsQuakeWindowPrivate * priv;
	gdouble window_default_height_scale;
	gdouble window_max_height_scale;
	gint press_x;
	gint press_y;
	gint window_frame_margin_bottom;
};

struct _WidgetsQuakeWindowClass {
	WidgetsConfigWindowClass parent_class;
};

struct _Block24Data {
	int _ref_count_;
	WidgetsQuakeWindow* self;
	GdkRectangle rect;
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _Block25Data {
	int _ref_count_;
	WidgetsQuakeWindow* self;
	GdkEventButton* e;
};

struct _Block26Data {
	int _ref_count_;
	Block25Data * _data25_;
	GdkCursorType* cursor_type;
};

struct _Block27Data {
	int _ref_count_;
	WidgetsQuakeWindow* self;
	GdkCursorType* cursor_type;
	GdkEventButton* e;
};

struct _Block28Data {
	int _ref_count_;
	WidgetsQuakeWindow* self;
	GdkRGBA background_color;
};

static gpointer widgets_quake_window_parent_class = NULL;
VALA_EXTERN gint constant_RESPONSE_RADIUS;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;

VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_quake_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsQuakeWindow, g_object_unref)
VALA_EXTERN void widgets_config_window_window_save_before_quit (WidgetsConfigWindow* self);
VALA_EXTERN GdkCursorType* widgets_config_window_get_cursor_type (WidgetsConfigWindow* self,
                                                      gdouble x,
                                                      gdouble y);
VALA_EXTERN GdkCursorType* widgets_config_window_get_frame_cursor_type (WidgetsConfigWindow* self,
                                                            gdouble x,
                                                            gdouble y);
VALA_EXTERN void widgets_config_window_update_frame (WidgetsConfigWindow* self);
VALA_EXTERN WidgetsQuakeWindow* widgets_quake_window_new (void);
VALA_EXTERN WidgetsQuakeWindow* widgets_quake_window_construct (GType object_type);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_new (void);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_construct (GType object_type);
VALA_EXTERN gint config_config_get_terminal_monitor (ConfigConfig* self);
static void __lambda263_ (Block24Data* _data24_,
                   GtkWidget* w);
static void ___lambda263__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
static gboolean __lambda264_ (WidgetsQuakeWindow* self,
                       GdkEventFocus* w);
VALA_EXTERN void widgets_quake_window_update_style (WidgetsQuakeWindow* self);
static gboolean ___lambda264__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean __lambda265_ (WidgetsQuakeWindow* self,
                       GdkEventFocus* w);
static gboolean _____lambda266_ (WidgetsQuakeWindow* self);
static gboolean ______lambda266__gsource_func (gpointer self);
static gboolean ___lambda265__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static gboolean __lambda267_ (WidgetsQuakeWindow* self,
                       GdkEventConfigure* w);
VALA_EXTERN void widgets_quake_window_update_blur_status (WidgetsQuakeWindow* self,
                                              gboolean force_update);
static gboolean ___lambda267__gtk_widget_configure_event (GtkWidget* _sender,
                                                   GdkEventConfigure* event,
                                                   gpointer self);
static gboolean __lambda268_ (WidgetsQuakeWindow* self,
                       GtkWidget* w,
                       GdkEventButton* e);
static GdkEventButton* _vala_GdkEventButton_copy (GdkEventButton* self);
static void _vala_GdkEventButton_free (GdkEventButton* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean ____lambda269_ (Block26Data* _data26_);
VALA_EXTERN gboolean utils_resize_window (GtkWidget* widget,
                              GdkEventButton* event,
                              GdkCursorType cursor_type);
static gboolean _____lambda269__gsource_func (gpointer self);
static gboolean ___lambda268__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda270_ (WidgetsQuakeWindow* self,
                       GtkWidget* w,
                       GdkEventButton* e);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static gboolean ___lambda271_ (Block27Data* _data27_);
static gboolean ____lambda271__gsource_func (gpointer self);
static gboolean ___lambda270__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda272_ (WidgetsQuakeWindow* self,
                       GtkWidget* w,
                       cairo_t* cr);
VALA_EXTERN void widgets_quake_window_draw_window_widgets (WidgetsQuakeWindow* self,
                                               cairo_t* cr);
VALA_EXTERN void widgets_quake_window_draw_window_above (WidgetsQuakeWindow* self,
                                             cairo_t* cr);
static gboolean ___lambda272__gtk_widget_draw (GtkWidget* _sender,
                                        cairo_t* cr,
                                        gpointer self);
static void __lambda273_ (WidgetsQuakeWindow* self,
                   ConfigConfig* w);
static void ___lambda273__config_config_update (ConfigConfig* _sender,
                                         gpointer self);
VALA_EXTERN gdouble utils_get_default_monitor_scale (void);
VALA_EXTERN void widgets_quake_window_add_widget (WidgetsQuakeWindow* self,
                                      GtkWidget* widget);
VALA_EXTERN void widgets_quake_window_toggle_quake_window (WidgetsQuakeWindow* self);
VALA_EXTERN void widgets_quake_window_show_quake_window (WidgetsQuakeWindow* self,
                                             GdkRectangle* rect);
static gboolean ______lambda274_ (WidgetsQuakeWindow* self);
static gboolean _______lambda274__gsource_func (gpointer self);
VALA_EXTERN void widgets_quake_window_clean_style (WidgetsQuakeWindow* self);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void utils_propagate_draw (GtkContainer* widget,
                           cairo_t* cr);
VALA_EXTERN void widgets_config_window_draw_titlebar_underline (WidgetsConfigWindow* self,
                                                    cairo_t* cr,
                                                    gint x,
                                                    gint y,
                                                    gint width,
                                                    gint offset);
VALA_EXTERN void widgets_config_window_draw_active_tab_underline (WidgetsConfigWindow* self,
                                                      cairo_t* cr,
                                                      gint x,
                                                      gint y);
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN void widgets_quake_window_show_window (WidgetsQuakeWindow* self,
                                       WidgetsWorkspaceManager* workspace_manager,
                                       WidgetsTabbar* tabbar);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
VALA_EXTERN void widgets_config_window_init (WidgetsConfigWindow* self,
                                 WidgetsWorkspaceManager* manager,
                                 WidgetsTabbar* tabbar);
static void __lambda275_ (WidgetsQuakeWindow* self,
                   GtkWidget* t);
static void ___lambda275__gtk_widget_show (GtkWidget* _sender,
                                    gpointer self);
static gboolean __lambda276_ (Block28Data* _data28_,
                       GtkWidget* w,
                       cairo_t* cr);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
static gboolean ___lambda276__gtk_widget_draw (GtkWidget* _sender,
                                        cairo_t* cr,
                                        gpointer self);
static void widgets_quake_window_real_window_save_before_quit (WidgetsConfigWindow* base);
VALA_EXTERN void config_config_load_config (ConfigConfig* self);
VALA_EXTERN void config_config_save (ConfigConfig* self);
static GdkCursorType* widgets_quake_window_real_get_cursor_type (WidgetsConfigWindow* base,
                                                          gdouble x,
                                                          gdouble y);
static GdkCursorType* _gdk_cursor_type_dup (GdkCursorType* self);
static GdkCursorType* widgets_quake_window_real_get_frame_cursor_type (WidgetsConfigWindow* base,
                                                                gdouble x,
                                                                gdouble y);
static void widgets_quake_window_real_update_frame (WidgetsConfigWindow* base);
static void widgets_quake_window_finalize (GObject * obj);
static GType widgets_quake_window_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		WidgetsQuakeWindow* self;
		self = _data24_->self;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda263_ (Block24Data* _data24_,
              GtkWidget* w)
{
	WidgetsQuakeWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data24_->self;
	g_return_if_fail (w != NULL);
	widgets_config_window_update_frame ((WidgetsConfigWindow*) self);
	{
		gboolean quake_window_fullscreen = FALSE;
		ConfigConfig* _tmp0_;
		GKeyFile* _tmp1_;
		_tmp0_ = ((WidgetsConfigWindow*) self)->config;
		_tmp1_ = _tmp0_->config_file;
		quake_window_fullscreen = g_key_file_get_boolean (_tmp1_, "advanced", "quake_window_fullscreen", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (quake_window_fullscreen) {
			gtk_window_fullscreen ((GtkWindow*) self);
		} else {
			gdouble config_height = 0.0;
			ConfigConfig* _tmp2_;
			GKeyFile* _tmp3_;
			_tmp2_ = ((WidgetsConfigWindow*) self)->config;
			_tmp3_ = _tmp2_->config_file;
			config_height = g_key_file_get_double (_tmp3_, "advanced", "quake_window_height", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (config_height > self->window_max_height_scale) {
				config_height = self->window_max_height_scale;
			}
			if (config_height == ((gdouble) 0)) {
				GdkRectangle _tmp4_;
				GdkRectangle _tmp5_;
				_tmp4_ = _data24_->rect;
				_tmp5_ = _data24_->rect;
				gtk_window_set_default_size ((GtkWindow*) self, _tmp4_.width, (gint) (_tmp5_.height * self->window_default_height_scale));
			} else {
				GdkRectangle _tmp6_;
				GdkRectangle _tmp7_;
				_tmp6_ = _data24_->rect;
				_tmp7_ = _data24_->rect;
				gtk_window_set_default_size ((GtkWindow*) self, _tmp6_.width, (gint) (_tmp7_.height * MIN (config_height, 1.0)));
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_print ("QuakeWindow init: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda263__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda263_ (self, _sender);
}

static gboolean
__lambda264_ (WidgetsQuakeWindow* self,
              GdkEventFocus* w)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_quake_window_update_style (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda264__gtk_widget_focus_in_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda264_ ((WidgetsQuakeWindow*) self, event);
	return result;
}

static gboolean
_____lambda266_ (WidgetsQuakeWindow* self)
{
	GdkWindowState window_state = 0U;
	GdkWindow* _tmp0_;
	gboolean result;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	window_state = gdk_window_get_state (_tmp0_);
	if (!((window_state & GDK_WINDOW_STATE_WITHDRAWN) == GDK_WINDOW_STATE_WITHDRAWN)) {
		gtk_widget_hide ((GtkWidget*) self);
	}
	result = FALSE;
	return result;
}

static gboolean
______lambda266__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda266_ ((WidgetsQuakeWindow*) self);
	return result;
}

static gboolean
__lambda265_ (WidgetsQuakeWindow* self,
              GdkEventFocus* w)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_quake_window_update_style (self);
	{
		gboolean _tmp0_ = FALSE;
		ConfigConfig* _tmp1_;
		GKeyFile* _tmp2_;
		_tmp1_ = ((WidgetsConfigWindow*) self)->config;
		_tmp2_ = _tmp1_->config_file;
		_tmp0_ = g_key_file_get_boolean (_tmp2_, "advanced", "hide_quakewindow_after_lost_focus", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			if (((WidgetsConfigWindow*) self)->show_quake_menu) {
				((WidgetsConfigWindow*) self)->show_quake_menu = FALSE;
			} else {
				g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ______lambda266__gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_print ("quake_window focus_out_event: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda265__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda265_ ((WidgetsQuakeWindow*) self, event);
	return result;
}

static gboolean
__lambda267_ (WidgetsQuakeWindow* self,
              GdkEventConfigure* w)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	cairo_rectangle_int_t input_shape_rect = {0};
	GdkWindow* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GdkScreen* _tmp4_;
	cairo_region_t* shape = NULL;
	cairo_rectangle_int_t _tmp8_;
	cairo_region_t* _tmp9_;
	GdkWindow* _tmp10_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_frame_extents (_tmp2_, &_tmp3_);
	input_shape_rect = _tmp3_;
	_tmp4_ = ((WidgetsConfigWindow*) self)->screen_monitor;
	if (gdk_screen_is_composited (_tmp4_)) {
		GtkBox* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		input_shape_rect.x = 0;
		input_shape_rect.y = 0;
		input_shape_rect.width = width;
		_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		_tmp6_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		input_shape_rect.height = (height - _tmp7_) + constant_RESPONSE_RADIUS;
	}
	_tmp8_ = input_shape_rect;
	_tmp9_ = cairo_region_create_rectangle (&_tmp8_);
	shape = _tmp9_;
	_tmp10_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_input_shape_combine_region (_tmp10_, shape, 0, 0);
	widgets_quake_window_update_blur_status (self, FALSE);
	widgets_config_window_window_save_before_quit ((WidgetsConfigWindow*) self);
	result = FALSE;
	_cairo_region_destroy0 (shape);
	return result;
}

static gboolean
___lambda267__gtk_widget_configure_event (GtkWidget* _sender,
                                          GdkEventConfigure* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda267_ ((WidgetsQuakeWindow*) self, event);
	return result;
}

static GdkEventButton*
_vala_GdkEventButton_copy (GdkEventButton* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventButton_copy0 (gpointer self)
{
	return self ? _vala_GdkEventButton_copy (self) : NULL;
}

static void
_vala_GdkEventButton_free (GdkEventButton* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		WidgetsQuakeWindow* self;
		self = _data25_->self;
		__vala_GdkEventButton_free0 (_data25_->e);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		WidgetsQuakeWindow* self;
		self = _data26_->_data25_->self;
		_g_free0 (_data26_->cursor_type);
		block25_data_unref (_data26_->_data25_);
		_data26_->_data25_ = NULL;
		g_slice_free (Block26Data, _data26_);
	}
}

static gboolean
____lambda269_ (Block26Data* _data26_)
{
	Block25Data* _data25_;
	WidgetsQuakeWindow* self;
	gint pointer_x = 0;
	gint pointer_y = 0;
	GdkDevice* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	_data25_ = _data26_->_data25_;
	self = _data25_->self;
	_tmp0_ = _data25_->e->device;
	gdk_device_get_position (_tmp0_, NULL, &_tmp1_, &_tmp2_);
	pointer_x = _tmp1_;
	pointer_y = _tmp2_;
	if (pointer_x != self->press_x) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = pointer_y != self->press_y;
	}
	if (_tmp3_) {
		GdkCursorType* _tmp4_;
		_tmp4_ = _data26_->cursor_type;
		utils_resize_window ((GtkWidget*) self, _data25_->e, *_tmp4_);
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static gboolean
_____lambda269__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda269_ (self);
	return result;
}

static gboolean
__lambda268_ (WidgetsQuakeWindow* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	Block25Data* _data25_;
	GdkEventButton* _tmp0_;
	GdkScreen* _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEventButton_copy0 (e);
	__vala_GdkEventButton_free0 (_data25_->e);
	_data25_->e = _tmp0_;
	_tmp1_ = ((WidgetsConfigWindow*) self)->screen_monitor;
	if (!gdk_screen_is_composited (_tmp1_)) {
		Block26Data* _data26_;
		GdkCursorType* _tmp2_;
		GdkCursorType* _tmp3_;
		_data26_ = g_slice_new0 (Block26Data);
		_data26_->_ref_count_ = 1;
		_data26_->_data25_ = block25_data_ref (_data25_);
		_tmp2_ = widgets_config_window_get_frame_cursor_type ((WidgetsConfigWindow*) self, _data25_->e->x_root, _data25_->e->y_root);
		_data26_->cursor_type = _tmp2_;
		_tmp3_ = _data26_->cursor_type;
		if (_tmp3_ != NULL) {
			GdkDevice* _tmp4_;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp4_ = _data25_->e->device;
			gdk_device_get_position (_tmp4_, NULL, &_tmp5_, &_tmp6_);
			self->press_x = _tmp5_;
			self->press_y = _tmp6_;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _____lambda269__gsource_func, block26_data_ref (_data26_), block26_data_unref);
		}
		block26_data_unref (_data26_);
		_data26_ = NULL;
	}
	result = FALSE;
	block25_data_unref (_data25_);
	_data25_ = NULL;
	return result;
}

static gboolean
___lambda268__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda268_ ((WidgetsQuakeWindow*) self, _sender, event);
	return result;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		WidgetsQuakeWindow* self;
		self = _data27_->self;
		_g_free0 (_data27_->cursor_type);
		__vala_GdkEventButton_free0 (_data27_->e);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static gboolean
___lambda271_ (Block27Data* _data27_)
{
	WidgetsQuakeWindow* self;
	gint pointer_x = 0;
	gint pointer_y = 0;
	GdkDevice* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = _data27_->self;
	_tmp0_ = _data27_->e->device;
	gdk_device_get_position (_tmp0_, NULL, &_tmp1_, &_tmp2_);
	pointer_x = _tmp1_;
	pointer_y = _tmp2_;
	if (pointer_x != self->press_x) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = pointer_y != self->press_y;
	}
	if (_tmp3_) {
		GdkCursorType* _tmp4_;
		_tmp4_ = _data27_->cursor_type;
		utils_resize_window ((GtkWidget*) self, _data27_->e, *_tmp4_);
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static gboolean
____lambda271__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda271_ (self);
	return result;
}

static gboolean
__lambda270_ (WidgetsQuakeWindow* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	Block27Data* _data27_;
	GdkEventButton* _tmp0_;
	GdkCursorType* _tmp1_;
	GdkCursorType* _tmp2_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEventButton_copy0 (e);
	__vala_GdkEventButton_free0 (_data27_->e);
	_data27_->e = _tmp0_;
	_tmp1_ = widgets_config_window_get_cursor_type ((WidgetsConfigWindow*) self, _data27_->e->x_root, _data27_->e->y_root);
	_data27_->cursor_type = _tmp1_;
	_tmp2_ = _data27_->cursor_type;
	if (_tmp2_ != NULL) {
		GdkDevice* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = _data27_->e->device;
		gdk_device_get_position (_tmp3_, NULL, &_tmp4_, &_tmp5_);
		self->press_x = _tmp4_;
		self->press_y = _tmp5_;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ____lambda271__gsource_func, block27_data_ref (_data27_), block27_data_unref);
	}
	result = FALSE;
	block27_data_unref (_data27_);
	_data27_ = NULL;
	return result;
}

static gboolean
___lambda270__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda270_ ((WidgetsQuakeWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda272_ (WidgetsQuakeWindow* self,
              GtkWidget* w,
              cairo_t* cr)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	widgets_quake_window_draw_window_widgets (self, cr);
	widgets_quake_window_draw_window_above (self, cr);
	result = TRUE;
	return result;
}

static gboolean
___lambda272__gtk_widget_draw (GtkWidget* _sender,
                               cairo_t* cr,
                               gpointer self)
{
	gboolean result;
	result = __lambda272_ ((WidgetsQuakeWindow*) self, _sender, cr);
	return result;
}

static void
__lambda273_ (WidgetsQuakeWindow* self,
              ConfigConfig* w)
{
	g_return_if_fail (w != NULL);
	widgets_quake_window_update_style (self);
	widgets_quake_window_update_blur_status (self, TRUE);
}

static void
___lambda273__config_config_update (ConfigConfig* _sender,
                                    gpointer self)
{
	__lambda273_ ((WidgetsQuakeWindow*) self, _sender);
}

WidgetsQuakeWindow*
widgets_quake_window_construct (GType object_type)
{
	WidgetsQuakeWindow * self = NULL;
	Block24Data* _data24_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	gint monitor = 0;
	ConfigConfig* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	ConfigConfig* _tmp12_;
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	self = (WidgetsQuakeWindow*) widgets_config_window_construct (object_type);
	_data24_->self = g_object_ref (self);
	((WidgetsConfigWindow*) self)->quake_mode = TRUE;
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gdk_screen_get_rgba_visual (screen);
	gtk_widget_set_visual ((GtkWidget*) self, _tmp2_);
	_tmp3_ = ((WidgetsConfigWindow*) self)->config;
	monitor = config_config_get_terminal_monitor (_tmp3_);
	gdk_screen_get_monitor_geometry (screen, monitor, &_tmp4_);
	_data24_->rect = _tmp4_;
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_MENU);
	_tmp5_ = _data24_->rect;
	gtk_window_move ((GtkWindow*) self, _tmp5_.x, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (((WidgetsConfigWindow*) self)->window_frame_box);
	((WidgetsConfigWindow*) self)->window_frame_box = _tmp6_;
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (((WidgetsConfigWindow*) self)->window_widget_box);
	((WidgetsConfigWindow*) self)->window_widget_box = _tmp7_;
	_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp10_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, TRUE, TRUE, (guint) 0);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) ___lambda263__gtk_widget_realize, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) ___lambda264__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda265__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) ___lambda267__gtk_widget_configure_event, self, 0);
	_tmp11_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "button-press-event", (GCallback) ___lambda268__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda270__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) ___lambda272__gtk_widget_draw, self, G_CONNECT_AFTER);
	_tmp12_ = ((WidgetsConfigWindow*) self)->config;
	g_signal_connect_object (_tmp12_, "update", (GCallback) ___lambda273__config_config_update, self, 0);
	_g_object_unref0 (screen);
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return self;
}

WidgetsQuakeWindow*
widgets_quake_window_new (void)
{
	return widgets_quake_window_construct (WIDGETS_TYPE_QUAKE_WINDOW);
}

void
widgets_quake_window_update_blur_status (WidgetsQuakeWindow* self,
                                         gboolean force_update)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint width = 0;
		gint height = 0;
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
		width = _tmp0_;
		height = _tmp1_;
		if (width != ((WidgetsConfigWindow*) self)->resize_cache_width) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = height != ((WidgetsConfigWindow*) self)->resize_cache_height;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = force_update;
		}
		if (_tmp2_) {
			Display* xdisplay = NULL;
			GdkWindow* _tmp4_;
			GdkDisplay* _tmp5_;
			Display* _tmp6_;
			gint xid = 0;
			GdkWindow* _tmp7_;
			Atom atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED = {0};
			Display* _tmp8_;
			Atom atom_KDE_NET_WM_BLUR_BEHIND_REGION = {0};
			Display* _tmp9_;
			gboolean blur_background = FALSE;
			ConfigConfig* _tmp10_;
			GKeyFile* _tmp11_;
			((WidgetsConfigWindow*) self)->resize_cache_width = width;
			((WidgetsConfigWindow*) self)->resize_cache_height = height;
			_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp5_ = gdk_window_get_display (_tmp4_);
			_tmp6_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp5_) : NULL);
			xdisplay = _tmp6_;
			_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
			xid = (gint) gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gdk_x11_window_get_type (), GdkX11Window));
			_tmp8_ = xdisplay;
			atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED = XInternAtom (_tmp8_, "_NET_WM_DEEPIN_BLUR_REGION_ROUNDED", FALSE);
			_tmp9_ = xdisplay;
			atom_KDE_NET_WM_BLUR_BEHIND_REGION = XInternAtom (_tmp9_, "_KDE_NET_WM_BLUR_BEHIND_REGION", FALSE);
			_tmp10_ = ((WidgetsConfigWindow*) self)->config;
			_tmp11_ = _tmp10_->config_file;
			blur_background = g_key_file_get_boolean (_tmp11_, "advanced", "blur_background", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (blur_background) {
				cairo_rectangle_int_t blur_rect = {0};
				GdkWindow* _tmp12_;
				GdkRectangle _tmp13_ = {0};
				GdkScreen* _tmp14_;
				cairo_rectangle_int_t _tmp18_;
				cairo_rectangle_int_t _tmp24_;
				cairo_rectangle_int_t _tmp25_;
				cairo_rectangle_int_t _tmp26_;
				cairo_rectangle_int_t _tmp27_;
				gulong* data = NULL;
				cairo_rectangle_int_t _tmp28_;
				cairo_rectangle_int_t _tmp29_;
				cairo_rectangle_int_t _tmp30_;
				cairo_rectangle_int_t _tmp31_;
				gulong* _tmp32_;
				gint data_length1;
				gint _data_size_;
				Display* _tmp33_;
				gulong* _tmp34_;
				gint _tmp34__length1;
				gulong* _tmp35_;
				gint _tmp35__length1;
				Display* _tmp36_;
				gulong* _tmp37_;
				gint _tmp37__length1;
				gulong* _tmp38_;
				gint _tmp38__length1;
				_tmp12_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_get_frame_extents (_tmp12_, &_tmp13_);
				blur_rect = _tmp13_;
				_tmp14_ = ((WidgetsConfigWindow*) self)->screen_monitor;
				if (gdk_screen_is_composited (_tmp14_)) {
					GtkBox* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					blur_rect.x = 0;
					blur_rect.y = 0;
					blur_rect.width = width;
					_tmp15_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp16_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp15_);
					_tmp17_ = _tmp16_;
					blur_rect.height = height - _tmp17_;
				}
				_tmp18_ = blur_rect;
				if (_tmp18_.width < 0) {
					cairo_rectangle_int_t _tmp19_;
					GtkBox* _tmp20_;
					GtkBox* _tmp21_;
					GtkBox* _tmp22_;
					GtkBox* _tmp23_;
					_tmp19_ = blur_rect;
					g_print ("[!!!] blur_rect calc result error! blur_rect.width = %d which is negat" \
"ive!\n", _tmp19_.width);
					_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp21_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect.width = (width - gtk_widget_get_margin_left ((GtkWidget*) _tmp20_)) - gtk_widget_get_margin_right ((GtkWidget*) _tmp21_);
					_tmp22_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					_tmp23_ = ((WidgetsConfigWindow*) self)->window_frame_box;
					blur_rect.height = (height - gtk_widget_get_margin_top ((GtkWidget*) _tmp22_)) - gtk_widget_get_margin_bottom ((GtkWidget*) _tmp23_);
				}
				_tmp24_ = blur_rect;
				blur_rect.x = (gint) (_tmp24_.x * utils_get_default_monitor_scale ());
				_tmp25_ = blur_rect;
				blur_rect.y = (gint) (_tmp25_.y * utils_get_default_monitor_scale ());
				_tmp26_ = blur_rect;
				blur_rect.width = (gint) (_tmp26_.width * utils_get_default_monitor_scale ());
				_tmp27_ = blur_rect;
				blur_rect.height = (gint) (_tmp27_.height * utils_get_default_monitor_scale ());
				_tmp28_ = blur_rect;
				_tmp29_ = blur_rect;
				_tmp30_ = blur_rect;
				_tmp31_ = blur_rect;
				_tmp32_ = g_new0 (gulong, 6);
				_tmp32_[0] = (gulong) _tmp28_.x;
				_tmp32_[1] = (gulong) _tmp29_.y;
				_tmp32_[2] = (gulong) _tmp30_.width;
				_tmp32_[3] = (gulong) _tmp31_.height;
				_tmp32_[4] = (gulong) 8;
				_tmp32_[5] = (gulong) 8;
				data = _tmp32_;
				data_length1 = 6;
				_data_size_ = data_length1;
				_tmp33_ = xdisplay;
				_tmp34_ = data;
				_tmp34__length1 = data_length1;
				_tmp35_ = data;
				_tmp35__length1 = data_length1;
				XChangeProperty (_tmp33_, (Window) xid, atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED, XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp34_, (_tmp35__length1 * sizeof (gulong)) / sizeof (gulong));
				_tmp36_ = xdisplay;
				_tmp37_ = data;
				_tmp37__length1 = data_length1;
				_tmp38_ = data;
				_tmp38__length1 = data_length1;
				XChangeProperty (_tmp36_, (Window) xid, atom_KDE_NET_WM_BLUR_BEHIND_REGION, XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) _tmp37_, ((_tmp38__length1 * sizeof (gulong)) / sizeof (gulong)) - 2);
				data = (g_free (data), NULL);
			} else {
				Display* _tmp39_;
				Display* _tmp40_;
				_tmp39_ = xdisplay;
				XDeleteProperty (_tmp39_, (Window) xid, atom_NET_WM_DEEPIN_BLUR_REGION_ROUNDED);
				_tmp40_ = xdisplay;
				XDeleteProperty (_tmp40_, (Window) xid, atom_KDE_NET_WM_BLUR_BEHIND_REGION);
			}
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_print ("%s\n", _tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
widgets_quake_window_add_widget (WidgetsQuakeWindow* self,
                                 GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_widget_box;
	gtk_box_pack_start (_tmp0_, widget, TRUE, TRUE, (guint) 0);
}

static gboolean
______lambda274_ (WidgetsQuakeWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		GdkWindow* _tmp2_;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		gtk_window_present_with_time ((GtkWindow*) self, gdk_x11_get_server_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_x11_window_get_type (), GdkX11Window)));
	}
	result = FALSE;
	return result;
}

static gboolean
_______lambda274__gsource_func (gpointer self)
{
	gboolean result;
	result = ______lambda274_ ((WidgetsQuakeWindow*) self);
	return result;
}

void
widgets_quake_window_toggle_quake_window (WidgetsQuakeWindow* self)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	gint monitor = 0;
	ConfigConfig* _tmp2_;
	gint window_monitor = 0;
	GdkScreen* _tmp3_;
	GdkWindow* _tmp4_;
	GdkRectangle rect = {0};
	GdkScreen* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = ((WidgetsConfigWindow*) self)->config;
	monitor = config_config_get_terminal_monitor (_tmp2_);
	_tmp3_ = screen;
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
	window_monitor = gdk_screen_get_monitor_at_window (_tmp3_, _tmp4_);
	_tmp5_ = screen;
	gdk_screen_get_monitor_geometry (_tmp5_, monitor, &_tmp6_);
	rect = _tmp6_;
	if (monitor == window_monitor) {
		GdkWindowState window_state = 0U;
		GdkWindow* _tmp7_;
		_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
		window_state = gdk_window_get_state (_tmp7_);
		if ((window_state & GDK_WINDOW_STATE_WITHDRAWN) == GDK_WINDOW_STATE_WITHDRAWN) {
			GdkRectangle _tmp8_;
			_tmp8_ = rect;
			widgets_quake_window_show_quake_window (self, &_tmp8_);
		} else {
			{
				gboolean _tmp9_ = FALSE;
				ConfigConfig* _tmp10_;
				GKeyFile* _tmp11_;
				_tmp10_ = ((WidgetsConfigWindow*) self)->config;
				_tmp11_ = _tmp10_->config_file;
				_tmp9_ = g_key_file_get_boolean (_tmp11_, "advanced", "hide_quakewindow_when_active", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (_tmp9_) {
					g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _______lambda274__gsource_func, g_object_ref (self), g_object_unref);
				} else {
					gtk_widget_hide ((GtkWidget*) self);
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				const gchar* _tmp13_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = e;
				_tmp13_ = _tmp12_->message;
				g_print ("quake_window toggle_quake_window: %s\n", _tmp13_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (screen);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		GdkRectangle _tmp14_;
		_tmp14_ = rect;
		widgets_quake_window_show_quake_window (self, &_tmp14_);
	}
	_g_object_unref0 (screen);
}

void
widgets_quake_window_show_quake_window (WidgetsQuakeWindow* self,
                                        GdkRectangle* rect)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkWindow* _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = *rect;
	_tmp4_ = *rect;
	gdk_window_move_resize (_tmp2_, _tmp3_.x, 0, _tmp4_.width, height);
	gtk_window_present ((GtkWindow*) self);
}

void
widgets_quake_window_update_style (WidgetsQuakeWindow* self)
{
	gboolean is_light_theme = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	widgets_quake_window_clean_style (self);
	is_light_theme = widgets_config_window_is_light_theme ((WidgetsConfigWindow*) self);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (is_light_theme) {
			GdkScreen* _tmp2_;
			_tmp2_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp2_)) {
				GtkBox* _tmp3_;
				GtkStyleContext* _tmp4_;
				_tmp3_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
				gtk_style_context_add_class (_tmp4_, "window_light_shadow_active");
			} else {
				GtkBox* _tmp5_;
				GtkStyleContext* _tmp6_;
				_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
				gtk_style_context_add_class (_tmp6_, "window_light_noshadow_active");
			}
		} else {
			GdkScreen* _tmp7_;
			_tmp7_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp7_)) {
				GtkBox* _tmp8_;
				GtkStyleContext* _tmp9_;
				_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
				gtk_style_context_add_class (_tmp9_, "window_dark_shadow_active");
			} else {
				GtkBox* _tmp10_;
				GtkStyleContext* _tmp11_;
				_tmp10_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
				gtk_style_context_add_class (_tmp11_, "window_dark_noshadow_active");
			}
		}
	} else {
		if (is_light_theme) {
			GdkScreen* _tmp12_;
			_tmp12_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp12_)) {
				GtkBox* _tmp13_;
				GtkStyleContext* _tmp14_;
				_tmp13_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
				gtk_style_context_add_class (_tmp14_, "window_light_shadow_inactive");
			} else {
				GtkBox* _tmp15_;
				GtkStyleContext* _tmp16_;
				_tmp15_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
				gtk_style_context_add_class (_tmp16_, "window_light_noshadow_inactive");
			}
		} else {
			GdkScreen* _tmp17_;
			_tmp17_ = ((WidgetsConfigWindow*) self)->screen_monitor;
			if (gdk_screen_is_composited (_tmp17_)) {
				GtkBox* _tmp18_;
				GtkStyleContext* _tmp19_;
				_tmp18_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
				gtk_style_context_add_class (_tmp19_, "window_dark_shadow_inactive");
			} else {
				GtkBox* _tmp20_;
				GtkStyleContext* _tmp21_;
				_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
				_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
				gtk_style_context_add_class (_tmp21_, "window_dark_noshadow_inactive");
			}
		}
	}
}

void
widgets_quake_window_clean_style (WidgetsQuakeWindow* self)
{
	GtkBox* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBox* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkBox* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkBox* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBox* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkBox* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkBox* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkBox* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkBox* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkBox* _tmp22_;
	GtkStyleContext* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "window_light_shadow_inactive");
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "window_dark_shadow_inactive");
	_tmp4_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_remove_class (_tmp5_, "window_light_shadow_active");
	_tmp6_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_remove_class (_tmp7_, "window_dark_shadow_active");
	_tmp8_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_remove_class (_tmp9_, "window_noradius_shadow_inactive");
	_tmp10_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_remove_class (_tmp11_, "window_noradius_shadow_active");
	_tmp12_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_remove_class (_tmp13_, "window_light_noshadow_inactive");
	_tmp14_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_remove_class (_tmp15_, "window_dark_noshadow_inactive");
	_tmp16_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_remove_class (_tmp17_, "window_light_noshadow_active");
	_tmp18_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_remove_class (_tmp19_, "window_dark_noshadow_active");
	_tmp20_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_remove_class (_tmp21_, "window_noradius_noshadow_inactive");
	_tmp22_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_remove_class (_tmp23_, "window_noradius_noshadow_active");
}

void
widgets_quake_window_draw_window_widgets (WidgetsQuakeWindow* self,
                                          cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	utils_propagate_draw ((GtkContainer*) self, cr);
}

void
widgets_quake_window_draw_window_above (WidgetsQuakeWindow* self,
                                        cairo_t* cr)
{
	GtkAllocation window_frame_rect = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint x = 0;
	GtkBox* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint y = 0;
	GtkBox* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint width = 0;
	GtkAllocation _tmp8_;
	gint height = 0;
	GtkAllocation _tmp9_;
	gint titlebar_y = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	window_frame_rect = _tmp1_;
	_tmp2_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp3_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	x = _tmp4_;
	_tmp5_ = ((WidgetsConfigWindow*) self)->window_frame_box;
	_tmp6_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp5_);
	_tmp7_ = _tmp6_;
	y = _tmp7_;
	_tmp8_ = window_frame_rect;
	width = _tmp8_.width;
	_tmp9_ = window_frame_rect;
	height = _tmp9_.height;
	titlebar_y = y;
	if (gtk_widget_get_scale_factor ((GtkWidget*) self) > 1) {
		titlebar_y += 1;
	}
	widgets_config_window_draw_titlebar_underline ((WidgetsConfigWindow*) self, cr, x, (titlebar_y + height) - constant_TITLEBAR_HEIGHT, width, -1);
	widgets_config_window_draw_active_tab_underline ((WidgetsConfigWindow*) self, cr, x + ((WidgetsConfigWindow*) self)->active_tab_underline_x, (titlebar_y + height) - constant_TITLEBAR_HEIGHT);
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		WidgetsQuakeWindow* self;
		self = _data28_->self;
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda275_ (WidgetsQuakeWindow* self,
              GtkWidget* t)
{
	g_return_if_fail (t != NULL);
	gtk_window_present ((GtkWindow*) self);
}

static void
___lambda275__gtk_widget_show (GtkWidget* _sender,
                               gpointer self)
{
	__lambda275_ ((WidgetsQuakeWindow*) self, _sender);
}

static gboolean
__lambda276_ (Block28Data* _data28_,
              GtkWidget* w,
              cairo_t* cr)
{
	WidgetsQuakeWindow* self;
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GtkBox* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data28_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (w, &_tmp0_);
	rect = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		ConfigConfig* _tmp2_;
		GKeyFile* _tmp3_;
		gchar* _tmp4_;
		GdkRGBA _tmp5_ = {0};
		gdouble _tmp6_ = 0.0;
		ConfigConfig* _tmp7_;
		GKeyFile* _tmp8_;
		GdkRGBA _tmp9_;
		GdkRGBA _tmp10_;
		GdkRGBA _tmp11_;
		GtkAllocation _tmp12_;
		_tmp2_ = ((WidgetsConfigWindow*) self)->config;
		_tmp3_ = _tmp2_->config_file;
		_tmp4_ = g_key_file_get_string (_tmp3_, "theme", "background", &_inner_error0_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp1_, 1.0, &_tmp5_);
		_data28_->background_color = _tmp5_;
		_tmp7_ = ((WidgetsConfigWindow*) self)->config;
		_tmp8_ = _tmp7_->config_file;
		_tmp6_ = g_key_file_get_double (_tmp8_, "general", "opacity", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp9_ = _data28_->background_color;
		_tmp10_ = _data28_->background_color;
		_tmp11_ = _data28_->background_color;
		cairo_set_source_rgba (cr, _tmp9_.red, _tmp10_.green, _tmp11_.blue, _tmp6_);
		_tmp12_ = rect;
		draw_draw_rectangle (cr, 0, 0, _tmp12_.width, constant_TITLEBAR_HEIGHT, TRUE);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_print ("Main quake mode: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = ((WidgetsConfigWindow*) self)->top_box;
	utils_propagate_draw ((GtkContainer*) _tmp16_, cr);
	result = TRUE;
	return result;
}

static gboolean
___lambda276__gtk_widget_draw (GtkWidget* _sender,
                               cairo_t* cr,
                               gpointer self)
{
	gboolean result;
	result = __lambda276_ (self, _sender, cr);
	return result;
}

void
widgets_quake_window_show_window (WidgetsQuakeWindow* self,
                                  WidgetsWorkspaceManager* workspace_manager,
                                  WidgetsTabbar* tabbar)
{
	Block28Data* _data28_;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace_manager != NULL);
	g_return_if_fail (tabbar != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	memset (&_data28_->background_color, 0, sizeof (GdkRGBA));
	widgets_config_window_init ((WidgetsConfigWindow*) self, workspace_manager, tabbar);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) ___lambda275__gtk_widget_show, self, 0);
	_tmp0_ = ((WidgetsConfigWindow*) self)->top_box;
	g_signal_connect_data ((GtkWidget*) _tmp0_, "draw", (GCallback) ___lambda276__gtk_widget_draw, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	_tmp1_ = ((WidgetsConfigWindow*) self)->top_box;
	gtk_box_pack_start (_tmp1_, (GtkWidget*) tabbar, TRUE, TRUE, (guint) 0);
	_tmp2_ = ((WidgetsConfigWindow*) self)->box;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) workspace_manager, TRUE, TRUE, (guint) 0);
	{
		gboolean _tmp3_ = FALSE;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		_tmp4_ = ((WidgetsConfigWindow*) self)->config;
		_tmp5_ = _tmp4_->config_file;
		_tmp3_ = g_key_file_get_boolean (_tmp5_, "advanced", "show_quakewindow_tab", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp3_) {
			GtkBox* _tmp6_;
			GtkBox* _tmp7_;
			_tmp6_ = ((WidgetsConfigWindow*) self)->box;
			_tmp7_ = ((WidgetsConfigWindow*) self)->top_box;
			gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_print ("Main quake mode: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block28_data_unref (_data28_);
		_data28_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = ((WidgetsConfigWindow*) self)->box;
	widgets_quake_window_add_widget (self, (GtkWidget*) _tmp10_);
	gtk_widget_show_all ((GtkWidget*) self);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static void
widgets_quake_window_real_window_save_before_quit (WidgetsConfigWindow* base)
{
	WidgetsQuakeWindow * self;
	gint monitor = 0;
	ConfigConfig* _tmp0_;
	GdkRectangle rect = {0};
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gint width = 0;
	gint height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ConfigConfig* _tmp6_;
	ConfigConfig* _tmp7_;
	GKeyFile* _tmp8_;
	GdkRectangle _tmp9_;
	ConfigConfig* _tmp10_;
	self = (WidgetsQuakeWindow*) base;
	_tmp0_ = ((WidgetsConfigWindow*) self)->config;
	monitor = config_config_get_terminal_monitor (_tmp0_);
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	gdk_screen_get_monitor_geometry (_tmp2_, monitor, &_tmp3_);
	rect = _tmp3_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	width = _tmp4_;
	height = _tmp5_;
	_tmp6_ = ((WidgetsConfigWindow*) self)->config;
	config_config_load_config (_tmp6_);
	_tmp7_ = ((WidgetsConfigWindow*) self)->config;
	_tmp8_ = _tmp7_->config_file;
	_tmp9_ = rect;
	g_key_file_set_double (_tmp8_, "advanced", "quake_window_height", (height * 1.0) / _tmp9_.height);
	_tmp10_ = ((WidgetsConfigWindow*) self)->config;
	config_config_save (_tmp10_);
}

static GdkCursorType*
_gdk_cursor_type_dup (GdkCursorType* self)
{
	GdkCursorType* dup;
	dup = g_new0 (GdkCursorType, 1);
	memcpy (dup, self, sizeof (GdkCursorType));
	return dup;
}

static gpointer
__gdk_cursor_type_dup0 (gpointer self)
{
	return self ? _gdk_cursor_type_dup (self) : NULL;
}

static GdkCursorType*
widgets_quake_window_real_get_cursor_type (WidgetsConfigWindow* base,
                                           gdouble x,
                                           gdouble y)
{
	WidgetsQuakeWindow * self;
	gint window_x = 0;
	gint window_y = 0;
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint bottom_side_start = 0;
	gint bottom_side_end = 0;
	gboolean _tmp5_ = FALSE;
	GdkCursorType* result;
	self = (WidgetsQuakeWindow*) base;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp0_, &_tmp1_, &_tmp2_);
	window_x = _tmp1_;
	window_y = _tmp2_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	bottom_side_start = (window_y + height) - self->window_frame_margin_bottom;
	bottom_side_end = ((window_y + height) - self->window_frame_margin_bottom) + constant_RESPONSE_RADIUS;
	if (y > ((gdouble) bottom_side_start)) {
		_tmp5_ = y < ((gdouble) bottom_side_end);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GdkCursorType _tmp6_;
		GdkCursorType* _tmp7_;
		_tmp6_ = GDK_BOTTOM_SIDE;
		_tmp7_ = __gdk_cursor_type_dup0 (&_tmp6_);
		result = _tmp7_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static GdkCursorType*
widgets_quake_window_real_get_frame_cursor_type (WidgetsConfigWindow* base,
                                                 gdouble x,
                                                 gdouble y)
{
	WidgetsQuakeWindow * self;
	gint window_x = 0;
	gint window_y = 0;
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint bottom_side_start = 0;
	gint bottom_side_end = 0;
	gboolean _tmp5_ = FALSE;
	GdkCursorType* result;
	self = (WidgetsQuakeWindow*) base;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp0_, &_tmp1_, &_tmp2_);
	window_x = _tmp1_;
	window_y = _tmp2_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	bottom_side_start = (window_y + height) - constant_RESPONSE_RADIUS;
	bottom_side_end = window_y + height;
	if (y > ((gdouble) bottom_side_start)) {
		_tmp5_ = y < ((gdouble) bottom_side_end);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GdkCursorType _tmp6_;
		GdkCursorType* _tmp7_;
		_tmp6_ = GDK_BOTTOM_SIDE;
		_tmp7_ = __gdk_cursor_type_dup0 (&_tmp6_);
		result = _tmp7_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static void
widgets_quake_window_real_update_frame (WidgetsConfigWindow* base)
{
	WidgetsQuakeWindow * self;
	GdkScreen* _tmp0_;
	self = (WidgetsQuakeWindow*) base;
	widgets_quake_window_update_style (self);
	_tmp0_ = ((WidgetsConfigWindow*) self)->screen_monitor;
	if (gdk_screen_is_composited (_tmp0_)) {
		GtkBox* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp1_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, self->window_frame_margin_bottom);
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_shadow_width (_tmp2_, 0, 0, 0, self->window_frame_margin_bottom);
	} else {
		GtkBox* _tmp3_;
		GdkWindow* _tmp4_;
		_tmp3_ = ((WidgetsConfigWindow*) self)->window_frame_box;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 0);
		_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_shadow_width (_tmp4_, 0, 0, 0, 0);
	}
}

static void
widgets_quake_window_class_init (WidgetsQuakeWindowClass * klass,
                                 gpointer klass_data)
{
	widgets_quake_window_parent_class = g_type_class_peek_parent (klass);
	((WidgetsConfigWindowClass *) klass)->window_save_before_quit = (void (*) (WidgetsConfigWindow*)) widgets_quake_window_real_window_save_before_quit;
	((WidgetsConfigWindowClass *) klass)->get_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_quake_window_real_get_cursor_type;
	((WidgetsConfigWindowClass *) klass)->get_frame_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_quake_window_real_get_frame_cursor_type;
	((WidgetsConfigWindowClass *) klass)->update_frame = (void (*) (WidgetsConfigWindow*)) widgets_quake_window_real_update_frame;
	G_OBJECT_CLASS (klass)->finalize = widgets_quake_window_finalize;
}

static void
widgets_quake_window_instance_init (WidgetsQuakeWindow * self,
                                    gpointer klass)
{
	self->window_default_height_scale = 0.3;
	self->window_max_height_scale = 0.7;
	self->window_frame_margin_bottom = 60;
}

static void
widgets_quake_window_finalize (GObject * obj)
{
	WidgetsQuakeWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_QUAKE_WINDOW, WidgetsQuakeWindow);
	G_OBJECT_CLASS (widgets_quake_window_parent_class)->finalize (obj);
}

static GType
widgets_quake_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsQuakeWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_quake_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsQuakeWindow), 0, (GInstanceInitFunc) widgets_quake_window_instance_init, NULL };
	GType widgets_quake_window_type_id;
	widgets_quake_window_type_id = g_type_register_static (WIDGETS_TYPE_CONFIG_WINDOW, "WidgetsQuakeWindow", &g_define_type_info, 0);
	return widgets_quake_window_type_id;
}

GType
widgets_quake_window_get_type (void)
{
	static volatile gsize widgets_quake_window_type_id__once = 0;
	if (g_once_init_enter (&widgets_quake_window_type_id__once)) {
		GType widgets_quake_window_type_id;
		widgets_quake_window_type_id = widgets_quake_window_get_type_once ();
		g_once_init_leave (&widgets_quake_window_type_id__once, widgets_quake_window_type_id);
	}
	return widgets_quake_window_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

