/* entry_menu.c generated by valac 0.56.17, the Vala compiler
 * generated from entry_menu.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_ENTRY_MENU (widgets_entry_menu_get_type ())
#define WIDGETS_ENTRY_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENTRY_MENU, WidgetsEntryMenu))
#define WIDGETS_ENTRY_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENTRY_MENU, WidgetsEntryMenuClass))
#define WIDGETS_IS_ENTRY_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENTRY_MENU))
#define WIDGETS_IS_ENTRY_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENTRY_MENU))
#define WIDGETS_ENTRY_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENTRY_MENU, WidgetsEntryMenuClass))

typedef struct _WidgetsEntryMenu WidgetsEntryMenu;
typedef struct _WidgetsEntryMenuClass WidgetsEntryMenuClass;
typedef struct _WidgetsEntryMenuPrivate WidgetsEntryMenuPrivate;

#define MENU_TYPE_MENU (menu_menu_get_type ())
#define MENU_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU, MenuMenu))
#define MENU_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU, MenuMenuClass))
#define MENU_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU))
#define MENU_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU))
#define MENU_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU, MenuMenuClass))

typedef struct _MenuMenu MenuMenu;
typedef struct _MenuMenuClass MenuMenuClass;
enum  {
	WIDGETS_ENTRY_MENU_0_PROPERTY,
	WIDGETS_ENTRY_MENU_NUM_PROPERTIES
};
static GParamSpec* widgets_entry_menu_properties[WIDGETS_ENTRY_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;

#define MENU_TYPE_MENU_ITEM (menu_menu_item_get_type ())
#define MENU_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU_ITEM, MenuMenuItem))
#define MENU_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU_ITEM, MenuMenuItemClass))
#define MENU_IS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU_ITEM))
#define MENU_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU_ITEM))
#define MENU_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU_ITEM, MenuMenuItemClass))

typedef struct _MenuMenuItem MenuMenuItem;
typedef struct _MenuMenuItemClass MenuMenuItemClass;

struct _WidgetsEntryMenu {
	GObject parent_instance;
	WidgetsEntryMenuPrivate * priv;
	MenuMenu* menu;
};

struct _WidgetsEntryMenuClass {
	GObjectClass parent_class;
};

struct _Block14Data {
	int _ref_count_;
	WidgetsEntryMenu* self;
	GtkEntry* entry;
};

static gpointer widgets_entry_menu_parent_class = NULL;

VALA_EXTERN GType widgets_entry_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEntryMenu, g_object_unref)
VALA_EXTERN GType menu_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenu, g_object_unref)
VALA_EXTERN WidgetsEntryMenu* widgets_entry_menu_new (void);
VALA_EXTERN WidgetsEntryMenu* widgets_entry_menu_construct (GType object_type);
VALA_EXTERN void widgets_entry_menu_create_entry_menu (WidgetsEntryMenu* self,
                                           GtkEntry* entry,
                                           gint x,
                                           gint y);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN GType menu_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenuItem, g_object_unref)
VALA_EXTERN gboolean widgets_entry_menu_is_selection (WidgetsEntryMenu* self,
                                          GtkEntry* entry);
VALA_EXTERN MenuMenuItem* menu_menu_item_new (const gchar* item_id,
                                  const gchar* item_text);
VALA_EXTERN MenuMenuItem* menu_menu_item_construct (GType object_type,
                                        const gchar* item_id,
                                        const gchar* item_text);
VALA_EXTERN MenuMenu* menu_menu_new (void);
VALA_EXTERN MenuMenu* menu_menu_construct (GType object_type);
static void __lambda25_ (Block14Data* _data14_,
                  const gchar* item_id);
VALA_EXTERN void widgets_entry_menu_handle_menu_item_click (WidgetsEntryMenu* self,
                                                GtkEntry* entry,
                                                const gchar* item_id);
static void ___lambda25__menu_menu_click_item (MenuMenu* _sender,
                                        const gchar* item_id,
                                        gpointer self);
VALA_EXTERN void widgets_entry_menu_handle_menu_destroy (WidgetsEntryMenu* self);
static void _widgets_entry_menu_handle_menu_destroy_menu_menu_destroy (MenuMenu* _sender,
                                                                gpointer self);
VALA_EXTERN void menu_menu_popup_at_position (MenuMenu* self,
                                  GList* menu_content,
                                  gint x,
                                  gint y);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void widgets_entry_menu_finalize (GObject * obj);
static GType widgets_entry_menu_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

WidgetsEntryMenu*
widgets_entry_menu_construct (GType object_type)
{
	WidgetsEntryMenu * self = NULL;
	self = (WidgetsEntryMenu*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	return self;
}

WidgetsEntryMenu*
widgets_entry_menu_new (void)
{
	return widgets_entry_menu_construct (WIDGETS_TYPE_ENTRY_MENU);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		WidgetsEntryMenu* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda25_ (Block14Data* _data14_,
             const gchar* item_id)
{
	WidgetsEntryMenu* self;
	self = _data14_->self;
	g_return_if_fail (item_id != NULL);
	widgets_entry_menu_handle_menu_item_click (self, _data14_->entry, item_id);
}

static void
___lambda25__menu_menu_click_item (MenuMenu* _sender,
                                   const gchar* item_id,
                                   gpointer self)
{
	__lambda25_ (self, item_id);
}

static void
_widgets_entry_menu_handle_menu_destroy_menu_menu_destroy (MenuMenu* _sender,
                                                           gpointer self)
{
	widgets_entry_menu_handle_menu_destroy ((WidgetsEntryMenu*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
widgets_entry_menu_create_entry_menu (WidgetsEntryMenu* self,
                                      GtkEntry* entry,
                                      gint x,
                                      gint y)
{
	Block14Data* _data14_;
	GtkEntry* _tmp0_;
	GList* menu_content = NULL;
	MenuMenuItem* _tmp3_;
	MenuMenuItem* _tmp4_;
	MenuMenuItem* _tmp7_;
	MenuMenu* _tmp8_;
	MenuMenu* _tmp9_;
	MenuMenu* _tmp10_;
	MenuMenu* _tmp11_;
	GList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (entry);
	_g_object_unref0 (_data14_->entry);
	_data14_->entry = _tmp0_;
	menu_content = NULL;
	if (widgets_entry_menu_is_selection (self, _data14_->entry)) {
		MenuMenuItem* _tmp1_;
		MenuMenuItem* _tmp2_;
		_tmp1_ = menu_menu_item_new ("cut", _ ("Cut"));
		menu_content = g_list_append (menu_content, _tmp1_);
		_tmp2_ = menu_menu_item_new ("copy", _ ("Copy"));
		menu_content = g_list_append (menu_content, _tmp2_);
	}
	_tmp3_ = menu_menu_item_new ("paste", _ ("Paste"));
	menu_content = g_list_append (menu_content, _tmp3_);
	_tmp4_ = menu_menu_item_new ("", "");
	menu_content = g_list_append (menu_content, _tmp4_);
	if (widgets_entry_menu_is_selection (self, _data14_->entry)) {
		MenuMenuItem* _tmp5_;
		MenuMenuItem* _tmp6_;
		_tmp5_ = menu_menu_item_new ("delete", _ ("Delete"));
		menu_content = g_list_append (menu_content, _tmp5_);
		_tmp6_ = menu_menu_item_new ("", "");
		menu_content = g_list_append (menu_content, _tmp6_);
	}
	_tmp7_ = menu_menu_item_new ("select_all", _ ("Select all"));
	menu_content = g_list_append (menu_content, _tmp7_);
	_tmp8_ = menu_menu_new ();
	_g_object_unref0 (self->menu);
	self->menu = _tmp8_;
	_tmp9_ = self->menu;
	g_signal_connect_data (_tmp9_, "click-item", (GCallback) ___lambda25__menu_menu_click_item, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp10_ = self->menu;
	g_signal_connect_object (_tmp10_, "destroy", (GCallback) _widgets_entry_menu_handle_menu_destroy_menu_menu_destroy, self, 0);
	_tmp11_ = self->menu;
	_tmp12_ = menu_content;
	menu_menu_popup_at_position (_tmp11_, _tmp12_, x, y);
	(menu_content == NULL) ? NULL : (menu_content = (_g_list_free__g_object_unref0_ (menu_content), NULL));
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

void
widgets_entry_menu_handle_menu_item_click (WidgetsEntryMenu* self,
                                           GtkEntry* entry,
                                           const gchar* item_id)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (item_id != NULL);
	_tmp0_ = item_id;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("cut")))) {
		switch (0) {
			default:
			{
				g_signal_emit_by_name (entry, "cut-clipboard");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("copy")))) {
		switch (0) {
			default:
			{
				g_signal_emit_by_name (entry, "copy-clipboard");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("paste")))) {
		switch (0) {
			default:
			{
				g_signal_emit_by_name (entry, "paste-clipboard");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("delete")))) {
		switch (0) {
			default:
			{
				gtk_editable_delete_selection ((GtkEditable*) entry);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("select_all")))) {
		switch (0) {
			default:
			{
				gtk_editable_select_region ((GtkEditable*) entry, 0, -1);
				break;
			}
		}
	}
}

gboolean
widgets_entry_menu_is_selection (WidgetsEntryMenu* self,
                                 GtkEntry* entry)
{
	gint start_pos = 0;
	gint end_pos = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	gtk_editable_get_selection_bounds ((GtkEditable*) entry, &_tmp0_, &_tmp1_);
	start_pos = _tmp0_;
	end_pos = _tmp1_;
	result = start_pos != end_pos;
	return result;
}

void
widgets_entry_menu_handle_menu_destroy (WidgetsEntryMenu* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->menu);
	self->menu = NULL;
}

static void
widgets_entry_menu_class_init (WidgetsEntryMenuClass * klass,
                               gpointer klass_data)
{
	widgets_entry_menu_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_entry_menu_finalize;
}

static void
widgets_entry_menu_instance_init (WidgetsEntryMenu * self,
                                  gpointer klass)
{
}

static void
widgets_entry_menu_finalize (GObject * obj)
{
	WidgetsEntryMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_ENTRY_MENU, WidgetsEntryMenu);
	_g_object_unref0 (self->menu);
	G_OBJECT_CLASS (widgets_entry_menu_parent_class)->finalize (obj);
}

static GType
widgets_entry_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsEntryMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_entry_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsEntryMenu), 0, (GInstanceInitFunc) widgets_entry_menu_instance_init, NULL };
	GType widgets_entry_menu_type_id;
	widgets_entry_menu_type_id = g_type_register_static (G_TYPE_OBJECT, "WidgetsEntryMenu", &g_define_type_info, 0);
	return widgets_entry_menu_type_id;
}

GType
widgets_entry_menu_get_type (void)
{
	static volatile gsize widgets_entry_menu_type_id__once = 0;
	if (g_once_init_enter (&widgets_entry_menu_type_id__once)) {
		GType widgets_entry_menu_type_id;
		widgets_entry_menu_type_id = widgets_entry_menu_get_type_once ();
		g_once_init_leave (&widgets_entry_menu_type_id__once, widgets_entry_menu_type_id);
	}
	return widgets_entry_menu_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

