/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *               2019 ~ 2020 Gary Wang
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 *             Gary Wang <wzc782970009@gmail.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <glib/gstdio.h>
#include <libsecret/secret.h>
#include <librsvg/rsvg.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define UTILS_TYPE_DEEPIN_MANUAL_INTERFACE (utils_deepin_manual_interface_get_type ())
#define UTILS_DEEPIN_MANUAL_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UTILS_TYPE_DEEPIN_MANUAL_INTERFACE, UtilsDeepinManualInterface))
#define UTILS_IS_DEEPIN_MANUAL_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UTILS_TYPE_DEEPIN_MANUAL_INTERFACE))
#define UTILS_DEEPIN_MANUAL_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UTILS_TYPE_DEEPIN_MANUAL_INTERFACE, UtilsDeepinManualInterfaceIface))

typedef struct _UtilsDeepinManualInterface UtilsDeepinManualInterface;
typedef struct _UtilsDeepinManualInterfaceIface UtilsDeepinManualInterfaceIface;

#define UTILS_TYPE_DEEPIN_MANUAL_INTERFACE_PROXY (utils_deepin_manual_interface_proxy_get_type ())
typedef GDBusProxy UtilsDeepinManualInterfaceProxy;
typedef GDBusProxyClass UtilsDeepinManualInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _UtilsDeepinManualInterfaceIface {
	GTypeInterface parent_iface;
	void (*ShowManual) (UtilsDeepinManualInterface* self, const gchar* appName, GError** error);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

VALA_EXTERN gboolean is_tiling;
gboolean is_tiling = FALSE;
VALA_EXTERN gboolean tiling_checked;
gboolean tiling_checked = FALSE;

gchar* project_path (void);
gchar* font_match (const gchar* family);
gchar** list_mono_or_dot_fonts (gint* num,
                                gint* result_length1);
VALA_EXTERN GType utils_deepin_manual_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint utils_deepin_manual_interface_register_object (void* object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error);
VALA_EXTERN GType utils_deepin_manual_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UtilsDeepinManualInterface, g_object_unref)
VALA_EXTERN void utils_deepin_manual_interface_ShowManual (UtilsDeepinManualInterface* self,
                                               const gchar* appName,
                                               GError** error);
static GType utils_deepin_manual_interface_get_type_once (void);
static void utils_deepin_manual_interface_proxy_g_signal (GDBusProxy* proxy,
                                                   const gchar* sender_name,
                                                   const gchar* signal_name,
                                                   GVariant* parameters);
static void utils_deepin_manual_interface_proxy_ShowManual (UtilsDeepinManualInterface* self,
                                                     const gchar* appName,
                                                     GError** error);
static void utils_deepin_manual_interface_proxy_utils_deepin_manual_interface_interface_init (UtilsDeepinManualInterfaceIface* iface);
static void _dbus_utils_deepin_manual_interface_ShowManual (UtilsDeepinManualInterface* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void utils_deepin_manual_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* method_name,
                                                               GVariant* parameters,
                                                               GDBusMethodInvocation* invocation,
                                                               gpointer user_data);
static GVariant* utils_deepin_manual_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* property_name,
                                                                     GError** error,
                                                                     gpointer user_data);
static gboolean utils_deepin_manual_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GVariant* value,
                                                                    GError** error,
                                                                    gpointer user_data);
static void _utils_deepin_manual_interface_unregister_object (gpointer user_data);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void utils_propagate_draw (GtkContainer* widget,
                           cairo_t* cr);
VALA_EXTERN gboolean utils_is_light_color (const gchar* color_string);
VALA_EXTERN gdouble utils_get_color_brightness (const gchar* color_string);
VALA_EXTERN gboolean utils_is_tiling_wm (void);
VALA_EXTERN void utils_set_tiling_wm (void);
VALA_EXTERN gchar* utils_get_menu_css (void);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN ConfigConfig* config_config_new (void);
VALA_EXTERN ConfigConfig* config_config_construct (GType object_type);
VALA_EXTERN void utils_touch_dir (const gchar* dir);
VALA_EXTERN void utils_create_file (const gchar* file_path);
VALA_EXTERN GeeArrayList* utils_list_files (const gchar* path);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
VALA_EXTERN void utils_destroy_all_children (GtkContainer* container);
VALA_EXTERN void utils_get_origin_allocation (GtkWidget* w,
                                  GtkAllocation* result);
VALA_EXTERN gboolean utils_move_window (GtkWidget* widget,
                            GdkEventButton* event);
VALA_EXTERN gboolean utils_is_primary_button (GdkEventButton* event);
VALA_EXTERN gboolean utils_resize_window (GtkWidget* widget,
                              GdkEventButton* event,
                              GdkCursorType cursor_type);
VALA_EXTERN GdkWindowEdge* utils_cursor_type_to_window_edge (GdkCursorType cursor_type);
static GdkWindowEdge* _gdk_window_edge_dup (GdkWindowEdge* self);
VALA_EXTERN void utils_toggle_max_window (GtkWindow* window);
VALA_EXTERN gboolean utils_is_left_button (GdkEventButton* event);
VALA_EXTERN gboolean utils_is_mouse_wheel (GdkEventButton* event);
VALA_EXTERN gboolean utils_is_right_button (GdkEventButton* event);
VALA_EXTERN gboolean utils_is_action_mouse_button (GdkEventButton* event);
VALA_EXTERN gboolean utils_is_double_click (GdkEventButton* event);
VALA_EXTERN void utils_load_css_theme (const gchar* css_path);
VALA_EXTERN gchar* utils_slice_string (const gchar* str,
                           gint unichar_num);
VALA_EXTERN gboolean utils_is_command_exist (const gchar* command_name);
VALA_EXTERN gchar* utils_get_command_output (const gchar* cmd);
VALA_EXTERN gchar* utils_get_proc_file_content (const gchar* proc_file_path);
VALA_EXTERN gchar* utils_get_image_path (const gchar* image_name);
VALA_EXTERN gchar* utils_get_theme_path (const gchar* theme_name);
VALA_EXTERN gchar* utils_get_additional_theme_path (const gchar* theme_name);
VALA_EXTERN gchar* utils_get_additional_theme_dir (void);
VALA_EXTERN gchar* utils_get_theme_dir (void);
VALA_EXTERN gchar* utils_get_config_dir (void);
VALA_EXTERN gchar* utils_get_root_path (const gchar* file_path);
VALA_EXTERN gchar* utils_get_config_file_path (const gchar* config_name);
VALA_EXTERN gchar* utils_get_ssh_script_path (void);
VALA_EXTERN gchar* utils_get_default_private_key_path (void);
VALA_EXTERN gchar* utils_lookup_password (const gchar* user,
                              const gchar* server_address,
                              const gchar* port);
VALA_EXTERN void utils_store_password (const gchar* user,
                           const gchar* server_address,
                           gint port,
                           const gchar* password);
static void _g_free0_ (gpointer var);
static void __lambda141_ (GObject* obj,
                   GAsyncResult* async_res);
static void ___lambda141__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void utils_get_pointer_position (gint* x,
                                 gint* y);
VALA_EXTERN gboolean utils_pointer_in_widget_area (GtkWidget* widget);
VALA_EXTERN void utils_show_manual (void);
VALA_EXTERN void utils_write_log (const gchar* log);
VALA_EXTERN cairo_surface_t* utils_create_image_surface_from_file (const gchar* file_path);
VALA_EXTERN gdouble utils_get_default_monitor_scale (void);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
VALA_EXTERN gint utils_get_active_monitor (GdkScreen* screen);
VALA_EXTERN gdouble utils_get_dde_scale_ratio (void);
VALA_EXTERN gint utils_get_pointer_monitor (GdkScreen* screen);
VALA_EXTERN gchar* utils_get_process_cmdline (gint pid);
VALA_EXTERN guint8* utils_to_raw_data (const gchar* str,
                           gint* result_length1);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _utils_deepin_manual_interface_dbus_arg_info_ShowManual_appName = {-1, "appName", "s", NULL};
static const GDBusArgInfo * const _utils_deepin_manual_interface_dbus_arg_info_ShowManual_in[] = {&_utils_deepin_manual_interface_dbus_arg_info_ShowManual_appName, NULL};
static const GDBusArgInfo * const _utils_deepin_manual_interface_dbus_arg_info_ShowManual_out[] = {NULL};
static const GDBusMethodInfo _utils_deepin_manual_interface_dbus_method_info_ShowManual = {-1, "ShowManual", (GDBusArgInfo **) (&_utils_deepin_manual_interface_dbus_arg_info_ShowManual_in), (GDBusArgInfo **) (&_utils_deepin_manual_interface_dbus_arg_info_ShowManual_out), NULL};
static const GDBusMethodInfo * const _utils_deepin_manual_interface_dbus_method_info[] = {&_utils_deepin_manual_interface_dbus_method_info_ShowManual, NULL};
static const GDBusSignalInfo * const _utils_deepin_manual_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _utils_deepin_manual_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _utils_deepin_manual_interface_dbus_interface_info = {-1, "com.deepin.Manual.Open", (GDBusMethodInfo **) (&_utils_deepin_manual_interface_dbus_method_info), (GDBusSignalInfo **) (&_utils_deepin_manual_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_utils_deepin_manual_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _utils_deepin_manual_interface_dbus_interface_vtable = {utils_deepin_manual_interface_dbus_interface_method_call, utils_deepin_manual_interface_dbus_interface_get_property, utils_deepin_manual_interface_dbus_interface_set_property};

void
utils_deepin_manual_interface_ShowManual (UtilsDeepinManualInterface* self,
                                          const gchar* appName,
                                          GError** error)
{
	UtilsDeepinManualInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = UTILS_DEEPIN_MANUAL_INTERFACE_GET_INTERFACE (self);
	if (_iface_->ShowManual) {
		_iface_->ShowManual (self, appName, error);
	}
}

static void
utils_deepin_manual_interface_default_init (UtilsDeepinManualInterfaceIface * iface,
                                            gpointer iface_data)
{
}

static GType
utils_deepin_manual_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UtilsDeepinManualInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_deepin_manual_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType utils_deepin_manual_interface_type_id;
	utils_deepin_manual_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "UtilsDeepinManualInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (utils_deepin_manual_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (utils_deepin_manual_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) utils_deepin_manual_interface_proxy_get_type);
	g_type_set_qdata (utils_deepin_manual_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.deepin.Manual.Open");
	g_type_set_qdata (utils_deepin_manual_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_utils_deepin_manual_interface_dbus_interface_info));
	g_type_set_qdata (utils_deepin_manual_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) utils_deepin_manual_interface_register_object);
	return utils_deepin_manual_interface_type_id;
}

GType
utils_deepin_manual_interface_get_type (void)
{
	static volatile gsize utils_deepin_manual_interface_type_id__once = 0;
	if (g_once_init_enter (&utils_deepin_manual_interface_type_id__once)) {
		GType utils_deepin_manual_interface_type_id;
		utils_deepin_manual_interface_type_id = utils_deepin_manual_interface_get_type_once ();
		g_once_init_leave (&utils_deepin_manual_interface_type_id__once, utils_deepin_manual_interface_type_id);
	}
	return utils_deepin_manual_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (UtilsDeepinManualInterfaceProxy, utils_deepin_manual_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UTILS_TYPE_DEEPIN_MANUAL_INTERFACE, utils_deepin_manual_interface_proxy_utils_deepin_manual_interface_interface_init) )
static void
utils_deepin_manual_interface_proxy_class_init (UtilsDeepinManualInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = utils_deepin_manual_interface_proxy_g_signal;
}

static void
utils_deepin_manual_interface_proxy_g_signal (GDBusProxy* proxy,
                                              const gchar* sender_name,
                                              const gchar* signal_name,
                                              GVariant* parameters)
{
}

static void
utils_deepin_manual_interface_proxy_init (UtilsDeepinManualInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_utils_deepin_manual_interface_dbus_interface_info));
}

static void
utils_deepin_manual_interface_proxy_ShowManual (UtilsDeepinManualInterface* self,
                                                const gchar* appName,
                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.deepin.Manual.Open", "ShowManual");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (appName));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
utils_deepin_manual_interface_proxy_utils_deepin_manual_interface_interface_init (UtilsDeepinManualInterfaceIface* iface)
{
	iface->ShowManual = utils_deepin_manual_interface_proxy_ShowManual;
}

static void
_dbus_utils_deepin_manual_interface_ShowManual (UtilsDeepinManualInterface* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* appName = NULL;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	appName = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	utils_deepin_manual_interface_ShowManual (self, appName, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (appName);
	;
}

static void
utils_deepin_manual_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowManual") == 0) {
		_dbus_utils_deepin_manual_interface_ShowManual (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
utils_deepin_manual_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
utils_deepin_manual_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
utils_deepin_manual_interface_register_object (gpointer object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_utils_deepin_manual_interface_dbus_interface_info), &_utils_deepin_manual_interface_dbus_interface_vtable, data, _utils_deepin_manual_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_utils_deepin_manual_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
utils_hex_to_rgba (const gchar* hex_color,
                   gdouble alpha,
                   GdkRGBA* result)
{
	GdkRGBA rgba_color = {0};
	g_return_if_fail (hex_color != NULL);
	memset (&rgba_color, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&rgba_color, hex_color);
	rgba_color.alpha = alpha;
	*result = rgba_color;
	return;
}

void
utils_set_context_color (cairo_t* cr,
                         GdkRGBA* color)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	cairo_set_source_rgba (cr, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
utils_propagate_draw (GtkContainer* widget,
                      cairo_t* cr)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_container_get_children (widget);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_length (_tmp1_) > ((guint) 0);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_list_free (_tmp1_), NULL));
	if (_tmp2_) {
		GList* _tmp3_;
		_tmp3_ = gtk_container_get_children (widget);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp3_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp4_;
				GtkWidget* child = NULL;
				_tmp4_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp4_;
				{
					GtkWidget* _tmp5_;
					_tmp5_ = child;
					gtk_container_propagate_draw (widget, _tmp5_, cr);
					_g_object_unref0 (child);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
}

gboolean
utils_is_light_color (const gchar* color_string)
{
	GdkRGBA color = {0};
	gdouble r = 0.0;
	GdkRGBA _tmp0_;
	gdouble g = 0.0;
	GdkRGBA _tmp1_;
	gdouble b = 0.0;
	GdkRGBA _tmp2_;
	gdouble max_v = 0.0;
	gdouble min_v = 0.0;
	gdouble s = 0.0;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (color_string != NULL, FALSE);
	memset (&color, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&color, color_string);
	_tmp0_ = color;
	r = _tmp0_.red;
	_tmp1_ = color;
	g = _tmp1_.green;
	_tmp2_ = color;
	b = _tmp2_.blue;
	max_v = MAX (r, MAX (g, b));
	min_v = MIN (r, MIN (g, b));
	if (max_v == ((gdouble) 0)) {
		s = 0.0;
	} else {
		s = 1.0 - (min_v / max_v);
	}
	b = max_v;
	if (b > 0.35) {
		_tmp3_ = s < 0.7;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

gdouble
utils_get_color_brightness (const gchar* color_string)
{
	GdkRGBA color = {0};
	gdouble r = 0.0;
	GdkRGBA _tmp0_;
	gdouble g = 0.0;
	GdkRGBA _tmp1_;
	gdouble b = 0.0;
	GdkRGBA _tmp2_;
	gdouble max_v = 0.0;
	gdouble min_v = 0.0;
	gdouble s = 0.0;
	gdouble result;
	g_return_val_if_fail (color_string != NULL, 0.0);
	memset (&color, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&color, color_string);
	_tmp0_ = color;
	r = _tmp0_.red;
	_tmp1_ = color;
	g = _tmp1_.green;
	_tmp2_ = color;
	b = _tmp2_.blue;
	max_v = MAX (r, MAX (g, b));
	min_v = MIN (r, MIN (g, b));
	if (max_v == ((gdouble) 0)) {
		s = 0.0;
	} else {
		s = 1.0 - (min_v / max_v);
	}
	b = max_v;
	result = b;
	return result;
}

gboolean
utils_is_tiling_wm (void)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (tiling_checked) {
		result = is_tiling;
		return result;
	}
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		g_spawn_command_line_sync ("pidof i3 xmonad wmii wmfs wingo subtle sway stumpwm spectrwm snapwm ra" \
"tpoison qtile notion herbstluftwm frankenwm dwm bspwm awesome alopex", &_tmp1_, NULL, NULL, &_inner_error0_);
		_g_free0 (output);
		output = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("utils.vala:120: Something bad happened with pidof command %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = output;
	is_tiling = g_strcmp0 (_tmp6_, "") != 0;
	tiling_checked = TRUE;
	result = is_tiling;
	_g_free0 (output);
	return result;
}

void
utils_set_tiling_wm (void)
{
	tiling_checked = TRUE;
	is_tiling = TRUE;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
utils_get_menu_css (void)
{
	gchar* background_color = NULL;
	gchar* _tmp0_;
	gchar* foreground_color = NULL;
	gchar* _tmp1_;
	gboolean is_light_theme = FALSE;
	const gchar* _tmp19_ = NULL;
	gchar* text_color = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* text_color_on_hover = NULL;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup ("#ffffff");
	background_color = _tmp0_;
	_tmp1_ = g_strdup ("#000000");
	foreground_color = _tmp1_;
	is_light_theme = TRUE;
	{
		ConfigConfig* config = NULL;
		ConfigConfig* _tmp2_;
		gchar* _tmp3_ = NULL;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		ConfigConfig* _tmp9_;
		GKeyFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		ConfigConfig* _tmp14_;
		GKeyFile* _tmp15_;
		gchar* _tmp16_;
		_tmp2_ = config_config_new ();
		config = _tmp2_;
		_tmp4_ = config;
		_tmp5_ = _tmp4_->config_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "theme", "background", &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (foreground_color);
			_g_free0 (background_color);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (background_color);
		background_color = _tmp7_;
		_tmp9_ = config;
		_tmp10_ = _tmp9_->config_file;
		_tmp11_ = g_key_file_get_string (_tmp10_, "theme", "foreground", &_inner_error0_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp3_);
			_g_object_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (foreground_color);
			_g_free0 (background_color);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (foreground_color);
		foreground_color = _tmp12_;
		_tmp14_ = config;
		_tmp15_ = _tmp14_->config_file;
		_tmp16_ = g_key_file_get_string (_tmp15_, "theme", "style", &_inner_error0_);
		_tmp13_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_free0 (_tmp3_);
			_g_object_unref0 (config);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (foreground_color);
			_g_free0 (background_color);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		is_light_theme = g_strcmp0 (_tmp13_, "light") == 0;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_print ("Can't read config file: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (foreground_color);
		_g_free0 (background_color);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (is_light_theme) {
		_tmp19_ = "white";
	} else {
		_tmp19_ = "black";
	}
	_tmp20_ = g_strdup (_tmp19_);
	text_color = _tmp20_;
	if (is_light_theme) {
		_tmp21_ = "black";
	} else {
		_tmp21_ = "white";
	}
	_tmp22_ = g_strdup (_tmp21_);
	text_color_on_hover = _tmp22_;
	_tmp23_ = background_color;
	_tmp24_ = string_to_string (_tmp23_);
	_tmp25_ = string_to_string (text_color_on_hover);
	_tmp26_ = background_color;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = foreground_color;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = text_color;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strconcat ("\n            menu {\n                background: ", _tmp24_, ";\n" \
"                opacity: 0.95;\n" \
"                border: 0;\n" \
"            }\n" \
"            menu menuitem{\n" \
"                color: ", _tmp25_, ";\n                background: ", _tmp27_, ";\n" \
"                opacity: 0.95;\n" \
"            }\n" \
"            menu menuitem:hover {\n" \
"                background-color: ", _tmp29_, ";\n                color: ", _tmp31_, ";\n" \
"                transition: color 10ms linear;\n" \
"            }\n" \
"            ", NULL);
	result = _tmp32_;
	_g_free0 (text_color_on_hover);
	_g_free0 (text_color);
	_g_free0 (foreground_color);
	_g_free0 (background_color);
	return result;
}

void
utils_touch_dir (const gchar* dir)
{
	GFile* dir_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	_tmp0_ = g_file_new_for_path (dir);
	dir_file = _tmp0_;
	_tmp1_ = dir_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		{
			GFile* _tmp2_;
			_tmp2_ = dir_file;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_print ("Could not create dir: %s\n", _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (dir_file);
}

void
utils_create_file (const gchar* file_path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file_path != NULL);
	_tmp0_ = g_file_new_for_path (file_path);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		{
			GFile* _tmp2_;
			GFileOutputStream* _tmp3_;
			GFileOutputStream* _tmp4_;
			_tmp2_ = file;
			_tmp3_ = g_file_create (_tmp2_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_print ("create_file: %s\n", _tmp6_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (file);
}

GeeArrayList*
utils_list_files (const gchar* path)
{
	GeeArrayList* files = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	files = _tmp0_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileEnumerator* _tmp4_;
		GFileInfo* info = NULL;
		_tmp1_ = g_file_new_for_path (path);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		enumerator = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		info = NULL;
		while (TRUE) {
			GFileInfo* _tmp5_ = NULL;
			GFileEnumerator* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			_tmp6_ = enumerator;
			_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (info);
			info = _tmp8_;
			_tmp9_ = info;
			if (!(_tmp9_ != NULL)) {
				_g_object_unref0 (_tmp5_);
				break;
			}
			_tmp10_ = info;
			if (g_file_info_get_file_type (_tmp10_) != G_FILE_TYPE_DIRECTORY) {
				GeeArrayList* _tmp11_;
				GFileInfo* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = files;
				_tmp12_ = info;
				_tmp13_ = g_file_info_get_name (_tmp12_);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
			}
			_g_object_unref0 (_tmp5_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_print ("list_files: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = files;
	return result;
}

void
utils_remove_all_children (GtkContainer* container)
{
	GList* _tmp0_;
	g_return_if_fail (container != NULL);
	_tmp0_ = gtk_container_get_children (container);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = w;
				gtk_container_remove (container, _tmp2_);
				_g_object_unref0 (w);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
}

void
utils_destroy_all_children (GtkContainer* container)
{
	GList* _tmp0_;
	g_return_if_fail (container != NULL);
	_tmp0_ = gtk_container_get_children (container);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_;
				GtkWidget* _tmp3_;
				_tmp2_ = w;
				gtk_container_remove (container, _tmp2_);
				_tmp3_ = w;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (w);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
}

void
utils_get_origin_allocation (GtkWidget* w,
                             GtkAllocation* result)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GtkWidget* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (w != NULL);
	gtk_widget_get_allocation (w, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = gtk_widget_get_toplevel (w);
	gtk_widget_translate_coordinates (w, _tmp1_, 0, 0, &_tmp2_, &_tmp3_);
	alloc.x = _tmp2_;
	alloc.y = _tmp3_;
	*result = alloc;
	return;
}

gboolean
utils_move_window (GtkWidget* widget,
                   GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (utils_is_primary_button (event)) {
		GtkWidget* _tmp0_;
		GdkWindow* _tmp1_;
		_tmp0_ = gtk_widget_get_toplevel (widget);
		_tmp1_ = gtk_widget_get_window (_tmp0_);
		gdk_window_begin_move_drag (_tmp1_, (gint) event->button, (gint) event->x_root, (gint) event->y_root, event->time);
	}
	result = FALSE;
	return result;
}

gboolean
utils_resize_window (GtkWidget* widget,
                     GdkEventButton* event,
                     GdkCursorType cursor_type)
{
	GtkWidget* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindowEdge* _tmp2_;
	GdkWindowEdge* _tmp3_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel (widget);
	_tmp1_ = gtk_widget_get_window (_tmp0_);
	_tmp2_ = utils_cursor_type_to_window_edge (cursor_type);
	_tmp3_ = _tmp2_;
	gdk_window_begin_resize_drag (_tmp1_, *_tmp3_, (gint) event->button, (gint) event->x_root, (gint) event->y_root, event->time);
	_g_free0 (_tmp3_);
	result = TRUE;
	return result;
}

static GdkWindowEdge*
_gdk_window_edge_dup (GdkWindowEdge* self)
{
	GdkWindowEdge* dup;
	dup = g_new0 (GdkWindowEdge, 1);
	memcpy (dup, self, sizeof (GdkWindowEdge));
	return dup;
}

static gpointer
__gdk_window_edge_dup0 (gpointer self)
{
	return self ? _gdk_window_edge_dup (self) : NULL;
}

GdkWindowEdge*
utils_cursor_type_to_window_edge (GdkCursorType cursor_type)
{
	GdkWindowEdge* result;
	if (cursor_type == GDK_TOP_LEFT_CORNER) {
		GdkWindowEdge _tmp0_;
		GdkWindowEdge* _tmp1_;
		_tmp0_ = GDK_WINDOW_EDGE_NORTH_WEST;
		_tmp1_ = __gdk_window_edge_dup0 (&_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		if (cursor_type == GDK_TOP_SIDE) {
			GdkWindowEdge _tmp2_;
			GdkWindowEdge* _tmp3_;
			_tmp2_ = GDK_WINDOW_EDGE_NORTH;
			_tmp3_ = __gdk_window_edge_dup0 (&_tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (cursor_type == GDK_TOP_RIGHT_CORNER) {
				GdkWindowEdge _tmp4_;
				GdkWindowEdge* _tmp5_;
				_tmp4_ = GDK_WINDOW_EDGE_NORTH_EAST;
				_tmp5_ = __gdk_window_edge_dup0 (&_tmp4_);
				result = _tmp5_;
				return result;
			} else {
				if (cursor_type == GDK_RIGHT_SIDE) {
					GdkWindowEdge _tmp6_;
					GdkWindowEdge* _tmp7_;
					_tmp6_ = GDK_WINDOW_EDGE_EAST;
					_tmp7_ = __gdk_window_edge_dup0 (&_tmp6_);
					result = _tmp7_;
					return result;
				} else {
					if (cursor_type == GDK_BOTTOM_RIGHT_CORNER) {
						GdkWindowEdge _tmp8_;
						GdkWindowEdge* _tmp9_;
						_tmp8_ = GDK_WINDOW_EDGE_SOUTH_EAST;
						_tmp9_ = __gdk_window_edge_dup0 (&_tmp8_);
						result = _tmp9_;
						return result;
					} else {
						if (cursor_type == GDK_BOTTOM_SIDE) {
							GdkWindowEdge _tmp10_;
							GdkWindowEdge* _tmp11_;
							_tmp10_ = GDK_WINDOW_EDGE_SOUTH;
							_tmp11_ = __gdk_window_edge_dup0 (&_tmp10_);
							result = _tmp11_;
							return result;
						} else {
							if (cursor_type == GDK_BOTTOM_LEFT_CORNER) {
								GdkWindowEdge _tmp12_;
								GdkWindowEdge* _tmp13_;
								_tmp12_ = GDK_WINDOW_EDGE_SOUTH_WEST;
								_tmp13_ = __gdk_window_edge_dup0 (&_tmp12_);
								result = _tmp13_;
								return result;
							} else {
								if (cursor_type == GDK_LEFT_SIDE) {
									GdkWindowEdge _tmp14_;
									GdkWindowEdge* _tmp15_;
									_tmp14_ = GDK_WINDOW_EDGE_WEST;
									_tmp15_ = __gdk_window_edge_dup0 (&_tmp14_);
									result = _tmp15_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
utils_toggle_max_window (GtkWindow* window)
{
	GdkWindowState window_state = 0U;
	GdkWindow* _tmp0_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) window);
	window_state = gdk_window_get_state (_tmp0_);
	if ((window_state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_unmaximize (window);
	} else {
		gtk_window_maximize (window);
	}
}

gboolean
utils_is_primary_button (GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = event->button == ((guint) GDK_BUTTON_PRIMARY);
	return result;
}

gboolean
utils_is_left_button (GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = event->button == ((guint) 1);
	return result;
}

gboolean
utils_is_mouse_wheel (GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = event->button == ((guint) 2);
	return result;
}

gboolean
utils_is_right_button (GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = event->button == ((guint) 3);
	return result;
}

gboolean
utils_is_action_mouse_button (GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (utils_is_left_button (event)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = utils_is_mouse_wheel (event);
	}
	result = _tmp0_;
	return result;
}

gboolean
utils_is_double_click (GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		_tmp0_ = event->type == GDK_2BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
utils_load_css_theme (const gchar* css_path)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (css_path != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gtk_css_provider_new ();
	css_provider = _tmp2_;
	{
		gtk_css_provider_load_from_path (css_provider, css_path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_print ("Got error when load css: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_style_context_add_provider_for_screen (screen, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_g_object_unref0 (css_provider);
	_g_object_unref0 (screen);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
utils_slice_string (const gchar* str,
                    gint unichar_num)
{
	gchar* slice_str = NULL;
	gchar* _tmp0_;
	gunichar c = 0U;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_strdup ("");
	slice_str = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gunichar _tmp2_ = 0U;
				gboolean _tmp3_;
				if (!_tmp1_) {
				}
				_tmp1_ = FALSE;
				_tmp3_ = string_get_next_char (str, &i, &_tmp2_);
				c = _tmp2_;
				if (!_tmp3_) {
					break;
				}
				if (i > unichar_num) {
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = slice_str;
					_tmp5_ = g_strconcat (_tmp4_, "... ", NULL);
					result = _tmp5_;
					_g_free0 (slice_str);
					return result;
				} else {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp6_ = slice_str;
					_tmp7_ = g_unichar_to_string (c);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_g_free0 (slice_str);
					slice_str = _tmp9_;
					_g_free0 (_tmp8_);
				}
			}
		}
	}
	result = slice_str;
	return result;
}

gboolean
utils_is_command_exist (const gchar* command_name)
{
	gchar* paths = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gboolean result;
	g_return_val_if_fail (command_name != NULL, FALSE);
	_tmp0_ = g_getenv ("PATH");
	_tmp1_ = g_strdup (_tmp0_);
	paths = _tmp1_;
	_tmp2_ = paths;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 0);
	{
		gchar** bin_path_collection = NULL;
		gint bin_path_collection_length1 = 0;
		gint _bin_path_collection_size_ = 0;
		gint bin_path_it = 0;
		bin_path_collection = _tmp4_;
		bin_path_collection_length1 = _vala_array_length (_tmp3_);
		for (bin_path_it = 0; bin_path_it < bin_path_collection_length1; bin_path_it = bin_path_it + 1) {
			gchar* _tmp5_;
			gchar* bin_path = NULL;
			_tmp5_ = g_strdup (bin_path_collection[bin_path_it]);
			bin_path = _tmp5_;
			{
				GFile* file = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GFile* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				_tmp6_ = bin_path;
				_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, command_name, NULL);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_file_new_for_path (_tmp8_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				file = _tmp10_;
				_tmp11_ = file;
				if (g_file_query_exists (_tmp11_, NULL)) {
					result = TRUE;
					_g_object_unref0 (file);
					_g_free0 (bin_path);
					bin_path_collection = (_vala_array_free (bin_path_collection, bin_path_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (paths);
					return result;
				}
				_g_object_unref0 (file);
				_g_free0 (bin_path);
			}
		}
		bin_path_collection = (_vala_array_free (bin_path_collection, bin_path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_free0 (paths);
	return result;
}

gchar*
utils_get_command_output (const gchar* cmd)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (cmd != NULL, NULL);
	{
		gint exit_code = 0;
		gchar* std_out = NULL;
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		g_spawn_command_line_sync (cmd, &_tmp0_, NULL, &_tmp1_, &_inner_error0_);
		_g_free0 (std_out);
		std_out = _tmp0_;
		exit_code = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (std_out);
			goto __catch0_g_error;
		}
		result = std_out;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp2_;
		g_clear_error (&_inner_error0_);
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
utils_get_proc_file_content (const gchar* proc_file_path)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (proc_file_path != NULL, NULL);
	{
		guint8* data = NULL;
		gint data_length1 = 0;
		gint _data_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		g_file_get_contents (proc_file_path, (gchar**) (&_tmp0_), &_tmp1_, &_inner_error0_);
		data = (g_free (data), NULL);
		data = _tmp0_;
		data_length1 = _tmp1_;
		_data_size_ = data_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			data = (g_free (data), NULL);
			goto __catch0_g_error;
		}
		_tmp2_ = data;
		_tmp2__length1 = data_length1;
		if (_tmp2_ != NULL) {
			guint8* _tmp9_;
			gint _tmp9__length1;
			gchar* _tmp10_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp3_ = FALSE;
					_tmp3_ = TRUE;
					while (TRUE) {
						guint8* _tmp5_;
						gint _tmp5__length1;
						guint8* _tmp6_;
						gint _tmp6__length1;
						guint8 _tmp7_;
						if (!_tmp3_) {
							gint _tmp4_;
							_tmp4_ = i;
							i = _tmp4_ + 1;
						}
						_tmp3_ = FALSE;
						_tmp5_ = data;
						_tmp5__length1 = data_length1;
						if (!(i < (_tmp5__length1 - 1))) {
							break;
						}
						_tmp6_ = data;
						_tmp6__length1 = data_length1;
						_tmp7_ = _tmp6_[i];
						if (((gint) _tmp7_) == 0) {
							guint8* _tmp8_;
							gint _tmp8__length1;
							_tmp8_ = data;
							_tmp8__length1 = data_length1;
							_tmp8_[i] = (guint8) ' ';
						}
					}
				}
			}
			_tmp9_ = data;
			_tmp9__length1 = data_length1;
			_tmp10_ = g_strdup ((const gchar*) _tmp9_);
			result = _tmp10_;
			data = (g_free (data), NULL);
			return result;
		} else {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("");
			result = _tmp11_;
			data = (g_free (data), NULL);
			return result;
		}
		data = (g_free (data), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_print ("get_proc_file_content: %s\n", _tmp13_);
		_tmp14_ = g_strdup ("");
		result = _tmp14_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
utils_get_image_path (const gchar* image_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (image_name != NULL, NULL);
	_tmp0_ = project_path ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, (const gchar*) _tmp0_, "share", "deepin-terminal-gtk", "image", image_name, NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_theme_path (const gchar* theme_name)
{
	gchar* theme_path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* dir_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* result;
	g_return_val_if_fail (theme_name != NULL, NULL);
	_tmp0_ = project_path ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, (const gchar*) _tmp0_, "share", "deepin-terminal-gtk", "theme", theme_name, NULL);
	theme_path = _tmp1_;
	_tmp2_ = theme_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	dir_file = _tmp3_;
	_tmp4_ = dir_file;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		gchar* _tmp5_;
		_tmp5_ = utils_get_additional_theme_path (theme_name);
		_g_free0 (theme_path);
		theme_path = _tmp5_;
	}
	result = theme_path;
	_g_object_unref0 (dir_file);
	return result;
}

gchar*
utils_get_additional_theme_path (const gchar* theme_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (theme_name != NULL, NULL);
	_tmp0_ = utils_get_additional_theme_dir ();
	_tmp1_ = (gchar*) _tmp0_;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path (G_DIR_SEPARATOR_S, _tmp3_, "themes", theme_name, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
utils_get_theme_dir (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = project_path ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, (const gchar*) _tmp0_, "share", "deepin-terminal-gtk", "theme", NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_additional_theme_dir (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = utils_get_config_dir ();
	_tmp1_ = (gchar*) _tmp0_;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path (G_DIR_SEPARATOR_S, _tmp3_, "deepin-terminal-gtk", "themes", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
utils_get_root_path (const gchar* file_path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = project_path ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, (const gchar*) _tmp0_, "share", "deepin-terminal-gtk", file_path, NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_config_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "deepin", "deepin-terminal-gtk", NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_config_file_path (const gchar* config_name)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (config_name != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "deepin", "deepin-terminal-gtk", config_name, NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_ssh_script_path (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = project_path ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, (const gchar*) _tmp0_, "lib", "deepin-terminal-gtk", "ssh_login.sh", NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_get_default_private_key_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, ".ssh", "id_rsa", NULL);
	result = _tmp1_;
	return result;
}

gchar*
utils_lookup_password (const gchar* user,
                       const gchar* server_address,
                       const gchar* port)
{
	SecretSchema* password_schema = NULL;
	gchar* password = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (user != NULL, NULL);
	g_return_val_if_fail (server_address != NULL, NULL);
	if (port == NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		SecretSchema* _tmp2_;
		_tmp0_ = g_strdup_printf ("com.deepin.terminal.password.%s.%s", user, server_address);
		_tmp1_ = _tmp0_;
		_tmp2_ = secret_schema_new (_tmp1_, SECRET_SCHEMA_NONE, "number", SECRET_SCHEMA_ATTRIBUTE_INTEGER, "string", SECRET_SCHEMA_ATTRIBUTE_STRING, "even", SECRET_SCHEMA_ATTRIBUTE_BOOLEAN, NULL);
		_secret_schema_unref0 (password_schema);
		password_schema = _tmp2_;
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		SecretSchema* _tmp5_;
		_tmp3_ = g_strdup_printf ("com.deepin.terminal.password.%s.%s.%s", user, server_address, port);
		_tmp4_ = _tmp3_;
		_tmp5_ = secret_schema_new (_tmp4_, SECRET_SCHEMA_NONE, "number", SECRET_SCHEMA_ATTRIBUTE_INTEGER, "string", SECRET_SCHEMA_ATTRIBUTE_STRING, "even", SECRET_SCHEMA_ATTRIBUTE_BOOLEAN, NULL);
		_secret_schema_unref0 (password_schema);
		password_schema = _tmp5_;
		_g_free0 (_tmp4_);
	}
	{
		gchar* _tmp6_ = NULL;
		SecretSchema* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = password_schema;
		_tmp8_ = secret_password_lookup_sync (_tmp7_, NULL, &_inner_error0_, NULL, "number", 8, "string", "eight", "even", TRUE, NULL);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (password);
		password = _tmp9_;
		_g_free0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e->message;
		g_error ("utils.vala:467: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (password);
		_secret_schema_unref0 (password_schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (password == NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		_g_free0 (password);
		_secret_schema_unref0 (password_schema);
		return result;
	} else {
		result = password;
		_secret_schema_unref0 (password_schema);
		return result;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
__lambda141_ (GObject* obj,
              GAsyncResult* async_res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (async_res != NULL);
	{
		secret_password_store_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_print ("%s", _tmp1_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda141__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda141_ (source_object, res);
}

void
utils_store_password (const gchar* user,
                      const gchar* server_address,
                      gint port,
                      const gchar* password)
{
	SecretSchema* password_schema = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SecretSchema* _tmp2_;
	SecretSchema* _tmp3_;
	GHashTable* attributes = NULL;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	SecretSchema* _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (user != NULL);
	g_return_if_fail (server_address != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = g_strdup_printf ("com.deepin.terminal.password.%s.%s.%i", user, server_address, port);
	_tmp1_ = _tmp0_;
	_tmp2_ = secret_schema_new (_tmp1_, SECRET_SCHEMA_NONE, "number", SECRET_SCHEMA_ATTRIBUTE_INTEGER, "string", SECRET_SCHEMA_ATTRIBUTE_STRING, "even", SECRET_SCHEMA_ATTRIBUTE_BOOLEAN, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	password_schema = _tmp3_;
	_tmp4_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_free0_);
	attributes = _tmp4_;
	_tmp5_ = attributes;
	_tmp6_ = g_strdup ("number");
	_tmp7_ = g_strdup ("8");
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = attributes;
	_tmp9_ = g_strdup ("string");
	_tmp10_ = g_strdup ("eight");
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = attributes;
	_tmp12_ = g_strdup ("even");
	_tmp13_ = g_strdup ("true");
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp13_);
	{
		SecretSchema* _tmp14_;
		_tmp14_ = password_schema;
		secret_password_clear_sync (_tmp14_, NULL, &_inner_error0_, "number", 8, "string", "eight", "even", TRUE, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_print ("%s", _tmp16_);
		_g_error_free0 (e);
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (password_schema);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (password_schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = password_schema;
	_tmp18_ = attributes;
	_tmp19_ = _g_hash_table_ref0 (_tmp18_);
	_tmp20_ = g_strdup_printf ("com.deepin.terminal.password.%s.%s", user, server_address);
	_tmp21_ = _tmp20_;
	secret_password_storev (_tmp17_, _tmp19_, SECRET_COLLECTION_DEFAULT, _tmp21_, password, NULL, ___lambda141__gasync_ready_callback, NULL);
	_g_free0 (_tmp21_);
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (password_schema);
}

void
utils_get_pointer_position (gint* x,
                            gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkDisplay* gdk_display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkSeat* seat = NULL;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	GdkDevice* device = NULL;
	GdkDevice* _tmp4_;
	GdkDevice* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gdk_display = _tmp1_;
	_tmp2_ = gdk_display_get_default_seat (gdk_display);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	seat = _tmp3_;
	_tmp4_ = gdk_seat_get_pointer (seat);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	device = _tmp5_;
	gdk_device_get_position (device, NULL, &_tmp6_, &_tmp7_);
	_vala_x = _tmp6_;
	_vala_y = _tmp7_;
	_g_object_unref0 (device);
	_g_object_unref0 (seat);
	_g_object_unref0 (gdk_display);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

gboolean
utils_pointer_in_widget_area (GtkWidget* widget)
{
	gint pointer_x = 0;
	gint pointer_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkAllocation widget_rect = {0};
	GtkAllocation _tmp2_ = {0};
	gint window_x = 0;
	gint window_y = 0;
	GtkWidget* _tmp3_;
	GdkWindow* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkAllocation _tmp10_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	pointer_x = _tmp0_;
	pointer_y = _tmp1_;
	utils_get_origin_allocation (widget, &_tmp2_);
	widget_rect = _tmp2_;
	_tmp3_ = gtk_widget_get_toplevel (widget);
	_tmp4_ = gtk_widget_get_window (_tmp3_);
	gdk_window_get_root_origin (_tmp4_, &_tmp5_, &_tmp6_);
	window_x = _tmp5_;
	window_y = _tmp6_;
	_tmp10_ = widget_rect;
	if (pointer_x > (window_x + _tmp10_.x)) {
		GtkAllocation _tmp11_;
		GtkAllocation _tmp12_;
		_tmp11_ = widget_rect;
		_tmp12_ = widget_rect;
		_tmp9_ = pointer_x < ((window_x + _tmp11_.x) + _tmp12_.width);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkAllocation _tmp13_;
		_tmp13_ = widget_rect;
		_tmp8_ = pointer_y > (window_y + _tmp13_.y);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkAllocation _tmp14_;
		GtkAllocation _tmp15_;
		_tmp14_ = widget_rect;
		_tmp15_ = widget_rect;
		_tmp7_ = pointer_y < ((window_y + _tmp14_.y) + _tmp15_.height);
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

void
utils_show_manual (void)
{
	GError* _inner_error0_ = NULL;
	{
		UtilsDeepinManualInterface* deepin_manual_interface = NULL;
		UtilsDeepinManualInterface* _tmp0_;
		UtilsDeepinManualInterface* _tmp1_;
		_tmp0_ = (UtilsDeepinManualInterface*) g_initable_new (UTILS_TYPE_DEEPIN_MANUAL_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "com.deepin.Manual.Open", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/deepin/Manual/Open", "g-interface-name", "com.deepin.Manual.Open", NULL);
		deepin_manual_interface = (UtilsDeepinManualInterface*) _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = deepin_manual_interface;
		utils_deepin_manual_interface_ShowManual (_tmp1_, "deepin-terminal-gtk", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (deepin_manual_interface);
			goto __catch0_g_error;
		}
		_g_object_unref0 (deepin_manual_interface);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_print ("show_manual: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
utils_write_log (const gchar* log)
{
	gchar* log_file_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* log_file = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (log != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "deepin", "deepin-terminal-gtk", NULL);
	log_file_dir = _tmp1_;
	_tmp2_ = g_get_user_cache_dir ();
	_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "deepin", "deepin-terminal-gtk", "deepin-terminal-gtk.log", NULL);
	log_file = _tmp3_;
	utils_touch_dir (log_file_dir);
	{
		g_file_set_contents (log_file, log, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_print ("write_log: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (log_file);
		_g_free0 (log_file_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (log_file);
	_g_free0 (log_file_dir);
}

cairo_surface_t*
utils_create_image_surface_from_file (const gchar* file_path)
{
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	{
		gdouble scale = 0.0;
		RsvgHandle* r = NULL;
		RsvgHandle* _tmp0_;
		RsvgDimensionData d = {0};
		RsvgDimensionData _tmp1_ = {0};
		cairo_surface_t* cs = NULL;
		RsvgDimensionData _tmp2_;
		RsvgDimensionData _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp6_;
		cairo_t* _tmp7_;
		cairo_t* _tmp8_;
		scale = utils_get_default_monitor_scale ();
		_tmp0_ = rsvg_handle_new_from_file (file_path, &_inner_error0_);
		r = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		rsvg_handle_get_dimensions (r, &_tmp1_);
		d = _tmp1_;
		_tmp2_ = d;
		_tmp3_ = d;
		_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) (_tmp2_.width * scale), (gint) (_tmp3_.height * scale));
		cs = _tmp4_;
		_tmp5_ = cs;
		cairo_surface_set_device_scale (_tmp5_, scale, scale);
		_tmp6_ = cs;
		_tmp7_ = cairo_create (_tmp6_);
		c = _tmp7_;
		_tmp8_ = c;
		rsvg_handle_render_cairo (r, _tmp8_);
		result = cs;
		_cairo_destroy0 (c);
		_g_object_unref0 (r);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		cairo_surface_t* cs = NULL;
		cairo_surface_t* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_print ("create_image_surface: %s %s\n", file_path, _tmp10_);
		_tmp11_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 1, 1);
		cs = _tmp11_;
		result = cs;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

cairo_surface_t*
utils_create_image_surface (const gchar* surface_path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* result;
	g_return_val_if_fail (surface_path != NULL, NULL);
	_tmp0_ = utils_get_image_path (surface_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = utils_create_image_surface_from_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gint
utils_get_active_monitor (GdkScreen* screen)
{
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	gint result;
	g_return_val_if_fail (screen != NULL, 0);
	_tmp0_ = gdk_screen_get_active_window (screen);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ != NULL) {
		GdkWindow* _tmp2_;
		_tmp2_ = window;
		result = gdk_screen_get_monitor_at_window (screen, _tmp2_);
		_g_object_unref0 (window);
		return result;
	} else {
		result = gdk_screen_get_primary_monitor (screen);
		_g_object_unref0 (window);
		return result;
	}
}

gdouble
utils_get_default_monitor_scale (void)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	gdouble result;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GdkMonitor* monitor = NULL;
		GdkDisplay* _tmp3_;
		GdkMonitor* _tmp4_;
		GdkMonitor* _tmp5_;
		GdkMonitor* _tmp6_;
		_tmp3_ = display;
		_tmp4_ = gdk_display_get_primary_monitor (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		monitor = _tmp5_;
		_tmp6_ = monitor;
		if (_tmp6_ != NULL) {
			GdkMonitor* _tmp7_;
			_tmp7_ = monitor;
			result = (gdouble) gdk_monitor_get_scale_factor (_tmp7_);
			_g_object_unref0 (monitor);
			_g_object_unref0 (display);
			return result;
		}
		_g_object_unref0 (monitor);
	}
	result = 1.0;
	_g_object_unref0 (display);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
utils_get_dde_scale_ratio (void)
{
	gchar* scaleStr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gdouble parsedScale = 0.0;
	const gchar* _tmp7_;
	gdouble _tmp8_ = 0.0;
	gdouble result;
	_tmp0_ = g_getenv ("QT_SCALE_FACTOR");
	_tmp1_ = g_strdup (_tmp0_);
	scaleStr = _tmp1_;
	_tmp2_ = scaleStr;
	if (_tmp2_ == NULL) {
		gchar* dpiStr = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = g_getenv ("QT_FONT_DPI");
		_tmp4_ = g_strdup (_tmp3_);
		dpiStr = _tmp4_;
		_tmp5_ = dpiStr;
		if (_tmp5_ == NULL) {
			result = 1.0;
			_g_free0 (dpiStr);
			_g_free0 (scaleStr);
			return result;
		}
		_tmp6_ = dpiStr;
		result = double_parse (_tmp6_) / 96;
		_g_free0 (dpiStr);
		_g_free0 (scaleStr);
		return result;
	}
	_tmp7_ = scaleStr;
	parsedScale = double_parse (_tmp7_);
	if (parsedScale == ((gdouble) 0)) {
		_tmp8_ = 1.0;
	} else {
		_tmp8_ = parsedScale;
	}
	result = _tmp8_;
	_g_free0 (scaleStr);
	return result;
}

gint
utils_get_pointer_monitor (GdkScreen* screen)
{
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (screen != NULL, 0);
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	result = gdk_screen_get_monitor_at_point (screen, x, y);
	return result;
}

gchar*
utils_get_process_cmdline (gint pid)
{
	GFile* cmd_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* command = NULL;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup_printf ("/proc/%d/cmdline", pid);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cmd_file = _tmp3_;
	_tmp4_ = g_strdup ("");
	command = _tmp4_;
	_tmp5_ = cmd_file;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		result = command;
		_g_object_unref0 (cmd_file);
		return result;
	}
	{
		GFileInputStream* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp9_;
		guint8* data = NULL;
		guint8* _tmp10_;
		gint data_length1;
		gint _data_size_;
		gssize size = 0L;
		GDataInputStream* _tmp11_;
		guint8* _tmp12_;
		gint _tmp12__length1;
		guint8* _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
		_tmp7_ = cmd_file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp6_);
		dis = _tmp9_;
		_tmp10_ = g_new0 (guint8, 4097);
		data = _tmp10_;
		data_length1 = 4097;
		_data_size_ = data_length1;
		_tmp11_ = dis;
		_tmp12_ = data;
		_tmp12__length1 = data_length1;
		size = g_input_stream_read ((GInputStream*) _tmp11_, _tmp12_, (gsize) _tmp12__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			data = (g_free (data), NULL);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		if (size <= ((gssize) 0)) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			_g_free0 (command);
			command = _tmp13_;
		}
		{
			gint pos = 0;
			pos = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_ = FALSE;
					guint8* _tmp17_;
					gint _tmp17__length1;
					guint8 _tmp18_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = pos;
						pos = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					if (!(((gssize) pos) < size)) {
						break;
					}
					_tmp17_ = data;
					_tmp17__length1 = data_length1;
					_tmp18_ = _tmp17_[pos];
					if (_tmp18_ == ((guint8) '\0')) {
						_tmp16_ = TRUE;
					} else {
						guint8* _tmp19_;
						gint _tmp19__length1;
						guint8 _tmp20_;
						_tmp19_ = data;
						_tmp19__length1 = data_length1;
						_tmp20_ = _tmp19_[pos];
						_tmp16_ = _tmp20_ == ((guint8) '\n');
					}
					if (_tmp16_) {
						guint8* _tmp21_;
						gint _tmp21__length1;
						_tmp21_ = data;
						_tmp21__length1 = data_length1;
						_tmp21_[pos] = (guint8) ' ';
					}
				}
			}
		}
		_tmp22_ = data;
		_tmp22__length1 = data_length1;
		_tmp23_ = g_strdup ((const gchar*) _tmp22_);
		_g_free0 (command);
		command = _tmp23_;
		data = (g_free (data), NULL);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("utils.vala:638: %s\n", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (command);
		_g_object_unref0 (cmd_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = command;
	_g_object_unref0 (cmd_file);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

guint8*
utils_to_raw_data (const gchar* str,
                   gint* result_length1)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = string_get_data (str, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

