// This file was generated by qtwaylandscanner
// source file is //usr/share/wayland-protocols/unstable/text-input/text-input-unstable-v1.xml

#include "qwayland-server-text-input-unstable-v1.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int zwp_text_input_v1::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_text_input_v1 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_text_input_v1_destroy_global();
        return 0;
    }

    zwp_text_input_v1::zwp_text_input_v1(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_text_input_v1::zwp_text_input_v1(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_text_input_v1::zwp_text_input_v1(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_text_input_v1::zwp_text_input_v1()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_text_input_v1::~zwp_text_input_v1()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_text_input_v1_object = nullptr;

        if (m_resource)
            m_resource->zwp_text_input_v1_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_text_input_v1::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_text_input_v1::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_text_input_v1::Resource *zwp_text_input_v1::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_text_input_v1::Resource *zwp_text_input_v1::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_text_input_v1::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_text_input_v1_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_text_input_v1::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_text_input_v1::interface()
    {
        return &::zwp_text_input_v1_interface;
    }

    zwp_text_input_v1::Resource *zwp_text_input_v1::zwp_text_input_v1_allocate()
    {
        return new Resource;
    }

    void zwp_text_input_v1::zwp_text_input_v1_destroy_global()
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_bind_resource(Resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_destroy_resource(Resource *)
    {
    }

    void zwp_text_input_v1::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_text_input_v1 *that = static_cast<zwp_text_input_v1 *>(data);
        that->add(client, id, version);
    }

    void zwp_text_input_v1::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_text_input_v1 *that = static_cast<zwp_text_input_v1::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_text_input_v1::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_text_input_v1 *that = resource->zwp_text_input_v1_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_text_input_v1_destroy_resource(resource);

            that = resource->zwp_text_input_v1_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_text_input_v1::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 10000);
    }

    zwp_text_input_v1::Resource *zwp_text_input_v1::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_text_input_v1_interface, version, id);
        return bind(handle);
    }

    zwp_text_input_v1::Resource *zwp_text_input_v1::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_text_input_v1_allocate();
        resource->zwp_text_input_v1_object = this;

        wl_resource_set_implementation(handle, &m_zwp_text_input_v1_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_text_input_v1_bind_resource(resource);
        return resource;
    }
    zwp_text_input_v1::Resource *zwp_text_input_v1::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_text_input_v1_interface, &m_zwp_text_input_v1_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_text_input_v1_interface zwp_text_input_v1::m_zwp_text_input_v1_interface = {
        zwp_text_input_v1::handle_activate,
        zwp_text_input_v1::handle_deactivate,
        zwp_text_input_v1::handle_show_input_panel,
        zwp_text_input_v1::handle_hide_input_panel,
        zwp_text_input_v1::handle_reset,
        zwp_text_input_v1::handle_set_surrounding_text,
        zwp_text_input_v1::handle_set_content_type,
        zwp_text_input_v1::handle_set_cursor_rectangle,
        zwp_text_input_v1::handle_set_preferred_language,
        zwp_text_input_v1::handle_commit_state,
        zwp_text_input_v1::handle_invoke_action
    };

    void zwp_text_input_v1::zwp_text_input_v1_activate(Resource *, struct ::wl_resource *, struct ::wl_resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_deactivate(Resource *, struct ::wl_resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_show_input_panel(Resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_hide_input_panel(Resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_reset(Resource *)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_set_surrounding_text(Resource *, const QString &, uint32_t , uint32_t )
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_set_content_type(Resource *, uint32_t , uint32_t )
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_set_cursor_rectangle(Resource *, int32_t , int32_t , int32_t , int32_t )
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_set_preferred_language(Resource *, const QString &)
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_commit_state(Resource *, uint32_t )
    {
    }

    void zwp_text_input_v1::zwp_text_input_v1_invoke_action(Resource *, uint32_t , uint32_t )
    {
    }


    void zwp_text_input_v1::handle_activate(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *seat,
        struct ::wl_resource *surface)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_activate(
            r,
            seat,
            surface);
    }

    void zwp_text_input_v1::handle_deactivate(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *seat)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_deactivate(
            r,
            seat);
    }

    void zwp_text_input_v1::handle_show_input_panel(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_show_input_panel(
            r);
    }

    void zwp_text_input_v1::handle_hide_input_panel(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_hide_input_panel(
            r);
    }

    void zwp_text_input_v1::handle_reset(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_reset(
            r);
    }

    void zwp_text_input_v1::handle_set_surrounding_text(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *text,
        uint32_t cursor,
        uint32_t anchor)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_set_surrounding_text(
            r,
            QString::fromUtf8(text),
            cursor,
            anchor);
    }

    void zwp_text_input_v1::handle_set_content_type(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t hint,
        uint32_t purpose)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_set_content_type(
            r,
            hint,
            purpose);
    }

    void zwp_text_input_v1::handle_set_cursor_rectangle(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_set_cursor_rectangle(
            r,
            x,
            y,
            width,
            height);
    }

    void zwp_text_input_v1::handle_set_preferred_language(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *language)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_set_preferred_language(
            r,
            QString::fromUtf8(language));
    }

    void zwp_text_input_v1::handle_commit_state(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_commit_state(
            r,
            serial);
    }

    void zwp_text_input_v1::handle_invoke_action(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t button,
        uint32_t index)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_v1 *>(r->zwp_text_input_v1_object)->zwp_text_input_v1_invoke_action(
            r,
            button,
            index);
    }

    void zwp_text_input_v1::send_enter(struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            surface);
    }

    void zwp_text_input_v1::send_enter(struct ::wl_resource *resource, struct ::wl_resource *surface)
    {
        zwp_text_input_v1_send_enter(
            resource,
            surface);
    }


    void zwp_text_input_v1::send_leave()
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle);
    }

    void zwp_text_input_v1::send_leave(struct ::wl_resource *resource)
    {
        zwp_text_input_v1_send_leave(
            resource);
    }


    void zwp_text_input_v1::send_modifiers_map(const QByteArray &map)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::modifiers_map", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::modifiers_map as it's not initialised");
            return;
        }
        send_modifiers_map(
            m_resource->handle,
            map);
    }

    void zwp_text_input_v1::send_modifiers_map(struct ::wl_resource *resource, const QByteArray &map)
    {
        struct wl_array map_data;
        map_data.size = map.size();
        map_data.data = static_cast<void *>(const_cast<char *>(map.constData()));
        map_data.alloc = 0;

        zwp_text_input_v1_send_modifiers_map(
            resource,
            &map_data);
    }


    void zwp_text_input_v1::send_input_panel_state(uint32_t state)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::input_panel_state", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::input_panel_state as it's not initialised");
            return;
        }
        send_input_panel_state(
            m_resource->handle,
            state);
    }

    void zwp_text_input_v1::send_input_panel_state(struct ::wl_resource *resource, uint32_t state)
    {
        zwp_text_input_v1_send_input_panel_state(
            resource,
            state);
    }


    void zwp_text_input_v1::send_preedit_string(uint32_t serial, const QString &text, const QString &commit)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::preedit_string", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::preedit_string as it's not initialised");
            return;
        }
        send_preedit_string(
            m_resource->handle,
            serial,
            text,
            commit);
    }

    void zwp_text_input_v1::send_preedit_string(struct ::wl_resource *resource, uint32_t serial, const QString &text, const QString &commit)
    {
        zwp_text_input_v1_send_preedit_string(
            resource,
            serial,
            text.toUtf8().constData(),
            commit.toUtf8().constData());
    }


    void zwp_text_input_v1::send_preedit_styling(uint32_t index, uint32_t length, uint32_t style)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::preedit_styling", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::preedit_styling as it's not initialised");
            return;
        }
        send_preedit_styling(
            m_resource->handle,
            index,
            length,
            style);
    }

    void zwp_text_input_v1::send_preedit_styling(struct ::wl_resource *resource, uint32_t index, uint32_t length, uint32_t style)
    {
        zwp_text_input_v1_send_preedit_styling(
            resource,
            index,
            length,
            style);
    }


    void zwp_text_input_v1::send_preedit_cursor(int32_t index)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::preedit_cursor", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::preedit_cursor as it's not initialised");
            return;
        }
        send_preedit_cursor(
            m_resource->handle,
            index);
    }

    void zwp_text_input_v1::send_preedit_cursor(struct ::wl_resource *resource, int32_t index)
    {
        zwp_text_input_v1_send_preedit_cursor(
            resource,
            index);
    }


    void zwp_text_input_v1::send_commit_string(uint32_t serial, const QString &text)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::commit_string", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::commit_string as it's not initialised");
            return;
        }
        send_commit_string(
            m_resource->handle,
            serial,
            text);
    }

    void zwp_text_input_v1::send_commit_string(struct ::wl_resource *resource, uint32_t serial, const QString &text)
    {
        zwp_text_input_v1_send_commit_string(
            resource,
            serial,
            text.toUtf8().constData());
    }


    void zwp_text_input_v1::send_cursor_position(int32_t index, int32_t anchor)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::cursor_position", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::cursor_position as it's not initialised");
            return;
        }
        send_cursor_position(
            m_resource->handle,
            index,
            anchor);
    }

    void zwp_text_input_v1::send_cursor_position(struct ::wl_resource *resource, int32_t index, int32_t anchor)
    {
        zwp_text_input_v1_send_cursor_position(
            resource,
            index,
            anchor);
    }


    void zwp_text_input_v1::send_delete_surrounding_text(int32_t index, uint32_t length)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::delete_surrounding_text", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::delete_surrounding_text as it's not initialised");
            return;
        }
        send_delete_surrounding_text(
            m_resource->handle,
            index,
            length);
    }

    void zwp_text_input_v1::send_delete_surrounding_text(struct ::wl_resource *resource, int32_t index, uint32_t length)
    {
        zwp_text_input_v1_send_delete_surrounding_text(
            resource,
            index,
            length);
    }


    void zwp_text_input_v1::send_keysym(uint32_t serial, uint32_t time, uint32_t sym, uint32_t state, uint32_t modifiers)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::keysym", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::keysym as it's not initialised");
            return;
        }
        send_keysym(
            m_resource->handle,
            serial,
            time,
            sym,
            state,
            modifiers);
    }

    void zwp_text_input_v1::send_keysym(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t sym, uint32_t state, uint32_t modifiers)
    {
        zwp_text_input_v1_send_keysym(
            resource,
            serial,
            time,
            sym,
            state,
            modifiers);
    }


    void zwp_text_input_v1::send_language(uint32_t serial, const QString &language)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::language", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::language as it's not initialised");
            return;
        }
        send_language(
            m_resource->handle,
            serial,
            language);
    }

    void zwp_text_input_v1::send_language(struct ::wl_resource *resource, uint32_t serial, const QString &language)
    {
        zwp_text_input_v1_send_language(
            resource,
            serial,
            language.toUtf8().constData());
    }


    void zwp_text_input_v1::send_text_direction(uint32_t serial, uint32_t direction)
    {
        Q_ASSERT_X(m_resource, "zwp_text_input_v1::text_direction", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call zwp_text_input_v1::text_direction as it's not initialised");
            return;
        }
        send_text_direction(
            m_resource->handle,
            serial,
            direction);
    }

    void zwp_text_input_v1::send_text_direction(struct ::wl_resource *resource, uint32_t serial, uint32_t direction)
    {
        zwp_text_input_v1_send_text_direction(
            resource,
            serial,
            direction);
    }



    int zwp_text_input_manager_v1::deferred_destroy_global_func(void *data) {
        auto object = static_cast<zwp_text_input_manager_v1 *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->zwp_text_input_manager_v1_destroy_global();
        return 0;
    }

    zwp_text_input_manager_v1::zwp_text_input_manager_v1(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    zwp_text_input_manager_v1::zwp_text_input_manager_v1(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    zwp_text_input_manager_v1::zwp_text_input_manager_v1(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    zwp_text_input_manager_v1::zwp_text_input_manager_v1()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    zwp_text_input_manager_v1::~zwp_text_input_manager_v1()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->zwp_text_input_manager_v1_object = nullptr;

        if (m_resource)
            m_resource->zwp_text_input_manager_v1_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void zwp_text_input_manager_v1::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void zwp_text_input_manager_v1::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void zwp_text_input_manager_v1::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::zwp_text_input_manager_v1_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = zwp_text_input_manager_v1::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *zwp_text_input_manager_v1::interface()
    {
        return &::zwp_text_input_manager_v1_interface;
    }

    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::zwp_text_input_manager_v1_allocate()
    {
        return new Resource;
    }

    void zwp_text_input_manager_v1::zwp_text_input_manager_v1_destroy_global()
    {
    }

    void zwp_text_input_manager_v1::zwp_text_input_manager_v1_bind_resource(Resource *)
    {
    }

    void zwp_text_input_manager_v1::zwp_text_input_manager_v1_destroy_resource(Resource *)
    {
    }

    void zwp_text_input_manager_v1::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        zwp_text_input_manager_v1 *that = static_cast<zwp_text_input_manager_v1 *>(data);
        that->add(client, id, version);
    }

    void zwp_text_input_manager_v1::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        zwp_text_input_manager_v1 *that = static_cast<zwp_text_input_manager_v1::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void zwp_text_input_manager_v1::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        zwp_text_input_manager_v1 *that = resource->zwp_text_input_manager_v1_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->zwp_text_input_manager_v1_destroy_resource(resource);

            that = resource->zwp_text_input_manager_v1_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void zwp_text_input_manager_v1::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 10000);
    }

    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::zwp_text_input_manager_v1_interface, version, id);
        return bind(handle);
    }

    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::bind(struct ::wl_resource *handle)
    {
        Resource *resource = zwp_text_input_manager_v1_allocate();
        resource->zwp_text_input_manager_v1_object = this;

        wl_resource_set_implementation(handle, &m_zwp_text_input_manager_v1_interface, resource, destroy_func);
        resource->handle = handle;
        zwp_text_input_manager_v1_bind_resource(resource);
        return resource;
    }
    zwp_text_input_manager_v1::Resource *zwp_text_input_manager_v1::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::zwp_text_input_manager_v1_interface, &m_zwp_text_input_manager_v1_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::zwp_text_input_manager_v1_interface zwp_text_input_manager_v1::m_zwp_text_input_manager_v1_interface = {
        zwp_text_input_manager_v1::handle_create_text_input
    };

    void zwp_text_input_manager_v1::zwp_text_input_manager_v1_create_text_input(Resource *, uint32_t)
    {
    }


    void zwp_text_input_manager_v1::handle_create_text_input(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->zwp_text_input_manager_v1_object)) {
            return;
        }
        static_cast<zwp_text_input_manager_v1 *>(r->zwp_text_input_manager_v1_object)->zwp_text_input_manager_v1_create_text_input(
            r,
            id);
    }
}

QT_WARNING_POP
QT_END_NAMESPACE
