// Code generated by smithy-go/middleware/generate.go DO NOT EDIT.
package middleware

import (
	"context"
	"fmt"
)

// FinalizeInput provides the input parameters for the FinalizeMiddleware to
// consume. FinalizeMiddleware may modify the Request value before forwarding
// the FinalizeInput along to the next next FinalizeHandler.
type FinalizeInput struct {
	Request interface{}
}

// FinalizeOutput provides the result returned by the next FinalizeHandler.
type FinalizeOutput struct {
	Result interface{}
}

// FinalizeHandler provides the interface for the next handler the
// FinalizeMiddleware will call in the middleware chain.
type FinalizeHandler interface {
	HandleFinalize(ctx context.Context, in FinalizeInput) (
		out FinalizeOutput, metadata Metadata, err error,
	)
}

// FinalizeMiddleware provides the interface for middleware specific to the
// finalize step. Delegates to the next FinalizeHandler for further
// processing.
type FinalizeMiddleware interface {
	// ID returns a unique ID for the middleware in the FinalizeStep. The step does not
	// allow duplicate IDs.
	ID() string

	// HandleFinalize invokes the middleware behavior which must delegate to the next handler
	// for the middleware chain to continue. The method must return a result or
	// error to its caller.
	HandleFinalize(ctx context.Context, in FinalizeInput, next FinalizeHandler) (
		out FinalizeOutput, metadata Metadata, err error,
	)
}

// FinalizeMiddlewareFunc returns a FinalizeMiddleware with the unique ID provided,
// and the func to be invoked.
func FinalizeMiddlewareFunc(id string, fn func(context.Context, FinalizeInput, FinalizeHandler) (FinalizeOutput, Metadata, error)) FinalizeMiddleware {
	return finalizeMiddlewareFunc{
		id: id,
		fn: fn,
	}
}

type finalizeMiddlewareFunc struct {
	// Unique ID for the middleware.
	id string

	// Middleware function to be called.
	fn func(context.Context, FinalizeInput, FinalizeHandler) (
		FinalizeOutput, Metadata, error,
	)
}

// ID returns the unique ID for the middleware.
func (s finalizeMiddlewareFunc) ID() string { return s.id }

// HandleFinalize invokes the middleware Fn.
func (s finalizeMiddlewareFunc) HandleFinalize(ctx context.Context, in FinalizeInput, next FinalizeHandler) (
	out FinalizeOutput, metadata Metadata, err error,
) {
	return s.fn(ctx, in, next)
}

var _ FinalizeMiddleware = (finalizeMiddlewareFunc{})

// FinalizeStep provides the ordered grouping of FinalizeMiddleware to be
// invoked on a handler.
type FinalizeStep struct {
	head *decoratedFinalizeHandler
	tail *decoratedFinalizeHandler
}

// NewFinalizeStep returns an FinalizeStep ready to have middleware for
// finalize added to it.
func NewFinalizeStep() *FinalizeStep {
	return &FinalizeStep{}
}

var _ Middleware = (*FinalizeStep)(nil)

// ID returns the unique ID of the step as a middleware.
func (s *FinalizeStep) ID() string {
	return "Finalize stack step"
}

// HandleMiddleware invokes the middleware by decorating the next handler
// provided. Returns the result of the middleware and handler being invoked.
//
// Implements Middleware interface.
func (s *FinalizeStep) HandleMiddleware(ctx context.Context, in interface{}, next Handler) (
	out interface{}, metadata Metadata, err error,
) {
	sIn := FinalizeInput{
		Request: in,
	}

	wh := &finalizeWrapHandler{next}
	if s.head == nil {
		res, metadata, err := wh.HandleFinalize(ctx, sIn)
		return res.Result, metadata, err
	}

	s.tail.Next = wh
	res, metadata, err := s.head.HandleFinalize(ctx, sIn)
	return res.Result, metadata, err
}

// Get retrieves the middleware identified by id. If the middleware is not present, returns false.
func (s *FinalizeStep) Get(id string) (FinalizeMiddleware, bool) {
	found, _ := s.get(id)
	if found == nil {
		return nil, false
	}

	return found.With, true
}

// Add injects the middleware to the relative position of the middleware group.
//
// Add never returns an error. It used to for duplicate phases but this
// behavior has since been removed as part of a performance optimization. The
// return value from Add can be ignored.
func (s *FinalizeStep) Add(m FinalizeMiddleware, pos RelativePosition) error {
	if s.head == nil {
		s.head = &decoratedFinalizeHandler{nil, m}
		s.tail = s.head
		return nil
	}

	if pos == Before {
		s.head = &decoratedFinalizeHandler{s.head, m}
	} else {
		tail := &decoratedFinalizeHandler{nil, m}
		s.tail.Next = tail
		s.tail = tail
	}

	return nil
}

// Insert injects the middleware relative to an existing middleware ID.
// Returns error if the original middleware does not exist, or the middleware
// being added already exists.
func (s *FinalizeStep) Insert(m FinalizeMiddleware, relativeTo string, pos RelativePosition) error {
	found, prev := s.get(relativeTo)
	if found == nil {
		return fmt.Errorf("not found: %s", m.ID())
	}

	if pos == Before {
		if prev == nil { // at the front
			s.head = &decoratedFinalizeHandler{s.head, m}
		} else { // somewhere in the middle
			prev.Next = &decoratedFinalizeHandler{found, m}
		}
	} else {
		if found.Next == nil { // at the end
			tail := &decoratedFinalizeHandler{nil, m}
			s.tail.Next = tail
			s.tail = tail
		} else { // somewhere in the middle
			found.Next = &decoratedFinalizeHandler{found.Next, m}
		}
	}

	return nil
}

// Swap removes the middleware by id, replacing it with the new middleware.
// Returns the middleware removed, or error if the middleware to be removed
// doesn't exist.
func (s *FinalizeStep) Swap(id string, m FinalizeMiddleware) (FinalizeMiddleware, error) {
	found, _ := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", m.ID())
	}

	swapped := found.With
	found.With = m
	return swapped, nil
}

// Remove removes the middleware by id. Returns error if the middleware
// doesn't exist.
func (s *FinalizeStep) Remove(id string) (FinalizeMiddleware, error) {
	found, prev := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", id)
	}

	if s.head == s.tail { // it's the only one
		s.head = nil
		s.tail = nil
	} else if found == s.head { // at the front
		s.head = s.head.Next.(*decoratedFinalizeHandler)
	} else if found == s.tail { // at the end
		prev.Next = nil
		s.tail = prev
	} else {
		prev.Next = found.Next // somewhere in the middle
	}

	return found.With, nil
}

// List returns a list of the middleware in the step.
func (s *FinalizeStep) List() []string {
	var ids []string
	for h := s.head; h != nil; {
		ids = append(ids, h.With.ID())
		if h.Next == nil {
			break
		}

		// once executed, tail.Next of the list will be set to an
		// *finalizeWrapHandler, make sure to check for that
		if hnext, ok := h.Next.(*decoratedFinalizeHandler); ok {
			h = hnext
		} else {
			break
		}
	}
	return ids
}

// Clear removes all middleware in the step.
func (s *FinalizeStep) Clear() {
	s.head = nil
	s.tail = nil
}

func (s *FinalizeStep) get(id string) (found, prev *decoratedFinalizeHandler) {
	for h := s.head; h != nil; {
		if h.With.ID() == id {
			found = h
			return
		}
		prev = h
		if h.Next == nil {
			return
		}

		// once executed, tail.Next of the list will be set to an
		// *finalizeWrapHandler
		h, _ = h.Next.(*decoratedFinalizeHandler)
	}
	return
}

type finalizeWrapHandler struct {
	Next Handler
}

var _ FinalizeHandler = (*finalizeWrapHandler)(nil)

// HandleFinalize implements FinalizeHandler, converts types and delegates to underlying
// generic handler.
func (w finalizeWrapHandler) HandleFinalize(ctx context.Context, in FinalizeInput) (
	out FinalizeOutput, metadata Metadata, err error,
) {
	res, metadata, err := w.Next.Handle(ctx, in.Request)
	return FinalizeOutput{
		Result: res,
	}, metadata, err
}

type decoratedFinalizeHandler struct {
	Next FinalizeHandler
	With FinalizeMiddleware
}

var _ FinalizeHandler = (*decoratedFinalizeHandler)(nil)

func (h decoratedFinalizeHandler) HandleFinalize(ctx context.Context, in FinalizeInput) (
	out FinalizeOutput, metadata Metadata, err error,
) {
	return h.With.HandleFinalize(ctx, in, h.Next)
}

// FinalizeHandlerFunc provides a wrapper around a function to be used as finalizeMiddleware.
type FinalizeHandlerFunc func(context.Context, FinalizeInput) (FinalizeOutput, Metadata, error)

// HandleFinalize calls the wrapped function with the provided arguments.
func (f FinalizeHandlerFunc) HandleFinalize(ctx context.Context, in FinalizeInput) (FinalizeOutput, Metadata, error) {
	return f(ctx, in)
}

var _ FinalizeHandler = FinalizeHandlerFunc(nil)
