/*********************                                                        */
/** expr.cpp
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This file automatically generated by:
 **
 **     /build/cvc4/src/cvc5-1.8/src/expr/mkexpr /build/cvc4/src/cvc5-1.8/src/expr/expr_template.cpp /build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds /build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds /build/cvc4/src/cvc5-1.8/src/theory/uf/kinds /build/cvc4/src/cvc5-1.8/src/theory/arith/kinds /build/cvc4/src/cvc5-1.8/src/theory/bv/kinds /build/cvc4/src/cvc5-1.8/src/theory/fp/kinds /build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds /build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds /build/cvc4/src/cvc5-1.8/src/theory/sep/kinds /build/cvc4/src/cvc5-1.8/src/theory/sets/kinds /build/cvc4/src/cvc5-1.8/src/theory/strings/kinds /build/cvc4/src/cvc5-1.8/src/theory/quantifiers/kinds
 **
 ** for the CVC4 project.
 **/

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */
/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT ! */

/* Edit the template file instead:                     */
/* /build/cvc4/src/cvc5-1.8/src/expr/expr_template.cpp */

/*********************                                                        */
/*! \file expr_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner, Tim King
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Public-facing expression interface, implementation.
 **
 ** Public-facing expression interface, implementation.
 **/
#include "expr/expr.h"

#include <iostream>
#include <iterator>
#include <utility>
#include <vector>

#include "base/check.h"
#include "expr/expr_manager_scope.h"
#include "expr/node.h"
#include "expr/node_algorithm.h"
#include "expr/node_manager_attributes.h"
#include "expr/variable_type_map.h"


#include "expr/uninterpreted_constant.h"
#include "util/abstract_value.h"
#include "expr/kind.h"
#include "util/bool.h"
#include "util/divisible.h"
#include "util/rational.h"
#include "util/bitvector.h"
#include "util/floatingpoint.h"
#include "expr/array_store_all.h"
#include "expr/datatype.h"
#include "expr/ascription_type.h"
#include "util/tuple.h"
#include "expr/record.h"
#include "expr/emptyset.h"
#include "util/string.h"
#include "expr/expr_sequence.h"
#include "util/regexp.h"

// This is a hack, but an important one: if there's an error, the
// compiler directs the user to the template file instead of the
// generated one.  We don't want the user to modify the generated one,
// since it'll get overwritten on a later build.
#line 37 "/build/cvc4/src/cvc5-1.8/src/expr/expr_template.cpp"

using namespace CVC4::kind;
using namespace std;

namespace CVC4 {

class ExprManager;

std::ostream& operator<<(std::ostream& out, const TypeCheckingException& e) {
  return out << e.getMessage() << ": " << e.getExpression();
}

std::ostream& operator<<(std::ostream& out, const Expr& e) {
  if(e.isNull()) {
    return out << "null";
  } else {
    ExprManagerScope ems(*e.getExprManager());
    return out << e.getNode();
  }
}

std::ostream& operator<<(std::ostream& out, const std::vector<Expr>& container)
{
  container_to_stream(out, container);
  return out;
}

std::ostream& operator<<(std::ostream& out, const std::set<Expr>& container)
{
  container_to_stream(out, container);
  return out;
}

std::ostream& operator<<(
    std::ostream& out,
    const std::unordered_set<Expr, ExprHashFunction>& container)
{
  container_to_stream(out, container);
  return out;
}

template <typename V>
std::ostream& operator<<(std::ostream& out, const std::map<Expr, V>& container)
{
  container_to_stream(out, container);
  return out;
}

template <typename V>
std::ostream& operator<<(
    std::ostream& out,
    const std::unordered_map<Expr, V, ExprHashFunction>& container)
{
  container_to_stream(out, container);
  return out;
}

TypeCheckingException::TypeCheckingException(const TypeCheckingException& t)
    : Exception(t.d_msg), d_expr(new Expr(t.getExpression()))
{
}

TypeCheckingException::TypeCheckingException(const Expr& expr,
                                             std::string message)
    : Exception(message), d_expr(new Expr(expr))
{
}

TypeCheckingException::TypeCheckingException(
    ExprManager* em, const TypeCheckingExceptionPrivate* exc)
    : Exception(exc->getMessage()),
      d_expr(new Expr(em, new Node(exc->getNode())))
{
}

TypeCheckingException::~TypeCheckingException() { delete d_expr; }

void TypeCheckingException::toStream(std::ostream& os) const
{
  os << "Error during type checking: " << d_msg << endl
     << "The ill-typed expression: " << *d_expr;
}

Expr TypeCheckingException::getExpression() const { return *d_expr; }

Expr::Expr() :
  d_node(new Node),
  d_exprManager(NULL) {
  // We do not need to wrap this in an ExprManagerScope as `new Node` is backed
  // by NodeValue::null which is a static outside of a NodeManager.
}

Expr::Expr(ExprManager* em, Node* node) :
  d_node(node),
  d_exprManager(em) {
  // We do not need to wrap this in an ExprManagerScope as this only initializes
  // pointers
}

Expr::Expr(const Expr& e) :
  d_node(NULL),
  d_exprManager(e.d_exprManager) {
  ExprManagerScope ems(*this);
  d_node = new Node(*e.d_node);
}

Expr::~Expr() {
  ExprManagerScope ems(*this);
  delete d_node;
}

ExprManager* Expr::getExprManager() const {
  return d_exprManager;
}

namespace expr {

static Node exportConstant(TNode n, NodeManager* to, ExprManagerMapCollection& vmap);

class ExportPrivate {
private:
  typedef std::unordered_map <NodeTemplate<false>, NodeTemplate<true>, TNodeHashFunction> ExportCache;
  ExprManager* d_from;
  ExprManager* d_to;
  ExprManagerMapCollection& d_vmap;
  uint32_t d_flags;
  ExportCache d_exportCache;

 public:
  ExportPrivate(ExprManager* from,
                ExprManager* to,
                ExprManagerMapCollection& vmap,
                uint32_t flags)
      : d_from(from), d_to(to), d_vmap(vmap), d_flags(flags)
  {
  }
  Node exportInternal(TNode n) {

    if(n.isNull()) return Node::null();
    if(theory::kindToTheoryId(n.getKind()) == theory::THEORY_DATATYPES) {
      throw ExportUnsupportedException
        ("export of node belonging to theory of DATATYPES kinds unsupported");
    }

    if(n.getMetaKind() == metakind::CONSTANT) {
      if(n.getKind() == kind::EMPTYSET) {
        Type type = d_from->exportType(
            n.getConst< ::CVC4::EmptySet>().getType(), d_to, d_vmap);
        return d_to->mkConst(::CVC4::EmptySet(type));
      }
      return exportConstant(n, NodeManager::fromExprManager(d_to), d_vmap);
    } else if(n.getMetaKind() == metakind::NULLARY_OPERATOR ){
      Expr from_e(d_from, new Node(n));
      Type type = d_from->exportType(from_e.getType(), d_to, d_vmap);
      return d_to->mkNullaryOperator(type, n.getKind());  // FIXME thread safety
    } else if(n.getMetaKind() == metakind::VARIABLE) {
      Expr from_e(d_from, new Node(n));
      Expr& to_e = d_vmap.d_typeMap[from_e];
      if(! to_e.isNull()) {
        Debug("export") << "+ mapped `" << from_e << "' to `" << to_e << "'" << std::endl;
        return to_e.getNode();
      } else {
        // construct new variable in other manager:
        // to_e is a ref, so this inserts from_e -> to_e
        std::string name;
        Type type = d_from->exportType(from_e.getType(), d_to, d_vmap);
        if(Node::fromExpr(from_e).getAttribute(VarNameAttr(), name)) {
          if (n.getKind() == kind::BOUND_VARIABLE)
          {
            // bound vars are only available at the Node level (not the Expr
            // level)
            TypeNode typeNode = TypeNode::fromType(type);
            NodeManager* to_nm = NodeManager::fromExprManager(d_to);
            Node nn = to_nm->mkBoundVar(name, typeNode);  // FIXME thread safety

            // Make sure that the correct `NodeManager` is in scope while
            // converting the node to an expression.
            NodeManagerScope to_nms(to_nm);
            to_e = nn.toExpr();
          } else if(n.getKind() == kind::VARIABLE) {
            bool isGlobal;
            Node::fromExpr(from_e).getAttribute(GlobalVarAttr(), isGlobal);

            // Temporarily set the node manager to nullptr; this gets around
            // a check that mkVar isn't called internally
            NodeManagerScope nullScope(nullptr);
            to_e = d_to->mkVar(name,
                               type,
                               isGlobal ? ExprManager::VAR_FLAG_GLOBAL
                                        : d_flags);  // FIXME thread safety
          } else if(n.getKind() == kind::SKOLEM) {
            // skolems are only available at the Node level (not the Expr level)
            TypeNode typeNode = TypeNode::fromType(type);
            NodeManager* to_nm = NodeManager::fromExprManager(d_to);
            Node nn =
                to_nm->mkSkolem(name,
                                typeNode,
                                "is a skolem variable imported from another "
                                "ExprManager");  // FIXME thread safety

            // Make sure that the correct `NodeManager` is in scope while
            // converting the node to an expression.
            NodeManagerScope to_nms(to_nm);
            to_e = nn.toExpr();
          } else {
            Unhandled();
          }

          Debug("export") << "+ exported var `" << from_e << "'[" << from_e.getId() << "] with name `" << name << "' and type `" << from_e.getType() << "' to `" << to_e << "'[" << to_e.getId() << "] with type `" << type << "'" << std::endl;
        } else {
          if (n.getKind() == kind::BOUND_VARIABLE)
          {
            // bound vars are only available at the Node level (not the Expr
            // level)
            TypeNode typeNode = TypeNode::fromType(type);
            NodeManager* to_nm = NodeManager::fromExprManager(d_to);
            Node nn = to_nm->mkBoundVar(typeNode);  // FIXME thread safety

            // Make sure that the correct `NodeManager` is in scope while
            // converting the node to an expression.
            NodeManagerScope to_nms(to_nm);
            to_e = nn.toExpr();
          }
          else
          {
            // Temporarily set the node manager to nullptr; this gets around
            // a check that mkVar isn't called internally
            NodeManagerScope nullScope(nullptr);
            to_e = d_to->mkVar(type);  // FIXME thread safety
          }
          Debug("export") << "+ exported unnamed var `" << from_e << "' with type `" << from_e.getType() << "' to `" << to_e << "' with type `" << type << "'" << std::endl;
        }
        uint64_t to_int = (uint64_t)(to_e.getNode().d_nv);
        uint64_t from_int = (uint64_t)(from_e.getNode().d_nv);
        d_vmap.d_from[to_int] = from_int;
        d_vmap.d_to[from_int] = to_int;
        d_vmap.d_typeMap[to_e] = from_e;  // insert other direction too

        // Make sure that the expressions are associated with the correct
        // `ExprManager`s.
        Assert(from_e.getExprManager() == d_from);
        Assert(to_e.getExprManager() == d_to);
        return Node::fromExpr(to_e);
      }
    } else {
      if (d_exportCache.find(n) != d_exportCache.end())
      {
        return d_exportCache[n];
      }

      std::vector<Node> children;
      Debug("export") << "n: " << n << std::endl;
      if(n.getMetaKind() == kind::metakind::PARAMETERIZED) {
        Debug("export") << "+ parameterized, op is " << n.getOperator() << std::endl;
        children.reserve(n.getNumChildren() + 1);
        children.push_back(exportInternal(n.getOperator()));
      } else {
        children.reserve(n.getNumChildren());
      }
      for(TNode::iterator i = n.begin(), i_end = n.end(); i != i_end; ++i) {
        Debug("export") << "+ child: " << *i << std::endl;
        children.push_back(exportInternal(*i));
      }
      if(Debug.isOn("export")) {
        Debug("export") << "children for export from " << n << std::endl;

        // `n` belongs to the `from` ExprManager, so begin ExprManagerScope
        // after printing `n`
        ExprManagerScope ems(*d_to);
        for(std::vector<Node>::iterator i = children.begin(), i_end = children.end(); i != i_end; ++i) {
          Debug("export") << "  child: " << *i << std::endl;
        }
      }

      // FIXME thread safety
      Node ret =
          NodeManager::fromExprManager(d_to)->mkNode(n.getKind(), children);

      d_exportCache[n] = ret;
      return ret;
    }
  }/* exportInternal() */

};

}/* CVC4::expr namespace */

Expr Expr::exportTo(ExprManager* exprManager, ExprManagerMapCollection& variableMap,
                    uint32_t flags /* = 0 */) const {
  Assert(d_exprManager != exprManager)
      << "No sense in cloning an Expr in the same ExprManager";
  ExprManagerScope ems(*this);
  return Expr(exprManager, new Node(expr::ExportPrivate(d_exprManager, exprManager, variableMap, flags).exportInternal(*d_node)));
}

Expr& Expr::operator=(const Expr& e) {
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  Assert(e.d_node != NULL) << "Unexpected NULL expression pointer!";

  if(this != &e) {
    if(d_exprManager == e.d_exprManager) {
      ExprManagerScope ems(*this);
      *d_node = *e.d_node;
    } else {
      // This happens more than you think---every time you set to or
      // from the null Expr.  It's tricky because each node manager
      // must be in play at the right time.

      ExprManagerScope ems1(*this);
      *d_node = Node::null();

      ExprManagerScope ems2(e);
      *d_node = *e.d_node;

      d_exprManager = e.d_exprManager;
    }
  }
  return *this;
}

bool Expr::operator==(const Expr& e) const {
  if(d_exprManager != e.d_exprManager) {
    return false;
  }
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  Assert(e.d_node != NULL) << "Unexpected NULL expression pointer!";
  return *d_node == *e.d_node;
}

bool Expr::operator!=(const Expr& e) const {
  return !(*this == e);
}

bool Expr::operator<(const Expr& e) const {
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  Assert(e.d_node != NULL) << "Unexpected NULL expression pointer!";
  if(isNull() && !e.isNull()) {
    return true;
  }
  ExprManagerScope ems(*this);
  return *d_node < *e.d_node;
}

bool Expr::operator>(const Expr& e) const {
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  Assert(e.d_node != NULL) << "Unexpected NULL expression pointer!";
  if(isNull() && !e.isNull()) {
    return true;
  }
  ExprManagerScope ems(*this);
  return *d_node > *e.d_node;
}

uint64_t Expr::getId() const
{
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->getId();
}

Kind Expr::getKind() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->getKind();
}

size_t Expr::getNumChildren() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->getNumChildren();
}

Expr Expr::operator[](unsigned i) const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  Assert(i >= 0 && i < d_node->getNumChildren()) << "Child index out of bounds";
  return Expr(d_exprManager, new Node((*d_node)[i]));
}

bool Expr::hasOperator() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->hasOperator();
}

Expr Expr::getOperator() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  PrettyCheckArgument(d_node->hasOperator(), *this,
                      "Expr::getOperator() called on an Expr with no operator");
  return Expr(d_exprManager, new Node(d_node->getOperator()));
}

bool Expr::isParameterized() const
{
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->getMetaKind() == kind::metakind::PARAMETERIZED;
}

Type Expr::getType(bool check) const
{
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  PrettyCheckArgument(!d_node->isNull(), this,
                      "Can't get type of null expression!");
  return d_exprManager->getType(*this, check);
}

Expr Expr::substitute(Expr e, Expr replacement) const {
  ExprManagerScope ems(*this);
  return Expr(d_exprManager, new Node(d_node->substitute(TNode(*e.d_node), TNode(*replacement.d_node))));
}

template <class Iterator>
class NodeIteratorAdaptor : public std::iterator<std::input_iterator_tag, Node> {
  Iterator d_iterator;
public:
  NodeIteratorAdaptor(Iterator i) : d_iterator(i) {
  }
  NodeIteratorAdaptor& operator++() { ++d_iterator; return *this; }
  NodeIteratorAdaptor operator++(int) { NodeIteratorAdaptor i(d_iterator); ++d_iterator; return i; }
  bool operator==(NodeIteratorAdaptor i) { return d_iterator == i.d_iterator; }
  bool operator!=(NodeIteratorAdaptor i) { return !(*this == i); }
  Node operator*() { return Node::fromExpr(*d_iterator); }
};/* class NodeIteratorAdaptor */

template <class Iterator>
static inline NodeIteratorAdaptor<Iterator> mkNodeIteratorAdaptor(Iterator i) {
  return NodeIteratorAdaptor<Iterator>(i);
}

Expr Expr::substitute(const std::vector<Expr> exes,
                      const std::vector<Expr>& replacements) const {
  ExprManagerScope ems(*this);
  return Expr(d_exprManager,
              new Node(d_node->substitute(mkNodeIteratorAdaptor(exes.begin()),
                                          mkNodeIteratorAdaptor(exes.end()),
                                          mkNodeIteratorAdaptor(replacements.begin()),
                                          mkNodeIteratorAdaptor(replacements.end()))));
}

template <class Iterator>
class NodePairIteratorAdaptor : public std::iterator<std::input_iterator_tag, pair<Node, Node> > {
  Iterator d_iterator;
public:
  NodePairIteratorAdaptor(Iterator i) : d_iterator(i) {
  }
  NodePairIteratorAdaptor& operator++() { ++d_iterator; return *this; }
  NodePairIteratorAdaptor operator++(int) { NodePairIteratorAdaptor i(d_iterator); ++d_iterator; return i; }
  bool operator==(NodePairIteratorAdaptor i) { return d_iterator == i.d_iterator; }
  bool operator!=(NodePairIteratorAdaptor i) { return !(*this == i); }
  pair<Node, Node> operator*() { return make_pair(Node::fromExpr((*d_iterator).first), Node::fromExpr((*d_iterator).second)); }
};/* class NodePairIteratorAdaptor */

template <class Iterator>
static inline NodePairIteratorAdaptor<Iterator> mkNodePairIteratorAdaptor(Iterator i) {
  return NodePairIteratorAdaptor<Iterator>(i);
}

Expr Expr::substitute(const std::unordered_map<Expr, Expr, ExprHashFunction> map) const {
  ExprManagerScope ems(*this);
  return Expr(d_exprManager, new Node(d_node->substitute(mkNodePairIteratorAdaptor(map.begin()), mkNodePairIteratorAdaptor(map.end()))));
}

Expr::const_iterator::const_iterator()
    : d_exprManager(nullptr), d_iterator(nullptr) {}

Expr::const_iterator::const_iterator(ExprManager* em, void* v)
    : d_exprManager(em), d_iterator(v) {}

Expr::const_iterator::const_iterator(const const_iterator& it)
    : d_exprManager(nullptr), d_iterator(nullptr) {
  if (it.d_iterator != nullptr) {
    d_exprManager = it.d_exprManager;
    ExprManagerScope ems(*d_exprManager);
    d_iterator =
        new Node::iterator(*reinterpret_cast<Node::iterator*>(it.d_iterator));
  }
}

Expr::const_iterator& Expr::const_iterator::operator=(const const_iterator& it) {
  if(d_iterator != NULL) {
    ExprManagerScope ems(*d_exprManager);
    delete reinterpret_cast<Node::iterator*>(d_iterator);
  }
  d_exprManager = it.d_exprManager;
  ExprManagerScope ems(*d_exprManager);
  d_iterator = new Node::iterator(*reinterpret_cast<Node::iterator*>(it.d_iterator));
  return *this;
}
Expr::const_iterator::~const_iterator() {
  if(d_iterator != NULL) {
    ExprManagerScope ems(*d_exprManager);
    delete reinterpret_cast<Node::iterator*>(d_iterator);
  }
}
bool Expr::const_iterator::operator==(const const_iterator& it) const {
  if(d_iterator == NULL || it.d_iterator == NULL) {
    return false;
  }
  return *reinterpret_cast<Node::iterator*>(d_iterator) ==
    *reinterpret_cast<Node::iterator*>(it.d_iterator);
}
Expr::const_iterator& Expr::const_iterator::operator++() {
  Assert(d_iterator != NULL);
  ExprManagerScope ems(*d_exprManager);
  ++*reinterpret_cast<Node::iterator*>(d_iterator);
  return *this;
}
Expr::const_iterator Expr::const_iterator::operator++(int) {
  Assert(d_iterator != NULL);
  ExprManagerScope ems(*d_exprManager);
  const_iterator it = *this;
  ++*reinterpret_cast<Node::iterator*>(d_iterator);
  return it;
}
Expr Expr::const_iterator::operator*() const {
  Assert(d_iterator != NULL);
  ExprManagerScope ems(*d_exprManager);
  return (**reinterpret_cast<Node::iterator*>(d_iterator)).toExpr();
}

Expr::const_iterator Expr::begin() const {
  ExprManagerScope ems(*d_exprManager);
  return Expr::const_iterator(d_exprManager, new Node::iterator(d_node->begin()));
}

Expr::const_iterator Expr::end() const {
  ExprManagerScope ems(*d_exprManager);
  return Expr::const_iterator(d_exprManager, new Node::iterator(d_node->end()));
}

std::string Expr::toString() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->toString();
}

bool Expr::isNull() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->isNull();
}

bool Expr::isVariable() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->getMetaKind() == kind::metakind::VARIABLE;
}

bool Expr::isConst() const {
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return d_node->isConst();
}

bool Expr::hasFreeVariable() const
{
  ExprManagerScope ems(*this);
  Assert(d_node != NULL) << "Unexpected NULL expression pointer!";
  return expr::hasFreeVar(*d_node);
}

void Expr::toStream(std::ostream& out, int depth, bool types, size_t dag,
                    OutputLanguage language) const {
  ExprManagerScope ems(*this);
  d_node->toStream(out, depth, types, dag, language);
}

Node Expr::getNode() const { return *d_node; }
TNode Expr::getTNode() const { return *d_node; }
Expr Expr::notExpr() const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  return d_exprManager->mkExpr(NOT, *this);
}

Expr Expr::andExpr(const Expr& e) const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == e.d_exprManager, e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(AND, *this, e);
}

Expr Expr::orExpr(const Expr& e) const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == e.d_exprManager, e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(OR, *this, e);
}

Expr Expr::xorExpr(const Expr& e) const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == e.d_exprManager, e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(XOR, *this, e);
}

Expr Expr::eqExpr(const Expr& e) const
{
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == e.d_exprManager, e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(EQUAL, *this, e);
}

Expr Expr::impExpr(const Expr& e) const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == e.d_exprManager, e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(IMPLIES, *this, e);
}

Expr Expr::iteExpr(const Expr& then_e,
                           const Expr& else_e) const {
  Assert(d_exprManager != NULL)
      << "Don't have an expression manager for this expression!";
  PrettyCheckArgument(d_exprManager == then_e.d_exprManager, then_e,
                      "Different expression managers!");
  PrettyCheckArgument(d_exprManager == else_e.d_exprManager, else_e,
                      "Different expression managers!");
  return d_exprManager->mkExpr(ITE, *this, then_e, else_e);
}

void Expr::printAst(std::ostream & o, int indent) const {
  ExprManagerScope ems(*this);
  getNode().printAst(o, indent);
}

void Expr::debugPrint() {
#ifndef CVC4_MUZZLE
  printAst(Warning());
  Warning().flush();
#endif /* ! CVC4_MUZZLE */
}


#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
template <> ::CVC4::UninterpretedConstant const & Expr::getConst() const {
#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::UNINTERPRETED_CONSTANT, *this, "Improper kind for getConst<::CVC4::UninterpretedConstant>()");
#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  return d_node->getConst< ::CVC4::UninterpretedConstant >();
}

#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
template <> ::CVC4::AbstractValue const & Expr::getConst() const {
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::ABSTRACT_VALUE, *this, "Improper kind for getConst<::CVC4::AbstractValue>()");
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  return d_node->getConst< ::CVC4::AbstractValue >();
}

#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
template <> ::CVC4::Kind const & Expr::getConst() const {
#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BUILTIN, *this, "Improper kind for getConst<::CVC4::Kind>()");
#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  return d_node->getConst< ::CVC4::Kind >();
}

#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
template <> ::CVC4::TypeConstant const & Expr::getConst() const {
#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::TYPE_CONSTANT, *this, "Improper kind for getConst<::CVC4::TypeConstant>()");
#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
  return d_node->getConst< ::CVC4::TypeConstant >();
}

#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
template <> bool const & Expr::getConst() const {
#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_BOOLEAN, *this, "Improper kind for getConst<bool>()");
#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
  return d_node->getConst< bool >();
}

#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
template <> ::CVC4::Divisible const & Expr::getConst() const {
#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::DIVISIBLE_OP, *this, "Improper kind for getConst<::CVC4::Divisible>()");
#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
  return d_node->getConst< ::CVC4::Divisible >();
}

#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
template <> ::CVC4::Rational const & Expr::getConst() const {
#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_RATIONAL, *this, "Improper kind for getConst<::CVC4::Rational>()");
#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
  return d_node->getConst< ::CVC4::Rational >();
}

#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorSize const & Expr::getConst() const {
#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_TYPE, *this, "Improper kind for getConst<::CVC4::BitVectorSize>()");
#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorSize >();
}

#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVector const & Expr::getConst() const {
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_BITVECTOR, *this, "Improper kind for getConst<::CVC4::BitVector>()");
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVector >();
}

#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorBitOf const & Expr::getConst() const {
#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_BITOF_OP, *this, "Improper kind for getConst<::CVC4::BitVectorBitOf>()");
#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorBitOf >();
}

#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorExtract const & Expr::getConst() const {
#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_EXTRACT_OP, *this, "Improper kind for getConst<::CVC4::BitVectorExtract>()");
#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorExtract >();
}

#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorRepeat const & Expr::getConst() const {
#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_REPEAT_OP, *this, "Improper kind for getConst<::CVC4::BitVectorRepeat>()");
#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorRepeat >();
}

#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorRotateLeft const & Expr::getConst() const {
#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_ROTATE_LEFT_OP, *this, "Improper kind for getConst<::CVC4::BitVectorRotateLeft>()");
#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorRotateLeft >();
}

#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorRotateRight const & Expr::getConst() const {
#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_ROTATE_RIGHT_OP, *this, "Improper kind for getConst<::CVC4::BitVectorRotateRight>()");
#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorRotateRight >();
}

#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorSignExtend const & Expr::getConst() const {
#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_SIGN_EXTEND_OP, *this, "Improper kind for getConst<::CVC4::BitVectorSignExtend>()");
#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorSignExtend >();
}

#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::BitVectorZeroExtend const & Expr::getConst() const {
#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::BITVECTOR_ZERO_EXTEND_OP, *this, "Improper kind for getConst<::CVC4::BitVectorZeroExtend>()");
#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::BitVectorZeroExtend >();
}

#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
template <> ::CVC4::IntToBitVector const & Expr::getConst() const {
#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::INT_TO_BITVECTOR_OP, *this, "Improper kind for getConst<::CVC4::IntToBitVector>()");
#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
  return d_node->getConst< ::CVC4::IntToBitVector >();
}

#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPoint const & Expr::getConst() const {
#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_FLOATINGPOINT, *this, "Improper kind for getConst<::CVC4::FloatingPoint>()");
#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPoint >();
}

#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::RoundingMode const & Expr::getConst() const {
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_ROUNDINGMODE, *this, "Improper kind for getConst<::CVC4::RoundingMode>()");
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::RoundingMode >();
}

#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointSize const & Expr::getConst() const {
#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TYPE, *this, "Improper kind for getConst<::CVC4::FloatingPointSize>()");
#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointSize >();
}

#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPIEEEBitVector const & Expr::getConst() const {
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPIEEEBitVector>()");
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPIEEEBitVector >();
}

#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPFloatingPoint const & Expr::getConst() const {
#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPFloatingPoint>()");
#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPFloatingPoint >();
}

#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPReal const & Expr::getConst() const {
#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_REAL_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPReal>()");
#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPReal >();
}

#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPSignedBitVector const & Expr::getConst() const {
#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPSignedBitVector>()");
#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPSignedBitVector >();
}

#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPUnsignedBitVector const & Expr::getConst() const {
#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPUnsignedBitVector>()");
#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >();
}

#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToFPGeneric const & Expr::getConst() const {
#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_GENERIC_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToFPGeneric>()");
#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToFPGeneric >();
}

#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToUBV const & Expr::getConst() const {
#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_UBV_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToUBV>()");
#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToUBV >();
}

#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToUBVTotal const & Expr::getConst() const {
#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_UBV_TOTAL_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToUBVTotal>()");
#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToUBVTotal >();
}

#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToSBV const & Expr::getConst() const {
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_SBV_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToSBV>()");
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToSBV >();
}

#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
template <> ::CVC4::FloatingPointToSBVTotal const & Expr::getConst() const {
#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_SBV_TOTAL_OP, *this, "Improper kind for getConst<::CVC4::FloatingPointToSBVTotal>()");
#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
  return d_node->getConst< ::CVC4::FloatingPointToSBVTotal >();
}

#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
template <> ::CVC4::ArrayStoreAll const & Expr::getConst() const {
#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::STORE_ALL, *this, "Improper kind for getConst<::CVC4::ArrayStoreAll>()");
#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
  return d_node->getConst< ::CVC4::ArrayStoreAll >();
}

#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
template <> ::CVC4::DatatypeIndexConstant const & Expr::getConst() const {
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::DATATYPE_TYPE, *this, "Improper kind for getConst<::CVC4::DatatypeIndexConstant>()");
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  return d_node->getConst< ::CVC4::DatatypeIndexConstant >();
}

#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
template <> ::CVC4::AscriptionType const & Expr::getConst() const {
#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::ASCRIPTION_TYPE, *this, "Improper kind for getConst<::CVC4::AscriptionType>()");
#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  return d_node->getConst< ::CVC4::AscriptionType >();
}

#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
template <> ::CVC4::TupleUpdate const & Expr::getConst() const {
#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::TUPLE_UPDATE_OP, *this, "Improper kind for getConst<::CVC4::TupleUpdate>()");
#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  return d_node->getConst< ::CVC4::TupleUpdate >();
}

#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
template <> ::CVC4::RecordUpdate const & Expr::getConst() const {
#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::RECORD_UPDATE_OP, *this, "Improper kind for getConst<::CVC4::RecordUpdate>()");
#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
  return d_node->getConst< ::CVC4::RecordUpdate >();
}

#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
template <> ::CVC4::EmptySet const & Expr::getConst() const {
#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::EMPTYSET, *this, "Improper kind for getConst<::CVC4::EmptySet>()");
#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
  return d_node->getConst< ::CVC4::EmptySet >();
}

#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
template <> ::CVC4::String const & Expr::getConst() const {
#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_STRING, *this, "Improper kind for getConst<::CVC4::String>()");
#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  return d_node->getConst< ::CVC4::String >();
}

#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
template <> ::CVC4::ExprSequence const & Expr::getConst() const {
#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::CONST_SEQUENCE, *this, "Improper kind for getConst<::CVC4::ExprSequence>()");
#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  return d_node->getConst< ::CVC4::ExprSequence >();
}

#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
template <> ::CVC4::RegExpRepeat const & Expr::getConst() const {
#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::REGEXP_REPEAT_OP, *this, "Improper kind for getConst<::CVC4::RegExpRepeat>()");
#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  return d_node->getConst< ::CVC4::RegExpRepeat >();
}

#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
template <> ::CVC4::RegExpLoop const & Expr::getConst() const {
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  PrettyCheckArgument(getKind() == ::CVC4::kind::REGEXP_LOOP_OP, *this, "Improper kind for getConst<::CVC4::RegExpLoop>()");
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
  return d_node->getConst< ::CVC4::RegExpLoop >();
}


namespace expr {

static Node exportConstant(TNode n, NodeManager* to, ExprManagerMapCollection& vmap) {
  Assert(n.isConst());
  Debug("export") << "constant: " << n << std::endl;

  if(n.getKind() == kind::STORE_ALL) {
    // Special export for ArrayStoreAll.
    //
    // Ultimately we'll need special cases also for RecordUpdate,
    // TupleUpdate, AscriptionType, and other constant-metakinded
    // expressions that embed types.  For now datatypes aren't supported
    // for export so those don't matter.
    ExprManager* toEm = to->toExprManager();
    const ArrayStoreAll& asa = n.getConst<ArrayStoreAll>();
    return to->mkConst(ArrayStoreAll(asa.getType().exportTo(toEm, vmap),
                                     asa.getExpr().exportTo(toEm, vmap)));
  }

  switch(n.getKind()) {

  case UNINTERPRETED_CONSTANT: return to->mkConst(n.getConst< ::CVC4::UninterpretedConstant >());
  case ABSTRACT_VALUE: return to->mkConst(n.getConst< ::CVC4::AbstractValue >());
  case BUILTIN: return to->mkConst(n.getConst< ::CVC4::Kind >());
  case TYPE_CONSTANT: return to->mkConst(n.getConst< ::CVC4::TypeConstant >());
  case CONST_BOOLEAN: return to->mkConst(n.getConst< bool >());
  case DIVISIBLE_OP: return to->mkConst(n.getConst< ::CVC4::Divisible >());
  case CONST_RATIONAL: return to->mkConst(n.getConst< ::CVC4::Rational >());
  case BITVECTOR_TYPE: return to->mkConst(n.getConst< ::CVC4::BitVectorSize >());
  case CONST_BITVECTOR: return to->mkConst(n.getConst< ::CVC4::BitVector >());
  case BITVECTOR_BITOF_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorBitOf >());
  case BITVECTOR_EXTRACT_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorExtract >());
  case BITVECTOR_REPEAT_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorRepeat >());
  case BITVECTOR_ROTATE_LEFT_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorRotateLeft >());
  case BITVECTOR_ROTATE_RIGHT_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorRotateRight >());
  case BITVECTOR_SIGN_EXTEND_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorSignExtend >());
  case BITVECTOR_ZERO_EXTEND_OP: return to->mkConst(n.getConst< ::CVC4::BitVectorZeroExtend >());
  case INT_TO_BITVECTOR_OP: return to->mkConst(n.getConst< ::CVC4::IntToBitVector >());
  case CONST_FLOATINGPOINT: return to->mkConst(n.getConst< ::CVC4::FloatingPoint >());
  case CONST_ROUNDINGMODE: return to->mkConst(n.getConst< ::CVC4::RoundingMode >());
  case FLOATINGPOINT_TYPE: return to->mkConst(n.getConst< ::CVC4::FloatingPointSize >());
  case FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPIEEEBitVector >());
  case FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPFloatingPoint >());
  case FLOATINGPOINT_TO_FP_REAL_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPReal >());
  case FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPSignedBitVector >());
  case FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >());
  case FLOATINGPOINT_TO_FP_GENERIC_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToFPGeneric >());
  case FLOATINGPOINT_TO_UBV_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToUBV >());
  case FLOATINGPOINT_TO_UBV_TOTAL_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToUBVTotal >());
  case FLOATINGPOINT_TO_SBV_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToSBV >());
  case FLOATINGPOINT_TO_SBV_TOTAL_OP: return to->mkConst(n.getConst< ::CVC4::FloatingPointToSBVTotal >());
  case STORE_ALL: return to->mkConst(n.getConst< ::CVC4::ArrayStoreAll >());
  case DATATYPE_TYPE: return to->mkConst(n.getConst< ::CVC4::DatatypeIndexConstant >());
  case ASCRIPTION_TYPE: return to->mkConst(n.getConst< ::CVC4::AscriptionType >());
  case TUPLE_UPDATE_OP: return to->mkConst(n.getConst< ::CVC4::TupleUpdate >());
  case RECORD_UPDATE_OP: return to->mkConst(n.getConst< ::CVC4::RecordUpdate >());
  case EMPTYSET: return to->mkConst(n.getConst< ::CVC4::EmptySet >());
  case CONST_STRING: return to->mkConst(n.getConst< ::CVC4::String >());
  case CONST_SEQUENCE: return to->mkConst(n.getConst< ::CVC4::ExprSequence >());
  case REGEXP_REPEAT_OP: return to->mkConst(n.getConst< ::CVC4::RegExpRepeat >());
  case REGEXP_LOOP_OP: return to->mkConst(n.getConst< ::CVC4::RegExpLoop >());

default: Unhandled() << n.getKind();
  }

}/* exportConstant() */

}/* CVC4::expr namespace */
}/* CVC4 namespace */
