/* SlingshotView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SlingshotView.vala, do not modify */

/*
 * Copyright 2019–2021 elementary, Inc. (https://elementary.io)
 *           2011-2012 Giulio Collura
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define APP_MENU_TYPE_POWER_STRIP (app_menu_power_strip_get_type ())
#define APP_MENU_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APP_MENU_TYPE_POWER_STRIP, AppMenuPowerStrip))
#define APP_MENU_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APP_MENU_TYPE_POWER_STRIP, AppMenuPowerStripClass))
#define APP_MENU_IS_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APP_MENU_TYPE_POWER_STRIP))
#define APP_MENU_IS_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APP_MENU_TYPE_POWER_STRIP))
#define APP_MENU_POWER_STRIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APP_MENU_TYPE_POWER_STRIP, AppMenuPowerStripClass))

typedef struct _AppMenuPowerStrip AppMenuPowerStrip;
typedef struct _AppMenuPowerStripClass AppMenuPowerStripClass;
typedef enum  {
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW = 0,
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW = 1,
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW
} SlingshotSlingshotViewModality;

#define SLINGSHOT_SLINGSHOT_VIEW_TYPE_MODALITY (slingshot_slingshot_view_modality_get_type ())
enum  {
	SLINGSHOT_SLINGSHOT_VIEW_0_PROPERTY,
	SLINGSHOT_SLINGSHOT_VIEW_NUM_PROPERTIES
};
static GParamSpec* slingshot_slingshot_view_properties[SLINGSHOT_SLINGSHOT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _SlingshotSlingshotViewSearchData SlingshotSlingshotViewSearchData;
enum  {
	SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL,
	SLINGSHOT_SLINGSHOT_VIEW_NUM_SIGNALS
};
static guint slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_NUM_SIGNALS] = {0};

struct _SlingshotSlingshotViewPrivate {
	AppMenuPowerStrip* powerstrip;
	SlingshotBackendSynapseSearch* synapse;
	GdkScreen* screen;
	GtkRevealer* view_selector_revealer;
	SlingshotSlingshotViewModality modality;
	SlingshotWidgetsGrid* grid_view;
	GtkGrid* container;
	GtkGrid* top;
	SlingshotWidgetsSearchView* search_view;
	SlingshotWidgetsCategoryView* category_view;
};

struct _Block1Data {
	int _ref_count_;
	SlingshotSlingshotView* self;
	GeeList* matches;
	gchar* text;
	gpointer _async_data_;
};

struct _SlingshotSlingshotViewSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotSlingshotView* self;
	gchar* text;
	SynapseSearchMatch* search_match;
	SynapseMatch* target;
	Block1Data* _data1_;
	gchar* stripped;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	SlingshotBackendSynapseSearch* _tmp2_;
	GeeList* _tmp3_;
	SlingshotBackendSynapseSearch* _tmp4_;
	GeeList* _tmp5_;
};

static gint SlingshotSlingshotView_private_offset;
static gpointer slingshot_slingshot_view_parent_class = NULL;
static GSettings* slingshot_slingshot_view__settings;
static GSettings* slingshot_slingshot_view__settings = NULL;
static GType slingshot_slingshot_view_type_id = 0;

GType app_menu_power_strip_register_type (GTypeModule * module);
VALA_EXTERN GType app_menu_power_strip_get_type (void) G_GNUC_CONST ;
static GType slingshot_slingshot_view_modality_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void slingshot_slingshot_view_search_entry_activated (SlingshotSlingshotView* self);
static void slingshot_slingshot_view_set_modality (SlingshotSlingshotView* self,
                                            SlingshotSlingshotViewModality new_modality);
static GSettings* slingshot_slingshot_view_get_settings (void);
static void slingshot_slingshot_view_search_data_free (gpointer _data);
static void slingshot_slingshot_view_search (SlingshotSlingshotView* self,
                                      const gchar* text,
                                      SynapseSearchMatch* search_match,
                                      SynapseMatch* target,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void slingshot_slingshot_view_search_finish (SlingshotSlingshotView* self,
                                             GAsyncResult* _res_);
static gboolean slingshot_slingshot_view_search_co (SlingshotSlingshotViewSearchData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda75_ (SlingshotSlingshotView* self);
static gboolean ____lambda75__gsource_func (gpointer self);
static void slingshot_slingshot_view_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean __lambda76_ (Block1Data* _data1_);
static gboolean ___lambda76__gsource_func (gpointer self);
static void slingshot_slingshot_view_set_settings (GSettings* value);
static GObject * slingshot_slingshot_view_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
VALA_EXTERN AppMenuPowerStrip* app_menu_power_strip_new (void);
VALA_EXTERN AppMenuPowerStrip* app_menu_power_strip_construct (GType object_type);
static gboolean _slingshot_slingshot_view___lambda77_ (SlingshotSlingshotView* self);
static gboolean __slingshot_slingshot_view___lambda77__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                           GdkEventFocus* event,
                                                                           gpointer self);
static gboolean _slingshot_slingshot_view_on_event_box_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                      GdkEventKey* event,
                                                                                      gpointer self);
static gboolean _slingshot_slingshot_view_on_search_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                        GdkEventKey* event,
                                                                                        gpointer self);
static void _slingshot_slingshot_view___lambda78_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda78__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                             gpointer self);
static void _slingshot_slingshot_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                          gpointer self);
static void _slingshot_slingshot_view___lambda79_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda79__slingshot_widgets_category_view_search_focus_request (SlingshotWidgetsCategoryView* _sender,
                                                                                                  gpointer self);
static void _slingshot_slingshot_view___lambda80_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda80__slingshot_widgets_grid_app_launched (SlingshotWidgetsGrid* _sender,
                                                                                 gpointer self);
static void _slingshot_slingshot_view___lambda81_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda81__slingshot_widgets_search_view_app_launched (SlingshotWidgetsSearchView* _sender,
                                                                                        gpointer self);
static void _slingshot_slingshot_view___lambda82_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda82__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                      GtkWidget* widget,
                                                                                      gpointer self);
static void _slingshot_slingshot_view___lambda83_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda83__slingshot_backend_app_system_changed (SlingshotBackendAppSystem* _sender,
                                                                                  gpointer self);
static void _slingshot_slingshot_view___lambda84_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda84__g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void _slingshot_slingshot_view___lambda85_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda85__g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void _slingshot_slingshot_view___lambda86_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda86__g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void _slingshot_slingshot_view___lambda87_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda87__app_menu_power_strip_invoke_action (AppMenuPowerStrip* _sender,
                                                                                gpointer self);
static void slingshot_slingshot_view_finalize (GObject * obj);
static void _vala_slingshot_slingshot_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_slingshot_slingshot_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_slingshot_view_get_instance_private (SlingshotSlingshotView* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotSlingshotView_private_offset);
}

static GType
slingshot_slingshot_view_modality_get_type_once (void)
{
	static const GEnumValue values[] = {{SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW", "normal-view"}, {SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW", "category-view"}, {SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW", "search-view"}, {0, NULL, NULL}};
	GType slingshot_slingshot_view_modality_type_id;
	slingshot_slingshot_view_modality_type_id = g_enum_register_static ("SlingshotSlingshotViewModality", values);
	return slingshot_slingshot_view_modality_type_id;
}

static GType
slingshot_slingshot_view_modality_get_type (void)
{
	static volatile gsize slingshot_slingshot_view_modality_type_id__once = 0;
	if (g_once_init_enter (&slingshot_slingshot_view_modality_type_id__once)) {
		GType slingshot_slingshot_view_modality_type_id;
		slingshot_slingshot_view_modality_type_id = slingshot_slingshot_view_modality_get_type_once ();
		g_once_init_leave (&slingshot_slingshot_view_modality_type_id__once, slingshot_slingshot_view_modality_type_id);
	}
	return slingshot_slingshot_view_modality_type_id__once;
}

void
slingshot_slingshot_view_panel_position_changed (SlingshotSlingshotView* self,
                                                 BudgiePanelPosition position)
{
	GtkGrid* _tmp16_;
	g_return_if_fail (self != NULL);
	if (position == BUDGIE_PANEL_POSITION_BOTTOM) {
		GtkGrid* _tmp0_;
		GtkGrid* _tmp1_;
		GtkGrid* _tmp2_;
		GtkGrid* _tmp3_;
		GtkGrid* _tmp4_;
		GtkGrid* _tmp5_;
		GtkGrid* _tmp6_;
		GtkStack* _tmp7_;
		_tmp0_ = self->priv->container;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 12);
		_tmp1_ = self->priv->container;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 0);
		_tmp2_ = self->priv->container;
		gtk_grid_remove_row (_tmp2_, 1);
		_tmp3_ = self->priv->container;
		gtk_grid_remove_row (_tmp3_, 0);
		_tmp4_ = self->priv->container;
		_tmp5_ = self->priv->top;
		gtk_grid_attach (_tmp4_, (GtkWidget*) _tmp5_, 0, 1, 1, 1);
		_tmp6_ = self->priv->container;
		_tmp7_ = self->stack;
		gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	} else {
		GtkGrid* _tmp8_;
		GtkGrid* _tmp9_;
		GtkGrid* _tmp10_;
		GtkGrid* _tmp11_;
		GtkGrid* _tmp12_;
		GtkGrid* _tmp13_;
		GtkGrid* _tmp14_;
		GtkStack* _tmp15_;
		_tmp8_ = self->priv->container;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 0);
		_tmp9_ = self->priv->container;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, 12);
		_tmp10_ = self->priv->container;
		gtk_grid_remove_row (_tmp10_, 1);
		_tmp11_ = self->priv->container;
		gtk_grid_remove_row (_tmp11_, 0);
		_tmp12_ = self->priv->container;
		_tmp13_ = self->priv->top;
		gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 0, 0, 1, 1);
		_tmp14_ = self->priv->container;
		_tmp15_ = self->stack;
		gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 0, 1, 1, 1);
	}
	_tmp16_ = self->priv->container;
	gtk_widget_show_all ((GtkWidget*) _tmp16_);
}

static void
slingshot_slingshot_view_search_entry_activated (SlingshotSlingshotView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		SlingshotWidgetsSearchView* _tmp0_;
		_tmp0_ = self->priv->search_view;
		slingshot_widgets_search_view_activate_selection (_tmp0_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
slingshot_slingshot_view_on_search_view_key_press (SlingshotSlingshotView* self,
                                                   GdkEventKey* event)
{
	gchar* key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = string_replace (_tmp0_, "KP_", "");
	key = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp6_;
				_tmp6_ = self->search_entry;
				g_signal_emit_by_name ((GtkWidget*) _tmp6_, "move-focus", GTK_DIR_TAB_FORWARD);
				result = GDK_EVENT_STOP;
				_g_free0 (key);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("Escape")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp7_ = self->search_entry;
				_tmp8_ = gtk_entry_get_text ((GtkEntry*) _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ > 0) {
					GtkSearchEntry* _tmp12_;
					_tmp12_ = self->search_entry;
					gtk_entry_set_text ((GtkEntry*) _tmp12_, "");
				} else {
					g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
				}
				result = GDK_EVENT_STOP;
				_g_free0 (key);
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	_g_free0 (key);
	return result;
}

gboolean
slingshot_slingshot_view_on_event_box_key_press (SlingshotSlingshotView* self,
                                                 GdkEventKey* event)
{
	gchar* key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GQuark _tmp20_ = 0U;
	static GQuark _tmp19_label0 = 0;
	static GQuark _tmp19_label1 = 0;
	static GQuark _tmp19_label2 = 0;
	static GQuark _tmp19_label3 = 0;
	static GQuark _tmp19_label4 = 0;
	static GQuark _tmp19_label5 = 0;
	static GQuark _tmp19_label6 = 0;
	static GQuark _tmp19_label7 = 0;
	static GQuark _tmp19_label8 = 0;
	static GQuark _tmp19_label9 = 0;
	static GQuark _tmp19_label10 = 0;
	static GQuark _tmp19_label11 = 0;
	static GQuark _tmp19_label12 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = string_replace (_tmp0_, "KP_", "");
	key = _tmp1_;
	if ((event->state & GDK_CONTROL_MASK) != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GQuark _tmp5_ = 0U;
		static GQuark _tmp4_label0 = 0;
		static GQuark _tmp4_label1 = 0;
		_tmp2_ = key;
		_tmp3_ = _tmp2_;
		_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
		if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("1")))) {
			switch (0) {
				default:
				{
					GraniteWidgetsModeButton* _tmp6_;
					_tmp6_ = self->view_selector;
					granite_widgets_mode_button_set_selected (_tmp6_, 0);
					result = GDK_EVENT_STOP;
					_g_free0 (key);
					return result;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("2")))) {
			switch (0) {
				default:
				{
					GraniteWidgetsModeButton* _tmp7_;
					_tmp7_ = self->view_selector;
					granite_widgets_mode_button_set_selected (_tmp7_, 1);
					result = GDK_EVENT_STOP;
					_g_free0 (key);
					return result;
				}
			}
		}
	}
	if ((event->state & GDK_MOD1_MASK) != 0) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GQuark _tmp11_ = 0U;
		static GQuark _tmp10_label0 = 0;
		static GQuark _tmp10_label1 = 0;
		static GQuark _tmp10_label2 = 0;
		static GQuark _tmp10_label3 = 0;
		static GQuark _tmp10_label4 = 0;
		static GQuark _tmp10_label5 = 0;
		static GQuark _tmp10_label6 = 0;
		static GQuark _tmp10_label7 = 0;
		static GQuark _tmp10_label8 = 0;
		static GQuark _tmp10_label9 = 0;
		static GQuark _tmp10_label10 = 0;
		_tmp8_ = key;
		_tmp9_ = _tmp8_;
		_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
		if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("F4")))) {
			switch (0) {
				default:
				{
					g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
					result = GDK_EVENT_STOP;
					_g_free0 (key);
					return result;
				}
			}
		} else if ((((((((((_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("0")))) || (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("1"))))) || (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("2"))))) || (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("3"))))) || (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("4"))))) || (_tmp11_ == ((0 != _tmp10_label6) ? _tmp10_label6 : (_tmp10_label6 = g_quark_from_static_string ("5"))))) || (_tmp11_ == ((0 != _tmp10_label7) ? _tmp10_label7 : (_tmp10_label7 = g_quark_from_static_string ("6"))))) || (_tmp11_ == ((0 != _tmp10_label8) ? _tmp10_label8 : (_tmp10_label8 = g_quark_from_static_string ("7"))))) || (_tmp11_ == ((0 != _tmp10_label9) ? _tmp10_label9 : (_tmp10_label9 = g_quark_from_static_string ("8"))))) || (_tmp11_ == ((0 != _tmp10_label10) ? _tmp10_label10 : (_tmp10_label10 = g_quark_from_static_string ("9"))))) {
			switch (0) {
				default:
				{
					GtkSearchEntry* _tmp16_;
					if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
						gint page = 0;
						const gchar* _tmp12_;
						gboolean _tmp13_ = FALSE;
						_tmp12_ = key;
						page = atoi (_tmp12_);
						if (page < 0) {
							_tmp13_ = TRUE;
						} else {
							_tmp13_ = page == 9;
						}
						if (_tmp13_) {
							SlingshotWidgetsGrid* _tmp14_;
							_tmp14_ = self->priv->grid_view;
							slingshot_widgets_grid_go_to_last (_tmp14_);
						} else {
							SlingshotWidgetsGrid* _tmp15_;
							_tmp15_ = self->priv->grid_view;
							slingshot_widgets_grid_go_to_number (_tmp15_, page);
						}
					}
					_tmp16_ = self->search_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp16_);
					result = GDK_EVENT_STOP;
					_g_free0 (key);
					return result;
				}
			}
		}
	}
	_tmp17_ = key;
	_tmp18_ = _tmp17_;
	_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
	if (((((((((_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("Down")))) || (_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("Enter"))))) || (_tmp20_ == ((0 != _tmp19_label2) ? _tmp19_label2 : (_tmp19_label2 = g_quark_from_static_string ("Home"))))) || (_tmp20_ == ((0 != _tmp19_label3) ? _tmp19_label3 : (_tmp19_label3 = g_quark_from_static_string ("KP_Enter"))))) || (_tmp20_ == ((0 != _tmp19_label4) ? _tmp19_label4 : (_tmp19_label4 = g_quark_from_static_string ("Left"))))) || (_tmp20_ == ((0 != _tmp19_label5) ? _tmp19_label5 : (_tmp19_label5 = g_quark_from_static_string ("Return"))))) || (_tmp20_ == ((0 != _tmp19_label6) ? _tmp19_label6 : (_tmp19_label6 = g_quark_from_static_string ("Right"))))) || (_tmp20_ == ((0 != _tmp19_label7) ? _tmp19_label7 : (_tmp19_label7 = g_quark_from_static_string ("Tab"))))) || (_tmp20_ == ((0 != _tmp19_label8) ? _tmp19_label8 : (_tmp19_label8 = g_quark_from_static_string ("Up"))))) {
		switch (0) {
			default:
			{
				result = GDK_EVENT_PROPAGATE;
				_g_free0 (key);
				return result;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label9) ? _tmp19_label9 : (_tmp19_label9 = g_quark_from_static_string ("Page_Up")))) {
		switch (0) {
			default:
			{
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
					SlingshotWidgetsGrid* _tmp21_;
					_tmp21_ = self->priv->grid_view;
					slingshot_widgets_grid_go_to_previous (_tmp21_);
				} else {
					if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW) {
						SlingshotWidgetsCategoryView* _tmp22_;
						_tmp22_ = self->priv->category_view;
						slingshot_widgets_category_view_page_up (_tmp22_);
					}
				}
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label10) ? _tmp19_label10 : (_tmp19_label10 = g_quark_from_static_string ("Page_Down")))) {
		switch (0) {
			default:
			{
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
					SlingshotWidgetsGrid* _tmp23_;
					_tmp23_ = self->priv->grid_view;
					slingshot_widgets_grid_go_to_next (_tmp23_);
				} else {
					if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW) {
						SlingshotWidgetsCategoryView* _tmp24_;
						_tmp24_ = self->priv->category_view;
						slingshot_widgets_category_view_page_down (_tmp24_);
					}
				}
				break;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label11) ? _tmp19_label11 : (_tmp19_label11 = g_quark_from_static_string ("BackSpace")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp25_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp25_, "has-focus", &_tmp26_, NULL);
				_tmp27_ = _tmp26_;
				if (!_tmp27_) {
					GtkSearchEntry* _tmp28_;
					GtkSearchEntry* _tmp29_;
					_tmp28_ = self->search_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp28_);
					_tmp29_ = self->search_entry;
					g_signal_emit_by_name ((GtkEntry*) _tmp29_, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 0, FALSE);
				}
				result = GDK_EVENT_PROPAGATE;
				_g_free0 (key);
				return result;
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label12) ? _tmp19_label12 : (_tmp19_label12 = g_quark_from_static_string ("End")))) {
		switch (0) {
			default:
			{
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
					SlingshotWidgetsGrid* _tmp30_;
					_tmp30_ = self->priv->grid_view;
					slingshot_widgets_grid_go_to_last (_tmp30_);
				}
				result = GDK_EVENT_PROPAGATE;
				_g_free0 (key);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gboolean _tmp31_ = FALSE;
				GtkSearchEntry* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp32_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp32_, "has-focus", &_tmp33_, NULL);
				_tmp34_ = _tmp33_;
				if (!_tmp34_) {
					_tmp31_ = event->is_modifier != ((guint) 1);
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					GtkSearchEntry* _tmp35_;
					GtkSearchEntry* _tmp36_;
					_tmp35_ = self->search_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp35_);
					_tmp36_ = self->search_entry;
					g_signal_emit_by_name ((GtkEntry*) _tmp36_, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 0, FALSE);
				}
				result = GDK_EVENT_PROPAGATE;
				_g_free0 (key);
				return result;
			}
		}
	}
	result = GDK_EVENT_STOP;
	_g_free0 (key);
	return result;
}

void
slingshot_slingshot_view_show_slingshot (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkStack* _tmp3_;
	GraniteWidgetsModeButton* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkRevealer* _tmp7_;
	AppMenuPowerStrip* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	_tmp1_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp2_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp3_ = self->stack;
	gtk_stack_set_transition_type (_tmp3_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp4_ = self->view_selector;
	_tmp5_ = granite_widgets_mode_button_get_selected (_tmp4_);
	_tmp6_ = _tmp5_;
	slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) _tmp6_);
	_tmp7_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp7_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp8_ = self->priv->powerstrip;
	_tmp9_ = slingshot_slingshot_view_get_settings ();
	_tmp10_ = _tmp9_;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, g_settings_get_boolean (_tmp10_, "enable-powerstrip"));
	_tmp11_ = self->stack;
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
}

static void
slingshot_slingshot_view_set_modality (SlingshotSlingshotView* self,
                                       SlingshotSlingshotViewModality new_modality)
{
	g_return_if_fail (self != NULL);
	self->priv->modality = new_modality;
	switch (self->priv->modality) {
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW:
		{
			GSettings* _tmp0_;
			GSettings* _tmp1_;
			GtkRevealer* _tmp4_;
			GtkStack* _tmp5_;
			GtkSearchEntry* _tmp6_;
			_tmp0_ = slingshot_slingshot_view_get_settings ();
			_tmp1_ = _tmp0_;
			if (g_settings_get_boolean (_tmp1_, "use-category")) {
				GSettings* _tmp2_;
				GSettings* _tmp3_;
				_tmp2_ = slingshot_slingshot_view_get_settings ();
				_tmp3_ = _tmp2_;
				g_settings_set_boolean (_tmp3_, "use-category", FALSE);
			}
			_tmp4_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp4_, TRUE);
			_tmp5_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp5_, "normal");
			_tmp6_ = self->search_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
			break;
		}
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW:
		{
			GSettings* _tmp7_;
			GSettings* _tmp8_;
			GtkRevealer* _tmp11_;
			GtkStack* _tmp12_;
			GtkSearchEntry* _tmp13_;
			_tmp7_ = slingshot_slingshot_view_get_settings ();
			_tmp8_ = _tmp7_;
			if (!g_settings_get_boolean (_tmp8_, "use-category")) {
				GSettings* _tmp9_;
				GSettings* _tmp10_;
				_tmp9_ = slingshot_slingshot_view_get_settings ();
				_tmp10_ = _tmp9_;
				g_settings_set_boolean (_tmp10_, "use-category", TRUE);
			}
			_tmp11_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp11_, TRUE);
			_tmp12_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp12_, "category");
			_tmp13_ = self->search_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp13_);
			break;
		}
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW:
		{
			GtkRevealer* _tmp14_;
			GtkStack* _tmp15_;
			_tmp14_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp14_, FALSE);
			_tmp15_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp15_, "search");
			break;
		}
		default:
		break;
	}
}

static void
slingshot_slingshot_view_search_data_free (gpointer _data)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search_match);
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotSlingshotViewSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_slingshot_view_search (SlingshotSlingshotView* self,
                                 const gchar* text,
                                 SynapseSearchMatch* search_match,
                                 SynapseMatch* target,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SlingshotSlingshotViewSearchData* _data_;
	SlingshotSlingshotView* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchMatch* _tmp2_;
	SynapseMatch* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data_ = g_slice_new0 (SlingshotSlingshotViewSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_slingshot_view_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (_data_->text);
	_data_->text = _tmp1_;
	_tmp2_ = _g_object_ref0 (search_match);
	_g_object_unref0 (_data_->search_match);
	_data_->search_match = _tmp2_;
	_tmp3_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp3_;
	slingshot_slingshot_view_search_co (_data_);
}

static void
slingshot_slingshot_view_search_finish (SlingshotSlingshotView* self,
                                        GAsyncResult* _res_)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SlingshotSlingshotView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->matches);
		_g_free0 (_data1_->text);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
___lambda75_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		GraniteWidgetsModeButton* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->view_selector;
		_tmp7_ = granite_widgets_mode_button_get_selected (_tmp6_);
		_tmp8_ = _tmp7_;
		slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) _tmp8_);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda75__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda75_ ((SlingshotSlingshotView*) self);
	return result;
}

static void
slingshot_slingshot_view_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_slingshot_view_search_co (_data_);
}

static gboolean
__lambda76_ (Block1Data* _data1_)
{
	SlingshotSlingshotView* self;
	SlingshotWidgetsSearchView* _tmp0_;
	GeeList* _tmp1_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = self->priv->search_view;
	_tmp1_ = _data1_->matches;
	slingshot_widgets_search_view_set_results (_tmp0_, _tmp1_, _data1_->text);
	result = FALSE;
	return result;
}

static gboolean
___lambda76__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda76_ (self);
	return result;
}

static gboolean
slingshot_slingshot_view_search_co (SlingshotSlingshotViewSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data1_->text);
	_data_->_data1_->text = _data_->text;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = string_strip (_data_->_data1_->text);
	_data_->stripped = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->stripped;
	if (g_strcmp0 (_data_->_tmp1_, "") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda75__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_free0 (_data_->stripped);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->modality != SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		slingshot_slingshot_view_set_modality (_data_->self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW);
	}
	if (_data_->search_match != NULL) {
		synapse_search_match_set_search_source (_data_->search_match, _data_->target);
		_data_->_tmp2_ = _data_->self->priv->synapse;
		_data_->_state_ = 1;
		slingshot_backend_synapse_search_search (_data_->_tmp2_, _data_->_data1_->text, (SynapseSearchProvider*) _data_->search_match, slingshot_slingshot_view_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = slingshot_backend_synapse_search_search_finish (_data_->_tmp2_, _data_->_res_);
		_g_object_unref0 (_data_->_data1_->matches);
		_data_->_data1_->matches = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = _data_->self->priv->synapse;
		_data_->_state_ = 2;
		slingshot_backend_synapse_search_search (_data_->_tmp4_, _data_->_data1_->text, NULL, slingshot_slingshot_view_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = slingshot_backend_synapse_search_search_finish (_data_->_tmp4_, _data_->_res_);
		_g_object_unref0 (_data_->_data1_->matches);
		_data_->_data1_->matches = _data_->_tmp5_;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda76__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_g_free0 (_data_->stripped);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SlingshotSlingshotView*
slingshot_slingshot_view_construct (GType object_type)
{
	SlingshotSlingshotView * self = NULL;
	self = (SlingshotSlingshotView*) g_object_new (object_type, NULL);
	return self;
}

SlingshotSlingshotView*
slingshot_slingshot_view_new (void)
{
	return slingshot_slingshot_view_construct (SLINGSHOT_TYPE_SLINGSHOT_VIEW);
}

static GSettings*
slingshot_slingshot_view_get_settings (void)
{
	GSettings* result;
	GSettings* _tmp0_;
	_tmp0_ = slingshot_slingshot_view__settings;
	result = _tmp0_;
	return result;
}

static void
slingshot_slingshot_view_set_settings (GSettings* value)
{
	GSettings* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (slingshot_slingshot_view__settings);
	slingshot_slingshot_view__settings = _tmp0_;
}

static gboolean
_slingshot_slingshot_view___lambda77_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	gboolean result;
	_tmp0_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__slingshot_slingshot_view___lambda77__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                  GdkEventFocus* event,
                                                                  gpointer self)
{
	gboolean result;
	result = _slingshot_slingshot_view___lambda77_ ((SlingshotSlingshotView*) self);
	return result;
}

static gboolean
_slingshot_slingshot_view_on_event_box_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                             GdkEventKey* event,
                                                                             gpointer self)
{
	gboolean result;
	result = slingshot_slingshot_view_on_event_box_key_press ((SlingshotSlingshotView*) self, event);
	return result;
}

static gboolean
_slingshot_slingshot_view_on_search_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                               GdkEventKey* event,
                                                                               gpointer self)
{
	gboolean result;
	result = slingshot_slingshot_view_on_search_view_key_press ((SlingshotSlingshotView*) self, event);
	return result;
}

static void
_slingshot_slingshot_view___lambda78_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	if (self->priv->modality != SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		slingshot_slingshot_view_set_modality (self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW);
	}
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_slingshot_view_search (self, _tmp2_, NULL, NULL, NULL, NULL);
}

static void
__slingshot_slingshot_view___lambda78__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                        gpointer self)
{
	_slingshot_slingshot_view___lambda78_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                     gpointer self)
{
	slingshot_slingshot_view_search_entry_activated ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda79_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	_tmp0_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
__slingshot_slingshot_view___lambda79__slingshot_widgets_category_view_search_focus_request (SlingshotWidgetsCategoryView* _sender,
                                                                                             gpointer self)
{
	_slingshot_slingshot_view___lambda79_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda80_ (SlingshotSlingshotView* self)
{
	g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
}

static void
__slingshot_slingshot_view___lambda80__slingshot_widgets_grid_app_launched (SlingshotWidgetsGrid* _sender,
                                                                            gpointer self)
{
	_slingshot_slingshot_view___lambda80_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda81_ (SlingshotSlingshotView* self)
{
	g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
}

static void
__slingshot_slingshot_view___lambda81__slingshot_widgets_search_view_app_launched (SlingshotWidgetsSearchView* _sender,
                                                                                   gpointer self)
{
	_slingshot_slingshot_view___lambda81_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda82_ (SlingshotSlingshotView* self)
{
	GraniteWidgetsModeButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->view_selector;
	_tmp1_ = granite_widgets_mode_button_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) _tmp2_);
}

static void
__slingshot_slingshot_view___lambda82__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                 GtkWidget* widget,
                                                                                 gpointer self)
{
	_slingshot_slingshot_view___lambda82_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda83_ (SlingshotSlingshotView* self)
{
	SlingshotWidgetsGrid* _tmp0_;
	SlingshotBackendAppSystem* _tmp1_;
	SlingshotWidgetsCategoryView* _tmp2_;
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->category_view;
	slingshot_widgets_category_view_setup_sidebar (_tmp2_);
}

static void
__slingshot_slingshot_view___lambda83__slingshot_backend_app_system_changed (SlingshotBackendAppSystem* _sender,
                                                                             gpointer self)
{
	_slingshot_slingshot_view___lambda83_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda84_ (SlingshotSlingshotView* self)
{
	SlingshotWidgetsGrid* _tmp0_;
	SlingshotBackendAppSystem* _tmp1_;
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp0_, _tmp1_);
}

static void
__slingshot_slingshot_view___lambda84__g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	_slingshot_slingshot_view___lambda84_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda85_ (SlingshotSlingshotView* self)
{
	SlingshotWidgetsGrid* _tmp0_;
	SlingshotBackendAppSystem* _tmp1_;
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp0_, _tmp1_);
}

static void
__slingshot_slingshot_view___lambda85__g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	_slingshot_slingshot_view___lambda85_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda86_ (SlingshotSlingshotView* self)
{
	SlingshotWidgetsGrid* _tmp0_;
	SlingshotBackendAppSystem* _tmp1_;
	SlingshotWidgetsCategoryView* _tmp2_;
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->category_view;
	slingshot_widgets_category_view_setup_sidebar (_tmp2_);
}

static void
__slingshot_slingshot_view___lambda86__g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	_slingshot_slingshot_view___lambda86_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda87_ (SlingshotSlingshotView* self)
{
	g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
}

static void
__slingshot_slingshot_view___lambda87__app_menu_power_strip_invoke_action (AppMenuPowerStrip* _sender,
                                                                           gpointer self)
{
	_slingshot_slingshot_view___lambda87_ ((SlingshotSlingshotView*) self);
}

static GObject *
slingshot_slingshot_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotSlingshotView * self;
	SlingshotBackendAppSystem* _tmp0_;
	SlingshotBackendSynapseSearch* _tmp1_;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GtkImage* grid_image = NULL;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkImage* category_image = NULL;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GraniteWidgetsModeButton* _tmp18_;
	GraniteWidgetsModeButton* _tmp19_;
	GraniteWidgetsModeButton* _tmp20_;
	GtkImage* _tmp21_;
	GraniteWidgetsModeButton* _tmp22_;
	GtkImage* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkRevealer* _tmp26_;
	GraniteWidgetsModeButton* _tmp27_;
	GtkSearchEntry* _tmp28_;
	GtkSearchEntry* _tmp29_;
	GtkSearchEntry* _tmp30_;
	GtkSearchEntry* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar* _tmp36_;
	AppMenuPowerStrip* _tmp37_;
	GtkGrid* _tmp38_;
	GtkGrid* _tmp39_;
	GtkGrid* _tmp40_;
	GtkGrid* _tmp41_;
	GtkRevealer* _tmp42_;
	GtkGrid* _tmp43_;
	GtkSearchEntry* _tmp44_;
	GtkGrid* _tmp45_;
	AppMenuPowerStrip* _tmp46_;
	SlingshotWidgetsGrid* _tmp47_;
	SlingshotWidgetsCategoryView* _tmp48_;
	SlingshotWidgetsSearchView* _tmp49_;
	GtkStack* _tmp50_ = NULL;
	GtkStack* _tmp51_;
	SlingshotWidgetsGrid* _tmp52_;
	GtkStack* _tmp53_;
	SlingshotWidgetsCategoryView* _tmp54_;
	GtkStack* _tmp55_;
	SlingshotWidgetsSearchView* _tmp56_;
	GtkGrid* _tmp57_;
	GtkGrid* _tmp58_;
	GtkGrid* _tmp59_;
	GtkGrid* _tmp60_;
	GtkGrid* _tmp61_;
	GtkGrid* _tmp62_;
	GtkStack* _tmp63_;
	SlingshotWidgetsGrid* _tmp64_;
	SlingshotBackendAppSystem* _tmp65_;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp66_;
	GtkEventBox* _tmp67_;
	GtkGrid* _tmp68_;
	GtkEventBox* _tmp69_;
	GSettings* _tmp70_;
	GSettings* _tmp71_;
	GtkEventBox* _tmp74_;
	GtkSearchEntry* _tmp75_;
	GtkSearchEntry* _tmp76_;
	GtkSearchEntry* _tmp77_;
	GtkSearchEntry* _tmp78_;
	SlingshotWidgetsCategoryView* _tmp79_;
	SlingshotWidgetsGrid* _tmp80_;
	SlingshotWidgetsSearchView* _tmp81_;
	GraniteWidgetsModeButton* _tmp82_;
	SlingshotBackendAppSystem* _tmp83_;
	GSettings* _tmp84_;
	GSettings* _tmp85_;
	GSettings* _tmp86_;
	GSettings* _tmp87_;
	GSettings* _tmp88_;
	GSettings* _tmp89_;
	AppMenuPowerStrip* _tmp90_;
	AppMenuPowerStrip* _tmp91_;
	GSettings* _tmp92_;
	GSettings* _tmp93_;
	parent_class = G_OBJECT_CLASS (slingshot_slingshot_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	_tmp0_ = slingshot_backend_app_system_new ();
	_g_object_unref0 (self->app_system);
	self->app_system = _tmp0_;
	_tmp1_ = slingshot_backend_synapse_search_new ();
	_g_object_unref0 (self->priv->synapse);
	self->priv->synapse = _tmp1_;
	_tmp2_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("view-grid-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	grid_image = _tmp4_;
	_tmp5_ = grid_image;
	_tmp6_ = g_strdup ("<Ctrl>1");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = granite_markup_accel_tooltip (_tmp8_, (gint) 1, _ ("View as Grid"));
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp5_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("view-filter-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp11_);
	category_image = _tmp11_;
	_tmp12_ = category_image;
	_tmp13_ = g_strdup ("<Ctrl>2");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = granite_markup_accel_tooltip (_tmp15_, (gint) 1, _ ("View by Category"));
	_tmp17_ = _tmp16_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp12_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = granite_widgets_mode_button_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->view_selector);
	self->view_selector = _tmp18_;
	_tmp19_ = self->view_selector;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp19_, 12);
	_tmp20_ = self->view_selector;
	_tmp21_ = grid_image;
	granite_widgets_mode_button_append (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->view_selector;
	_tmp23_ = category_image;
	granite_widgets_mode_button_append (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->view_selector_revealer);
	self->priv->view_selector_revealer = _tmp24_;
	_tmp25_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp25_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp26_ = self->priv->view_selector_revealer;
	_tmp27_ = self->view_selector;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp28_;
	_tmp29_ = self->search_entry;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp29_, _ ("Search Apps"));
	_tmp30_ = self->search_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp30_, TRUE);
	_tmp31_ = self->search_entry;
	_tmp32_ = g_strdup ("<Ctrl>BackSpace");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	_tmp35_ = granite_markup_accel_tooltip (_tmp34_, (gint) 1, _ ("Clear all"));
	_tmp36_ = _tmp35_;
	g_object_set ((GtkEntry*) _tmp31_, "secondary-icon-tooltip-markup", _tmp36_, NULL);
	_g_free0 (_tmp36_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp37_ = app_menu_power_strip_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->powerstrip);
	self->priv->powerstrip = _tmp37_;
	_tmp38_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->top);
	self->priv->top = _tmp38_;
	_tmp39_ = self->priv->top;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp39_, 12);
	_tmp40_ = self->priv->top;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp40_, 12);
	_tmp41_ = self->priv->top;
	_tmp42_ = self->priv->view_selector_revealer;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->top;
	_tmp44_ = self->search_entry;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->top;
	_tmp46_ = self->priv->powerstrip;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = slingshot_widgets_grid_new ();
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->grid_view);
	self->priv->grid_view = _tmp47_;
	_tmp48_ = slingshot_widgets_category_view_new (self);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->category_view);
	self->priv->category_view = _tmp48_;
	_tmp49_ = slingshot_widgets_search_view_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->search_view);
	self->priv->search_view = _tmp49_;
	_tmp50_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp50_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp50_;
	_tmp51_ = self->stack;
	_tmp52_ = self->priv->grid_view;
	gtk_stack_add_named (_tmp51_, (GtkWidget*) _tmp52_, "normal");
	_tmp53_ = self->stack;
	_tmp54_ = self->priv->category_view;
	gtk_stack_add_named (_tmp53_, (GtkWidget*) _tmp54_, "category");
	_tmp55_ = self->stack;
	_tmp56_ = self->priv->search_view;
	gtk_stack_add_named (_tmp55_, (GtkWidget*) _tmp56_, "search");
	_tmp57_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp57_;
	_tmp58_ = self->priv->container;
	gtk_grid_set_row_spacing (_tmp58_, 12);
	_tmp59_ = self->priv->container;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp59_, 12);
	_tmp60_ = self->priv->container;
	_tmp61_ = self->priv->top;
	gtk_grid_attach (_tmp60_, (GtkWidget*) _tmp61_, 0, 1, 1, 1);
	_tmp62_ = self->priv->container;
	_tmp63_ = self->stack;
	gtk_grid_attach (_tmp62_, (GtkWidget*) _tmp63_, 0, 0, 1, 1);
	_tmp64_ = self->priv->grid_view;
	_tmp65_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp64_, _tmp65_);
	_tmp66_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp66_);
	event_box = _tmp66_;
	_tmp67_ = event_box;
	_tmp68_ = self->priv->container;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp69_);
	_tmp70_ = slingshot_slingshot_view_get_settings ();
	_tmp71_ = _tmp70_;
	if (g_settings_get_boolean (_tmp71_, "use-category")) {
		GraniteWidgetsModeButton* _tmp72_;
		_tmp72_ = self->view_selector;
		granite_widgets_mode_button_set_selected (_tmp72_, 1);
		slingshot_slingshot_view_set_modality (self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW);
	} else {
		GraniteWidgetsModeButton* _tmp73_;
		_tmp73_ = self->view_selector;
		granite_widgets_mode_button_set_selected (_tmp73_, 0);
		slingshot_slingshot_view_set_modality (self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW);
	}
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) __slingshot_slingshot_view___lambda77__gtk_widget_focus_in_event, self, 0);
	_tmp74_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp74_, "key-press-event", (GCallback) _slingshot_slingshot_view_on_event_box_key_press_gtk_widget_key_press_event, self, 0);
	_tmp75_ = self->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "key-press-event", (GCallback) _slingshot_slingshot_view_on_search_view_key_press_gtk_widget_key_press_event, self, 0);
	_tmp76_ = self->search_entry;
	g_signal_connect_object (_tmp76_, "search-changed", (GCallback) __slingshot_slingshot_view___lambda78__gtk_search_entry_search_changed, self, 0);
	_tmp77_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp77_);
	_tmp78_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp78_, "activate", (GCallback) _slingshot_slingshot_view_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp79_ = self->priv->category_view;
	g_signal_connect_object (_tmp79_, "search-focus-request", (GCallback) __slingshot_slingshot_view___lambda79__slingshot_widgets_category_view_search_focus_request, self, 0);
	_tmp80_ = self->priv->grid_view;
	g_signal_connect_object (_tmp80_, "app-launched", (GCallback) __slingshot_slingshot_view___lambda80__slingshot_widgets_grid_app_launched, self, 0);
	_tmp81_ = self->priv->search_view;
	g_signal_connect_object (_tmp81_, "app-launched", (GCallback) __slingshot_slingshot_view___lambda81__slingshot_widgets_search_view_app_launched, self, 0);
	_tmp82_ = self->view_selector;
	g_signal_connect_object (_tmp82_, "mode-changed", (GCallback) __slingshot_slingshot_view___lambda82__granite_widgets_mode_button_mode_changed, self, 0);
	_tmp83_ = self->app_system;
	g_signal_connect_object (_tmp83_, "changed", (GCallback) __slingshot_slingshot_view___lambda83__slingshot_backend_app_system_changed, self, 0);
	_tmp84_ = slingshot_slingshot_view_get_settings ();
	_tmp85_ = _tmp84_;
	g_signal_connect_object (_tmp85_, "changed::rows", (GCallback) __slingshot_slingshot_view___lambda84__g_settings_changed, self, G_CONNECT_AFTER);
	_tmp86_ = slingshot_slingshot_view_get_settings ();
	_tmp87_ = _tmp86_;
	g_signal_connect_object (_tmp87_, "changed::columns", (GCallback) __slingshot_slingshot_view___lambda85__g_settings_changed, self, G_CONNECT_AFTER);
	_tmp88_ = slingshot_slingshot_view_get_settings ();
	_tmp89_ = _tmp88_;
	g_signal_connect_object (_tmp89_, "changed::show-terminal-apps", (GCallback) __slingshot_slingshot_view___lambda86__g_settings_changed, self, G_CONNECT_AFTER);
	_tmp90_ = self->priv->powerstrip;
	g_signal_connect_object (_tmp90_, "invoke-action", (GCallback) __slingshot_slingshot_view___lambda87__app_menu_power_strip_invoke_action, self, 0);
	_tmp91_ = self->priv->powerstrip;
	_tmp92_ = slingshot_slingshot_view_get_settings ();
	_tmp93_ = _tmp92_;
	gtk_widget_set_visible ((GtkWidget*) _tmp91_, g_settings_get_boolean (_tmp93_, "enable-powerstrip"));
	_g_object_unref0 (event_box);
	_g_object_unref0 (category_image);
	_g_object_unref0 (grid_image);
	return obj;
}

static void
slingshot_slingshot_view_class_init (SlingshotSlingshotViewClass * klass,
                                     gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	slingshot_slingshot_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotSlingshotView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_slingshot_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_slingshot_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_slingshot_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_slingshot_view_finalize;
	slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL] = g_signal_new ("close-indicator", SLINGSHOT_TYPE_SLINGSHOT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("org.ubuntubudgie.plugins.budgie-appmenu");
	_tmp1_ = _tmp0_;
	slingshot_slingshot_view_set_settings (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
slingshot_slingshot_view_instance_init (SlingshotSlingshotView * self,
                                        gpointer klass)
{
	self->priv = slingshot_slingshot_view_get_instance_private (self);
}

static void
slingshot_slingshot_view_finalize (GObject * obj)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	_g_object_unref0 (self->app_system);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->priv->powerstrip);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->view_selector);
	_g_object_unref0 (self->priv->synapse);
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->view_selector_revealer);
	_g_object_unref0 (self->priv->grid_view);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->top);
	_g_object_unref0 (self->priv->search_view);
	_g_object_unref0 (self->priv->category_view);
	G_OBJECT_CLASS (slingshot_slingshot_view_parent_class)->finalize (obj);
}

GType
slingshot_slingshot_view_get_type (void)
{
	return slingshot_slingshot_view_type_id;
}

GType
slingshot_slingshot_view_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotSlingshotViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_slingshot_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotSlingshotView), 0, (GInstanceInitFunc) slingshot_slingshot_view_instance_init, NULL };
	slingshot_slingshot_view_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "SlingshotSlingshotView", &g_define_type_info, 0);
	SlingshotSlingshotView_private_offset = sizeof (SlingshotSlingshotViewPrivate);
	return slingshot_slingshot_view_type_id;
}

static void
_vala_slingshot_slingshot_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_slingshot_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

